? 	subroutine str_substitute (dst_str, src_str, old_chr, new_chr)    C+ C Version:	V1-002  C  C Facility:	Library routines.  C F C Abstract:	Scan a character string replacing occurences of one string= C		with another and write the result to a destination string.  C  C Environment:	User mode.  C 
 C History: C " C	08-Nov-1988, DBS; Version V1-001 C 001 -	Original version. " C	29-Dec-1988, DBS; Version V1-002D C 002 -	Changed the order of the parameters to reflect the standard. C-   C++  C Functional Description: E C	This routine will perform one scan of a source character string and E C	replace all occurences of the "old_chr" with "new_chr".  The result E C	will be written to the character string dst_str.  For single chara- B C	cter substitutions, or substitutions of equal length, the sourceB C	and destination can be the same, but for substitutions where theE C	old and new strings are different sizes it is best to use different ) C	strings for the source and destination.  C  C Calling Sequence:  C : C	call str_substitute (dst_str, src_str, old_chr, new_chr) C  C Formal Argument(s): ' C	dst_str.wt.ds	The destination string. " C	src_str.rt.ds	The source string.9 C	old_chr.rt.ds	The character(s) that should be replaced. ; C	new_chr.rt.ds	The character(s) to substitute for the old.  C  C Implicit Inputs: C	None C  C Implicit Outputs:  C	None C  C Completion Codes:  C	None C  C Side Effects:  C	None C  C--     	implicit none   ! C Type declarations for variables    	character	dst_str*(*) 	character	src_str*(*) 	character	old_chr*(*) 	character	new_chr*(*)   	integer*2	dst_inc 	integer*2	dst_loop  	integer*2	new_len 	integer*2	old_len 	integer*2	src_inc 	integer*2	src_len 	integer*2	src_loop    C+
 C Mainline C-   	src_len	 = len(src_str) 	old_len	 = len(old_chr) 	new_len	 = len(new_chr)
 	src_loop = 1 
 	dst_loop = 1   ! 	do while (src_loop .le. src_len) = 		if (src_str(src_loop:src_loop+old_len-1) .eq. old_chr) then 1 			dst_str(dst_loop:dst_loop+new_len-1) = new_chr  			src_inc	= old_len 			dst_inc	= new_len 		else9 		dst_str(dst_loop:dst_loop) = src_str(src_loop:src_loop) 
 		src_inc	= 1 
 		dst_inc = 1  		end if 		src_loop = src_loop + src_inc  		dst_loop = dst_loop + dst_inc  	end do    	return  	end