/*
 * $Header: Bitmaps.h,v 1.4 92/09/23 11:01:06 kirke Locked $
 *
 * xblackjack -- Card bitmaps (from Spider)
 *
 * (c) Copyright 1992, Kirk Erickson and Silicon Graphics Inc.
 * (c) Copyright 1989, Donald R. Woods and Sun Microsystems, Inc.
 * (c) Copyright 1990, David Lemke and Network Computing Devices Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Kirk Erickson and
 * Silicon Graphics Inc. not be used in advertising or publicity pertaining
 * to distribution of the software without specific, written prior
 * permission.  Kirk Erickson and Silicon Graphics Inc. make no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * THE ABOVE-NAMED DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE ABOVE-NAMED BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Log:	Bitmaps.h,v $
 * Revision 1.4  92/09/23  11:01:06  kirke
 * Removed extraneous static variables spider_bits and card_bits
 * (to fix lint warnings).
 * 
 * Revision 1.3  92/08/09  18:32:31  kirke
 * Replaced copyright notice (to include Silicon Graphics, Inc).
 * 
 * Revision 1.2  92/05/16  10:48:42  kirk
 * New copyright notice.
 * 
 * Revision 1.1  92/02/17  20:54:24  kirk
 * Inserted copyright notice.
 * 
 * Revision 1.0  92/01/30  22:01:15  kirk
 * Initial revision
 * 
 */

/* substitue gray1 for Green on mono */
#define gray1_width 16
#define gray1_height 16
static char gray1_bits[] = {
   0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
   0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
   0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa};

/* logo for card backs */
/* any size logo can be handled.  */

#define logo_width 64
#define logo_height 64
static char logo_bits[] = {
 0x77,0xd5,0xd7,0xdd,0x77,0xd5,0xd7,0xdd,0xbb,0xea,0xae,0xbb,0xbb,0xea,0xae,
 0xbb,0x5d,0x75,0x5d,0x77,0x5d,0x75,0x5d,0x77,0xee,0xba,0xba,0xee,0xae,0xba,
 0xba,0xee,0x77,0x5d,0x75,0xdd,0x77,0x5d,0x75,0xdd,0xbb,0xae,0xea,0xba,0xbb,
 0xae,0xea,0xba,0x5d,0x57,0xd5,0x75,0x5d,0x57,0xd5,0x75,0xae,0xab,0xaa,0xeb,
 0xae,0xab,0xaa,0xeb,0xd7,0x55,0x55,0xd7,0xd7,0x51,0x55,0xd7,0xeb,0xae,0xaa,
 0xae,0xeb,0xa2,0xaa,0xae,0x75,0x5d,0x55,0x5d,0x75,0x44,0x15,0x5d,0xba,0xbb,
 0xea,0xba,0xba,0x88,0x8a,0xba,0x5d,0x77,0x75,0x75,0x1d,0x11,0x45,0x75,0xee,
 0xee,0xba,0xea,0x2e,0x22,0xa2,0xea,0xd7,0xdd,0x5d,0xd5,0x57,0x44,0x10,0xd5,
 0xab,0xbb,0xef,0xaa,0xab,0x88,0x88,0xaa,0x57,0x77,0x77,0xd5,0x57,0x11,0x45,
 0xd5,0xae,0xee,0xba,0xea,0xae,0x22,0xa2,0xea,0x5d,0xdd,0x5d,0x75,0x5d,0x45,
 0x10,0x75,0xba,0xba,0xef,0xba,0xba,0x8a,0x88,0xba,0x75,0x75,0x77,0x5d,0x75,
 0x15,0x45,0x5d,0xea,0xea,0xba,0xae,0xea,0x2a,0xa2,0xae,0xdd,0xd5,0x5d,0x77,
 0xdd,0x55,0x50,0x77,0xae,0xab,0xaf,0xeb,0xae,0xab,0xa8,0xeb,0xd7,0x55,0x57,
 0xd7,0xd7,0x55,0x55,0xd7,0xeb,0xaa,0xaa,0xae,0xeb,0xaa,0xaa,0xae,0x75,0x57,
 0x55,0x5d,0x75,0x57,0x55,0x5d,0xba,0xae,0xea,0xba,0xba,0xae,0xaa,0xba,0xdd,
 0x5d,0x75,0x75,0xdd,0x5d,0x75,0x75,0xae,0xbb,0xba,0xea,0xae,0xbb,0xba,0xea,
 0x77,0x77,0x5d,0xd5,0x77,0x77,0x5d,0xd5,0xeb,0xee,0xee,0xaa,0xeb,0xee,0xae,
 0xaa,0xd7,0xdd,0x77,0xd5,0xd7,0xdd,0x77,0xd5,0xae,0xbb,0xbb,0xea,0xae,0xbb,
 0xbb,0xea,0x5d,0x77,0x5d,0x75,0x5d,0x77,0x5d,0x75,0xba,0xee,0xee,0xba,0xba,
 0xee,0xae,0xba,0x75,0xdd,0x77,0x5d,0x75,0xdd,0x77,0x5d,0xea,0xba,0xbb,0xae,
 0xea,0xba,0xbb,0xae,0xd5,0x75,0x5d,0x57,0xd5,0x75,0x5d,0x57,0xaa,0xeb,0xae,
 0xab,0xaa,0xeb,0xae,0xab,0x55,0xd7,0xd7,0x55,0x55,0xd7,0xd7,0x55,0xaa,0xae,
 0xeb,0xae,0xaa,0xae,0xeb,0xae,0x55,0x5d,0x75,0x5d,0x55,0x5d,0x75,0x5d,0xea,
 0xba,0xba,0xbb,0xea,0xba,0xba,0xbb,0x75,0x75,0x5d,0x77,0x75,0x75,0x5d,0x77,
 0xba,0xea,0xee,0xee,0xba,0xea,0xee,0xee,0x5d,0xd5,0xd7,0xdd,0x5d,0xd5,0xd7,
 0xdd,0xef,0xaa,0xab,0xbb,0xef,0xaa,0xab,0xbb,0x77,0xd5,0x57,0x77,0x77,0xd5,
 0x57,0x77,0xba,0xea,0xae,0xee,0xba,0xea,0xae,0xee,0x5d,0x75,0x5d,0xdd,0x5d,
 0x75,0x5d,0xdd,0xef,0xba,0xba,0xba,0xef,0xba,0xba,0xba,0x77,0x5d,0x75,0x75,
 0x77,0x5d,0x75,0x75,0xba,0xae,0xea,0xea,0xba,0xae,0xea,0xea,0x5d,0x77,0xdd,
 0xd5,0x5d,0x77,0xdd,0xd5,0xaf,0xeb,0xae,0xab,0xaf,0xeb,0xae,0xab,0x57,0xd7,
 0xd7,0x55,0x57,0xd7,0xd7,0x55,0xaa,0xae,0xeb,0xaa,0xaa,0xae,0xeb,0xaa,0x55,
 0x5d,0x75,0x57,0x55,0x5d,0x75,0x57,0xaa,0xba,0xba,0xae,0xaa,0xba,0xba,0xae,
 0x75,0x75,0xdd,0x5d,0x55,0x75,0xdd,0x5d,0xba,0xea,0xae,0xbb,0xba,0xea,0xae,
 0xbb,0x5d,0xd5,0x77,0x77,0x5d,0xd5,0x77,0x77,0xae,0xaa,0xeb,0xee,0xae,0xaa,
 0xeb,0xee};

#define king_c_width 47
#define king_c_height 92
#define king_c_x_hot -1
#define king_c_y_hot -1
static char king_c_bits[] = {
   0x00, 0xb0, 0x20, 0x08, 0x82, 0x06, 0x80, 0xe3, 0x20, 0x08, 0x82, 0x03,
   0xc0, 0xc7, 0xdb, 0xb6, 0xed, 0x01, 0xe0, 0x8f, 0x21, 0x08, 0xc2, 0x00,
   0xe0, 0x0f, 0xff, 0xff, 0x7f, 0x00, 0xe0, 0x0f, 0x56, 0x55, 0x35, 0x00,
   0xc0, 0x07, 0xac, 0xaa, 0x1a, 0x00, 0xb8, 0x3b, 0xfc, 0xff, 0x0f, 0x00,
   0xfc, 0x7f, 0xfc, 0xff, 0x0f, 0x00, 0xfe, 0xff, 0x04, 0xa0, 0x0a, 0x08,
   0xfe, 0xff, 0x3c, 0xae, 0x0a, 0x1c, 0xfe, 0xff, 0x74, 0xa6, 0x0a, 0x3e,
   0xfc, 0x7f, 0x7c, 0xbe, 0x0a, 0x3a, 0x38, 0x39, 0x24, 0xa0, 0x0a, 0x2a,
   0x00, 0x01, 0x24, 0xa0, 0x0a, 0x3a, 0x80, 0x03, 0xe4, 0xa1, 0x0a, 0x2a,
   0x80, 0x03, 0x44, 0xa0, 0x0a, 0x3a, 0xc0, 0x07, 0xb4, 0xa1, 0x3a, 0x2a,
   0x00, 0x00, 0x47, 0xa0, 0x2e, 0x3a, 0x00, 0x80, 0xe4, 0xb8, 0x2b, 0x2a,
   0x00, 0x80, 0x06, 0xa7, 0x3a, 0x3a, 0x00, 0xe0, 0xe0, 0xac, 0x1e, 0x2a,
   0x00, 0xf8, 0xf1, 0x21, 0x32, 0x3a, 0x00, 0xfe, 0x9f, 0xff, 0x6b, 0x2a,
   0x80, 0xff, 0x3f, 0x22, 0xe2, 0x3a, 0xe0, 0xff, 0xbf, 0x88, 0xf8, 0x2b,
   0xf8, 0xdf, 0x7f, 0x22, 0xbe, 0x3b, 0xfe, 0xbf, 0xfe, 0x88, 0xcf, 0x2b,
   0xff, 0xf7, 0xf5, 0xe3, 0x63, 0x3a, 0x7f, 0x36, 0xeb, 0xff, 0x31, 0x2b,
   0x3e, 0x36, 0xf6, 0x3e, 0x78, 0x3a, 0xbe, 0xf7, 0xea, 0x00, 0x1c, 0x6b,
   0xde, 0xe3, 0xd5, 0x38, 0xce, 0x7b, 0xfe, 0x9c, 0xef, 0x38, 0x9e, 0x6b,
   0x7e, 0x7f, 0xd7, 0xd6, 0xc6, 0x7b, 0xbe, 0xeb, 0xae, 0xee, 0xf3, 0x6b,
   0xde, 0xdd, 0xd5, 0xd6, 0xe3, 0x7b, 0xff, 0xaa, 0xab, 0x10, 0xf7, 0x6b,
   0x7b, 0x77, 0xd7, 0x38, 0xf3, 0x7b, 0x7d, 0x2a, 0xeb, 0x87, 0xf9, 0x6b,
   0xfc, 0xc9, 0x9d, 0x8c, 0xf9, 0x7b, 0xf8, 0xff, 0x86, 0x90, 0xfb, 0x0f,
   0xfc, 0x67, 0xb6, 0xb6, 0xf9, 0x78, 0xfe, 0xd7, 0x32, 0xa6, 0xfd, 0x0e,
   0xcf, 0xcf, 0x82, 0xa0, 0xf9, 0x7e, 0xd8, 0xef, 0xde, 0xbd, 0xfb, 0x0d,
   0xb0, 0xdf, 0xbd, 0x7b, 0xf7, 0x1b, 0x7e, 0x9f, 0x05, 0x41, 0xf3, 0xf3,
   0x70, 0xbf, 0x65, 0x4c, 0xeb, 0x7f, 0x1e, 0x9f, 0x6d, 0x6d, 0xe6, 0x3f,
   0xf0, 0xdf, 0x09, 0x61, 0xff, 0x1f, 0xde, 0x9f, 0x31, 0xb9, 0x93, 0x3f,
   0xd6, 0x9f, 0xe1, 0xd7, 0x54, 0xbe, 0xde, 0xcf, 0x1c, 0xeb, 0xee, 0xde,
   0xd6, 0xef, 0x08, 0xd5, 0x55, 0xff, 0xde, 0xc7, 0x6b, 0xab, 0xbb, 0x7b,
   0xd6, 0xcf, 0x77, 0x75, 0xd7, 0x7d, 0xde, 0x63, 0x6b, 0xeb, 0xfe, 0x7e,
   0xd6, 0x79, 0x1c, 0xf7, 0x39, 0x7f, 0xde, 0x73, 0x1c, 0xab, 0xc7, 0x7b,
   0xd6, 0x38, 0x00, 0x57, 0xef, 0x7d, 0x5c, 0x1e, 0x7c, 0x6f, 0x6c, 0x7c,
   0xd4, 0x8c, 0xff, 0xd7, 0x6c, 0xfe, 0x5c, 0xc6, 0xc7, 0xaf, 0xef, 0xff,
   0xd4, 0xf3, 0x11, 0x7f, 0xfd, 0x7f, 0xdc, 0x7d, 0x44, 0xfe, 0xfb, 0x1f,
   0xd4, 0x1f, 0x11, 0xfd, 0xff, 0x07, 0x5c, 0x47, 0x44, 0xfc, 0xff, 0x01,
   0x54, 0xd6, 0xff, 0xf9, 0x7f, 0x00, 0x5c, 0x4c, 0x84, 0x8f, 0x1f, 0x00,
   0x54, 0x78, 0x35, 0x07, 0x07, 0x00, 0x5c, 0x5c, 0xe5, 0x60, 0x01, 0x00,
   0x54, 0xd4, 0x1d, 0x27, 0x01, 0x00, 0x5c, 0x74, 0x05, 0xe2, 0x00, 0x00,
   0x54, 0x5c, 0x85, 0x2d, 0xe0, 0x03, 0x5c, 0x50, 0x05, 0x22, 0xc0, 0x01,
   0x54, 0x50, 0x85, 0x27, 0xc0, 0x01, 0x5c, 0x50, 0x05, 0x24, 0x80, 0x00,
   0x54, 0x50, 0x05, 0x24, 0x9c, 0x1c, 0x5c, 0x50, 0x7d, 0x3e, 0xfe, 0x3f,
   0x7c, 0x50, 0x65, 0x2e, 0xff, 0x7f, 0x38, 0x50, 0x75, 0x3c, 0xff, 0x7f,
   0x10, 0x50, 0x05, 0x20, 0xff, 0x7f, 0x00, 0xf0, 0xff, 0x3f, 0xfe, 0x3f,
   0x00, 0xf0, 0xff, 0x3f, 0xdc, 0x1d, 0x00, 0x58, 0x55, 0x35, 0xe0, 0x03,
   0x00, 0xac, 0xaa, 0x6a, 0xf0, 0x07, 0x00, 0xfe, 0xff, 0xff, 0xf0, 0x07,
   0x00, 0x43, 0x10, 0x84, 0xf1, 0x07, 0x80, 0xb7, 0x6d, 0xdb, 0xe3, 0x03,
   0xc0, 0x41, 0x10, 0x04, 0xc7, 0x01, 0x60, 0x41, 0x10, 0x04, 0x0d, 0x00};

#define king_d_width 47
#define king_d_height 92
#define king_d_x_hot -1
#define king_d_y_hot -1
static char king_d_bits[] = {
   0x00, 0x2c, 0x22, 0x22, 0xa2, 0x01, 0x80, 0x58, 0x55, 0x55, 0xd5, 0x00,
   0x80, 0x30, 0x22, 0x22, 0xe2, 0x08, 0xc0, 0xe1, 0x88, 0x88, 0x48, 0x04,
   0xc0, 0xc1, 0x55, 0x55, 0x75, 0x06, 0xe0, 0x83, 0x89, 0x88, 0x28, 0x45,
   0xf0, 0x07, 0xff, 0x1f, 0x32, 0x65, 0xf0, 0x07, 0xfe, 0xff, 0x95, 0x24,
   0xf8, 0x0f, 0x02, 0xfc, 0x93, 0x6a, 0xfc, 0x1f, 0xf2, 0xf0, 0x5f, 0x76,
   0xfe, 0x3f, 0x0a, 0xd1, 0xdf, 0x1d, 0xfc, 0x1f, 0x7a, 0x50, 0xdf, 0x1d,
   0xf8, 0x0f, 0xb2, 0x50, 0x55, 0x76, 0xf0, 0x07, 0x79, 0x50, 0xb5, 0x6a,
   0xf0, 0x07, 0x01, 0xa0, 0xaa, 0x24, 0xe0, 0x83, 0x22, 0xa0, 0x2a, 0x65,
   0xc0, 0x81, 0x4d, 0x40, 0x55, 0x65, 0xc0, 0x01, 0x31, 0x5c, 0x55, 0x26,
   0x80, 0x00, 0x02, 0x66, 0x55, 0x64, 0x80, 0x00, 0x0e, 0x5b, 0x55, 0x68,
   0x0c, 0x00, 0x06, 0x55, 0xd5, 0x20, 0xd6, 0x40, 0x41, 0xa5, 0xaa, 0x60,
   0xaa, 0xa0, 0xaa, 0xfa, 0xff, 0x7f, 0x56, 0x5d, 0x55, 0x3f, 0xc6, 0x48,
   0x6a, 0xbf, 0xaa, 0x6a, 0xad, 0x65, 0xd4, 0x7a, 0xff, 0xc7, 0x18, 0x73,
   0xb8, 0x34, 0xfe, 0xff, 0xff, 0x7f, 0x9c, 0x25, 0xde, 0x03, 0x00, 0x7f,
   0xb2, 0x4d, 0xac, 0xff, 0xff, 0x41, 0x33, 0xcf, 0xdc, 0x31, 0xc6, 0x5b,
   0xe6, 0xd8, 0xfd, 0x5b, 0xeb, 0x57, 0x36, 0xde, 0x7d, 0x8d, 0xb9, 0x4e,
   0x8c, 0x97, 0x9d, 0xfd, 0x75, 0x5f, 0xe4, 0x2d, 0xb9, 0xac, 0xaa, 0x7a,
   0xf2, 0x28, 0xd8, 0x56, 0xcb, 0x7d, 0x59, 0x2d, 0x99, 0xeb, 0xcf, 0x6a,
   0x2c, 0x2e, 0x7b, 0x35, 0xa7, 0x77, 0x56, 0xad, 0xaf, 0x2a, 0x25, 0x2b,
   0x8b, 0x5e, 0x5b, 0x35, 0x74, 0x5e, 0x55, 0x5f, 0xaa, 0xaa, 0xaa, 0x2a,
   0x22, 0x5f, 0xf8, 0xdf, 0xaa, 0x74, 0xd5, 0x5b, 0xaa, 0xfa, 0xcb, 0x29,
   0xe8, 0x59, 0xfb, 0xdf, 0x9a, 0x52, 0x95, 0xdb, 0x6f, 0x53, 0x9a, 0x32,
   0x2a, 0x5f, 0x9b, 0x1c, 0x3d, 0x67, 0x27, 0x5e, 0xfd, 0x5f, 0x3d, 0x72,
   0x4e, 0xbc, 0xfa, 0xbf, 0x7a, 0xe4, 0xe6, 0xbc, 0x38, 0xd9, 0xfa, 0x54,
   0x4c, 0x59, 0xca, 0xf6, 0xdb, 0xa9, 0x4a, 0x59, 0xfb, 0xdf, 0x9a, 0x17,
   0x94, 0xd3, 0x5f, 0x55, 0xda, 0xab, 0x2e, 0x55, 0xfb, 0x1f, 0xfa, 0x44,
   0x54, 0x55, 0x55, 0x55, 0xfa, 0xaa, 0x7a, 0x2e, 0xac, 0xda, 0x7a, 0xd1,
   0xd4, 0xa4, 0x54, 0xf5, 0xb5, 0x6a, 0xee, 0xe5, 0xac, 0xde, 0x74, 0x34,
   0x56, 0xf3, 0xd7, 0x99, 0xb4, 0x9a, 0xbe, 0xd3, 0x6a, 0x1b, 0x14, 0x4f,
   0x5e, 0x55, 0x35, 0x9d, 0xb4, 0x27, 0xfa, 0xae, 0xbf, 0xb9, 0xe9, 0x31,
   0x72, 0x9d, 0xb1, 0xbe, 0x7b, 0x6c, 0xea, 0xd7, 0xda, 0xbf, 0x1b, 0x67,
   0xda, 0x63, 0x8c, 0x3b, 0xf3, 0xcc, 0x82, 0xff, 0xff, 0x35, 0xb2, 0x4d,
   0xfe, 0x00, 0xc0, 0x7b, 0xa4, 0x39, 0xfe, 0xff, 0xff, 0x7f, 0x2c, 0x1d,
   0xce, 0x18, 0xe3, 0xff, 0x5e, 0x2b, 0xa6, 0xb5, 0x56, 0x55, 0xfd, 0x56,
   0x12, 0x63, 0xfc, 0xaa, 0xba, 0x6a, 0xfe, 0xff, 0x5f, 0x55, 0x05, 0x55,
   0x06, 0x55, 0xa5, 0x82, 0x02, 0x6b, 0x04, 0xab, 0xaa, 0x60, 0x00, 0x30,
   0x16, 0xaa, 0xda, 0x70, 0x00, 0x01, 0x26, 0xaa, 0x66, 0x40, 0x00, 0x01,
   0x64, 0xaa, 0x3a, 0x8c, 0x80, 0x03, 0xa6, 0xaa, 0x02, 0xb2, 0x81, 0x03,
   0xa6, 0x54, 0x05, 0x44, 0xc1, 0x07, 0x24, 0x55, 0x05, 0x80, 0xe0, 0x0f,
   0x56, 0xad, 0x0a, 0x9e, 0xe0, 0x0f, 0x6e, 0xaa, 0x0a, 0x4d, 0xf0, 0x1f,
   0xb8, 0xfb, 0x0a, 0x5e, 0xf8, 0x3f, 0xb8, 0xfb, 0x8b, 0x50, 0xfc, 0x7f,
   0x6e, 0xfa, 0x0f, 0x4f, 0xf8, 0x3f, 0x56, 0xc9, 0x3f, 0x40, 0xf0, 0x1f,
   0x24, 0xa9, 0xff, 0x7f, 0xe0, 0x0f, 0xa6, 0x4c, 0xf8, 0xff, 0xe0, 0x0f,
   0xa2, 0x14, 0x11, 0x91, 0xc1, 0x07, 0x60, 0xae, 0xaa, 0xaa, 0x83, 0x03,
   0x20, 0x12, 0x11, 0x11, 0x87, 0x03, 0x10, 0x47, 0x44, 0x44, 0x0c, 0x01,
   0x00, 0xab, 0xaa, 0xaa, 0x1a, 0x01, 0x80, 0x45, 0x44, 0x44, 0x34, 0x00};

#define king_h_width 47
#define king_h_height 92
#define king_h_x_hot -1
#define king_h_y_hot -1
static char king_h_bits[] = {
   0x00, 0x08, 0x00, 0x00, 0x80, 0x00, 0x00, 0xb0, 0x6d, 0xdb, 0x76, 0x00,
   0x00, 0x60, 0x55, 0x55, 0x55, 0x00, 0x00, 0xc0, 0x28, 0x8a, 0x22, 0x03,
   0x00, 0x80, 0x10, 0x04, 0xa1, 0x04, 0x38, 0x38, 0x11, 0x04, 0xf1, 0x02,
   0x7c, 0x7c, 0xfe, 0xff, 0x9f, 0x3e, 0xfe, 0xfe, 0xaa, 0xaa, 0xca, 0x6a,
   0xfe, 0xfe, 0xfc, 0xff, 0x2f, 0x2a, 0xfe, 0xff, 0x04, 0xa0, 0xca, 0x2a,
   0xfe, 0xff, 0x1a, 0xaf, 0x8a, 0x2a, 0xfc, 0x7f, 0xa6, 0xa0, 0xfa, 0x56,
   0xfc, 0x7f, 0x3e, 0x4f, 0x55, 0x02, 0xf8, 0x3f, 0x3a, 0x4c, 0x95, 0x45,
   0xf0, 0x1f, 0x3e, 0x4e, 0x35, 0x7e, 0xe0, 0x0f, 0xa2, 0x80, 0x2a, 0x02,
   0xe0, 0x0f, 0x62, 0x80, 0x2a, 0x7f, 0xc0, 0x07, 0x42, 0x40, 0x55, 0x01,
   0x80, 0x03, 0x03, 0x40, 0xd5, 0x7f, 0x80, 0xc3, 0xb2, 0x21, 0xd5, 0x3c,
   0x00, 0x21, 0x43, 0xd0, 0x54, 0x1e, 0x00, 0x91, 0xe2, 0x50, 0x2a, 0x4f,
   0x00, 0xf0, 0x04, 0xa8, 0x9f, 0x27, 0x00, 0x58, 0xab, 0xaa, 0xc9, 0x33,
   0x00, 0x46, 0x55, 0x75, 0xea, 0x69, 0xc0, 0x2f, 0x0b, 0x6a, 0xff, 0x2c,
   0x78, 0x56, 0xe6, 0xf8, 0x66, 0x1a, 0xae, 0xf5, 0xbc, 0x6f, 0xf5, 0x4b,
   0x95, 0xd9, 0xf3, 0xe3, 0x1d, 0x67, 0x4a, 0x5a, 0x0d, 0x58, 0x6d, 0x7c,
   0xa5, 0xf4, 0xf5, 0xd7, 0x87, 0x71, 0xb2, 0x59, 0x5d, 0x5d, 0x47, 0x46,
   0x49, 0xb2, 0xd5, 0xf5, 0xa6, 0x38, 0x97, 0x55, 0x5f, 0x7d, 0x15, 0x4d,
   0x3a, 0xed, 0xf6, 0xb7, 0xa7, 0x44, 0x74, 0xb2, 0x84, 0x30, 0x55, 0x56,
   0xf9, 0x2c, 0x55, 0x55, 0xad, 0x52, 0xf2, 0xaf, 0xa7, 0xf2, 0x96, 0x5b,
   0x74, 0x59, 0x44, 0x51, 0x97, 0x59, 0xb1, 0x3a, 0x8f, 0x50, 0xe6, 0x5d,
   0x38, 0x1d, 0x50, 0xb9, 0x96, 0x44, 0xb5, 0x1a, 0x9f, 0xd8, 0xc5, 0x72,
   0x72, 0x1c, 0x50, 0x99, 0x42, 0x3c, 0xb8, 0x1a, 0x1f, 0xa8, 0x62, 0x0f,
   0xf5, 0x2e, 0x90, 0x78, 0xf2, 0x63, 0x8e, 0xe7, 0xcf, 0xf9, 0xf3, 0x38,
   0x1c, 0xcf, 0x9f, 0xf3, 0xe7, 0x71, 0xc6, 0x4f, 0x1e, 0x09, 0x74, 0xaf,
   0xf0, 0x46, 0x15, 0xf8, 0x58, 0x1d, 0x3c, 0x42, 0x99, 0x0a, 0x38, 0x4e,
   0x4e, 0xa3, 0x1b, 0xf9, 0x58, 0xad, 0x22, 0x69, 0x9d, 0x0a, 0xb8, 0x1c,
   0xba, 0x67, 0x0a, 0xf1, 0x5c, 0x8d, 0x9a, 0xe9, 0x8a, 0x22, 0x9a, 0x2e,
   0xda, 0x69, 0x4f, 0xe5, 0xf5, 0x4f, 0x4a, 0xb5, 0xaa, 0xaa, 0x34, 0x9f,
   0x6a, 0xaa, 0x0c, 0x21, 0x4d, 0x2e, 0x22, 0xe5, 0xed, 0x6f, 0xb7, 0x5c,
   0xb2, 0xa8, 0xbe, 0xfa, 0xaa, 0xe9, 0x1c, 0x65, 0xaf, 0xab, 0x4d, 0x92,
   0x62, 0xe2, 0xba, 0xba, 0x9a, 0x4d, 0x8e, 0xe1, 0xeb, 0xaf, 0x2f, 0xa5,
   0x3e, 0xb6, 0x1a, 0xb0, 0x5a, 0x52, 0xe6, 0xb8, 0xc7, 0xcf, 0x9b, 0xa9,
   0xd2, 0xaf, 0xf6, 0x3d, 0xaf, 0x75, 0x58, 0x66, 0x1f, 0x67, 0x6a, 0x1e,
   0x34, 0xff, 0x56, 0xd0, 0xf4, 0x03, 0x96, 0x57, 0xae, 0xaa, 0x62, 0x00,
   0xcc, 0x93, 0x55, 0xd5, 0x1a, 0x00, 0xe4, 0xf9, 0x15, 0x20, 0x0f, 0x00,
   0xf2, 0x54, 0x0a, 0x47, 0x89, 0x00, 0x78, 0x2a, 0x0b, 0xc2, 0x84, 0x00,
   0x3c, 0xab, 0x84, 0x4d, 0xc3, 0x01, 0xfe, 0xab, 0x02, 0xc0, 0xc0, 0x01,
   0x80, 0xaa, 0x02, 0x42, 0xe0, 0x03, 0xfe, 0x54, 0x01, 0x46, 0xf0, 0x07,
   0x40, 0x54, 0x01, 0x45, 0xf0, 0x07, 0x7e, 0xac, 0x72, 0x7c, 0xf8, 0x0f,
   0xa2, 0xa9, 0x32, 0x5c, 0xfc, 0x1f, 0x40, 0xaa, 0xf2, 0x7c, 0xfe, 0x3f,
   0x6a, 0x5f, 0x05, 0x65, 0xfe, 0x3f, 0x54, 0x51, 0xf5, 0x58, 0xff, 0x7f,
   0x54, 0x53, 0x05, 0x20, 0xff, 0x7f, 0x54, 0xf4, 0xff, 0x3f, 0x7f, 0x7f,
   0x56, 0x53, 0x55, 0x55, 0x7f, 0x7f, 0x7c, 0xf9, 0xff, 0x7f, 0x3e, 0x3e,
   0x40, 0x8f, 0x20, 0x88, 0x1c, 0x1c, 0x20, 0x85, 0x20, 0x08, 0x01, 0x00,
   0xc0, 0x44, 0x51, 0x14, 0x03, 0x00, 0x00, 0xaa, 0xaa, 0xaa, 0x06, 0x00,
   0x00, 0x6e, 0xdb, 0xb6, 0x0d, 0x00, 0x00, 0x01, 0x00, 0x00, 0x10, 0x00};

#define king_s_width 47
#define king_s_height 92
#define king_s_x_hot -1
#define king_s_y_hot -1
static char king_s_bits[] = {
   0x00, 0xa0, 0x10, 0x04, 0x41, 0x02, 0x00, 0xc2, 0x39, 0x8e, 0x63, 0x01,
   0x00, 0x82, 0x7d, 0xdf, 0xf7, 0x00, 0x00, 0x07, 0x7d, 0xdf, 0x67, 0x00,
   0x00, 0x07, 0x12, 0x04, 0x21, 0x00, 0x80, 0x0f, 0xfc, 0xff, 0x3f, 0x00,
   0x80, 0x0f, 0xfc, 0xff, 0x3f, 0x00, 0xc0, 0x1f, 0x54, 0x01, 0x20, 0x20,
   0xe0, 0x3f, 0x54, 0x79, 0x3e, 0x70, 0xf0, 0x7f, 0x54, 0x05, 0x21, 0x58,
   0xf8, 0xff, 0x54, 0xb9, 0x2f, 0x0c, 0xf8, 0xff, 0x54, 0x9d, 0x26, 0x04,
   0xfc, 0xff, 0x55, 0xb9, 0x2f, 0x24, 0xfc, 0xff, 0x55, 0x01, 0x21, 0x24,
   0xfc, 0xff, 0x55, 0x01, 0x21, 0x14, 0xfc, 0xff, 0x55, 0x81, 0x21, 0x14,
   0xf8, 0xfa, 0x54, 0xb5, 0x36, 0x14, 0x70, 0x72, 0x54, 0x1d, 0x3c, 0x24,
   0x00, 0x07, 0x54, 0x61, 0x23, 0x24, 0x80, 0x0f, 0x54, 0x81, 0x20, 0x24,
   0x00, 0x00, 0x56, 0xc1, 0xe1, 0x24, 0x00, 0x00, 0x55, 0x03, 0x60, 0x15,
   0x00, 0x00, 0x55, 0xad, 0x5a, 0x15, 0x00, 0x80, 0xab, 0xd3, 0xa5, 0x14,
   0x00, 0xe0, 0xff, 0xff, 0x7f, 0x34, 0x00, 0xbc, 0x00, 0x00, 0xc4, 0x35,
   0x00, 0xb3, 0xff, 0xff, 0x47, 0x35, 0xc0, 0x07, 0x55, 0x55, 0xaf, 0x66,
   0x38, 0x67, 0xff, 0xff, 0xad, 0x66, 0x76, 0x6e, 0x01, 0x00, 0xa1, 0x66,
   0xe3, 0x4c, 0x31, 0xb8, 0x52, 0x45, 0xc7, 0x1d, 0x3a, 0x84, 0x56, 0x45,
   0x8f, 0xd3, 0xf2, 0x87, 0x56, 0x45, 0x9c, 0xd2, 0xe2, 0x4f, 0x28, 0x45,
   0x78, 0x9d, 0xda, 0x4f, 0xa9, 0x46, 0xb1, 0x22, 0x42, 0x54, 0xab, 0x46,
   0x73, 0x27, 0x24, 0x52, 0xab, 0x66, 0x97, 0xaf, 0x05, 0x40, 0x94, 0x66,
   0xbe, 0xbe, 0xfd, 0xbf, 0x54, 0x67, 0x5c, 0x3c, 0xfd, 0xbf, 0x55, 0x7f,
   0x7c, 0x78, 0xac, 0xaa, 0x55, 0x11, 0x5f, 0x7c, 0xa8, 0x2a, 0x5e, 0x7f,
   0xe8, 0x5e, 0x5b, 0x55, 0x62, 0x0a, 0xbf, 0x4f, 0x3b, 0xd6, 0xa2, 0x7e,
   0x68, 0x47, 0x7a, 0xd7, 0x5e, 0x0b, 0xbf, 0x42, 0xc8, 0x09, 0xa1, 0x7e,
   0x7e, 0x85, 0x90, 0x13, 0x42, 0xfd, 0xd0, 0x7a, 0xeb, 0x5e, 0xe2, 0x16,
   0x7e, 0x45, 0x6b, 0xdc, 0xf2, 0xfd, 0x50, 0x46, 0xaa, 0xda, 0x7a, 0x17,
   0xfe, 0x7a, 0x54, 0x15, 0x3e, 0xfa, 0x88, 0xaa, 0x55, 0x35, 0x1e, 0x3e,
   0xfe, 0xaa, 0xfd, 0xbf, 0x3c, 0x3a, 0xe6, 0x2a, 0xfd, 0xbf, 0x7d, 0x7d,
   0x66, 0x29, 0x02, 0xa0, 0xf5, 0xe9, 0x66, 0xd5, 0x4a, 0x24, 0xe4, 0xce,
   0x62, 0xd5, 0x2a, 0x42, 0x44, 0x8d, 0x62, 0x95, 0xf2, 0x5b, 0xb9, 0x1e,
   0xa2, 0x14, 0xf2, 0x47, 0x4b, 0x39, 0xa2, 0x6a, 0xe1, 0x4f, 0xcb, 0xf1,
   0xa2, 0x6a, 0x21, 0x5c, 0xb8, 0xe3, 0xa2, 0x4a, 0x1d, 0x8c, 0x32, 0xc7,
   0x66, 0x85, 0x00, 0x80, 0x76, 0x6e, 0x66, 0xb5, 0xff, 0xff, 0xe6, 0x1c,
   0x66, 0xf5, 0xaa, 0xaa, 0xe0, 0x03, 0xac, 0xe2, 0xff, 0xff, 0xcd, 0x00,
   0xac, 0x23, 0x00, 0x00, 0x3d, 0x00, 0x2c, 0xfe, 0xff, 0xff, 0x07, 0x00,
   0x28, 0xa5, 0xcb, 0xd5, 0x01, 0x00, 0xa8, 0x5a, 0xb5, 0xaa, 0x00, 0x00,
   0xa8, 0x06, 0xc0, 0xaa, 0x00, 0x00, 0x24, 0x87, 0x83, 0x6a, 0x00, 0x00,
   0x24, 0x04, 0x81, 0x2a, 0xf0, 0x01, 0x24, 0xc4, 0x86, 0x2a, 0xe0, 0x00,
   0x24, 0x3c, 0xb8, 0x2a, 0x4e, 0x0e, 0x28, 0x6c, 0xad, 0x2a, 0x5f, 0x1f,
   0x28, 0x84, 0x81, 0xaa, 0xff, 0x3f, 0x28, 0x84, 0x80, 0xaa, 0xff, 0x3f,
   0x24, 0x84, 0x80, 0xaa, 0xff, 0x3f, 0x24, 0xf4, 0x9d, 0xaa, 0xff, 0x3f,
   0x20, 0x64, 0xb9, 0x2a, 0xff, 0x1f, 0x30, 0xf4, 0x9d, 0x2a, 0xff, 0x1f,
   0x1a, 0x84, 0xa0, 0x2a, 0xfe, 0x0f, 0x0e, 0x7c, 0x9e, 0x2a, 0xfc, 0x07,
   0x04, 0x04, 0x80, 0x2a, 0xf8, 0x03, 0x00, 0xfc, 0xff, 0x3f, 0xf0, 0x01,
   0x00, 0xfc, 0xff, 0x3f, 0xf0, 0x01, 0x00, 0x84, 0x20, 0x48, 0xe0, 0x00,
   0x00, 0xe6, 0xfb, 0xbe, 0xe0, 0x00, 0x00, 0xef, 0xfb, 0xbe, 0x41, 0x00,
   0x80, 0xc6, 0x71, 0x9c, 0x43, 0x00, 0x40, 0x82, 0x20, 0x08, 0x05, 0x00};

#define queen_c_width 47
#define queen_c_height 92
#define queen_c_x_hot -1
#define queen_c_y_hot -1
static char queen_c_bits[] = {
   0xc0, 0xec, 0x92, 0x02, 0x00, 0x00, 0xe0, 0xef, 0x29, 0x03, 0xe0, 0x00,
   0xe1, 0xaf, 0x44, 0x02, 0xf0, 0x01, 0xc3, 0xa6, 0x92, 0x02, 0xf8, 0x03,
   0x02, 0xf6, 0x29, 0x03, 0xf8, 0x03, 0x66, 0xb6, 0xcf, 0x03, 0xf8, 0x03,
   0xf4, 0xd7, 0x20, 0x02, 0xf0, 0x01, 0xf4, 0x57, 0xef, 0x03, 0xee, 0x0e,
   0x64, 0x73, 0xe6, 0x02, 0xff, 0x1f, 0x04, 0x5b, 0xae, 0x87, 0xff, 0x3f,
   0xb4, 0x5b, 0x40, 0x8a, 0xff, 0x3f, 0xfe, 0x4b, 0x68, 0x92, 0xff, 0x3f,
   0xfa, 0x79, 0x30, 0x27, 0xff, 0x1f, 0xf2, 0x2d, 0x20, 0x4f, 0x4e, 0x0e,
   0xcf, 0x2d, 0x20, 0x9d, 0x40, 0x00, 0xd8, 0x24, 0x04, 0x39, 0xe1, 0x00,
   0xf0, 0x7e, 0xbc, 0x73, 0xe2, 0x00, 0xe0, 0xf6, 0xb0, 0x67, 0xf2, 0x01,
   0x70, 0xf2, 0xc1, 0xef, 0x04, 0x00, 0x70, 0x5b, 0x43, 0xdc, 0x04, 0x00,
   0x38, 0x0f, 0x7f, 0xf1, 0x04, 0x00, 0xb8, 0x29, 0x54, 0xe4, 0x04, 0x00,
   0x9c, 0xfc, 0x00, 0xdd, 0x04, 0x01, 0xcc, 0x84, 0xb7, 0xc3, 0x83, 0x02,
   0xee, 0x8f, 0x7c, 0x62, 0xc3, 0x06, 0x26, 0xda, 0x6d, 0x37, 0x26, 0x09,
   0x33, 0x73, 0xd7, 0x1d, 0xcf, 0x36, 0xbb, 0x3f, 0xba, 0xf8, 0x9b, 0x2a,
   0xe9, 0xfb, 0xd7, 0xaf, 0x31, 0x25, 0x6c, 0x55, 0xef, 0xf4, 0xf9, 0x15,
   0xf6, 0xee, 0x39, 0xac, 0x19, 0x3a, 0x5e, 0x55, 0x11, 0xdc, 0xf9, 0x45,
   0xbb, 0xbb, 0xe2, 0xac, 0xf1, 0x33, 0x55, 0x55, 0xe3, 0xf8, 0x63, 0x4f,
   0xee, 0xee, 0x5a, 0x6b, 0xb7, 0x2e, 0x55, 0x55, 0xbb, 0x3b, 0x5e, 0x59,
   0xbb, 0xbb, 0x5b, 0x2b, 0xaf, 0x37, 0x55, 0x55, 0x43, 0x38, 0x5b, 0x68,
   0xee, 0xee, 0xe2, 0x18, 0xb0, 0x53, 0xf5, 0x57, 0x05, 0x18, 0x70, 0x64,
   0x1f, 0xb8, 0x87, 0x18, 0xe8, 0x29, 0x03, 0xc0, 0xc5, 0x99, 0xd9, 0x6b,
   0x01, 0x03, 0xa7, 0x9a, 0xa9, 0x2b, 0x1b, 0x03, 0x75, 0x17, 0x50, 0x57,
   0x1e, 0x30, 0x2a, 0x2a, 0xe0, 0x2c, 0x0d, 0x30, 0x9e, 0x3c, 0x06, 0x58,
   0x1a, 0x60, 0x3c, 0x79, 0x0c, 0xb0, 0x34, 0x07, 0x54, 0x54, 0x0c, 0x78,
   0xea, 0x0a, 0xe8, 0xae, 0xc0, 0xd8, 0xd4, 0x95, 0x59, 0xe5, 0xc0, 0x80,
   0xd6, 0x9b, 0x99, 0xa3, 0x03, 0xc0, 0x94, 0x17, 0x18, 0xe1, 0x1d, 0xf8,
   0x26, 0x0e, 0x18, 0xa0, 0xea, 0xaf, 0xca, 0x0d, 0x18, 0x47, 0x77, 0x77,
   0x16, 0xda, 0x1c, 0xc2, 0xaa, 0xaa, 0xec, 0xf5, 0xd4, 0xda, 0xdd, 0xdd,
   0x9a, 0x7a, 0xdc, 0xdd, 0xaa, 0xaa, 0x74, 0xed, 0xd6, 0x5a, 0x77, 0x77,
   0xf2, 0xc6, 0x1f, 0xc7, 0xaa, 0xaa, 0xcc, 0x8f, 0x35, 0x47, 0xdd, 0xdd,
   0xa2, 0x9f, 0x3b, 0x88, 0xaa, 0x7a, 0x5c, 0x98, 0x35, 0x9c, 0x77, 0x6f,
   0xa8, 0x9f, 0x2f, 0xf7, 0xaa, 0x36, 0xa4, 0x8c, 0xf5, 0xeb, 0xdf, 0x97,
   0x54, 0xd9, 0x1f, 0x5d, 0xfc, 0xdd, 0x6c, 0xf3, 0xb8, 0xeb, 0xce, 0xcc,
   0x90, 0x64, 0xec, 0xb6, 0x5b, 0x64, 0x60, 0xc3, 0x46, 0x3e, 0xf1, 0x77,
   0x40, 0xc1, 0xc3, 0xed, 0x21, 0x33, 0x80, 0x20, 0xbb, 0x00, 0x3f, 0x39,
   0x00, 0x20, 0x27, 0x2a, 0x94, 0x1d, 0x00, 0x20, 0x8f, 0xfe, 0xf0, 0x1c,
   0x00, 0x20, 0x3b, 0xc2, 0xda, 0x0e, 0x00, 0x20, 0xf7, 0x83, 0x4f, 0x0e,
   0x80, 0x4f, 0xe6, 0x0d, 0x6f, 0x07, 0x00, 0x47, 0xce, 0x3d, 0x7e, 0x0f,
   0x00, 0x87, 0x9c, 0x20, 0x24, 0x1b, 0x00, 0x02, 0xb9, 0x04, 0xb4, 0xf3,
   0x70, 0x72, 0xf2, 0x04, 0xb4, 0x4f, 0xf8, 0xff, 0xe4, 0x0c, 0x9e, 0x5f,
   0xfc, 0xff, 0x49, 0x16, 0xd2, 0x7f, 0xfc, 0xff, 0x51, 0x02, 0xda, 0x2d,
   0xfc, 0xff, 0xe1, 0x75, 0xda, 0x20, 0xf8, 0xff, 0x40, 0x67, 0xce, 0x26,
   0x70, 0x77, 0xc0, 0xf7, 0xea, 0x2f, 0x80, 0x0f, 0x40, 0x04, 0xeb, 0x2f,
   0xc0, 0x1f, 0xc0, 0xf3, 0x6d, 0x66, 0xc0, 0x1f, 0xc0, 0x94, 0x6f, 0x40,
   0xc0, 0x1f, 0x40, 0x49, 0x65, 0xc3, 0x80, 0x0f, 0x40, 0x22, 0xf5, 0x87,
   0x00, 0x07, 0xc0, 0x94, 0xf7, 0x07, 0x00, 0x00, 0x40, 0x49, 0x37, 0x03};

#define queen_d_width 47
#define queen_d_height 92
#define queen_d_x_hot -1
#define queen_d_y_hot -1
static char queen_d_bits[] = {
   0x04, 0xf1, 0x49, 0x01, 0x00, 0x00, 0xc8, 0xb7, 0x94, 0x01, 0x80, 0x00,
   0x08, 0x79, 0x22, 0x03, 0x80, 0x00, 0x88, 0x58, 0x41, 0x05, 0xc0, 0x01,
   0xe8, 0xbf, 0x80, 0x09, 0xc0, 0x01, 0x88, 0xec, 0x77, 0x0b, 0xe0, 0x03,
   0x48, 0x5e, 0x88, 0x17, 0xf0, 0x07, 0xf8, 0x97, 0xef, 0x27, 0xf0, 0x07,
   0x48, 0x0f, 0x73, 0x4f, 0xf8, 0x0f, 0x24, 0x1b, 0xd7, 0x5f, 0xfc, 0x1f,
   0xfc, 0x17, 0x10, 0x9f, 0xfe, 0x3f, 0xa4, 0x1d, 0x20, 0xbf, 0xfc, 0x1f,
   0xc2, 0x17, 0xac, 0x7d, 0xf9, 0x0f, 0xff, 0x0e, 0x90, 0x7a, 0xf2, 0x07,
   0xc0, 0x09, 0x80, 0xfd, 0xf2, 0x07, 0x40, 0x1b, 0x9f, 0xfa, 0xe2, 0x03,
   0xe0, 0x38, 0xcc, 0xf5, 0xc5, 0x01, 0xa0, 0x62, 0xc0, 0xea, 0xc5, 0x09,
   0xf0, 0xc8, 0xe0, 0xf5, 0x89, 0x1c, 0xd0, 0xa3, 0x21, 0xeb, 0x8b, 0x2a,
   0xf8, 0x9f, 0x9e, 0xdc, 0x0b, 0x77, 0xa8, 0xff, 0xa2, 0xff, 0x13, 0x2a,
   0xdc, 0xfd, 0xff, 0xdf, 0x17, 0x18, 0xf4, 0xea, 0xff, 0xab, 0x17, 0x2c,
   0xfe, 0x77, 0x7f, 0xf7, 0x1f, 0x2a, 0xea, 0xaf, 0xaa, 0xfa, 0x3b, 0x55,
   0x5f, 0xff, 0xdd, 0x7f, 0xfd, 0x52, 0xfd, 0xfa, 0xff, 0xaf, 0x5f, 0x23,
   0xdf, 0xd5, 0xff, 0xd5, 0xae, 0x5e, 0xce, 0xaf, 0xaa, 0xfa, 0x97, 0x35,
   0x6f, 0xf2, 0xd5, 0xff, 0xd7, 0x62, 0xa7, 0xf2, 0x7f, 0x3e, 0x57, 0x55,
   0x37, 0xf2, 0x4f, 0x06, 0xb7, 0x08, 0xf3, 0x2f, 0x4f, 0x6e, 0x6e, 0x55,
   0x5b, 0x31, 0xdc, 0x6c, 0x3e, 0x22, 0x49, 0x55, 0x9b, 0x8c, 0x5f, 0x55,
   0x9d, 0x51, 0x9b, 0xfe, 0xaa, 0x08, 0xbc, 0x4e, 0xf8, 0xab, 0x4e, 0x55,
   0x2e, 0xb9, 0xaf, 0xfa, 0x75, 0x22, 0x5e, 0xc5, 0xea, 0x0f, 0x8c, 0x55,
   0x6f, 0xd5, 0x1f, 0xf0, 0xaa, 0x08, 0x5f, 0xc5, 0xe0, 0x9f, 0x8a, 0x55,
   0x6f, 0xb9, 0x3e, 0x40, 0x71, 0x23, 0x5f, 0x9d, 0x82, 0x5f, 0x9d, 0x54,
   0x6b, 0xa3, 0xfa, 0x5a, 0xa3, 0x4e, 0x35, 0xab, 0xda, 0xad, 0x6a, 0x56,
   0x6a, 0x56, 0xb5, 0x5b, 0xd5, 0xac, 0x72, 0xc5, 0x5a, 0x5f, 0xc5, 0xd6,
   0x2a, 0xb9, 0xfa, 0x41, 0xb9, 0xfa, 0xc4, 0x8e, 0x02, 0x7c, 0x9d, 0xf6,
   0xaa, 0x51, 0xf9, 0x07, 0xa3, 0xfa, 0x10, 0x55, 0x0f, 0xf8, 0xab, 0xf6,
   0xaa, 0x31, 0xf0, 0x57, 0xa3, 0x7a, 0x44, 0xae, 0x5f, 0xf5, 0x9d, 0x74,
   0xaa, 0x72, 0xd5, 0x1f, 0x72, 0x3d, 0x10, 0x55, 0x7f, 0xd9, 0x8a, 0xb9,
   0xaa, 0xfa, 0x31, 0xd9, 0xaa, 0x92, 0x44, 0x7c, 0x36, 0x3b, 0x8c, 0xda,
   0xaa, 0x76, 0x76, 0xf2, 0xf4, 0xcf, 0x10, 0xed, 0x60, 0xf2, 0x4f, 0xec,
   0xaa, 0xea, 0x7c, 0xfe, 0x4f, 0xe5, 0x46, 0xeb, 0xff, 0xab, 0x4f, 0xf6,
   0xac, 0xe9, 0x5f, 0x55, 0xf5, 0x73, 0x7a, 0x75, 0xab, 0xff, 0xab, 0xfb,
   0xc4, 0xfa, 0xf5, 0xff, 0x5f, 0xbf, 0x4a, 0xbf, 0xfe, 0xbb, 0xff, 0xfa,
   0xaa, 0xdc, 0x5f, 0x55, 0xf5, 0x57, 0x54, 0xf8, 0xef, 0xfe, 0xee, 0x7f,
   0x34, 0xe8, 0xd5, 0xff, 0x57, 0x2f, 0x18, 0xe8, 0xfb, 0xff, 0xbf, 0x3b,
   0x54, 0xc8, 0xff, 0x45, 0xff, 0x15, 0xee, 0xd0, 0x3b, 0x79, 0xf9, 0x1f,
   0x54, 0xd1, 0xd7, 0x84, 0xc5, 0x0b, 0x38, 0x91, 0xaf, 0x07, 0x13, 0x0f,
   0x90, 0xa3, 0x57, 0x03, 0x46, 0x05, 0x80, 0xa3, 0xaf, 0x33, 0x1c, 0x07,
   0xc0, 0x47, 0x5f, 0xf9, 0xd8, 0x02, 0xe0, 0x4f, 0xbf, 0x01, 0x90, 0x03,
   0xe0, 0x4f, 0x5e, 0x09, 0x70, 0xff, 0xf0, 0x9f, 0xbe, 0x35, 0xe8, 0x43,
   0xf8, 0x3f, 0xfd, 0x04, 0xb8, 0x25, 0xfc, 0x7f, 0xf9, 0x08, 0xe8, 0x3f,
   0xf8, 0x3f, 0xfa, 0xeb, 0xd8, 0x24, 0xf0, 0x1f, 0xf2, 0xce, 0xf0, 0x12,
   0xe0, 0x0f, 0xe4, 0xf7, 0xe9, 0x1f, 0xe0, 0x0f, 0xe8, 0x11, 0x7a, 0x12,
   0xc0, 0x07, 0xd0, 0xee, 0x37, 0x11, 0x80, 0x03, 0x90, 0x01, 0xfd, 0x17,
   0x80, 0x03, 0xa0, 0x82, 0x1a, 0x11, 0x00, 0x01, 0xc0, 0x44, 0x9e, 0x10,
   0x00, 0x01, 0x80, 0x29, 0xed, 0x13, 0x00, 0x00, 0x80, 0x92, 0x8f, 0x20};

#define queen_h_width 47
#define queen_h_height 92
#define queen_h_x_hot -1
#define queen_h_y_hot -1
static char queen_h_bits[] = {
   0x00, 0x54, 0x05, 0x20, 0x00, 0x00, 0x00, 0xac, 0xce, 0x20, 0x0e, 0x0e,
   0x00, 0x56, 0xcd, 0x11, 0x1f, 0x1f, 0x00, 0xae, 0xda, 0x91, 0xbf, 0x3f,
   0x00, 0x16, 0x15, 0x90, 0xbf, 0x3f, 0x00, 0x0e, 0x3a, 0x93, 0xff, 0x3f,
   0x00, 0x75, 0x3e, 0x97, 0xff, 0x3f, 0x00, 0x45, 0x70, 0x27, 0xff, 0x1f,
   0x00, 0x7d, 0x6e, 0x20, 0xff, 0x1f, 0x00, 0x75, 0xcc, 0x2c, 0xfe, 0x0f,
   0x80, 0x7e, 0x9e, 0x5d, 0xfc, 0x07, 0x80, 0x46, 0x80, 0x5d, 0xf8, 0x03,
   0x80, 0x86, 0x00, 0x83, 0xf8, 0x03, 0x80, 0x8e, 0x02, 0x37, 0xf1, 0x01,
   0x40, 0x8f, 0x81, 0xff, 0xe1, 0x00, 0x40, 0x0f, 0x81, 0x0d, 0xe0, 0x00,
   0x40, 0x0f, 0xc4, 0x3f, 0x40, 0x00, 0x40, 0x97, 0xc3, 0x7a, 0x40, 0x08,
   0xa0, 0x13, 0xe3, 0xff, 0x00, 0x36, 0xa0, 0x3b, 0x61, 0xf5, 0x03, 0x2a,
   0xa0, 0x2f, 0xf0, 0xff, 0x0f, 0x5d, 0xa0, 0x57, 0x58, 0xcd, 0x3f, 0x2a,
   0xd0, 0xad, 0xaf, 0xce, 0x1f, 0x36, 0xd0, 0x5d, 0x55, 0xfb, 0x0f, 0x48,
   0xd0, 0xf2, 0xea, 0xf1, 0x0f, 0x7e, 0x50, 0x91, 0x3f, 0xfb, 0x35, 0x37,
   0x28, 0x8e, 0x24, 0xb6, 0xf0, 0x20, 0x98, 0x7c, 0xe4, 0xb1, 0xd4, 0x2b,
   0x48, 0xe6, 0x1f, 0x38, 0x67, 0x76, 0x24, 0xe2, 0x03, 0x18, 0x7a, 0x52,
   0x24, 0xf2, 0x67, 0x5b, 0x5d, 0x2a, 0x32, 0xd3, 0xaf, 0xfe, 0x67, 0x52,
   0x29, 0x51, 0x4f, 0xad, 0x3b, 0x62, 0x20, 0x39, 0x9d, 0xec, 0x25, 0x73,
   0x54, 0xe9, 0x9e, 0xce, 0x3a, 0x79, 0x58, 0xd9, 0x3b, 0xce, 0x2a, 0x3d,
   0x12, 0xb9, 0x39, 0x76, 0x35, 0x5f, 0x9c, 0xb9, 0x7b, 0x67, 0x2d, 0x2f,
   0x94, 0x68, 0x77, 0x6b, 0x35, 0x57, 0x84, 0x7c, 0x67, 0xbf, 0x2a, 0x2b,
   0x8e, 0x64, 0xf9, 0xb7, 0x36, 0x15, 0x95, 0x6c, 0xe7, 0xb5, 0x2a, 0x0b,
   0xa4, 0x74, 0x9d, 0x59, 0x3d, 0x25, 0x88, 0xa4, 0x77, 0x5e, 0x2f, 0x13,
   0xc9, 0xbc, 0xdc, 0x79, 0x33, 0x11, 0x5e, 0xdc, 0x73, 0xe7, 0x1d, 0x3d,
   0xbc, 0xb8, 0xe7, 0xce, 0x3b, 0x7a, 0x88, 0xcc, 0x9e, 0x3b, 0x3d, 0x93,
   0xc8, 0xf4, 0x7a, 0xee, 0x25, 0x11, 0xa4, 0xbc, 0x9a, 0xb9, 0x2e, 0x25,
   0xd0, 0x54, 0xad, 0xe7, 0x36, 0xa9, 0xa8, 0x6c, 0xed, 0x9f, 0x26, 0x71,
   0xd4, 0x54, 0xfd, 0xe6, 0x3e, 0x21, 0xea, 0xac, 0xd6, 0xee, 0x16, 0x29,
   0xf4, 0xb4, 0xe6, 0xde, 0x9d, 0x39, 0xfa, 0xac, 0x6e, 0x9c, 0x9d, 0x48,
   0xbc, 0x54, 0x73, 0xdc, 0x9b, 0x1a, 0x9e, 0x5c, 0x73, 0x79, 0x97, 0x2a,
   0xce, 0xa4, 0x37, 0xb9, 0x9c, 0x04, 0x46, 0xdc, 0xb5, 0xf2, 0x8a, 0x94,
   0x4a, 0xe6, 0x7f, 0xf5, 0xcb, 0x4c, 0x54, 0xba, 0xda, 0xe6, 0x4f, 0x24,
   0x4a, 0x5e, 0x18, 0xc0, 0x47, 0x24, 0x6e, 0xe6, 0x1c, 0xf8, 0x67, 0x12,
   0xd4, 0x2b, 0x8d, 0x27, 0x3e, 0x19, 0x04, 0x0f, 0x6d, 0x24, 0x71, 0x14,
   0xec, 0xac, 0xdf, 0xfc, 0x89, 0x0a, 0x7e, 0xf0, 0x8f, 0x57, 0x4f, 0x0b,
   0x12, 0xf0, 0xdf, 0xaa, 0xba, 0x0b, 0x6c, 0xf8, 0x73, 0xf5, 0xb5, 0x0b,
   0x54, 0xfc, 0xb3, 0x1a, 0xea, 0x05, 0xba, 0xf0, 0xff, 0x0f, 0xf4, 0x05,
   0x54, 0xc0, 0xaf, 0x86, 0xdc, 0x05, 0x6c, 0x00, 0xff, 0xc7, 0xc8, 0x05,
   0x10, 0x02, 0x5e, 0xc3, 0xe9, 0x02, 0x00, 0x02, 0xfc, 0x23, 0xf0, 0x02,
   0x00, 0x07, 0xb0, 0x81, 0xf0, 0x02, 0x00, 0x87, 0xff, 0x81, 0xf1, 0x02,
   0x80, 0x8f, 0xec, 0x40, 0x71, 0x01, 0xc0, 0x1f, 0xc1, 0x00, 0x61, 0x01,
   0xc0, 0x1f, 0xba, 0x01, 0x62, 0x01, 0xe0, 0x3f, 0xba, 0x79, 0x7e, 0x01,
   0xf0, 0x7f, 0x34, 0x33, 0xae, 0x00, 0xf8, 0xff, 0x04, 0x76, 0xbe, 0x00,
   0xf8, 0xff, 0xe4, 0x0e, 0xa2, 0x00, 0xfc, 0xff, 0xe9, 0x7c, 0xae, 0x00,
   0xfc, 0xff, 0xc9, 0x5c, 0x70, 0x00, 0xfc, 0xfd, 0x09, 0xa8, 0x68, 0x00,
   0xfc, 0xfd, 0x89, 0x5b, 0x75, 0x00, 0xf8, 0xf8, 0x88, 0xb3, 0x6a, 0x00,
   0x70, 0x70, 0x04, 0x73, 0x35, 0x00, 0x00, 0x00, 0x04, 0xa0, 0x2a, 0x00};

#define queen_s_width 47
#define queen_s_height 92
#define queen_s_x_hot -1
#define queen_s_y_hot -1
static char queen_s_bits[] = {
   0x00, 0x96, 0xb4, 0x10, 0x00, 0x00, 0x00, 0x4e, 0x19, 0x08, 0x00, 0x00,
   0x00, 0x26, 0xb2, 0x0b, 0x00, 0x00, 0x04, 0x15, 0x34, 0x0b, 0x20, 0x00,
   0x04, 0x0d, 0xb8, 0x0a, 0x20, 0x00, 0x0a, 0x75, 0x7c, 0x08, 0x70, 0x00,
   0x0a, 0x45, 0x62, 0x0f, 0x70, 0x00, 0x0a, 0x7d, 0x7e, 0x0e, 0xf8, 0x00,
   0x11, 0x5d, 0xcc, 0x0d, 0xf8, 0x00, 0x8a, 0x7a, 0xdc, 0x10, 0xfc, 0x01,
   0x8e, 0x4a, 0x80, 0x1f, 0xfe, 0x03, 0x84, 0x8a, 0xc1, 0x1d, 0xff, 0x07,
   0x84, 0x8a, 0xc0, 0x9f, 0xff, 0x0f, 0x8c, 0x0a, 0xa0, 0xc3, 0xff, 0x1f,
   0x86, 0x9a, 0x63, 0xc1, 0xff, 0x1f, 0x4c, 0x9d, 0xd1, 0xc1, 0xff, 0x1f,
   0x46, 0x2d, 0x30, 0xc3, 0xff, 0x1f, 0x4c, 0x2d, 0xa8, 0xc2, 0xff, 0x1f,
   0x46, 0x55, 0x44, 0x84, 0xaf, 0x0f, 0x4c, 0xaf, 0xab, 0x0a, 0x27, 0x07,
   0xe6, 0x13, 0x11, 0x11, 0x70, 0x00, 0xec, 0xab, 0xaa, 0x2e, 0xf8, 0x00,
   0x66, 0x46, 0x44, 0x26, 0x00, 0x00, 0x7c, 0xae, 0xaa, 0x41, 0x00, 0x00,
   0x16, 0x1c, 0x91, 0x94, 0x00, 0x00, 0xbc, 0xa8, 0x6a, 0x8c, 0x01, 0x04,
   0x36, 0x4b, 0x24, 0x8a, 0x02, 0x0e, 0x7c, 0xb3, 0x1e, 0x80, 0x02, 0x15,
   0xf6, 0xe4, 0x47, 0x61, 0x87, 0x3b, 0xfc, 0xa1, 0xc2, 0xb0, 0x6f, 0x15,
   0xe6, 0x91, 0xb4, 0xdc, 0x7d, 0x4e, 0xcc, 0x93, 0x04, 0xf6, 0xdc, 0x25,
   0x96, 0x8f, 0x08, 0x6d, 0xb6, 0x39, 0x3c, 0x8f, 0xc8, 0x32, 0x6b, 0x7f,
   0x66, 0xce, 0xb9, 0xbd, 0xc5, 0x2b, 0xcc, 0xfc, 0xdf, 0xbe, 0xa5, 0x30,
   0x86, 0xcd, 0x69, 0xa7, 0x55, 0x31, 0x1c, 0x8d, 0x98, 0xa3, 0xb5, 0x4d,
   0x36, 0x8b, 0xe8, 0x29, 0x2b, 0x13, 0x2c, 0x9a, 0xe4, 0x6c, 0x16, 0x35,
   0x46, 0xbf, 0x74, 0xce, 0x0c, 0x56, 0x8c, 0xa3, 0x3e, 0x80, 0x30, 0x17,
   0x86, 0xff, 0xff, 0xff, 0x7f, 0x30, 0xac, 0x45, 0x44, 0x44, 0x84, 0x10,
   0xa6, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x8c, 0xab, 0xaa, 0xaa, 0xea, 0x18,
   0x18, 0x57, 0x55, 0x55, 0xd5, 0x31, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x65,
   0x08, 0x21, 0x22, 0x22, 0xa2, 0x35, 0x0c, 0xfe, 0xff, 0xff, 0xff, 0x61,
   0xe8, 0x0c, 0x01, 0x7c, 0xc5, 0x31, 0x6a, 0x30, 0x73, 0x2e, 0xfd, 0x62,
   0xac, 0x68, 0x36, 0x27, 0x59, 0x34, 0xc8, 0xd4, 0x94, 0x17, 0xd1, 0x6c,
   0xb2, 0xad, 0xc5, 0x19, 0xb1, 0x38, 0x8c, 0xaa, 0xe5, 0x96, 0xb3, 0x61,
   0x0c, 0xa5, 0x7d, 0xfb, 0x3f, 0x33, 0xd4, 0xa3, 0xbd, 0x9d, 0x73, 0x66,
   0xfe, 0xd6, 0x4c, 0x13, 0xf1, 0x3c, 0x9c, 0x6d, 0xb6, 0x10, 0xf1, 0x69,
   0xa4, 0x3b, 0x6f, 0x20, 0xc9, 0x33, 0x72, 0xbe, 0x3b, 0x2d, 0x89, 0x67,
   0xa8, 0xf6, 0x0d, 0x43, 0x85, 0x3f, 0xdc, 0xe1, 0x86, 0xe2, 0x27, 0x6f,
   0xa8, 0x40, 0x01, 0x78, 0xcd, 0x3e, 0x70, 0x40, 0x51, 0x24, 0xd2, 0x6c,
   0x20, 0x80, 0x31, 0x56, 0x15, 0x3d, 0x00, 0x00, 0x29, 0x89, 0x38, 0x68,
   0x00, 0x00, 0x82, 0x55, 0x75, 0x3e, 0x00, 0x00, 0x64, 0x22, 0x62, 0x66,
   0x00, 0x1f, 0x74, 0x55, 0xd5, 0x37, 0x00, 0x0e, 0x88, 0x88, 0xc8, 0x67,
   0xe0, 0xe4, 0x50, 0xd5, 0xf5, 0x32, 0xf0, 0xf5, 0x21, 0x22, 0xaa, 0x62,
   0xf8, 0xff, 0x43, 0x15, 0xb4, 0x32, 0xf8, 0xff, 0xc3, 0x0c, 0xb4, 0x62,
   0xf8, 0xff, 0x83, 0x8b, 0xb9, 0x32, 0xf8, 0xff, 0x83, 0xc6, 0x59, 0x61,
   0xf8, 0xff, 0xc3, 0x05, 0x50, 0x31, 0xf0, 0xff, 0xf9, 0x03, 0x51, 0x21,
   0xe0, 0xff, 0xb8, 0x83, 0x51, 0x21, 0xc0, 0x7f, 0xf8, 0x01, 0x52, 0x71,
   0x80, 0x3f, 0x08, 0x3b, 0x5e, 0x51, 0x00, 0x1f, 0xb0, 0x33, 0xba, 0x88,
   0x00, 0x1f, 0x70, 0x7e, 0xbe, 0x50, 0x00, 0x0e, 0xf0, 0x46, 0xa2, 0x50,
   0x00, 0x0e, 0x10, 0x3e, 0xae, 0x50, 0x00, 0x04, 0x50, 0x1d, 0xb0, 0x20,
   0x00, 0x04, 0xd0, 0x2c, 0xa8, 0x20, 0x00, 0x00, 0xd0, 0x4d, 0x64, 0x00,
   0x00, 0x00, 0x10, 0x98, 0x72, 0x00, 0x00, 0x00, 0x08, 0x2d, 0x69, 0x00};

#define jack_c_width 47
#define jack_c_height 92
#define jack_c_x_hot -1
#define jack_c_y_hot -1
static char jack_c_bits[] = {
   0x60, 0xab, 0x6a, 0x6b, 0x03, 0x00, 0xc0, 0xd6, 0x56, 0xb5, 0xe1, 0x00,
   0x80, 0xad, 0x6a, 0xdb, 0xf0, 0x01, 0x81, 0xdb, 0x56, 0x6d, 0xf8, 0x03,
   0x83, 0xf6, 0x7e, 0x37, 0xf8, 0x03, 0x46, 0x0e, 0x00, 0x18, 0xf8, 0x03,
   0x4d, 0xfd, 0xff, 0x0f, 0xf0, 0x01, 0x9b, 0xfd, 0xff, 0x0f, 0xee, 0x0e,
   0xb7, 0x04, 0x40, 0x0d, 0xff, 0x1f, 0x60, 0x04, 0x40, 0x95, 0xff, 0x3f,
   0xff, 0x1c, 0x5f, 0x95, 0xff, 0x3f, 0x04, 0xa4, 0x40, 0x95, 0xff, 0x3f,
   0x04, 0x1e, 0x4f, 0x15, 0xff, 0x1f, 0x04, 0x4c, 0x46, 0x15, 0x4e, 0x0e,
   0x04, 0x5c, 0x4e, 0x15, 0x40, 0x00, 0x04, 0x24, 0x40, 0x15, 0xe0, 0x00,
   0x04, 0xe4, 0x40, 0x75, 0xe0, 0x00, 0x04, 0x44, 0x40, 0x5d, 0xf0, 0x01,
   0x04, 0x04, 0x42, 0x57, 0x00, 0x00, 0x04, 0xe8, 0x41, 0x55, 0x00, 0x00,
   0x0f, 0xc8, 0x60, 0x35, 0x00, 0x00, 0x12, 0x18, 0x70, 0x7c, 0x00, 0x00,
   0x27, 0x37, 0xdc, 0xff, 0x01, 0x00, 0xe4, 0xe9, 0x07, 0xde, 0x07, 0x00,
   0xe7, 0x1c, 0x9f, 0xd7, 0x1e, 0x00, 0xf4, 0x19, 0xfa, 0xe9, 0x7a, 0x40,
   0xef, 0xdc, 0x62, 0xc4, 0xea, 0x61, 0xd4, 0x19, 0x06, 0xd6, 0x7e, 0x37,
   0xbc, 0x1c, 0x9e, 0xc3, 0xf6, 0x1e, 0x7c, 0xd5, 0xfe, 0xeb, 0x7e, 0x15,
   0xec, 0x1a, 0xfa, 0xc1, 0xea, 0x12, 0xd4, 0x1d, 0xe2, 0xd5, 0x6a, 0x19,
   0xbc, 0xcf, 0x46, 0xc0, 0xfe, 0x11, 0x6c, 0x0f, 0xdd, 0xfa, 0xf6, 0x10,
   0xf4, 0x0a, 0x3b, 0xd0, 0x7e, 0x16, 0xbc, 0x6d, 0x55, 0xcf, 0x7a, 0x10,
   0xb4, 0x07, 0x1b, 0xd4, 0x26, 0x18, 0xbc, 0x85, 0xad, 0xd3, 0xa1, 0x15,
   0x9c, 0xb5, 0x0a, 0x65, 0x14, 0x14, 0xdc, 0x82, 0xed, 0x94, 0x11, 0x1a,
   0xdc, 0xc2, 0x4a, 0x09, 0x6c, 0x1a, 0xcc, 0x5a, 0x3d, 0x35, 0x0b, 0x1d,
   0x6c, 0xc1, 0x4a, 0x82, 0x06, 0x1d, 0x6c, 0x61, 0xd5, 0x6d, 0xb5, 0x1e,
   0x6c, 0xad, 0xba, 0xb2, 0x86, 0x1e, 0xbc, 0x60, 0x6d, 0x5b, 0x83, 0x1e,
   0x78, 0xc1, 0xda, 0xb6, 0x06, 0x3d, 0x78, 0x61, 0x4d, 0x5d, 0xb5, 0x36,
   0x78, 0xad, 0xb6, 0xab, 0x86, 0x36, 0xb8, 0x60, 0x41, 0x52, 0x83, 0x36,
   0xb8, 0xd0, 0xac, 0xbc, 0x5a, 0x33, 0x58, 0x36, 0x90, 0x52, 0x43, 0x3b,
   0x58, 0x88, 0x29, 0xb7, 0x41, 0x3b, 0x28, 0x28, 0xa6, 0x50, 0xad, 0x39,
   0xa8, 0x85, 0xcb, 0xb5, 0xa1, 0x3d, 0x18, 0x64, 0x2b, 0xd8, 0xe0, 0x2d,
   0x08, 0x5e, 0xf3, 0xaa, 0xb6, 0x3d, 0x68, 0x7e, 0x0b, 0xdc, 0x50, 0x2f,
   0x08, 0x6f, 0x5f, 0xbb, 0xf0, 0x36, 0x88, 0x7f, 0x03, 0x62, 0xf3, 0x3d,
   0x98, 0x56, 0xab, 0x47, 0xb8, 0x2b, 0x48, 0x57, 0x83, 0x5f, 0x58, 0x37,
   0xa8, 0x7e, 0xd7, 0x7f, 0xab, 0x3e, 0x78, 0x6f, 0xc3, 0x79, 0x38, 0x3d,
   0xec, 0x7e, 0x6b, 0x60, 0x98, 0x2b, 0x86, 0x57, 0x23, 0x46, 0x3b, 0xf7,
   0x02, 0x5e, 0x97, 0x5f, 0x98, 0x2f, 0x00, 0x78, 0xeb, 0xf9, 0x38, 0xe7,
   0x00, 0xe0, 0x7b, 0xe0, 0x97, 0x27, 0x00, 0x80, 0xff, 0x3b, 0xec, 0xe4,
   0x00, 0x00, 0x3e, 0x0e, 0x18, 0x48, 0x00, 0x00, 0xac, 0x06, 0x13, 0xf0,
   0x00, 0x00, 0xaa, 0x82, 0x17, 0x20, 0x00, 0x00, 0xea, 0x42, 0x20, 0x20,
   0x80, 0x0f, 0xba, 0x02, 0x22, 0x20, 0x00, 0x07, 0xae, 0x02, 0x27, 0x20,
   0x00, 0x07, 0xa8, 0x02, 0x24, 0x20, 0x00, 0x02, 0xa8, 0x72, 0x3a, 0x20,
   0x70, 0x72, 0xa8, 0x62, 0x32, 0x20, 0xf8, 0xff, 0xa8, 0xf2, 0x78, 0x20,
   0xfc, 0xff, 0xa9, 0x02, 0x25, 0x20, 0xfc, 0xff, 0xa9, 0xfa, 0x38, 0xff,
   0xfc, 0xff, 0xa9, 0x02, 0x20, 0x06, 0xf8, 0xff, 0xb0, 0x02, 0x20, 0xed,
   0x70, 0x77, 0xf0, 0xff, 0xbf, 0xd9, 0x80, 0x0f, 0xf0, 0xff, 0xbf, 0xb2,
   0xc0, 0x1f, 0x18, 0x00, 0x70, 0x62, 0xc0, 0x1f, 0xec, 0x7e, 0x6f, 0xc1,
   0xc0, 0x1f, 0xb6, 0x6a, 0xdb, 0x81, 0x80, 0x0f, 0xdb, 0x56, 0xb5, 0x01,
   0x00, 0x87, 0xad, 0x6a, 0x6b, 0x03, 0x00, 0xc0, 0xd6, 0x56, 0xd5, 0x06};

#define jack_d_width 47
#define jack_d_height 92
#define jack_d_x_hot -1
#define jack_d_y_hot -1
static char jack_d_bits[] = {
   0x00, 0xce, 0xed, 0x76, 0x0e, 0x00, 0x00, 0x9c, 0xed, 0x36, 0x87, 0x00,
   0x00, 0x38, 0x0c, 0x86, 0x83, 0x00, 0x01, 0xf0, 0xff, 0xff, 0xc1, 0x01,
   0x03, 0xf0, 0xff, 0xff, 0xc0, 0x01, 0x07, 0xb0, 0x02, 0xc0, 0xe0, 0x03,
   0x06, 0xa8, 0x42, 0xc0, 0xf0, 0x07, 0x05, 0xa8, 0x3e, 0xfc, 0xf0, 0x07,
   0x06, 0xa8, 0x82, 0xc2, 0xf8, 0x0f, 0x05, 0xaa, 0x7e, 0xfa, 0xfc, 0x1f,
   0x06, 0xab, 0x3a, 0xba, 0xfe, 0x3f, 0x85, 0xa9, 0x22, 0xa2, 0xfc, 0x1f,
   0x46, 0xa9, 0x02, 0xa2, 0xf8, 0x0f, 0xa5, 0xa8, 0x02, 0xa4, 0xf0, 0x07,
   0x9e, 0xa8, 0x02, 0xa7, 0xf0, 0x07, 0x47, 0xa8, 0x02, 0xa0, 0xe0, 0x03,
   0x22, 0xae, 0x22, 0xa0, 0xc0, 0x01, 0x10, 0xa9, 0xc2, 0xd7, 0xc3, 0x41,
   0x0d, 0xaf, 0x83, 0x91, 0x84, 0x60, 0x07, 0x61, 0x06, 0x28, 0x85, 0x70,
   0x85, 0x1e, 0x1c, 0x44, 0x0c, 0x30, 0xc4, 0x64, 0xf0, 0xc7, 0x37, 0x10,
   0x66, 0x99, 0x03, 0x38, 0xd3, 0x50, 0xf7, 0x66, 0xfc, 0xc7, 0xdc, 0x73,
   0xce, 0x8d, 0x03, 0x38, 0xde, 0x5d, 0xac, 0x3b, 0xfc, 0x87, 0xbf, 0x1d,
   0x17, 0xd7, 0x03, 0xf8, 0xbe, 0x3b, 0xb4, 0xee, 0xfe, 0xef, 0x76, 0x77,
   0x57, 0xdc, 0xbb, 0xbb, 0x76, 0x3e, 0xb4, 0xba, 0xee, 0xee, 0xf6, 0x1c,
   0x17, 0x69, 0xbb, 0xbb, 0xf6, 0x59, 0xb4, 0xda, 0xee, 0xee, 0xd6, 0x73,
   0x4f, 0xec, 0xbd, 0xbb, 0xf6, 0x57, 0xac, 0xda, 0xeb, 0xee, 0x16, 0x1f,
   0x1d, 0xe9, 0xb6, 0xbb, 0xf6, 0x3f, 0xaf, 0xda, 0xee, 0xee, 0x16, 0x78,
   0x55, 0xec, 0xdb, 0xbb, 0xf6, 0x3f, 0xbc, 0xda, 0xbb, 0xee, 0x16, 0x10,
   0x16, 0xe9, 0x6c, 0xbb, 0xf6, 0x5f, 0xaf, 0x7a, 0xd7, 0xee, 0x16, 0x78,
   0x76, 0x7c, 0xab, 0xbd, 0xf6, 0x57, 0xac, 0x9a, 0x5d, 0xeb, 0x56, 0x1c,
   0x35, 0xed, 0xa2, 0xb6, 0xf6, 0x37, 0xef, 0xee, 0x59, 0xed, 0xb6, 0x7b,
   0xb5, 0x73, 0xdb, 0xda, 0x5e, 0x37, 0x2c, 0xbd, 0x46, 0xb1, 0x5e, 0x1a,
   0x58, 0x7a, 0x8d, 0x62, 0xbd, 0x34, 0xec, 0x7a, 0x5b, 0xdb, 0xce, 0xad,
   0xde, 0x6d, 0xb7, 0x9a, 0x77, 0xf7, 0xec, 0x6f, 0x6d, 0x45, 0xb7, 0xac,
   0x38, 0x6a, 0xd7, 0xba, 0x59, 0x35, 0xea, 0x6f, 0xbd, 0xd5, 0x3e, 0x6e,
   0x1e, 0x68, 0x77, 0xeb, 0x5e, 0xf5, 0xfa, 0x6f, 0xdd, 0x36, 0x97, 0x68,
   0x08, 0x68, 0x77, 0xdd, 0x5b, 0x3d, 0xfc, 0x6f, 0xdd, 0xdb, 0x37, 0xaa,
   0x1e, 0x68, 0x77, 0x77, 0x5b, 0xf5, 0xfc, 0x6f, 0xdd, 0x6d, 0x97, 0xb8,
   0xf8, 0x68, 0x77, 0xd7, 0x5b, 0x35, 0xea, 0x6f, 0xdd, 0xbd, 0x37, 0xf2,
   0xce, 0x6b, 0x77, 0x77, 0x5b, 0x2d, 0x9a, 0x6f, 0xdd, 0xdd, 0x96, 0xe8,
   0x38, 0x6f, 0x77, 0x77, 0x5d, 0x2d, 0x7c, 0x6e, 0xdd, 0xdd, 0x3b, 0xea,
   0xee, 0x6e, 0xf7, 0x7f, 0x77, 0x2d, 0xdc, 0x7d, 0x1f, 0xc0, 0xeb, 0xe8,
   0xb8, 0xfd, 0xe1, 0x3f, 0xdc, 0x35, 0xba, 0x7b, 0x1c, 0xc0, 0xb1, 0x73,
   0xce, 0x3b, 0xe3, 0x3f, 0x66, 0xef, 0x0a, 0xcb, 0x1c, 0xc0, 0x99, 0x66,
   0x08, 0xec, 0xe3, 0x0f, 0x26, 0x23, 0x0c, 0x30, 0x22, 0x38, 0x78, 0xa1,
   0x0e, 0xa1, 0x14, 0x60, 0x86, 0xe0, 0x06, 0x21, 0x89, 0xc1, 0xf5, 0xb0,
   0x82, 0xc3, 0xeb, 0x43, 0x95, 0x08, 0x80, 0x03, 0x05, 0x44, 0x75, 0x44,
   0xc0, 0x07, 0x05, 0x40, 0x15, 0xe2, 0xe0, 0x0f, 0xe5, 0x40, 0x15, 0x79,
   0xe0, 0x0f, 0x25, 0x40, 0x15, 0xa5, 0xf0, 0x1f, 0x45, 0x40, 0x95, 0x62,
   0xf8, 0x3f, 0x45, 0x44, 0x95, 0xa1, 0xfc, 0x7f, 0x5d, 0x5c, 0xd5, 0x60,
   0xf8, 0x3f, 0x5f, 0x7e, 0x55, 0xa0, 0xf0, 0x1f, 0x43, 0x41, 0x15, 0x60,
   0xe0, 0x0f, 0x3f, 0x7c, 0x15, 0xa0, 0xe0, 0x0f, 0x03, 0x42, 0x15, 0x60,
   0xc0, 0x07, 0x03, 0x40, 0x0d, 0xe0, 0x80, 0x03, 0xff, 0xff, 0x0f, 0xc0,
   0x80, 0x83, 0xff, 0xff, 0x0f, 0x80, 0x00, 0xc1, 0x61, 0x30, 0x1c, 0x00,
   0x00, 0xe1, 0x6c, 0xb7, 0x39, 0x00, 0x00, 0x70, 0x6e, 0xb7, 0x73, 0x00};

#define jack_h_width 47
#define jack_h_height 92
#define jack_h_x_hot -1
#define jack_h_y_hot -1
static char jack_h_bits[] = {
   0x60, 0xca, 0x64, 0xca, 0x00, 0x00, 0xc0, 0xd4, 0x6a, 0x65, 0x00, 0x00,
   0x81, 0xc9, 0x64, 0x32, 0x07, 0x07, 0x03, 0xd3, 0x6a, 0x99, 0x8f, 0x0f,
   0x17, 0xc6, 0x60, 0xcc, 0xdf, 0x1f, 0x37, 0xfc, 0xff, 0xcf, 0xdf, 0x1f,
   0x57, 0xf8, 0xff, 0xcf, 0xff, 0x1f, 0x97, 0x50, 0x05, 0xc8, 0xff, 0x1f,
   0x37, 0x51, 0xe5, 0x85, 0xff, 0x0f, 0x3f, 0x51, 0xc5, 0x84, 0xff, 0x0f,
   0x6a, 0x51, 0xa5, 0x04, 0xff, 0x07, 0xaa, 0x51, 0xc5, 0x09, 0xfe, 0x03,
   0x6a, 0xa9, 0x02, 0x08, 0xfc, 0x01, 0x3f, 0xa9, 0x32, 0x10, 0xfc, 0x01,
   0x97, 0xa8, 0x12, 0x1b, 0xf8, 0x00, 0x57, 0x56, 0xe1, 0x04, 0x70, 0x00,
   0x37, 0x59, 0x01, 0x04, 0x70, 0x09, 0x97, 0x56, 0x81, 0x07, 0x20, 0x0f,
   0x87, 0x5a, 0x07, 0x0e, 0x24, 0x06, 0x07, 0xa7, 0x1a, 0x08, 0x09, 0x0d,
   0xc7, 0xfe, 0x75, 0x14, 0xf6, 0x0b, 0xf7, 0xff, 0xff, 0x3f, 0x88, 0x06,
   0x3f, 0x07, 0x00, 0xc0, 0x84, 0x01, 0x38, 0x8f, 0x44, 0x91, 0x41, 0x02,
   0xe7, 0x1e, 0xff, 0x7f, 0xa6, 0x0e, 0xde, 0x3f, 0x80, 0x00, 0x9c, 0x1a,
   0xb6, 0x73, 0xfe, 0x7f, 0x7e, 0x17, 0xd9, 0xf3, 0x44, 0x22, 0xf3, 0x0a,
   0xed, 0xee, 0x89, 0x91, 0x73, 0x07, 0x76, 0xfc, 0x53, 0xca, 0xdd, 0x06,
   0x3b, 0x39, 0x97, 0xe9, 0x7f, 0x1f, 0x9d, 0x3c, 0xaf, 0x75, 0xd6, 0x7a,
   0x4e, 0xee, 0x2e, 0x74, 0x6e, 0x6b, 0x27, 0xf7, 0x5f, 0xba, 0xd7, 0x6a,
   0x93, 0xaf, 0x59, 0xfa, 0x7b, 0x5b, 0xc9, 0xd5, 0xb9, 0x9d, 0xdd, 0x32,
   0xe4, 0xfa, 0xb7, 0x9d, 0x6b, 0x6b, 0x72, 0x1f, 0x7f, 0xee, 0xd7, 0x5a,
   0xf9, 0x26, 0x66, 0xfe, 0x7f, 0x37, 0x5c, 0xf3, 0x67, 0x66, 0xdc, 0x6e,
   0xaf, 0x09, 0x6e, 0x66, 0xb2, 0x5d, 0xf6, 0xfd, 0x7f, 0xf6, 0x67, 0x3b,
   0xed, 0xfa, 0x7f, 0xff, 0xcf, 0x76, 0xda, 0x4a, 0x24, 0x12, 0xd9, 0x2d,
   0xed, 0x8a, 0x94, 0x94, 0xa8, 0x57, 0xda, 0x6a, 0x4f, 0x79, 0xab, 0x2d,
   0xb4, 0xd5, 0x9e, 0xf2, 0x56, 0x5b, 0xea, 0x15, 0x29, 0x29, 0x51, 0xb7,
   0xb4, 0x9b, 0x48, 0x24, 0x52, 0x5b, 0x6e, 0xf3, 0xff, 0xfe, 0x5f, 0xb7,
   0xdc, 0xe6, 0x6f, 0xfe, 0xbf, 0x6f, 0xba, 0x4d, 0x66, 0x76, 0x90, 0xf5,
   0x76, 0x3b, 0x66, 0xe6, 0xcf, 0x3a, 0xec, 0xfe, 0x7f, 0x66, 0x64, 0x9f,
   0x5a, 0xeb, 0x77, 0xfe, 0xf8, 0x4e, 0xd6, 0xd6, 0xb9, 0xed, 0x5f, 0x27,
   0x4c, 0xbb, 0xb9, 0x9d, 0xab, 0x93, 0xda, 0xde, 0x5f, 0x9a, 0xf5, 0xc9,
   0x56, 0xeb, 0x5d, 0xfa, 0xef, 0xe4, 0xd6, 0x76, 0x2e, 0x74, 0x77, 0x72,
   0x5e, 0x6b, 0xae, 0xf5, 0x3c, 0xb9, 0xf8, 0xfe, 0x97, 0xe9, 0x9c, 0xdc,
   0x60, 0xbb, 0x53, 0xca, 0x3f, 0x6e, 0xe0, 0xce, 0x89, 0x91, 0x77, 0xb7,
   0x50, 0xcf, 0x44, 0x22, 0xcf, 0x9b, 0xe8, 0x7e, 0xfe, 0x7f, 0xce, 0x6d,
   0x58, 0x39, 0x00, 0x01, 0xfc, 0x7b, 0x70, 0x65, 0xfe, 0xff, 0x78, 0xe7,
   0x40, 0x82, 0x89, 0x22, 0xf1, 0x1c, 0x80, 0x21, 0x03, 0x00, 0xe0, 0xfc,
   0x60, 0x11, 0xfc, 0xff, 0xff, 0xef, 0xd0, 0x6f, 0x28, 0xae, 0x7f, 0xe3,
   0xb0, 0x90, 0x10, 0x58, 0xe5, 0xe0, 0x60, 0x24, 0x70, 0xe0, 0x5a, 0xe1,
   0xf0, 0x04, 0xe0, 0x81, 0x6a, 0xe9, 0x90, 0x0e, 0x20, 0x80, 0x9a, 0xec,
   0x00, 0x0e, 0x20, 0x87, 0x6a, 0xea, 0x00, 0x1f, 0xd8, 0x48, 0x15, 0xe9,
   0x80, 0x3f, 0x08, 0x4c, 0x95, 0xfc, 0x80, 0x3f, 0x10, 0x40, 0x95, 0x56,
   0xc0, 0x7f, 0x90, 0xa3, 0x8a, 0x55, 0xe0, 0xff, 0x20, 0xa5, 0x8a, 0x56,
   0xf0, 0xff, 0x21, 0xa3, 0x8a, 0xfc, 0xf0, 0xff, 0xa1, 0xa7, 0x8a, 0xec,
   0xf8, 0xff, 0x13, 0xa0, 0x0a, 0xe9, 0xf8, 0xff, 0xf3, 0xff, 0x1f, 0xea,
   0xf8, 0xfb, 0xf3, 0xff, 0x3f, 0xec, 0xf8, 0xfb, 0x33, 0x06, 0x63, 0xe8,
   0xf0, 0xf1, 0x99, 0x56, 0xcb, 0xc0, 0xe0, 0xe0, 0x4c, 0x26, 0x93, 0x81,
   0x00, 0x00, 0xa6, 0x56, 0x2b, 0x03, 0x00, 0x00, 0x53, 0x26, 0x53, 0x06};

#define jack_s_width 47
#define jack_s_height 92
#define jack_s_x_hot -1
#define jack_s_y_hot -1
static char jack_s_bits[] = {
   0xb8, 0xba, 0xee, 0xea, 0x40, 0x00, 0x70, 0x75, 0xd7, 0x75, 0xe0, 0x00,
   0xe4, 0xba, 0xee, 0x3a, 0xe0, 0x00, 0xca, 0x75, 0xd7, 0x1d, 0xf0, 0x01,
   0x8e, 0xff, 0xff, 0x0f, 0xf0, 0x01, 0x0e, 0xff, 0xff, 0x0f, 0xf8, 0x03,
   0x0a, 0x01, 0xa8, 0x0a, 0xfc, 0x07, 0x0a, 0xf1, 0xa8, 0x0a, 0xfe, 0x0f,
   0x0e, 0x09, 0xab, 0x0a, 0xff, 0x1f, 0x0e, 0x79, 0xa8, 0x0a, 0xff, 0x1f,
   0x0a, 0xb1, 0xa8, 0x8a, 0xff, 0x3f, 0x0e, 0x79, 0xa8, 0x8a, 0xff, 0x3f,
   0x8a, 0x00, 0xa8, 0x8a, 0xff, 0x3f, 0x95, 0x03, 0xa8, 0x8a, 0xff, 0x3f,
   0x0a, 0x99, 0xa8, 0x0a, 0x5f, 0x1f, 0x0e, 0x21, 0xa9, 0x0a, 0x4e, 0x0e,
   0x0a, 0xdf, 0xa8, 0x0a, 0xe0, 0x00, 0x0e, 0x0e, 0xa8, 0x0a, 0xf0, 0x01,
   0x0e, 0x02, 0xe8, 0x0e, 0x00, 0x00, 0x0a, 0x02, 0xbc, 0x3b, 0x00, 0x00,
   0x0a, 0x06, 0xeb, 0x2e, 0x00, 0x00, 0x0e, 0xfc, 0xbf, 0x3b, 0x00, 0x00,
   0x9e, 0x03, 0x00, 0xf8, 0x01, 0x00, 0xb1, 0x6d, 0xdb, 0x06, 0x07, 0x00,
   0x7e, 0x02, 0x00, 0x74, 0x19, 0x00, 0xd9, 0xff, 0xff, 0x77, 0xed, 0x00,
   0xce, 0xb4, 0xbb, 0x27, 0x67, 0x01, 0x55, 0xf9, 0xee, 0x06, 0x33, 0x07,
   0x32, 0xb0, 0xfb, 0x77, 0x99, 0x09, 0x39, 0xfe, 0xbf, 0x77, 0xcd, 0x3c,
   0x4d, 0x26, 0xa8, 0x24, 0x67, 0x66, 0xe6, 0x4a, 0x72, 0x06, 0x31, 0x3f,
   0xb3, 0xf1, 0xac, 0x75, 0xdd, 0x13, 0x98, 0xb1, 0x71, 0x74, 0xb7, 0x2c,
   0xef, 0xd2, 0xdb, 0x24, 0x89, 0x21, 0xa0, 0xf6, 0x04, 0x04, 0x27, 0x33,
   0x7c, 0x3e, 0xf9, 0xff, 0x89, 0x2d, 0x26, 0x4e, 0x5a, 0xd5, 0x22, 0x21,
   0x92, 0x93, 0xae, 0xea, 0x88, 0x33, 0xcb, 0xa4, 0xdb, 0x5d, 0x22, 0x2d,
   0x67, 0xc9, 0xe8, 0xae, 0x98, 0x21, 0x70, 0x32, 0x5a, 0x35, 0xb2, 0x72,
   0xbf, 0x8c, 0xa8, 0x9a, 0x9c, 0x3c, 0x38, 0x25, 0xfa, 0x2f, 0xa4, 0x31,
   0x4c, 0xda, 0x99, 0x0c, 0x57, 0x3a, 0x9c, 0x4f, 0x69, 0x4b, 0xf9, 0x1c,
   0x38, 0x9f, 0xd2, 0x96, 0xf2, 0x39, 0x5c, 0xea, 0x30, 0x99, 0x5b, 0x32,
   0x8c, 0x25, 0xf4, 0x5f, 0xa4, 0x1c, 0x3c, 0x39, 0x59, 0x15, 0x31, 0xfd,
   0x4e, 0x4d, 0xac, 0x5a, 0x4c, 0x0e, 0x84, 0x19, 0x75, 0x17, 0x93, 0xe6,
   0xb4, 0x44, 0xba, 0xdb, 0x25, 0xd3, 0xcc, 0x11, 0x57, 0x75, 0xc9, 0x49,
   0x84, 0x44, 0xab, 0x5a, 0x72, 0x64, 0xb4, 0x91, 0xff, 0x9f, 0x7c, 0x3e,
   0xcc, 0xe4, 0x20, 0x20, 0x6f, 0x05, 0x84, 0x91, 0x24, 0xdb, 0x4b, 0xf7,
   0x34, 0xed, 0x2e, 0x8e, 0x8d, 0x19, 0xc8, 0xbb, 0xae, 0x35, 0x8f, 0xcd,
   0xfc, 0x8c, 0x60, 0x4e, 0x52, 0x67, 0x66, 0xe6, 0x24, 0x15, 0x64, 0xb2,
   0x3c, 0xb3, 0xee, 0xfd, 0x7f, 0x9c, 0x90, 0x99, 0xee, 0xdf, 0x0d, 0x4c,
   0xe0, 0xcc, 0x60, 0x77, 0x9f, 0xaa, 0x80, 0xe6, 0xe4, 0xdd, 0x2d, 0x73,
   0x00, 0xb7, 0xee, 0xff, 0xff, 0x9b, 0x00, 0x98, 0x2e, 0x00, 0x40, 0x7e,
   0x00, 0xe0, 0x60, 0xdb, 0xb6, 0x8d, 0x00, 0x80, 0x1f, 0x00, 0xc0, 0x79,
   0x00, 0x00, 0xdc, 0xfd, 0x3f, 0x70, 0x00, 0x00, 0x74, 0xd7, 0x60, 0x50,
   0x00, 0x00, 0xdc, 0x3d, 0x40, 0x50, 0x00, 0x00, 0x70, 0x17, 0x40, 0x70,
   0x80, 0x0f, 0x50, 0x15, 0x70, 0x70, 0x00, 0x07, 0x50, 0x15, 0xfb, 0x50,
   0x70, 0x72, 0x50, 0x95, 0x84, 0x70, 0xf8, 0xfa, 0x50, 0x15, 0x99, 0x50,
   0xfc, 0xff, 0x51, 0x15, 0xc0, 0xa9, 0xfc, 0xff, 0x51, 0x15, 0x00, 0x51,
   0xfc, 0xff, 0x51, 0x15, 0x9e, 0x70, 0xfc, 0xff, 0x51, 0x15, 0x8d, 0x50,
   0xf8, 0xff, 0x50, 0x15, 0x9e, 0x70, 0xf8, 0xff, 0x50, 0xd5, 0x90, 0x70,
   0xf0, 0x7f, 0x50, 0x15, 0x8f, 0x50, 0xe0, 0x3f, 0x50, 0x15, 0x80, 0x50,
   0xc0, 0x1f, 0xf0, 0xff, 0xff, 0x70, 0x80, 0x0f, 0xf0, 0xff, 0xff, 0x71,
   0x80, 0x0f, 0xb8, 0xeb, 0xae, 0x53, 0x00, 0x07, 0x5c, 0x77, 0x5d, 0x27,
   0x00, 0x07, 0xae, 0xeb, 0xae, 0x0e, 0x00, 0x02, 0x57, 0x77, 0x5d, 0x1d};

#define rank_width 9
#define rank_height 14
static char rank_bits[13][28] = {
   0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x6c, 0x00, 0x6c, 0x00, 0x6c, 0x00,
   0x6c, 0x00, 0xc6, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xc6, 0x00, 0x83, 0x01,
   0x83, 0x01, 0x83, 0x01,
   0x7c, 0x00, 0xfe, 0x00, 0xc7, 0x01, 0x83, 0x01, 0x80, 0x01, 0xc0, 0x01,
   0xe0, 0x00, 0x70, 0x00, 0x38, 0x00, 0x1c, 0x00, 0x0e, 0x00, 0x87, 0x01,
   0xff, 0x01, 0xff, 0x01,
   0xff, 0x01, 0xff, 0x01, 0xc3, 0x01, 0xe0, 0x00, 0x70, 0x00, 0x78, 0x00,
   0xfc, 0x00, 0xc8, 0x01, 0x80, 0x01, 0x80, 0x01, 0x82, 0x01, 0xc7, 0x01,
   0xfe, 0x00, 0x7c, 0x00,
   0xe0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xd8, 0x00, 0xd8, 0x00, 0xcc, 0x00,
   0xcc, 0x00, 0xc6, 0x00, 0xc6, 0x00, 0xff, 0x01, 0xff, 0x01, 0xc0, 0x00,
   0xe0, 0x01, 0xe0, 0x01,
   0xff, 0x00, 0xff, 0x00, 0x03, 0x00, 0x03, 0x00, 0x7b, 0x00, 0xff, 0x00,
   0xc7, 0x01, 0x82, 0x01, 0x80, 0x01, 0x80, 0x01, 0x82, 0x01, 0xc7, 0x01,
   0xfe, 0x00, 0x7c, 0x00,
   0x7c, 0x00, 0xfe, 0x00, 0xc7, 0x01, 0x83, 0x00, 0x03, 0x00, 0x7b, 0x00,
   0xff, 0x00, 0xc7, 0x01, 0x83, 0x01, 0x83, 0x01, 0x83, 0x01, 0xc7, 0x01,
   0xfe, 0x00, 0x7c, 0x00,
   0xff, 0x01, 0xff, 0x01, 0x83, 0x01, 0xc0, 0x00, 0xc0, 0x00, 0x60, 0x00,
   0x60, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x18, 0x00, 0x18, 0x00,
   0x18, 0x00, 0x18, 0x00,
   0x7c, 0x00, 0xfe, 0x00, 0xc7, 0x01, 0x83, 0x01, 0xc7, 0x01, 0xfe, 0x00,
   0x7c, 0x00, 0xfe, 0x00, 0xc7, 0x01, 0x83, 0x01, 0x83, 0x01, 0xc7, 0x01,
   0xfe, 0x00, 0x7c, 0x00,
   0x7c, 0x00, 0xfe, 0x00, 0xc7, 0x01, 0x83, 0x01, 0x83, 0x01, 0x83, 0x01,
   0xc7, 0x01, 0xfe, 0x01, 0xbc, 0x01, 0x80, 0x01, 0x82, 0x01, 0xc7, 0x01,
   0xfe, 0x00, 0x7c, 0x00,
   0xf3, 0x00, 0xfb, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01,
   0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01,
   0xfb, 0x01, 0xf3, 0x00,
   0xe0, 0x01, 0xe0, 0x01, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00,
   0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc3, 0x00, 0xc3, 0x00, 0xe7, 0x00,
   0x7e, 0x00, 0x3c, 0x00,
   0x38, 0x00, 0x7c, 0x00, 0xee, 0x00, 0xc6, 0x00, 0xc6, 0x00, 0xc6, 0x00,
   0xc6, 0x00, 0xc6, 0x00, 0xdf, 0x00, 0xff, 0x00, 0xf6, 0x00, 0xee, 0x00,
   0xfc, 0x01, 0xb8, 0x00,
   0xef, 0x01, 0xef, 0x01, 0xe6, 0x00, 0x76, 0x00, 0x3e, 0x00, 0x1e, 0x00,
   0x1e, 0x00, 0x3e, 0x00, 0x36, 0x00, 0x76, 0x00, 0x66, 0x00, 0xe6, 0x00,
   0xef, 0x01, 0xef, 0x01};

#define spade_width 15
#define spade_height 19
#define spade_x_hot -1
#define spade_y_hot -1
static char spade_bits[] = {
   0x80, 0x00, 0x80, 0x00, 0xc0, 0x01, 0xc0, 0x01, 0xe0, 0x03, 0xf0, 0x07,
   0xf0, 0x07, 0xf8, 0x0f, 0xfc, 0x1f, 0xfe, 0x3f, 0xfe, 0x3f, 0xff, 0x7f,
   0xff, 0x7f, 0xff, 0x7f, 0xff, 0x7f, 0xbe, 0x3e, 0x9c, 0x1c, 0xc0, 0x01,
   0xe0, 0x03};
#define spade_lg_width 39
#define spade_lg_height 52
#define spade_lg_x_hot -1
#define spade_lg_y_hot -1
static char spade_lg_bits[] = {
   0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,
   0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00,
   0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x7f,
   0x00, 0x00, 0x00, 0x80, 0xff, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x01, 0x00,
   0x00, 0xc0, 0xff, 0x01, 0x00, 0x00, 0xe0, 0xff, 0x03, 0x00, 0x00, 0xf0,
   0xff, 0x07, 0x00, 0x00, 0xf0, 0xff, 0x07, 0x00, 0x00, 0xf8, 0xff, 0x0f,
   0x00, 0x00, 0xfc, 0xff, 0x1f, 0x00, 0x00, 0xfe, 0xff, 0x3f, 0x00, 0x00,
   0xff, 0xff, 0x7f, 0x00, 0x80, 0xff, 0xff, 0xff, 0x00, 0xc0, 0xff, 0xff,
   0xff, 0x01, 0xe0, 0xff, 0xff, 0xff, 0x03, 0xf0, 0xff, 0xff, 0xff, 0x07,
   0xf8, 0xff, 0xff, 0xff, 0x0f, 0xf8, 0xff, 0xff, 0xff, 0x0f, 0xfc, 0xff,
   0xff, 0xff, 0x1f, 0xfc, 0xff, 0xff, 0xff, 0x1f, 0xfe, 0xff, 0xff, 0xff,
   0x3f, 0xfe, 0xff, 0xff, 0xff, 0x3f, 0xfe, 0xff, 0xff, 0xff, 0x3f, 0xff,
   0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff,
   0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x7f,
   0xfe, 0xff, 0xff, 0xff, 0x3f, 0xfe, 0xff, 0xff, 0xff, 0x3f, 0xfc, 0xff,
   0xbe, 0xff, 0x1f, 0xfc, 0x7f, 0x1c, 0xff, 0x1f, 0xf8, 0x3f, 0x1c, 0xfe,
   0x0f, 0xf0, 0x1f, 0x1c, 0xfc, 0x07, 0xc0, 0x07, 0x1c, 0xf0, 0x01, 0x00,
   0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x3e,
   0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00,
   0x00, 0x80, 0xff, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x01, 0x00, 0x00, 0xe0,
   0xff, 0x03, 0x00, 0x00, 0xf0, 0xff, 0x07, 0x00};

#define spade_sm_width 9
#define spade_sm_height 12
#define spade_sm_x_hot -1
#define spade_sm_y_hot -1
static char spade_sm_bits[] = {
   0x10, 0x00, 0x10, 0x00, 0x38, 0x00, 0x38, 0x00, 0x7c, 0x00, 0xfe, 0x00,
   0xff, 0x01, 0xff, 0x01, 0xff, 0x01, 0xd6, 0x00, 0x10, 0x00, 0x38, 0x00};

#define heart_width 15
#define heart_height 17
#define heart_x_hot -1
#define heart_y_hot -1
static char heart_bits[] = {
   0x1c, 0x1c, 0x3e, 0x3e, 0x7f, 0x7f, 0x7f, 0x7f, 0xff, 0x7f, 0xff, 0x7f,
   0xfe, 0x3f, 0xfe, 0x3f, 0xfc, 0x1f, 0xf8, 0x0f, 0xf0, 0x07, 0xf0, 0x07,
   0xe0, 0x03, 0xc0, 0x01, 0xc0, 0x01, 0x80, 0x00, 0x80, 0x00};

#define heart_sm_width 9
#define heart_sm_height 11
#define heart_sm_x_hot -1
#define heart_sm_y_hot -1
static char heart_sm_bits[] = {
   0xc6, 0x00, 0xef, 0x01, 0xff, 0x01, 0xff, 0x01, 0xfe, 0x00, 0xfe, 0x00,
   0x7c, 0x00, 0x38, 0x00, 0x38, 0x00, 0x10, 0x00, 0x10, 0x00};

#define club_width 15
#define club_height 16
#define club_x_hot -1
#define club_y_hot -1
static char club_bits[] = {
   0xc0, 0x81, 0xe0, 0x83, 0xf0, 0x87, 0xf0, 0x87, 0xf0, 0x87, 0xe0, 0x83,
   0xdc, 0x9d, 0xfe, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x3e,
   0x9c, 0x1c, 0xc0, 0x81, 0xc0, 0x81, 0xe0, 0x83};

#define club_sm_width 9
#define club_sm_height 11
#define club_sm_x_hot -1
#define club_sm_y_hot -1
static char club_sm_bits[] = {
   0x38, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x38, 0x00, 0xd6, 0x00, 0xff, 0x81,
   0xff, 0x81, 0xff, 0x81, 0xd6, 0x00, 0x00, 0x00, 0x38, 0x00};

#define diamond_width 13
#define diamond_height 19
#define diamond_x_hot -1
#define diamond_y_hot -1
static char diamond_bits[] = {
   0x40, 0x00, 0x40, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xf0, 0x01, 0xf8, 0x03,
   0xf8, 0x03, 0xfc, 0x07, 0xfe, 0x0f, 0xff, 0x1f, 0xfe, 0x0f, 0xfc, 0x07,
   0xf8, 0x03, 0xf8, 0x03, 0xf0, 0x01, 0xe0, 0x00, 0xe0, 0x00, 0x40, 0x00,
   0x40, 0x00};

#define diamond_sm_width 7
#define diamond_sm_height 12
#define diamond_sm_x_hot -1
#define diamond_sm_y_hot -1
static char diamond_sm_bits[] = {
   0x08, 0x08, 0x1c, 0x1c, 0x3e, 0x7f, 0x3e, 0x1c, 0x1c, 0x08, 0x08, 0x00};
