/***************************************************************************
 *
 * FILE NAME		: image.c
 *
 * AUTHOR		: Andrew Peebles
 *
 * DESCRIPTION		: Contains Xm routines for pixmap handling
 *
 * VERSIONS		: %W%
 *
 ***************************************************************************/

/*
 * standard includes
 */
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <Xm/Xm.h>
#include "image.h"

/*
 * Function:
 */
Boolean
CreateAndInstallPixmap (bits, width, height, name)
/*
 * Takes arguments from a bitmap include file, creates an image
 * from the data and stores it in the PIXMAP cache under name.
 * These pixmaps can then be retrieved with GetPixmap and used
 * for button labels, etc.
 */
char	*bits;
int	width, height;
char	*name;
{
    XImage *image;

    image = (XImage *) XtMalloc (sizeof (XImage));
    image->width = width;
    image->height = height;
    image->data = bits;
    image->depth = 1;
    image->xoffset = 0;
    image->format = XYBitmap;
    image->byte_order = LSBFirst;
    image->bitmap_unit = 8;
    image->bitmap_bit_order = LSBFirst;
    image->bitmap_pad = 8;
    image->bytes_per_line = (width+7)/8;

    return (XmInstallImage (image, name));
}

/*
 * Function:
 */
Pixmap
GetPixmap (w, name)
/*
 * Used to retrieve pixmaps stored in the PIXMAP cache.  Returns
 * a pixmap id.  Uses the pasted in widget to calculate the foreground
 * and background values of the pixmap.
 */
Widget	w;
char	*name;
{
  Pixmap	p;
  Arg		args[5];
  Pixel		f,b;

  XtSetArg (args[0], XmNforeground, &f);
  XtSetArg (args[1], XmNbackground, &b);
  XtGetValues (w, args, 2);
  p = XmGetPixmap (w->core.screen,
		   name,
		   f, b);
  return (p);
}

/*
 * Function:
 */
void
InstallDefaultPixmaps ()
/*
 * Install some default pixmaps in the PIXMAP cache.  These
 * are the dialog pixmaps used by the Motif dialog widget set.
 * They can be retrieved with the function GetPixmap with the
 * following names:
 *
 *	xm_error
 *	xm_warning
 *	xm_question
 *	xm_info
 *	xm_working
 */
{
  XImage	*image;

  CreateAndInstallPixmap (errorBits,
			  errorWidth,
			  errorHeight,
			  "xm_error");

  CreateAndInstallPixmap (infoBits,
			  infoWidth,
			  infoHeight,
			  "xm_info");

  CreateAndInstallPixmap (questionBits,
			  questionWidth,
			  questionHeight,
			  "xm_question");

  CreateAndInstallPixmap (warningBits,
			  warningWidth,
			  warningHeight,
			  "xm_warning");

  CreateAndInstallPixmap (workingBits,
			  workingWidth,
			  workingHeight,
			  "xm_working");

}

/*
 * Function:
 */
XImage *
MakeImage (width, height, data)
/*
 * takes arguments from a bitmap include file and returns an XImage
 * pointer to that data.
 */
int	width, height;
char	*data;
{
  XImage	*image;

      image = (XImage *) XtMalloc (sizeof (XImage));
      image->width = width;
      image->height = height;
      image->data = data;
      image->depth = 1;
      image->xoffset = 0;
      image->format = XYBitmap;
      image->byte_order = LSBFirst;
      image->bitmap_unit = 8;
      image->bitmap_bit_order = LSBFirst;
      image->bitmap_pad = 8;
      image->bytes_per_line = (width+7)/8;
      return (image);
}

