include Equal440.sc
include bassdrum.spi
include hitom.spi
include lowtom.spi
include openhi.spi
include snare.spi
include closedhi.spi
include hiconga.spi
include loconga.spi
include pulse.spi
include weird.spi
include sawbop.spi
include bop.spi
include bell.spi

wave square
{
	1
	0
}

instrument drum1 
{
	out : adsr $noteon $gate 0.01 0.2 0.0 0.0
		{filter 
			{add {random 0.3} {osc &sine {add 50 {random 30}} 0.6}}
		10 1 10};
}

instrument drum2 -- freq, timeto16th
{
	out : adsr $noteon $gate 0.01 0.2 0.0 0.0
		{filter {random 0.3} {expodecay $noteon $0 $1 1} 1 5};
}


instrument bassthing durationadd 0.3
{
	-- OK, we have a filtered mix of a square wave and
	-- a sine wave, the square wave at half the instrument
	-- pitch and quieter.

	-- The filter uses a expodecay falling from the frequency of the
	-- note being played to zero, giving a "beeowww" sort of thing.
	-- The filter gain is 6 + a random number which starts at 1
	-- and decays very rapidly, to give a noisy transient. In an
	-- ideal world, with lots of room for samples in the archive,
	-- I would have used one to generate this transient.

	%freq: mul $freq 2;	-- shift up an octave

	out:
		adsr $noteon $gate 0.01 0.1 0.9 0.3 
			{filter
				{mul
					{mix
						{osc &square %freq 0.5}
						{osc &sine {mul %freq 2} 1}
					}
					0.1
				}
				{expodecay $noteon %freq 0.1 1}
				{add {expodecay $noteon %freq 0.02 {random 1}} 6}
				0.1
		};

}

pan1: osc &sine 0.1 0.8;
pan2: osc &sine 0.16 0.8;
pan3: osc &sine 0.09 0.8;
druml,drumr:
	stereomix
		{instance druminst35 2 of bassdrum} -0.5 4				-- bass
		{instance druminst38 2 of snare} 1 4				-- snare
		{instance druminst42 2 of closedhi} 0.2 4		-- closed hi
		{instance druminst46 2 of openhi} -0.2 4		-- open hi
		{instance druminst60 2 of hitom} pan3 4		-- high bongo
		{instance druminst61 2 of lowtom} {sub 1 pan3} 4		-- low bongo
		{instance druminst62 2 of hiconga} -0.5 4		-- mute hi conga
		{instance druminst64 2 of loconga} -0.5 4;	-- low conga

CH0,CH1:
	stereomix
		{instance inst1 4 of bassthing} pan1 6				-- synthbass
		{instance inst2 8 of bell} pan2 6					-- strings
		{instance inst4 8 of sawbop} {sub 1 pan2} 3			-- lead
		{instance inst5 4 of pulse} 0 6						-- lead
		{instance inst6 4 of weird 0.8 3.5} 0.4 4			-- piano, chor.
		{instance inst7 4 of weird 0.7 1.75} -0.4 4			-- brass
		druml -1 2
		drumr 1 2;

-- Sapphire score generated from ../test.mid by mid2sapp $Revision: 1.3 $
-- drum tracks : 9

tempo 148;
-- WARNING - tempo change to 149 at 1536
-- WARNING - tempo change to 150 at 3072
-- WARNING - tempo change to 150 at 4608
-- WARNING - tempo change to 149 at 6144
-- WARNING - tempo change to 148 at 7680
-- WARNING - tempo change to 147 at 9216
-- WARNING - tempo change to 147 at 10752
-- WARNING - tempo change to 147 at 12288
-- WARNING - tempo change to 146 at 13824
-- WARNING - tempo change to 145 at 15360
-- WARNING - tempo change to 144 at 16896
-- WARNING - tempo change to 143 at 18432
-- WARNING - tempo change to 142 at 19968
-- WARNING - tempo change to 141 at 21504
-- WARNING - tempo change to 141 at 23040
-- WARNING - tempo change to 141 at 24576
-- WARNING - tempo change to 140 at 26112
-- WARNING - tempo change to 140 at 27648
-- WARNING - tempo change to 139 at 29184
-- WARNING - tempo change to 138 at 30720
-- WARNING - tempo change to 137 at 32256
-- WARNING - tempo change to 137 at 33792
-- WARNING - tempo change to 137 at 35328
-- WARNING - tempo change to 137 at 36864
-- WARNING - tempo change to 136 at 38400
-- WARNING - tempo change to 136 at 39936
-- WARNING - tempo change to 136 at 41472
-- WARNING - tempo change to 135 at 43008
-- WARNING - tempo change to 134 at 44544
-- WARNING - tempo change to 133 at 46080
-- WARNING - tempo change to 132 at 47616
-- WARNING - tempo change to 131 at 49152
-- WARNING - tempo change to 130 at 50688
-- WARNING - tempo change to 130 at 52224
-- WARNING - tempo change to 129 at 53760
-- WARNING - tempo change to 129 at 55296
-- WARNING - tempo change to 130 at 56832
-- WARNING - tempo change to 130 at 58368
-- WARNING - tempo change to 129 at 59904
-- WARNING - tempo change to 128 at 61440
-- WARNING - tempo change to 127 at 62976
-- WARNING - tempo change to 126 at 64512
-- WARNING - tempo change to 125 at 66048
-- WARNING - tempo change to 124 at 67584
-- WARNING - tempo change to 123 at 69120
-- WARNING - tempo change to 122 at 70656
-- WARNING - tempo change to 121 at 72192
-- WARNING - tempo change to 120 at 73728
-- WARNING - tempo change to 119 at 75264
-- WARNING - tempo change to 118 at 76800
-- WARNING - tempo change to 117 at 78336

--OTHER : 0 Program 1 38
note /00:00:4608/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:4632/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:4656/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:4680/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:4728/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:4752/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:4800/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:4848/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:4872/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:4896/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:4920/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:4968/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:4992/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:5016/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:5040/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:5064/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:5112/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:5136/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:5184/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:5232/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:5256/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:5280/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:5304/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:5352/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:5376/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:5400/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:5424/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:5448/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:5496/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:5520/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:5568/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:5616/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:5640/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:5664/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:5688/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:5736/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:5760/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:5784/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:5808/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:5832/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:5880/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:5904/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:5952/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:6000/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:6024/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:6048/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:6072/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:6120/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:6144/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:6168/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:6192/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:6216/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:6264/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:6288/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:6336/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:6384/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:6408/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:6432/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:6456/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:6504/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:6528/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:6552/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:6576/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:6600/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:6648/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:6672/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:6720/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:6768/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:6792/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:6816/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:6840/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:6888/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:6912/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:6936/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:6960/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:6984/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:7032/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:7056/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:7104/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:7152/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:7176/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:7200/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:7224/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:7272/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:7296/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:7320/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:7344/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:7368/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:7416/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:7440/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:7488/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:7536/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:7560/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:7584/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:7608/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:7656/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:7680/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:7704/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:7728/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:7752/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:7800/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:7824/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:7872/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:7920/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:7944/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:7968/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:7992/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:8040/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:8064/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:8088/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:8112/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:8136/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:8184/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:8208/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:8256/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:8304/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:8328/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:8352/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:8376/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:8424/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:8448/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:8472/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:8496/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:8520/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:8568/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:8592/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:8640/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:8688/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:8712/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:8736/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:8760/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:8808/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:8832/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:8856/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:8880/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:8904/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:8952/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:8976/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:9024/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:9072/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:9096/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:9120/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:9144/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:9192/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:9216/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:9240/ inst1 Equal440 e0 /00:00:24/ 0.734375;
note /00:00:9264/ inst1 Equal440 c0 /00:00:24/ 0.726562;
note /00:00:9288/ inst1 Equal440 e0 /00:00:24/ 0.710938;
note /00:00:9336/ inst1 Equal440 c0 /00:00:24/ 0.6875;
note /00:00:9360/ inst1 Equal440 e0 /00:00:24/ 0.679688;
note /00:00:9408/ inst1 Equal440 e0 /00:00:24/ 0.65625;
note /00:00:9456/ inst1 Equal440 e0 /00:00:24/ 0.632812;
note /00:00:9480/ inst1 Equal440 e0 /00:00:24/ 0.617188;
note /00:00:9504/ inst1 Equal440 c0 /00:00:24/ 0.609375;
note /00:00:9528/ inst1 Equal440 e0 /00:00:24/ 0.59375;
note /00:00:9576/ inst1 Equal440 e0 /00:00:24/ 0.570312;
note /00:00:9600/ inst1 Equal440 a-1 /00:00:24/ 0.5625;
note /00:00:9624/ inst1 Equal440 c#0 /00:00:24/ 0.546875;
note /00:00:9648/ inst1 Equal440 a-1 /00:00:24/ 0.539062;
note /00:00:9672/ inst1 Equal440 c#0 /00:00:24/ 0.523438;
note /00:00:9720/ inst1 Equal440 a-1 /00:00:24/ 0.5;
note /00:00:9744/ inst1 Equal440 c#0 /00:00:24/ 0.492188;
note /00:00:9792/ inst1 Equal440 c#0 /00:00:24/ 0.46875;
note /00:00:9840/ inst1 Equal440 c#0 /00:00:24/ 0.445312;
note /00:00:9864/ inst1 Equal440 c#0 /00:00:24/ 0.429688;
note /00:00:9888/ inst1 Equal440 a-1 /00:00:24/ 0.421875;
note /00:00:9912/ inst1 Equal440 c#0 /00:00:24/ 0.40625;
note /00:00:9960/ inst1 Equal440 c#0 /00:00:24/ 0.382812;
note /00:00:9984/ inst1 Equal440 a#-1 /00:00:24/ 0.375;
note /00:00:10008/ inst1 Equal440 d0 /00:00:24/ 0.359375;
note /00:00:10032/ inst1 Equal440 a#-1 /00:00:24/ 0.351562;
note /00:00:10056/ inst1 Equal440 d0 /00:00:24/ 0.335938;
note /00:00:10104/ inst1 Equal440 a#-1 /00:00:24/ 0.3125;
note /00:00:10128/ inst1 Equal440 d0 /00:00:24/ 0.304688;
note /00:00:10176/ inst1 Equal440 d0 /00:00:24/ 0.28125;
note /00:00:10224/ inst1 Equal440 d0 /00:00:24/ 0.257812;
note /00:00:10248/ inst1 Equal440 d0 /00:00:24/ 0.242188;
note /00:00:10272/ inst1 Equal440 a#-1 /00:00:24/ 0.234375;
note /00:00:10296/ inst1 Equal440 d0 /00:00:24/ 0.21875;
note /00:00:10344/ inst1 Equal440 d0 /00:00:24/ 0.195312;
note /00:00:10368/ inst1 Equal440 g-1 /00:00:24/ 0.1875;
note /00:00:10392/ inst1 Equal440 b-1 /00:00:24/ 0.171875;
note /00:00:10416/ inst1 Equal440 g-1 /00:00:24/ 0.164062;
note /00:00:10440/ inst1 Equal440 b-1 /00:00:24/ 0.148438;
note /00:00:10488/ inst1 Equal440 g-1 /00:00:24/ 0.125;
note /00:00:10512/ inst1 Equal440 b-1 /00:00:24/ 0.117188;
note /00:00:10560/ inst1 Equal440 b-1 /00:00:24/ 0.09375;
note /00:00:10608/ inst1 Equal440 b-1 /00:00:24/ 0.0703125;
note /00:00:10632/ inst1 Equal440 b-1 /00:00:24/ 0.0546875;
note /00:00:10656/ inst1 Equal440 g-1 /00:00:24/ 0.046875;
note /00:00:10680/ inst1 Equal440 b-1 /00:00:24/ 0.03125;
note /00:00:10728/ inst1 Equal440 b-1 /00:00:24/ 0.0078125;
--OTHER : 10752 Program 1 39
note /00:00:10776/ inst1 Equal440 e0 /00:00:24/ 0.0078125;
note /00:00:10800/ inst1 Equal440 c0 /00:00:24/ 0.0234375;
note /00:00:10824/ inst1 Equal440 e0 /00:00:24/ 0.03125;
note /00:00:10872/ inst1 Equal440 c0 /00:00:24/ 0.0546875;
note /00:00:10896/ inst1 Equal440 e0 /00:00:24/ 0.0703125;
note /00:00:10944/ inst1 Equal440 e0 /00:00:24/ 0.09375;
note /00:00:10992/ inst1 Equal440 e0 /00:00:24/ 0.117188;
note /00:00:11016/ inst1 Equal440 e0 /00:00:24/ 0.125;
note /00:00:11040/ inst1 Equal440 c0 /00:00:24/ 0.140625;
note /00:00:11064/ inst1 Equal440 e0 /00:00:24/ 0.148438;
note /00:00:11112/ inst1 Equal440 e0 /00:00:24/ 0.171875;
note /00:00:11136/ inst1 Equal440 a-1 /00:00:24/ 0.1875;
note /00:00:11160/ inst1 Equal440 c#0 /00:00:24/ 0.195312;
note /00:00:11184/ inst1 Equal440 a-1 /00:00:24/ 0.210938;
note /00:00:11208/ inst1 Equal440 c#0 /00:00:24/ 0.21875;
note /00:00:11256/ inst1 Equal440 a-1 /00:00:24/ 0.242188;
note /00:00:11280/ inst1 Equal440 c#0 /00:00:24/ 0.257812;
note /00:00:11328/ inst1 Equal440 c#0 /00:00:24/ 0.28125;
note /00:00:11376/ inst1 Equal440 c#0 /00:00:24/ 0.304688;
note /00:00:11400/ inst1 Equal440 c#0 /00:00:24/ 0.3125;
note /00:00:11424/ inst1 Equal440 a-1 /00:00:24/ 0.328125;
note /00:00:11448/ inst1 Equal440 c#0 /00:00:24/ 0.335938;
note /00:00:11496/ inst1 Equal440 c#0 /00:00:24/ 0.359375;
note /00:00:11520/ inst1 Equal440 a#-1 /00:00:24/ 0.375;
note /00:00:11544/ inst1 Equal440 d0 /00:00:24/ 0.382812;
note /00:00:11568/ inst1 Equal440 a#-1 /00:00:24/ 0.398438;
note /00:00:11592/ inst1 Equal440 d0 /00:00:24/ 0.40625;
note /00:00:11640/ inst1 Equal440 a#-1 /00:00:24/ 0.429688;
note /00:00:11664/ inst1 Equal440 d0 /00:00:24/ 0.445312;
note /00:00:11712/ inst1 Equal440 d0 /00:00:24/ 0.46875;
note /00:00:11760/ inst1 Equal440 d0 /00:00:24/ 0.492188;
note /00:00:11784/ inst1 Equal440 d0 /00:00:24/ 0.5;
note /00:00:11808/ inst1 Equal440 a#-1 /00:00:24/ 0.515625;
note /00:00:11832/ inst1 Equal440 d0 /00:00:24/ 0.523438;
note /00:00:11880/ inst1 Equal440 d0 /00:00:24/ 0.546875;
note /00:00:11904/ inst1 Equal440 g-1 /00:00:24/ 0.5625;
note /00:00:11928/ inst1 Equal440 b-1 /00:00:24/ 0.570312;
note /00:00:11952/ inst1 Equal440 g-1 /00:00:24/ 0.585938;
note /00:00:11976/ inst1 Equal440 b-1 /00:00:24/ 0.59375;
note /00:00:12024/ inst1 Equal440 g-1 /00:00:24/ 0.617188;
note /00:00:12048/ inst1 Equal440 b-1 /00:00:24/ 0.632812;
note /00:00:12096/ inst1 Equal440 b-1 /00:00:24/ 0.65625;
note /00:00:12144/ inst1 Equal440 b-1 /00:00:24/ 0.679688;
note /00:00:12168/ inst1 Equal440 b-1 /00:00:24/ 0.6875;
note /00:00:12192/ inst1 Equal440 g-1 /00:00:24/ 0.703125;
note /00:00:12216/ inst1 Equal440 b-1 /00:00:24/ 0.710938;
note /00:00:12264/ inst1 Equal440 b-1 /00:00:24/ 0.734375;
note /00:00:12288/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:12312/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:12336/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:12360/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:12408/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:12432/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:12480/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:12528/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:12552/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:12576/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:12600/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:12648/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:12672/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:12696/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:12720/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:12744/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:12792/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:12816/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:12864/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:12912/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:12936/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:12960/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:12984/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:13032/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:13056/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:13080/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:13104/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:13128/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:13176/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:13200/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:13248/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:13296/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:13320/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:13344/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:13368/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:13416/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:13440/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:13464/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:13488/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:13512/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:13560/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:13584/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:13632/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:13680/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:13704/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:13728/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:13752/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:13800/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:13824/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:13848/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:13872/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:13896/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:13944/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:13968/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:14016/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:14064/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:14088/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:14112/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:14136/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:14184/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:14208/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:14232/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:14256/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:14280/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:14328/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:14352/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:14400/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:14448/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:14472/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:14496/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:14520/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:14568/ inst1 Equal440 c#0 /00:00:24/ 0.75;
note /00:00:14592/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:14616/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:14640/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:14664/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:14712/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:14736/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:14784/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:14832/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:14856/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:14880/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:14904/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:14952/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:14976/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:15000/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:15024/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:15048/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:15096/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:15120/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:15168/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:15216/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:15240/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:15264/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:15288/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:15336/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:35328/ inst1 Equal440 d-1 /00:00:24/ 0.75;
note /00:00:35352/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:35376/ inst1 Equal440 d-1 /00:00:24/ 0.75;
note /00:00:35400/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:35424/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:35448/ inst1 Equal440 c1 /00:00:24/ 0.75;
note /00:00:35472/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:35496/ inst1 Equal440 c1 /00:00:24/ 0.75;
note /00:00:35520/ inst1 Equal440 a-2 /00:00:24/ 0.75;
note /00:00:35544/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:35568/ inst1 Equal440 a-2 /00:00:24/ 0.75;
note /00:00:35592/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:35616/ inst1 Equal440 a0 /00:00:24/ 0.75;
note /00:00:35640/ inst1 Equal440 a1 /00:00:24/ 0.75;
note /00:00:35664/ inst1 Equal440 a0 /00:00:24/ 0.75;
note /00:00:35688/ inst1 Equal440 a1 /00:00:24/ 0.75;
note /00:00:35712/ inst1 Equal440 b-2 /00:00:24/ 0.75;
note /00:00:35736/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:35760/ inst1 Equal440 b-2 /00:00:24/ 0.75;
note /00:00:35784/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:35808/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:35832/ inst1 Equal440 a0 /00:00:24/ 0.75;
note /00:00:35856/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:35880/ inst1 Equal440 a0 /00:00:24/ 0.75;
note /00:00:35904/ inst1 Equal440 f#-2 /00:00:24/ 0.75;
note /00:00:35928/ inst1 Equal440 f#-1 /00:00:24/ 0.75;
note /00:00:35952/ inst1 Equal440 f#-2 /00:00:24/ 0.75;
note /00:00:35976/ inst1 Equal440 f#-1 /00:00:24/ 0.75;
note /00:00:36000/ inst1 Equal440 f#0 /00:00:24/ 0.75;
note /00:00:36024/ inst1 Equal440 f#1 /00:00:24/ 0.75;
note /00:00:36048/ inst1 Equal440 f#0 /00:00:24/ 0.75;
note /00:00:36072/ inst1 Equal440 f#1 /00:00:24/ 0.75;
note /00:00:36096/ inst1 Equal440 c-1 /00:00:24/ 0.75;
note /00:00:36120/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:36144/ inst1 Equal440 c-1 /00:00:24/ 0.75;
note /00:00:36168/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:36192/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:36216/ inst1 Equal440 a#0 /00:00:24/ 0.75;
note /00:00:36240/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:36264/ inst1 Equal440 a#0 /00:00:24/ 0.75;
note /00:00:36288/ inst1 Equal440 g-2 /00:00:24/ 0.75;
note /00:00:36312/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:36336/ inst1 Equal440 g-2 /00:00:24/ 0.75;
note /00:00:36360/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:36384/ inst1 Equal440 g0 /00:00:24/ 0.75;
note /00:00:36408/ inst1 Equal440 g1 /00:00:24/ 0.75;
note /00:00:36432/ inst1 Equal440 g0 /00:00:24/ 0.75;
note /00:00:36456/ inst1 Equal440 g1 /00:00:24/ 0.75;
note /00:00:36480/ inst1 Equal440 a-2 /00:00:24/ 0.75;
note /00:00:36504/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:36528/ inst1 Equal440 a-2 /00:00:24/ 0.75;
note /00:00:36552/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:36576/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:36600/ inst1 Equal440 g0 /00:00:24/ 0.75;
note /00:00:36624/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:36648/ inst1 Equal440 g0 /00:00:24/ 0.75;
note /00:00:36672/ inst1 Equal440 e-2 /00:00:24/ 0.75;
note /00:00:36696/ inst1 Equal440 e-1 /00:00:24/ 0.75;
note /00:00:36720/ inst1 Equal440 e-2 /00:00:24/ 0.75;
note /00:00:36744/ inst1 Equal440 e-1 /00:00:24/ 0.75;
note /00:00:36768/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:36792/ inst1 Equal440 e1 /00:00:24/ 0.75;
note /00:00:36816/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:36840/ inst1 Equal440 e1 /00:00:24/ 0.75;
note /00:00:36864/ inst1 Equal440 d-1 /00:00:24/ 0.75;
note /00:00:36888/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:36912/ inst1 Equal440 d-1 /00:00:24/ 0.75;
note /00:00:36936/ inst1 Equal440 d0 /00:00:24/ 0.75;
note /00:00:36960/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:36984/ inst1 Equal440 c1 /00:00:24/ 0.75;
note /00:00:37008/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:37032/ inst1 Equal440 c1 /00:00:24/ 0.75;
note /00:00:37056/ inst1 Equal440 a-2 /00:00:24/ 0.75;
note /00:00:37080/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:37104/ inst1 Equal440 a-2 /00:00:24/ 0.75;
note /00:00:37128/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:37152/ inst1 Equal440 a0 /00:00:24/ 0.75;
note /00:00:37176/ inst1 Equal440 a1 /00:00:24/ 0.75;
note /00:00:37200/ inst1 Equal440 a0 /00:00:24/ 0.75;
note /00:00:37224/ inst1 Equal440 a1 /00:00:24/ 0.75;
note /00:00:37248/ inst1 Equal440 b-2 /00:00:24/ 0.75;
note /00:00:37272/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:37296/ inst1 Equal440 b-2 /00:00:24/ 0.75;
note /00:00:37320/ inst1 Equal440 b-1 /00:00:24/ 0.75;
note /00:00:37344/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:37368/ inst1 Equal440 a0 /00:00:24/ 0.75;
note /00:00:37392/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:37416/ inst1 Equal440 a0 /00:00:24/ 0.75;
note /00:00:37440/ inst1 Equal440 f#-2 /00:00:24/ 0.75;
note /00:00:37464/ inst1 Equal440 f#-1 /00:00:24/ 0.75;
note /00:00:37488/ inst1 Equal440 f#-2 /00:00:24/ 0.75;
note /00:00:37512/ inst1 Equal440 f#-1 /00:00:24/ 0.75;
note /00:00:37536/ inst1 Equal440 f#0 /00:00:24/ 0.75;
note /00:00:37560/ inst1 Equal440 f#1 /00:00:24/ 0.75;
note /00:00:37584/ inst1 Equal440 f#0 /00:00:24/ 0.75;
note /00:00:37608/ inst1 Equal440 f#1 /00:00:24/ 0.75;
note /00:00:37632/ inst1 Equal440 c-1 /00:00:24/ 0.75;
note /00:00:37656/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:37680/ inst1 Equal440 c-1 /00:00:24/ 0.75;
note /00:00:37704/ inst1 Equal440 c0 /00:00:24/ 0.75;
note /00:00:37728/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:37752/ inst1 Equal440 a#0 /00:00:24/ 0.75;
note /00:00:37776/ inst1 Equal440 a#-1 /00:00:24/ 0.75;
note /00:00:37800/ inst1 Equal440 a#0 /00:00:24/ 0.75;
note /00:00:37824/ inst1 Equal440 g-2 /00:00:24/ 0.75;
note /00:00:37848/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:37872/ inst1 Equal440 g-2 /00:00:24/ 0.75;
note /00:00:37896/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:37920/ inst1 Equal440 g0 /00:00:24/ 0.75;
note /00:00:37944/ inst1 Equal440 g1 /00:00:24/ 0.75;
note /00:00:37968/ inst1 Equal440 g0 /00:00:24/ 0.75;
note /00:00:37992/ inst1 Equal440 g1 /00:00:24/ 0.75;
note /00:00:38016/ inst1 Equal440 a-2 /00:00:24/ 0.75;
note /00:00:38040/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:38064/ inst1 Equal440 a-2 /00:00:24/ 0.75;
note /00:00:38088/ inst1 Equal440 a-1 /00:00:24/ 0.75;
note /00:00:38112/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:38136/ inst1 Equal440 g0 /00:00:24/ 0.75;
note /00:00:38160/ inst1 Equal440 g-1 /00:00:24/ 0.75;
note /00:00:38184/ inst1 Equal440 g0 /00:00:24/ 0.75;
note /00:00:38208/ inst1 Equal440 e-2 /00:00:24/ 0.75;
note /00:00:38232/ inst1 Equal440 e-1 /00:00:24/ 0.75;
note /00:00:38256/ inst1 Equal440 e-2 /00:00:24/ 0.75;
note /00:00:38280/ inst1 Equal440 e-1 /00:00:24/ 0.75;
note /00:00:38304/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:38328/ inst1 Equal440 e1 /00:00:24/ 0.75;
note /00:00:38352/ inst1 Equal440 e0 /00:00:24/ 0.75;
note /00:00:38376/ inst1 Equal440 e1 /00:00:24/ 0.75;
note /00:00:59952/ inst1 Equal440 c0 /00:00:48/ 0.75;
note /00:00:60048/ inst1 Equal440 e0 /00:00:48/ 0.75;
note /00:00:60096/ inst1 Equal440 d-1 /00:00:48/ 0.75;
note /00:00:60144/ inst1 Equal440 c0 /00:00:48/ 0.75;
note /00:00:60240/ inst1 Equal440 e0 /00:00:48/ 0.75;
note /00:00:60336/ inst1 Equal440 a-1 /00:00:48/ 0.75;
note /00:00:60432/ inst1 Equal440 c#0 /00:00:48/ 0.75;
note /00:00:60480/ inst1 Equal440 b-2 /00:00:48/ 0.75;
note /00:00:60528/ inst1 Equal440 a-1 /00:00:48/ 0.75;
note /00:00:60624/ inst1 Equal440 c#0 /00:00:48/ 0.75;
note /00:00:60720/ inst1 Equal440 a#-1 /00:00:48/ 0.75;
note /00:00:60816/ inst1 Equal440 d0 /00:00:48/ 0.75;
note /00:00:60864/ inst1 Equal440 c-1 /00:00:48/ 0.75;
note /00:00:60912/ inst1 Equal440 a#-1 /00:00:48/ 0.75;
note /00:00:61008/ inst1 Equal440 d0 /00:00:48/ 0.75;
note /00:00:61104/ inst1 Equal440 g-1 /00:00:48/ 0.75;
note /00:00:61200/ inst1 Equal440 b-1 /00:00:48/ 0.75;
note /00:00:61248/ inst1 Equal440 a-2 /00:00:48/ 0.75;
note /00:00:61296/ inst1 Equal440 g-1 /00:00:48/ 0.75;
note /00:00:61392/ inst1 Equal440 b-1 /00:00:48/ 0.75;
note /00:00:61488/ inst1 Equal440 c0 /00:00:48/ 0.75;
note /00:00:61584/ inst1 Equal440 e0 /00:00:48/ 0.75;
note /00:00:61632/ inst1 Equal440 d-1 /00:00:48/ 0.75;
note /00:00:61680/ inst1 Equal440 c0 /00:00:48/ 0.75;
note /00:00:61776/ inst1 Equal440 e0 /00:00:48/ 0.75;
note /00:00:61872/ inst1 Equal440 a-1 /00:00:48/ 0.75;
note /00:00:61968/ inst1 Equal440 c#0 /00:00:48/ 0.75;
note /00:00:62016/ inst1 Equal440 b-2 /00:00:48/ 0.75;
note /00:00:62064/ inst1 Equal440 a-1 /00:00:48/ 0.75;
note /00:00:62160/ inst1 Equal440 c#0 /00:00:48/ 0.75;
note /00:00:62256/ inst1 Equal440 a#-1 /00:00:48/ 0.75;
note /00:00:62352/ inst1 Equal440 d0 /00:00:48/ 0.75;
note /00:00:62400/ inst1 Equal440 c-1 /00:00:48/ 0.75;
note /00:00:62448/ inst1 Equal440 a#-1 /00:00:48/ 0.75;
note /00:00:62544/ inst1 Equal440 d0 /00:00:48/ 0.75;
note /00:00:62640/ inst1 Equal440 g-1 /00:00:48/ 0.75;
note /00:00:62736/ inst1 Equal440 b-1 /00:00:48/ 0.75;
note /00:00:62784/ inst1 Equal440 a-2 /00:00:48/ 0.75;
note /00:00:62832/ inst1 Equal440 g-1 /00:00:48/ 0.75;
note /00:00:62928/ inst1 Equal440 b-1 /00:00:48/ 0.75;
note /00:00:63024/ inst1 Equal440 c0 /00:00:48/ 0.726562;
note /00:00:63120/ inst1 Equal440 e0 /00:00:48/ 0.679688;
note /00:00:63168/ inst1 Equal440 d-1 /00:00:48/ 0.65625;
note /00:00:63216/ inst1 Equal440 c0 /00:00:48/ 0.632812;
note /00:00:63312/ inst1 Equal440 e0 /00:00:48/ 0.585938;
note /00:00:63408/ inst1 Equal440 a-1 /00:00:48/ 0.539062;
note /00:00:63504/ inst1 Equal440 c#0 /00:00:48/ 0.492188;
note /00:00:63552/ inst1 Equal440 b-2 /00:00:48/ 0.46875;
note /00:00:63600/ inst1 Equal440 a-1 /00:00:48/ 0.445312;
note /00:00:63696/ inst1 Equal440 c#0 /00:00:48/ 0.398438;
note /00:00:63792/ inst1 Equal440 a#-1 /00:00:48/ 0.351562;
note /00:00:63888/ inst1 Equal440 d0 /00:00:48/ 0.304688;
note /00:00:63936/ inst1 Equal440 c-1 /00:00:48/ 0.28125;
note /00:00:63984/ inst1 Equal440 a#-1 /00:00:48/ 0.257812;
note /00:00:64080/ inst1 Equal440 d0 /00:00:48/ 0.210938;
note /00:00:64176/ inst1 Equal440 g-1 /00:00:48/ 0.164062;
note /00:00:64272/ inst1 Equal440 b-1 /00:00:48/ 0.117188;
note /00:00:64320/ inst1 Equal440 a-2 /00:00:48/ 0.09375;
note /00:00:64368/ inst1 Equal440 g-1 /00:00:48/ 0.0703125;
note /00:00:64464/ inst1 Equal440 b-1 /00:00:48/ 0.0234375;
--OTHER : 64512 Program 1 38
note /00:00:64560/ inst1 Equal440 c0 /00:00:48/ 0.0234375;
note /00:00:64656/ inst1 Equal440 e0 /00:00:48/ 0.0703125;
note /00:00:64704/ inst1 Equal440 d-1 /00:00:48/ 0.09375;
note /00:00:64752/ inst1 Equal440 c0 /00:00:48/ 0.117188;
note /00:00:64848/ inst1 Equal440 e0 /00:00:48/ 0.164062;
note /00:00:64944/ inst1 Equal440 a-1 /00:00:48/ 0.210938;
note /00:00:65040/ inst1 Equal440 c#0 /00:00:48/ 0.257812;
note /00:00:65088/ inst1 Equal440 b-2 /00:00:48/ 0.28125;
note /00:00:65136/ inst1 Equal440 a-1 /00:00:48/ 0.304688;
note /00:00:65232/ inst1 Equal440 c#0 /00:00:48/ 0.351562;
note /00:00:65328/ inst1 Equal440 a#-1 /00:00:48/ 0.398438;
note /00:00:65424/ inst1 Equal440 d0 /00:00:48/ 0.445312;
note /00:00:65472/ inst1 Equal440 c-1 /00:00:48/ 0.46875;
note /00:00:65520/ inst1 Equal440 a#-1 /00:00:48/ 0.492188;
note /00:00:65616/ inst1 Equal440 d0 /00:00:48/ 0.539062;
note /00:00:65712/ inst1 Equal440 g-1 /00:00:48/ 0.585938;
note /00:00:65808/ inst1 Equal440 b-1 /00:00:48/ 0.632812;
note /00:00:65856/ inst1 Equal440 a-2 /00:00:48/ 0.65625;
note /00:00:65904/ inst1 Equal440 g-1 /00:00:48/ 0.679688;
note /00:00:66000/ inst1 Equal440 b-1 /00:00:48/ 0.726562;
note /00:00:66096/ inst1 Equal440 c0 /00:00:48/ 0.75;
note /00:00:66192/ inst1 Equal440 e0 /00:00:48/ 0.75;
note /00:00:66240/ inst1 Equal440 d-1 /00:00:48/ 0.75;
note /00:00:66288/ inst1 Equal440 c0 /00:00:48/ 0.75;
note /00:00:66384/ inst1 Equal440 e0 /00:00:48/ 0.75;
note /00:00:66480/ inst1 Equal440 a-1 /00:00:48/ 0.75;
note /00:00:66576/ inst1 Equal440 c#0 /00:00:48/ 0.75;
note /00:00:66624/ inst1 Equal440 b-2 /00:00:48/ 0.75;
note /00:00:66672/ inst1 Equal440 a-1 /00:00:48/ 0.75;
note /00:00:66768/ inst1 Equal440 c#0 /00:00:48/ 0.75;
note /00:00:66864/ inst1 Equal440 a#-1 /00:00:48/ 0.75;
note /00:00:66960/ inst1 Equal440 d0 /00:00:48/ 0.75;
note /00:00:67008/ inst1 Equal440 c-1 /00:00:48/ 0.75;
note /00:00:67056/ inst1 Equal440 a#-1 /00:00:48/ 0.75;
note /00:00:67152/ inst1 Equal440 d0 /00:00:48/ 0.75;
note /00:00:67248/ inst1 Equal440 g-1 /00:00:48/ 0.75;
note /00:00:67344/ inst1 Equal440 b-1 /00:00:48/ 0.75;
note /00:00:67392/ inst1 Equal440 a-2 /00:00:48/ 0.75;
note /00:00:67440/ inst1 Equal440 g-1 /00:00:48/ 0.75;
note /00:00:67536/ inst1 Equal440 b-1 /00:00:48/ 0.75;
note /00:00:67632/ inst1 Equal440 c0 /00:00:48/ 0.75;
note /00:00:67728/ inst1 Equal440 e0 /00:00:48/ 0.75;
note /00:00:67776/ inst1 Equal440 d-1 /00:00:48/ 0.75;
note /00:00:67824/ inst1 Equal440 c0 /00:00:48/ 0.75;
note /00:00:67920/ inst1 Equal440 e0 /00:00:48/ 0.75;
note /00:00:68016/ inst1 Equal440 a-1 /00:00:48/ 0.75;
note /00:00:68112/ inst1 Equal440 c#0 /00:00:48/ 0.75;
note /00:00:68160/ inst1 Equal440 b-2 /00:00:48/ 0.75;
note /00:00:68208/ inst1 Equal440 a-1 /00:00:48/ 0.75;
note /00:00:68304/ inst1 Equal440 c#0 /00:00:48/ 0.75;
note /00:00:68400/ inst1 Equal440 a#-1 /00:00:48/ 0.75;
note /00:00:68496/ inst1 Equal440 d0 /00:00:48/ 0.75;
note /00:00:68544/ inst1 Equal440 c-1 /00:00:48/ 0.75;
note /00:00:68592/ inst1 Equal440 a#-1 /00:00:48/ 0.75;
note /00:00:68688/ inst1 Equal440 d0 /00:00:48/ 0.75;
note /00:00:68784/ inst1 Equal440 g-1 /00:00:48/ 0.75;
note /00:00:68880/ inst1 Equal440 b-1 /00:00:48/ 0.75;
note /00:00:68928/ inst1 Equal440 a-2 /00:00:48/ 0.75;
note /00:00:68976/ inst1 Equal440 g-1 /00:00:48/ 0.75;
note /00:00:69072/ inst1 Equal440 b-1 /00:00:48/ 0.75;
note /00:00:69168/ inst1 Equal440 c0 /00:00:48/ 0.75;
note /00:00:69264/ inst1 Equal440 e0 /00:00:48/ 0.75;
note /00:00:69312/ inst1 Equal440 d-1 /00:00:48/ 0.75;
note /00:00:69360/ inst1 Equal440 c0 /00:00:48/ 0.75;
note /00:00:69456/ inst1 Equal440 e0 /00:00:48/ 0.75;
note /00:00:69552/ inst1 Equal440 a-1 /00:00:48/ 0.75;
note /00:00:69648/ inst1 Equal440 c#0 /00:00:48/ 0.75;
note /00:00:69696/ inst1 Equal440 b-2 /00:00:48/ 0.75;
note /00:00:69744/ inst1 Equal440 a-1 /00:00:48/ 0.75;
note /00:00:69840/ inst1 Equal440 c#0 /00:00:48/ 0.75;
note /00:00:69936/ inst1 Equal440 a#-1 /00:00:48/ 0.75;
note /00:00:70032/ inst1 Equal440 d0 /00:00:48/ 0.75;
note /00:00:70080/ inst1 Equal440 c-1 /00:00:48/ 0.75;
note /00:00:70128/ inst1 Equal440 a#-1 /00:00:48/ 0.75;
note /00:00:70224/ inst1 Equal440 d0 /00:00:48/ 0.75;
note /00:00:70320/ inst1 Equal440 g-1 /00:00:48/ 0.75;
note /00:00:70416/ inst1 Equal440 b-1 /00:00:48/ 0.75;
note /00:00:70464/ inst1 Equal440 a-2 /00:00:48/ 0.75;
note /00:00:70512/ inst1 Equal440 g-1 /00:00:48/ 0.75;
note /00:00:70608/ inst1 Equal440 b-1 /00:00:48/ 0.75;
note /00:00:70704/ inst1 Equal440 c0 /00:00:48/ 0.75;
note /00:00:70800/ inst1 Equal440 e0 /00:00:48/ 0.75;
note /00:00:70848/ inst1 Equal440 d-1 /00:00:48/ 0.75;
note /00:00:70896/ inst1 Equal440 c0 /00:00:48/ 0.75;
note /00:00:70992/ inst1 Equal440 e0 /00:00:48/ 0.75;
note /00:00:71088/ inst1 Equal440 a-1 /00:00:48/ 0.75;
note /00:00:71184/ inst1 Equal440 c#0 /00:00:48/ 0.75;
note /00:00:71232/ inst1 Equal440 b-2 /00:00:48/ 0.75;
note /00:00:71280/ inst1 Equal440 a-1 /00:00:48/ 0.75;
note /00:00:71376/ inst1 Equal440 c#0 /00:00:48/ 0.75;
note /00:00:71472/ inst1 Equal440 a#-1 /00:00:48/ 0.75;
note /00:00:71568/ inst1 Equal440 d0 /00:00:48/ 0.75;
note /00:00:71616/ inst1 Equal440 c-1 /00:00:48/ 0.75;
note /00:00:71664/ inst1 Equal440 a#-1 /00:00:48/ 0.75;
note /00:00:71760/ inst1 Equal440 d0 /00:00:48/ 0.75;
note /00:00:71856/ inst1 Equal440 g-1 /00:00:48/ 0.75;
note /00:00:71952/ inst1 Equal440 b-1 /00:00:48/ 0.75;
note /00:00:72000/ inst1 Equal440 a-2 /00:00:48/ 0.75;
note /00:00:72048/ inst1 Equal440 g-1 /00:00:48/ 0.75;
note /00:00:72144/ inst1 Equal440 b-1 /00:00:48/ 0.75;
note /00:00:72240/ inst1 Equal440 c0 /00:00:48/ 0.75;
note /00:00:72336/ inst1 Equal440 e0 /00:00:48/ 0.75;
note /00:00:72384/ inst1 Equal440 d-1 /00:00:48/ 0.75;
note /00:00:72432/ inst1 Equal440 c0 /00:00:48/ 0.75;
note /00:00:72528/ inst1 Equal440 e0 /00:00:48/ 0.75;
note /00:00:72624/ inst1 Equal440 a-1 /00:00:48/ 0.75;
note /00:00:72720/ inst1 Equal440 c#0 /00:00:48/ 0.75;
note /00:00:72768/ inst1 Equal440 b-2 /00:00:48/ 0.75;
note /00:00:72816/ inst1 Equal440 a-1 /00:00:48/ 0.75;
note /00:00:72912/ inst1 Equal440 c#0 /00:00:48/ 0.75;
note /00:00:73008/ inst1 Equal440 a#-1 /00:00:48/ 0.75;
note /00:00:73104/ inst1 Equal440 d0 /00:00:48/ 0.75;
note /00:00:73152/ inst1 Equal440 c-1 /00:00:48/ 0.75;
note /00:00:73200/ inst1 Equal440 a#-1 /00:00:48/ 0.75;
note /00:00:73296/ inst1 Equal440 d0 /00:00:48/ 0.75;
note /00:00:73392/ inst1 Equal440 g-1 /00:00:48/ 0.75;
note /00:00:73488/ inst1 Equal440 b-1 /00:00:48/ 0.75;
note /00:00:73536/ inst1 Equal440 a-2 /00:00:48/ 0.75;
note /00:00:73584/ inst1 Equal440 g-1 /00:00:48/ 0.75;
note /00:00:73680/ inst1 Equal440 b-1 /00:00:48/ 0.75;
note /00:00:73776/ inst1 Equal440 c0 /00:00:48/ 0.75;
note /00:00:73872/ inst1 Equal440 e0 /00:00:48/ 0.75;
note /00:00:73920/ inst1 Equal440 d-1 /00:00:48/ 0.75;
note /00:00:73968/ inst1 Equal440 c0 /00:00:48/ 0.75;
note /00:00:74064/ inst1 Equal440 e0 /00:00:48/ 0.75;
note /00:00:74160/ inst1 Equal440 a-1 /00:00:48/ 0.75;
note /00:00:74256/ inst1 Equal440 c#0 /00:00:48/ 0.75;
note /00:00:74304/ inst1 Equal440 b-2 /00:00:48/ 0.75;
note /00:00:74352/ inst1 Equal440 a-1 /00:00:48/ 0.75;
note /00:00:74448/ inst1 Equal440 c#0 /00:00:48/ 0.75;
note /00:00:74544/ inst1 Equal440 a#-1 /00:00:48/ 0.75;
note /00:00:74640/ inst1 Equal440 d0 /00:00:48/ 0.75;
note /00:00:74688/ inst1 Equal440 c-1 /00:00:48/ 0.75;
note /00:00:74736/ inst1 Equal440 a#-1 /00:00:48/ 0.75;
note /00:00:74832/ inst1 Equal440 d0 /00:00:48/ 0.75;
note /00:00:74928/ inst1 Equal440 g-1 /00:00:48/ 0.75;
note /00:00:75024/ inst1 Equal440 b-1 /00:00:48/ 0.75;
note /00:00:75072/ inst1 Equal440 a-2 /00:00:48/ 0.75;
note /00:00:75120/ inst1 Equal440 g-1 /00:00:48/ 0.75;
note /00:00:75216/ inst1 Equal440 b-1 /00:00:48/ 0.75;

--OTHER : 0 Program 2 51
note /00:00:0/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:0/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:0/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:0/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:384/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:384/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:384/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:384/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:768/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:768/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:768/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:768/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:1152/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:1152/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:1152/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:1152/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:1536/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:1536/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:1536/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:1536/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:1920/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:1920/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:1920/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:1920/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:2304/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:2304/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:2304/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:2304/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:2688/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:2688/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:2688/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:2688/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:3072/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:3072/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:3072/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:3072/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:3456/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:3456/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:3456/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:3456/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:3840/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:3840/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:3840/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:3840/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:4224/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:4224/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:4224/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:4224/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:4608/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:4608/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:4608/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:4608/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:4992/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:4992/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:4992/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:4992/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:5376/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:5376/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:5376/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:5376/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:5760/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:5760/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:5760/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:5760/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:6144/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:6144/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:6144/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:6144/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:6528/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:6528/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:6528/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:6528/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:6912/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:6912/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:6912/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:6912/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:7296/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:7296/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:7296/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:7296/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:7680/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:7680/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:7680/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:7680/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:8064/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:8064/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:8064/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:8064/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:8448/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:8448/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:8448/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:8448/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:8832/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:8832/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:8832/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:8832/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:9216/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:9216/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:9216/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:9216/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:9600/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:9600/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:9600/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:9600/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:9984/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:9984/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:9984/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:9984/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:10368/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:10368/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:10368/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:10368/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:10752/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:10752/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:10752/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:10752/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:11136/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:11136/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:11136/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:11136/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:11520/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:11520/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:11520/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:11520/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:11904/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:11904/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:11904/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:11904/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:12288/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:12288/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:12288/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:12288/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:12672/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:12672/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:12672/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:12672/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:13056/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:13056/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:13056/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:13056/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:13440/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:13440/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:13440/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:13440/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:13824/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:13824/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:13824/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:13824/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:14208/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:14208/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:14208/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:14208/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:14592/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:14592/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:14592/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:14592/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:14976/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:14976/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:14976/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:14976/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:15360/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:15360/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:15360/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:15360/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:15744/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:15744/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:15744/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:15744/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:16128/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:16128/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:16128/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:16128/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:16512/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:16512/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:16512/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:16512/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:16896/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:16896/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:16896/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:16896/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:17280/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:17280/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:17280/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:17280/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:17664/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:17664/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:17664/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:17664/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:18048/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:18048/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:18048/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:18048/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:18432/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:18432/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:18432/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:18432/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:18816/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:18816/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:18816/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:18816/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:19200/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:19200/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:19200/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:19200/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:19584/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:19584/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:19584/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:19584/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:19968/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:19968/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:19968/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:19968/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:20352/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:20352/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:20352/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:20352/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:20736/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:20736/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:20736/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:20736/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:21120/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:21120/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:21120/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:21120/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:21504/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:21504/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:21504/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:21504/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:21888/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:21888/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:21888/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:21888/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:22272/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:22272/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:22272/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:22272/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:22656/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:22656/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:22656/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:22656/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:23040/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:23040/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:23040/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:23040/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:23424/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:23424/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:23424/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:23424/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:23808/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:23808/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:23808/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:23808/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:24192/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:24192/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:24192/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:24192/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:24576/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:24576/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:24576/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:24576/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:24960/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:24960/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:24960/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:24960/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:25344/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:25344/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:25344/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:25344/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:25728/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:25728/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:25728/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:25728/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:26112/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:26112/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:26112/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:26112/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:26496/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:26496/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:26496/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:26496/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:26880/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:26880/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:26880/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:26880/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:27264/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:27264/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:27264/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:27264/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:27648/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:27648/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:27648/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:27648/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:28032/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:28032/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:28032/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:28032/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:28416/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:28416/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:28416/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:28416/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:28800/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:28800/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:28800/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:28800/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:29184/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:29184/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:29184/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:29184/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:29568/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:29568/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:29568/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:29568/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:29952/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:29952/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:29952/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:29952/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:30336/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:30336/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:30336/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:30336/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:30720/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:30720/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:30720/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:30720/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:31104/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:31104/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:31104/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:31104/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:31488/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:31488/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:31488/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:31488/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:31872/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:31872/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:31872/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:31872/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:32256/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:32256/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:32256/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:32256/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:32640/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:32640/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:32640/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:32640/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:33024/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:33024/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:33024/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:33024/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:33408/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:33408/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:33408/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:33408/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:33792/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:33792/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:33792/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:33792/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:34176/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:34176/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:34176/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:34176/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:34560/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:34560/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:34560/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:34560/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:34944/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:34944/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:34944/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:34944/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:35328/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:35328/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:35328/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:35328/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:35712/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:35712/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:35712/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:35712/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:36096/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:36096/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:36096/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:36096/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:36480/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:36480/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:36480/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:36480/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:36864/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:36864/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:36864/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:36864/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:37248/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:37248/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:37248/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:37248/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:37632/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:37632/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:37632/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:37632/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:38016/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:38016/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:38016/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:38016/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:38400/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:38400/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:38400/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:38400/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:38784/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:38784/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:38784/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:38784/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:39168/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:39168/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:39168/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:39168/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:39552/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:39552/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:39552/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:39552/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:39936/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:39936/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:39936/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:39936/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:40320/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:40320/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:40320/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:40320/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:40704/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:40704/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:40704/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:40704/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:41088/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:41088/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:41088/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:41088/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:41472/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:41472/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:41472/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:41472/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:41856/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:41856/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:41856/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:41856/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:42240/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:42240/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:42240/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:42240/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:42624/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:42624/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:42624/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:42624/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:43008/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:43008/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:43008/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:43008/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:43392/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:43392/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:43392/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:43392/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:43776/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:43776/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:43776/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:43776/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:44160/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:44160/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:44160/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:44160/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:44544/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:44544/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:44544/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:44544/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:44928/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:44928/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:44928/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:44928/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:45312/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:45312/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:45312/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:45312/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:45696/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:45696/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:45696/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:45696/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:46080/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:46080/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:46080/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:46080/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:46464/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:46464/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:46464/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:46464/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:46848/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:46848/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:46848/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:46848/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:47232/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:47232/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:47232/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:47232/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:47616/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:47616/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:47616/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:47616/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:48000/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:48000/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:48000/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:48000/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:48384/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:48384/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:48384/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:48384/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:48768/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:48768/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:48768/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:48768/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:49152/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:49152/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:49152/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:49152/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:49536/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:49536/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:49536/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:49536/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:49920/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:49920/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:49920/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:49920/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:50304/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:50304/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:50304/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:50304/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:50688/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:50688/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:50688/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:50688/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:51072/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:51072/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:51072/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:51072/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:51456/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:51456/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:51456/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:51456/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:51840/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:51840/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:51840/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:51840/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:52224/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:52224/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:52224/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:52224/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:52608/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:52608/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:52608/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:52608/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:52992/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:52992/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:52992/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:52992/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:53376/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:53376/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:53376/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:53376/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:53760/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:53760/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:53760/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:53760/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:54144/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:54144/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:54144/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:54144/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:54528/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:54528/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:54528/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:54528/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:54912/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:54912/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:54912/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:54912/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:55296/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:55296/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:55296/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:55296/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:55680/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:55680/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:55680/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:55680/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:56064/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:56064/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:56064/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:56064/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:56448/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:56448/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:56448/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:56448/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:56832/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:56832/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:56832/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:56832/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:57216/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:57216/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:57216/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:57216/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:57600/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:57600/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:57600/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:57600/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:57984/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:57984/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:57984/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:57984/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:58368/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:58368/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:58368/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:58368/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:58752/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:58752/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:58752/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:58752/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:59136/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:59136/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:59136/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:59136/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:59520/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:59520/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:59520/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:59520/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:59904/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:59904/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:59904/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:59904/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:60288/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:60288/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:60288/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:60288/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:60672/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:60672/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:60672/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:60672/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:61056/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:61056/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:61056/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:61056/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:61440/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:61440/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:61440/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:61440/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:61824/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:61824/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:61824/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:61824/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:62208/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:62208/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:62208/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:62208/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:62592/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:62592/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:62592/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:62592/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:62976/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:62976/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:62976/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:62976/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:63360/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:63360/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:63360/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:63360/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:63744/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:63744/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:63744/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:63744/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:64128/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:64128/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:64128/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:64128/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:64512/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:64512/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:64512/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:64512/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:64896/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:64896/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:64896/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:64896/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:65280/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:65280/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:65280/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:65280/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:65664/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:65664/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:65664/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:65664/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:66048/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:66048/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:66048/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:66048/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:66432/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:66432/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:66432/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:66432/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:66816/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:66816/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:66816/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:66816/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:67200/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:67200/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:67200/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:67200/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:67584/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:67584/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:67584/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:67584/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:67968/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:67968/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:67968/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:67968/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:68352/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:68352/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:68352/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:68352/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:68736/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:68736/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:68736/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:68736/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:69120/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:69120/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:69120/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:69120/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:69504/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:69504/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:69504/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:69504/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:69888/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:69888/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:69888/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:69888/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:70272/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:70272/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:70272/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:70272/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:70656/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:70656/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:70656/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:70656/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:71040/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:71040/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:71040/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:71040/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:71424/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:71424/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:71424/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:71424/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:71808/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:71808/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:71808/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:71808/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:72192/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:72192/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:72192/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:72192/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:72576/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:72576/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:72576/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:72576/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:72960/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:72960/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:72960/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:72960/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:73344/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:73344/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:73344/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:73344/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:73728/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:73728/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:73728/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:73728/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:74112/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:74112/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:74112/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:74112/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:74496/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:74496/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:74496/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:74496/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:74880/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:74880/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:74880/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:74880/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:75264/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:75264/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:75264/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:75264/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:75648/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:75648/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:75648/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:75648/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:76032/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:76032/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:76032/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:76032/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:76416/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:76416/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:76416/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:76416/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:76800/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:76800/ inst2 Equal440 c3 /00:00:384/ 0.046875;
note /00:00:76800/ inst2 Equal440 e3 /00:00:384/ 0.046875;
note /00:00:76800/ inst2 Equal440 a3 /00:00:384/ 0.046875;
note /00:00:77184/ inst2 Equal440 e2 /00:00:384/ 0.046875;
note /00:00:77184/ inst2 Equal440 a2 /00:00:384/ 0.046875;
note /00:00:77184/ inst2 Equal440 c#3 /00:00:384/ 0.046875;
note /00:00:77184/ inst2 Equal440 f#3 /00:00:384/ 0.046875;
note /00:00:77568/ inst2 Equal440 f2 /00:00:384/ 0.046875;
note /00:00:77568/ inst2 Equal440 a#2 /00:00:384/ 0.046875;
note /00:00:77568/ inst2 Equal440 d3 /00:00:384/ 0.046875;
note /00:00:77568/ inst2 Equal440 g3 /00:00:384/ 0.046875;
note /00:00:77952/ inst2 Equal440 d2 /00:00:384/ 0.046875;
note /00:00:77952/ inst2 Equal440 g2 /00:00:384/ 0.046875;
note /00:00:77952/ inst2 Equal440 b2 /00:00:384/ 0.046875;
note /00:00:77952/ inst2 Equal440 e3 /00:00:384/ 0.046875;

note /00:00:0/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:24/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:48/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:96/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:120/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:144/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:168/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:192/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:216/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:240/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:264/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:384/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:408/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:432/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:456/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:480/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:504/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:528/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:552/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:576/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:600/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:624/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:648/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:768/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:792/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:816/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:840/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:864/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:888/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:912/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:936/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:960/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:984/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1008/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1032/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1152/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1176/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1200/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1224/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1248/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1272/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1296/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1320/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1344/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1368/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1392/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1416/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1536/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1560/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1584/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:1584/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1608/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1632/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1656/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1680/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:1680/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1704/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1728/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1752/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1776/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:1776/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1800/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1872/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:1920/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1944/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1968/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:1968/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:1992/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2016/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2040/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2064/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:2064/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2088/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2112/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2136/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2160/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:2160/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2184/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2256/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:2304/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2328/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2352/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:2352/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2376/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2400/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2424/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2448/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:2448/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2472/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2496/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2520/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2544/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:2544/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2568/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2640/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:2688/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2712/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2736/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:2736/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2760/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2784/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2808/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2832/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:2832/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2856/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2880/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2904/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2928/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:2928/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:2952/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3024/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:3072/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3096/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3120/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:3120/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3144/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3168/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3192/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3216/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:3216/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3240/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3264/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3288/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3312/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:3312/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3336/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3408/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:3456/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3480/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3504/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:3504/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3528/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3552/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3576/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3600/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:3600/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3624/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3648/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3672/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3696/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:3696/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3720/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3792/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:3840/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3864/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3888/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:3888/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3912/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3936/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3960/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:3984/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:3984/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4008/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4032/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4056/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4080/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:4080/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4104/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4176/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:4224/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4248/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4272/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:4272/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4296/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4320/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4344/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4368/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:4368/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4392/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4416/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4440/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4464/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:4464/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4488/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4560/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:4608/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4632/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4656/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:4656/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4680/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4704/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4728/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4752/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:4752/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4776/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4800/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4824/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4848/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:4848/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4872/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:4944/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:4992/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5016/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5040/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:5040/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5064/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5088/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5112/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5136/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:5136/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5160/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5184/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5208/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5232/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:5232/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5256/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5328/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:5376/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5400/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5424/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:5424/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5448/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5472/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5496/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5520/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:5520/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5544/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5568/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5592/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5616/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:5616/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5640/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5712/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:5760/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5784/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5808/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:5808/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5832/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5856/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5880/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5904/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:5904/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5928/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5952/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:5976/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6000/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:6000/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6024/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6096/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:6144/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:6144/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6168/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6192/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:6192/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6216/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6240/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:6240/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:6240/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6264/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6288/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:6288/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6312/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6336/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:6336/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6360/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:6360/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6384/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:6384/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6408/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6432/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:6432/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:6480/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:6528/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:6528/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6552/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6576/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:6576/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6600/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6624/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:6624/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:6624/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6648/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6672/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:6672/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6696/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6720/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:6720/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6744/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:6744/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6768/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:6768/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6792/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6816/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:6816/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:6864/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:6912/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:6912/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6936/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6960/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:6960/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:6984/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7008/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:7008/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:7008/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7032/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7056/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:7056/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7080/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7104/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:7104/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7128/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:7128/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7152/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:7152/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7176/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7200/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:7200/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:7248/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:7296/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:7296/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7320/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7344/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:7344/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7368/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7392/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:7392/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:7392/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7416/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7440/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:7440/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7464/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7488/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:7488/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7512/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:7512/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7536/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:7536/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7560/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7584/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:7584/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:7608/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:7632/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:7632/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:7680/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:7680/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7704/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7728/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:7728/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7752/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7776/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:7776/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:7776/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7800/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7824/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:7824/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7848/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7872/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:7872/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7896/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:7896/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7920/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:7920/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7944/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:7968/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:7968/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:8016/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:8064/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:8064/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8088/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8112/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:8112/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8136/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8160/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:8160/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:8160/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8184/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8208/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:8208/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8232/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8256/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:8256/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8280/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:8280/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8304/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:8304/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8328/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8352/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:8352/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:8400/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:8448/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:8448/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8472/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8496/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:8496/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8520/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8544/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:8544/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:8544/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8568/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8592/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:8592/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8616/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8640/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:8640/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8664/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:8664/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8688/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:8688/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8712/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8736/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:8736/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:8784/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:8832/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:8832/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8856/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8880/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:8880/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8904/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8928/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:8928/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:8928/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8952/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:8976/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:8976/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9000/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9024/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:9024/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9048/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:9048/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9072/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:9072/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:9072/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9096/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9120/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:9120/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:9144/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:9168/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:9216/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:9216/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9240/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9264/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:9264/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9288/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9312/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:9312/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:9312/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9336/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9360/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:9360/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9384/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9408/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:9408/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9432/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:9432/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9456/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:9456/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9480/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9504/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:9504/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:9552/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:9600/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:9600/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9624/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9648/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:9648/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9672/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9696/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:9696/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:9696/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9720/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9744/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:9744/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9768/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9792/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:9792/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9816/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:9816/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9840/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:9840/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9864/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:9888/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:9888/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:9936/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:9984/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:9984/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10008/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10032/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:10032/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10056/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10080/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:10080/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:10080/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10104/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10128/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:10128/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10152/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10176/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:10176/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10200/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:10200/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10224/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:10224/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10248/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10272/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:10272/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:10320/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:10368/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:10368/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10392/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10416/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:10416/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10440/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10464/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:10464/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:10464/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10488/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10512/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:10512/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10536/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10560/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:10560/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:10560/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10584/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:10584/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10608/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:10608/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10632/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10656/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:10656/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:10704/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:10704/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:10728/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:10752/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:10752/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10776/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10800/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:10800/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10824/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10848/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:10848/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:10848/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10872/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10896/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:10896/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10920/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10944/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:10944/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10968/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:10968/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:10992/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:10992/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11016/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11040/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:11040/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:11088/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:11136/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:11136/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11160/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11184/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:11184/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11208/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11232/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:11232/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:11232/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11256/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11280/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:11280/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11304/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11328/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:11328/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11352/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:11352/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11376/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:11376/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11400/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11424/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:11424/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:11472/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:11520/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:11520/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11544/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11568/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:11568/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11592/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11616/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:11616/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:11616/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11640/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11664/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:11664/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11688/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11712/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:11712/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11736/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:11736/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11760/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:11760/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11784/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11808/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:11808/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:11856/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:11904/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:11904/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11928/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11952/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:11952/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:11952/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:11976/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12000/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:12000/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:12000/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12024/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12048/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:12048/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12072/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12096/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:12096/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12120/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:12120/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12144/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:12144/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:12144/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12168/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:12168/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12192/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:12192/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:12216/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:12240/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:12240/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:12288/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:12288/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12312/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12336/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:12336/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12360/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12384/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:12384/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:12384/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12408/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12432/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:12432/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12456/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12480/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:12480/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12504/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:12504/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12528/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:12528/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12552/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12576/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:12576/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:12624/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:12672/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:12672/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12696/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12720/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:12720/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12744/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12768/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:12768/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:12768/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12792/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12816/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:12816/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12840/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12864/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:12864/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12888/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:12888/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12912/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:12912/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12936/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:12960/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:12960/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:13008/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:13056/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:13056/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13080/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13104/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:13104/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13128/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13152/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:13152/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:13152/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13176/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13200/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:13200/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13224/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13248/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:13248/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13272/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:13272/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13296/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:13296/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13320/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13344/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:13344/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:13392/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:13440/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:13440/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13464/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13488/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:13488/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:13488/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13512/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13536/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:13536/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:13536/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13560/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13584/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:13584/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13608/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13632/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:13632/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13656/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:13656/ druminst62 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13680/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:13680/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:13680/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13704/ druminst64 Equal440 c3 /00:00:24/ 0.75;
note /00:00:13728/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:13728/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:13752/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:13776/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:13776/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:13800/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:13824/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:13872/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:13920/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:13920/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:13968/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:14016/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:14040/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:14064/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:14112/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:14112/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:14160/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:14208/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:14256/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:14304/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:14304/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:14352/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:14400/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:14424/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:14448/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:14496/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:14496/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:14544/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:14592/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:14640/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:14688/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:14688/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:14736/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:14784/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:14808/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:14832/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:14880/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:14880/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:14928/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:14976/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:15024/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:15072/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:15072/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:15096/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:15120/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:15168/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:15192/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:15216/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:15264/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:15264/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:15312/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:15312/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:15360/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:15408/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:15456/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:15456/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:15504/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:15552/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:15576/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:15600/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:15648/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:15648/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:15696/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:15744/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:15792/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:15840/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:15840/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:15888/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:15936/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:15960/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:15984/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:16032/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:16032/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:16080/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:16128/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:16176/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:16224/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:16224/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:16272/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:16320/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:16344/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:16368/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:16416/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:16416/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:16464/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:16512/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:16560/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:16608/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:16608/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:16632/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:16656/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:16704/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:16704/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:16728/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:16752/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:16800/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:16800/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:16824/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:16848/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:16944/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:16992/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:17040/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:17112/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:17136/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:17184/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:17232/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:17328/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:17376/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:17424/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:17496/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:17520/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:17568/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:17616/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:17712/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:17760/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:17808/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:17880/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:17904/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:17952/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:18000/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:18096/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:18144/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:18192/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:18264/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:18288/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:18288/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:18312/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:18336/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:18360/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:18384/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:18528/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:18648/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:18720/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:18912/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:19032/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:19104/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:19296/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:19416/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:19488/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:19680/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:19776/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:19800/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:19872/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:19920/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:19944/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:20064/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:20184/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:20256/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:20448/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:20568/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:20640/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:20832/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:20952/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:21024/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:21216/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:21336/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:21408/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:21432/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:21456/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:21480/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:21552/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:21600/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:21648/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:21720/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:21744/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:21792/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:21840/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:21936/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:21984/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:22032/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:22104/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:22128/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:22176/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:22224/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:22320/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:22368/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:22416/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:22488/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:22512/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:22560/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:22608/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:22704/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:22704/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:22752/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:22800/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:22848/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:22872/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:22896/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:22896/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:22944/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:22968/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:22992/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:22992/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:23040/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:23088/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:23136/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:23136/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:23184/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:23232/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:23256/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:23280/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:23328/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:23328/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:23376/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:23424/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:23472/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:23520/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:23520/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:23568/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:23616/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:23640/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:23664/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:23712/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:23712/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:23760/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:23808/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:23856/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:23904/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:23904/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:23952/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:24000/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:24024/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:24048/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:24096/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:24096/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:24144/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:24192/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:24240/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:24288/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:24288/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:24312/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:24336/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:24384/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:24384/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:24408/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:24432/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:24432/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:24456/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:24480/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:24480/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:24504/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:24528/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:24552/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:24576/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:24624/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:24672/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:24672/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:24720/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:24768/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:24792/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:24816/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:24864/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:24864/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:24912/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:24960/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:25008/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:25056/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:25056/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:25104/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:25152/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:25176/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:25200/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:25248/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:25248/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:25296/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:25344/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:25392/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:25440/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:25440/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:25488/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:25536/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:25560/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:25584/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:25632/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:25632/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:25680/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:25728/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:25776/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:25824/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:25824/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:25872/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:25920/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:25920/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:25944/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:25968/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:26016/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:26016/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:26064/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:26088/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:26112/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:26160/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:26208/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:26208/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:26256/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:26304/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:26328/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:26352/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:26400/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:26400/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:26448/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:26496/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:26544/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:26592/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:26592/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:26640/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:26688/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:26712/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:26736/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:26784/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:26784/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:26832/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:26880/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:26928/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:26976/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:26976/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:27024/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:27072/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:27096/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:27120/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:27168/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:27168/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:27216/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:27264/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:27312/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:27312/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:27360/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:27360/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:27408/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:27456/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:27480/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:27504/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:27504/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:27552/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:27552/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:27576/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:27600/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:27600/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:27624/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:27648/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:27696/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:27744/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:27744/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:27792/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:27840/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:27864/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:27888/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:27936/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:27936/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:27984/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:28032/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:28080/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:28128/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:28128/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:28176/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:28224/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:28248/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:28272/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:28320/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:28320/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:28368/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:28416/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:28464/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:28512/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:28512/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:28560/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:28608/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:28632/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:28656/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:28704/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:28704/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:28752/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:28800/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:28848/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:28848/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:28896/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:28896/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:28920/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:28944/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:28992/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:29016/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:29040/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:29040/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:29064/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:29088/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:29088/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:29112/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:29136/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:29136/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:29160/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:29184/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:29232/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:29280/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:29280/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:29328/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:29376/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:29400/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:29424/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:29472/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:29472/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:29520/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:29568/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:29616/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:29664/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:29664/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:29712/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:29760/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:29784/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:29808/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:29856/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:29856/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:29904/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:29952/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:30000/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:30048/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:30048/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:30096/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:30144/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:30168/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:30192/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:30240/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:30240/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:30288/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:30336/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:30384/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:30384/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:30432/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:30432/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:30480/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:30528/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:30552/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:30576/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:30576/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:30600/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:30624/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:30624/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:30648/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:30672/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:30720/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:30768/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:30816/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:30816/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:30864/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:30912/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:30936/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:30960/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:31008/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:31008/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:31056/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:31104/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:31152/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:31200/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:31200/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:31248/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:31296/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:31320/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:31344/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:31392/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:31392/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:31440/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:31488/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:31536/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:31584/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:31584/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:31632/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:31680/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:31704/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:31728/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:31776/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:31776/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:31824/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:31872/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:31920/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:31920/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:31968/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:31968/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:31992/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:32016/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:32064/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:32088/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:32112/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:32112/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:32160/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:32160/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:32184/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:32208/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:32232/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:32256/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:32304/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:32352/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:32352/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:32400/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:32448/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:32472/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:32496/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:32544/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:32544/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:32592/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:32640/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:32688/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:32736/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:32736/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:32784/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:32832/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:32856/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:32880/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:32928/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:32928/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:32976/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:33024/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:33072/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:33120/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:33120/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:33168/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:33216/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:33240/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:33264/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:33312/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:33312/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:33360/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:33408/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:33456/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:33456/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:33504/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:33504/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:33552/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:33600/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:33600/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:33624/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:33648/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:33648/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:33696/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:33696/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:33720/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:33744/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:33744/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:33792/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:33840/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:33888/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:33888/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:33936/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:33984/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:34008/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:34032/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:34080/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:34080/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:34128/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:34176/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:34224/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:34272/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:34272/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:34320/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:34368/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:34392/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:34416/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:34464/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:34464/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:34512/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:34560/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:34608/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:34656/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:34656/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:34704/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:34752/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:34776/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:34800/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:34848/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:34848/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:34896/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:34944/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:34992/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:34992/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:35040/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:35040/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:35088/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:35136/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:35136/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:35160/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:35184/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:35184/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:35208/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:35232/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:35232/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:35256/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:35280/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:35280/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:35304/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:35328/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:35376/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:35424/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:35424/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:35472/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:35520/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:35544/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:35568/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:35616/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:35616/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:35664/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:35712/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:35760/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:35808/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:35808/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:35856/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:35904/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:35928/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:35952/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:36000/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:36000/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:36048/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:36096/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:36144/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:36192/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:36192/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:36240/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:36288/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:36312/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:36336/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:36384/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:36384/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:36432/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:36480/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:36528/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:36576/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:36576/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:36600/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:36624/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:36672/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:36672/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:36696/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:36720/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:36720/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:36768/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:36768/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:36816/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:44544/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44576/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44592/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:44592/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44624/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44640/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44672/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44688/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:44688/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44720/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44736/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44768/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44784/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:44784/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44816/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44832/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44864/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44880/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:44880/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44912/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44928/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44960/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:44976/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:44976/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45008/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45024/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45056/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45072/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:45072/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45104/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45120/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45152/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45168/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:45168/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45200/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45216/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45248/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45264/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:45264/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45296/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45312/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45344/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45360/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:45360/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45392/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45408/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45440/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45456/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:45456/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45488/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45504/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45536/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45552/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:45552/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45584/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45600/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45632/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45648/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:45648/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45680/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45696/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45728/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45744/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:45744/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45776/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45792/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45824/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45840/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:45840/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45872/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45888/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45920/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45936/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:45936/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45968/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:45984/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46016/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46032/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:46032/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46064/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46080/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46080/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:46112/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46128/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:46128/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46160/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46176/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46176/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:46208/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46224/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:46224/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46256/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46272/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46272/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:46304/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46320/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:46320/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46352/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46368/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46368/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:46400/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46416/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:46416/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46448/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46464/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46464/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:46496/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46512/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:46512/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46544/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46560/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46560/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:46592/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46608/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:46608/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46640/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46656/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46656/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:46688/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46704/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:46704/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46736/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46752/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46752/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:46784/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46800/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:46800/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46832/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46848/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46848/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:46880/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46896/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:46896/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46928/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46944/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46944/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:46976/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:46992/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:46992/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47024/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47040/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47040/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:47072/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47088/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:47088/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47120/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47136/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47136/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:47168/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47184/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:47184/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47216/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47232/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47232/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:47264/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47280/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:47280/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47312/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47328/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47328/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:47360/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47376/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:47376/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47408/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47424/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47424/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:47456/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47472/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:47472/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47504/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47520/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47520/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:47552/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47568/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:47568/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47600/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47616/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47616/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:47648/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47664/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:47664/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47696/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47712/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47712/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:47712/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:47744/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47760/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:47760/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47792/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47808/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47808/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:47832/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:47840/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47856/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:47856/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47888/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47904/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47904/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:47904/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:47936/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47952/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:47952/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:47984/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48000/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48000/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:48032/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48048/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:48048/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48080/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48096/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48096/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:48096/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:48128/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48144/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:48144/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48176/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48192/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48192/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:48216/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:48224/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48240/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:48240/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48272/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48288/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48288/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:48288/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:48320/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48336/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:48336/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48368/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48384/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48384/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:48416/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48432/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:48432/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48464/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48480/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48480/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:48480/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:48512/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48528/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:48528/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48560/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48576/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48576/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:48600/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:48608/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48624/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:48624/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48656/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48672/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48672/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:48672/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:48704/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48720/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:48720/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48752/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48768/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48768/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:48800/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48816/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:48816/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48848/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48864/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48864/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:48864/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:48896/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48912/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:48912/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48944/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48960/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:48960/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:48960/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:48984/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:48992/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49008/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:49008/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49040/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49056/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49056/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:49056/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:49088/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49104/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:49104/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49128/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:49136/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49152/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49152/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:49184/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49200/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:49200/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49232/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49248/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49248/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:49248/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:49280/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49296/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:49296/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49328/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49344/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49344/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:49368/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:49376/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49392/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:49392/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49424/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49440/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49440/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:49440/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:49472/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49488/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:49488/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49520/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49536/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49536/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:49568/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49584/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:49584/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49616/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49632/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49632/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:49632/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:49664/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49680/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:49680/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49712/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49728/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49728/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:49752/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:49760/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49776/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:49776/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49808/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49824/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49824/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:49824/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:49856/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49872/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:49872/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49904/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49920/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49920/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:49952/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:49968/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:49968/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50000/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50016/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50016/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:50016/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:50048/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50064/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:50064/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50096/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50112/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50112/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:50136/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:50144/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50160/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:50160/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50192/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50208/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50208/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:50208/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:50240/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50256/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:50256/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50288/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50304/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50304/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:50336/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50352/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:50352/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50352/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:50384/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50400/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50400/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:50400/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:50432/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50448/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:50448/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50480/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50496/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50496/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:50520/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:50528/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50544/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:50544/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50544/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:50568/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:50576/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50592/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50592/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:50592/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:50616/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:50624/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50640/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:50640/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50640/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:50672/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50688/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50688/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:50720/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50736/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:50736/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50768/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50784/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50784/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:50784/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:50816/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50832/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:50832/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50864/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50880/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50880/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:50904/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:50912/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50928/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:50928/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50960/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50976/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:50976/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:50976/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:51008/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51024/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:51024/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51056/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51072/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51072/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:51104/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51120/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:51120/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51152/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51168/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51168/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:51168/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:51200/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51216/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:51216/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51248/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51264/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51264/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:51288/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:51296/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51312/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:51312/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51344/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51360/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51360/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:51360/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:51392/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51408/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:51408/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51440/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51456/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51456/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:51488/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51504/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:51504/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51536/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51552/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51552/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:51552/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:51584/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51600/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:51600/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51632/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51648/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51648/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:51672/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:51680/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51696/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:51696/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51728/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51744/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51744/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:51744/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:51776/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51792/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:51792/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51824/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51840/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51840/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:51872/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51888/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:51888/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51920/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51936/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51936/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:51936/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:51968/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:51984/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:51984/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52016/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52032/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52032/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:52056/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:52064/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52080/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:52080/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52112/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52128/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52128/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:52128/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:52152/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:52160/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52176/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:52176/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52176/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:52200/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:52208/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52224/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52224/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:52256/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52272/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:52272/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52304/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52320/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52320/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:52320/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:52352/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52368/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:52368/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52400/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52416/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52416/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:52440/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:52448/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52464/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:52464/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52496/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52512/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52512/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:52512/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:52544/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52560/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:52560/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52592/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52608/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52608/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:52640/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52656/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:52656/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52688/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52704/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52704/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:52704/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:52736/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52752/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:52752/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52784/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52800/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52800/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:52824/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:52832/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52848/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:52848/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52880/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52896/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52896/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:52896/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:52928/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52944/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:52944/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52976/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52992/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:52992/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:53024/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53040/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:53040/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53072/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53088/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53088/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:53088/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:53120/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53136/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:53136/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53168/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53184/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53184/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:53208/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:53216/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53232/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:53232/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53264/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53280/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53280/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:53280/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:53312/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53328/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:53328/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53360/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53376/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53376/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:53408/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53424/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:53424/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53456/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53472/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53472/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:53472/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:53496/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:53504/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53520/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:53520/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53552/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53568/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53568/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:53592/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:53600/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53616/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:53616/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53648/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53664/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53664/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:53664/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:53696/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53712/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:53712/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53712/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:53744/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53760/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53760/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:53792/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53808/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:53808/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53840/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53856/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53856/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:53856/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:53888/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53904/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:53904/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53936/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53952/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:53952/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:53976/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:53984/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54000/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:54000/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54032/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54048/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54048/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:54048/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:54080/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54096/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:54096/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54128/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54144/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54144/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:54176/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54192/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:54192/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54224/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54240/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54240/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:54240/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:54272/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54288/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:54288/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54320/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54336/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54336/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:54360/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:54368/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54384/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:54384/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54416/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54432/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54432/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:54432/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:54464/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54480/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:54480/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54512/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54528/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54528/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:54560/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54576/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:54576/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54608/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54624/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54624/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:54624/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:54656/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54672/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:54672/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54704/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54720/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54720/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:54744/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:54752/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54768/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:54768/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54800/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54816/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54816/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:54816/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:54848/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54864/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:54864/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54896/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54912/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54912/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:54944/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54960/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:54960/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:54960/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:54992/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55008/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55008/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:55008/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:55032/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:55040/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55056/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:55056/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55088/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55104/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55104/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:55128/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:55136/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55152/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:55152/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55184/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55200/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55200/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:55200/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:55224/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:55232/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55248/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:55248/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55272/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:55280/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55296/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55296/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:55328/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55344/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:55344/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55376/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55392/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55392/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:55392/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:55424/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55440/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:55440/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55472/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55488/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55488/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:55512/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:55520/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55536/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:55536/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55568/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55584/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55584/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:55584/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:55616/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55632/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:55632/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55664/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55680/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55680/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:55712/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55728/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:55728/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55760/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55776/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55776/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:55776/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:55808/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55824/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:55824/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55856/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55872/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55872/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:55896/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:55904/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55920/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:55920/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55952/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55968/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:55968/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:55968/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:56000/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56016/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:56016/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56048/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56064/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56064/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:56096/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56112/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:56112/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56144/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56160/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56160/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:56160/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:56192/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56208/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:56208/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56240/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56256/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56256/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:56280/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:56288/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56304/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:56304/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56336/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56352/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56352/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:56352/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:56384/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56400/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:56400/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56432/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56448/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56448/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:56480/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56496/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:56496/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56496/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:56528/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56544/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56544/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:56544/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:56576/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56592/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:56592/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56624/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56640/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56640/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:56664/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:56672/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56688/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:56688/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56688/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:56712/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:56720/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56736/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56736/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:56736/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:56760/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:56768/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56784/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:56784/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56784/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:56816/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56832/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56832/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:56832/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:56864/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56880/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:56880/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56880/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:56912/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56928/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56928/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:56928/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:56928/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:56952/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:56960/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56976/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:56976/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:56976/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57000/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57008/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57024/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57024/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:57024/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57048/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:57056/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57072/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:57072/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57072/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57096/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57104/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57120/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57120/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:57120/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:57120/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57144/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57152/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57168/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:57168/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57168/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57200/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57216/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57216/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:57216/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57248/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57264/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:57264/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57264/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57296/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57312/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57312/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:57312/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:57312/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57336/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57344/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57360/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:57360/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57360/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57384/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57392/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57408/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57408/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:57408/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57432/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:57440/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57456/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:57456/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57456/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57480/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57488/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57504/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57504/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:57504/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:57504/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57528/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57536/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57552/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:57552/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57552/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57584/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57600/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57600/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:57600/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57632/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57648/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:57648/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57648/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57680/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57696/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57696/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:57696/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:57696/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57720/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57728/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57744/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:57744/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57744/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57768/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57776/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57792/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57792/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:57792/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57816/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:57824/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57840/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:57840/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57840/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57864/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57872/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57888/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57888/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:57888/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:57888/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57912/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57920/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57936/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:57936/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57936/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:57968/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57984/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:57984/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:57984/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58016/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58032/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:58032/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58032/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58064/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58080/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58080/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:58080/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:58080/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58104/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58112/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58128/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:58128/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58128/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58152/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58160/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58176/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58176/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:58176/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58200/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:58208/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58224/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:58224/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58224/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58248/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58256/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58272/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58272/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:58272/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:58272/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58296/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:58296/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58304/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58320/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:58320/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58320/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:58320/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58344/ druminst38 Equal440 c3 /00:00:24/ 0.992188;
note /00:00:58352/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58368/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58368/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:58368/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58400/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58416/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:58416/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58416/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58448/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58464/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58464/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:58464/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58488/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58496/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58512/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:58512/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58512/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58536/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58544/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58560/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58560/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:58560/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58592/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58608/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:58608/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58608/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58632/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58640/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58656/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58656/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:58656/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58680/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58688/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58704/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:58704/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58704/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58736/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58752/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58752/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:58752/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58784/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58800/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:58800/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58800/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58832/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58848/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58848/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:58848/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58872/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58880/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58896/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:58896/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58896/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58920/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58928/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58944/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58944/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:58944/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:58976/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58992/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:58992/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:58992/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59016/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59024/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59040/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59040/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:59040/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59064/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59072/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59088/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:59088/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59088/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59120/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59136/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59136/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:59136/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59168/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59184/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:59184/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59184/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59216/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59232/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59232/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:59232/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59256/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59264/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59280/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:59280/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59280/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59304/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59312/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59328/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59328/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:59328/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59360/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59376/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:59376/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59376/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59400/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59408/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59424/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59424/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:59424/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59448/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59456/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59472/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:59472/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59472/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59504/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59520/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59520/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:59520/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59552/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59568/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:59568/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59568/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59600/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59616/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59616/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:59616/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59640/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59648/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59664/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:59664/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59664/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59688/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59696/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59712/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59712/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:59712/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59744/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59760/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:59760/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59760/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59784/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59792/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59808/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59808/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:59808/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59832/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59840/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59856/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:59856/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59856/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59888/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59904/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59904/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:59904/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59936/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59952/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:59952/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:59952/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:59984/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60000/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60000/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:60000/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60024/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60032/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60048/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:60048/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60048/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60072/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60080/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60096/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60096/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:60096/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60128/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60144/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:60144/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60144/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60168/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60176/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60192/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60192/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:60192/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60216/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60224/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60240/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:60240/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60240/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60272/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60288/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60288/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:60288/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60320/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60336/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:60336/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60336/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60368/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60384/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60384/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:60384/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60408/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60416/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60432/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:60432/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60432/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60456/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60464/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60480/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60480/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:60480/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60512/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60528/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:60528/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60528/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60552/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60560/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60576/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60576/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:60576/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60600/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60608/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60624/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:60624/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60624/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60656/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60672/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60672/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:60672/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60704/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60720/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:60720/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60720/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60752/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60768/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60768/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:60768/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60792/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60800/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60816/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:60816/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60816/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60840/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60848/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60864/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60864/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:60864/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60896/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60912/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:60912/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60912/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60936/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60944/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60960/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:60960/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:60960/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60984/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:60992/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61008/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:61008/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61008/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61040/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61056/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61056/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:61056/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61088/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61104/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:61104/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61104/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61136/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61152/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61152/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:61152/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61176/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61184/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61200/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:61200/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61200/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61224/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61232/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61248/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61248/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:61248/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61280/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61296/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:61296/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61296/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61320/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61328/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61344/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61344/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:61344/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61368/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61376/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61392/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:61392/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61392/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61424/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61440/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61440/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:61440/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61472/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61488/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:61488/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61488/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61520/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61536/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61536/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:61536/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61560/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61568/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61584/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:61584/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61584/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61608/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61616/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61632/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61632/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:61632/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61664/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61680/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:61680/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61680/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61704/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61712/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61728/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61728/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:61728/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61752/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61760/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61776/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:61776/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61776/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61808/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61824/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61824/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:61824/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61856/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61872/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:61872/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61872/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61904/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61920/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61920/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:61920/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61944/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61952/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61968/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:61968/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:61968/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:61992/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62000/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62016/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62016/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:62016/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62048/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62064/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:62064/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62064/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62088/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62096/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62112/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62112/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:62112/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62136/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62144/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62160/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:62160/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62160/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62192/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62208/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62208/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:62208/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62240/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62256/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:62256/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62256/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62288/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62304/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62304/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:62304/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62328/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62336/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62352/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:62352/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62352/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62376/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62384/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62400/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62400/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:62400/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62432/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62448/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:62448/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62448/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62472/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62480/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62496/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62496/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:62496/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62520/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62528/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62544/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:62544/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62544/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62576/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62592/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62592/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:62592/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62624/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62640/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:62640/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62640/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62672/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62688/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62688/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:62688/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62712/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62720/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62736/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:62736/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62736/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62760/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62768/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62784/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62784/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:62784/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62816/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62832/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:62832/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62832/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62856/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62864/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62880/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62880/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:62880/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62904/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62912/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62928/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:62928/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62928/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:62960/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62976/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:62976/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:62976/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63008/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63024/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:63024/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63024/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63056/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63072/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63072/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:63072/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63096/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63104/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63120/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:63120/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63120/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63144/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63152/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63168/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63168/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:63168/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63200/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63216/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:63216/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63216/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63240/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63248/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63264/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63264/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:63264/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63288/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63296/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63312/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:63312/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63312/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63344/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63360/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63360/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:63360/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63392/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63408/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:63408/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63408/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63440/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63456/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63456/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:63456/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63480/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63488/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63504/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:63504/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63504/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63528/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63536/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63552/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63552/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:63552/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63584/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63600/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:63600/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63600/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63624/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63632/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63648/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63648/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:63648/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63672/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63680/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63696/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:63696/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63696/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63728/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63744/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63744/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:63744/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63776/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63792/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:63792/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63792/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63824/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63840/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63840/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:63840/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63864/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63872/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63888/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:63888/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63888/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63912/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63920/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63936/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63936/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:63936/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:63968/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63984/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:63984/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:63984/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64008/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64016/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64032/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64032/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:64032/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64056/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64064/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64080/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:64080/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64080/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64112/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64128/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64128/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:64128/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64160/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64176/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:64176/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64176/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64208/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64224/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64224/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:64224/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64248/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64256/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64272/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:64272/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64272/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64296/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64304/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64320/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64320/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:64320/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64352/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64368/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:64368/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64368/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64392/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64400/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64416/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64416/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:64416/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64440/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64448/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64464/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:64464/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64464/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64496/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64512/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64512/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:64512/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64544/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64560/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:64560/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64560/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64592/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64608/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64608/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:64608/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64632/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64640/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64656/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:64656/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64656/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64680/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64688/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64704/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64704/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:64704/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64736/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64752/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:64752/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64752/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64776/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64784/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64800/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64800/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:64800/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64824/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64832/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64848/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:64848/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64848/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64880/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64896/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64896/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:64896/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64928/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64944/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:64944/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64944/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:64976/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64992/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:64992/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:64992/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65016/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65024/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65040/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:65040/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65040/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65064/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65072/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65088/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65088/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:65088/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65120/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65136/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:65136/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65136/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65160/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65168/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65184/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65184/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:65184/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65208/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65216/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65232/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:65232/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65232/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65264/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65280/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65280/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:65280/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65312/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65328/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:65328/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65328/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65360/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65376/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65376/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:65376/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65400/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65408/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65424/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:65424/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65424/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65448/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65456/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65472/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65472/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:65472/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65504/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65520/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:65520/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65520/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65544/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65552/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65568/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65568/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:65568/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65592/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65600/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65616/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:65616/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65616/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65648/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65664/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65664/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:65664/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65696/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65712/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:65712/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65712/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65744/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65760/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65760/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:65760/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65784/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65792/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65808/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:65808/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65808/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65832/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65840/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65856/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65856/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:65856/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65888/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65904/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:65904/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65904/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65928/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65936/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65952/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:65952/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:65952/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65976/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:65984/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66000/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:66000/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66000/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66032/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66048/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66048/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:66048/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66080/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66096/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:66096/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66096/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66128/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66144/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66144/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:66144/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66168/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66176/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66192/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:66192/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66192/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66216/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66224/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66240/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66240/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:66240/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66272/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66288/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:66288/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66288/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66312/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66320/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66336/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66336/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:66336/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66360/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66368/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66384/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:66384/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66384/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66416/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66432/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66432/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:66432/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66464/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66480/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:66480/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66480/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66512/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66528/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66528/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:66528/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66552/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66560/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66576/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:66576/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66576/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66600/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66608/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66624/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66624/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:66624/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66656/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66672/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:66672/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66672/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66696/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66704/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66720/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66720/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:66720/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66744/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66752/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66768/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:66768/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66768/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66800/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66816/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66816/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:66816/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66848/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66864/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:66864/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66864/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66896/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66912/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66912/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:66912/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66936/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66944/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66960/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:66960/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:66960/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66984/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:66992/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67008/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67008/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:67008/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67040/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67056/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:67056/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67056/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67080/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67088/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67104/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67104/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:67104/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67128/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67136/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67152/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:67152/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67152/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67184/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67200/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67200/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:67200/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67232/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67248/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:67248/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67248/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67280/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67296/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67296/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:67296/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67320/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67328/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67344/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:67344/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67344/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67368/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67376/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67392/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67392/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:67392/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67424/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67440/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:67440/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67440/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67464/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67472/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67488/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67488/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:67488/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67512/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67520/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67536/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:67536/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67536/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67568/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67584/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67584/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:67584/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67616/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67632/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:67632/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67632/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67664/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67680/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67680/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:67680/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67704/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67712/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67728/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:67728/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67728/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67752/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67760/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67776/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67776/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:67776/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67808/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67824/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:67824/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67824/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67848/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67856/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67872/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67872/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:67872/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67896/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67904/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67920/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:67920/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67920/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:67952/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67968/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:67968/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:67968/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68000/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68016/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:68016/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68016/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68048/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68064/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68064/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:68064/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68088/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68096/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68112/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:68112/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68112/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68136/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68144/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68160/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68160/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:68160/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68192/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68208/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:68208/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68208/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68232/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68240/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68256/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68256/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:68256/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68280/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68288/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68304/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:68304/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68304/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68336/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68352/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68352/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:68352/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68384/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68400/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:68400/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68400/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68432/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68448/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68448/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:68448/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68472/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68480/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68496/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:68496/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68496/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68520/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68528/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68544/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68544/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:68544/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68576/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68592/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:68592/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68592/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68616/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68624/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68640/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68640/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:68640/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68664/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68672/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68688/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:68688/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68688/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68720/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68736/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68736/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:68736/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68768/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68784/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:68784/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68784/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68816/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68832/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68832/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:68832/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68856/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68864/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68880/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:68880/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68880/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68904/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68912/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68928/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68928/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:68928/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:68960/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68976/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:68976/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:68976/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69000/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69008/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69024/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69024/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:69024/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69048/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69056/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69072/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:69072/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69072/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69104/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69120/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69120/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:69120/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69152/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69168/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:69168/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69168/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69200/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69216/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69216/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:69216/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69240/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69248/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69264/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:69264/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69264/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69288/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69296/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69312/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69312/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:69312/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69344/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69360/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:69360/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69360/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69384/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69392/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69408/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69408/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:69408/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69432/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69440/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69456/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:69456/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69456/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69488/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69504/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69504/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:69504/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69536/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69552/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:69552/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69552/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69584/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69600/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69600/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:69600/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69624/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69632/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69648/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:69648/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69648/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69672/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69680/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69696/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69696/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:69696/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69728/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69744/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:69744/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69744/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69768/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69776/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69792/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69792/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:69792/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69816/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69824/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69840/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:69840/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69840/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69872/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69888/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69888/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:69888/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69920/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69936/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:69936/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69936/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:69968/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69984/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:69984/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:69984/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70008/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70016/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70032/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:70032/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70032/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70056/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70064/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70080/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70080/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:70080/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70112/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70128/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:70128/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70128/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70152/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70160/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70176/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70176/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:70176/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70200/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70208/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70224/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:70224/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70224/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70256/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70272/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70272/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:70272/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70304/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70320/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:70320/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70320/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70352/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70368/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70368/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:70368/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70392/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70400/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70416/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:70416/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70416/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70440/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70448/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70464/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70464/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:70464/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70496/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70512/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:70512/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70512/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70536/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70544/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70560/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70560/ druminst35 Equal440 c3 /00:00:48/ 0.992188;
note /00:00:70560/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70584/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70592/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70608/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:70608/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70608/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70640/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70656/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70656/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70688/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70704/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:70704/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70704/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70736/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70752/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70752/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70776/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70784/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70800/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:70800/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70800/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70824/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70832/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70848/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70848/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70880/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70896/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:70896/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70896/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70920/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70928/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70944/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70944/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70968/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:70976/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70992/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:70992/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:70992/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71024/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71040/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71040/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71072/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71088/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:71088/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71088/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71120/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71136/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71136/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71160/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71168/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71184/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:71184/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71184/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71208/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71216/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71232/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71232/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71264/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71280/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:71280/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71280/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71304/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71312/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71328/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71328/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71352/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71360/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71376/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:71376/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71376/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71408/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71424/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71424/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71456/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71472/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:71472/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71472/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71504/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71520/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71520/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71544/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71552/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71568/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:71568/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71568/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71592/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71600/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71616/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71616/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71648/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71664/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:71664/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71664/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71688/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71696/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71712/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71712/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71736/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71744/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71760/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:71760/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71760/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71792/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71808/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71808/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71840/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71856/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:71856/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71856/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71888/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71904/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71904/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71928/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71936/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71952/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:71952/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:71952/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71976/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:71984/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:72000/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:72000/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72032/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:72048/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:72048/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:72048/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72072/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72080/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:72096/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:72096/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72120/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72128/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:72144/ druminst46 Equal440 c3 /00:00:48/ 0.75;
note /00:00:72144/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:72144/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72176/ druminst42 Equal440 c3 /00:00:16/ 0.375;
note /00:00:72192/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72240/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72288/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72312/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72336/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72360/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72384/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72432/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72456/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72480/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72504/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72528/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72576/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72624/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72672/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72696/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72720/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72744/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72768/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72816/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72840/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72864/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72888/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72912/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:72960/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73008/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73056/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73080/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73104/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73128/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73152/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73200/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73224/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73248/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73272/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73296/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73344/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73392/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73440/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73464/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73488/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73512/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73536/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73584/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73608/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73632/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73656/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73680/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73728/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73776/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73824/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73848/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73872/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73896/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73920/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73968/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:73992/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74016/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74040/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74064/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74112/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74160/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74208/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74232/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74256/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74280/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74304/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74352/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74376/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74400/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74424/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74448/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74496/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74544/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74592/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74616/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74640/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74664/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74688/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74736/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74760/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74784/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74808/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74832/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74880/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74928/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:74976/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75000/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75024/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75048/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75072/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75120/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75144/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75168/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75192/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75216/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75264/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75312/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75360/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75384/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75408/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75432/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75456/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75504/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75528/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75552/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75576/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75600/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75648/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75696/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75744/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75768/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75792/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75816/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75840/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75888/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75912/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75936/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75960/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:75984/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76032/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76080/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76128/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76152/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76176/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76200/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76224/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76272/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76296/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76320/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76344/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76368/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76416/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76464/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76512/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76536/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76560/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76584/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76608/ druminst60 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76656/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76680/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76704/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76728/ druminst61 Equal440 c3 /00:00:24/ 0.75;
note /00:00:76752/ druminst61 Equal440 c3 /00:00:24/ 0.75;

--OTHER : 0 Program 4 86
--OTHER : 24576 Program 4 86
note /00:00:24600/ inst4 Equal440 a4 /00:00:24/ 0.0078125;
note /00:00:24624/ inst4 Equal440 d3 /00:00:24/ 0.015625;
note /00:00:24648/ inst4 Equal440 d3 /00:00:24/ 0.03125;
note /00:00:24672/ inst4 Equal440 g3 /00:00:24/ 0.0390625;
note /00:00:24696/ inst4 Equal440 e4 /00:00:24/ 0.046875;
note /00:00:24720/ inst4 Equal440 c4 /00:00:24/ 0.0625;
note /00:00:24744/ inst4 Equal440 e4 /00:00:24/ 0.0703125;
note /00:00:24768/ inst4 Equal440 c4 /00:00:24/ 0.0859375;
note /00:00:24792/ inst4 Equal440 d3 /00:00:24/ 0.09375;
note /00:00:24816/ inst4 Equal440 g3 /00:00:24/ 0.101562;
note /00:00:24840/ inst4 Equal440 d3 /00:00:24/ 0.117188;
note /00:00:24864/ inst4 Equal440 a2 /00:00:24/ 0.125;
note /00:00:24888/ inst4 Equal440 d3 /00:00:24/ 0.132812;
note /00:00:24912/ inst4 Equal440 a2 /00:00:24/ 0.148438;
note /00:00:24936/ inst4 Equal440 g3 /00:00:24/ 0.15625;
note /00:00:24960/ inst4 Equal440 c#4 /00:00:24/ 0.171875;
note /00:00:24984/ inst4 Equal440 f#4 /00:00:24/ 0.179688;
note /00:00:25008/ inst4 Equal440 b2 /00:00:24/ 0.1875;
note /00:00:25032/ inst4 Equal440 b2 /00:00:24/ 0.203125;
note /00:00:25056/ inst4 Equal440 e3 /00:00:24/ 0.210938;
note /00:00:25080/ inst4 Equal440 c#4 /00:00:24/ 0.21875;
note /00:00:25104/ inst4 Equal440 a3 /00:00:24/ 0.234375;
note /00:00:25128/ inst4 Equal440 c#4 /00:00:24/ 0.242188;
note /00:00:25152/ inst4 Equal440 a3 /00:00:24/ 0.257812;
note /00:00:25176/ inst4 Equal440 b2 /00:00:24/ 0.265625;
note /00:00:25200/ inst4 Equal440 e3 /00:00:24/ 0.273438;
note /00:00:25224/ inst4 Equal440 b2 /00:00:24/ 0.289062;
note /00:00:25248/ inst4 Equal440 f#2 /00:00:24/ 0.296875;
note /00:00:25272/ inst4 Equal440 b2 /00:00:24/ 0.304688;
note /00:00:25296/ inst4 Equal440 f#2 /00:00:24/ 0.320312;
note /00:00:25320/ inst4 Equal440 e3 /00:00:24/ 0.328125;
note /00:00:25344/ inst4 Equal440 d4 /00:00:24/ 0.34375;
note /00:00:25368/ inst4 Equal440 g4 /00:00:24/ 0.351562;
note /00:00:25392/ inst4 Equal440 c3 /00:00:24/ 0.359375;
note /00:00:25416/ inst4 Equal440 c3 /00:00:24/ 0.375;
note /00:00:25440/ inst4 Equal440 f3 /00:00:24/ 0.382812;
note /00:00:25464/ inst4 Equal440 d4 /00:00:24/ 0.390625;
note /00:00:25488/ inst4 Equal440 a#3 /00:00:24/ 0.40625;
note /00:00:25512/ inst4 Equal440 d4 /00:00:24/ 0.414062;
note /00:00:25536/ inst4 Equal440 a#3 /00:00:24/ 0.429688;
note /00:00:25560/ inst4 Equal440 c3 /00:00:24/ 0.4375;
note /00:00:25584/ inst4 Equal440 f3 /00:00:24/ 0.445312;
note /00:00:25608/ inst4 Equal440 c3 /00:00:24/ 0.460938;
note /00:00:25632/ inst4 Equal440 g2 /00:00:24/ 0.46875;
note /00:00:25656/ inst4 Equal440 c3 /00:00:24/ 0.476562;
note /00:00:25680/ inst4 Equal440 g2 /00:00:24/ 0.492188;
note /00:00:25704/ inst4 Equal440 f3 /00:00:24/ 0.5;
note /00:00:25728/ inst4 Equal440 b3 /00:00:24/ 0.515625;
note /00:00:25752/ inst4 Equal440 e4 /00:00:24/ 0.523438;
note /00:00:25776/ inst4 Equal440 a2 /00:00:24/ 0.53125;
note /00:00:25800/ inst4 Equal440 a2 /00:00:24/ 0.546875;
note /00:00:25824/ inst4 Equal440 d3 /00:00:24/ 0.554688;
note /00:00:25848/ inst4 Equal440 b3 /00:00:24/ 0.5625;
note /00:00:25872/ inst4 Equal440 g3 /00:00:24/ 0.578125;
note /00:00:25896/ inst4 Equal440 b3 /00:00:24/ 0.585938;
note /00:00:25920/ inst4 Equal440 g3 /00:00:24/ 0.601562;
note /00:00:25944/ inst4 Equal440 a2 /00:00:24/ 0.609375;
note /00:00:25968/ inst4 Equal440 d3 /00:00:24/ 0.617188;
note /00:00:25992/ inst4 Equal440 a2 /00:00:24/ 0.632812;
note /00:00:26016/ inst4 Equal440 e2 /00:00:24/ 0.640625;
note /00:00:26040/ inst4 Equal440 a2 /00:00:24/ 0.648438;
note /00:00:26064/ inst4 Equal440 e2 /00:00:24/ 0.664062;
note /00:00:26088/ inst4 Equal440 d3 /00:00:24/ 0.671875;
note /00:00:26112/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:26136/ inst4 Equal440 a4 /00:00:24/ 0.6875;
note /00:00:26160/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:26184/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:26208/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:26232/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:26256/ inst4 Equal440 c4 /00:00:24/ 0.6875;
note /00:00:26280/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:26304/ inst4 Equal440 c4 /00:00:24/ 0.6875;
note /00:00:26328/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:26352/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:26376/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:26400/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:26424/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:26448/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:26472/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:26496/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:26520/ inst4 Equal440 f#4 /00:00:24/ 0.6875;
note /00:00:26544/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:26568/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:26592/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:26616/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:26640/ inst4 Equal440 a3 /00:00:24/ 0.6875;
note /00:00:26664/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:26688/ inst4 Equal440 a3 /00:00:24/ 0.6875;
note /00:00:26712/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:26736/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:26760/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:26784/ inst4 Equal440 f#2 /00:00:24/ 0.6875;
note /00:00:26808/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:26832/ inst4 Equal440 f#2 /00:00:24/ 0.6875;
note /00:00:26856/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:26880/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:26904/ inst4 Equal440 g4 /00:00:24/ 0.6875;
note /00:00:26928/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:26952/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:26976/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:27000/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:27024/ inst4 Equal440 a#3 /00:00:24/ 0.6875;
note /00:00:27048/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:27072/ inst4 Equal440 a#3 /00:00:24/ 0.6875;
note /00:00:27096/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:27120/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:27144/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:27168/ inst4 Equal440 g2 /00:00:24/ 0.6875;
note /00:00:27192/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:27216/ inst4 Equal440 g2 /00:00:24/ 0.6875;
note /00:00:27240/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:27264/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:27288/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:27312/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:27336/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:27360/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:27384/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:27408/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:27432/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:27456/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:27480/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:27504/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:27528/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:27552/ inst4 Equal440 e2 /00:00:24/ 0.6875;
note /00:00:27576/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:27600/ inst4 Equal440 e2 /00:00:24/ 0.6875;
note /00:00:27624/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:27648/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:27672/ inst4 Equal440 a4 /00:00:24/ 0.671875;
note /00:00:27696/ inst4 Equal440 d3 /00:00:24/ 0.664062;
note /00:00:27720/ inst4 Equal440 d3 /00:00:24/ 0.648438;
note /00:00:27744/ inst4 Equal440 g3 /00:00:24/ 0.640625;
note /00:00:27768/ inst4 Equal440 e4 /00:00:24/ 0.632812;
note /00:00:27792/ inst4 Equal440 c4 /00:00:24/ 0.617188;
note /00:00:27816/ inst4 Equal440 e4 /00:00:24/ 0.609375;
note /00:00:27840/ inst4 Equal440 c4 /00:00:24/ 0.601562;
note /00:00:27864/ inst4 Equal440 d3 /00:00:24/ 0.585938;
note /00:00:27888/ inst4 Equal440 g3 /00:00:24/ 0.578125;
note /00:00:27912/ inst4 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:27936/ inst4 Equal440 a2 /00:00:24/ 0.554688;
note /00:00:27960/ inst4 Equal440 d3 /00:00:24/ 0.546875;
note /00:00:27984/ inst4 Equal440 a2 /00:00:24/ 0.53125;
note /00:00:28008/ inst4 Equal440 g3 /00:00:24/ 0.523438;
note /00:00:28032/ inst4 Equal440 c#4 /00:00:24/ 0.515625;
note /00:00:28056/ inst4 Equal440 f#4 /00:00:24/ 0.5;
note /00:00:28080/ inst4 Equal440 b2 /00:00:24/ 0.492188;
note /00:00:28104/ inst4 Equal440 b2 /00:00:24/ 0.476562;
note /00:00:28128/ inst4 Equal440 e3 /00:00:24/ 0.46875;
note /00:00:28152/ inst4 Equal440 c#4 /00:00:24/ 0.460938;
note /00:00:28176/ inst4 Equal440 a3 /00:00:24/ 0.445312;
note /00:00:28200/ inst4 Equal440 c#4 /00:00:24/ 0.4375;
note /00:00:28224/ inst4 Equal440 a3 /00:00:24/ 0.429688;
note /00:00:28248/ inst4 Equal440 b2 /00:00:24/ 0.414062;
note /00:00:28272/ inst4 Equal440 e3 /00:00:24/ 0.40625;
note /00:00:28296/ inst4 Equal440 b2 /00:00:24/ 0.390625;
note /00:00:28320/ inst4 Equal440 f#2 /00:00:24/ 0.382812;
note /00:00:28344/ inst4 Equal440 b2 /00:00:24/ 0.375;
note /00:00:28368/ inst4 Equal440 f#2 /00:00:24/ 0.359375;
note /00:00:28392/ inst4 Equal440 e3 /00:00:24/ 0.351562;
note /00:00:28416/ inst4 Equal440 d4 /00:00:24/ 0.34375;
note /00:00:28440/ inst4 Equal440 g4 /00:00:24/ 0.328125;
note /00:00:28464/ inst4 Equal440 c3 /00:00:24/ 0.320312;
note /00:00:28488/ inst4 Equal440 c3 /00:00:24/ 0.304688;
note /00:00:28512/ inst4 Equal440 f3 /00:00:24/ 0.296875;
note /00:00:28536/ inst4 Equal440 d4 /00:00:24/ 0.289062;
note /00:00:28560/ inst4 Equal440 a#3 /00:00:24/ 0.273438;
note /00:00:28584/ inst4 Equal440 d4 /00:00:24/ 0.265625;
note /00:00:28608/ inst4 Equal440 a#3 /00:00:24/ 0.257812;
note /00:00:28632/ inst4 Equal440 c3 /00:00:24/ 0.242188;
note /00:00:28656/ inst4 Equal440 f3 /00:00:24/ 0.234375;
note /00:00:28680/ inst4 Equal440 c3 /00:00:24/ 0.21875;
note /00:00:28704/ inst4 Equal440 g2 /00:00:24/ 0.210938;
note /00:00:28728/ inst4 Equal440 c3 /00:00:24/ 0.203125;
note /00:00:28752/ inst4 Equal440 g2 /00:00:24/ 0.1875;
note /00:00:28776/ inst4 Equal440 f3 /00:00:24/ 0.179688;
note /00:00:28800/ inst4 Equal440 b3 /00:00:24/ 0.171875;
note /00:00:28824/ inst4 Equal440 e4 /00:00:24/ 0.15625;
note /00:00:28848/ inst4 Equal440 a2 /00:00:24/ 0.148438;
note /00:00:28872/ inst4 Equal440 a2 /00:00:24/ 0.132812;
note /00:00:28896/ inst4 Equal440 d3 /00:00:24/ 0.125;
note /00:00:28920/ inst4 Equal440 b3 /00:00:24/ 0.117188;
note /00:00:28944/ inst4 Equal440 g3 /00:00:24/ 0.101562;
note /00:00:28968/ inst4 Equal440 b3 /00:00:24/ 0.09375;
note /00:00:28992/ inst4 Equal440 g3 /00:00:24/ 0.0859375;
note /00:00:29016/ inst4 Equal440 a2 /00:00:24/ 0.0703125;
note /00:00:29040/ inst4 Equal440 d3 /00:00:24/ 0.0625;
note /00:00:29064/ inst4 Equal440 a2 /00:00:24/ 0.046875;
note /00:00:29088/ inst4 Equal440 e2 /00:00:24/ 0.0390625;
note /00:00:29112/ inst4 Equal440 a2 /00:00:24/ 0.03125;
note /00:00:29136/ inst4 Equal440 e2 /00:00:24/ 0.015625;
note /00:00:29160/ inst4 Equal440 d3 /00:00:24/ 0.0078125;
--OTHER : 29184 Program 4 90
note /00:00:29208/ inst4 Equal440 a4 /00:00:24/ 0.0078125;
note /00:00:29232/ inst4 Equal440 d3 /00:00:24/ 0.015625;
note /00:00:29256/ inst4 Equal440 d3 /00:00:24/ 0.03125;
note /00:00:29280/ inst4 Equal440 g3 /00:00:24/ 0.0390625;
note /00:00:29304/ inst4 Equal440 e4 /00:00:24/ 0.046875;
note /00:00:29328/ inst4 Equal440 c4 /00:00:24/ 0.0625;
note /00:00:29352/ inst4 Equal440 e4 /00:00:24/ 0.0703125;
note /00:00:29376/ inst4 Equal440 c4 /00:00:24/ 0.0859375;
note /00:00:29400/ inst4 Equal440 d3 /00:00:24/ 0.09375;
note /00:00:29424/ inst4 Equal440 g3 /00:00:24/ 0.101562;
note /00:00:29448/ inst4 Equal440 d3 /00:00:24/ 0.117188;
note /00:00:29472/ inst4 Equal440 a2 /00:00:24/ 0.125;
note /00:00:29496/ inst4 Equal440 d3 /00:00:24/ 0.132812;
note /00:00:29520/ inst4 Equal440 a2 /00:00:24/ 0.148438;
note /00:00:29544/ inst4 Equal440 g3 /00:00:24/ 0.15625;
note /00:00:29568/ inst4 Equal440 c#4 /00:00:24/ 0.171875;
note /00:00:29592/ inst4 Equal440 f#4 /00:00:24/ 0.179688;
note /00:00:29616/ inst4 Equal440 b2 /00:00:24/ 0.1875;
note /00:00:29640/ inst4 Equal440 b2 /00:00:24/ 0.203125;
note /00:00:29664/ inst4 Equal440 e3 /00:00:24/ 0.210938;
note /00:00:29688/ inst4 Equal440 c#4 /00:00:24/ 0.21875;
note /00:00:29712/ inst4 Equal440 a3 /00:00:24/ 0.234375;
note /00:00:29736/ inst4 Equal440 c#4 /00:00:24/ 0.242188;
note /00:00:29760/ inst4 Equal440 a3 /00:00:24/ 0.257812;
note /00:00:29784/ inst4 Equal440 b2 /00:00:24/ 0.265625;
note /00:00:29808/ inst4 Equal440 e3 /00:00:24/ 0.273438;
note /00:00:29832/ inst4 Equal440 b2 /00:00:24/ 0.289062;
note /00:00:29856/ inst4 Equal440 f#2 /00:00:24/ 0.296875;
note /00:00:29880/ inst4 Equal440 b2 /00:00:24/ 0.304688;
note /00:00:29904/ inst4 Equal440 f#2 /00:00:24/ 0.320312;
note /00:00:29928/ inst4 Equal440 e3 /00:00:24/ 0.328125;
note /00:00:29952/ inst4 Equal440 d4 /00:00:24/ 0.34375;
note /00:00:29976/ inst4 Equal440 g4 /00:00:24/ 0.351562;
note /00:00:30000/ inst4 Equal440 c3 /00:00:24/ 0.359375;
note /00:00:30024/ inst4 Equal440 c3 /00:00:24/ 0.375;
note /00:00:30048/ inst4 Equal440 f3 /00:00:24/ 0.382812;
note /00:00:30072/ inst4 Equal440 d4 /00:00:24/ 0.390625;
note /00:00:30096/ inst4 Equal440 a#3 /00:00:24/ 0.40625;
note /00:00:30120/ inst4 Equal440 d4 /00:00:24/ 0.414062;
note /00:00:30144/ inst4 Equal440 a#3 /00:00:24/ 0.429688;
note /00:00:30168/ inst4 Equal440 c3 /00:00:24/ 0.4375;
note /00:00:30192/ inst4 Equal440 f3 /00:00:24/ 0.445312;
note /00:00:30216/ inst4 Equal440 c3 /00:00:24/ 0.460938;
note /00:00:30240/ inst4 Equal440 g2 /00:00:24/ 0.46875;
note /00:00:30264/ inst4 Equal440 c3 /00:00:24/ 0.476562;
note /00:00:30288/ inst4 Equal440 g2 /00:00:24/ 0.492188;
note /00:00:30312/ inst4 Equal440 f3 /00:00:24/ 0.5;
note /00:00:30336/ inst4 Equal440 b3 /00:00:24/ 0.515625;
note /00:00:30360/ inst4 Equal440 e4 /00:00:24/ 0.523438;
note /00:00:30384/ inst4 Equal440 a2 /00:00:24/ 0.53125;
note /00:00:30408/ inst4 Equal440 a2 /00:00:24/ 0.546875;
note /00:00:30432/ inst4 Equal440 d3 /00:00:24/ 0.554688;
note /00:00:30456/ inst4 Equal440 b3 /00:00:24/ 0.5625;
note /00:00:30480/ inst4 Equal440 g3 /00:00:24/ 0.578125;
note /00:00:30504/ inst4 Equal440 b3 /00:00:24/ 0.585938;
note /00:00:30528/ inst4 Equal440 g3 /00:00:24/ 0.601562;
note /00:00:30552/ inst4 Equal440 a2 /00:00:24/ 0.609375;
note /00:00:30576/ inst4 Equal440 d3 /00:00:24/ 0.617188;
note /00:00:30600/ inst4 Equal440 a2 /00:00:24/ 0.632812;
note /00:00:30624/ inst4 Equal440 e2 /00:00:24/ 0.640625;
note /00:00:30648/ inst4 Equal440 a2 /00:00:24/ 0.648438;
note /00:00:30672/ inst4 Equal440 e2 /00:00:24/ 0.664062;
note /00:00:30696/ inst4 Equal440 d3 /00:00:24/ 0.671875;
note /00:00:30720/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:30744/ inst4 Equal440 a4 /00:00:24/ 0.6875;
note /00:00:30768/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:30792/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:30816/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:30840/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:30864/ inst4 Equal440 c4 /00:00:24/ 0.6875;
note /00:00:30888/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:30912/ inst4 Equal440 c4 /00:00:24/ 0.6875;
note /00:00:30936/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:30960/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:30984/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:31008/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:31032/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:31056/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:31080/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:31104/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:31128/ inst4 Equal440 f#4 /00:00:24/ 0.6875;
note /00:00:31152/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:31176/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:31200/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:31224/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:31248/ inst4 Equal440 a3 /00:00:24/ 0.6875;
note /00:00:31272/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:31296/ inst4 Equal440 a3 /00:00:24/ 0.6875;
note /00:00:31320/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:31344/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:31368/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:31392/ inst4 Equal440 f#2 /00:00:24/ 0.6875;
note /00:00:31416/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:31440/ inst4 Equal440 f#2 /00:00:24/ 0.6875;
note /00:00:31464/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:31488/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:31512/ inst4 Equal440 g4 /00:00:24/ 0.6875;
note /00:00:31536/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:31560/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:31584/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:31608/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:31632/ inst4 Equal440 a#3 /00:00:24/ 0.6875;
note /00:00:31656/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:31680/ inst4 Equal440 a#3 /00:00:24/ 0.6875;
note /00:00:31704/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:31728/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:31752/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:31776/ inst4 Equal440 g2 /00:00:24/ 0.6875;
note /00:00:31800/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:31824/ inst4 Equal440 g2 /00:00:24/ 0.6875;
note /00:00:31848/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:31872/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:31896/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:31920/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:31944/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:31968/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:31992/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:32016/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:32040/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:32064/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:32088/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:32112/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:32136/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:32160/ inst4 Equal440 e2 /00:00:24/ 0.6875;
note /00:00:32184/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:32208/ inst4 Equal440 e2 /00:00:24/ 0.6875;
note /00:00:32232/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:32256/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:32280/ inst4 Equal440 a4 /00:00:24/ 0.6875;
note /00:00:32304/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:32328/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:32352/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:32376/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:32400/ inst4 Equal440 c4 /00:00:24/ 0.6875;
note /00:00:32424/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:32448/ inst4 Equal440 c4 /00:00:24/ 0.6875;
note /00:00:32472/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:32496/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:32520/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:32544/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:32568/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:32592/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:32616/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:32640/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:32664/ inst4 Equal440 f#4 /00:00:24/ 0.6875;
note /00:00:32688/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:32712/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:32736/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:32760/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:32784/ inst4 Equal440 a3 /00:00:24/ 0.6875;
note /00:00:32808/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:32832/ inst4 Equal440 a3 /00:00:24/ 0.6875;
note /00:00:32856/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:32880/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:32904/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:32928/ inst4 Equal440 f#2 /00:00:24/ 0.6875;
note /00:00:32952/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:32976/ inst4 Equal440 f#2 /00:00:24/ 0.6875;
note /00:00:33000/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:33024/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:33048/ inst4 Equal440 g4 /00:00:24/ 0.6875;
note /00:00:33072/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:33096/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:33120/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:33144/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:33168/ inst4 Equal440 a#3 /00:00:24/ 0.6875;
note /00:00:33192/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:33216/ inst4 Equal440 a#3 /00:00:24/ 0.6875;
note /00:00:33240/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:33264/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:33288/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:33312/ inst4 Equal440 g2 /00:00:24/ 0.6875;
note /00:00:33336/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:33360/ inst4 Equal440 g2 /00:00:24/ 0.6875;
note /00:00:33384/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:33408/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:33432/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:33456/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:33480/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:33504/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:33528/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:33552/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:33576/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:33600/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:33624/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:33648/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:33672/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:33696/ inst4 Equal440 e2 /00:00:24/ 0.6875;
note /00:00:33720/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:33744/ inst4 Equal440 e2 /00:00:24/ 0.6875;
note /00:00:33768/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:33792/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:33816/ inst4 Equal440 a4 /00:00:24/ 0.6875;
note /00:00:33840/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:33864/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:33888/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:33912/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:33936/ inst4 Equal440 c4 /00:00:24/ 0.6875;
note /00:00:33960/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:33984/ inst4 Equal440 c4 /00:00:24/ 0.6875;
note /00:00:34008/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:34032/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:34056/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:34080/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:34104/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:34128/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:34152/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:34176/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:34200/ inst4 Equal440 f#4 /00:00:24/ 0.6875;
note /00:00:34224/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:34248/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:34272/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:34296/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:34320/ inst4 Equal440 a3 /00:00:24/ 0.6875;
note /00:00:34344/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:34368/ inst4 Equal440 a3 /00:00:24/ 0.6875;
note /00:00:34392/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:34416/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:34440/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:34464/ inst4 Equal440 f#2 /00:00:24/ 0.6875;
note /00:00:34488/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:34512/ inst4 Equal440 f#2 /00:00:24/ 0.6875;
note /00:00:34536/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:34560/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:34584/ inst4 Equal440 g4 /00:00:24/ 0.6875;
note /00:00:34608/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:34632/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:34656/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:34680/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:34704/ inst4 Equal440 a#3 /00:00:24/ 0.6875;
note /00:00:34728/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:34752/ inst4 Equal440 a#3 /00:00:24/ 0.6875;
note /00:00:34776/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:34800/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:34824/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:34848/ inst4 Equal440 g2 /00:00:24/ 0.6875;
note /00:00:34872/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:34896/ inst4 Equal440 g2 /00:00:24/ 0.6875;
note /00:00:34920/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:34944/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:34968/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:34992/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:35016/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:35040/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:35064/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:35088/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:35112/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:35136/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:35160/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:35184/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:35208/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:35232/ inst4 Equal440 e2 /00:00:24/ 0.6875;
note /00:00:35256/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:35280/ inst4 Equal440 e2 /00:00:24/ 0.6875;
note /00:00:35304/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:35328/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:35352/ inst4 Equal440 a4 /00:00:24/ 0.6875;
note /00:00:35376/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:35400/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:35424/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:35448/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:35472/ inst4 Equal440 c4 /00:00:24/ 0.6875;
note /00:00:35496/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:35520/ inst4 Equal440 c4 /00:00:24/ 0.6875;
note /00:00:35544/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:35568/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:35592/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:35616/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:35640/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:35664/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:35688/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:35712/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:35736/ inst4 Equal440 f#4 /00:00:24/ 0.6875;
note /00:00:35760/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:35784/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:35808/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:35832/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:35856/ inst4 Equal440 a3 /00:00:24/ 0.6875;
note /00:00:35880/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:35904/ inst4 Equal440 a3 /00:00:24/ 0.6875;
note /00:00:35928/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:35952/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:35976/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:36000/ inst4 Equal440 f#2 /00:00:24/ 0.6875;
note /00:00:36024/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:36048/ inst4 Equal440 f#2 /00:00:24/ 0.6875;
note /00:00:36072/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:36096/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:36120/ inst4 Equal440 g4 /00:00:24/ 0.6875;
note /00:00:36144/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:36168/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:36192/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:36216/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:36240/ inst4 Equal440 a#3 /00:00:24/ 0.6875;
note /00:00:36264/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:36288/ inst4 Equal440 a#3 /00:00:24/ 0.6875;
note /00:00:36312/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:36336/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:36360/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:36384/ inst4 Equal440 g2 /00:00:24/ 0.6875;
note /00:00:36408/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:36432/ inst4 Equal440 g2 /00:00:24/ 0.6875;
note /00:00:36456/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:36480/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:36504/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:36528/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:36552/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:36576/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:36600/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:36624/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:36648/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:36672/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:36696/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:36720/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:36744/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:36768/ inst4 Equal440 e2 /00:00:24/ 0.6875;
note /00:00:36792/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:36816/ inst4 Equal440 e2 /00:00:24/ 0.6875;
note /00:00:36840/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:36864/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:36888/ inst4 Equal440 a4 /00:00:24/ 0.6875;
note /00:00:36912/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:36936/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:36960/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:36984/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:37008/ inst4 Equal440 c4 /00:00:24/ 0.6875;
note /00:00:37032/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:37056/ inst4 Equal440 c4 /00:00:24/ 0.6875;
note /00:00:37080/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:37104/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:37128/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:37152/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:37176/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:37200/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:37224/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:37248/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:37272/ inst4 Equal440 f#4 /00:00:24/ 0.6875;
note /00:00:37296/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:37320/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:37344/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:37368/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:37392/ inst4 Equal440 a3 /00:00:24/ 0.6875;
note /00:00:37416/ inst4 Equal440 c#4 /00:00:24/ 0.6875;
note /00:00:37440/ inst4 Equal440 a3 /00:00:24/ 0.6875;
note /00:00:37464/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:37488/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:37512/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:37536/ inst4 Equal440 f#2 /00:00:24/ 0.6875;
note /00:00:37560/ inst4 Equal440 b2 /00:00:24/ 0.6875;
note /00:00:37584/ inst4 Equal440 f#2 /00:00:24/ 0.6875;
note /00:00:37608/ inst4 Equal440 e3 /00:00:24/ 0.6875;
note /00:00:37632/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:37656/ inst4 Equal440 g4 /00:00:24/ 0.6875;
note /00:00:37680/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:37704/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:37728/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:37752/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:37776/ inst4 Equal440 a#3 /00:00:24/ 0.6875;
note /00:00:37800/ inst4 Equal440 d4 /00:00:24/ 0.6875;
note /00:00:37824/ inst4 Equal440 a#3 /00:00:24/ 0.6875;
note /00:00:37848/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:37872/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:37896/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:37920/ inst4 Equal440 g2 /00:00:24/ 0.6875;
note /00:00:37944/ inst4 Equal440 c3 /00:00:24/ 0.6875;
note /00:00:37968/ inst4 Equal440 g2 /00:00:24/ 0.6875;
note /00:00:37992/ inst4 Equal440 f3 /00:00:24/ 0.6875;
note /00:00:38016/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:38040/ inst4 Equal440 e4 /00:00:24/ 0.6875;
note /00:00:38064/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:38088/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:38112/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:38136/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:38160/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:38184/ inst4 Equal440 b3 /00:00:24/ 0.6875;
note /00:00:38208/ inst4 Equal440 g3 /00:00:24/ 0.6875;
note /00:00:38232/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:38256/ inst4 Equal440 d3 /00:00:24/ 0.6875;
note /00:00:38280/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:38304/ inst4 Equal440 e2 /00:00:24/ 0.6875;
note /00:00:38328/ inst4 Equal440 a2 /00:00:24/ 0.6875;
note /00:00:38352/ inst4 Equal440 e2 /00:00:24/ 0.6875;
note /00:00:38376/ inst4 Equal440 d3 /00:00:24/ 0.6875;

--OTHER : 0 Program 5 80
note /00:00:3096/ inst5 Equal440 e4 /00:00:24/ 0.0078125;
note /00:00:3120/ inst5 Equal440 a4 /00:00:24/ 0.015625;
note /00:00:3144/ inst5 Equal440 e4 /00:00:24/ 0.0234375;
note /00:00:3168/ inst5 Equal440 a4 /00:00:24/ 0.03125;
note /00:00:3192/ inst5 Equal440 e4 /00:00:24/ 0.0390625;
note /00:00:3216/ inst5 Equal440 a4 /00:00:24/ 0.046875;
note /00:00:3240/ inst5 Equal440 a2 /00:00:24/ 0.0546875;
note /00:00:3264/ inst5 Equal440 a4 /00:00:24/ 0.0703125;
note /00:00:3288/ inst5 Equal440 e4 /00:00:24/ 0.078125;
note /00:00:3312/ inst5 Equal440 c4 /00:00:24/ 0.0859375;
note /00:00:3336/ inst5 Equal440 e4 /00:00:24/ 0.09375;
note /00:00:3360/ inst5 Equal440 c4 /00:00:24/ 0.101562;
note /00:00:3384/ inst5 Equal440 e4 /00:00:24/ 0.109375;
note /00:00:3408/ inst5 Equal440 a4 /00:00:24/ 0.117188;
note /00:00:3432/ inst5 Equal440 a2 /00:00:24/ 0.125;
note /00:00:3456/ inst5 Equal440 a3 /00:00:24/ 0.140625;
note /00:00:3480/ inst5 Equal440 c#4 /00:00:24/ 0.148438;
note /00:00:3504/ inst5 Equal440 f#4 /00:00:24/ 0.15625;
note /00:00:3528/ inst5 Equal440 c#4 /00:00:24/ 0.164062;
note /00:00:3552/ inst5 Equal440 f#4 /00:00:24/ 0.171875;
note /00:00:3576/ inst5 Equal440 c#4 /00:00:24/ 0.179688;
note /00:00:3600/ inst5 Equal440 f#4 /00:00:24/ 0.1875;
note /00:00:3624/ inst5 Equal440 f#2 /00:00:24/ 0.195312;
note /00:00:3648/ inst5 Equal440 f#4 /00:00:24/ 0.210938;
note /00:00:3672/ inst5 Equal440 c#4 /00:00:24/ 0.21875;
note /00:00:3696/ inst5 Equal440 a3 /00:00:24/ 0.226562;
note /00:00:3720/ inst5 Equal440 c#4 /00:00:24/ 0.234375;
note /00:00:3744/ inst5 Equal440 a3 /00:00:24/ 0.242188;
note /00:00:3768/ inst5 Equal440 c#4 /00:00:24/ 0.25;
note /00:00:3792/ inst5 Equal440 f#4 /00:00:24/ 0.257812;
note /00:00:3816/ inst5 Equal440 f#2 /00:00:24/ 0.265625;
note /00:00:3840/ inst5 Equal440 a#3 /00:00:24/ 0.28125;
note /00:00:3864/ inst5 Equal440 d4 /00:00:24/ 0.289062;
note /00:00:3888/ inst5 Equal440 g4 /00:00:24/ 0.296875;
note /00:00:3912/ inst5 Equal440 d4 /00:00:24/ 0.304688;
note /00:00:3936/ inst5 Equal440 g4 /00:00:24/ 0.3125;
note /00:00:3960/ inst5 Equal440 d4 /00:00:24/ 0.320312;
note /00:00:3984/ inst5 Equal440 g4 /00:00:24/ 0.328125;
note /00:00:4008/ inst5 Equal440 g2 /00:00:24/ 0.335938;
note /00:00:4032/ inst5 Equal440 g4 /00:00:24/ 0.351562;
note /00:00:4056/ inst5 Equal440 d4 /00:00:24/ 0.359375;
note /00:00:4080/ inst5 Equal440 a#3 /00:00:24/ 0.367188;
note /00:00:4104/ inst5 Equal440 d4 /00:00:24/ 0.375;
note /00:00:4128/ inst5 Equal440 a#3 /00:00:24/ 0.382812;
note /00:00:4152/ inst5 Equal440 d4 /00:00:24/ 0.390625;
note /00:00:4176/ inst5 Equal440 g4 /00:00:24/ 0.398438;
note /00:00:4200/ inst5 Equal440 g2 /00:00:24/ 0.40625;
note /00:00:4224/ inst5 Equal440 g3 /00:00:24/ 0.421875;
note /00:00:4248/ inst5 Equal440 b3 /00:00:24/ 0.429688;
note /00:00:4272/ inst5 Equal440 e4 /00:00:24/ 0.4375;
note /00:00:4296/ inst5 Equal440 b3 /00:00:24/ 0.445312;
note /00:00:4320/ inst5 Equal440 e4 /00:00:24/ 0.453125;
note /00:00:4344/ inst5 Equal440 b3 /00:00:24/ 0.460938;
note /00:00:4368/ inst5 Equal440 e4 /00:00:24/ 0.46875;
note /00:00:4392/ inst5 Equal440 e2 /00:00:24/ 0.476562;
note /00:00:4416/ inst5 Equal440 e4 /00:00:24/ 0.492188;
note /00:00:4440/ inst5 Equal440 b3 /00:00:24/ 0.5;
note /00:00:4464/ inst5 Equal440 g3 /00:00:24/ 0.507812;
note /00:00:4488/ inst5 Equal440 b3 /00:00:24/ 0.515625;
note /00:00:4512/ inst5 Equal440 g3 /00:00:24/ 0.523438;
note /00:00:4536/ inst5 Equal440 b3 /00:00:24/ 0.53125;
note /00:00:4560/ inst5 Equal440 e4 /00:00:24/ 0.539062;
note /00:00:4584/ inst5 Equal440 e2 /00:00:24/ 0.546875;
note /00:00:4608/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:4632/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:4656/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:4680/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:4704/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:4728/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:4752/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:4776/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:4800/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:4824/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:4848/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:4872/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:4896/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:4920/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:4944/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:4968/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:4992/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:5016/ inst5 Equal440 c#4 /00:00:24/ 0.5625;
note /00:00:5040/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:5064/ inst5 Equal440 c#4 /00:00:24/ 0.5625;
note /00:00:5088/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:5112/ inst5 Equal440 c#4 /00:00:24/ 0.5625;
note /00:00:5136/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:5160/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:5184/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:5208/ inst5 Equal440 c#4 /00:00:24/ 0.5625;
note /00:00:5232/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:5256/ inst5 Equal440 c#4 /00:00:24/ 0.5625;
note /00:00:5280/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:5304/ inst5 Equal440 c#4 /00:00:24/ 0.5625;
note /00:00:5328/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:5352/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:5376/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:5400/ inst5 Equal440 d4 /00:00:24/ 0.5625;
note /00:00:5424/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:5448/ inst5 Equal440 d4 /00:00:24/ 0.5625;
note /00:00:5472/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:5496/ inst5 Equal440 d4 /00:00:24/ 0.5625;
note /00:00:5520/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:5544/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:5568/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:5592/ inst5 Equal440 d4 /00:00:24/ 0.5625;
note /00:00:5616/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:5640/ inst5 Equal440 d4 /00:00:24/ 0.5625;
note /00:00:5664/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:5688/ inst5 Equal440 d4 /00:00:24/ 0.5625;
note /00:00:5712/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:5736/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:5760/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:5784/ inst5 Equal440 b3 /00:00:24/ 0.5625;
note /00:00:5808/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:5832/ inst5 Equal440 b3 /00:00:24/ 0.5625;
note /00:00:5856/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:5880/ inst5 Equal440 b3 /00:00:24/ 0.5625;
note /00:00:5904/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:5928/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:5952/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:5976/ inst5 Equal440 b3 /00:00:24/ 0.5625;
note /00:00:6000/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:6024/ inst5 Equal440 b3 /00:00:24/ 0.5625;
note /00:00:6048/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:6072/ inst5 Equal440 b3 /00:00:24/ 0.5625;
note /00:00:6096/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:6120/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:6144/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:6168/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:6192/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:6216/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:6240/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:6264/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:6288/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:6312/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:6336/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:6360/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:6384/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:6408/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:6432/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:6456/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:6480/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:6504/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:6528/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:6552/ inst5 Equal440 c#4 /00:00:24/ 0.5625;
note /00:00:6576/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:6600/ inst5 Equal440 c#4 /00:00:24/ 0.5625;
note /00:00:6624/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:6648/ inst5 Equal440 c#4 /00:00:24/ 0.5625;
note /00:00:6672/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:6696/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:6720/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:6744/ inst5 Equal440 c#4 /00:00:24/ 0.5625;
note /00:00:6768/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:6792/ inst5 Equal440 c#4 /00:00:24/ 0.5625;
note /00:00:6816/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:6840/ inst5 Equal440 c#4 /00:00:24/ 0.5625;
note /00:00:6864/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:6888/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:6912/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:6936/ inst5 Equal440 d4 /00:00:24/ 0.5625;
note /00:00:6960/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:6984/ inst5 Equal440 d4 /00:00:24/ 0.5625;
note /00:00:7008/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:7032/ inst5 Equal440 d4 /00:00:24/ 0.5625;
note /00:00:7056/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:7080/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:7104/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:7128/ inst5 Equal440 d4 /00:00:24/ 0.5625;
note /00:00:7152/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:7176/ inst5 Equal440 d4 /00:00:24/ 0.5625;
note /00:00:7200/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:7224/ inst5 Equal440 d4 /00:00:24/ 0.5625;
note /00:00:7248/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:7272/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:7296/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:7320/ inst5 Equal440 b3 /00:00:24/ 0.5625;
note /00:00:7344/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:7368/ inst5 Equal440 b3 /00:00:24/ 0.5625;
note /00:00:7392/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:7416/ inst5 Equal440 b3 /00:00:24/ 0.5625;
note /00:00:7440/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:7464/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:7488/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:7512/ inst5 Equal440 b3 /00:00:24/ 0.5625;
note /00:00:7536/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:7560/ inst5 Equal440 b3 /00:00:24/ 0.5625;
note /00:00:7584/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:7608/ inst5 Equal440 b3 /00:00:24/ 0.5625;
note /00:00:7632/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:7656/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:7680/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:7704/ inst5 Equal440 e4 /00:00:24/ 0.546875;
note /00:00:7728/ inst5 Equal440 a4 /00:00:24/ 0.539062;
note /00:00:7752/ inst5 Equal440 e4 /00:00:24/ 0.53125;
note /00:00:7776/ inst5 Equal440 a4 /00:00:24/ 0.523438;
note /00:00:7800/ inst5 Equal440 e4 /00:00:24/ 0.515625;
note /00:00:7824/ inst5 Equal440 a4 /00:00:24/ 0.507812;
note /00:00:7848/ inst5 Equal440 a2 /00:00:24/ 0.5;
note /00:00:7872/ inst5 Equal440 a4 /00:00:24/ 0.492188;
note /00:00:7896/ inst5 Equal440 e4 /00:00:24/ 0.476562;
note /00:00:7920/ inst5 Equal440 c4 /00:00:24/ 0.46875;
note /00:00:7944/ inst5 Equal440 e4 /00:00:24/ 0.460938;
note /00:00:7968/ inst5 Equal440 c4 /00:00:24/ 0.453125;
note /00:00:7992/ inst5 Equal440 e4 /00:00:24/ 0.445312;
note /00:00:8016/ inst5 Equal440 a4 /00:00:24/ 0.4375;
note /00:00:8040/ inst5 Equal440 a2 /00:00:24/ 0.429688;
note /00:00:8064/ inst5 Equal440 a3 /00:00:24/ 0.421875;
note /00:00:8088/ inst5 Equal440 c#4 /00:00:24/ 0.40625;
note /00:00:8112/ inst5 Equal440 f#4 /00:00:24/ 0.398438;
note /00:00:8136/ inst5 Equal440 c#4 /00:00:24/ 0.390625;
note /00:00:8160/ inst5 Equal440 f#4 /00:00:24/ 0.382812;
note /00:00:8184/ inst5 Equal440 c#4 /00:00:24/ 0.375;
note /00:00:8208/ inst5 Equal440 f#4 /00:00:24/ 0.367188;
note /00:00:8232/ inst5 Equal440 f#2 /00:00:24/ 0.359375;
note /00:00:8256/ inst5 Equal440 f#4 /00:00:24/ 0.351562;
note /00:00:8280/ inst5 Equal440 c#4 /00:00:24/ 0.335938;
note /00:00:8304/ inst5 Equal440 a3 /00:00:24/ 0.328125;
note /00:00:8328/ inst5 Equal440 c#4 /00:00:24/ 0.320312;
note /00:00:8352/ inst5 Equal440 a3 /00:00:24/ 0.3125;
note /00:00:8376/ inst5 Equal440 c#4 /00:00:24/ 0.304688;
note /00:00:8400/ inst5 Equal440 f#4 /00:00:24/ 0.296875;
note /00:00:8424/ inst5 Equal440 f#2 /00:00:24/ 0.289062;
note /00:00:8448/ inst5 Equal440 a#3 /00:00:24/ 0.28125;
note /00:00:8472/ inst5 Equal440 d4 /00:00:24/ 0.265625;
note /00:00:8496/ inst5 Equal440 g4 /00:00:24/ 0.257812;
note /00:00:8520/ inst5 Equal440 d4 /00:00:24/ 0.25;
note /00:00:8544/ inst5 Equal440 g4 /00:00:24/ 0.242188;
note /00:00:8568/ inst5 Equal440 d4 /00:00:24/ 0.234375;
note /00:00:8592/ inst5 Equal440 g4 /00:00:24/ 0.226562;
note /00:00:8616/ inst5 Equal440 g2 /00:00:24/ 0.21875;
note /00:00:8640/ inst5 Equal440 g4 /00:00:24/ 0.210938;
note /00:00:8664/ inst5 Equal440 d4 /00:00:24/ 0.195312;
note /00:00:8688/ inst5 Equal440 a#3 /00:00:24/ 0.1875;
note /00:00:8712/ inst5 Equal440 d4 /00:00:24/ 0.179688;
note /00:00:8736/ inst5 Equal440 a#3 /00:00:24/ 0.171875;
note /00:00:8760/ inst5 Equal440 d4 /00:00:24/ 0.164062;
note /00:00:8784/ inst5 Equal440 g4 /00:00:24/ 0.15625;
note /00:00:8808/ inst5 Equal440 g2 /00:00:24/ 0.148438;
note /00:00:8832/ inst5 Equal440 g3 /00:00:24/ 0.140625;
note /00:00:8856/ inst5 Equal440 b3 /00:00:24/ 0.125;
note /00:00:8880/ inst5 Equal440 e4 /00:00:24/ 0.117188;
note /00:00:8904/ inst5 Equal440 b3 /00:00:24/ 0.109375;
note /00:00:8928/ inst5 Equal440 e4 /00:00:24/ 0.101562;
note /00:00:8952/ inst5 Equal440 b3 /00:00:24/ 0.09375;
note /00:00:8976/ inst5 Equal440 e4 /00:00:24/ 0.0859375;
note /00:00:9000/ inst5 Equal440 e2 /00:00:24/ 0.078125;
note /00:00:9024/ inst5 Equal440 e4 /00:00:24/ 0.0703125;
note /00:00:9048/ inst5 Equal440 b3 /00:00:24/ 0.0546875;
note /00:00:9072/ inst5 Equal440 g3 /00:00:24/ 0.046875;
note /00:00:9096/ inst5 Equal440 b3 /00:00:24/ 0.0390625;
note /00:00:9120/ inst5 Equal440 g3 /00:00:24/ 0.03125;
note /00:00:9144/ inst5 Equal440 b3 /00:00:24/ 0.0234375;
note /00:00:9168/ inst5 Equal440 e4 /00:00:24/ 0.015625;
note /00:00:9192/ inst5 Equal440 e2 /00:00:24/ 0.0078125;
note /00:00:9240/ inst5 Equal440 a4 /00:00:24/ 0.0078125;
note /00:00:9264/ inst5 Equal440 a2 /00:00:24/ 0.015625;
note /00:00:9288/ inst5 Equal440 d3 /00:00:24/ 0.0234375;
note /00:00:9312/ inst5 Equal440 g3 /00:00:24/ 0.03125;
note /00:00:9336/ inst5 Equal440 d3 /00:00:24/ 0.0390625;
note /00:00:9360/ inst5 Equal440 a2 /00:00:24/ 0.046875;
note /00:00:9384/ inst5 Equal440 d3 /00:00:24/ 0.0546875;
note /00:00:9408/ inst5 Equal440 a2 /00:00:24/ 0.0703125;
note /00:00:9432/ inst5 Equal440 d3 /00:00:24/ 0.078125;
note /00:00:9456/ inst5 Equal440 g3 /00:00:24/ 0.0859375;
note /00:00:9480/ inst5 Equal440 d3 /00:00:24/ 0.09375;
note /00:00:9504/ inst5 Equal440 g3 /00:00:24/ 0.101562;
note /00:00:9528/ inst5 Equal440 d3 /00:00:24/ 0.109375;
note /00:00:9552/ inst5 Equal440 g3 /00:00:24/ 0.117188;
note /00:00:9576/ inst5 Equal440 d3 /00:00:24/ 0.125;
note /00:00:9600/ inst5 Equal440 f#2 /00:00:24/ 0.140625;
note /00:00:9624/ inst5 Equal440 f#4 /00:00:24/ 0.148438;
note /00:00:9648/ inst5 Equal440 f#2 /00:00:24/ 0.15625;
note /00:00:9672/ inst5 Equal440 b2 /00:00:24/ 0.164062;
note /00:00:9696/ inst5 Equal440 e3 /00:00:24/ 0.171875;
note /00:00:9720/ inst5 Equal440 b2 /00:00:24/ 0.179688;
note /00:00:9744/ inst5 Equal440 f#2 /00:00:24/ 0.1875;
note /00:00:9768/ inst5 Equal440 b2 /00:00:24/ 0.195312;
note /00:00:9792/ inst5 Equal440 f#2 /00:00:24/ 0.210938;
note /00:00:9816/ inst5 Equal440 b2 /00:00:24/ 0.21875;
note /00:00:9840/ inst5 Equal440 e3 /00:00:24/ 0.226562;
note /00:00:9864/ inst5 Equal440 b2 /00:00:24/ 0.234375;
note /00:00:9888/ inst5 Equal440 e3 /00:00:24/ 0.242188;
note /00:00:9912/ inst5 Equal440 b2 /00:00:24/ 0.25;
note /00:00:9936/ inst5 Equal440 e3 /00:00:24/ 0.257812;
note /00:00:9960/ inst5 Equal440 b2 /00:00:24/ 0.265625;
note /00:00:9984/ inst5 Equal440 g2 /00:00:24/ 0.28125;
note /00:00:10008/ inst5 Equal440 g4 /00:00:24/ 0.289062;
note /00:00:10032/ inst5 Equal440 g2 /00:00:24/ 0.296875;
note /00:00:10056/ inst5 Equal440 c3 /00:00:24/ 0.304688;
note /00:00:10080/ inst5 Equal440 f3 /00:00:24/ 0.3125;
note /00:00:10104/ inst5 Equal440 c3 /00:00:24/ 0.320312;
note /00:00:10128/ inst5 Equal440 g2 /00:00:24/ 0.328125;
note /00:00:10152/ inst5 Equal440 c3 /00:00:24/ 0.335938;
note /00:00:10176/ inst5 Equal440 g2 /00:00:24/ 0.351562;
note /00:00:10200/ inst5 Equal440 c3 /00:00:24/ 0.359375;
note /00:00:10224/ inst5 Equal440 f3 /00:00:24/ 0.367188;
note /00:00:10248/ inst5 Equal440 c3 /00:00:24/ 0.375;
note /00:00:10272/ inst5 Equal440 f3 /00:00:24/ 0.382812;
note /00:00:10296/ inst5 Equal440 c3 /00:00:24/ 0.390625;
note /00:00:10320/ inst5 Equal440 f3 /00:00:24/ 0.398438;
note /00:00:10344/ inst5 Equal440 c3 /00:00:24/ 0.40625;
note /00:00:10368/ inst5 Equal440 e2 /00:00:24/ 0.421875;
note /00:00:10392/ inst5 Equal440 e4 /00:00:24/ 0.429688;
note /00:00:10416/ inst5 Equal440 e2 /00:00:24/ 0.4375;
note /00:00:10440/ inst5 Equal440 a2 /00:00:24/ 0.445312;
note /00:00:10464/ inst5 Equal440 d3 /00:00:24/ 0.453125;
note /00:00:10488/ inst5 Equal440 a2 /00:00:24/ 0.460938;
note /00:00:10512/ inst5 Equal440 e2 /00:00:24/ 0.46875;
note /00:00:10536/ inst5 Equal440 a2 /00:00:24/ 0.476562;
note /00:00:10560/ inst5 Equal440 e2 /00:00:24/ 0.492188;
note /00:00:10584/ inst5 Equal440 a2 /00:00:24/ 0.5;
note /00:00:10608/ inst5 Equal440 d3 /00:00:24/ 0.507812;
note /00:00:10632/ inst5 Equal440 a2 /00:00:24/ 0.515625;
note /00:00:10656/ inst5 Equal440 d3 /00:00:24/ 0.523438;
note /00:00:10680/ inst5 Equal440 a2 /00:00:24/ 0.53125;
note /00:00:10704/ inst5 Equal440 d3 /00:00:24/ 0.539062;
note /00:00:10728/ inst5 Equal440 a2 /00:00:24/ 0.546875;
note /00:00:10752/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:10776/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:10800/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:10824/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:10848/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:10872/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:10896/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:10920/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:10944/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:10968/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:10992/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:11016/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:11040/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:11064/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:11088/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:11112/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:11136/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:11160/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:11184/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:11208/ inst5 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:11232/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:11256/ inst5 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:11280/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:11304/ inst5 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:11328/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:11352/ inst5 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:11376/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:11400/ inst5 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:11424/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:11448/ inst5 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:11472/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:11496/ inst5 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:11520/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:11544/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:11568/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:11592/ inst5 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:11616/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:11640/ inst5 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:11664/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:11688/ inst5 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:11712/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:11736/ inst5 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:11760/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:11784/ inst5 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:11808/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:11832/ inst5 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:11856/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:11880/ inst5 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:11904/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:11928/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:11952/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:11976/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:12000/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:12024/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:12048/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:12072/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:12096/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:12120/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:12144/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:12168/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:12192/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:12216/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:12240/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:12264/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:12288/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:12312/ inst5 Equal440 a4 /00:00:24/ 0.546875;
note /00:00:12336/ inst5 Equal440 a2 /00:00:24/ 0.539062;
note /00:00:12360/ inst5 Equal440 d3 /00:00:24/ 0.53125;
note /00:00:12384/ inst5 Equal440 g3 /00:00:24/ 0.523438;
note /00:00:12408/ inst5 Equal440 d3 /00:00:24/ 0.515625;
note /00:00:12432/ inst5 Equal440 a2 /00:00:24/ 0.507812;
note /00:00:12456/ inst5 Equal440 d3 /00:00:24/ 0.5;
note /00:00:12480/ inst5 Equal440 a2 /00:00:24/ 0.492188;
note /00:00:12504/ inst5 Equal440 d3 /00:00:24/ 0.476562;
note /00:00:12528/ inst5 Equal440 g3 /00:00:24/ 0.46875;
note /00:00:12552/ inst5 Equal440 d3 /00:00:24/ 0.460938;
note /00:00:12576/ inst5 Equal440 g3 /00:00:24/ 0.453125;
note /00:00:12600/ inst5 Equal440 d3 /00:00:24/ 0.445312;
note /00:00:12624/ inst5 Equal440 g3 /00:00:24/ 0.4375;
note /00:00:12648/ inst5 Equal440 d3 /00:00:24/ 0.429688;
note /00:00:12672/ inst5 Equal440 f#2 /00:00:24/ 0.421875;
note /00:00:12696/ inst5 Equal440 f#4 /00:00:24/ 0.40625;
note /00:00:12720/ inst5 Equal440 f#2 /00:00:24/ 0.398438;
note /00:00:12744/ inst5 Equal440 b2 /00:00:24/ 0.390625;
note /00:00:12768/ inst5 Equal440 e3 /00:00:24/ 0.382812;
note /00:00:12792/ inst5 Equal440 b2 /00:00:24/ 0.375;
note /00:00:12816/ inst5 Equal440 f#2 /00:00:24/ 0.367188;
note /00:00:12840/ inst5 Equal440 b2 /00:00:24/ 0.359375;
note /00:00:12864/ inst5 Equal440 f#2 /00:00:24/ 0.351562;
note /00:00:12888/ inst5 Equal440 b2 /00:00:24/ 0.335938;
note /00:00:12912/ inst5 Equal440 e3 /00:00:24/ 0.328125;
note /00:00:12936/ inst5 Equal440 b2 /00:00:24/ 0.320312;
note /00:00:12960/ inst5 Equal440 e3 /00:00:24/ 0.3125;
note /00:00:12984/ inst5 Equal440 b2 /00:00:24/ 0.304688;
note /00:00:13008/ inst5 Equal440 e3 /00:00:24/ 0.296875;
note /00:00:13032/ inst5 Equal440 b2 /00:00:24/ 0.289062;
note /00:00:13056/ inst5 Equal440 g2 /00:00:24/ 0.28125;
note /00:00:13080/ inst5 Equal440 g4 /00:00:24/ 0.265625;
note /00:00:13104/ inst5 Equal440 g2 /00:00:24/ 0.257812;
note /00:00:13128/ inst5 Equal440 c3 /00:00:24/ 0.25;
note /00:00:13152/ inst5 Equal440 f3 /00:00:24/ 0.242188;
note /00:00:13176/ inst5 Equal440 c3 /00:00:24/ 0.234375;
note /00:00:13200/ inst5 Equal440 g2 /00:00:24/ 0.226562;
note /00:00:13224/ inst5 Equal440 c3 /00:00:24/ 0.21875;
note /00:00:13248/ inst5 Equal440 g2 /00:00:24/ 0.210938;
note /00:00:13272/ inst5 Equal440 c3 /00:00:24/ 0.195312;
note /00:00:13296/ inst5 Equal440 f3 /00:00:24/ 0.1875;
note /00:00:13320/ inst5 Equal440 c3 /00:00:24/ 0.179688;
note /00:00:13344/ inst5 Equal440 f3 /00:00:24/ 0.171875;
note /00:00:13368/ inst5 Equal440 c3 /00:00:24/ 0.164062;
note /00:00:13392/ inst5 Equal440 f3 /00:00:24/ 0.15625;
note /00:00:13416/ inst5 Equal440 c3 /00:00:24/ 0.148438;
note /00:00:13440/ inst5 Equal440 e2 /00:00:24/ 0.140625;
note /00:00:13464/ inst5 Equal440 e4 /00:00:24/ 0.125;
note /00:00:13488/ inst5 Equal440 e2 /00:00:24/ 0.117188;
note /00:00:13512/ inst5 Equal440 a2 /00:00:24/ 0.109375;
note /00:00:13536/ inst5 Equal440 d3 /00:00:24/ 0.101562;
note /00:00:13560/ inst5 Equal440 a2 /00:00:24/ 0.09375;
note /00:00:13584/ inst5 Equal440 e2 /00:00:24/ 0.0859375;
note /00:00:13608/ inst5 Equal440 a2 /00:00:24/ 0.078125;
note /00:00:13632/ inst5 Equal440 e2 /00:00:24/ 0.0703125;
note /00:00:13656/ inst5 Equal440 a2 /00:00:24/ 0.0546875;
note /00:00:13680/ inst5 Equal440 d3 /00:00:24/ 0.046875;
note /00:00:13704/ inst5 Equal440 a2 /00:00:24/ 0.0390625;
note /00:00:13728/ inst5 Equal440 d3 /00:00:24/ 0.03125;
note /00:00:13752/ inst5 Equal440 a2 /00:00:24/ 0.0234375;
note /00:00:13776/ inst5 Equal440 d3 /00:00:24/ 0.015625;
note /00:00:13800/ inst5 Equal440 a2 /00:00:24/ 0.0078125;
note /00:00:33816/ inst5 Equal440 a2 /00:00:24/ 0.0078125;
note /00:00:33840/ inst5 Equal440 a2 /00:00:24/ 0.015625;
note /00:00:33864/ inst5 Equal440 g3 /00:00:24/ 0.0234375;
note /00:00:33888/ inst5 Equal440 a2 /00:00:24/ 0.03125;
note /00:00:33912/ inst5 Equal440 a2 /00:00:24/ 0.0390625;
note /00:00:33936/ inst5 Equal440 g3 /00:00:24/ 0.046875;
note /00:00:33960/ inst5 Equal440 a2 /00:00:24/ 0.0546875;
note /00:00:33984/ inst5 Equal440 a2 /00:00:24/ 0.0703125;
note /00:00:34008/ inst5 Equal440 g3 /00:00:24/ 0.078125;
note /00:00:34032/ inst5 Equal440 a2 /00:00:24/ 0.0859375;
note /00:00:34056/ inst5 Equal440 a2 /00:00:24/ 0.09375;
note /00:00:34080/ inst5 Equal440 g3 /00:00:24/ 0.101562;
note /00:00:34104/ inst5 Equal440 a2 /00:00:24/ 0.109375;
note /00:00:34128/ inst5 Equal440 a2 /00:00:24/ 0.117188;
note /00:00:34152/ inst5 Equal440 g3 /00:00:24/ 0.125;
note /00:00:34176/ inst5 Equal440 e3 /00:00:24/ 0.140625;
note /00:00:34200/ inst5 Equal440 f#2 /00:00:24/ 0.148438;
note /00:00:34224/ inst5 Equal440 f#2 /00:00:24/ 0.15625;
note /00:00:34248/ inst5 Equal440 e3 /00:00:24/ 0.164062;
note /00:00:34272/ inst5 Equal440 f#2 /00:00:24/ 0.171875;
note /00:00:34296/ inst5 Equal440 f#2 /00:00:24/ 0.179688;
note /00:00:34320/ inst5 Equal440 e3 /00:00:24/ 0.1875;
note /00:00:34344/ inst5 Equal440 f#2 /00:00:24/ 0.195312;
note /00:00:34368/ inst5 Equal440 f#2 /00:00:24/ 0.210938;
note /00:00:34392/ inst5 Equal440 e3 /00:00:24/ 0.21875;
note /00:00:34416/ inst5 Equal440 f#2 /00:00:24/ 0.226562;
note /00:00:34440/ inst5 Equal440 f#2 /00:00:24/ 0.234375;
note /00:00:34464/ inst5 Equal440 e3 /00:00:24/ 0.242188;
note /00:00:34488/ inst5 Equal440 f#2 /00:00:24/ 0.25;
note /00:00:34512/ inst5 Equal440 f#2 /00:00:24/ 0.257812;
note /00:00:34536/ inst5 Equal440 e3 /00:00:24/ 0.265625;
note /00:00:34560/ inst5 Equal440 f3 /00:00:24/ 0.28125;
note /00:00:34584/ inst5 Equal440 g2 /00:00:24/ 0.289062;
note /00:00:34608/ inst5 Equal440 g2 /00:00:24/ 0.296875;
note /00:00:34632/ inst5 Equal440 f3 /00:00:24/ 0.304688;
note /00:00:34656/ inst5 Equal440 g2 /00:00:24/ 0.3125;
note /00:00:34680/ inst5 Equal440 g2 /00:00:24/ 0.320312;
note /00:00:34704/ inst5 Equal440 f3 /00:00:24/ 0.328125;
note /00:00:34728/ inst5 Equal440 g2 /00:00:24/ 0.335938;
note /00:00:34752/ inst5 Equal440 g2 /00:00:24/ 0.351562;
note /00:00:34776/ inst5 Equal440 f3 /00:00:24/ 0.359375;
note /00:00:34800/ inst5 Equal440 g2 /00:00:24/ 0.367188;
note /00:00:34824/ inst5 Equal440 g2 /00:00:24/ 0.375;
note /00:00:34848/ inst5 Equal440 f3 /00:00:24/ 0.382812;
note /00:00:34872/ inst5 Equal440 g2 /00:00:24/ 0.390625;
note /00:00:34896/ inst5 Equal440 g2 /00:00:24/ 0.398438;
note /00:00:34920/ inst5 Equal440 f3 /00:00:24/ 0.40625;
note /00:00:34944/ inst5 Equal440 d3 /00:00:24/ 0.421875;
note /00:00:34968/ inst5 Equal440 e2 /00:00:24/ 0.429688;
note /00:00:34992/ inst5 Equal440 e2 /00:00:24/ 0.4375;
note /00:00:35016/ inst5 Equal440 d3 /00:00:24/ 0.445312;
note /00:00:35040/ inst5 Equal440 e2 /00:00:24/ 0.453125;
note /00:00:35064/ inst5 Equal440 e2 /00:00:24/ 0.460938;
note /00:00:35088/ inst5 Equal440 d3 /00:00:24/ 0.46875;
note /00:00:35112/ inst5 Equal440 e2 /00:00:24/ 0.476562;
note /00:00:35136/ inst5 Equal440 e2 /00:00:24/ 0.492188;
note /00:00:35160/ inst5 Equal440 d3 /00:00:24/ 0.5;
note /00:00:35184/ inst5 Equal440 e2 /00:00:24/ 0.507812;
note /00:00:35208/ inst5 Equal440 e2 /00:00:24/ 0.515625;
note /00:00:35232/ inst5 Equal440 d3 /00:00:24/ 0.523438;
note /00:00:35256/ inst5 Equal440 e2 /00:00:24/ 0.53125;
note /00:00:35280/ inst5 Equal440 e2 /00:00:24/ 0.539062;
note /00:00:35304/ inst5 Equal440 d3 /00:00:24/ 0.546875;
note /00:00:35328/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:35352/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:35376/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:35400/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:35424/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:35448/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:35472/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:35496/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:35520/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:35544/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:35568/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:35592/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:35616/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:35640/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:35664/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:35688/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:35712/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:35736/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:35760/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:35784/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:35808/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:35832/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:35856/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:35880/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:35904/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:35928/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:35952/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:35976/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:36000/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:36024/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:36048/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:36072/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:36096/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:36120/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:36144/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:36168/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:36192/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:36216/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:36240/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:36264/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:36288/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:36312/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:36336/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:36360/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:36384/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:36408/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:36432/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:36456/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:36480/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:36504/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:36528/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:36552/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:36576/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:36600/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:36624/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:36648/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:36672/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:36696/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:36720/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:36744/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:36768/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:36792/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:36816/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:36840/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:36864/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:36888/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:36912/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:36936/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:36960/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:36984/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:37008/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:37032/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:37056/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:37080/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:37104/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:37128/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:37152/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:37176/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:37200/ inst5 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:37224/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:37248/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:37272/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:37296/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:37320/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:37344/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:37368/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:37392/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:37416/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:37440/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:37464/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:37488/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:37512/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:37536/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:37560/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:37584/ inst5 Equal440 f#2 /00:00:24/ 0.5625;
note /00:00:37608/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:37632/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:37656/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:37680/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:37704/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:37728/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:37752/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:37776/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:37800/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:37824/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:37848/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:37872/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:37896/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:37920/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:37944/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:37968/ inst5 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:37992/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:38016/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:38040/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:38064/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:38088/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:38112/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:38136/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:38160/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:38184/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:38208/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:38232/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:38256/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:38280/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:38304/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:38328/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:38352/ inst5 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:38376/ inst5 Equal440 d3 /00:00:24/ 0.5625;
--OTHER : 43008 Program 5 100
note /00:00:43032/ inst5 Equal440 g3 /00:00:24/ 0.0078125;
note /00:00:43056/ inst5 Equal440 c4 /00:00:24/ 0.015625;
note /00:00:43080/ inst5 Equal440 a4 /00:00:24/ 0.0234375;
note /00:00:43104/ inst5 Equal440 g3 /00:00:24/ 0.03125;
note /00:00:43128/ inst5 Equal440 c4 /00:00:24/ 0.0390625;
note /00:00:43152/ inst5 Equal440 a4 /00:00:24/ 0.046875;
note /00:00:43176/ inst5 Equal440 g3 /00:00:24/ 0.0546875;
note /00:00:43200/ inst5 Equal440 c4 /00:00:24/ 0.0703125;
note /00:00:43224/ inst5 Equal440 a4 /00:00:24/ 0.078125;
note /00:00:43248/ inst5 Equal440 g3 /00:00:24/ 0.0859375;
note /00:00:43272/ inst5 Equal440 c4 /00:00:24/ 0.09375;
note /00:00:43296/ inst5 Equal440 a4 /00:00:24/ 0.101562;
note /00:00:43320/ inst5 Equal440 g3 /00:00:24/ 0.109375;
note /00:00:43344/ inst5 Equal440 c4 /00:00:24/ 0.117188;
note /00:00:43368/ inst5 Equal440 a4 /00:00:24/ 0.125;
note /00:00:43392/ inst5 Equal440 f#4 /00:00:24/ 0.140625;
note /00:00:43416/ inst5 Equal440 e3 /00:00:24/ 0.148438;
note /00:00:43440/ inst5 Equal440 a3 /00:00:24/ 0.15625;
note /00:00:43464/ inst5 Equal440 f#4 /00:00:24/ 0.164062;
note /00:00:43488/ inst5 Equal440 e3 /00:00:24/ 0.171875;
note /00:00:43512/ inst5 Equal440 a3 /00:00:24/ 0.179688;
note /00:00:43536/ inst5 Equal440 f#4 /00:00:24/ 0.1875;
note /00:00:43560/ inst5 Equal440 e3 /00:00:24/ 0.195312;
note /00:00:43584/ inst5 Equal440 a3 /00:00:24/ 0.210938;
note /00:00:43608/ inst5 Equal440 f#4 /00:00:24/ 0.21875;
note /00:00:43632/ inst5 Equal440 e3 /00:00:24/ 0.226562;
note /00:00:43656/ inst5 Equal440 a3 /00:00:24/ 0.234375;
note /00:00:43680/ inst5 Equal440 f#4 /00:00:24/ 0.242188;
note /00:00:43704/ inst5 Equal440 e3 /00:00:24/ 0.25;
note /00:00:43728/ inst5 Equal440 a3 /00:00:24/ 0.257812;
note /00:00:43752/ inst5 Equal440 f#4 /00:00:24/ 0.265625;
note /00:00:43776/ inst5 Equal440 g4 /00:00:24/ 0.28125;
note /00:00:43800/ inst5 Equal440 f3 /00:00:24/ 0.289062;
note /00:00:43824/ inst5 Equal440 a#3 /00:00:24/ 0.296875;
note /00:00:43848/ inst5 Equal440 g4 /00:00:24/ 0.304688;
note /00:00:43872/ inst5 Equal440 f3 /00:00:24/ 0.3125;
note /00:00:43896/ inst5 Equal440 a#3 /00:00:24/ 0.320312;
note /00:00:43920/ inst5 Equal440 g4 /00:00:24/ 0.328125;
note /00:00:43944/ inst5 Equal440 f3 /00:00:24/ 0.335938;
note /00:00:43968/ inst5 Equal440 a#3 /00:00:24/ 0.351562;
note /00:00:43992/ inst5 Equal440 g4 /00:00:24/ 0.359375;
note /00:00:44016/ inst5 Equal440 f3 /00:00:24/ 0.367188;
note /00:00:44040/ inst5 Equal440 a#3 /00:00:24/ 0.375;
note /00:00:44064/ inst5 Equal440 g4 /00:00:24/ 0.382812;
note /00:00:44088/ inst5 Equal440 f3 /00:00:24/ 0.390625;
note /00:00:44112/ inst5 Equal440 a#3 /00:00:24/ 0.398438;
note /00:00:44136/ inst5 Equal440 g4 /00:00:24/ 0.40625;
note /00:00:44160/ inst5 Equal440 e4 /00:00:24/ 0.421875;
note /00:00:44184/ inst5 Equal440 d3 /00:00:24/ 0.429688;
note /00:00:44208/ inst5 Equal440 g3 /00:00:24/ 0.4375;
note /00:00:44232/ inst5 Equal440 e4 /00:00:24/ 0.445312;
note /00:00:44256/ inst5 Equal440 d3 /00:00:24/ 0.453125;
note /00:00:44280/ inst5 Equal440 g3 /00:00:24/ 0.460938;
note /00:00:44304/ inst5 Equal440 e4 /00:00:24/ 0.46875;
note /00:00:44328/ inst5 Equal440 d3 /00:00:24/ 0.476562;
note /00:00:44352/ inst5 Equal440 g3 /00:00:24/ 0.492188;
note /00:00:44376/ inst5 Equal440 e4 /00:00:24/ 0.5;
note /00:00:44400/ inst5 Equal440 d3 /00:00:24/ 0.507812;
note /00:00:44424/ inst5 Equal440 g3 /00:00:24/ 0.515625;
note /00:00:44448/ inst5 Equal440 e4 /00:00:24/ 0.523438;
note /00:00:44472/ inst5 Equal440 d3 /00:00:24/ 0.53125;
note /00:00:44496/ inst5 Equal440 g3 /00:00:24/ 0.539062;
note /00:00:44520/ inst5 Equal440 e4 /00:00:24/ 0.546875;
note /00:00:44544/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:44568/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:44592/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:44616/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:44640/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:44664/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:44688/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:44712/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:44736/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:44760/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:44784/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:44808/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:44832/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:44856/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:44880/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:44904/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:44928/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:44952/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:44976/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:45000/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:45024/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:45048/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:45072/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:45096/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:45120/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:45144/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:45168/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:45192/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:45216/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:45240/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:45264/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:45288/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:45312/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:45336/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:45360/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:45384/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:45408/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:45432/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:45456/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:45480/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:45504/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:45528/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:45552/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:45576/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:45600/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:45624/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:45648/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:45672/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:45696/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:45720/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:45744/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:45768/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:45792/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:45816/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:45840/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:45864/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:45888/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:45912/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:45936/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:45960/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:45984/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:46008/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:46032/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:46056/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:46080/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:46104/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:46128/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:46152/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:46176/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:46200/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:46224/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:46248/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:46272/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:46296/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:46320/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:46344/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:46368/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:46392/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:46416/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:46440/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:46464/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:46488/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:46512/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:46536/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:46560/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:46584/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:46608/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:46632/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:46656/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:46680/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:46704/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:46728/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:46752/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:46776/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:46800/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:46824/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:46848/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:46872/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:46896/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:46920/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:46944/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:46968/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:46992/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:47016/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:47040/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:47064/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:47088/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:47112/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:47136/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:47160/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:47184/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:47208/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:47232/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:47256/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:47280/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:47304/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:47328/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:47352/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:47376/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:47400/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:47424/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:47448/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:47472/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:47496/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:47520/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:47544/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:47568/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:47592/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:47616/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:47640/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:47664/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:47688/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:47712/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:47736/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:47760/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:47784/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:47808/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:47832/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:47856/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:47880/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:47904/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:47928/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:47952/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:47976/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:48000/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:48024/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:48048/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:48072/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:48096/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:48120/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:48144/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:48168/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:48192/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:48216/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:48240/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:48264/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:48288/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:48312/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:48336/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:48360/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:48384/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:48408/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:48432/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:48456/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:48480/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:48504/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:48528/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:48552/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:48576/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:48600/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:48624/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:48648/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:48672/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:48696/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:48720/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:48744/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:48768/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:48792/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:48816/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:48840/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:48864/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:48888/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:48912/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:48936/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:48960/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:48984/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:49008/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:49032/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:49056/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:49080/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:49104/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:49128/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:49152/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:49176/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:49200/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:49224/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:49248/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:49272/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:49296/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:49320/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:49344/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:49368/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:49392/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:49416/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:49440/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:49464/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:49488/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:49512/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:49536/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:49560/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:49584/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:49608/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:49632/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:49656/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:49680/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:49704/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:49728/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:49752/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:49776/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:49800/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:49824/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:49848/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:49872/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:49896/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:49920/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:49944/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:49968/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:49992/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:50016/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:50040/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:50064/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:50088/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:50112/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:50136/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:50160/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:50184/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:50208/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:50232/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:50256/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:50280/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:50304/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:50328/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:50352/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:50376/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:50400/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:50424/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:50448/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:50472/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:50496/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:50520/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:50544/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:50568/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:50592/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:50616/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:50640/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:50664/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:50688/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:50712/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:50736/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:50760/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:50784/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:50808/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:50832/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:50856/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:50880/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:50904/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:50928/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:50952/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:50976/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:51000/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:51024/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:51048/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:51072/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:51096/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:51120/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:51144/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:51168/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:51192/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:51216/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:51240/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:51264/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:51288/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:51312/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:51336/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:51360/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:51384/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:51408/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:51432/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:51456/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:51480/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:51504/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:51528/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:51552/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:51576/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:51600/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:51624/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:51648/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:51672/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:51696/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:51720/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:51744/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:51768/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:51792/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:51816/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:51840/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:51864/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:51888/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:51912/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:51936/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:51960/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:51984/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:52008/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:52032/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:52056/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:52080/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:52104/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:52128/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:52152/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:52176/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:52200/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:52224/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:52248/ inst5 Equal440 g3 /00:00:24/ 0.546875;
note /00:00:52272/ inst5 Equal440 c4 /00:00:24/ 0.539062;
note /00:00:52296/ inst5 Equal440 a4 /00:00:24/ 0.53125;
note /00:00:52320/ inst5 Equal440 g3 /00:00:24/ 0.523438;
note /00:00:52344/ inst5 Equal440 c4 /00:00:24/ 0.515625;
note /00:00:52368/ inst5 Equal440 a4 /00:00:24/ 0.507812;
note /00:00:52392/ inst5 Equal440 g3 /00:00:24/ 0.5;
note /00:00:52416/ inst5 Equal440 c4 /00:00:24/ 0.492188;
note /00:00:52440/ inst5 Equal440 a4 /00:00:24/ 0.476562;
note /00:00:52464/ inst5 Equal440 g3 /00:00:24/ 0.46875;
note /00:00:52488/ inst5 Equal440 c4 /00:00:24/ 0.460938;
note /00:00:52512/ inst5 Equal440 a4 /00:00:24/ 0.453125;
note /00:00:52536/ inst5 Equal440 g3 /00:00:24/ 0.445312;
note /00:00:52560/ inst5 Equal440 c4 /00:00:24/ 0.4375;
note /00:00:52584/ inst5 Equal440 a4 /00:00:24/ 0.429688;
note /00:00:52608/ inst5 Equal440 f#4 /00:00:24/ 0.421875;
note /00:00:52632/ inst5 Equal440 e3 /00:00:24/ 0.40625;
note /00:00:52656/ inst5 Equal440 a3 /00:00:24/ 0.398438;
note /00:00:52680/ inst5 Equal440 f#4 /00:00:24/ 0.390625;
note /00:00:52704/ inst5 Equal440 e3 /00:00:24/ 0.382812;
note /00:00:52728/ inst5 Equal440 a3 /00:00:24/ 0.375;
note /00:00:52752/ inst5 Equal440 f#4 /00:00:24/ 0.367188;
note /00:00:52776/ inst5 Equal440 e3 /00:00:24/ 0.359375;
note /00:00:52800/ inst5 Equal440 a3 /00:00:24/ 0.351562;
note /00:00:52824/ inst5 Equal440 f#4 /00:00:24/ 0.335938;
note /00:00:52848/ inst5 Equal440 e3 /00:00:24/ 0.328125;
note /00:00:52872/ inst5 Equal440 a3 /00:00:24/ 0.320312;
note /00:00:52896/ inst5 Equal440 f#4 /00:00:24/ 0.3125;
note /00:00:52920/ inst5 Equal440 e3 /00:00:24/ 0.304688;
note /00:00:52944/ inst5 Equal440 a3 /00:00:24/ 0.296875;
note /00:00:52968/ inst5 Equal440 f#4 /00:00:24/ 0.289062;
note /00:00:52992/ inst5 Equal440 g4 /00:00:24/ 0.28125;
note /00:00:53016/ inst5 Equal440 f3 /00:00:24/ 0.265625;
note /00:00:53040/ inst5 Equal440 a#3 /00:00:24/ 0.257812;
note /00:00:53064/ inst5 Equal440 g4 /00:00:24/ 0.25;
note /00:00:53088/ inst5 Equal440 f3 /00:00:24/ 0.242188;
note /00:00:53112/ inst5 Equal440 a#3 /00:00:24/ 0.234375;
note /00:00:53136/ inst5 Equal440 g4 /00:00:24/ 0.226562;
note /00:00:53160/ inst5 Equal440 f3 /00:00:24/ 0.21875;
note /00:00:53184/ inst5 Equal440 a#3 /00:00:24/ 0.210938;
note /00:00:53208/ inst5 Equal440 g4 /00:00:24/ 0.195312;
note /00:00:53232/ inst5 Equal440 f3 /00:00:24/ 0.1875;
note /00:00:53256/ inst5 Equal440 a#3 /00:00:24/ 0.179688;
note /00:00:53280/ inst5 Equal440 g4 /00:00:24/ 0.171875;
note /00:00:53304/ inst5 Equal440 f3 /00:00:24/ 0.164062;
note /00:00:53328/ inst5 Equal440 a#3 /00:00:24/ 0.15625;
note /00:00:53352/ inst5 Equal440 g4 /00:00:24/ 0.148438;
note /00:00:53376/ inst5 Equal440 e4 /00:00:24/ 0.140625;
note /00:00:53400/ inst5 Equal440 d3 /00:00:24/ 0.125;
note /00:00:53424/ inst5 Equal440 g3 /00:00:24/ 0.117188;
note /00:00:53448/ inst5 Equal440 e4 /00:00:24/ 0.109375;
note /00:00:53472/ inst5 Equal440 d3 /00:00:24/ 0.101562;
note /00:00:53496/ inst5 Equal440 g3 /00:00:24/ 0.09375;
note /00:00:53520/ inst5 Equal440 e4 /00:00:24/ 0.0859375;
note /00:00:53544/ inst5 Equal440 d3 /00:00:24/ 0.078125;
note /00:00:53568/ inst5 Equal440 g3 /00:00:24/ 0.0703125;
note /00:00:53592/ inst5 Equal440 e4 /00:00:24/ 0.0546875;
note /00:00:53616/ inst5 Equal440 d3 /00:00:24/ 0.046875;
note /00:00:53640/ inst5 Equal440 g3 /00:00:24/ 0.0390625;
note /00:00:53664/ inst5 Equal440 e4 /00:00:24/ 0.03125;
note /00:00:53688/ inst5 Equal440 d3 /00:00:24/ 0.0234375;
note /00:00:53712/ inst5 Equal440 g3 /00:00:24/ 0.015625;
note /00:00:53736/ inst5 Equal440 e4 /00:00:24/ 0.0078125;
--OTHER : 53760 Program 5 96
note /00:00:53784/ inst5 Equal440 g3 /00:00:24/ 0.0078125;
note /00:00:53808/ inst5 Equal440 c4 /00:00:24/ 0.015625;
note /00:00:53832/ inst5 Equal440 a4 /00:00:24/ 0.0234375;
note /00:00:53856/ inst5 Equal440 g3 /00:00:24/ 0.03125;
note /00:00:53880/ inst5 Equal440 c4 /00:00:24/ 0.0390625;
note /00:00:53904/ inst5 Equal440 a4 /00:00:24/ 0.046875;
note /00:00:53928/ inst5 Equal440 g3 /00:00:24/ 0.0546875;
note /00:00:53952/ inst5 Equal440 c4 /00:00:24/ 0.0703125;
note /00:00:53976/ inst5 Equal440 a4 /00:00:24/ 0.078125;
note /00:00:54000/ inst5 Equal440 g3 /00:00:24/ 0.0859375;
note /00:00:54024/ inst5 Equal440 c4 /00:00:24/ 0.09375;
note /00:00:54048/ inst5 Equal440 a4 /00:00:24/ 0.101562;
note /00:00:54072/ inst5 Equal440 g3 /00:00:24/ 0.109375;
note /00:00:54096/ inst5 Equal440 c4 /00:00:24/ 0.117188;
note /00:00:54120/ inst5 Equal440 a4 /00:00:24/ 0.125;
note /00:00:54144/ inst5 Equal440 f#4 /00:00:24/ 0.140625;
note /00:00:54168/ inst5 Equal440 e3 /00:00:24/ 0.148438;
note /00:00:54192/ inst5 Equal440 a3 /00:00:24/ 0.15625;
note /00:00:54216/ inst5 Equal440 f#4 /00:00:24/ 0.164062;
note /00:00:54240/ inst5 Equal440 e3 /00:00:24/ 0.171875;
note /00:00:54264/ inst5 Equal440 a3 /00:00:24/ 0.179688;
note /00:00:54288/ inst5 Equal440 f#4 /00:00:24/ 0.1875;
note /00:00:54312/ inst5 Equal440 e3 /00:00:24/ 0.195312;
note /00:00:54336/ inst5 Equal440 a3 /00:00:24/ 0.210938;
note /00:00:54360/ inst5 Equal440 f#4 /00:00:24/ 0.21875;
note /00:00:54384/ inst5 Equal440 e3 /00:00:24/ 0.226562;
note /00:00:54408/ inst5 Equal440 a3 /00:00:24/ 0.234375;
note /00:00:54432/ inst5 Equal440 f#4 /00:00:24/ 0.242188;
note /00:00:54456/ inst5 Equal440 e3 /00:00:24/ 0.25;
note /00:00:54480/ inst5 Equal440 a3 /00:00:24/ 0.257812;
note /00:00:54504/ inst5 Equal440 f#4 /00:00:24/ 0.265625;
note /00:00:54528/ inst5 Equal440 g4 /00:00:24/ 0.28125;
note /00:00:54552/ inst5 Equal440 f3 /00:00:24/ 0.289062;
note /00:00:54576/ inst5 Equal440 a#3 /00:00:24/ 0.296875;
note /00:00:54600/ inst5 Equal440 g4 /00:00:24/ 0.304688;
note /00:00:54624/ inst5 Equal440 f3 /00:00:24/ 0.3125;
note /00:00:54648/ inst5 Equal440 a#3 /00:00:24/ 0.320312;
note /00:00:54672/ inst5 Equal440 g4 /00:00:24/ 0.328125;
note /00:00:54696/ inst5 Equal440 f3 /00:00:24/ 0.335938;
note /00:00:54720/ inst5 Equal440 a#3 /00:00:24/ 0.351562;
note /00:00:54744/ inst5 Equal440 g4 /00:00:24/ 0.359375;
note /00:00:54768/ inst5 Equal440 f3 /00:00:24/ 0.367188;
note /00:00:54792/ inst5 Equal440 a#3 /00:00:24/ 0.375;
note /00:00:54816/ inst5 Equal440 g4 /00:00:24/ 0.382812;
note /00:00:54840/ inst5 Equal440 f3 /00:00:24/ 0.390625;
note /00:00:54864/ inst5 Equal440 a#3 /00:00:24/ 0.398438;
note /00:00:54888/ inst5 Equal440 g4 /00:00:24/ 0.40625;
note /00:00:54912/ inst5 Equal440 e4 /00:00:24/ 0.421875;
note /00:00:54936/ inst5 Equal440 d3 /00:00:24/ 0.429688;
note /00:00:54960/ inst5 Equal440 g3 /00:00:24/ 0.4375;
note /00:00:54984/ inst5 Equal440 e4 /00:00:24/ 0.445312;
note /00:00:55008/ inst5 Equal440 d3 /00:00:24/ 0.453125;
note /00:00:55032/ inst5 Equal440 g3 /00:00:24/ 0.460938;
note /00:00:55056/ inst5 Equal440 e4 /00:00:24/ 0.46875;
note /00:00:55080/ inst5 Equal440 d3 /00:00:24/ 0.476562;
note /00:00:55104/ inst5 Equal440 g3 /00:00:24/ 0.492188;
note /00:00:55128/ inst5 Equal440 e4 /00:00:24/ 0.5;
note /00:00:55152/ inst5 Equal440 d3 /00:00:24/ 0.507812;
note /00:00:55176/ inst5 Equal440 g3 /00:00:24/ 0.515625;
note /00:00:55200/ inst5 Equal440 e4 /00:00:24/ 0.523438;
note /00:00:55224/ inst5 Equal440 d3 /00:00:24/ 0.53125;
note /00:00:55248/ inst5 Equal440 g3 /00:00:24/ 0.539062;
note /00:00:55272/ inst5 Equal440 e4 /00:00:24/ 0.546875;
note /00:00:55296/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:55320/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:55344/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:55368/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:55392/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:55416/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:55440/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:55464/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:55488/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:55512/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:55536/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:55560/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:55584/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:55608/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:55632/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:55656/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:55680/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:55704/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:55728/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:55752/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:55776/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:55800/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:55824/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:55848/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:55872/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:55896/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:55920/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:55944/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:55968/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:55992/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:56016/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:56040/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:56064/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:56088/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:56112/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:56136/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:56160/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:56184/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:56208/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:56232/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:56256/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:56280/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:56304/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:56328/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:56352/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:56376/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:56400/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:56424/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:56448/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:56472/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:56496/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:56520/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:56544/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:56568/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:56592/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:56616/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:56640/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:56664/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:56688/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:56712/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:56736/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:56760/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:56784/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:56808/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:56832/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:56856/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:56880/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:56904/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:56928/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:56952/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:56976/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:57000/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:57024/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:57048/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:57072/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:57096/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:57120/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:57144/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:57168/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:57192/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:57216/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:57240/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:57264/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:57288/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:57312/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:57336/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:57360/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:57384/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:57408/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:57432/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:57456/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:57480/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:57504/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:57528/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:57552/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:57576/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:57600/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:57624/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:57648/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:57672/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:57696/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:57720/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:57744/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:57768/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:57792/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:57816/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:57840/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:57864/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:57888/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:57912/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:57936/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:57960/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:57984/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:58008/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:58032/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:58056/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:58080/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:58104/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:58128/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:58152/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:58176/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:58200/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:58224/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:58248/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:58272/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:58296/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:58320/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:58344/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:58368/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:58392/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:58416/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:58440/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:58464/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:58488/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:58512/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:58536/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:58560/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:58584/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:58608/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:58632/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:58656/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:58680/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:58704/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:58728/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:58752/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:58776/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:58800/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:58824/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:58848/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:58872/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:58896/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:58920/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:58944/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:58968/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:58992/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:59016/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:59040/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:59064/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:59088/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:59112/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:59136/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:59160/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:59184/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:59208/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:59232/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:59256/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:59280/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:59304/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:59328/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:59352/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:59376/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:59400/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:59424/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:59448/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:59472/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:59496/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:59520/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:59544/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:59568/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:59592/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:59616/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:59640/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:59664/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:59688/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:59712/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:59736/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:59760/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:59784/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:59808/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:59832/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:59856/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:59880/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:59904/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:59928/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:59952/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:59976/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:60000/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:60024/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:60048/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:60072/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:60096/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:60120/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:60144/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:60168/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:60192/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:60216/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:60240/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:60264/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:60288/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:60312/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:60336/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:60360/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:60384/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:60408/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:60432/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:60456/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:60480/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:60504/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:60528/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:60552/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:60576/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:60600/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:60624/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:60648/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:60672/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:60696/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:60720/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:60744/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:60768/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:60792/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:60816/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:60840/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:60864/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:60888/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:60912/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:60936/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:60960/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:60984/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:61008/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:61032/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:61056/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:61080/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:61104/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:61128/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:61152/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:61176/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:61200/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:61224/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:61248/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:61272/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:61296/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:61320/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:61344/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:61368/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:61392/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:61416/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:61440/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:61464/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:61488/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:61512/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:61536/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:61560/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:61584/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:61608/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:61632/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:61656/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:61680/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:61704/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:61728/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:61752/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:61776/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:61800/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:61824/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:61848/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:61872/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:61896/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:61920/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:61944/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:61968/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:61992/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:62016/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:62040/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:62064/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:62088/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:62112/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:62136/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:62160/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:62184/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:62208/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:62232/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:62256/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:62280/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:62304/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:62328/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:62352/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:62376/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:62400/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:62424/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:62448/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:62472/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:62496/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:62520/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:62544/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:62568/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:62592/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:62616/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:62640/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:62664/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:62688/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:62712/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:62736/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:62760/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:62784/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:62808/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:62832/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:62856/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:62880/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:62904/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:62928/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:62952/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:62976/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:63000/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:63024/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:63048/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:63072/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:63096/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:63120/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:63144/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:63168/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:63192/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:63216/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:63240/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:63264/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:63288/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:63312/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:63336/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:63360/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:63384/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:63408/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:63432/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:63456/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:63480/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:63504/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:63528/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:63552/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:63576/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:63600/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:63624/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:63648/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:63672/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:63696/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:63720/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:63744/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:63768/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:63792/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:63816/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:63840/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:63864/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:63888/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:63912/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:63936/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:63960/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:63984/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:64008/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:64032/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:64056/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:64080/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:64104/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:64128/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:64152/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:64176/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:64200/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:64224/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:64248/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:64272/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:64296/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:64320/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:64344/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:64368/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:64392/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:64416/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:64440/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:64464/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:64488/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:64512/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:64536/ inst5 Equal440 g3 /00:00:24/ 0.546875;
note /00:00:64560/ inst5 Equal440 c4 /00:00:24/ 0.539062;
note /00:00:64584/ inst5 Equal440 a4 /00:00:24/ 0.53125;
note /00:00:64608/ inst5 Equal440 g3 /00:00:24/ 0.523438;
note /00:00:64632/ inst5 Equal440 c4 /00:00:24/ 0.515625;
note /00:00:64656/ inst5 Equal440 a4 /00:00:24/ 0.507812;
note /00:00:64680/ inst5 Equal440 g3 /00:00:24/ 0.5;
note /00:00:64704/ inst5 Equal440 c4 /00:00:24/ 0.492188;
note /00:00:64728/ inst5 Equal440 a4 /00:00:24/ 0.476562;
note /00:00:64752/ inst5 Equal440 g3 /00:00:24/ 0.46875;
note /00:00:64776/ inst5 Equal440 c4 /00:00:24/ 0.460938;
note /00:00:64800/ inst5 Equal440 a4 /00:00:24/ 0.453125;
note /00:00:64824/ inst5 Equal440 g3 /00:00:24/ 0.445312;
note /00:00:64848/ inst5 Equal440 c4 /00:00:24/ 0.4375;
note /00:00:64872/ inst5 Equal440 a4 /00:00:24/ 0.429688;
note /00:00:64896/ inst5 Equal440 f#4 /00:00:24/ 0.421875;
note /00:00:64920/ inst5 Equal440 e3 /00:00:24/ 0.40625;
note /00:00:64944/ inst5 Equal440 a3 /00:00:24/ 0.398438;
note /00:00:64968/ inst5 Equal440 f#4 /00:00:24/ 0.390625;
note /00:00:64992/ inst5 Equal440 e3 /00:00:24/ 0.382812;
note /00:00:65016/ inst5 Equal440 a3 /00:00:24/ 0.375;
note /00:00:65040/ inst5 Equal440 f#4 /00:00:24/ 0.367188;
note /00:00:65064/ inst5 Equal440 e3 /00:00:24/ 0.359375;
note /00:00:65088/ inst5 Equal440 a3 /00:00:24/ 0.351562;
note /00:00:65112/ inst5 Equal440 f#4 /00:00:24/ 0.335938;
note /00:00:65136/ inst5 Equal440 e3 /00:00:24/ 0.328125;
note /00:00:65160/ inst5 Equal440 a3 /00:00:24/ 0.320312;
note /00:00:65184/ inst5 Equal440 f#4 /00:00:24/ 0.3125;
note /00:00:65208/ inst5 Equal440 e3 /00:00:24/ 0.304688;
note /00:00:65232/ inst5 Equal440 a3 /00:00:24/ 0.296875;
note /00:00:65256/ inst5 Equal440 f#4 /00:00:24/ 0.289062;
note /00:00:65280/ inst5 Equal440 g4 /00:00:24/ 0.28125;
note /00:00:65304/ inst5 Equal440 f3 /00:00:24/ 0.265625;
note /00:00:65328/ inst5 Equal440 a#3 /00:00:24/ 0.257812;
note /00:00:65352/ inst5 Equal440 g4 /00:00:24/ 0.25;
note /00:00:65376/ inst5 Equal440 f3 /00:00:24/ 0.242188;
note /00:00:65400/ inst5 Equal440 a#3 /00:00:24/ 0.234375;
note /00:00:65424/ inst5 Equal440 g4 /00:00:24/ 0.226562;
note /00:00:65448/ inst5 Equal440 f3 /00:00:24/ 0.21875;
note /00:00:65472/ inst5 Equal440 a#3 /00:00:24/ 0.210938;
note /00:00:65496/ inst5 Equal440 g4 /00:00:24/ 0.195312;
note /00:00:65520/ inst5 Equal440 f3 /00:00:24/ 0.1875;
note /00:00:65544/ inst5 Equal440 a#3 /00:00:24/ 0.179688;
note /00:00:65568/ inst5 Equal440 g4 /00:00:24/ 0.171875;
note /00:00:65592/ inst5 Equal440 f3 /00:00:24/ 0.164062;
note /00:00:65616/ inst5 Equal440 a#3 /00:00:24/ 0.15625;
note /00:00:65640/ inst5 Equal440 g4 /00:00:24/ 0.148438;
note /00:00:65664/ inst5 Equal440 e4 /00:00:24/ 0.140625;
note /00:00:65688/ inst5 Equal440 d3 /00:00:24/ 0.125;
note /00:00:65712/ inst5 Equal440 g3 /00:00:24/ 0.117188;
note /00:00:65736/ inst5 Equal440 e4 /00:00:24/ 0.109375;
note /00:00:65760/ inst5 Equal440 d3 /00:00:24/ 0.101562;
note /00:00:65784/ inst5 Equal440 g3 /00:00:24/ 0.09375;
note /00:00:65808/ inst5 Equal440 e4 /00:00:24/ 0.0859375;
note /00:00:65832/ inst5 Equal440 d3 /00:00:24/ 0.078125;
note /00:00:65856/ inst5 Equal440 g3 /00:00:24/ 0.0703125;
note /00:00:65880/ inst5 Equal440 e4 /00:00:24/ 0.0546875;
note /00:00:65904/ inst5 Equal440 d3 /00:00:24/ 0.046875;
note /00:00:65928/ inst5 Equal440 g3 /00:00:24/ 0.0390625;
note /00:00:65952/ inst5 Equal440 e4 /00:00:24/ 0.03125;
note /00:00:65976/ inst5 Equal440 d3 /00:00:24/ 0.0234375;
note /00:00:66000/ inst5 Equal440 g3 /00:00:24/ 0.015625;
note /00:00:66024/ inst5 Equal440 e4 /00:00:24/ 0.0078125;
--OTHER : 66048 Program 5 80
note /00:00:66072/ inst5 Equal440 g3 /00:00:24/ 0.0078125;
note /00:00:66096/ inst5 Equal440 c4 /00:00:24/ 0.015625;
note /00:00:66120/ inst5 Equal440 a4 /00:00:24/ 0.0234375;
note /00:00:66144/ inst5 Equal440 g3 /00:00:24/ 0.03125;
note /00:00:66168/ inst5 Equal440 c4 /00:00:24/ 0.0390625;
note /00:00:66192/ inst5 Equal440 a4 /00:00:24/ 0.046875;
note /00:00:66216/ inst5 Equal440 g3 /00:00:24/ 0.0546875;
note /00:00:66240/ inst5 Equal440 c4 /00:00:24/ 0.0703125;
note /00:00:66264/ inst5 Equal440 a4 /00:00:24/ 0.078125;
note /00:00:66288/ inst5 Equal440 g3 /00:00:24/ 0.0859375;
note /00:00:66312/ inst5 Equal440 c4 /00:00:24/ 0.09375;
note /00:00:66336/ inst5 Equal440 a4 /00:00:24/ 0.101562;
note /00:00:66360/ inst5 Equal440 g3 /00:00:24/ 0.109375;
note /00:00:66384/ inst5 Equal440 c4 /00:00:24/ 0.117188;
note /00:00:66408/ inst5 Equal440 a4 /00:00:24/ 0.125;
note /00:00:66432/ inst5 Equal440 f#4 /00:00:24/ 0.140625;
note /00:00:66456/ inst5 Equal440 e3 /00:00:24/ 0.148438;
note /00:00:66480/ inst5 Equal440 a3 /00:00:24/ 0.15625;
note /00:00:66504/ inst5 Equal440 f#4 /00:00:24/ 0.164062;
note /00:00:66528/ inst5 Equal440 e3 /00:00:24/ 0.171875;
note /00:00:66552/ inst5 Equal440 a3 /00:00:24/ 0.179688;
note /00:00:66576/ inst5 Equal440 f#4 /00:00:24/ 0.1875;
note /00:00:66600/ inst5 Equal440 e3 /00:00:24/ 0.195312;
note /00:00:66624/ inst5 Equal440 a3 /00:00:24/ 0.210938;
note /00:00:66648/ inst5 Equal440 f#4 /00:00:24/ 0.21875;
note /00:00:66672/ inst5 Equal440 e3 /00:00:24/ 0.226562;
note /00:00:66696/ inst5 Equal440 a3 /00:00:24/ 0.234375;
note /00:00:66720/ inst5 Equal440 f#4 /00:00:24/ 0.242188;
note /00:00:66744/ inst5 Equal440 e3 /00:00:24/ 0.25;
note /00:00:66768/ inst5 Equal440 a3 /00:00:24/ 0.257812;
note /00:00:66792/ inst5 Equal440 f#4 /00:00:24/ 0.265625;
note /00:00:66816/ inst5 Equal440 g4 /00:00:24/ 0.28125;
note /00:00:66840/ inst5 Equal440 f3 /00:00:24/ 0.289062;
note /00:00:66864/ inst5 Equal440 a#3 /00:00:24/ 0.296875;
note /00:00:66888/ inst5 Equal440 g4 /00:00:24/ 0.304688;
note /00:00:66912/ inst5 Equal440 f3 /00:00:24/ 0.3125;
note /00:00:66936/ inst5 Equal440 a#3 /00:00:24/ 0.320312;
note /00:00:66960/ inst5 Equal440 g4 /00:00:24/ 0.328125;
note /00:00:66984/ inst5 Equal440 f3 /00:00:24/ 0.335938;
note /00:00:67008/ inst5 Equal440 a#3 /00:00:24/ 0.351562;
note /00:00:67032/ inst5 Equal440 g4 /00:00:24/ 0.359375;
note /00:00:67056/ inst5 Equal440 f3 /00:00:24/ 0.367188;
note /00:00:67080/ inst5 Equal440 a#3 /00:00:24/ 0.375;
note /00:00:67104/ inst5 Equal440 g4 /00:00:24/ 0.382812;
note /00:00:67128/ inst5 Equal440 f3 /00:00:24/ 0.390625;
note /00:00:67152/ inst5 Equal440 a#3 /00:00:24/ 0.398438;
note /00:00:67176/ inst5 Equal440 g4 /00:00:24/ 0.40625;
note /00:00:67200/ inst5 Equal440 e4 /00:00:24/ 0.421875;
note /00:00:67224/ inst5 Equal440 d3 /00:00:24/ 0.429688;
note /00:00:67248/ inst5 Equal440 g3 /00:00:24/ 0.4375;
note /00:00:67272/ inst5 Equal440 e4 /00:00:24/ 0.445312;
note /00:00:67296/ inst5 Equal440 d3 /00:00:24/ 0.453125;
note /00:00:67320/ inst5 Equal440 g3 /00:00:24/ 0.460938;
note /00:00:67344/ inst5 Equal440 e4 /00:00:24/ 0.46875;
note /00:00:67368/ inst5 Equal440 d3 /00:00:24/ 0.476562;
note /00:00:67392/ inst5 Equal440 g3 /00:00:24/ 0.492188;
note /00:00:67416/ inst5 Equal440 e4 /00:00:24/ 0.5;
note /00:00:67440/ inst5 Equal440 d3 /00:00:24/ 0.507812;
note /00:00:67464/ inst5 Equal440 g3 /00:00:24/ 0.515625;
note /00:00:67488/ inst5 Equal440 e4 /00:00:24/ 0.523438;
note /00:00:67512/ inst5 Equal440 d3 /00:00:24/ 0.53125;
note /00:00:67536/ inst5 Equal440 g3 /00:00:24/ 0.539062;
note /00:00:67560/ inst5 Equal440 e4 /00:00:24/ 0.546875;
note /00:00:67584/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:67608/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:67632/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:67656/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:67680/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:67704/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:67728/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:67752/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:67776/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:67800/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:67824/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:67848/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:67872/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:67896/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:67920/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:67944/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:67968/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:67992/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:68016/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:68040/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:68064/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:68088/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:68112/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:68136/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:68160/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:68184/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:68208/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:68232/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:68256/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:68280/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:68304/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:68328/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:68352/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:68376/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:68400/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:68424/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:68448/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:68472/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:68496/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:68520/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:68544/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:68568/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:68592/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:68616/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:68640/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:68664/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:68688/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:68712/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:68736/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:68760/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:68784/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:68808/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:68832/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:68856/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:68880/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:68904/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:68928/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:68952/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:68976/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:69000/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:69024/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:69048/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:69072/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:69096/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:69120/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:69144/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:69168/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:69192/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:69216/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:69240/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:69264/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:69288/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:69312/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:69336/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:69360/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:69384/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:69408/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:69432/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:69456/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:69480/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:69504/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:69528/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:69552/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:69576/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:69600/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:69624/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:69648/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:69672/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:69696/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:69720/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:69744/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:69768/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:69792/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:69816/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:69840/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:69864/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:69888/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:69912/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:69936/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:69960/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:69984/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:70008/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:70032/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:70056/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:70080/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:70104/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:70128/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:70152/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:70176/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:70200/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:70224/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:70248/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:70272/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:70296/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:70320/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:70344/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:70368/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:70392/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:70416/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:70440/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:70464/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:70488/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:70512/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:70536/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:70560/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:70584/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:70608/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:70632/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:70656/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:70680/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:70704/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:70728/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:70752/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:70776/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:70800/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:70824/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:70848/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:70872/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:70896/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:70920/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:70944/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:70968/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:70992/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:71016/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:71040/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:71064/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:71088/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:71112/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:71136/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:71160/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:71184/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:71208/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:71232/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:71256/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:71280/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:71304/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:71328/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:71352/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:71376/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:71400/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:71424/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:71448/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:71472/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:71496/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:71520/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:71544/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:71568/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:71592/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:71616/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:71640/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:71664/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:71688/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:71712/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:71736/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:71760/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:71784/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:71808/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:71832/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:71856/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:71880/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:71904/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:71928/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:71952/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:71976/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:72000/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:72024/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:72048/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:72072/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:72096/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:72120/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:72144/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:72168/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:72192/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:72216/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:72240/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:72264/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:72288/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:72312/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:72336/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:72360/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:72384/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:72408/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:72432/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:72456/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:72480/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:72504/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:72528/ inst5 Equal440 c4 /00:00:24/ 0.5625;
note /00:00:72552/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:72576/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:72600/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:72624/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:72648/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:72672/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:72696/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:72720/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:72744/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:72768/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:72792/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:72816/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:72840/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:72864/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:72888/ inst5 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:72912/ inst5 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:72936/ inst5 Equal440 f#4 /00:00:24/ 0.5625;
note /00:00:72960/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:72984/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:73008/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:73032/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:73056/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:73080/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:73104/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:73128/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:73152/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:73176/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:73200/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:73224/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:73248/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:73272/ inst5 Equal440 f3 /00:00:24/ 0.5625;
note /00:00:73296/ inst5 Equal440 a#3 /00:00:24/ 0.5625;
note /00:00:73320/ inst5 Equal440 g4 /00:00:24/ 0.5625;
note /00:00:73344/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:73368/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:73392/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:73416/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:73440/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:73464/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:73488/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:73512/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:73536/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:73560/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:73584/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:73608/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:73632/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:73656/ inst5 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:73680/ inst5 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:73704/ inst5 Equal440 e4 /00:00:24/ 0.5625;
note /00:00:73728/ inst5 Equal440 a4 /00:00:24/ 0.5625;
note /00:00:73752/ inst5 Equal440 g3 /00:00:24/ 0.546875;
note /00:00:73776/ inst5 Equal440 c4 /00:00:24/ 0.539062;
note /00:00:73800/ inst5 Equal440 a4 /00:00:24/ 0.53125;
note /00:00:73824/ inst5 Equal440 g3 /00:00:24/ 0.523438;
note /00:00:73848/ inst5 Equal440 c4 /00:00:24/ 0.515625;
note /00:00:73872/ inst5 Equal440 a4 /00:00:24/ 0.507812;
note /00:00:73896/ inst5 Equal440 g3 /00:00:24/ 0.5;
note /00:00:73920/ inst5 Equal440 c4 /00:00:24/ 0.492188;
note /00:00:73944/ inst5 Equal440 a4 /00:00:24/ 0.476562;
note /00:00:73968/ inst5 Equal440 g3 /00:00:24/ 0.46875;
note /00:00:73992/ inst5 Equal440 c4 /00:00:24/ 0.460938;
note /00:00:74016/ inst5 Equal440 a4 /00:00:24/ 0.453125;
note /00:00:74040/ inst5 Equal440 g3 /00:00:24/ 0.445312;
note /00:00:74064/ inst5 Equal440 c4 /00:00:24/ 0.4375;
note /00:00:74088/ inst5 Equal440 a4 /00:00:24/ 0.429688;
note /00:00:74112/ inst5 Equal440 f#4 /00:00:24/ 0.421875;
note /00:00:74136/ inst5 Equal440 e3 /00:00:24/ 0.40625;
note /00:00:74160/ inst5 Equal440 a3 /00:00:24/ 0.398438;
note /00:00:74184/ inst5 Equal440 f#4 /00:00:24/ 0.390625;
note /00:00:74208/ inst5 Equal440 e3 /00:00:24/ 0.382812;
note /00:00:74232/ inst5 Equal440 a3 /00:00:24/ 0.375;
note /00:00:74256/ inst5 Equal440 f#4 /00:00:24/ 0.367188;
note /00:00:74280/ inst5 Equal440 e3 /00:00:24/ 0.359375;
note /00:00:74304/ inst5 Equal440 a3 /00:00:24/ 0.351562;
note /00:00:74328/ inst5 Equal440 f#4 /00:00:24/ 0.335938;
note /00:00:74352/ inst5 Equal440 e3 /00:00:24/ 0.328125;
note /00:00:74376/ inst5 Equal440 a3 /00:00:24/ 0.320312;
note /00:00:74400/ inst5 Equal440 f#4 /00:00:24/ 0.3125;
note /00:00:74424/ inst5 Equal440 e3 /00:00:24/ 0.304688;
note /00:00:74448/ inst5 Equal440 a3 /00:00:24/ 0.296875;
note /00:00:74472/ inst5 Equal440 f#4 /00:00:24/ 0.289062;
note /00:00:74496/ inst5 Equal440 g4 /00:00:24/ 0.28125;
note /00:00:74520/ inst5 Equal440 f3 /00:00:24/ 0.265625;
note /00:00:74544/ inst5 Equal440 a#3 /00:00:24/ 0.257812;
note /00:00:74568/ inst5 Equal440 g4 /00:00:24/ 0.25;
note /00:00:74592/ inst5 Equal440 f3 /00:00:24/ 0.242188;
note /00:00:74616/ inst5 Equal440 a#3 /00:00:24/ 0.234375;
note /00:00:74640/ inst5 Equal440 g4 /00:00:24/ 0.226562;
note /00:00:74664/ inst5 Equal440 f3 /00:00:24/ 0.21875;
note /00:00:74688/ inst5 Equal440 a#3 /00:00:24/ 0.210938;
note /00:00:74712/ inst5 Equal440 g4 /00:00:24/ 0.195312;
note /00:00:74736/ inst5 Equal440 f3 /00:00:24/ 0.1875;
note /00:00:74760/ inst5 Equal440 a#3 /00:00:24/ 0.179688;
note /00:00:74784/ inst5 Equal440 g4 /00:00:24/ 0.171875;
note /00:00:74808/ inst5 Equal440 f3 /00:00:24/ 0.164062;
note /00:00:74832/ inst5 Equal440 a#3 /00:00:24/ 0.15625;
note /00:00:74856/ inst5 Equal440 g4 /00:00:24/ 0.148438;
note /00:00:74880/ inst5 Equal440 e4 /00:00:24/ 0.140625;
note /00:00:74904/ inst5 Equal440 d3 /00:00:24/ 0.125;
note /00:00:74928/ inst5 Equal440 g3 /00:00:24/ 0.117188;
note /00:00:74952/ inst5 Equal440 e4 /00:00:24/ 0.109375;
note /00:00:74976/ inst5 Equal440 d3 /00:00:24/ 0.101562;
note /00:00:75000/ inst5 Equal440 g3 /00:00:24/ 0.09375;
note /00:00:75024/ inst5 Equal440 e4 /00:00:24/ 0.0859375;
note /00:00:75048/ inst5 Equal440 d3 /00:00:24/ 0.078125;
note /00:00:75072/ inst5 Equal440 g3 /00:00:24/ 0.0703125;
note /00:00:75096/ inst5 Equal440 e4 /00:00:24/ 0.0546875;
note /00:00:75120/ inst5 Equal440 d3 /00:00:24/ 0.046875;
note /00:00:75144/ inst5 Equal440 g3 /00:00:24/ 0.0390625;
note /00:00:75168/ inst5 Equal440 e4 /00:00:24/ 0.03125;
note /00:00:75192/ inst5 Equal440 d3 /00:00:24/ 0.0234375;
note /00:00:75216/ inst5 Equal440 g3 /00:00:24/ 0.015625;
note /00:00:75240/ inst5 Equal440 e4 /00:00:24/ 0.0078125;

--OTHER : 0 Program 6 5
note /00:00:19968/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:19968/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:19992/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:19992/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:20040/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:20040/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:20064/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:20064/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:20112/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:20112/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:20136/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:20136/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:20160/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:20160/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:20184/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:20184/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:20208/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:20208/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:20232/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:20232/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:20352/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:20352/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:20376/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:20376/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:20424/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:20424/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:20448/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:20448/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:20496/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:20496/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:20520/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:20520/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:20544/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:20544/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:20568/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:20568/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:20592/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:20592/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:20616/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:20616/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:20736/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:20736/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:20760/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:20760/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:20808/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:20808/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:20832/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:20832/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:20880/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:20880/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:20904/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:20904/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:20928/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:20928/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:20952/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:20952/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:20976/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:20976/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:21000/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:21000/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:21120/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:21120/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:21144/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:21144/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:21192/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:21192/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:21216/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:21216/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:21264/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:21264/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:21288/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:21288/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:21312/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:21312/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:21336/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:21336/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:21360/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:21360/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:21384/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:21384/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:21504/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:21504/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:21528/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:21528/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:21576/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:21576/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:21600/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:21600/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:21648/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:21648/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:21672/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:21672/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:21696/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:21696/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:21720/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:21720/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:21744/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:21744/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:21768/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:21768/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:21888/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:21888/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:21912/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:21912/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:21960/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:21960/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:21984/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:21984/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:22032/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:22032/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:22056/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:22056/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:22080/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:22080/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:22104/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:22104/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:22128/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:22128/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:22152/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:22152/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:22272/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:22272/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:22296/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:22296/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:22344/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:22344/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:22368/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:22368/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:22416/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:22416/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:22440/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:22440/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:22464/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:22464/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:22488/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:22488/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:22512/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:22512/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:22536/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:22536/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:22656/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:22656/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:22680/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:22680/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:22728/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:22728/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:22752/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:22752/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:22800/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:22800/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:22824/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:22824/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:22848/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:22848/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:22872/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:22872/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:22896/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:22896/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:22920/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:22920/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:23040/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:23040/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:23064/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:23064/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:23112/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:23112/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:23136/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:23136/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:23184/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:23184/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:23208/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:23208/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:23232/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:23232/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:23256/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:23256/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:23280/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:23280/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:23304/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:23304/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:23424/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:23424/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:23448/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:23448/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:23496/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:23496/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:23520/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:23520/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:23568/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:23568/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:23592/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:23592/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:23616/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:23616/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:23640/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:23640/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:23664/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:23664/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:23688/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:23688/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:23808/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:23808/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:23832/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:23832/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:23880/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:23880/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:23904/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:23904/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:23952/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:23952/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:23976/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:23976/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:24000/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:24000/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:24024/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:24024/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:24048/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:24048/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:24072/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:24072/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:24192/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:24192/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:24216/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:24216/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:24264/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:24264/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:24288/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:24288/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:24336/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:24336/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:24360/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:24360/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:24384/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:24384/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:24408/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:24408/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:24432/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:24432/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:24456/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:24456/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:24576/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:24576/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:24600/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:24600/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:24648/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:24648/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:24672/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:24672/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:24720/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:24720/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:24744/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:24744/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:24768/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:24768/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:24792/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:24792/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:24816/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:24816/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:24840/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:24840/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:24960/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:24960/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:24984/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:24984/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:25032/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:25032/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:25056/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:25056/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:25104/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:25104/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:25128/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:25128/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:25152/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:25152/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:25176/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:25176/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:25200/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:25200/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:25224/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:25224/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:25344/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:25344/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:25368/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:25368/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:25416/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:25416/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:25440/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:25440/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:25488/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:25488/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:25512/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:25512/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:25536/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:25536/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:25560/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:25560/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:25584/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:25584/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:25608/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:25608/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:25728/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:25728/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:25752/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:25752/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:25800/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:25800/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:25824/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:25824/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:25872/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:25872/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:25896/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:25896/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:25920/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:25920/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:25944/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:25944/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:25968/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:25968/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:25992/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:25992/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:32256/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:32256/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:32280/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:32280/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:32328/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:32328/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:32352/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:32352/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:32376/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:32376/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:32424/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:32424/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:32640/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:32640/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:32664/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:32664/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:32712/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:32712/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:32736/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:32736/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:32760/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:32760/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:32808/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:32808/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:33024/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:33024/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:33048/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:33048/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:33096/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:33096/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:33120/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:33120/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:33144/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:33144/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:33192/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:33192/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:33408/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:33408/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:33432/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:33432/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:33480/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:33480/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:33504/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:33504/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:33528/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:33528/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:33576/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:33576/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:33792/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:33792/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:33816/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:33816/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:33864/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:33864/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:33888/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:33888/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:33912/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:33912/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:33960/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:33960/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:34176/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:34176/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:34200/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:34200/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:34248/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:34248/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:34272/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:34272/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:34296/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:34296/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:34344/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:34344/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:34560/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:34560/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:34584/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:34584/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:34632/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:34632/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:34656/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:34656/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:34680/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:34680/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:34728/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:34728/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:34944/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:34944/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:34968/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:34968/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:35016/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:35016/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:35040/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:35040/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:35064/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:35064/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:35112/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:35112/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:35328/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:35328/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:35352/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:35352/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:35400/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:35400/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:35424/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:35424/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:35448/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:35448/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:35496/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:35496/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:35712/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:35712/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:35736/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:35736/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:35784/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:35784/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:35808/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:35808/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:35832/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:35832/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:35880/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:35880/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:36096/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:36096/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:36120/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:36120/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:36168/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:36168/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:36192/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:36192/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:36216/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:36216/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:36264/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:36264/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:36480/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:36480/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:36504/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:36504/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:36552/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:36552/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:36576/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:36576/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:36600/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:36600/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:36648/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:36648/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:36864/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:36864/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:36888/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:36888/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:36936/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:36936/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:36960/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:36960/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:36984/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:36984/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:37032/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:37032/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:37248/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:37248/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:37272/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:37272/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:37320/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:37320/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:37344/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:37344/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:37368/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:37368/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:37416/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:37416/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:37632/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:37632/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:37656/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:37656/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:37704/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:37704/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:37728/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:37728/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:37752/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:37752/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:37800/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:37800/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:38016/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:38016/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:38040/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:38040/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:38088/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:38088/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:38112/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:38112/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:38136/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:38136/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:38184/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:38184/ inst6 Equal440 e3 /00:00:24/ 0.5625;
--OTHER : 41472 Program 6 5
note /00:00:41472/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:41472/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:41496/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:41496/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:41544/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:41544/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:41568/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:41568/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:41616/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:41616/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:41640/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:41640/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:41664/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:41664/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:41688/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:41688/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:41712/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:41712/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:41736/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:41736/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:41784/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:41784/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:41856/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:41856/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:41880/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:41880/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:41928/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:41928/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:41952/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:41952/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:42000/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:42000/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:42024/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:42024/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:42048/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:42048/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:42072/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:42072/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:42096/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:42096/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:42120/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:42120/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:42168/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:42168/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:42240/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:42240/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:42264/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:42264/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:42312/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:42312/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:42336/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:42336/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:42384/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:42384/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:42408/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:42408/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:42432/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:42432/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:42456/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:42456/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:42480/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:42480/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:42504/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:42504/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:42552/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:42552/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:42624/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:42624/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:42648/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:42648/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:42696/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:42696/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:42720/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:42720/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:42768/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:42768/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:42792/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:42792/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:42816/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:42816/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:42840/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:42840/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:42864/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:42864/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:42888/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:42888/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:42936/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:42936/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:43008/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:43008/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:43032/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:43032/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:43080/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:43080/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:43104/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:43104/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:43152/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:43152/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:43176/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:43176/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:43200/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:43200/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:43224/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:43224/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:43248/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:43248/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:43272/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:43272/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:43320/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:43320/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:43392/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:43392/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:43416/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:43416/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:43464/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:43464/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:43488/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:43488/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:43536/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:43536/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:43560/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:43560/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:43584/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:43584/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:43608/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:43608/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:43632/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:43632/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:43656/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:43656/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:43704/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:43704/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:43776/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:43776/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:43800/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:43800/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:43848/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:43848/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:43872/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:43872/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:43920/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:43920/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:43944/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:43944/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:43968/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:43968/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:43992/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:43992/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:44016/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:44016/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:44040/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:44040/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:44088/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:44088/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:44160/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:44160/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:44184/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:44184/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:44232/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:44232/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:44256/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:44256/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:44304/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:44304/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:44328/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:44328/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:44352/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:44352/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:44376/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:44376/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:44400/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:44400/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:44424/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:44424/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:44472/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:44472/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:44544/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:44544/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:44568/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:44568/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:44616/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:44616/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:44640/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:44640/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:44688/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:44688/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:44712/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:44712/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:44736/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:44736/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:44760/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:44760/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:44784/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:44784/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:44808/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:44808/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:44856/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:44856/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:44928/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:44928/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:44952/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:44952/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:45000/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:45000/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:45024/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:45024/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:45072/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:45072/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:45096/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:45096/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:45120/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:45120/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:45144/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:45144/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:45168/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:45168/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:45192/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:45192/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:45240/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:45240/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:45312/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:45312/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:45336/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:45336/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:45384/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:45384/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:45408/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:45408/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:45456/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:45456/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:45480/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:45480/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:45504/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:45504/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:45528/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:45528/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:45552/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:45552/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:45576/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:45576/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:45624/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:45624/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:45696/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:45696/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:45720/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:45720/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:45768/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:45768/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:45792/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:45792/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:45840/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:45840/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:45864/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:45864/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:45888/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:45888/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:45912/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:45912/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:45936/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:45936/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:45960/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:45960/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:46008/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:46008/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:46080/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:46080/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:46104/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:46104/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:46152/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:46152/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:46176/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:46176/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:46224/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:46224/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:46248/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:46248/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:46272/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:46272/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:46296/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:46296/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:46320/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:46320/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:46344/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:46344/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:46392/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:46392/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:46464/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:46464/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:46488/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:46488/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:46536/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:46536/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:46560/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:46560/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:46608/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:46608/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:46632/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:46632/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:46656/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:46656/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:46680/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:46680/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:46704/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:46704/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:46728/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:46728/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:46776/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:46776/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:46848/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:46848/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:46872/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:46872/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:46920/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:46920/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:46944/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:46944/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:46992/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:46992/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:47016/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:47016/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:47040/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:47040/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:47064/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:47064/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:47088/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:47088/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:47112/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:47112/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:47160/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:47160/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:47232/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:47232/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:47256/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:47256/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:47304/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:47304/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:47328/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:47328/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:47376/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:47376/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:47400/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:47400/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:47424/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:47424/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:47448/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:47448/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:47472/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:47472/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:47496/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:47496/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:47544/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:47544/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:47616/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:47616/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:47640/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:47640/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:47688/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:47688/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:47712/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:47712/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:47760/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:47760/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:47784/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:47784/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:47808/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:47808/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:47832/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:47832/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:47856/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:47856/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:47880/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:47880/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:47928/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:47928/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:48000/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:48000/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:48024/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:48024/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:48072/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:48072/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:48096/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:48096/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:48144/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:48144/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:48168/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:48168/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:48192/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:48192/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:48216/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:48216/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:48240/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:48240/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:48264/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:48264/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:48312/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:48312/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:48384/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:48384/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:48408/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:48408/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:48456/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:48456/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:48480/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:48480/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:48528/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:48528/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:48552/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:48552/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:48576/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:48576/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:48600/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:48600/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:48624/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:48624/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:48648/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:48648/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:48696/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:48696/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:48768/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:48768/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:48792/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:48792/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:48840/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:48840/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:48864/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:48864/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:48912/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:48912/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:48936/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:48936/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:48960/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:48960/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:48984/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:48984/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:49008/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:49008/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:49032/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:49032/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:49080/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:49080/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:55296/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:55296/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:55320/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:55320/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:55344/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:55344/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:55392/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:55392/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:55416/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:55416/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:55464/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:55464/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:55488/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:55488/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:55512/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:55512/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:55536/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:55536/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:55584/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:55584/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:55680/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:55680/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:55704/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:55704/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:55728/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:55728/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:55776/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:55776/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:55800/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:55800/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:55848/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:55848/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:55872/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:55872/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:55896/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:55896/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:55920/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:55920/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:55968/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:55968/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:56064/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:56064/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:56088/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:56088/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:56112/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:56112/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:56160/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:56160/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:56184/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:56184/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:56232/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:56232/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:56256/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:56256/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:56280/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:56280/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:56304/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:56304/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:56352/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:56352/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:56448/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:56448/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:56472/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:56472/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:56496/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:56496/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:56544/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:56544/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:56568/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:56568/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:56616/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:56616/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:56640/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:56640/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:56664/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:56664/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:56688/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:56688/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:56736/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:56736/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:56832/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:56832/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:56856/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:56856/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:56880/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:56880/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:56928/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:56928/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:56952/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:56952/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:57000/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:57000/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:57024/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:57024/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:57048/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:57048/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:57072/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:57072/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:57120/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:57120/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:57216/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:57216/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:57240/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:57240/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:57264/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:57264/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:57312/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:57312/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:57336/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:57336/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:57384/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:57384/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:57408/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:57408/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:57432/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:57432/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:57456/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:57456/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:57504/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:57504/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:57600/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:57600/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:57624/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:57624/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:57648/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:57648/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:57696/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:57696/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:57720/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:57720/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:57768/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:57768/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:57792/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:57792/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:57816/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:57816/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:57840/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:57840/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:57888/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:57888/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:57984/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:57984/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:58008/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:58008/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:58032/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:58032/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:58080/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:58080/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:58104/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:58104/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:58152/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:58152/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:58176/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:58176/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:58200/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:58200/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:58224/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:58224/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:58272/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:58272/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:58368/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:58368/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:58392/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:58392/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:58416/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:58416/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:58464/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:58464/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:58488/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:58488/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:58536/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:58536/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:58560/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:58560/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:58584/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:58584/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:58608/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:58608/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:58656/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:58656/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:58752/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:58752/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:58776/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:58776/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:58800/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:58800/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:58848/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:58848/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:58872/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:58872/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:58920/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:58920/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:58944/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:58944/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:58968/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:58968/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:58992/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:58992/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:59040/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:59040/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:59136/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:59136/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:59160/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:59160/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:59184/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:59184/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:59232/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:59232/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:59256/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:59256/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:59304/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:59304/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:59328/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:59328/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:59352/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:59352/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:59376/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:59376/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:59424/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:59424/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:59520/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:59520/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:59544/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:59544/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:59568/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:59568/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:59616/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:59616/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:59640/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:59640/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:59688/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:59688/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:59712/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:59712/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:59736/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:59736/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:59760/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:59760/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:59808/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:59808/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:59904/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:59904/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:59928/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:59928/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:59952/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:59952/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:60000/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:60000/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:60024/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:60024/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:60072/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:60072/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:60096/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:60096/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:60120/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:60120/ inst6 Equal440 c3 /00:00:24/ 0.5625;
note /00:00:60144/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:60144/ inst6 Equal440 a3 /00:00:48/ 0.5625;
note /00:00:60192/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:60192/ inst6 Equal440 a3 /00:00:24/ 0.5625;
note /00:00:60288/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:60288/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:60312/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:60312/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:60336/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:60336/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:60384/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:60384/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:60408/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:60408/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:60456/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:60456/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:60480/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:60480/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:60504/ inst6 Equal440 e2 /00:00:24/ 0.5625;
note /00:00:60504/ inst6 Equal440 a2 /00:00:24/ 0.5625;
note /00:00:60528/ inst6 Equal440 c#3 /00:00:48/ 0.5625;
note /00:00:60528/ inst6 Equal440 f#3 /00:00:48/ 0.5625;
note /00:00:60576/ inst6 Equal440 c#3 /00:00:24/ 0.5625;
note /00:00:60576/ inst6 Equal440 f#3 /00:00:24/ 0.5625;
note /00:00:60672/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:60672/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:60696/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:60696/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:60720/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:60720/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:60768/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:60768/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:60792/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:60792/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:60840/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:60840/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:60864/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:60864/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:60888/ inst6 Equal440 f2 /00:00:24/ 0.5625;
note /00:00:60888/ inst6 Equal440 a#2 /00:00:24/ 0.5625;
note /00:00:60912/ inst6 Equal440 d3 /00:00:48/ 0.5625;
note /00:00:60912/ inst6 Equal440 g3 /00:00:48/ 0.5625;
note /00:00:60960/ inst6 Equal440 d3 /00:00:24/ 0.5625;
note /00:00:60960/ inst6 Equal440 g3 /00:00:24/ 0.5625;
note /00:00:61056/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:61056/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:61080/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:61080/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:61104/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:61104/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:61152/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:61152/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:61176/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:61176/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:61224/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:61224/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:61248/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:61248/ inst6 Equal440 e3 /00:00:24/ 0.5625;
note /00:00:61272/ inst6 Equal440 d2 /00:00:24/ 0.5625;
note /00:00:61272/ inst6 Equal440 g2 /00:00:24/ 0.5625;
note /00:00:61296/ inst6 Equal440 b2 /00:00:48/ 0.5625;
note /00:00:61296/ inst6 Equal440 e3 /00:00:48/ 0.5625;
note /00:00:61344/ inst6 Equal440 b2 /00:00:24/ 0.5625;
note /00:00:61344/ inst6 Equal440 e3 /00:00:24/ 0.5625;

--OTHER : 0 Program 7 62
note /00:00:30744/ inst7 Equal440 e4 /00:00:24/ 0.0078125;
note /00:00:30768/ inst7 Equal440 c4 /00:00:48/ 0.015625;
note /00:00:30816/ inst7 Equal440 a2 /00:00:24/ 0.0390625;
note /00:00:30840/ inst7 Equal440 c4 /00:00:48/ 0.046875;
note /00:00:30888/ inst7 Equal440 d3 /00:00:24/ 0.0625;
note /00:00:30912/ inst7 Equal440 g3 /00:00:24/ 0.078125;
note /00:00:30936/ inst7 Equal440 c4 /00:00:48/ 0.0859375;
note /00:00:30984/ inst7 Equal440 c4 /00:00:48/ 0.101562;
note /00:00:31032/ inst7 Equal440 e4 /00:00:48/ 0.125;
note /00:00:31080/ inst7 Equal440 d3 /00:00:24/ 0.140625;
note /00:00:31104/ inst7 Equal440 b2 /00:00:24/ 0.15625;
note /00:00:31128/ inst7 Equal440 c#4 /00:00:24/ 0.164062;
note /00:00:31152/ inst7 Equal440 a3 /00:00:48/ 0.171875;
note /00:00:31200/ inst7 Equal440 f#2 /00:00:24/ 0.195312;
note /00:00:31224/ inst7 Equal440 a3 /00:00:48/ 0.203125;
note /00:00:31272/ inst7 Equal440 b2 /00:00:24/ 0.21875;
note /00:00:31296/ inst7 Equal440 e3 /00:00:24/ 0.234375;
note /00:00:31320/ inst7 Equal440 a3 /00:00:48/ 0.242188;
note /00:00:31368/ inst7 Equal440 a3 /00:00:48/ 0.257812;
note /00:00:31416/ inst7 Equal440 c#4 /00:00:48/ 0.28125;
note /00:00:31464/ inst7 Equal440 b2 /00:00:24/ 0.296875;
note /00:00:31488/ inst7 Equal440 c3 /00:00:24/ 0.3125;
note /00:00:31512/ inst7 Equal440 d4 /00:00:24/ 0.320312;
note /00:00:31536/ inst7 Equal440 a#3 /00:00:48/ 0.328125;
note /00:00:31584/ inst7 Equal440 g2 /00:00:24/ 0.351562;
note /00:00:31608/ inst7 Equal440 a#3 /00:00:48/ 0.359375;
note /00:00:31656/ inst7 Equal440 c3 /00:00:24/ 0.375;
note /00:00:31680/ inst7 Equal440 f3 /00:00:24/ 0.390625;
note /00:00:31704/ inst7 Equal440 a#3 /00:00:48/ 0.398438;
note /00:00:31752/ inst7 Equal440 a#3 /00:00:48/ 0.414062;
note /00:00:31800/ inst7 Equal440 d4 /00:00:48/ 0.4375;
note /00:00:31848/ inst7 Equal440 c3 /00:00:24/ 0.453125;
note /00:00:31872/ inst7 Equal440 a2 /00:00:24/ 0.46875;
note /00:00:31896/ inst7 Equal440 b3 /00:00:24/ 0.476562;
note /00:00:31920/ inst7 Equal440 g3 /00:00:48/ 0.484375;
note /00:00:31968/ inst7 Equal440 e2 /00:00:24/ 0.507812;
note /00:00:31992/ inst7 Equal440 g3 /00:00:48/ 0.515625;
note /00:00:32040/ inst7 Equal440 a2 /00:00:24/ 0.53125;
note /00:00:32064/ inst7 Equal440 d3 /00:00:24/ 0.546875;
note /00:00:32088/ inst7 Equal440 g3 /00:00:48/ 0.554688;
note /00:00:32136/ inst7 Equal440 g3 /00:00:48/ 0.570312;
note /00:00:32184/ inst7 Equal440 b3 /00:00:48/ 0.59375;
note /00:00:32232/ inst7 Equal440 a2 /00:00:24/ 0.609375;
note /00:00:32256/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:32280/ inst7 Equal440 e4 /00:00:24/ 0.625;
note /00:00:32304/ inst7 Equal440 c4 /00:00:48/ 0.625;
note /00:00:32352/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:32376/ inst7 Equal440 c4 /00:00:48/ 0.625;
note /00:00:32424/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:32448/ inst7 Equal440 g3 /00:00:24/ 0.625;
note /00:00:32472/ inst7 Equal440 c4 /00:00:48/ 0.625;
note /00:00:32520/ inst7 Equal440 c4 /00:00:48/ 0.625;
note /00:00:32568/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:32616/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:32640/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:32664/ inst7 Equal440 c#4 /00:00:24/ 0.625;
note /00:00:32688/ inst7 Equal440 a3 /00:00:48/ 0.625;
note /00:00:32736/ inst7 Equal440 f#2 /00:00:24/ 0.625;
note /00:00:32760/ inst7 Equal440 a3 /00:00:48/ 0.625;
note /00:00:32808/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:32832/ inst7 Equal440 e3 /00:00:24/ 0.625;
note /00:00:32856/ inst7 Equal440 a3 /00:00:48/ 0.625;
note /00:00:32904/ inst7 Equal440 a3 /00:00:48/ 0.625;
note /00:00:32952/ inst7 Equal440 c#4 /00:00:48/ 0.625;
note /00:00:33000/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:33024/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:33048/ inst7 Equal440 d4 /00:00:24/ 0.625;
note /00:00:33072/ inst7 Equal440 a#3 /00:00:48/ 0.625;
note /00:00:33120/ inst7 Equal440 g2 /00:00:24/ 0.625;
note /00:00:33144/ inst7 Equal440 a#3 /00:00:48/ 0.625;
note /00:00:33192/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:33216/ inst7 Equal440 f3 /00:00:24/ 0.625;
note /00:00:33240/ inst7 Equal440 a#3 /00:00:48/ 0.625;
note /00:00:33288/ inst7 Equal440 a#3 /00:00:48/ 0.625;
note /00:00:33336/ inst7 Equal440 d4 /00:00:48/ 0.625;
note /00:00:33384/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:33408/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:33432/ inst7 Equal440 b3 /00:00:24/ 0.625;
note /00:00:33456/ inst7 Equal440 g3 /00:00:48/ 0.625;
note /00:00:33504/ inst7 Equal440 e2 /00:00:24/ 0.625;
note /00:00:33528/ inst7 Equal440 g3 /00:00:48/ 0.625;
note /00:00:33576/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:33600/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:33624/ inst7 Equal440 g3 /00:00:48/ 0.625;
note /00:00:33672/ inst7 Equal440 g3 /00:00:48/ 0.625;
note /00:00:33720/ inst7 Equal440 b3 /00:00:48/ 0.625;
note /00:00:33768/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:33792/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:33816/ inst7 Equal440 e4 /00:00:24/ 0.625;
note /00:00:33840/ inst7 Equal440 c4 /00:00:48/ 0.625;
note /00:00:33888/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:33912/ inst7 Equal440 c4 /00:00:48/ 0.625;
note /00:00:33960/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:33984/ inst7 Equal440 g3 /00:00:24/ 0.625;
note /00:00:34008/ inst7 Equal440 c4 /00:00:48/ 0.625;
note /00:00:34056/ inst7 Equal440 c4 /00:00:48/ 0.625;
note /00:00:34104/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:34152/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:34176/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:34200/ inst7 Equal440 c#4 /00:00:24/ 0.625;
note /00:00:34224/ inst7 Equal440 a3 /00:00:48/ 0.625;
note /00:00:34272/ inst7 Equal440 f#2 /00:00:24/ 0.625;
note /00:00:34296/ inst7 Equal440 a3 /00:00:48/ 0.625;
note /00:00:34344/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:34368/ inst7 Equal440 e3 /00:00:24/ 0.625;
note /00:00:34392/ inst7 Equal440 a3 /00:00:48/ 0.625;
note /00:00:34440/ inst7 Equal440 a3 /00:00:48/ 0.625;
note /00:00:34488/ inst7 Equal440 c#4 /00:00:48/ 0.625;
note /00:00:34536/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:34560/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:34584/ inst7 Equal440 d4 /00:00:24/ 0.625;
note /00:00:34608/ inst7 Equal440 a#3 /00:00:48/ 0.625;
note /00:00:34656/ inst7 Equal440 g2 /00:00:24/ 0.625;
note /00:00:34680/ inst7 Equal440 a#3 /00:00:48/ 0.625;
note /00:00:34728/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:34752/ inst7 Equal440 f3 /00:00:24/ 0.625;
note /00:00:34776/ inst7 Equal440 a#3 /00:00:48/ 0.625;
note /00:00:34824/ inst7 Equal440 a#3 /00:00:48/ 0.625;
note /00:00:34872/ inst7 Equal440 d4 /00:00:48/ 0.625;
note /00:00:34920/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:34944/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:34968/ inst7 Equal440 b3 /00:00:24/ 0.625;
note /00:00:34992/ inst7 Equal440 g3 /00:00:48/ 0.625;
note /00:00:35040/ inst7 Equal440 e2 /00:00:24/ 0.625;
note /00:00:35064/ inst7 Equal440 g3 /00:00:48/ 0.625;
note /00:00:35112/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:35136/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:35160/ inst7 Equal440 g3 /00:00:48/ 0.625;
note /00:00:35208/ inst7 Equal440 g3 /00:00:48/ 0.625;
note /00:00:35256/ inst7 Equal440 b3 /00:00:48/ 0.625;
note /00:00:35304/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:35328/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:35352/ inst7 Equal440 e4 /00:00:24/ 0.625;
note /00:00:35376/ inst7 Equal440 c4 /00:00:48/ 0.625;
note /00:00:35424/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:35448/ inst7 Equal440 c4 /00:00:48/ 0.625;
note /00:00:35496/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:35520/ inst7 Equal440 g3 /00:00:24/ 0.625;
note /00:00:35544/ inst7 Equal440 c4 /00:00:48/ 0.625;
note /00:00:35592/ inst7 Equal440 c4 /00:00:48/ 0.625;
note /00:00:35640/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:35688/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:35712/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:35736/ inst7 Equal440 c#4 /00:00:24/ 0.625;
note /00:00:35760/ inst7 Equal440 a3 /00:00:48/ 0.625;
note /00:00:35808/ inst7 Equal440 f#2 /00:00:24/ 0.625;
note /00:00:35832/ inst7 Equal440 a3 /00:00:48/ 0.625;
note /00:00:35880/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:35904/ inst7 Equal440 e3 /00:00:24/ 0.625;
note /00:00:35928/ inst7 Equal440 a3 /00:00:48/ 0.625;
note /00:00:35976/ inst7 Equal440 a3 /00:00:48/ 0.625;
note /00:00:36024/ inst7 Equal440 c#4 /00:00:48/ 0.625;
note /00:00:36072/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:36096/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:36120/ inst7 Equal440 d4 /00:00:24/ 0.625;
note /00:00:36144/ inst7 Equal440 a#3 /00:00:48/ 0.625;
note /00:00:36192/ inst7 Equal440 g2 /00:00:24/ 0.625;
note /00:00:36216/ inst7 Equal440 a#3 /00:00:48/ 0.625;
note /00:00:36264/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:36288/ inst7 Equal440 f3 /00:00:24/ 0.625;
note /00:00:36312/ inst7 Equal440 a#3 /00:00:48/ 0.625;
note /00:00:36360/ inst7 Equal440 a#3 /00:00:48/ 0.625;
note /00:00:36408/ inst7 Equal440 d4 /00:00:48/ 0.625;
note /00:00:36456/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:36480/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:36504/ inst7 Equal440 b3 /00:00:24/ 0.625;
note /00:00:36528/ inst7 Equal440 g3 /00:00:48/ 0.625;
note /00:00:36576/ inst7 Equal440 e2 /00:00:24/ 0.625;
note /00:00:36600/ inst7 Equal440 g3 /00:00:48/ 0.625;
note /00:00:36648/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:36672/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:36696/ inst7 Equal440 g3 /00:00:48/ 0.625;
note /00:00:36744/ inst7 Equal440 g3 /00:00:48/ 0.625;
note /00:00:36792/ inst7 Equal440 b3 /00:00:48/ 0.625;
note /00:00:36840/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:36864/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:36888/ inst7 Equal440 e4 /00:00:24/ 0.625;
note /00:00:36912/ inst7 Equal440 c4 /00:00:48/ 0.625;
note /00:00:36960/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:36984/ inst7 Equal440 c4 /00:00:48/ 0.625;
note /00:00:37032/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:37056/ inst7 Equal440 g3 /00:00:24/ 0.625;
note /00:00:37080/ inst7 Equal440 c4 /00:00:48/ 0.625;
note /00:00:37128/ inst7 Equal440 c4 /00:00:48/ 0.625;
note /00:00:37176/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:37224/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:37248/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:37272/ inst7 Equal440 c#4 /00:00:24/ 0.625;
note /00:00:37296/ inst7 Equal440 a3 /00:00:48/ 0.625;
note /00:00:37344/ inst7 Equal440 f#2 /00:00:24/ 0.625;
note /00:00:37368/ inst7 Equal440 a3 /00:00:48/ 0.625;
note /00:00:37416/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:37440/ inst7 Equal440 e3 /00:00:24/ 0.625;
note /00:00:37464/ inst7 Equal440 a3 /00:00:48/ 0.625;
note /00:00:37512/ inst7 Equal440 a3 /00:00:48/ 0.625;
note /00:00:37560/ inst7 Equal440 c#4 /00:00:48/ 0.625;
note /00:00:37608/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:37632/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:37656/ inst7 Equal440 d4 /00:00:24/ 0.625;
note /00:00:37680/ inst7 Equal440 a#3 /00:00:48/ 0.625;
note /00:00:37728/ inst7 Equal440 g2 /00:00:24/ 0.625;
note /00:00:37752/ inst7 Equal440 a#3 /00:00:48/ 0.625;
note /00:00:37800/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:37824/ inst7 Equal440 f3 /00:00:24/ 0.625;
note /00:00:37848/ inst7 Equal440 a#3 /00:00:48/ 0.625;
note /00:00:37896/ inst7 Equal440 a#3 /00:00:48/ 0.625;
note /00:00:37944/ inst7 Equal440 d4 /00:00:48/ 0.625;
note /00:00:37992/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:38016/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:38040/ inst7 Equal440 b3 /00:00:24/ 0.625;
note /00:00:38064/ inst7 Equal440 g3 /00:00:48/ 0.625;
note /00:00:38112/ inst7 Equal440 e2 /00:00:24/ 0.625;
note /00:00:38136/ inst7 Equal440 g3 /00:00:48/ 0.625;
note /00:00:38184/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:38208/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:38232/ inst7 Equal440 g3 /00:00:48/ 0.625;
note /00:00:38280/ inst7 Equal440 g3 /00:00:48/ 0.625;
note /00:00:38328/ inst7 Equal440 b3 /00:00:48/ 0.625;
note /00:00:38376/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:39984/ inst7 Equal440 a4 /00:00:24/ 0.015625;
note /00:00:40008/ inst7 Equal440 e4 /00:00:24/ 0.0234375;
note /00:00:40032/ inst7 Equal440 d3 /00:00:24/ 0.0390625;
note /00:00:40056/ inst7 Equal440 e4 /00:00:48/ 0.046875;
note /00:00:40104/ inst7 Equal440 a4 /00:00:48/ 0.0625;
note /00:00:40152/ inst7 Equal440 d3 /00:00:24/ 0.0859375;
note /00:00:40176/ inst7 Equal440 e4 /00:00:48/ 0.09375;
note /00:00:40224/ inst7 Equal440 g3 /00:00:24/ 0.117188;
note /00:00:40248/ inst7 Equal440 a2 /00:00:24/ 0.125;
note /00:00:40272/ inst7 Equal440 d3 /00:00:48/ 0.132812;
note /00:00:40320/ inst7 Equal440 f#4 /00:00:48/ 0.15625;
note /00:00:40368/ inst7 Equal440 f#4 /00:00:24/ 0.171875;
note /00:00:40392/ inst7 Equal440 c#4 /00:00:24/ 0.179688;
note /00:00:40416/ inst7 Equal440 b2 /00:00:24/ 0.195312;
note /00:00:40440/ inst7 Equal440 c#4 /00:00:48/ 0.203125;
note /00:00:40488/ inst7 Equal440 f#4 /00:00:48/ 0.21875;
note /00:00:40536/ inst7 Equal440 b2 /00:00:24/ 0.242188;
note /00:00:40560/ inst7 Equal440 c#4 /00:00:48/ 0.25;
note /00:00:40608/ inst7 Equal440 e3 /00:00:24/ 0.273438;
note /00:00:40632/ inst7 Equal440 f#2 /00:00:24/ 0.28125;
note /00:00:40656/ inst7 Equal440 b2 /00:00:48/ 0.289062;
note /00:00:40704/ inst7 Equal440 g4 /00:00:48/ 0.3125;
note /00:00:40752/ inst7 Equal440 g4 /00:00:24/ 0.328125;
note /00:00:40776/ inst7 Equal440 d4 /00:00:24/ 0.335938;
note /00:00:40800/ inst7 Equal440 c3 /00:00:24/ 0.351562;
note /00:00:40824/ inst7 Equal440 d4 /00:00:48/ 0.359375;
note /00:00:40872/ inst7 Equal440 g4 /00:00:48/ 0.375;
note /00:00:40920/ inst7 Equal440 c3 /00:00:24/ 0.398438;
note /00:00:40944/ inst7 Equal440 d4 /00:00:48/ 0.40625;
note /00:00:40992/ inst7 Equal440 f3 /00:00:24/ 0.429688;
note /00:00:41016/ inst7 Equal440 g2 /00:00:24/ 0.4375;
note /00:00:41040/ inst7 Equal440 c3 /00:00:48/ 0.445312;
note /00:00:41088/ inst7 Equal440 e4 /00:00:48/ 0.46875;
note /00:00:41136/ inst7 Equal440 e4 /00:00:24/ 0.484375;
note /00:00:41160/ inst7 Equal440 b3 /00:00:24/ 0.492188;
note /00:00:41184/ inst7 Equal440 a2 /00:00:24/ 0.507812;
note /00:00:41208/ inst7 Equal440 b3 /00:00:48/ 0.515625;
note /00:00:41256/ inst7 Equal440 e4 /00:00:48/ 0.53125;
note /00:00:41304/ inst7 Equal440 a2 /00:00:24/ 0.554688;
note /00:00:41328/ inst7 Equal440 b3 /00:00:48/ 0.5625;
note /00:00:41376/ inst7 Equal440 d3 /00:00:24/ 0.585938;
note /00:00:41400/ inst7 Equal440 e2 /00:00:24/ 0.59375;
note /00:00:41424/ inst7 Equal440 a2 /00:00:48/ 0.601562;
note /00:00:41472/ inst7 Equal440 a4 /00:00:48/ 0.625;
note /00:00:41520/ inst7 Equal440 a4 /00:00:24/ 0.625;
note /00:00:41544/ inst7 Equal440 e4 /00:00:24/ 0.625;
note /00:00:41568/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:41592/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:41640/ inst7 Equal440 a4 /00:00:48/ 0.625;
note /00:00:41688/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:41712/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:41760/ inst7 Equal440 g3 /00:00:24/ 0.625;
note /00:00:41784/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:41808/ inst7 Equal440 d3 /00:00:48/ 0.625;
note /00:00:41856/ inst7 Equal440 f#4 /00:00:48/ 0.625;
note /00:00:41904/ inst7 Equal440 f#4 /00:00:24/ 0.625;
note /00:00:41928/ inst7 Equal440 c#4 /00:00:24/ 0.625;
note /00:00:41952/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:41976/ inst7 Equal440 c#4 /00:00:48/ 0.625;
note /00:00:42024/ inst7 Equal440 f#4 /00:00:48/ 0.625;
note /00:00:42072/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:42096/ inst7 Equal440 c#4 /00:00:48/ 0.625;
note /00:00:42144/ inst7 Equal440 e3 /00:00:24/ 0.625;
note /00:00:42168/ inst7 Equal440 f#2 /00:00:24/ 0.625;
note /00:00:42192/ inst7 Equal440 b2 /00:00:48/ 0.625;
note /00:00:42240/ inst7 Equal440 g4 /00:00:48/ 0.625;
note /00:00:42288/ inst7 Equal440 g4 /00:00:24/ 0.625;
note /00:00:42312/ inst7 Equal440 d4 /00:00:24/ 0.625;
note /00:00:42336/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:42360/ inst7 Equal440 d4 /00:00:48/ 0.625;
note /00:00:42408/ inst7 Equal440 g4 /00:00:48/ 0.625;
note /00:00:42456/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:42480/ inst7 Equal440 d4 /00:00:48/ 0.625;
note /00:00:42528/ inst7 Equal440 f3 /00:00:24/ 0.625;
note /00:00:42552/ inst7 Equal440 g2 /00:00:24/ 0.625;
note /00:00:42576/ inst7 Equal440 c3 /00:00:48/ 0.625;
note /00:00:42624/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:42672/ inst7 Equal440 e4 /00:00:24/ 0.625;
note /00:00:42696/ inst7 Equal440 b3 /00:00:24/ 0.625;
note /00:00:42720/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:42744/ inst7 Equal440 b3 /00:00:48/ 0.625;
note /00:00:42792/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:42840/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:42864/ inst7 Equal440 b3 /00:00:48/ 0.625;
note /00:00:42912/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:42936/ inst7 Equal440 e2 /00:00:24/ 0.625;
note /00:00:42960/ inst7 Equal440 a2 /00:00:48/ 0.625;
note /00:00:43008/ inst7 Equal440 a4 /00:00:48/ 0.625;
note /00:00:43056/ inst7 Equal440 a4 /00:00:24/ 0.625;
note /00:00:43080/ inst7 Equal440 e4 /00:00:24/ 0.625;
note /00:00:43104/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:43128/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:43176/ inst7 Equal440 a4 /00:00:48/ 0.625;
note /00:00:43224/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:43248/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:43296/ inst7 Equal440 g3 /00:00:24/ 0.625;
note /00:00:43320/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:43344/ inst7 Equal440 d3 /00:00:48/ 0.625;
note /00:00:43392/ inst7 Equal440 f#4 /00:00:48/ 0.625;
note /00:00:43440/ inst7 Equal440 f#4 /00:00:24/ 0.625;
note /00:00:43464/ inst7 Equal440 c#4 /00:00:24/ 0.625;
note /00:00:43488/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:43512/ inst7 Equal440 c#4 /00:00:48/ 0.625;
note /00:00:43560/ inst7 Equal440 f#4 /00:00:48/ 0.625;
note /00:00:43608/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:43632/ inst7 Equal440 c#4 /00:00:48/ 0.625;
note /00:00:43680/ inst7 Equal440 e3 /00:00:24/ 0.625;
note /00:00:43704/ inst7 Equal440 f#2 /00:00:24/ 0.625;
note /00:00:43728/ inst7 Equal440 b2 /00:00:48/ 0.625;
note /00:00:43776/ inst7 Equal440 g4 /00:00:48/ 0.625;
note /00:00:43824/ inst7 Equal440 g4 /00:00:24/ 0.625;
note /00:00:43848/ inst7 Equal440 d4 /00:00:24/ 0.625;
note /00:00:43872/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:43896/ inst7 Equal440 d4 /00:00:48/ 0.625;
note /00:00:43944/ inst7 Equal440 g4 /00:00:48/ 0.625;
note /00:00:43992/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:44016/ inst7 Equal440 d4 /00:00:48/ 0.625;
note /00:00:44064/ inst7 Equal440 f3 /00:00:24/ 0.625;
note /00:00:44088/ inst7 Equal440 g2 /00:00:24/ 0.625;
note /00:00:44112/ inst7 Equal440 c3 /00:00:48/ 0.625;
note /00:00:44160/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:44208/ inst7 Equal440 e4 /00:00:24/ 0.625;
note /00:00:44232/ inst7 Equal440 b3 /00:00:24/ 0.625;
note /00:00:44256/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:44280/ inst7 Equal440 b3 /00:00:48/ 0.625;
note /00:00:44328/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:44376/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:44400/ inst7 Equal440 b3 /00:00:48/ 0.625;
note /00:00:44448/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:44472/ inst7 Equal440 e2 /00:00:24/ 0.625;
note /00:00:44496/ inst7 Equal440 a2 /00:00:48/ 0.625;
note /00:00:44544/ inst7 Equal440 a4 /00:00:48/ 0.625;
note /00:00:44592/ inst7 Equal440 a4 /00:00:24/ 0.625;
note /00:00:44616/ inst7 Equal440 e4 /00:00:24/ 0.625;
note /00:00:44640/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:44664/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:44712/ inst7 Equal440 a4 /00:00:48/ 0.625;
note /00:00:44760/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:44784/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:44832/ inst7 Equal440 g3 /00:00:24/ 0.625;
note /00:00:44856/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:44880/ inst7 Equal440 d3 /00:00:48/ 0.625;
note /00:00:44928/ inst7 Equal440 f#4 /00:00:48/ 0.625;
note /00:00:44976/ inst7 Equal440 f#4 /00:00:24/ 0.625;
note /00:00:45000/ inst7 Equal440 c#4 /00:00:24/ 0.625;
note /00:00:45024/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:45048/ inst7 Equal440 c#4 /00:00:48/ 0.625;
note /00:00:45096/ inst7 Equal440 f#4 /00:00:48/ 0.625;
note /00:00:45144/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:45168/ inst7 Equal440 c#4 /00:00:48/ 0.625;
note /00:00:45216/ inst7 Equal440 e3 /00:00:24/ 0.625;
note /00:00:45240/ inst7 Equal440 f#2 /00:00:24/ 0.625;
note /00:00:45264/ inst7 Equal440 b2 /00:00:48/ 0.625;
note /00:00:45312/ inst7 Equal440 g4 /00:00:48/ 0.625;
note /00:00:45360/ inst7 Equal440 g4 /00:00:24/ 0.625;
note /00:00:45384/ inst7 Equal440 d4 /00:00:24/ 0.625;
note /00:00:45408/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:45432/ inst7 Equal440 d4 /00:00:48/ 0.625;
note /00:00:45480/ inst7 Equal440 g4 /00:00:48/ 0.625;
note /00:00:45528/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:45552/ inst7 Equal440 d4 /00:00:48/ 0.625;
note /00:00:45600/ inst7 Equal440 f3 /00:00:24/ 0.625;
note /00:00:45624/ inst7 Equal440 g2 /00:00:24/ 0.625;
note /00:00:45648/ inst7 Equal440 c3 /00:00:48/ 0.625;
note /00:00:45696/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:45744/ inst7 Equal440 e4 /00:00:24/ 0.625;
note /00:00:45768/ inst7 Equal440 b3 /00:00:24/ 0.625;
note /00:00:45792/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:45816/ inst7 Equal440 b3 /00:00:48/ 0.625;
note /00:00:45864/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:45912/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:45936/ inst7 Equal440 b3 /00:00:48/ 0.625;
note /00:00:45984/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:46008/ inst7 Equal440 e2 /00:00:24/ 0.625;
note /00:00:46032/ inst7 Equal440 a2 /00:00:48/ 0.625;
note /00:00:46080/ inst7 Equal440 a4 /00:00:48/ 0.625;
note /00:00:46128/ inst7 Equal440 a4 /00:00:24/ 0.625;
note /00:00:46152/ inst7 Equal440 e4 /00:00:24/ 0.625;
note /00:00:46176/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:46200/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:46248/ inst7 Equal440 a4 /00:00:48/ 0.625;
note /00:00:46296/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:46320/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:46368/ inst7 Equal440 g3 /00:00:24/ 0.625;
note /00:00:46392/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:46416/ inst7 Equal440 d3 /00:00:48/ 0.625;
note /00:00:46464/ inst7 Equal440 f#4 /00:00:48/ 0.625;
note /00:00:46512/ inst7 Equal440 f#4 /00:00:24/ 0.625;
note /00:00:46536/ inst7 Equal440 c#4 /00:00:24/ 0.625;
note /00:00:46560/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:46584/ inst7 Equal440 c#4 /00:00:48/ 0.625;
note /00:00:46632/ inst7 Equal440 f#4 /00:00:48/ 0.625;
note /00:00:46680/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:46704/ inst7 Equal440 c#4 /00:00:48/ 0.625;
note /00:00:46752/ inst7 Equal440 e3 /00:00:24/ 0.625;
note /00:00:46776/ inst7 Equal440 f#2 /00:00:24/ 0.625;
note /00:00:46800/ inst7 Equal440 b2 /00:00:48/ 0.625;
note /00:00:46848/ inst7 Equal440 g4 /00:00:48/ 0.625;
note /00:00:46896/ inst7 Equal440 g4 /00:00:24/ 0.625;
note /00:00:46920/ inst7 Equal440 d4 /00:00:24/ 0.625;
note /00:00:46944/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:46968/ inst7 Equal440 d4 /00:00:48/ 0.625;
note /00:00:47016/ inst7 Equal440 g4 /00:00:48/ 0.625;
note /00:00:47064/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:47088/ inst7 Equal440 d4 /00:00:48/ 0.625;
note /00:00:47136/ inst7 Equal440 f3 /00:00:24/ 0.625;
note /00:00:47160/ inst7 Equal440 g2 /00:00:24/ 0.625;
note /00:00:47184/ inst7 Equal440 c3 /00:00:48/ 0.625;
note /00:00:47232/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:47280/ inst7 Equal440 e4 /00:00:24/ 0.625;
note /00:00:47304/ inst7 Equal440 b3 /00:00:24/ 0.625;
note /00:00:47328/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:47352/ inst7 Equal440 b3 /00:00:48/ 0.625;
note /00:00:47400/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:47448/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:47472/ inst7 Equal440 b3 /00:00:48/ 0.625;
note /00:00:47520/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:47544/ inst7 Equal440 e2 /00:00:24/ 0.625;
note /00:00:47568/ inst7 Equal440 a2 /00:00:48/ 0.625;
note /00:00:47616/ inst7 Equal440 a4 /00:00:48/ 0.625;
note /00:00:47664/ inst7 Equal440 a4 /00:00:24/ 0.625;
note /00:00:47688/ inst7 Equal440 e4 /00:00:24/ 0.625;
note /00:00:47712/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:47736/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:47784/ inst7 Equal440 a4 /00:00:48/ 0.625;
note /00:00:47832/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:47856/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:47904/ inst7 Equal440 g3 /00:00:24/ 0.625;
note /00:00:47928/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:47952/ inst7 Equal440 d3 /00:00:48/ 0.625;
note /00:00:48000/ inst7 Equal440 f#4 /00:00:48/ 0.625;
note /00:00:48048/ inst7 Equal440 f#4 /00:00:24/ 0.625;
note /00:00:48072/ inst7 Equal440 c#4 /00:00:24/ 0.625;
note /00:00:48096/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:48120/ inst7 Equal440 c#4 /00:00:48/ 0.625;
note /00:00:48168/ inst7 Equal440 f#4 /00:00:48/ 0.625;
note /00:00:48216/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:48240/ inst7 Equal440 c#4 /00:00:48/ 0.625;
note /00:00:48288/ inst7 Equal440 e3 /00:00:24/ 0.625;
note /00:00:48312/ inst7 Equal440 f#2 /00:00:24/ 0.625;
note /00:00:48336/ inst7 Equal440 b2 /00:00:48/ 0.625;
note /00:00:48384/ inst7 Equal440 g4 /00:00:48/ 0.625;
note /00:00:48432/ inst7 Equal440 g4 /00:00:24/ 0.625;
note /00:00:48456/ inst7 Equal440 d4 /00:00:24/ 0.625;
note /00:00:48480/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:48504/ inst7 Equal440 d4 /00:00:48/ 0.625;
note /00:00:48552/ inst7 Equal440 g4 /00:00:48/ 0.625;
note /00:00:48600/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:48624/ inst7 Equal440 d4 /00:00:48/ 0.625;
note /00:00:48672/ inst7 Equal440 f3 /00:00:24/ 0.625;
note /00:00:48696/ inst7 Equal440 g2 /00:00:24/ 0.625;
note /00:00:48720/ inst7 Equal440 c3 /00:00:48/ 0.625;
note /00:00:48768/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:48816/ inst7 Equal440 e4 /00:00:24/ 0.625;
note /00:00:48840/ inst7 Equal440 b3 /00:00:24/ 0.625;
note /00:00:48864/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:48888/ inst7 Equal440 b3 /00:00:48/ 0.625;
note /00:00:48936/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:48984/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:49008/ inst7 Equal440 b3 /00:00:48/ 0.625;
note /00:00:49056/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:49080/ inst7 Equal440 e2 /00:00:24/ 0.625;
note /00:00:49104/ inst7 Equal440 a2 /00:00:48/ 0.625;
note /00:00:49152/ inst7 Equal440 a4 /00:00:48/ 0.625;
note /00:00:49200/ inst7 Equal440 a4 /00:00:24/ 0.625;
note /00:00:49224/ inst7 Equal440 e4 /00:00:24/ 0.625;
note /00:00:49248/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:49272/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:49320/ inst7 Equal440 a4 /00:00:48/ 0.625;
note /00:00:49368/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:49392/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:49440/ inst7 Equal440 g3 /00:00:24/ 0.625;
note /00:00:49464/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:49488/ inst7 Equal440 d3 /00:00:48/ 0.625;
note /00:00:49536/ inst7 Equal440 f#4 /00:00:48/ 0.625;
note /00:00:49584/ inst7 Equal440 f#4 /00:00:24/ 0.625;
note /00:00:49608/ inst7 Equal440 c#4 /00:00:24/ 0.625;
note /00:00:49632/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:49656/ inst7 Equal440 c#4 /00:00:48/ 0.625;
note /00:00:49704/ inst7 Equal440 f#4 /00:00:48/ 0.625;
note /00:00:49752/ inst7 Equal440 b2 /00:00:24/ 0.625;
note /00:00:49776/ inst7 Equal440 c#4 /00:00:48/ 0.625;
note /00:00:49824/ inst7 Equal440 e3 /00:00:24/ 0.625;
note /00:00:49848/ inst7 Equal440 f#2 /00:00:24/ 0.625;
note /00:00:49872/ inst7 Equal440 b2 /00:00:48/ 0.625;
note /00:00:49920/ inst7 Equal440 g4 /00:00:48/ 0.625;
note /00:00:49968/ inst7 Equal440 g4 /00:00:24/ 0.625;
note /00:00:49992/ inst7 Equal440 d4 /00:00:24/ 0.625;
note /00:00:50016/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:50040/ inst7 Equal440 d4 /00:00:48/ 0.625;
note /00:00:50088/ inst7 Equal440 g4 /00:00:48/ 0.625;
note /00:00:50136/ inst7 Equal440 c3 /00:00:24/ 0.625;
note /00:00:50160/ inst7 Equal440 d4 /00:00:48/ 0.625;
note /00:00:50208/ inst7 Equal440 f3 /00:00:24/ 0.625;
note /00:00:50232/ inst7 Equal440 g2 /00:00:24/ 0.625;
note /00:00:50256/ inst7 Equal440 c3 /00:00:48/ 0.625;
note /00:00:50304/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:50352/ inst7 Equal440 e4 /00:00:24/ 0.625;
note /00:00:50376/ inst7 Equal440 b3 /00:00:24/ 0.625;
note /00:00:50400/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:50424/ inst7 Equal440 b3 /00:00:48/ 0.625;
note /00:00:50472/ inst7 Equal440 e4 /00:00:48/ 0.625;
note /00:00:50520/ inst7 Equal440 a2 /00:00:24/ 0.625;
note /00:00:50544/ inst7 Equal440 b3 /00:00:48/ 0.625;
note /00:00:50592/ inst7 Equal440 d3 /00:00:24/ 0.625;
note /00:00:50616/ inst7 Equal440 e2 /00:00:24/ 0.625;
note /00:00:50640/ inst7 Equal440 a2 /00:00:48/ 0.625;
note /00:00:50688/ inst7 Equal440 a4 /00:00:48/ 0.625;
note /00:00:50736/ inst7 Equal440 a4 /00:00:24/ 0.601562;
note /00:00:50760/ inst7 Equal440 e4 /00:00:24/ 0.59375;
note /00:00:50784/ inst7 Equal440 d3 /00:00:24/ 0.585938;
note /00:00:50808/ inst7 Equal440 e4 /00:00:48/ 0.570312;
note /00:00:50856/ inst7 Equal440 a4 /00:00:48/ 0.554688;
note /00:00:50904/ inst7 Equal440 d3 /00:00:24/ 0.53125;
note /00:00:50928/ inst7 Equal440 e4 /00:00:48/ 0.523438;
note /00:00:50976/ inst7 Equal440 g3 /00:00:24/ 0.507812;
note /00:00:51000/ inst7 Equal440 a2 /00:00:24/ 0.492188;
note /00:00:51024/ inst7 Equal440 d3 /00:00:48/ 0.484375;
note /00:00:51072/ inst7 Equal440 f#4 /00:00:48/ 0.46875;
note /00:00:51120/ inst7 Equal440 f#4 /00:00:24/ 0.445312;
note /00:00:51144/ inst7 Equal440 c#4 /00:00:24/ 0.4375;
note /00:00:51168/ inst7 Equal440 b2 /00:00:24/ 0.429688;
note /00:00:51192/ inst7 Equal440 c#4 /00:00:48/ 0.414062;
note /00:00:51240/ inst7 Equal440 f#4 /00:00:48/ 0.398438;
note /00:00:51288/ inst7 Equal440 b2 /00:00:24/ 0.375;
note /00:00:51312/ inst7 Equal440 c#4 /00:00:48/ 0.367188;
note /00:00:51360/ inst7 Equal440 e3 /00:00:24/ 0.351562;
note /00:00:51384/ inst7 Equal440 f#2 /00:00:24/ 0.335938;
note /00:00:51408/ inst7 Equal440 b2 /00:00:48/ 0.328125;
note /00:00:51456/ inst7 Equal440 g4 /00:00:48/ 0.3125;
note /00:00:51504/ inst7 Equal440 g4 /00:00:24/ 0.289062;
note /00:00:51528/ inst7 Equal440 d4 /00:00:24/ 0.28125;
note /00:00:51552/ inst7 Equal440 c3 /00:00:24/ 0.273438;
note /00:00:51576/ inst7 Equal440 d4 /00:00:48/ 0.257812;
note /00:00:51624/ inst7 Equal440 g4 /00:00:48/ 0.242188;
note /00:00:51672/ inst7 Equal440 c3 /00:00:24/ 0.21875;
note /00:00:51696/ inst7 Equal440 d4 /00:00:48/ 0.210938;
note /00:00:51744/ inst7 Equal440 f3 /00:00:24/ 0.195312;
note /00:00:51768/ inst7 Equal440 g2 /00:00:24/ 0.179688;
note /00:00:51792/ inst7 Equal440 c3 /00:00:48/ 0.171875;
note /00:00:51840/ inst7 Equal440 e4 /00:00:48/ 0.15625;
note /00:00:51888/ inst7 Equal440 e4 /00:00:24/ 0.132812;
note /00:00:51912/ inst7 Equal440 b3 /00:00:24/ 0.125;
note /00:00:51936/ inst7 Equal440 a2 /00:00:24/ 0.117188;
note /00:00:51960/ inst7 Equal440 b3 /00:00:48/ 0.101562;
note /00:00:52008/ inst7 Equal440 e4 /00:00:48/ 0.0859375;
note /00:00:52056/ inst7 Equal440 a2 /00:00:24/ 0.0625;
note /00:00:52080/ inst7 Equal440 b3 /00:00:48/ 0.0546875;
note /00:00:52128/ inst7 Equal440 d3 /00:00:24/ 0.0390625;
note /00:00:52152/ inst7 Equal440 e2 /00:00:24/ 0.0234375;
note /00:00:52176/ inst7 Equal440 a2 /00:00:48/ 0.015625;
--OTHER : 67584 Program 7 62
note /00:00:67608/ inst7 Equal440 g3 /00:00:24/ 0.0078125;
note /00:00:67632/ inst7 Equal440 a2 /00:00:48/ 0.015625;
note /00:00:67680/ inst7 Equal440 a2 /00:00:24/ 0.0390625;
note /00:00:67704/ inst7 Equal440 d3 /00:00:48/ 0.046875;
note /00:00:67752/ inst7 Equal440 e4 /00:00:24/ 0.0625;
note /00:00:67776/ inst7 Equal440 a2 /00:00:24/ 0.078125;
note /00:00:67800/ inst7 Equal440 a4 /00:00:48/ 0.0859375;
note /00:00:67848/ inst7 Equal440 a2 /00:00:48/ 0.101562;
note /00:00:67896/ inst7 Equal440 c4 /00:00:48/ 0.125;
note /00:00:67944/ inst7 Equal440 e4 /00:00:24/ 0.140625;
note /00:00:67968/ inst7 Equal440 e3 /00:00:24/ 0.15625;
note /00:00:67992/ inst7 Equal440 e3 /00:00:24/ 0.164062;
note /00:00:68016/ inst7 Equal440 f#2 /00:00:48/ 0.171875;
note /00:00:68064/ inst7 Equal440 f#2 /00:00:24/ 0.195312;
note /00:00:68088/ inst7 Equal440 b2 /00:00:48/ 0.203125;
note /00:00:68136/ inst7 Equal440 c#4 /00:00:24/ 0.21875;
note /00:00:68160/ inst7 Equal440 f#2 /00:00:24/ 0.234375;
note /00:00:68184/ inst7 Equal440 f#4 /00:00:48/ 0.242188;
note /00:00:68232/ inst7 Equal440 f#2 /00:00:48/ 0.257812;
note /00:00:68280/ inst7 Equal440 a3 /00:00:48/ 0.28125;
note /00:00:68328/ inst7 Equal440 c#4 /00:00:24/ 0.296875;
note /00:00:68352/ inst7 Equal440 f3 /00:00:24/ 0.3125;
note /00:00:68376/ inst7 Equal440 f3 /00:00:24/ 0.320312;
note /00:00:68400/ inst7 Equal440 g2 /00:00:48/ 0.328125;
note /00:00:68448/ inst7 Equal440 g2 /00:00:24/ 0.351562;
note /00:00:68472/ inst7 Equal440 c3 /00:00:48/ 0.359375;
note /00:00:68520/ inst7 Equal440 d4 /00:00:24/ 0.375;
note /00:00:68544/ inst7 Equal440 g2 /00:00:24/ 0.390625;
note /00:00:68568/ inst7 Equal440 g4 /00:00:48/ 0.398438;
note /00:00:68616/ inst7 Equal440 g2 /00:00:48/ 0.414062;
note /00:00:68664/ inst7 Equal440 a#3 /00:00:48/ 0.4375;
note /00:00:68712/ inst7 Equal440 d4 /00:00:24/ 0.453125;
note /00:00:68736/ inst7 Equal440 d3 /00:00:24/ 0.46875;
note /00:00:68760/ inst7 Equal440 d3 /00:00:24/ 0.476562;
note /00:00:68784/ inst7 Equal440 e2 /00:00:48/ 0.484375;
note /00:00:68832/ inst7 Equal440 e2 /00:00:24/ 0.507812;
note /00:00:68856/ inst7 Equal440 a2 /00:00:48/ 0.515625;
note /00:00:68904/ inst7 Equal440 b3 /00:00:24/ 0.53125;
note /00:00:68928/ inst7 Equal440 e2 /00:00:24/ 0.546875;
note /00:00:68952/ inst7 Equal440 e4 /00:00:48/ 0.554688;
note /00:00:69000/ inst7 Equal440 e2 /00:00:48/ 0.570312;
note /00:00:69048/ inst7 Equal440 g3 /00:00:48/ 0.59375;
note /00:00:69096/ inst7 Equal440 b3 /00:00:24/ 0.609375;
note /00:00:69120/ inst7 Equal440 g3 /00:00:24/ 0.625;
note /00:00:69144/ inst7 Equal440 g3 /00:00:24/ 0.609375;
note /00:00:69168/ inst7 Equal440 a2 /00:00:48/ 0.601562;
note /00:00:69216/ inst7 Equal440 a2 /00:00:24/ 0.585938;
note /00:00:69240/ inst7 Equal440 d3 /00:00:48/ 0.570312;
note /00:00:69288/ inst7 Equal440 e4 /00:00:24/ 0.554688;
note /00:00:69312/ inst7 Equal440 a2 /00:00:24/ 0.546875;
note /00:00:69336/ inst7 Equal440 a4 /00:00:48/ 0.53125;
note /00:00:69384/ inst7 Equal440 a2 /00:00:48/ 0.515625;
note /00:00:69432/ inst7 Equal440 c4 /00:00:48/ 0.492188;
note /00:00:69480/ inst7 Equal440 e4 /00:00:24/ 0.476562;
note /00:00:69504/ inst7 Equal440 e3 /00:00:24/ 0.46875;
note /00:00:69528/ inst7 Equal440 e3 /00:00:24/ 0.453125;
note /00:00:69552/ inst7 Equal440 f#2 /00:00:48/ 0.445312;
note /00:00:69600/ inst7 Equal440 f#2 /00:00:24/ 0.429688;
note /00:00:69624/ inst7 Equal440 b2 /00:00:48/ 0.414062;
note /00:00:69672/ inst7 Equal440 c#4 /00:00:24/ 0.398438;
note /00:00:69696/ inst7 Equal440 f#2 /00:00:24/ 0.390625;
note /00:00:69720/ inst7 Equal440 f#4 /00:00:48/ 0.375;
note /00:00:69768/ inst7 Equal440 f#2 /00:00:48/ 0.359375;
note /00:00:69816/ inst7 Equal440 a3 /00:00:48/ 0.335938;
note /00:00:69864/ inst7 Equal440 c#4 /00:00:24/ 0.320312;
note /00:00:69888/ inst7 Equal440 f3 /00:00:24/ 0.3125;
note /00:00:69912/ inst7 Equal440 f3 /00:00:24/ 0.296875;
note /00:00:69936/ inst7 Equal440 g2 /00:00:48/ 0.289062;
note /00:00:69984/ inst7 Equal440 g2 /00:00:24/ 0.273438;
note /00:00:70008/ inst7 Equal440 c3 /00:00:48/ 0.257812;
note /00:00:70056/ inst7 Equal440 d4 /00:00:24/ 0.242188;
note /00:00:70080/ inst7 Equal440 g2 /00:00:24/ 0.234375;
note /00:00:70104/ inst7 Equal440 g4 /00:00:48/ 0.21875;
note /00:00:70152/ inst7 Equal440 g2 /00:00:48/ 0.203125;
note /00:00:70200/ inst7 Equal440 a#3 /00:00:48/ 0.179688;
note /00:00:70248/ inst7 Equal440 d4 /00:00:24/ 0.164062;
note /00:00:70272/ inst7 Equal440 d3 /00:00:24/ 0.15625;
note /00:00:70296/ inst7 Equal440 d3 /00:00:24/ 0.140625;
note /00:00:70320/ inst7 Equal440 e2 /00:00:48/ 0.132812;
note /00:00:70368/ inst7 Equal440 e2 /00:00:24/ 0.117188;
note /00:00:70392/ inst7 Equal440 a2 /00:00:48/ 0.101562;
note /00:00:70440/ inst7 Equal440 b3 /00:00:24/ 0.0859375;
note /00:00:70464/ inst7 Equal440 e2 /00:00:24/ 0.078125;
note /00:00:70488/ inst7 Equal440 e4 /00:00:48/ 0.0625;
note /00:00:70536/ inst7 Equal440 e2 /00:00:48/ 0.046875;
note /00:00:70584/ inst7 Equal440 g3 /00:00:48/ 0.0234375;
note /00:00:70632/ inst7 Equal440 b3 /00:00:24/ 0.0078125;
end at /00:00:78336/;
