include Equal440.sc
include pulse.spi

include sine.wave
include saw.wave

signature 4 4;
tempo 200;

instrument baribell durationadd 0.5
{
	%a1:	expodecay $noteon 1 2 0.9;
	%e1:	mul $amp $amp %a1 %a1;
	%modfa:	mul $freq 4.5;

	%modf:	mul $freq 1.36 {add {osc &sine %modfa %e1} 2};
	%modf2:	add %modf 2;
	%o1:	add {osc &sine %modf %e1} 2;
	%o2:	add {osc &sine %modf2 %e1} 2;

	%o:		mix 
				{osc &sine {mul $freq %o1} $amp}
				{osc &sine {mul {add $freq 2} %o1} $amp}
				{osc &saw {mul $freq 4} {div $amp 4}}
				{osc &saw {add {mul $freq 4} 1.5} {div $amp 4}};
	%a2:	expodecay $noteon 1 4 1;

	out:	mul %a2 %a2 %o;
}

instrument baripulse durationadd 0.0
{
	%ffreq:	mul $freq 2;
	%e1:	adsr $noteon $gate 0.1 0.1 0.0 0.0 1.0;
	%e2:	expodecay $noteon 1.0 0.25 1.0;

	%f1:	add 1.5 {mul %ffreq 2.5};
	%o1:	osc &sine %f1 0.5;
	%mod:	add 1.0 %o1;
	%f2:	mul %ffreq %mod;

	%osc1:	osc &sine $freq %e1;
	%osc2:	osc &sine %f2 %e2;

	%out1:	mix %osc1 %osc2;
	out:	mul %out1 $amp;
}
	

sig : instance inst0 6 of baribell;
delsig : delay sig 0.4 0.05;


CH0,CH1:
	stereomix
		sig -0.5 2
		delsig 0.5 2
		{instance inst1 6 of baripulse} 0.2 4;

-- Sapphire score generated from /dos/ultrasnd/midi/barimyst.mid by mid2sapp $Revision: 1.3 $
-- drum tracks : 9, offset : 4




--OTHER : 0 MetaPortNumber 0
--OTHER : 0 MetaSequenceName "Les Barricades Mysterieuses "
--OTHER : 0 Parameter 1 91 0
--OTHER : 38401 Parameter 1 91 40

--OTHER : 0 MetaPortNumber 0
--OTHER : 0 MetaSequenceName "Bass Banjo (tubby sound - reverb off)"
--OTHER : 0 Program 1 105
note /00:00:376/ inst1 Equal440 a#0 /00:00:120/ 0.78125;
note /00:00:496/ inst1 Equal440 f1 /00:00:360/ 0.78125;
note /00:00:616/ inst1 Equal440 f0 /00:00:120/ 0.78125;
note /00:00:736/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:856/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:976/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:1096/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:1216/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:1336/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:1456/ inst1 Equal440 d0 /00:00:240/ 0.78125;
note /00:00:1576/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:1696/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:1816/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:1936/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:2056/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:2176/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:2296/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:2416/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:2536/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:2656/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:2776/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:2896/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:3016/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:3136/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:3256/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:3376/ inst1 Equal440 d0 /00:00:240/ 0.78125;
note /00:00:3496/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:3616/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:3736/ inst1 Equal440 c1 /00:00:360/ 0.78125;
note /00:00:3856/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:3976/ inst1 Equal440 d#1 /00:00:120/ 0.78125;
note /00:00:4096/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:4096/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:4216/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:4336/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:4456/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:4576/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:4696/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:4816/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:4936/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:5056/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:5176/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:5296/ inst1 Equal440 d0 /00:00:240/ 0.78125;
note /00:00:5416/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:5536/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:5656/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:5776/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:5896/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:6016/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:6136/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:6256/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:6376/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:6496/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:6616/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:6736/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:6856/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:6976/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:7096/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:7216/ inst1 Equal440 d0 /00:00:240/ 0.78125;
note /00:00:7336/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:7456/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:7576/ inst1 Equal440 c1 /00:00:360/ 0.78125;
note /00:00:7696/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:7816/ inst1 Equal440 d#1 /00:00:120/ 0.78125;
note /00:00:7936/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:7936/ inst1 Equal440 d1 /00:00:120/ 0.78125;
note /00:00:8056/ inst1 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:8176/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:8296/ inst1 Equal440 a1 /00:00:120/ 0.78125;
note /00:00:8416/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:8536/ inst1 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:8656/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:8776/ inst1 Equal440 a1 /00:00:120/ 0.78125;
note /00:00:8896/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:9016/ inst1 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:9136/ inst1 Equal440 a0 /00:00:240/ 0.78125;
note /00:00:9256/ inst1 Equal440 f1 /00:00:120/ 0.78125;
note /00:00:9376/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:9496/ inst1 Equal440 g1 /00:00:240/ 0.78125;
note /00:00:9616/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:9736/ inst1 Equal440 g1 /00:00:120/ 0.78125;
note /00:00:9856/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:9976/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:10096/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:10216/ inst1 Equal440 e1 /00:00:120/ 0.78125;
note /00:00:10336/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:10456/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:10576/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:10696/ inst1 Equal440 e1 /00:00:120/ 0.78125;
note /00:00:10816/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:10936/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:11056/ inst1 Equal440 a0 /00:00:240/ 0.78125;
note /00:00:11176/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:11296/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:11416/ inst1 Equal440 f1 /00:00:120/ 0.78125;
note /00:00:11536/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:11656/ inst1 Equal440 c0 /00:00:120/ 0.78125;
note /00:00:11776/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:11896/ inst1 Equal440 f1 /00:00:120/ 0.78125;
note /00:00:12016/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:12136/ inst1 Equal440 c0 /00:00:120/ 0.78125;
note /00:00:12256/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:12376/ inst1 Equal440 g1 /00:00:120/ 0.78125;
note /00:00:12496/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:12616/ inst1 Equal440 d0 /00:00:120/ 0.78125;
note /00:00:12736/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:12856/ inst1 Equal440 d#1 /00:00:120/ 0.78125;
note /00:00:12976/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:13096/ inst1 Equal440 c0 /00:00:120/ 0.78125;
note /00:00:13216/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:13336/ inst1 Equal440 f1 /00:00:120/ 0.78125;
note /00:00:13456/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:13576/ inst1 Equal440 a#-1 /00:00:120/ 0.78125;
note /00:00:13696/ inst1 Equal440 f0 /00:00:120/ 0.78125;
note /00:00:13816/ inst1 Equal440 a#0 /00:00:120/ 0.78125;
note /00:00:13936/ inst1 Equal440 f1 /00:00:360/ 0.78125;
note /00:00:14056/ inst1 Equal440 f0 /00:00:120/ 0.78125;
note /00:00:14176/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:14296/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:14416/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:14536/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:14656/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:14776/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:14896/ inst1 Equal440 d0 /00:00:240/ 0.78125;
note /00:00:15016/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:15136/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:15256/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:15376/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:15496/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:15616/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:15736/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:15856/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:15976/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:16096/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:16216/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:16336/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:16456/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:16576/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:16696/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:16816/ inst1 Equal440 d0 /00:00:240/ 0.78125;
note /00:00:16936/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:17056/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:17176/ inst1 Equal440 c1 /00:00:360/ 0.78125;
note /00:00:17296/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:17416/ inst1 Equal440 d#1 /00:00:120/ 0.78125;
note /00:00:17536/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:17536/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:17656/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:17776/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:17896/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:18016/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:18136/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:18256/ inst1 Equal440 d0 /00:00:240/ 0.78125;
note /00:00:18376/ inst1 Equal440 d1 /00:00:120/ 0.78125;
note /00:00:18496/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:18616/ inst1 Equal440 d#1 /00:00:120/ 0.78125;
note /00:00:18736/ inst1 Equal440 b0 /00:00:240/ 0.78125;
note /00:00:18856/ inst1 Equal440 g0 /00:00:120/ 0.78125;
note /00:00:18976/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:19096/ inst1 Equal440 f0 /00:00:120/ 0.78125;
note /00:00:19216/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:19336/ inst1 Equal440 g-1 /00:00:120/ 0.78125;
note /00:00:19456/ inst1 Equal440 c0 /00:00:240/ 0.78125;
note /00:00:19576/ inst1 Equal440 c1 /00:00:120/ 0.78125;
note /00:00:19696/ inst1 Equal440 d0 /00:00:240/ 0.78125;
note /00:00:19816/ inst1 Equal440 d1 /00:00:120/ 0.78125;
note /00:00:19936/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:20056/ inst1 Equal440 d#1 /00:00:120/ 0.78125;
note /00:00:20176/ inst1 Equal440 e0 /00:00:120/ 0.78125;
note /00:00:20296/ inst1 Equal440 c0 /00:00:120/ 0.78125;
note /00:00:20416/ inst1 Equal440 f0 /00:00:120/ 0.78125;
note /00:00:20536/ inst1 Equal440 a#0 /00:00:120/ 0.78125;
note /00:00:20656/ inst1 Equal440 f1 /00:00:360/ 0.78125;
note /00:00:20776/ inst1 Equal440 f0 /00:00:120/ 0.78125;
note /00:00:20896/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:21016/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:21136/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:21256/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:21376/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:21496/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:21616/ inst1 Equal440 d0 /00:00:240/ 0.78125;
note /00:00:21736/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:21856/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:21976/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:22096/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:22216/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:22336/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:22456/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:22576/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:22696/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:22816/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:22936/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:23056/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:23176/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:23296/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:23416/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:23536/ inst1 Equal440 d0 /00:00:240/ 0.78125;
note /00:00:23656/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:23776/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:23896/ inst1 Equal440 c1 /00:00:360/ 0.78125;
note /00:00:24016/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:24136/ inst1 Equal440 d#1 /00:00:120/ 0.78125;
note /00:00:24256/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:24256/ inst1 Equal440 d1 /00:00:120/ 0.78125;
note /00:00:24376/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:24496/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:24616/ inst1 Equal440 g1 /00:00:240/ 0.78125;
note /00:00:24736/ inst1 Equal440 g#0 /00:00:240/ 0.78125;
note /00:00:24856/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:24976/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:25096/ inst1 Equal440 g#1 /00:00:240/ 0.78125;
note /00:00:25216/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:25336/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:25456/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:25576/ inst1 Equal440 g1 /00:00:240/ 0.78125;
note /00:00:25696/ inst1 Equal440 g#0 /00:00:240/ 0.78125;
note /00:00:25816/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:25936/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:26056/ inst1 Equal440 f1 /00:00:120/ 0.78125;
note /00:00:26176/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:26416/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:26536/ inst1 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:26656/ inst1 Equal440 e1 /00:00:240/ 0.78125;
note /00:00:26776/ inst1 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:26896/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:27016/ inst1 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:27136/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:27256/ inst1 Equal440 g#1 /00:00:240/ 0.78125;
note /00:00:27376/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:27496/ inst1 Equal440 g#1 /00:00:240/ 0.78125;
note /00:00:27616/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:27736/ inst1 Equal440 g#1 /00:00:240/ 0.78125;
note /00:00:27856/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:27976/ inst1 Equal440 g#1 /00:00:240/ 0.78125;
note /00:00:28096/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:28216/ inst1 Equal440 g1 /00:00:240/ 0.78125;
note /00:00:28336/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:28456/ inst1 Equal440 g1 /00:00:240/ 0.78125;
note /00:00:28576/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:28696/ inst1 Equal440 g1 /00:00:240/ 0.78125;
note /00:00:28816/ inst1 Equal440 a0 /00:00:240/ 0.78125;
note /00:00:28936/ inst1 Equal440 g1 /00:00:240/ 0.78125;
note /00:00:29056/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:29176/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:29296/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:29416/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:29536/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:29656/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:29776/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:29896/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:30016/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:30136/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:30256/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:30376/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:30496/ inst1 Equal440 a0 /00:00:240/ 0.78125;
note /00:00:30616/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:30736/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:30856/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:30976/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:31096/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:31216/ inst1 Equal440 d0 /00:00:240/ 0.78125;
note /00:00:31336/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:31456/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:31576/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:31696/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:31816/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:31936/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:32056/ inst1 Equal440 c1 /00:00:120/ 0.78125;
note /00:00:32176/ inst1 Equal440 d0 /00:00:240/ 0.78125;
note /00:00:32296/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:32416/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:32536/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:32656/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:32776/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:32896/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:33016/ inst1 Equal440 c1 /00:00:120/ 0.78125;
note /00:00:33136/ inst1 Equal440 d0 /00:00:240/ 0.78125;
note /00:00:33256/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:33376/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:33496/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:33616/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:33736/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:33856/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:33976/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:34096/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:34216/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:34336/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:34456/ inst1 Equal440 c1 /00:00:360/ 0.78125;
note /00:00:34576/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:34696/ inst1 Equal440 f0 /00:00:120/ 0.78125;
note /00:00:34816/ inst1 Equal440 d1 /00:00:120/ 0.78125;
note /00:00:34816/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:34936/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:35056/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:35176/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:35296/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:35416/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:35536/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:35656/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:35776/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:35896/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:36016/ inst1 Equal440 d0 /00:00:240/ 0.78125;
note /00:00:36136/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:36256/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:36376/ inst1 Equal440 c1 /00:00:240/ 0.78125;
note /00:00:36496/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:36616/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:36736/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:36856/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:36976/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:37096/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:37216/ inst1 Equal440 a#0 /00:00:240/ 0.78125;
note /00:00:37336/ inst1 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:37456/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:37576/ inst1 Equal440 d#1 /00:00:240/ 0.78125;
note /00:00:37696/ inst1 Equal440 g0 /00:00:240/ 0.78125;
note /00:00:37816/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:37936/ inst1 Equal440 d0 /00:00:240/ 0.78125;
note /00:00:38056/ inst1 Equal440 d1 /00:00:240/ 0.78125;
note /00:00:38176/ inst1 Equal440 d#0 /00:00:240/ 0.78125;
note /00:00:38296/ inst1 Equal440 c1 /00:00:360/ 0.78125;
note /00:00:38416/ inst1 Equal440 f0 /00:00:240/ 0.78125;
note /00:00:38536/ inst1 Equal440 d#1 /00:00:120/ 0.78125;
note /00:00:38656/ inst1 Equal440 a#-1 /00:00:480/ 0.78125;
note /00:00:38656/ inst1 Equal440 a#0 /00:00:480/ 0.78125;

--OTHER : 0 MetaPortNumber 0
--OTHER : 0 MetaSequenceName "  Francois Couperin (Le Grand)"

--OTHER : 0 MetaPortNumber 0
--OTHER : 0 MetaSequenceName "Lead 5-string (classic banjo)"
--OTHER : 0 Program 0 105
note /00:00:316/ inst0 Equal440 a#1 /00:00:60/ 0.703125;
note /00:00:376/ inst0 Equal440 d2 /00:00:180/ 0.703125;
note /00:00:436/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:556/ inst0 Equal440 c2 /00:00:180/ 0.703125;
note /00:00:616/ inst0 Equal440 f2 /00:00:180/ 0.703125;
note /00:00:676/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:796/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:856/ inst0 Equal440 d2 /00:00:180/ 0.703125;
note /00:00:916/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:976/ inst0 Equal440 c2 /00:00:180/ 0.703125;
note /00:00:1096/ inst0 Equal440 f2 /00:00:180/ 0.703125;
note /00:00:1156/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:1276/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:1336/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:1396/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:1516/ inst0 Equal440 f1 /00:00:180/ 0.703125;
note /00:00:1576/ inst0 Equal440 a#1 /00:00:60/ 0.703125;
note /00:00:1636/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:1696/ inst0 Equal440 g1 /00:00:180/ 0.703125;
note /00:00:1756/ inst0 Equal440 a#1 /00:00:60/ 0.703125;
note /00:00:1816/ inst0 Equal440 d#2 /00:00:180/ 0.703125;
note /00:00:1876/ inst0 Equal440 g1 /00:00:60/ 0.703125;
note /00:00:1936/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:1996/ inst0 Equal440 d#2 /00:00:60/ 0.703125;
note /00:00:2056/ inst0 Equal440 d2 /00:00:20/ 0.703125;
note /00:00:2076/ inst0 Equal440 d#2 /00:00:20/ 0.703125;
note /00:00:2096/ inst0 Equal440 d2 /00:00:20/ 0.703125;
note /00:00:2116/ inst0 Equal440 c2 /00:00:60/ 0.703125;
note /00:00:2176/ inst0 Equal440 d2 /00:00:60/ 0.703125;
note /00:00:2236/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:2296/ inst0 Equal440 d2 /00:00:180/ 0.703125;
note /00:00:2356/ inst0 Equal440 a#1 /00:00:180/ 0.703125;
note /00:00:2476/ inst0 Equal440 c2 /00:00:180/ 0.703125;
note /00:00:2536/ inst0 Equal440 f2 /00:00:180/ 0.703125;
note /00:00:2596/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:2716/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:2776/ inst0 Equal440 d2 /00:00:180/ 0.703125;
note /00:00:2836/ inst0 Equal440 a#1 /00:00:180/ 0.703125;
note /00:00:2956/ inst0 Equal440 c2 /00:00:180/ 0.703125;
note /00:00:3016/ inst0 Equal440 f2 /00:00:180/ 0.703125;
note /00:00:3076/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:3196/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:3256/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:3316/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:3436/ inst0 Equal440 f1 /00:00:180/ 0.703125;
note /00:00:3496/ inst0 Equal440 a#1 /00:00:60/ 0.703125;
note /00:00:3556/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:3616/ inst0 Equal440 g1 /00:00:180/ 0.703125;
note /00:00:3676/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:3736/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:3796/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:3916/ inst0 Equal440 f1 /00:00:240/ 0.703125;
note /00:00:3976/ inst0 Equal440 a#1 /00:00:60/ 0.703125;
note /00:00:4036/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:4096/ inst0 Equal440 a#1 /00:00:20/ 0.703125;
note /00:00:4116/ inst0 Equal440 a1 /00:00:20/ 0.703125;
note /00:00:4136/ inst0 Equal440 a#1 /00:00:20/ 0.703125;
note /00:00:4156/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:4216/ inst0 Equal440 d2 /00:00:180/ 0.703125;
note /00:00:4276/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:4396/ inst0 Equal440 c2 /00:00:180/ 0.703125;
note /00:00:4456/ inst0 Equal440 f2 /00:00:180/ 0.703125;
note /00:00:4516/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:4636/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:4696/ inst0 Equal440 d2 /00:00:180/ 0.703125;
note /00:00:4756/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:4816/ inst0 Equal440 c2 /00:00:180/ 0.703125;
note /00:00:4936/ inst0 Equal440 f2 /00:00:180/ 0.703125;
note /00:00:4996/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:5116/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:5176/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:5236/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:5356/ inst0 Equal440 f1 /00:00:180/ 0.703125;
note /00:00:5416/ inst0 Equal440 a#1 /00:00:60/ 0.703125;
note /00:00:5476/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:5536/ inst0 Equal440 g1 /00:00:180/ 0.703125;
note /00:00:5596/ inst0 Equal440 a#1 /00:00:60/ 0.703125;
note /00:00:5656/ inst0 Equal440 d#2 /00:00:180/ 0.703125;
note /00:00:5716/ inst0 Equal440 g1 /00:00:60/ 0.703125;
note /00:00:5776/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:5836/ inst0 Equal440 d#2 /00:00:60/ 0.703125;
note /00:00:5896/ inst0 Equal440 d2 /00:00:20/ 0.703125;
note /00:00:5916/ inst0 Equal440 d#2 /00:00:20/ 0.703125;
note /00:00:5936/ inst0 Equal440 d2 /00:00:20/ 0.703125;
note /00:00:5956/ inst0 Equal440 c2 /00:00:60/ 0.703125;
note /00:00:6016/ inst0 Equal440 d2 /00:00:60/ 0.703125;
note /00:00:6076/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:6136/ inst0 Equal440 d2 /00:00:180/ 0.703125;
note /00:00:6196/ inst0 Equal440 a#1 /00:00:180/ 0.703125;
note /00:00:6316/ inst0 Equal440 c2 /00:00:180/ 0.703125;
note /00:00:6376/ inst0 Equal440 f2 /00:00:180/ 0.703125;
note /00:00:6436/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:6556/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:6616/ inst0 Equal440 d2 /00:00:180/ 0.703125;
note /00:00:6676/ inst0 Equal440 a#1 /00:00:180/ 0.703125;
note /00:00:6796/ inst0 Equal440 c2 /00:00:180/ 0.703125;
note /00:00:6856/ inst0 Equal440 f2 /00:00:180/ 0.703125;
note /00:00:6916/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:7036/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:7096/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:7156/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:7276/ inst0 Equal440 f1 /00:00:180/ 0.703125;
note /00:00:7336/ inst0 Equal440 a#1 /00:00:60/ 0.703125;
note /00:00:7396/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:7456/ inst0 Equal440 g1 /00:00:180/ 0.703125;
note /00:00:7516/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:7576/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:7636/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:7756/ inst0 Equal440 f1 /00:00:240/ 0.703125;
note /00:00:7816/ inst0 Equal440 a#1 /00:00:60/ 0.703125;
note /00:00:7876/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:7936/ inst0 Equal440 a#1 /00:00:20/ 0.703125;
note /00:00:7956/ inst0 Equal440 a1 /00:00:20/ 0.703125;
note /00:00:7976/ inst0 Equal440 a#1 /00:00:20/ 0.703125;
note /00:00:7996/ inst0 Equal440 d2 /00:00:120/ 0.703125;
note /00:00:8056/ inst0 Equal440 f2 /00:00:240/ 0.703125;
note /00:00:8116/ inst0 Equal440 d2 /00:00:120/ 0.703125;
note /00:00:8236/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:8296/ inst0 Equal440 f2 /00:00:180/ 0.703125;
note /00:00:8356/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:8476/ inst0 Equal440 d2 /00:00:120/ 0.703125;
note /00:00:8536/ inst0 Equal440 f2 /00:00:240/ 0.703125;
note /00:00:8596/ inst0 Equal440 d2 /00:00:120/ 0.703125;
note /00:00:8716/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:8776/ inst0 Equal440 f2 /00:00:240/ 0.703125;
note /00:00:8836/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:8956/ inst0 Equal440 d2 /00:00:120/ 0.703125;
note /00:00:9016/ inst0 Equal440 f2 /00:00:240/ 0.703125;
note /00:00:9076/ inst0 Equal440 d2 /00:00:120/ 0.703125;
note /00:00:9196/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:9256/ inst0 Equal440 f2 /00:00:240/ 0.703125;
note /00:00:9316/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:9436/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:9496/ inst0 Equal440 f2 /00:00:240/ 0.703125;
note /00:00:9556/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:9676/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:9736/ inst0 Equal440 e2 /00:00:120/ 0.703125;
note /00:00:9796/ inst0 Equal440 a#1 /00:00:60/ 0.703125;
note /00:00:9856/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:9856/ inst0 Equal440 f2 /00:00:120/ 0.703125;
note /00:00:9916/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:9976/ inst0 Equal440 c2 /00:00:240/ 0.703125;
note /00:00:10036/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:10156/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:10216/ inst0 Equal440 c2 /00:00:240/ 0.703125;
note /00:00:10276/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:10396/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:10456/ inst0 Equal440 c2 /00:00:240/ 0.703125;
note /00:00:10516/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:10636/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:10696/ inst0 Equal440 c2 /00:00:240/ 0.703125;
note /00:00:10756/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:10876/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:10936/ inst0 Equal440 c2 /00:00:240/ 0.703125;
note /00:00:10996/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:11116/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:11176/ inst0 Equal440 c2 /00:00:240/ 0.703125;
note /00:00:11236/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:11356/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:11416/ inst0 Equal440 d2 /00:00:120/ 0.703125;
note /00:00:11476/ inst0 Equal440 g1 /00:00:60/ 0.703125;
note /00:00:11536/ inst0 Equal440 a1 /00:00:20/ 0.703125;
note /00:00:11536/ inst0 Equal440 d#1 /00:00:180/ 0.703125;
note /00:00:11556/ inst0 Equal440 g1 /00:00:20/ 0.703125;
note /00:00:11576/ inst0 Equal440 a1 /00:00:20/ 0.703125;
note /00:00:11596/ inst0 Equal440 g1 /00:00:20/ 0.703125;
note /00:00:11616/ inst0 Equal440 a1 /00:00:20/ 0.703125;
note /00:00:11636/ inst0 Equal440 g1 /00:00:20/ 0.703125;
note /00:00:11656/ inst0 Equal440 a1 /00:00:20/ 0.703125;
note /00:00:11676/ inst0 Equal440 g1 /00:00:20/ 0.703125;
note /00:00:11696/ inst0 Equal440 a1 /00:00:20/ 0.703125;
note /00:00:11716/ inst0 Equal440 f1 /00:00:30/ 0.703125;
note /00:00:11746/ inst0 Equal440 g1 /00:00:30/ 0.703125;
note /00:00:11776/ inst0 Equal440 f1 /00:00:60/ 0.703125;
note /00:00:11836/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:11896/ inst0 Equal440 c2 /00:00:240/ 0.703125;
note /00:00:11956/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:12076/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:12136/ inst0 Equal440 d#2 /00:00:240/ 0.703125;
note /00:00:12196/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:12316/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:12376/ inst0 Equal440 d2 /00:00:240/ 0.703125;
note /00:00:12436/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:12556/ inst0 Equal440 g#1 /00:00:120/ 0.703125;
note /00:00:12616/ inst0 Equal440 f2 /00:00:240/ 0.703125;
note /00:00:12676/ inst0 Equal440 g#1 /00:00:120/ 0.703125;
note /00:00:12796/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:12856/ inst0 Equal440 d2 /00:00:240/ 0.703125;
note /00:00:12916/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:13036/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:13096/ inst0 Equal440 d#2 /00:00:240/ 0.703125;
note /00:00:13156/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:13276/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:13336/ inst0 Equal440 d#2 /00:00:240/ 0.703125;
note /00:00:13396/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:13516/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:13576/ inst0 Equal440 d2 /00:00:120/ 0.703125;
note /00:00:13636/ inst0 Equal440 a#1 /00:00:60/ 0.703125;
note /00:00:13696/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:13696/ inst0 Equal440 d2 /00:00:15/ 0.703125;
note /00:00:13711/ inst0 Equal440 c2 /00:00:15/ 0.703125;
note /00:00:13726/ inst0 Equal440 a#1 /00:00:15/ 0.703125;
note /00:00:13741/ inst0 Equal440 c2 /00:00:15/ 0.703125;
note /00:00:13756/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:13816/ inst0 Equal440 d2 /00:00:180/ 0.703125;
note /00:00:13876/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:13996/ inst0 Equal440 c2 /00:00:180/ 0.703125;
note /00:00:14056/ inst0 Equal440 f2 /00:00:180/ 0.703125;
note /00:00:14116/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:14236/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:14296/ inst0 Equal440 d2 /00:00:180/ 0.78125;
note /00:00:14356/ inst0 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:14476/ inst0 Equal440 c2 /00:00:180/ 0.78125;
note /00:00:14536/ inst0 Equal440 f2 /00:00:180/ 0.78125;
note /00:00:14596/ inst0 Equal440 a1 /00:00:120/ 0.78125;
note /00:00:14716/ inst0 Equal440 a1 /00:00:120/ 0.78125;
note /00:00:14776/ inst0 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:14836/ inst0 Equal440 g1 /00:00:120/ 0.78125;
note /00:00:14956/ inst0 Equal440 f1 /00:00:180/ 0.78125;
note /00:00:15016/ inst0 Equal440 a#1 /00:00:60/ 0.78125;
note /00:00:15076/ inst0 Equal440 a1 /00:00:60/ 0.78125;
note /00:00:15136/ inst0 Equal440 g1 /00:00:180/ 0.78125;
note /00:00:15196/ inst0 Equal440 a#1 /00:00:60/ 0.78125;
note /00:00:15256/ inst0 Equal440 d#2 /00:00:180/ 0.78125;
note /00:00:15316/ inst0 Equal440 g1 /00:00:60/ 0.78125;
note /00:00:15376/ inst0 Equal440 a1 /00:00:60/ 0.78125;
note /00:00:15436/ inst0 Equal440 d#2 /00:00:60/ 0.78125;
note /00:00:15496/ inst0 Equal440 d2 /00:00:20/ 0.78125;
note /00:00:15516/ inst0 Equal440 d#2 /00:00:20/ 0.78125;
note /00:00:15536/ inst0 Equal440 d2 /00:00:20/ 0.78125;
note /00:00:15556/ inst0 Equal440 c2 /00:00:60/ 0.78125;
note /00:00:15616/ inst0 Equal440 d2 /00:00:60/ 0.78125;
note /00:00:15676/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:15736/ inst0 Equal440 d2 /00:00:180/ 0.78125;
note /00:00:15796/ inst0 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:15856/ inst0 Equal440 c2 /00:00:180/ 0.78125;
note /00:00:15976/ inst0 Equal440 f2 /00:00:180/ 0.78125;
note /00:00:16036/ inst0 Equal440 a1 /00:00:120/ 0.78125;
note /00:00:16156/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:16216/ inst0 Equal440 d2 /00:00:180/ 0.78125;
note /00:00:16276/ inst0 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:16336/ inst0 Equal440 c2 /00:00:180/ 0.78125;
note /00:00:16456/ inst0 Equal440 f2 /00:00:180/ 0.78125;
note /00:00:16516/ inst0 Equal440 a1 /00:00:120/ 0.78125;
note /00:00:16636/ inst0 Equal440 a1 /00:00:120/ 0.78125;
note /00:00:16696/ inst0 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:16756/ inst0 Equal440 g1 /00:00:120/ 0.78125;
note /00:00:16876/ inst0 Equal440 f1 /00:00:180/ 0.78125;
note /00:00:16936/ inst0 Equal440 a#1 /00:00:60/ 0.78125;
note /00:00:16996/ inst0 Equal440 a1 /00:00:60/ 0.78125;
note /00:00:17056/ inst0 Equal440 g1 /00:00:180/ 0.78125;
note /00:00:17116/ inst0 Equal440 a1 /00:00:60/ 0.78125;
note /00:00:17176/ inst0 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:17236/ inst0 Equal440 f1 /00:00:120/ 0.78125;
note /00:00:17356/ inst0 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:17416/ inst0 Equal440 a#1 /00:00:60/ 0.78125;
note /00:00:17476/ inst0 Equal440 a1 /00:00:60/ 0.78125;
note /00:00:17536/ inst0 Equal440 a#1 /00:00:20/ 0.78125;
note /00:00:17556/ inst0 Equal440 a1 /00:00:20/ 0.78125;
note /00:00:17576/ inst0 Equal440 a#1 /00:00:20/ 0.78125;
note /00:00:17596/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:17656/ inst0 Equal440 d2 /00:00:240/ 0.78125;
note /00:00:17716/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:17836/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:17896/ inst0 Equal440 c2 /00:00:240/ 0.78125;
note /00:00:17956/ inst0 Equal440 a1 /00:00:120/ 0.78125;
note /00:00:18076/ inst0 Equal440 a1 /00:00:120/ 0.78125;
note /00:00:18136/ inst0 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:18196/ inst0 Equal440 g1 /00:00:120/ 0.78125;
note /00:00:18316/ inst0 Equal440 g1 /00:00:120/ 0.78125;
note /00:00:18376/ inst0 Equal440 a1 /00:00:120/ 0.78125;
note /00:00:18436/ inst0 Equal440 f#1 /00:00:60/ 0.78125;
note /00:00:18496/ inst0 Equal440 g1 /00:00:60/ 0.78125;
note /00:00:18556/ inst0 Equal440 d#2 /00:00:120/ 0.78125;
note /00:00:18616/ inst0 Equal440 g2 /00:00:240/ 0.78125;
note /00:00:18676/ inst0 Equal440 d#2 /00:00:120/ 0.78125;
note /00:00:18796/ inst0 Equal440 d#2 /00:00:120/ 0.78125;
note /00:00:18856/ inst0 Equal440 f2 /00:00:240/ 0.78125;
note /00:00:18916/ inst0 Equal440 d2 /00:00:120/ 0.78125;
note /00:00:19036/ inst0 Equal440 d2 /00:00:120/ 0.78125;
note /00:00:19096/ inst0 Equal440 d#2 /00:00:240/ 0.78125;
note /00:00:19156/ inst0 Equal440 c2 /00:00:120/ 0.78125;
note /00:00:19276/ inst0 Equal440 c2 /00:00:120/ 0.78125;
note /00:00:19336/ inst0 Equal440 d2 /00:00:120/ 0.78125;
note /00:00:19396/ inst0 Equal440 b1 /00:00:60/ 0.78125;
note /00:00:19456/ inst0 Equal440 c2 /00:00:60/ 0.78125;
note /00:00:19516/ inst0 Equal440 g1 /00:00:120/ 0.78125;
note /00:00:19576/ inst0 Equal440 d#2 /00:00:240/ 0.78125;
note /00:00:19636/ inst0 Equal440 g1 /00:00:120/ 0.78125;
note /00:00:19756/ inst0 Equal440 f1 /00:00:120/ 0.78125;
note /00:00:19816/ inst0 Equal440 d2 /00:00:180/ 0.78125;
note /00:00:19876/ inst0 Equal440 f1 /00:00:120/ 0.78125;
note /00:00:19996/ inst0 Equal440 d2 /00:00:60/ 0.78125;
note /00:00:20056/ inst0 Equal440 d#2 /00:00:60/ 0.78125;
note /00:00:20116/ inst0 Equal440 d2 /00:00:60/ 0.78125;
note /00:00:20176/ inst0 Equal440 c2 /00:00:60/ 0.78125;
note /00:00:20236/ inst0 Equal440 a#1 /00:00:60/ 0.78125;
note /00:00:20296/ inst0 Equal440 a1 /00:00:60/ 0.78125;
note /00:00:20356/ inst0 Equal440 g1 /00:00:60/ 0.78125;
note /00:00:20416/ inst0 Equal440 a#1 /00:00:15/ 0.78125;
note /00:00:20431/ inst0 Equal440 a1 /00:00:15/ 0.78125;
note /00:00:20446/ inst0 Equal440 a#1 /00:00:15/ 0.78125;
note /00:00:20461/ inst0 Equal440 a1 /00:00:15/ 0.78125;
note /00:00:20476/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:20536/ inst0 Equal440 d2 /00:00:180/ 0.78125;
note /00:00:20596/ inst0 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:20716/ inst0 Equal440 c2 /00:00:180/ 0.78125;
note /00:00:20776/ inst0 Equal440 f2 /00:00:180/ 0.78125;
note /00:00:20836/ inst0 Equal440 a1 /00:00:120/ 0.78125;
note /00:00:20956/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:21016/ inst0 Equal440 d2 /00:00:180/ 0.78125;
note /00:00:21076/ inst0 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:21196/ inst0 Equal440 c2 /00:00:180/ 0.78125;
note /00:00:21256/ inst0 Equal440 f2 /00:00:180/ 0.78125;
note /00:00:21316/ inst0 Equal440 a1 /00:00:120/ 0.78125;
note /00:00:21436/ inst0 Equal440 a1 /00:00:120/ 0.78125;
note /00:00:21496/ inst0 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:21556/ inst0 Equal440 g1 /00:00:120/ 0.78125;
note /00:00:21676/ inst0 Equal440 f1 /00:00:180/ 0.78125;
note /00:00:21736/ inst0 Equal440 a#1 /00:00:60/ 0.78125;
note /00:00:21796/ inst0 Equal440 a1 /00:00:60/ 0.78125;
note /00:00:21856/ inst0 Equal440 g1 /00:00:180/ 0.78125;
note /00:00:21916/ inst0 Equal440 a#1 /00:00:60/ 0.78125;
note /00:00:21976/ inst0 Equal440 d#2 /00:00:180/ 0.78125;
note /00:00:22036/ inst0 Equal440 g1 /00:00:60/ 0.78125;
note /00:00:22096/ inst0 Equal440 a1 /00:00:60/ 0.78125;
note /00:00:22156/ inst0 Equal440 d#2 /00:00:60/ 0.78125;
note /00:00:22216/ inst0 Equal440 d2 /00:00:20/ 0.78125;
note /00:00:22236/ inst0 Equal440 d#2 /00:00:20/ 0.78125;
note /00:00:22256/ inst0 Equal440 d2 /00:00:20/ 0.78125;
note /00:00:22276/ inst0 Equal440 c2 /00:00:60/ 0.78125;
note /00:00:22336/ inst0 Equal440 d2 /00:00:60/ 0.78125;
note /00:00:22396/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:22456/ inst0 Equal440 d2 /00:00:180/ 0.78125;
note /00:00:22516/ inst0 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:22576/ inst0 Equal440 c2 /00:00:180/ 0.78125;
note /00:00:22696/ inst0 Equal440 f2 /00:00:180/ 0.78125;
note /00:00:22756/ inst0 Equal440 a1 /00:00:120/ 0.78125;
note /00:00:22876/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:22936/ inst0 Equal440 d2 /00:00:180/ 0.78125;
note /00:00:22996/ inst0 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:23056/ inst0 Equal440 c2 /00:00:180/ 0.78125;
note /00:00:23176/ inst0 Equal440 f2 /00:00:180/ 0.78125;
note /00:00:23236/ inst0 Equal440 a1 /00:00:120/ 0.78125;
note /00:00:23356/ inst0 Equal440 a1 /00:00:120/ 0.78125;
note /00:00:23416/ inst0 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:23476/ inst0 Equal440 g1 /00:00:120/ 0.78125;
note /00:00:23596/ inst0 Equal440 f1 /00:00:180/ 0.78125;
note /00:00:23656/ inst0 Equal440 a#1 /00:00:60/ 0.78125;
note /00:00:23716/ inst0 Equal440 a1 /00:00:60/ 0.78125;
note /00:00:23776/ inst0 Equal440 g1 /00:00:180/ 0.78125;
note /00:00:23836/ inst0 Equal440 a1 /00:00:60/ 0.78125;
note /00:00:23896/ inst0 Equal440 a#1 /00:00:240/ 0.78125;
note /00:00:23956/ inst0 Equal440 f1 /00:00:120/ 0.78125;
note /00:00:24076/ inst0 Equal440 f1 /00:00:240/ 0.78125;
note /00:00:24136/ inst0 Equal440 a#1 /00:00:60/ 0.78125;
note /00:00:24196/ inst0 Equal440 a1 /00:00:60/ 0.78125;
note /00:00:24256/ inst0 Equal440 a#1 /00:00:20/ 0.78125;
note /00:00:24276/ inst0 Equal440 a1 /00:00:20/ 0.78125;
note /00:00:24296/ inst0 Equal440 a#1 /00:00:20/ 0.78125;
note /00:00:24316/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:24376/ inst0 Equal440 d2 /00:00:240/ 0.78125;
note /00:00:24436/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:24556/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:24616/ inst0 Equal440 d#2 /00:00:240/ 0.78125;
note /00:00:24676/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:24796/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:24856/ inst0 Equal440 c2 /00:00:300/ 0.78125;
note /00:00:24916/ inst0 Equal440 g#1 /00:00:120/ 0.78125;
note /00:00:25036/ inst0 Equal440 c2 /00:00:60/ 0.78125;
note /00:00:25096/ inst0 Equal440 f2 /00:00:240/ 0.78125;
note /00:00:25156/ inst0 Equal440 c2 /00:00:120/ 0.78125;
note /00:00:25276/ inst0 Equal440 c2 /00:00:120/ 0.78125;
note /00:00:25336/ inst0 Equal440 d2 /00:00:240/ 0.78125;
note /00:00:25396/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:25516/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:25576/ inst0 Equal440 d#2 /00:00:240/ 0.78125;
note /00:00:25636/ inst0 Equal440 a#1 /00:00:120/ 0.78125;
note /00:00:25756/ inst0 Equal440 c2 /00:00:120/ 0.78125;
note /00:00:25816/ inst0 Equal440 d#2 /00:00:240/ 0.78125;
note /00:00:25876/ inst0 Equal440 c2 /00:00:120/ 0.78125;
note /00:00:25996/ inst0 Equal440 g#1 /00:00:120/ 0.78125;
note /00:00:26056/ inst0 Equal440 d2 /00:00:120/ 0.78125;
note /00:00:26116/ inst0 Equal440 g#1 /00:00:120/ 0.78125;
note /00:00:26176/ inst0 Equal440 d#2 /00:00:300/ 0.703125;
note /00:00:26236/ inst0 Equal440 g#1 /00:00:60/ 0.703125;
note /00:00:26296/ inst0 Equal440 g1 /00:00:180/ 0.703125;
note /00:00:26356/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:26476/ inst0 Equal440 d#2 /00:00:120/ 0.703125;
note /00:00:26536/ inst0 Equal440 g2 /00:00:240/ 0.703125;
note /00:00:26596/ inst0 Equal440 d#2 /00:00:60/ 0.703125;
note /00:00:26716/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:26776/ inst0 Equal440 g2 /00:00:240/ 0.703125;
note /00:00:26836/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:26956/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:27016/ inst0 Equal440 g2 /00:00:240/ 0.703125;
note /00:00:27076/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:27196/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:27256/ inst0 Equal440 g2 /00:00:240/ 0.703125;
note /00:00:27316/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:27436/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:27496/ inst0 Equal440 g2 /00:00:240/ 0.703125;
note /00:00:27556/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:27676/ inst0 Equal440 d2 /00:00:120/ 0.703125;
note /00:00:27736/ inst0 Equal440 f2 /00:00:240/ 0.703125;
note /00:00:27796/ inst0 Equal440 d2 /00:00:120/ 0.703125;
note /00:00:27916/ inst0 Equal440 d2 /00:00:120/ 0.703125;
note /00:00:27976/ inst0 Equal440 f2 /00:00:240/ 0.703125;
note /00:00:28036/ inst0 Equal440 d2 /00:00:120/ 0.703125;
note /00:00:28156/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:28216/ inst0 Equal440 f2 /00:00:240/ 0.703125;
note /00:00:28276/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:28396/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:28456/ inst0 Equal440 f2 /00:00:240/ 0.703125;
note /00:00:28516/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:28636/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:28696/ inst0 Equal440 d#2 /00:00:240/ 0.703125;
note /00:00:28756/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:28876/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:28936/ inst0 Equal440 d#2 /00:00:240/ 0.703125;
note /00:00:28996/ inst0 Equal440 c2 /00:00:120/ 0.703125;
note /00:00:29116/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:29176/ inst0 Equal440 d#2 /00:00:240/ 0.703125;
note /00:00:29236/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:29356/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:29416/ inst0 Equal440 d#2 /00:00:240/ 0.703125;
note /00:00:29476/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:29596/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:29656/ inst0 Equal440 d2 /00:00:240/ 0.703125;
note /00:00:29716/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:29836/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:29896/ inst0 Equal440 d2 /00:00:240/ 0.703125;
note /00:00:29956/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:30076/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:30136/ inst0 Equal440 d2 /00:00:240/ 0.703125;
note /00:00:30196/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:30316/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:30376/ inst0 Equal440 d2 /00:00:240/ 0.703125;
note /00:00:30436/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:30556/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:30616/ inst0 Equal440 c2 /00:00:240/ 0.703125;
note /00:00:30676/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:30796/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:30856/ inst0 Equal440 c2 /00:00:240/ 0.703125;
note /00:00:30916/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:31036/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:31096/ inst0 Equal440 c2 /00:00:240/ 0.703125;
note /00:00:31156/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:31276/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:31336/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:31396/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:31516/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:31576/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:31636/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:31756/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:31816/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:31876/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:31996/ inst0 Equal440 d#1 /00:00:120/ 0.703125;
note /00:00:32056/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:32116/ inst0 Equal440 d#1 /00:00:120/ 0.703125;
note /00:00:32236/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:32296/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:32356/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:32476/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:32536/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:32596/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:32716/ inst0 Equal440 d#1 /00:00:120/ 0.703125;
note /00:00:32776/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:32836/ inst0 Equal440 d#1 /00:00:120/ 0.703125;
note /00:00:32956/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:33016/ inst0 Equal440 a1 /00:00:240/ 0.703125;
note /00:00:33076/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:33196/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:33256/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:33316/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:33436/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:33496/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:33556/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:33676/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:33736/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:33796/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:33916/ inst0 Equal440 d#1 /00:00:120/ 0.703125;
note /00:00:33976/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:34036/ inst0 Equal440 d#1 /00:00:120/ 0.703125;
note /00:00:34156/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:34216/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:34276/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:34396/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:34456/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:34516/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:34636/ inst0 Equal440 f1 /00:00:240/ 0.703125;
note /00:00:34696/ inst0 Equal440 a#1 /00:00:60/ 0.703125;
note /00:00:34756/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:34816/ inst0 Equal440 a#1 /00:00:15/ 0.703125;
note /00:00:34831/ inst0 Equal440 a1 /00:00:15/ 0.703125;
note /00:00:34846/ inst0 Equal440 a#1 /00:00:30/ 0.703125;
note /00:00:34876/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:34936/ inst0 Equal440 d2 /00:00:180/ 0.703125;
note /00:00:34996/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:35116/ inst0 Equal440 c2 /00:00:180/ 0.703125;
note /00:00:35176/ inst0 Equal440 f2 /00:00:180/ 0.703125;
note /00:00:35236/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:35356/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:35416/ inst0 Equal440 d2 /00:00:180/ 0.703125;
note /00:00:35476/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:35596/ inst0 Equal440 c2 /00:00:180/ 0.703125;
note /00:00:35656/ inst0 Equal440 f2 /00:00:180/ 0.703125;
note /00:00:35716/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:35836/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:35896/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:35956/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:36076/ inst0 Equal440 f1 /00:00:180/ 0.703125;
note /00:00:36136/ inst0 Equal440 a#1 /00:00:60/ 0.703125;
note /00:00:36196/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:36256/ inst0 Equal440 g1 /00:00:180/ 0.703125;
note /00:00:36316/ inst0 Equal440 a#1 /00:00:60/ 0.703125;
note /00:00:36376/ inst0 Equal440 d#2 /00:00:180/ 0.703125;
note /00:00:36436/ inst0 Equal440 g1 /00:00:60/ 0.703125;
note /00:00:36496/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:36556/ inst0 Equal440 d#2 /00:00:60/ 0.703125;
note /00:00:36616/ inst0 Equal440 d2 /00:00:15/ 0.703125;
note /00:00:36631/ inst0 Equal440 d#2 /00:00:15/ 0.703125;
note /00:00:36646/ inst0 Equal440 d2 /00:00:30/ 0.703125;
note /00:00:36676/ inst0 Equal440 c2 /00:00:60/ 0.703125;
note /00:00:36736/ inst0 Equal440 d2 /00:00:60/ 0.703125;
note /00:00:36796/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:36856/ inst0 Equal440 d2 /00:00:180/ 0.703125;
note /00:00:36916/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:37036/ inst0 Equal440 c2 /00:00:180/ 0.703125;
note /00:00:37096/ inst0 Equal440 f2 /00:00:180/ 0.703125;
note /00:00:37156/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:37276/ inst0 Equal440 a#1 /00:00:120/ 0.703125;
note /00:00:37336/ inst0 Equal440 d2 /00:00:180/ 0.703125;
note /00:00:37396/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:37516/ inst0 Equal440 c2 /00:00:180/ 0.703125;
note /00:00:37576/ inst0 Equal440 f2 /00:00:180/ 0.703125;
note /00:00:37636/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:37756/ inst0 Equal440 a1 /00:00:120/ 0.703125;
note /00:00:37816/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:37876/ inst0 Equal440 g1 /00:00:120/ 0.703125;
note /00:00:37996/ inst0 Equal440 f1 /00:00:180/ 0.703125;
note /00:00:38056/ inst0 Equal440 a#1 /00:00:60/ 0.703125;
note /00:00:38116/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:38176/ inst0 Equal440 g1 /00:00:180/ 0.703125;
note /00:00:38236/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:38296/ inst0 Equal440 a#1 /00:00:240/ 0.703125;
note /00:00:38356/ inst0 Equal440 f1 /00:00:120/ 0.703125;
note /00:00:38476/ inst0 Equal440 f1 /00:00:180/ 0.703125;
note /00:00:38536/ inst0 Equal440 a#1 /00:00:60/ 0.703125;
note /00:00:38596/ inst0 Equal440 a1 /00:00:60/ 0.703125;
note /00:00:38656/ inst0 Equal440 d1 /00:00:480/ 0.703125;
note /00:00:38656/ inst0 Equal440 f1 /00:00:480/ 0.703125;
note /00:00:38656/ inst0 Equal440 a#1 /00:00:480/ 0.703125;
end at /00:00:39136/;
