--
--	This is an ambient 'intro' section, written using a medieval arabic scale.
--  It needs some more samples, but they would have inflated the archive size!
--

include Equal440.sc
include pulse.spi

-- First, a sample of water...

sample ocean format wav file "/dos/windows/ocean.wav" pitch 440

-- Two playbacks, one loop slightly shorter than the other so they
-- go out of phase.

water_l,water_r:
	stereomix
		{filter {loopsamp &ocean 1 1 440 1 10 90 40} water_freq 20 0.2} waterpan wateramp
		{filter {loopsamp &ocean 1 1 440 1 10 70 40} water_freq 20 0.2} {sub 0 waterpan} wateramp;

-- It starts in the centre and then splits left/right, getting louder.

ramp wateramp from 0 at 0 to 2.0 at 50;
ramp waterpan from 0 at 20 to 1.0 at 30;
event at (0) waterfreq=100,waterpan=0;
ramp waterfreq from 50 at 10 to 1000 at 50;

--
-- Then up comes a pulse beat, played on two instruments,
-- one at each side of the stereo image. These images have
-- echoes which gradually drift into the centre.


rightdelout:
	delay
		{mix
			{instance rightpulse 2 of pulse}
			{filter rightdelout 100 -3 1.0}
		}
		0.3 0.25;

leftdelout:
	delay
		{mix
			{instance leftpulse 2 of pulse}
			{filter leftdelout 100 -3 1.0}
		}
		0.3 0.25;

middelout:
	delay
		{mix
			{div {mix leftdelout rightdelout} 4}
			{mul middelout 1.2}
		}
		0.76 0.75;

pulse_l,pulse_r:
	stereomix
		leftdelout -1 pulseamp
		rightdelout 1 pulseamp
		middelout 0 pulseamp;

ramp pulseamp from 0 at 50 to 3 at 60;
ramp pulseamp from 3 at 100 to 0 at 150;


-- a score

include Arabic.sc
score pulse_score Arabic
{
	c,1;	c,1;	c,1;	c,1;	c,1;	d,1;	c,1;	e,1;	c,1;
	c,1;	e,1;	c,1;	f,1;	c,1;	b,1;	c,1;	c,1;	c,1;
	c,1;	e,1;	c,1;	f,1;	c,1;	b,1;	c,1;	a,1;	b,1;
	c,1;	c,1;	c,1;	c,1;	c,1;	d,1;	c,1;	a,1;	b,1;
}
	
playscore pulse_score leftpulse times 3 at 52.5;
playscore pulse_score rightpulse times 3 at 50;

-- this is a funny little instrument for a bass part
-- which uses a square wave. Do not use this wave unfiltered!


wave square
{
	1
	-1	
}

instrument bassthing durationadd 0.3
{
	-- OK, we have a filtered mix of a square wave and
	-- a sine wave, the square wave at half the instrument
	-- pitch and quieter.

	-- The filter uses a expodecay falling from the frequency of the
	-- note being played to zero, giving a "beeowww" sort of thing.
	-- The filter gain is 6 + a random number which starts at 1
	-- and decays very rapidly, to give a noisy transient. In an
	-- ideal world, with lots of room for samples in the archive,
	-- I would have used one to generate this transient.

	out:
		adsr $noteon $gate 0.01 0.1 0.9 0.3 
			{filter
				{mul
					{mix
						{osc &square {div $freq 2} 0.5}
						{osc &sine $freq 1}
					}
					0.1
				}
				{expodecay $noteon $freq 0.1 1}
				{add {expodecay $noteon $freq 0.02 {random 1}} 6}
				0.1
		};
}

bass_out: instance bass 2 of bassthing;

bass_l,bass_r:
	stereomix
		bass_out -0.7 bass_amp
		{delay bass_out 0.3 0.25} 0.7 {mul bass_amp 0.7};

event at (0) bass_amp=0;
ramp bass_amp from 0 at 10 to 1 at 70;

-- the bass part.

score bass_score Arabic
{
	c,1;
	.,2;
	b2,1,0.5;
	g,1;
	.,2;
	d,1,0.5;
}

playscore bass_score bass times 50 trans -8 at 0;

--

--	The final mixdown
--

CH0: mul 2 {mix pulse_l water_l bass_l};
CH1: mul 2 {mix pulse_r water_r bass_r};

end at 200;
