;;;
;;;
;;; Major mode for sapphire, still has some problems 
;;;
;;;

(require 'font-lock)
(require 'cc-mode)

(defvar sapphire-mode-syntax-table nil
  "Syntax table in use in Sapphire-mode buffers.")

(if sapphire-mode-syntax-table
    ()
  (setq sapphire-mode-syntax-table (make-syntax-table))
  (modify-syntax-entry ?\\ "\\" sapphire-mode-syntax-table)
  (modify-syntax-entry ?\n ">" sapphire-mode-syntax-table)
  (modify-syntax-entry ?\f ">" sapphire-mode-syntax-table)
  (modify-syntax-entry ?- ". 12" sapphire-mode-syntax-table)
  (modify-syntax-entry ?\( "()" sapphire-mode-syntax-table)
  (modify-syntax-entry ?\) ")(" sapphire-mode-syntax-table)
  (modify-syntax-entry ?{ "{}" sapphire-mode-syntax-table)
  (modify-syntax-entry ?} "}{" sapphire-mode-syntax-table)
  (modify-syntax-entry ?\' "\"" sapphire-mode-syntax-table)
  (modify-syntax-entry ?\" "\"" sapphire-mode-syntax-table))

(defvar sapphire-mode-abbrev-table nil
  "Abbrev table in use in Sapphire-mode buffers.")
(define-abbrev-table 'sapphire-mode-abbrev-table ())

;;;###autoload

(defun sapphire-mode ()
  "Major mode for editing SAPPHIRE code.
This is much like C mode except for the syntax of comments.  It uses
the same keymap as C mode and has the same variables for customizing
indentation.  It has its own abbrev table and its own syntax table.
Turning on SAPPHIRE mode calls the value of the variable `sapphire-mode-hook'
with no args, if that value is non-nil."
  (interactive)
  (kill-all-local-variables)
  (setq major-mode 'sapphire-mode)
  (setq mode-name "Sapphire")
  (setq local-abbrev-table sapphire-mode-abbrev-table)
  (set-syntax-table sapphire-mode-syntax-table)
  (make-local-variable 'paragraph-start)
  (setq paragraph-start (concat "^$\\|" page-delimiter))
  (make-local-variable 'paragraph-separate)
  (setq paragraph-separate paragraph-start)
  (make-local-variable 'paragraph-ignore-fill-prefix)
  (setq paragraph-ignore-fill-prefix t)
;  (make-local-variable 'indent-line-function)
;  (setq indent-line-function 'c-indent-line) ; ?
  (make-local-variable 'require-final-newline)
  (setq require-final-newline t)
  (make-local-variable 'comment-start)
  (setq comment-start "--")
  (make-local-variable 'comment-end)
  (setq comment-end "")
  (make-local-variable 'comment-column)
  (setq comment-column 32)
  (make-local-variable 'comment-start-skip)
  (setq comment-start-skip "--+ *")
  (make-local-variable 'comment-indent-function)
  (setq comment-indent-function 'c-comment-indent)
  (run-hooks 'sapphire-mode-hook))


;;
;;
;;

(defconst sapphire-font-lock-keywords (purecopy
 (list
  (list (concat "[ \n\t{]+\\("
				 (mapconcat 'identity
			    '("copy" "add" "mul" "sub" "div" "switch" "osc" "adsr" "delay"
			      "mix" "expodecay" "oneshot" "stereomix" "filter" "samphold"
			      "print" "loopsamp" "random")
			    "\\|")
				 "\\)[ \n\t;(]")
		1 'font-lock-function-name-face)
  '( "\\(--.*\\)" 1 font-lock-comment-face t)
  (list (concat "[ \n\t{]+\\("
				(mapconcat 'identity
				'("include" "instrument" "scale"  "event" "at" "playscore"
				  "score" "end" "speed" "amp" "trans" "wave" "times"
				  "instance" "of" "scale" "playnote" "durationadd"
				  "file" "pitch" "samprate" "from" "to" "ramp" "signature"
				  "tempo" "sample" "format")
				"\\|")
				 "\\)[ \n\t;(]")
		1 'font-lock-keyword-face)
  (list "[%$]*\\([%$][\\,_a-zA-Z0-9]+\\)[ \n\t;(})]" 1 'font-lock-string-face)
  (list "[%$]*\\([\\,_a-zA-Z0-9]+\\):" 1 'font-lock-comment-face)
        ))
  "Additional expressions to highlight in Sapphire mode.")

