%{

/*  Sapphire version 1 - an acoustic compiler
    Copyright (C) 1995 James C Finnis

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static char *rcsid="$Id: lexer.l,v 15.0 1995/11/12 20:56:40 white Exp $";

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "sapphire.h"
#ifndef VMS
#include "parser.tab.h"
#else
#include "parser_tab.h"
#endif

extern void yyraise(char *,...);

int lines=0;
extern int debug;
LIST visited={NULL,NULL};

char currentfile[100];

#define	MAX_INCLUDE_DEPTH	10

YY_BUFFER_STATE include_stack[MAX_INCLUDE_DEPTH];
int include_stack_lines[MAX_INCLUDE_DEPTH];
int include_stack_ptr=0;

#undef YY_INPUT
#define	YY_INPUT(buf,result,max_size)\
{ \
int c=getc(yyin);\
if(c==10)lines++;\
if(debug==2){putchar(c);if(c==10)printf("+%d ",lines);}\
result=(c==EOF)?YY_NULL:(buf[0]=c,1);\
}


void mkinteger(void);
void mkreal(void);
void mkfraction(void);
void mkname(void);
void mktext(void);
extern YYSTYPE yylval;
%}

comment	"--".*
delimiter	[\t\n ]
whitespace	{delimiter}+
uc_letter	[A-Z]
lc_letter	[a-z]
letter	{uc_letter}|{lc_letter}
ascii_char	[^\"]
escaped_char	\\{lc_letter}|\\\"
digit	[0-9]
idsymb	{letter}|{digit}|_|#|-
id	{idsymb}+
natural	{digit}+
posreal	{natural}\.{natural}
negreal	-{natural}\.{natural}
negnat	-{natural}
integer	{natural}|{negnat}
real	{posreal}|{negreal}
fraction	{natural}\/{natural}
text	\"({ascii_char}|{escaped_char})*\"

%x	incl

%%

{comment}	{ }
{whitespace}	{ }
include		{BEGIN(incl);}

event		{ return(EVENT); }
at			{ return(AT); }
from		{ return(FROM); }
to			{ return(TO);}
ramp		{ return(RAMP);}
playscore	{ return(PLAYSCORE); }
instrument	{ return(INSTRUMENT); }
end			{ return(END); }
speed		{ return(SPEED); }
amp			{ return(AMP); }
trans		{ return(TRANS); }
times		{ return(TIMES); }
score		{ return(SCORE); }
wave		{ return(WAVE); }
sample		{ return(SAMPLE); }
channels	{ return(CHANS); }
format		{ return(FORMAT); }
file		{ return(FILETOK); }
pitch		{ return(PITCH); }
samprate	{ return(SAMPRATE); }
instance	{ return(INSTANCE); }
of		{ return(OF); }
scale	{return(SCALE); }
note	{return(NOTE); }
signature { return(SIGNATURE); }
tempo { return(TEMPO); }
durationadd { return(DURADD); }

{real}		{ mkreal(); return(REAL); }
{integer}	{ mkinteger(); return(INTEGER); }
{fraction}	{ mkfraction(); return(REAL); }
\${id}		{ mkname(); return(PARAM); }
\${integer}	{ mkname(); return(PARAM); }
\%{id}		{ mkname(); return(LOCAL); }
\%{integer}	{ mkname(); return(LOCAL); }
{id}		{ mkname(); return(ID); }
{text}		{ mktext(); return(STRING); }

.			{return(*yytext);}

<<EOF>> {
		if(--include_stack_ptr < 0)
		{
			yyterminate();
		}
		else
		{
			yy_switch_to_buffer(include_stack[include_stack_ptr]);
			lines=include_stack_lines[include_stack_ptr];
		}
	}

<incl>[ \t]*
<incl>[^ \t\n]+	{
        int already_visited(char *);
        if(!already_visited(yytext))
		  {
			
			if(include_stack_ptr >= MAX_INCLUDE_DEPTH){
			  yyraise("includes nested too deeply");
			}
			include_stack_lines[include_stack_ptr]=lines;
			lines=0;
			include_stack[include_stack_ptr++]=YY_CURRENT_BUFFER;
			yyin=pathfopen(yytext,"r");
			if(!yyin)yyraise("file not found - %s",yytext);
			strcpy(currentfile,yytext);
			yy_switch_to_buffer(yy_create_buffer(yyin,YY_BUF_SIZE));
          }
		  BEGIN(INITIAL);
	}

%%

/*
 * Support routines
 *
 */

int already_visited(char *fn)
{
  NODE *p;
  for(p=visited.head;p;p=p->next)
	{
	  if(!strcmp((char *)(p->data),fn))
		  return 1;
	}
  insertatend(&visited,"VISITED",strdup(fn));
  return 0;
}

void mkname(void)
{
	strcpy(yylval.str,yytext);
}


void mkinteger(void)
{
	yylval.integer=atol(yytext);
}

void mkreal(void)
{
/*	yylval.real=(float)atof(yytext); */
	sscanf(yytext,"%f",&(yylval.real));
}

void mkfraction(void)
{
	char *p,buf[80];
	float n,d;

	strcpy(buf,yytext);

	/* find the / and assign a null to it */
	for(p=buf;*p!='/';p++);
	*p++='\0';

	d=(float)atol(p);	/* get the denominator */
	if(d==0.0)yyraise("divide by zero in fraction %s",yytext);
	
	n=(float)atol(yytext);
	
	yylval.real=n/d;
}

static void process_text(char *txt)
{
  char *tmp,*p,*q;

#ifndef DOS
  tmp=emalloc(strlen(txt));
#else
  tmp=alloca(strlen(txt));	/* get space for the string */
#endif
  for(q=tmp,p=txt;*p;p++)
	{
	  if(*p=='\\')	/* it's an escaped char! */
		{
		  switch(*++p)
			{
			case 'n':*q++='\n';break;
			case 't':*q++='\t';break;
			case 'v':*q++='\v';break;
			case 'b':*q++='\b';break;
			case 'r':*q++='\r';break;
			case 'f':*q++='\f';break;
			case 'a':*q++='\a';break;
			default: *q++=*p;break;
			}
		}
	  else
		{
		  *q++=*p;
		}
	}
  *q='\0';
  strcpy(txt,tmp);	/* and copy the new version back */
#ifdef DOS
  free(tmp);
#endif
}


/*
		Make a new static string and return an index into the
		static string table
*/

void mktext(void)
{
  char *tmp,*p,*q;
  
  /* strip the quotes! */
  yytext[strlen(yytext)-1]='\0';
  
  /* process for escaped characters (a cheat ;-)*/

  process_text(yytext+1);
  strcpy(yylval.str,yytext+1);
}
