/*  Sapphire version 1 - an acoustic compiler
    Copyright (C) 1995 James C Finnis

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*
   $Id: objects.h,v 15.0 1995/11/12 20:56:40 white Exp $
*/


struct objtable
{
	char *name;
	funcptr func;		/* object function */
	int numins,numouts;
	funcptr initfunc;	/* initialisation function */
	unsigned long flags;
};
extern void f_copy(void);
extern void f_add(void);
extern void f_mul(void);
extern void f_sub(void);
extern void f_div(void);
extern void f_switch(void);	/*input,tval,output if in<tval, output otherwise*/
extern void f_osc(void);	/* freq,amp */
extern void i_osc(void);
extern void i_adsr(void);
extern void f_adsr(void);
extern void f_instaddr(void);
extern void f_delay(void);
extern void i_delay(void);
extern void i_mix(void);
extern void f_mix(void);
extern void i_expodecay(void);
extern void f_expodecay(void);
extern void i_oneshot(void);
extern void f_oneshot(void);
extern void i_loopsamp(void);
extern void f_loopsamp(void);
extern void f_stereomix(void);
extern void f_filter(void);
extern void i_filter(void);
extern void f_samphold(void);
extern void i_samphold(void);
extern void f_print(void);
extern void f_random(void);
/* END_OF_OBJECT_FUNCTIONS */

/* The flags */

#define	OF_HASWAVE	1	/* uses a wave as the first argument */
#define	OF_VARARGS	2	/* don't check number of inputs */
#define OF_HASSAMPL 4	/* uses a sample as the first argument */

struct objtable objtab[]=
{
  /* name,

  	 main function, 

	 number of inputs (or lowest permitted number if
	 OF_VARARGS is set in flags),

	 number of outputs,

	 initialisation function,

	 flags. */

	{"copy",f_copy,1,1,NULL,NULL},
	{"add",f_add,1,1,NULL,OF_VARARGS},
	{"mul",f_mul,1,1,NULL,OF_VARARGS},
	{"sub",f_sub,2,1,NULL,NULL},
	{"div",f_div,2,1,NULL,NULL},
	{"switch",f_switch,4,1,NULL,NULL},
	{"osc",f_osc,2,1,i_osc,OF_HASWAVE},
	{"adsr",f_adsr,7,1,i_adsr,NULL},
	{"delay",f_delay,3,1,i_delay,NULL},
	{"mix",f_mix,1,1,NULL,OF_VARARGS},
	{"expodecay",f_expodecay,4,1,i_expodecay,NULL},
	{"oneshot",f_oneshot,3,1,i_oneshot,OF_HASSAMPL},
	{"stereomix",f_stereomix,3,2,NULL,OF_VARARGS},
	{"filter",f_filter,4,1,i_filter,NULL},
	{"samphold",f_samphold,2,1,i_samphold,NULL},
	{"print",f_print,1,1,NULL,NULL},
	{"loopsamp",f_loopsamp,7,1,i_loopsamp,OF_HASSAMPL},
	{"random",f_random,1,1,NULL,NULL},
	{"instaddr",f_instaddr,NUMINS,1,NULL,OF_VARARGS},

	/* Later objects */

	/* END_OF_OBJECT_TABLE */
};
#define	NUMOBJS	(sizeof(objtab)/sizeof(struct objtable))

