/*  Sapphire version 1 - an acoustic compiler
    Copyright (C) 1995 James C Finnis

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
static char *rcsid="$Id: output.c,v 15.0 1995/11/12 20:56:40 white Exp $";


#include <stdio.h>
#include <string.h>
#include "sapphire.h"
extern float *a_output0,*a_output1;
float mino=0.0,maxo=0.0;
float limit=1.0;

extern struct filedata opfilehdr;

void output_values(void)
{
  float ip0,ip1,maxi,mini,maxamp;
  if(opfilehdr.file)
	{
	  float d[2];
	retry:
	  ip0= *a_output0*limit;
	  ip1= *a_output1*limit;

	  maxi=ip0;mini=ip0;
	  if(ip1>ip0)maxi=ip1;
	  if(ip1<ip0)mini=ip1;

	  maxamp=maxi;
	  if(-mini>maxamp)maxamp= -mini;

	  if(maxamp>=1.0)
		{
		  limit=0.97/(maxamp*limit);
		  goto retry;
		}
	  if(maxi>maxo)maxo=maxi;
	  if(mini<mino)mino=mini;

	  d[0]=ip0;d[1]=ip1;
	  f_writedata(&opfilehdr,&d[0]);
	}
  else
	{
	  printf("%f\t\t\t%f\n",*a_output0,*a_output1);
	}
}



