
/*  A Bison parser, made from parser.y with Bison version GNU Bison version 1.22
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	REAL	258
#define	INTEGER	259
#define	FRACTION	260
#define	ID	261
#define	PARAM	262
#define	LOCAL	263
#define	STRING	264
#define	EVENT	265
#define	AT	266
#define	PLAYSCORE	267
#define	SCORE	268
#define	INSTRUMENT	269
#define	END	270
#define	SPEED	271
#define	AMP	272
#define	TRANS	273
#define	WAVE	274
#define	TIMES	275
#define	INSTANCE	276
#define	OF	277
#define	SCALE	278
#define	NOTE	279
#define	DURADD	280
#define	SAMPLE	281
#define	FORMAT	282
#define	FILETOK	283
#define	PITCH	284
#define	SAMPRATE	285
#define	FROM	286
#define	TO	287
#define	RAMP	288
#define	SIGNATURE	289
#define	TEMPO	290
#define	CHANS	291

#line 1 "parser.y"


/*  Sapphire version 1 - an acoustic compiler
    Copyright (C) 1995 James C Finnis

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static char *rcsid="$Id: parser.y,v 11.1 1995/11/01 22:25:12 white Exp $";

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#define YYDEBUG 1
#ifndef UNIX
#define yyoverflow yyraise
#endif

#define	snark	if(DTEST(DEBUG_PARSE))printf
#include "sapphire.h"
#include "objects.h"

void yyerror(char *);
void yyraise(char *,...);
void warn(char *,...);
void raiseatline(int l,char *,...);

NODE *findeventbefore(unsigned long t);
unsigned long tmpid=0L;
static float zero_float_value=0.0;

struct paramstruct
{
	union
	{
		char var[KEYSIZE];
		float real;
	} d;
	int isvar;
};

NODE *join(NODE *a,NODE *b);
NODE *do_varparam(char *var);
NODE *do_realparam(float r);
NODE *do_instparam(char *id,int voices,char *instr,NODE *params);
NODE *do_objparam(char *name,char *wav,NODE *params);
NODE *do_insobjparam(char *name,char *wav,NODE *params);
struct object *do_object(char *str,char *wav,int no,
	NODE *p,char o[][KEYSIZE]);
void do_instance(char *id,int voices,char *instr,NODE *params,int no,
				 char o[][KEYSIZE]);
void do_insobject(char *str,char *wav,int no,
	NODE *p,char o[][KEYSIZE]);
void do_event(unsigned long t,int isend);
void do_ramp_event(char *varname,float startval,unsigned long starttime,
				   float endval,unsigned long endtime);
void do_instrument(char *str,float duradd);
void do_wave(char *str);
float *getfloat(float f);
void do_sample(char *id,char *format,char *filename,float pitch,float samprate,int chans);
void do_note(char *instance,unsigned long time,char *scalename,
	float amp,unsigned long dur);
struct scoreitem *make_item(void);
unsigned long get_time_real(long mins,long secs,long cents);
unsigned long get_time_bar(long bar,long beat,long frac);
unsigned long get_time_secs(float secs);
static void clearparamlist(NODE *p);

struct insobject
{
  char wave[KEYSIZE];
  int outputct;
  NODE *params;
  char outputs[NUMPARAMS][KEYSIZE];
};

struct instrument
{
	unsigned long duradd;
	NODE *objects;
};

char ioutputarray[NUMPARAMS][KEYSIZE];
int ioutputct=0;

char outputarray[NUMPARAMS][KEYSIZE];
int outputct=0;

float wavearr[MAXWAV];
int wavct=0;

char eventvars[NUMPARAMS][KEYSIZE];
float eventvals[NUMPARAMS];
int eventct=0;

extern int lines;
extern struct object *self;
extern struct filedata opfilehdr;


char scorename[KEYSIZE];
int transopt=DEFTRANSOPT,timesopt=1;
float speedopt=DEFSPEEDOPT,ampopt=DEFAMPOPT;

extern int timesigdenom,timesignum,samprate,tempo;
unsigned long endsample=0;

float amplitude,duration;
char currnotepitches[NUMPARAMS][KEYSIZE];
int npitch=0;
struct scale *thisscale;
LIST waves={NULL,NULL};
LIST samples={NULL,NULL};
LIST objects={NULL,NULL};
LIST events={NULL,NULL};
LIST vars={NULL,NULL};
LIST insobjects={NULL,NULL};
LIST instruments={NULL,NULL};
LIST currentscale={NULL,NULL};int numscaleitems=0;
LIST scales={NULL,NULL};
LIST currentscore={NULL,NULL};
LIST scores={NULL,NULL};
LIST instances={NULL,NULL};
LIST ramps={NULL,NULL};


#line 145 "parser.y"
typedef union
{
  char str[64];
  long integer;
  float real;
  unsigned long tval;
  NODE *node;
} YYSTYPE;

#ifndef YYLTYPE
typedef
  struct yyltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  yyltype;

#define YYLTYPE yyltype
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		242
#define	YYFLAG		-32768
#define	YYNTBASE	49

#define YYTRANSLATE(x) ((unsigned)(x) <= 291 ? yytranslate[x] : 89)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    42,     2,    46,
    47,     2,    45,    40,     2,    44,    48,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    41,    37,     2,
    43,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    38,     2,    39,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
    36
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     4,     7,     9,    11,    13,    15,    17,    19,
    21,    23,    25,    27,    29,    31,    33,    37,    42,    51,
    57,    59,    63,    67,    77,    86,    92,   100,   106,   111,
   123,   129,   137,   142,   146,   154,   161,   170,   181,   194,
   200,   202,   205,   207,   209,   213,   215,   217,   220,   222,
   225,   227,   229,   234,   241,   250,   258,   260,   262,   267,
   274,   283,   291,   293,   297,   301,   303,   306,   312,   320,
   322,   325,   330,   337,   342,   344,   348,   350,   352,   354,
   357,   360,   363,   366,   369,   371,   373,   375,   377,   379,
   383,   389,   391,   399,   405
};

static const short yyrhs[] = {    50,
     0,    51,     0,    50,    51,     0,    59,     0,    60,     0,
    66,     0,    65,     0,    61,     0,    58,     0,    62,     0,
    64,     0,    55,     0,    52,     0,    53,     0,    54,     0,
     1,     0,    35,     4,    37,     0,    34,     4,     4,    37,
     0,    24,    87,     6,     6,    81,    87,    85,    37,     0,
    23,     6,    38,    56,    39,     0,    57,     0,    56,    40,
    57,     0,     6,    41,    85,     0,    69,    41,    21,     6,
    88,    22,     6,    71,    37,     0,    69,    41,    21,     6,
    88,    22,     6,    37,     0,    69,    41,     6,    71,    37,
     0,    69,    41,     6,    42,     6,    71,    37,     0,    10,
    11,    87,    75,    37,     0,    15,    11,    87,    37,     0,
    33,     6,    31,    85,    11,    87,    32,    85,    11,    87,
    37,     0,    14,     6,    38,    77,    39,     0,    14,     6,
    25,    85,    38,    77,    39,     0,    63,    38,    79,    39,
     0,    13,     6,     6,     0,    12,     6,     6,    83,    11,
    87,    37,     0,    12,     6,     6,    11,    87,    37,     0,
    26,     6,    27,     6,    28,     9,    29,    85,     0,    26,
     6,    27,     6,    28,     9,    29,    85,    30,    85,     0,
    26,     6,    27,     6,    28,     9,    29,    85,    30,    85,
    36,     4,     0,    19,     6,    38,    67,    39,     0,    68,
     0,    67,    68,     0,    85,     0,    70,     0,    69,    40,
    70,     0,    86,     0,    73,     0,    71,    73,     0,    74,
     0,    72,    74,     0,    86,     0,    85,     0,    38,     6,
    71,    39,     0,    38,     6,    42,     6,    71,    39,     0,
    38,    21,     6,    88,    22,     6,    71,    39,     0,    38,
    21,     6,    88,    22,     6,    39,     0,    86,     0,    85,
     0,    38,     6,    72,    39,     0,    38,     6,    42,     6,
    72,    39,     0,    38,    21,     6,    88,    22,     6,    72,
    39,     0,    38,    21,     6,    88,    22,     6,    39,     0,
    76,     0,    75,    40,    76,     0,    86,    43,    85,     0,
    78,     0,    77,    78,     0,    69,    41,     6,    72,    37,
     0,    69,    41,     6,    42,     6,    72,    37,     0,    80,
     0,    79,    80,     0,    81,    40,    85,    37,     0,    81,
    40,    85,    40,    85,    37,     0,    44,    40,    85,    37,
     0,    82,     0,    81,    45,    82,     0,     6,     0,    85,
     0,    84,     0,    83,    84,     0,    16,    85,     0,    18,
     4,     0,    17,    85,     0,    20,     4,     0,     4,     0,
     3,     0,     7,     0,     8,     0,     6,     0,    46,    88,
    47,     0,    88,    41,    88,    41,    88,     0,    85,     0,
    48,    88,    41,    88,    41,    88,    48,     0,    48,    88,
    41,    88,    48,     0,     4,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   176,   179,   180,   183,   184,   185,   186,   187,   188,   189,
   190,   191,   192,   193,   194,   195,   201,   207,   213,   221,
   251,   252,   255,   271,   276,   283,   289,   299,   304,   309,
   316,   322,   332,   347,   358,   366,   372,   376,   380,   386,
   393,   394,   397,   404,   405,   408,   417,   418,   424,   425,
   431,   435,   439,   444,   449,   453,   459,   463,   467,   471,
   475,   479,   485,   486,   489,   498,   499,   502,   507,   514,
   515,   518,   524,   530,   538,   539,   542,   548,   556,   557,
   560,   565,   569,   573,   579,   583,   589,   593,   597,   603,
   607,   611,   617,   623,   631
};

static const char * const yytname[] = {   "$","error","$illegal.","REAL","INTEGER",
"FRACTION","ID","PARAM","LOCAL","STRING","EVENT","AT","PLAYSCORE","SCORE","INSTRUMENT",
"END","SPEED","AMP","TRANS","WAVE","TIMES","INSTANCE","OF","SCALE","NOTE","DURADD",
"SAMPLE","FORMAT","FILETOK","PITCH","SAMPRATE","FROM","TO","RAMP","SIGNATURE",
"TEMPO","CHANS","';'","'{'","'}'","','","':'","'&'","'='","'.'","'+'","'('",
"')'","'/'","program","itemlist","item","tempochange","timesigchange","note",
"scale","scalelist","scaleitem","instance","object","event","instrument","score",
"scorehdr","playscore","sample","wave","wavlist","wavitem","outputlist","outputitem",
"paramlist","insparamlist","param","insparam","eventlist","eventspec","objlist",
"insobject","scorelist","scoreitem","notelist","noteitem","playoptlist","playopt",
"real","variable","time","posint",""
};
#endif

static const short yyr1[] = {     0,
    49,    50,    50,    51,    51,    51,    51,    51,    51,    51,
    51,    51,    51,    51,    51,    51,    52,    53,    54,    55,
    56,    56,    57,    58,    58,    59,    59,    60,    60,    60,
    61,    61,    62,    63,    64,    64,    65,    65,    65,    66,
    67,    67,    68,    69,    69,    70,    71,    71,    72,    72,
    73,    73,    73,    73,    73,    73,    74,    74,    74,    74,
    74,    74,    75,    75,    76,    77,    77,    78,    78,    79,
    79,    80,    80,    80,    81,    81,    82,    82,    83,    83,
    84,    84,    84,    84,    85,    85,    86,    86,    86,    87,
    87,    87,    87,    87,    88
};

static const short yyr2[] = {     0,
     1,     1,     2,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     3,     4,     8,     5,
     1,     3,     3,     9,     8,     5,     7,     5,     4,    11,
     5,     7,     4,     3,     7,     6,     8,    10,    12,     5,
     1,     2,     1,     1,     3,     1,     1,     2,     1,     2,
     1,     1,     4,     6,     8,     7,     1,     1,     4,     6,
     8,     7,     1,     3,     3,     1,     2,     5,     7,     1,
     2,     4,     6,     4,     1,     3,     1,     1,     1,     2,
     2,     2,     2,     2,     1,     1,     1,     1,     1,     3,
     5,     1,     7,     5,     1
};

static const short yydefact[] = {     0,
    16,    89,    87,    88,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     2,    13,    14,
    15,    12,     9,     4,     5,     8,    10,     0,    11,     7,
     6,     0,    44,    46,     0,     0,     0,     0,     0,     0,
     0,    86,    85,     0,     0,    92,     0,     0,     0,     0,
     0,     0,     3,     0,     0,     0,     0,     0,    34,     0,
     0,     0,     0,     0,    95,     0,     0,     0,     0,     0,
     0,     0,    17,    85,    77,     0,     0,    70,     0,    75,
    78,    45,     0,     0,     0,    63,     0,     0,     0,     0,
     0,     0,     0,    79,     0,     0,     0,    66,    29,     0,
    41,    43,     0,     0,    21,    90,     0,     0,     0,     0,
     0,    18,     0,    33,    71,     0,     0,     0,     0,     0,
    47,    52,    51,     0,    28,     0,     0,     0,    81,    83,
    82,    84,     0,    80,     0,     0,    31,    67,    40,    42,
     0,    20,     0,     0,     0,     0,     0,     0,     0,     0,
    76,     0,     0,     0,    26,    48,     0,    64,    65,    36,
     0,     0,     0,    23,    22,     0,    94,     0,    91,     0,
     0,    74,    72,     0,     0,     0,     0,     0,     0,    35,
    32,     0,     0,     0,    49,    58,    57,     0,     0,     0,
     0,     0,     0,    53,     0,    27,     0,     0,     0,     0,
    68,    50,    93,    19,    37,     0,    73,     0,     0,    25,
     0,     0,     0,     0,     0,     0,     0,    54,     0,    24,
     0,    59,     0,    69,    38,     0,    56,     0,     0,     0,
     0,    30,    55,    60,     0,    39,    62,     0,    61,     0,
     0,     0
};

static const short yydefgoto[] = {   240,
    17,    18,    19,    20,    21,    22,   104,   105,    23,    24,
    25,    26,    27,    28,    29,    30,    31,   100,   101,    96,
    33,   120,   184,   121,   185,    85,    86,    97,    98,    77,
    78,    79,    80,    93,    94,   122,   123,    47,    48
};

static const short yypact[] = {   438,
-32768,-32768,-32768,-32768,    -4,    10,    30,    32,    58,    70,
    72,    16,    75,    89,    94,    98,   360,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,   -11,-32768,-32768,
-32768,   109,-32768,-32768,    16,   100,   104,    47,    16,    66,
    82,-32768,    73,   119,   119,-32768,   126,    93,   110,   135,
   147,   121,-32768,    36,   133,    20,   133,    76,-32768,   113,
   133,   138,   113,   166,-32768,   129,   141,   172,   119,   174,
   113,   146,-32768,-32768,-32768,   150,    31,-32768,    68,-32768,
-32768,-32768,   139,   180,   -27,-32768,   151,    16,   113,   113,
   192,   193,   137,-32768,   167,   120,    24,-32768,-32768,    21,
-32768,-32768,   163,   131,-32768,-32768,   119,   127,   165,   179,
   197,-32768,   113,-32768,-32768,   113,   127,    23,   204,   185,
-32768,-32768,-32768,   119,-32768,   133,   113,   175,-32768,-32768,
-32768,-32768,    16,-32768,   133,   208,-32768,-32768,-32768,-32768,
   113,-32768,   166,   -26,     8,   119,   207,    16,   181,    12,
-32768,   161,   211,   333,-32768,-32768,   198,-32768,-32768,-32768,
   182,    83,   244,-32768,-32768,   119,-32768,   113,-32768,   196,
   199,-32768,-32768,   113,   224,   256,   119,   343,   227,-32768,
-32768,    27,   228,   384,-32768,-32768,-32768,   188,   200,   113,
   113,   202,   333,-32768,   219,-32768,   393,   250,   236,   411,
-32768,-32768,-32768,-32768,   213,   233,-32768,   262,   239,-32768,
   399,   249,   268,   119,   405,   113,    16,-32768,   277,-32768,
   411,-32768,   245,-32768,   225,   240,-32768,   305,   314,   267,
   274,-32768,-32768,-32768,   320,-32768,-32768,   326,-32768,   279,
   287,-32768
};

static const short yypgoto[] = {-32768,
-32768,   272,-32768,-32768,-32768,-32768,-32768,   148,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,   190,     1,
   238,  -146,  -114,   -99,  -170,-32768,   170,   162,   -95,-32768,
   221,   191,   186,-32768,   209,    11,     0,   -30,   -41
};


#define	YYLAST		473


static const short yytable[] = {    34,
    32,   138,    66,    67,    57,   176,    35,   178,    62,   125,
    42,    43,   126,   202,   166,    36,    34,    32,    42,    43,
   156,   167,    46,    42,    74,    83,    54,   109,   152,     2,
     3,     4,   198,    42,    74,    37,    75,    38,    42,    74,
    84,    75,   202,   153,   202,    46,   208,   199,   173,    46,
   211,   174,   117,    44,    34,    45,    87,   128,   202,   139,
    34,    44,   137,    45,    81,   144,   138,   202,    39,   114,
    95,    60,   228,   102,    76,    40,   156,    41,   156,    76,
    49,   111,   157,   213,    61,   215,    88,    81,     2,     3,
     4,    89,    90,    91,    50,    92,    34,    51,    46,   129,
   130,    52,   161,    63,   169,    58,   229,   116,   156,    59,
   102,   156,   117,   -95,   168,    42,    74,   171,    81,    64,
   238,   181,    65,   149,   188,    87,   150,    81,   156,    42,
    74,    68,    75,    69,    34,   195,    70,   159,     2,     3,
     4,    42,    74,    46,     2,     3,     4,   133,    55,    56,
    72,   164,    89,    90,    91,    46,    92,    73,    46,    55,
   136,    34,   187,    42,    74,    71,     2,     3,     4,   142,
   143,   103,   223,   186,    99,   106,   118,   108,   189,   110,
   119,   107,   112,   187,   192,   124,   226,    42,    74,   113,
     2,     3,     4,   127,   186,   131,   132,   187,   118,   187,
   205,   206,   175,   141,   135,   146,   147,   148,   186,   154,
   186,   160,   187,   163,   187,   170,   177,   172,   180,   179,
   187,   155,   118,   186,   190,   186,   225,    46,   187,   193,
   191,   186,   197,   200,   187,   203,   204,   187,   207,   186,
   209,   214,   216,   217,   219,   186,    42,    74,   186,     2,
     3,     4,    42,    74,   221,     2,     3,     4,    42,    74,
   231,     2,     3,     4,    42,    74,   230,     2,     3,     4,
    42,    74,   235,     2,     3,     4,   232,   236,   241,    42,
    74,   182,     2,     3,     4,   183,   242,   182,    53,   140,
   165,   212,    82,   118,   194,   158,   162,   115,   145,   118,
   218,   134,   151,     0,     0,   182,   222,    42,    74,     0,
     2,     3,     4,     0,   118,   227,    42,    74,     0,     2,
     3,     4,    42,    74,     0,     2,     3,     4,    42,    74,
     0,     2,     3,     4,     0,    42,    74,     0,     2,     3,
     4,     0,   118,   233,     0,    42,    74,     0,     2,     3,
     4,   182,   234,     0,     0,     0,     0,   182,   237,    -1,
     1,     0,     0,   182,   239,     2,     3,     4,     0,     5,
   118,     6,     7,     8,     9,     0,     0,     0,    10,   196,
   118,     0,    11,    12,     0,    13,    42,    74,     0,     2,
     3,     4,    14,    15,    16,    42,    74,     0,     2,     3,
     4,    42,    74,     0,     2,     3,     4,    42,    74,     0,
     2,     3,     4,    42,    74,     0,     2,     3,     4,     0,
   201,   182,     0,     0,     0,     0,     0,     0,     0,   210,
   118,     0,     0,     0,     0,   220,   118,     0,     1,     0,
     0,   224,   182,     2,     3,     4,     0,     5,   182,     6,
     7,     8,     9,     0,     0,     0,    10,     0,     0,     0,
    11,    12,     0,    13,     0,     0,     0,     0,     0,     0,
    14,    15,    16
};

static const short yycheck[] = {     0,
     0,    97,    44,    45,    35,   152,    11,   154,    39,    37,
     3,     4,    40,   184,    41,     6,    17,    17,     3,     4,
   120,    48,    12,     3,     4,     6,    38,    69,     6,     6,
     7,     8,     6,     3,     4,     6,     6,     6,     3,     4,
    21,     6,   213,    21,   215,    35,   193,    21,    37,    39,
   197,    40,    45,    46,    55,    48,    57,    88,   229,    39,
    61,    46,    39,    48,    54,   107,   162,   238,    11,    39,
    60,    25,   219,    63,    44,     6,   176,     6,   178,    44,
     6,    71,   124,   198,    38,   200,    11,    77,     6,     7,
     8,    16,    17,    18,     6,    20,    97,     4,    88,    89,
    90,     4,   133,    38,   146,     6,   221,    40,   208,     6,
   100,   211,    45,    41,   145,     3,     4,   148,   108,    38,
   235,    39,     4,   113,   166,   126,   116,   117,   228,     3,
     4,     6,     6,    41,   135,   177,    27,   127,     6,     7,
     8,     3,     4,   133,     6,     7,     8,    11,    40,    41,
     4,   141,    16,    17,    18,   145,    20,    37,   148,    40,
    41,   162,   163,     3,     4,    31,     6,     7,     8,    39,
    40,     6,   214,   163,    37,    47,    38,     6,   168,     6,
    42,    41,    37,   184,   174,     6,   217,     3,     4,    40,
     6,     7,     8,    43,   184,     4,     4,   198,    38,   200,
   190,   191,    42,    41,    38,    41,    28,    11,   198,     6,
   200,    37,   213,     6,   215,     9,     6,    37,    37,    22,
   221,    37,    38,   213,    29,   215,   216,   217,   229,     6,
    32,   221,     6,     6,   235,    48,    37,   238,    37,   229,
    22,     6,    30,    11,     6,   235,     3,     4,   238,     6,
     7,     8,     3,     4,     6,     6,     7,     8,     3,     4,
    36,     6,     7,     8,     3,     4,    22,     6,     7,     8,
     3,     4,     6,     6,     7,     8,    37,     4,     0,     3,
     4,    38,     6,     7,     8,    42,     0,    38,    17,   100,
   143,    42,    55,    38,    39,   126,   135,    77,   108,    38,
    39,    93,   117,    -1,    -1,    38,    39,     3,     4,    -1,
     6,     7,     8,    -1,    38,    39,     3,     4,    -1,     6,
     7,     8,     3,     4,    -1,     6,     7,     8,     3,     4,
    -1,     6,     7,     8,    -1,     3,     4,    -1,     6,     7,
     8,    -1,    38,    39,    -1,     3,     4,    -1,     6,     7,
     8,    38,    39,    -1,    -1,    -1,    -1,    38,    39,     0,
     1,    -1,    -1,    38,    39,     6,     7,     8,    -1,    10,
    38,    12,    13,    14,    15,    -1,    -1,    -1,    19,    37,
    38,    -1,    23,    24,    -1,    26,     3,     4,    -1,     6,
     7,     8,    33,    34,    35,     3,     4,    -1,     6,     7,
     8,     3,     4,    -1,     6,     7,     8,     3,     4,    -1,
     6,     7,     8,     3,     4,    -1,     6,     7,     8,    -1,
    37,    38,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,
    38,    -1,    -1,    -1,    -1,    37,    38,    -1,     1,    -1,
    -1,    37,    38,     6,     7,     8,    -1,    10,    38,    12,
    13,    14,    15,    -1,    -1,    -1,    19,    -1,    -1,    -1,
    23,    24,    -1,    26,    -1,    -1,    -1,    -1,    -1,    -1,
    33,    34,    35
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/lib/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Bob Corbett and Richard Stallman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#else /* not MSDOS, __TURBOC__, or _AIX */
#ifdef __hpux
#ifdef __cplusplus
extern "C" {
void *alloca (unsigned int);
};
#else /* not __cplusplus */
void *alloca ();
#endif /* not __cplusplus */
#endif /* __hpux */
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#define YYLEX		yylex(&yylval, &yylloc)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
int yyparse (void);
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_bcopy(FROM,TO,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (from, to, count)
     char *from;
     char *to;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (char *from, char *to, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 184 "/usr/lib/bison.simple"
int
yyparse()
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_bcopy ((char *)yyss1, (char *)yyss, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_bcopy ((char *)yyvs1, (char *)yyvs, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_bcopy ((char *)yyls1, (char *)yyls, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 16:
#line 196 "parser.y"
{
				yyraise("expected a declaration");
			;
    break;}
case 17:
#line 202 "parser.y"
{
			  tempo=yyvsp[-1].integer;
			;
    break;}
case 18:
#line 208 "parser.y"
{
			  timesignum=yyvsp[-2].integer;timesigdenom=yyvsp[-1].integer;
			;
    break;}
case 19:
#line 214 "parser.y"
{
				/* time, instance, scale, notes,
				duration, amp */
				do_note(yyvsp[-5].str,yyvsp[-6].tval,yyvsp[-4].str,yyvsp[-1].real,yyvsp[-2].tval);
			;
    break;}
case 20:
#line 222 "parser.y"
{
				NODE *l;
				struct scale *sp;
				int i;

				if(!(find(&scales,yyvsp[-3].str)))
				  {
					
					sp=emalloc(sizeof(struct scale));
					sp->p=emalloc(sizeof(struct scaleitem)*
								  numscaleitems);

				
					for(i=0,l=currentscale.head;l;l=l->next)
					  {
						strcpy(sp->p[i].name,l->key);
						sp->p[i++].pitch=
						  *((float *)(l->data));
					  }
					sp->num=numscaleitems;
				
					insertatend(&scales,yyvsp[-3].str,sp);
					currentscale.head=NULL;
					currentscale.tail=NULL;
					numscaleitems=0;
				  }
			;
    break;}
case 23:
#line 256 "parser.y"
{
				float *pf;
				if(yyvsp[0].real < 0.0)
					yyraise("negative pitch in scale");

				if(find(&currentscale,yyvsp[-2].str))
					yyraise("note %s already defined",yyvsp[-2].str);
					
				pf=emalloc(sizeof(float));
				*pf=yyvsp[0].real;
				insertatend(&currentscale,yyvsp[-2].str,pf);
				numscaleitems++;
			;
    break;}
case 24:
#line 272 "parser.y"
{
				do_instance(yyvsp[-5].str,yyvsp[-4].integer,yyvsp[-2].str,yyvsp[-1].node,outputct,outputarray);
				outputct=0;
			;
    break;}
case 25:
#line 277 "parser.y"
{
				do_instance(yyvsp[-4].str,yyvsp[-3].integer,yyvsp[-1].str,NULL,outputct,outputarray);
				outputct=0;
			;
    break;}
case 26:
#line 284 "parser.y"
{
				do_object(yyvsp[-2].str,NULL,outputct,yyvsp[-1].node,outputarray);
				clearparamlist(yyvsp[-1].node);
				outputct=0;
			;
    break;}
case 27:
#line 290 "parser.y"
{
				struct object *o;
				do_object(yyvsp[-4].str,yyvsp[-2].str,outputct,yyvsp[-1].node,outputarray);
				clearparamlist(yyvsp[-1].node);
				outputct=0;

			;
    break;}
case 28:
#line 300 "parser.y"
{
				do_event(yyvsp[-2].tval,0);
				eventct=0;
			;
    break;}
case 29:
#line 305 "parser.y"
{
				do_event(yyvsp[-1].tval,1);
				eventct=0;
			;
    break;}
case 30:
#line 310 "parser.y"
{
				do_ramp_event(yyvsp[-9].str,yyvsp[-7].real,yyvsp[-5].tval,yyvsp[-3].real,yyvsp[-1].tval);
				eventct=0;
			;
    break;}
case 31:
#line 317 "parser.y"
{
				do_instrument(yyvsp[-3].str,DEFAULT_DURADD);
				insobjects.head=NULL;
				insobjects.tail=NULL;
			;
    break;}
case 32:
#line 323 "parser.y"
{
				/* nasty hack - duration multiplier, for long-release notes. */

				do_instrument(yyvsp[-5].str,yyvsp[-3].real);
				insobjects.head=NULL;
				insobjects.tail=NULL;
			;
    break;}
case 33:
#line 333 "parser.y"
{
				struct score *lp;

				if(find(&scores,scorename))
					yyraise("score %s already defined",scorename);

				lp=emalloc(sizeof(struct score));
				lp->list=currentscore;
				lp->scale=thisscale;
				insertatend(&scores,scorename,lp);
				currentscore.head=currentscore.tail=NULL;
			;
    break;}
case 34:
#line 348 "parser.y"
{
				NODE *n;
				
				strcpy(scorename,yyvsp[-1].str);
				if(!(n=find(&scales,yyvsp[0].str)))
					yyraise("scale %s not found",yyvsp[0].str);
				thisscale=(struct scale *)(n->data);
			;
    break;}
case 35:
#line 359 "parser.y"
{
				do_playscore(yyvsp[-5].str,yyvsp[-4].str,yyvsp[-1].tval,transopt,speedopt,ampopt,timesopt);
				transopt=DEFTRANSOPT;
				speedopt=DEFSPEEDOPT;
				ampopt=DEFAMPOPT;
				timesopt=1;
			;
    break;}
case 36:
#line 367 "parser.y"
{
				do_playscore(yyvsp[-4].str,yyvsp[-3].str,yyvsp[-1].tval,transopt,speedopt,ampopt,timesopt);
			;
    break;}
case 37:
#line 373 "parser.y"
{
				do_sample(yyvsp[-6].str,yyvsp[-4].str,yyvsp[-2].str,yyvsp[0].real,-1.0,-1);
			;
    break;}
case 38:
#line 377 "parser.y"
{
				do_sample(yyvsp[-8].str,yyvsp[-6].str,yyvsp[-4].str,yyvsp[-2].real,yyvsp[0].real,-1);
			;
    break;}
case 39:
#line 381 "parser.y"
{
				do_sample(yyvsp[-10].str,yyvsp[-8].str,yyvsp[-6].str,yyvsp[-4].real,yyvsp[-2].real,yyvsp[0].integer);
			;
    break;}
case 40:
#line 387 "parser.y"
{
				do_wave(yyvsp[-3].str);
				wavct=0;
			;
    break;}
case 43:
#line 398 "parser.y"
{
				if(wavct==MAXWAV)yyraise("wave too big");
				wavearr[wavct++]=yyvsp[0].real;
			;
    break;}
case 46:
#line 409 "parser.y"
{
				if(outputct==NUMPARAMS)
					yyraise("too many outputs");
				strcpy(outputarray[outputct++],yyvsp[0].str);
			;
    break;}
case 48:
#line 419 "parser.y"
{
			  yyval.node=join(yyvsp[-1].node,yyvsp[0].node);
			;
    break;}
case 50:
#line 426 "parser.y"
{
			  yyval.node=join(yyvsp[-1].node,yyvsp[0].node);
			;
    break;}
case 51:
#line 432 "parser.y"
{
			  yyval.node=do_varparam(yyvsp[0].str);
			;
    break;}
case 52:
#line 436 "parser.y"
{
			  yyval.node=do_realparam(yyvsp[0].real);
			;
    break;}
case 53:
#line 440 "parser.y"
{
			  /* an object as a parameter */
			  yyval.node=do_objparam(yyvsp[-2].str,NULL,yyvsp[-1].node);
			;
    break;}
case 54:
#line 445 "parser.y"
{
			  /* an object with wave/sample as a parameter */
			  yyval.node=do_objparam(yyvsp[-4].str,yyvsp[-2].str,yyvsp[-1].node);
			;
    break;}
case 55:
#line 450 "parser.y"
{
			  yyval.node=do_instparam(yyvsp[-5].str,yyvsp[-4].integer,yyvsp[-2].str,yyvsp[-1].node);
			;
    break;}
case 56:
#line 454 "parser.y"
{
			  yyval.node=do_instparam(yyvsp[-4].str,yyvsp[-3].integer,yyvsp[-1].str,NULL);
			;
    break;}
case 57:
#line 460 "parser.y"
{
			  yyval.node=do_varparam(yyvsp[0].str);
			;
    break;}
case 58:
#line 464 "parser.y"
{
			  yyval.node=do_realparam(yyvsp[0].real);
			;
    break;}
case 59:
#line 468 "parser.y"
{
			  yyval.node=do_insobjparam(yyvsp[-2].str,NULL,yyvsp[-1].node);
			;
    break;}
case 60:
#line 472 "parser.y"
{
			  yyval.node=do_insobjparam(yyvsp[-4].str,yyvsp[-2].str,yyvsp[-1].node);
			;
    break;}
case 61:
#line 476 "parser.y"
{
			  yyraise("embedded instances not supported in instruments");
			;
    break;}
case 62:
#line 480 "parser.y"
{
			  yyraise("embedded instances not supported in instruments");
			;
    break;}
case 65:
#line 490 "parser.y"
{
				if(eventct==NUMPARAMS)
					yyraise("too many events");
				eventvals[eventct]=yyvsp[0].real;
				strcpy(eventvars[eventct++],yyvsp[-2].str);
			;
    break;}
case 68:
#line 503 "parser.y"
{
				do_insobject(yyvsp[-2].str,NULL,outputct,yyvsp[-1].node,outputarray);
				outputct=0;
			;
    break;}
case 69:
#line 508 "parser.y"
{
				do_insobject(yyvsp[-4].str,yyvsp[-2].str,outputct,yyvsp[-1].node,outputarray);
				outputct=0;
			;
    break;}
case 72:
#line 519 "parser.y"
{
				duration=yyvsp[-1].real;
				amplitude=1.0;
				insertatend(&currentscore,"SCI",make_item());
			;
    break;}
case 73:
#line 525 "parser.y"
{
				duration=yyvsp[-3].real;
				amplitude=yyvsp[-1].real;
				insertatend(&currentscore,"SCI",make_item());
			  ;
    break;}
case 74:
#line 531 "parser.y"
{
				  duration=yyvsp[-1].real;
				  amplitude=0.0;
				  insertatend(&currentscore,"SCI",make_item());
			  ;
    break;}
case 77:
#line 543 "parser.y"
{
				if(npitch==NUMPARAMS)
					yyraise("too many notes at once!");
				strcpy(currnotepitches[npitch++],yyvsp[0].str);
			;
    break;}
case 78:
#line 549 "parser.y"
{
				if(npitch==NUMPARAMS)
					yyraise("too many notes at once!");
				sprintf(currnotepitches[npitch++],"%f",yyvsp[0].real);
			;
    break;}
case 81:
#line 561 "parser.y"
{
				speedopt=yyvsp[0].real;
				if(speedopt<=0.0)yyraise("invalid speed %f",speedopt);
			;
    break;}
case 82:
#line 566 "parser.y"
{
				transopt=yyvsp[0].integer;
			;
    break;}
case 83:
#line 570 "parser.y"
{
				ampopt=yyvsp[0].real;
			;
    break;}
case 84:
#line 574 "parser.y"
{
			  timesopt=yyvsp[0].integer;
			;
    break;}
case 85:
#line 580 "parser.y"
{
				yyval.real=(float)yyvsp[0].integer;
			;
    break;}
case 86:
#line 584 "parser.y"
{
				yyval.real=yyvsp[0].real;
			;
    break;}
case 87:
#line 590 "parser.y"
{
				strcpy(yyval.str,yyvsp[0].str);
			;
    break;}
case 88:
#line 594 "parser.y"
{
				strcpy(yyval.str,yyvsp[0].str);
			;
    break;}
case 89:
#line 598 "parser.y"
{
				strcpy(yyval.str,yyvsp[0].str);
			;
    break;}
case 90:
#line 604 "parser.y"
{
				yyval.tval=yyvsp[-1].integer;
			;
    break;}
case 91:
#line 608 "parser.y"
{
				yyval.tval=get_time_real(yyvsp[-4].integer,yyvsp[-2].integer,yyvsp[0].integer);
			;
    break;}
case 92:
#line 612 "parser.y"
{
			  float f;
			  f=yyvsp[0].real*(float)samprate;
			  yyval.tval=(unsigned long)f;
			;
    break;}
case 93:
#line 618 "parser.y"
{
				unsigned long q;
				q=get_time_bar(yyvsp[-5].integer,yyvsp[-3].integer,yyvsp[-1].integer);
				yyval.tval=q;
			;
    break;}
case 94:
#line 624 "parser.y"
{
				unsigned long q;
				q=get_time_bar(yyvsp[-3].integer,yyvsp[-1].integer,0);
				yyval.tval=q;
			;
    break;}
case 95:
#line 632 "parser.y"
{
				if(yyvsp[0].integer<0)yyraise("%d must be >=0",yyvsp[0].integer);
				yyval.integer=yyvsp[0].integer;
			;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 465 "/usr/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 637 "parser.y"


int paramcount(NODE *params)
{
  int c=0;
  while(params)
	{
	  params=params->next;
	  c++;
	}
  return c;
}
NODE *join(NODE *a,NODE *b)
{
  register NODE *t;
  if(!a)return b;
  if(!b)return a;
  for(t=a;t->next;t=t->next);
  t->next=b;return a;
}
static void clearparamlist(NODE *p)
{
  NODE *q;
  for(;p;p=q)
  {
	q=p->next;
	free(p->data);
	free(p);
  }
}

/* Add an object to the internal object structure */

struct object *do_object(char *str,char *wav,int no,
	NODE *p,char o[][KEYSIZE])
{
	int i,j,t,np;
	float *last,*var;
	struct object *obj;
	NODE *n,*varnode;
	
	np=paramcount(p);

	for(i=0;i<NUMOBJS;i++)
		if(!strcmp(objtab[i].name,str))break;
	if(i==NUMOBJS)yyraise("unknown object type : %s",str);

	if(!wav)
	  {
		if(objtab[i].flags & OF_HASWAVE)
		  yyraise("object %s requires a wave table",str);
		if(objtab[i].flags & OF_HASSAMPL)
		  yyraise("object %s requires a sample",str);
	  }
		

	if(!(objtab[i].flags & OF_VARARGS))
	{
		if(np<objtab[i].numins)
			yyraise("not enough inputs for %s. %d got, %d required",str,np,
				objtab[i].numins);
		if(np>objtab[i].numins)
			warn("too many inputs for %s. %d required",str,np,
				objtab[i].numins);
	}

	if(no<objtab[i].numouts)
		warn("not enough outputs for %s. %d got,%d required",str,no,
			objtab[i].numins);

	obj=emalloc(sizeof(struct object));
	insertatend(&objects,str,obj);
	obj->func=objtab[i].func;
	obj->type=i;
	
	snark("object %s created, %d ins and %d outs\n",str,
		objtab[i].numins,objtab[i].numouts);
	
	/* got the object, now deal with input plumbing */

	obj->outsused=no;
	obj->numins=objtab[i].numins;
	obj->realins=np;

	t=obj->numins;

	if(np>t)t=np;
	j=0;
	for(n=p;j<t;j++)
	  {
		struct paramstruct *par;
		obj->invars[j]=NULL;
		if(j<np)
		  {
			par=(struct paramstruct *)(n->data);
			if(par->isvar)
			  {
				varnode=mkorfindvar(par->d.var);
				var=&(varnode->f);
				snark(" parameter %s is var at %lx.\n",
					  par->d.var,var);
				obj->inputs[j]=var;
				obj->invars[j]=varnode;
			  }
			else
			  {
				snark(" parameter %f is real.\n",
					  par->d.real);
				obj->inputs[j]=getfloat(par->d.real);
			  }
			n=n->next;
		  }
		else
		  {
			snark(" parameter omitted, setting to 0.\n");
			obj->inputs[j]= &zero_float_value;
		  }
	  }


	for(j=0;j<obj->numins;j++)
	{
		if(!(obj->inputs[j]))
			yyraise("object %s has null input at %d",str,j);
	}
	/* inputs done, now the outputs */

	obj->numouts=objtab[i].numouts;

	for(j=0;j<no;j++)
	{
	  varnode=mkorfindvar(o[j]);
	  var= &(varnode->f);
	  obj->outvars[j]=varnode;
	  if(j<objtab[j].numouts)
		{
		  last=obj->outputs[j]=var;
		  snark(" output %s OK.\n",o[j]);
		}
	  else
		{
		  snark(" extra output.\n");
		  obj->outputs[j]=var;
		}
	}
	obj->lastval=last;

	snark("lastval set\n");
	/* get the wave pointer */

	if(wav)
	  {
		if(objtab[i].flags & OF_HASWAVE)
		  {
			if(!(n=find(&waves,wav)))
			  yyraise("wave table %s not found",wav);
			obj->wave=(float *)(n->data);
			obj->wavsize=n->t;
		  }
		else if(objtab[i].flags & OF_HASSAMPL)
		  {
			struct filedata *hdr;
			if(!(n=find(&samples,wav)))
			  yyraise("sample %s not found",wav);

			hdr=(struct filedata *)(n->data);
			obj->wave=(float *)hdr;
			if(!(obj->wavsize=hdr->numsamples))
			  obj->wavsize=10000;
			
		  }
	  }
   
	snark("wave set\n");
	
	/* and run the initfunc */

	if(objtab[i].initfunc)
	  {
		extern float **selfinpbase,**selfoutbase;
		self=obj;
		selfinpbase=&(self->inputs[0]);
		selfoutbase=&(self->outputs[0]);
		(*(objtab[i].initfunc))();
	  }
	self=NULL;

	snark(" and object made OK.\n");
	return(obj);
}

static NODE *makeevent(unsigned long t)
{
  NODE *n;

  /* get the event list for this time
	 or make a new one */
  
  n=findeventbefore(t);

  if((n==NULL) || (n->t != t))
	{
	  snark("New event list : %ld\n",t);
	  if(n)
		{
		  snark("previous events at %ld\n",n->t);
		}
	  else
		{
		  snark("no event before %ld.\n",t);
		}
	  if(!n)
		{
		  insertatend(&events,"EVENT",NULL);
		  n=events.head;
		}
	  else
		  n=insertafter(&events,n,"EVENT",NULL);

	  n->t=t;
	}
  return n;
}
  
void do_event(unsigned long t,int isend)
{
	NODE *n;
	struct event *e;
	int i;
	
	if(isend)
	{
		endsample=t;
	}
	else
	{
snark("making event at %ld\n",t);
	  n=makeevent(t);
	  for(i=0;i<eventct;i++)
		{
		  e=emalloc(sizeof(struct event));
		  e->type=E_NORMAL;
		  e->next=(struct event *)(n->data);
		  (struct event *)(n->data)=e;
		  e->var=mkorfindvarf(eventvars[i]);
		  e->val=eventvals[i];
		}
	}
}

/* thing that builds events - used in other objects */
void add_event(unsigned long t,char *var,float f)
{
	extern int showevents;
	
	strcpy(eventvars[0],var);
	eventvals[0]=f;
	eventct=1;
	do_event(t,0);eventct=0;
}

void do_ramp_event(char *varname,float startval,unsigned long starttime,
				   float endval,unsigned long endtime)
{
  NODE *n;
  struct event *e;
  n=makeevent(starttime);
  e=emalloc(sizeof(struct event));
  e->next=(struct event *)(n->data);
  (struct event *)(n->data)=e;
  e->type=E_RAMP;
  e->var=mkorfindvarf(varname);
  e->val=startval;
  e->finalval=endval;
  e->endtime=endtime;
}

void *emalloc(unsigned long siz)
{
  static unsigned alloced=0L;
  static FILE *a=NULL;
  char *p;

  if(DTEST(DEBUG_MEM))
	{
	  if(!a)a=fopen("mem.log","w");
	  fprintf(a,"attempting to emalloc %ld - %ld so far\n",siz,alloced);
	}


  if(!(p=malloc(siz)))
	yyraise("memory allocation error for %ld bytes",siz);
  alloced+=siz;

  return(p);
}

void yyerror(char *s)
{
  void show_object(struct object *);
  if(lines>=0)
	printf("fatal error: %s at line %d\n",s,lines);
  else if(self)
	{
	  printf("fatal run-time error \"%s\" in object:\n ",s,self);show_object(self);
	}
  else
	printf("fatal error: %s\n",s);

  exit(10);
}

void yyraise(char *a,...)
{
	va_list argptr;
	char buf[80];

	va_start(argptr,a);
	vsprintf(buf,a,argptr);
	yyerror(buf);
}

void warn(char *a,...)
{
	va_list argptr;
	char buf[80];

	va_start(argptr,a);
	vsprintf(buf,a,argptr);
	printf("warning: %s at line %d\n",buf,lines);
}


/* get sample number from time */
unsigned long get_time_real(long mins,long secs,long hunds)
{
	unsigned long t;

	/* work out number of hundredth */

	t=hunds+secs*100+mins*6000;
	
	/* work out the sample number */

	t *= (samprate/100);
	return(t);
}

/* get time from number of seconds */
unsigned long get_time_secs(float secs)
{
	secs *= samprate;
	return((unsigned long)secs);
}

/* get sample number from bar/beat/64th */
unsigned long get_time_bar(long bar,long beat,long frac)
{
	float sampsperfrac;
	float fracs;
	float bard,beatd,fracd,sr,tmpo;
	unsigned long r;

	bard=(float)bar;
	beatd=(float)beat;
	fracd=(float)frac;
	tmpo=(float)tempo;
	sr=(float)samprate;
	
	/* how many samples in a frac */

	sampsperfrac=(sr*60.0)/tmpo;
	sampsperfrac /= 64.0;
	
	/* how many fracs are we talking about */

	fracs=fracd+(beatd+bard*(float)timesignum)*(float)64.0;

	r=(unsigned long)(fracs*sampsperfrac);

	return r;
}

NODE *insertafter(LIST *l,NODE *node,char *key,void *data)
{
	NODE *new=emalloc(sizeof(NODE));

	if(!node)
	{
		new->next=NULL;
	}
	else
	{
		new->next=node->next;
		node->next=new;
	}

	if(strlen(key)>KEYSIZE)yyraise("key %s too long",key);

	if(node==l->tail) l->tail=new;
	strcpy(new->key,key);
	new->data=data;
	return(new);
}

void clear_list(LIST *l)
{
  NODE *p,*q;

  for(p=l->head;p;p=q)
	{
	  q=p->next;
	  free(p);
	}
  l->head=l->tail=NULL;
}

void removefromlist(LIST *l,NODE *p)
{
  NODE *q;

  if(p==l->head)
	{
	  /* this is the head of the list */
	  if(p==l->tail)
		{
		  /* it's also the end of the list - empty the list */
		  free(p);
		  l->head=l->tail=NULL;
		}
	  else
		{
		  /* it's the head of a list with other nodes */
		  l->head=p->next;
		  free(p);
		}
	}
  else
	{
	  for(q=l->head;q;q=q->next)if(p==q->next)break;
	  if(q)
		{
		  q->next=p->next;
		  if(p==l->tail)l->tail=q;
		  free(p);
		}
	} 
}


void insertatend(LIST *l,char *key,void *data)
{
	insertafter(l,l->tail,key,data);
	if(!(l->head))l->head=l->tail;
}

void insertatbegin(LIST *l,char *key,void *data)
{
	NODE *new=insertafter(l,NULL,key,data);
	if(!(new->next=l->head))l->tail=new;
	l->head=new;
}
		
NODE *find(LIST *l,char *key)
{
	register NODE *p;
	for(p=l->head;p;p=p->next)
		if(!strcmp(p->key,key))return(p);
	return(NULL);
}

/* find or make a variable */
NODE *mkorfindvar(char *key)
{
	NODE *v;
	if(!(v=find(&vars,key)))
	{
		insertatend(&vars,key,NULL);
		v=vars.tail;
		vars.tail->f=0.0;
		snark("  variable %s created.\n",key);
	}
	return(v);
}
float *mkorfindvarf(char *key)
{
  NODE *v;
  v=mkorfindvar(key);
  return &(v->f);
}

/* find the event immediately before or at a given time. Can we
optimise? */
NODE *findeventbefore(unsigned long t)
{
	NODE *p,*q=NULL;
	if(!events.head)
	{
		snark("event list empty\n");
		return(NULL);
	}

	/* quick optimise - check the tail of the list */

	if(events.tail->t <= t)
	{
		return(events.tail);
	}

	/* oh well, do it the hard way. */

	for(p=events.head;p;p=p->next)
	{
		if(p->t > t) /* ok, got it */
		{
			return(q);
		}
		q=p;
	}
	return(events.tail);
}

/* these create parameter nodes. These are
   linked to each other with join(), and are not
   associated with a LIST, like normal nodes */
static NODE *mkparamnode(void)
{
  NODE *new=emalloc(sizeof(NODE));
  struct paramstruct *param=emalloc(sizeof(struct paramstruct));
  new->next=NULL;
  new->data=(void *)param;
  return new;
}

NODE *do_varparam(char *var)
{
  NODE *new;
  struct paramstruct *p;
  new=mkparamnode();
  p=(struct paramstruct *)(new->data);

  p->isvar=1;
  strcpy(p->d.var,var);
  return new;
}
NODE *do_realparam(float r)
{
  NODE *new;
  struct paramstruct *p;
  new=mkparamnode();
  p=(struct paramstruct *)(new->data);

  p->isvar=0;
  p->d.real=r;
  return new;
}

NODE *do_objparam(char *name,char *wav,NODE *params)
{
  char tmp[1][KEYSIZE];

  /* make a temporary variable name */

  sprintf(tmp[0],"_Go%lx",tmpid++);
  
  /* and construct an object to output into that variable */
  
  do_object(name,wav,1,params,&(tmp[0]));
  clearparamlist(params);

  /* return a variable param for the temporary variable */

  return do_varparam(tmp[0]);
}

NODE *do_insobjparam(char *name,char *wav,NODE *params)
{
  char tmp[1][KEYSIZE];

  /* make a temporary instance variable name */

  sprintf(tmp[0],"$_Gi%lx",tmpid++);

  /* and construct an instance object to output into that variable */
  
  do_insobject(name,wav,1,params,&(tmp[0]));
/*  clearparamlist(params); dargle */

  /* return a variable param for the temporary variable */

  return do_varparam(tmp[0]);
}

NODE *do_instparam(char *id,int voices,char *instr,NODE *params)
{
  char tmp[1][KEYSIZE];

  /* make a temporary variable name */

  sprintf(tmp[0],"_Gp%lx",tmpid++);
  
  /* and construct an instance to output into that variable */
  
  do_instance(id,voices,instr,params,1,&(tmp[0]));
  clearparamlist(params);

  /* return a variable param for the temporary variable */

  return do_varparam(tmp[0]);
}


void do_wave(char *str)
{
	float *d;
	
	if(!find(&waves,str))
	  {

		d=emalloc(sizeof(float)*wavct);
		memcpy(d,wavearr,sizeof(float)*wavct);

		insertatend(&waves,str,d);
		waves.tail->t=wavct;
	  }
}

void do_insobject(char *str,char *wav,int no,
				  NODE *params,char o[][KEYSIZE])
{
	int i,j,paramct;
	struct insobject *iobj;

	paramct=paramcount(params);

	for(i=0;i<NUMOBJS;i++)
		if(!strcmp(objtab[i].name,str))break;
	if(i==NUMOBJS)yyraise("unknown object type : %s",str);

	if(!wav)
	  {
		if(objtab[i].flags & OF_HASWAVE)
		  yyraise("object %s requires a wave table",str);
		if(objtab[i].flags & OF_HASSAMPL)
		  yyraise("object %s requires a sample",str);
	  }

	if(!(objtab[i].flags & OF_VARARGS))
	  {
		if(paramct<objtab[i].numins)
		  yyraise("not enough inputs for %s. %d required",str,
				  objtab[i].numins);
		if(paramct>objtab[i].numins)
		  warn("too many inputs for %s. %d required",str,
			   objtab[i].numins);
	  }

	if(no<objtab[i].numouts)
	  warn("not enough outputs for %s. %d required",str,
		   objtab[i].numins);

	iobj=emalloc(sizeof(struct insobject));
	iobj->outputct=no;
	iobj->params=params;

	for(i=0;i<no;i++)strcpy(iobj->outputs[i],o[i]);
	*(iobj->wave)='\0';
	if(wav)strcpy(iobj->wave,wav);

	insertatend(&insobjects,str,iobj);
}

void do_instrument(char *str,float duradd)
{
	extern float get_duration(float);
	
	struct instrument *inst;

	snark("declaring instrument %s\n",str);
	if(find(&instruments,str))
		yyraise("instrument already defined - %s",str);

	inst=emalloc(sizeof(struct instrument));
	inst->objects=insobjects.head;
	inst->duradd=get_duration(duradd);

	insertatend(&instruments,str,inst);
}

char *convertname(char *inst,int voice,char *s)
{ 
	static char buf[80];

	if(!strcmp("out",s))
	{
		sprintf(buf,"@%s.%d",inst,voice);
		return(buf);
	}
	
	switch(*s)
	{
		case '$':	/* this is a local parameter name */
			sprintf(buf,"_%s.%d.%s",inst,voice,s+1);break;
		case '%':	/* this is a local variable name */
			sprintf(buf,"__%s.%d.%s",inst,voice,s+1);break;
		default:strcpy(buf,s);
	}
	return(buf);
}

/* use the get an instance parameter by number in
   build_params */
static NODE *parambynumber(NODE *params,int i)
{
  while(params && i--)
	params=params->next;

  return params;
}

static NODE *copyparam(NODE *param)
{
  NODE *new;
  struct paramstruct *p,*q;

  new=mkparamnode();
  p=(struct paramstruct *)(new->data);
  q=(struct paramstruct *)(param->data);

  *p=*q;
  return new;
}


/* build the parameters for each instance object.
   is the instance id, voice is the voice number,
   io is the instance object, and params is the head
   of the parameter list of the instance. */
   
static NODE *build_params(char *id,int voice,struct insobject *io,NODE *params)
{
	char *s;
	int pn;
	NODE *p;
	NODE *objp=NULL;
	struct paramstruct *param;

	for(p=io->params;p;p=p->next)
	{
	  param=(struct paramstruct *)(p->data);
	  if(param->isvar)
		{
		  s=param->d.var;
		  snark(" parameter is %s is variable\n",s);

		  /* is this a instance parameter? If so, just copy */
		  if(*s=='$' && isdigit(s[1]))
			{
			  NODE *q;
			  pn=atoi(s+1);	/* get parameter number */
			  snark(" is an instance parameter (%d).\n",pn);

			  if(!(q=parambynumber(params,pn)))
				yyraise("instance parameter missing for instance %s",id);

			  objp=join(objp,copyparam(q));

			}
			else	/* no, just convert the name */
			{
			  objp=join(objp,do_varparam(convertname(id,voice,s)));
			  snark(" is internal variable %s\n",s);
			}
		}
		else	/* just a constant */
		{
		  objp=join(objp,do_realparam(param->d.real));
		  snark(" parameter is %f\n",param->d.real);		  
		}
	}
	return objp;
}

void build_outputs(char *id,int voice,struct insobject *io)
{
	int i;
	char *s;
	int pn;
	
	ioutputct=io->outputct;
	
	for(i=0;i<ioutputct;i++)
	{
		s=io->outputs[i];
		strcpy(ioutputarray[i],convertname(id,voice,s));
	}
}


void do_instance(char *id,int voices,char *instr,NODE *params,int no,
				 char o[][KEYSIZE])
{
	struct instrument *inst;
	struct insobject *io;
	struct instance  *ic;
	
	NODE *n,*objp;
	int i;

	if(find(&instances,id))yyraise("instance %s already exists.",id);
	
	if(!(n=find(&instruments,instr)))
		yyraise("instrument not found - %s",instr);

	inst=n->data;
	snark("attempting to create instance %s of %s/%d\n",id,instr,voices);

	/* allocate the instance structure */
	
	ic=emalloc(sizeof(struct instance));
	ic->voices=voices;
	ic->list=emalloc(sizeof(LIST)*ic->voices);
	ic->duradd=inst->duradd;
	
	for(i=0;i<voices;i++)
	{
		ic->list[i].head=NULL;
		ic->list[i].tail=NULL;
	}
	insertatend(&instances,id,ic);
	
	/* make the objects for each voice */
	for(i=0;i<voices;i++)
	{
		snark("creating voice %d for instrument instance %s\n",i,id);
		for(n=inst->objects;n;n=n->next)
		{
			io=(struct insobject *)n->data;

			/* OK, now decode the names and make the object */

			snark("making object for voice %s, %d outputs\n",
				n->key,io->outputct);
			objp=build_params(id,i,io,params);
			build_outputs(id,i,io);
			do_object(n->key,
				*(io->wave)?io->wave:NULL,ioutputct,objp,ioutputarray);
			clearparamlist(objp);
		}
	}

	/* now wire the voices together */

	objp=NULL;

	for(i=0;i<voices;i++)
	{
	  objp=join(objp,do_varparam(convertname(id,i,"out")));
	}
	do_object("instaddr",NULL,no,objp,o);
	clearparamlist(objp);
}

struct scoreitem *make_item(void)
{
	int i;
	struct scoreitem *n;

	n=emalloc(sizeof(struct scoreitem));
	n->duration=duration;
	n->amplitude=amplitude;
	
	for(i=0;i<npitch;i++)
	{
		strcpy(n->pitches[i],currnotepitches[i]);
	}
	n->npitches=npitch;
	npitch=0;
	return(n);
}

void do_note(char *instance,unsigned long time,char *scalename,
	float amp,unsigned long dur)
{
	struct scale *scale;
	NODE *n;
	int i;
	
	if(!(n=find(&scales,scalename)))yyraise("unknown scale %s",scalename);
	scale= (struct scale *)(n->data);
	
	for(i=0;i<npitch;i++)
		add_alloc_note(time,instance,scale,currnotepitches[i],
		amp,dur,0);
	npitch=0;
}

/* set up a sample rather than a wave */
void do_sample(char *id,char *format,char *filename,float pitch,float samprate,int chans)
{
  struct filedata *hdr;
  if(find(&samples,id))
	return;

  hdr=emalloc(sizeof(struct filedata));

  insertatend(&samples,id,hdr);

  strcpy(hdr->format,format);
  hdr->file=NULL;
  hdr->pitch=pitch;

  strcpy(hdr->filename,filename);
  /* attempt to open the file */

  if(f_openfile(hdr,"rb"))
	yyraise("unable to open file %s",filename);

  /* and revise the offsets and stuff */
  if(samprate!=-1.0)
	hdr->samprate=samprate;

  if(chans!=-1)
	hdr->channels = chans;

  /* and read the header */
  f_readheader(hdr);
}


/* this routine is used up there somewhere to allocate floats */

#define FLOATBLOCKSIZE	64

float *getfloat(float f)
{
  static float *buffer=NULL;
  static short floatindex=0;

  if(floatindex==64)floatindex=0;
  if(!floatindex)
	  buffer=(float *)emalloc(sizeof(float)*FLOATBLOCKSIZE);
  buffer[floatindex]=f;
  return buffer+(floatindex++);
}
  
void show_object(struct object *o)
{
  short i;

  for(i=0;i<o->outsused;i++)
	printf("%s ",o->outvars[i]->key);
  
  printf(" :   %s",objtab[o->type].name);
  
  for(i=0;i<o->realins;i++)
	if(o->invars[i])
	  printf(" %s",o->invars[i]->key);
	else
	  printf(" %f",*(o->inputs[i]));
  printf("\n");
}
