/*
    Sapphire version 1 - an acoustic compiler
    Copyright (C) 1995 James C Finnis

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	sapphire general include file

	$Id: sapphire.h,v 15.0 1995/11/12 20:56:40 white Exp $
*/

#define	NUMPARAMS	10
#define	NUMINS		32		/* must be >= NUMPARAMS */
#define	MAXWAV		4000
#define	KEYSIZE		32

#define	DEFTRANSOPT	0
#define	DEFSPEEDOPT	1.0
#define	DEFAMPOPT	1.0

/* these are the values to use if we fdon't override using -C or -B.
   override CACHESIZE with -C, BLOCKSIZE with -B */


#ifdef UNIX
#define CACHESIZE	40
#define BLOCKSIZE	(64000/sizeof(float))
#else
#define CACHESIZE	5
#define BLOCKSIZE	(16000/sizeof(float))
#endif

#define DEFAULT_DURADD 0.2

extern int debug;

/* Linked lists */

typedef struct _node
{
	struct _node *next;
	char key[KEYSIZE];
	float f;
	unsigned long t;
	void *data;
} NODE;

typedef struct
{
	NODE *head,*tail;
} LIST;

extern NODE *insertafter(LIST *l,NODE *node,char *key,void *data);
extern void insertatend(LIST *l,char *key,void *data);
extern void insertatbegin(LIST *l,char *key,void *data);
extern void removefromlist(LIST *l,NODE *p);
extern void clear_list(LIST *l);
extern NODE *find(LIST *l,char *key);

extern NODE *mkorfindvar(char *key);
extern float *mkorfindvarf(char *key);

/* objects */

typedef void (*funcptr)(void);

struct object
{
	funcptr func;

	float *outputs[NUMPARAMS],*lastval;
	float *wave; /* may also be ptr to filedata structure for sample */
	unsigned long wavsize;
	int numouts,outsused,realins;
	
	float *inputs[NUMINS];
	int numins;

	/* these are used for debugging purposes. */
	NODE *invars[NUMINS];
	NODE *outvars[NUMPARAMS];
	int type;

	/* SAMPLE stuff */
	float sampledfreq; /* frequency of sampled note (.e.g. flute playing a440) */
	float samprate;	   /* sampling frequency */
	
	void *private;
};


extern char *convertname(char *inst,int voice,char *s);
extern LIST events,objects,scores,scales,instances,samples,ramps;

/* event types */
#define E_NORMAL 1
#define E_RAMP 2

struct event
{
  short type;
  float *var;
  float val; /* in ramps, means start value */

  /* OK. These should be a union, but I bolted them on later. */

  float finalval; /* ramps only */
  unsigned long endtime; /* ramps only */

  struct event *next;
};


struct scoreitem
{
	char pitches[NUMPARAMS][KEYSIZE];
	float duration,amplitude;
	int npitches;
};

	
extern void add_event(unsigned long t,char *var,float f);

struct scaleitem
{
	float pitch;
	char name[KEYSIZE];
};

struct scale
{
	int num;
	struct scaleitem *p;
};

extern float get_pitch(struct scale *scl,char *nt,int transpose);

struct score
{
	LIST list;
	struct scale *scale;
};

struct instance
{
	int voices;
	unsigned long duradd; /* duration release hack */
	LIST *list;
};

struct ramp
{
  unsigned long samplesleft;
  float finalvalue;
  float add;
  float *var;
};

/* format handling routines */

struct filedata
{
  char filename[256];
  char format[256];
  FILE *file;

  unsigned long numsamples;
  unsigned short channels,samprate,bitspersample;
  unsigned long pos; /* saved fseek position for when file is closed */
  unsigned long ts;  /* timestamp for file cache */
  unsigned long dataoffset; /* offset of data block (private to each format) */
  int slot; /* slot in file cache */

  float pitch; /* used by samples - indicates recorded pitch (not loaded or saved) */
};

int setformat(char *name);
/* returns 0 on success, 1 on fail, 2 for too many files */
int f_openfile(struct filedata *hdr,char *mode);
void f_closefile(struct filedata *hdr);
void f_writeheader(struct filedata *hdr);
void f_writedata(struct filedata *hdr,float *data);
void f_end(struct filedata *hdr);
void f_readheader(struct filedata *hdr);
int f_readdata(struct filedata *data,unsigned long numsamps,unsigned long offset,
			   int channel,float *buffer);
float f_getsample(struct filedata *hdr,unsigned long i);

/* note allocation */

void add_note(unsigned long time,
char *instance,int voice,struct scale *scale,char *note,
float amp,unsigned long dur);
void add_alloc_note(unsigned long time,
char *instance,struct scale *scale,char *note,float amp,
unsigned long dur,int trans);


void do_playscore(char *str,char *inst,unsigned long t,int trans,float
	speed,float amp,int times);


extern int timesigdenom,timesignum,samprate,tempo;
extern FILE *pathfopen(char *,char *);
extern void *emalloc(unsigned long);


/*
   Debugging flags (used with -d option)

*/

#define DTEST(x)	(debug&((x)))

#define DEBUG_SHOWOBJS	1 /* show objects after parse */
#define DEBUG_OBJECTS	2 /* we are debugging object flow */
#define DEBUG_EVENTS	4 /* we are debugging events */
#define DEBUG_SAMPLES	8 /* we are debugging sample file parsing */
#define DEBUG_SCORES	16 /* show scores after parse */
#define DEBUG_MEM		32 /* debug memory allocations */
#define DEBUG_PARSE		64 /* debug parsing and creation */
