/*  Sapphire version 1 - an acoustic compiler
    Copyright (C) 1995 James C Finnis

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static char *rcsid="$Id: scores.c,v 15.0 1995/11/12 20:56:40 white Exp $";

/*
 *	Score handling - used by playscore.
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <stdarg.h>
#include <string.h>
#include <math.h>

#include "sapphire.h"
extern int debug;
#define snark if(DTEST(DEBUG_SCORES))printf

int dodurationadd=1;

void yyraise(char *,...);
void warn(char *,...);

/* get pitch from a note of the form
   [octave]note or just a frequency
   e.g.
   C,
   C2,
   440.0.
  
   The default octave is 3.
*/

float get_pitch(struct scale *scl,char *nt,int transpose)
{
	int octave=3,nitems,i;
	float pitch,octrat;
	NODE *n;
	char note[KEYSIZE];
	struct scaleitem *p;
	char *c;

	strcpy(note,nt);
	
	p=scl->p;nitems=scl->num-1;
	
	/* Just a frequency? */

	if(isdigit(*note))
	{
		sscanf(note,"%f",&pitch);
		return(pitch);
	}
	
	/* we have a trailing number, get the octave number
	from it and strip */
	
	if(isdigit(note[strlen(note)-1]))
	  {
		for(c=note+strlen(note)-1;isdigit(*c)||(*c=='-');c--);c++;
		octave=atoi(c);
		*c=0;
	}

	/* bring the octave number down so that the "middle" octave is 3 */

	octave -=2 ;
	/* find the note */

	for(i=0;i<=nitems;i++)
	{
		if(!strcmp(p[i].name,note))break;
	}

	if(i>nitems)yyraise("can't find note %s",note);

	if(transpose)
	{
		i+=transpose;
		while(i>nitems)
		{
			i-=nitems;
			octave++;
		}
		while(i<0)
		{
			i+=nitems;
			octave--;
		}
	}

	pitch=p[i].pitch;

	octave -=1;

	if(octave)
	{
		octrat=	p[nitems].pitch/p[0].pitch;

		octrat=pow(octrat,(double)octave);
		pitch *= octrat;

		return(pitch);
	}
	return(pitch);
}

/* a note is indicated by the following events:
	time t:			noteon=1,gate=1,amp=amp,freq=pitch
	time t+1:		noteon=0
	time t+dur-1:	gate=0
*/

	
void add_note(unsigned long time,
	char *instance,int voice,struct scale *scale,char *note,float amp,
	unsigned long dur)
{
	add_event(time,convertname(instance,voice,"$noteon"),1.0);
	add_event(time,convertname(instance,voice,"$gate"),1.0);
	add_event(time,convertname(instance,voice,"$freq"),
		get_pitch(scale,note,0));
	add_event(time,convertname(instance,voice,"$amp"),amp);

	add_event(time+1,convertname(instance,voice,"$noteon"),0.0);

	add_event(time+dur-1,convertname(instance,voice,"$gate"),0.0);
}

/* voice allocation stuff. */

/* Is the voice allocated? */

static int is_alloc(LIST *h,unsigned long start,unsigned long end)
{
	unsigned long *p,st,ed;
	NODE *l;
	
	for(l=h->head;l;l=l->next)
	{
		p=(unsigned long)(l->data);
		st=p[0];ed=p[1];
		if((st<end)&&(ed>=end))return(1);
		if((st<=start)&&(ed>start))return(1);
	}
	return(0);
}

/* returns voice number *or* -1 for failure */
static int alloc_voice(struct instance *ic,unsigned long start,
unsigned long end)
{
	LIST *lists;
	unsigned long *p;
	int i;
	
	lists=ic->list;

	for(i=0;i<ic->voices;i++)
	{
		if(!is_alloc(lists+i,start,end))break;
	}
	if(i==ic->voices)return(-1);
	
	p=emalloc(sizeof(unsigned long)*2);
	p[0]=start;p[1]=end;
	insertatend(lists+i,"ALLOC",p);
	return(i);
}

/* add a note, allocating a voice for it. */

void add_alloc_note(unsigned long time,
	char *instance,struct scale *scale,char *note,float amp,
	unsigned long dur,int trans)
{
	int voice;
	struct instance *ic;
	NODE *n;
	float pitch;
	float p,q;
	if(!(n=find(&instances,instance)))
		yyraise("can't find instance %s",instance);
	
	ic=(struct instance *)(n->data);

	pitch=get_pitch(scale,note,trans);

	if(pitch<1.0)return;	/* <1 is a rest */
	
	/* allocate the voice. Note that we allocate "time+duradd" where
	   duradd was the time the programmer specified for decay */
	if((voice=alloc_voice(ic,time,time+(dodurationadd?dur+ic->duradd:dur)))<0)
	{
		warn("not enough voices for %s",instance);
		return;
	}

	add_event(time,convertname(instance,voice,"$noteon"),1.0);
	add_event(time,convertname(instance,voice,"$gate"),1.0);
	add_event(time,convertname(instance,voice,"$freq"),pitch);
	add_event(time,convertname(instance,voice,"$amp"),amp);

	add_event(time+1,convertname(instance,voice,"$noteon"),0.0);

	add_event(time+dur-1,convertname(instance,voice,"$gate"),0.0);
}

/* duration in samples from duration in beats */

float get_duration(float d)
{
	float sampsperbeat,sr,t;
	
	sr=(float)samprate;
	t=(float)tempo;

	sampsperbeat=(sr*(float)60.0)/t;

	d*=sampsperbeat;
	return d;
}

	
/* the gubbins */
void do_playscore(char *str,char *inst,unsigned long t,int trans,float
speed,float amp,int times)
{
	NODE *n,*start;
	struct score *sc;
	struct scoreitem *s;
	float dur=0.0,tf,tstart;

	int i,tm;

	if(!(n=find(&scores,str)))yyraise("can't find score %s",str);
	sc=(struct score *)(n->data);

	if(!find(&instances,inst))yyraise("can't find instance %s",inst);
	
	tf=tstart=(float)t;
	start=sc->list.head;

	for(tm=0;tm<times;tm++)
	  {
		for(n=start;n;n=n->next)
		  {
			s=(struct scoreitem *)(n->data);
			
			if(s->npitches)
			  {
				for(i=0;i<s->npitches;i++)
				  {
					add_alloc_note((unsigned long)tf,inst,sc->scale,
								   s->pitches[i],s->amplitude*amp,
								   get_duration(s->duration),trans);
				  }
			  }
			dur+=s->duration/speed;
			tf=tstart+get_duration(dur);
		  }
	  }
  }

		
