/****************************************************************************
 * NCSA Mosaic for the X Window System                                      *
 * Software Development Group                                               *
 * National Center for Supercomputing Applications                          *
 * University of Illinois at Urbana-Champaign                               *
 * 605 E. Springfield, Champaign IL 61820                                   *
 * mosaic@ncsa.uiuc.edu                                                     *
 *                                                                          *
 * Copyright (C) 1993, Board of Trustees of the University of Illinois      *
 *                                                                          *
 * NCSA Mosaic software, both binary and source (hereafter, Software) is    *
 * copyrighted by The Board of Trustees of the University of Illinois       *
 * (UI), and ownership remains with the UI.                                 *
 *                                                                          *
 * The UI grants you (hereafter, Licensee) a license to use the Software    *
 * for academic, research and internal business purposes only, without a    *
 * fee.  Licensee may distribute the binary and source code (if released)   *
 * to third parties provided that the copyright notice and this statement   *
 * appears on all copies and that no charge is associated with such         *
 * copies.                                                                  *
 *                                                                          *
 * Licensee may make derivative works.  However, if Licensee distributes    *
 * any derivative work based on or derived from the Software, then          *
 * Licensee will (1) notify NCSA regarding its distribution of the          *
 * derivative work, and (2) clearly notify users that such derivative       *
 * work is a modified version and not the original NCSA Mosaic              *
 * distributed by the UI.                                                   *
 *                                                                          *
 * Any Licensee wishing to make commercial use of the Software should       *
 * contact the UI, c/o NCSA, to negotiate an appropriate license for such   *
 * commercial use.  Commercial use includes (1) integration of all or       *
 * part of the source code into a product for sale or license by or on      *
 * behalf of Licensee to third parties, or (2) distribution of the binary   *
 * code or source code to third parties that need it to utilize a           *
 * commercial product sold or licensed by or on behalf of Licensee.         *
 *                                                                          *
 * UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR   *
 * ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED          *
 * WARRANTY.  THE UI SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY THE    *
 * USERS OF THIS SOFTWARE.                                                  *
 *                                                                          *
 * By using or copying this Software, Licensee agrees to abide by the       *
 * copyright law and all other applicable laws of the U.S. including, but   *
 * not limited to, export control laws, and the terms of this license.      *
 * UI shall have the right to terminate this license immediately by         *
 * written notice upon Licensee's breach of, or non-compliance with, any    *
 * of its terms.  Licensee may be held legally responsible for any          *
 * copyright infringement that is caused or encouraged by Licensee's        *
 * failure to abide by the terms of this license.                           *
 *                                                                          *
 * Comments and questions are welcome and can be sent to                    *
 * mosaic-x@ncsa.uiuc.edu.                                                  *
 ****************************************************************************/

#ifndef HTMLP_H
#define HTMLP_H

#include "../libhtmlw/HTML.h"

#include <Xm/XmP.h>
# ifdef MOTIF1_2
#  include <Xm/ManagerP.h>
# endif /* MOTIF1_2 */

#include <X11/Xatom.h>
#ifndef VMS
#include <X11/Xmu/Atoms.h>
#else
#include <XMU/Atoms.h>
#endif

/*  New fields for the HTML widget class */
typedef struct _HTMLClassPart {
	int none;		/* No extra HTML class stuff */
} HTMLClassPart;

typedef struct _HTMLClassRec
{
	CoreClassPart		core_class;
	CompositeClassPart	composite_class;
	ConstraintClassPart	constraint_class;
	XmManagerClassPart	manager_class;
	HTMLClassPart		html_class;
} HTMLClassRec;


extern HTMLClassRec htmlClassRec;

#define IMAGE_DEFAULT_BORDER	2
#define DEF_IMAGE_HSPACE	0
#define DEF_IMAGE_VSPACE	0
#define D_INDENT_SPACES		40

#define D_NONE          0
#define D_TITLE         1
#define D_TEXT          2
#define D_OLIST         3
#define D_ULIST         4
#define D_DESC_LIST_START 5

/*
 * To allow arbitrary nesting of lists
 */
typedef struct dtype_rec {
        int type;               /* D_NONE, D_TITLE, D_TEXT, D_OLIST, D_ULIST */
        int count;
        int compact;
	int save_left_margin;
	int indent_margin;
	int save_cur_line_width;
	int cur_line_width;
	char style;		/* 1, A, a, I, i */
        struct dtype_rec *next;

} DescRec;
 
typedef enum {
	TIMES,
	HELVETICA,
	CENTURY,
	LUCIDA
} CurFontFamily;

typedef enum {
	FONT,
	ITALIC_FONT,
	BOLD_FONT,
	BOLDITALIC_FONT,
	FIXED_FONT,
	FIXEDBOLD_FONT,
	FIXEDITALIC_FONT,
	HEADER1_FONT,
	HEADER2_FONT,
	HEADER3_FONT,
	HEADER4_FONT,
	HEADER5_FONT,
	HEADER6_FONT,
	ADDRESS_FONT,
	PLAIN_FONT,
	PLAINBOLD_FONT,
	PLAINITALIC_FONT,
	LISTING_FONT,
	SUPSUB_FONT
} CurFontType;

/*
 * To allow arbitrary nesting of font changes
 */
typedef struct font_rec {
        XFontStruct *font;
	int size;
	CurFontType type;
	CurFontFamily family;
	unsigned long color;
	Boolean color_ch;
        struct font_rec *next;
} FontRec;

/*
 * To allow arbitrary nesting of alignment changes
 */
typedef struct align_rec {
        DivAlignType align;
        struct align_rec *next;
} AlignRec;

/* A struc to maintain current HTML context */
typedef struct _PhotoComposeContext {
	int width_of_viewable_part;	/* never change during computation */
	int right_margin;
	int left_margin;
	int eoffsetx;	      /* The element offset relative to View */
	int cur_line_width;   /* WidthOfViewablePart-right_margin-left_margin */
	int x;		      /* x, y relative to View, Where to put next */
	int y;		      /* Element */

	/* When cw_only we never create Element but compute 3 values:
	 *    computed_min_x, computed_max_x, computed_maxmin_x
	 * This part is for first pass of table to compute cell sizes
	 */
	Boolean cw_only;	/* compute width only if True */
	int computed_min_x;	/* the minimum cell width for this line */
	int computed_maxmin_x;	/* the max of all min_x in cell */
	int computed_max_x;	/* the maximum cell width */

	int margin_height;
	int cur_baseline;	/* all objects in a line must have the same */
				/* baseline.  If baseline changes then adjust */
				/* y and cur_line_height */
				/* and the y value in each element of line */
	int cur_line_height;
	int element_id;    	/* to get unique number */
	int is_bol;      	/* we are at begin of line if 1 */
				/* we are right after list bullet if 2 */
	char have_space_after;  /* remember if a word has a space after */
	XFontStruct	*cur_font;
	int		cur_font_size;
	int		cur_font_base;
	CurFontFamily	cur_font_family;
	CurFontType	cur_font_type;
	MarkInfo	*anchor_tag_ptr;     /* we are in anchor ?? */
	int max_width_return;	/* we compute the MaxWidth of hyper text to */
				/* adjust scrollbar */
				/* initial value is WidthOfViewablePart */
	int	pf_lf_state; 	/* state for linefeed */
	int	preformat;	/* is in <PRE> ? */
	DivAlignType	div;	/* Current horizontal alignment */
	AlignType	valign;	/* Current vertical alignment */
	unsigned long	fg;	/* the current foreground */
	unsigned long	bg;	/* the current background */
	unsigned long	cur_font_color;
	int		underline_number;
	int		in_underlined;
	Boolean		dashed_underlines;
	FormInfo	*cur_form;	/* the current form */
	Boolean		in_form;	/* is in form? */
	int		widget_id;
	int		aprog_id;
	int		applet_id;
	int		superscript;
	int		subscript;
	int		indent_level;
	char		*text_area_buf;	 /* buffer for Form TextArea */
	int		ignore;		 /* ignore some tags when formating */
	SelectInfo	*current_select; /* SELECT in FORM */
	Boolean		in_select;	 /* is a select? */
	int		is_index;
	int		Width;
	Boolean		Strikeout;
	DescRec		DescType;
	int		InDocHead;
	char		*TitleText;
	FontRec		FontBase;
	FontRec		*FontStack;
	Boolean		in_table;	/* are we in a table? */
	Boolean		in_paragraph;   /* are we in a paragraph? */
	Boolean		in_script;	/* are we in a script? */
	Boolean		in_style;	/* are we in a style sheet? */
	struct ele_rec	*last_progressive_ele;	/* last element displayed progressively */
	Boolean		anchor_start;	/* Mark start of anchor in text */
	Boolean		at_top;		/* are we at top of a page or cell? */
	Boolean		in_anchor;	/* are we in an anchor? */
	Boolean		float_left;	/* 1 is image, 2 is table */
	int		float_lmarg;
	int		float_ly;
	Boolean		float_right;
	int		float_rmarg;
	int		float_ry;
	int		float_table_extra; /* size of extra space after table */
	Boolean		ignore_float;
	Boolean		nobr;		/* are we in <NOBR>? */
	int		nobr_x;		/* starting x of <NOBR> */
	int		blockquote;	/* <BLOCKQUOTE> counter */
	int		frameset;	/* <FRAMESET> counter */
	int		noframes;	/* <NOFRAMES> counter */
} PhotoComposeContext;

/* New fields for the HTML widget */
typedef struct _HTMLPart {
	/* Resources */
	Dimension		margin_width;
	Dimension		margin_height;

	Widget			view;
	Widget			hbar;
	Widget			vbar;
	Widget                  frame;

	XtCallbackList		anchor_callback;
	XtCallbackList		base_callback;
	XtCallbackList		form_callback;

	char			*title;
	char			*raw_text;
	char			*header_text;
	char			*footer_text;
/*
 * Without motif we have to define our own foreground resource
 * instead of using the manager's
 */
	Pixel			anchor_fg;
	Pixel			visitedAnchor_fg;
	Pixel			activeAnchor_fg;
	Pixel			activeAnchor_bg;

        Boolean                 body_colors;
        Boolean                 body_images;
        Boolean                 font_colors;
	Boolean			font_sizes;
	CurFontFamily		font_family;
	int			font_base;

	int			max_colors_in_image;
	int			bg_image;
	Pixmap			bgmap_SAVE;
	Pixmap			bgclip_SAVE;
        int                     bg_height;
        int                     bg_width; 

        Pixel                   foreground_SAVE;
	Pixel			anchor_fg_SAVE;
	Pixel			visitedAnchor_fg_SAVE;
	Pixel			activeAnchor_fg_SAVE;
	Pixel			activeAnchor_bg_SAVE;
	Pixel			top_color_SAVE;
	Pixel			bottom_color_SAVE;    
        Pixel                   background_SAVE;
    
	int			num_anchor_underlines;
	int			num_visitedAnchor_underlines;
	Boolean			dashed_anchor_lines;
	Boolean			dashed_visitedAnchor_lines;
	Boolean			fancy_selections;
	Boolean			is_index;
	int			percent_vert_space;

	XFontStruct		*font;
	XFontStruct		*italic_font;
	XFontStruct		*bold_font;
	XFontStruct		*bolditalic_font;
	XFontStruct		*meter_font;
	XFontStruct		*toolbar_font;
	XFontStruct		*fixed_font;
	XFontStruct		*fixedbold_font;
	XFontStruct		*fixeditalic_font;
	XFontStruct		*header1_font;
	XFontStruct		*header2_font;
	XFontStruct		*header3_font;
	XFontStruct		*header4_font;
	XFontStruct		*header5_font;
	XFontStruct		*header6_font;
	XFontStruct		*address_font;
	XFontStruct		*plain_font;
	XFontStruct		*plainbold_font;
	XFontStruct		*plainitalic_font;
	XFontStruct		*listing_font;
        XFontStruct             *supsub_font;
	Boolean			changing_font;

        XtPointer		previously_visited_test;
	XtCallbackList		image_callback;
	Boolean			delay_image_loads;
	XtCallbackList		get_url_data_cb;
        XtCallbackList		pointer_motion_callback;

	/* PRIVATE */
	Dimension		max_pre_width;
	Dimension		view_width;
	Dimension		view_height;
	int			doc_width;
	int			doc_height;
	int			scroll_x;
	int			scroll_y;
	Boolean			use_hbar;
	Boolean			use_vbar;
	struct ele_rec		*formatted_elements;
	struct ele_rec		*select_start;
	struct ele_rec		*select_end;
	int			sel_start_pos;
	int			sel_end_pos;
	struct ele_rec		*new_start;
	struct ele_rec		*new_end;
	int			new_start_pos;
	int			new_end_pos;
	struct ele_rec		*active_anchor;
	GC			drawGC;
	int			press_x;
	int			press_y;
	Time			but_press_time;
	Time			selection_time;
	MarkInfo		*html_objects;
	MarkInfo		*html_header_objects;
	MarkInfo		*html_footer_objects;
	WidgetInfo		*widget_list;
	FormInfo		*form_list;
	MapInfo                 *map_list;
        Boolean 		drawing;
        unsigned int		draw_count;
        Boolean                 focus_follows_mouse;
        struct ele_rec          *cached_tracked_ele;
	struct ele_rec		*last_formatted_elem;
	struct ele_rec		*cur_elem_to_format;
	MapInfo			*cur_map;	/* usemap being parsed */
	AreaInfo		*cur_area;	/* usemap area last parsed */
	Boolean			cursor_in_anchor;
	int			underline_yoffset;
	Boolean			table_cell_has_bg;
	Boolean			image_animation;
	int			redisplay_x;
	int			redisplay_y;
	int			redisplay_width;
	int			redisplay_height;
        unsigned int		refresh_count;
} HTMLPart;


typedef struct _HTMLRec {
	CorePart		core;
	CompositePart		composite;
	ConstraintPart		constraint;
	XmManagerPart		manager;
	HTMLPart		html;
} HTMLRec;

/* To reduce the number of MOTIF/ATHENA ifdefs around the code
 * we use some generalized constants x */
#   define XxNx      XmNx
#   define XxNy      XmNy
#   define XxNwidth  XmNwidth
#   define XxNheight XmNheight
#   define XxNset    XmNset
#   define XxNvalue  XmNvalue

extern void ReformatWindow(HTMLWidget hw, Boolean save_obj);
extern int FormatAll(HTMLWidget hw, int *Fwidth, Boolean save_obj);
extern struct ele_rec *RefreshElement(HTMLWidget hw, struct ele_rec *eptr);
extern void HtmlGetImage (HTMLWidget w, ImageInfo *picd,
				PhotoComposeContext *pcc, int force_load);
extern MarkInfo *HTMLParse(HTMLWidget hw, char *str);
extern void RefreshURL(XtPointer cld, XtIntervalId *id);

extern void _FreeAprogStruct(AprogInfo *aps);
extern void _FreeAppletStruct(AppletInfo *ats);
extern void _FreeTableStruct(TableInfo *t);

#endif /* HTMLP_H */
