/****************************************************************************
 * NCSA Mosaic for the X Window System                                      *
 * Software Development Group                                               *
 * National Center for Supercomputing Applications                          *
 * University of Illinois at Urbana-Champaign                               *
 * 605 E. Springfield, Champaign IL 61820                                   *
 * mosaic@ncsa.uiuc.edu                                                     *
 *                                                                          *
 * Copyright (C) 1993, Board of Trustees of the University of Illinois      *
 *                                                                          *
 * NCSA Mosaic software, both binary and source (hereafter, Software) is    *
 * copyrighted by The Board of Trustees of the University of Illinois       *
 * (UI), and ownership remains with the UI.                                 *
 *                                                                          *
 * The UI grants you (hereafter, Licensee) a license to use the Software    *
 * for academic, research and internal business purposes only, without a    *
 * fee.  Licensee may distribute the binary and source code (if released)   *
 * to third parties provided that the copyright notice and this statement   *
 * appears on all copies and that no charge is associated with such         *
 * copies.                                                                  *
 *                                                                          *
 * Licensee may make derivative works.  However, if Licensee distributes    *
 * any derivative work based on or derived from the Software, then          *
 * Licensee will (1) notify NCSA regarding its distribution of the          *
 * derivative work, and (2) clearly notify users that such derivative       *
 * work is a modified version and not the original NCSA Mosaic              *
 * distributed by the UI.                                                   *
 *                                                                          *
 * Any Licensee wishing to make commercial use of the Software should       *
 * contact the UI, c/o NCSA, to negotiate an appropriate license for such   *
 * commercial use.  Commercial use includes (1) integration of all or       *
 * part of the source code into a product for sale or license by or on      *
 * behalf of Licensee to third parties, or (2) distribution of the binary   *
 * code or source code to third parties that need it to utilize a           *
 * commercial product sold or licensed by or on behalf of Licensee.         *
 *                                                                          *
 * UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR   *
 * ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED          *
 * WARRANTY.  THE UI SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY THE    *
 * USERS OF THIS SOFTWARE.                                                  *
 *                                                                          *
 * By using or copying this Software, Licensee agrees to abide by the       *
 * copyright law and all other applicable laws of the U.S. including, but   *
 * not limited to, export control laws, and the terms of this license.      *
 * UI shall have the right to terminate this license immediately by         *
 * written notice upon Licensee's breach of, or non-compliance with, any    *
 * of its terms.  Licensee may be held legally responsible for any          *
 * copyright infringement that is caused or encouraged by Licensee's        *
 * failure to abide by the terms of this license.                           *
 *                                                                          *
 * Comments and questions are welcome and can be sent to                    *
 * mosaic-x@ncsa.uiuc.edu.                                                  *
 ****************************************************************************/


/*
 * Written By:  Scott Powers
 * Date:        April 26, 1995
 * Purpose:     Creates a comment card for Mosaic.  Submittal is via form
 *		  and works in conjunction with	a "C" cgi-bin program.
 */

#include "../config.h"
#include "mosaic.h"
#include "gui.h"
#define _COMMENT_H
#include "comment.h"
#undef _COMMENT_H
#include <stdio.h>


#ifndef VMS
#include <pwd.h>
#include <sys/utsname.h>
#else
#include "vms_pwd.h"
#include <lib$routines.h>
#ifdef __GNUC__
#include MOSAIC_BUILT
#else
#include "mosaic_built"
#endif
#endif  /* PGE, GEC */

int do_comment = 0;

extern mo_window *current_win;
extern char *machine;
#ifndef VMS
extern struct utsname mo_uname;
#endif /* VMS, GEC */


void CommentCard(mo_window *win);
int DumpHtml(char *htmlname);
char *MakeFilename();
void InitCard(char *fname);
void PutCardCount(long *num, char *fname);
long GetCardCount(char *fname);


void CommentCard(mo_window *win) {

FILE *fp;
long num[10];
char *fname;
int n;
char *htmlurl;
char *htmlname = (char *)malloc(sizeof(char) *L_tmpnam);

	if (!win)
		win = mo_next_window(NULL);

	if (!win)
		return;

	for (n=0; n<10; n++) {
		num[n] = 0;
	}

	if (!do_comment) {
		if (!(fname = MakeFilename())) {
			return;
		}

 		num[0] = GetCardCount(fname);
		num[0]++;
	}

#ifndef PRERELEASE
	if ((num[0] == COMMENT_TIME) || do_comment) {
		if (!tmpnam(htmlname)) {
			if (!do_comment) free(fname);
			return;
		}
		strcat(htmlname, ".html");
		if (!DumpHtml(htmlname)) {
			if (!do_comment) free(fname);
			return;
		}
		htmlurl = (char *)calloc(strlen(htmlname) +
			strlen("file://localhost") + 10, sizeof(char));
#ifndef VMS
		sprintf(htmlurl, "file://localhost%s", htmlname);
#else
		sprintf(htmlurl, "file://localhost/%s", htmlname);
#endif /* VMS, GEC */
		mo_open_another_window(win, htmlurl, NULL, NULL);
#ifdef VMS
		remove(htmlname);
#endif /* VMS, GEC */
		free(htmlname);
		/* Cannot free the url */
	}
#endif

	if (!do_comment) {
		PutCardCount(num, fname);
		free(fname);
	}

	return;
}


int DumpHtml(char *htmlname) {

FILE *fp;

#ifdef VMS
#define SYI$_HW_NAME 4362
#define SYI$_VERSION 4096
int syi_hw_name = SYI$_HW_NAME;
int syi_version = SYI$_VERSION;
char hardware[32], VMS_version[16], *cp;
int status;
unsigned short l_hardware, l_version;

struct  dsc$descriptor_s
{
  unsigned short  dsc$w_length;
  unsigned char   dsc$b_dtype;
  unsigned char   dsc$b_class;
  char            *dsc$a_pointer;
} hardware_desc = {sizeof(hardware), 14, 1, NULL},
  VMS_version_desc = {sizeof(VMS_version), 14, 1, NULL};

  hardware_desc.dsc$a_pointer = hardware;
  VMS_version_desc.dsc$a_pointer = VMS_version;
#endif

	if (!(fp = fopen(htmlname, "w"))) {
		return(0);
	}
	fprintf(fp, "%s\n", comment_card_html_top);
#ifndef VMS
	fprintf(fp,"					Mosaic Compiled OS: %s<br>\n",MO_COMMENT_OS);
	fprintf(fp,"					<input type=\"hidden\" name=\"os\" value=\"%s\">\n",MO_COMMENT_OS);
	fprintf(fp,"					Sysname: %s<br>\n",mo_uname.sysname);
	fprintf(fp,"					<input type=\"hidden\" name=\"sysname\" value=\"%s\">\n",mo_uname.sysname);
	fprintf(fp,"					Release: %s<br>\n",mo_uname.release);
	fprintf(fp,"					<input type=\"hidden\" name=\"release\" value=\"%s\">\n",mo_uname.release);
#else
	status = lib$getsyi ((void *)&syi_hw_name, 0, &hardware_desc, &l_hardware, 0, 0);
        status = lib$getsyi ((void *)&syi_version, 0, &VMS_version_desc, &l_version, 0, 0);
	hardware[l_hardware] = '\0';
        VMS_version[l_version] = '\0';
        for (cp = &VMS_version[l_version-1]; VMS_version; cp--) {
          if (*cp != ' ') break;
          *cp = '\0';
        }
	fprintf(fp,"                                    System version %s running on a %s.<br>\n", VMS_version, hardware);
	fprintf(fp,"					<input type=\"hidden\" name=\"release\" value=\"%s\">\n",VMS_version);
	fprintf(fp,"					<input type=\"hidden\" name=\"hardware\" value=\"%s\">\n",hardware);
#ifdef MULTINET
	fprintf(fp,"                                    TCP/IP: MultiNet<br>\n");
	fprintf(fp,"					<input type=\"hidden\" name=\"TCP/IP\" value=\"MultiNet\">\n");
#elif WIN_TCP
	fprintf(fp,"                                    TCP/IP: Pathway<br>\n");
	fprintf(fp,"					<input type=\"hidden\" name=\"TCP/IP\" value=\"Pathway\">\n");
#elif SOCKETSHR
	fprintf(fp,"                                    TCP/IP: SOCKETSHR/NETLIB<br>\n");
	fprintf(fp,"					<input type=\"hidden\" name=\"TCP/IP\" value=\"SOCKETSHR/NETLIB\">\n");
#else
	fprintf(fp,"                                    TCP/IP: UCX or UCX compatible<br>\n");
	fprintf(fp,"					<input type=\"hidden\" name=\"TCP/IP\" value=\"UCX (or UCX compatible)\">\n");
#endif /* TCP/IP flavour */
#ifdef MOTIF1_25
	fprintf(fp,"                                    Your Mosaic executable was generated using Motif 1.2-5<br>\n");
	fprintf(fp,"					<input type=\"hidden\" name=\"motif\" value=\"1.2-5\">\n");
#else
#ifdef MOTIF1_24
	fprintf(fp,"                                    Your Mosaic executable was generated using Motif 1.2-4<br>\n");
	fprintf(fp,"					<input type=\"hidden\" name=\"motif\" value=\"1.2-4\">\n");
#else
#ifdef MOTIF1_23
#if (MOTIF1_23 == 7)
	fprintf(fp,"                                    Your Mosaic executable was generated using Motif 1.2-3 ECO 7<br>\n");
	fprintf(fp,"					<input type=\"hidden\" name=\"motif\" value=\"1.2-3 ECO 7\">\n");
#else
	fprintf(fp,"                                    Your Mosaic executable was generated using Motif 1.2-3<br>\n");
	fprintf(fp,"					<input type=\"hidden\" name=\"motif\" value=\"1.2-3\">\n");
#endif
#else
#ifdef MOTIF1_2
	fprintf(fp,"                                    Your Mosaic executable was generated using Motif 1.2<br>\n");
	fprintf(fp,"					<input type=\"hidden\" name=\"motif\" value=\"1.2\">\n");
#else
	fprintf(fp,"                                    Your Mosaic executable was generated using Motif 1.1<br>\n");
	fprintf(fp,"					<input type=\"hidden\" name=\"motif\" value=\"1.1\">\n");
#endif
#endif
#endif
#endif
        fprintf(fp,"                                    and was built on %s with image Ident %s<br>\n", BUILD_TIME, IDENT_VER);
	fprintf(fp,"					<input type=\"hidden\" name=\"built\" value=\"%s\">\n",BUILD_TIME);
	fprintf(fp,"					<input type=\"hidden\" name=\"ident\" value=\"%s\">\n",IDENT_VER);
#if defined(VAXC) && !defined(__DECC)
        fprintf(fp,"                                    using VAX C.<br>\n");
	fprintf(fp,"					<input type=\"hidden\" name=\"C\" value=\"VAX C\">\n");
#else
#ifdef __GNUC__
        fprintf(fp,"                                    using GNU C.<br>\n");
	fprintf(fp,"					<input type=\"hidden\" name=\"C\" value=\"GNU C\">\n");
#else
        fprintf(fp,"                                    using DEC C.<br>\n");
	fprintf(fp,"					<input type=\"hidden\" name=\"C\" value=\"DEC C\">\n");
#endif
#endif
#endif /* VMS, GEC */
	fprintf(fp, "%s\n", comment_card_html_bot);
	fclose(fp);

	return(1);
}


char *MakeFilename() {

char *hptr, home[256], *fname;
struct passwd *pwdent;

	/*
	 * Try the HOME environment variable, then the password file, and
	 *   finally give up.
	 */
	if (!(hptr = getenv("HOME"))) {
#ifndef VMS
		if (!(pwdent = getpwuid(getuid()))) {
			return(NULL);
		} else {
			strcpy(home, pwdent->pw_dir);
		}
#else
		return (0);
#endif /* VMS, GEC */
	} else {
		strcpy(home, hptr);
	}

 	fname = (char *)calloc(strlen(home) + strlen(COMMENT_CARD_FILENAME) +
 			     strlen(MO_VERSION_STRING) + 5, sizeof(char));
#ifndef VMS
	sprintf(fname, "%s/%s%s", home,COMMENT_CARD_FILENAME,MO_VERSION_STRING);
#else
	sprintf(fname, "%s%s%s", home,COMMENT_CARD_FILENAME,MO_VERSION_STRING2);
#endif /* VMS, GEC */

	return(fname);
}


long GetCardCount(char *fname) {

FILE *fp;
long num[10];
int n;

	if (!(fp = fopen(fname, "r"))) {
		InitCard(fname);
		return((long)0);
	}
	fseek(fp, 0L, SEEK_SET);
	n = fread(num, sizeof(long), 2, fp);

	fclose(fp);

	return(num[0]);
}

void InitCard(char *fname) {

FILE *fp;
long num[10];
int n;

#ifdef VMS
/*
 * Make sure we start a new file like UNIX
 */
        remove (fname);
#endif /* VMS, GEC */
	if (!(fp = fopen(fname, "w"))) {
		return;
	}

	num[0] = 1;
	n = fwrite(num, sizeof(long), 2, fp);
                               
	fclose(fp);

	return;
}


void PutCardCount(long *num, char *fname) {

FILE *fp;
int n;

#ifndef VMS
	if (!(fp = fopen(fname, "w"))) {
#else
	if (!(fp = fopen(fname, "r+"))) {
#endif /* VMS, GEC */
		return;
	}

	n = fwrite(num, sizeof(long), 2, fp);

	fclose(fp);                          

	return;
}
