.TH MXRN 1 "3 Mar 1993" "X"
.\" $Header: /net/objy27/wrld/mnt11/ricks/src/master/xrn/xrn.man,v 1.9 1993/02/04 18:22:44 ricks Exp $
.\"
.\" xrn - an X-based NNTP news reader
.\"
.\" Copyright (c) 1988-1993, Ellen M. Sentovich and Rick L. Spickelmier.
.\"
.\" Permission to use, copy, modify, and distribute this software and its
.\" documentation for any purpose and without fee is hereby granted, provided
.\" that the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation, and that the name of the University of California not
.\" be used in advertising or publicity pertaining to distribution of 
.\" the software without specific, written prior permission.  The University
.\" of California makes no representations about the suitability of this
.\" software for any purpose.  It is provided "as is" without express or
.\" implied warranty.
.\"
.\" THE UNIVERSITY OF CALIFORNIA DISCLAIMS ALL WARRANTIES WITH REGARD TO 
.\" THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND 
.\" FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE FOR
.\" ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
.\" RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
.\" CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.ds XR \fImxrn\fP
.ds NS `.newsrc'
.ds NG \fBNewsgroup\fP
.ds AR \fBArticle\fP
.ds AL \fBAll\fP
.ds AD \fBAdd\fP
.ds XD `~/.Xdefaults'
.\"
.SH NAME
mxrn/dxrn \- an X-based interface to the USENET news system that uses the
NNTP remote news server
.\"
.SH SYNOPSIS
\*(XR is an X-based interface to the USENET news system
that uses the NNTP remote news server for accessing newsgroups
and articles.
By using the NNTP server, users can read news from personal workstations
with the program accessing the news groups and articles from a central
repository on the local area network.
This manual page applies to version 6.18.
.\"
.SH DESCRIPTION
.PP
.nh
\*(XR
[-addBindings bindings]
[-addButtonList list]
[-addPopupList list]
.br
[-allBindings bindings]
[-allButtonList list]
[-allPopupList list]
.br
[-artBindings bindings]
[-artButtonList list]
[-artPopupList list]
.br
[-artSpecButtonList list]
[+/-authorFullName]
[-authorLength len]
.br
[+/-autoRead]
[+/-autoWrap]
[+/-busyIcon]
[-busyIconName]
.br
[-busyIconPixmap]
[+/-cc]
[+/-ccForward]
[-compBreakLength len]
.br
[-compLineLength len]
[-compRows rows]
[+/-confirm list] 
.br
[-deadLetters file]
[-defaultlines num]
[+/-delayedPrint]
.br
[+/-displayLineCount]
[+/-displayLocalTime]
.br
[-distribution dist]
[+/-dumpCore]
[-editorCommand command]
.br
[+/-executableSignatures]
[+/-extraMailHeaders]
[-hostName hostname]
.br
[-iconGeometry +X+Y] 
[-ignoreNewsgroups list]
[-includeCommand command]
.br
[+/-includeHeader]
[-includePrefix "prefix text"]
[+/-includeSep]
.br
[+/-info]
[+/-killFiles] 
[-layout geometry]
[-leaveHeaders list]
.br
[+/-localSignatures]
[-lockFile name]
[-mailer "mailer command"]
.br
[-maxLines number] 
[-mhPath path]
[-minLines number]
[-newsrcFile file] 
.br
[-ngBindings bindings]
[-ngButtonList list]
[-ngPopupList list]
.br
[-nntpServer name] 
[-onlyShow num]
[-organization organization]
.br
[+/-pageArticles]
[-personalName "name"]
[-pointerBackground]
.br
[-pointerForeground]
[-popupButton button]
[-printCommand command]
.br
[-replyPath mailPath]
[-replyTo name]
[-rescanTime time]
[+/-resetSave]
.br
[+/-retainKilled]
[-retryLimit count]
[-retryPopupCount count]
.br
[-retryPopupTimeout secs]
[-retryPause secs]
[-saveDir directory]
.br
[-saveMode mode]
[-saveNewsrcFile file] 
[-savePostings file] 
.br
[-saveString string]
[-signatureFile file] 
[+/-signatureNotify] 
.br
[-sortedSubjects sort-type]
[-stripHeaders list]
[-subjectLength len]
.br
[+/-subjectRead] 
[-tmpDir directory]
[-topLines number]
.br
[-unreadIconName "name"]
[-unreadIconPixmap pixmap]
[+/-updateNewsrc]
.br
[+/-useGadgets]
[+/-verboseKill]
[+/-watchProgress]
[-watchUnread list]
.br
[+/-xrefMarkRead]
.\"

Along with the standard toolkit options:
display, geometry, xrm, and iconic.
.\"
.SH BASIC OPERATION
.PP
\fBDon't let the size of this manual page alarm you.\fP
\*(XR is easy to learn on-line without reading
the documentation.
This manual page describes many features that may be obvious to the
casual observer, along with a large section on customization
(such as choosing colors and fonts).
It also describes how to use scroll bars, buttons, and select text;
if you have used an X toolkit application before, the section
titled "BUTTONS, SCROLL BARS, and SELECTION" can be skipped.
.PP
\*(XR uses the \*(NS file to determine what groups need to be read.
If the \*(NS file does not exist, it is created, and the
user is subscribed to the news group `news.announce.newusers'.
.PP
\*(XR has four modes of operation: \*(AD, \*(NG, \*(AL,
and \*(AR modes.
\*(AD mode will be entered on startup if there are any groups
that the news system knows about that are not in the \*(NS file
(\fIi.e.,\fP new groups).
In \*(AD mode, the user is given a list of new groups.
Groups can then be subscribed to and placed in the \*(NS file
at the first position, the last position, or after a group already
in the \*(NS file.
When \*(AD mode is exited, any remaining groups are
added unsubscribed, so the user is not asked about them the
next time \*(XR is started.
On exit from \*(AD mode, or on startup if there are no new groups,
\*(NG mode is entered.
\*(NG mode displays the subscribed to groups that have unread
articles and the range of available articles.
The basic functions available in this mode allow the user to
read a group, mark all articles in a group as read, unsubscribe from a group,
move the cursor around the newsgroup window,
change the order of the list of newsgroups,
re-visit the most recently visited group, and quit \*(XR.
In addition, the user can
subscribe to a group and specify its position in the \*(NS file, 
query the news server for new articles and groups, and
go to groups that are either not subscribed to or currently have
no unread articles (\fIi.e.,\fP groups not displayed on the screen).
.br
From \*(NG mode the user can go into \*(AL mode.
In \*(AL mode the user is presented with a sorted list of
all known groups and their subscription status (subscribed
or unsubscribed) and can change their status or location
in the \*(NS file.
On exiting \*(AL mode the user is placed back in \*(NG mode.
.br
In order to read the articles in a particular group, the user goes
from \*(NG mode to \*(AR mode.
In \*(AR mode the user can sequence through the articles in
the group forward or backward, mark a group of articles
as read or unread, mark all articles in the current group
as read, unsubscribe to the current group, 
return to the last article visited, search forward or backward
for an article subject (either for the exact subject or for
a regular expression in the subject), locally kill all articles with a
particular subject, and quit (saving all changes) or exit
(leaving all articles marked unread).
In addition, the user can save the current
article in a file, post an article to the group, post a followup
to the current article, mail a reply to the author of an article, and
return to \*(NG mode.
.\"
.SH NEWS SYSTEM
.sp
The news system is a set of bulletins, discussion groups, program sources,
and other bits of information distributed around the world under the
name `USENET'.
The information is generally called `news' and is broken up into
`newsgroups'.
Each newsgroup deals with a subject or set of subjects.
The subjects for newsgroups are varied:  from discussions about particular
versions of UNIX to movie reviews, from information on the X window system
to commentary on current social and political issues.
.PP
For information on what newsgroups are available, answers to commonly
asked questions, and newsgroup etiquette, read the articles in the
newsgroup `news.announce.newsusers'.  Users who are new to the USENET
are strongly encouraged to become familiar with the contents of the
articles in `news.announce.newusers' before posting any messages.
.\"
.SH NEWS SERVER
.PP
In order to run \*(XR, you must have access to an NNTP news server.
If you do not have access to such a server and would like to set one
up, see the "USENET Software:
History and Sources" posting in news.announce.newusers for information
about where to get the appropriate software.
Either the file `/usr/local/lib/rn/server' (this filename may be
configured differently at some sites) must contain the name
of the server machine, the environment variable NNTPSERVER must be
set to the name of the server machine, the
\fBnntpServer\fP Xdefault must be set to the name of the server machine,
or the `-nntpServer' flag must be specified on the command line
(with the order of precedence being command line,
Xdefault, environment variable, file).
The name can be the actual host name of the NNTP server
(i.e. shambhala.berkeley.edu) or the internet number (i.e. 128.32.132.54).
If someone else has installed \*(XR at your site,
then it is probably already configured to use the correct news server
and you don't have to worry about it.
.\"
.SH SCREEN LAYOUT
.PP
The screen displayed by \*(XR consists of seven sections:
a title bar, two scrollable text windows, two information bars,
and two button boxes.
The title bar displays the current version of the program.
The top text window displays information based on the mode.
In \*(AD mode, the window displays all groups that are
not currently in the \*(NS file, one per line.
In \*(NG mode, the
window displays the groups containing unread articles;
each group represented by a line of the form:
.sp
.ce 100
Unread news in <group name>           <num> article(s) + <old> old
.ce 0
.sp
<group name> is the name of the group,
<num> is the number of unread articles, and <old> is the number of
read articles that are still available (i.e. have not been expired) on
the news server.  If "List old" is toggled on, then the word "Unread"
will not appear on the lines of newsgroups with no unread articles,
and furthermore, the words "news in" will not appear on the lines of
newsgroups with no available articles at all.
.PP
In \*(AR mode, the window displays a list of subjects
for the articles in the current group, with each subject line
being represented by a line of the form:
.sp
.ce 100
[+u][SP] <num>    <subject of the article> [<lines>] <author>
.ce 0
.sp
where <num> is the article number, <lines> is the number of lines in
the article (when available), and <author> is the author of the
article.  A `+' in the first position
means that the article has been read, a `u' in the first position
means that the article has been marked as unread, a 'S' in the second
position means that the article has been saved to a file, and a 'P' in
the second position means that the article has been printed.
.PP
in the top button box, and error messages.
The top button box has buttons that are specific to the mode
and apply to the information in the top text window.
The bottom text window displays articles in \*(AR mode
and a list of all known groups and their subscription status in \*(AL
mode.
The bottom information bar displays information about the mode,
the buttons in the bottom button box, and error messages.
The bottom button box has buttons that are specific to the mode
and apply to the information in the bottom text window.
.SH BUTTONS, SCROLL BARS, AND SELECTION
.PP
All button and text selection commands are done with the
left mouse button.
Single-line text selection is accomplished by
clicking the left mouse button on the desired line.
Multiple-line selection is accomplished by clicking the
left mouse button on the first line, holding the button down,
dragging the mouse to the last line, and releasing the mouse button.
Extended selection can be done by clicking on an article or range of
articles, then using shift-click to add or remove an article from the
selection.
Selected lines appear in reverse video (the foreground and background
colors are switched).
The text windows are scrolled with the scroll bar on the
right side of the window.
Clicking the left mouse button in the scroll bar will scroll the
text up or down some fraction of a page; the `slider' or `elevator' in the
scrollbar can be dragged to perform more rapid scrolls.
.\"
.SH MODES
.PP
The next few sections describe the individual modes in \*(XR.
Each button in the various modes is described with the label for the button
and the name of the button.
The name of the button can be used in X resources, in the button
lists, and in the bindings tables. 
.br
Note that not all buttons will appear in the button boxes; you can use the
customization menus to determine which functions appear in the button boxes
and popup menus. See the section of this manual titled `CUSTOMIZATIONS' for
further information.
.\"
.SH ADD MODE
.PP
\*(AD mode is entered when new groups have been detected
(groups that the news system knows about but are not in the \*(NS file).
.br
This allows you to determine what to do to these groups (subscribe or ignore
them).
.IP "Quit (addQuit)"
Add remaining groups in the list to \*(NS as unsubscribed;
go to group mode.
.IP "Add First (addFirst)"
Add the current group(s) to the beginning of the \*(NS file and
mark as subscribed.
The current group is the selected group(s), or the group
on the line containing the cursor.
.IP "Add Last (addLast)"
Add the current group(s) to the end of the \*(NS file and
mark as subscribed.
.IP "Add After Group (addAfter)"
Add the current group(s) after a group already in the \*(NS.
A dialog box is used to allow the user to enter the name of the
group to add the group after.
The mouse cursor must be in the dialog box
for \*(XR to accept text (however, it does not have to be
in the type-in area).
The dialog box has two options: \fBabort\fP and \fBadd\fP.
No other buttons on the screen will work until the user
has selected an option in the dialog box.
Hitting carriage return is the same as clicking the
\fBadd\fP button (in all \*(XR dialog boxes hitting carriage
return is the same as clicking in the rightmost button of the
dialog box).
.IP "Add Unsubscribed (addUnsub)"
Add the current group(s) to the end of the \*(NS file
and mark as unsubscribed.

.SH NEWSGROUP MODE
.PP
\*(NG mode is normally the mode that \*(XR starts up in. The window at the
top of the screen displays the list of subscribed groups that have new news
articles (ones that you haven't read) and provides control over which groups
are visited.
.br
Double clicking the left mouse button on a newsgroup entry will enter the
newsgroup.
.IP "exit (ngExit)"
Quit \*(XR, leaving the \*(NS file unchanged since the
last `rescan' operation or `checkpoint'.
If `updateNewsrc' is on, then the \*(NS file is kept up to
date with the last time \*(AR mode was exited.
.IP "Quit (ngQuit)"
Quit \*(XR. The \*(NS file is updated to account for the articles read
and \*(XR exits.
.IP "Read Group (ngRead)"
Read the articles in the current group.
The current group is either the one selected (if one is selected)
or the first group in the list. The first article in the group is read, if
the `Auto Read' flag is turned on. The `Open Newsgroup' function can be used
to avoid reading the first article.
.br
If all groups have been read, the user can still access
groups by using the \fBgoto newsgroup\fP command.
.IP "Open Group (ngOpen)"
Open a newsgroup without reading the first article. This command is useful
for groups with large articles, such as source groups, where you may not want
to read the initial article.
.br
The current group is either the one selected (if one is selected)
or the first group in the list. 
.IP "Next (ngNext)"
Move the cursor to the next group, leaving the articles in
the current group untouched.
.IP "Prev (ngPrev)"
Move the cursor to the previous group, leaving the articles in
the current group untouched.
.IP "Catch Up (ngCatchUp)"
Mark all articles in the current group as read.
.IP "Subscribe (ngSubscribe)"
Subscribe to a group.
A dialog box is used to allow the user to enter the
name of the group.
The dialog box has the following options:
\fBabort\fP, 
\fBprev group\fP (subscribe to the previous group visited),
\fBfirst\fP (put group in the beginning of the \*(NS file),
\fBlast\fP (put group in the end of the \*(NS file), and
\fBcurrent position\fP (put group at the position of the cursor).
This command can also be used to change the position of a subscribed
group.
Hitting carriage return after typing in the name is the same as
clicking the \fBcurrent position\fP button.
.IP "Unsubscribe (ngUnsub)"
Unsubscribe from the current group.
.IP "Goto Newsgroup (ngGoto)"
Go to an arbitrary newsgroup. The first unread article is displayed.
If all articles in the group have been read, the last
article in the group is displayed.
The name specified can be a substring of the group name or
a regular expression.
.IP "Toggle Groups (ngToggleGroups)"
Toggle group display mode from verbose mode (showing information on all
subscribed groups) to normal mode (showing information only on subscribed
groups with new news).
.IP "All Groups (ngAllGroups)"
Display all of the groups that exist, their subscription status,
and a set of buttons for changing the status.
.IP "Rescan (ngRescan)"
Query the server for any new groups or articles.
.IP "Prev Group (ngPrevGroup)"
Re-visit the previous group visited.
.IP "Select Groups (ngSelect)"
Records the groups currently selected.
If no groups are selected, nothing is recorded.
.IP "Move (ngMove)"
Moves the groups previously selected with the
\fBselect groups\fP command to the current cursor position.
If the cursor is currently inside the groups
to be moved, no groups are moved.
If any other button is invoked after
\fBselect groups\fP and before \fBmove\fP,
the selection is lost, and no groups are
moved.
.IP "Checkpoint (ngCheckPoint)"
Update the \*(NS file.  
\*(XR normally updates the \*(NS file on `rescan' and `quit'
in \*(NG mode. 
This allows you to update the \*(NS file without exiting \*(XR
or reconnecting to the server (see also 'artCheckPoint').
.IP "Post (ngPost)"
Post an article to a newsgroup.  
See "post" under \*(AR mode for more information.
.IP "Gripe (ngGripe)"
Send a gripe (bug, bug fix, complaint, feature request, etc.) to
the authors of the program.
.\"
.SH ALL MODE
.PP
\*(AL mode allows the user to change both the subscription status
and the \*(NS file position of any available group.
All operations can apply to multiple groups.
Thus, the user should never have to use a text editor on the \*(NS file.
.br
Double-clicking on a newsgroup name in the list will cause the group
to be read. You can use the `open group' function to open a group without
reading the first article.
.IP "Quit (allQuit)"
Update the \*(NS file and return to group mode.
.IP "Subscribe (allSub)"
Subscribe to the current group, leaving it
at its current position in the \*(NS file.
.IP "Subscribe First (allFirst)"
Subscribe to the current group and add it to
the beginning of the \*(NS file.
.IP "Subscribe Last (allLast)"
Subscribe to the current group and add it to the end of the \*(NS file.
.IP "Subscribe After Group (allAfter)"
Subscribe to the current group and add it after a particular group
in the \*(NS file (which is entered with the use of a dialog box).
.IP "Unsubscribe (allUnsub)"
Unsubscribe the current group.
.IP "Goto Group (allGoto)"
Go to the current newsgroup.
.IP "Open Group (allOpen)"
Open a newsgroup without automatically reading the first article.
The currently selected group (or the first group in the selection) is opened.
.IP "Select Groups (allSelect)"
.IP "Move (allMove)"
Same as the "select groups" and "move" buttons in \*(NG mode.
These functions are used to re-order groups.
.IP "Toggle Order (allToggle)"
Toggle the order of the newsgroups in the window between \*(NS order
and alphabetical order.
.IP "Scroll Forward (allScroll)"
Scroll the all groups window forward a page.
.IP "Scroll Backward (allScrollBack)"
Scroll the all groups window backwards a page.
.IP "Search (allSearch)"
Search the all groups window for a group.
.IP "Continue Search (allContinue)"
Continue the all groups search.
.IP "Cancel Search (allCancelSearch)"
Cancel the all groups search.
.\"
.SH ARTICLE MODE
.PP
\*(AR mode is used for reading and manipulating articles in a single group.
When a group is entered, the list of article subjects
displayed contains those from the first unread
article to the last available article.
Previous articles can be obtained by using the \fBprev\fP or
\fBsubject previous\fP commands.
Double clicking the left mouse button on an article entry will display the
article.
.IP "Quit (artQuit)"
Update the \*(NS file and return to group mode.
.IP "Next (artNext)"
Display the selected article, if any; otherwise,
display the next article in the current group.
Return to \*(NG mode after the last article has been reached.
.IP "Next Unread (artNextUnread)"
Display the selected article if it is unread; otherwise,
display the first unread article AFTER the cursor position.
If no unread articles exist, \*(XR returns to \*(NG mode.
.IP "Prev (artPrev)"
Display the selected article, if any; otherwise,
display the previous article in the current group.
.IP "Last (artLast)"
Display the last article accessed before the
currently displayed one.
This command only keeps track of one previously
accessed article, so invoking it repeatedly
simply toggles the display between two articles.
.IP "Next Newsgroup (artNextGroup)"
Go directly to the next newsgroup with unread news
(bypass newsgroup mode).
.IP "Goto Article (artGotoArticle)"
Go to the specified article number. Articles read in previous sessions can
be accessed using this command.
.IP "Catch Up (artCatchUp)"
Mark all articles in the current group as read;
return to \*(NG mode.
If a particular article is selected, catch up from the
beginning of the group to the selected article.
.IP "Fed Up (artFedUp)"
Mark all articles in the current group as read;
go to the next newsgroup.
.IP "Mark Read (artMarkRead)"
Mark an article (or group of articles) as read.
This command marks either the selected article(s)
or the article the cursor is on, and leaves
the cursor at its current position.
.IP "Mark Unread (artMarkUnread)"
Mark an article (or group of articles) and unread.
This command marks either the selected article(s)
or the article the cursor is on, and
leaves the cursor at its current position.
When an article is marked as unread, a 'u' is
placed in the far left column next to the article's
subject.
The \fBnext\fP, \fBprev\fP, \fBsubject next\fP,
and \fBsubject prev\fP buttons will all display
this article if they come across it, but the
\fBnext unread\fP button will not.
The only way to mark an article as read once
it has been marked with a 'u' is to use the
\fBmark read\fP function.
.IP "Unsubscribe (artUnsub)"
Unsubscribe from the current group; return to \*(NG mode.
.IP "Scroll Forward (artScroll)"
Scroll the article text forward a page.
.IP "Scroll Backward (artScrollBack)"
Scroll the article text backward a page.
.IP "Scroll End (artScrollEnd)"
Scroll the article text to the end.
.IP "Scroll Beginning (artScrollBeginning)"
Scroll the article text to the beginning.
.IP "Scroll Line (artScrollLine)"
Scroll the article text forward one line.
.IP "Scroll Back Line (artScrollBackLine)"
Scroll the article text backward one line.
.IP "Subject Next (artSubNext)"
Find and display the next article with the same subject as the current article
(stripping the '[rR][eE]:' garbage).
If there are no more articles with the current subject and
there are more unread articles, the first unread article is
selected.
If there are no more articles with the current subject and there
are no more unread articles, \*(AR mode is exited.
.IP "Subject Prev (artSubPrev)"
Find and display the previous article with the same subject
as the current article. The search will proceed past the current list of
articles to scan articles read in previous sessions.
.IP "Session Kill (artKillSession)"
Mark all articles with the current subject as read, for
this session only.
.IP "Local Kill (artKillLocal)"
Mark all articles with the current subject as read for this group,
and for this and all future sessions.
.IP "Global Kill (artKillGlobal)"
Mark all articles with the current subject as read for all groups,
and for this and all future sessions.
.IP "Author Kill (artKillAuthor)"
Mark all articles by the current author as read for this session only.
.IP "Subject Search (artSubSearch)"
Begin a regular expression subject search.
When this button is invoked, a window pops up
querying the user for a regular expression (of the
form used in \fBed\fP), and a direction in which to
search.
If a regular expression is not typed in, the
last regular expression is used, and the search direction
is the one specified in the dialog box (this
can be used to switch the direction of the search
without retyping the expression).
.IP "Continue (artContinue)"
Continue the last regular expression search
by searching for the same regular expression
in the same direction.
.IP "Cancel Search (artCancelSearch)"
Cancel the regular expression search.
.IP "Article Order (artNonSorted)"
Change the order of entries in the subject window to be sorted by
article number.
.IP "Subject Order (artSorted)"
Change the order of entries in the subject window to be sorted by
article number, with groups of articles with the same subject
grouped together.
or sorted by subject.
.IP "Strict Order (artStrictSorted)"
Change the order of entries in the subject window to be sorted by
the subject only. (This can be useful for sources groups).
.IP "Post (artPost)"
Post an article to the current group.
A scrollable, editable text window will appear with
a header and the user's appropriate signature file included.
The appropriate signature file is the usual signature file name
`~/.signature' followed by either a `-' and a  newsgroup name
substring, or followed by a `.' and `followup', `forward', `gripe',
`reply' or `post' according to the posting mode.  For example if you
want to post a followup article in comp.sources.x then xrn uses the
first valid signature file in the following order:
.sp
.in +0.5i
.nf
~/.signature-comp.sources.x
~/.signature-comp.sources
~/.signature-comp
~/.signature.followup
~/.signature
.fi
.in -0.5i
.sp
An appropriate header will be generated with a number
of blank header fields that if left blank will be
deleted from the posting.
The editor defaults to the standard Xtoolkit editor,
and the default can be overridden
by using the command line option -editorCommand or by
setting the same Xdefault (see the section on command
line arguments).
The mouse buttons can be used to select text in this window (which can then be
placed in a file, for example).
.sp
There are four buttons at the bottom of the window: \fBabort\fP,
\fBsend\fP (to post the article), \fBsave\fP (to save the article
in a file), and \fBinclude\fP (include the text of the article in
the reply or followup).
The \fBinclude article\fP button is
omitted if there is no current article (e.g. if the user is sending a
"Gripe" or if "post" was selected from \*(NG mode).
Only one article or message window can be active at a time.
Only one post (or followup or reply) window can be active at a time.
.IP "Exit (artExit)"
Exit article mode, marking all articles listed
in the top window as unread.
.IP "Checkpoint (artCheckPoint)"
Update the \*(NS file.  
\*(XR normally updates the \*(NS file on `rescan' and `quit'
in \*(NG mode. 
This allows you to update the \*(NS file without exiting \*(XR
or reconnecting to the server (see also 'ngCheckPoint').
.IP "Gripe (artGripe)"
Send a gripe (bug, bug fix, complaint, feature request, etc.) to
the authors of the program.
.IP "List Old (artListOld)"
List all articles available in the group, even those that have been read.
Note that this button does not toggle (clicking this button twice will no
put you back to where you were).
.IP "Save (artSave)"
Save the current article in a file, or use the current article
as standard input to a command.
The save command will pop up a dialog box for the filename.
The dialog box has two buttons: \fBabort\fP and \fBsave\fP.
If the filename begins with a `|', the article will be sent to the command
specified after the `|'.
Otherwise, the article will be appended to the file specified.
If the name is relative (does not begin with `/' or `~'), it will be
prepended by `~/News/'.
If the name begins with a `+' the name is assumed to be a MH mail
folder and a `refile' command will be done on the article.
If no name is specified, it will be saved in `~/News/<groupname>', where
`<groupname>' is the name of the current group with the first letter
capitalized (following the
.IR rn (1)
article saving conventions).
If \-saveMode is set to `subdirs', then `~/News/<groupname>/' will
be used instead of `~/News/'. Multiple articles can be selected and saved
with one command. If the filename contains the characters `%d', the article
number will replace that string; otherwise, the group of articles will be
appended into a single save file.
For VMS, piping of articles to commands (`|') is not supported.
File names are used as given. If no filename is given in a `save' command,
the group name will be used for a filename (with second and subsequent periods
converted to underscores; for example, `comp.os_vms'. Subdirs save mode on
VMS uses the group name to create a subdirectory for saving the articles.
.IP "Reply (artReply)"
Reply (by mail) to the author of the current article.
See \fBpost\fP for a description of how to create and send a message.
.IP "Forward (artForward)"
Send the current article to another person via mail.
.IP "Followup (artFollowup)"
Post a followup article to the current article.
See \fBpost\fP for a description of how to create and send an article.
.IP "Cancel (artCancel)"
Cancel the current article.
.IP "Rot-13 (artRot13)"
Decrypt a encrypted article.
In the newsgroup `rec.humor', occasionally articles are submitted
that may offend certain people or groups of people.
In order to minimize the offense, these articles are posted in
an encrypted form.
This button will decrypt them.
.IP "Translate (artXlate)"
Translate article from ISO 646 to ISO 8859-1.
.IP "Toggle Header (artHeader)"
Show the full text of an article, including the full header.
.IP "Print Article (artPrint)"
Send the article to the printer (see the `printCommand' command
line option).

.SH CUSTOMIZING MXRN
.PP
Colors, fonts, and other \*(XR options can be
specified on the command line or using X resources.
With the exception of the display name, all \*(XR options
can be specified using X resources.
Options specified on the command line take precedence over those specified
using X resources. In addition, \*(XR has a set of customization screens
that can be used to tailor the environment without editing resource files.
For each customization entry below, the corresponding resource entry and
customization menu entry are described.

.SH CUSTOMIZATIONS
.PP
The majority of the customization functions are available in any \*(XR mode
by selecting the entries from the `Customize' menu. For each of the
entries in this menu, the section below describes the function and the
associated command-line argument. Note that the case of the entries given
for the resource file and command line are case-sensitive - they must be
entered exactly as given.
.br
The following sections describe the fields on each of the customization
screens and their function.
.TP 5
.B Customize/Controls
This box provides a series of options for functions that the user wishes
to confirm before actions are taken. These boxes pop up to ask the user to
verify the invocation of "dangerous" actions (such as \fBcatch up\fP
and \fBunsubscribe\fP). It also provides control of `save' functions.
.TP 10
.B Confirm Exit
If active, provides a dialog box to allow you to confirm `quit' operations.
.TP 10
.B Confirm Exit
If active, provides a dialog box to allow you to confirm `exit' operations.
.TP 10
.B Confirm NG Catch Up
If active, provides a dialog box to allow you to confirm `Catch Up' operations
in \*(NG mode.
.TP 10
.B Confirm Article Catch Up
If active, provides a dialog box to allow you to confirm `Catch Up' operations
in \*(AR mode.
.TP 10
.B Confirm NG Unsubscribe
If active, provides a dialog box to allow you to confirm `Unsubscribe'
operations in \*(NG mode.
.TP 10
.B Confirm Article Unsubscribe
If active, provides a dialog box to allow you to confirm `Unsubscribe'
operations in \*(AR mode.
.TP 10
.B Action Prompt at Subject Change
If active, provides a dialog box to allow you to decide what to do when
the subject changes when reading articles.
.TP 10
.B Confirm Save file Overwrite
If active, allows you to specify what to do when a save operation finds
the file you've specified already exists (replace, append, or quit).
The default is to append to the existing file.
.TP 5
.B Customize/Controls Save fields
These fields modify the behavior of save operations.
.TP 10
.B Mailbox
If enabled, articles are saved in 'mailbox' format - with a date header
line and other data to make the saved file appear to be in a format similar
to mail storage.
.TP 10
.B Headers
If enabled, all the header lines are saved with the article. If disabled,
the article is saved as displayed (with any headers stripped as controled
by the `leave headers' and `strip headers' customizations applied.)
.TP 10
.B Subdirectory/One Directory
These controls determine how articles are saved if no directory path is
given; if `Subdirectory' is enabled, the article is saved in a subdirectory
of your news directory - this subdirectory is determined from the newsgroup
name. If `One Directory' is enabled, the file is saved in the news directory.
If neither is enabled, the file is saved in your current working directory.
.br
.TP 5
.B Customize/Posting
This box provides a series of options for controlling the posting of
articles and followups.
.TP 10
.B Line Length/Wrap Length
These fields determine the behavior of word wrapping of articles.
Any line that exceeds `Wrap Length' characters in width will be word-wrapped
at the first space past the column determined by `Line Length'. 
If they are both zero, no word-wrapping takes place.
.TP 10
.B Signature File
This field provides the path to the file containing your `signature' - any
postings or mailings have the contents of this file appended. Generally used
to add mail address and witty sayings. The length of
this file is limited to avoid `War and Peace' signatures.
Defaults to `~/.signature'. (SYS$LOGIN:NEWS.SIGNATURE on VMS).
.TP 10
.B Save Postings
This field gives the file name of the file to use to save postings (used
when the `save' function in the composition window is invoked.
Defaults to `~/Articles'. (SYS$SCRATCH:SAVED.POSTING on VMS.)
Note that this is the default name used when you do not specify a
file name during a save operation.
.TP 10
.B Dead Letters
This field gives the file name of the file to use to save an article that
could not be posted due to an error.
Defaults to `~/dead.letters'. (SYS$SCRATCH:DEAD.LETTER on VMS).
.TP 10
.B Editor Command
This entry allows use an alternate editor for creating postings, followups,
forwards, gripes, and replies.
The entry must be a sprintf format string that contains a `%s' where
the file name should be placed. Examples are:
.sp
.in +0.25i
.nf
xterm -e vi %s
xterm -e microEmacs %s
emacsclient %s
edit/tpu/display=decwindows %s [only VMS could be this verbose :-)]
.fi
.in -0.25i
.sp
The resulting command should handle all editing and windowing.
The article being followed up or replied to is automatically included.
.br
.TP 10
.B Organization
This field provides a value for the `Organization' header field in postings
and followups. Usually set to the name of your company or other organization.
.TP 10
.B Reply To
This entry provides a specific address for the the Reply-To header field in
postings and followups. Most news readers use this address for `reply'
commands.
.TP 10
.B Include Separator
Include or do not include the prefix text ("|> ") in front of included
articles. The default is to include the prefix text ("|> ").
.TP 10
.B Include Prefix
Change the standard prefix for each line of included text from the
default, "|> ", to the given text string.
.br
.TP 5
.B Customize/Reading
This box provides a series of options for controlling the reading of articles.
.TP 10
.B Subject Read
Specifies the action to take when using the `doTheRightThing' function to
read articles. If this button is enabled, at the end of the article a
\fBsubject next\fP function is performed. If disabled, a \fBnext unread\fP
function is performed.
.TP 10
.B Retain Killed
If enabled, articles that are killed are left in the subject listing.
If disabled, these articles are removed from the list.
.TP 10
.B Full Name
Display the full name of the author or the user/hostname of the author.
If enabled, the entry contains the author's personal name. If disabled,
the entry contains the author's path name.
.TP 10
.B Show Line Count
If enabled, the number of lines in the article (when available) is displayed
in the subject lines.
.TP 10
.B Auto Wrap
If enabled, articles being read are word-wrapped to fit in the space specified
by the `Line Length'. If disabled, a horizontal scrollbar is used to view the
article contents.
.TP 10
.B Use Kill Files
Enable or disable use of kill files. If disabled, the kill files will be
ignored.
.TP 10
.B Page Articles
When the `doTheRightThing' function is used to read articles, specifies
the action at the end of the article. If enabled, the function will stop
at the end of the article. If disabled, the next article will be read.
.TP 10
.B Read First Article
If enabled, the first article in the newsgroup is read when it is opened.
If disabled, no articles are read.
.TP 10
.B Update Newsrc
If enabled, the \*(NS file is updated when leaving \*(AR mode.
.TP 10
.B Watch Kill Progress
If enabled, the screen is updated as each article is killed during kill
operations; if disabled, the screen is updated only at the end of the
operation.
.br
.TP 5
.B Customize/Mailing
This box provides a series of options for controlling the mailing of articles.
.TP 10
.B Reply Path
The path to use for mailing replies. This should be a sprintf-able string.
This format string is used to build a mail address
acceptable to mail for replies. For example, `IN%%"%s"'.
.br
The address in the articles `Reply-To' header replaces the `%s' in the string
and the resulting line is used to provide a mail address. You must double
any "%" characters that appear in this string other than the "%s".
.TP 10
.B Personal Name
(VMS Only) Sets your 'real' name for use in postings. 
.TP 10
.B Mailer
(UNIX Only) Specifies the command to use for mailing replies.
This command must take all of it's input from standard input
(\*(XR will not build a command line).
The default is `/usr/lib/sendmail -oi -t'.
.TP 10
.B Host Name
Sets the name of your internet host. Used for postings to specify a useful
path name when the default isn't useful.
.TP 10
.B Include CC
If enabled, a `Cc:' line is provided in the header for forwards and replies.
.br
.TP 5
.B Customize/General
This box provides a series of options for controlling the general behavior
of \*(XR.
.TP 10
.B Top/Min/Max Lines
These entries control the size and behavior of the window containing the
list of newsgroups and articles. `Top Lines' specifies the number of entries
in the list. As articles are read, the list scrolls to maintain the current
article between `Min Lines' and `Max Lines'. For example, setting `Top Lines'
to 10, `Min Lines' to 2, and `Max Lines' to 8 will cause the top window to
scroll unless the current article is between lines 2 and 8. This type of
setting minimizes the number of times the top window must be repainted.
.TP 10
.B NNTP Server 
Supplies the name of the the NNTP server to use (name or internet number).
If the entry ends in two colons (`::'), DECnet is assumed as the transport.
Otherwise, TCP/IP is assumed.
.TP 10
.B Newsrc File
Name of the the \*(NS file to use. This file contains information on your
subscribed groups and which articles have been read.
Defaults to `~/.newsrc'. (SYS$LOGIN:NEWS.RC on VMS).
If a file with a name of the form `<newsrcFile>-<nntpServer>'
is found, it will be used. For example, .newsrc-fumble for news server node
`fumble'.
.TP 10
.B Saved Newsrc File
Specifies the name of the backup \*(NS file.
.br
Before the \*(NS file is modified, it is saved in a backup file.
This entry allows you to control the name of this backup file.
Defaults to `~/.oldnewsrc'. (SYS$LOGIN:OLDNEWS.RC on VMS).
.TP 10
.B Temp Directory
Specifies the directory to use for the temporary storage of articles fetched
from the server.
If this option and the corresponding Xdefault do not exist,
\*(XR will look for the environment variable \fBTMPDIR\fP.
The default is `/tmp'. (SYS$SCRATCH: on VMS.)
.B Save Directory
Specifies the article saving directory.
Defaults to `~/News' when \-saveMode specifies `onedir', or 
`~/News/newsgroup' when \-saveMode specifies `subdirs'.
For VMS, defaults to SYS$SCRATCH:. 
.TP 10
.B Print Command
Set the command used for printing articles.  The article is sent
to the command via standard input.
Defaults to `lpr'. (PRINT/DELETE on VMS).
.TP 10
.B Rescan Time
Amount of idle time (in seconds) before checking for new articles.
This rescan is only performed in \*(NG mode.
.TP 10
.B Popup Button
Specifies which mouse button will pop up the popup menus. Defaults to the
standard button for the widget set being used (MB2 for XUI, MB3 for Motif).
.TP 10
.B Display Informational Messages
If enabled, display all informative messages in the message pane. If disabled,
information messages are displayed in the top information line only.
Defaults to display all information in the message pane.

.SH OTHER CUSTOMIZATIONS
The following arguments can be provided on the command line to further
customize \*(XR. Entries in your application defaults file can be used
to specify these as well.
.TP 10
.B Watch Progress
If enabled, when 'Catch Up' is used to catch up to a selected position
in a group, the display is 'animated' so you can watch the progress of
the operation.
.br
The associated customization file entry is `watchProgress'. The command line
argument can be \+watchProgress (enabled) or \-watchProgress (disabled).
.TP 10
.B -authorLength
.B -subjectLength
Specifies the width of the `subject' and `author' fields in the subject
listing.
.TP 10
.B \-busyIcon
When set to "on", the icon image will invert when \*(XR is busy.
.TP 10
.B \-ccForward
When set to "on", you will be included as a CC entry in forwarded articles.
.TP 10
.B \-compRows rows
Specifies the number of rows in the message composition window.
.TP 10
.B \-distribution
Specifies the default distribution for articles. The default is `world'.
.TP 10
.B \-display display
specification of the X display. (Not for VMS).
.TP 10
.B +/-dumpCore
Dump core when a signal is detected.  The X resources class for the
"dumpCore" X resource is "Debug". `\+dumpCore' disables the default signal
handler.
.TP 10
.B -iconGeometry +X+Y
specification of the initial \*(XR icon location.
The window manager may choose to ignore this specification.
.TP 10
.B -iconName name
specification of the initial \*(XR icon name.
The window manager may choose to ignore this specification.
.TP 10
.B -iconic
start up \*(XR with the window iconified.
.TP 10
.B \-layout =WxH+X+Y
specification of the \*(XR window size and location.
The window manager may choose to ignore this specification.
Using the Customize/Save menu item saves the current geometry automatically.
.TP 10
.B \-leaveHeaders list
the header fields to leave in the article; a comma separated case-insensitive
list of field names (\fIi.e.,\fP subject,from,organization).
This option takes precedence over `stripHeaders'.
If the word `all' is specified instead of a list of fields, then all headers
will be retained (This can be used in user X resources to override
a resource specified in the global \*(XR application defaults, or on
the command line to override a resource specified in either the application
defaults or the user X resources.).
.B -lockFile name
Specifies the name of the lock file to use. The lock file is used to
avoid you running \*(XR multiple times, thus losing updates to your newsrc
file.
.TP 10
.B -resetSave
If set to "on", the string in the save dialog box will be reset when you
exit article mode. Normally, the string is retained between entries.
[Except when the saveString is specified - see below].
.TP 10
.B -retryPopupCount
.B -retryPopupTimeout
.B -retryPause
.B -retryLimit
Specifies the action to be taken when the connection to the NNTP server is
lost. \*(XR will pause for `retryPause' seconds between retries. A connection
attempt is made `retryPopupCount' times before posting a popup window that
allows the user the opportunity to give up. After `retryPopupTimout' seconds,
this dialog box is automatically dismissed and another retry is attempted.
After trying this `retryLimit' times, \*(XR exits.
.TP 10
.B \-saveString
Provides a default value for the filename in the save dialog box.
.TP 10
.B \+sortedSubjects
Specifies the subject sorting type to be used. Use "\+sortedSubjects" to
group articles with the same subject, and "\-sortedSubjects" to display
articles in article number order.
.br
The associated customization file entry is `sortedSubjects'. The command line
argument can be \+sortedSubjects (enabled) or \-sortedSubjects (disabled).
.br
When used in the customization file, the following values can be used:
.b
.nf
       Value                                 Sort by
    none (or off, unsorted, false)         article number
    subject (or on, true, article, sorted) related subjects
    strict                                 subject only

You can specify specific sorting types by including the
group name or hierarchy in the customization entry.
For example:
mxrn*sortedSubjects: subject
mxrn.comp.sources.x.sortedSubjects: strict
mxrn*binaries*sortedSubjects: strict
mxrn.rec.humor.funny.sortedSubjects: none
.fi
This would cause most groups to appear with subject sorting, `comp.sources.x'
to appear in strict order, binaries groups (like `comp.binaries.ibm-pc') in
strict order, and `rec.humor.funny' in article number order.
.b
.TP 10
.B \-saveDir
Specifies the default directory for saving articles.
.br
You can specify save directories on a newsgroup basis by including the
group name or hierarchy in the customization entry.
For example:
mxrn*saveDir: ~/News
mxrn.comp.sources.x.saveDir: ~/X-sources
mxrn*binaries*saveDir: ~/binaries
.fi
This would cause most groups to default to `~/News' for saving;
'comp.sources.x' and binaries groups are placed in separate directories.
.b
.TP 10
.B \-stripHeaders list
the header fields to strip from the article; a comma separated case-insensitive
list of field names (\fIi.e.,\fP keywords,message-id).
If the word `none' is specified instead of a list of fields,
then no headers will be stripped
(This can be used in user X resources to override
a resource specified in the global \*(XR application defaults, or on
the command line to override a resource specified in either the
application defaults or the user X resources.).
.TP 10
.B -unreadIconName name
specification of the \*(XR icon name when there are groups with unread articles.
The window manager may choose to ignore this specification.
.TP 10
.B -useGadgets
If set to "on", gadgets will be used to create the pulldown menus. Saves a
bit of memory - the trade-off is that the gadgets are less customizable.
.TP 10
.B -watchUnread
Specifies a list of newsgroup names to monitor. If given, this list of
groups will be scanned in newsgroup mode; if any contain new news, the
icon title will change to the unread title. If not given, all groups
are watched.
.TP 10
.B -ngButtonList list
.TP 10
.B -artButtonList list
.TP 10
.B -artSpecButtonList list
.TP 10
.B -addButtonList list
.TP 10
.B -allButtonList list
use the given list of buttons for the particular
mode in the order given rather than all of the buttons for the
mode in the default order.
The list is a comma separated list of button names.
The names of the buttons appear next after the button label
in the button descriptions above.
For example, a list of buttons for \*(NG mode might be:
ngQuit,ngRead,ngCatchUp,ngRescan,ngSubscribe,ngPost
Customization menus exist for buttons and menus for each mode.
.TP 10
.B -ngBindings bindings
.TP 10
.B -allBindings bindings
.TP 10
.B -addBindings bindings
.TP 10
.B -artBindings bindings
use the given bindings for the key/mouse bindings for
the particular mode.
See the X toolkit documentation on `Translation Tables' 
for information on the format of `bindings'.
The actions defined in \*(XR are the same as the button names.
For example, a set of bindings for \*(NG mode might be:
.nf
    mxrn.ngBindings: \\
       <Key>Q:		ngQuit()	\\n\\
       <Key>N:		ngRead()	\\n\\
       <Key>P:		ngPrev()
.fi
.TP 10
.B -ngPopupList list
.TP 10
.B -artPopupList list
.TP 10
.B -addPopupList list
.TP 10
.B -allPopupList list
Specifies the list of buttons to appear in the popup menu for
the given mode. The list is a comma separated list of button names.
The names of the buttons appear next after the button label
in the button descriptions above.
For example, a list of buttons for \*(NG mode might be:
ngQuit,ngRead,ngCatchUp,ngRescan,ngSubscribe,ngPost
Customization menus exist for the menus for each mode.
.\"
.SH X RESOURCES
.PP
\*(XR takes a number of specifications for colors, fonts, border widths,
and other program options.
.pp
The format for an \*(XR X resource is:
.sp
.ce 100
dxrn.x.y....z.a: value
or..
mxrn.x.y....z.a: value
.ce 0
.sp
Where \fIx.y....z\fP specifies the path from the top level of
\*(XR to a particular item
(think of \*(XR as a hierarchical collection of windows, panes, and buttons,
and \fIx.y....z\fP is a path from the top of the hierarchy to a node
in the hierarchy),
\fIa\fP is the type of default (\fIi.e.,\fP font, border,
foreground, background, borderWidth), and \fIvalue\fP is the value of
the default (\fIi.e,.\fP a color name or hex representation, a font name,
a numeric value).
Specifying a default for a item at some point in the hierarchy will set
that default for all items from that point down in the hierarchy.
A higher level default can be overridden by specifying
a default at a lower level directly.
.sp
MXRN/DXRN widget hierarchy:
.nf
...mxrn or dxrn (Shell)
  main  (Main Window)
    MenuBar (Menu Bar)
    vpane (Paned)
    titlebar (Label)  (optional)
    index (Text) (enclosed in topFrame for mxrn).
    indexinfo (Label)
    indexbuttons (Box)
      buttonName (Pushbutton)
    articleText (Text) (enclosed in botFrame for mxrn).
    textinfo (Label)
    textbuttons (Box)
      buttonName (Pushbutton)

composeTop (Shell)
  pane (Paned)
    headerText (Text) (enclosed in headerFrame for mxrn)
    composeText (Text) (enclosed in textFrame for mxrn)
    box (menu/RowColumn)
       abort (Pushbutton)
       send (Pushbutton)
       save (Pushbutton)
       includeArticle (Pushbutton)
       includeFile (Pushbutton)
       wrapText (PushButton)
dialogs...
.fi
.sp
Examples of defaults are:
.in +0.3i
.nf
#bindings for article mode
mxrn.artBindings:	\\
  <Key>0x20:	doTheRightThing() \\n\\
  Alt<Key>N:	artNext()	\\n\\
  <Key>N:	artSubNext()	\\n\\
  Alt<Key>P:	artPrev()	\\n\\
  <Key>P:	artSubPrev()	\\n\\
  Alt<Key>F:	artFollowup()	\\n\\
  Alt<Key>R:	artReply()	\\n\\
  Alt<Key>W:	artSave()	\\n\\
  Alt<Key>C:	artCancel()	\\n\\
  Alt<Key>V:	artHeader()	\\n\\
  Ctrl<Key>X:	artRot13()	\\n\\
  Alt<Key>u:	artUnsub()	\\n\\
  Ctrl<Key>Z:	artQuit()\\n
\\n
#
#layout/scrolling control for toplevel widget
#
mxrn.topLines:	10
mxrn.minLines:	3
mxrn.maxLines:	8
#
# which button pops up the popup menus
#
mxrn.popupButton:	2
mxrn.saveMode:	onedir
mxrn.includePrefix:	>
#
# list of popup menus. best set using customize
#
mxrn.ngPopupList:	ngQuit,ngRead,ngSubscribe,ngUnsub,ngCatchUp
mxrn.artPopupList:	artQuit,artNext,artPrev,artNextUnread
#
# your name. please don't use mine!
#
mxrn.personalName:	Rick Murphy
mxrn.includeHeader:	off
mxrn.includeSep:	on
#
# don't update newsrc each newsgroup
#
mxrn.updateNewsrc:	off
#
# inhibit info messages, use kill files.
#
mxrn.info:	off
mxrn.killFiles:	on
#
# list of buttons in various modes
#
mxrn.artButtonList:	artQuit,artFedUp,artPost
mxrn.ngButtonList:	ngQuit,ngRead,ngSubscribe,ngUnsub,ngCatchUp
#
# leading text for 'reply' functions
#
mxrn.replyPath:	decuac::"%s"
mxrn.lineLength:	72
mxrn.breakLength:	80
mxrn.pageArticles:	off
mxrn.rescanTime:	1800
mxrn.subjectRead:	on
mxrn.replyTo:		murphy@ufp.dco.dec.com
mxrn.organization:	Digital Equipment Corporation, Landover MD
mxrn.geometry:		617x750+248+214
mxrn.confirm:	ngCatchUp,artCatchUp
mxrn.sortedSubjects:	on
#
# examples of how to color pushbuttons.
# for `dxrn' ignore the shadowColor entries.
#
mxrn*background:	SkyBlue
mxrn*foreground:	white
mxrn*artPrint.background:	#e0e000
mxrn*artPrint.foreground:	black
mxrn*artPrint.bottomShadowColor:	#005400
mxrn*artPrint.topShadowColor:	yellow
mxrn*artQuit.background:	red
mxrn*artQuit.foreground:	White
mxrn*artQuit.bottomShadowColor:	#770000
mxrn*artQuit.topShadowColor:	#ffb3cc
mxrn*ngRead.background:	#00d800
mxrn*ngRead.foreground:	black
mxrn*ngRead.bottomShadowColor:	#005400
mxrn*ngRead.topShadowColor:	green
mxrn*ngRescan.background:	#e0e000
mxrn*ngRescan.foreground:	black
mxrn*ngRescan.bottomShadowColor:	#005400
mxrn*ngRescan.topShadowColor:	yellow
mxrn*XmPushButton.background:	#00d800
mxrn*XmPushButton.foreground:	black
mxrn*XmPushButton.font:	*-*-Menu-Medium-R-Normal-*-*-100-*-*-*-*-*-ISOLATIN1
#
# resources for the newsgroup/subject list
# 
mxrn*index.background:	black
mxrn*index.foreground:	white
#
# a fixed font is strongly recommended
#
mxrn*index.font:	*-*-*-Medium-R-Normal-*-*-120-*-*-M-*
mxrn*index.fontList:	*-*-*-Medium-R-Normal-*-*-120-*-*-M-*
mxrn*XmText.background:	black
mxrn*XmText.foreground:	white
mxrn*XmText.font:	*-*-*-Medium-R-Normal-*-*-120-*-*-M-*
mxrn*XmText.fontList:	*-*-*-Medium-R-Normal-*-*-120-*-*-M-*
composeTop*headerText*fontList:	*-*-*-Medium-R-Normal-*-*-120-*-*-M-*
composeTop*composeText*fontList:*-*-*-Medium-R-Normal-*-*-120-*-*-M-*
mxrn*pointerForeground:	red
mxrn*leaveHeaders:	subject, newsgroups, from, reply-to
mxrn*sortedSubjects:	on
#
# the following is recommended for VMS users. Otherwise,
# the `delete' key deletes the wrong way!
#
*XmText.translations:	\\
#override \\n\\
   Shift<Key>Delete:	delete-previous-character()\\n\\
	<Key>Delete:	delete-previous-character()\\n\\
   Shift<Key>Linefeed:	delete-next-word()\\n\\
	<Key>Linefeed:	delete-previous-word()\\n\\
   Shift<Key>BackSpace:	end-of-line()\\n\\
	<Key>BackSpace:	beginning-of-line()\\n\\
    Ctrl<Key>e:         end-of-line()\\n\\
    Ctrl<Key>j:         delete-previous-word()\\n\\
    Ctrl<Key>h:         beginning-of-line()\\n\\
    Ctrl<Key>r:         redraw-display()\\n\\
    Ctrl<Key>u:         delete-to-start-of-line()\\n
\\n
.fi
.in -0.3i

.SH FILES
.PP
~/.newsrc		description of the groups and the articles read in
.br
			each group (SYS$LOGIN:NEWS.RC for VMS)
.br
~/.oldnewsrc		backup of ~/.newsrc (created at startup)
.br
			(SYS$LOGIN:OLDNEWS.RC on VMS)
.br
~/.signature		signature for use when sending messages
.br
			(SYS$LOGIN:NEWS.SIGNATURE on VMS)
.br
~/News			directory where articles are saved
.br
			(SYS$SCRATCH: on VMS)
.br
~/Articles		where `saved' postings and messages are stored
.br
			(SYS$SCRATCH:SAVED.POSTING on VMS)
.br
~/dead.letter		where failed postings and messages are stored
.br
			(SYS$SCRATCH:DEAD.LETTERS on VMS)
.br
~/.xrnlock		lock file (SYS$LOGIN:XRN.LOCK on VMS)
.br
/usr/local/lib/rn/server	location of the news server hostname
.br
			(optional) (SYS$LOGIN:NNTP.SERVER on VMS)
.br
/usr/local/lib/news/hiddenhost	location of the hiddenhost name
.br
			(optional) (SYS$LOGIN:HIDDEN.HOST on VMS)
.br
/usr/local/lib/news/pathhost	location of the path host name
.br
			(optional) (SYS$LOGIN:PATH.HOST on VMS)
.br
/usr/local/lib/news/domain	location of the domain name
.br
			(optional) (SYS$LOGIN:DOMAIN.NAME on VMS)
.br
/etc/uucpname		location of the UUCP name for your host
.br
			(optional)
.br
/usr/lib/sendmail		default mailer
.br
CHANGES			list of changes from the previous version
.br
TODO			list of bugs and things to do

.SH ENVIRONMENT VARIABLES
.PP
Note: environment variables are implemented as logical names on VMS.
.br
NNTPSERVER		hostname of the news server
.br
TMPDIR		temporary directory
.br
DOMAIN		name of your internet domain (".Berkeley.EDU", ".orst.edu")
.br
HIDDENHOST	full domain-style name of the host that you want your return path to be from ("decvax.dec.com", "Berkeley.EDU")
.br
HIDDENPATH	name of the host that you want put in the Path field of messages.
.br
USER		login name of the user.
.br
HOME		home directory of the user.
.br
FULLNAME	full name of the user, used for the From field of messages.
.SH SEE ALSO
readnews(1), rn(1), vnews(1), X(1), nntpd(8)

.SH COMMENTS
.PP
The name (\*(XR) is a bit of a misnomer.
\*(XR is not an X interface to `rn' (the terminal-based news reading
program by Larry Wall), but is an X-based news reader that has
had part of the functionality of `rn' added since a number of our
users are (were?) `rn' users (all of the code is new).
Much of the `rn' functionality that \*(XR currently has was not in the original
plan (KILL files, for example).
.sp
The user interface look and feel is modeled after that of `XMH'
(by Terry Weissman).
.sp
The \*(NS file is updated on executing the `quit' command in \*(NG
mode, during every `rescan', and by `checkpoint'.
If the `updateNewsrc' option is set, the \*(NS file will be updated
every time \*(AR mode is exited.
.sp
\*(XR catches signals and X errors and will clean up on error exit
(remove temporary files, update the \*(NS file).
The cleanup will be done and then a death notifier box will
be posted (if the signal is SIGHUP or SIGINT,
the death notifier will be skipped
and the program will exit).
The "click to exit" button must be pressed in the death notifier box
for the program to exit.
.sp
XREFS are handled by \*(XR, however only articles that
are actually read (not marked as read by 'catchup' or 'mark as read')
have their XREFS chased and only groups that are currently subscribed
to have XREFed articles marked as read.
.sp
The default specifications for color and fonts can be confusing
(thousands of different X resources can be specified for \*(XR,
no two users' \*(XR displays need to be the same).
.sp
\*(XR uses the XHDR command of the Berkeley NNTP news server
(XHDR is not part of the protocol defined by RFC 977).
\*(XR will detect the presence of this command and complain
if it does not exist.
.sp
Since the NNTP protocol does not define a unique response code
for server timeout, timeout recovery may not work if the format
of the timeout error message changes.
.sp
\*(XR assumes a `smart' or `lucky' mailer.
.sp
\*(XR notices that the `.newsrc' file has been updated by another program while
\*(XR is running and informs the user (and gives the user the option to quit
without updating the `.newsrc' or to continue on).
.sp
Article temporary files can be removed and \*(XR will recover.
.sp
\*(XR strips `<character>^H' from articles.
.sp
The v{f,s}printf implementation included with \*(XR is from 
Robert A. Larson <blarson@skat.usc.edu>.
.sp
The strtok implementation included with \*(XR is from
Henry Spencer <henry@zoo.toronto.edu>.

.SH BUGS
.PP
.sp 
See TODO for a full list of bugs and things that need to be done.
.sp
Incomplete KILL file support.
.sp
See config.h for a list of defines you may want to use based
on problems that may exist in your version of the X11 toolkit and widgets.
.sp
Report bugs and requests for features to `murphy@ufp.dco.dec.com'
(...decwrl!ufp.enet!murphy)
.sp
.\"
.SH "ORIGINAL AUTHORS"
Ellen M Sentovich (UC Berkeley, ellen@ic.berkeley.edu, ...!ucbvax!ic!ellen)
.br
Rick L Spickelmier (formerly UC Berkeley, now Objectivity, Inc.,
ricks@berkeley.edu, ...!ucbvax!ricks, ricks@objy.com)
.br
See the FIXERS/CHANGES files for a listing of those who have really
been doing most of the work over the last year or so!
.br
Rick Murphy (DEC, Landover MD) VMS, XUI, and Motif port.
note: Ellen Sentovich and Rick Spickelmier are responsible for writing the
code. Rick Murphy is responsible for writing the bugs. Don't bother the
Berkeley folks with reports of dxrn or mxrn bugs.
