#include "struct.h"
#include "defs.h"
#include "paths.h"
#include "data.h"
#include "proto.h"

#define MAXPATH 50

int paths[NUMPATHS][MAXPATH][2] = {
    { /* PEELLEFT = 0*/
	0, 3,
	15,3,
	14,3,
	13,3,
	12,3,
	11,3,
	10,3,
	9,3,
	8,3,
	-1,-1,
    },
    { /* PEELRIGHT = 1 */
	0,3,
	1,3,
	2,3,
	3,3,
	4,3,
	5,3,
	6,3,
	7,3,
	8,3,
	-1,-1,
    },
    { /* LOOP = 2 */
	8,2,
	9,2,
	10,2,
	11,2,
	12,2,
	13,2,
	14,2,
	15,2,
	0,2,
	1,2,
	2,2,
	3,2,
	4,2,
	5,2,
	6,2,
	7,2,
	8,2,
	-1,-1,
    },
    { /* SWOOP1 = 3 */
	8,20,
	9,3,
	10,3,
	11,3,
	12,3,
	-1,-1,
    },
    { /* SWOOP2 = 4 */
	8,20,
	7,3,
	6,3,
	5,3,
	4,3,
	-1,-1,
    },
    { /* ZIGZAG = 5 */
	7,15,	8,2,
	9,15,	8,2,
	7,15,	8,2,
	9,15,   8,2,
	-1,-1,
    },
    { /* LOOP2 = 6 */
	8,2, 7,2, 6,2, 5,2, 4,2, 3,2, 2,2, 1,2, 0,2, 15,2, 14,2, 13,2, 12,2, 11,2, 10,2, 9,2, 8,2,
	-1,-1,
    },
    { /* SPIN = 7 */
	8,1, 7,1, 6,1, 5,1, 4,1, 3,1, 2,1, 1,1, 0,1, 15,1, 14,1, 13,1, 12,1, 11,1, 10,1, 9,1, 8,1,
	-1,-1,
    },
    { /* LEFTDIAG */
	8,2,
	9,2,
	10,30,
	9,2,
	8,1,
	-1,-1,
    },
    { /* RIGHTDIAG */
	8,2,
	7,2,
	6,30,
	7,2,
	8,1,
	-1,-1,
    },
    { /* ENTER1 */
	8,65, 9,5, 10,5, 11,5, 12,5, 13,5, 14,20, -1,-1,
    },	  
    { /* ENTER2 */
	8,65, 7,5, 6,5, 5,5, 4,5, 3,5, 2,20, -1,-1,
    },
	    /* ENTER3 */
    {-1,-1},
    /* ENTER4 */
    { 10,45, 11,5, 12,20, 13,5, 14,10, -1,-1, },
    /* ENTER5 */
    { 6,45, 5,5, 4,20, 3,5, 2,10, -1,-1, },
    /* ENTER6 */
    { 8,80, 6,10, 4,40, 0,20, 14,30, -1,-1},
    /* ENTER7 */
    { 8,80, 10,10, 12,40, 0,20, 2,30, -1,-1},
    /* ENTER8 */
    { 0,50, 2,50, 3,5, 4,5, 5,5, 6,5, 7,5, 8,5, 9,5, 10,5, 11,5, 12,30, 13,5, 14,5, 15,5, 0,5, -1,-1},
    /* ENTER9 */
    { 0,50, 14,50, 13,5, 12,5, 11,5, 10,5, 9,5, 8,5, 7,5, 6,5, 5,5, 4,30, 3,5, 2,5, 1,5, 0,5, -1,-1},
    /* ENTER10 */
    { 4,80, 10,30, 0,70, -1,-1 },
    /* ENTER11 */
    { 12,80, 6,30, 0,70, -1,-1 },
};

/* enter_paths are for new ships.  consists of starting co-ordinates, number of frames
   to wait at the start (presumably offscreen) and a path to follow.
   path -1 means this ship is not used on this level
   at end of path, ship flies into convoy position on it's own from wherever it winds up
*/

struct enter_path {
    int x, y, delay, path;
};

struct enter_path ep[NUMLEVELS][MAXALIENS] = {
    {	
	{ -1, -1, -1, -1},
	{ -1, -1, -1, -1},
	{ -1, -1, -1, -1},
	{ 200, -30, 435, P_ENTER1 },
	{ -1, -1, -1, -1},
	{ -1, -1, -1, -1},
	{ 200, -30, 430, P_ENTER2 },
	{ -1, -1, -1, -1},
	{ -1, -1, -1, -1},
	{ -1, -1, -1, -1},

	{ -1, -1, -1, -1},
	{ -1, -1, -1, -1},
	{ 200, -30,425, P_ENTER1 },
	{ 200, -30,420, P_ENTER2 },
	{ 200, -30,415, P_ENTER1 },
	{ 200, -30,410, P_ENTER2 },
	{ 200, -30,405, P_ENTER1 },
	{ 200, -30,400, P_ENTER2 },
	{ -1, -1, -1, -1},
	{ -1, -1, -1, -1},
		     
	{ 200, -30,345, P_ENTER1 },
	{ 200, -30,340,P_ENTER2 },
	{ 200, -30,335, P_ENTER1 },
	{ 200, -30,330, P_ENTER2 },
	{ 200, -30,325, P_ENTER1 },
	{ 200, -30,320, P_ENTER2 },
	{ 200, -30,315, P_ENTER1 },
	{ 200, -30,310, P_ENTER2 },
	{ 200, -30,305, P_ENTER1 },
	{ 200, -30,300, P_ENTER2 },
		      
	{ 200, -30,245, P_ENTER1 },
	{ 200, -30,240, P_ENTER2 },
	{ 200, -30,235, P_ENTER1 },
	{ 200, -30,230, P_ENTER2 },
	{ 200, -30,225, P_ENTER1 },
	{ 200, -30,220, P_ENTER2 },
	{ 200, -30,215, P_ENTER1 },
	{ 200, -30,210, P_ENTER2 },
	{ 200, -30,205, P_ENTER1 },
	{ 200, -30,200, P_ENTER2 },
		     
	{ 200, -30,145, P_ENTER1 },
	{ 200, -30,140, P_ENTER2 },
	{ 200, -30,135, P_ENTER1 },
	{ 200, -30,130, P_ENTER2 },
	{ 200, -30,125, P_ENTER1 },
	{ 200, -30,120, P_ENTER2 },
	{ 200, -30,115, P_ENTER1 },
	{ 200, -30,110, P_ENTER2 },
	{ 200, -30,105, P_ENTER1 },
	{ 200, -30,100, P_ENTER2 },
		     
	{ 200, -30, 50, P_ENTER1 },
	{ 200, -30, 45, P_ENTER2 },
	{ 200, -30, 40, P_ENTER1 },
	{ 200, -30, 35, P_ENTER2 },
	{ 200, -30, 30, P_ENTER1 },
	{ 200, -30, 25, P_ENTER2 },
	{ 200, -30, 20, P_ENTER1 },
	{ 200, -30, 15, P_ENTER2 },
	{ 200, -30, 10, P_ENTER1 },
	{ 200, -30,  5, P_ENTER2 },

    },
    {
	{  -1,   -1,  -1, -1},
	{  -1,   -1,  -1, -1},
	{  -1,   -1,  -1, -1},
	{ 200,  -30, 435, P_ENTER1 },
	{  -1,   -1,  -1, -1},	 
	{  -1,   -1,  -1, -1},
	{ 200,  -30, 430, P_ENTER2 },
	{  -1,   -1,  -1, -1},	 
	{  -1,   -1,  -1, -1},
	{  -1,   -1,  -1, -1},

	{  -1,   -1,  -1, -1},
	{  -1,   -1,  -1, -1},
	{ 200,  -30, 425, P_ENTER1 },
	{ 200,  -30, 420, P_ENTER2 },
	{ 200,  -30, 415, P_ENTER1 },
	{ 200,  -30, 410, P_ENTER2 },
	{ 200,  -30, 405, P_ENTER1 },
	{ 200,  -30, 400, P_ENTER2 },
	{  -1,   -1,  -1, -1},	 
	{  -1,   -1,  -1, -1},
		     
	{ 410,  125, 345, P_ENTER4 },
	{ 410,  125, 340, P_ENTER4 },
	{ 410,  125, 335, P_ENTER4 },
	{ 410,  125, 330, P_ENTER4 },
	{ 410,  125, 325, P_ENTER4 },
	{ 410,  125, 320, P_ENTER4 },
	{ 410,  125, 315, P_ENTER4 },
	{ 410,  125, 310, P_ENTER4 },
	{ 410,  125, 305, P_ENTER4 },
	{ 410,  125, 300, P_ENTER4 },
	 	       		 
	{ -30,  125, 245, P_ENTER5 },
	{ -30,  125, 240, P_ENTER5 },
	{ -30,  125, 235, P_ENTER5 },
	{ -30,  125, 230, P_ENTER5 },
	{ -30,  125, 225, P_ENTER5 },
	{ -30,  125, 220, P_ENTER5 },
	{ -30,  125, 215, P_ENTER5 },
	{ -30,  125, 210, P_ENTER5 },
	{ -30,  125, 205, P_ENTER5 },
	{ -30,  125, 200, P_ENTER5 },
		      		 
	{ 410,  125, 145, P_ENTER4 },
	{ 410,  125, 140, P_ENTER4 },
	{ 410,  125, 135, P_ENTER4 },
	{ 410,  125, 130, P_ENTER4 },
	{ 410,  125, 125, P_ENTER4 },
	{ 410,  125, 120, P_ENTER4 },
	{ 410,  125, 115, P_ENTER4 },
	{ 410,  125, 110, P_ENTER4 },
	{ 410,  125, 105, P_ENTER4 },
	{ 410,  125, 100, P_ENTER4 },
	 	      		 
	{ -30,  125,  50, P_ENTER5 },
	{ -30,  125,  45, P_ENTER5 },
	{ -30,  125,  40, P_ENTER5 },
	{ -30,  125,  35, P_ENTER5 },
	{ -30,  125,  30, P_ENTER5 },
	{ -30,  125,  25, P_ENTER5 },
	{ -30,  125,  20, P_ENTER5 },
	{ -30,  125,  15, P_ENTER5 },
	{ -30,  125,  10, P_ENTER5 },
	{ -30,  125,   5, P_ENTER5 },
				 
    },
    {
	{  -1,   -1,  -1, -1},
	{  -1,   -1,  -1, -1},
	{  -1,   -1,  -1, -1},
	{ -30,  125, 405, P_ENTER5 },
	{  -1,   -1,  -1, -1},	 
	{  -1,   -1,  -1, -1},
	{ -30,  125, 400, P_ENTER5 },
	{  -1,   -1,  -1, -1},	 
	{  -1,   -1,  -1, -1},
	{  -1,   -1,  -1, -1},

	{  -1,   -1,  -1, -1},
	{  -1,   -1,  -1, -1},
	{ -30,  125, 435, P_ENTER5 },
	{ -30,  125, 430, P_ENTER5 },
	{ -30,  125, 425, P_ENTER5 },
	{ -30,  125, 420, P_ENTER5 },
	{ -30,  125, 415, P_ENTER5 },
	{ -30,  125, 410, P_ENTER5 },
	{  -1,   -1,  -1, -1},	 
	{  -1,   -1,  -1, -1},
		     
	{ 100,  -30, 340, P_ENTER6 },
	{ 300,  -30, 340, P_ENTER7 },
	{ 100,  -30, 330, P_ENTER6 },
	{ 300,  -30, 330, P_ENTER7 },
	{ 100,  -30, 320, P_ENTER6 },
	{ 300,  -30, 320, P_ENTER7 },
	{ 100,  -30, 310, P_ENTER6 },
	{ 300,  -30, 310, P_ENTER7 },
	{ 100,  -30, 300, P_ENTER6 },
	{ 300,  -30, 300, P_ENTER7 },
/*--*/  { 100,  -30, 240, P_ENTER6 },
	{ 300,  -30, 240, P_ENTER7 },
	{ 100,  -30, 230, P_ENTER6 },
	{ 300,  -30, 230, P_ENTER7 },
	{ 100,  -30, 220, P_ENTER6 },
	{ 300,  -30, 220, P_ENTER7 },
	{ 100,  -30, 210, P_ENTER6 },
	{ 300,  -30, 210, P_ENTER7 },
	{ 100,  -30, 200, P_ENTER6 },
	{ 300,  -30, 200, P_ENTER7 },
/*--*/  { 100,  -30, 140, P_ENTER6 },
	{ 300,  -30, 140, P_ENTER7 },
	{ 100,  -30, 130, P_ENTER6 },
	{ 300,  -30, 130, P_ENTER7 },
	{ 100,  -30, 120, P_ENTER6 },
	{ 300,  -30, 120, P_ENTER7 },
	{ 100,  -30, 110, P_ENTER6 },
	{ 300,  -30, 110, P_ENTER7 },
	{ 100,  -30, 100, P_ENTER6 },
	{ 300,  -30, 100, P_ENTER7 },
/*--*/  { 100,  -30,  40, P_ENTER6 },
	{ 300,  -30,  40, P_ENTER7 },
	{ 100,  -30,  30, P_ENTER6 },
	{ 300,  -30,  30, P_ENTER7 },
	{ 100,  -30,  20, P_ENTER6 },
	{ 300,  -30,  20, P_ENTER7 },
	{ 100,  -30,  10, P_ENTER6 },
	{ 300,  -30,  10, P_ENTER7 },
	{ 100,  -30,   0, P_ENTER6 },
	{ 300,  -30,   0, P_ENTER7 },
	                	 
    },
    {
	{  -1,   -1,  -1, -1},
	{  -1,   -1,  -1, -1},
	{  -1,   -1,  -1, -1},
	{ -30,  250, 805, P_ENTER10},
	{  -1,   -1,  -1, -1},	  
	{  -1,   -1,  -1, -1},	 
	{ 430,  250, 800, P_ENTER11},
	{  -1,   -1,  -1, -1},	  
	{  -1,   -1,  -1, -1},
	{  -1,   -1,  -1, -1},

	{  -1,   -1,  -1, -1},
	{  -1,   -1,  -1, -1},
	{ -30,  250, 835, P_ENTER10},
	{ 430,  250, 830, P_ENTER11},
	{ -30,  250, 825, P_ENTER10},
	{ 430,  250, 820, P_ENTER11},
	{ -30,  250, 815, P_ENTER10},
	{ 430,  250, 810, P_ENTER11},
	{  -1,   -1,  -1, -1},	  
	{  -1,   -1,  -1, -1},
		     
	{ 100,  530, 640, P_ENTER8 },
	{ 300,  530, 640, P_ENTER9 },
	{ 100,  530, 630, P_ENTER8 },
	{ 300,  530, 630, P_ENTER9 },
	{ 100,  530, 620, P_ENTER8 },
	{ 300,  530, 620, P_ENTER9 },
	{ 100,  530, 610, P_ENTER8 },
	{ 300,  530, 610, P_ENTER9 },
	{ 100,  530, 600, P_ENTER8 },
	{ 300,  530, 600, P_ENTER9 },
/*--*/  { 100,  530, 440, P_ENTER8 },
	{ 300,  530, 440, P_ENTER9 },
	{ 100,  530, 430, P_ENTER8 },
	{ 300,  530, 430, P_ENTER9 },
	{ 100,  530, 420, P_ENTER8 },
	{ 300,  530, 420, P_ENTER9 },
	{ 100,  530, 410, P_ENTER8 },
	{ 300,  530, 410, P_ENTER9 },
	{ 100,  530, 400, P_ENTER8 },
	{ 300,  530, 400, P_ENTER9 },
/*--*/  { 100,  530, 240, P_ENTER8 },
	{ 300,  530, 240, P_ENTER9 },
	{ 100,  530, 230, P_ENTER8 },
	{ 300,  530, 230, P_ENTER9 },
	{ 100,  530, 220, P_ENTER8 },
	{ 300,  530, 220, P_ENTER9 },
	{ 100,  530, 210, P_ENTER8 },
	{ 300,  530, 210, P_ENTER9 },
	{ 100,  530, 200, P_ENTER8 },
	{ 300,  530, 200, P_ENTER9 },
/*--*/  { 100,  530,  40, P_ENTER8 },
	{ 300,  530,  40, P_ENTER9 },
	{ 100,  530,  30, P_ENTER8 },
	{ 300,  530,  30, P_ENTER9 },
	{ 100,  530,  20, P_ENTER8 },
	{ 300,  530,  20, P_ENTER9 },
	{ 100,  530,  10, P_ENTER8 },
	{ 300,  530,  10, P_ENTER9 },
	{ 100,  530,   0, P_ENTER8 },
	{ 300,  530,   0, P_ENTER9 },
	                	 
    }
};

void path_dir(int path, int pos, int *dir, int *steer)
{
    *dir =   paths[path][pos][0];
    *steer = paths[path][pos][1];
}

void start_path(int path, struct alien *al)
{
    int i;

    for(i=0;(i<MAXPATH) && (paths[path][i][0] >= 0);i++) {
	if(paths[path][i][0] == al->dir)
	    break;
	if(paths[path][i][0] < 0) {
	    al->steer = TURNSPEED;
	    al->path = -1;
	    return;
	}
    }
    if(i >= MAXPATH) {
	al->steer = TURNSPEED;
	al->path = -1;
	return;
    }

    al->path = path;
    al->path_pos = i;
    al->steer = paths[path][i][1];
}

void new_alien(int level, int i, struct alien *al)
{
    int l = (level-1) % NUMLEVELS;

    al->alive = 1;
    al->dying = 0;
    al->x = ep[l][i].x;
    al->y = ep[l][i].y;
    al->entering = 1;
    al->enterdelay = ep[l][i].delay;
    al->path = ep[l][i].path;
    al->path_pos = 0;
    al->dir = paths[ep[l][i].path][0][0];
    al->steer = 2*(paths[ep[l][i].path][0][1]/3);
    al->escorting = -1;
    al->shape = getImage(alien_shape[i/10]);
}
