#include <stdio.h>
#include "Wlib.h"
#include "defs.h"
#include "images.h"
#include "data.h"
#include "struct.h"
#include "proto.h"

W_Image *pauseImage, *titleImage;
int pausex, pausey, pauseyspeed=1;

void undo_pause()
{
    W_CacheClearArea(baseWin, pausex-(pauseImage->width/2), pausey-(pauseImage->height/2), 
		     pauseImage->width, pauseImage->height);
}

void do_pause()
{
    if((pausey < pauseImage->height/2) || ((pausey+(pauseImage->height/2)) >= WINHEIGHT))
	pauseyspeed = -pauseyspeed;
    pausey+=pauseyspeed;

    W_DrawImage(baseWin, pausex-(pauseImage->width/2), pausey-(pauseImage->height/2), 0, pauseImage, W_White);
}

void 
center_text(char *text, int y, W_Color color)
{
/*
    W_MaskText(baseWin, WINWIDTH/2 - ((strlen(text)*W_Textwidth)/2)-1, y+1, W_Black,
	       text, strlen(text), W_RegularFont);
*/
    W_MaskText(baseWin, WINWIDTH/2 - ((strlen(text)*W_Textwidth)/2), y, color,
	       text, strlen(text), W_RegularFont);
}

static void show_points()
{
    int i, ty;
    int a_images[6] = {
	I_ALIEN1,
	I_ALIEN2,
	I_ALIEN3,
	I_ALIEN4,
	I_ALIEN5,
	I_ALIEN6
    };

    char buf[40];

    for (i=0;i<6;i++) {
	W_DrawImage(baseWin, WINWIDTH/2 - 30, 220+i*21,
		    0, getImage(a_images[5-i]), W_Red);
	if(i < 5)
	    sprintf(buf, "- %d", (i+1)*100);
	else
	    sprintf(buf, "- ???");
	W_MaskText(baseWin, WINWIDTH/2, 225+i*21,
		   W_Yellow, buf, strlen(buf), W_RegularFont);
    }
    ty = 220+i*21;
    center_text("Ships in convoy are worth 50 points", ty, W_Green); ty += W_Textheight;
    center_text("Bonus ships at 20,000, 50,000, then every 50,000.", ty, W_Green);
}

void do_title()
{
    int ty;
    W_DrawImage(baseWin, WINWIDTH/2 - titleImage->width/2, 50, 0, titleImage, W_Red);

    ty = 60 + titleImage->height;
    if(getting_name)
	title_page = 0;

    switch(title_page) {
      case 0:
	center_text("Copyright (c) 1995   Joe Rumsey", ty, W_Green); ty+= W_Textheight;
	center_text("<ogre@netcom.com>", ty, W_Green); ty+= 2*W_Textheight;

	center_text("This game is shareware!", ty, W_Yellow); ty += W_Textheight;
	center_text("If you enjoy it, please send US$5 to", ty, W_Yellow); ty+= 2*W_Textheight;
	center_text("Joe Rumsey", ty, W_White);ty+= W_Textheight;
	center_text("1122 N. Towner St.", ty, W_White); ty += W_Textheight;
	center_text("Santa Ana, CA 92703", ty, W_White); ty += W_Textheight;

	if(!getting_name) {
	    show_points();
	}
	break;
      case 1:
      default:
	show_scores();
	break;
    }

    center_text("Press k for keyboard control, m for mouse", WINHEIGHT - 2*W_Textheight, W_Yellow);
    center_text("Or q to quit", WINHEIGHT - W_Textheight, W_Yellow);
    pagetimer--;
    if(!pagetimer) {
	W_ClearWindow(baseWin);
	title_page++;
	if(title_page > 1)
	    title_page = 0;
	pagetimer = 300;
    }
}

void init_titles()
{
    titleImage = getImage(I_TITLE);

    pauseImage = getImage(I_PAUSE);
    pausex = WINWIDTH/2;
    pausey = WINHEIGHT/2;
    pauseyspeed = 3;
}



