$! VMS DCL 
$! demos for ACE/gr
$!
$ BCflag :== "  "
$! define the location
$!
$ set def [-.SRC]
$ xmgr:== "$''f$environment("DEFAULT")'XMGR"
$ set def [-.doc]
$ define GR_HOME "''f$environment("DEFAULT")'"
$ define GR_HELPVIEWER "LYNX"
$ set def [-.examples]
$ write sys$output 'BCflag
$! command line parameters
$ XMGR -usage
$ wait 0:00:04
$! XView command line parameters
$ XMGR -help
$ wait 0:00:03
$!
$! explain the row of single character buttons and a few other things
$ XMGR explain.par 'BCflag
$!
$! display the various axes available
$ XMGR -p axes.par 'BCflag
$!
$! display the symbols and line styles
$ XMGR symslines.dat 'BCflag
$!
$! display more symbols
$ XMGR moresyms.dat 'BCflag
$!
$! display various fill styles
$ XMGR fills.dat 'BCflag
$!
$! some graph stuff and ticks
$ XMGR -p graphs.par 'BCflag
$!
$! some graph stuff and ticks
$ XMGR -p props1.par 'BCflag
$!
$! demonstration of many graphs
$ XMGR -maxgraph 36 manygraphs.d 'BCflag
$!
$! some graph stuff and ticks
$ XMGR brw.dat -p regions.par 'BCflag
$!
$! test of a graph inset
$ XMGR tinset.d 'BCflag
$!
$! some time and date formats
$ XMGR times.dat 'BCflag
$!
$! some more tick label formats
$ XMGR -p tforms.par 'BCflag
$!
$! some more tick label formats
$ XMGR au.d 'BCflag
$!
$! display fonts and font mappings
$ XMGR -p tfonts.par 'BCflag
$!
$! example of world stack
$ XMGR tstack.dat 'BCflag
$!
$! a graph with a parameter file
$ XMGR -p test1.par -a xy test.dat 'BCflag
$!
$! a graph with a parameter file in reverse video
$ XMGR -rvideo -p test1.par -a xy test.dat 'BCflag
$!
$ XMGR test2.d 'BCflag
$!
$! multiple graphs with a parameter file
$ XMGR mlo.dat -graph 1 brw.dat -p co2.par 'BCflag
$!
$! multiple graphs created with arrange feature
$! $ XMGR co2.all0.dat -graph 1 1.dat -graph 2 2.dat -graph 3 3.dat -graph 4 4.dat -p co2-3.par 'BCflag
$ XMGR co2.all 'BCflag
$!
$! a graph with alternate axes
$ XMGR -p altaxis.par test.dat -a xy 'BCflag
$!
$! a graph with error bars
$ XMGR terr.d 'BCflag
$!
$! another graph with error bars
$ XMGR terr2.d 'BCflag
$!
$! a graph with XY RADIUS format
$ XMGR txyr.dat 'BCflag
$!
$! a graph with hilo data
$ XMGR hilo.dat 'BCflag
$!
$! log plots
$ XMGR -p logtest.par log.d -graph 1 log.d 'BCflag
$!
$! more log plots
$ XMGR tlog.demo 'BCflag
$!
$! non-linear curve fitting
$ XMGR logistic.d 'BCflag
$!
$! bar charts
$!
$! display all types of bar graphs
$ XMGR bars.d 'BCflag
$!
$! a bar graph demonstrating specified ticks and tick labels
$ XMGR bar.d 'BCflag
$!
$! a bar graph demonstrating specified ticks and tick labels
$ XMGR bar2.d 'BCflag
$!
$! a bar graph demonstrating patterns
$ XMGR tbar3.dat 'BCflag
$!
$! a stacked bar graph
$ XMGR stackedb.d 'BCflag
$!
$! a slideshow demo
$! XMGR -pipe 'BCflag < slideshow.d
$!
$! need a program
$! modified from previous versions, a thank you goes to Bruce Barnett
$! this modification allows others without write permission
$! to run the demos.
$!
$!echo ""
$!if ( ! -f tmc ) then
$!      echo ""
$!     echo "Compiling a short program to test the -pipe option"
$!    echo "Executing 'cc tmc.c -o tmc -lm'"
$!      cc tmc.c -o tmc -lm
$!      echo "Done compilation"
$!     echo ""
$!endif
$!
$!
$! a graph with the -pipe option
$!echo "Testing -pipe option, executing './tmc | $ACEGR -pipe' "
$!./tmc | $ACEGR -pipe 'BCflag
