P /* --------------------------------- grasm.c -------------------------------- */  / /* This is part of the flight simulator 'fly8'. 6  * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au). */  > /* Vga graphics driver (direct video access, 256 colors only). */   #include "fly.h" #include "grdj.h"    #include <graphics.h>  #include <pc.h>  #include <dos.h>     #define DOSYNC		0x0001 #define BIGPAGE		0x0006  #define GRF_STATS	(GR_TYPES+1) #define INITED		0x1000   LOCAL_FUNC int FAR GraSetActive (int page)  { : 	SetActiveBase (page * (long)GrSizeY() * (long)GrSizeX()); 	return (0); }    LOCAL_FUNC int FAR GraSetVisual (int page)  { " 	if (CS->device->flags & DOSYNC) {? 		while (inportb (0x3da) & 0x01)	/* wait for Display Enabled */  			sys_poll (20);  	}@ 	SetVisualBase ((long)page * (long)GrSizeX() * (long)GrSizeY());" 	if (CS->device->flags & DOSYNC) {8 		while (inportb (0x3da) & 0x08)	/* wait for Vert Sync*/ 			sys_poll (21); @ 		while (!(inportb (0x3da) & 0x08)) /* wait for Vert Sync end */ 			sys_poll (22);  	} 	return (0); }    LOCAL_FUNC int FAR! GraSetPalette (int index, long c)  { ; 	GrSetColor (index, C_RGB_R (c), C_RGB_G (c), C_RGB_B (c));  	return (0); }    LOCAL_FUNC int FAR GraGetOptions (char *options)  { 	 	char	*p; 
 	int	ret = 0;  	long	temp;   # 	if (F(p = get_piarg (options, 1))) 
 		return (1);  	if (!stricmp (p, "et4k")) 		Gr->flags |= GR_TYPE_T4K;  	else if (!stricmp (p, "vesa"))  		Gr->flags |= GR_TYPE_VESA; 	else { ' 		LogPrintf ("Bad video type %s\n", p); 
 		ret = 1; 	}
 	free (p);    	if (get_arg (options, "stats")) 		Gr->flags |= GRF_STATS;   , 	if (get_narg (options, "shutters=", &temp)) 		st.misc[7] = (int)temp;  	else  		st.misc[7] = 0;    	return (ret); }    LOCAL_FUNC int FAR GraSetBiosMode (int n) {  	union REGS	regs;    	if (n >= 0x100) { 		regs.x.ax = 0x4f02;  		regs.x.bx = n; 	} else  		regs.x.ax = n;% 	return (int86 (0x10, &regs, &regs));  }    LOCAL_FUNC int FAR$ GraInit (DEVICE *dev, char *options) {  	int	i;    	if (GraGetOptions (options)) 
 		return (1);   ( 	if (dev->sizex == 0 || dev->sizey == 0)
 		return (1);   ; 	InitGr (GR_width_height_graphics, dev->sizex, dev->sizey);    #if 1  	if (dev->mode > 0)  		GraSetBiosMode (dev->mode);  #endif  ? 	for (i = 0; i++ < 256 && GrAllocCell () >= 0;)	/* get 2-255 */  		;    	bSetWriteMode (T_MSET);# 	GraSetPalette (CC_BLACK, C_BLACK); $ 	for (i = 0; i < dev->npages; ++i) { 		GraSetActive (i); @ 		bScrClear (0, 0, dev->sizex, dev->sizey, st.colors[CC_BLACK]); 	}   	GraSetVisual (0); 	GraSetActive (0);   	Gr->flags |= INITED;    	return (0); }    LOCAL_FUNC void FAR  GraTerm (DEVICE *dev)  {  	if (!(Gr->flags & INITED)) 	 		return;  	Gr->flags &= ~INITED;   	if (Gr->flags & GRF_STATS)  		LogStats ();    	InitGr (GR_default_text, 0, 0); 	GraSetBiosMode (0x03);  }    #if 0  LOCAL_FUNC void FAR  GraClear (SCREEN *scr) { H 	bScrClear (scr->minx, scr->miny, scr->sizex, scr->sizey, scr->BgColor); }  #endif   LOCAL_FUNC int FAR GraShutters (int eye)  {  	if (st.misc[7]) { 		if (eye >= 0) $ 			outportb (st.misc[7]+4, 1+2*eye); 		else if (-1 == eye) ( 			outportb (st.misc[7]+4, 1);		/* on */ 		else if (-2 == eye) ) 			outportb (st.misc[7]+4, 0);		/* off */ $ 		return (0);				/* have shutters */ 	} else " 		return (1);				/* no shutters */ }    struct GrDriver NEAR GrASM = {	 	"GrASM",  	0,  	NULL,	/* extra */ 	0, 	 	GraInit, 	 	GraTerm, 	 	bMoveTo, 	 	bDrawTo,  	GraSetVisual, 	GraSetActive, 	0,	/* Clear() too slow */ 	bSetWriteMode,  	GraSetPalette,  	bDrawEllipse, 	0,	/* Flush */  	GraShutters };  
 #undef DOSYNC  #undef BIGPAGE #undef GRF_STATS
 #undef INITED 