0 .\" This is part of the flight simulator 'Fly8'.7 .\" Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).  .\" M .\" Use: sed "/^$/d" <fly8.mm | groff -T<device> -rO1.25i -mgm >fly8.<device> , .\"	then print it to an appropriate printer. .\" $ .\" Justify paragraphs and set style .SA 1  .nr Pt 0M .\" Set fonts (3 = bold, 2 = italic) and size (points) for each heading level  .ds HF 3 3 2 2 2 2 2 .ds HP 14 12 12 12 12 12 12 C .\" These are groff mm macro registers - ignored if not using groff  .nr Hps1 2v  .nr Hps2 3v M .\" Set fonts (3 = bold, 2 = italic) and size (points) for each heading level  .ds HF 3 3 2 2 2 2 2 .ds HP 18 14 12 12 12 12 12  .if \n[.g] \{\M .	\" Set Proportional heading pre-space (only if the macro exists in tmac.gm) # .	\"   Also sets Hps1 and Hps2 to 0   .	if d HPPS .HPPS 0.75v 1.5v 0 0 .	\" Set ToC title$ .	ds Licon "\s18Table of Contents\s0 \}0 .\" Force "break follows heading" for all levels .nr Hb 8 .\" Generate ToC to level 7  .nr Cl 7 .PH "''\fIPage %\fP'' ; .PF "'\fIVersion 1.11\fP'\fIFLY8\fP'\fIFlight Simulator\fP'    .\" No header on page 1  .nr N 2    .sp 10   .ce 100  .ps 18 .vs 20 .sp  FLY8 .br  Flight Simulator .ps 12 .vs 14 .I .sp  Eyal Lebedinsky  .ps 10 .vs 12 .R .sp  eyal@ise.canberra.edu.au .ce 0    .SK 0    .ce 100  .ps 18 .vs 20 .sp  FLY8 .br  Flight Simulator .ps 12 .vs 14 .I .sp  Eyal Lebedinsky  .ps 10 .vs 12 .R .sp  eyal@ise.canberra.edu.au .ce 0  .sp 3    .H 1 "Introduction"  .P  @ This program is a flight simulator. It puts more emphasis on theC dynamics than on the cosmetics: just wire-frame. It can run on many E machines as it was written for portability. The distribution includes F support for msdos, mswin and unix (used to work on Amiga but I have noD access to one anymore). Other ports were done but I did received any sources back yet.   < On Intel based systems a 386DX is the minimum for any decentC performance. A fast video controller is a boon as the program, when F running on a 386DX/40Mhz, spends 70-80% of its time pushing pixels. On> non-intel machines you can try and see if it is fast enough...   .P  G As of this release the msdos version requires a 386 or better. If I get D enough requests then I will compile it for 286 but it is too slow on& such machines most of the time anyway.   .P  E The program was written for fun. I borrowed ideas from everywhere and E hope to hear some more. The design is based on a program I wrote more H than 20 years ago at uni (the Technion). I had an excellent coach (Danny@ Cohen) and I still have fond memories of those times. But now myH computer has more than 24Kbytes of memory! so Fly8 is written in C (Fly8> was the name of the last version of the original program datedD 12-JAN-1974, it was written in PDP15 assembly - macro15 - for a VT15 graphics processor).   .P  B The actual purpose of this program is to give me an opportunity toE experiment with various aspects of flight simulation, but mostly with G (1) the HUD symbology (or, more generaly, with man-machine interaction) H and (2) the studying of basic aerodynamics (as well as general real timeG simulation techniques). This explains why there are so many HUD options F and such a proliferation of flight dynamics models, as well as why theG simulation parameters are user definable as input files at run time. Of D course, the experimental nature of the program means that it must be distributed in source form.    .P  G On the PC the basic screen drawing uses the standard Microsoft graphics G library. It is OK but not very fast; the main advantage is that it will H support most video adapters. The fast graphics driver was built from theE routines from DJGPP with much personal additions. The flight dynamics G was influenced by an SGI program I saw and ACM. The timer routines come H from a microsoft journal article, the user-input routine (notice how youA can use arrow keys etc? use up-arrow to retrieve history.. I will F document it one day) comes from DDJ (or was it CUJ? author name is BobG Bybee). Well, I avoid re-inventing wheels unless it is fun. The program F compiles with Microsoft C, Borland C, gcc on a friend's Amiga, Sun andE Linux and I hope on other platforms; it is written to be portable. It , runs under MSDOS, MSWindows, Amiga and unix.   .P  H What? what? WHAT? you want to see some action? OK. just skip to the next chapter then come back.    .P  G The full set of commands is detailed in the 'commands' chapter. Here we * will look at the program areas in general.   .P  G There are two rather distinct kinds of commands that one uses: commands F that drive (fly) the game and commands that configure, set options andE so on (which are used with less urgency). It was attempted to get the H important commands into the keyboard (a one keystroke command) while theH others go into the main menu system (accessed with the Esc key). Some ofH the urgent commands may bring up a menu which you may ignore if you know the keystokes.   .P  A The urgent commands will control the vehicle flight and the other F subsystems (radar, HUD, HDD, weapons etc.). You will notice early thatH the program lacks the traditional instrument panel: it is intended to be/ driven from the HUD and other digital displays.    .P  H The vehicle is also driven by a pointing device (a mouse or, preferably,E a joystick). It will run off the keypad when you have no such device. F The pointer is used only for steering control although the buttons can! be mapped to auxiliary functions.    .P  G The display area is typicaly divided into the main view and a number of @ secondary Head Down Displays (HDD). The design has a dozen or soE on-board instruments that generate visual data; you select which ones G should be displayed on which HDD. The main view is what you see through H the cockpit. The HUD can be overlaid onto this view (as is the case withA a real plane). Other data may also be shown here for convenience.    .P  C One instrument is designated as an alternate main view (use the 'v' D command to see it). The 'windows' menu handles the screen format and configuration.   .P  C The program generates various messages as it goes along, these will F appear at the bottom of the main view and stack up. Each message has aD time-out for deletion but you can use 'c' to clear the lot. When theF program needs user input it will open a prompt line at the very bottomF of the main view (in magenta color) where your data will show. You canG use the normal editing keys while entering data here - previous entries G are accessible with the up/down arrows. See 'input line editing' later.    .P  B You may find some of the commands/options strange (if not outrightE insane); this will be related to my taste or (mostly) to much history E and quick fixing that did not completely settle yet. I have looked at F other programs (like F3, JF2, ACM and SGI f.s.) but this was after theE first version of this program was finished, so some good ideas missed D the bus this time. In the future I hope to polish the user interfaceD (especialy after other people get to use it and express an opinion).   .P  D Being as the program is still evolving you will find some areas lessB complete than others. I hope that there is enough of it to make itD useful. I expect to see contributions (of ideas and code) from otherE people; I will continue to develop the program (at least for a while) F and would like to see it take it's own path in life [heavy stuff :-)].   .H 1 "Installation"  .P  B On most environments all you need to do is unpack the distributionC archive into your prefered directory and you are set. Make sure you E un-archive the parts such that the directory structure is maintained. E Refer to the README file for specific instructions, you will probably 9 want to enable support for your graphics card (on MSDOS).    .P  B Another thing you will want to do is select your prefered pointingG device (the joystick is best). Examine the examples in fly.ini and read $ the later chapter about the options.   .H 1 "Quick start" .P  G In this chapter the symbol '@' is used to denote the Enter key. It will > give you a feel for what the program is like. With the program installed, typer   .P .ti 5   
 \fCfly8 z5\fPd   .P  H This starts the program in a demo setting and is useful to see if all is, OK. It is also great as a screen blanker :-)   .P  D If the fly.ini options are correct then your plane will take off andF start looking for action. Some messages are displayed during startup -G these will disappear after a short while. The screen will show a simplen@ view of the runway, a ground grid (in gray) and an overlaid HUD.   .P  G If there is no picture, try hitting 'Enter'. Then try 'Esc' 'x' 'y'. If2A no luck then kill it (or reboot on msdos, I guess). Now check theo3 fly.log file which may have an error message in it.n   .P  H On msdos it was found that with some accelerator cards the program hangs@ (don't know why, I use the MicroSoft C graphics library and mostD advanced cards should emulate VGA). Try installing the correct video
 VESA bios.   .P  E Do not run this program in a dos window of MSWindows or OS/2, use theFE MSWindows version for MSWindows (although it probably will work fine, H there is a chance of locking your machine up by not doing so). In a full/ window OS/2 session it was reported to work OK.R   .P  G The scene will include you and 5 other planes (drones). Your auto-pilotsE will track and shoot the drones. As they are shot down, new ones takenE off. To take control back from the autopilot hit Shift-C. Now use the D joystick (or whatever input device you choose) to fly the plane. OneC mouse or joystick button shoots (same as F1). When the target is in-H the correct position the autopilot will shoot (unless you tell it not toE with 'k'). The idea is to fly your plane so that the target is insiderF the aiming reticle (the small circle) and then shoot. A SHOOT cue will flash when your aim is correct.a   .P  E You may want to know the current settings (like throttle, flaps etc.)rD Turn on the 'panel' display (Esc hud/options-2/panel). The 'Esc' keyA activates the menu system. Most selections can be used as a shortoG sequence of the associated letters; the last sequence can be entered asoA Esc-u-2-p-Esc. The hud menu is also directly available as the 'u'  command.   .P  F This is how you fly the plane: moving the joystick sideways will startF the plane rolling. The further you move the stick the faster the roll.G Once you center the stick the roll will stop. In order to fly level you B need to roll the other way until you are level and then center the stick.   .P  L Moving the stick away from you will push the nose of the plane DOWN, pullingJ the stick back will pull the nose up. When the stick is centered the plane' will maintain it's climb angle (pitch).h   .P  F So far we rolled and pitched but we did not yet turn. In order to turnG one needs to use both controls. To turn right, first roll to the right,p@ then pull the plane 'up'; at this point 'up' is actualy 'right'.E Remember that the joystick controls the plane relative to itself (the,G pilot if you wish) and NOT relative to the ground. Once you turn in theaD desired dirction you can roll left to resume level flight in the new heading.   .P  J Because the plane has weight, if you roll and start turning the plane willK also start falling down (the wings no longer support the full weight of theuG plane) so a realistic turn will call for a moderate roll and not a fullmH 90 degrees. The harder you will pull the stick, the faster you will turnI and the larger roll you should execute to maintain level during the turn.O   .P  I You probably do not want more instructions at this 'quick start' section,rG not to mention that I never flown a plane and am not qualified for muchmE in the way of flight instruction. Any volunteers for writing a flightp manual chapter?A   .P  H Knowing how to fly the plane is not enough, you also need to know how toG participate in the game (fight). Actualy, in order to start winning yousF will need to be able to fly without thinking, you will need your logic5 powers to control your situation and plan your moves.l   .P  L Your strategy is to avoid being hit and try and kill all enemy planes. ThereJ it is, as simple as can be. I wonder why people fill books with chat about+ Basic Flight and Air Combat Maneuvering :-)A   .P  E Now a quick look at controlling other equipment. For takeoff, release D the wheel brakes ('b') and set full throttle ('1') or even light theF afterburner (a few hits on the '.' key). You may want to set the flapsG (a few ']', then reset with '[') but it is not necessary. At a speed offF 150-200 pull the nose up gently (not more than 10-15 degrees) and waitC for takeoff. After you gain some high (but rather soon) retract therE landing gear ('g'). There you are in the air. Do not try a sharp turnaE too soon as you may loose altitude and hit the ground, unless you ares$ experienced with this sort of thing.   .P  G To land, reduce speed and approach the runway at a steady descent. Just H before touchdown reduce the descent to the bare minimum (don't forget toD lower the landing gear ('g') in time but not too early). Once on theC ground engage the speed-brakes ('+') and reverse thrust (just hit 3tF until you have -100 power showing; this is not always available). WhenF your speed is low enough engage the wheel brakes ('b') and towards theH end idle your engines ('0') and release the speed brakes ('+'). Once youF are stationary on the ground with the engine idle your fuel will startG to be replaced and finally your wepons will be replaced and your damagei will be reset.   .P  K When flying, use 'r' to switch the radar on and off, use 'w' to select youraH weapon and use 'v' to switch to a map view of the world (with you at the  center) and back to normal view.   .P    This should do you for starters.   .P  F While we are here, do 'Esc' 'i' 'Enter'. Some numbers will show at theH top of the screen. The first is the total time (in milliseconds) for oneH frame, the second is the video-drawing time. If the total time goes overF 100 often then you should buy a faster machine (actually, if it is theB second numbers that dominates, a faster video card may be a better6 investment). If it stays under 60-70 then all is fine.   .P  C On MSDOS, if you have a TsengLab ET4000 based card then try runnings   .P .ti 5r  0 \fCfly8 dvgrfast:et4k Vgret4k m800x600x256 z5\fP   .P  M and if it works you will notice the speedup. Other cards are supported, checkdI the readme for details. The standard Microsoft library does not do doubleeG buffering above 640x350x16 (even in C8); don't know why - the memory islH there. You may wish to edit the file 'fly.ini' with your preferred setup6 so that you will not need to specify it in the future.   .P  1 As of this release you can use a VESA mode, as ina   .P .ti 5p  2 \fCfly8 dvgrfast:vesa Vgrvesa1p m800x600x256 z5\fP   .P  I it will perform well if it works. If you can load your VESA BIOS into ramaL then do so, it often is much faster. If you do not have a VESA BIOS suppliedK with your card then look around for one. There is at least one package (thei> universal vesa driver UNIVBE) which should work on most cards.   .bri .spu To exit hit 'Esc' 'x' and 'y'.   .H 1 "Commands Reference"  .P  A Fly8 commands are one keystroke each but some expect some data oro9 options to follow, which may bring up a prompt or a menu.v   .P  @ Some commands are used only when the 'keypad' is selected as theF pointing device for flying. Otherwise the commands are grouped here by5 their physical location and organized alphabetically.t   .P  F The program usually runs with the NumLock engaged which means that the@ keypad keys duplicate the digits 0 through 9 and the period '.'.   .P  F There is no current facility to redefine the usage of the keys but the4 keyboard macros can be of use here. See under F7/F8.   .H 2 "Alphabetic Keys" .P  E Most commands toggle their function on/off, some cycle through modes.    .VL 10 5 .LI Ae  A select aiming reticle mode. (cycles)  [obsolete] This is used for A experimenting with various LCOS formulae and will be gone once it @ settles down. At this point the calculations are based on linearG motions, it should be modified to follow an arc instead. The setting is58 shown as 'Mn' in the 'modes' screen in the 'radar' part.   .VL 5u .LI 0e no acceleration correction .LI 1  0.5 second correction  .LI 2f 1.0 second correctione .LI 3t3 t/2 seconds correction (t=time to impact) (default)  .LI 4  t*t/2 seconds correction .LEi   .LI bp  I Wheel brakes (toggle). Can be applied at any time but only effective when D on the ground. In reality these should not be operated at high speed< (use speed brakes and reverse thrust for initial slow down).   .LI c.  E Clear text area. By now there is no text area anymore so this is used G for the auxiliary function of removing all outstanding messages. If the C windows boundary got dirty then use the Screen.Clear menu option tok completely redraw the screen.g   .LI Ci  F Chase the locked target (toggle) This is the auto-pilot mode. If thereD is no target (or the radar is turned off) then the plane will wanderD around the airport perimeter. If there are ground targets then theseF will be chased and the plane will crash! This mode is activated by theC command line option 'z'. If the kill-mode is enabled ('k') then ther# auto-pilot will fire at the target.i   .LI De  H Descend the parachute. After you eject it may take a while to get to theH ground. You can pass the time by looking around (use the arrow and F5/F6F zoom keys), or you can jump to the landing phase with this command. IfE you land before your plane crashes then you will have to wait (a WAITo notice will be shown).   .LI d   F Declutter the HUD. This will remove some HUD items that get in the way= when you are in a dogfight. You can use the Hud.Parts menu tor selectively remove HUD items.c   .LI Em  F Eject. If your plane is not dead, your ejecting will send it crashing.B You are then on a parachute descending slowly. Use 'D' for a quick descent.   .LI fu  D Select radar target-acquisition mode (cycle). Controls the manner byC which the radar selects a target as explained later in the relevantn section.   .LI gd  D Landing gear up/down (toggle). You can't raise the gear while on the ground.s   .LI hy   Help (also '?')u   .LI in  F Intelligence: identify all visible targets (toggle) This is what makesC this program better than the real thing... in this mode all visiblerE targets are identified even when outside of the HUD area. You need tolD have HUD data mode enabled to get info about the targets. The aiming) reticule will not show when in this mode.k   .LI jm  F Radar sees only real pilots (ignores drones) (toggle). The program canD generate drones for target practice. If you want the radar to ignoreC these and only show (and select) real planes then use this command. 3 There are other pilots only when you are networked.b   .LI ko  F Kill- auto shoot when ready (toggle). When a target is in range and inH correct position the auto-pilot will flash a SHOOT cue. In this mode theF selected weapon will be fired at this point. The  radar must be active. with a locked target (you should see a piper).   .LI lu  B Lock target (toggle) The radar can operate in two modes, either it@ continuously selects a target according to the designated targetE acquisition mode or it stays locked on the current one. In the lockedeG mode, the first selected target will be locked on and no more searchingdF will be done. When not locked the target designator will be shown as aG broken box. You can use the un-lock command (usually attached to one ofd? the buttons and to the space-bar) to release the current targeto and acquire a new one.   .LI mr  E Show general program status. (toggle) This replaces the numerous modem indicators that planes have.   .LI M   B Set the virtual buttons shift mode. This command is expected to beE entered from a macro so NO prompting is done to the user, you will bepG now typing blind. You will enter a list of characters which will changeeF the buttons mode. The first unrecognized character will terminate this: command (it is good practice to use the Esc key for that).   .VL 5    .LI 0i  7 The following commands will enable the designated mode.,   .LI 1e  8 The following commands will disable the designated mode.   .LI 2g  C The following commands will toggle the designated mode. This is thel% default at the start of this command.s   .LI ah   Set the Btn-Alt mode.f   .LI ct   Set the Btn-Ctrl mode.   .LI pr   Set the Btn-Special mode.y   .LI sy   Set the Btn-Shift mode.f   .LI xh  > Disable all modes and enter 'enable' mode (same as '1' above).   .LI *e    Quit without changing the modes.   .LEs   .LI ot  H Observer select. See the world from another object's point of view. AlsoE useful for just a list of the objects. The list of current objects is D presented. Hit Enter to abort or select an object. The selection 'c'H will return you to your controlled plane. 'l' will select your target asH the view object (if there is a target). In the list, piloted planes haveG a 'c' and your target has an 'l'. Note that you cannot use this commandiE if networking is active. Also as objects come and go, by the time you(H select an object (by a sequence number in the list) it may have moved up? the list - you end up with the wrong object. The command is notg7 considered important enough to make it any more robust.n   .LI O'  $ As 'o' but also shows minor objects.   .LI pr  = Pause. Will not work when net is active (toggle). The "Pause"aE message tells you that you are. Use 'p' again to resume (which shouldm clear the "Paused" message).   .LI Pn  @ Report a button press. The next character must be a button name.   .LI qd  ? Quiet (sound) mode. (cycle) Sets the sounds level to one of thetH following. Note that the independent 'aural alarm' option can be used to turn the nagging alarms on/off.    .VL 5r   .LI 0u  	 no sound.o   .LI 1   ' only shoot/hit/alarms sounds (default).i   .LI 2l  D all sounds and effects. For now the only effect is the engine noise.   .LEi   .LI rv   Activate radar (toggle)l   .LI Ra  B Report a button release. The next character must be a button name.   .LI si  H Will show some stats. Following that list  is given a summary of objects: currently active (does not include the landscape objects).   .LI S   D Resupply plane: full stores and fuel, reset damage. This is a cheat!   .LI u   G Hud configuration. see 'hud commands' later. Identical to the main menud \'hud' function.   .LI vt  @ Select normal/alternate view (toggle). Will bring the designatedF alternate instrument into the main view. The alternate view is definedJ through the window configuration menu. Note the view name at the top right corner of the screen.i   .LI wt   Select weapon (cycle).   .LI Wa  G Remove all weapon stores. The plane manoeuvres better this way. You cang: still use the weapons, the counters will just go negative.   .LI x  .bru  D Calibrate pointer. Mainly for joystick. When Fly8 starts it sets theE joystick to an 'uncalibrated' mode. You now need to play the stick tonF all of it's positions, which means move the x and y to the edges, moveH the throttle to both ends and move the FCS hat to all positions. FinallyH leave the stick centered, the throttle at the position which you want toH be the point where AB starts and leave the hat centered. Now hit 'x' and% the program will re-calibrate itself.e   .P  D After playing for a while you can again hit 'x' but you will have toF take your hards off the stick and reposition the throttle before doingG so (and you MUST have played for a while so that the full extent of thew controls was used).e   .H 2 "Symbol Keys" .P  E These are the rest of the keys on the main keyboard. For clarity eachhH key's name is spelled out. If it is allocated then the function follows.   .VL 25 5   .LI "\\\\  [back del]"   .LI "\\\\  [escape]"   invoke the menu system   .LI "\\\\  [space]"n   release radar lock   .LI "` [grave accent]"   .LI "- [hyphen]"   see keypad '-'   .LI "= [equals sign]"]   .LI "\\\\\\\\ [back slash]"n   used to reset the trim to nill.l   .LI "[ [l-bracket]"t  
 less flaps   .LI "] [r-bracket]"o  
 more flaps   .LI "; [semicolon]"h   .LI "' [quote]"    .LI ", [comma]"a   .LI ". [period]"   see keypad '.'   .LI "/ [slash]"n   see keypad '/'   .LI "~ [tilde]"    .LI "! [bang]"  J shell to system. May not restore some environment parameters and pallette.D Use 'exit' to resume. Not implemented on windowed enviroments - just% open another window if you need so...    .LI "@ [at symbol]"C   .LI "# [hash]"   .LI "$ [dollar]"   .LI "% [percent]"g   .LI "^ [caret]"h   .LI "& [ampersand]"t   .LI "* [asterisk]"   see keypad '*'   .LI "( [l-paren]"i   less wheel brakes.   .LI ") [r-paren]"e   more wheel brakes.   .LI "_ [underdash]"i   .LI "+ [plus]"   see keypad '+'   .LI "| [pipe]"   .LI "{ [l-brace]".  
 less spoilers    .LI "} [r-brace]"e  
 more spoilersC   .LI ": [colon]"k   .LI "\N'34' [double quote]"g   .LI "< [less than]"    less speed brakes.   .LI "> [greater than]"   more speed brakes.   .LI "? [question mark]"d   help   .LEp  
 .H 2 "Keypad"  .P  D The keypad is a collection of keys that replicate the main keyboard.0 These are described as three groups by function.   .P  H The following keys surround the numerical keypad and are not affected by the Shift key.   .VL 20 5   .LI -t   view right (+45 degrees)   .LI *.  
 view ahead   .LI /    view left (-45 degrees)    .LI +o  F speed brakes (toggle). Note that the Speed brakes take time to deploy,G it's status is shown on the control panel in percent of full extension.f   .LI (Enter)c   unallocated    .LEv   .P  , The rest of these keys must have NumLock on.   .P  I These first four keys respond only if the keypad is your pointing device.a   .VL 20 5   .LI "8 (up)"   pitch (pull nose) up   .LI "2 (down)"   pitch (push nose) down   .LI "6 (right)"a  
 roll right   .LI "4 (left)"  	 roll lefta   .LE    .P  @ The following commands extend all pointing devices capabilities:   .VL 20 5   .LI "5 (center)"  M center ailerons and elevetors, like centering the joystick. Useful when usingaK a mouse (or trackball): will move the reference point to where the mouse isu at this moment.Y   .LI "7 (Home)"  2 stop rolling. Levels the plane. For quiche eaters.   .LI "9 (PdUp)"   more (+5%) power   .LI "3 (PdDn)"   less (-5%) power  
 .LI "1 (End)"s   mil (dry) (100%) power    
 .LI "0 (Ins)"s   zero (0%) power   
 .LI ". (Del)"i  4 after burner up (+1 unit which is 20% of full scale)   .LEd   .H 2 "Special keys"  .P  > These keys are a group of six on most keyboard but can also be: duplicated using the Shift key and a numerical keypad key.   .VL 20 5  
 .LI PageUp  " level (heading 0, pitch 0, roll 0)  
 .LI PageDn  ( reset coordinates to zero (back to base)   .LI Home   unallocatedt   .LI Ends   unallocatedr  
 .LI Insert   unallocatedy  
 .LI Delete   unallocated    .LE    .H 2 "Function keys" .P  C The function keys are normally used in plain mode (no Shift, Alt oriG Ctrl). When the menu is on the up-front, the left column ten selectionstD are accessible with F1-F10 while the right column uses AltF1-AltF10.   .VL 10 5   .LI F1  A shoot. Usually also mapped the mouse left button and the joystick  trigger button.s   .LI F2   rudder left    .LI F3  
 rudder centerc   .LI F4   rudder right   .LI F5  > zoom in (more detail, narrower view, eye further from window).   .LI F6  9 zoom out (less detail, wider view, eye closer to window).    .LI F7   Macro/HotKey definition.  D Any key can be used for a macro name (except F7/F8). If you define aF macro for a HotKey (Ctrl- and Alt- 'a' thru 'z') then it can be played@ back with one keystroke. Other keys are played using the F8 key.  G If you use a Macro during recording then the Macro will be recorded. IfLH you later re-define this Macro then it will affect any other Macros that uses it.  @ During macro expansion there is a limit of 16 levels of nesting.  5 There is no capability for Macros definition editing.i   .VL 20   .LI "define"   F7<macro-key><keystrokes>F7a   .brl  G If the key is already defined then you are warned of the re-definition..B You may abort at any stage (F8F8) and the original definition will remain.e  7 If you hit F8 during recording then you are prompted byiG Abort/Cont/Quote? to which you may respond by F8 (abort the recording),eH F7 (ignore the F8 and continue recording) or any other key (the key will: be recorded with the F8 expecting it to be another macro).   .LI "delete"   F7<macro-key>F7e   .brL  * It is not possible to record a null macro.   .LE    .LI F8 "Macro play"a  
 F8<macro-key>s   .VL 20   .LI "HotKey play"w   <HotKey>   .br   ; Hot keys are Ctrl-a through Ctrl-z and Alt-a through Alt-z.    .LE    .LI F9  D zoom in (more detail, narrower view, eye further from window) in the0 external view window (default is the radar map).   .LI F10n  H zoom out (less detail, wider view, eye closer to window) in the external' view window (default is the radar map).    .LI F11s   unallocatedt   .LI F12l   unallocatede .LEc   .H 2 "Alt keys"a .P   Alt-Arrows: see below.   .P  7 Alt-a thru Alt-z are reserved for user defined HotKeys.    .P   The other keys are unallocated.t   .H 2 "Ctrl keys" .P   Ctrl-Arrows: see below.e   .P  9 Ctrl-a thru Ctrl-z are reserved for user defined HotKeys.o   .P   The other keys are unallocated.t   .H 2 "Arrow keys"    .VL 20 5   .LI up   turn gaze (head) down    .brr All turns by 5 degrees   .LI down   turn gaze (head) upP   .LI left   turn gaze (head) lefte  	 .LI righti   turn gaze (head) right   .br   % use '*' to restore normal front view.t  	 .LI CTLups   trim nose down.e   .LI CTLdownt  
 trim nose up.d   .LI CTLright   trim rudder right.   .LI CTLleft    trim rudder left.w  	 .LI ALTupt   debug (varies).u   .LI ALTdowno   debug (varies).u   .LI ALTright   debug (varies).V   .LI ALTleft    debug (varies).    .LEn   .H 1 "Menus" .P  H A menu has a list of options, each associated with a key and a function.B To select a function use the Up/Dn arrows to highlight it and thenE Enter, or directly press the corresponding key. When on the up-front,u@ the associated letters are NOT shown but are recognized; use theF CtrlF-keys to select left column functions and AltF-keys for the right column. See under HDD later.   .P  E Menus can be nested, in which case the previous selections are listed E first (in a staggered fasion and highlighted) followed by the currentmE menu. The selected option is highlighted (white) while the others aree displayed in gray.   .P  E The Esc key brings up the top menu but later is used to abort a menu.d& During menu navigation use these keys:   .VL 10 5   .LI Esct .brp   aborts the menuh .bre  	 .LI Entert .bre  # accept the current selection optione   .LI UpArrowr .brh   select previous option   .LI DnArrowa .brt   select next option  	 .LI otheri .brs   select the corresponding optiona   .LE    .P  G If a command is invalid (top/bottom of list or undefined option) then ai, beep is emited and the keystroke is ignored.   .P  G The menu system is changing rapidly so the following may be incomplete.h   .P  D Some other commands may pop up a menu, in which case it behaves in a similar way.   .P  H If you have the up-front instrument active then the menus will appear onF it rather than on the main menu. This is a stupid attempt to make yourC interaction look similar to what happens in a modern fighter. It is D often the case that the pilot has a panel which can display about 10C alpha-numeric words in bright white (daylight readable). These willtH usually use special LEDs and a more elaborate font than the 7-seg digitsE (9 segment?). There are pushbuttons beside these words. The words are I arranged in two columns, each with 10 words, with 10 buttons on the right G and 10 on the left. As you press a button new information is displayed.mB Other planes use a real CRT but still have a 5-buttons arrangement( (mostly on all four sides, totaling 20).   .P  E In Fly8 the up-front device has two columns of words, each column can H show 10 words, each word can be 10 characters long. There are 10 buttonsJ on the left (Ctrl-F1 through Ctrl-F10) and 10 on the right (Alt-F1 throughI Alt-F10). Use these keys to make selections. You can still use the normal E command letters (if you know them, as they are not displayed here) as.F well as move about with the Up/Down keys: a small dash between the key= number and the text identifies the currently selected option.a   .H 2 "Top Menu"u   .VL 15 5   .LI Exit   quit the program   .brh  # confirm with 'y' on subsequent menun   .LI Help   toggles the help screen on/off   .LI Pointers   select pointing device  
 .LI Screen   screen options.e   .LI WindowsL   set windows configurationl   .LI Info   select stats info level    .LI Emit  ) create some random objects or remove them[   .LI Hud   
 configure HUD    .LI Net-   networking commandsr   .LI Optionso   set global program options   .LI Auto   selects some autopilot options  	 .LI DebugL   set debug options    .LI Buttonsa  H Allows to control the functionality of the pointer buttons. Usuaslly youF set these options at startup time. The 'B' command will too bring thisG menu up. To actually report a button press/release you use the 'P', 'R's and 'M' commands.a   .LI Commande  F Allows to control the behaviour os the simple keystroke commands which7 by default have a 'Toggle' action (like 'w', 'g' etc.).-   .LEe   .H 2 "Pointer Menu"  .P  D A list of all available pointing devices is offered. Select one. All@ systems have a keypad device, most have a mouse and the PC has a	 joystick.c  I You will be asked to specify pointer options - read about it later in the. command line options section.    .H 2 "Screen Menu"   .VL 10 5   .LI Screen.Palette .br0   program the palettei   .LI Screen.Colors  .br2    assign colors to visual elements   .LI Screen.Stereo  .brr   select a stereo mode   .LI "Screen.Dbl Buff"P .brh  I set buffering mode to double/single. A message is posted on the new mode. G Double buffering is not supported in all environments and in all modes,sG and in some cases it may be significantly slower than single buffering.    .LI Screen.Blanker .bru  H toggle screen blanker mode. Borders and some fixed data are not shown in
 blanker mode.    .LI "Screen.HUD pos" .br)  F select it the HUD is focused at infinity (default) or on the HUD face.B Only used for experimenting, rather useless to change the default.   .LE    .H 3 "Screen.Palette Menu" .P  E A set of colors is listed. Select one for modification. You will thena1 be presented with a number of adjustment options:l   .VL 15 5   .LI Brighter   intensify the colore  
 .LI Darker   reduce color intensity   .LI Newi    set color to a desired RBG value   .LI Restoreo   restore color to original value    .LEa   .H 3 "Screen.Colors Menu"e .P  E A list of visual componnents is listed. Select one and then the color2E palette menu will show - choose the color to assign for this element.d   .H 3 "Screen.Stereo Menu"W .P   select a mono/stereo mode:   .VL 10 5   .LI Screen.Stereo.Mono .brb   standard mono mode   .LI Screen.Stereo.S'Scopic .br   H side by side stereoscopic images. Use the 'recerse' option if you prefer  the cross-eye stereoscipic view.   .LI Screen.Stereo.RedBlueL .br   * red/blue composite (needs colored glasses)   .LI Screen.Stereo.Alternate  .brw  E alternating left/right images (needs shutter glasses and '-s' commandd line option)   .LI Screen.Reverse .br7  7 toggle reverse-stereo mode (swap Left and Right images)a   .LI Screen.Paralax .br   F set stereo inter-occular distance. Initialy set to 12 units. Each unit is 1meter/256 (about 4mm).   .LE.   .H 2 "Windows Menu"u .P  C A number of window configurations are offered. This defines how the @ screen is split into main and auxiliary display areas. After the> selection the screen remains active so that you can select the  \'configure' option immediately.   .VL 10 5   .LI Windows.configurec .bre  0 This will call up the windows layout setup menu.   .LI "Windows.bg color" .brl  G Set the foreground color for one window. You will be prompted to select.$ a window and then to select a color.   .LI "Windows.fg color" .br   E Set the border color for one window. You will be prompted to select ar" window and then to select a color.   .LI "Windows.bo color" .bre  G Set the background color for one window. You will be prompted to select $ a window and then to select a color.   .LI Windows.full .brL   the whole screen is one window   .LI Windows.landscapee .bre  H a wide main view with three windows below: stores on the left, radar map4 on the right and a rear vision mirror in the middle.   .LI Windows.portrait .bra  < a square main view with a column of two windows on the right   .LI Windows.square .brh  E a square main view with a column of three square windows on the right    .LI Windows.wide .bre  / a wide main view with four square windows below    .LI Windows.panorama .brt  E An experimental format where the center view is accompanied by a lefte( and right views which meet on the edges.   .LI Windows.etherP .brl  A a new window configuration that is being developed at the moment.t   .LEs   .H 3 "Windows.Configure Menu"k .P  E The plane has a number of on-board instruments, each one has a visual D representation that can be shown on one of the active displays. ThisH menu is used for defining which instrument is to be shown on each of theI displays. Configuring the main display (usually numbered 0) defines which . instrument will be used as the alternate view.   .VL 15 5  	 .LI front   ! this is a forward looking camera.w   .LI none    designates the HDD as unassigned   .LI rear   a rear viewing camerat   .LI mapd  D a map of the area from above with you at the center and north is up.  	 .LI radar   K as 'map' above but the plane's current heading is the 'up' direction. Givesl better situation awareness.L  
 .LI target   a target following camera.   .LI pan   @ another target following camera that is less stable (more real?)   .LI gaze  . a view of my plane from a fixed relative point  	 .LI chaser  4 a view of my plane from a point that chases my path.  
 .LI follow  6 as 'chase' but the view is always level (never rolls).   .LI hudf   this is the raw HUD displayr   .LI "up-front"  2 an alphanumeric display used for pilot interaction  	 .LI panele  ) a digital data and warning display panel.g  	 .LI righta  / the right view of the 'panorama' configuration.    .LI left  . the left view of the 'panorama' configuration.  
 .LI stores  C This is a summary of the vehicle's status showing weapon selection,bH throttle and engine state, fuel and other engaged features (gear, brakes etc.).  	 .LI lampse  H a digital board of lamps that can be on, off or blinking in red or greenH with a legend on each. It is used by default by the Ether configuration.  
 .LI mirror  H Like a rear view but through a mirror. It is by default set up as a wide
 angle mirror.n   .LEt   .H 2 "Info Menu" .P  G Select the stats info level. This info is shown on the up-front HDD but . can (optionally) be overlaid on the main view.   .VL 10 5   .LI Info.off .br   & do not overlay 'info' on the main view   .LI Info.on  .bre  " do overlay 'info' on the main view  
 .LI Info.nonei .brm   no infot   .LI Info.timinga .br     only basic timing will be shown.   .LI Info.stats .brp  > timing and internal stats are shown, used for program testing.  
 .LI Info.game  .bre  + timing and basic info for a game are shown.    .sp   & The second line will show (in  order):   .DLy   .LIe  % time from start of game (in seconds).    .LId  D number of targets present (both standard targets and ground targets)   .LIn   number of weapons used in total    .LIg   number of hits scoredi   .LEo   .spt   The third line will show:n   .DL    .LIt   score (counting down!)   .LIm   plane speed (meters/sec).l   .LEe .LEa   .P  E The basic 'timing' data, which is always the first line, is a list ofn millisecond durations for:   .DLt   .LI    total time of frames   .LIc  ) graphics drawing (display list -> screen)0   .LIt  * 3D transformations (world -> display list)   .LIt  + objects simulation (old world -> new world)r   .LIl  . other visual calculation (hud, text, sky etc.)   .LIu  ( vertical sync wait (if double buffering)   .LIa  A total minus the rest; will include the auxiliary windows time andw network disturbance.   .LEt   .H 2 "Emit Menu" .P  H Various objects can be created with this menu. These objects are used as targets.   .VL 10 5   .LI Emit.targeth .bro   create one random target   .LI delL   delete all targets   .LI Emit.gtarget .br    create one random ground target    .LI deln   delete all ground targetsi   .LI Emit.box .br   H create one random box. Boxes are cubes that hop around which can be shot down.a   .LI dels   delete all boxes   .LI "Emit.del tgts"U .br   - delete all targets, ground targets and boxes.    .LI Emit.drone .brt   create one random plane (drone)t   .LI delo  G delete all drones. This will also set the number of automatic drones to  zero.c   .LI Emit.dronesi .brb  F specify how many drones should be automatically maintained in the air.+ Whenever one is lost another one takes off.r   .LI Emit.killers .bry  F specify how many of the drones should be killers. These will be set to Chase and Kill mode.   .LEl   .H 2 "HUD Menu"s .P  G Various aspects of the HUD can be set. Each option is either set, reset2H or toggled. The default is to toggle the option but the first three menuE items can be used to change this mode. This menu can be accessed from E the main menu as well as directly with the 'u' command. The followings+ selections appear on many of the sub-menus:o   .VL 20 5   .LI "0 turn off"   turn option off    .LI "1 turn on"e   turn option  onh   .LI "2 toggle"   toggle option on/off   .LEc   .P  A This top level menu will bring up a number of sub-menus which aree! described further down this doco.    .VL 10 5   .LI HUD.offe .brl  E turn the HUD off. When turned off, the radar symbols will still show.eB This is a feature of the game which is not like the real thing; itH allows you to play with a very clean view. Not only will the radar stuffG still show, but the symbols will now move freely across the full screen = rather than being confined to the HUD area. To get rid of theh! reticle/TDB use the 'parts' menu.l  
 .LI HUD.on .brc   turn the HUD onx   .LI HUD.type .brs  H Select HUD style. Although the styles are named after planes, each plane@ actualy displays many styles depending on the mode of operation.  
 .LI HUD.partsw .br   E The HUD has many components. This sub-menu allows you to choose whichhH are included in the HUD display. Selecting a HUD type will automatically3 adjust these to what is appropriate for that style.o   .LI HUD.options1 .brL  E This (and the next) selection allows you to set some parameters whichiF modify the appearance of the HUD. The most often used ones are in this& sub-menu and the rest are in the next.   .LI HUD.options2 .brW  % See description of "options 1" above.   
 .LI HUD.radarn .bre  3 This will configure the radar symbology on the HUD..   .LI HUD.ils  .bre  H Will let you select the ILS beacon. In the future there should be a more elaborate NAV facility instead.    .LI HUD.hdde .brL  D This menu is now changing as a new hdd (head down display) system is being implemented.   .LI HUD.help .brg  ( Display the full hud setup options list.   .H 3 "HUD.type Menu" .P  B Fly8 supports a number of HUD styles. The name of the hud does notF necessarily correspond with the plane type but this is what I found onC the various videos that I saw. If anybody has more knowledge or can 3 provide other detail PLEASE feel free to advice me.d   .VL 10 5   .LI HUD.type.Classic .bre  E This one I made up before seeing any real HUD. The basic data is laidtG close to the edge and leaved most of the area free from obstruction. MyfH original aiming reticule was 8 dots in a circle but I discontinued it inG favour or the more common piper style. The numerals on the pitch ladder"C do not rotate and the fast font is used. On a slow machine this hudeC (especially in low detail) will perform much faster that any other.    .LI HUD.type.FA18h .brd  H This HUD does not use tapes for the altitude and speed. The pitch ladderH is narrower than usual and slanted toward the horizon. A good feature isD the fact that the pitch ladder stays always in view: if the velocityA vector goes off the screen (easily done on the FA-18 which has noiF trouble flying at high AOAs) the pitch ladder adopts (temporarily) theC waterline mark. Another feature is the closure speed which is shownrC under the piper rather than on a radar ranging scale. Optionally, aqH pendulum (or what do you call it?) can be displayed which shows you yourF roll angle with good resolution up to 45 Degrees either way. This is a) wide angle hud - 20 degrees side to side.    .LI HUD.type.F16 .brs  F This HUD uses simple scales (no baseline). The heading scale can be at the top or at the bottom.    .LI HUD.type.F15 .brn  C This HUD is probably used for air to air on other planes. The speed C scale is upside-down. The heading scale can be set to two differentL positioned at the top.   .LI HUD.type.Ether .brn  # A new HUD type now being developed.    .LEe   .H 3 "HUD.parts Menu"a .P  A The various HUD symbols can be individually selected for display.f   .VL 10 5   .LI HUD.parts.ladder .brw  * Select pitch ladder (and related) options.   .LI HUD.parts.altitude .br    Show altitude scale (or box).e   .LI HUD.parts.speedv .br    Show speed scale (or box).   .LI HUD.parts.headinga .brw   Show heading scale.t   .LI HUD.parts.border .brL  $ Show the HUD border (in gray color).   .LI HUD.parts.vv .br   = Show the plane's velocity vector. A must for accurate flying.    .LI HUD.parts.vw .brp  H This activates a mode that the FA18 uses: when the vv goes off screen, aH waterline mark will appear and the pitch ladder will be drawn around it.E This way the ladder never goes completely off screen (which can often ! happen when flying at high AOAs).a   .LI HUD.parts.plus .br   / Show a 'plus' sign at the center of the screen..   .LI HUD.parts.pointers .brt  F Show a small (red) mark that tracks the joystick (or mouse or whatever pointing device you  use).   .LI HUD.parts.beta .br   - Show the sideslip angle (beta) on FA18 style.i   .LI HUD.parts.ground .brp  5 Brings up a menu of ground proximity related options.c   .LI HUD.parts.director .brh  G Show the flight director. This is part of the new ether HUD still underm development.   .LI HUD.parts.waypoint .brl  E Will show the target as a diamond along with a small pointer near therF FPM pointing at it. This small pointer represents a top view where the? small circle is the pointer base and the line from it marks theuF direction of the target. When ILS is active it is that point that will be tracked by these symbols.   .LI HUD.parts.tracers  .br   F This shows a 'string' hanginf off your boresight, which represents theG bullets position if you were firing. Horizontal marks indicate intervalrF of 1500 feet, and a small bead marks the target distance. This tool is1 useful for gun shots when the radar is shut down.    .LI HUD.parts.ghoste .br   C The Flight Path Marker is caged. A ghost FPM is shown if the cagingnG shifts the FPM by more than 1 degree. It looks like the FPM but withoutr the central circle.u   .LI HUD.parts.truehead .br   B The Heading scale is normally calibrated to show about 30 degrees.H However, you may prefer it to span directly correspond to the world viewF through the HUD. In this way, an object that is 10 degrees left of theC HUD center will really be indicated with a 10 degrees offset on thed< heading scale. This option is the default for the Ether HUD.   .LEh   .H 3 "HUD.parts.ladder menu" .P  E These options modify some aspects of the HUD appearance regarding the $ pitch ladder and associated symbols.   .VL 10 5   .LI HUD.parts.ladder.laddero .bri  ( Enables the display of the pitch ladder.   .LI HUD.parts.ladder.pinned  .bri  G In this mode the ladder it always attached to the HUD center (waterline> mark).   .LI HUD.parts.ladder.right .brn  E The numbers on the ladder steps are displayed only on the right wing.,   .LI HUD.parts.ladder.erect .br   F The numbers are displayed erected. The default will rotate the numbers with the ladder.   .LI HUD.parts.ladder.color .br   B In this mode the positive steps are blue and the negative are red.   .LI HUD.parts.ladder.funnele .br   G The step tips are displayed in the middle gap instead, which gives it a 
 funnel shape.e   .LI HUD.parts.ladder.slant .brt  D The steps are slanted rather than flat. The slant increases with the* pitch angle, reaching to about 45 degrees.   .LI HUD.parts.ladder.zeniths .br   G Will display a zenith/nadir marker. It is a small circle for the zenith 7 and a similar circle with a cross inside for the nadir.e   .LI HUD.parts.ladder.under .brb  @ The numerals are displayed under the step rather than beside it.   .LI HUD.parts.ladder.tip0u .bro  ? Specifies that you want a tip to be displayed on the zero pitch  (horizon) ladder step.   .LI HUD.parts.ladder.hold  .bri  E This is a temporary option that controls the behaviour of the programyG when the pitch is very high such that some standard calculations cannotoE be carried out. By default it freezes the heading and allows the rollt angle to vary.   .LI HUD.parts.ladder.h rolls .bre  A This controls another aspect of the behaviour as described in thehE previous option. It causes the roll angle to freeze while the headings' will continue to reflect your attitude.l   .LI HUD.parts.ladder.sun .brw  D Shows a sun symbol, a small white circle which stays on the HUD edgeH when the sun is out of sight. It actually follows the zenith rather thatE the real sun and is intended as an aid in recovering your situationalm
 awareness.   .LI HUD.parts.ladder.negtipc .bre  E This indicates that the step tips will always point toward the nadir. + The default is to point toward the horizon.s   .LI HUD.parts.ladder.sizes .br   > Brings up a menu for setting the sizes of the ladder features.   .LEl  " .H 3 "HUD.parts.ladder.sizes menu" .P  H These options specify the sizes of the pitch ladder parts. The size is aB relative number with a value from 0 (size zero) to 16384 (full HUDE width). A resize menu will come up which will allow you to modify thenF size using the '+' or '-' options (increase/decrease) or using the '='F option (you can then enter a new value). Use the '*' option to restoreF the value to what it was at the start (but when you exit this menu the new value is final).   .VL 10 5   .LI HUD.parts.ladder.sizes.gap .bri  0 The width of the gap in the middle of each step.   .LI HUD.parts.ladder.sizes.stepr .brt   The width of each ladder step.  " .LI HUD.parts.ladder.sizes.horizon .br   ' The size of the horizon step in flight.o   .LI HUD.parts.ladder.sizes.land  .bro  > The size of the horizon step when the landing gear is lowered.   .LI HUD.parts.ladder.sizes.tip .bri   The size of the step tip.     .LI HUD.parts.ladder.sizes.ndash .brg  > The number of dashes that make a single step (one side of it).   .LEu   .H 3 "HUD.parts.ground menu" .P  H These options modify some aspects of the HUD appearance regarding ground
 proximity.   .VL 10 5   .LI "HUD.parts.ground.gnd ptr" .bra  G The ground pointer is a marker that shows your bank (roll) angle. It ishE represented by an arrow-head which slides along a set of angle marks.u' The highest angle marked is 45 degrees.o   .LI HUD.parts.ground.Xbreakw .brh  H Show the X-break symbol if at risk of hitting the ground. This symbol isE a large, blinking, X symbol in the center of the HUD. If you get eveneB closer to impact then a PULL UP message will be flashed and a high pitch warning will sound.a   .LI HUD.parts.ground.Xvars .brt  D In this mode the X-break symbol starts with two angle-brackets (likeH \'> <' that get closer towards the HUD center as the impact gets nearer.- It then merges into a single X shaped symbol.n   .P  I The default mode always shows the X shaped symbol, regardless of the timec
 to impact.   .LI HUD.parts.ground.Xgrid .br   E Show the warning grid if at risk of hitting the ground. This is a redHH grid which will overlay the ground if you fly too low. This experimental? mode is attempting to assist you in regaining awareness of yours< situation when there are not enough groung features in view.   .LI HUD.parts.ground.pullupc .br(  H A pullup cue will be displayed. It indicated the dive angle at which youB will hit the ground in 5 seconds. When a bomb weapon is selected aG safety distance of 200 meters is set to protect you from the explosion.d   .P  H The pullup cue looks like an extra pitch ladder step (usually narrower), with upwards slanted tips.   .LEe   .H 3 "HUD.options1 Menu" .P  8 These options modify some aspects of the HUD appearance.   .VL 10 5   .LI HUD.options1.heading .brs  E The heading scale shows the planes heading. The numbers displayed areoE in the range 000-350 in increments of 10. This option selects betweenuG showing the full 3 digits or using an abbreviated form. The abbreviated F form will only show the top two digits (09 for 90 and 27 for 270). TheJ Classic HUD style will show the full number but without the leading zeros.   .LI HUD.options1.knots .br   F Internally all data is stored in meters. This option requests that allF numbers use knots/feet (as appropriate) instead. It is the default for the standard HUDs.   .LI HUD.options1.top .brt  F This will further modify the heading scale. The scale will show at theF top or at the bottom depending on this option. For the FA18 HUD style,C this option will cause a base-line to be drawn under the scale (theU' scale will stay at the top regardless).c   .LI HUD.options1.finec .br   F For some of the scales this option will show more detail. The standardH detail is to show a tick every 5 units. The fine detail will show a tick every two units.   .LI HUD.options1.xfine .bre  F This is a further refinement of the above 'fine' level and will show a tick for each scale unit.    .LI HUD.options1.big .bra  H [obsolete]The name is completely wrong. This option defines the style ofH the ticks on the scales (for some of the HUDs only). The usual way is toG have the ticks go from the base-line to the outside. In the 'big' styleiC the scale will be along the edge with the ticks towards the inside.s   .LI HUD.options1.scale .brr  G This defines the number of units along the scale. This affects only ther3 Classic HUD. The more units, the longer the scales.e   .LI HUD.options1.area. .bri  E The HUD has a fixed area (measured in field-of-view degrees). You cannF alter this size. Note that although the HUD size changes when you zoomA in/out, it still keeps the same FOV. This option defines how manyk@ degrees are from the center to the edge of the HUD (all HUDs are square).   .LI HUD.options1.cas .brl  F The speed show will be the 'calibrated airspeed' rather than the 'true@ airspeed'. A snall 'T' or 'C' will mark the type of speed shown.   .LEH   .H 3 "HUD.options2 Menu" .P  F These options modify some aspects of the HUD appearance. These are the less used options.   .VL 10 5   .LI "HUD.options2.a alarm" .brt  D Enable aural alarms. If you hate the GLIMIT beeps etc. then use this  option to turn these alarms off.   .LI "HUD.options2.v alarm" .brh  @ This will Enable/disable the visual alarms that show on the HUD.   .LI HUD.options2.panel .brr  G Request to show the panel HDD on the main window. This will show at thep) bottom right side as digital flight data.h   .LI HUD.options2.fonty .bro  < Select the font for the stroke characters used on the screen   .LI HUD.options2.fontsizef .bro  H Select the stroke font size. A size of 8 means 'use the default' and allH other sizes are relative to 8. The default is calculated from the screen resolution.p   .LE    .H 3 "HUD.radar Menu"d .P  @ The radar symbology on the HUD is controlled with these options.   .VL 10 5   .LI HUD.radar.corner .brl  D Radar target data can be at the bottom-left corner of the HUD or can follow the target designator.e   .LI HUD.radar.data .br    Request to show target data.   .LI HUD.radar.distance .brt  A Request to show target distance in intel mode (mainly used in thee radar/map modes).b   .LI HUD.radar.name .brT  G Request to show target type in intel mode (mainly used in the radar/mapr modes).b   .LI HUD.radar.accvects .br   C Show target acceleration vector as a hand inside the reticle piper.e   .LI HUD.radar.reticler .brp   Show aiming reticle piper.   .LI HUD.radar.target .brs   Show the target designator.s   .LI HUD.radar.ross .br   E Use Ross's method for the aiming reticle. This mode will show a smallhH box in front of the target where it is expected to be when a bullet hitsH it. If you aim the reticle at this box and shoot then you should hit the target.c   .LI HUD.radar.limitf .bre  H Unlike real HUDs, the radar symbols can be displayed all over the screenG rather that just inside the HUD area. 'limit' will specify which way it 
 should be.   .LI HUD.radar.thickb .brp  A This is an experimental option to draw the radar reticle thicker.d   .LI HUD.radar.hidetgt  .brp  E When active, if the TD box is under the reticle then it is not shown.i& This de-clutters the area of interest.   .LI HUD.radar.tpointer .brt  : If the target is off the HUD then a line is drawn from theC boresightpoint (the '+' at the view center) towards the target. ThetC distance to the target is shown digitally: this is the angle of the C target relative to the boresight direction: 180 means it is exactlyrH behind you, 90 means it is on your side (ANY side, right, left, above or@ below). It should be read as: if you turn so many degrees in theB direction of the pointer then you will have the target straight in front.   .LI HUD.radar.vpointer .bre  H This will modify the 'tpointer' such that the length of the pointer will$ vary with the target relative angle.   .LEw   .H 3 "HUD.hdd Menu"d .P  H Fly8 supports a number of HDD devices. This menu allows you to set these8 up with various options. It is still under construction.   .VL 10 5   .LI HUD.HDD.instrumentst .brd  G Show the instruments panel. This is a very basic (and rather useless byaH now) instruments depiction that will be overlayed at the bottom right of the main window.   .LI HUD.HDD.navi .brm  8 Request to display navogation info in the panel display.   .LI HUD.HDD.compasss .brr  G A compass will be added to the radar map display. See next options too.'   .LI HUD.HDD.square .bru  ! Selects a square or round compasse   .LI HUD.HDD.orthot .bre  ; Selects angled or orthogonal ticks around a square compass.p   .LE    .H 2 "Net Menu"g .P  8 For full details please refer to the networking chapter.   .VL 10 5   .LI Net.ping .brd  C find out who else is playing. A message is broadcasted and for each ) responding player a message is displayed.a   .LI Net.play .bro  + join another player's game (or all players)n   .LI Net.quit .br   G stop playing with a player. If there are more than one players then youU will be asked to choose.   .LI Net.messager .bra  H send a message to a player (or all). You will later be notified how longC it took the message to reach each player and return a notification.a   .LI Net.accept .brr  C accept a player's request to play with you. Used in response to theu Requesting message.r   .LI Net.declinen .brl  D decline a player's request to play with you. Used in response to the Requesting message.    .LI "Net.always accept"d .brs  * automatically accept any requests to play.   .LI "Net.always decline" .bro  + automatically decline any requests to play.b   .LI "Net.manual reply" .br   5 do not automatically respond to any requests to play.L   .LEs   .H 2 "Options Menu"    .VL 10 5   .LI Options.Version  .br   + show program version and compile date/time.e   .LI Options.Smokes .br   H set/clear smoke generation. Damaged planes and craters will smoke if the option is enabled.   .LI Options.Font .br   G show current stroke font. It is displayed if large on the center of thed screen.r   .LI Options.Colors .bri   Show the current palette setup.d   .LI Options.Modesr .brg  8 show current program modes setting (same as 'm' command)   .LI Options.Skyh .bru   paint blue sky in views.   .LI Options.Gravityt .bri  3 enable gravity (default). Will affect bullets path.t   .LI "Options.Play Blues" .bru  H [sound debug] No simulator is complete without it. Actually used to testG the sound generation logic which for now is operational only on the PC.g   .LI Options.Verbosen .brm  H Toggle verbose mode. Off by default. When using the menu system you willG not be shown the standard 'help' screens. Use the 'm' and 'uh' commandsdH to see the 'modes' and 'hud' help screens. The command line 'v' controls this option as well.   .LI "Options.Net Stats"m .bre  1 display network statistics (same as 'n' command).i   .LI "Options.Limited"  .brn  D Will limit the ammunition to the takeoff quantity. Normally you have limitless ammo.r   .LI "Options.No stall" .brt  @ This option reduced the effectiveness of a stall. Good for early	 practice.a   .LI "Options.Paused Msg" .br   E This option is ON by default. If set to OFF then the 'paused' messagehG (when issuing the 'p' command) will not display. This is nice for cleanb screen captures.   .LI "Options.win ident". .br   A This option is OFF by default. If set to ON then a window name ist* displayed at the top right corner of each.   .LEL   .H 2 "Auto Menu" .P  ? These options enable some augmentation systems which modify the  behaviour of some controls.d   .VL 10 5   .LI Auto.Flaps .br1  G Enables the flaps Control Augmentation System (CAS). This will give youeD better turn performance by adding flaps (or leading edge flaps) when needed).   .LI Auto.Elevators .brt  G This will enable the CAS which limits the Elevators sensitivity at higheG speed to avoid excessive load. A Stability Augmentation System (SAS) is.@ being added which will improve dynamic pitch stability by taking" some authority over the elevators.   .LI Auto.Rudder  .brL  9 Enable the rudder SAS and CAS. It is not yet implemented.w   .LEh   .H 2 "Debug Menu"    .VL 10 5   .LI Debug.debuge .brr  G Enable the general debug mode. Some programs will display internal datas? when in this mode. This changes a lot and cannot be documented.n   .LI "Debug.gp w" .br   G General purpose debug option W is controlled by this option. It is usedmH for debugging and cannot be documented here, see if there is anything in the readme.l   .LI "Debug.gp x" .br    As above for option X.   .LI "Debug.gp y" .bra   As above for option Y.   .LI "Debug.gp z" .bre   As above for option Z.   .LEh   .H 2 "Buttons Menu"  .P  H The Buttons on your pointer (mouse, joystick etc.) are recognized by theH pointer driver and reported back to Fly8. It is now up to the program toH react to the button status. If a button press command is associated withH a key then it will be issued when the button press status is recognized.H If the button was set to release mode then when you release the button a command may be sent too.   .P  D You use this menu to define the modes that a button responds to. TheC actual command associated with a button press/release is defined byI# including, in fly.max, a line like:    .P .ti 5a \fCDef Btn 0 F1\fP   .P  C This will cause button 0 (the first button) to issue the F1 (weaponh fire) command. Another example:2   .P .ti 5  \fCDef Btn 1 +\fPh .ti 5  \fCDef Brl 1 +\fPd   .P  F This will cause a '+' (speed brake on/off) to be issued when you pressH button 1, then another '+' when it is released. This way the speed brake" is active while you hold button 1.   .P  F If you want the same key to have a different command depending of yourE game mode then you can use the virtual 'button shift modes' provided. D The buttons are considered to be sensitive to the status of the Alt,E Ctrl, Shift and Special buttons (which do not exist on any input). If5? the Btn-Alt is set then pressing button 1 will be recognized as 5 Btn-Alt-1 and will respond to a line in fly.max like:    .P .ti 5  \fCDef Btn Alt 1 r\fPb   .P  C to turn the radar on/off. The only way to set these button modes is E through this buttons menu. However, you can program any hot key to dooH this for you. You can program Alt-S as your button Shift key in fly.max:   .P .ti 5 7 \fCDef Alt S M s		# Now Alt-S toggles Btn-Shift mode\fPs   .P  C This allows the buttons to have 16 diffrerent modes which should beeC enough, however, by default, the buttons do NOT respond to the mode 4 state. To make a button sensitive you use this menu.   .P  H All joysticks have 2 buttons, Thrustmaster FCS and CHPro have 4 (use theE ":four" option in this case) and also the hat is decoded as four moreoG buttons. Mice may have more buttons and some drivers will recognize thetG common three. When using a Thrustmaster WCS of FLCS you may program allrG the buttons to be handled through the keyboard, in which case there aretC NO buttons directly visible (use the ":zero" pointer option in thisu case).   .P  B The first thing you will see is a request to name the button to beF customized. The buttons are named with a single alphanumeric characterE (so a maximum of 36 buttons can be handled by Fly8). Then you will bee" presented with the following menu.   .VL 10 5   .LI Buttons.Altt .br   G Will set the Button Alt mode sensitivity. By default all buttons ignoreeG this mode, the pointer option a=... can nominate buttons that should bei sesitive to this mode.   .LI Buttons.Ctrl .brv  H Will set the Button Ctrl mode sensitivity. By default all buttons ignoreG this mode, the pointer option c=... can nominate buttons that should bee sesitive to this mode.   .LI Buttons.Shift  .brt  B Will set the Button Shift mode sensitivity. By default all buttonsD ignore this mode, the pointer option s=... can nominate buttons that  should be sesitive to this mode.   .LI Buttons.sPecialt .brt  D Will set the Button Special mode sensitivity. By default all buttonsD ignore this mode, the pointer option p=... can nominate buttons that  should be sesitive to this mode.   .LI Buttons.Debounce .brD  F Set the debounce mode. When ON, a button press will activate a commandE once, until released and pressed again. When OFF, the command will beeD repeatedly issued as long as the button is pressed (once per frame).   .P  B By default all buttons are debounced. The pointer option d=... can. nominate buttons that should NOT be debounced.   .LI Buttons.Releasee .brt  F When ON, this option will enable issuing button release commands. When0 OFF the button release will not issue a command.   .P  C By default all buttons recognize release events. The pointer option G r=... can nominate buttons that should NOT recognize release. [but I am   not sure what it is useful for].   .LI Buttons.Cleare .br   D Will clear all modes sensitivity for the button. Note that this willE include the Debounce and Release modes which are normally ON. You use B the Clear option when you wish to directly set a button to a knownE state, like: "x d r s" will set this button for Debounce, Release andg Shift sensitivity.   .LI Buttons.Cancel .br.  1 Will exit without changing the button definition.s   .LEr   .H 2 "Commands Menu" .P  H Some simple commands toggle between options. This makes it impossible toE use a macro for setting these commands to a pre-determined state. TheeE commands menu allows you to do just so. Select 'On', Off' or 'Toggle'sG then hit another command. Now it will follow the earlier setting ratheru$ than the default 'Toggle' behaviour.   .H 1 "Command Line Editing"  .P  B When a command needs to receive a parameter which is more than oneE keystroke it uses a line input facility. It allows you to use history F and editing. You can use the arrow keys and insert/delete keys to moveE about and edit your response. The up/down keys will retrieve history.bB Finally you will need to press Enter for the program to accept theH input. If you key the start of a line and hit PgUp then a search will be2 done for a previous entry with the same beginning.   .P  D The history queue has 20 entries, all input requests share this same queue.   .H 1 "Aural Indicators"h .P  K Sound is used to inform and warn. The sounds at the moment are simple tones  or tone sequences.   .P   A short beep will sound when:n   .DL 5i   .LIa   you fire a weaponl   .LIh  $ you hit a target, or a plane crashes   .LId  # the radar locks onto a (new) targeti   .LIa   a menu selection is invalide   .LEl   .P   A low beep will sound when:y   .DL 5C   .LIL   landinge   .LI   
 taking off   .LIe   landing gear status is changed   .LEu   .P   Two repeating tones for:   .DL 5    .LIs  % Emergency alarm (pull-up, eject etc.)o   .LIe  # Warning alarm (stall, g-limit etc.)m   .LEn   .P   Repeating scales when:   .DL 5L   .LIo   target practice has endeda   .LEr   .H 1 "Visual Indicators" .P  G These are highlighted words flashed onto the HUD. They vary in size andk blink rate..   .VL 15 5   .LI WAIT  F You ejected and landed but your plane did not yet crash. This one doesC not relate to the HUD, all the others only show when the HUD is on.u  	 .LI STALL   E You are flying the plane too slow to maintain lift or you are turningh* too sharply at a too high angle of attack.  
 .LI GLIMIT  F You exceeded the maximum acceptable G force of your body (+9G to -3G),. or you exceeded the 10G plane structure limit.   .LI FUEL  G You have less than 10% fuel left. The less fuel you have the faster the") message blinks, then it finally stays on.i  
 .LI "PULL UP"m  < You are about to hit the ground unless you pull the plane upF immediately. If the danger is higher then a red ground grid is flashedD to give the pilot better orientation (there is not enough scenery to build proper visual awareness).   	 .LI EJECTs  6 The plane is damaged beyond control. Shift-E to eject.   .LEs   .H 1 "The Plane" .P  G This chapter explains in detail how planes are handled in this program.d   .P  G The plane is controlled by your pointing device, preferably a joystick. 2 The basic controls will have the following effect:   .P  H Left/right controls will cause the plane to roll. The roll will continueA while the controls are engaged. When the joystick is centered theSF rolling will stop and the plane will stay in the current situation. IfF you want to fly level after rolling to the right then you will have to do the following:n   .DL 5t   .LIb  ( roll right (the horizon will roll left).   .LIt  6 stop rolling (the horizon will stay at a fixed angle).   .LI   . roll left (horizon rolling back to the right).   .LID  ) stop rolling (when the horizon is level).    .LEb   .P  E As the plane has momentum, the response is not immediate and you will  have to get a feel for it.   .P  D To start climbing you will pull the stick toward you until the climbA angle is what you want and then release the stick. The plane willsG continue climbing until you push the nose down for level flight. If youuD are rolled over to one side then the pulling will cause the plane toG turn into that side. If you are upside-down and you pull the stick thenoA you will start descending towards the ground. In other words: thepG up/down controls (elevators) are used for any change of direction, bothf left/right and up/down.l   .P  F To turn right, first roll right, then pull the stick until the desiredE heading is reached, then release the elevators and roll back to leveloB flight. Of course, due to gravity and plane dynamics any change inF situation will probably cause the plane to move in a direction slighly> different from what the controls suggest - you should learn toC compensate for this. The flight-path-marker (the little circle with D three wings) tells you where the plane is heading and this is hardly2 ever the direction where your plane is pointed at.   .P  B To control your engine you set the throttle with the 9/3 keys. TheC throttle can be set to between -100% and 100%. Reverse setting only H works on the ground. Each keystroke is 5% change. The 1 key will set theC throttle to 100% and the 0 key to 0%. The planes speed will pick up D slowly (depends on the planes weight and the engines power). You canF engage the after-burner with the '.' key. To slow down you may use the speed brakes ('+' key).n   .P  C About the AfterBurner: light it with '.' (will also set throttle toyA 100%). Then each '.' or '3' (power-up) will add a notch. Each '9'tE (power-down) will take it down a notch. There are five steps (say 20% D each). The throttle display will show '103' for '100% + AB3', 105 isH full AB. The engine display will show thrust in % of mil thrust (full ABG is about 150%-160%). If you use '1' (max throttle) or '0' (idle engine) F the ab is turned off. NOTE that AB5 uses about 6 times as much fuel as MIL for 60% extra power!   .P  F Note that with the PC keyboard and the NumLock engaged, the above keys appear in a logical order.   .P  G The Classic plane is an over-simplified vehicle. It has no momentum andhD no aerodynamics characteristics, it goes where you point it and is aD good way to get the hang of the controls. It will never crash eitherG (you can fly underground of course). But don't get too used to it, realsE planes handle very differently (the Classic is more like a weightlessd spaceship of an arcade-game).r   .H 1 "The Head Up Display" .P  F The program displays a number of HUD styles. These are named accordingH to a plane type but this is just because I first saw this HUD on a videoG tape dedicated to that plane. In reality each plane has a number of HUDtF modes. You can change the HUD style through the hud menu regardless of the plane type.e   .P  F The HUD is a piece of glass that is positioned at an angle in front ofD the pilot. The pilot looks through it to see the front view from theC cockpit and at the same time a reflection of a video screen is seen H (this CRT is in the 'dashboard' facing up). The dual-image is similar toF when one looks outside through a window at night and sees a reflection? of some part of the room as well as the outside. The HUD can beeF displayed by itself on one of the auxiliary HDDs (sometimes refered toB as the 'HUD repeater'), which is useful when the HUD optics is not operational (damaged).   .P  H In practice, the HUD is a flat image superimposed on the front view, andH it uses a special (usually green but you can change this) color. It does! not cover the full field-of-view.e   .P  G The image projected onto the HUD contains two kinds of information. OneoC type is data that the pilot will otherwise have to look for in somebH cockpit instruments (thus taking his eye off the outside scene); this isF simply a way of putting the most important information if front of theB pilot. An example is the display of plane speed. The other kind isF information directly related to the outside image and meaningfull onlyH in relation to it, for example: a bounding box is displayed such that it< coincides with a visible target that the radar is locked on.   .P  B The prominent features on the HUD are a number of scales which areH usually diaplayed along the edge. Sometimes the detail of the scales can? be controlled in three levels through the Hud menu (see there).    .P  B The HUD symbols will relate to flight data or to auxiliary systemsH (weapons, radar, fuel etc.). The data related to the flying of the plane is described first.    .H 2 "Heading" .P  F Your compass. It will be shown as a horizontal ruler that moves as youH turn. The current heading is marked with a 'tick' or a 'V'. It can be atF the top or at the bottom of the HUD (Top option in Hud menu). North isF 360, South is 180, East is 90 and West 270. Some modes do not show theB trailing zero (270 is shown as 27) and NO, there is no support for radians or other units...u   .H 2 "Altitude"n .P  F Your height above sea level, a vertical ruler at the right edge of theD HUD. It may be accompanied by a second bar (immediately to its left)D that shows your climb/fall rate. This ruler moves up and down as theD plane moves, the current altitude is to be read at the 'tick' in itsH middle. High altitudes show in thousands (with a possible decimal point)F while low ones will show exact. The FA-18 style HUD shows the altitudeH in a box at the right side of the HUD with the climb rate above it. SomeG HUDs will show a radar-range scale adjacent to (and to the left of) theoG altitude scale. This will indicate the distance to the target (the fullaG scale range is shown just above this scale) as a sliding tick while the . target closure speed is shown inside the tick.   .P  - Climb rate is in meters (or feet) per minute!    .H 2 "Speed" .P  H Your speed is shown as a ruler at the left edge of the HUD, a tick marksE the current value. The FA-18 style HUD shows it in the left box. SomecG HUDs do not show the trailing zero while others show have the scale run  from top to bottom.:   .P  F This information may be in meters/kmh of feet/knots (use the Hud Knots7 command to toggle). The F16/FA18 default to feet/knots.H   .H 2 "Pitch ladder"n .P  H The orientation of the plane is displayed as a ladder, each step relatesH to a different pitch. The steps are always parallel to the horizon. EachE step is marked with a number which is your pitch angle (90 degrees iseG straight up, -90 is down and zero is level). The step's angle represent H the planes roll. When you are upside-down the steps are too, as you roll= the steps turn in the opposite way to follow the horizon. ThetC negative-pitch steps (when you are going down) are dashed while theeF positive ones are solid. Small winglets at the tips of the steps pointF toward the ground. The zero-pitch step is larger and is your artificalG horizon if you cannot see the real one. The FA-18 style HUD tries a bitiH harder by bending the steps toward the ground: the higher your pitch theF larger the slant. It also shows a small circle at the straight up/down1 directions (the down one has a cross through it).    .P  G Although the pitch ladder follows the horizon (meaning the zero-step isiF on the horizon) there is some freedom in where on the horizon  to showD it. Unless you disable the velocity vector (flight path) marker (seeD below), the ladder will be centered on it. This means that at a highE angle of attack the pitch ladder may be out of view (as will the vv).    .P  D In the case of the FA18, if the vv goes out of view then a waterlineH marker will appear at the center of the HUD (it is a W marker in a fixedH position) and the ladder will shift (smoothly) toward it. Once the vv isE back in view the ladder will return to it and the waterline mark willxD disappear (the transitions take about two seconds maximum). The FA18D ladder shows an extra-long zero-step while the landing gear is down.   .H 2 "Velocity Vector" .P  B A plane rarely moves straight ahead due to gravity and aerodynamicC forces. This marker (sometimes called the 'plane symbol') is a tinyeG circle with wings on either side and at the top (it is a stylized shapesE of a plane from behind). At any time, this marker shows you where theo@ plane is heading. You will most of the time use this marker as aH reference for flying the plane. The center of the view is rather uselessH for flying (you can bring up a cross-hair with the 'u+' command) but canG be helpful in aiming the cannon (in the absence of the aiming reticle).f   .P  M The Classic plane always goes ahead, so the vv will be fixed at the center ofk8 the HUD. By default it will not be shown for this plane.   .H 2 "Waterline mark"  .P  F This is a 'W' that shows in the straight ahead point on the front view@ (this is not always the physical center of the HUD). It comes onE whenever the landing gear is lowered. The FA-18 HUD shows it wheneverp' the Velocity Vector is outside the HUD.t   .H 2 "Radar Symbology" .P  C When the radar is active, some symbols related to its operation areeB displayed. The main features are the target designator box and the aiming reticle (the Piper).i   .H 3 "Target designator" .P  E This is a square that is centered on the target. If the target is notgH locked then the box will have only corners. The target should be visibleG inside the box, unless it is off screen. When off screen, the box has an@ \'+' through it and it crawls along the HUD edge showing you theG direction where the target is. If the target is actualy behind you then+  the '+' is replaced with an 'X'.   .H 3 "Aiming Reticle"( .P  H If a target is close enough (within weapon range) then an aiming reticleF appears.  The reticle is a circle with 12 ticks. Each tick represent aG distance of 1000 to the target and the range is marked with a tick thatBH moves along the inside edge of the reticle. A tick at 11 o'clock means aF distance of 11,000 etc. You should fly the plane so that the center ofF the reticle (has a dot) is on the target and then shoot (actually, theE cannon/radar computer will display 'shoot' above the reticle when youeD have a good aim). If this sounds simple it is because it is a simpleH procedure; the problem is that in order to get the target in the reticleD you will NOT be flying the plane directly toward it. In practice you9 forget about where the plane should go and play a game ofwE follow-the-target with the reticle (just try and not hit the ground).g   .P  E The F16 will also show a 'hand' inside the circle which indicates theiD direction and magnitude of the target acceleration (this one is veryG jiterry at times). You can turn this hand on/off with the Hud menu "accm vect" command.   .P  H The FA18 HUD shows the closure speed outside the lower right side of theH reticle. The F15/F16 shows the same information on the radar range scaleG (beside the altitude) marked with a large '>' symbol. The closure speedyA measures how fast you are catching up (positive) with the target.a   .P  E However, in order to complicate the situation we have some variationsr	 possible:k   .P  G There is an alternate piper: Ross's reticle. This is a different aiming B method altogether. A square reticle is shown with only the cornersA visible. It is ahead of your target at all times on its projectedmH position. You have to aim the piper at the box and then shoot. With thisC one you do not care where the real target is because the aiming box G replaces it. The piper will be fixed at the center of the HUD.  You mayg1 want to turn off the target designator with 'ut'.s   .P  E The target designator and aiming reticle are part of the HUD display,nD however you may choose to ignore this and request that these use theG full screen. Use the 'uL' command to limit these to inside the hud arean or use the whole screen.   .H 3 "Radar Range" .P  C The radar measures the distance and relative (closure) speed of theoE target. The range is shown as an extra scale on the right side on therH HUD while the closure speed is shown beside the '>' mark on it. The FA18H HUD does not show this scale but shows the closure speed under the piper with a 'Vc' mark.r   .H 3 "Digital data"p .P  H When a target is selected, some digital information may be displayed (itC can be disabled by the hud/radar menu). This data shows at the left 5 bottom corner of the HUD and has the following items:n   .DL 5e   .LIi  2 distance to target (units or k's with one decimal)   .LIl   closure speed (meters/knots)   .LI   ( time to meet (seconds with one decimal).   .LI    target type or pilot names   .LE,   .P  C When the target is in range the time shown is bullet time-to-impact  rather than plane flight time.   .P  H If the Corner option is not selected (uC) then this data will show underH the target designator box. If the target is too close to the bottom then the data may show above it.o   .P  E If you activate the Intel mode (i) then all visible targets get a boxsJ with the following data (the MAP and RADAR diplays always have this mode):   .DL 5    .LI   2 distance to target (units or k's with one decimal)   .LIv   target type or pilot name    .LEr   .P  ; You can use 'un' to disable the display of the second line.t   .P   .H 2 "Other Features"u .P  B In addition to the above features, the HUD may show the following:   .P  G The FA18 type HUD shows as standard, on the left low edge, the angle ofnG attack (aoa), the mach number and the pilot's vertical Gs. The selectedtG weapon (and available units) is displayed at the low center of the HUD.h   .P  H The F15/F16 HUD shows the aoa at the top right above the altitude scale.E The weapon selected is shown at the top of the data list ('XXX' meanse none selected)   .H 1 "The ILS" .P  D The Instrument Landing System (ILS) is a system that provides enoughH information about your approach to guide you to the touchdown point withA great accuracy. The system comprises two separate facilities: thehG Localizer beam which tells you how well you are aligned with the runwayuA and the Glide Path beam which monitors your descent rate. The two B components measure your approach error and display it as two bars.   .P  E The Localizer deviation bar is a vertical line that moves accross theeF HUD and indicates which way of the correct line you are. If the bar is? left of center then this means that you are to the right of theiI Localizer beam, so you should correct your approach to the left. When the F bar is right of center you will need to move to the right too. You areH correctly aligned when the bar is at the center. You can judge the bar'sD position by noting the number of ticks along the horizontal bar. TheH larger middle one is where you want to be. The bar is at full deflection when your error is 2.5 degrees.e   .P  F The Glide Path deviation bar is a horizontal line that indicates whereE the correct descent line is. If the line is above center then the yougH should be flying higher (your descent is too rapid or you are descendingF toward a point on the ground too short of the runway); you should gainH some height or reduce your descent angle. In the same way, when the lineF is below HUD center you are above the correct path. The bar is at full+ deflection when your error is 0.75 degrees.    .P  E Note that the ILS system does not know where you are heading, it justtD tells you how close you are to the correct approach path. The systemD does not even know if you are coming or going! So make sure that youG approach the runway from the correct end or the ILS Localizer deviation H bar will show reverse reading and the Glide Path will direct you to land at the far end of the runway.    .P  F Real ILS systems have very narrow beams and will only operate when youG are reasonably aligned. These systems will tell you when you are out oftG range. The one in Fly8 is active within a radius of about 25 kilometers  around the runway.   .P  F When the ILS is operating a marker along the heading scale will directE you to the airport; use it for the general approach but then identify  the correct runway carefully.    .P  G To select the desired runway use the ILS menu and choose from the list.rG There are now two airports (A is home and B is for the drones) and eachnG has two runways: 18 (approach at heading 180) and 27 (approach at 270).iC You can turn the ILS off and it will still remember the last active F runway which will be offered when you use the command again. These ILSE aids are defined in fly.nav and you can change these. The 'H' commandrG option is used to designate your home runway, otherwise it is the firstt6 one defined (the drones use the last one in the list).   .H 1 "Radar and targets" .P  D The radar in this program does NOT try to simulate a real radar. TheF real thing has many types and modes of operation. This one just cheats to get its data.   .P  F When enabled ('r') the radar measures distance, direction and speed of possible targets.H   .P  H In the basic mode, the radar constantly selects the closest target. ThisG may cause it to 'jump' between targets as they change distance. You can"D put the radar in 'locked' mode ('l') which will make it stick to theF selected target. In this mode, when a target is destroyed, the nearestH target will be selected and stay locked. Use 'l' to release the lock (or) you can turn the radar off/on with 'rr').I   .P  B There are 3 other acquisition modes controlled by the 'f' command.   .VL 10 5   .LI 0n  2 pick closest target (old way, as described above).   .LI 1   B 3.3deg circle: boresight. Only targets inside the small circle are	 detected.o   .LI 2h  H 20deg circle: HUD. Any target inside the large circle (which covers most of the HUD area) is detected.t   .LI 3P  C 5.3deg wide by 60deg high: vertical. Targets inside the narrow bandt6 (+-5.3 degrees wide but 60 degrees tall) are detected.   .LEk   .P  F In modes 1-3, a target is highlighted when it is within the designated7 area. The limits of the modes 1-3 are drawn on the HUD.k   .P  = If you are in locked mode then the first detected target willeE immediately be locked, otherwise you will have to hit 'l' to lock theeC highlighted target. Only when a target is locked you get the aimingo  reticle (if it is close enough).   .P  G It should be made clear that the 'locked' mode is set/reset by you withlB the 'l' command. Once engaged, there is no need to lock on targetsF because the first one to qualify will immediately be locked on. If youE want then to select another target then use 'l' to release the targetr* and then later 'l' to lock on the new one.   .P  G Once a target is locked, the selection markings disappear and the piperiH shows (or if it is still far then only the target designator box shows).   .P  D A target is identified with a box around it (the target designator).H When the target is out of view the box has a large '+' crossing it which> changes to a large 'X' when the target is actually behind you.   .P  H If you issue Shift-C then the plane will chase the current target (thereD must be one or the plane will just patrol round the runway). Use theH \'k' command to allow automatic firing ('k' works even when not in ChaseA mode, and is useful if you want to practice the chase and let the: auto-pilot do the shooting).   .P  9 When the reticle goes off-screen it gets a '+' inside it.n   .P  E You can shoot at various objects. Use the 'emit' menu to create thesee objects.   .P  C When you hit something it gets damaged and fragments fall off. WhenoG enough damage is done the object is officially HIT. It blinks red/whiteTD and starts falling toward the ground. Practice targets are destroyedE immediately. These fragments are lethal and can hit any other object! G Normally you can fly through any object EXCEPT a bullet - so don't staytA behind a broken plane or you may be hit by the falling fragments.'   .H 1 "Networking"t .P  H As others said before, playing with oneself is fun but you don't make as- many friends (they said you'll go blind too).e   .P  < The program will let you play with others using a variety ofC communication media. Once networked, objects are shared between thedG players. The number of players is only limited by the capability of thee network medium.d   .P  F Below here, numeric parameter values can be given in C format, i.e. ifH it starts with 0x it is hex, starts with 0 is octal, else it is decimal.  
 .H 2 msdos   .H 3 seriald .P  E At the bottom of the pile is the PC to PC serial connection. Only twonE players can combine in this way. You can choose two drivers for this:)   .P   .ti 5s6 \fCdncom.N:baud:parity:bits:stop:xmode:inbuf:outbuf\fP   .P  C Direct control over the com port. It can handle any speed, but slowhE machines will drop charaters if you go too fast. Slow machines shouldh NOT use output buffering.    .P   Positional parameters:   .VL 15 5   .LI Nn   com port number: 1...4   .LI baud   the line speed, up to 115200.   
 .LI parity  	 e, o or nn   .LI bits   8o   .LI stop   1P  	 .LI xmodet   xon or xoff; do not specify!  	 .LI inbufg   4000 is enough. experiment.i  
 .LI outbuf  B very little needed if at all. Very fast machines will benefit fromF output buffering, slow ones will choke unless the baud rate is low. AtF 115200 most machines cannot cope with output buffering. My 486/66 gets/ a major speedup with output buffering at 38400.u   .LE    .P  > Other parameters can follow, the parameter name MUST BE GIVEN:   .VL 15 5   .LI irqN   irq number (use 4/3 as usual)e   .LI baseNNNo  0 port hardware address (use 0x3f8/0x2f8 as usual)   .LEG   .P   Example:   .P   .ti 5i0 \fCdncom.2:115200:n:8:1::4000::irq3:base0x2f8\fP   .P  9 Note that no 'xmode' was given and no 'output buffering'.e   .P  7 If you prefer, you can use SLIP when you have SLIP8250:t   .P   .in 5X   .nfn0 \fCslip8250 0x65 -h SLIP 3 0x02f8 38400 10000\fP \fCfly8 r dnslip.1:int=0x65\fP   .fie .in 0p   .P   This is the same asb   .P   .ti 5c \fCfly8 r dnslip.1\fPo   .P  - because the driver will then be searched for.s   .P  E Slip is not too fast, you need both machines to be at least 386DX for > full speed and even then it is touch and go. It does no output
 buffering.   .H 3 network-based .P  F If you have a 'real' network then install your favourite packet driver and do   .P   .ti 5s \fCfly8 r dnpkt.1:pack=1408\fP   .P  H In this mode you can have as many players as you wish. The program talksH packet level. You can also use the EtherSlip driver to play head to head> with this driver, however direct com access is more efficient.   .P  H If you are runnning a unix system with the fly8udp server on it then you@ can use the msdos udp over packet driver. This will allow you toG join the other unix players. The unix server MUST be on the smae subneta for this driver to work.   .ti 5o= \fCfly8 r dnpcudp.1:pack=1408:ip=0xc0000203:sip=0xc0000204\fPe   .P  G Note how you must give your own ip (ip=) and the server ip (sip=). YoureD own ip can be anything but your sysadmin must allocate it, while theC server ip is the actual ip for the host that is running the fly8udpe server.   	 .H 2 unixt  	 .H 3 FIFOd .P  E The FIFO driver will allow communication using FIFOs as well as a ttyt serial line.   .P  E This driver provides a head-to-head capability through FIFOs or otherhC similar  steam oriented facility. For one, it will allow connecting = through a serial port (or other '/dev/tty' type connections).    .P  H Basically, you nominate an input file (if=) and an output file (of=) andD Fly8 will use these. For example, this is how you start a two player  head-to-head on a pair of FIFOs:   .P .ti 5L9 \fCfly8 r N1 Tone dnfifo.1:if=ff81:of=ff82:pack L1.log\fPh .ti 5 9 \fCfly8 r N2 Tone dnfifo.1:if=ff82:of=ff81:pack L2.log\fP    .P   The two fifos can be created aso   .P .ti 5i \fCmkfifo ff81\fPn   .P   or asn   .P .ti 5  \fC/usr/etc/mknod ff81 p\fPh   .P  K Note that the two programs run with different user names (N*) but share themC same team (T*). This means that they cannot fight each other. Use ar  different team name for dueling.   .P  H Also note that a different log file is used by each (L*). This is needed) only if both run from the same directory.    .P  A To play accross a serial line, simply start this on both machineso   .P .ti 5s9 \fCfly8 r N1 Tone dnfifo.1:if=/dev/ttyS1:of=/dev/ttyS1\fPw   .P  G /dev/ttyS1 is the serial line connection name on this end. You will useS@ a different user name (and maybe team name) on the two ends too.   .P  ; You will first need to set the serial line up, for example:n   .P .ti 5 . \fCstty speed 38400 raw crtscts </dev/ttyS1\fP   .P  E This setup can connect to the msdos serial driver. On msdos use thesee parameters:    .P .ti 5o3 \fCfly8 r N2 Tone dncom.2:38400:n:8:1::4000:4000\fPh   .P  * This will use com2 (use 'com.1' for com1).   .H 3 UDP-level .P  G This driver is based on a server (fly8udp) program to which each playersB connects. The server will re-distribute all messages as necessary.   .P  " The order of events is as follows:   .P   Start the server:r   .P .ti 5l \fCfly8udp &\fPs   .P  F Put the host name where the server runs in the fly.ini parameter. Here? is an example for when the server is running on the local host:i   .P .ti 5e \fCr\fPd .ti 5.! \fCdnudp.1:localhost:pack=1408\fPt   .P  3 The 'r' will enable the Fly8 networking in general.U   .P  F The ':pack' option tells Fly8 to collect multiple logical packets into; one physical packet, please always use it with this driver.    .P  G The above option can be put on the command line too, have a look at thee sample script 'flyudp'.r   .P  G Now start Fly8 as usuall. Once running, check to see who is attached to F the server with the ping request 'Esc n p' command. If someone repliesF then you can connect with the play request 'Esc n y'; answer '*' (all)( to the prompt or select a specific user.   .P  E Note that if you do not talk to the server for 10 seconds you will bedF purged from it's table. This means that if you are the first user thenE you will not be able to keep your registration, the first two playersi: need to connect (both) within this 10 seconds time window.   .P  ; To control the server use the 'udpmgr' program. Start it asi   .P .ti 5  \fCudpmgr localhost\fP   .P  B where 'localhost' is the default host where the server is running,B subtitute the correct name otherwise. Use this command to shut the server down:   .P .ti 5, \fCshutdown\fP   .P  C and use this to stop the manager itself (if it does not drop out byc itself at this point)e   .P .ti 5n	 \fCend\fPt   .P  3 You can request the server to print it's stats witho   .P .ti 5  \fCstats\fP    .P  
 .H 2 usage .P  I OK, you started the program with networking. It really enjoys it but thenrI it is a computer. You want to enjoy it too. Here is how. The Net menu hasdC a set of commands for managing your connections with other players.t   .P  G Some of the requests in this menu will need you to identify a player. AhH list of players is displayed and you should select one by entering theirE name. If you Enter '*' then you will select all of them. If you Enter G \'+' then you will select all of your team members. If your response isiE null then you select none. If there is only one player then it wil be F selected automatically. Otherwise, you can enter the start of the name: and team so that the first partial match will be selected.   .P  E A message 'no net' means that the program was started without the nete: option (or possibly all net connections are inaccessible).   .P  D A message 'no player' may be displayed which means that there are noC players in the needed status (eg. you try to 'quit' but you are noti currently playing with anyone).t   .VL 10 5   .LI ping .bra  H This is a broadcast ping to all players. All other programs will respondH with their identification. Now you know who is active on the net. How doG you tell who's who? the parameter -Nxxx supplies your handle (nickname,r/ etc.) and you will be known by it in this game.    .LI play .br(  B Request to play with another player. If there is only one then theE program will go ahead and establish connection. Otherwise you will beoE prompted to select a player from a list. To have the program know whol4 is playing you should have used the P command first.   .LI quit .br   C Quit playing. If there are more players then you will get a list toiH choose from. An empty response will assume you want to quit all players.   .LI messaged .br   H Send a message to a player. Right now, an echo message will also be sentG and the turnaround trip time (in milliseconds) will be shown. This timeP& is end-to-end including program delay.   .LEo   .P  G In addition to the above commands which you will use from time to time,pG there are a number of options on this menu which you may want to set ath9 program startup (or wish to continue to handle manually).l   .VL 10 5   .LI "accept" .brn  B If you are in 'manual reply' mode then you will get messages aboutB players who want to play with you. Use this option to accept them.  
 .LI "decline"o .brx  B If you are in 'manual reply' mode then you will get messages aboutC players who want to play with you. Use this option to decline theire request.   .LI "auto accept"l .bre  / Set the game to always accepy playing requests.0   .LI "auto delcine" .brw  0 Set the game to always decline playing requests.   .LI "manual reply" .br3  > Set the program to ask you to accept/decline playing requests.   .LI "auto connect" .br   L This option will attempt to connect to all net players continuously. It willC also accept all play requests automatically. If you plan to use anyPH communication then it is a good idea to always enable this option - just' add it to the startup macro in fly.max.    .LEn   .P  D When you exit the program it will automatically quit all players and notify the net of your exit.   .P  D If long delays are observed then a player may be automatically timedA out. You will see messages about this. Use 'play' to re-establishlF contact. Proper use of 'quit' and 'play' will let you pop out of sight7 in danger and re-join in a more favourable position :-)e   .P   .in 5  .ll -5  H IMPORTANT NOTE: the comms at this point is one-on-one. If you connect toD three other players then they all show in your world and you show in> their but they do not know of each other unless they establishB connections too. If a group plays and each one joins with a global4 \'play' then everyone will know about everyone else.   .in 0E .ll +5   .P  A There is a need for proper 'game' management (co-ordination), nows completely lacking.P  
 .H 1 Files   .H 2 fly.ini .P  = This file serves as an extension to the command line options. C The command-line option 'I' can set a user selected file name, thisr# option MUST be on the command line.e   .P  , Fly8 acquires parameters from three sources:   .P   .VL 10 5   .LI "The ini file" .br0  D One parameter per line. Leading blanks are skipped, then first blank5 terminates the parameter. '#' denotes a comment line.a   .P  N The file is searched for in the current directory, then in your home directoryA (using the HOME variable) then in each directory along your PATH.O  # .LI "The environment variable FLY8"F .bra  ( Parameters are separated by a semicolon.   .LI "The command line options" .bri  ? The usual rules apply, but the traditional '-' is NOT required.n   .LEi  C These sources are processed in the above order and later parametersoG override earlier ones. The parameters consist of one letter followed byoD a value. Some options are grouped, and then two letters identify the
 parameter.   .P  K Numeric values are expected as hex (0x*) octal (0*) or decimal (otherwise).i   .P   .VL 10 5   .LI FFilesPath .brf  @ Path where all files are to be found. Should be used only on the
 command line.    .LI IIniFile .br   # Specified the name of an init file.aB The default is 'fly.ini'. The file is searched for in the current > directory, then in the home dir (uses HOME env. var.) then the@ PATH directories are checked. Only the first file found is used.) Should be used onlye on the command line.P   .LI MMacroFile .brf  0 Name of keyboard macros file. [default is 'fly']   .LI XNavFile .bro  ) Name of nav data file. [default is 'fly']s  
 .LI YLandFiles .br   * Name of landscape file. [default is 'fly']   .LI dpPointerDriver1 .brd  J The pointing device can be one of: keypad, mouse, astick, bstick. But each# version of fly8 has different ones.f   .P  F All pointers MUST have as the first option the following 4 characters:   .P    1 [+-] set 1st channel direction   .P  + 2 [xy] set 1st channel function (see below)    .P    3 [+-] set 2nd channel direction   .P  + 4 [xy] set 2nd channel function (see below)    .P   Example of pointer parameters:   .P  
 dpMouse:+y-x::   .P  I This means "the first mouse axis should be interpreted as the fly8 Y axisvK while the second should be treated as the X axis and is inverted (the '-').aL This unusual setting may be used if your mouse is actually a trackball which' you are using sideways (axes reversed).    .P  K The Fly8 X axis controlls the roll while the Y axis controls the pitch. Theh standard option is '+x+y'.   .P  H Each pointing device can have more parameters. When a list of buttons isA expected you can use a simple list or include ranges, for example4G ":a=1-4" will make buttons 1, 2, 3 and 4 sensitive to the Btn-Alt mode.PG If the '-' is at the start then a '0' is assumes before it while at theo@ end a 'z' is assumed. This means that ":a=-" will set all of the buttons.   .VL 10 5   .LI "common options" .brn   .VL 5 0    .LI d= .br   B Do not debounce these buttons - make them repeating. Example 'd=0'C will cause button 0 to repeat its associated command while pressed.t   .LI r= .bra  B Do NOT issue key release command for these buttons. Example 'r=13'4 will disable issuing key-release on buttons 1 and 3.   .LI a= .LI c= .LI p= .LI s= .brd  ? Set the buttons to respondto Alt, Ctrl, Special and SHift modest
 respectively.m  
 .LI linear .bre  A The 'x' and 'y' inputs will be interpreted as a linear scale. The F default is to apply a log scale such that the sensitivity of the stick= increases as you move away from the reference point (center).r   .LEr  
 .LI keypad .br   $ (No optional parameters are defined)  	 .LI mouse  .bre   .VL 5 0s   .LI sx=  .brr  ) Sets the sensitivity of the mouse x axis.r   .LI sy=h .brm  ) Sets the sensitivity of the mouse y axis.    .LEd  	 .LI stick    .VL 5 0h   .LI ian= .brn  ? The size (in % of active range) of the region where the reading D may be unstable. This 'idle' parameter nominates the area around theF center of the joystick and the edges of it (and of the throttle) whereD the reading will be treated as it is was still at the center (or the edge).   .P  H The 'an' above nominate the axis and stick number as: ix1= main stick x,E iy1= main stick y, ix2= 2nd stick x, iy2= 2nd stick y. y2 is used fore3 throttle (CH, WCS) or hat (FCS in analog hat mode).f   .LI hat  .bri  ? Use y2 as the FCS hat. The positions are called buttons 4 (up),eF 5(right), 6(down) & 7(left). Do not use this option for the CHPro, see! the special 'chpro' option later.f   .LI ttlm .brs  E Use y2 as throttle. if you use ":ttl-" then the throttle will be readlE such that full-range is zero-throttle and zero-range is full-throttlet$ (which is how the CH and WCS do it).   .LI zero .brl  H Read no buttons. This is used when the buttons are delivered through the keyboard using a WCS or FLCS.p   .LI four .br   F Read all 4 buttons. These are called 0,1,2 & 3. Do not use this option4 for the CHPro, see the special 'chpro' option later.  	 .LI chprot .br(  G Used to indicate that you are using a CH Pro Flightstick which has four F buttons and a hat and has a different encoding scheme than the TM FCS.   .LI rd=o .br   H Read the joystick this many times instead of once. See also next option.   .LI dly= .bre  G Wait some time between multiple reads. The last two options are usefullnH if there is a lot of interruptions (network, multiuser system etc.). TheH delay may be necessary if doing multiple reads since some joystick ports are slow to reset.  	 .LI counte .br   E Do not use the timer when reading the stick, just run a loop counter.mE Usefull if your machine/joystick-card combination is so fast that the B timer does not have enough resolution. This method is however moreC sensitive to interruptions, use 'rd=' and 'dly=' to overcome these.o6 Also, under mswin the timer may not function properly.   .LI game .bri  F Do not use the <joystick.h> device but use the <game.h> device driver.   .LI gp .br)  A Use the serial line /dev/gp0 to read a Colorado Spectrum Gameport  (Workstation) joystick port.   .LEe   .LEd   .LI dvVideoDriverf .bri  7 The software video driver. These vary between machines.i   .BL 5y   .LIo  B MSDOS:	grQc (default), grFast or grVESA (VESA/VBE). There may be a2 grbgi if compiled with borland but it is too slow.   .LIe  > DjGpp:	grAsm (using fast assembly level graphics), grDJ (using% distribution DjGpp graphics library).t   .LI    MSWIN:	grGDI, grBitBlt, grWinG   .LIn  @ UNIX:	grx (PixMap based), gri (Image based) or grSVGA (svgalib).   .LIw  * AMIGA:	gramiga [amiga port not available!]   .LE    .LI dnNetDriverl .bre  E Network access through driver 'NetPort'. Only msdos/unix have network"> drivers at the moment. Look earlier at the networking section.   .LI dkKeyboardDriver .br   @ Keyboard device name. Usually there is only one defined so leave this parameter out.    .LI dsSoundDriverm .br   B Sound device name. Usually there is only one defined so leave this parameter out.   .LI PPlaneType .LI DDroneType .brn  ? The plane and drone type. If absent then drone type defaults to 3 plane type. Current types are: classic, basic, f16.P   .LI VVideoModesFiler .br   A The video modes file to use, e.g. 'Vgrvesa' means to use the filei% \'grvesa.vmd'. [default is 'fly.vmd']    .LI mVideoMode .brt  E The video mode. This is one of the modes defined in the .vmd file you- use.   .LI iStringP .br   G Initialization keystrokes. The string is a list of macros to execute atiE startup. The default is Ctrl-A. The string 'iCaezAb' will execute, inNF order: Ctrl-a Ctrl-e Ctrl-z Alt-b. Only Ctrl- and Alt- type macros can3 be used here. Macros are defined in the *.max file.u   .LI bn .br   J Windows configuration. The 'n' is the same letter as used on the 'Windows' menu.    .LI r  .bro  ? Activate network playing (used to be 'support Remote players').o   .LI NHandle  .brl   You will be known as 'Handle'.  	 .LI TTeam  .bre   Your team's name.   	 .LI HHomee .brc  3 Your home runway name (selected from fly.nav file).e   .LI on .brn  F This is used to prefix a list of options (separately described as 'oq'F etc. later). You can embed '-', '+' and '^' to set, clear or toggle anA option respectively. For example "o-qv+l" will turn off sound and5 verbose, and turn on landscape.n   .LI oq .br    No sound   .LI ol .bri  ( Add some landscaping (very rudimentary).   .LI ov .bre  ) See Options.Verbose in the menus chapter.h   .LI zNDrones .br   > Screen-blanker mode (with 'NDRONES' drones). You are put insto8 auto-pilot auto-kill mode, window borders are not shown.   .LI ntTimeLimit8 .brb  + Time limit in seconds (use in batch demos).    .LI nbLineBufferSize .brn  E Max num of segments in the display list. Default 5000. Used to reducedF memory shortage on msdos. Should be set to higher in environments that" have no stupid memory limitations.   .LI niMilliSecss .bro  B Max time for single step plane dynamics. Used to reduce simulation@ errors by breaking long periods into a sequence of shorter ones.   .LI nmMacros .brt   Max number of keyboard macros   
 .LI cColor .br   H Sets any one of the color definition. The color name is the same as usedB on the color menu. The value is as RGB, each componnent is 8 bits.F Example: ch0x60c060 set hud-low ('h') color to light green (R=60, G=c0 B=60, all in hex).   .LEr   .H 2 fly.log .P  F This file logs the activity of the program, problem messages and finalD stats. The command-line option -L can set a user selected file name.   .H 2 fly.mac .P  E This file is read at program startup and written at program shutdown. H It is the list of keyboard macros. Use the 'mac2max' program to list theK contents of this file. At the moment there is no macro editor so you should I use the redefine-macro for updating. The command-line option -M can set ahB user selected file name. It is easier to maintain the fly.max (see? later) manually, the fly.mac file may be removed in the future.]   .H 2 fly.max .P  G This file is read on program startup and defined keyboard macros. If it]H does not exist then fly.mac is read, if there is none then no macros areH defined (at this point). During shutdown all keyboard macros are written* to fly.mac (will OVERWRITE the original!).   .P  8 fly.max is a text file while fly.mac is a binary format.   .P  H It used to be that you could only define macros at run time using the F7G facility. However, now you will probably edit fly.max instead. However,s8 if you do add new macros interactively then you can use:   .ti 5Y   \fCmac2max fly.mac >new.max\fP   .P  G and now with an editor copy from new.max what you want into fly.max. IfWC you run the program again then fly.mac will be overwritten with thed content of fly.max.4   .P  F If you find yourself running fly8 and forgot to save the fly.mac (intoH fly.max) then shell out (with the ! command) and make a copy of fly.mac.H The shell only works if you have enough memory. If the screen goes blankD on shell then assume that it worked and type (blind) something like:   .ti 5b \fCcopy fly.mac xxx\fP   .ti 5e
 \fCexit\fP   .P  ' and the program will resume. Good luck.o   .P  E fly.max is a list of key definitions. Each definition starts with theaB Def keyword and is followed by the key being defined and a list of keystrokes (the macro itself).   .P  C Things can continue on multiple lines. A # will cause the rest of ac line to be ignored.    .P  E A key name is a list of shifts followed by a key name. The recognizedd shifts are:s   .P   .VL 10 5  	 .LI Shift    .LI Ctrl   .LI Alth   .LI Btnt .brt  2 Button press. This is the usual button definition.   .LI Brln .brr  C Button release. Will only be effective if the button was defined to G report key releases (the default, but see ":r=" in pointer parameters).    .LEs   .P  G A key name is either a single character (which represents itself and ISdA CASE SENSITIVE) or one of the special names (not case sensitive):c   .VL 10 5   .LI F1   .LI F2   .LI F3   .LI F4   .LI F5   .LI F6   .LI F7   .LI F8   .LI F9   .LI F10e   .LI F11    .LI F12k   .LI Left  	 .LI Right    .LI Up   .LI Dn .brh  
 alias Down   .LI PgUp .br    alias PageUp   .LI PgDn .bre   alias PageDown   .LI Home   .LI End    .LI Insd .brk   alias Insert   .LI Ctr  .bry  - alias Center. Unshifted numeric keypad 5 key.    .LI Dele .bre   alias Delete   .LI Sp .brS   alias Spacem   .LI Bell .br   	 alias \\a    .LI Bs .bra   alias Ro, Rubout, \\be   .LI Esc  .bre  	 alias \\e(   .LI Ff .br.  	 alias \\fh  	 .LI Enter  .brH   alias Ent, Cr, Ret, \\no   .LI Nl .brf  	 alias \\r    .LI Tab  .br   	 alias \\ty   .LI Vt .brt  	 alias \\vt   .LI \\\\\\\\\\\\\\\\ .bru  
 A single '\\'t   .LE    .P  F Note that some keys have both a long and a short name and some have an escape form too.   .P   You can use string notation:   .P   .ti 5d> \fCDef Alt g "\\esph=\\e40c080\\n\\e\\e" # set HUD to green\fP   .ti 5l? \fCDef Alt y "\\esph=\\e808000\\n\\e\\e" # set HUD to yellow\fPo   .P  & strings can continue on the next line.   .P  H Buttons are named 0-9 and a-z. The usual drivers will assign them in theF following manner (use wcs.adv and flcs.b50 to configue these devices).   .VL 10 5   .LI 0L .bro  ' trigger, mouse right button (FLCS TG2).    .LI 1f .br.  / other button on a two button pointer (FLCS S2).m   .LI 2,3e .brl  8 rest of buttons on a 4 button joystick (FLCS S1 and S3).   .LI 4,5,6,7u .brs  * main hat positions: up, right, down, left.   .LI 8c .bry  " FLCS TG1 (partial trigger) button.   .LI 9r .brr   FLCS red paddle (S4) button.   .LI a,b,c,d,e,ft .brm    WCS bottons 1, 2, 3, 4, 5 and 6.   .LI g,ht .br    WCS rocker up and rocker down.   .LI i,j,k,l  .br   ! FLCS hat 2 up, right, down, left,n   .LI m,n,o,p. .br   ! FLCS hat 3 up, right, down, left,i   .LI q,r,s,ts .br=  ! FLCS hat 4 up, right, down, left,o   .LE    .P  D Note that these names depend on the pointer driver that you use. The& mouse uses only 0 (left) and 1(right).   .H 2 fly.nav .P  G Lists the navigation waypoints which have ILS beacons. Should really bemE merged with the landscape file. Maybe one day. It is created from thee< fly.nac file using an awk script (in the 'parms' directory).   .P  G This is a very basic file that nominates the navigation points. Fly8 ishF not strong in this area, however you can activate the ILS system which will use one of these beacons.   .P  ! The file structure is as follows:u   .P  F First you nominate the number of points you are defining (I know, I am lazy).   .P  ! Next come the beacon information:g   .P   .ft C.   .ti 4  "A18", .ti 6a& V(0), V(0), V(0),	/* [x,y,z] meters */ .ti 6e9 149*60+10, -(35*60+20),	/* longitude, latitude minutes */O .ti 6o0 0, -500, 		/* localizer relative [x,y] meters */ .ti 6 0 0, 1500,		/* glide-path relative [x,y] meters */ .ti 6 ( 0,			/* heading of forward beam angle */ .ti 6 ! D(3),			/* pitch of beam angle */t .ft PL   .P  F The name is whatever you call it (not case sensitive). The position isB like in the object positioning in the .lnc file. The long/lat dataH allows the program to track your position, it is NOT checked against the previous line!   .P  H The next line specifies the localizer position (assumed to be level withB the object) as [east, north] and then the same for the glide slope@ origin point. These points are where the transmitting antenna is located.   .P  F The next line gives the heading of the localizer beam (0 means north),@ and the next is the glide slope angle (3 means 3 degrees slope).   .P  " An empty name must close the list.   .H 2 fly.lnd .P  E Defines the contents of the landscape. It is created from the fly.lnca1 file using the C pre-processor and an awk script..   .P  G It is mechanically built from fly.lnc. It describes the contents of thes
 landscape.   .P  E This file is a list of objects and their placement. You can place thepG standard objects (defined in separate .vxx files) as well as define newdH objects. The new objects will not be animated are are used for the fixed
 landscape.   .P  . And object placement has the following format:   .P   .ft C  .ti 4a$ O_RUNWAY, CC_DEFAULT,	/* runway A */ .ti 6'( V(0), V(0), V(0),	/* position x, y, z */ .ti 6s, D(0), D(0), D(0),	/* heading, roll, pitch */ .ft Pp   .P  H The first line names the object and assigns a color. CC_DEFAULT will let$ the object keep it's standard color.   .P  F The second line gives the objects position as x (east) y (north) and z' (up) in meters (you can use fractions).    .P  G The third line gives the objects orientation in terms of heading (northtF is zero) roll (zero means level, 90 means a quarter turn right and 180C means upside-down) and pitch (zero means level, 90 mens straight up  while -90 is straight down).   .P  ( To define a local object use the format:   .P   .ft C  .ti 4s! O_DEFINE+1, V_METERS,	/* river */n .ti 6h 6, .ti 6 ! V(-4000), V(-2000), V(0), V_MOVE,i .ti 6c  ... .ft Pa   .P  E The first line is the object name (each object is defined once and isaE assigned a number, this one is '1') and the data resolution: V_METERStG means that the data is to be kept in meters (no fractions) while V_FINE > means that internal data representation is in 1/16 of a meter.   .P  H Next you nominate the number of vertices (must me right!)  and followingG are the vertices. Each is an (x, y, z) trio and an indication as to the  visibility of that vertex.   .P  C To place a local object use a name of the format O_LOCAL+1 (for the. object in the above example).   
 .H 2 *.vxx .P  F This file can mechanically built from *.vx. It defines the shape of an object.n   .P  C The .vxx file is a simple list of numbers. The first line gives thepD number of vertices in the object and nominates the resolution of the= following data: 2 means 1=1meter while '1' means 1=1/16meter..   .P  G The data is a list of (x, y, z) points followed by 1 (line not visible)m or 2 (line visible).   .P  H No punctuation marks are used on this file and data cannot be moved fromD the nominated lines (2 numbers of the first line and 4 on the rest).   .P  C This file can be built from a more flexible file (usually stored asaD a .vx) which is then processd by the C preprocessor an an expression% evaluator which builds the .vxx file.E   .P  H Some of the .vx files look line C initializers - this is because objectsE used to be internal definitions. There is no point in making this anysA nicer since the whole object representation will at some stage ben6 completely upgraded to a full polygon based structure.  
 .H 2 *.prm .P  H These files define the various aircraft parameters. Different parametersG are used by different flight models, but if you modify a parameter fileg= it is best to set ALL parameters so that all model will work.m   .P  E The file that you create is the *.prc, which is then processed into a(E *.prm file (which is then read by fly8). The fly8 options 'P' and 'D'lF select which parameter file will be read (so 'fly8 Pf16' will read the \'f16.prm' file).t   .P  E The *.prc file has short comments against each line which should givelD some idea about each value. Note that the data is explicily integer.C This means that fractions are kept as fixed point. Also, other datafG (line angles and lengths) have a fraction part; however, you should notfD worry about this, just make sure that you specify the data using theG correct format. If you see a drag coefficient specified as F(0.02) thennF keep using the F() format - this will convert the fraction to the fly8E representation. Following are the types recognized (look at 'parms.h'l! for the definitions if you wish):u   .P   .VL 10 5   .LI F(x) .brn  B Stores x as a fraction. x should be kept in the range -1.0 to 1.0.  
 .LI F10(x) .brs  E Stores x as a scaled fraction. x should be kept in the range -10.0 top 10.0.r   .LI V(x) .brP  @ Length representation. Will be stores as meters with four binary fraction bits (just over 6cm).  
 .LI VV(x)  .bre  A Special format for high resolution lengths. x should be kept to a H reasonably small value (-128.0 to 128.0) but the resolution is to 8 bitsE (about 4mm). This is used in giving delicate landing gear dimentions.    .LI Go .br   8 Constant of gravity (9.810). Useful for defining forces.   .LI D(x) .bre    Stores x degrees in fly8 format.  	 .LI DV(x)  .brt  $ Stores x degrees/sec in fly8 format.  
 .LI I10(x) .br   F Stores a large integer with -1 decimal point (that means that a weight of 12876 is stores as '1287').   .LE   H In all of the above 'x' can be any number (integer or floating point) orH any expression of these. The expression evaluator understand most of theD standard C operators. Also, you can use the C preprocessor syntax in2 this file since it is being run through it anyway.   .P  D Note that fly8 expects the parameters in the correct format so neverE change the format notation in the *.prc file, just change the values.    .P  G The most important parameter is the first item in the '10 options' listt7 (towards the end), it selects the flight model program.t   .P .ti 15 [much more stuff needed here]    .H 2 fly.vmd .P  K This file defines the parameters for the available video modes. In windowedoI environments this is the startup mode and you can then resize the window. G The command-line option V can set a user selected file name. The readmefG should itemize the available mode files for the different environments.b   .P  E The file is a list of mode lines. Each line has the following format:    .VL 10 5   .LI name .brp  = The name of mode, any string (should be unique in this file).)   .LI "int10 value"b .br   E For pc/grfast: the supplied text files should have enough info to set2! these up for the supported cards.    .P  : For pc/grqc: this number is the c library id for the mode.   .P   Not used on other platforms.   .LI "number of colors" .brt   Must be 256 on pc/vga.   .LI "min x"L .brt  C The physical offset of the left margine of the screen. 0 on pc/vga.d   .LI "min y"  .brr  B The physical offset of the top margine of the screen. 0 on pc/vga.   .LI "size x" .br    Screen width in pixels   .LI "size y" .bro   Screen height in pixels    .LI "number of pages"  .bra  A How many full pages (WxH) will fit in your memory. Fly8 may use 2' for double buffering.P   .LI "physical screen width"h .brm  H Actual screen measurment (e.g. millimeters) for aspect ratio adjustment.   .LI "physical screen height" .bri  H Actual screen measurment (e.g. millimeters) for aspect ratio adjustment.   .LI "font width" .brt   8 (obsolete)   .LI "font height"( .brw   8 (obsolete)   .LI "flags"m .br   C This is a general purpose flags word used differently by each video(G driver. For example, msdos/grfast (and many others) uses the '1' bit tou3 indicate a need to wait for vsync on page flipping.i   .H 2 "data directory"  .P  G This directory is where one build the *.lnd, *.prm and *.nav files fromeG the free form input. The 'data' directory can be located anywhere but ItE find is easy to keep is as a subdirectory of the Fly8 game directory..   .P   The files here are:    .VL 10 5  	 .LI *.lnd  .brf  3 built from *.lnc, this is the landscape desciption.r  	 .LI *.prm  .brT  4 built from *.prc, this is the plane parameters file.  	 .LI *.nav  .bro  7 built from *.nav, this file gives some navigation data.[   .LEo   .P  J The steps to follow in building the files are described below. The 'build'= batch file is available for msdos but a similar one should be ? done for unix etc. It simple automates a rather simple process.i   .P   .VL 10 5   .LI 1m .br3  C Edit the source file (lnc/prc/nac). Use whatever editor you prefer,y these are plain text files.n   .LI 2  .brc  B Do 'build File Type' where File is the name of the file you edited< (without extension!) and type is lnd/prm/nav as appropriate.  C This script will run your file through the C pre-processor and thens! through an awk script (expr.awk).e   .LI 3a .brc  B Copy the new file (lnd/prm/nav) to your game directory. Or you canB give the directory on the build 'build File Type CopyToDirectory'.   .LI 4e .brd  E Change to the game directory and play. The new file will now be used.P   .LE    .H 1 AcknowledgementsD .P   .VL 10 5  , .LI "Ross Johnson (rpj@ise.canberra.edu.au)" .br   C Ideas, testing, networking know-how, X11 help. Doco typesetting and  review.s  * .LI "Mike Taylor (miket@canb.auug.org.au)" .brA   Amiga and Windows ports.  , .LI "Paul Thomas (paul.thomas@uk.ac.ox.eng)" .br   % Contributed a number of plane shapes.)   .LE    .H 1 "Misc Notes"a .P  D When you eject ('E') you will find yourself on a parachute. When youG land, you will move to a new plane. You can accelerate the descent withrG \'D' but if the plane did not yet crash then you will (have to) wait on06 the ground until it crashes and a new one is provided.   .P  L The IBMPC uses a timer chip with three counters. Fly8 reads counter 0 to getH high resolution interval timing and writes counter 2 to generate speakerI sound. Counter 0 is often set to the wrong mode by various programs (sometH examples: Landmark 1.14 sets the mode to 3 while version 2.00 sets it toH 2) . The standard is mode 3, but it is sometimes set to 2. Fly8 needs toE have the timer in the mode 2 or 3 or it reads bad timing information./   .P  F The program 'gettimer' will report the current mode. If it is 36/34 orE b6/b4 then the mode is correct. Fly8 was upgraded to support the mostdA common two modes and can actually operate with non-standard timerl@ settings (I should document these special parameters somewhere).   .P  2 The program settimer will set the timer to mode 3.   .H 1 "Known Problems"x .BL 5f   .LIe  B On a 486DX50 the serial driver fails at 115200 but is ok at 57600.G Output buffering at high speed looses the comms. It is now fixed with an kludge in the comms driver.o   .LI   ? On fast machines attempting to read the joystick twice in a rowaB produces unexpected results. A special delay option was introduced to get around this problem.    .LIt  A The stroke character generator will not handle stroke sizes above H 128 pixels. May be a problem if you try running at very high resolutions (say 1600x1200).   .LIo  E On slow machines the program may fail with a divide overflow. It also E may happen (rarely) on fast machines. This will be fixed gradually as + sensitive areas of the program get cleaned.n   .LEt .TCe