P /* --------------------------------- fly.h ---------------------------------- */  / /* This is part of the flight simulator 'fly8'. 6  * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au). */  ! /* structures used by the system.  */   #ifndef FLY8_FLY #define FLY8_FLY   #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <ctype.h> #include <stdarg.h>    #ifndef LOCAL_FUNC #define LOCAL_FUNC	static  #endif   #include "config.h"  #include "keymap.h"  #include "shape.h" #include "objects.h"   #include "stats.h" #include "colors.h"   7 #define rangeof(array)	(sizeof(array)/sizeof(array[0]))   6 #define	BUFLEN	256		/* size of a display list block */   typedef unsigned char	Uchar; typedef unsigned int	Uint; typedef unsigned short	Ushort; typedef unsigned long	Ulong;   typedef short	ANGLE; typedef short	VECT[3]; typedef long	LVECT[3]; typedef ANGLE	AVECT[3];  typedef short	MAT[3][3];   #define X	0  #define Y	1  #define Z	2    #define	HEAD	0 #define	TAIL	1   #define QUEUE(q,m) \ 	if ((q)[HEAD])			\  		(q)[TAIL]->next = (m);	\
 	else				\ 		(q)[HEAD] = (m);	\ 	(q)[TAIL] = (m)   typedef struct vertex	VERTEX;  typedef struct shape	SHAPE;  typedef struct object	OBJECT;  typedef Ushort		BUFLINE; typedef struct buffer	BUFFER;  typedef struct device	DEVICE;  typedef struct pointer	POINTER;  typedef struct screen	SCREEN;  typedef struct view	VIEW;  typedef struct window	WINDOW; ! typedef struct viewport	VIEWPORT;  typedef struct player	PLAYER;  typedef struct packet	PACKET;  typedef struct netport	NETPORT;  typedef struct msg	HMSG; typedef struct hdd	HDD;  typedef struct pid	PID;  typedef struct macro	MACRO;  typedef struct menu	MENU;    struct vertex {  	VECT	V; 	Ushort	flags; };   struct shape { 	VERTEX	*v;  	Ushort	extent;  	Ushort	flags; 	long	weight;		/* grams */ 	short	drag;		/* drag factor */  	Ushort	color; };  * #define	SH(p)		(st.bodies[p->name]->shape), #define TITLE(p)	(st.bodies[p->name]->title)   struct pid {	 	long	Kp;  	long	Iband;	 	long	Ki;  	long	Dband;	 	long	Kd; 
 	long	factor;  	long	range; 	long	Pprev; 	long	I; };   struct macro {
 	Ushort	name;  #define KEYUNUSED		0 	Ushort	len;
 	Ushort	*def;  };  
 struct menu {  	int	letter; 	char	*text; };  # typedef struct e_imported E_IMPORT;  struct e_imported {  	Ulong	lasttime; 	Ulong	timeout;  	short	misc[5];  };  * #define EIM(p)	(*(E_IMPORT **)&(p)->extra)     struct object {  	OBJECT		*next;  	OBJECT		*prev;  	void		*extra; 	OBJECT		*owner; 	PLAYER		*rplayer; 	POINTER		*pointer;  	VIEWPORT	*viewport;! 	long		id;		/* local object id */ # 	long		rid;		/* remote object id */ 5 	long		ownerid;	/* local object id of owner-object */ ! 	Ulong		rtime;		/* remote time */ ! 	Ulong		tob;		/* time of birth */ $ 	Ulong		tom;		/* time of maturity */" 	LVECT		R;		/* position [earth] */! 	VECT		V;		/* velocity [earth] */ ) 	AVECT		dda;		/* angular accels [body] */ ' 	AVECT		da;		/* angular rates [body] */ ' 	AVECT		dae;		/* Euler rates [earth] */ & 	AVECT		a;		/* Euler angles [earth] */
 	short		sinx; 
 	short		cosx; 
 	short		siny; 
 	short		cosy; 
 	short		sinz; 
 	short		cosz; ( 	MAT		T;		/* body->earth xform matrix */' 	short		home;		/* home ils beacon id */  	short		longitude; 	short		longmin; 	short		latitude;  	short		latmin; 
 	short		name;  	Ushort		color;  #define	FOREVER		0x7fff 
 	short		time;  #define	TIMEPSEC	100 	Ushort		flags; * #define F_VISIBLE	0x0001		/* permanent: */ #define F_IMPORTED	0x0002  #define F_EXPORTED	0x0004  #define F_MAINT		0x0008  #define F_STEALTH	0x0010 #define F_CC		0x0020/ #define F_LAND		0x0040		/* part of landscape */  #define F_FRIEND	0x0080 , #define F_ALIVE		0x0200		/* transitional: */ #define F_NEW		0x0400  #define F_DEL		0x0800  #define F_HIT		0x1000  #define F_KEEPNAV	0x2000 #define F_DONE		0x4000 #define F_MOD		0x8000  	Ushort		gpflags;  #define GPF_PILOT	0x0001( 	Ushort		shflags;	/* copy of SH flags */ 	short		speed; 	short		e_type;  #define ET_IMPORTED	0x0001 #define ET_PLANE	0x0002  #define ET_BOMB		0x0003 - #define IS_PLANE(p)	(ET_PLANE == (p)->e_type)  	short		score; 	short		damage;  	short		damaging;  	short		misc[5]; };   struct buffer {  	BUFFER		*next;  	BUFLINE		*p;		/* first free */ - 	BUFLINE		first[1];	/* start of data array */  };   #define	T_MASK		0xe000U  #define	T_BIT		0x2000U #define	T_COLOR		(0 * T_BIT) #define	T_DRAW		(1 * T_BIT)  #define	T_MOVE		(2 * T_BIT)  #define	T_ELLIPSE	(3 * T_BIT)  #define	T_MODE		(4 * T_BIT)  #define	T_NOP		(7 * T_BIT) #define	T_MOR		0U  #define	T_MXOR		1U #define	T_MSET		2U   struct device {  	DEVICE	*next; 	char	*name;) 	void	*pdevice;	/* private device data */ $ 	int	mode;		/* vga bios mode etc. */$ 	int	colors;		/* number of colors */ 	int	minx;		/* physical */ 	int	miny;		/* physical */ 	int	sizex;		/* physical */  	int	sizey; 		/* physical */* 	int	npages;		/* how many display pages */ 	int	lengx;		/* millimeter */  	int	lengy;		/* millimeter */ ! 	int	flags;		/* driver dpivate */  };   struct pointer { 	char	*name; 	Ushort	flags; #define PF_PRESENT	0x0001  #define PF_INITED	0x0002  	struct PtrDriver NEAR* control; #define	NANALOG	10 /* Channel allocation:  * 0	roll clockwise 
  * 1	pitch up   * 2	rudder right 
  * 3	throttle   * 4	trim pitch up  * 5	trim rudder right
  * 6	flaps
  * 7	spoilers   * 8	speed brakes   * 9	ground brakes */+ 	short	a[NANALOG];	/* analog -100...+100 */ * 	short	l[NANALOG];	/* last value of a[] */' 	Ushort	low[NANALOG];	/* calibration */ % 	Ushort	c[NANALOG];	/* calibration */ ( 	Ushort	high[NANALOG];	/* calibration */( 	Ushort	play[NANALOG];	/* calibration */% 	short	b[10];		/* digital commands */ $ 	Ushort	btn[36];	/* buttons flags */ #define	NOPTS	20 	int	opt[NOPTS]; };   struct screen {  	DEVICE	*device;) 	void	*pscreen;	/* private screen data */  	short	minx;		/* physical */ 	short	miny;		/* physical */ 	short	sizex;		/* physical */  	short	sizey;		/* physical */  	Ushort	FgColor; 	Ushort	BgColor; 	Ushort	BoColor;	/* border */  };   struct window { 6 	int	orgx;	/* all in normalized coordinates [0...1] */
 	int	orgy;0 	int	maxx;	/* left=orgx-maxx right =orgx+maxx */0 	int	maxy;	/* top =orgy-maxy bottom=orgy+maxy */ };   struct viewport {  	Ushort	flags; #define	VF_MIRROR	0x0001 	int	x;	/* NDC normally 0.0 */ 	int	y;	/* NDC normally 0.0 */< 	int	z;	/* NDC zoom, normally 0.5, must >= maxx and maxy! */* 	int	maxx;	/* NDC vp width normally 0.5 */+ 	int	maxy;	/* NDC vp height normally 0.5 */ . 			/* distz and shift in units of VONE*VONE */- 	int	distz;	/* eye to vp in viewers coords */ 2 	int	shift;	/* eye x shift (v coords) in stereo */ 	int	eyex;	/* viewer coords: */ > 	int	eyey;	/* eye position relative to viewer object origin */
 	int	eyez;: 	ANGLE	rotx;	/* eye direction relative to viewer origin */ 	ANGLE	roty; 	ANGLE	rotz; 	int	zoom;	/* zoom count */  };  
 struct	view { . 	VIEWPORT	*viewport;	/* camera: world -> 2D */, 	WINDOW		*window;	/* camera -> NDC window */1 	SCREEN		*screen;	/* window -> physical screen */  };   typedef struct body BODY; 
 struct body { 
 	int	name; 	Ushort	flags; #define BO_DYNSHAPE	0x0001
 	char	*title;  	SHAPE	*shape; 	int	(FAR* init) (BODY *b);  	void	(FAR* term) (BODY *b);$ 	int	(FAR* create) (OBJECT *object);% 	void	(FAR* delete) (OBJECT *object); 5 	void	(FAR* dynamics) (OBJECT *object, int interval); 8 	void	(FAR* hit) (OBJECT *object, int speed, int extent, 			int damaging);  };   #define	LADDRESS	6 #define	LNAME		20    struct player {  	PLAYER	*next; 	Ushort	flags; #define	PL_ACTIVE	0x0001 #define	PL_PENDREQUEST	0x0002  #define	PL_PENDBOSS	0x0004 #define	PL_PENDCONFIRM	0x0008 ; #define	PL_PEND	(PL_PENDREQUEST|PL_PENDCONFIRM|PL_PENDBOSS)  #define	PL_PLAYING	0x0010 . #define	PL_RECEIVE	(PL_PENDCONFIRM|PL_PLAYING) #define	PL_SEND	(PL_PLAYING)1 #define	PL_NOTIDLE	(PL_ACTIVE|PL_PEND|PL_PLAYING)  #define	PL_FRIEND	0x0020 	short	netport;  	Uchar	address[LADDRESS];  	char	name[LNAME]; 	char	team[LNAME];& 	short	ComVersion;			/* net version */ 	PACKET	*incoming; 	PACKET	*tail; 	Ulong	timeout; * 	long	rtime;				/* RemoteTime-LocalTime */* 	short	rtimeErr;			/* intergrated error */ };   struct netport { 	Ushort			flags; #define	NP_ON		0x0001  #define	NP_BCAST	0x0002y #define	NP_PACKING	0x0004. 	Ushort			packlen; 	short			netport;m
 	char			unit;e$ 	int			nplayers;	/* playing users */ 	struct NetDriver	*NetDriver;h 	PACKET			*incoming[2]; % 	PACKET			*outgoing;	/* async send */ & 	PACKET			*outpak;	/* packed packet */ };  , #define	PAKPACKLEN	1500			/* max pack len */   struct packet {u$ 	PACKET	*next;		/* must be first! */0 	Uchar	*data;		/* acquired packet data memory */1 	Uchar	*address;	/* where address is in 'data' */ 5 	Uchar	*raw;		/* where real packet starts in 'data'*//" 	Ulong	arrived;	/* arrival time */1 	Ushort	flags;		/* running length if incomming */h 	short	netport;i$ 	short	length;		/* message length */" 	Ushort	size;		/* raw data size */ };   struct SysDriver { 	char	*name; 	Ushort	flags;
 	void	*extra;d 	int	(FAR* Init) (void); 	void	(FAR* Term) (void);D 	void	(FAR* Poll) (void);n 	Ulong	(FAR* Disable) (void);	 	void	(FAR* Enable) (Ulong i); 	void	(FAR* Shell) (void);C 	void	(FAR* BuildFileName) (char *FullName, char *path, char *name,t 					char *ext); };   struct TmDriver {B 	char	*name; 	Ushort	flags;
 	void	*extra;u! 	int	(FAR* Init) (char *options);d 	void	(FAR* Term) (void);u 	Ulong	(FAR* Milli) (void);  	int	(FAR* Hires) (void);e 	char *	(FAR* Ctime) (void);- 	Ulong	(FAR* Interval) (int mode, Ulong res);r #define TMR_PUSH	0x0001u #define TMR_POP		0x0002e #define TMR_READ	0x0004  #define TMR_SET		0x0008T$ #define	TMR_START	(TMR_PUSH|TMR_SET)# #define TMR_STOP	(TMR_READ|TMR_POP)p& #define TMR_RESTART	(TMR_READ|TMR_SET) };   struct KbdDriver { 	char	*name; 	Ushort	flags;
 	void	*extra;;! 	int	(FAR* Init) (char *options);  	void	(FAR* Term) (void);	 	int	(FAR* Read) (void); 	int	(FAR* Getch) (void);d 	int	(FAR* Wait) (void); };   struct SndDriver { 	char	*name; 	Ushort	flags;
 	void	*extra;)! 	int	(FAR* Init) (char *options);u 	void	(FAR* Term) (void);	 	void	(FAR* Poll) (int force);% 	int 	(FAR* Beep) (int f, int milli);g0 	int 	(FAR* Effect) (int eff, int command, ...); #define EFF_HIT			1	/* eff */E #define EFF_M61_SHOOT		2 #define EFF_MK82_EXPLODE	3 #define EFF_MK82_SHOOT		4x #define EFF_NO_POINTER		5i #define EFF_BEEP		6t #define EFF_MSG			7U #define EFF_ENGINE		8t #define EFF_GONE		9[ #define EFF_HELLO		10( #define EFF_NOTICE		11 #define EFF_GEAR		12 #define EFF_ALARM		13  #define EFF_WARN		14 #define EFF_DAMAGE		15! #define SND_OFF			0	/* command */R #define SND_ON			1 #define SND_PARMS		2+ 	int 	(FAR* List) (int *list, int command);  };   struct GrDriver {n 	char	*name; 	Ushort	flags;
 	void	*extra;t 	DEVICE	*devices;;. 	int	(FAR* Init) (DEVICE *dev, char *options);  	void	(FAR* Term) (DEVICE *dev);' 	void	(FAR* MoveTo) (Uint x1, Uint y1);r/ 	void	(FAR* DrawTo) (Uint x2, Uint y2, Uint c);T! 	int	(FAR* SetVisual) (int page); ! 	int	(FAR* SetActive) (int page);d! 	void	(FAR* Clear) (SCREEN *scr);s$ 	int	(FAR* SetWriteMode) (int mode);/ 	int	(FAR* SetPalette) (int index, long color);s@ 	void	(FAR* Ellipse) (Uint x, Uint y, Uint rx, Uint ry, Uint c); 	void	(FAR* Flush) (void); 	int	(FAR* Shutters) (int eye);i };   struct PtrDriver { 	char	*name; 	Ushort	flags;
 	void	*extra;e- 	int	(FAR* Init) (POINTER *p, char *options);c 	void	(FAR* Term) (POINTER *p);  	int	(FAR* Cal) (POINTER *p);C  	int	(FAR* Center) (POINTER *p);, 	int	(FAR* Read) (POINTER *p, int transfer);' 	void	(FAR* Key) (POINTER *p, int key);  };   struct NetDriver { 	char	*name; 	Ushort	flags;
 	void	*extra;00 	int	(FAR* Init) (NETPORT *port, char *options);" 	void	(FAR* Term) (NETPORT *port);/ 	int	(FAR* Send) (NETPORT *port, PACKET *pack);_! 	int	(FAR* Poll) (NETPORT *port);  };   struct netname { 	struct netname	*next;
 	char		*name;O };   struct msg {
 	HMSG		*next; 
 	char		*text;s% 	Ulong		timeout;	/* time to delete */s
 	Uint		flags;  #define MSG_WARN	0x0001p #define MSG_ERR		0x0002d };  ) #define NBUFS		2		/* must be 2 for now */    struct hdd {
 	short		type;f #define	HDT_FRONT	 0 #define	HDT_NONE	 1  #define	HDT_REAR	 2t #define	HDT_MAP		 3a #define	HDT_RADAR	 4 #define	HDT_TARGET	 5e #define	HDT_PAN		 6  #define	HDT_GAZE	 7i #define	HDT_CHASE	 8 #define	HDT_FOLLOW	 9  #define	HDT_HUD		10  #define	HDT_UPFRONT	11 #define	HDT_PANEL	12 #define	HDT_RIGHT	13 #define	HDT_LEFT	14_ #define	HDT_STORES	15f #define	HDT_LAMPS	16 #define	HDT_MIRROR	173 	Ushort		flags;n #define HDF_ON		0x0001) #define HDF_MONO	0x0002		/* monochrome */0 	Ushort		FgColor;	 	Ushort		BgColor;	 	Ushort		BoColor;	/* border */ 	VIEW		view;' 	BUFFER		*bufs[NBUFS];	/* HDD window */  }; #define NVIEWERS	10v   struct status {/ 	struct SysDriver	NEAR* system;r 	struct TmDriver		NEAR* time;/! 	struct GrDriver		NEAR* graphics;s 	struct SndDriver	NEAR* sound;! 	struct KbdDriver	NEAR* keyboard;	 	BODY		**bodies;  	char		*iname;			/* init file */" 	char		*mname;			/* macros file */+ 	char		*fname;			/* font file [obsolete] */ ( 	char		*vmdname;		/* video modes file */$ 	char		*lname;			/* log file name */% 	char		*navname;		/* nav file name */e+ 	char		*lndname;		/* landscape file name */n- 	char		*fdir;			/* support files directory */h+ 	char		*ptrname;		/* pointer device name */4( 	char		*grname;		/* video device name */# 	char		*grmname;		/*    and mode */b) 	char		*sndname;		/* sound device name */N, 	char		*kbdname;		/* keyboard device name */- 	struct netname	*netnames;		/* net drivers */A! 	char		*ptype;			/* plane type */[! 	char		*dtype;			/* drone type */r0 	char		*options;		/* options for 'create_obj' */! 	char		*nikname;		/* my handle */b% 	char		*teamname;		/* my team name */	) 	char		*homename;		/* my nav home name */	 	char		*timeropts;+ 	char		*initkeys;		/* startup keystrokes */v+ 	Ulong		big_bang;		/* keep relative time */o 	Ulong		present; 	Ulong		lasttime;; #define	TO_OBJECT	(4*1000L)x 	Ulong		ObjectTimeout; #define	TO_PLAYER	(8*1000L)U 	Ulong		PlayerTimeout; #define	TO_DRONE	(8*1000L)- 	Ulong		DroneTime;		/* drone takeoff delay */;  #define	TO_REFRESH	(TO_OBJECT/4) 	Ulong		RefreshTime; 	Ulong		ShutdownTime;g 	Ulong		test_start;x 	long		mscore; 	Ulong		nbullets;b 	Ushort		ComVersion; 	Ushort		nbuffers; 	Ushort		maxbuffers; 	Ushort		maxrecall;1 	Ushort		flags;n #define	SF_BLANKER	0x0001N #define	SF_LANDSCAPE	0x0002* #define	SF_SKY		0x0004 #define	SF_VERBOSE	0x0008  #define	SF_INTERACTIVE	0x0010a #define	SF_SIMULATING	0x0020 #define	SF_INITED	0x0040 #define	SF_PAUSED	0x0080 #define	SF_LISTS	0x0f00i #define	SF_MODES	0x0100  #define	SF_HUD		0x0200 #define	SF_HELP		0x0300  #define	SF_NET 		0x0400t #define	SF_STATS	0x0500* #define	SF_COLORS	0x0600 #define SF_FONT		0x0700b #define SF_PAUSEMSG	0x1000 #define SF_DEBUG	0x2000t #define SF_CLEARED	0x4000i #define	SF_MAIN		0x8000E 	Ushort		flags1; #define	SF_USEG		0x0001  #define	SF_WIDENT	0x0002 #define	SF_DBUFFERING	0x0004 #define	SF_TESTING	0x0008* #define	SF_STEREOREV	0x0010R #define	SF_EXTVIEW	0x0020p #define	SF_IDENT	0x0040  #define	SF_INFO		0x0080  #define	SF_SMOKE	0x0100m #define SF_TERM		0x0200n #define	SF_HUDINFRONT	0x0400: #define	SF_ASYNC	0x0800		/* asynchronous process active */ 	Ushort		sounds; #define	SS_WARN		0x0001( #define	SS_ALARM	0x0002F 	Ushort		debug;C #define DF_GPW		0x1000 #define DF_GPX		0x2000 #define DF_GPY		0x4000 #define DF_GPZ		0x8000 	Ushort		network;i #define	NET_ON		0x0001 #define	NET_NOBCAST	0x0002 #define	NET_INITED	0x0004  #define	NET_AUTOACCEPT	0x0010; #define	NET_AUTODECLINE	0x0020 #define	NET_AUTOCONNECT	0x0040F #define	NET_AUTOREPLY	(NET_AUTOACCEPT|NET_AUTODECLINE|NET_AUTOCONNECT) 	short		ntargets;_ 	short		extview;
 	short		info;D" 	short		stereo;		/* vision type */ #define VIS_MONO		0L #define VIS_STEREOSCOPIC	1 #define VIS_REDBLUE		2 #define VIS_ALTERNATING		3, 	short		windows;	/* windows configuration */ #define WIN_TEXT	0 #define WIN_FULL	1 #define WIN_LANDSCAPE	2L #define WIN_PORTRATE	3 #define WIN_SQUARE	4 #define WIN_WIDE	5 #define WIN_PANORAMA	6 #define WIN_ETHER	7t6 	short		paralax;	/* stereo eye shift. MAX 100*VONE! *// 	short		focus;		/* stereo eye focus distance */t4 	short		gap;		/* gap between stereo frames: 1/gap */ 	short		quiet; 	OBJECT		*owner;( 	BUFFER		*bufs[NBUFS];	/* main window *// 	BUFFER		*buf[2];	/* current writable buffer */y1 	BUFLINE		*buf_p;		/* current writable bufline */v3 	short		buf_avail;	/* available entries in st.buf*// 	short		which_buffer;E 	short		nobjects;k 	long		object_id; . 	OBJECT		*world[2];	/* all objects in world */ #define CO	st.world[0] #define COT	st.world[1]t1 	OBJECT		*land[2];	/* all objects in landscape */  #define CL	st.land[0]  #define CLT	st.land[1]& 	OBJECT		*viewer;	/* origin of view */ #define CV	st.viewer2 	OBJECT		*control;	/* object under user control */ #define CC	st.controli! 	VIEW		view[1];	/* active view */o #define CVIEW	st.viewl #define CP	st.view->viewport #define CW	st.view->window #define CS	st.view->screen #define NHDD	10v" 	HDD		hdd[NHDD];	/* HDD windows */0 	int		interval;	/* milliseconds of last frame */# 	int		dither;		/* rand () % 1000 */)- 	POINTER		*pointer;	/* kludge for oplane.c */ 
 	int		StFont; 3 	Uchar	NEAR* NEAR* StFontPtr;	/* StFonts[StFont] */h 	int		StFontSize;	( 	int		landx;		/* land square: x and y */ 	int		landy;# 	int		gravity;	/* meters/sec/sec */A! 	HMSG		*msg;		/* message queue */F% 	int		drones;		/* number of drones */ 0 	int		killers;	/* how many drones are killers */, 	int		SkyLines;	/* number of lines in sky */( 	short		home;		/* home base nav point */* 	Ushort		btnmode;	/* buttons shift mode */4 	short		nMacros;	/* max number of keyboard macros */ 	long		lineno; #define NCOLORS	16 	Ushort		colors[NCOLORS];f 	Ulong		palette[NCOLORS];M 	Ushort		assign[32]; #define CA_IFG		0n #define CA_MFG		1; #define CA_WFG		2i #define CA_CFG		3r #define CA_HFG		4	 #define CA_HFGI		5 #define CA_HBO		6( #define CA_SLEFT	7 #define CA_SRIGHT	8( #define CA_SBOTH	9 #define CA_GROUND	10 #define CA_DULL		11h #define CA_FAINT	12t #define CA_SKY		13 #define CA_FRIEND	14 #define CA_FOE		15 #define CA_HELP		16o #define CA_FIRE1	17t #define CA_FIRE2	18  #define CA_MENU		19F #define CA_MENUH	20 " #define ST_INFO		st.assign[CA_IFG]! #define ST_MFG		st.assign[CA_MFG]O! #define ST_WFG		st.assign[CA_WFG]d! #define ST_CFG		st.assign[CA_CFG]F! #define ST_HFG		st.assign[CA_HFG]	# #define ST_HFGI		st.assign[CA_HFGI]_! #define ST_HBO		st.assign[CA_HBO]d$ #define ST_SLEFT	st.assign[CA_SLEFT]& #define ST_SRIGHT	st.assign[CA_SRIGHT]$ #define ST_SBOTH	st.assign[CA_SBOTH]& #define ST_GROUND	st.assign[CA_GROUND]# #define ST_DULL		st.assign[CA_DULL] $ #define ST_FAINT	st.assign[CA_FAINT]! #define ST_SKY		st.assign[CA_SKY] & #define ST_FRIEND	st.assign[CA_FRIEND]! #define ST_FOE		st.assign[CA_FOE]d# #define ST_HELP		st.assign[CA_HELP]e$ #define ST_FIRE1	st.assign[CA_FIRE1]$ #define ST_FIRE2	st.assign[CA_FIRE2]# #define ST_MENU		st.assign[CA_MENU]o$ #define ST_MENUH	st.assign[CA_MENUH]  4 	PLAYER NEAR	*all_known;	/* for remote_* () usage */# 	PLAYER NEAR	*all_active;	/* -"- */*! 	PLAYER NEAR	*all_team;	/* -"- */n" 	PLAYER NEAR	*all_ports;	/* -"- */# 	PLAYER NEAR	*all_pports;	/* -"- */l4 	PLAYER NEAR	*all_players;	/* internal to menus.c */# 	PLAYER NEAR	*no_players;	/* -"- */S 	int		misc[20];) 	long		stats[100];0 	char		filename[1024];	/* file name work area */ };   #define Sys	st.systemE #define Tm	st.time #define Gr	st.graphics #define Snd	st.sound #define Kbd	st.keyboardi   #define GACC	st.gravityp   #define VP	view->viewport  #define VW	view->window	 #define VS	view->screenn   struct FldTab {u
 	int	type;	 	void	*p;n };   struct hud {
 	short	flags;0: #define HF_ETHER	0x0001	/* this is an ether display/HUD */C #define HF_ETHERFRAME	0x0002	/* use ether style frame indicators */p! 	short	orgx;		/* window center */p 	short	orgy; 	short	maxx;		/* window size */	 	short	maxy;$ 	short	shifty;		/* hud down shift */ 	short	cx;		/* hud center */
 	short	cy; 	short	sx;		/* hud size */
 	short	sy;
 	short	clipx;0
 	short	clipy; 2 	short	clipr;		/* bounding rectangle (relative) */
 	short	clipl; 
 	short	clipt; 
 	short	clipb; 2 	short	right;		/* bounding rectangle (absolute) */ 	short	left; 	short	top;A 	short	bottom; 	short	tx;		/* tick size */G
 	short	ty;+ 	short	ttx;		/* 'big' adjusted tick size */n 	short	tty;8 	short	ss;		/* stroke size */n 	short	dd;		/* digit width */R( 	ANGLE	width;		/* horizontal aperture */' 	ANGLE	height;		/* vertical aperture */D! 	Ushort	fg;		/* color (normal) */ ' 	Ushort	fgi;		/* color (intensified) */  	int	VV[2];		/* vv position */. 	short	etherx;		/* ether frame x centerline */. 	short	ethery;		/* ether frame y centerline */. 	short	ethertx;	/* ether frame x half-width */. 	short	etherty;	/* ether frame y half-width */ 	short	misc[10]; }; typedef struct hud HUD;m   struct ils { 	char	*name;  	LVECT	R;		/* runway position */ 	short	longitude;D 	short	latitude;* 	short	l[2];		/* localizer relative x/y */+ 	short	g[2];		/* glide-path relative x/y */ / 	ANGLE	localizer;	/* heading of forward beam */;% 	ANGLE	glidepath;	/* pitch of beam */* };   #include "extern.h"l   #endif