P /* --------------------------------- hudmenu.c ------------------------------ */  / /* This is part of the flight simulator 'fly8'. 6  * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au). */  
 /* HUD Menus.  */   #include "plane.h"     /* Select HUD type */  ! static MENU FAR	MenuHudType[] = {  	{'0', "Classic"},	/*  0 */  	{'1', "FA18"},		/*  1 */  	{'2', "F16"},		/*  2 */ 	{'3', "F15"},		/*  3 */ 	{'4', "Ether"},		/*  4 */ {'\0', 0}};    extern int FAR menu_hudtype (void)  { 	 	int	sel;   ) 	sel = (EE(CV)->hud1&HUD_TYPES)/HUD_TYPE; $ 	sel = menu_open (MenuHudType, sel);   	switch (sel) {  	case MENU_ABORTED:  	case MENU_FAILED: 		break;	 	default: > 		EE(CV)->hud1 = (EE(CV)->hud1 & ~HUD_TYPES) | (sel*HUD_TYPE); 		hud_setup (CV);  		break; 	} 	if (MENU_FAILED != sel) 		menu_close ();   	return (0); }    /* Select ladder sizes;  */    static MENU FAR	MenuLdSize[] = { 	{'g', "gap"},		/*  0 */ 	{'s', "step"},		/*  1 */  	{'h', "horizon"},	/*  2 */  	{'l', "land"},		/*  3 */  	{'t', "tip"},		/*  4 */ 	{'n', "ndash"},		/*  5 */ {'\0', 0}};    LOCAL_FUNC int NEAR  menu_ldsize (void) {  	int	sel, quit;   	 	sel = 0;  	for (quit = 0; !quit;) { " 		sel = menu_open (MenuLdSize, 0); 		switch (sel) { 		case MENU_ABORTED:
 		default: 			quit = 1;	 			break; 	 		case 0: 1 			get_num ("gap size", &EE(CV)->ldgap, MT_SHORT,  					0, FONE, FONE/128);	 			break; 	 		case 1: 3 			get_num ("step size", &EE(CV)->ldstep, MT_SHORT,  					0, FONE, FONE/128);	 			break; 	 		case 2: 7 			get_num ("horizon size", &EE(CV)->ldstep0, MT_SHORT,  					0, FONE, FONE/128);	 			break; 	 		case 3: 4 			get_num ("land size", &EE(CV)->ldstepg, MT_SHORT, 					0, FONE, FONE/128);	 			break; 	 		case 4: 1 			get_num ("tip size", &EE(CV)->ldtip, MT_SHORT,  					0, FONE, FONE/128);	 			break; 	 		case 5: 0 			get_num ("ndash", &EE(CV)->ldndash, MT_SHORT, 					0, 8, 1);	 			break;  		}  		if (MENU_FAILED != sel)  			menu_close ();  	} 	return (0); }    /* Select ladder style */    static MENU FAR	MenuLadder[] = { 	{'0', "off"},		/*  0 */ 	{'1', "on"},		/*  1 */  	{'2', "toggle"},	/*  2 */ 	{'l', "ladder"},	/*  3 */ 	{'p', "pinned"},	/*  4 */ 	{'r', "right"},		/*  5 */ 	{'e', "erect"},		/*  6 */ 	{'c', "color"},		/*  7 */ 	{'f', "funnel"},	/*  8 */ 	{'s', "slant"},		/*  9 */ 	{'z', "zenith"},	/* 10 */ 	{'u', "under"},		/* 11 */ 	{'t', "tip0"},		/* 12 */  	{'h', "hold"},		/* 13 */  	{'R', "h roll"},	/* 14 */ 	{'S', "sun"},		/* 15 */ 	{'i', "negtip"},	/* 16 */ 	{'x', "sizes"},		/* 17 */ {'\0', 0}};    LOCAL_FUNC int NEAR  menu_ladder (void) {  	int	sel, quit;    	SetOption (0, 2);	 	sel = 0;  	for (quit = 0; !quit;) { " 		sel = menu_open (MenuLadder, 0); 		switch (sel) { 		case MENU_ABORTED:
 		default: 			quit = 1;	 			break; 	 		case 0: 	 		case 1: 	 		case 2:  			SetOption (0, sel);	 			break; 	 		case 3: ( 			SetOption (&EE(CV)->hud, HUD_LADDER);	 			break; 	 		case 4: ) 			SetOption (&EE(CV)->ladder, LD_FIXED); 	 			break; 	 		case 5: ) 			SetOption (&EE(CV)->ladder, LD_RIGHT); 	 			break; 	 		case 6: ) 			SetOption (&EE(CV)->ladder, LD_ERECT); 	 			break; 	 		case 7: ) 			SetOption (&EE(CV)->ladder, LD_COLOR); 	 			break; 	 		case 8: * 			SetOption (&EE(CV)->ladder, LD_FUNNEL);	 			break; 	 		case 9: ) 			SetOption (&EE(CV)->ladder, LD_SLANT); 	 			break; 
 		case 10:* 			SetOption (&EE(CV)->ladder, LD_ZENITH);	 			break; 
 		case 11:) 			SetOption (&EE(CV)->ladder, LD_UNDER); 	 			break; 
 		case 12:( 			SetOption (&EE(CV)->ladder, LD_TIP0);	 			break; 
 		case 13:( 			SetOption (&EE(CV)->ladder, LD_HOLD);	 			break; 
 		case 14:, 			SetOption (&EE(CV)->ladder, LD_HOLDROLL);	 			break; 
 		case 15:' 			SetOption (&EE(CV)->ladder, LD_SUN); 	 			break; 
 		case 16:* 			SetOption (&EE(CV)->ladder, LD_NEGTIP);	 			break; 
 		case 17: 			menu_ldsize ();	 			break;  		}  		if (MENU_FAILED != sel)  			menu_close ();  	} 	return (0); }    /* Select HUD parts (x)  */  # static MENU FAR	MenuHudGround[] = {  	{'0', "off"},		/*  0 */ 	{'1', "on"},		/*  1 */  	{'2', "toggle"},	/*  2 */ 	{'p', "gnd ptr"},	/*  3 */  	{'x', "xbreak"},	/*  4 */ 	{'v', "xvar"},		/*  5 */  	{'g', "xgrid"},		/*  6 */ 	{'u', "pullup"},	/*  7 */ {'\0', 0}};    LOCAL_FUNC int NEAR  menu_hud_ground (void) {  	int	sel, quit;    	SetOption (0, 2);	 	sel = 0;  	for (quit = 0; !quit;) { % 		sel = menu_open (MenuHudGround, 0);  		switch (sel) { 		case MENU_ABORTED:
 		default: 			quit = 1;	 			break; 	 		case 0: 	 		case 1: 	 		case 2:  			SetOption (0, sel);	 			break; 	 		case 3: + 			SetOption (&EE(CV)->hud1, HUD_PENDULUM); 	 			break; 	 		case 4: ) 			SetOption (&EE(CV)->hud2, HUD_XBREAK); 	 			break; 	 		case 5: ' 			SetOption (&EE(CV)->hud3, HUD_XVAR); 	 			break; 	 		case 6: ( 			SetOption (&EE(CV)->hud2, HUD_XGRID);	 			break; 	 		case 7: & 			SetOption (&EE(CV)->hud3, HUD_CUE);	 			break;  		}  		if (MENU_FAILED != sel)  			menu_close ();  	}   	return (0); }    /* Select HUD parts  */  " static MENU FAR	MenuHudParts[] = { 	{'0', "off"},		/*  0 */ 	{'1', "on"},		/*  1 */  	{'2', "toggle"},	/*  2 */ 	{'l', "ladder"},	/*  3 */ 	{'a', "altitude"},	/*  4 */ 	{'s', "speed"},		/*  5 */ 	{'h', "heading"},	/*  6 */  	{'b', "border"},	/*  7 */ 	{'v', "vv"},		/*  8 */  	{'w', "vw"},		/*  9 */  	{'+', "plus"},		/* 10 */  	{'P', "pointer"},	/* 11 */  	{'B', "beta"},		/* 12 */  	{'g', "ground"},	/* 13 */ 	{'d', "director"},	/* 14 */ 	{'y', "waypoint"},	/* 15 */ 	{'t', "tracers"},	/* 16 */  	{'G', "ghost"},		/* 17 */ 	{'T', "truehead"},	/* 18 */ {'\0', 0}};    LOCAL_FUNC int NEAR  menu_hudparts (void) {  	int	sel, quit;    	SetOption (0, 2);	 	sel = 0;  	for (quit = 0; !quit;) { $ 		sel = menu_open (MenuHudParts, 0); 		switch (sel) { 		case MENU_ABORTED:
 		default: 			quit = 1;	 			break; 	 		case 0: 	 		case 1: 	 		case 2:  			SetOption (0, sel);	 			break; 	 		case 3:  			menu_ladder (); 			quit = 1;	 			break; 	 		case 4: + 			SetOption (&EE(CV)->hud2, HUD_ALTITUDE); 	 			break; 	 		case 5: ( 			SetOption (&EE(CV)->hud2, HUD_SPEED);	 			break; 	 		case 6: * 			SetOption (&EE(CV)->hud2, HUD_HEADING);	 			break; 	 		case 7: ) 			SetOption (&EE(CV)->hud1, HUD_BORDER); 	 			break; 	 		case 8: $ 			SetOption (&EE(CV)->hud, HUD_VV);	 			break; 	 		case 9: % 			SetOption (&EE(CV)->hud2, HUD_VW); 	 			break; 
 		case 10:& 			SetOption (&EE(CV)->hud, HUD_PLUS);	 			break; 
 		case 11:( 			SetOption (&EE(CV)->hud, HUD_CURSOR);	 			break; 
 		case 12:' 			SetOption (&EE(CV)->hud2, HUD_BETA); 	 			break; 
 		case 13: 			menu_hud_ground (); 			quit = 1;	 			break; 
 		case 14:+ 			SetOption (&EE(CV)->hud2, HUD_DIRECTOR); 	 			break; 
 		case 15:+ 			SetOption (&EE(CV)->hud2, HUD_WAYPOINT); 	 			break; 
 		case 16:) 			SetOption (&EE(CV)->hud2, HUD_BTRAIL); 	 			break; 
 		case 17:& 			SetOption (&EE(CV)->hud3, HUD_GVV);	 			break; 
 		case 18:. 			SetOption (&EE(CV)->hud3, HUD_TRUEHEADING);	 			break;  		}  		if (MENU_FAILED != sel)  			menu_close ();  	}   	return (0); }    /* Select HUD options. */  % static MENU FAR	MenuHudOptions1[] = {  	{'0', "off"},		/*  0 */ 	{'1', "on"},		/*  1 */  	{'2', "toggle"},	/*  2 */ 	{'3', "heading"},	/*  3 */  	{'k', "knots"},		/*  4 */ 	{'T', "top"},		/*  5 */ 	{'f', "fine"},		/*  6 */  	{'x', "xfine"},		/*  7 */ 	{'b', "big"},		/*  8 */ 	{'l', "scale"},		/*  9 */ 	{'a', "area"},		/* 10 */  	{'c', "cas"},		/* 11 */ {'\0', 0}};    LOCAL_FUNC int NEAR  menu_hudoptions1 (void)  {  	int	sel, quit, ch;  	char	msg[80], prompt[80];   	SetOption (0, 2);	 	sel = 0;  	for (quit = 0; !quit;) { ' 		sel = menu_open (MenuHudOptions1, 0);  		switch (sel) { 		case MENU_ABORTED: 		case MENU_FAILED: 
 		default: 			quit = 1;	 			break; 	 		case 0: 	 		case 1: 	 		case 2:  			SetOption (0, sel);	 			break; 	 		case 3: - 			SetOption (&EE(CV)->hud, HUD_FULLHEADING); 	 			break; 	 		case 4: ( 			SetOption (&EE(CV)->hud1, HUD_KNOTS);	 			break; 	 		case 5: & 			SetOption (&EE(CV)->hud1, HUD_TOP);	 			break; 	 		case 6: & 			SetOption (&EE(CV)->hud, HUD_FINE); 			if (EE(CV)->hud & HUD_FINE) 				EE(CV)->hud &= ~HUD_XFINE;	 			break; 	 		case 7:-' 			SetOption (&EE(CV)->hud, HUD_XFINE);- 			if (EE(CV)->hud & HUD_XFINE)T 				EE(CV)->hud &= ~HUD_FINE;a	 			break; 	 		case 8::% 			SetOption (&EE(CV)->hud, HUD_BIG);.	 			break; 	 		case 9:s
 			for (;;) {u, 				sprintf (prompt, "scale len(%d)[10-25]", 					(int)EE(CV)->tapelen); . 				sprintf (msg, "%d", (int)EE(CV)->tapelen);) 				edit_str (prompt, msg, sizeof (msg));3 				if ('\0' == msg[0])4 					break;	' 				if (1 == sscanf (msg, "%u", &ch) &&  				    ch >= 10 && ch <= 25) {l! 					EE(CV)->tapelen = (short)ch;S 					break;  				}m 			}	 			break;T
 		case 10:
 			for (;;) { - 				sprintf (prompt, "hud area(%dDeg)[1-45]",	 					(int)EE(CV)->hudarea);>. 				sprintf (msg, "%d", (int)EE(CV)->hudarea);) 				edit_str (prompt, msg, sizeof (msg));  				if ('\0' == msg[0])e 					break; ' 				if (1 == sscanf (msg, "%u", &ch) &&z 				    ch >= 1 && ch <= 45) {! 					EE(CV)->hudarea = (short)ch;  					break;t 				}/ 			}	 			break;"
 		case 11:- 			SetOption (&EE(CV)->hud2, HUD_CALIBRATED);i	 			break;  		}{ 		if (MENU_FAILED != sel)' 			menu_close ();_ 	}   	return (0); }s  % static MENU FAR	MenuHudOptions2[] = {= 	{'0', "off"},		/*  0 */ 	{'1', "on"},		/*  1 */  	{'2', "toggle"},	/*  2 */ 	{'A', "a alarm"},	/*  3 */  	{'V', "v alarm"},	/*  4 */b 	{'p', "panel"},		/*  5 */ 	{'F', "font"},		/*  6 */g 	{'S', "fontsize"},	/*  7 */ {'\0', 0}};	   LOCAL_FUNC int NEAR	 menu_hudoptions2 (void)E {) 	int	sel, quit, ch;  	char	msg[80], prompt[80];	 	HMSG	*m;	   	SetOption (0, 2);	 	sel = 0;z 	for (quit = 0; !quit;) {O' 		sel = menu_open (MenuHudOptions2, 0);  		switch (sel) { 		case MENU_ABORTED: 		case MENU_FAILED:H
 		default: 			quit = 1;	 			break;e	 		case 0:e	 		case 1:t	 		case 2:s 			SetOption (0, sel);	 			break;		 		case 3: ) 			SetOption (&EE(CV)->hud1, HUD_AALARM);n	 			break;,	 		case 4:d) 			SetOption (&EE(CV)->hud1, HUD_VALARM); 	 			break;f	 		case 5:E( 			SetOption (&EE(CV)->hud1, HUD_PANEL);	 			break; 	 		case 6: 
 			for (;;) {/) 				m = MsgPrintf (0, "StFont(%d)?[0-9]",, 					(int)st.StFont);1 				ch = mgetch ();  				msg_del (m);! 				if (ch >= '0' && ch <= '9') {/ 					font_set (ch - '0');/ 					break;h 				}* 			}	 			break;r	 		case 7: 
 			for (;;) {o, 				sprintf (prompt, "StFontSize(%d)[4-64]", 					(int)st.StFontSize); , 				sprintf (msg, "%d", (int)st.StFontSize);) 				edit_str (prompt, msg, sizeof (msg));, 				if ('\0' == msg[0])R 					break;	' 				if (1 == sscanf (msg, "%u", &ch) &&,! 				    ch >= 8/2 && ch <= 8*8) {" 					st.StFontSize = ch; 					break;C 				}A 			}	 			break;v 		}  		if (MENU_FAILED != sel)t 			menu_close ();l 	}   	return (0); }    /* Select HUD radar options. */  " static MENU FAR	MenuHudRadar[] = { 	{'0', "off"},		/*  0 */ 	{'1', "on"},		/*  1 */  	{'2', "toggle"},	/*  2 */ 	{'C', "corner"},	/*  3 */ 	{'d', "data"},		/*  4 */  	{'D', "distance"},	/*  5 */ 	{'n', "name"},		/*  6 */a 	{'a', "accvect"},	/*  7 */- 	{'r', "reticle"},	/*  8 */k 	{'t', "target"},	/*  9 */ 	{'z', "ross"},		/* 10 */) 	{'L', "limit"},		/* 11 */ 	{'H', "thick"},		/* 12 */ 	{'h', "hidetgt"},	/* 13 */	 	{'p', "tpointer"},	/* 14 */ 	{'v', "vpointer"},	/* 15 */ 	{'l', "lead mode"},	/* 16 */( {'\0', 0}};e   LOCAL_FUNC int NEARk menu_hudradar (void) {i 	int	sel, quit;e 	int	i;N   	SetOption (0, 2);	 	sel = 0;S 	for (quit = 0; !quit;) {L$ 		sel = menu_open (MenuHudRadar, 0); 		switch (sel) { 		case MENU_ABORTED: 		case MENU_FAILED:1
 		default: 			quit = 1;	 			break;_	 		case 0:b	 		case 1:a	 		case 2:S 			SetOption (0, sel);	 			break;;	 		case 3: ) 			SetOption (&EE(CV)->hud1, HUD_CORNER);,	 			break;L	 		case 4:k& 			SetOption (&EE(CV)->hud, HUD_DATA);	 			break;U	 		case 5:e( 			SetOption (&EE(CV)->hud1, HUD_IDIST);	 			break;E	 		case 6:b( 			SetOption (&EE(CV)->hud1, HUD_INAME);	 			break;		 		case 7:E* 			SetOption (&EE(CV)->hud1, HUD_ACCVECT);	 			break;;	 		case 8:S) 			SetOption (&EE(CV)->hud, HUD_RETICLE);		 			break;n	 		case 9:{( 			SetOption (&EE(CV)->hud, HUD_TARGET);	 			break;2
 		case 10:& 			SetOption (&EE(CV)->hud, HUD_ROSS);	 			break;b
 		case 11:( 			SetOption (&EE(CV)->hud1, HUD_LIMIT);	 			break;*
 		case 12:( 			SetOption (&EE(CV)->hud1, HUD_THICK);	 			break;t
 		case 13:* 			SetOption (&EE(CV)->hud2, HUD_HIDETGT);	 			break;(
 		case 14:+ 			SetOption (&EE(CV)->hud2, HUD_TPOINTER);e	 			break;n
 		case 15:+ 			SetOption (&EE(CV)->hud2, HUD_VPOINTER); 	 			break; 
 		case 16:* 			i = (EE(CV)->radar & R_MODES) / R_MODE; 			i = (i + 1) % 5;, 			EE(CV)->radar &= ~R_MODES;  			EE(CV)->radar |= i * R_MODE;P	 			break;  		}e 		if (MENU_FAILED != sel)i 			menu_close ();H 	}   	return (0); }    /* Select HDD options. */   static MENU FAR	MenuHdd[] = {k 	{'0', "off"},		/*  0 */ 	{'1', "on"},		/*  1 */R 	{'2', "toggle"},	/*  2 */ 	{'i', "instruments"},	/*  3 */D 	{'n', "nav"},		/*  4 */ 	{'c', "compass"},	/*  5 */	 	{'q', " square"},	/*  6 */r 	{'o', " ortho"},	/*  7 */ {'\0', 0}};    LOCAL_FUNC int NEARP menu_hdd (void), {f 	int	sel, quit;{   	SetOption (0, 2);	 	sel = 0;o 	for (quit = 0; !quit;) {a 		sel = menu_open (MenuHdd, 0);e 		switch (sel) { 		case MENU_ABORTED: 		case MENU_FAILED:/
 		default: 			quit = 1;	 			break; 	 		case 0:}	 		case 1: 	 		case 2:w 			SetOption (0, sel);	 			break; 	 		case 3:P- 			SetOption (&EE(CV)->hdd, HDD_INSTRUMENTS);2	 			break;,	 		case 4:	% 			SetOption (&EE(CV)->hdd, HDD_NAV); 	 			break;p	 		case 5:1) 			SetOption (&EE(CV)->hdd, HDD_COMPASS);"	 			break;*	 		case 6:T, 			SetOption (&EE(CV)->hdd, HDD_SQRCOMPASS);	 			break;N	 		case 7:h, 			SetOption (&EE(CV)->hdd, HDD_ORTCOMPASS);	 			break;; 		}l 		if (MENU_FAILED != sel)i 			menu_close ();u 	}   	return (0); };   /* Select HUD sub-menu */   static MENU FAR	MenuHud[] = {  	{'0', "HUD off"},	/*  0 */	 	{'u', "HUD on"},	/*  1 */ 	{'t', "type"},		/*  2 */  	{'p', "parts"},		/*  3 */ 	{'1', "options1"},	/*  4 */ 	{'2', "options2"},	/*  5 */ 	{'r', "radar"},		/*  6 */ 	{'i', "ils"},		/*  7 */ 	{'d', "hdd"},		/*  8 */ 	{'h', "help"},		/*  9 */  {'\0', 0}};	   extern int FAR menu_hud (void)I {;	 	int	sel; 
 	Ushort	list;	   	if (!IS_PLANE(CV))d
 		return (0);    	if (st.flags & SF_VERBOSE) {p 		list = set_lists (0);V 		set_lists (SF_HUD);9 	}   	sel = menu_open (MenuHud, 0);   	switch (sel) {	 	case MENU_ABORTED:n 	case MENU_FAILED:	 	default:b 		break; 	case 0: 		EE(CV)->hud &= ~HUD_ON;  		break; 	case 1: 		EE(CV)->hud |= HUD_ON; 		break; 	case 2: 		menu_hudtype (); 		break; 	case 3: 		menu_hudparts ();  		break; 	case 4: 		menu_hudoptions1 (); 		break; 	case 5: 		menu_hudoptions2 (); 		break; 	case 6: 		menu_hudradar ();- 		break; 	case 7: 		menu_ils (); 		break; 	case 8: 		menu_hdd (); 		break; 	case 9: 		set_lists (SF_HUD);  		break; 	} 	if (MENU_FAILED != sel) 		menu_close ();   	if (st.flags & SF_VERBOSE)d 		set_lists (list);  	return (0); }    extern void FAR= hud_setup (OBJECT *p)) { 
 	int	font;  ( 	EX->hud  &= HUD_ON|HUD_CURSOR|HUD_ROSS;5 	EX->hud1 &= HUD_TYPES|HUD_INAME|HUD_IDIST|HUD_PANEL;	 	EX->hud2 &= HUD_ILS|HUD_XGRID;  	EX->hud3 &= HUD_GVV;  	EX->ladder = 0;  $ 	EX->hud  |= HUD_DEFAULT|HUD_LADDER;8 	EX->hud1 |= HUD_VALARM|HUD_AALARM|HUD_LIMIT|HUD_BORDER;; 	EX->hud2 |= HUD_HEADING|HUD_ALTITUDE|HUD_SPEED|HUD_XBREAK;, 	EX->hud3 |= HUD_CUE;{    	switch (EX->hud1 & HUD_TYPES) { 	case HUD_F15:) 		EX->hud  |= HUD_FINE|HUD_PLUS|HUD_DATA;h$ 		EX->hud1 |= HUD_KNOTS|HUD_ACCVECT; 		EX->hud2 |= HUD_HIDETGT; 		EX->ladder |= LD_NEGTIP; 		EX->hudarea = 10;u 		EX->hudshift = FCON (0.40);u 		EX->ldgap = FCON(0.077); 		EX->ldstep = FCON(0.238);N 		EX->ldstep0 = FCON(0.391);% 		EX->ldstepg = FCON(0.61);	/* ??? */  		EX->ldtip = FCON (0.03); 		EX->ldndash = 5; 		font = 1;  		EX->hudFontSize = FCON(0.06);i 		break; 	case HUD_F16:  		EX->hud  |= HUD_PLUS|HUD_DATA;< 		EX->hud1 |= HUD_KNOTS|HUD_ACCVECT|HUD_PENDULUM|HUD_CORNER;& 		EX->hud2 |= HUD_BTRAIL|HUD_TPOINTER; 		EX->hud3 |= HUD_XVAR;6 		EX->ladder |= LD_NEGTIP; 		EX->hudarea = 11;  		EX->hudshift = FCON (0.50);E 		EX->ldgap = FCON(0.085); 		EX->ldstep = FCON(0.220);p 		EX->ldstep0 = FCON(0.58);) 		EX->ldstepg = FCON(0.58);X 		EX->ldtip = FCON (0.03); 		EX->ldndash = 4; 		font = 1;:  		EX->hudFontSize = FCON(0.045); 		break; 	case HUD_FA18:9' 		EX->hud  |= HUD_FULLHEADING|HUD_DATA;"% 		EX->hud1 |= HUD_KNOTS|HUD_PENDULUM;) 		EX->hud2 |= HUD_VW;t 		EX->hud3 |= HUD_GVV;> 		EX->ladder |= LD_SLANT|LD_ZENITH|LD_UNDER|LD_TIP0|LD_NEGTIP; 		EX->hudarea = 10;	 		EX->hudshift = FCON (0.4); 		EX->ldgap = FCON(0.11);	 		EX->ldstep = FCON(0.23); 		EX->ldstep0 = FCON(0.34);r 		EX->ldstepg = FCON(0.96);  		EX->ldtip = FCON (0.06); 		EX->ldndash = 5; 		font = 1;o 		EX->hudFontSize = FCON(0.06);	 		break; 	case HUD_ETHER:2 		EX->hud  |= HUD_BIG|HUD_XFINE|HUD_DATA|HUD_PLUS; 		EX->hud1 &= ~HUD_BORDER;  		EX->hud1 |= HUD_KNOTS|HUD_TOP;" 		EX->hud2 |= HUD_VW|HUD_TPOINTER; 		EX->hud3 |= HUD_TRUEHEADING; 		EX->ladder |= LD_NEGTIP; 		EX->hudarea = 15;h( 		EX->tapelen = 16;		/* scales length */ 		EX->hudshift = 0;	 		EX->ldgap = FONE/32*5; 		EX->ldstep = FONE/32*12; 		EX->ldstep0 = FONE/32*18;= 		EX->ldstepg= FONE/32*18; 		EX->ldtip = FCON (0.03); 		EX->ldndash = 5; 		font = 1;  		EX->hudFontSize = FCON(0.06);1 		break;	 	default: 2 		EX->hud  |= HUD_BIG|HUD_XFINE|HUD_PLUS|HUD_DATA;  		EX->hud1 |= HUD_KNOTS|HUD_TOP; 		EX->hud2 |= HUD_VW; # 		EX->ladder |= LD_ERECT|LD_NEGTIP;S 		EX->hudarea = 11; ( 		EX->tapelen = 16;		/* scales length */ 		EX->hudshift = FCON (0.3); 		EX->ldgap = FONE/32*5; 		EX->ldstep = FONE/32*12; 		EX->ldstep0 = FONE/32*18;  		EX->ldstepg= FONE/32*18; 		EX->ldtip = FCON (0.03); 		EX->ldndash = 5; 		font = 0;h 		EX->hudFontSize = FCON(0.05);	 		break; 	}! 	if (MODEL_CLASSIC != EP->opt[0])b 		EX->hud  |= HUD_VV;a   	if (!CC || CC == p) 		font_set (font); }b   extern void FAR  cc_setup (void)( {- 	if (st.flags & SF_BLANKER) {, 		EE(CC)->hud1 &= ~HUD_PANEL;(- 		EE(CC)->radar = R_ON | R_LOCK | (3*R_MODE);E& 		EE(CC)->flags |= PF_CHASE | PF_KILL; 		EE(CC)->weapon = WE_M61;# 	} else if (WIN_FULL == st.windows)  		EE(CC)->hud1 |= HUD_PANEL;   	if (WIN_ETHER == st.windows) { 9 		EE(CC)->hud1 = (EE(CC)->hud1 & ~HUD_TYPES) | HUD_ETHER;	 		hud_setup (CC);) 	} }	   extern void FAR	 win_setup (void) {e4 	if (WIN_ETHER == st.windows && CC && IS_PLANE (CC))? 		EE(CC)->hdd |= HDD_COMPASS | HDD_SQRCOMPASS | HDD_ORTCOMPASS;  }t