P /* --------------------------------- init.c --------------------------------- */  / /* This is part of the flight simulator 'fly8'. 6  * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au). */   /* startup code. */   #include "fly.h"     LOCAL_FUNC int NEAR  get_option (char *e) {  	char	t, *p; 	int	errs = 0, itemp;  	long	ltemp;   	while (e[0] == ' ') 		++e; 	if (e[0] == '\0')
 		return (0);   < /* Find first space and replace it with a string terminator. */ 	for (t = 0, p = e; *p; ++p) { 		if (isspace (*p)) { 
 			t = *p;
 			*p = '\0'; 	 			break;  		}  	}   	LogPrintf (" %s\n", e); 	switch (e[0]) {
 	case 'b':! 		if (e[1] >= '0' && e[1] <= '9') " 			st.windows = (int)(e[1] - '0'); 		else if ('e' == e[1])  			st.windows = WIN_ETHER; 		else 			st.windows = WIN_FULL;  		break;
 	case 'c': 		if (get_long (e+2, &ltemp) || ( 		    set_rrggbb (e[1], (Ulong)ltemp)) {# 			LogPrintf ("bad color %s\n", e); 
 			++errs; 		}  		break; 	case 'd':			/* devices */ 		switch (e[1]) {  		case 'k':		/* keyboard */ % 			st.kbdname = STRfree (st.kbdname);  			st.kbdname = STRdup (e+2); 	 			break;  		case 'n':		/* netport */ 			{ 				struct netname	*p;   				if (!NEW (p)) { ( 					LogPrintf ("no mem for netname\n"); 					++errs; 					break;  				}  				p->name = STRdup (e+2);  				p->next = st.netnames; 				st.netnames = p; 			}	 			break;  		case 'p':		/* pointer */% 			st.ptrname = STRfree (st.ptrname);  			st.ptrname = STRdup (e+2); 	 			break;  		case 's':		/* sound */% 			st.sndname = STRfree (st.sndname);  			st.sndname = STRdup (e+2); 	 			break;  		case 't':		/* timer */) 			st.timeropts = STRfree (st.timeropts);  			st.timeropts = STRdup (e+2); 	 			break;  		case 'v':		/* video */# 			st.grname = STRfree (st.grname);  			st.grname = STRdup (e+2);	 			break; 
 		default: 			goto too_bad; 		}  		break;
 	case 'D':  		st.dtype = STRfree (st.dtype); 		st.dtype = STRdup (e+1); 		break;
 	case 'f':  		st.fname = STRfree (st.fname); 		st.fname = STRdup (e+1); 		break;
 	case 'F': 		/* already processed */  		break;
 	case 'h':
 	case '?': help:  		welcome (2); #ifdef NOSTDERR  #define SHOW(x)	LogPrintf (x)  #else # #define SHOW(x)	fprintf (stderr, x)  #endif# 		SHOW ("usage: fly8 [options]\n"); , 		SHOW ("       see ini.doc for options\n"); #undef SHOW 	 		++errs;  		break;
 	case 'H':& 		st.homename = STRfree (st.homename); 		st.homename = STRdup (e+1);  		break;
 	case 'i':& 		st.initkeys = STRfree (st.initkeys); 		st.initkeys = STRdup (e+1);  		break;
 	case 'I': 		/* already processed */  		break;
 	case 'L': 		/* already processed */  		break;
 	case 'm':$ 		st.grmname = STRfree (st.grmname); 		st.grmname = STRdup (e+1); 		break;
 	case 'M':  		st.mname = STRfree (st.mname); 		st.mname = STRdup (e+1); 		break;
 	case 'n': 		if (get_long (e+2, &ltemp)) {  bad_num:) 			LogPrintf ("bad number in '%s'\n", e); 
 			++errs;	 			break;  		}  		switch (e[1]) { 0 		case 'b':		/* max num of display list lines */# 			itemp = (int)(ltemp/BUFLEN*2+1);  			if (itemp < 20) 				goto bad_num; ! 			st.maxbuffers = (Ushort)itemp; 	 			break; 2 		case 'i':		/* plane dynamics minimal interval */ 			if (ltemp < 1)  				goto bad_num;  			st.misc[6] = (int)ltemp; 	 			break; ! 		case 'l':		/* log flush rate */ " 			if (ltemp < 0 || ltemp > 30000) 				goto bad_num;  			st.misc[9] = (int)ltemp; 	 			break;   		case 'm':		/* num of macros */ 			if (ltemp < 1)  				goto bad_num;  			st.nMacros = (Ushort)ltemp;	 			break; , 		case 'r':		/* history recall queue size */ 			if (ltemp < 1)  				goto bad_num;   			st.maxrecall = (Ushort)ltemp;	 			break; , 		case 't':		/* num of secs till shutdown */ 			if (ltemp < 0)  				goto bad_num; ! 			st.ShutdownTime = ltemp*1000L; 	 			break; 
 		default: 			goto too_bad;	 			break;  		}  		break;
 	case 'N':$ 		st.nikname = STRfree (st.nikname);
 		if (e[1]) {  			st.nikname = STRdup (e+1); : 			if (strlen (st.nikname) >LNAME-1)   /* keep it short */ 				st.nikname[LNAME-1] = '\0';  		}  		break;
 	case 'o': 		SetOption (0, itemp = 1);  		for (p = e + 1; *p; ++p) { 			switch (*p) { 			case '-': 				SetOption (0, itemp = 0); 
 				break; 			case '+': 				SetOption (0, itemp = 1); 
 				break; 			case '^': 				SetOption (0, itemp = 2); 
 				break; 			case 'l':( 				SetOption (&st.flags, SF_LANDSCAPE);
 				break; 			case 'q': 				if (0 == itemp) " 					st.quiet = 1;	/* quiet off */ 				else if (1 == itemp)! 					st.quiet = 0;	/* quiet on */  				else# 					st.quiet = (st.quiet + 1) % 3; 
 				break; 			case 'v':& 				SetOption (&st.flags, SF_VERBOSE);
 				break; 			default:  				goto too_bad;  			} 		}  		break;
 	case 'P':  		st.ptype = STRfree (st.ptype); 		st.ptype = STRdup (e+1); 		break;
 	case 'r': 		itemp = 1; 		if (e[itemp] == '0') { 			st.network &= ~NET_ON;  			++itemp;  		} else 			st.network |= NET_ON; 		if (e[itemp] == 'l') { 			++itemp;  			if (e[itemp] == '0') {  				st.network &= ~NET_NOBCAST;  				++itemp;	 			} else  				st.network |= NET_NOBCAST; 		}  		break;
 	case 'T':& 		st.teamname = STRfree (st.teamname);
 		if (e[1]) {  			st.teamname = STRdup (e+1);: 			if (strlen (st.teamname) >LNAME-1)  /* keep it short */  				st.teamname[LNAME-1] = '\0'; 		}  		break;
 	case 'V': 		if ('\0' == e[1]) { 
 			++errs;
 			goto help;  		} $ 		st.vmdname = STRfree (st.vmdname); 		st.vmdname = STRdup (e+1); 		break;
 	case 'X':$ 		st.navname = STRfree (st.navname); 		st.navname = STRdup (e+1); 		break;
 	case 'Y':$ 		st.lndname = STRfree (st.lndname); 		st.lndname = STRdup (e+1); 		break;
 	case 'z': 		st.flags ^= SF_BLANKER; 
 		if (e[1]) {  			if (get_int (e+1, &itemp) ||  				itemp < 0) { 				LogPrintf ("use -znn\n");  				++errs;  			} 			st.drones = itemp;  		} else 			st.drones = 0;  		break;	 	default:  too_bad:' 		LogPrintf ("unknown option %s\n", e); 	 		++errs;  		break; 	} 	if (t) 	 		*p = t;  	return (errs);  }    LOCAL_FUNC int NEAR  get_argopts (char **a) {  	int	errs = 0;	 	char	*p;    	if (*a)% 		LogPrintf ("command line args:\n");    	while (T(p = *a++)) { 		p = STRdup (p+(p[0] == '-'));  		errs += get_option (p);  		p = STRfree (p); 	} 	return (errs);  }    LOCAL_FUNC int NEAR  get_envopts (void) {  	char	*e, *p, *q;  	int	errs = 0;   	e = getenv ("FLY8"); 	 	if (e) {  		LogPrintf ("env args:\n"); 		e = STRdup (e);  		for (p = e; p && *p; p = q) { % 			while (*p == ' ')	/* find start */  				++p; 			if (*p == '\0')
 				break;& 			q = strchr (p, ';');	/* find end */	 			if (q)  				*q = '\0';	/* end string */  			errs += get_option (p);$ 			*q++ = ';';		/* restore string */ 		}  		e = STRfree (e); 	} 	return (errs);  }    LOCAL_FUNC FILE * NEAR find_ini (void)  {  	FILE	*ini;  	char	*e, *p, *q;    	if (!st.iname)  		st.iname = STRdup (INIFILE);  ' 	if (T(ini = fopen (st.iname, RTMODE)))  		return (ini);    	if (st.fdir) { : 		Sys->BuildFileName (st.filename, st.fdir, st.iname, "");- 		if (T(ini = fopen (st.filename, RTMODE))) { ! 			st.iname = STRfree (st.iname); # 			st.iname = STRdup (st.filename);  			return (ini); 		}  	}   	if (T(e = getenv ("HOME"))) {4 		Sys->BuildFileName (st.filename, e, st.iname, "");- 		if (T(ini = fopen (st.filename, RTMODE))) { ! 			st.iname = STRfree (st.iname); # 			st.iname = STRdup (st.filename);  			return (ini); 		}  	}   	if (T(e = getenv ("PATH"))) { 		e = STRdup (e);  		for (p = e; p && *p; p = q) { * 			q = strchr (p, PATHSEP);	/* find end */	 			if (q) ! 				*q++ = '\0';	/* end string */ 5 			Sys->BuildFileName (st.filename, p, st.iname, ""); . 			if (T(ini = fopen (st.filename, RTMODE))) {" 				st.iname = STRfree (st.iname);$ 				st.iname = STRdup (st.filename); 				return (ini);  			} 		}  		e = STRfree (e); 	} 	return (ini); }    LOCAL_FUNC int NEAR  get_iniopts (void) {  	int	errs = 0, l;  	FILE	*ini;  	char	opt[256], *p;    	if (!(ini = find_ini ()))
 		return (0);   $ 	LogPrintf ("%s args:\n", st.iname);) 	while (fgets (opt, sizeof (opt), ini)) { " 		for (p = opt; isspace (*p); ++p) 			;2 		if ('\n' == p[0] || '#' == p[0] || '\0' == p[0]) 			continue; 		l = strlen(p);# 		p[l-1] = '\0';		/* remove '\n' */- 		errs += get_option (p);p 	} 	if (ferror (ini)) {% 		perror ("error reading init file");(	 		++errs;n   	}   	fclose (ini); 	return (errs);/ }    LOCAL_FUNC OBJECT * NEAR# create_viewer (int type, int nzoom)  {  	OBJECT	*p;   * 	if (T(p = create_object (O_VIEWER, 1))) { 		p->misc[0] = type; 		save_viewport (p); 		zoom (p->viewport, nzoom); 	} elsen) 		MsgEPrintf (-50, "no viewer %u", type);  	return (p); }e   extern void FAR( initialize (char *argv[]); {	 	POINTER	*ptr; 	char	**pp, *p;} 	int	gotit;f 	int	i;,  + 	st.object_id = 1000;			/* reserve 1-999 */> 	st.paralax = 12;' 	st.focus = VMAX; 
 	st.gap = 64;' 	st.quiet = 1; 	st.gravity = (int) (C_G*VONE);_ 	st.windows = WIN_FULL;d 	st.flags  |= SF_PAUSEMSG; 	st.flags1 |= SF_USEG;
 	st.info = 1;) 	st.extview = HDT_RADAR; 	st.maxbuffers = 200;	 	st.maxrecall = 20;r$ 	st.SkyLines = 50;			/* sky lines */ 	st.network |= NET_AUTOACCEPT;- 	st.misc[6] = 100;			/* min plane interval */ . 	st.misc[9] = -1;			/* flush log immediatly */ 	st.nMacros = 256;   /* initial palette settings/ */" 	st.palette[CC_BLACK]   = C_BLACK;  	st.palette[CC_RED]     = C_RED;! 	st.palette[CC_BLUE]    = C_BLUE; $ 	st.palette[CC_MAGENTA] = C_MAGENTA;" 	st.palette[CC_GREEN]   = C_GREEN;" 	st.palette[CC_BROWN]   = C_BROWN;! 	st.palette[CC_GRAY]    = C_GRAY;	$ 	st.palette[CC_DYELLOW] = C_DYELLOW;# 	st.palette[CC_YELLOW]  = C_YELLOW;d% 	st.palette[CC_LRED]    = C_LIGHTRED; & 	st.palette[CC_LBLUE]   = C_LIGHTBLUE;& 	st.palette[CC_LGRAY]   = C_LIGHTGRAY;! 	st.palette[CC_SPARE1]  = C_GRAY; $ 	st.palette[CC_SKYBLUE] = C_SKYBLUE;# 	st.palette[CC_DGREEN]  = C_DGREEN;+" 	st.palette[CC_WHITE]   = C_WHITE;   /* default pixel settingse */* 	for (i = 0; i < rangeof (st.colors); ++i) 		st.colors[i] = i;    /* default colors assignements */ 	ST_INFO   = CC_WHITE; 	ST_MFG    = CC_WHITE; 	ST_WFG    = CC_GREEN; 	ST_CFG    = CC_RED; 	ST_HFG    = CC_DYELLOW; 	ST_HFGI   = CC_YELLOW;  	ST_HBO    = CC_GRAY;  	ST_SLEFT  = CC_RED; 	ST_SRIGHT = CC_BLUE;c 	ST_SBOTH  = CC_MAGENTA; 	ST_GROUND = CC_GRAY;d 	ST_DULL   = CC_GRAY;H 	ST_FAINT  = CC_LGRAY; 	ST_SKY    = CC_SKYBLUE; 	ST_FRIEND = CC_LBLUE; 	ST_FOE    = CC_LRED;[ 	ST_HELP   = CC_GREEN; 	ST_FIRE1  = CC_WHITE; 	ST_FIRE2  = CC_RED; 	ST_MENU   = CC_LGRAY; 	ST_MENUH  = CC_WHITE;   	sim_set ();   	Sys = &SysNone; 	Tm = &TmNone; 	Snd = &SndNone; 	Kbd = &KbdNone;  F /* First we bring up the system and time drivers, these are essential. */  + 	if (F(Sys = &SysDriver) || Sys->Init ()) {a 		Sys = &SysNone;*) 		LogPrintf ("system mgr init failed\n");:	 		die ();a 	}  ) 	if (F(Tm = &TmDriver) || Tm->Init (0)) {  		Tm = &TmNone; ( 		LogPrintf ("timer mgr init failed\n");	 		die ();a 	} 	st.big_bang = Tm->Milli ();   	if (mem_init ()) {() 		LogPrintf ("memory mgr init failed\n");b	 		die ();n 	}   	Frandomize ();r  & 	for (pp = argv+1; T(p = *pp); ++pp) { 		if ('-' == p[0]) 			++p;s 		if ('I' == p[0]) {! 			st.iname = STRfree (st.iname);  			st.iname = STRdup (p+1);b 		} else if ('F' == p[0]) {( 			st.fdir = STRfree (st.fdir);e 			st.fdir = STRdup (p+1); 		} else if ('L' == p[0]) {p 			if ('\0' != p[1]) {  				st.lname = xfree (st.lname); 				st.lname = strdup (p+1); 			} 		}e 	}   	if (log_init ()) 	 		die ();0   	if (msg_init ()) {  		LogPrintf ("no messages\n");	 		die ();	 	}  . 	LogPrintf ("Fly8 start: %s\n", Tm->Ctime ());& 	LogPrintf ("Program  %s\n", argv[0]);
 	welcome (1);e  > 	if (get_iniopts () || get_envopts () || get_argopts (argv+1))	 		die ();o   	if (-1 == st.misc[9])2 		st.misc[9] = 1000;		/* flush log on 1sec idle */  / 	if (st.timeropts && Tm->Init (st.timeropts)) {	 		Tm = &TmNone;	' 		LogPrintf ("timer re-init failed\n");k	 		die ();l 	} 	if (!st.nikname)	" 		st.nikname = STRdup ("JohnDoe"); 	if (!st.teamname) 		st.teamname = STRdup ("[*]");   3 	Fsrand ((int)Tm->Milli ());		/* don't be boring */n   	if (funcs_init ()) {i$ 		LogPrintf ("funcs init failed\n");	 		die ();  	}   	Kbd = kbrd_init (st.kbdname);& 	if (!Kbd || Kbd->Init (st.kbdname)) { 		Kbd = &KbdNone;)' 		LogPrintf ("keyboard init failed\n"); 	 		die ();	 	}  D /* In the next section 'Snd' is temporarily set to zero. Handle this0  * carefully since many programs use it blindly. */ 	gotit = 0;eB 	if (F(Snd = sound_init (st.sndname)) || Snd->Init (st.sndname)) {$ 		Snd = &SndNone;		/* always safe */$ 		LogPrintf ("sound init failed\n"); 	} else. 		gotit = 1;J 	if (!gotit && st.sndname && (F(Snd = sound_init (0)) || Snd->Init (0))) {$ 		Snd = &SndNone;		/* always safe */, 		LogPrintf ("default sound init failed\n"); 	} elsed 		gotit = 1;  > 	if (!gotit && (F(Snd = sound_init ("")) || Snd->Init (""))) {$ 		Snd = &SndNone;		/* always safe */. 		LogPrintf ("'NoSound' sound init failed\n");	 		die ();= 	}# 	st.sndname = STRfree (st.sndname);.! 	st.sndname = STRdup (Snd->name);=   	if (!NEW (CS)) { = 		LogPrintf ("out of memory [%s(%u)]\n", __FILE__, __LINE__); 	 		die ();; 	}   	if (!NEW (CW)) {o= 		LogPrintf ("out of memory [%s(%u)]\n", __FILE__, __LINE__); 	 		die ();. 	}   	if (!NEW (CP)) { = 		LogPrintf ("out of memory [%s(%u)]\n", __FILE__, __LINE__);L	 		die ();  	}  , 	if (0 == (Gr = devices_init (st.grname))) {& 		LogPrintf ("devices init failed\n");	 		die ();  	}  * 	CS->device = devices_select (st.grmname);; 	if (CS->device == 0 || Gr->Init (CS->device, st.grname)) {  		if (st.grmname) {a, 			LogPrintf ("no device: %s\n", st.grname);" 			LogPrintf ("trying default\n"); 			devices_release ();& 			CS->device = devices_select (NULL); 		} else 			CS->device = 0;< 		if (CS->device == 0 || Gr->Init (CS->device, st.grname)) { 			devices_release (); 			LogPrintf ("no device\n");)
 			die (); 		}  	}' 	if (!Gr->SetVisual || !	Gr->SetActive). 		CS->device->npages = 1;f   /* Default color assignments.n */ 	CS->FgColor = CC_WHITE; 	CS->BgColor = CC_BLACK; 	CS->BoColor = CC_LGRAY;  ) 	for (i = 0; i < rangeof (st.hdd); ++i) {o 		st.hdd[i].FgColor = CC_WHITE;; 		st.hdd[i].BgColor = CC_BLACK;i 		st.hdd[i].BoColor = CC_LGRAY;  	}   	set_palette ();
 	set_main ();+   /* Now we are in graphics mode!i */# 	st.grmname = STRfree (st.grmname); ( 	st.grmname = STRdup (CS->device->name);   	font_set (0); 	st.StFontSize = 8;    	if (mac_init ()) {g 		LogPrintf ("no macros");	 		die ();t 	}  , 	MsgPrintf (-100, "System   %s", Sys->name);+ 	MsgPrintf (-100, "Timer    %s", Tm->name); + 	MsgPrintf (-100, "Graphics %s", Gr->name); - 	MsgPrintf (-100, " vmodes  %s", st.vmdname); - 	MsgPrintf (-100, " mode    %s", st.grmname); , 	MsgPrintf (-100, "Sound    %s", Snd->name);, 	MsgPrintf (-100, "Keyboard %s", Kbd->name);  0 	MsgPrintf (-100, "nBuffers %u", st.maxbuffers);   	if (edit_init ()) { 		LogPrintf ("no edit_str\n");	 		die ();t 	}   	if (pointers_init ()) { 		LogPrintf ("no pointers\n");	 		die ();T 	}   	if (bodies_init ()) { 		LogPrintf ("no bodies\n");	 		die ();t 	}   	if (land_init ()) { 		LogPrintf ("no land\n");	 		die ();e 	}   	if (nav_init ()) {  		LogPrintf ("no nav\n");s	 		die ();T 	}. 	if ((st.home = nav_find (st.homename)) < 0) {4 		LogPrintf ("bad home name \"%s\"\n", st.homename); 		st.home = 0; 	}  B /* We are initialized, now get us a plane. First find the pointer. */, 	if (F(ptr = pointer_select (st.ptrname))) { 		if (st.ptrname) {r/ 			MsgEPrintf (-100, "no ptr: %s", st.ptrname);)% 			st.ptrname = STRfree (st.ptrname);  		};% 		MsgPrintf (-100, "trying default");	' 		if (F(ptr = pointer_select (NULL))) {0 			LogPrintf ("no pointer\n");
 			die (); 		}i" 		st.ptrname = STRdup (ptr->name); 	}, 	MsgPrintf (-100, "Pointer  %s", ptr->name);   	CO = COT = 0;   	st.options = st.ptype;u* 	if (!(CC = create_object (O_PLANE, 1))) {( 		LogPrintf ("no plane %s\n", st.ptype); 		pointer_release (ptr);	 		die ();n 	} 	CC->pointer = ptr;r 	ptr->l[9] = 100;		/* brakes */p 	CC->flags |= F_CC | F_FRIEND; 	CC->color = CC_LBLUE; 	CC->gpflags |= GPF_PILOT; 	place_plane (CC, st.home); 	 	CV = CC;f  ! /* Establish the virtual viewers.p */ 	create_viewer (HDT_FRONT, 0); 	create_viewer (HDT_REAR, 0);p 	create_viewer (HDT_MAP, 0); 	create_viewer (HDT_RADAR, 0);  	create_viewer (HDT_TARGET, 12); 	create_viewer (HDT_PAN, 12);{ 	create_viewer (HDT_GAZE, 0);  	create_viewer (HDT_CHASE, 0); 	create_viewer (HDT_FOLLOW, 0);    	create_viewer (HDT_RIGHT, 0); 	create_viewer (HDT_LEFT,  0);  ; 	create_viewer (HDT_MIRROR, -3);		/* somewhat wide angle */{   /* Now get the net going.e */ 	remote_init ();   /* We made it, tell the world. */' 	welcome (0);			/* welcome everybody */r 	if (st.quiet) {" 		Snd->Effect (EFF_HELLO, SND_ON); 		if (st.quiet >= 2)$ 			Snd->Effect (EFF_ENGINE, SND_ON); 	}  
 	cc_setup ();e   	double_buffer (SF_DBUFFERING);>   	st.flags |= SF_INITED;o 	if (Gr->Shutters)# 		Gr->Shutters (-1);		/* turn on */    	st.DroneTime = st.present;w   	{7 		static Ushort	keys[] = {KF_INIT};	/* startup macro */E 		Ushort		key, shift;.	 		int		i;D   		if (NULL == st.initkeys)( 			mac_interpret (keys, rangeof (keys)); 		else { 			shift = K_CTRL;. 			for (i = 0; T(key = st.initkeys[i]); ++i) { 				if ('C' == key)  					shift = K_CTRL; 				else if ('A' == key) 					shift = K_ALT;  				else if (isalpha (key)) { % 					keys[0] = shift + tolower (key); * 					mac_interpret (keys, rangeof (keys)); 				} else {' 					MsgEPrintf (-100, "bad initkeys");A 					break;a 				}C 			} 		}  	}   	log_flush (1);C   	sim_reset (); } 