P /* --------------------------------- mouse.c -------------------------------- */  / /* This is part of the flight simulator 'fly8'. 6  * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au). */  . /* Handler for the mouse as a pointing device. */   #include "fly.h"   #include <dos.h>    8 #define USELOG		0x0001		/* log scale on x/y (default) */   #define PO		p->opt #define FA1D		PO[0]  #define FA1F		PO[1]  #define FA2D		PO[2]  #define FA2F		PO[3]  #define FSPEEDX		PO[4] #define FSPEEDY		PO[5] #define FOPTS		PO[6]   static int	nbuttons = 2;   LOCAL_FUNC int FAR MikCal (POINTER *p)  { 8 	union REGS	rg;		/* cpu register for use of DOS calls */  / 	rg.x.ax = 4;			/* set mouse cursor position */ & 	rg.x.cx = 100 << 3;		/* middle col */& 	rg.x.dx = 100 << 3;		/* middle row */ 	int86(0x33, &rg, &rg);  	p->a[FA1F] = p->a[FA2F] = 0;  	p->l[FA1F] = p->l[FA2F] = 0;  	return (0); }    LOCAL_FUNC int FAR# MikInit (POINTER *p, char *options)  { 8 	union REGS	rg;		/* cpu register for use of DOS calls */7 	struct SREGS segreg;		/* cpu segment registers	     */ 4 	long		miaddr;		/* mouse interupt routine address */	 	long		l;    	p->flags = 0;  ( /* check if the mouse drive exists first */: 	rg.x.ax = 0x3533;		/* look at the interrupt 33 address */! 	int86x(0x21, &rg, &rg, &segreg); 4 	miaddr = (((long)segreg.es) << 16) + (long)rg.x.bx;1 	if (0 == miaddr || 0x0cf == *(char FAR *)miaddr) 
 		return (1);    /* check for mouse present */' 	rg.x.ax = 0;			/* mouse status flag */ ; 	int86(0x33, &rg, &rg);		/* check for the mouse interupt */  	if (rg.x.ax == 0)
 		return (2);  	p->flags |= PF_PRESENT; 	nbuttons = rg.x.bx;  # 	if (get_narg (options, "sx=", &l))  		FSPEEDX = 2; 	else  		FSPEEDX = (int)l;   # 	if (get_narg (options, "sy=", &l))  		FSPEEDY = 2; 	else  		FSPEEDY = (int)l;   ! 	if (get_arg (options, "linear"))  		FOPTS &= ~USELOG;  	else  		FOPTS |= USELOG;   #if 0  /* set mouse attributes  */& 	rg.x.ax = 10;			/* set text cursor */1 	rg.x.bx = 0;			/* software text cursor please */ % 	rg.x.cx = 0x77ff;		/* screen mask */ % 	rg.x.dx = 0x7700;		/* cursor mask */  	int86(0x33, &rg, &rg);  #endif  " /* set number of columns for mouse */5 	rg.x.ax = 7;			/* set min/max horizontal position */   	rg.x.cx = 0;			/* start at 0 */) 	rg.x.dx = 200 << 3;	/* end at the end */  	int86(0x33, &rg, &rg);   ( /* set number of vertical rows for mouse */3 	rg.x.ax = 8;			/* set min/max vertical position */   	rg.x.cx = 0;			/* start at 0 */) 	rg.x.dx = 200 << 3;	/* end at the end */  	int86(0x33, &rg, &rg);    /* set mouse speed */ 	rg.x.ax = 15; 	rg.x.cx = FSPEEDX;  	rg.x.dx = FSPEEDY;  	int86(0x33, &rg, &rg);    #if 0  /* turn the mouse cursor on  */! 	rg.x.ax = 1;			/* Show Cursor */  	int86(0x33, &rg, &rg);   ! /* turn the mouse cursor back off  */! 	rg.x.ax = 2;			/* Hide Cursor */  	int86(0x33, &rg, &rg);  #endif 	p->flags |= PF_INITED;   % /* get it in the middle of the screen  */ 	MikCal (p);   	return (0); }    LOCAL_FUNC void FAR  MikTerm (POINTER *p) {  	p->flags = 0; }    LOCAL_FUNC int FAR" MikRead (POINTER *p, int transfer) {  	union REGS	rg;  	char		btn[3]; 	int		reading;  9 	rg.x.ax = 3;		/* Get button status and mouse position */  	int86(0x33, &rg, &rg);   ) 	reading = (rg.x.dx >> 3) - 100;		/* x */  	reading *=  FA2D; 	p->a[FA2F] = reading; 	if (transfer)> 		p->l[FA2F] = (FOPTS & USELOG) ? lin2log (reading) : reading;  ) 	reading = (rg.x.cx >> 3) - 100;		/* y */  	reading *=  -FA1D;  	p->a[FA1F] = reading; 	if (transfer)> 		p->l[FA1F] = (FOPTS & USELOG) ? lin2log (reading) : reading;  0 	btn[0] = T(rg.x.bx & 0x02);		/* right button *// 	btn[1] = T(rg.x.bx & 0x01);		/* left button */  	if (nbuttons > 2) {3 		btn[2] = T(rg.x.bx & 0x04);	/* middle button ? */  		reading = 3; 	} else  		reading = 2; 	do_btns (p, btn, reading);    	return (0); }   " struct PtrDriver NEAR PtrMouse = {	 	"MOUSE",  	0,  	NULL,	/* extra */	 	MikInit, 	 	MikTerm,  	MikCal, 	MikCal,			/* center */ 	 	MikRead,  	std_key };
 #undef USELOG 	 #undef PO  #undef FA1D  #undef FA1F  #undef FA2D  #undef FA2F  #undef FSPEEDX #undef FSPEEDY #undef FOPTS  