 /* linux/kernel/chr_drv/joystick.c +    Copyright (C) 1992, 1993 Arthur C. Smith C    Joystick driver for Linux running on an IBM compatable computer.   
 VERSION INFO: 8 01/08/93	ACS	0.1: Works but needs multi-joystick support> 01/13/93	ACS	0.2: Added multi-joysitck support (minor 0 and 1)5 		  	     Added delay between measuring joystick axis  		   	     Added scaling ioctl@ 02/16/93	ACS	0.3: Modified scaling to use ints to prevent kernel 			     panics 8-)@ 02/28/93	ACS	0.4: Linux99.6 and fixed race condition in js_read.6 			     After looking at a schmatic of a joystick cardN                              it became apparent that any write to the joystick; 			     port started ALL the joystick one shots. If the one 9 			     that we are reading is short enough and the first < 		 	     one to be read, the second one will return bad data: 			     if it's one shot has not expired when the joystick8 			     port is written for the second time. Thus solves) 			     the mystery delay problem in 0.2! C 04/22/93	ACS/Eyal 0.5:Upgraded the driver to the 99.8 kernel, added 4 			     joystick support to the make config options,3 			     updated the driver to return the buttons as 2 			     positive logic, and read both axis at once 			     (thanks Eyal)!' 12 Feb 94	Eyal	Allow timelimit of zero.  			DO read first time!" 			Return all 4 buttons for port 0' 			DO return correct buttons for port 1 * 			Slight cleaning of analog reading loop.' 			TIMEOUT is now in timer count units. 2 			Rename fields to lower case, remove js_ prefix.) 			Use a private internal data structure. , 			Allow long reads for both sticks at once.- 13 Feb 94	Eyal	Fix header "linux/joystick.h". : 			For compatibility, I still access 'corr' using the same9 			  structure. I'd rather use the struct only for reads. . 			js_init() now recognizes complex joysticks.7 			Check timeout incrementally, to allow large timeouts 3 			  without locking the machine up if the stick is  			  disconnected.9 		?	Should js_open() enforce exclusion? Just checking the ( 			  'busy' flag is not enough, I think.4 			If js_read() times out, DO release the semaphore.; 		?	Is there a need for a better 'corr' logic, like setting & 			  a low/high/range value such that:# 				reading = the_usual_timer_loop;  				if (reading > high)  					reading = high; 				else if (reading < low)  					reading = low; 2 				return (reading - low) * range / (high - low);B 25 Apr 94	Eyal	Merge in the loadable stuff from 0.7 public release! 			(maintained by Carlos Puchol?)  14 Oct 94	Eyal	minor cosmetics. 0  4 Feb 95	Eyal	add <linux/mm.h> 1.1.88 needs it.C 16 May 95	Eyal	drop local version.h, use <linux/version.h>, support  			new modules style. 0 23 May 95	Eyal	Register IO port, nicer messages. 26 May 95	Eyal	Remove cli/sti." 23 Jun 95	Eyal	Restructure driver: 			- set js_exist at open time.   			- redo the semaphore/locking. 			- use do_gettimeofday().  */   #include <linux/config.h>  #include <linux/module.h>  #include <linux/version.h> #include <linux/mm.h>  #include <linux/ioport.h>  #include <linux/time.h>    #include <linux/sched.h> #include <linux/errno.h> #include <linux/major.h>   #include <asm/io.h>  #include <asm/segment.h> #include <asm/system.h>    #include <linux/joystick.h>     #define JS_VERSION	"0.7e (Eyal)" #define JS_NAME		"joystick" 3 #define JS_CLISTI	1		/* no need to cli for reads */ 3 #define JS_BLOCK	1		/* need to serialize access? */ 2 #define MY_TIMER	1		/* directly read hw timer 0 */  " #define GET_USERMEM(kernel,user) \? 	get_usermem ((char *)&kernel, (char *)user, sizeof(kernel), 1)   " #define PUT_USERMEM(kernel,user) \? 	put_usermem ((char *)&kernel, (char *)user, sizeof(kernel), 1)   + static char kernel_version[] = UTS_RELEASE; @ static struct JS_DATA_SAVE_TYPE js_data[JS_MAX];	/* misc data */< static int js_exist = 0;		/* which joysticks' axis exist? */@ static int js_read_semaphore = 0;	/* to prevent two processes */( 					/* from trying to read different */% 					/* joysticks at the same time */    #if MY_TIMERL /* Return the current value of timer 0. This is a 16 bit counter that starts.  * at LATCH and counts down to 0 then repeats. */ inline int   get_timer0 (void)  {  	int	t;    #if !JS_CLISTI 	cli (); #endif 	outb (0, PIT_MODE); 	t  = (int)inb (PIT_COUNTER_0); $ 	t += (int)inb (PIT_COUNTER_0) << 8; #if !JS_CLISTI 	sti (); #endif   	return (t); }  #endif   static void 
 js_lock () {  	int	t;    	for (t = 1; t;) { #if JS_BLOCK	 		cli ();  #endif 		if (!(t = js_read_semaphore))  			js_read_semaphore = 1;  #if JS_BLOCK	 		sti ();  #endif 	} }    static void  js_unlock () {  	js_read_semaphore = 0;  }    static void : get_usermem (char *kernel, char *user, int size, int lock) { / 	verify_area (VERIFY_READ, (void *)user, size); 
 	if (lock)
 		js_lock ();  	while (size-- > 0) # 		*kernel++ = get_fs_byte (user++); 
 	if (lock) 		js_unlock ();  }    static void : put_usermem (char *kernel, char *user, int size, int lock) { 0 	verify_area (VERIFY_WRITE, (void *)user, size);
 	if (lock)
 		js_lock ();  	while (size-- > 0) " 		put_fs_byte (*kernel++, user++);
 	if (lock) 		js_unlock ();  }    static int  B js_ioctl(struct inode *inode, struct file *file, unsigned int cmd, 	unsigned long arg)  { + 	unsigned int	minor = MINOR(inode->i_rdev);   & 	if (MAJOR(inode->i_rdev) != JS_MAJOR) 		return -EINVAL;  	if (minor >= JS_MAX)  		return -ENODEV;    	switch (cmd) {  	case JS_SET_CAL: ) 		GET_USERMEM (js_data[minor].corr, arg);  		break; 	case JS_GET_CAL: ) 		PUT_USERMEM (js_data[minor].corr, arg);  		break; 	case JS_SET_TIMEOUT: , 		GET_USERMEM (js_data[minor].timeout, arg); 		break; 	case JS_GET_TIMEOUT: , 		PUT_USERMEM (js_data[minor].timeout, arg); 		break; 	case JS_SET_TIMELIMIT: . 		GET_USERMEM (js_data[minor].timelimit, arg); 		break; 	case JS_GET_TIMELIMIT: . 		PUT_USERMEM (js_data[minor].timelimit, arg); 		break;	 	default:  		return -EINVAL;  	} 	return (0); }   K /* This is the actual joystick reading. It reads all channels always. It is /  * up to the caller to only use what they want.  */
 static int" js_update (int mask, long timeout) { 	 	long		t; 
 	int		chk; 	long		t_x0, t_y0, t_x1, t_y1; #if MY_TIMER
 	int		t0, t1;  #else  	struct timeval	t0, t1;  #endif  # 	t = t_x0 = t_y0 = t_x1 = t_y1 = 0;   
 #if JS_CLISTI  	cli (); #endif #if MY_TIMER 	t0 = get_timer0 (); #else  	do_gettimeofday (&t0);  #endif- 	outb (0, JS_PORT);			/* trigger one-shots */ ; 	while (t < timeout && 0 != (chk = inb (JS_PORT) & mask)) {  #if MY_TIMER 		t1 = get_timer0 ();  		t += DELTA_TIME (t0, t1); 
 		t0 = t1; #else  		do_gettimeofday (&t1);* 		t = (t1.tv_sec - t0.tv_sec) * 1000000L + 			(t1.tv_usec - t0.tv_usec);  #endif 		if (chk & JS_X_0)  			t_x0 = t; 		if (chk & JS_Y_0)  			t_y0 = t; 		if (chk & JS_X_1)  			t_x1 = t; 		if (chk & JS_Y_1)  			t_y1 = t; 	}* 	chk = inb (JS_PORT);			/* read buttons */
 #if JS_CLISTI  	sti (); #endif   /* Update local data register. */@ 	js_data[0].expiretime = CURRENT_JIFFIES + js_data[0].timelimit;1 	js_data[0].x = (int)(t_x0 >> js_data[0].corr.x); 1 	js_data[0].y = (int)(t_y0 >> js_data[0].corr.y); @ 	js_data[0].buttons = (~chk >> 4) & 0x0f;	/* all four buttons */  @ 	js_data[1].expiretime = CURRENT_JIFFIES + js_data[1].timelimit;1 	js_data[1].x = (int)(t_x1 >> js_data[1].corr.x); 1 	js_data[1].y = (int)(t_y1 >> js_data[1].corr.y); D 	js_data[1].buttons = js_data[0].buttons >> 2;	/* only two buttons*/   	return (chk); }    static void  js_reset (unsigned int minor)  { ) 	js_data[minor].corr.x     = JS_DEF_CORR; ) 	js_data[minor].corr.y     = JS_DEF_CORR; , 	js_data[minor].timeout    = JS_DEF_TIMEOUT;. 	js_data[minor].timelimit  = JS_DEF_TIMELIMIT;- 	js_data[minor].expiretime = CURRENT_JIFFIES;  }   K /* The open will verify that this joystick exists even if it was missing at J  * init time. If the stick is disconnected later then timeouts will happenL  * on every read until the next open. This allows for intermittent failures. */
 static int0 js_open (struct inode *inode, struct file *file) { , 	unsigned int	minor = MINOR (inode->i_rdev); 	int		t, mask;   	if (minor >= JS_MAX)  		return -ENODEV;,   	js_lock ();  & 	if (JS_TRUE == js_data[minor].busy) { 		js_unlock ();a 		return -EBUSY; 	}   	js_reset (minor);  5 /* We read all channels to set the global 'js_exist'.3 */2 	t = JS_ALL & ~js_update (JS_ALL, JS_DEF_TIMEOUT);6 	mask = minor ? (JS_X_1 | JS_Y_1) : (JS_X_0 | JS_Y_0);   	js_exist = t;! 	if ((js_exist & mask) != mask) {i #if 0a2 		printk ("%s: open failed js_exist=%x mask=%x\n", 			JS_NAME, js_exist, mask); #endif 		js_unlock ();n 		return -ENODEV;  	}   	js_data[minor].busy = JS_TRUE;t   	js_unlock ();   	MOD_INC_USE_COUNT;    	return (0); }t   static voidh3 js_release (struct inode *inode, struct file *file)  {t+ 	unsigned int	minor = MINOR(inode->i_rdev);s   	js_lock (); 	inode->i_atime = CURRENT_TIME;r  	js_data[minor].busy = JS_FALSE; 	js_unlock ();   	MOD_DEC_USE_COUNT;t }p    /* We support two kinds of read:J  *	- a single joystick read (js0 or js1) which reads two analogue channels.  *	and two buttons. Use JS_DATA_TYPE for this.I  *	- a combined read of all channels (on js0 only). Use JS_DATA_TYPE_LONGn  *	for this. */
 static intF js_read (struct inode *inode, struct file *file, char *buf, int count) { 
 	char		*c;+ 	unsigned int	minor = MINOR(inode->i_rdev);w 	struct JS_DATA_TYPE		js_short;f" 	struct JS_DATA_TYPE_LONG	js_long;  B 	if (!(count == JS_RETURN || (count == JS_RETURN_LONG && !minor))) 		return -EOVERFLOW;   	js_lock ();   	inode->i_atime = CURRENT_TIME;R  B /* Only read if the old data is stale, but then read ALL channels. */2 	if (CURRENT_JIFFIES >= js_data[minor].expiretime)/ 		js_update (js_exist, js_data[minor].timeout);t   /* Deliver data to user memory.t */ 	if (JS_RETURN_LONG == count) { + 		js_long.buttons = js_data[minor].buttons;r 		js_long.x = js_data[0].x;c 		js_long.y = js_data[0].y;	 		js_long.x2 = js_data[1].x; 		js_long.y2 = js_data[1].y; 		c = (char *)&js_long;i	 	} else {e, 		js_short.buttons = js_data[minor].buttons;  		js_short.x = js_data[minor].x;  		js_short.y = js_data[minor].y; 		c = (char *)&js_short; 	}   	js_unlock ();    	put_usermem (c, buf, count, 0);   	return (count); }'    ) static struct file_operations js_fops = {g 	NULL,			/* js_lseek	*/e 	js_read,		/* js_read	*/ 	NULL,			/* js_write	*/i 	NULL,			/* js_readaddr	*/ 	NULL,			/* js_select	*/ 	js_ioctl,		/* js_ioctl	*/ 	NULL,			/* js_mmap	*/ 	js_open,		/* js_open	*/ 	js_release,		/* js_release	*/ 	NULL			/* js_sync	*/l };   #ifdef __cplusplus extern "C" { #endif   int9 init_module (void) {  	int	t;9 	int	js_num;  ' 	printk ("%s %s: MAJOR=%d BASE=0x%x\n",d* 		JS_NAME, JS_VERSION, JS_MAJOR, JS_PORT);  5 	if (register_chrdev (JS_MAJOR, JS_NAME, &js_fops)) { 2 		printk ("%s: unable to get MAJOR=%d\n", JS_NAME,
 			JS_MAJOR);	
 		return (1);e 	}  & 	request_region (JS_PORT, 1, JS_NAME);   	for (t = 0; t < JS_MAX; t++) {- 		  js_data[t].busy = JS_FALSE;i 		  js_reset ((unsigned int)t);e 	}   	js_read_semaphore = 0;i  I /* The rest of this function is done for information only and is not used<&  * to block 'open' of missing devices.  *F  * 'js_num' is the number of joysticks found, 't' means we also found -  * a partial joystick (like FlightStick hat).t */9 	js_exist = JS_ALL & ~js_update (JS_ALL, JS_DEF_TIMEOUT);. 	t = 0;" 	switch (js_exist) {! 	case JS_ALL:		/* Two complete */o
 		js_num = 2;r 		break;  5 	case JS_0 | JS_X_1:	/* One complete + one partial */d 	case JS_0 | JS_Y_1: 	case JS_1 | JS_X_0: 	case JS_1 | JS_Y_0: 		t = 1; 	case JS_0:		/* One complete */) 	case JS_1:r
 		js_num = 1;( 		break;   	default:		/* One partial */ 		t = 1; 	case 0x00:		/* None at all */
 		js_num = 0;z 		break; 	}  . 	printk ("%s: found %d%s device%s, ", JS_NAME,2 		js_num, t ? "+" : "", (js_num == 1) ? "" : "s");   	return (0); }t   void cleanup_module (void)j {t 	if (MOD_IN_USE)9 		printk ("%s: device busy, remove delayed.\n", JS_NAME);c 	else {  		release_region (JS_PORT, 1);1 		if (unregister_chrdev (JS_MAJOR, JS_NAME) != 0) 4 			printk ("%s: cleanup_module failed.\n", JS_NAME); 		else7 			printk ("%s: cleanup_module succeeded.\n", JS_NAME);  	} }e   #ifdef __cplusplus }t #endif