#include <sys/audio.h>
#include "common.h"

int sound_init(int audiofd, layer *info, int stereo) {
    /* Initialize audio device */
    int		samplefrq = (int)
		    (s_freq[info->version]
		     [info->sampling_frequency] * 1000.0);

    if (ioctl(audiofd, AUDIO_SET_SAMPLE_RATE, samplefrq)) {
	perror("AUDIO_SET_SAMPLE_RATE");
	return 1;
    }
    if (ioctl(audiofd, AUDIO_SET_CHANNELS, stereo)) {
	perror("AUDIO_SET_CHANNELS");
	return 1;
    }
    if (ioctl(audiofd, AUDIO_SET_DATA_FORMAT, AUDIO_FORMAT_LINEAR16BIT)) {
	perror("AUDIO_SET_DATA_FORMAT");
	return 1;
    }
    if (ioctl(audiofd, AUDIO_SET_TXBUFSIZE, 128*1024)) {
	perror("AUDIO_SET_TXBUFSIZE");
	return 1;
    }
    return 0;
}

int sound_open() {
    return(open("/dev/audio", O_WRONLY));
}

int sound_close(int audiofd) {
    return(close(audiofd));
}

int sound_write(int audiofd, const void *buffer, size_t count) {
    return(write(audiofd, buffer, count));
}

