/*
 * You can add new audio devices by creating a .c file that supports
 * all the following functions, and making sure it gets compiled in.
 */

/*
 * Opens the audio device, or at least takes it so we know we can use
 * it. Returns an integer handle, which is negative if something went wrong.
 */
int sound_open();

/*
 * Initializes the device, because now we know stuff like framerate,
 * mono/stereo. This currently looks at some globals, which are of course
 * very mean and ugly. Check the existing .c-files to see what they are.
 * (Eventually they should get de-globalized.) A non-zero return code means
 * something went wrong.
 */
int sound_init(int audiofd, layer *info, int stereo);

/*
 * Write length bytes from buffer to the audio device. Returns the number of
 * bytes written or -1 for an error.
 */
int sound_write(int audiofd, const void *buffer, size_t count);

/*
 * Closes the audio device, uninitializes it, and whatever else your device
 * needs done. A non-zero return code means something went wrong.
 */
int sound_close(int audiofd);
