 /* CRCLIB.C						      */ @ /* Compute 32 BIT ANSI X3.66 CRC checksum on (part of) a file */@ /* Original code by Gary S. Brown.                            */@ /* Adapted 190894 MVB                                         */@ /* VMS 051094 MVB                                             */@ /* Maarten van Breemen                                        */@ /* E-mail: vbreemen@knoware.nl                                */@ /* CIS: 100125,2704                                           */  C #include "crclib.h" /* prototypes of selfcheck() and crc32file() */    #include <stdio.h>   #include <stdlib.h>  #include <string.h>   
 #ifndef __VMS    #include <io.h>    #include <fcntl.h> #else    #include <stat.h>   %   static long filelength(int handle);   $   static long filelength(int handle)   {      struct stat buf;     int result;            result=fstat( handle, &buf);       if (result) return (-1);     return (buf.st_size);    }         #define _MAX_PATH 255       #endif   #define TRUE  1  #define FALSE 0   M /* by changing the crc32 value on a application specific way, the security */ M /* level is increased because the crc32 value is more difficult to hack    */    #define APPLICATION_OFFSET 23   O #define UPDC32(octet,crc) (crc_32_tab[((crc) ^ (octet)) & 0xff] ^ ((crc) >> 8))      H /**********************************************************************\H |* Demonstration program to compute the 32-bit CRC used as the frame  *|H |* check sequence in ADCCP (ANSI X3.66, also known as FIPS PUB 71     *|H |* and FED-STD-1003, the U.S. versions of CCITT's X.25 link-level     *|H |* protocol).  The 32-bit FCS was added via the Federal Register,     *|H |* 1 June 1982, p.23798.  I presume but don't know for certain that   *|H |* this polynomial is or will be included in CCITT V.41, which        *|H |* defines the 16-bit CRC (often called CRC-CCITT) polynomial.  FIPS  *|H |* PUB 78 says that the 32-bit FCS reduces otherwise undetected       *|H |* errors by a factor of 10^-5 over 16-bit FCS.                       *|H \**********************************************************************/I /*                                                                     */ I /* Need an unsigned type capable of holding 32 bits;                   */ I /* Copyright (C) 1986 Gary S. Brown.  You may use this program, or     */ I /* code or tables extracted from it, as desired without restriction.   */ I /* First, the polynomial itself and its table of feedback terms.  The  */ I /* polynomial is                                                       */ I /* X^32+X^26+X^23+X^22+X^16+X^12+X^11+X^10+X^8+X^7+X^5+X^4+X^2+X^1+X^0 */ I /* Note that we take it "backwards" and put the highest-order term in  */ I /* the lowest-order bit.  The X^32 term is "implied"; the LSB is the   */ I /* X^31 term, etc.  The X^0 term (usually shown as "+1") results in    */ I /* the MSB being 1.                                                    */ I /* Note that the usual hardware shift register implementation, which   */ I /* is what we're using (we're merely optimizing it by doing eight-bit  */ I /* chunks at a time) shifts bits into the lowest-order term.  In our   */ I /* implementation, that means shifting towards the right.  Why do we   */ I /* do it this way?  Because the calculated CRC must be transmitted in  */ I /* order from highest-order term to lowest-order term.  UARTs transmit */ I /* characters in order from LSB to MSB.  By storing the CRC this way,  */ I /* we hand it to the UART in the order low-byte to high-byte; the UART */ I /* sends each low-bit to hight-bit; and the result is transmission bit */ I /* by bit from highest- to lowest-order term without requiring any bit */ I /* shuffling on our part.  Reception works similarly.                  */ I /*                                                                     */ I /* The feedback terms table consists of 256, 32-bit entries.  Notes:   */ I /*                                                                     */ I /*  1. The table can be generated at runtime if desired; code to do so */ I /*     is shown later.  It might not be obvious, but the feedback      */ I /*     terms simply represent the results of eight shift/xor opera-    */ I /*     tions for all combinations of data and CRC register values.     */ I /*                                                                     */ I /*  2. The CRC accumulation logic is the same for all CRC polynomials, */ I /*     be they sixteen or thirty-two bits wide.  You simply choose the */ I /*     appropriate table.  Alternatively, because the table can be     */ I /*     generated at runtime, you can start by generating the table for */ I /*     the polynomial in question and use exactly the same "updcrc",   */ I /*     if your application needn't simultaneously handle two CRC       */ I /*     polynomials.  (Note, however, that XMODEM is strange.)          */ I /*                                                                     */ I /*  3. For 16-bit CRCs, the table entries need be only 16 bits wide;   */ I /*     of course, 32-bit entries work OK if the high 16 bits are zero. */ I /*                                                                     */ I /*  4. The values must be right-shifted by eight bits by the "updcrc"  */ I /*     logic; the shift must be unsigned (bring in zeroes).  On some   */ I /*     hardware you could probably optimize the shift in assembler by  */ I /*     using byte-swap instructions.                                   */   I static unsigned long int crc_32_tab[] = { /* CRC polynomial 0xedb88320 */ I   0x00000000, 0x77073096, 0xee0e612c, 0x990951ba, 0x076dc419, 0x706af48f, I   0xe963a535, 0x9e6495a3, 0x0edb8832, 0x79dcb8a4, 0xe0d5e91e, 0x97d2d988, I   0x09b64c2b, 0x7eb17cbd, 0xe7b82d07, 0x90bf1d91, 0x1db71064, 0x6ab020f2, I   0xf3b97148, 0x84be41de, 0x1adad47d, 0x6ddde4eb, 0xf4d4b551, 0x83d385c7, I   0x136c9856, 0x646ba8c0, 0xfd62f97a, 0x8a65c9ec, 0x14015c4f, 0x63066cd9, I   0xfa0f3d63, 0x8d080df5, 0x3b6e20c8, 0x4c69105e, 0xd56041e4, 0xa2677172, I   0x3c03e4d1, 0x4b04d447, 0xd20d85fd, 0xa50ab56b, 0x35b5a8fa, 0x42b2986c, I   0xdbbbc9d6, 0xacbcf940, 0x32d86ce3, 0x45df5c75, 0xdcd60dcf, 0xabd13d59, I   0x26d930ac, 0x51de003a, 0xc8d75180, 0xbfd06116, 0x21b4f4b5, 0x56b3c423, I   0xcfba9599, 0xb8bda50f, 0x2802b89e, 0x5f058808, 0xc60cd9b2, 0xb10be924, I   0x2f6f7c87, 0x58684c11, 0xc1611dab, 0xb6662d3d, 0x76dc4190, 0x01db7106, I   0x98d220bc, 0xefd5102a, 0x71b18589, 0x06b6b51f, 0x9fbfe4a5, 0xe8b8d433, I   0x7807c9a2, 0x0f00f934, 0x9609a88e, 0xe10e9818, 0x7f6a0dbb, 0x086d3d2d, I   0x91646c97, 0xe6635c01, 0x6b6b51f4, 0x1c6c6162, 0x856530d8, 0xf262004e, I   0x6c0695ed, 0x1b01a57b, 0x8208f4c1, 0xf50fc457, 0x65b0d9c6, 0x12b7e950, I   0x8bbeb8ea, 0xfcb9887c, 0x62dd1ddf, 0x15da2d49, 0x8cd37cf3, 0xfbd44c65, I   0x4db26158, 0x3ab551ce, 0xa3bc0074, 0xd4bb30e2, 0x4adfa541, 0x3dd895d7, I   0xa4d1c46d, 0xd3d6f4fb, 0x4369e96a, 0x346ed9fc, 0xad678846, 0xda60b8d0, I   0x44042d73, 0x33031de5, 0xaa0a4c5f, 0xdd0d7cc9, 0x5005713c, 0x270241aa, I   0xbe0b1010, 0xc90c2086, 0x5768b525, 0x206f85b3, 0xb966d409, 0xce61e49f, I   0x5edef90e, 0x29d9c998, 0xb0d09822, 0xc7d7a8b4, 0x59b33d17, 0x2eb40d81, I   0xb7bd5c3b, 0xc0ba6cad, 0xedb88320, 0x9abfb3b6, 0x03b6e20c, 0x74b1d29a, I   0xead54739, 0x9dd277af, 0x04db2615, 0x73dc1683, 0xe3630b12, 0x94643b84, I   0x0d6d6a3e, 0x7a6a5aa8, 0xe40ecf0b, 0x9309ff9d, 0x0a00ae27, 0x7d079eb1, I   0xf00f9344, 0x8708a3d2, 0x1e01f268, 0x6906c2fe, 0xf762575d, 0x806567cb, I   0x196c3671, 0x6e6b06e7, 0xfed41b76, 0x89d32be0, 0x10da7a5a, 0x67dd4acc, I   0xf9b9df6f, 0x8ebeeff9, 0x17b7be43, 0x60b08ed5, 0xd6d6a3e8, 0xa1d1937e, I   0x38d8c2c4, 0x4fdff252, 0xd1bb67f1, 0xa6bc5767, 0x3fb506dd, 0x48b2364b, I   0xd80d2bda, 0xaf0a1b4c, 0x36034af6, 0x41047a60, 0xdf60efc3, 0xa867df55, I   0x316e8eef, 0x4669be79, 0xcb61b38c, 0xbc66831a, 0x256fd2a0, 0x5268e236, I   0xcc0c7795, 0xbb0b4703, 0x220216b9, 0x5505262f, 0xc5ba3bbe, 0xb2bd0b28, I   0x2bb45a92, 0x5cb36a04, 0xc2d7ffa7, 0xb5d0cf31, 0x2cd99e8b, 0x5bdeae1d, I   0x9b64c2b0, 0xec63f226, 0x756aa39c, 0x026d930a, 0x9c0906a9, 0xeb0e363f, I   0x72076785, 0x05005713, 0x95bf4a82, 0xe2b87a14, 0x7bb12bae, 0x0cb61b38, I   0x92d28e9b, 0xe5d5be0d, 0x7cdcefb7, 0x0bdbdf21, 0x86d3d2d4, 0xf1d4e242,iI   0x68ddb3f8, 0x1fda836e, 0x81be16cd, 0xf6b9265b, 0x6fb077e1, 0x18b74777, I   0x88085ae6, 0xff0f6a70, 0x66063bca, 0x11010b5c, 0x8f659eff, 0xf862ae69, I   0x616bffd3, 0x166ccf45, 0xa00ae278, 0xd70dd2ee, 0x4e048354, 0x3903b3c2, I   0xa7672661, 0xd06016f7, 0x4969474d, 0x3e6e77db, 0xaed16a4a, 0xd9d65adc, I   0x40df0b66, 0x37d83bf0, 0xa9bcae53, 0xdebb9ec5, 0x47b2cf7f, 0x30b5ffe9, I   0xbdbdf21c, 0xcabac28a, 0x53b39330, 0x24b4a3a6, 0xbad03605, 0xcdd70693,*I   0x54de5729, 0x23d967bf, 0xb3667a2e, 0xc4614ab8, 0x5d681b02, 0x2a6f2b94,i0   0xb40bbe37, 0xc30c8ea1, 0x5a05df1b, 0x2d02ef8d };      S /* returns FALSE if the CRC value in image.crc differs from the CRC of image.exe */i /* if ok, returns TRUE */  int selfcheck(char *image) {e     char keyfile[_MAX_PATH];     char key[10];      char actual_key[10];     unsigned long int crc32;     FILE *stream;f      X!     /* construct keyfile name */       strcpy(keyfile,image);     /* get rid of extension */'     *(strrchr(keyfile,(int) '.'))='\0';i!     strcat(keyfile,".CRC");      s        34     /* read the CRC32 value out of the keyfile */   &     if (!(stream=fopen(keyfile, "r")))     {   1         fprintf(stderr,"Cannot open key file\n");)         return FALSE;*     }*  $     if (fgets(key, 5, stream)==NULL)     {   A         fprintf(stderr,"Cannot read CRC marker from key file\n");a         fclose(stream);          return FALSE;l     }n          /* is there a CRC code ? */1     if (strcmp(key,"CRC:"))T
     {     <         fprintf(stderr,"No CRC marker found in key file\n");         fclose(stream);|         return FALSE;9     }r          /* get it */ c$     if (fgets(key, 9, stream)==NULL)	     {    e?         fprintf(stderr,"Cannot get CRC value from key file\n");R         fclose(stream);)         return FALSE;      }7              if (ferror(stream))o     {   I         fprintf(stderr,"An i/o error occurred while reading key file\n");          fclose(stream);*         return FALSE;*     }              *     fclose(stream);*       *     /* determine the actual CRC32 value */,     if (crc32file( image, 0, &crc32)==FALSE)     {         <         fprintf(stderr,"Cannot compute actual CRC value\n");         return FALSE;      }o         '     sprintf(actual_key,"%08lX", crc32);i      e     /* and compare */oO     if (strcmp(key,actual_key)) return FALSE; /* The CRC value is incorrect! */*     else return TRUE;  }     F /* computes the CRC value of filename excluding 'ignore_last_bytes' */5 /* returns FALSE on any error condition, else TRUE */NN int crc32file(char *filename, int ignore_last_bytes, unsigned long int *crc32) {s       FILE *stream;25       register unsigned long int oldcrc32=0xFFFFFFFF;        register int c;a       int handle;r!       register long byte_read=0L;1       register long filesize;               #ifndef __VMSN2         _fmode=O_BINARY;                                 #endif       7       if (!(stream=fopen(filename, "r"))) return FALSE;   h/       /* get the number of bytes in the file */         handle = fileno( stream );&       filesize = filelength( handle );       2       /* ignore some trailing bytes if asked so */E       if (ignore_last_bytes>0 && (long) ignore_last_bytes < filesize)i'          filesize -= ignore_last_bytes;A                                  +       while (c=fgetc(stream),!feof(stream))h
       {   )           oldcrc32 = UPDC32(c, oldcrc32);w-           if (++byte_read >= filesize) break;        }o
                  if (ferror(stream))i       {            fclose(stream);o           return FALSE;t       }                             fclose(stream);               oldcrc32 = ~oldcrc32;   /       /* do some application-specific action */ %       oldcrc32 += APPLICATION_OFFSET;e       2       /* pass the value to the calling function */       *crc32 = oldcrc32;              return TRUE; }     