 $!+++  $!( $! TEX_ROOT:[EXE.COMMON]TeX_COMMANDS.COM $!E $! This is the common login procedure for TeX. It may add the various H $! TeX related verbs to the process command table and defines the global $! symbols for the utilities.  $!E $! The basic logicals TEX_DISK, TEX_ROOT and TEX_USAGE, which must be 
 $! defined as  $! $!     TEX_DISK  = <disk>:$ $!     TEX_ROOT  = TEX_DISK:[TEXMF.]! $!     TEX_USAGE = <command mode>  $!F $! are required. Only COM and CLD are valid values for <command mode>;H $! <command mode> controls whether TeX is defined as a verb or a foreign $! command. F $! If these logicals don't exist, the procedure will display a warning $! message and exit. $!B $! NOTES: We don't check the correct definition of these logicals;8 $!        we only check the existence of these logicals. $! $!G $! Since normally some minor modifications are made, one should clearly D $! indicate these changes to keep the modified procedure as close as$ $! possible to the TeX distribution. $! $!J $! Site specific commands, like additional commands for supported packagesL $! should be added in the procedure TEX_ROOT:[000000]DECUS_TEX_COMMANDS.COM, $! which is called at the end. $!B $! This (hopefully) simplifies the maintainence of these packages. $! $!' $! Copyright  1994,1995  Ralf G"artner = $! <gaertner@cthulhu.rhein-main.de , gaertner@decus.decus.de>  $!, $! based on STARTTEX.COM  Christian SpielerE $!                         <spieler@linac.ikp.physik.th-darmstadt.de>  $!---  $! $! disable error checks  $!
 $ set noon $ say := write sys$output  $!                    - $! check for TEX_DISK, TEX_ROOT and TEX_USAGE  $!M $ if   (f$trnlnm("TEX_DISK") .eqs. "") .or. (f$trnlnm("TEX_ROOT") .eqs. "") - '   .or. (f$trnlnm("TEX_USAGE") .eqs. "")  $ then $   ! D $   ! TEX_DISK, TEX_ROOT, TEX_USAGE are missing, exit with a message $   !  $   say f$fao - O   ("%STRTUP-E-TEX, the logicals TEX_DISK, TEX_ROOT, TEX_USAGE are not defined") 8 $   say f$fao("%STRTUP-I-TEX, contact your TeX manager") $   say " " 	 $   exit   $ endif  $!K $! define the basic commands, which may be setup as verb or foreign command  $!B $ mode = f$edit(f$trnlnm("TEX_USAGE"),"COLLAPSE,UPCASE,UNCOMMENT")/ $ if f$search("TEX_EXE:TEXMF.''mode'") .nes. ""  $ then $   ! 1 $   ! define TeX / MF as verb or foreign commands  $   ! : $   if mode .eqs. "CLD" then set command TEX_EXE:TEXMF.CLD/ $   if mode .eqs. "COM" then @TEX_EXE:TEXMF.COM  $ else $   ! 7 $   ! TeX definition file not found, so exit immediatly  $   ! B $   say f$fao("%STRTUP-E-TEX, TeX definition file !AS not found",-&               "TEX_EXE:TEXMF.''mode'")7 $   say f$fao("%STRTUP-I-TEX, contact you TeX manager")  $   say " " 	 $   exit   $ endif  $!? $! other basic commands (like DVIPS), which are defined as verb  $!
 $cld_loop:& $ cld_file = f$search("TEX_EXE:*.CLD") $ if cld_file .nes. "". $   then cld_name = f$parse(cld_file,,,"NAME")G $        if cld_name .eqs. "TEXMF" then goto cld_loop  ! skip TEXMF.CLD   $        set command  'cld_file' $        goto cld_loop $ endif  $!= $! the foreign commands for the basic TeX system (incl. XDVI)  $!
 $! WEB system  $!: $ TANGLE    :== $TEX_EXE:TANGLE.EXE        ! WEB -> PASCAL8 $ WEAVE     :== $TEX_EXE:WEAVE.EXE         ! WEB -> TeX N $ POOLTYPE  :== $TEX_EXE:POOLTYPE.EXE      ! type the string pool of a program $!> $! TeXware / MFware (GFware,PKware,PXKware) / VFware utilities $!L $ DVITYPE   :== $TEX_EXE:DVITYPE.EXE       ! type the contents of a DVI file@ $ PLTOTF    :== $TEX_EXE:PLTOTF.EXE        ! convert PL  --> TFM? $ TFTOPL    :== $TEX_EXE:TFTOPL.EXE        ! convert TFM --> PL , $ PATGEN    :== $TEX_EXE:PATGEN.EXE        ! $ > $ GFTOPK    :== $TEX_EXE:GFTOPK.EXE        ! convert GF --> PK? $ GFTODVI   :== $TEX_EXE:GFTODVI.EXE       ! print MF's GF font 9 $ GFTYPE    :== $TEX_EXE:GFTYPE.EXE        ! type GF font 7 $ MF2T      :== $TEX_EXE:MFT.EXE           ! MF --> TeX ? $ PKTYPE    :== $TEX_EXE:PKTYPE.EXE        ! type PK fontraster > $ PKTOGF    :== $TEX_EXE:PKTOGF.EXE        ! convert PK --> GF? $ GFTOPXL   :== $TEX_EXE:GFTOPXL.EXE       ! convert GF --> PXL J $ PKTOPX    :== $TEX_EXE:PKTOPX.EXE        ! convert PK --> PXL (obsolete)L $ PXTOPK    :== $TEX_EXE:PXTOPK.EXE        ! to PXL(unpacked) and vice versa $ < $ VPTOVF    :== $TEX_EXE:VPTOVF.EXE        ! VPL --> TFM, VF8 $ VFTOVP    :== $TEX_EXE:VFTOVP.EXE        ! VF  --> VPL $! $! screen previewer  $!! $ XDVI      :== $TEX_EXE:XDVI.EXE  $! $! MakeTeXPK used by DVIPS $!K $ MAKETEXPK  == "@TEX_EXE:MAKETEXPK.COM ""%n"" ""%d"" ""%b"" ""%m"" ""%o"""  $!( $! MakeTeXPK used by XDVI needs the mode $!O $ XDVIMAKEPK == "@TEX_EXE:MAKETEXPK.COM ""%n"" ""%d"" ""%b"" ""%m"" ""imagen"""  $! $! DVIPS utility $!$ $ AFM2TFM   :== $TEX_EXE:AFM2TFM.EXE $! $! DECUS supplied commands $! $DECUS_TeX_commands:: $ if f$search("TEX_EXE:DECUS_TEX_COMMANDS.COM") .nes. "" -)     then  @TEX_EXE:DECUS_TEX_COMMANDS.COM  $  $ exit $ / $! End of TEX_ROOT:[EXE.COMMON]TEX_COMMANDS.COM 