 $!+++  $!) $! TEX_ROOT:[EXE.COMMON<]TeX_LOGICALS.COM  $!C $! This is the common startup procedure for the basic TeX logicals.  $!% $! We assume, that this procedure is   $! $!     a) called during startup  $! or 0 $!     b) run once during an interactive session $!K $! In both cases the basic logicals TEX_DISK, TEX_ROOT and TEX_USAGE, which  $! must be defined as  $! $!     TEX_DISK  = <disk>:$ $!     TEX_ROOT  = TEX_DISK:[TEXMF.]! $!     TEX_USAGE = <command mode>  $!K $! are required. Only CLD or COM are valid values for <command mode>. Prior I $! to the version TeX 3.14159 (PD 3.6), TeX can only be invoked by a verb J $! definition, so  TEX_USAGE = "COM"  will not work for TeX3.1415 (PD 3.5) $! or older versions.  $!L $! If the logicals don't exist, the procedure will display a warning message $! and exit. $!A $! NOTE: We don't check the correct definition of these logicals; % $!       we only check the existence.  $! $!I $! If this procedure is run during an interactive session, we assume that H $! the user hasn't system privileges. So all logicals are defined in theH $! process table. This could be useful for sites, who prefer to avoid an@ $! automatic TeX setup and leave the initialization to the user. $!! $! We suggest, that a symbol like  $!1 $!   START_TEX :== @<disk>:[TEXMF]TEX_BY_USER.COM  $!F $! is defined in the system-wide login procedure for this 'user-mode'.D $! TEX_BY_USER.COM is a simple driver which calls TEX_LOGICALS.COM . $! $!N $! Normally some minor modifications are made to this procedure, so one shouldL $! clearly indicate these changes to keep the modified procedure as close as$ $! possible to the TeX distribution. $! $!J $! Site specific logicals, like additional logicals for programs/packages,L $! should be added in the procedure TEX_ROOT:[000000]DECUS_TEX_LOGICALS.COM, $! which is called at the end. $!B $! This (hopefully) simplifies the maintainence of these packages. $! $!' $! Copyright  1994,1995  Ralf G"artner = $! <gaertner@cthulhu.rhein-main.de , gaertner@decus.decus.de>  $!, $! based on STARTTEX.COM  Christian SpielerE $!                         <spieler@linac.ikp.physik.th-darmstadt.de>  $!---  $! $! disable error checks  $!
 $ set noon $!                    - $! check for TEX_DISK, TEX_ROOT and TEX_USAGE  $!M $ if   (f$trnlnm("TEX_DISK") .eqs. "") .or. (f$trnlnm("TEX_ROOT") .eqs. "") - '   .or. (f$trnlnm("TEX_USAGE") .eqs. "")  $ then $   ! D $   ! TEX_DISK, TEX_ROOT, TEX_USAGE are missing, exit with a message $   !  $   say := write sys$output  $   say f$fao - O   ("%STRTUP-E-TEX, the logicals TEX_DISK, TEX_ROOT, TEX_USAGE are not defined") 8 $   say f$fao("%STRTUP-I-TEX, contact your TeX manager") $   say " " 	 $   exit   $ endif  $!& $! check, if we are running at startup $! $ if f$mode() .eqs. "OTHER"  $ then $   ! J $   ! we are at system startup, so define the logicals in the SYSTEM table $   !  $   table := LNM$SYSTEM  $ else $   ! O $   ! we are not at system startup, so define the logicals in the PROCESS table  $   !  $   table := LNM$PROCESS $ endif  $ 0 $ cmd1 = "DEFINE/TABLE=''TABLE'/NOLOG/EXECUTIVE"F $ cmd2 = "DEFINE/TABLE=''TABLE'/NOLOG/EXECUTIVE/TRANSLATION=CONCEALED" $! $! basic TeX logicals  $!   $! the old-style hardware check  $!# $ if f$getsyi("HW_MODEL") .lt. 1024 D $   then  cmd1   TEX_EXE   TEX_ROOT:[EXE.VAX], TEX_ROOT:[EXE.COMMON]D $   else  cmd1   TEX_EXE   TEX_ROOT:[EXE.AXP], TEX_ROOT:[EXE.COMMON] $ endif  $! $!K $! basic TeX logicals, note that TeX 3.14159 (PD 3.6) supports subdirectory J $! searching, so most logicals use this capability. These definitions will( $! not work for prvious versions of TeX. $! $!  K $ cmd1  TEX_FORMATS      TEX_ROOT:[FORMATS...]  ! standard formats, *.POOL, O $                                               ! and local formats in [.LOCAL] < $ cmd1  TEX_INPUTS       SYS$DISK:[], -         ! user files>                          TEX_ROOT:[INPUTS...]   ! common files $!J $! TEX_FONTS is used by the drivers, which may not understand subdirectory7 $! searching. So the logical is defined as search list.  $!G $! DECUS uses the additional logicals TFM_ROOT, PK_ROOT, and VF_ROOT to  $! shorten the definitions.  $!4 $ cmd2  TFM_ROOT         TEX_DISK:[TEXMF.FONTS.TFM.]: $ cmd2  PK_ROOT          TEX_DISK:[TEXMF.FONTS.PK.IMAGEN.]3 $ cmd2  VF_ROOT          TEX_DISK:[TEXMF.FONTS.VF.]  $ M $ cmd1  TEX_FONTS        TFM_ROOT:[CM], -                    ! CM *.TFM files D                          TFM_ROOT:[LATEX], -                 ! LaTeXH                          TFM_ROOT:[AMS], -                   ! AMS fontsJ                          TFM_ROOT:[XYPIC], -                 ! XYpic fontsH                          TFM_ROOT:[CM.BBM], -                ! BBM fontsM                          TFM_ROOT:[CM.CONCRETE], -           ! Concrete fonts J                          TFM_ROOT:[DC], -                    ! DC/EC fontsP                          TFM_ROOT:[ADOBE], -                 ! PostScript(DVIPS)L                          TFM_ROOT:[PANDORA], -               ! Pandora fontsJ                          TFM_ROOT:[LOCAL]                    ! local fonts $!D $! uncomment the TEX_EDIT definition below for your preferred editor $!J $! cmd1  TEX_EDIT        "Callable_LSE"                       ! LSE editorI $ cmd1  TEX_EDIT        "Callable_TPU"                       ! TPU editor J $! cmd1  TEX_EDIT        "Callable_EDT"                       ! EDT editorK $! cmd1  TEX_EDIT        "Callable_TECO"                      ! Teco editor  $! $! $! basic Metafont logicals $! $!  N $ cmd1  MF_BASES         TEX_FORMATS                         ! MF.BASE/MF.POOL $!J $! since Metafont supports subdirectory seaching, so we don't have to list$ $! all the different subdirectories. $!I $ cmd1  MF_INPUTS        SYS$DISK:[], -                      ! user files N                          TEX_ROOT:[INPUTS.TEX_MF], -         ! CMBASE/PLAIN.MFJ                          TEX_ROOT:[FONTS.MF...]              ! all sources $!G $! MF_TERM & MF_LIB aren't really needed, so they are commented/not set  $! cmd1  MF_TERM         ""  $! cmd1  MF_LIB          ""  $! $!I $! DVIPS logicals; TEX_PKDIR, TEX_VFDIR, and TEX_POSTSCRIPT are hardcoded & $! into the program by compile flags ! $!H $! DVIPS_PK_* are DECUS additions; TEX_PKDIR and TEX_VFDIR are also used $! by the DVITOLN03 driver $!: $ cmd1  DVIPS_PK_1       TEX_DISK:[TEXMF.FONTS.PK.IMAGEN.]@ $ cmd1  DVIPS_PK_2       TEX_DISK:[TEXMF.FONTS.PK.IMAGEN.LATEX.]> $ cmd1  DVIPS_PK_3       TEX_DISK:[TEXMF.FONTS.PK.IMAGEN.AMS.]@ $ cmd1  DVIPS_PK_4       TEX_DISK:[TEXMF.FONTS.PK.IMAGEN.XYPIC.]> $ cmd1  DVIPS_PK_5       TEX_DISK:[TEXMF.FONTS.PK.IMAGEN.BBM.]C $ cmd1  DVIPS_PK_6       TEX_DISK:[TEXMF.FONTS.PK.IMAGEN.CONCRETE.] = $ cmd1  DVIPS_PK_7       TEX_DISK:[TEXMF.FONTS.PK.IMAGEN.DC.] B $ cmd1  DVIPS_PK_8       TEX_DISK:[TEXMF.FONTS.PK.IMAGEN.PANDORA.]@ $ cmd1  DVIPS_PK_9       TEX_DISK:[TEXMF.FONTS.PK.IMAGEN.LOCAL.] $ J $ cmd1  TEX_PKDIR        DVIPS_PK_1, DVIPS_PK_2, DVIPS_PK_3, DVIPS_PK_4, -J                          DVIPS_PK_5, DVIPS_PK_6, DVIPS_PK_7, DVIPS_PK_8, -#                          DVIPS_PK_9 9 $ cmd1  TEX_VFDIR        VF_ROOT:[DVIPS], VF_ROOT:[LOCAL] > $ cmd1  TEX_POSTSCRIPT   TEX_ROOT:[INPUTS.DVIPS], -    ! DVIPSA                          TEX_ROOT:[INPUTS.PSTRICKS]    ! PStricks  $!                         $!F $! XDVI logicals; we don't use all available logicals, so some of themF $! are commented. For a complete description of the XDVI logicals, seeF $! TEX_ROOT:[SRC.PROGRAMS.DRIVER.XDVI]README.VMS . One should note howG $! the `private' fonts are named; this is the format of the GF/PK files , $! from the GFTOPK ans MAKETEXPK utilities.  $!G $ xdvifonts = "PK_ROOT:[%d]%f.%p/" + -                       ! CM fonts J               "PK_ROOT:[LATEX.%d]%f.%p/" + -                 ! LateX fontsH               "PK_ROOT:[AMS.%d]%f.%p/" + -                   ! AMS fontsJ               "PK_ROOT:[XYPIC.%d]%f.%p/" + -                 ! XYpic fontsH               "PK_ROOT:[BBM.%d]%f.%p/" + -                   ! BBM fontsM               "PK_ROOT:[CONCRETE.%d]%f.%p/" + -              ! Concrete fonts J               "PK_ROOT:[DC.%d]%f.%p/" + -                    ! DC/EC fontsL               "PK_ROOT:[PANDORA.%d]%f.%p/" + -               ! Pandora fontsJ               "PK_ROOT:[LOCAL.%d]%f.%p/" + -                 ! local fontsL               "SYS$DISK:[]%f.%d%p"                           ! private fonts $ & $ cmd1  XDVIFONTS       "''xdvifonts'"L $ cmd1  XDVIMFMODE      "localfont"                          ! for MakeTeXPKK $ cmd1  XDVISIZES       "300/329/360/432/518/622/746"        ! TeX defaults 2 $ cmd1  XDVIVFS         "VF_ROOT:[IMAGEN.%d]%f.%p" $!K $! (optional) management logicals, not really needed. Use them if you want.  $!  ' $ cmd1  TEX_MGR          TEX_ROOT:[MGR] : $ cmd2  TEX_SRC          TEX_DISK:[TEXMF.SRC.PROGRAMS.], -7                          TEX_DISK:[TEXMF.SRC.PACKAGES.] / $ cmd1  TEX_VERSION      "TeX 3.14159 (PD 3.6)"  $!N $! (optional) user support logicals, not really needed. May be useful to have. $!  ) $! cmd2  TEX_DOC          TEX_ROOT:[DOC.] , $! cmd1  TEX_EXAMPLES     TEX_DOC:[EXAMPLES] $!J $! Old DVI drivers may need TEX$FONTS. Uncomment the line below if you use $! such a driver $!# $! cmd1  TEX$FONTS        TEX_FONTS  $!- $! Define a logical for the TeX Help Library.  $!O $ tex_help_lib := TEX_ROOT:[DOC]TEXMF.HLB                  ! new DECUS TeX help 8 $ if f$search(tex_help_lib) .eqs. "" -                  O     then tex_help_lib := TEX_ROOT:[DOC]OLD_DECUS_TEX.HLB   ! old DECUS TeX help  $  $ if f$mode() .eqs. "OTHER"   $   then hlp_table := LNM$SYSTEM! $   else hlp_table := LNM$PROCESS  $ endif 4 $ if f$trnlnm("HLP$LIBRARY","''hlp_table'") .eqs. "" $ then ! use HLP$LIBRARY% $   cmd1  HLP$LIBRARY  'tex_help_lib'  $ else@ $   if f$trnlnm("HLP$LIBRARY","''hlp_table'") .nes. tex_help_lib $   then ! use HLP$LIBRARY_<n> $     count = 1  $loop:A $     if f$trnlnm("HLP$LIBRARY_''count'","''hlp_table'") .eqs. "" 
 $     then1 $       cmd1  HLP$LIBRARY_'count'  'tex_help_lib' 
 $     elseD $       if f$trnlnm("HLP$LIBRARY","''hlp_table'") .nes. tex_help_lib  $         then count = count + 1 $              goto loop
 $       endif  $     endif 	 $   endif  $ endif  $! $!I $! DECUS_TEX_LOGICALS.COM may define additional logicals, execute command O $! procedures or do whatever is needed to customize the local TeX installation. 9 $! To be consistent, we pass the table to that procedure.  $! $! $DECUS_TeX_logicals: $ : $ if f$search("TEX_EXE:DECUS_TEX_LOGICALS.COM") .nes. "" -5     then  @TEX_EXE:DECUS_TEX_LOGICALS.COM  "''table'"  $  $ exit $ / $! End of TEX_ROOT:[EXE.COMMON]TeX_LOGICALS.COM 