 #define module_name	VMS2TAR   #define module_version  "V2.1-1" /*:  *	VMS2TAR.C - Handles the create functionality of VMSTAR.  */   
 #ifdef __DECC ) #pragma module module_name module_version  #else " #module module_name module_version #endif   #include <stdio.h> #include <stdlib.h>  #include <stat.h>  #include <string.h>  #include <ctype.h> #include <time.h>    #include <unixio.h>  #include <unixlib.h> #include <ssdef.h> #include <rms.h> #include <starlet.h> #include <lib$routines.h>    #include "vmstar_cmdline.h"  #include "vmstarP.h"   #define EXPERIMENT 1   /* Globals in this module */  A static int mode, uid, gid;    /* current values used by create */ $ static int bufferpointer, bytecount;   /* File characteristics */   static int outfd; @ static unsigned long vmsmrs, vmstime;  /* maximum record size */G static int vmsrat,vmsorg,vmsrfm;       /* other format (as integers) */   & /* forward declarations of routines */   int initsearch(); 
 int search();  int scan_name(); int cleanup_dire();  int get_attributes();  int fill_header(); int write_header();  int write_trailer(); int addfile(); int out_file();  int flushout();  int lowercase();   #ifdef EXPERIMENT  int outfile_rms(); int get_varfilesize();$ char EmptyTrailer[RECSIZE] = {'\0'}; #endif /* EXPERIMENT */   ( /* vms2tar -- handles create function */   vms2tar(argc,argv)	 int argc;  char **argv; { +     int argi, process, file_type, absolute; (     char string[NAMSIZE], *cp, *dp, *wp;       bufferpointer = 0;     gid = getgid();      uid = getuid();      mode = 0644;   /* Open the output file */  4     outfd = creat(tarfile,0600,"rfm=fix","mrs=512");     if (outfd < 0)     { B         printf("tar: error opening output tarfile %s\n", tarfile);         exit(SS$_NORMAL);      }     '     for (argi = 0; argi < argc; ++argi)      { #         strcpy(string, argv[argi]);          absolute = 0; C         cp = strchr(string, ':');   /* device name in argument ? */ A         if (cp != NULL)            /* yes, force absolute mode */              absolute = 1;          else	         { J             cp = strchr(string, '[');  /* test argument for absolute... */D             if (cp != NULL)            /* ...or relative filespec */
             {                  ++cp; -                 if (*cp != '.' && *cp != '-') !                     absolute = 1; 
             } 	         } #         if(initsearch(string) <= 0) 9             printf("tar: no files matching %s\n",string);          else+           while(search(newfile,NAMSIZE)!=0)            { &             strcpy(linkname, newfile);"             cleanup_dire(newfile);J             file_type = scan_name(newfile,new_directory,outfile,absolute);+             strcpy(pathname,new_directory); %             strcat(pathname,outfile); ?             if (get_attributes(newfile) != 0) exit(SS$_NORMAL);              process = 1;             if(the_wait)
             {                  *temp = '\0'; 4                 while (*temp != 'y' && *temp != 'n')                 { 6                     printf("%s   (y/n) ? ", linkname);&                     scanf("%s", temp);+                     *temp = tolower(*temp);                  } )                 process = (*temp == 'y'); 
             }              if (process)
             { '                 if(file_type == ISDIRE)                  { #                     bytecount =  0;                       mode = 0755;*                     fill_header(pathname);(                     write_header(outfd);                 } '                 if(file_type == ISFILE)                  {                       mode = 0644;6                     if(addfile(newfile, pathname) < 0)                     { C                         printf("tar: error copying %s\n",linkname); )                         exit(SS$_NORMAL);                      }                  } 9                 if (bytecount < 0 && file_type == ISFILE)  		{ :                     printf("*** skipped  %s\n", linkname);) 		    printf("*** unsupported format\n");  		} F                 if (verbose && (bytecount >=0 || file_type == ISDIRE))                 { I                      strcpy(creation,ctime(&vmstime)); /* work on this */ $                      creation[24]=0;K                      printf("%s %8d %s\n",creation + 4,bytecount,pathname);                  } 
             }            }      }      write_trailer(outfd);      close(outfd);  }   4 /* addfile - copy the vms file to the output file */   int addfile(vmsname,unixname)  char vmsname[],unixname[]; {  int ind;G     if(bytecount < 0)          /* we don't output unsupported files  */          return(0);3     if((ind=out_file(vmsname,bytecount,outfd)) < 0)          return(ind);*     bufferpointer = bufferpointer%BLKSIZE;     return(1); }     ! /* out_file - write out the file. - * move nbytes of data from "fdin" to "fdout"; ) * Always pad the output to a full RECSIZE > * If it a VMS text file, it may be various formats, so we will, * read the file twice in case of a text file( * so that we get the correct byte count.0 * We set the bytecount=-1 if this is funny file. */  # int out_file(filename,nbytes,fdout)  char filename[]; int fdout, nbytes; {  int i, n, pos; char *bufp, *linep; 
 FILE *filein;  static char dbuffer[RECSIZE];  #ifdef EXPERIMENT  int r_value; #endif /* EXPERIMENT */   4     if(vmsrfm == FAB$C_FIX || vmsrfm == FAB$C_STM ||        vmsrfm == FAB$C_STMLF)      { 0     	if((filein = fopen(filename,"rb")) == NULL)     	{<     		printf("tar: error opening input file %s\n",filename);         	return(-1);	         } L         fill_header(pathname);          /* We have all of the information */D         write_header(outfd);            /* So write to the output */         while(nbytes > 0) 	         { I             n = fread(buffer, 1, nbytes>RECSIZE? RECSIZE:nbytes, filein);              if (n == 0) 
             {                  fclose(filein); F                 printf("tar: error reading input file %s\n",filename);                 return(-1); 
             }              nbytes -= n;             flushout(fdout);	         }          fclose(filein);          return(0);     }      else     { . 	if(vmsrat == 0)			/* No record attributes? */' 	{				/* Might be a text file anyway */ & 					/* So let's check two records. */   #if 0 D 	    /* Unfortunatelly, it won't work, because I seem to get RECSIZEC 	       byte blocks, and I can't find a way to get just one record. C 	       Thus, I can't reliably find out if the file is text or not. $ 	       Pity.  -- Richard Levitte */M 	    if((filein = fopen(filename,"r","rfm=fix","mrs=512","ctx=rec")) == NULL)  	    {F                 printf("tar: error opening input file %s\n",filename);                 return(-1); 
             } 8 	    if((nbytes = fread(dbuffer,1,RECSIZE,filein)) != 0) 	    {< 		if(dbuffer[nbytes-2] != '\r' || dbuffer[nbytes-1] != '\n') 		{  		    fclose(filein);  		    bytecount = -1;  		    return(0); 		}  	    } 	    else if (!feof(filein)) 	    { 		fclose(filein); 8 		printf("tar: error reading input file %s\n",filename);@ 		printf("     record too large or incorrect RMS attributes\n");
 		return(-1);  	    }8 	    if((nbytes = fread(dbuffer,1,RECSIZE,filein)) != 0) 	    {< 		if(dbuffer[nbytes-2] != '\r' || dbuffer[nbytes-1] != '\n') 		{  		    fclose(filein);  		    bytecount = -1;  		    return(0); 		}  	    } 	    else if (!feof(filein)) 	    { 		fclose(filein); 8 		printf("tar: error reading input file %s\n",filename);@ 		printf("     record too large or incorrect RMS attributes\n");
 		return(-1);  	    }* 	    fclose(filein); /* rewind(filein); */ 	    /* exit(1); */  #else  #ifdef EXPERIMENT              /*P             ** OK, the regular VMSTAR skips them, but these may be Schlumberger H             ** file formats (PDS, DLIS etc.) so let us take another shot:             ** at them by using Stream_LF or RMS routines.             */   	    /* ? 	    ** The file turned out to be a variable length file, so we F 	    ** need the exact size without the bytes used for indicating sizeD 	    ** of each record. I could not find a way of accurately knowing= 	    ** the size of such files without parsing them first !!!. 	    */  	    bytecount = 0;m9 	    if ((nbytes = get_varfilesize(filename, !force)) < 0e 		|| bytecount < 0)  		return nbytes; 	    bytecount = nbytes;  E             /* r_value = outfile_stream(filename, nbytes, fdout) ; */cE             r_value = outfile_rms(filename, nbytes, fdout, !force) ; <               return (r_value) ; #elser 	    bytecount = -1; 	    return(0);i #endif /* EXPERIMENT */  #endif /* 0 */ 	}+ 	if((filein = fopen(filename,"r")) == NULL)h 	{; 	    printf("tar: error opening input file %s\n",filename);s 	    return(-1); 	} 	/* compute "Unix" file size */  	nbytes = 0;. 	while(fgets(dbuffer,RECSIZE,filein) !=  NULL) 	    nbytes += strlen(dbuffer);a 	if (!feof(filein))  	{ 	    fclose(filein);; 	    printf("tar: error reading input file %s\n",filename);dC 	    printf("     record too large or incorrect RMS attributes\n");  	    return(-1); 	}= 	rewind(filein);                 /* Back to the beginning  */r: 	bytecount = nbytes;             /* Use the real count  */9 	fill_header(pathname);          /* Compute the header */P0 	write_header(outfd);            /* Write it  */ 	bufp = buffer;i  1 	if (nbytes != 0)		    /* Check for empty file */* 	{2 	    while(fgets(dbuffer,RECSIZE,filein) !=  NULL)= 	    {                           /* Now copy to the output */_ 		linep = dbuffer;= 		while (*linep != '\0')  /* read source file line by line */; 		{ # 		    if (bufp >= &buffer[RECSIZE])  		    {e 			bufp = buffer; 2 			flushout(fdout); /* if buffer full, flush it */. 		    } /* copy in fixed size output buffer */ 		    *bufp++ = *linep++;r 		}  i 	    } 	    flushout(fdout);e 	} 	fclose(filein);     }      return (0);        g }   ; /* flushout - write a fixed size block in output tarfile */r   flushout(fdout)o
 int fdout; { /     if (write(fdout,buffer,RECSIZE) != RECSIZE)      {t0         printf("tar: error writing tarfile.\n");         exit(SS$_NORMAL);      }      bufferpointer += RECSIZE;  }   8 /* write_header - copy the header to the output file  */   int write_header(fd) int fd;  {f int n;.     if((n=write(fd,&header,RECSIZE))!=RECSIZE)     { :         printf("tar: error writing header in tarfile.\n");         exit(SS$_NORMAL);      }      bufferpointer += RECSIZE;      return(n); }   ; /*  get_attributes - get the file attributes via stat()  */i   int get_attributes(fname) 
 char fname[];  {  struct stat sblock;i       if(stat(fname,&sblock))      { ;         printf("tar: can't get file status on %s\n",fname);iG         vmstime = 0;                    /* Prevent garbage printoout */oD         bytecount = -1;                 /* of inaccessible files  */         return(-1);      }   8 /* now get the file attributes, we don't use them all */     vmsrat = sblock.st_fab_rat;      vmsmrs = sblock.st_fab_mrs;      vmsrfm = sblock.st_fab_rfm;      vmstime = sblock.st_mtime;     bytecount = sblock.st_size;        return (0);  }     C /* write_trailer - write the two blank blocks on the output file */p3 /* pad the output to a full blocksize if needed. */    write_trailer(fdout)
 int fdout; {  int i;     for (i=0; i < NAMSIZE; ++i) 4         header.title[i] = header.linkname[i] = '\0';     for (i=0; i < 255; ++i)          header.dummy[i] = '\0';      for (i=0; i < 12; ++i)0         header.count[i] = header.time[i] = '\0';     for (i=0; i < 8; ++i) ?         header.protection[i] = header.uid[i] = header.gid[i] =   	    header.chksum[i] = '\0';      header.linkcount = '\0';     write_header(fdout);     write_header(fdout);       /*E     ** This is to satisfy Tar on NT, that works only with block sizesa     ** of 1024.      */ #ifdef DEBUGF     printf("padding = %d, block_factor = %d\n",padding, block_factor); #endif     if (!padding)        return 1;   *     bufferpointer = bufferpointer%BLKSIZE;#     while (bufferpointer < BLKSIZE)k         write_header(fdout);     return(1); }   $ /* scan_name - decode a file name */  C /* Decode a file name into the directory, and the name, and convert B * to a valid UNIX pathname. Return  a value to indicate if this is$ * a directory name, or another file.= * We return the extracted directory string in "dire", and thetA * filename (if it exists) in "fname". The full title is in "line"  * at input.i */  ' int scan_name(line,dire,fname,absolute)i char line[],dire[],fname[]; 
 int absolute;  {n char *cp1,*cp2;, int len,len2,i;v char *strindex();;  > /* The format will be VMS at input, so we have to scan for theB  * VMS device separator ':', and also the VMS directory separators  * '[' and ']'.tG  * If the name ends with '.dir;1' then it is actually a directory name.ZI  * The outputs dire and  fname will be a complete file spec, based on thee  * default directory.oK  * It may be a rooted directory, in which case there will be a "][" string,l
  * remove it.rH  * Strip out colons from the right, in case there is a node name (shouldL  * not be!) If the filename ends in a trailing '.', suppress it , unless the  * "d" option is set.u  */e    O     strcpy(temp,strrchr(line,':')+1);           /* Start with the whole name */h  F /* If relative path, get rid of default directory part of the name  */       if (absolute == 0)     {f         strcpy(dire,"./");=         for(cp1 = temp ,cp2 = curdir; *cp2 && (*cp1 == *cp2);=             cp1++, cp2++);         if(*cp2 == 0)eJ             *cp1 = 0;              /* Perfect match, no directory spec  */         else	         {r             switch(*cp1)
             {e             case '.':*C             case '[':               /* Legal beginnings or ends  */                  break;M             default:            /* We are above the default, use full name */rE                 cp1 = strchr(temp,'[');    /* Fixed this from 1.5  */                  *dire = '\0';                  break;
             }nE             cp1++;                 /* Get past the starting . or [ */u	         }          strcat(dire, cp1);     }      else         strcpy(dire, temp + 1); H     cp1 = strrchr(dire, ']');       /* change trailing directory mark */     if (cp1 != NULL)     {r         *cp1++ = '/';	M         *cp1 = '\0';                /* and terminate string (no file name) */i     } A     strcpy(temp,strrchr(line,']')+1); /* Now get the file name */ (     if((cp1=strindex(temp,".DIR;1"))!=0)     {tM         *cp1++ = '/';                          /* Terminate directory name */          *cp1 = '\0';         strcat(dire,temp);         *fname = '\0';     }"     else     {=         strcpy(fname,temp); F         *strchr(fname,';') = '\0';;           /* no version numbers */D         lowercase(fname);                     /* map to lowercase */     }b  )     /* Now rewrite the directory name  */d      lowercase(dire);'  F     for (cp1 = dire + 1; *cp1; ++cp1)         /* Change '.' to '/'  */         if(*cp1 == '.')0             *cp1 = '/';s     if((len=strlen(fname))==0)         return(ISDIRE);f     else         if(fname[--len] == '.')a            if (dot == 0)7                 fname[len] = 0; /* No trailing dots  */)         return(ISFILE);e } ( /* initsearch - parse input file name */B /* To start looking for file names to satisfy the requested input,C  * use the sys$parse routine to create a wild-card name block. When;B  * it returns, we can then use the resultant FAB and NAM blocks onA  * successive calls to sys$search() until there are no more filesr  * that match.  */   2 struct FAB fblock;      /* File attribute block */: struct NAM nblock;      /* Name attribute block for rms */   int initsearch(string) char string[]; {  int status;  char *strindex();t  static char searchname[NAMSIZE];* static char default_name[] = DEFAULT_NAME;  #     if(strindex(string,"::")!=NULL)t     {t>         printf("tar: DECnet file access is not supported.\n");         return(-1);      }/     fblock = cc$rms_fab;     nblock = cc$rms_nam;$     fblock.fab$l_dna = default_name;,     fblock.fab$b_dns = strlen(default_name);     fblock.fab$l_fna = string;&     fblock.fab$b_fns = strlen(string);     fblock.fab$l_nam = &nblock;s"     nblock.nam$l_esa = searchname;*     nblock.nam$b_ess = sizeof(searchname); #ifdef debug(     printf("searching on: %s\n",string); #endif      status = sys$parse(&fblock);     if(status != RMS$_NORMAL)r     {=         if(status == RMS$_DNF)?             printf("tar: directory not found %s\n",searchname);s         else1             printf("tar: error in SYS$PARSE.\n");          return (-1);     }rC     searchname[nblock.nam$b_esl] = 0;   /* Terminate the string  */o  D     /* Now reset for searching, pointing to the parsed name block */       fblock = cc$rms_fab;     fblock.fab$l_nam = &nblock;iD     return(nblock.nam$b_esl); /* return the length of the string  */ }N  ? /* search - get the next file name that matches the namblock */ 3 /* that was set up by the sys$search() function. */n   int search(buff,maxlen)  char buff[]; int maxlen;o {r int status;c       nblock.nam$l_rsa = buff;     nblock.nam$b_rss = maxlen;;     nblock.nam$b_rsl = 0;       /* For next time around  */y6     while ((status = sys$search(&fblock)) != RMS$_NMF)     {m#         buff[nblock.nam$b_rsl] = 0;P!         if(status == RMS$_NORMAL)/%             return(nblock.nam$b_rsl);          else	         {c#             if (status == RMS$_PRV)f@                 printf("tar: no privilege to access %s\n",buff);(             else if (status == RMS$_FNF)8                 printf("tar: file not found %s\n",buff);             else
             { B                 printf("tar: error in SYS$SEARCH for %s\n", buff);                 return (0);l
             } 	         }c     }f     return (0);b }e1 /* fill_header - fill the fields of the header */ : /* enter with the file name, if the file name is empty, */@ /* then this is a trailer, and we should fill it with zeroes. */   int fill_header(name)s char name[]; { 
 int i,chksum;   int zero = 0, hdrsize = RECSIZE; char *ptr,tem[15];  ! /* Fill the header with zeroes */r  8     lib$movc5(&zero, &zero, &zero, &hdrsize, &header);  B     if(strlen(name)!=0)         /* only fill if there is a file */     {iE         sprintf(header.title,"%s",name);        /* write file name */dF         sprintf(header.protection,"%6o ",mode); /* all written with */F         sprintf(header.uid,"%6o ",uid);         /* a trailing space */'         sprintf(header.gid,"%6o ",gid); F         sprintf(tem,"%11o ",bytecount);         /* except the count */I         strncpy(header.count,tem,12);           /* and the time, which */aF         sprintf(tem,"%11o ",vmstime);           /* except the count */B         strncpy(header.time,tem,12);            /* have no null */G         strncpy(header.chksum,"        ",8);    /* all blanks for sum*/c  < /* I know that the next two are already zero, but do them */  A         header.linkcount = 0;                   /* always zero */fB         sprintf(header.linkname,"%s","");       /* always blank */R         for(chksum=0, ptr = (char *)&header;ptr < (char *)&header.linkcount;ptr++)G                  chksum += *ptr;                /* make the checksum */o,         sprintf(header.chksum,"%6o",chksum);     }      return(0); }r  F /* strindex - search for string2 in string1, return address pointer */   char *strindex(string1,string2)r char *string1,*string2;  {  char *c1, *c2, *cp; $     for(c1 = string1; *c1 !=0; c1++)     {04         cp = c1;        /* save the start address */:         for(c2=string2; *c2 !=0 && *c1 == *c2; c1++,c2++);            if(*c2 == 0)=                 return(cp);e     }m     return(NULL);e }r  ; /* lowercase - function to change a string to lower case */f   int lowercase(string)T char string[]; {a int i;2         for(i=0;string[i]=tolower(string[i]);i++);:         return (--i);           /* return string length */ }=  D /* cleanup_dire - routine to get rid of rooted directory problems */! /* and any others that turn up */o   int cleanup_dire(string) char string[]; {I
 char *ptr;/         if((ptr=strindex(string,"][")) != NULL)s5         {       /* Just collapse around the string */m           strcpy(ptr,ptr+2);           return(1);	         }U5         if((ptr=strindex(string,"[000000.")) != NULL) (         {         /* remove "000000." */%             strcpy(ptr + 1, ptr + 8);              return(1);	         }          return(0); }    #ifdef EXPERIMENTe1 int outfile_rms(filename,nbytes,fdout,check_text)m char filename[]; int fdout, nbytes; int check_text;e {      int n, rms_status ;      struct FAB myfab ;     struct XABFHC myxab;     struct RAB myrab ;     unsigned short int b_size ;d$     char *UserBuffer, *TransBuffer ;/     int BytesRead, TransBufSize, i, TotalBytes;    #if 0       BytesRead = TotalBytes = 0 ;     b_size = vmsmrs ;T8     UserBuffer = (char*) malloc(b_size * sizeof(char)) ;?     TransBuffer = (char*) malloc((b_size+512) * sizeof(char)) ;t #endif       myfab = cc$rms_fab ;      myfab.fab$l_fna = filename ;(     myfab.fab$b_fns = strlen(filename) ;     myfab.fab$b_rat = vmsrat ;     myfab.fab$w_mrs = vmsmrs ;!     myfab.fab$b_org = FAB$C_SEQ ;s     myfab.fab$b_rfm = vmsrfm ;       myxab = cc$rms_xabfhc;$     myfab.fab$l_xab = (char*)&myxab;  #     rms_status = sys$open(&myfab) ;p     if (rms_status & 1)i     {  #if 1  	BytesRead = TotalBytes = 0 ;e 	b_size = myxab.xab$w_lrl ;y5 	UserBuffer = (char*) malloc(b_size * sizeof(char)) ;2< 	TransBuffer = (char*) malloc((b_size+512) * sizeof(char)) ; #endif         myrab = cc$rms_rab ;"         myrab.rab$w_usz = b_size ; #if 0c         if (b_size > 512)  #endif*             myrab.rab$l_ubf = UserBuffer ; #if 0a         else&             myrab.rab$l_ubf = buffer ; #endif"         myrab.rab$l_fab = &myfab ;+         rms_status = sys$connect(&myrab) ; r     }      if ( !(rms_status & 1) )     { :         printf(" Unable to define RMS structures ...\n") ;2         printf(" Skipping file %s \n", filename) ;         return (-1) ;n     }   H     fill_header(pathname);          /* We have all of the information */@     write_header(fdout);            /* So write to the output */   #ifdef debug8     printf(" Starting to transter %d bytes\n", nbytes) ; #endif #if 0      if (b_size > 512)      {  #endif         /*  >         ** OK, this is the tricky case, and output to tar file>         ** will need to be buffered/divided to fit 512 blocks.
         */         TransBufSize = 0 ;&         rms_status = sys$get(&myrab) ;C         while( rms_status != RMS$_EOF && rms_status == RMS$_NORMAL)a	         { )             BytesRead = myrab.rab$w_rsz ;; 	    if (check_text)% 		if (UserBuffer[BytesRead-2] == '\r't) 		    && UserBuffer[BytesRead-1] == '\n'); 		{') 		    UserBuffer[(--BytesRead)-1] = '\n';  		} !             nbytes -= BytesRead ; J             memcpy( (TransBuffer + TransBufSize), UserBuffer, BytesRead) ;'             TransBufSize += BytesRead ;1$             if (TransBufSize >= 512)
             {'                 /*<                 ** OK, time to flush out the Transfer Buffer                 */                 i = 0 ; +                 while (TransBufSize >= 512)                  { @                     memcpy(buffer, (TransBuffer + i), RECSIZE) ;%                     flushout(fdout) ;u"                     i += RECSIZE ;-                     TransBufSize -= RECSIZE ;                  }eF                 memcpy(TransBuffer, (TransBuffer + i), TransBufSize) ;
             }s*             rms_status = sys$get(&myrab) ;	         }s         if (TransBufSize != 0 ) 	         {t             /*  .             ** Flush the buffer one last time              */3             memcpy(buffer, EmptyTrailer, RECSIZE) ;n7             memcpy(buffer, TransBuffer, TransBufSize) ;h             flushout(fdout) ;e	         }M- #if 0				/* This part should NOT be needed */M     }      else     {i         /* LH         ** This is the simple case of PDS files where max. record length0         ** is 512, so no splitting is required. F         ** Infact even with this case some records could be less than D         ** 512 bytes, and so the output to tar file will need to be G         ** "buffered" - i.e. it will be safe to use the previous optionb         ** for all cases.a
         */&         rms_status = sys$get(&myrab) ;C         while( rms_status != RMS$_EOF && rms_status == RMS$_NORMAL)f	         {s)             BytesRead = myrab.rab$w_rsz ;S!             nbytes -= BytesRead ;u             flushout(fdout); n*             rms_status = sys$get(&myrab) ;	         }      }  #endif     sys$close(&myfab) ;      return(0); }      intu$ get_varfilesize(filename,check_text) char *filename; < int check_text;			/* Boolean: Check if text file on true. */ {  int n, rms_status ;d struct FAB myfab ; struct XABFHC myxab; struct RAB myrab ; unsigned short int b_size ;l char *UserBuffer ; int BytesRead, TotalBytes;   #if 0N      BytesRead = TotalBytes = 0 ;     b_size = vmsmrs ;a8     UserBuffer = (char*) malloc(b_size * sizeof(char)) ; #endif       myfab = cc$rms_fab ;      myfab.fab$l_fna = filename ;(     myfab.fab$b_fns = strlen(filename) ;     myfab.fab$b_rat = vmsrat ;     myfab.fab$w_mrs = vmsmrs ;!     myfab.fab$b_org = FAB$C_SEQ ;      myfab.fab$b_rfm = vmsrfm ;       myxab = cc$rms_xabfhc;$     myfab.fab$l_xab = (char*)&myxab;  #     rms_status = sys$open(&myfab) ;      if (rms_status & 1)_     {  #if 1  	BytesRead = TotalBytes = 0 ;f 	b_size = myxab.xab$w_lrl ; 5 	UserBuffer = (char*) malloc(b_size * sizeof(char)) ;f #endif         myrab = cc$rms_rab ;"         myrab.rab$w_usz = b_size ;&         myrab.rab$l_ubf = UserBuffer ;"         myrab.rab$l_fab = &myfab ;+         rms_status = sys$connect(&myrab) ; "     };     if ( !(rms_status & 1) )     { :         printf(" Unable to define RMS structures ...\n") ;         return (-1) ;s     }   "     rms_status = sys$get(&myrab) ;"     if (rms_status != RMS$_NORMAL)     {h 	bytecount = -1; 	return (0);     }w?     while( rms_status != RMS$_EOF && rms_status == RMS$_NORMAL),     { %         BytesRead = myrab.rab$w_rsz ;r 	if (check_text)( 	    if (UserBuffer[BytesRead-2] != '\r'% 		|| UserBuffer[BytesRead-1] != '\n'), 	    { 		bytecount = -1;(
 		return (0);  	    }	 	    elseh9 		BytesRead--; /* The \r will be thrown out the window */,  !         TotalBytes += BytesRead ; &         rms_status = sys$get(&myrab) ;     }      sys$close(&myfab) ;      return (TotalBytes) ;6 }, #endif /* EXPERIMENT */n