 #ifndef LINT3 /* derived from: zooext.c 2.21 88/08/24 02:39:04 */ 1 /*$Source: /usr/home/dhesi/zoo/RCS/zooext.c,v $*/ 5 /*$Id: zooext.c,v 1.9 91/07/09 01:54:13 dhesi Exp $*/ F static char sccsid[]="$Source: /usr/home/dhesi/zoo/RCS/zooext.c,v $\n\3 $Id: zooext.c,v 1.9 91/07/09 01:54:13 dhesi Exp $";  #endif /* LINT */    /*; Copyright (C) 1986, 1987 Rahul Dhesi -- All rights reserved 5 (C) Copyright 1988 Rahul Dhesi -- All rights reserved 5 (C) Copyright 1991 Rahul Dhesi -- All rights reserved  */I /* Extract file from archive.  Extracts files specified in parameter-list E    from archive zoo_path.  If none specified, extracts all files from     archive. */   #include "options.h" #include "zoo.h"8 #include "parse.h"      /* defines struct for parse() */  6 #include "portable.h"   /* portable I/O definitions */; #include "machine.h"    /* machine-specific declarations */    #include "zooio.h" #include "various.h"   #ifndef NOSIGNAL #include <signal.h>  #endif   #include "zoofns.h"   6 #ifdef MODE_BIN		/* will need fileno() from stdio.h */ # include <stdio.h>  #endif   void makepath PARMS((char *));C int needed PARMS((char *, struct direntry *, struct zoo_header *));  void putstr PARMS((char *));   #ifdef FATTR- int setfattr PARMS ((char *, unsigned long));  #endif /* FATTR */   extern int quiet;    #include "errors.i"   B /* Following two are used by ctrl_c() also, hence declared here */G char extfname[LFNAMESIZE];             /* filename of extracted file */ M char prtfname[LFNAMESIZE];             /* name of extracted file on screen */ < static ZOOFILE this_file;              /* file to extract */  L static int tofile;                     /* true if not pipe or null device */ extern unsigned int crccode;E extern char *out_buf_adr;              /* address of output buffer */    void zooext(zoo_path, option)  char *zoo_path, *option; { E char *whichname;                          /* which name to extract */ I char matchname[PATHSIZE];                 /* for pattern matching only */  #ifndef NOSIGNALE T_SIGNAL (*oldsignal)();        /* to save previous SIGINT handler */  #endif< ZOOFILE zoo_file;                         /* open archive */I long next_ptr;                            /* pointer to within archive */ B struct zoo_header zoo_header;             /* header for archive */< int status;                               /* error status */- int exit_status = 0;								/* exit status */ = int error_message;								/* Whether to give error message */ ? unsigned long disk_space;                 /* disk space left */ B int matched = 0;                          /* Any files matched? */I int overwrite = 0;                        /* force overwrite of files? */ 6 int supersede = 0;								/* supersede newer files? */I int needdel = 0;                          /* extract deleted files too */ G int usepath = 2;                          /* use path for extraction */ E int todot = 0;                            /* extract relative to . */ K int badcrc_count = 0;                     /* how many files with bad CRC */ P int bad_header = 0;                       /* to avoid spurious messages later */E long fiz_ofs = 0;                         /* offset where to start */ : long dat_ofs = 0;									/* .. and offset of file data */E int pipe = 0;                             /* are we piping output? */ N int null_device = 0;                      /* are we sending to null device? */ #ifndef PORTABLEE int fast_ext = 0;                         /* fast extract as *.?Z? */ I int alloc_size;                           /* disk allocation unit size */  #endif? struct direntry direntry;                 /* directory entry */ 5 int first_dir = 1;								/* first dir entry seen? */   C static char extract_ver[] = "Zoo %d.%d is needed to extract %s.\n"; D static char no_space[] = "Insufficient disk space to extract %s.\n";   while (*option) {     switch (*option) {  #ifndef PORTABLE"       case 'z': fast_ext++; break; #endif       case 'x':        case 'e': break;%       case 'N': null_device++; break; &       case 'O': overwrite += 2; break;#       case 'o': overwrite++; break;        case 'p': pipe++; break; 		case 'S': supersede++; break; !       case 'd': needdel++; break;        case 'q': quiet++; break;  		case ':': usepath = 0; break; !       case '/': usepath++; break;        case '.': todot++; break; B       case '@':		/* if @m,n specified, fiz_ofs = m, dat_ofs = n */ 			{ 				char *comma_pos;
 				++option; $ 				comma_pos = strchr(option, ','); 				if (comma_pos != NULL) {( 					dat_ofs = calc_ofs (comma_pos + 1); 					*comma_pos = '\0';  				}  				fiz_ofs = calc_ofs(option);  				goto no_more;  			}       default:-          prterror ('f', inv_option, *option);           /* break; */     }    option++; }   1 no_more: /* come from exit in while loop above */     J if (overwrite == 1)                 /* must be at least 2 to begin with */    overwrite--;    if (null_device && pipe) {#    prterror ('f', inv_option, 'p');     pipe = 0; }    if (overwrite && pipe)'    prterror ('w', option_ignored, 'O');    #ifndef PORTABLE if (null_device && fast_ext) {#    prterror ('w', inv_option, 'N');     null_device = 0;  }  #endif  @ tofile = !pipe && !null_device;     /* sending to actual file */  % zoo_file = zooopen(zoo_path, Z_READ);    if (zoo_file == NOFILE) ,    prterror ('f', could_not_open, zoo_path);  J if (fiz_ofs != 0L) {                /* if offset specified, start there */- 	prterror ('m', start_ofs, fiz_ofs, dat_ofs); "    zooseek (zoo_file, fiz_ofs, 0); } else {    /* read header */$    frd_zooh (&zoo_header, zoo_file);=    if ((zoo_header.zoo_start + zoo_header.zoo_minus) != 0L) { )       prterror ('w', failed_consistency);        bad_header++;  		exit_status = 1;    }O    zooseek (zoo_file, zoo_header.zoo_start, 0); /* seek to where data begins */  }    #ifndef PORTABLEK disk_space = space (0, &alloc_size);         /* remember disk space left */  #else < disk_space = MAXLONG;              /* infinite disk space */ #endif  : /* if piping output we open the output device just once */ if (null_device) {    this_file = NULLFILE; } else if (pipe)/    this_file = STDOUT;    /* standard output */    while (1) { !    frd_dir (&direntry, zoo_file); %    if (direntry.zoo_tag != ZOO_TAG) {        long currpos, zoolength;! 		prterror ('F', invalid_header);   > 		/* Note:  if header was bad, there's no point trying to find? 			how many more bytes aren't processed -- our seek position is  			likely very wrong */    		if (!bad_header)- 			if ((currpos = zootell (zoo_file)) != -1L) ( 				if (zooseek (zoo_file, 0L, 2) != -1)1 					if ((zoolength = zootell (zoo_file)) != -1L) 1 						printf (cant_process, zoolength - currpos);  		zooexit (1);    }?    if (direntry.next == 0L) {                /* END OF CHAIN */ G       break;                                 /* EXIT on end of chain */     }M 	/* when first direntry read, change dat_ofs from abs. pos. to rel. offset */ ! 	if (first_dir && dat_ofs != 0) {  		dat_ofs -= direntry.offset;  		first_dir = 0; 	}H    next_ptr = direntry.next + dat_ofs;       /* ptr to next dir entry */  A    whichname = choosefname(&direntry);       /* which filename */ 1 	whichname = str_dup(whichname);				/* bug fix */ =    fixfname(whichname);                      /* fix syntax */ B 	strcpy (matchname, fullpath (&direntry));	/* get full pathname */ 	if (zoo_header.vdata & VFL_ON) ? 		add_version (matchname, &direntry);		/* add version suffix */   B /* if extraction to subtree rooted at curr dir, modify pathname */ #if 0  #ifdef DIR_LBRACK 5    if (todot && direntry.dirname[0] == *DIR_LBRACK && 7                 direntry.dirname[1] != *CUR_DIR)      {        char tmpstr[PATHSIZE];"       strcpy (tmpstr, DIR_LBRACK);       strcat (tmpstr, CUR_DIR); ,       strcat (tmpstr, &direntry.dirname[1]);(       strcpy (direntry.dirname, tmpstr);    } #endif #endif  4    /* hard-coded '/' should be eventually removed */+    if (todot && *direntry.dirname == '/') {        char tmpstr[PATHSIZE];'       strcpy(tmpstr, direntry.dirname); '       strcpy(direntry.dirname,CUR_DIR); '       strcat(direntry.dirname, tmpstr);     }  C    /* matchname now holds the full pathname for pattern matching */   *    if ( ( (needdel && direntry.deleted) ||.             (needdel < 2 && !direntry.deleted)9         ) && needed(matchname, &direntry, &zoo_header)) { @       matched++;           /* update count of files extracted */  /       if (direntry.major_ver > MAJOR_LZH_VER || 0          (direntry.major_ver == MAJOR_LZH_VER &&2             direntry.minor_ver > MINOR_LZH_VER)) {;             prterror ('e', extract_ver, direntry.major_ver, :                            direntry.minor_ver, whichname); 				exit_status = 1;             goto loop_again;       }          /*C       If extracting to null device, or if user requested extraction =       of entire path, include any directory name in filename. C       If extraction to current directory requested, and if extfname +       begins with path separator, fix it */   #       strcpy (extfname, whichname); =       if ((usepath || null_device) && direntry.dirlen != 0) { 8          combine(extfname, direntry.dirname, whichname);)          if (usepath > 1 && !null_device) E             makepath(direntry.dirname);         /* make dir prefix */        }    		strcpy(prtfname, extfname);   		if (zoo_header.vdata & VFL_ON)% 			add_version (prtfname, &direntry);          if (tofile) {           int present = 0;    #ifndef PORTABLE          /* ?          if Z format (fast) extraction, extension is created as D          follows:  for no current extension, new extension is "zzz";@          for current extension "a", new extension is "azz";  forA          current extension "ab", new extension is "azb";  and for 9          current extension "abc", new extension is "azc".           */             if (fast_ext) {             int length; #             struct path_st path_st; D             parse (&path_st, extfname);         /* split filename */H             strcpy (extfname, path_st.fname);   /* just root filename */*             length = strlen (path_st.ext);#             strcat (extfname, ".");              if (length == 0)D                strcat (extfname, "zzz");        /* no ext -> .zzz */#             else if (length == 1) { .                strcat (extfname, path_st.ext);E                strcat (extfname, "zz");         /* *.?    -> *.?zz */ +             } else { /* length is 2 or 3 */ J                if (length == 2)                 /* allow .aa, .ab, etc. */2                   path_st.ext[2] = path_st.ext[1];$                path_st.ext[1] = 'z';E                strcat (extfname, path_st.ext);  /* *.??   -> *.?z? */ 
             } % 				strcpy(prtfname, direntry.fname); & 				add_version (prtfname, &direntry);
          } #endif   /* ifndef PORTABLE */  ? 			/* don't extract if archived file is older than disk copy */ ( 			if (!supersede && exists(extfname)) { 				unsigned int ddate, dtime; #ifdef GETUTIME ( 				getutime (extfname, &ddate, &dtime); #else  				ZOOFILE tfile;4 				ddate = dtime = 0xffff;					/* assume maximum */& 				tfile = zooopen(extfname, Z_READ); 				if (tfile == NOFILE) 					goto loop_again; $ 				gettime (tfile, &ddate, &dtime); 				zooclose (tfile);  #endifC 				if (cmpnum (direntry.date, direntry.time, ddate, dtime) <= 0) { 4 					prterror ('m', "%-14s -- skipped\n", prtfname); 					goto loop_again;  				}  			}            if (overwrite) { -             this_file = zoocreate (extfname);  #ifdef FATTRC 				/* if can't open file, and OO option, make it writable first */ 0 				if (this_file == NOFILE && overwrite >= 4 &&8 						(direntry.fattr >> 22) == 1 && exists(extfname)) {E 					setfattr (extfname, (unsigned long) (1L << 7) | direntry.fattr); & 					this_file = zoocreate (extfname); 				}  #endif /* FATTR */          } else { $             if (exists (extfname)) {                present = 1; "                this_file = NOFILE;             } else0                this_file = zoocreate (extfname);
          } 			error_message = 1; #          if (this_file == NOFILE) { A             if (present == 1) {      /* if file exists already */ 8 					char ans[20];          /* answer to "Overwrite?" */                do {  #ifdef EXT_ANYWAY E                   printf ("%s exists; extract anyway? [Yes/No/All] ", %                            extfname);  #else C                   printf ("Overwrite %s (Yes/No/All)? ", extfname);  #endif!                   fflush (stdin); 2                   fgets (ans, sizeof(ans), stdin);                    str_lwr (ans);C                } while (*ans != 'y' && *ans != 'n' && *ans != 'a');                   if (*ans == 'a')                    overwrite++;0                if (*ans == 'y' || *ans == 'a') {2                   this_file = zoocreate(extfname);K                   error_message = 1; /* give error message if open fails */                 } else { M                   error_message = 0; /* user said 'n', so no error message */                 }             } else {J                error_message = 1;   /* Real error -- give error message */
             }           } /* end if */        } /* end if */  F       if (this_file == NOFILE) {         /* file couldn't be opened */"          if (error_message == 1) {D             prterror ('e', "Can't open %s for output.\n", extfname); 				exit_status = 1;   #ifndef PORTABLE6             /* if error was due to full disk, abort */3             if (space(0, &alloc_size) < alloc_size) )                prterror ('f', disk_full);  #endif  
          }M       } else if (zooseek (zoo_file, (direntry.offset + dat_ofs), 0) == -1L) { :          prterror ('e', "Could not seek to file data.\n"); 			exit_status = 1;            close_file (this_file);       } else { #ifndef PORTABLEF          /* check msdos's free disk space if we seem to be running low/             (within 1 cluster of being full) */ E          if (tofile && disk_space < direntry.org_size + alloc_size) { 0             disk_space = space (0, &alloc_size);*             if (disk_space < alloc_size) {&                close_file (this_file);!                unlink (extfname); )                prterror ('f', disk_full); 
             } 
          } #endif8          if (tofile && disk_space < direntry.org_size) { #ifdef PORTABLE 
             ;  #else ' 				prterror ('e', no_space, prtfname); J             unlink (extfname);               /* delete any created file */ #endif   /* portable */             } else {    #ifndef PORTABLEF             if (fast_ext) {            /* fast ext -> create header */N                void make_tnh PARMS((struct tiny_header *, struct direntry *));.                struct tiny_header tiny_header;1                make_tnh(&tiny_header, &direntry); P                zoowrite (this_file, (char *) &tiny_header, sizeof(tiny_header));  ?                if (direntry.cmt_size != 0) { /* copy comment */                     long save_pos;0                   save_pos = zootell (zoo_file);:                   zooseek (zoo_file, direntry.comment, 0);/                   getfile (zoo_file, this_file, 7                           (long) direntry.cmt_size, 0); 2                   zooseek (zoo_file, save_pos, 0);                }
             }  #endif /* ifndef PORTABLE */  D             crccode = 0;      /* Initialize CRC before extraction */                if (!pipe) {  #ifdef PORTABLE 8                   prterror ('m', "%-14s -- ", prtfname); #else                    if (fast_ext) :                      prterror ('m', "%-12s ==> %-12s -- ",-                         prtfname,  extfname);                    else;                      prterror ('m', "%-12s -- ", prtfname);  #endif /* PORTABLE */   5                } else {            /* must be pipe */ I                   prterror ('M',"\n\n********\n%s\n********\n",prtfname);    #ifdef SETMODEM                   MODE_BIN(this_file);           /* make std output binary so J                                                    ^Z won't cause error */ #endif                } #ifndef NOSIGNAL             if (tofile)                 {7                   oldsignal = signal (SIGINT, SIG_IGN); +                   if (oldsignal != SIG_IGN) P                      signal (SIGINT, ctrl_c); /* Trap ^C & erase partial file */                } #endif /* not NOSIGNAL */   -             if (direntry.packing_method == 0) 1                /* 4th param 1 means CRC update */ L                status = getfile (zoo_file, this_file, direntry.size_now, 1);   #ifndef PORTABLE             else if (fast_ext)4                /* 4th param 0 means no CRC update */L                status = getfile (zoo_file, this_file, direntry.size_now, 0); #endif  4             else if (direntry.packing_method == 1) { #ifdef UNBUF_IO  /*#include "ERROR"*/2 					/* NOT PORTABLE -- DO NOT TRY THIS AT HOME */) 					long lseek PARMS ((int, long, int));  					long tell PARMS ((int));  					int this_fd, zoo_fd;    					/* get file descriptors */ 5 					this_fd = null_device ? -2 : fileno (this_file);   					zoo_fd = fileno (zoo_file);  ; 					zooseek (zoo_file, zootell (zoo_file), 0);	/* synch */ ; 					lseek (zoo_fd, zootell (zoo_file), 0);			/* ..again */  					if (!null_device) {> 						zooseek (this_file, zootell (this_file), 0);	/* synch */= 						lseek (this_fd, zootell (this_file), 0);		/* ..again */  					}: 			      status = lzd(zoo_fd, this_fd);			/* uncompress */8 					zooseek (zoo_file, tell (zoo_fd), 0);	/* resynch	*/ 					if (!null_device): 						zooseek (this_file, tell (this_fd), 0);/* resynch	*/ #else C                status = lzd (zoo_file, this_file);	/* uncompress */  #endif6             } else if (direntry.packing_method == 2) {9                status = lzh_decode (zoo_file, this_file);              } else {G                prterror ('e', "File %s:  impossible packing method.\n",                    whichname); #                   unlink(extfname); "                   goto loop_again;
             }      #ifndef NOSIGNAL             if (tofile) *                signal (SIGINT, oldsignal); #endif /* not NOSIGNAL */    #ifdef SETMODE             if (pipe) E                MODE_TEXT(this_file);          /* restore text mode */  #endif               if (tofile) { :                /* set date/time of file being extracted */ #ifdef GETTZ 					void tzadj();' 					/* adjust for original timezone */  					tzadj (&direntry);  #endif #ifdef NIXTIME&                close_file (this_file);A                setutime (extfname, direntry.date, direntry.time);  #else A                settime (this_file, direntry.date, direntry.time); &                close_file (this_file); #endif #ifdef FATTRI /* Restore file attributes. Bit 23==1 means system-specific; we currently I don't recognize this.  Bit 23==0 means use portable format, in which case G bit 22==0 means ignore attributes.  Thus attributes are ignored if both B bits 23 and 22 are zero, which is the effect of a zero-filled fileE attribute field.  Currently we restore file attributes if and only if  bit 23==0 and bit 22==1. */   ' 					if ((direntry.fattr >> 22) == 1) { * 						setfattr (extfname, direntry.fattr); 					} #endif /* FATTR */*             } /* end of if (tofile) ... */             if (status != 0) { 					exit_status = 1;                 if (tofile)$                   unlink (extfname);5                if (status == 2) {	/* was 1 (wrong) */                    memerr(0);J                /* To avoid spurious errors due to ^Z being sent to screen,E                   we don't check for I/O error if output was piped */ B                } else if (!pipe && (status == 2 || status == 3)) {8                      prterror ('e', no_space, prtfname);                }             } else {;                /* file extracted, so update disk space.  */ D                /* we subtract the original size of the file, roundedC                   UP to the nearest multiple of the disk allocation                    size. */ #ifndef PORTABLE                {%                   unsigned long temp; G                   temp = (direntry.org_size + alloc_size) / alloc_size; 2                   disk_space -= temp * alloc_size;                } #endif                  if (  #ifndef PORTABLE 					      !fast_ext &&  #endif# 							direntry.file_crc != crccode 	 						) { !                   badcrc_count++;  						exit_status = 1;                   if (!pipe) {&                      if (!null_device)7                         prterror ('M', "extracted   "); 7                      prterror ('w', bad_crc, prtfname);                    } <                   else {   /* duplicate to standard error */8                      static char stars[] = "\n******\n";$                      putstr (stars);7                      prterror ('w', bad_crc, prtfname); $                      putstr (stars);4                      fprintf (stderr, "WARNING:  ");9                      fprintf (stderr, bad_crc, prtfname);                    }                 } else                    if (!pipe)J                      prterror ('M', null_device ? "OK\n" : "extracted\n");               } /* end if */          } /* end if */        } /* end if */    } /* end if */    loop_again: B    zooseek (zoo_file, next_ptr, 0); /* ..seek to next dir entry */ } /* end while */    close_file (zoo_file);
 if (!matched)     putstr (no_match);    if (badcrc_count) { >    prterror ('w', "%d File(s) with bad CRC.\n", badcrc_count); } else if (null_device) )    prterror ('m', "Archive seems OK.\n");    zooexit (exit_status);   } /* end zooext */   /* close_file() */; /* closes a file if and only if we aren't sending output to "    a pipe or to the null device */   void close_file (file)
 ZOOFILE file;  {     if (tofile)       zooclose (file); }   C /* Ctrl_c() is called if ^C is hit while a file is being extracted. 1    It closes the files, deletes it, and exits. */  T_SIGNAL ctrl_c()  {  #ifndef NOSIGNAL6    signal (SIGINT, SIG_IGN);     /* ignore any more */ #endif    zooclose (this_file);    unlink (extfname);     zooexit (1);  }    #ifndef PORTABLE+ /* make_tnh copies creates a tiny_header */ % void make_tnh (tiny_header, direntry)   struct tiny_header *tiny_header; struct direntry *direntry; { "    tiny_header->tinytag = TINYTAG;    tiny_header->type = 1; :    tiny_header->packing_method = direntry->packing_method;&    tiny_header->date = direntry->date;&    tiny_header->time = direntry->time;.    tiny_header->file_crc = direntry->file_crc;.    tiny_header->org_size = direntry->org_size;.    tiny_header->size_now = direntry->size_now;0    tiny_header->major_ver = direntry->major_ver;0    tiny_header->minor_ver = direntry->minor_ver;.    tiny_header->cmt_size = direntry->cmt_size;0    strcpy (tiny_header->fname, direntry->fname); }  #endif /* ifndef PORTABLE */