 #ifndef LINT: static char sccsid[]="@(#) parse.c 2.1 87/12/25 12:24:10"; #endif /* LINT */    /*C The contents of this file are hereby released to the public domain.   :                                  -- Rahul Dhesi 1986/11/14   */   #include "options.h" #include "zoo.h" #include "zooio.h" #include "various.h" #include "zoofns.h"    #include "parse.h" #include "assert.h"    /*I parse() accepts a filename and return its component parts in a structure. I The component parts are:  disk drive, path prefix, root name of filename,  and extension.  > If DISK_CH is not defined, it is assumed that filenames may be@ preceded with a disk prefix terminated by the character DISK_CH.< The first character of the disk prefix, followed by DISK_CH, is returned in the drive field.   B If the symbol DISK_CH is defined, a null string is returned in the disk field.  */ void parse (path_st, fname) ! register struct path_st *path_st;  char *fname; { H    char tempname[LFNAMESIZE];       /* working copy of supplied fname */K    char *namep;                   /* points to relevant part of tempname */       char *p;     strcpy (tempname, fname);   #ifdef DEBUG6 printf ("parse:  supplied name is [%s].\n", tempname); #endif   #ifndef DISK_CH     path_st->drive[0] = '\0';@    namep = tempname;           /* points to pathname+filename */ #else     path_st->drive[0] = '\0';@    p = strchr (tempname, DISK_CH);      /* point to first ':' */      if (p != NULL) { K       path_st->drive[0] = *tempname;/* use only first char of drive name */ "       path_st->drive[1] = DISK_CH;       path_st->drive[2] = '\0'; B       namep = ++p;                /* point to pathname+filename */    } else {        path_st->drive[0] = '\0'; C       namep = tempname;           /* points to pathname+filename */     } #endif /* end of not DISK_CH */   F    /* Note:  findlast() finds last occurrence in the subject string of"       any one of a set of chars */      /* save the long filename */ "    p = findlast (namep, PATH_SEP);  L    /* if path separator found, copy next char onwards; else entire string */    strncpy (path_st->lfname,)                (p != NULL) ? p+1 : namep,                 LFNAMESIZE); I    path_st->lfname[LFNAMESIZE-1] = '\0';     /* force null termination */    #ifdef DEBUG5 printf ("parse:  path = [%s] long filename = [%s]\n", !          namep, path_st->lfname);  #endif    /* Separate out the extension */: p = findlast (namep, EXT_SEP);						/* look for . or /		*/6 if (p != NULL && *p != EXT_CH)						/* found .?					*/0 	p = NULL;												/* ... if not, ignore / */   #ifdef DEBUG if (p == NULL);    printf ("parse:  no extension found for [%s]\n", namep);  else=    printf ("parse:  extension for [%s] is [%s]\n", namep, p);  #endif  J    path_st->ext[0] = '\0';                      /* assume no extension  */J    if (p != NULL) {                             /* found extension      */J       strncpy (path_st->ext, (p+1), EXTLEN);    /* save extension       */J       path_st->ext[EXTLEN] = '\0';              /* force termination    */J       *p = '\0';                                /* null out extension   */    }  -    /* separate out root of filename if any */ "    p = findlast (namep, PATH_SEP);      if (p != NULL) { 
       ++p;H       strncpy (path_st->fname, p, ROOTSIZE);  /* save filename        */6       *p = '\0';               /* null out filename */    } else { 0       strncpy (path_st->fname, namep, ROOTSIZE);A       *namep = '\0';                   /* null out filename    */     }H    path_st->fname[ROOTSIZE] = '\0';           /* force termination    */  >    /* what remains, whether null or not, is the path prefix */C    path_st->dir[0] = '\0';             /* in case *namep is '\0' */   +    strncpy (path_st->dir, namep, PATHSIZE);   C    /* remove trailing path-separater from directory name, but don't 6       remove it if it is also the leading separater */    {       int n;       n = strlen(path_st->dir);        if (n != 1) "          path_st->dir[n-1] = '\0';    }   #ifdef DEBUG0 printf ("parse:  path prefix = [%s].\n", namep); #endifC    /* if extension is null, and if long filename contains more than A       ROOTSIZE  characters, transfer some of them to extension */ G    if (path_st->ext[0] == '\0' && strlen(path_st->lfname) > ROOTSIZE) { @       strncpy(path_st->ext, &path_st->lfname[ROOTSIZE], EXTLEN);       path_st->ext[3] = '\0';     } }    /*******************/  /*L findlast() finds last occurrence in provided string of any of the characters. except the null character in the provided set.  F If found, return value is pointer to character found, else it is NULL. */   char *findlast (str, set) 3 register char *str;        /* subject string     */ > char *set;                 /* set of characters to look for */   {     register char *p;  B    if (str == NULL || set == NULL || *str == '\0' || *set == '\0')       return (NULL);  <    p = lastptr (str);   /* pointer to last char of string */    assert(p != NULL);   1    while (p != str && strchr (set, *p) == NULL) { 
       --p;    }  8    /* either p == str or we found a character or both */     if (strchr (set, *p) == NULL)       return (NULL);    else        return (p);  }    /*******************/  /*L lastptr() returns a pointer to the last non-null character in the string, if+ any.  If the string is null it returns NULL  */   char *lastptr (str) K register char *str;                 /* string in which to find last char */  {     register char *p;    if (str == NULL) :       prterror ('f', "lastptr:  received null pointer\n");    if (*str == '\0')       return (NULL);    p = str; >    while (*p != '\0')            /* find trailing null char */
       ++p;>    --p;                          /* point to just before it */    return (p); } 