0 /* derived from: zoo.h 2.16 88/01/27 23:21:36 */   /*C The contents of this file are hereby released to the public domain.   4                            -- Rahul Dhesi 1986/11/14 */    L /* Global data structures and also some information about archive structure.  0 Among other things, the archive header contains:  H (a) A text message.  In the MS-DOS version this message is terminated byE control Z.  This allows naive users to type the archive to the screen K and see a brief but meaningful message instead of garbage.  The contents of F the text message are however not used by Zoo and they may be anything.G In particular, the text message may identify the type or archive or the H particular computer system it was created on.  When an archive is packedF by any version of Zoo, the text message is changed to the text messageH used by that version.  For example, if Zoo 1.10 packs an archive createdC by Zoo 1.31, the text message changes to "Zoo 1.10 archive.".  This F was once considered a shortcoming, but it is now an essential feature,A because packing will also update an old archiver header structure  into a new one.   I (b) A four-byte tag that identifies all Zoo archives.  This helps prevent L arbitrary binary files from being treated as Zoo archives.  The tag value isI arbitrary, but seemed to be unlikely to occur in an executable file.  The 8 same tag value is used to identify each directory entry.  I (c) A long pointer to where in the file the archive starts.  This pointer H is stored along with its negation for consistency checking.  It is hopedG that if the archive is damaged, both the pointer and its negation won't F be damaged and at least one would still be usable to tell us where the data begins.  E (d) A two-byte value giving the major and minor version number of the F minimum version of Zoo that is needed to fully manipulate the archive.G As the archive structure is modified, this version number may increase. L Currently version 1.71 of Zoo creates archives that may be fully manipulated by version 1.40 onwards.  A (e) With zoo 2.00 addtional fields have been added in the archive D header to store information about the archive comment and generation limit.   Version numbering:K The directory entry of each file will contain the minimum version number of I Zoo needed to extract that file.  As far as possible, version 1.00 of Zoo ; will be able to extract files from future version archives.  */  - #define H_TYPE	1				/* archive header type */   , /* Define major and minor version numbers */= #define MAJOR_VER 2        /* needed to manipulate archive */  #define MINOR_VER 0   0 /* version needed to extract packing method 1 */ #define MAJOR_EXT_VER 1  #define MINOR_EXT_VER 0   0 /* version needed to extract packing method 2 */ #define MAJOR_LZH_VER	2  #define MINOR_LZH_VER	1    #define CTRL_Z 26   K /* should be 0xFDC4A7DCUL but many c compilers don't recognize UL at end */ C #define ZOO_TAG ((unsigned long) 0xFDC4A7DCL) /* A random choice */ E #define TEXT "ZOO 2.10 Archive.\032"   /* Header text for archive. */ @ #define SIZ_TEXT  20                   /* Size of header text */  C #define PATHSIZE 256                   /* Max length of pathname */ A #define FNAMESIZE 13                   /* Size of DOS filename */ B #define LFNAMESIZE 256                 /* Size of long filename */L #define ROOTSIZE 8                     /* Size of fname without extension */> #define EXTLEN 3                       /* Size of extension */K #define FILE_LEADER  "@)#("            /* Allowing location of file data */ > #define SIZ_FLDR  5                    /* 4 chars plus null */M #define MAX_PACK 2                     /* max packing method we can handle */ E #define BACKUP_EXT ".bak"              /* extension of backup file */   
 #ifdef OOZ #define FIRST_ARG 2  #endif  
 #ifdef ZOOC #define FIRST_ARG 3        /* argument position of filename list */  #endif   typedef unsigned char uchar;  I /* WARNING:  Static initialization in zooadd.c or zooext.c depends on the *    order of fields in struct zoo_header */ struct zoo_header { 7    char text[SIZ_TEXT];       /* archive header text */ 7    unsigned long zoo_tag;     /* identifies archives */ C    long zoo_start;            /* where the archive's data starts */ @    long zoo_minus;			/* for consistency checking of zoo_start */    uchar major_ver; J    uchar minor_ver;           /* minimum version to extract all files   */. 	uchar type;						/* type of archive header */5 	long acmt_pos;					/* position of archive comment */ 8 	unsigned int acmt_len;		/* length of archive comment */B 	unsigned int vdata;			/* byte in archive;  data about versions */ };   struct direntry { ;    unsigned long zoo_tag;     /* tag -- redundancy check */ O    uchar type;                 /* type of directory entry.  always 1 for now */ C    uchar packing_method;       /* 0 = no packing, 1 = normal LZW */ A    long next;                 /* pos'n of next directory entry */ 9    long offset;               /* position of this file */ 3    unsigned int date;         /* DOS format date */ 3    unsigned int time;         /* DOS format time */ 4    unsigned int file_crc;     /* CRC of this file */    long org_size;     long size_now;     uchar major_ver; F    uchar minor_ver;            /* minimum version needed to extract */C    uchar deleted;              /* will be 1 if deleted, 0 if not */ :    uchar struc;                /* file structure if any */D    long comment;              /* points to comment;  zero if none */=    unsigned int cmt_size;		/* length of comment, 0 if none */ )    char fname[FNAMESIZE];		/* filename */   H    int var_dir_len;           /* length of variable part of dir entry */E    uchar tz;                   /* timezone where file was archived */ :    unsigned int dir_crc;      /* CRC of directory entry */  ;    /* fields for variable part of directory entry follow */ <    uchar namlen;               /* length of long filename */=    uchar dirlen;               /* length of directory name */ 1    char lfname[LFNAMESIZE];   /* long filename */ 2    char dirname[PATHSIZE];    /* directory name */1    unsigned int system_id;    /* Filesystem ID */ 8 	unsigned long fattr;			/* File attributes -- 24 bits */E 	unsigned int vflag;			/* version flag bits -- one byte in archive */ : 	unsigned int version_no;	/* file version number if any */ };  # /* Values for direntry.system_id */ @ #define SYSID_NIX       0     /* UNIX and similar filesystems */5 #define SYSID_MS        1     /* MS-DOS filesystem */ 3 #define SYSID_PORTABLE  2     /* Portable syntax */   C /* Structure of header of small archive containing just one file */   0 #define  TINYTAG     0x07FE   /* magic number */   #ifndef PORTABLE: struct tiny_header {          /* one-file small archive */0    int tinytag;               /* magic number */4    char type;                 /* always 1 for now */    char packing_method;     unsigned int date;     unsigned int time;     unsigned int file_crc;     long org_size;     long size_now;     char major_ver;    char minor_ver;<    unsigned int cmt_size; /* length of comment, 0 if none */,    char fname[FNAMESIZE];     /* filename */ }; #endif /* ifndef PORTABLE */  8 #define	FIXED_OFFSET 34		/* zoo_start in old archives */< #define	MINZOOHSIZ 34			/* minimum size of archive header */> #define  SIZ_ZOOH  42			/* length of current archive header */  > /* offsets of items within the canonical zoo archive header */* #define  TEXT_I    0		/* text in header */$ #define  ZTAG_I    20		/* zoo tag */) #define  ZST_I     24		/* start offset */ 5 #define  ZSTM_I    28		/* negative of start offset */ * #define  MAJV_I    32		/* major version */* #define  MINV_I    33		/* minor version *// #define	HTYPE_I	 34			/* archive header type */ 8 #define	ACMTPOS_I 35			/* position of archive comment */6 #define	ACMTLEN_I 39			/* length of archive comment */) #define	HVDATA_I	 41			/* version data */   E /* offsets of items within the canonical directory entry structure */ D #define  SIZ_DIR  51          /* length of type 1 directory entry */D #define  SIZ_DIRL 56          /* length of type 2 directory entry */> #define  DTAG_I   0           /* tag within directory entry */; #define  DTYP_I   4           /* type of directory entry */ 2 #define  PKM_I    5           /* packing method */A #define  NXT_I    6           /* pos'n of next directory entry */ B #define  OFS_I    10          /* position (offset) of this file */3 #define  DAT_I    14          /* DOS format date */ 3 #define  TIM_I    16          /* DOS format time */ 4 #define  CRC_I    18          /* CRC of this file */1 #define  ORGS_I   20          /* original size */ , #define  SIZNOW_I 24          /* size now */8 #define  DMAJ_I   28          /* major version number */8 #define  DMIN_I   29          /* minor version number */2 #define  DEL_I    30          /* deleted or not */2 #define  STRUC_I  31          /* file structure */4 #define  CMT_I    32          /* comment [offset] */0 #define  CMTSIZ_I 36          /* comment size */, #define  FNAME_I  38          /* filename */; #define  VARDIRLEN_I  51      /* length of var. direntry */ , #define  TZ_I     53          /* timezone */: #define  DCRC_I   54          /* CRC of directory entry */  ; #define  FNM_SIZ  13          /* size of stored filename */   5 /* Offsets within variable part of directory entry */ " #define  NAMLEN_I   (SIZ_DIRL + 0)" #define  DIRLEN_I   (SIZ_DIRL + 1)" #define  LFNAME_I   (SIZ_DIRL + 2); #define  DIRNAME_I  LFNAME_I  /* plus length of filename */    /*A Total size of fixed plus variable directory recognized currently: C One byte each for dirlen and namlen, 256 each for long filename and = directory name, 2 for system id, 3 for file attributes, 1 for = version flag, 2 for version number, plus a fudge factor of 5.  */5 #define  MAXDIRSIZE  (SIZ_DIRL+1+1+256+256+2+3+1+2+5)   @ /* Value used to stuff into timezone field if it is not known */ #define  NO_TZ    127   " /* Value for no file attributes */ #define	NO_FATTR		0L   /* version flag bits */ 3 #define	VFL_ON	0x80		/* enable version numbering */ , #define	VFL_GEN	0x0f		/* generation count */9 #define	VFL_LAST 0x40		/* last generation of this file */   * /* default generation value for archive */ #define	GEN_DEFAULT			3 + /* max generation count, file or archive */  #define	MAXGEN				0x0fG /* version mask to prune down to correct size on large-word machines */  #define VER_MASK				0xffff