3 % UCTHESIS DOCUMENT CLASS -- Release info is below. # %    for LaTeX version 2e - 11/3/94   H %%% ==================================================================== %%%  @LaTeX-class-file{ ) %%%     filename        = "ucthesis.cls",   %%%     version         = "3.0",, %%%     date            = "31 October 1994",% %%%	portedby	= "Blaise B. Frederick", - %%%	address		= "Center for Functional Imaging % %%%			   Lawrence Berkeley Laboratory  %%%			   MS 55-121 %%%			   1 Cyclotron Rd. %%%			   Berkeley, CA 94720  %%%			   USA",! %%%	telephone	= "(510) 486-4423", ' %%%	email		= "frederic@imasun.lbl.gov", & %%%     codetable       = "ISO/ASCII",, %%%     keywords        = "LaTeX, ucthesis",4 %%%     supported       = "until November 30, 1994",F %%%     docstring       = "This file is the main file for the ucthesisL %%%                        class, which is intended to meet the requirementsL %%%                        for University of California Ph.D. dissertations.5 %%%			   It is a direct port to LaTeX2e from UCTHESIS 8 %%%			   v2.7 by Ethan V. Munson, with no changes other > %%%			   than those for compatibility.  The major modifictions9 %%%			   are in the font selection commands in the option  %%%			   files uct1x.clo. 	 %%%			    3 %%%			   UCTHESIS.STY v2.7 is based on the standard ; %%%			   report.sty as modified by Mittelbach and Schopf in ; %%%			   Jan 1992.  The primary differences are (1) the use < %%%			   of pseudo-double-spacing, except in certain specialI %%%                        environments; and (2) the use of a 6 inch line F %%%                        with 4em paragraph indentation.  It is only: %%%			   intended for single-sided printing.  Double-sided0 %%%			   printing may be possible, but you're on %%%			   your own. %%% D %%%                        I know of no bugs in this implementation,E %%%                        but would be happy to hear of any problems . %%%                        that arise with it. %%% 0 %%%			   Version 2.x fixes a bug in the previous3 %%%			   version of 20 Jun 1988.  The bug was that  5 %%%			   "draft" optional mode didn't work because of 1 %%%			   problems in handling optional arguments. H %%%                        This file does not seem to work with earlier < %%%                        versions of LaTeX (pre-Jan 1992). %%% . %%%			   Version 2.3 includes a single-spaced  %%%			   tabular* environment. %%%			3 %%%			   Version 2.4 sets \evensidemargin correctly / %%%			   for two-sided style.  It also adds new ( %%%			   environments (\smalltabular and1 %%%			   \scriptsizetabular) which produce tables 1 %%%			   with smaller fonts.  The obvious methods 2 %%%			   of producing small-font tables don't work %%%			   in ucthesis style.  %%% 4 %%%			   Version 2.5 adds support for the \maketitle %%%			   macro.  %%% 2 %%%			   Version 2.6 adds support for complete and2 %%%			   correct front matter.  Some dead code was %%%			   removed, too. %%% D %%%                        Version 2.7 adds front matter support forB %%%                        thesis committees of more than 3 peopleB %%%                        and for a labeled signature line on the) %%%                        abstract page.  %%% 4 %%%			   Version 3.0 is a direct port of version 2.79 %%%			   to LaTeX2e.  The major revisions in ucthesis.cls 5 %%%			   are converting option processing to LaTeX2e  8 %%%			   conventions.  The uct1x files have been revised0 %%%			   to use the new font selection commands. %%% / %%%			   Some users have had problems with the  1 %%%			   margins ending up too small on one side. / %%%			   This appears to be a DVI-to-PostScript . %%%			   driver or printer-adjustment problem.9 %%%			   If you have such trouble, make small adjustments - %%%			   to the \textwidth and \oddsidemargin , %%%			   settings in your document preamble.	 %%%			    0 %%%			   Another problem some people have had is0 %%%			   that you can't use \pagestyle{headings}6 %%%			   and \markboth if you use \part.  The solution3 %%%			   is to get the headerfooter style, which is ! %%%			   nice and simple to use."  %%%  }H %%% ====================================================================   \NeedsTeXFormat{LaTeX2e}O \ProvidesClass{ucthesis}[1994/10/31 v3.0 University of California Thesis Class]   - %    **************************************** - %    *               OPTIONS                * - %    ****************************************  % B % Option values are now declared first thing.  Defaults are set to> % 11 point, onesided, final (ie not draft) mode (BBF 10/31/94) \newcommand\@ptsize{}  \newcommand\@draftmark{}. \DeclareOption{10pt}{\renewcommand\@ptsize{0}}. \DeclareOption{11pt}{\renewcommand\@ptsize{1}}. \DeclareOption{12pt}{\renewcommand\@ptsize{2}}9 \DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse} 8 \DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}2 \DeclareOption{draft}{\renewcommand\@draftmark{1}}2 \DeclareOption{final}{\renewcommand\@draftmark{0}}# \ExecuteOptions{11pt,oneside,final}      % CHOOSING THE TYPE SIZE:  % G %  The type size option is handled by reading a different file for each ; %  size, as follows, to define font size-specific commands: 0 %       10pt : UCT10, 11pt : UCT11, 12pt : UCT12 %   ! %  Two-side or one-side printing.  % @ % \@twosidefalse               %  Default is one-sided printing.9 \def\ds@twoside{\@twosidetrue  %  Defines twoside option. E            \@mparswitchtrue}   %    Marginpars go on outside of page.   B % This is a tricky solution to a tough bootstrapping problem.  TheE % "draft" option requires the definition of the \ssp macro.  However, H % the \ssp macro requires that the uct1?.clo file has been loaded.  ThisA % loading is done by the \@options command which also invokes the @ % \ds@draft macro.  This was a cyclic dependency in the previousH % version.  To break this dependency, I have made \ds@draft set a markerE % which is later tested to determine whether to actually do the draft  % mode actions.  % ! % Ethan Munson (October 16, 1992)   A % FMi 91/03/30: made twocolum.sty a file and twocolumn an option.   5 % RmS 91/10/15: moved actual reading of twocolumn.sty ( %               to the end of this file." \def\ds@twocolumn{\@twocolumntrue}  J % The \ProcessOptions command causes the execution of every option commandJ % FOO which is declared and for which the user typed the FOO option in hisK % \documentclass.  For every undeclared option BAR there will be a warning   % message. (BBF 10/31/94)    \ProcessOptions    \input uct1\@ptsize.clo\relax   > % For some environments we switch back to single-spacing, alsoD % provides \dsp in case you need double-spacing where single-spacing % is otherwise used.4 \def\ssp{\def\baselinestretch{1.0}\large\normalsize}5 \def\dsp{\def\baselinestretch{1.37}\large\normalsize}   F % \smallssp is used to produce tabular environments in the small font.I % This is required because single-spacing requires a change in font size. > % \scriptsizessp is a still smaller version of the same thing.  4 \def\smallssp{\def\baselinestretch{1.0}\large\small}> \def\scriptsizessp{\def\baselinestretch{1.0}\large\scriptsize}  H %  draft option (this is where the draft option is actually implemented) % J % \overfullrule = 0pt             % Default is don't mark overfull hboxes. \ifnum \@draftmark = 1 \ssp				  % Single-spaces and ; \overfullrule 5pt		  % causes overfull hboxes to be marked.  \fi     ' % PREPARING A FOREIGN LANGUAGE VERSION:  % H % This document style is for documents prepared in the English language.G % To prepare a version for another language, various English words must G % be replaced.  Many of the English words that required replacement are E % indicated below, where we give the name of the command in which the B % words appear, and which must be redefined, with the actual words
 % underlined.  % F % Other English words that need replacement can be found in the macros* % supporting the title and approval pages. %  % \tableofcontents:  \def\contentsname{Contents}  %                 ~~~~~~~~ %  % \listoffigures: $ \def\listfigurename{List of Figures}# %                   ~~~~~~~~~~~~~~~  %  % \listoftables:" \def\listtablename{List of Tables}! %                  ~~~~~~~~~~~~~~  %  % \thebibliography:  \def\bibname{Bibliography} %            ~~~~~~~~~~~~  %  % \theindex: \def\indexname{Index}  %              ~~~~~ %  % figure environment:  \def\figurename{Figure}  %               ~~~~~~ %  % table environment: \def\tablename{Table}  %              ~~~~~ %  % \chapter:  \def\chaptername{Chapter}  %                ~~~~~~~ % \appendix: \def\appendixname{Appendix}  %                 ~~~~~~~~ % \part  \def\partname{Part}  %             ~~~~ % abstract environment:  \def\abstractname{Abstract}  %                 ~~~~~~~~ %  % acknowledge environment:& \def\acknowledgename{Acknowledgements}% %                    ~~~~~~~~~~~~~~~~   - %    **************************************** - %    *             FRONT MATTER             * - %    ****************************************  %    % DECLARATIONS % ; % These macros are used to declare arguments needed for the % % construction of the front matter.     2 % The year the degree will be officially conferred( \def\degreeyear#1{\gdef\@degreeyear{#1}}  - % The full (unabbreviated) name of the degree   \def\degree#1{\gdef\@degree{#1}}  ; % All previous degrees: one per line in chronological order * \def\prevdegrees#1{\gdef\@prevdegrees{#1}}  $ % The name of your committee's chair \def\chair#1{\gdef\@chair{#1}}  8 % The names of your other committe members, one per line, \def\othermembers#1{\gdef\@othermembers{#1}}  9 % The number of committee members, which affects both the 7 % number of lines and the amount of space between lines  % on the approval page.  \def\@numberofmembers{3} \def\@approvalspace{.75in}1 \def\numberofmembers#1{\gdef\@numberofmembers{#1}  \ifnum \@numberofmembers > 3 \gdef\@approvalspace{.5in} \fi}  E % The name of your degree's field (e.g. Psychology, Computer Science)  \def\field#1{\gdef\@field{#1}}  E % You have to define the campus name twice because I can't figure out C % how to get the TeX \uppercase macro to work for me (EVM, 9/21/94)   E % The name of your UC Campus CAPITALIZED (e.g. Berkeley, Los Angeles)   \def\campus#1{\gdef\@campus{#1}}  $ % \alwayssingle and \endalwayssingle % E % These macros define an environment for front matter that is always  1 % single column even in a double-column document.   J \def\alwayssingle{\@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn      \else \newpage \fi}  A \def\endalwayssingle{\if@restonecol\twocolumn \else \newpage \fi}   A % \maketitle outputs the complete titlepage.  It requires all the B % above macros except \campuscap.  It is probably not correct for ! % joint (e.g. UCSD/SDSU) degrees.   = % Set the font that will be used in the front matter headings . \def\fmfont{\fontsize\@xiipt{14.5}\selectfont}3 \def\fmsmallfont{\fontsize\@xiipt{14pt}\selectfont}    \def\maketitle{  {\ssp  \begin{alwayssingle}     \let\footnotesize\small      \let\footnoterule\relax      \thispagestyle{empty}      \setcounter{page}{1}       \null\vfil   \begin{center}     \fmfont      {\bfseries {\@title} \par}     \bigskip \medskip      by \par      \bigskip \medskip      {\@author} \par  \vspace{6ex}     {\@prevdegrees} \par \vspace{6ex}@     A dissertation submitted in partial satisfaction of the \par
 \smallskip'     requirements for the degree of \par 
 \smallskip     {\@degree} \par      \bigskip \medskip      in \par      \bigskip \medskip      {\@field}\par      \bigskip \medskip      in the \par      \bigskip \medskip      GRADUATE DIVISION \par
 \smallskip     of the \par 
 \smallskipN     UNIVERSITY of CALIFORNIA at {\expandafter\uppercase\expandafter{\@campus}}   \end{center} {  \vspace{6ex} \fmsmallfont   Committee in charge:
 \begin{quote}  {\@chair}, Chair\newline {\@othermembers} \end{quote}    \begin{center}     {\@degreeyear}   \end{center} }      \vfil\null \end{alwayssingle}   \setcounter{footnote}{0} }}   % APPROVALPAGE % E % The \approvalpage macro emits a UC-approved approval page ready for B % your committee's signature.  It is not an automatic part of the E % output because there's really no point in printing it until you are C % ready to get signatures.  It requires the the \year, \author, and C % \campus macros have been defined.  It uses lots of tricky spacing D % that is probably better handled with tabular environment code, but( % I'm too lazy to fix it. (EVM, 9/19/94)   \def\approvalpage{ \begin{alwayssingle} \thispagestyle{empty}  \null\vfill  \begin{center}6 \fmfont The dissertation of {\@author} is approved: \\ \vspace{.25in} \vspace{\@approvalspace}7 $\:\overline{~~~~ \mbox{\rule{0in}{0.16in}\small Chair%  \hspace{3.15in} Date }}\:$ \\  \vspace{\@approvalspace}N $\:\overline{~~~~ \mbox{\rule{0in}{0.16in}\small ~\hspace{3.5in} Date }}\:$ \\ \vspace{\@approvalspace}N $\:\overline{~~~~ \mbox{\rule{0in}{0.16in}\small ~\hspace{3.5in} Date }}\:$ \\ \vspace{\@approvalspace} \ifnum \@numberofmembers > 3N $\:\overline{~~~~ \mbox{\rule{0in}{0.16in}\small ~\hspace{3.5in} Date }}\:$ \\ \vspace{\@approvalspace} \fi  \ifnum \@numberofmembers > 4N $\:\overline{~~~~ \mbox{\rule{0in}{0.16in}\small ~\hspace{3.5in} Date }}\:$ \\ \vspace{\@approvalspace} \fi  \ifnum \@numberofmembers > 5N $\:\overline{~~~~ \mbox{\rule{0in}{0.16in}\small ~\hspace{3.5in} Date }}\:$ \\ \vspace{\@approvalspace} \fi 3 {\fmfont University of California at {\@campus}} \\  \vspace{-.25in}  \vspace{\@approvalspace} {\fmfont \@degreeyear} \end{center} \vfill\null  \end{alwayssingle} }    % COPYRIGHTPAGE  % F % While it's technically optional, you probably want a copyright page.B % This is a macro, not an environment, because it can be generated- % with the \title, \author, and \year macros.    \def\copyrightpage{  \begin{alwayssingle} \thispagestyle{empty}  \begin{center} {\fmfont {\bfseries\@title}\par \vspace{1in} Copyright \@degreeyear\par by\par	 \@author}  \end{center} \end{alwayssingle}}   
 % ABSTRACT % A % The ABSTRACT environment allows for multi-page abstracts which, C % in accordance with UC rules, is numbered separately from the rest D % of the rest of the dissertation in Arabic.  It requires definitionF % of the \title, \author, \degree, \field, \campus, and \chair macros.     \def\abstract{ \begin{alwayssingle} \pagestyle{plain}  \thispagestyle{plain}  \setcounter{page}{1} \begin{center} {\fmfont {\bfseries \abstractname}\par 
 \vspace{.5in}  \@title\par 
 \vspace{.1in}  by\par
 \vspace{.1in}  \@author\par {\@degree} in \@field\par 
 \vspace{.1in} * University of California at {\@campus}\par
 \vspace{.1in}  {\@chair}, Chair} 
 \vspace{.1in} 
 \end{center}}   1 \def\endabstract{\par\vfil\null\end{alwayssingle}  }     \def\abstractsignature{  \hspace*{\fill}  \begin{minipage}[t]{3.25in} - \addtolength{\baselineskip}{-.5\baselineskip}  \vspace{1.7cm} \rule{3.2in}{.5pt}\\	 \@chair\\  Dissertation Committee Chair \end{minipage}}    % DEDICATION % D % The dedication environment just makes sure the dedication gets its % own page.    \newenvironment{dedication}  {\begin{alwayssingle}} {\end{alwayssingle}}   % ACKNOWLEDGEMENTS % @ % The acknowledgements environment puts a large, bold, centered 2 % "Acknowledgements" label at the top of the page.  ! \newenvironment{acknowledgements}  {\begin{alwayssingle}  \begin{center}# {\large \bfseries \acknowledgename}  \end{center} }  {\end{alwayssingle}}   % FRONTMATTER environment  % C % The FRONTMATTER environment makes sure that page numbering is set C % correctly (roman, lower-case, starting at 3) for the front matter ? % that follows the abstract.  It also resets page-numbering for < % the remainder of the dissertation (arabic, starting at 1).   \newenvironment{frontmatter}; {\setcounter{page}{3}\renewcommand{\thepage}{\roman{page}}} D {\newpage\renewcommand{\thepage}{\arabic{page}}\setcounter{page}{1}}    - %    **************************************** - %    *                LISTS                 * - %    ****************************************  %    % ENUMERATE A %  Enumeration is done with four counters: enumi, enumii, enumiii B %  and enumiv, where enumN controls the numbering of the Nth levelC %  enumeration.  The label is generated by the commands \labelenumi=D %  ... \labelenumiv.  The expansion of \p@enumN\theenumN defines the %  output of a \ref command. % ? % 16 Mar 88 -- changed defs of \labelenum... to use \theenum...d   \def\labelenumi{\theenumi.}% \def\theenumi{\arabic{enumi}}o   \def\labelenumii{(\theenumii)} \def\theenumii{\alph{enumii}}  \def\p@enumii{\theenumi}   \def\labelenumiii{\theenumiii.}   \def\theenumiii{\roman{enumiii}}% \def\p@enumiii{\theenumi(\theenumii)}r   \def\labelenumiv{\theenumiv.}e \def\theenumiv{\Alph{enumiv}} $ \def\p@enumiv{\p@enumiii\theenumiii}  	 % ITEMIZEuH % Itemization is controlled by four commands: \labelitemi, \labelitemii,A % \labelitemiii, and \labelitemiv, which define the labels of the  % various itemization levels.e   \def\labelitemi{$\m@th\bullet$}  \def\labelitemii{\bfseries --} \def\labelitemiii{$\m@th\ast$} \def\labelitemiv{$\m@th\cdot$}     % VERSET@ %   The verse environment is defined by making clever use of theD %   list environment's parameters.  The user types \\ to end a line.7 %   This is implemented by \let'in \\ equal \@centercr.	 %   \def\verse{\par\let\\=\@centercrF   \list{}{\ssp\itemsep\z@ \itemindent -1.5em\listparindent \itemindentC           \rightmargin\leftmargin\advance\leftmargin 1.5em}\item[]}m \let\endverse\endlist    % QUOTATION	 %   Fills linesl %   Indents paragraphr %n3 \def\quotation{\par\list{}{\ssp\listparindent 1.5emd     \itemindent\listparindent 7     \rightmargin\leftmargin\parsep \z@ plus\p@}\item[]}. \let\endquotation=\endlist  = % QUOTE -- same as quotation except no paragraph indentation,a %e; \def\quote{\par\list{}{\ssp\rightmargin\leftmargin}\item[]}  \let\endquote=\endlist  
 % DESCRIPTIONs %p; %  To change the formatting of the label, you must redefineo %  \descriptionlabel.   6 \def\descriptionlabel#1{\hspace\labelsep \bfseries #1}? \def\description{\list{}{\labelwidth\z@ \itemindent-\leftmargin (        \let\makelabel\descriptionlabel}}   \let\enddescription\endlisto   \newdimen\descriptionmarginm \descriptionmargin=3em    - %    ****************************************e- %    *         OTHER ENVIRONMENTS           * - %    ****************************************  %  %%
 % VERBATIM %28 % standard verbatim mode driver macro is modified to useA % single-spacing.  There appears to be a small problem with extra%> % vertical space (1 or 2 points worth) after this environment.@ % Probably, this results from returning to double-spacing beforeD % issuing a \parskip, but I'm not enough of TeX hacker to figure out+ % the source of the problem. (EVM, 9/25/94) ) % 94/11/03 BBF converted \tt to \ttfamily   F \def\@verbatim{\trivlist\ssp \item[]\if@minipage\else\vskip\parskip\fi' \leftskip\@totalleftmargin\rightskip\z@e/ \parindent\z@\parfillskip\@flushglue\parskip\z@oB %%RmS 91/08/26 Added \@@par to clear possible \parshape definition2 %%from a surrounding list (the verbatim guru says) \@@par@ \@tempswafalse \def\par{\if@tempswa\hbox{}\fi\@tempswatrue\@@par \penalty\interlinepenalty}%gK \obeylines \ttfamily \catcode``=13 \@noligs \let\do\@makeother \dospecials}    % ARRAY AND TABULARt %r  A \arraycolsep 5pt     % Half the space between columns in an arrayi#                      % environment.nB \tabcolsep 6pt       % Half the space between columns in a tabular#                      % environment.eG \arrayrulewidth .4pt % Width of rules in array and tabular environment.iG \doublerulesep 2pt   % Space between adjacent rules in array or tabulari#                      % environment.   C % We have to redefine array here in order to make it single-spaced.c) % (Not sure if this is really necessary.) : \def\array{\let\@acol\@arrayacol \let\@classz\@arrayclasszL  \let\@classiv\@arrayclassiv \let\\\@arraycr\let\@halignto\@empty\@tabarray}  	 % TABBING	 % 7 \tabbingsep \labelsep   % Space used by the \' command.a.                         %  (See LaTeX manual.)  E % We have to redefine tabular here in order to make it single-spaced. 4 \def\tabular{\par\ssp\let\@halignto\@empty\@tabular}/ \expandafter \def\csname tabular*\endcsname #1%r' {\par\ssp\def\@halignto{to#1}\@tabular}9  A % \smalltabular and \smalltabular* are alternative tabular styles*J % in the \small font.  They are required because single-spacing implies a & % change of font to a particular size. % EVM, 7/20/93  > \def\smalltabular{\par\smallssp\let\@halignto\@empty\@tabular}! \def\endsmalltabular{\endtabular} 4 \expandafter \def\csname smalltabular*\endcsname #1%, {\par\smallssp\def\@halignto{to#1}\@tabular}B \expandafter \let \csname endsmalltabular*\endcsname = \endtabular  I % \scriptsizetabular and \scriptsizetabular* are analogs of \smalltabulariH \def\scriptsizetabular{\par\scriptsizessp\let\@halignto\@empty\@tabular}& \def\endscriptsizetabular{\endtabular}9 \expandafter \def\csname scriptsizetabular*\endcsname #1%r1 {\par\scriptsizessp\def\@halignto{to#1}\@tabular}eG \expandafter \let \csname endscriptsizetabular*\endcsname = \endtabular   
 % MINIPAGEF %  \@minipagerestore is called upon entry to a minipage environment toE %  set up things that are to be handled differently inside a minipageT7 %  environment. In the current styles, it does nothing.s %fC % \skip\@mpfootins : plays same role for footnotes in a minipage as{> %                    \skip\footins does for ordinary footnotes    \skip\@mpfootins = \skip\footins  
 % FRAMEBOX % @ \fboxsep = 3pt    % Space left between box and text by \fbox and                   % \framebox.F \fboxrule = .4pt  % Width of rules in box made by \fbox and \framebox.    - %    ****************************************n- %    *        CHAPTERS AND SECTIONS         *n- %    ****************************************i %e % DEFINE COUNTERS: %sH % \newcounter{NEWCTR}[OLDCTR] : Defines NEWCTR to be a counter, which isD %                               reset to zero when counter OLDCTR is( %                               stepped.G %                               Counter OLDCTR must already be defined.u  @ % Must redefine @startsection so that we always get indentation.< \def\@startsection#1#2#3#4#5#6{\if@noskipsec \leavevmode \fi    \par \@tempskipa #4\relax    \@afterindenttrue=    \ifdim \@tempskipa <\z@ \@tempskipa -\@tempskipa \relax\fid    \if@nobreak \everypar{}\elsepA      \addpenalty{\@secpenalty}\addvspace{\@tempskipa}\fi \@ifstarpI      {\@ssect{#3}{#4}{#5}{#6}}{\@dblarg{\@sect{#1}{#2}{#3}{#4}{#5}{#6}}}}p   \newcounter {part} \newcounter {chapter}  \newcounter {section}[chapter]! \newcounter {subsection}[section]v' \newcounter {subsubsection}[subsection] & \newcounter {paragraph}[subsubsection]% \newcounter {subparagraph}[paragraph]l  B % For any counter CTR, \theCTR is a macro that defines the printedB % version of counter CTR.  It is defined in terms of the following	 % macros:  %sH %  \arabic{COUNTER} : The value of COUNTER printed as an arabic numeral.G %  \roman{COUNTER}  : Its value printed as a lower-case roman numberal.sH %  \Roman{COUNTER}  : Its value printed as an upper-case roman numberal.F %  \alph{COUNTER}   : Value of COUNTER printed as a lower-case letter:, %                         1 = a, 2 = b, etc.G %  \Alph{COUNTER}   : Value of COUNTER printed as an upper-case letter:n. %                           1 = A, 2 = B, etc. %   $ \def\thepart          {\Roman{part}}( \def\thechapter       {\arabic{chapter}}4 \def\thesection       {\thechapter.\arabic{section}}7 \def\thesubsection    {\thesection.\arabic{subsection}} > \def\thesubsubsection {\thesubsection .\arabic{subsubsection}}< \def\theparagraph     {\thesubsubsection.\arabic{paragraph}}; \def\thesubparagraph  {\theparagraph.\arabic{subparagraph}}   E % \@chapapp is initially defined to be '\chaptername'.  The \appendix,- % command redefines it to be '\appendixname'.t %  \def\@chapapp{\chaptername}c  8 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%8 %                        PART                          %8 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  / \def\part{\cleardoublepage   % Starts new page. A    \thispagestyle{plain}%    % Page style of part page is 'plain'b2   \if@twocolumn              % IF two-column style/      \onecolumn              %  THEN \onecolumnb5      \@tempswatrue           %       @tempswa := true:6     \else \@tempswafalse     %  ELSE @tempswa := false!   \fi                        % FI{;   \hbox{}\vfil               % Add fil glue to center titledC %%  \bgroup  \centering      % BEGIN centering %% Removed 19 Jan 88a   \secdef\@part\@spart}   G \def\@part[#1]#2{\ifnum \c@secnumdepth >-2\relax  % IF secnumdepth > -2 ?         \refstepcounter{part}%                    %   THEN step~H                                                   %         part counterG         \addcontentsline{toc}{part}{\thepart      %        add toc lined>         \hspace{1em}#1}\else                      %   ELSE addH                                                   %         unnumb. line6         \addcontentsline{toc}{part}{#1}\fi        % FI    \markboth{}{}%O9    {\centering                       % %% added 19 Jan 88 ;     \interlinepenalty \@M            %% RmS added 11 Nov 91r:     \ifnum \c@secnumdepth >-2\relax  % IF secnumdepth > -2I       \huge\bfseries \partname~\thepart    %   THEN Print '\partname' anddD     \par                             %         number in \huge bold.E     \vskip 20\p@\fi                  %        Add space before title. /     \Huge \bfseries                        % FI1A     #2\par}\@endpart}                % Print Title in \Huge bold.nB                                      % Bug Fix 13 Nov 89: #1 -> #2    " % \@endpart finishes the part page %t8 \def\@endpart{\vfil\newpage   % End page with 1fil glue.3    \if@twoside                % IF twoside printingrA        \hbox{}%               %   THEN Produce totally blank pageb        \thispagestyle{empty}%e        \newpageg"    \fi                        % FI2    \if@tempswa                % IF @tempswa = true1      \twocolumn               %   THEN \twocolumn "    \fi}                       % FI  3 \def\@spart#1{{\centering      % %% added 19 Jan 88X5    \interlinepenalty \@M       %% RmS added 11 Nov 91hD    \Huge \bfseries                   % Print title in \Huge boldface    #1\par}\@endpart}          - %    ****************************************h- %    *         TABLE OF CONTENTS, ETC.      *e- %    ****************************************o %e  % A \subsection command writes a. %       \contentsline{subsection}{TITLE}{PAGE}D % command on the .toc file, where TITLE contains the contents of theH % entry and PAGE is the page number.  If subsections are being numbered,  % then TITLE will be of the form! %       \numberline{NUM}{HEADING}pG % where NUM is the number produced by \thesubsection.  Other sectioning  % commands work similarly. %d5 % A \caption command in a 'figure' environment writesx; %    \contentsline{figure}{\numberline{NUM}{CAPTION}}{PAGE}tF % on the .lof file, where NUM is the number produced by \thefigure andB % CAPTION is the figure caption.  It works similarly for a 'table' % environment. %sE % The command \contentsline{NAME} expands to \l@NAME.  So, to specify ? % the table of contents, we must define \l@chapter, \l@section, E % \l@subsection, ... ; to specify the list of figures, we must definee> % \l@figure; and so on.  Most of these can be defined with the2 % \@dottedtocline command, which works as follows. %m7 % \@dottedtocline{LEVEL}{INDENT}{NUMWIDTH}{TITLE}{PAGE}\B %    LEVEL    : An entry is produced only if LEVEL < or = value ofH %               'tocdepth' counter.  Note, \chapter is level 0, \section  %               is level 1, etc.G %    INDENT   : The indentation from the outer left margin of the startN% %               of the contents line.eH %    NUMWIDTH : The width of a box in which the section number is to go,8 %               if TITLE includes a \numberline command. %rA % This command uses the following three parameters, which are setdF % with a \def (so em's can be used to make them depend upon the font).E %   \@pnumwidth : The width of a box in which the page number is put.pB %   \@tocrmarg  : The right margin for multiple line entries.  One5 %                 wants \@tocrmarg > or = \@pnumwidthsB %   \@dotsep    : Separation between dots, in mu units.  Should be2 %                 \def'd to a number like 2 or 1.7   \def\@pnumwidth{1.55em}f \def\@tocrmarg {2.55em}i \def\@dotsep{4.5}t \setcounter{tocdepth}{2}     % TABLEOFCONTENTSeG %  In ucthesis style, \tableofcontents, \listoffigures, etc. are alwaysg+ %  set in single-column style.  @restonecoly  & \def\tableofcontents{\@restonecolfalse,   \if@twocolumn\@restonecoltrue\onecolumn\fi   \chapter*{\contentsname@H         \@mkboth{\uppercase{\contentsname}}{\uppercase{\contentsname}}}%3   {\ssp\@starttoc{toc}}\if@restonecol\twocolumn\fi}c  , \def\l@part#1#2{\addpenalty{-\@highpenalty}%4    \addvspace{2.25em plus\p@}% space above part line    \begingroupE    \@tempdima 3em         % width of box holding part number, used by E      \parindent \z@ \rightskip \@pnumwidth             %% \numberline~      \parfillskip -\@pnumwidth=      {\large \bfseries          % set line in \large boldface A      \leavevmode          % TeX command to enter horizontal mode.1.      #1\hfil \hbox to\@pnumwidth{\hss #2}}\par8      \nobreak             % Never break after part entryE     \global\@nobreaktrue                        %% Added 24 May 89 as:>     \everypar{\global\@nobreakfalse\everypar{}}%% suggested by@                                                %% Jerry Leichter
    \endgroup}\  : %% First line of l@chapter changed 24 May 89, as suggested %% by Jerry Leichter.  %%/ \def\l@chapter#1#2{\addpenalty{-\@highpenalty}%a4    \vskip 1.0em plus\p@   % space above chapter line?    \@tempdima 1.5em       % width of box holding chapter numbern    \begingroup*      \parindent \z@ \rightskip \@pnumwidth      \parfillskip -\@pnumwidth+      \bfseries                  % Boldface. A      \leavevmode          % TeX command to enter horizontal mode.cB       \advance\leftskip\@tempdima  %% added 5 Feb 88 to conform toE       \hskip -\leftskip            %% 25 Jan 88 change to \numberline =      #1\nobreak\hfil \nobreak\hbox to\@pnumwidth{\hss #2}\partG      \penalty\@highpenalty %% added 24 May 89, suggested by J. Leichterh
    \endgroup}i  0 \def\l@section{\@dottedtocline{1}{1.5em}{2.3em}}3 \def\l@subsection{\@dottedtocline{2}{3.8em}{3.2em}}s6 \def\l@subsubsection{\@dottedtocline{3}{7.0em}{4.1em}}/ \def\l@paragraph{\@dottedtocline{4}{10em}{5em}}n2 \def\l@subparagraph{\@dottedtocline{5}{12em}{6em}}   % LIST OF FIGURES\ %g@ % Single-space list of figures, add it to the table of contents.$ \def\listoffigures{\@restonecolfalse,   \if@twocolumn\@restonecoltrue\onecolumn\fiA   \chapter*{\listfigurename\@mkboth{\uppercase{\listfigurename}}%a {\uppercase{\listfigurename}}}2    \addcontentsline{toc}{chapter}{\listfigurename}&    {\ssp\@starttoc{lof}}\if@restonecol     \twocolumn\fi}  / \def\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}    % LIST OF TABLES %E# \def\listoftables{\@restonecolfalsen,   \if@twocolumn\@restonecoltrue\onecolumn\fi?   \chapter*{\listtablename\@mkboth{\uppercase{\listtablename}}%e=    {\uppercase{\listtablename}}}\@starttoc{lot}\if@restonecolw   \twocolumn\fi}# \def\listoftables{\@restonecolfalse ,   \if@twocolumn\@restonecoltrue\onecolumn\fi?   \chapter*{\listtablename\@mkboth{\uppercase{\listtablename}}%  {\uppercase{\listtablename}}}e1    \addcontentsline{toc}{chapter}{\listtablename}s&    {\ssp\@starttoc{lot}}\if@restonecol   \twocolumn\fi}     \let\l@table\l@figuret      - %    ****************************************-- %    *             BIBLIOGRAPHY             *h- %    ****************************************u %rB % The thebibliography environment executes the following commands: % 8 %  \def\newblock{\hskip .11em plus .33em minus .07em} --D %      Defines the `closed' format, where the blocks (major units of- %      information) of an entry run together.* %*A %  \sloppy  -- Used because it's rather hard to do line breaks in  %      bibliographies, %* %  \sfcode`\.=1000\relax --*D %      Causes a `.' (period) not toproduce an end-of-sentence space.  3 %% RmS 91/10/27 [ .. ] replaced by \@biblabel{ .. }r1 %% RmS 91/11/13: Changed counter enumi to enumiv, 7 %%               as it says in the comment in latex.tex.F %% RmS 92/01/14: Set \p@enumiv to {} and \theenumiv to \arabic{enumiv}* %%               to get correct references1 \def\thebibliography#1{\chapter*{\bibname\@mkboth /   {\uppercase{\bibname}}{\uppercase{\bibname}}}i*   \addcontentsline{toc}{chapter}{\bibname}L   \list{\@biblabel{\arabic{enumiv}}}{\settowidth\labelwidth{\@biblabel{#1}}%     \leftmargin\labelwidth      \advance\leftmargin\labelsep     \usecounter{enumiv}%     \let\p@enumiv\@empty%     \def\theenumiv{\arabic{enumiv}}}%}5     \def\newblock{\hskip .11em plus.33em minus.07em}% ,     \sloppy\clubpenalty4000\widowpenalty4000     \sfcode`\.=\@m}e    : %% 91/08/26 FMI & RmS: introduced warning instead of error   \def\endthebibliography{%oB   \def\@noitemerr{\@warning{Empty `thebibliography' environment}}%   \endlist}d    H % \def\@biblabel#1{[#1]\hfill}  % Produces the label for a \bibitem[...]*                                 % command.B % \def\@cite#1{[#1]}            % Produces the output of the \cite*                                 % command.      - %    ****************************************a- %    *              THE INDEX               *i- %    ****************************************  %  % THE THEINDEX ENVIRONMENTF % Produces double column format, with each paragraph a separate entry.? % The user commands \item, \subitem and \subsubitem are used toaC % produce the entries, and \indexspace adds an extra vertical space F % that's the right size to put above the first entry with a new letter % of the alphabet.   \newif\if@restonecol  ? \def\theindex{\@restonecoltrue\if@twocolumn\@restonecolfalse\fii \columnseprule \z@; \columnsep 35\p@\twocolumn[\@makeschapterhead{\indexname}]%T=     \@mkboth{\uppercase{\indexname}}{\uppercase{\indexname}}%e&     \thispagestyle{plain}\parindent\z@3     \parskip\z@ plus .3\p@\relax\let\item\@idxitem}\  $ \def\@idxitem{\par\hangindent 40\p@}  3 \def\subitem{\par\hangindent 40\p@ \hspace*{20\p@}}t  6 \def\subsubitem{\par\hangindent 40\p@ \hspace*{30\p@}}  < \def\endtheindex{\if@restonecol\onecolumn\else\clearpage\fi}  ; \def\indexspace{\par \vskip 10\p@ plus5\p@ minus3\p@\relax}     - %    **************************************** - %    *             FOOTNOTES                * - %    ****************************************e %aD % \footnoterule is a macro to draw the rule separating the footnotesC % from the text.  It should take zero vertical space, so it needs auG % negative skip to compensate for any positive space taken by the rule.o % (See PLAIN.TEX.)   \def\footnoterule{\kern-3\p@   \hrule width .4\columnwidth3H   \kern 2.6\p@}                 % The \hrule has default height of .4pt.   % \newcounter{footnote}iD \@addtoreset{footnote}{chapter}  % Numbers footnotes within chapters   %   \@makefntext{NOTE} :H %        Must produce the actual footnote, using \@thefnmark as the markA %        of the footnote and NOTE as the text.  It is called wheneG %        effectively inside a \parbox of width \columnwidth (i.e., witha  %        \hsize = \columnwidth). %`G %        The following macro indents all lines of the footnote by 10pt,rB %        and indents the first line of a new paragraph by 1em.  ToG %        change these dimensions, just substitute the desired value for B %        '10pt' [in both places] or '1em'.  The mark is flushright %        against the footnote.C %          \long\def\@makefntext#1{\@setpar{\@@par\@tempdima \hsize%H %             \advance\@tempdima-10pt\parshape \@ne 10pt \@tempdima}\par% %             \parindent 1em\noindent 8 %             \hbox to \z@{\hss$\m@th^{\@thefnmark}$}#1} %f? %        A simpler macro is used, in which the footnote text iseH %        set like an ordinary text paragraph, with no indentation exceptD %        on the first line of a paragraph, and the first line of theA %        footnote.  Thus, all the macro must do is set \parindentaG %        to the appropriate value for succeeding paragraphs and put then( %        proper indentation before mark.  / \long\def\@makefntext#1{\parindent 1em\noindentt8             \hbox to 1.8em{\hss$\m@th^{\@thefnmark}$}#1}  B % \@makefnmark : A macro to generate the footnote marker that goes  %    in the text.  Default used. %r     % Single-space footnotes.nF \long\def\@footnotetext#1{\insert\footins{\ssp\reset@font\footnotesize.     \interlinepenalty\interfootnotelinepenalty     \splittopskip\footnotesepb5     \splitmaxdepth \dp\strutbox \floatingpenalty \@MMa&     \hsize\columnwidth \@parboxrestoreK    \edef\@currentlabel{\csname p@footnote\endcsname\@thefnmark}\@makefntext=*     {\rule{\z@}{\footnotesep}\ignorespaces       #1\strut}}}e  a- %    ****************************************\- %    *         FIGURES AND TABLES           *}- %    ****************************************n %tE % Float placement parameters.  See LaTeX manual for their definition.e %h \setcounter{topnumber}{2}e \def\topfraction{.7} \setcounter{bottomnumber}{1} \def\bottomfraction{.3}I \setcounter{totalnumber}{3}i \def\textfraction{.2}a \def\floatpagefraction{.5} \setcounter{dbltopnumber}{2} \def\dbltopfraction{.7}e \def\dblfloatpagefraction{.5}n  H % \@makecaption{NUMBER}{TEXT} : Macro to make a figure or table caption.: %      NUMBER : Figure or table number--e.g., 'Figure 3.2'! %      TEXT   : The caption text.n? %  Macro should be called inside a \parbox of right width, withs %  \normalsize.c7 % changed 25 Jun 86 to fix according to Howard Trickey: 3 % instead of \unhbox\@tempboxa\par we do #1: #2\par   B % 15 Nov 93: further changes to support captions BEFORE the figureE % or table.  Changes suggested by Donald Arseneau, installed by Ethan*  % Munson.  Detailed reasons are:< %	The \unhbox allows \vadjust material (\vspace) to get out;B %	the \vbox to\topskip{} is for captions at the top of top-floats;7 %	the \ifdim is for captions above the figure or table; , %	the strut is for tables below the caption.  ? \long\def\@makecaption#1#2{% Add space only if something is ...tG    \par\ifdim\prevdepth>-\p@ \vskip 10\p@\relax \fi % above the captioncB    \setbox\@tempboxa\hbox{\vbox to\topskip{}#1: #2\unskip\strut}% ?    \ifdim \wd\@tempboxa >\hsize      % IF longer than one line:sH        {\ssp#1: #2\unskip\strut\par} %   THEN set as ordinary paragraph.6      \else                           %   ELSE  center.3        \hbox to\hsize{\hfil\unhbox\@tempboxa\hfil}%#    \fi}}  D % To define a float of type TYPE (e.g., TYPE = figure), the document" % style must define the following. %tC %  \fps@TYPE   : The default placement specifier for floats of type  %                TYPE. % C % \ftype@TYPE : The type number for floats of type TYPE.  Each TYPECD %                has associated a unique positive TYPE NUMBER, whichB %                is a power of two.  E.g., figures might have typeE %                number 1, tables type number 2, programs type numberO %                4, etc. %sA % \ext@TYPE : The file extension indicating the file on which thenB %                contents list for float type TYPE is stored.  For. %                example, \ext@figure = 'lof'. % E %  \fnum@TYPE  : A macro to generate the figure number for a caption.T> %                For example, \fnum@TYPE == Figure \thefigure. % C %  The actual float-making environment commands--e.g., the commandseE %  \figure and \endfigure--are defined in terms of the macros \@floatr- %  and \end@float, which are described below.i %\E % \@float{TYPE}[PLACEMENT] : Macro to begin a float environment for abF %     single-column float of type TYPE with PLACEMENT as the placement> %     specifier.  The default value of PLACEMENT is defined by@ %     \fps@TYPE.  The environment is ended by \end@float.  E.g.,; %     \figure == \@float{figure}, \endfigure == \end@float.      % FIGURE   \newcounter{figure}[chapter]- \def\thefigure{\thechapter.\@arabic\c@figure}    \def\fps@figure{tbp} \def\ftype@figure{1} \def\ext@figure{lof}( \def\fnum@figure{\figurename~\thefigure} \def\figure{\@float{figure}} \let\endfigure\end@float& \@namedef{figure*}{\@dblfloat{figure}}$ \@namedef{endfigure*}{\end@dblfloat}   % TABLE  %  \newcounter{table}[chapter]\+ \def\thetable{\thechapter.\@arabic\c@table}    \def\fps@table{tbp}  \def\ftype@table{2}= \def\ext@table{lot}e% \def\fnum@table{\tablename~\thetable}e \def\table{\@float{table}} \let\endtable\end@float $ \@namedef{table*}{\@dblfloat{table}}# \@namedef{endtable*}{\end@dblfloat}%    - %    ****************************************p- %    *            PAGE STYLES               *u- %    ****************************************  %rH % The page style 'foo' is defined by defining the command \ps@foo.  ThisG % command should make only local definitions.  There should be no straynE % spaces in the definition, since they could lead to mysterious extra{ % spaces in the output.  % > % The \ps@... command defines the macros \@oddhead, \@oddfoot,< % \@evenhead, and \@evenfoot to define the running heads andD % feet---e.g., \@oddhead is the macro to produce the contents of theF % heading box for odd-numbered pages.  It is called inside an \hbox of % width \textwidth.  % H % To make headings determined by the sectioning commands, the page style> % defines the commands \chaptermark, \sectionmark, ... , whereD % \chaptermark{TEXT} is called by \chapter to set a mark, and so on.D % The \...mark commands and the \...head macros are defined with theE % help of the following macros.  (All the \...mark commands should be  % initialized to no-ops.)  %g % MARKING CONVENTIONS:D % LaTeX extends TeX's \mark facility by producing two kinds of marks< % a 'left' and a 'right' mark, using the following commands:/ %     \markboth{LEFT}{RIGHT} : Adds both marks. 3 %     \markright{RIGHT}      : Adds a 'right' mark. B %     \leftmark  : Used in the \@oddhead, \@oddfoot, \@evenhead orB %                  \@evenfoot macro, gets the current 'left' mark.5 %                  Works like TeX's \botmark command.lB %     \rightmark : Used in the \@oddhead, \@oddfoot, \@evenhead orC %                  \@evenfoot macro, gets the current 'right' mark.n7 %                  Works like TeX's \firstmark command.eE % The marking commands work reasonably well for right marks 'numbered}B % within' left marks--e.g., the left mark is changed by a \chapterH % command and the right mark is changed by a \section command.  However,H % it does produce somewhat anomalous results if two \bothmark's occur on % the same page. %{ %LB % Commands like \tableofcontents that should set the marks in someD % page styles use a \@mkboth command, which is \let by the pagestyle< % command (\ps@...)  to \markboth for setting the heading or % \@gobbletwo to do nothing.  ' \mark{{}{}}   % Initializes TeX's marksi    % \ps@empty defined in LATEX.TEX  % % Definition of 'headings' page styleiC %  Note the use of ##1 for parameter of \def\chaptermark inside thei %  \def\ps@headings. % F % 91/03/26 FMi: Added extra set of braces arround |\sl| in |\@oddhead|@ % to support NFSS (|\sl| is a shape |\rm| a family). Also remove! % unnecessary |\hbox{}| commands.  %nH % 94/11/3 BBF: Eliminated two letter font selection commands \rm and \sl% % in favor of \rmfamily and \slshape.i %   , \if@twoside         % If two-sided printing.& \def\ps@headings{\let\@mkboth\markboth0  \def\@oddfoot{}\def\@evenfoot{}%       No feet.M  \def\@evenhead{\rmfamily \thepage\hfil \slshape \leftmark}%    Left heading.}L  \def\@oddhead{{\slshape \rightmark}\hfil \rmfamily\thepage}% Right heading.G  \def\chaptermark##1{\markboth {\uppercase{\ifnum \c@secnumdepth >\m@nee-       \@chapapp\ \thechapter. \ \fi ##1}}{}}%lF  \def\sectionmark##1{\markright {\uppercase{\ifnum \c@secnumdepth >\z@    \thesection. \ \fi ##1}}}}t, \else               % If one-sided printing.& \def\ps@headings{\let\@mkboth\markboth- \def\@oddfoot{}\def\@evenfoot{}%     No feet.mE \def\@oddhead{{\slshape \rightmark}\hfil \rmfamily\thepage}% Heading.sG \def\chaptermark##1{\markright {\uppercase{\ifnum \c@secnumdepth >\m@neu'   \@chapapp\ \thechapter. \ \fi ##1}}}}t \fia  ( % Definition of 'myheadings' page style. %o* \def\ps@myheadings{\let\@mkboth\@gobbletwo<  \def\@oddhead{{\slshape\rightmark}\hfil \rmfamily\thepage}%I  \def\@oddfoot{}\def\@evenhead{\rmfamily \thepage\hfil\slshape\leftmark}%e<  \def\@evenfoot{}\def\chaptermark##1{}\def\sectionmark##1{}%  \def\subsectionmark##1{}}  # % Definition of 'plain' page style.s %o# \def\ps@plain{\let\@mkboth\markbothE, \def\@oddfoot{}\def\@evenfoot{}				% no feet? \def\@oddhead{\hbox{}\hfil\rmfamily\thepage}		% heading (right) @ \def\@evenhead{\rmfamily\thepage\hfil\hbox{}}}		% heading (left)      - %    ****************************************e- %    *            MISCELLANEOUS             *n- %    ****************************************a %o % DATE %r \def\today{\ifcase\month\ord9   January\or February\or March\or April\or May\or June\or.C   July\or August\or September\or October\or November\or December\fie"   \space\number\day, \number\year}  C % EQUATION and EQNARRAY -- put here because it must follow \chapter  % definition %~ % \newcounter{equation}u %dC \@addtoreset{equation}{chapter}   % Makes \chapter reset 'equation' ,                                   % counter.  / \def\theequation{\thechapter.\arabic{equation}}h  B % \jot = 3pt      % Extra space added between lines of an eqnarray                   % environment   B % The macro \@eqnnum defines how equation numbers are to appear in % equations. %} % \def\@eqnnum{(\theequation)} %     - %    ****************************************\- %    *           INITIALIZATION             *d- %    ****************************************  %% % Default initializationsn  0 \ps@plain                   % 'plain' page style1 \pagenumbering{arabic}      % Arabic page numbers ? \if@twoside\else\raggedbottom\fi % Ragged bottom unless twosidei*                                  % option.
 \if@twocolumnw  \@@input twocolum.sty\relax \else ,  \onecolumn                 % Single-column. \fin  	 \endinputr