
 #! /bin/sh  1 #                               -*- Mode: Ksh -*- B # piecharts.sh --- Creation of pie charts in (La)TeX + PostScript,  #                  with PSTricksF # Author          : Denis GIROU (CNRS/CIRCE - France) <girou@circe.fr>, # Created the     : Fri Oct 16 21:53:41 1992F # Last mod. by    : Denis GIROU (CNRS/CIRCE - France) <girou@circe.fr>, # Last mod. the   : Tue Jan 26 21:15:55 1993 # Version         : 2.2  # G # Description     :   piecharts.sh is a simple SHELL and AWK program to K #                   realize hight quality, greatly customizable, grayscaled 8 #                   or colored pie charts in PostScript.J #                     It uses (La)TeX and the splendid PSTricks package ofG #                   Timothy Van Zandt <tvz@princeton.edu>, available in 1 #                   /anonymous@princeton.edu:/pub I #                     It creates the (La)TeX (+ PSTricks) code for direct O #                   insertion in a (La)TeX document of the pie chart generated. N #                   It use a data file which describe the parts and the labels #                   for them. G #                     You always can modify the generated code for more 6 #                   personal and sophisticated result. # N # Syntax          : piecharts.sh [scale_factor] ([PLAIN] | [FIGURE] [BOXIT]) \8 #                                <data_file >output_file0 #                     Default scale factor is 1.I #                     Default mode is LaTeX. In this case, use the FIGURE M #                   option if you want to define the figure LaTeX environment K #                   for the pie chart, and use the BOXIT option if you want - #                   a box around this figure. N #                     Use the PLAIN option if you want to generate a plain TeXL #                   code (in this case, you cannot used the FIGURE and BOXIT #                   options).  # H # Input file      :   The fill styles are: none, solid, vlines, vlines*,< #                   hlines, hlines*, crosshatch, crosshatch*H #                     The predefined colors are : black, darkgray, gray,M #                   lightgray, white, red, green, blue, cyan, magenta, yellow N #                     You can easily define new gray or colors, or access to aF #                   rgb palette with the palette.sty file of PSTricks.F #                     You can also change a lot of parameters. See theE #                   documentation of PSTricks for more customization.  # M # Input file format:  You can add blanks lines and comments (beginning by #). K #                     The default field separator is | You can change it at " #                   the AWK level.H #                     The first non-comment line has 3 fields for titlesM #                   (only the first is required), and after you must have one J #                   line by part of the pie chart, with 5 or 6 fields eachM #                   (percentage, inside label, outside label, filling, color, K #                   explode). The last one is optional and must be "yes" if M #                   you want that this part will be explode in the pie chart. M #                     Obviously, the total of the percentages must be 100, or  #                   less. N #                     You can add (La)TeX commands in the labels (\em, \small,L #                   etc.), and separate lines by \\ in LaTeX and \cr in TeX.J #                   The text attributes cannot act on multiple lines : youM #                   must type {\em Paris}\\{\em France} for example in LaTeX. J #                     Be careful of some (La)TeX special characters (see $+ #                   and % in the examples). K #                     Here are two examples, using a LaTeX syntax (suppress 9 #                   the first 2 characters of each line):  # , # # Data for the first example of pie charts # E # # Title of the figure      | Title for the table of figures | Label  # Example 1 of pie chart # N # # Value | Inside label  | Outside label                 | Type of    | ColorN # #                                                       |  filling   |  fillN #      20 | \small\$9.0M  | {\em Paris}\\{\em France}     | hlines     | blackN #      35 | \small\$16.7M | {\em London}\\Great Britain   | vlines     | blackN #      45 | {\small\$23.1M}\\1991 | {\em Berlin}\\Germany | crosshatch | black #  # - # # Data for the second example of pie charts  # E # # Title of the figure      | Title for the table of figures | Label I # \bf Example 2 of pie chart | Pie Chart 2                    | piechart2  # I # # Value | Inside | Outside label | Type of    | Color of | Explode part < # #       |  label |               |  filling   |  filling |@ #       2 |        |  2\% \\ Last  | solid      | red      | yes6 #      28 |        | 28\%          | solid      | blue7 #       4 |        |  4\%          | solid      | green @ #      47 |        | 47\% \\ First | solid      | magenta  | yes6 #      19 |        | 19\%          | solid      | cyan #  # N # Examples        :   If you name these files piechart1.dat and piechart2.dat,( #                   you can simply type:B #                   piecharts.sh 1.5 <piechart1.dat >piechart1.tmpJ #                   piecharts.sh 0.7 figure boxit <piechart2.dat >pie2.tmpL #                   and just insert the two result files in a LaTeX document) #                   at the right place... N #                     There are no difference if you want to produce plain TeXK #                   code. You only must put valid plain TeX commands in the  #                   data files.  # H # Portability     :   Expected great. Tested on RS6000 under AIX 3.2 and4 #                   DECStation 3100 under Ultrix 4.3 # H # Known problems  :   - Obviously, take care of the labels for the smallI #                   parts. If they are too long or in a too big font, the 0 #                   result will not be pretty...L #                     - You must have the LANG environment variable to En_USH #                   if your UNIX has the National Language Support (NLS)N #                   (by instance, amusing problems arrive with LANG=Fr_FR ...) # M # Thanks          :   Timothy Van Zandt for the great work of PSTricks, tests 5 #                   and ideas for the plain TeX mode.  # ) # History         : (10/16/92) - rev. 1.0 * #                   (10/20/92) - rev. 1.1:M #                      * increase the portability by suppression of the usage ; #                        of the sub builtin function of AWK I #                      * better tracking of blank/null and comments lines * #                   (12/04/92) - rev. 2.0:J #                      * increase the portability by transformation of theH #                        unique AWK program in a SHELL script calling an& #                        AWK program :I #                          - the program is renamed form piecharts.awk to ) #                            piecharts.sh K #                          - input data file now given as parameter, not as + #                            standard input L #                          - the parameters are obtained in the SHELL scriptJ #                          - the options (SCALE, FIGURE and BOXIT) are nowN #                            treated by post-processing the AWK output file byI #                            SED (ugly but it's because some AWK versions F #                            doesn't accept the definition of external* #                            variables...)D #                      * change the unit for the values of the partsE #                        from fractions of 360 degrees to percentages K #                      * definition of the figure environment now optional, 0 #                        using the FIGURE optionM #                      * new possibility to declare some explode parts in the ! #                        piechart E #                      * use of the new \uput PSTricks macro for easy 3 #                        treatment of explode parts L #                      * possibility to have multiple (centered) line labels4 #                        (inside and outside labels)M #                      * better tracking of syntax errors in the command line * #                   (12/11/92) - rev. 2.1:N #                      * generation of the tabular environment for labels only1 #                        if they have multi-lines M #                      * the comment lines which begin with the ## are copied N #                        (without the ##) at the beginning of the result file.K #                        This allow automatic generation of input data file N #                        with a good specification of the colors, by automaticM #                        generation of the \newgray commands. It's to work in G #                        conjonction with the piecharts-data.sh script. C #                      * input data file read on the standard input I #                      * diminution of the width of the minipage to avoid 6 #                        the "overfull \hbox" problemsN #                      * change the test of the sum of percentages from 100 toL #                        100.0001, because it can occurs problem with 100...* #                   (01/26/93) - rev. 2.2:G #                      * suppression of lines longer than 78 characters E #                      * change the obsolete \Polar PSTricks order to % #                        \SpecialCoor M #                      * add the PLAIN option and the possibility to generate ' #                        plain TeX code     " # Interpretation of the parameters if [ $# -gt 3 ] 6    then echo "You cannot give more than 3 parameters."G         echo "Syntax: piecharts.sh [scale factor] ([PLAIN] | [FIGURE] \  [BOXIT]) <data_file  >out_file"          exit fi   SCALE=1  FIGURE="xx" 
 BOXIT="xx" TEX="LATEX"  while [ $# -ne 0 ],   do if [ $1 = "BOXIT" ] || [ $1 = "boxit" ]         then BOXIT="BOXIT"3         elif [ $1 = "FIGURE" ] || [ $1 = "figure" ] "               then FIGURE="FIGURE"7               elif [ $1 = "PLAIN" ] || [ $1 = "plain" ] #                    then TEX="PLAIN"                      else SCALE=$1      fi 
      shift done  & # Verifications for the plain TeX mode- if [ $TEX = "PLAIN" ] && [ $BOXIT = "BOXIT" ] E    then echo "You cannot give the BOXIT parameter in PLAIN TEX mode."          exit fi/ if [ $TEX = "PLAIN" ] && [ $FIGURE = "FIGURE" ] F    then echo "You cannot give the FIGURE parameter in PLAIN TEX mode."         exit fi   # Beginning of the AWK program awk ' < BEGIN{FS="|"                              # Fields separator       PARAM="NO"       BEGIN_VALUE=0        END_VALUE=0        TOTAL_PERCENT=0 M       #   Definition of a figure environment (if FIGURE is not use, this line L       # will be remove later - ugly but it is because some AWK versions does;       # not accept the definition of external variables...)        # if FIGURE ,         print "%figure\\begin{figure}[htbp]"M       #   Framebox around the figure, (if BOXIT is not use, this line will be        # remove later)        # if BOXIT3         print "%boxit  \\psframebox[framesep=8mm]{" 9       print "%latex  {\\addtolength{\\textwidth}{-2.3cm}" 5       print "%latex   \\begin{minipage}{\\textwidth}" '       print "%latex    \\begin{center}"        # if FIGURE )         print "%figure     \\vspace{6mm}" 7       print "%latex     {\\setlength{\\tabcolsep}{0cm}"        print "%tex     {%" 6       print "      \\psset{unit=cm,xunit=cm,yunit=cm}"8       print "%latex      \\begin{pspicture}(-2,-2)(2,2)"#       print "        \\SpecialCoor" /       print "%tex      \\pspicture(-2,-2)(2,2)" F       print "%tex      \\def\\PieLabel\#1{\\vbox{\\halign{\\hfil\#\#"\ "\\hfil\\cr\#1\\cr}}}%" -       print "        \\psset{framesep=1.5pt}"        }    { <  # Suppression of the right and left blanks of the variables  for (I=1;I<=NF+1;I++) {      # On the left... "      for (J=1;J<=length($I)+1;J++)#          if (substr($I,1,1) == " ")              $I=substr($I,2)            else             break       # On the right...      for (J=length($I);J>0;J--) #          if (substr($I,J,1) == " ")              $I=substr($I,1,J-1)            else             break   }  E  #   Special comments before title (beginning by ##): they are copied 6  # at the beginning of the result file, without the ##  if (substr($1,1,2) == "##")!     print substr($1,3,length($1))   !  # Comments, null and blank lines 4  if (substr($1,1,1) == "#" || $1 == "" || $1 == " ")	     break     if (PARAM == "NO") { I      #   Generic parameters: title, title for the table of figures, label "      # (the last two are optional)      PARAM="YES"
      TITLE=$1       TABLE_TITLE=$2       LABEL=$3}	    else { +      # Verification of the sum of the parts #      TOTAL_PERCENT=TOTAL_PERCENT+$1 $      if (TOTAL_PERCENT > 100.0001) {A         print "Error! Total of percentages greater than 100! (" \                TOTAL_PERCENT ")" 
         exit} @      # Transformation of percentages in fractions of 360 degrees      $1=$1*3.6      END_VALUE=END_VALUE+$1       VAL=BEGIN_VALUE+$1/2       #Explode part$      if ($6 == "YES" || $6 == "yes")2          print "       \\uput{0.3}[" VAL "](0;0){"G      print "        \\pswedge[fillstyle=" $4 ",fillcolor=" $5 "]{2}{" \ )            BEGIN_VALUE "}{" END_VALUE "}"       # Inside label       if ($2 != "") {K         print "%tex        \\rput(1.2;" VAL "){\\psframebox*{\\PieLabel{" \  $2 "}}}""         if (index($2,"\\\\") == 0)K            print "%latex        \\rput(1.2;" VAL "){\\psframebox*{" $2 "}}"           else { 2            print "%latex        \\rput(1.2;" VAL \6                  "){\\psframebox*{\\begin{tabular}{c}"B            print "%latex                                      " $2M            print "%latex                                    \\end{tabular}}}"             }	         }       # Outside label      if ($3 != "") {I         print "%tex        \\uput{2.2}[" VAL "](0;0){\\PieLabel{" $3 "}}" "         if (index($3,"\\\\") == 0)B            print "%latex        \\uput{2.2}[" VAL "](0;0){" $3 "}"          else { N            print "%latex        \\uput{2.2}[" VAL "](0;0){\\begin{tabular}{c}";            print "%latex                               " $3 E            print "%latex                             \\end{tabular}}"             }	         }       # End of explode treatment $      if ($6 == "YES" || $6 == "yes")         print "       }"      BEGIN_VALUE=END_VALUE}   $1="" }    END{(     print "%latex      \\end{pspicture}"$     print "%tex      \\endpspicture"     print "     }"D     # For the case of a multiple line outside label at the bottom...     # if FIGURE '       print "%figure     \\vspace{4mm}" #     print "%latex    \\end{center}"      # if FIGURE        if (TABLE_TITLE == "").          print "%figure  \\caption{" TITLE "}"        else ?          print "%figure  \\caption[" TABLE_TITLE "]{" TITLE "}"        if (LABEL != "").          print "%figure  \\label{f:" LABEL "}"$     print "%latex   \\end{minipage}"     print "%latex  }"      # if BOXIT       print "%boxit }"     # if FIGURE "       print "%figure\\end{figure}"       }' >/tmp/piechart.tmp   N #   Post-processing for the "scale factor", PLAIN, FIGURE and BOXIT parametersH # (ugly but it's because some AWK versions doesn't accept the definition #  of external variables...) if [ $FIGURE = "FIGURE" ] @    then sed -e /unit=/s/unit=/unit=$SCALE/g -e /\^%figure/s/// \1             /tmp/piechart.tmp >/tmp/piechart.tmp2 =    else sed -e /unit=/s/unit=/unit=$SCALE/g -e /\^%figure/d \ 1             /tmp/piechart.tmp >/tmp/piechart.tmp2  fi' mv /tmp/piechart.tmp2 /tmp/piechart.tmp  if [ $BOXIT = "BOXIT" ] C    then sed -e /\^%boxit/s/// /tmp/piechart.tmp >/tmp/piechart.tmp2 C    else sed -e /\^%boxit/d    /tmp/piechart.tmp >/tmp/piechart.tmp2  fi   # plain TeX or LaTeX mode ' mv /tmp/piechart.tmp2 /tmp/piechart.tmp  if [ $TEX = "LATEX" ] C    then sed -e /\^%tex/d      /tmp/piechart.tmp >/tmp/piechart.tmp2 /         mv /tmp/piechart.tmp2 /tmp/piechart.tmp C         sed -e /\^%latex/s/// /tmp/piechart.tmp >/tmp/piechart.tmp2 C    else sed -e /\^%latex/d    /tmp/piechart.tmp >/tmp/piechart.tmp2 /         mv /tmp/piechart.tmp2 /tmp/piechart.tmp C         sed -e /\^%tex/s///   /tmp/piechart.tmp >/tmp/piechart.tmp2n fi   # Deliver of the result! cat /tmp/piechart.tmp2  ' rm /tmp/piechart.tmp /tmp/piechart.tmp2C