 /* Declarations for getopt. F    Copyright (C) 1989, 1990, 1991, 1992 Free Software Foundation, Inc.  J    This program is free software; you can redistribute it and/or modify itI    under the terms of the GNU Library General Public License as published I    by the Free Software Foundation; either version 2, or (at your option)     any later version.   B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU Library General PublicF    License along with this program; if not, write to the Free Software@    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */   #ifndef _GETOPT_H  #define _GETOPT_H 1    #ifdef	__cplusplus extern "C" { #endif  1 /* For communication from `getopt' to the caller. 8    When `getopt' finds an option that takes an argument,'    the argument value is returned here. ,    Also, when `ordering' is RETURN_IN_ORDER,5    each non-option ARGV-element is returned here.  */    extern char *optarg;  3 /* Index in ARGV of the next element to be scanned. 8    This is used for communication to and from the caller>    and for communication between successive calls to `getopt'.  G    On entry to `getopt', zero means this is the first call; initialize.   C    When `getopt' returns EOF, this is the index of the first of the :    non-option elements that the caller should itself scan.  =    Otherwise, `optind' communicates from one call to the next 0    how much of ARGV has been scanned so far.  */   extern int optind;  G /* Callers store zero here to inhibit the error message `getopt' prints      for unrecognized options.  */   extern int opterr;  @ /* Describe the long-named options requested by the application.K    The LONG_OPTIONS argument to getopt_long or getopt_long_only is a vector I    of `struct option' terminated by an element containing a name which is     zero.      The field `has_arg' is:?    no_argument		(or 0) if the option does not take an argument, ?    required_argument	(or 1) if the option requires an argument, F    optional_argument 	(or 2) if the option takes an optional argument.  G    If the field `flag' is not NULL, it points to a variable that is set F    to the value given in the field `val' when the option is found, but-    left unchanged if the option is not found.   F    To have a long-named option do something other than set an `int' toE    a compiled-in constant, such as set a value from `optarg', set the A    option's `flag' field to zero and its `val' field to a nonzero D    value (the equivalent single-letter option character, if there isB    one).  For long options that have a zero `flag' field, `getopt'/    returns the contents of the `val' field.  */   
 struct option  {  #if	__STDC__   const char *name;  #else 
   char *name;  #endifC   /* has_arg can't be an enum because some compilers complain about C      type mismatches in all the code that assumes it is an int.  */    int has_arg;   int *flag;
   int val; };  F /* Names for the values of the `has_arg' field of `struct option'.  */  
 enum _argtype  {    no_argument,   required_argument,   optional_argument  };   #if __STDC__G extern int getopt (int argc, char *const *argv, const char *shortopts); K extern int getopt_long (int argc, char *const *argv, const char *shortopts, 7 		        const struct option *longopts, int *longind); 9 extern int getopt_long_only (int argc, char *const *argv,  			     const char *shortopts,< 		             const struct option *longopts, int *longind);  ; /* Internal only.  Users should not call this directly.  */ 9 extern int _getopt_internal (int argc, char *const *argv,  			     const char *shortopts,; 		             const struct option *longopts, int *longind,  			     int long_only);  #else /* not __STDC__ */ extern int getopt ();  extern int getopt_long (); extern int getopt_long_only ();    extern int _getopt_internal ();  #endif /* not __STDC__ */    #ifdef	__cplusplus }  #endif   #endif /* _GETOPT_H */