9 /* Prepare TeX index dribble output into an actual index.       Version 1.45   :    Copyright (C) 1987, 1991 Free Software Foundation, Inc.  G    This program is free software; you can redistribute it and/or modify G    it under the terms of the GNU General Public License as published by F    the Free Software Foundation; either version 2, or (at your option)    any later version.   B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software?    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */      #include <stdio.h> #include <ctype.h> #include <errno.h> #include "getopt.h"    #if defined (STDC_HEADERS) #  include <string.h>  #  include <stdlib.h>  #  if !defined (bzero). #    define bzero(p, n) memset((p), '\0', (n)) #  endif /* !bzero */  #else /* !STDC_HEADERS */  extern int errno; ) char *getenv (), *malloc (), *realloc ();  void bzero (); #endif /* !STDC_HEADERS */   #if defined (HAVE_UNISTD_H)  #  include <unistd.h>  #else /* !HAVE_UNISTD_H */ long lseek (); #endif /* !HAVE_UNISTD_H */    char *mktemp ();   #if defined (VMS)  #  if !defined (VAX11C)  #    define noshare  #  endif /* !VAX11C */ #  include <perror.h>  extern noshare int sys_nerr;# extern noshare char *sys_errlist[];    #  include <file.h>   & #  define EXIT_SUCCESS ((1 << 28) | 1)$ #  define EXIT_FATAL ((1 << 28) | 4) #  define unlink delete    #else /* !VMS */   extern int sys_nerr; extern char *sys_errlist[];    #  if defined (USG)  #    include <sys/types.h> #    include <sys/fcntl.h> #  endif /* USG */  1 #  if defined (_AIX) || !defined (_POSIX_VERSION)  #    include <sys/file.h> $ #  else /* !AIX && _POSIX_VERSION */ #    if !defined (USG) #      include <fcntl.h> #    endif /* !USG */ & #  endif /* !_AIX && _POSIX_VERSION */ #  define EXIT_SUCCESS 0 #  define EXIT_FATAL 1 #endif /* !VMS */    #if !defined (SEEK_SET)  #  define SEEK_SET 0 #  define SEEK_CUR 1 #  define SEEK_END 2 #endif /* !SEEK_SET */  : /* When sorting in core, this structure describes one line9    and the position and length of its first keyfield.  */  struct lineinfo  { 1   char *text;		/* The actual text of the line. */ 	   union { E     char *text;		/* The start of the key (for textual comparison). */ B     long number;	/* The numeric value (for numeric comparison). */   } key;*   long keylen;		/* Length of KEY field. */ };  < /* This structure describes a field to use as a sort key. */ struct keyfield  { 0   int startwords;	/* Number of words to skip. */;   int startchars;	/* Number of additional chars to skip. */ 8   int endwords;		/* Number of words to ignore at end. */9   int endchars;		/* Ditto for characters of last word. */ B   char ignore_blanks;	/* Non-zero means ignore spaces and tabs. */;   char fold_case;	/* Non-zero means case doesn't matter. */ ?   char reverse;		/* Non-zero means compare in reverse order. */ >   char numeric;		/* Non-zeros means field is ASCII numeric. */9   char positional;	/* Sort according to file position. */ @   char braced;		/* Count balanced-braced groupings as fields. */ };  ! /* Vector of keyfields to use. */  struct keyfield keyfields[3];   1 /* Number of keyfields stored in that vector.  */  int num_keyfields = 3;  A /* Vector of input file names, terminated with a null pointer. */  char **infiles;   I /* Vector of corresponding output file names, or NULL, meaning default it     (add an `s' to the end). */ char **outfiles;   /* Length of `infiles'. */ int num_infiles;  = /* Pointer to the array of pointers to lines being sorted. */  char **linearray;   * /* The allocated length of `linearray'. */ long nlines;  L /* Directory to use for temporary files.  On Unix, it ends with a slash.  */ char *tempdir;  4 /* Start of filename to use for temporary files.  */ char *tempbase;   % /* Number of last temporary file.  */  int tempcount;  1 /* Number of last temporary file already deleted. M    Temporary files are deleted by `flush_tempfiles' in order of creation.  */  int last_deleted_tempcount;   A /* During in-core sort, this points to the base of the data block ,    which contains all the lines of data.  */ char *text_base;  " /* Additional command switches .*/  = /* Nonzero means do not delete tempfiles -- for debugging. */  int keep_tempfiles;   ) /* The name this program was run with. */  char *program_name;   5 /* Forward declarations of functions in this file. */    void decode_command ();  void sort_in_core ();  void sort_offline ();  char **parsefile (); char *find_field (); char *find_pos (); long find_value ();  char *find_braced_pos ();  char *find_braced_end ();  void writelines ();  int compare_field ();  int compare_full (); long readline ();  int merge_files ();  int merge_direct (); void pfatal_with_name ();  void fatal (); void error (); void *xmalloc (), *xrealloc ();  char *concat (); char *maketempname (); void flush_tempfiles (); char *tempcopy ();   #define MAX_IN_CORE_SORT 500000    void main (argc, argv)       int argc;      char **argv;  {    int i;     tempcount = 0;   last_deleted_tempcount = 0;    program_name = argv[0];   +   /* Describe the kind of sorting to do. */ F   /* The first keyfield uses the first braced field and folds case. */   keyfields[0].braced = 1;   keyfields[0].fold_case = 1;    keyfields[0].endwords = -1;    keyfields[0].endchars = -1;   F   /* The second keyfield uses the second braced field, numerically. */   keyfields[1].braced = 1;   keyfields[1].numeric = 1;    keyfields[1].startwords = 1;   keyfields[1].endwords = -1;    keyfields[1].endchars = -1;   F   /* The third keyfield (which is ignored while discarding duplicates)       compares the whole line. */   keyfields[2].endwords = -1;    keyfields[2].endchars = -1;      decode_command (argc, argv);  3   tempbase = mktemp (concat ("txiXXXXXX", "", ""));   4   /* Process input files completely, one by one.  */  #   for (i = 0; i < num_infiles; i++)      {        int desc;        long ptr;        char *outfile;  ,       desc = open (infiles[i], O_RDONLY, 0);       if (desc < 0)  	pfatal_with_name (infiles[i]); !       lseek (desc, 0L, SEEK_END); '       ptr = lseek (desc, 0L, SEEK_CUR);          close (desc);          outfile = outfiles[i];       if (!outfile)  	{* 	  outfile = concat (infiles[i], "s", ""); 	}  !       if (ptr < MAX_IN_CORE_SORT) # 	/* Sort a small amount of data. */ ) 	sort_in_core (infiles[i], ptr, outfile); 
       else) 	sort_offline (infiles[i], ptr, outfile);      }      flush_tempfiles (tempcount);   exit (EXIT_SUCCESS); }    void usage () {    fprintf (stderr, "\ 9 Usage: %s [-k] infile [-o outfile] ...\n", program_name);    exit (1);  }   C /* Decode the command line arguments to set the parameter variables G    and set up the vector of keyfields and the vector of input files. */    void decode_command (argc, argv)       int argc;      char **argv;  {    int optc;    char **ip;   char **op;  6   /* Store default values into parameter variables. */     tempdir = getenv ("TMPDIR");
 #ifdef VMS   if (tempdir == NULL)     tempdir = "sys$scratch:";  #else    if (tempdir == NULL)     tempdir = "/tmp/";   else(     tempdir = concat (tempdir, "/", ""); #endif     keep_tempfiles = 0;   9   /* Allocate ARGC input files, which must be enough.  */   7   infiles = (char **) xmalloc (argc * sizeof (char *)); 8   outfiles = (char **) xmalloc (argc * sizeof (char *));   ip = infiles;    op = outfiles;  5   while ((optc = getopt (argc, argv, "-ko:")) != EOF)      {        switch (optc)  	{$ 	case 1:		/* Non-option filename. */ 	  *ip++ = optarg; 	  *op++ = NULL;	 	  break;   
 	case 'k': 	  keep_tempfiles = 1;	 	  break;   
 	case 'o': 	  if (op > outfiles)  	    *(op - 1) = optarg;	 	  break;   	 	default:  	  usage (); 	}     }   C   /* Record number of keyfields and terminate list of filenames. */    num_infiles = ip - infiles; 
   *ip = 0;   if (num_infiles == 0) 
     usage ();  }   ) /* Return a name for a temporary file. */    char * maketempname (count)      int count;  {    char tempsuffix[10];$   sprintf (tempsuffix, "%d", count);0   return concat (tempdir, tempbase, tempsuffix); }   0 /* Delete all temporary files up to TO_COUNT. */   void flush_tempfiles (to_count)      int to_count; {    if (keep_tempfiles)      return; +   while (last_deleted_tempcount < to_count) 5     unlink (maketempname (++last_deleted_tempcount));  }   : /* Copy the input file open on IDESC into a temporary file)    and return the temporary file name. */    #define BUFSIZE 1024   char * tempcopy (idesc)      int idesc;  { -   char *outfile = maketempname (++tempcount);    int odesc;   char buffer[BUFSIZE];   3   odesc = open (outfile, O_WRONLY | O_CREAT, 0666);      if (odesc < 0)     pfatal_with_name (outfile);      while (1)      { 0       int nread = read (idesc, buffer, BUFSIZE);#       write (odesc, buffer, nread);        if (!nread)  	break;      }      close (odesc);     return outfile;  }   J /* Compare LINE1 and LINE2 according to the specified set of keyfields. */   int  compare_full (line1, line2)       char **line1, **line2;  {    int i;  &   /* Compare using the first keyfield;E      if that does not distinguish the lines, try the second keyfield;       and so on. */  %   for (i = 0; i < num_keyfields; i++)      {        long length1, length2;B       char *start1 = find_field (&keyfields[i], *line1, &length1);B       char *start2 = find_field (&keyfields[i], *line2, &length2);R       int tem = compare_field (&keyfields[i], start1, length1, *line1 - text_base,/ 			       start2, length2, *line2 - text_base);        if (tem) 	{ 	  if (keyfields[i].reverse) 	    return -tem;  	  return tem; 	}     }   (   return 0;			/* Lines match exactly. */ }   3 /* Compare LINE1 and LINE2, described by structures 8    in which the first keyfield is identified in advance.F    For positional sorting, assumes that the order of the lines in core$    reflects their nominal order.  */   int  compare_prepared (line1, line2) $      struct lineinfo *line1, *line2; {    int i;
   int tem;   char *text1, *text2;  N   /* Compare using the first keyfield, which has been found for us already. */   if (keyfields->positional)     { <       if (line1->text - text_base > line2->text - text_base)	 	tem = 1; 
       else
 	tem = -1;     }    else if (keyfields->numeric)0     tem = line1->key.number - line2->key.number;   elseF     tem = compare_field (keyfields, line1->key.text, line1->keylen, 0,' 			 line2->key.text, line2->keylen, 0); 
   if (tem)     {        if (keyfields->reverse) 
 	return -tem;        return tem;      }      text1 = line1->text;   text2 = line2->text;  '   /* Compare using the second keyfield; D      if that does not distinguish the lines, try the third keyfield;      and so on. */  %   for (i = 1; i < num_keyfields; i++)      {        long length1, length2;A       char *start1 = find_field (&keyfields[i], text1, &length1); A       char *start2 = find_field (&keyfields[i], text2, &length2); Q       int tem = compare_field (&keyfields[i], start1, length1, text1 - text_base, . 			       start2, length2, text2 - text_base);       if (tem) 	{ 	  if (keyfields[i].reverse) 	    return -tem;  	  return tem; 	}     }   (   return 0;			/* Lines match exactly. */ }   & /* Like compare_full but more general.G    You can pass any strings, and you can say how many keyfields to use. C    POS1 and POS2 should indicate the nominal positional ordering of "    the two lines in the input.  */   int 7 compare_general (str1, str2, pos1, pos2, use_keyfields)       char *str1, *str2;       long pos1, pos2;       int use_keyfields;  {    int i;  &   /* Compare using the first keyfield;E      if that does not distinguish the lines, try the second keyfield;       and so on. */  %   for (i = 0; i < use_keyfields; i++)      {        long length1, length2;@       char *start1 = find_field (&keyfields[i], str1, &length1);@       char *start2 = find_field (&keyfields[i], str2, &length2);D       int tem = compare_field (&keyfields[i], start1, length1, pos1,! 			       start2, length2, pos2);        if (tem) 	{ 	  if (keyfields[i].reverse) 	    return -tem;  	  return tem; 	}     }   (   return 0;			/* Lines match exactly. */ }   E /* Find the start and length of a field in STR according to KEYFIELD. B    A pointer to the starting character is returned, and the length7    is stored into the int that LENGTHPTR points to.  */    char *% find_field (keyfield, str, lengthptr)       struct keyfield *keyfield;       char *str;       long *lengthptr;  {    char *start;   char *end;   char *(*fun) ();     if (keyfield->braced)      fun = find_braced_pos;   else     fun = find_pos;   B   start = (*fun) (str, keyfield->startwords, keyfield->startchars, 		  keyfield->ignore_blanks);    if (keyfield->endwords < 0)      {        if (keyfield->braced)  	end = find_braced_end (start); 
       else 	{ 	  end = start;  	  while (*end && *end != '\n')  	    end++;  	}     }    else     { D       end = (*fun) (str, keyfield->endwords, keyfield->endchars, 0);"       if (end - str < start - str)
 	end = start;      }    *lengthptr = end - start;    return start;  }   4 /* Return a pointer to a specified place within STR,B    skipping (from the beginning) WORDS words and then CHARS chars.2    If IGNORE_BLANKS is nonzero, we skip all blanks(    after finding the specified word.  */   char *+ find_pos (str, words, chars, ignore_blanks)       char *str;       int words, chars;      int ignore_blanks;  {    int i;   char *p = str;     for (i = 0; i < words; i++)      { 
       char c; 7       /* Find next bunch of nonblanks and skip them. */ *       while ((c = *p) == ' ' || c == '\t') 	p++; ?       while ((c = *p) && c != '\n' && !(c == ' ' || c == '\t'))  	p++;        if (!*p || *p == '\n')
 	return p;     }   !   while (*p == ' ' || *p == '\t')      p++;     for (i = 0; i < chars; i++)      {        if (!*p || *p == '\n') 	break; 
       p++;     }    return p;  }   D /* Like find_pos but assumes that each field is surrounded by braces1    and that braces within fields are balanced. */    char *2 find_braced_pos (str, words, chars, ignore_blanks)      char *str;       int words, chars;      int ignore_blanks;  {    int i;   int bracelevel;    char *p = str;	   char c;      for (i = 0; i < words; i++)      {        bracelevel = 1; 1       while ((c = *p++) != '{' && c != '\n' && c)  	/* Do nothing. */ ;       if (c != '{')  	return p - 1;       while (bracelevel) 	{ 	  c = *p++; 	  if (c == '{') 	    bracelevel++; 	  if (c == '}') 	    bracelevel--; 	  if (c == 0 || c == '\n')  	    return p - 1; 	}     }   -   while ((c = *p++) != '{' && c != '\n' && c)      /* Do nothing. */ ;      if (c != '{')      return p - 1;      if (ignore_blanks)(     while ((c = *p) == ' ' || c == '\t')
       p++;     for (i = 0; i < chars; i++)      {        if (!*p || *p == '\n') 	break; 
       p++;     }    return p;  }   @ /* Find the end of the balanced-brace field which starts at STR.=    The position returned is just before the closing brace. */    char * find_braced_end (str)       char *str;  {    int bracelevel;    char *p = str;	   char c;      bracelevel = 1;    while (bracelevel)     {        c = *p++;        if (c == '{')  	bracelevel++;       if (c == '}')  	bracelevel--;       if (c == 0 || c == '\n') 	return p - 1;     }    return p - 1;  }    long find_value (start, length)      char *start;       long length;  {    while (length != 0L)     {        if (isdigit (*start))  	return atol (start);        length--;        start++;     }    return 0l; }   6 /* Vector used to translate characters for comparison.9    This is how we make all alphanumerics follow all else, ,    and ignore case in the first sorting.  */ int char_order[256];   void init_char_order () {u   int i;   for (i = 1; i < 256; i++)1     char_order[i] = i;     for (i = '0'; i <= '9'; i++)     char_order[i] += 512;      for (i = 'a'; i <= 'z'; i++)     {        char_order[i] = 512 + i;*       char_order[i + 'A' - 'a'] = 512 + i;     }d }   O /* Compare two fields (each specified as a start pointer and a character count)t    according to KEYFIELD.gD    The sign of the value reports the relation between the fields. */   intRF compare_field (keyfield, start1, length1, pos1, start2, length2, pos2)      struct keyfield *keyfield;e      char *start1;      long length1;      long pos1;       char *start2;      long length2;      long pos2;l {L   if (keyfields->positional)     {f       if (pos1 > pos2)
 	return 1;
       else 	return -1;s     }C   if (keyfield->numeric)     { O       long value = find_value (start1, length1) - find_value (start2, length2);        if (value > 0)
 	return 1;       if (value < 0) 	return -1;t       return 0;d     }(   else     {f       char *p1 = start1;       char *p2 = start2;"       char *e1 = start1 + length1;"       char *e2 = start2 + length2;         while (1)e 	{ 	  int c1, c2;   	  if (p1 == e1) 	    c1 = 0; 	  elsee 	    c1 = *p1++; 	  if (p2 == e2) 	    c2 = 0; 	  elseA 	    c2 = *p2++;  ( 	  if (char_order[c1] != char_order[c2]), 	    return char_order[c1] - char_order[c2]; 	  if (!c1)A 	    break;d 	}  8       /* Strings are equal except possibly for case.  */       p1 = start1;       p2 = start2;       while (1)r 	{ 	  int c1, c2;   	  if (p1 == e1) 	    c1 = 0; 	  else< 	    c1 = *p1++; 	  if (p2 == e2) 	    c2 = 0; 	  else  	    c2 = *p2++;   	  if (c1 != c2); 	    /* Reverse sign here so upper case comes out last.  */e 	    return c2 - c1; 	  if (!c1)e 	    break;c 	}         return 0;e     }  }   C /* A `struct linebuffer' is a structure which holds a line of text.y:    `readline' reads a line from a stream into a linebuffer6    and works regardless of the length of the line.  */   struct linebuffer_ {    long size;   char *buffer;  };  $ /* Initialize LINEBUFFER for use. */   void initbuffer (linebuffer)E#      struct linebuffer *linebuffer;f {    linebuffer->size = 200;E.   linebuffer->buffer = (char *) xmalloc (200); }c  3 /* Read a line of text from STREAM into LINEBUFFER.t%    Return the length of the line.  */*   long readline (linebuffer, stream)	#      struct linebuffer *linebuffer;       FILE *stream; {e$   char *buffer = linebuffer->buffer;   char *p = linebuffer->buffer;m#   char *end = p + linebuffer->size;c     while (1)/     {e       int c = getc (stream);       if (p == end)  	{> 	  buffer = (char *) xrealloc (buffer, linebuffer->size *= 2);$ 	  p += buffer - linebuffer->buffer;& 	  end += buffer - linebuffer->buffer; 	  linebuffer->buffer = buffer;h 	}       if (c < 0 || c == '\n')/ 	{
 	  *p = 0;	 	  break;  	}       *p++ = c;c     }/     return p - buffer; }a w2 /* Sort an input file too big to sort in core.  */   void- sort_offline (infile, nfiles, total, outfile)       char *infile;      int nfiles;      long total;      char *outfile;  {e   /* More than enough. */rE   int ntemps = 2 * (total + MAX_IN_CORE_SORT - 1) / MAX_IN_CORE_SORT;/B   char **tempfiles = (char **) xmalloc (ntemps * sizeof (char *));&   FILE *istream = fopen (infile, "r");   int i;   struct linebuffer lb;*   long linelength;   int failure = 0;     initbuffer (&lb);o  (   /* Read in one line of input data.  */  '   linelength = readline (&lb, istream);i  2   if (lb.buffer[0] != '\\' && lb.buffer[0] != '@')     { 5       error ("%s: not a texinfo index file", infile);f
       return;d     }'  F   /* Split up the input into `ntemps' temporary files, or maybe fewer,5      and put the new files' names into `tempfiles' */s     for (i = 0; i < ntemps; i++)     { 1       char *outname = maketempname (++tempcount);i+       FILE *ostream = fopen (outname, "w");e       long tempsize = 0;         if (!ostream)p 	pfatal_with_name (outname);       tempfiles[i] = outname;   H       /* Copy lines into this temp file as long as it does not make file1 	 "too big" or until there are no more lines.  */   ;       while (tempsize + linelength + 1 <= MAX_IN_CORE_SORT)o 	{ 	  tempsize += linelength + 1; 	  fputs (lb.buffer, ostream); 	  putc ('\n', ostream);  * 	  /* Read another line of input data.  */  ( 	  linelength = readline (&lb, istream);% 	  if (!linelength && feof (istream))* 	    break;s  3 	  if (lb.buffer[0] != '\\' && lb.buffer[0] != '@')p 	    {6 	      error ("%s: not a texinfo index file", infile); 	      failure = 1;* 	      goto fail;n 	    } 	}       fclose (ostream);o       if (feof (istream))d 	break;c     }      free (lb.buffer);    fail:p8   /* Record number of temp files we actually needed.  */  
   ntemps = i;   .   /* Sort each tempfile into another tempfile.E     Delete the first set of tempfiles and put the names of the second(     into `tempfiles'. */     for (i = 0; i < ntemps; i++)     { 1       char *newtemp = maketempname (++tempcount);r>       sort_in_core (&tempfiles[i], MAX_IN_CORE_SORT, newtemp);       if (!keep_tempfiles) 	unlink (tempfiles[i]);e       tempfiles[i] = newtemp;C     }T     if (failure)     return;r  2   /* Merge the tempfiles together and indexify. */  +   merge_files (tempfiles, ntemps, outfile);= }   $ /* Sort INFILE, whose size is TOTAL,4    assuming that is small enough to be done in-core,F    then indexify it and send the output to OUTFILE (or to stdout).  */   void% sort_in_core (infile, total, outfile)f      char *infile;      long total;      char *outfile;  {*   char **nextline;,   char *data = (char *) xmalloc (total + 1);   char *file_data;   long file_size;d   int i;   FILE *ostream = stdout;a   struct lineinfo *lineinfo;  A   /* Read the contents of the file into the moby array `data'. */i  (   int desc = open (infile, O_RDONLY, 0);     if (desc < 0)e+     fatal ("failure reopening %s", infile);    for (file_size = 0;;)d     { ;       i = read (desc, data + file_size, total - file_size);        if (i <= 0)" 	break;)       file_size += i;t     }c   file_data = data;.   data[file_size] = 0;     close (desc);   9   if (file_size > 0 && data[0] != '\\' && data[0] != '@')f     { 5       error ("%s: not a texinfo index file", infile);(
       return;a     }h     init_char_order ();   0   /* Sort routines want to know this address. */     text_base = data;   ?   /* Create the array of pointers to lines, with a default sizet      frequently enough.  */a     nlines = total / 50;   if (!nlines)     nlines = 2;_;   linearray = (char **) xmalloc (nlines * sizeof (char *));i  ;   /* `nextline' points to the next free slot in this array.i(      `nlines' is the allocated size.  */     nextline = linearray;(  E   /* Parse the input file's data, and make entries for the lines.  */:  @   nextline = parsefile (infile, nextline, file_data, file_size);   if (nextline == 0)     {i5       error ("%s: not a texinfo index file", infile);t
       return;o     }e     /* Sort the lines. */   N   /* If we have enough space, find the first keyfield of each line in advance.G      Make a `struct lineinfo' for each line, which records the keyfieldl,      as well as the line, and sort them.  */  \   lineinfo = (struct lineinfo *) malloc ((nextline - linearray) * sizeof (struct lineinfo));     if (lineinfo)N     {        struct lineinfo *lp;       char **p;o  B       for (lp = lineinfo, p = linearray; p != nextline; lp++, p++) 	{ 	  lp->text = *p; : 	  lp->key.text = find_field (keyfields, *p, &lp->keylen); 	  if (keyfields->numeric)< 	    lp->key.number = find_value (lp->key.text, lp->keylen); 	}  Y       qsort (lineinfo, nextline - linearray, sizeof (struct lineinfo), compare_prepared);   B       for (lp = lineinfo, p = linearray; p != nextline; lp++, p++) 	*p = lp->text;*         free (lineinfo);     }    elseK     qsort (linearray, nextline - linearray, sizeof (char *), compare_full);*     /* Open the output file. */      if (outfile)     { %       ostream = fopen (outfile, "w");f       if (!ostream)i 	pfatal_with_name (outfile);     }   8   writelines (linearray, nextline - linearray, ostream);   if (outfile)     fclose (ostream);a     free (linearray);    free (data); }e o, /* Parse an input string in core into lines.4    DATA is the input string, and SIZE is its length./    Data goes in LINEARRAY starting at NEXTLINE.DC    The value returned is the first entry in LINEARRAY still unused. 5    Value 0 means input file contents are invalid.  */s   char **u* parsefile (filename, nextline, data, size)      char *filename;      char **nextline;t      char *data;      long size;  {u   char *p, *end;   char **line = nextline;      p = data;    end = p + size;.   *end = 0;n     while (p != end)     {p&       if (p[0] != '\\' && p[0] != '@')
 	return 0;         *line = p;       while (*p && *p != '\n') 	p++;[       if (p != end)  	p++;(  
       line++; %       if (line == linearray + nlines)  	{ 	  char **old = linearray;O 	  linearray = (char **) xrealloc (linearray, sizeof (char *) * (nlines *= 4));  	  line += linearray - old;  	}     }(     return line; }   9 /* Indexification is a filter applied to the sorted linesa0    as they are being written to the output file.C    Multiple entries for the same name, with different page numbers,i?    get combined into a single entry with multiple page numbers.iC    The first braced field, which is used for sorting, is discarded.fB    However, its first character is examined, folded to lower case,B    and if it is different from that in the previous line fed to usA    a \initial line is written with one argument, the new initial.i  @    If an entry has four braced fields, then the second and third*    constitute primary and secondary names.,    In this case, each change of primary nameB    generates a \primary line which contains only the primary name,:    and in between these are \secondary lines which contain-    just a secondary name and page numbers. */L  7 /* The last primary name we wrote a \primary entry for.iN    If only one level of indexing is being done, this is the last name seen. */ char *lastprimary;2 /* Length of storage allocated for lastprimary. */ int lastprimarylength;  & /* Similar, for the secondary name. */ char *lastsecondary; int lastsecondarylength;  8 /* Zero if we are not in the middle of writing an entry.@    One if we have written the beginning of an entry but have not(    yet written any page numbers into it.@    Greater than one if we have written the beginning of an entry$    plus at least one page number. */ int pending;  H /* The initial (for sorting purposes) of the last primary entry written.7    When this changes, a \initial {c} line is written */x   char *lastinitial;   int lastinitiallength;  B /* When we need a string of length 1 for the value of lastinitial,    store it here.  */x   char lastinitial1[2];;  5 /* Initialize static storage for writing an index. */t   void
 init_index ()h {i   pending = 0;   lastinitial = lastinitial1;/   lastinitial1[0] = 0;   lastinitial1[1] = 0;   lastinitiallength = 0;   lastprimarylength = 100;9   lastprimary = (char *) xmalloc (lastprimarylength + 1);*-   bzero (lastprimary, lastprimarylength + 1);g   lastsecondarylength = 100;=   lastsecondary = (char *) xmalloc (lastsecondarylength + 1);	1   bzero (lastsecondary, lastsecondarylength + 1);  }(  . /* Indexify.  Merge entries for the same name,6    insert headers for each initial character, etc.  */   void indexify (line, ostream)      char *line;      FILE *ostream;  {u)   char *primary, *secondary, *pagenumber;m5   int primarylength, secondarylength = 0, pagelength;e   int nosecondary;   int initiallength;   char *initial;   char initial1[2];    register char *p;,  B   /* First, analyze the parts of the entry fed to us this time. */  &   p = find_braced_pos (line, 0, 0, 0);   if (*p == '{')     {a       initial = p;<       /* Get length of inner pair of braces starting at `p',* 	 including that inner pair of braces.  */6       initiallength = find_braced_end (p + 1) + 1 - p;     }1   else     {        initial = initial1;        initial1[0] = *p;n       initial1[1] = 0;       initiallength = 1;  3       if (initial1[0] >= 'a' && initial1[0] <= 'z')& 	initial1[0] -= 040;     },  /   pagenumber = find_braced_pos (line, 1, 0, 0);f9   pagelength = find_braced_end (pagenumber) - pagenumber;    if (pagelength == 0)
     abort ();n  ,   primary = find_braced_pos (line, 2, 0, 0);6   primarylength = find_braced_end (primary) - primary;  .   secondary = find_braced_pos (line, 3, 0, 0);   nosecondary = !*secondary;   if (!nosecondary) >     secondarylength = find_braced_end (secondary) - secondary;  J   /* If the primary is different from before, make a new primary entry. */4   if (strncmp (primary, lastprimary, primarylength))     {uD       /* Close off current secondary entry first, if one is open. */       if (pending) 	{ 	  fputs ("}\n", ostream); 	  pending = 0;, 	}  F       /* If this primary has a different initial, include an entry for 	 the initial. */ /       if (initiallength != lastinitiallength ||d1 	  strncmp (initial, lastinitial, initiallength))i 	{$ 	  fprintf (ostream, "\\initial {");/ 	  fwrite (initial, 1, initiallength, ostream);t% 	  fprintf (ostream, "}\n", initial);r 	  if (initial == initial1)  	    {" 	      lastinitial = lastinitial1;! 	      *lastinitial1 = *initial1;a 	    } 	  elset 	    { 	      lastinitial = initial;i 	    }% 	  lastinitiallength = initiallength;w 	}  ,       /* Make the entry for the primary.  */       if (nosecondary) 	fputs ("\\entry {", ostream);
       else  	fputs ("\\primary {", ostream);2       fwrite (primary, primarylength, 1, ostream);       if (nosecondary) 	{ 	  fputs ("}{", ostream);  	  pending = 1;  	}
       else 	fputs ("}\n", ostream);  /       /* Record name of most recent primary. */ ,       if (lastprimarylength < primarylength) 	{+ 	  lastprimarylength = primarylength + 100;&0 	  lastprimary = (char *) xrealloc (lastprimary, 					   1 + lastprimarylength);t 	}4       strncpy (lastprimary, primary, primarylength);%       lastprimary[primarylength] = 0;   C       /* There is no current secondary within this primary, now. */e       lastsecondary[0] = 0;p     }a  P   /* Should not have an entry with no subtopic following one with a subtopic. */  $   if (nosecondary && *lastsecondary)D     error ("entry %s follows an entry with a secondary name", line);  1   /* Start a new secondary entry if necessary. */nJ   if (!nosecondary && strncmp (secondary, lastsecondary, secondarylength))     {        if (pending) 	{ 	  fputs ("}\n", ostream); 	  pending = 0;n 	}  /       /* Write the entry for the secondary.  */r'       fputs ("\\secondary {", ostream);{6       fwrite (secondary, secondarylength, 1, ostream);       fputs ("}{", ostream);       pending = 1;  1       /* Record name of most recent secondary. */h0       if (lastsecondarylength < secondarylength) 	{/ 	  lastsecondarylength = secondarylength + 100;-4 	  lastsecondary = (char *) xrealloc (lastsecondary,# 					     1 + lastsecondarylength);  	}:       strncpy (lastsecondary, secondary, secondarylength);)       lastsecondary[secondarylength] = 0;      }*  >   /* Here to add one more page number to the current entry. */   if (pending++ != 1)iK     fputs (", ", ostream);	/* Punctuate first, if this is not the first. */c.   fwrite (pagenumber, pagelength, 1, ostream); };  , /* Close out any unfinished output entry. */   void finish_index (ostream)      FILE *ostream;' {    if (pending)     fputs ("}\n", ostream);e   free (lastprimary);0   free (lastsecondary);  };  & /* Copy the lines in the sorted order.@    Each line is copied out of the input file it was found in. */   void' writelines (linearray, nlines, ostream)i      char **linearray;      int nlines;      FILE *ostream;t {+(   char **stop_line = linearray + nlines;   char **next_line;r     init_index ();  @   /* Output the text of the lines, and free the buffer space. */  B   for (next_line = linearray; next_line != stop_line; next_line++)     {cU       /* If -u was specified, output the line only if distinct from previous one.  */o        if (next_line == linearray<       /* Compare previous line with this one, using only the'          explicitly specd keyfields. */hP 	  || compare_general (*(next_line - 1), *next_line, 0L, 0L, num_keyfields - 1)) 	{ 	  char *p = *next_line;
 	  char c;  " 	  while ((c = *p++) && c != '\n') 	    /* Do nothing. */ ; 	  *(p - 1) = 0;" 	  indexify (*next_line, ostream); 	}     }k     finish_index (ostream);1 }t 2A /* Assume (and optionally verify) that each input file is sorted;t$    merge them and output the result.8    Returns nonzero if any input file fails to be sorted.  @    This is the high-level interface that can handle an unlimited    number of files.  */    #define MAX_DIRECT_MERGE 10f   intu& merge_files (infiles, nfiles, outfile)      char **infiles;      int nfiles;      char *outfile;  {f   char **tempfiles; 
   int ntemps;a   int i;   int value = 0;"   int start_tempcount = tempcount;  !   if (nfiles <= MAX_DIRECT_MERGE)r3     return merge_direct (infiles, nfiles, outfile);   <   /* Merge groups of MAX_DIRECT_MERGE input files at a time,=      making a temporary file to hold each group's result.  */   >   ntemps = (nfiles + MAX_DIRECT_MERGE - 1) / MAX_DIRECT_MERGE;;   tempfiles = (char **) xmalloc (ntemps * sizeof (char *));r   for (i = 0; i < ntemps; i++)     {1        int nf = MAX_DIRECT_MERGE;       if (i + 1 == ntemps)$ 	nf = nfiles - i * MAX_DIRECT_MERGE;0       tempfiles[i] = maketempname (++tempcount);O       value |= merge_direct (&infiles[i * MAX_DIRECT_MERGE], nf, tempfiles[i]);      }   A   /* All temporary files that existed before are no longer needed B      since their contents have been merged into our new tempfiles.      So delete them.  */$   flush_tempfiles (start_tempcount);  2   /* Now merge the temporary files we created.  */  +   merge_files (tempfiles, ntemps, outfile);      free (tempfiles);t     return value;a }w sA /* Assume (and optionally verify) that each input file is sorted; $    merge them and output the result.8    Returns nonzero if any input file fails to be sorted.  9    This version of merging will not work if the number ofi5    input files gets too high.  Higher level functions 8    use it only with a bounded number of input files.  */   intE' merge_direct (infiles, nfiles, outfile)e      char **infiles;      int nfiles;      char *outfile;i {u   struct linebuffer *lb1, *lb2;r+   struct linebuffer **thisline, **prevline;;   FILE **streams;u   int i;   int nleft;   int lossage = 0;   int *file_lossage;"   struct linebuffer *prev_out = 0;   FILE *ostream = stdout;      if (outfile)     {x%       ostream = fopen (outfile, "w");;     }+   if (!ostream)f     pfatal_with_name (outfile);l     init_index ();     if (nfiles == 0)     {r       if (outfile) 	fclose (ostream);       return 0;      }   *   /* For each file, make two line buffers.;      Also, for each file, there is an element of `thisline'r?      which points at any time to one of the file's two buffers, C      and an element of `prevline' which points to the other buffer.iN      `thisline' is supposed to point to the next available line from the file,4      while `prevline' holds the last file line used,S      which is remembered so that we can verify that the file is properly sorted. */   5   /* lb1 and lb2 contain one buffer each per file. */nL   lb1 = (struct linebuffer *) xmalloc (nfiles * sizeof (struct linebuffer));L   lb2 = (struct linebuffer *) xmalloc (nfiles * sizeof (struct linebuffer));  T   /* thisline[i] points to the linebuffer holding the next available line in file i,<      or is zero if there are no lines left in that file.  */#   thisline = (struct linebuffer **) 4     xmalloc (nfiles * sizeof (struct linebuffer *));D   /* prevline[i] points to the linebuffer holding the last used lineE      from file i.  This is just for verifying that file i is properly       sorted.  */#   prevline = (struct linebuffer **)a4     xmalloc (nfiles * sizeof (struct linebuffer *));6   /* streams[i] holds the input stream for file i.  */9   streams = (FILE **) xmalloc (nfiles * sizeof (FILE *));e@   /* file_lossage[i] is nonzero if we already know file i is not      properly sorted.  */ 9   file_lossage = (int *) xmalloc (nfiles * sizeof (int));   1   /* Allocate and initialize all that storage. */d     for (i = 0; i < nfiles; i++)     {,       initbuffer (&lb1[i]);h       initbuffer (&lb2[i]);e       thisline[i] = &lb1[i];       prevline[i] = &lb2[i];       file_lossage[i] = 0;+       streams[i] = fopen (infiles[i], "r");f       if (!streams[i]) 	pfatal_with_name (infiles[i]);e  )       readline (thisline[i], streams[i]);e     }   1   /* Keep count of number of files not at eof. */u   nleft = nfiles;w     while (nleft)      { "       struct linebuffer *best = 0;       struct linebuffer *exch;       int bestfile = -1;       int i;  L       /* Look at the next avail line of each file; choose the least one.  */  "       for (i = 0; i < nfiles; i++) 	{ 	  if (thisline[i] &&r 	      (!best ||? 	       0 < compare_general (best->buffer, thisline[i]->buffer,e0 				 (long) bestfile, (long) i, num_keyfields))) 	    { 	      best = thisline[i]; 	      bestfile = i; 	    } 	}  D       /* Output that line, unless it matches the previous one and we 	 don't want duplicates. */S         if (!(prev_out &&O( 	    !compare_general (prev_out->buffer,3 			      best->buffer, 0L, 1L, num_keyfields - 1)))t" 	indexify (best->buffer, ostream);       prev_out = best;  D       /* Now make the line the previous of its file, and fetch a new 	 line from that file.  */          exch = prevline[bestfile];.       prevline[bestfile] = thisline[bestfile];        thisline[bestfile] = exch;         while (1)u 	{0 	  /* If the file has no more, mark it empty. */    	  if (feof (streams[bestfile])) 	    { 	      thisline[bestfile] = 0;8 	      /* Update the number of files still not empty. */ 	      nleft--; 
 	      break;= 	    }4 	  readline (thisline[bestfile], streams[bestfile]);B 	  if (thisline[bestfile]->buffer[0] || !feof (streams[bestfile])) 	    break;i 	}     }a     finish_index (ostream);   5   /* Free all storage and close all input streams. */\     for (i = 0; i < nfiles; i++)     {o       fclose (streams[i]);       free (lb1[i].buffer);n       free (lb2[i].buffer);e     }    free (file_lossage);
   free (lb1);a
   free (lb2);    free (thisline);   free (prevline);   free (streams);l     if (outfile)     fclose (ostream);l     return lossage;l }s t$ /* Print error message and exit.  */   void fatal (s1, s2)      char *s1, *s2;e {    error (s1, s2);    exit (EXIT_FATAL); }t  J /* Print error message.  S1 is printf control string, S2 is arg for it. */   void error (s1, s2)      char *s1, *s2;e {p    printf ("%s: ", program_name);   printf (s1, s2);   printf ("\n"); }i   void perror_with_name (name)f      char *name; {t
   char *s;     if (errno < sys_nerr)o3     s = concat ("", sys_errlist[errno], " for %s");    else     s = "cannot open %s";    error (s, name); }s   void pfatal_with_name (name)e      char *name; { 
   char *s;     if (errno < sys_nerr)l3     s = concat ("", sys_errlist[errno], " for %s");    else     s = "cannot open %s";n   fatal (s, name); })  F /* Return a newly-allocated string whose contents concatenate those of    S1, S2, S3.  */   char * concat (s1, s2, s3)h      char *s1, *s2, *s3; {iA   int len1 = strlen (s1), len2 = strlen (s2), len3 = strlen (s3); ;   char *result = (char *) xmalloc (len1 + len2 + len3 + 1);n     strcpy (result, s1);   strcpy (result + len1, s2);d$   strcpy (result + len1 + len2, s3);%   *(result + len1 + len2 + len3) = 0;i     return result; }   E /* Just like malloc, but kills the program in case of fatal error. */; void * xmalloc (nbytes)      int nbytes; { (   void *temp = (void *) malloc (nbytes);  %   if (nbytes && temp == (void *)NULL) %     memory_error ("xmalloc", nbytes);*     return (temp); }*  > /* Like realloc (), but barfs if there isn't enough memory. */ void * xrealloc (pointer, nbytes)      void *pointer;       int nbytes; {(
   void *temp;l     if (!pointer)t$     temp = (void *)xmalloc (nbytes);   else-     temp = (void *)realloc (pointer, nbytes);o     if (nbytes && !temp)&     memory_error ("xrealloc", nbytes);     return (temp); }i  ) memory_error (callers_name, bytes_wanted)g      char *callers_name;      int bytes_wanted; {t   char printable_string[80];     sprintf (printable_string,; 	   "Virtual memory exhausted in %s ()!  Needed %d bytes.",x  	   callers_name, bytes_wanted);     error (printable_string);    abort ();t }    #ifndef STDC_HEADERS void bzero (b, length)l      register char *b;      register int length;. { 
 #ifdef VMS   short zero = 0;)   long max_str = 65535;!     while (length > max_str)     { :       (void) LIB$MOVC5 (&zero, &zero, &zero, &max_str, b);       length -= max_str;       b += max_str;      }(5   (void) LIB$MOVC5 (&zero, &zero, &zero, &length, b);r #else    while (length-- > 0)
     *b++ = 0;r #endif /* not VMS */ }i #endif /* not STDC_HEADERS */r