& /* info -- a stand-alone Info program.  :    Copyright (C) 1987, 1991 Free Software Foundation, Inc.  !    This file is part of GNU Info.   >    GNU Info is distributed in the hope that it will be useful,>    but WITHOUT ANY WARRANTY.  No author or distributor acceptsC    responsibility to anyone for the consequences of using it or for F    whether it serves any particular purpose or works at all, unless heE    says so in writing.  Refer to the GNU Emacs General Public License     for full details.  B    Everyone is granted permission to copy, modify and redistributeE    GNU Info, but only under the conditions described in the GNU Emacs B    General Public License.   A copy of this license is supposed toC    have been given to you along with GNU Emacs so you can know your F    rights and responsibilities.  It should be in a file named COPYING.C    Among other things, the copyright notice and this notice must be     preserved on all copies.  */    /* This is GNU Info:  D    Version 1.45  (Change "major_version" and "minor_version" below.)    Fri Feb  7 1992 */   #include <stdio.h> #include <sys/types.h> #include <sys/stat.h>  #include <signal.h>  #include <pwd.h> #include <errno.h>   #if !defined (errno) extern int errno;  #endif /* !errno */    #include <ctype.h> #include "getopt.h"    #if defined (hpux)
 #  define USG  #endif /* hpux */    #if defined (USG)     struct passwd *getpwnam (); #  include <fcntl.h> #  include <termio.h>  #  include <string.h>    #  if defined (USGr3)  #    if !defined (M_XENIX) #      include <sys/stream.h>  #      include <sys/ptem.h>  #      undef TIOCGETC  #    else /* M_XENIX */  #      define tchars tc  #      include <sys/ttold.h> #    endif /* M_XENIX */ #  endif /* USGr3 */@ #  define bcopy(source, dest, count) memcpy(dest, source, count)D    char *index(s,c) char *s; { char *strchr(); return strchr(s,c); }G    char *rindex(s,c) char *s; { char *strrchr(); return strrchr(s,c); }  #else /* !USG */ #  include <sys/file.h>  #  include <sgtty.h> #  include <strings.h> #endif /* USG */   #if !defined (DEFAULT_INFOPATH)  #  define DEFAULT_INFOPATH \B 	".:/usr/gnu/info:/usr/local/emacs/info:/usr/local/lib/emacs/info" #endif /* !DEFAULT_INFOPATH */   typedef struct nodeinfo {    char *filename;    char *nodename;    int pagetop;   int nodetop;   struct nodeinfo *next; } NODEINFO;    typedef struct indirectinfo {    char *filename;    int first_byte;  } INDIRECT_INFO;   typedef int Function (); #define VOID_SIGHANDLER  #if defined (VOID_SIGHANDLER)  #  define SigHandler void  #else  #  define SigHandler int #endif /* !VOID_SIGHANDLER */ . #define barf(msg) fprintf(stderr, "%s\n", msg)   /* Some character stuff. */ L #define control_character_threshold 0x020 /* smaller than this is control */F #define meta_character_threshold 0x07f	/* larger than this is Meta. */? #define control_character_bit 0x40	/* 0x000000, must be off. */ < #define meta_character_bit 0x080	/* x0000000, must be on. */  " #define info_separator_char '\037'# #define start_of_node_string "\037"    #ifdef CTRL  #undef CTRL  #endif  0 #define CTRL(c) ((c) & (~control_character_bit))* #define META(c) ((c) | meta_character_bit)  / #define UNMETA(c) ((c) & (~meta_character_bit)) 7 #define UNCTRL(c) to_upper(((c)|control_character_bit))    #ifndef to_upper? #define to_upper(c) (((c) < 'a' || (c) > 'z') ? (c) : (c) - 32) ? #define to_lower(c) (((c) < 'A' || (c) > 'Z') ? (c) : (c) + 32)  #endif  E #define CTRL_P(c) ((unsigned char) (c) < control_character_threshold) B #define META_P(c) ((unsigned char) (c) > meta_character_threshold)   #define NEWLINE '\n' #define RETURN CTRL('M') #define DELETE 0x07f #define TAB '\t' #define ABORT_CHAR CTRL('G') #define PAGE CTRL('L') #define SPACE 0x020  #define ESC CTRL('[') " #define control_display_prefix '^'  2 #define TAG_TABLE_END_STRING "\037\nEND TAG TABLE"- #define TAG_TABLE_BEG_STRING "\nTAG TABLE:\n"  #define NODE_ID "Node:" C #define NNODENAME 4		/* Default amount to grow nodename list by. */  #define FILENAME_LEN 256 #define NODENAME_LEN 256 #define STRING_SIZE 256 ! #define nodeend_sequence "\n\037"   1 #define whitespace(c) ((c) == ' ' || (c) == '\t') C #define cr_whitespace(c) ((c) == ' ' || (c) == '\t' || (c) == '\n')   $ /* All right, some windows stuff. */   typedef struct {G   /* Absolute x and y coordinates for usable portion of this window. */    int left, top, right, bottom; 0   /* Absolute cursor position in this window. */
   int ch, cv; 	 } WINDOW;    typedef struct _wind_list {    int left, top, right, bottom; 
   int ch, cv; !   struct _wind_list *next_window;  } WINDOW_LIST;  ) WINDOW the_window = {0, 0, 80, 24, 0, 0}; 0 WINDOW_LIST *window_stack = (WINDOW_LIST *)NULL;. WINDOW terminal_window = {0, 0, 80, 24, 0, 0};  8 /* Not really extern, but defined later in this file. */ extern WINDOW echo_area; void *xmalloc (), *xrealloc (); " SigHandler info_signal_handler ();8 char *getenv (), *next_info_file (), *opsys_filename ();% int build_menu (), find_menu_node (); ) void swap_filestack (), pop_filestack ();   6 /* A crock, this should be done in a different way. */ #define MAX_INDIRECT_FILES 100     /* The info history list. */ NODEINFO *Info_History = NULL;  : /* ?Can't have more than xx files in the indirect list? */0 INDIRECT_INFO indirect_list[MAX_INDIRECT_FILES];  5 /* The filename of the currently loaded info file. */ % char current_info_file[FILENAME_LEN];   6 /* The nodename of the node the user is looking at. */% char current_info_node[NODENAME_LEN];   H /* The last file actually loaded.  Not the same as current info file. */) char last_loaded_info_file[FILENAME_LEN];   B /* Offsets in info_file of top and bottom of current_info_node. */ int nodetop, nodebot;   # /* Number of lines in this node. */  int nodelines;   /* Buffer for the info file. */  char *info_file = NULL;   ! /* Length of the above buffer. */  int info_buffer_len;  @ /* Pointer to the start of a tag table, or NULL to show none. */ char *tag_table = NULL;   ! /* Length of the above buffer. */  int tag_buffer_len;		   4 /* Non-zero means that the tag table is indirect. */ int indirect = 0;  int indirect_top;   2 /* Offset in the buffer of the current pagetop. */ int pagetop;  ; /* Offset in the buffer of the last displayed character. */  int pagebot = 0;  G /* If non-NULL, this is a colon separated list of directories to search G    for a specific info file.  The user places this variable into his or     her environment. */ char *infopath = NULL;  0 /* If filled, the name of a file to write to. */! char dumpfile[FILENAME_LEN] = "";   G /* This is the command to print a node. A default value is compiled in, E    or it can be found from the environment as $INFO_PRINT_COMMAND. */  char *print_command;  H /* Non-zero means forst redisplay before prompt for the next command. */ int window_bashed = 0;  F /* **************************************************************** */ /*								    */ /*			Getting Started.			    */ /*								    */F /* **************************************************************** */   /* Begin the Info session. */   / /* Global is on until we are out of trouble. */  int totally_inhibit_errors = 1;   - /* Non-zero means print version info only. */  int version_flag = 0;   + /* The major and minor versions of Info. */  int major_version = 1; int minor_version = 45;     struct option long_options[] = {   { "directory", 1, 0, 'd' },    { "node", 1, 0, 'n' },   { "file", 1, 0, 'f' },   { "output", 1, 0, 'o' },%   { "version", 0, &version_flag, 1 },    {NULL, 0, NULL, 0} };  N #define savestring(x) (char *) strcpy ((char *) xmalloc (1 + strlen (x)), (x))   main (argc, argv)       int argc;      char **argv;  {    int c, ind, no_such_node = 0;    char filename[FILENAME_LEN];   char *nodename;    char **nodenames; &   int nodenames_size, nodenames_index;/   char *ptr, *env_infopath, *env_print_command;      nodenames_index = 0;I   nodenames = (char **) xmalloc ((nodenames_size = 1) * sizeof (char *));    nodenames[0] = (char *)NULL;  %   env_infopath = getenv ("INFOPATH"); 4   env_print_command = getenv ("INFO_PRINT_COMMAND");     filename[0] = '\0';e  $   if (env_infopath && *env_infopath))     infopath = savestring (env_infopath);d   else-     infopath = savestring (DEFAULT_INFOPATH);W  .   if (env_print_command && *env_print_command)3     print_command = savestring (env_print_command);s   else4     print_command = savestring (INFO_PRINT_COMMAND);  O   while ((c = getopt_long (argc, argv, "d:n:f:o:", long_options, &ind)) != EOF)r     {i0       if (c == 0 && long_options[ind].flag == 0) 	c = long_options[ind].val;m       switch (c) 	{ 	case 0:	 	  break;l 	  e
 	case 'd': 	  free (infopath); " 	  infopath = savestring (optarg);	 	  break;  	  i
 	case 'n':  , 	  if (nodenames_index + 2 > nodenames_size) 	    nodenames = (char **)F 	      xrealloc (nodenames, (nodenames_size += 10) * sizeof (char *));  ) 	  nodenames[nodenames_index++] = optarg;n- 	  nodenames[nodenames_index] = (char *)NULL; 	 	  break;  	   
 	case 'f':, 	  strncpy (filename, optarg, FILENAME_LEN);	 	  break;d 	  o
 	case 'o':, 	  strncpy (dumpfile, optarg, FILENAME_LEN);	 	  break;c 	  <	 	default:> 	  usage (); 	}     }   C   /* If the user specified `--version' then simply show the versionn#      info at this time and exit. */f   if (version_flag)c     {t!       show_version_info (stdout);        exit (0);      }   <   /* Okay, flags are parsed.  Get possible Info menuname. */  :   if (*filename && (ptr = rindex (filename,'/')) != NULL )     {u-       /* Add filename's directory to path. */i       char *temp;)  J       temp = (char *) xmalloc (2 + strlen (filename) + strlen (infopath));/       strncpy (temp, filename, ptr - filename); 9       sprintf (temp + (ptr - filename), ":%s", infopath);E       free (infopath);       infopath = temp;     }e  1   /* Start with DIR or whatever was specified. */xM   if (!get_node (filename, (nodenames[0] == NULL) ? "Top" : nodenames[0], 0))a     {        if (filename[0]) 	{0 	  fprintf (stderr, "Try just plain `info'.\n"); 	  exit (1); 	}
       else 	{ 	  strcpy (filename, "DIR");  1 	  if (!get_node ((char *)NULL, (char *)NULL, 1))  	    { 	      fprintf (stderr,i> 		       "%s: Cannot find \"%s\", anywhere along the search ", 		       argv[0], filename);8 	      fprintf (stderr, "path of\n\"%s\".\n", infopath); 	      exit (1); 	    } 	}     }      totally_inhibit_errors = 0;O  /   for (ind = 1 ; ind < nodenames_index ; ind++)a+     get_node (filename, nodenames[ind], 0);   F   nodename = nodenames[nodenames_index > 0 ? nodenames_index - 1 : 0];   if (!nodename)     {n1       nodename = (char *) xmalloc (NODENAME_LEN);f       *nodename = '\0';      }       if (optind != argc)%     {s       while (optind != argc) 	{ 	  if (!build_menu ())   	    {8 	      display_error ("There is no menu in node \"%s\"", 			     current_info_node ); 	      no_such_node++;
 	      break;o 	    }5 	  else if (!find_menu_node (argv[optind], nodename))  	    { 	      display_error6 		("There is no menu entry for \"%s\" in node \"%s\"", 		 argv[optind], nodename ); 	      no_such_node++;
 	      break;R 	    }2 	  else if (!get_node ((char *)NULL, nodename, 0)) 	    { 	      no_such_node++;
 	      break;  	    } 	  elsec  	    {( #if 1h@ 	      /* RMS says not to type this stuff out because he expects9 		 programs to call Info instead of interactive users. */ % 	      printf ("%s.. ",argv[optind]);n 	      fflush (stdout);  #endif 	      optind++; 	    } 	}     }d  I   /* If we are outputting to a file, and the node was not found, exit. */ "   if (no_such_node && dumpfile[0])
     exit (1);e   else     begin_info_session ();     exit (0);( })   usage () {E%   fprintf (stderr,"%s\n%s\n%s\n%s\n",_K "Usage: info [-d dir-path] [-f info-file] [-n node-name -n node-name ...]",LI "            [-o output-file] [--directory dir-path] [--file info-file]","B "            [--node node-name --node node-name ...] [--version]",: "            [--output output-file] [menu-selection...]");   exit (1);w }d  3 /* Print the version of info to standard output. */O show_version_info (stream)      FILE *stream; {oM   fprintf (stream, "GNU Info version %d.%d\n", major_version, minor_version);    fflush (stream); })   #if defined (SIGTSTP)t Function *old_tstp;  Function *old_ttou, *old_ttin; #endif /* SIGTSTP */   #if defined (SIGWINCH) Function *old_winch; #endif /* SIGWINCH */.   /* Start using Info. */t begin_info_session ()t {u>   /* If the user just wants to dump the node, then do that. */   if (dumpfile[0])     { #       dump_current_node (dumpfile);        exit (0);t     }i     init_terminal_io ();  ;   /* Install handlers for restoring/breaking the screen. */D     install_signals ();W   new_echo_area ();I  ;   print_string ("Welcome to Info!  Type \"?\" for help. ");x   close_echo_area (); 
   toploop ();/3   goto_xy (the_window.left, the_window.bottom + 1);o   restore_io (); }f  1 /* What to do before processing a stop signal. */e before_stop_signal (); {n   restore_io (); }_  0 /* What to do after processing a stop signal. */ after_stop_signal () {s   clear_screen ();   display_page ();)   goto_xy (the_window.ch, the_window.cv);i   opsys_init_terminal ();N }*  * /* Do the right thing with this signal. */
 SigHandler info_signal_handler (sig)N
      int sig;i {t   switch (sig)     {S #if defined (SIGTSTP)f     case SIGTSTP:e     case SIGTTOU:h     case SIGTTIN:e       before_stop_signal ();       signal (sig, SIG_DFL); #if !defined (USG)1       sigsetmask (sigblock (0) & ~sigmask (sig));i #endif /* !USG */        kill (getpid (), sig);       after_stop_signal ();f(       signal (sig, info_signal_handler);       break; #endif /* SIGTSTP */   #if defined (SIGWINCH)     case SIGWINCH:M       /* Window has changed.  Get the size of the new window, and rebuild our.          window chain. */L       {L 	int display_page ();e 	extern char *widest_line; 	extern WINDOW terminal_window;t" 	extern WINDOW_LIST *window_stack;, 	extern int terminal_rows, terminal_columns;. 	int delta_width, delta_height, right, bottom;  ! 	right = get_terminal_columns ();n 	bottom = get_terminal_rows ();n  ( 	delta_width = right - terminal_columns;' 	delta_height = bottom - terminal_rows;    	terminal_columns = right; 	terminal_rows = bottom;  + 	/* Save current window, whatever it is. */s 	push_window ();  + 	/* Change the value of the widest_line. */e 	free (widest_line);( 	widest_line = (char *) xmalloc (right);  A 	/* Make the new window.  Map over all windows in window list. */e 	{$ 	  WINDOW_LIST *wind = window_stack;! 	  extern WINDOW modeline_window;t  & 	  while (wind != (WINDOW_LIST *)NULL) 	    {? 	      adjust_wind ((WINDOW *)wind, delta_width, delta_height);R  	      wind = wind->next_window; 	    }  5 	  /* Adjust the other windows that we know about. */e= 	  adjust_wind (&terminal_window, delta_width, delta_height);*7 	  adjust_wind (&echo_area, delta_width, delta_height);	= 	  adjust_wind (&modeline_window, delta_width, delta_height);* 	}  6 	/* Clear and redisplay the entire terminal window. */ 	set_window (&terminal_window);. 	clear_screen ();s  , 	/* Redisplay the contents of the screen. */8 	with_output_to_window (&terminal_window, display_page);  # 	/* Get back the current window. */  	pop_window ();d       }r       break; #endif /* SIGWINCH */        case SIGINT:       restore_io ();       exit (1);s       break;     }y }1   install_signals () {  #if defined (SIGTSTP)"@   old_tstp = (Function *) signal (SIGTSTP, info_signal_handler);@   old_ttou = (Function *) signal (SIGTTOU, info_signal_handler);@   old_ttin = (Function *) signal (SIGTTIN, info_signal_handler); #endif /* SIGTSTP */   #if defined (SIGWINCH)B   old_winch = (Function *) signal (SIGWINCH, info_signal_handler); #endif /* SIGWINCH */   '   signal (SIGINT, info_signal_handler);e }o  - adjust_wind (wind, delta_width, delta_height)p      WINDOW *wind;#      int delta_width, delta_height;c {    wind->right += delta_width;1   wind->bottom += delta_height;e   wind->ch += delta_width;   wind->cv += delta_height;H  J   /* Ugly hack to fix busted windows code.  If the window we are adjusting8      already has a TOP offset, then adjust that also. */   if (wind->top)     wind->top += delta_height; }h  F /* **************************************************************** */ /*								    */ /*			Completing Things			    */n /*								    */F /* **************************************************************** */   typedef struct completion_entry: {l   char *identifier;=
   char *data;     struct completion_entry *next; }                COMP_ENTRY;  ? /* The linked list of COMP_ENTRY structures that you create. */c2 COMP_ENTRY *completion_list = (COMP_ENTRY *) NULL;  > /* The vector of COMP_ENTRY pointers that COMPLETE returns. */  COMP_ENTRY **completions = NULL;  1 /* The number of elements in the above vector. */d int completion_count;z  ( /* Initial size of COMPLETIONS array. */) #define INITIAL_COMPLETIONS_CORE_SIZE 200d  3 /* Current size of the completion array in core. */s int completions_core_size = 0;  3 /* Ease the typing task.  Another name for the I'thp     IDENTIFIER of COMPLETIONS. */9 #define completion_id(i) ((completions[(i)])->identifier)I  @ /* The number of completions that can be present before the help@    function starts asking you about whether it should print them    all or not. */f% int completion_query_threshold = 100;    free_completion_list ()e {    COMP_ENTRY *temp;u   while (completion_list)      {        temp = completion_list;L  &       if (completion_list->identifier)$ 	free (completion_list->identifier);          if (completion_list->data) 	free (completion_list->data);  .       completion_list = completion_list->next;       free (temp);     }m }   . /* Add a single completion to COMPLETION_LIST.6    IDENTIFIER is the string that the user should type.E    DATA should just be a pointer to some random data that you wish tooG    have associated with the identifier, but I'm too stupid for that, soaI    it must be a string as well.  This allocates the space for the strings '    so you don't necessarily have to. */"! add_completion (identifier, data))      char *identifier, *data;{ { B   COMP_ENTRY *temp = (COMP_ENTRY *) xmalloc (sizeof (COMP_ENTRY));  @   temp->identifier = (char *) xmalloc (strlen (identifier) + 1);(   strcpy (temp->identifier, identifier);  4   temp->data = (char *) xmalloc (strlen (data) + 1);   strcpy (temp->data, data);     temp->next = completion_list;    completion_list = temp;e }e  G /* Function for reading a line.  Supports completion on COMPLETION_LISTxD    if you pass COMPLETING as non-zero.  Prompt is either a prompt orA    NULL, LINE is the place to store the characters that are read.iE    LINE may start out already containing some characters; if so, theyeB    are printed.  MAXCHARS tells how many characters can fit in theB    buffer at LINE.  readline () returns zero if the user types theL    abort character.  LINE is returned with a '\0' at the end, not a '\n'. */ int - readline (prompt, line, maxchars, completing)f      char *prompt, *line;       int maxchars;      int completing; {n   int character;   int readline_ch, readline_cv;d"   int current_len = strlen (line);@   int just_completed = 0;		/* Have we just done a completion? */   int meta_flag = 0;     new_echo_area ();t  
   if (prompt)a      print_string ("%s", prompt);     readline_ch = the_window.ch;   readline_cv = the_window.cv;     print_string ("%s", line);     while (1)f     {        line[current_len] = '\0'; )       goto_xy (readline_ch, readline_cv);e        print_string ("%s", line);       clear_eol ();u         if (just_completed)  	just_completed--;  "       character = blink_cursor ();       if (meta_flag) 	{  	  character = META (character); 	  meta_flag = 0;[ 	}         if (META_P (character))a2 	character = META (to_upper (UNMETA (character)));         switch (character) 	{
 	case EOF: 	  character = '\n';  
 	case ESC: 	  meta_flag++;o	 	  break;    	case META (DELETE): 	case CTRL ('W'):o4 	  while (current_len && line[current_len] == SPACE) 	    current_len--;u   	  if (!current_len) 	    break;   4 	  while (current_len && line[current_len] != SPACE) 	    current_len--;r  	 	  break;e   	case CTRL ('U'):t 	  current_len = 0;i	 	  break;P   	case '\b':l 	case 0x07f: 	  if (current_len)t 	    current_len--;T 	  elsei
 	    ding ();I	 	  break;i   	case '\n':  	case '\r':W 	  if (completing) 	    {# 	      extern int completion_count;    	      try_complete (line);d  ! 	      if (completion_count >= 1)( 		{i 		  close_echo_area ();p 		  return (1);m 		}) 	      elset 		{t  		  current_len = strlen (line);
 		  break; 		}h 	    } 	  elser 	    { 	      close_echo_area (); 	      return (1); 	    }   	case ABORT_CHAR:n 	  ding ();l   	  if (current_len)\ 	    { 	      current_len = 0;e 	    } 	  else  	    { 	      close_echo_area (); 	      clear_echo_area (); 	      return (0); 	    }	 	  break;e  
 	case ' ': 	case '\t':*
 	case '?': 	  if (completing) 	    {# 	      extern int completion_count;r  . 	      if (character == '?' || just_completed) 		{ % 		  help_possible_completions (line); 
 		  break; 		}o 	      elsed 		{)! 		  char temp_line[NODENAME_LEN];  		  strcpy (temp_line, line);i, 		  try_complete (line); just_completed = 2;4 		  if (completion_count != 1 && character == SPACE) 		    { * 		      if (strcmp (temp_line, line) == 0) 			{ 			  line[current_len] = SPACE;e" 			  line[current_len + 1] = '\0'; 			  strcpy (temp_line, line); 			  try_complete (line);( 			  if (completion_count == 0)  			    {" 			      line[current_len] = '\0'; 			      ding ();) 			    } 			} 		    }f  		  current_len = strlen (line); 		  if (completion_count == 0) 		    ding ();
 		  break; 		}: 	    }? 	  /* Do *NOT* put anything in-between the completing cases andl? 	     the default: case.  No.  Because the SPC, TAB and `?' get)9 	     treated as normal characters by falling through thed& 	     "if (completing)" test above. */	 	default:n 	  if (!CTRL_P (character) &&n 	      !META_P (character) &&g 	      current_len < maxchars)% 	    line[current_len++] = character;_ 	  elser
 	    ding ();l 	}     }r }t  1 /* Initialize whatever the completer is using. */a init_completer ()a {o=   if (completions_core_size != INITIAL_COMPLETIONS_CORE_SIZE)n     {a       if (completions) 	free (completions);  #       completions = (COMP_ENTRY **)f! 	xmalloc ((sizeof (COMP_ENTRY *))(> 		 * (completions_core_size = INITIAL_COMPLETIONS_CORE_SIZE));     }o   completion_count = 0;{ }   2 /* Reverse the completion list passed in LIST, and'    return a pointer to the new head. */N COMP_ENTRY * reverse_list (list)j      COMP_ENTRY *list; {e   COMP_ENTRY *next;h)   COMP_ENTRY *prev = (COMP_ENTRY *) NULL;      while (list)     {h       next = list->next;       list->next = prev;       prev = list;       list = next;     }    return (prev); }_  < /* Remember the possible completion passed in POINTER on the    completions list. */h remember_completion (pointer)e      COMP_ENTRY *pointer;  {d0   if (completion_count == completions_core_size)     {))       COMP_ENTRY **temp = (COMP_ENTRY **)e/ 	realloc (completions, ((sizeof (COMP_ENTRY *)) % 			       * (completions_core_size +=e' 				  INITIAL_COMPLETIONS_CORE_SIZE)));r       if (!temp) 	{= 	  display_error ("Too many completions (~d)!  Out of core!",  			 completion_count);
 	  return; 	}
       else 	completions = temp;     }G,   completions[completion_count++] = pointer; },  ? /* Complete TEXT from identifiers in LIST.  Place the resultanti?    completions in COMPLETIONS, and the number of completions ini<    COMPLETION_COUNT. Modify TEXT to contain the least common/    denominator of all the completions found. */C intf complete (text, list)d      char *text;      COMP_ENTRY *list; {s   int low_match, i, idx;$   int string_length = strlen (text);     init_completer ();/   low_match = 100000;		/* Some large number. */i     while (list)     {1@       if (strnicmp (text, list->identifier, string_length) == 0) 	remember_completion (list);       list = list->next;     }o     if (completion_count == 0)     return (0);r     if (completion_count == 1)     {				/* One completion */o'       strcpy (text, completion_id (0));        return (1);*     }*  .   /* Else find the least common denominator */  
   idx = 1;      while (idx < completion_count)     {        int c1, c2;*       for (i = 0;*3 	   (c1 = to_lower (completion_id (idx - 1)[i])) &&t- 	   (c2 = to_lower (completion_id (idx)[i]));  	   i++) 	if (c1 != c2)	 	  break;r         if (low_match > i) 	low_match = i;T       idx++;     }P  /   strncpy (text, completion_id (0), low_match);*   text[low_match] = '\0';R
   return (1);* }e  F /* Complete TEXT from the completion structures in COMPLETION_LIST. */ into try_complete (text)n      char *text; {t,   return (complete (text, completion_list)); }*  < /* The function that prints out the possible completions. */  help_possible_completions (text)      char *text; {    char temp_string[2000];p  ,   goto_xy (the_window.left, the_window.top);   strcpy (temp_string, text);    try_complete (temp_string);/     open_typeout ();     if (completion_count == 0)     { <       print_string ("There are no possible completions.\n");       goto print_done;     }      if (completion_count == 1)     {        print_stringA 	("The only possible completion of what you have typed is:\n\n"); ,       print_string ("%s", completion_id(0));       goto print_done;     }m  5   if (completion_count >= completion_query_threshold)      {c       print_stringD 	("\nThere are %d completions.  Do you really want to see them all", 	 completion_count);         if (!get_y_or_n_p ())x 	return;     }e  G   print_string ("\nThe %d completions of what you have typed are:\n\n",T 		completion_count);     {u     int idx = 0;     int counter = 0;<     int columns = (the_window.right - the_window.left) / 30;  "     while (idx < completion_count)       {f 	if (counter == columns) 	  { 	    charout ('\n'); 	    counter = 0;o 	  } 	indent_to (counter * 30);* 	print_string ("%s", completion_id (idx)); 	counter++;) 	idx++;a       }f   }*   print_done:O+   print_string ("\n\n-----------------\n");o   close_typeout ();  }p  M /* Return the next file that should be searched, or NULL if we are at the endiN    of the info file. If the FILE argument is provided, begin the search there,G    if REWIND is non-zero start the search at the beginning of the list.n  I    The list is the one built by an indirect tag table, on the supposition J    that those files form a logical set to search if we are in one of them.H    If no such list is current (either it doesn't exist, or FILE isn't on<    it) the search list is set to be last_loaded_info_file */ char * next_info_file (file, rewind)R;      char *file;		/* file to set `next' to. May be NULL. */.7      int rewind;		/* should I rewind the file list?  */t {a   static int index = -1;     if (file != NULL)      {\$       char *ptr = rindex (file,'/');         if (ptr != NULL) 	file = ptr + 1;         for (index = 0;;! 	   index < MAX_INDIRECT_FILES &&h2 	   indirect_list[index].filename != (char *)NULL; 	   index++) 	{9 	  if (strcmp (file, indirect_list[index].filename) == 0)  	    return (file);  	}  E       /* OK, we are not on the current indirect_list. This means that%= 	 we have switched to another node that has no indirect list,  	 so forget the old one. */i       for (index = 0;h! 	   index < MAX_INDIRECT_FILES &&t2 	   indirect_list[index].filename != (char *)NULL; 	   index++) 	{( 	  free (indirect_list[index].filename);0 	  indirect_list[index].filename = (char *)NULL; 	}=       return (indirect_list[0].filename = savestring (file));      }a   else if (rewind)     {        index = 0;  4       if (indirect_list[0].filename == (char *)NULL)@ 	indirect_list[0].filename = savestring (last_loaded_info_file);     }O   else     index++;   #   if (index < MAX_INDIRECT_FILES &&e4       indirect_list[index].filename != (char *)NULL)+     return (indirect_list[index].filename);C  
   index = -1;l   return (NULL); }r  F /* **************************************************************** */ /*								    */ /*			Getting Nodes				    */ /*								    */F /* **************************************************************** */   /* A node name looks like:.    Node: nodename with spaces but not a comma,3 or Node: (filename-containing-node)node-within-file  or Node: (filename)e  >    The latter case implies a nodename of "Top".  All files are    supposed to have one.  C    Lastly, the nodename specified could be "*", which specifies the     entire file. */  H /* Return the directory portion of FILENAME, i.e., everything before the    last slash. */ 
 static char *  file_directory (filename)       char *filename; {n   register char *scan;   register int length;   char *result;      scan = filename;     while (*scan++ != '\0');     while (1)      {        if (scan == filename): 	break;\         if ((*--scan) == '/')t 	{
 	  scan++;	 	  break;  	}     }i     length = scan - filename;t)   result = (char *) xmalloc (length + 1);p%   strncpy (result, filename, length);a   result[length] = '\0';     return (result); }D  E /* Given FILENAME and DIRECTORY return a newly allocated string whichsG    is either the two concatenated, or simply FILENAME if it is absolute	    already. */
 static char *p% file_absolutize (filename, directory)r       char *filename, *directory; {_+   register int filename_len, directory_len;e   char *result;l     if (filename[0] == '/')t#     return (savestring (filename));l  #   filename_len = strlen (filename); %   directory_len = strlen (directory);r?   result = (char *) xmalloc (directory_len + filename_len + 1);i     strcpy (result, directory);    strcat (result, filename);     return (result); }a  B /* Load FILENAME.  If REMEMBER_NAME is non-zero, then remember theB    loaded filename in CURRENT_INFO_FILE.  In either case, remember5    the name of this file in LAST_LOADED_INFO_FILE. */  intL' get_info_file (filename, remember_name)c      char *filename;      int remember_name;l {[   FILE *input_stream;t   struct stat file_info;   int pointer, result;   char tempname[FILENAME_LEN];     /* Get real filename. *//   strcpy (tempname, opsys_filename (filename));I  I   /* If the file doesn't exist, try again with the name in lower case. */s'   result = stat (tempname, &file_info);f     if (result < 0)C     {R       register int i;n       char *lowered_name;E  =       lowered_name = (char *)xmalloc (1 + strlen (filename));v  @       for (i = 0; lowered_name[i] = to_lower (filename[i]); i++) 	;  7       strcpy (tempname, opsys_filename (lowered_name));M+       result = stat (tempname, &file_info);O     }Y  0   /* See if this file is the last loaded one. */A   if (!result && (strcmp (last_loaded_info_file, tempname) == 0))v     return (1);i  !   /* Now try to open the file. */ ?   if (result || (input_stream = fopen (tempname, "r")) == NULL)e     {m       file_error (tempname);       return (0);e     }C  =   /* If we already have a file loaded, then free it first. */o   if (info_file)     {O       free (info_file);N         if (!indirect) 	{4 	  /* Then the tag table is also no longer valid. */ 	  tag_table = (char *) NULL;_ 	}     }_  8   /* Read the contents of the file into a new buffer. */  E   info_file = (char *) xmalloc (info_buffer_len = file_info.st_size);r6   fread (info_file, 1, info_buffer_len, input_stream);   fclose (input_stream);+   strcpy (last_loaded_info_file, tempname);n   if (remember_name)     {e+       strcpy (current_info_file, tempname);t       if (indirect)o 	{ 	  int idx;T 	  indirect = 0; 	  free (tag_table); 	}     }    else     return (1);   <   /* Force redisplay, since we are looking at a new file. */   window_bashed = 1;  A   /* The file has been read, and we don't know anything about it.(,      Find out if it contains a tag table. */  '   tag_table = NULL;		/* assume none. */l   indirect = 0;    tag_buffer_len = 0;t  6   set_search_constraints (info_file, info_buffer_len);  -   /* Go to the last few lines in the file. */ ,   pointer = back_lines (8, info_buffer_len);;   pointer = search_forward (TAG_TABLE_END_STRING, pointer);*     if (pointer > -1)      {i:       /* Then there is a tag table.  Find the start of it, 	 and remember that. */o@       pointer = search_backward (TAG_TABLE_BEG_STRING, pointer);  1       /* Handle error for malformed info file. */w       if (pointer < 0)1 	display_error ("Start of tag table not found!");x
       else 	{F 	  /* No problem.  If this file is an indirect file, then the contentsF 	     of the tag table must remain in RAM the entire time.  Otherwise,H 	     we can flush the tag table with the file when the file is flushed.C 	     So, if indirect, remember that, and copy the table to anotherp 	     place.*/  3 	  int indirect_check = forward_lines (2, pointer);n  # 	  tag_table = info_file + pointer;i. 	  tag_buffer_len = info_buffer_len - pointer;  ( 	  /* Shorten the search constraints. */ 	  info_buffer_len = pointer;   3 	  if (looking_at ("(Indirect)\n", indirect_check))( 	    {: 	      /* We have to find the start of the indirect file's 		 information. */5 	      tag_table = (char *) xmalloc (tag_buffer_len);a  E 	      bcopy (&info_file[indirect_check], tag_table, tag_buffer_len);(  ( 	      /* Find the list of filenames. */F 	      indirect_top = search_backward ("Indirect:\n", indirect_check); 	      if (indirect_top < 0) 		{e 		  free (tag_table);o 		  tag_table = (char *) NULL;= 		  display_error ("Start of INDIRECT tag table not found!");r 		  return (0);T 		}a  < 	      /* Remember the filenames, and their byte offsets. */ 	      {. 		/* Index into the filename/offsets array. */ 		int idx, temp_first_byte;T# 		char temp_filename[FILENAME_LEN];p. 		char *directory = file_directory (tempname);  ! 		info_buffer_len = indirect_top;   : 		/* For each line, scan the info into globals.  Then save> 	           the information in the INDIRECT_INFO structure. */  + 		for (idx = 0; idx < MAX_INDIRECT_FILES &&t4 		     indirect_list[idx].filename != (char *) NULL;
 		     idx++)l   		  {(* 		     free (indirect_list[idx].filename);3 		     indirect_list[idx].filename = (char *) NULL;- 		  }) 		@ 		for (idx = 0;info_file[indirect_top] != info_separator_char &&! 		     idx < MAX_INDIRECT_FILES;)  		  { 5 		    indirect_top = forward_lines (1, indirect_top);g9 		    if (info_file[indirect_top] == info_separator_char)a 		      break;   		    /* Ignore blank lines. */s* 		    if (info_file[indirect_top] == '\n') 		      continue;   / 		    sscanf (&info_file[indirect_top], "%s%d",e( 			    temp_filename, &temp_first_byte);  ! 		    if (strlen (temp_filename))r	 		      { 4 			temp_filename[strlen (temp_filename) - 1] = '\0';  			indirect_list[idx].filename =0 			  file_absolutize (temp_filename, directory);3 			indirect_list[idx].first_byte = temp_first_byte;o	 			idx++;d	 		      }i 		  }t   		free (directory);x   		/* Terminate the table. */  		if (idx == MAX_INDIRECT_FILES) 		  {' 		    display_error=? 		      ("Sorry, the INDIRECT file array isn't large enough.");A 		    idx--; 		  } . 		indirect_list[idx].filename = (char *) NULL; 	      } 	      indirect = 1; 	   } else { 	      ; 	   }. 	}     }=
   return (1);r }f  B /* Make current_info_node be NODENAME.  This could involve loadingB    a file, etc.  POPPING is non-zero if we got here because we are    popping one level. */ int & get_node (filename, nodename, popping)      char *nodename, *filename;       int popping;] {l   int pointer;'   char internal_filename[FILENAME_LEN];c'   char internal_nodename[NODENAME_LEN];t     if (nodename && *nodename)     { M       /* Maybe nodename looks like: (filename)nodename, or worse: (filename). )          If so, extract the stuff out. */        if (*nodename == '(')  	{ 	  register int temp = 1;t 	  char character;    	  filename = internal_filename;  ; 	  while ((character = nodename[temp]) && character != ')')& 	    {& 	      filename[temp - 1] = character; 	      temp++; 	    }   	  if (character)l 	    {! 	      filename[temp - 1] = '\0';;* 	      temp++;		/* skip the closing ')' */ 	    }  9 	  /* We have the filename now.  The nodename follows. */d 	  internal_nodename[0] = '\0';*  " 	  while (nodename[temp] == ' ' || 		 nodename[temp] == '\t' || 		 nodename[temp] == '\n') 	    temp++;   	  if (nodename[temp]) 	    { 	      register int tem1 = 0;n  ; 	      while (internal_nodename[tem1++] = nodename[temp++])  		;i 	    } 	  else if (*filename != '\0')& 	    strcpy (internal_nodename,"Top");    	  nodename = internal_nodename; 	}     }p     if (!popping)tG     push_node (current_info_file, current_info_node, pagetop, nodetop);h     if (!nodename || !*nodename)     {c#       nodename = internal_nodename;        strcpy (nodename, "Top");t     }      if (!filename || !*filename)     {e#       filename = internal_filename;l+       strcpy (filename, current_info_file);      }f     if (!*filename)      strcpy (filename, "DIR");   #   if (!get_info_file (filename, 1))}     goto node_not_found;  "   if (strcmp (nodename, "*") == 0)     {l7       /* The "node" that we want is the entire file. */e       pointer = 0;       goto found_node;     }*   K   /* If we are using a tag table, see if we can find the nodename in it. */r   if (tag_table)     { 5       pointer = find_node_in_tag_table (nodename, 0);t       if (pointer < 1) 	{ 	  int pop_node ();r  8 	  /* The search through the tag table failed.  Maybe we; 	     should try searching the buffer?  Nahh, just barf. */0 	node_not_found: 	  if (popping)(+ 	    return (0);	/* Second time through. */n   	  {0 	     int save_inhibit = totally_inhibit_errors;  ! 	     totally_inhibit_errors = 0;l 	     display_error E 	       ("Sorry, unable to find the node \"%s\" in the file \"%s\".",( 		nodename, filename);, 	     totally_inhibit_errors = save_inhibit; 	  }   	  current_info_file[0] = '\0';N 	  current_info_node[0] = '\0';e# 	  last_loaded_info_file[0] = '\0';TG 	  pop_node (internal_filename, internal_nodename, &nodetop, &pagetop); 6 	  get_node (internal_filename, internal_nodename, 1); 	  return (0); 	}  7       /* Otherwise, the desired location is right here.n$          Scarf the position byte. */*       while (tag_table[pointer] != '\177') 	pointer++;)  7       sscanf (&tag_table[pointer + 1], "%d", &pointer);m  H       /* Okay, we have a position pointer.  If this is an indirect file,D          then we should look through the indirect_list for the firstH          element.first_byte which is larger than this.  Then we can load(          the specified file, and win. */       if (indirect)  	{) 	  /* Find the filename for this node. */e 	  int idx; , 	  for (idx = 0; idx < MAX_INDIRECT_FILES &&< 	       indirect_list[idx].filename != (char *) NULL; idx++) 	    {3 	      if (indirect_list[idx].first_byte > pointer)v 		{  		  /* We found it. */
 		  break; 		}f 	    }; 	  if (!get_info_file (indirect_list[idx - 1].filename, 1))U 	    goto node_not_found;r0 	  pointer -= indirect_list[idx - 1].first_byte;  G 	  /* Here is code to compensate for the header of an indirect file. */) 	  {" 	    int tt = find_node_start (0); 	    if (tt > -1){ 	      pointer += tt;b 	  } 	}
       else 	{A 	  /* This tag table is *not* indirect.  The filename of the fileo@ 	     containing this node is the same as the current file.  The 	     line probably looks like:i* 	     File: info,  Node: Checking25796 */ 	}     }    else     {  #if defined (NOTDEF)B       /* We don't have a tag table.  The node can only be found by1          searching this file in its entirety.  */m'       if (!get_info_file (filename, 1))x 	return (0); #endif /* NOTDEF */t       pointer = 0;     }   G   /* Search this file, using pointer as a good guess where to start. */eK   /* This is the same number that RMS used.  It might be right or wrong. */a   pointer -= 1000;   if (pointer < 0)     pointer = 0;  2   pointer = find_node_in_file (nodename, pointer);   if (pointer < 0)     goto node_not_found;  F   /* We found the node in its file.  Remember exciting information. */   found_node:e   back_lines (0, pointer);   nodetop = pagetop = pointer;'   strcpy (current_info_node, nodename);T'   strcpy (current_info_file, filename);    get_node_extent ();h
   return (1);b }   D /* Get the bounds for this node.  NODETOP points to the start of theC    node. Scan forward looking for info_separator_char, and remembero    that in NODEBOT. */ get_node_extent () {    int idx = nodetop;   int character;>   int do_it_till_end = (strcmp (current_info_node, "*") == 0);     nodelines = 0;   again:#   while ((idx < info_buffer_len) && 8 	 ((character = info_file[idx]) != info_separator_char))     {e       if (character == '\n')
 	nodelines++;s       idx++;     }d/   if (do_it_till_end && idx != info_buffer_len)e     {        idx++;       goto again;c     }w   nodebot = idx; })  C /* Locate the start of a node in the current search_buffer.  ReturnfE    the offset to the node start, or minus one.  START is the place in_,    the file at where to begin the search. */ find_node_start (start)h      int start;  { 8   return (search_forward (start_of_node_string, start)); }r  ! /* Find NODENAME in TAG_TABLE. */*) find_node_in_tag_table (nodename, offset)y      char *nodename;      int offset; {g   int temp;(  5   set_search_constraints (tag_table, tag_buffer_len);r     temp = offset;   while (1)e     { .       offset = search_forward (NODE_ID, temp);         if (offset < 0)) 	return (offset);   9       temp = skip_whitespace (offset + strlen (NODE_ID));l  H       if (strnicmp (tag_table + temp, nodename, strlen (nodename)) == 0) 	{ 	  register char character;   7 	  character = *(tag_table + temp + strlen (nodename));   / 	  if (character == '\177' || character == ',')M 	    return (temp);e 	}     }e }r  ! /* Find NODENAME in INFO_FILE. */e$ find_node_in_file (nodename, offset)      char *nodename;      int offset; {    int temp, last_offset = -1;t  6   set_search_constraints (info_file, info_buffer_len);     while (1)S     {	(       offset = find_node_start (offset);          if (offset == last_offset)
 	offset = -1;d
       else 	last_offset = offset;         if (offset < 0)e 	return (offset); 
       else" 	temp = forward_lines (1, offset);         if (temp == offset) 9 	return (-1);		/* At last line now, just a node start. */t
       else 	offset = temp;c  .       temp = string_in_line (NODE_ID, offset);         if (temp > -1) 	{4 	  temp = skip_whitespace (temp + strlen (NODE_ID));E 	  if (strnicmp (info_file + temp, nodename, strlen (nodename)) == 0)i 	    {A 	      int check_exact = *(info_file + temp + strlen (nodename));   ! 	      if (check_exact == '\t' ||  		  check_exact == ',' ||e 		  check_exact == '.' ||] 		  check_exact == '\n') 		return (offset); 	    } 	}     }( }p    F /* **************************************************************** */ /*								    */+ /*		    Dumping and Printing Nodes			    */* /*								    */F /* **************************************************************** */  J /* Make a temporary filename based on STARTER and the PID of this Info. */ char * make_temp_filename (starter)      char *starter;  {    register int i; 
   char *temp;e  2   temp = (char *) xmalloc (strlen (starter) + 10);.   sprintf (temp, "%s-%d", starter, getpid ());     for (i = 0; temp[i]; i++),     if (!isalnum (temp[i]))        temp[i] = '-';     return (temp); }v  0 /* Delete a file.  Print errors if necessary. */ deletefile (filename)*      char *filename; {i   if (unlink (filename) != 0)r     {a       file_error (filename);       return (1);a     }N
   return (0);  }(   printfile (filename)      char *filename; {dN   int length = strlen (print_command) + strlen (filename) + strlen ("\n") + 1;,   char *command = (char *) xmalloc (length);   int error;  6   display_error ("Printing file `%s'...\n", filename);6   sprintf (command, "%s %s", print_command, filename);   error = system (command);'   if (error)1     display_error ("Can't invoke `%s'", command);;   free (command);c   return (error);  }   4 /* Dump the current node into a file named FILENAME.2    Return 0 if the dump was successful, otherwise,    print error and exit. */w dump_current_node (filename)      char *filename; {o   int c, i = nodetop;    FILE *output_stream;  "   if (strcmp (filename, "-") == 0)     output_stream = stdout;e   else*     output_stream = fopen (filename, "w");  %   if (output_stream == (FILE *) NULL)e     {m       file_error (filename);       return (1);0     }   ,   while (i < nodebot && i < info_buffer_len)     {e       c = info_file[i];p/       if (CTRL_P (c) && !(index ("\n\t\f", c)))_ 	{ 	  putc ('^', output_stream);o 	  c = UNCTRL (c); 	}  )       if (putc (c, output_stream) == EOF)i 	{ 	  if (output_stream != stdout)e 	    fclose (output_stream);   	  file_error (filename);  	  return (1); 	}
       i++;     }e     if (output_stream != stdout)     fclose (output_stream);f  
   return (0);  }t  F /* **************************************************************** */ /*								    */# /*			 Toplevel eval loop. 			    */  /*								    */F /* **************************************************************** */   #define MENU_HEADER "\n* Menu:"* #define MENU_ID "\n* " #define FOOTNOTE_HEADER "*Note"n  0 /* Number of items that the current menu has. */ int the_menu_size = 0;  6 /* The node that last made a menus completion list. */" char menus_nodename[NODENAME_LEN];" char menus_filename[NODENAME_LEN];   static int search_start = 0;  A /* The default prompt string for the Follow Reference command. */ & char *visible_footnote = (char *)NULL;
 toploop () {    int done, inhibit_display;   int command, last_command;2   int last_pointer, count, new_ypos, last_pagetop;   char nodename[NODENAME_LEN];     done = inhibit_display = 0;    command = last_command = 0;o   new_ypos = last_pagetop = -1;i     while (!done)e     {_       if (!inhibit_display &&f0 	  (window_bashed || (pagetop != last_pagetop))) 	display_page ();   *       inhibit_display = window_bashed = 0;       last_pagetop = pagetop;t  E       nodename[0] = '\0';	/* Don't display old text in input line. */h         last_command = command;i         if (last_command == 'S') 	cursor_to (search_start);
       else) 	goto_xy (echo_area.left, echo_area.top);s          command = blink_cursor ();       clear_echo_area ();a         if (command == EOF). 	{ 	  done = 1; 	  continue; 	}#       command = to_upper (command);i         switch (command) 	{
 	case 'D':+ 	  get_node ((char *) NULL, "(dir)Top", 0);n	 	  break;d  
 	case 'H':1 	  if ((the_window.bottom - the_window.top) < 24) < 	    get_node ((char *) NULL, "(info)Help-Small-Screen", 0); 	  elsed/ 	    get_node ((char *) NULL, "(info)Help", 0);e	 	  break;]  
 	case 'N': 	  if (!next_node ())  	    {0 	      display_error ("No NEXT for this node!"); 	      inhibit_display = 1;/ 	    }	 	  break;   
 	case 'P': 	  if (!prev_node ())c 	    {0 	      display_error ("No PREV for this node!"); 	      inhibit_display = 1;[ 	    }	 	  break;;  
 	case 'U': 	  { 	    int savetop = pagetop;e   	    if (!up_node ())) 	      {) 		display_error ("No UP for this node!");t 		inhibit_display = 1; 		pagetop = savetop; 	      } 	    break;s 	  }  
 	case 'M': 	  if (!build_menu ()) 	    {/ 	      display_error ("No menu in this node!");h 	      inhibit_display = 1;i
 	      break;k 	    }  < 	  if (!readline ("Menu item: ", nodename, NODENAME_LEN, 1)) 	    { 	      clear_echo_area (); 	      inhibit_display = 1;e
 	      break;  	    }  - 	  I_goto_xy (echo_area.left, echo_area.top);i, 	  if (!find_menu_node (nodename, nodename)) 	    {> 	      display_error ("\"%s\" is not a menu item!", nodename); 	      inhibit_display = 1;g
 	      break;o 	    }  - 	  if (get_node ((char *) NULL, nodename, 0))r 	    clear_echo_area ();	 	  break;   
 	case 'F': 	  {! 	    char footnote[NODENAME_LEN];    	    if (!build_notes ())i 	      {6 		display_error ("No cross-references in this node!"); 		inhibit_display = 1; 		break; 	      }  ) 	    strcpy (footnote, visible_footnote);/E 	    if (!readline ("Follow reference: ", footnote, NODENAME_LEN, 1))n 	      { 		inhibit_display = 1; 		break; 	      }  / 	    I_goto_xy (echo_area.left, echo_area.top);n. 	    if (!find_note_node (footnote, nodename)) 	      {A 		display_error ("\"%s\" is not a cross-reference in this node!",k 			       footnote); 		inhibit_display = 1; 		break; 	      }  . 	    if (get_node ((char *)NULL, nodename, 0)) 	      clear_echo_area (); 	    break;t 	  }  
 	case 'L': 	  {9 	    char filename[FILENAME_LEN], nodename[NODENAME_LEN];n 	    int ptop, ntop;7 	    if (pop_node (filename, nodename, &ntop, &ptop) && # 		get_node (filename, nodename, 1))n 	      { 		pagetop = ptop;  	      }	 	    elsel 	      inhibit_display = 1;n 	    break;  	  }   	case SPACE: 	case CTRL ('V'):  	  if (!next_page ())* 	    {8 	      display_error ("At last page of this node now!"); 	      inhibit_display = 1;t 	    }	 	  break;    	case META ('V'):_
 	case DELETE:t 	  if (!prev_page ())r 	    {9 	      display_error ("At first page of this node now!");e 	      inhibit_display = 1;t 	    }	 	  break;   
 	case 'B': 	  if (pagetop == nodetop) 	    {< 	      display_error ("Already at beginning of this node!"); 	      inhibit_display = 1;  	    } 	  elset 	    pagetop = nodetop;f	 	  break;   = 	  /* I don't want to do this this way, but the documentationoA 	     clearly states that '6' doesn't work.  It states this for a 1 	     reason, and ours is not to wonder why... */N
 	case '1':
 	case '2':
 	case '3':
 	case '4':
 	case '5': 	  { 	    int item = command - '0';   	    if (!build_menu ()) 	      {* 		display_error ("No menu in this node!"); 		inhibit_display = 1; 		break; 	      }   	    if (item > the_menu_size) 	      {8 		display_error ("There are only %d items in the menu!", 			       the_menu_size);c 		inhibit_display = 1; 		break; 	      }   	    if (!get_menu (item)) 	      inhibit_display = 1;f 	  }	 	  break;l  
 	case 'G':< 	  if (!readline ("Goto node: ", nodename, NODENAME_LEN, 0)) 	    { 	      inhibit_display = 1;e
 	      break;  	    }  - 	  if (get_node ((char *) NULL, nodename, 0))r 	    clear_echo_area ();	 	  break;   = 	  /* Search from the starting position forward for a string. = 	     Select the node containing the desired string.  Put the ? 	     top of the page screen_lines / 2 lines behind it, but not; 	     before nodetop. */
 	case 'S': 	  { 	    int pointer, temp;n)  	    char prompt[21 + NODENAME_LEN + 1];t3  	    static char search_string[NODENAME_LEN] = ""; ,  	    static char *starting_filename = NULL,! 	    		*starting_nodename = NULL;k% 	    static int starting_pagetop = 0;'  	    static int wrap_search = 0;  B  	    sprintf (prompt, "Search for string [%s]: ", search_string);  9  	    if (!readline (prompt , nodename, NODENAME_LEN, 0))* 	      { 		inhibit_display = 1; 		break; 	      }  A 	    /* If the user defaulted the search string, and the previous*> 	       command was search, then this is a continuation of the 	       previous search. */ 4 	    if (((strcmp (nodename, search_string) == 0) ||% 		 (!*nodename && *search_string)) &&  		(last_command == 'S')) 	      { 		search_start++;  	      }	 	    elset 	      {- 		/* Initialize the start of a new search. */; 		if (starting_filename) 		  free (starting_filename);i  9 		starting_filename = savestring (last_loaded_info_file);t   		if (starting_nodename) 		  free (starting_nodename);a  < 		starting_nodename = savestring (nodename ? nodename : "");   		starting_pagetop = pagetop;e 		search_start = pagetop;  		wrap_search = 0;   		if (*nodename != '\0')% 		  strcpy (search_string, nodename);= 	      }  / 	    I_goto_xy (echo_area.left, echo_area.top);    	    {> 	      static int pushed = 0; /* How many files are pushed? */; 	      int found_string = 0;  /* Did we find our string? */m   	      if (wrap_search)d 		{e9 		  push_filestack (next_info_file ((char *)NULL, 1), 0);p
 		  pushed++;' 		  search_start = 0;) 		}    	      for (;;)  		{n8 		  set_search_constraints (info_file, info_buffer_len);; 		  pointer = search_forward (search_string, search_start);s   		  if (pointer != -1) 		    {u 		      found_string = 1;  		      break; 		    }  		  else 		    {p 		      char *next_file;  5 		      next_file = next_info_file ((char *)NULL, 0);    		      if (next_file != NULL) 			{ 			  if (pushed) 			    { 			      pop_filestack (); 			      pushed--; 			    }  # 			  push_filestack (next_file, 0);  			  pushed++; 			  search_start = 0; #if 1_/ 			  I_goto_xy (echo_area.left, echo_area.top);(8 			  print_string ("Searching file %s...\n", next_file); #endif 			  continue; 			}   		      if (wrap_search) 			{ 			  display_error 			    ("\"%s\" not found!", 			     search_string);o   			  inhibit_display = 1;o 			  wrap_search = 0;r   			  if (pushed) 			    { 			      pop_filestack (); 			      pushed--; 			    } 			  break;e 			} 		      else 			{+ 			  display_error ("Search: End of file");* 			  inhibit_display = 1;	 			  wrap_search = 1;e   			  if (pushed) 			    { 			      pop_filestack (); 			      pushed--; 			    } 			  break;* 			} 		    }f 		}E   	      if (pushed) 		{f 		  swap_filestack (); 		  pop_filestack ();o
 		  pushed--;e 		}i   	      if (!found_string)s 		break;   	      wrap_search = 0;e> 	      temp = search_backward (start_of_node_string, pointer);   	      if (temp != -1)  		{ 		  search_start = pointer;t& 		  pointer = forward_lines (1, temp); 		}p  E 	      if (temp == -1 || !extract_field ("Node:", nodename, pointer))e 		{h 		  display_error ? 		    ("There doesn't appear to be a nodename for this node.");;$ 		  get_node ((char *)NULL, "*", 0); 		  pagetop = pointer;
 		  break; 		}L  		 > 	      /* Get the node if it is different than the one already
 		 loaded. */l5 	      if (strcmp (nodename, starting_nodename) != 0)f 		{h 		  free (starting_nodename);s. 		  starting_nodename = savestring (nodename);  . 		  if (get_node ((char *) NULL, nodename, 0)) 		    clear_echo_area ();g 		}t  		 0 	      /* Reset the top of page if necessary. */ 	      {A 		if ((strcmp (last_loaded_info_file, starting_filename) != 0) ||d& 		    (starting_pagetop != pagetop) || 		    (search_start > pagebot))t 		  {a 		    pointer = = 		      back_lines ((the_window.bottom - the_window.top) / 2, ' 				  forward_lines (1, search_start));    		    if (pointer < nodetop) 		      pointer = nodetop;  		  t 		    pagetop = pointer; 		    window_bashed = 1; 		  }( 		else 		  inhibit_display = 1; 	      }
 	      break;w 	    }    	  }d   	case CTRL ('H'):g
 	case '?': 	  help_use_info (); 	  last_pagetop = -1; 	 	  break;   
 	case 'Q': 	  done = 1;	 	  break;   / 	case CTRL ('L'):	/* Control-l is redisplay. */) 	  window_bashed = 1;l 	  if (last_command == 'S')o 	    command = 'S';t	 	  break;1  E 	case '(':    /* You *must* be trying to type a complete nodename. */  	  strcpy (nodename, "(");< 	  if (!readline ("Goto node: ", nodename, NODENAME_LEN, 0)) 	    { 	      inhibit_display = 1;v 	      clear_echo_area ();
 	      break;  	    }- 	  I_goto_xy (echo_area.left, echo_area.top);	- 	  if (get_node ((char *) NULL, nodename, 0))  	    clear_echo_area ();	 	  break;:   	case CTRL ('P'):(A 	  /* Print the contents of this node on the default printer.  We B 	     would like to let the user specify the printer, but we don'tB 	     want to ask her each time which printer to use.  Besides, heB 	     might not know, which is why it (the user) is in the need of 	     Info. */ 	  {= 	    char *tempname = make_temp_filename (current_info_node);e- 	    if (dump_current_node (tempname) == 0 &&s 		printfile (tempname) == 0 && 		deletefile (tempname) == 0)  	      {= 		display_error ("Printed node.  Go pick up your output.\n");  	      } 	    inhibit_display = 1;  	    free (tempname);c 	  }	 	  break;N  	 	default:  	  inhibit_display = 1;i: 	  display_error ("Unknown command! Press '?' for help.");   	}     }i }_  A /* Return the screen column width that the line from START to ENDo    requires to display. */ line_length (start, end)      int start, end; {n   int count = 0;     while (start < end);     { #       if (info_file[start] == '\t')  	count += 7 - (count % 8);)       else if (CTRL_P (info_file[start]))  	count += 2;
       else	 	count++;          start++;     }o     return (count);t }e  ' /* Tell this person how to use Info. */  help_use_info () {d   open_typeout ();   clear_screen ();   print_string ("\n\           Commands in Info\n\  \n\  h	Invoke the Info tutorial.\n\ \n\e Selecting other nodes:\n\i, n	Move to the \"next\" node of this node.\n\0 p	Move to the \"previous\" node of this node.\n\  u	Move \"up\" from this node.\n\& m	Pick menu item specified by name.\n\; 	Picking a menu item causes another node to be selected.\n\c8 f	Follow a cross reference.  Reads name of reference.\n\' l	Move to the last node you were at.\n\n9 d	Move to the `directory' node.  Equivalent to `gDIR'.\n\  \n\  Moving within a node:\n\ Space	Scroll forward a page.\n\{ DEL	Scroll backward a page.\n\& b	Go to the beginning of this node.\n\ \n\d Advanced commands:\n\  q	Quit Info.\n\ $ 1	Pick first item in node's menu.\n\5 2 - 5   Pick second ... fifth item in node's menu.\n\ $ g	Move to node specified by name.\n\> 	You may include a filename as well, as (FILENAME)NODENAME.\n\: s	Search through this Info file for a specified string,\n\> 	and select the node in which the next occurrence is found.\n\6 Ctl-p   Print the contents of this node using `%s'.\n\ \n\  Done.\n\n",print_command);   close_typeout ();5 }   3 /* Move to the node specified in the NEXT field. */_ int( next_node () {i   char nodename[NODENAME_LEN];  2   if (!extract_field ("Next:", nodename, nodetop))     return (0);h1   return (get_node ((char *) NULL, nodename, 0));  }y  7 /* Move to the node specified in the PREVIOUS field. */i inti prev_node () {a   char nodename[NODENAME_LEN];  5   if (!extract_field ("Previous:", nodename, nodetop)l5       && !extract_field ("Prev:", nodename, nodetop))m     return (0);01   return (get_node ((char *) NULL, nodename, 0));e }   1 /* Move to the node specified in the UP field. */  int 
 up_node () {_   char nodename[NODENAME_LEN];  0   if (!extract_field ("Up:", nodename, nodetop))     return (0);t1   return (get_node ((char *) NULL, nodename, 0));  }   8 /* Build a completion list of menuname/nodename for each,    line in this node that is a menu item. */ intt
 build_menu ()n {	   int pointer = nodetop;   char menuname[NODENAME_LEN];   char nodename[NODENAME_LEN];  8   if (strcmp (menus_nodename, current_info_node) == 0 &&6       strcmp (menus_filename, current_info_file) == 0)      return (the_menu_size != 0);  -   strcpy (menus_nodename, current_info_node);s-   strcpy (menus_filename, current_info_file);a   free_completion_list ();   the_menu_size = 0;  .   set_search_constraints (info_file, nodebot);<   if ((pointer = search_forward (MENU_HEADER, nodetop)) < 0)     return (0);o  6   /* There is a menu here.  Look for members of it. */"   pointer += strlen (MENU_HEADER);     while (1)m     {c       int idx;  2       pointer = search_forward (MENU_ID, pointer);       if (pointer < 0)+ 	break;			/* No more menus in this node. */   ?       pointer = (skip_whitespace (pointer + strlen (MENU_ID)));i         idx = 0;J       while ((menuname[idx] = info_file[pointer]) && menuname[idx] != ':') 	idx++, pointer++;         menuname[idx] = '\0';(       pointer++;  $       if (info_file[pointer] == ':') 	{ 	  strcpy (nodename, menuname);i 	}
       else 	{ 	  int in_parens;=  ' 	  pointer = skip_whitespace (pointer);d 	  idx = in_parens = 0;y  1 	  while ((nodename[idx] = info_file[pointer]) &&_ 		 (in_parens || 		  (nodename[idx] != '\t' &&  		   nodename[idx] != '.' && 		   nodename[idx] != ','))) 	    {  	      if (nodename[idx] == '(') 		in_parens++;% 	      else if (nodename[idx] == ')')  		in_parens--;   	      idx++, pointer++; 	    } 	  nodename[idx] = '\0'; 	}*       add_completion (menuname, nodename);       the_menu_size++;     }s   if (the_menu_size)5     completion_list = reverse_list (completion_list);s   return (the_menu_size != 0); }=  < /* Select ITEMth item from a list built by build_menu (). */ int  get_menu (item)p      int item; {t   if (!build_menu ())f     return (0);i     if (item > the_menu_size)      return (0);=   else     {	)       COMP_ENTRY *temp = completion_list;s         while (--item && temp) 	temp = temp->next;i  7       return (get_node ((char *) NULL, temp->data, 0));      }i }_  5 /* Scan through the ?already? built menu list lookingp;    for STRING.  If you find it, put the corresponding nodes	    name in NODENAME. */  intf! find_menu_node (string, nodename)e      char *string, *nodename;! { (   return (scan_list (string, nodename)); }l  9 /* The work part of find_menu_node and find_note_node. */{ int  scan_list (string, nodename)      char *string, *nodename;e {e%   COMP_ENTRY *temp = completion_list;y     while (temp)     {iC       if (stricmp (string, temp->identifier, strlen (string)) == 0)  	{! 	  strcpy (nodename, temp->data);a 	  return (1); 	}       temp = temp->next;     }	
   return (0);	 }   > /* Remove <CR> and whitespace from string, replacing them withD    only one space.  Exception:  <CR> at end of string disappears. */ clean_up (string)r      char *string; {    char *to;r  D   /* Skip all whitespace characters found at the start of STRING. */   while (whitespace (*string))
     string++;_     to = string;     while (*to = *string++)      {r$       if (*to == '\n' || *to == ' ') 	{
 	  *to = ' ';a  , 	  while (*string == ' ' || *string == '\t') 	    string++; 	} 	to++;     }_ }e  ? /* Find a reference to "*Note".  Return the offset of the start     of that reference, or -1. */t find_footnote_ref (from)      int from; {.   while (1)i     {m4       from = search_forward (FOOTNOTE_HEADER, from);       if (from < 0)s 	return (from);d
       else" 	from += strlen (FOOTNOTE_HEADER);#       if (info_file[from] == ' ' ||  	  info_file[from] == '\n' ||	 	  info_file[from] == '\t')f 	return (from);y     }  }   K /* Build an array of (footnote.nodename) for each footnote in this node. */s intn build_notes () {p   int pointer;   char notename[NODENAME_LEN];   char nodename[NODENAME_LEN];  .   set_search_constraints (info_file, nodebot);  (   if ((find_footnote_ref (nodetop)) < 0)     return (0);    pointer = nodetop;  /   menus_filename[0] = menus_nodename[0] = '\0';    visible_footnote = "";   free_completion_list ();     while (1)      {        int idx;  ,       pointer = find_footnote_ref (pointer);       if (pointer < 0)/ 	break;			/* no more footnotes in this node. */:  1       pointer = skip_whitespace_and_cr (pointer);n       idx = 0;  J       while ((notename[idx] = info_file[pointer]) && notename[idx] != ':') 	{ 	  idx++, pointer++; 	}         notename[idx] = '\0';o       clean_up (notename);       pointer++;$       if (info_file[pointer] == ':') 	{ 	  strcpy (nodename, notename);  	}
       else 	{ 	  int in_parens = 0;   ' 	  pointer = skip_whitespace (pointer);} 	  idx = 0;y  1 	  while ((nodename[idx] = info_file[pointer]) &&( 		 (in_parens || 		  (nodename[idx] != '\t' &&a 		   nodename[idx] != '.' && 		   nodename[idx] != ','))) 	    {  	      if (nodename[idx] == '(') 		in_parens++;% 	      else if (nodename[idx] == ')')t 		in_parens--;   	      idx++, pointer++; 	    } 	  nodename[idx] = '\0'; 	  clean_up (nodename);n 	}2       /* Add the notename/nodename to the list. */*       add_completion (notename, nodename);       the_menu_size++;  N       /* Remember this identifier as the default if it is the first one in the          page. */i!       if (!(*visible_footnote) &&i 	  pointer > pagetop &&eL       pointer < forward_lines (the_window.bottom - the_window.top, pointer))0 	visible_footnote = completion_list->identifier;     }b   if (the_menu_size)5     completion_list = reverse_list (completion_list);    return (the_menu_size != 0); }c  E /* Scan through the ?already? built footnote list looking for STRING.y>    If found, place the corresponding node name in NODENAME. */ int ! find_note_node (string, nodename)       char *string, *nodename;= {\(   return (scan_list (string, nodename)); }i  F /* **************************************************************** */ /*								    */ /*			Page Display 				    */ /*								    */F /* **************************************************************** */    ) /* The display functions for GNU Info. */  int display_ch, display_cv;	 int display_point;  B /* Display the current page from pagetop down to the bottom of the<    page or the bottom of the node, whichever comes first. */ display_page ()u {    display_point = pagetop;   display_ch = the_window.left;P   display_cv = the_window.top;   generic_page_display (); }o  B /* Print the page from display_point to bottom of node, or window,G    whichever comes first.  Start printing at display_ch, display_cv. */` generic_page_display ()w {i   int done_with_display = 0;   int character;  #   goto_xy (display_ch, display_cv);      while (!done_with_display)     {d#       if (display_point == nodebot)  	{ 	  clear_eop (); 	  goto display_finish;  	}  +       character = info_file[display_point];o  D       if ((display_width (character, the_window.ch) + the_window.ch) 	  >= the_window.right)  	display_carefully (character);o
       else 	charout (character);c  .       if ((the_window.cv >= the_window.bottom)& 	  || (the_window.cv == the_window.top, 	      && the_window.ch == the_window.left)) 	{ 	display_finish: 	  pagebot = display_point;n 	  make_modeline (); 	  done_with_display++;t 	  continue; 	}
       else 	display_point++;      }t   fflush (stdout); }d  @ /* Display character carefully, ensuring that no scrolling takes:    place, even in the case of funky control characters. */ display_carefully (character)r      int character;r {d   if (CTRL_P (character))f     {a       switch (character) 	{
 	case RETURN:  	case NEWLINE:
 	case TAB: 	  clear_eol ();. 	  advance (the_window.right - the_window.ch);	 	  break;,	 	default:0 	  charout ('^'); * 	  if (the_window.cv == the_window.bottom) 	    break;  	  else " 	    charout (UNCTRL (character)); 	}     }f   else     charout (character); }   J /* Move the cursor to POSITION in page.  Return non-zero if successful. */ cursor_to (position)      int position; {    int ch, cv, character;   int point;  /   if (position > pagebot || position < pagetop)      return (0);r     point = pagetop;   ch = the_window.left;A   cv = the_window.top;     while (point < position)     {=%       character = info_file[point++];u  *       ch += display_width (character, ch);  !       if (ch >= the_window.right)e 	{ 	  ch = ch - the_window.right; 	  cv++;   	  if (cv >= the_window.bottom)m 	    return (0); 	}     }s   goto_xy (ch, cv);r
   return (1);( }o  3 /* Move to the next page in this node.  Return 0 if_$    we can't get to the next page. */ int  next_page () {e   int pointer;     pointer =tF     forward_lines ((the_window.bottom - the_window.top) - 2, pagetop);     if (pointer >= nodebot)e     return (0);U  ;   /* Hack for screens smaller than displayed line width. */n   if (pointer > display_point)     {        pointer = display_point;       back_lines (1, pointer);     }    pagetop = pointer;
   return (1);o }e  : /* Move to the previous page in this node.  Return zero if     there is no previous page. */ int  prev_page () {l   int pointer =)A   back_lines ((the_window.bottom - the_window.top) - 2, pagetop);i     if (pagetop == nodetop)i     return (0);n     if (pointer < nodetop)     pointer = nodetop;     pagetop = pointer;
   return (1);( }p    F /* **************************************************************** */ /*								    */ /*			Utility Functions			    */m /*								    */F /* **************************************************************** */  8 char *search_buffer;		/* area in ram to scan through. */. int buffer_bottom;		/* Length of this area. */  > /* Set the global variables that all of these routines use. */' set_search_constraints (buffer, extent)s      char *buffer;      int extent; {*   search_buffer = buffer;l   buffer_bottom = extent;  }   * /* Move back to the start of this line. */ to_beg_line (from)      int from; { 1   while (from && search_buffer[from - 1] != '\n')      from--;    return (from); }p  + /* Move forward to the end of this line. */t to_end_line (from) {t=   while (from < buffer_bottom && search_buffer[from] != '\n')      from++;    return (from); }a  C /* Move back count lines in search_buffer starting at starting_pos.h%    Returns the start of that line. */N  back_lines (count, starting_pos)      int count, starting_pos;r {,,   starting_pos = to_beg_line (starting_pos);   while (starting_pos && count)a     {i4       starting_pos = to_beg_line (starting_pos - 1);       count--;     }    return (starting_pos); }e  5 /* Move forward count lines starting at starting_pos.)%    Returns the start of that line. */m# forward_lines (count, starting_pos)       int count, starting_pos;- {t,   starting_pos = to_end_line (starting_pos);/   while (starting_pos < buffer_bottom && count)>     {i4       starting_pos = to_end_line (starting_pos + 1);       count--;     }>&   return (to_beg_line (starting_pos)); }(  ? /* Search for STRING in SEARCH_BUFFER starting at STARTING_POS.t<    Return the location of the string, or -1 if not found. */% search_forward (string, starting_pos)       char *string;      int starting_pos; {    register int c, i, len;    register char *buff, *end;   char *alternate;    G   /* We match characters in SEARCH_BUFFER against STRING and ALTERNATE.*I      ALTERNATE is a case reversed version of STRING; this is cheaper thanr6      case folding each character before comparison. */  #   /* Build the alternate string. */ "   alternate = savestring (string);   len = strlen (string);     for (i = 0; i < len; i++)      {f       c = alternate[i];E         if (c >= 'a' && c <= 'z')= 	alternate[i] = c - 32;o$       else if (c >= 'A' && c <= 'Z') 	alternate[i] = c + 32;      }   &   buff = search_buffer + starting_pos;*   end = search_buffer + buffer_bottom + 1;     while (buff < end)     {o       for (i = 0; i < len; i++)L 	{ 	  c = buff[i];[  + 	  if (c != string[i] && c != alternate[i])o 	    break;t 	}         if (!string[i])f 	{ 	  free (alternate);! 	  return (buff - search_buffer);  	}  
       buff++;e     }e     free (alternate);i   return (-1); }   ? /* Search for STRING in SEARCH_BUFFER starting at STARTING_POS. <    Return the location of the string, or -1 if not found. */& search_backward (string, starting_pos)      char *string;      int starting_pos; {e   int len = strlen (string);!   while (starting_pos - len > -1)e     { L       if (strnicmp (search_buffer + (starting_pos - len), string, len) == 0) 	return (starting_pos - len); 
       else 	starting_pos--;     }e   return (-1); }o  E /* Only search for STRING from POINTER to end of line.  Return offsetl$    of string, or -1 if not found. */  string_in_line (string, pointer)      char *string;      int pointer;[ {](   int old_buffer_bottom = buffer_bottom;  @   set_search_constraints (search_buffer, to_end_line (pointer));-   pointer = search_forward (string, pointer);n$   buffer_bottom = old_buffer_bottom;   return (pointer);a }i  9 /* Skip whitespace characters at OFFSET in SEARCH_BUFFER. B    Return the next non-whitespace character or -1 if BUFFER_BOTTOM    is reached. */o skip_whitespace (offset)      int offset; {o   int character;      while (offset < buffer_bottom)     {e(       character = search_buffer[offset];0       if (character == ' ' || character == '\t')
 	offset++;
       else 	return (offset);g     }e   return (-1); }o  9 /* Skip whitespace characters including <CR> at OFFSET invA    SEARCH_BUFFER.  Return the position of the next non-whitespacee3    character, or -1 if BUFFER_BOTTOM is reached. */i skip_whitespace_and_cr (offset)z      int offset; {a   while (1)      {y(       offset = skip_whitespace (offset);6       if (offset > 0 && search_buffer[offset] != '\n') 	return (offset);d
       else
 	offset++;     }  }   A /* Extract the node name part of the of the text after the FIELD.)@    Place the node name into NODENAME.  Assume the line starts at    OFFSET in SEARCH_BUFFER. */ int	, extract_field (field_name, nodename, offset)!      char *field_name, *nodename;*      int offset; {*   int temp, character;  -   temp = string_in_line (field_name, offset);h   if (temp < 0)n     return (0);      temp += strlen (field_name);    temp = skip_whitespace (temp);  5   /* Okay, place the following text into NODENAME. */t  1   while ((character = search_buffer[temp]) != ','; 	 && character != '\n' 	 && character != '\t')=     {n       *nodename = character;       nodename++;i
       temp++;m     }y   *nodename = '\0';o
   return (1);  }w  A /* Return non-zero if pointer is exactly at string, else zero. */  inti looking_at (string, pointer)      char *string;      int pointer;; { G   if (strnicmp (search_buffer + pointer, string, strlen (string)) == 0)      return (1);p   else     return (0);{ }   G /* File stack stuff. This is currently only used to push one file while[@    searching indirect files, but we may as well write it in full    generality. */c typedef struct filestack {    struct filestack *next;e   char filename[FILENAME_LEN];&   char current_filename[FILENAME_LEN];   char *tag_table;   char *info_file;   int info_buffer_len; } FILESTACK;   FILESTACK *filestack = NULL;   inty( push_filestack (filename, remember_name)      char *filename;      int remember_name;  {nB   FILESTACK *element = (FILESTACK *) xmalloc (sizeof (FILESTACK));     element->next = filestack;   filestack = element;  6   strcpy (filestack->filename, last_loaded_info_file);:   strcpy (filestack->current_filename, current_info_file);#   filestack->tag_table = tag_table;r#   filestack->info_file = info_file;c/   filestack->info_buffer_len = info_buffer_len;A   @   *last_loaded_info_file = '\0';	/* force the file to be read */<   info_file = (char *)NULL;	/* Pretend we have no buffer. */.   if (get_info_file (filename, remember_name))     {c       return (1);r     };   else     {        pop_filestack ();t       return (0);      }s }t   void pop_filestack () {o   FILESTACK *temp;        if (filestack == NULL)     {sF        fprintf (stderr , "File stack is empty and can't be popped\n");        brians_error ();t        return;     }      free (info_file);   6   strcpy (last_loaded_info_file, filestack->filename);:   strcpy (current_info_file, filestack->current_filename);#   tag_table = filestack->tag_table;c#   info_file = filestack->info_file;_/   info_buffer_len = filestack->info_buffer_len;;6   set_search_constraints (info_file, info_buffer_len);     temp = filestack;    filestack = filestack->next;   free ((char *)temp); }x  A /* Swap the current info file with the bottom of the filestack */  void swap_filestack ()e { -   char t_last_loaded_info_file[FILENAME_LEN]; )   char t_current_info_file[FILENAME_LEN];p   char *t_tag_table;   char *t_info_file;   int t_info_buffer_len;     if (filestack == NULL)     {lG        fprintf (stderr , "File stack is empty and can't be swapped\n");i        brians_error ();l        return;     }   8   strcpy (t_last_loaded_info_file, filestack->filename);<   strcpy (t_current_info_file, filestack->current_filename);%   t_tag_table = filestack->tag_table;    t_info_file = info_file;&   t_info_buffer_len = info_buffer_len;  6   strcpy (filestack->filename, last_loaded_info_file);:   strcpy (filestack->current_filename, current_info_file);#   filestack->tag_table = tag_table;(#   filestack->info_file = info_file;*/   filestack->info_buffer_len = info_buffer_len;*  :   strcpy (last_loaded_info_file, t_last_loaded_info_file);2   strcpy (current_info_file, t_current_info_file);   tag_table = t_tag_table;   info_file = t_info_file;&   info_buffer_len = t_info_buffer_len; }t    /* Now the node history stack */   extern NODEINFO *Info_History;  I /* Save the current filename, nodename, and position on the history list.c    We prepend. */i intt< push_node (filename, nodename, page_position, node_position)      char *filename, *nodename;r&      int page_position, node_position; { ?   NODEINFO *newnode = (NODEINFO *) xmalloc (sizeof (NODEINFO));      newnode->next = Info_History;p  ?   newnode->filename = (char *) xmalloc (strlen (filename) + 1);)'   strcpy (newnode->filename, filename);a  ?   newnode->nodename = (char *) xmalloc (strlen (nodename) + 1);*'   strcpy (newnode->nodename, nodename);t  #   newnode->pagetop = page_position;e#   newnode->nodetop = node_position;(     Info_History = newnode;t
   return (1);g }s  9 /* Pop one node from the node list, leaving the values in     passed variables. */  inti/ pop_node (filename, nodename, nodetop, pagetop)-      char *filename, *nodename;e      int *nodetop, *pagetop; {v.   if (Info_History->next == (NODEINFO *) NULL)     {t5       display_error ("At beginning of history now!");        return (0);      }u   else     {s(       NODEINFO *releaser = Info_History;  : 	/* If the popped file is not the current file, then force$ 	   the popped file to be loaded. */F       if (strcmp (Info_History->filename, last_loaded_info_file) != 0)! 	last_loaded_info_file[0] = '\0';   0       strcpy (filename, Info_History->filename);0       strcpy (nodename, Info_History->nodename);'       *pagetop = Info_History->pagetop;i'       *nodetop = Info_History->nodetop;a$       free (Info_History->nodename);$       free (Info_History->filename);(       Info_History = Info_History->next;       free (releaser);       return (1);T     }* }   ) /* Whoops, Unix doesn't have strnicmp. */R  B /* Compare at most COUNT characters from string1 to string2.  Case    doesn't matter. */i inte" strnicmp (string1, string2, count)      char *string1, *string2;  {l   char ch1, ch2;     while (count);     {        ch1 = *string1++;t       ch2 = *string2++;'+       if (to_upper (ch1) == to_upper (ch2)) 	 	count--; 
       else 	break;)     }r   return (count);  }   7 /* Compare string1 to string2.  Case doesn't matter. */h inte stricmp (string1, string2)      char *string1, *string2;  {o   char ch1, ch2;     while (1)c     {[       ch1 = *string1++;g       ch2 = *string2++;o         if (ch1 == '\0') 	return (ch2 != '\0');         if ((ch2 == '\0') ||& 	  (to_upper (ch1) != to_upper (ch2))) 	return (1);     }  }e  $ /* Make the user type "Y" or "N". */ int  get_y_or_n_p ()E {H   int character;   print_string (" (Y or N)?");   clear_eol ();t   until_we_like_it:u     character = blink_cursor ();   if (character == EOF)s     return (0);s"   if (to_upper (character) == 'Y')     {g       charout (character);       return (1);      }f  "   if (to_upper (character) == 'N')     {e       charout (character);       return (0);      }      if (character == ABORT_CHAR)     {e       ding ();       return (0);r     }      goto until_we_like_it; }e  : /* Move the cursor to the desired column in the window. */ indent_to (screen_column)       int screen_column;p {t.   int counter = screen_column - the_window.ch;   if (counter > 0)     {n       while (counter--)_ 	charout (' ');      }e   else if (screen_column != 0)     charout (' '); }    _F /* **************************************************************** */ /*								    */$ /*			Error output/handling.			    */ /*								    */F /* **************************************************************** */  9 /* Display specific error from known file error table. */u file_error (file)e      char *file; {e   extern int errno;    extern int sys_nerr;   extern char *sys_errlist[];e     if (errno < sys_nerr)o7     display_error ("%s: %s", file, sys_errlist[errno]);e   else8     display_error ("%s: Unknown error %d", file, errno); }h  C /* Display the error in the echo-area using format_string and args.O0    This is a specialized interface to printf. */) display_error (format_string, arg1, arg2)       char *format_string;h {s   extern int terminal_inited_p;>   char output_buffer[1024];=     if (totally_inhibit_errors)      return;+  5   sprintf (output_buffer, format_string, arg1, arg2);    if (terminal_inited_p)     {a       new_echo_area ();E       ding ();)       print_string ("%s", output_buffer);R       close_echo_area ();f     }m   else     {f.       fprintf (stderr, "%s\n", output_buffer);     }e }   < /* Tell everybody what a loser I am.  If you see this error,    send me a bug report. */n brians_error ()  { @   display_error ("You are never supposed to see this error.\n");@   display_error ("Tell bfox@ai.mit.edu to fix this someday.\n");   return (-1); }r  F /* **************************************************************** */ /*								    */% /*			Terminal IO, and Driver			    */i /*								    */F /* **************************************************************** */  & /* The Unix termcap interface code. */   #define NO_ERROR 0 #define GENERIC_ERROR 1c  #define NO_TERMINAL_DESCRIPTOR 2 #define OUT_OF_MEMORY 3h #define BAD_TERMINAL 4  ? #define FERROR(msg)	fprintf (stderr, msg); exit (GENERIC_ERROR))  # extern int tgetnum (), tgetflag ();c extern char *tgetstr (); extern char *tgoto ();  E #define Certainly_enough_space 2048	/* page 3, Section 1.1, para 4 */.   #if defined (unix), char termcap_buffer[Certainly_enough_space]; #else /* !unix */E #define termcap_buffer NULLm #endif /* !unix */  M /* You CANNOT remove these next four vars.  TERMCAP needs them to operate. */E char PC;	 char *BC;L	 char *UP;   ? /* A huge array of stuff to get from termcap initialization. */    #define tc_int 0 #define tc_char tc_int+1 #define tc_flag tc_char+1i #define tc_last tc_flag+1m   typedef int flag;;  5 /* First, the variables which this array refers to */,   /* Capabilities */  * int terminal_columns;		/* {tc_int, "co" */' int terminal_rows;		/* {tc_int, "li" */=- flag terminal_is_generic;	/* {tc_flag,"gn" */e    /* Cursor Motion */  ) char *terminal_goto;		/* {tc_char,"cm" */d) char *terminal_home;		/* {tc_char,"ho" */e  / char *terminal_cursor_left;	/* {tc_char,"le" */ 0 char *terminal_cursor_right;	/* {tc_char,"nd" */- char *terminal_cursor_up;	/* {tc_char,"up" */ / char *terminal_cursor_down;	/* {tc_char,"do" */    /* Screen Clearing */   - char *terminal_clearpage;	/* {tc_char,"cl" */m, char *terminal_clearEOP;	/* {tc_char,"cd" */, char *terminal_clearEOL;	/* {tc_char,"ce" */   /* "Standout" */2 char *terminal_standout_begin;	/* {tc_char,"so" */0 char *terminal_standout_end;	/* {tc_char,"se" */   /* Reverse Video */i1 char *terminal_inverse_begin;	/* {tc_char,"mr" */u2 char *terminal_end_attributes;	/* {tc_char,"me" */   /* Ding! */   , char *terminal_ear_bell;	/* {tc_char,"bl" */   /* Terminal Initialization */_  - char *terminal_use_begin;	/* {tc_char,"ti" */ , char *terminal_use_end;		/* {tc_char,"te" */   /* Padding Stuff */   , char *terminal_padding;		/* {tc_char,"pc" */    /* Now the whopping big array */   typedef struct {   char type;
   char *name;d   char *value; } termcap_capability_struct;  , termcap_capability_struct capabilities[] = {   /* Capabilities */   -   {tc_int, "co", (char *) &terminal_columns},)*   {tc_int, "li", (char *) &terminal_rows},1   {tc_flag, "gn", (char *) &terminal_is_generic},n   /* Cursor Motion */t  +   {tc_char, "cm", (char *) &terminal_goto},l+   {tc_char, "ho", (char *) &terminal_home},_  2   {tc_char, "le", (char *) &terminal_cursor_left},3   {tc_char, "nd", (char *) &terminal_cursor_right},;0   {tc_char, "up", (char *) &terminal_cursor_up},2   {tc_char, "do", (char *) &terminal_cursor_down},   /* Screen Clearing */t   0   {tc_char, "cl", (char *) &terminal_clearpage},/   {tc_char, "cd", (char *) &terminal_clearEOP},e/   {tc_char, "ce", (char *) &terminal_clearEOL},n    /* "Standout" */5   {tc_char, "so", (char *) &terminal_standout_begin},u3   {tc_char, "se", (char *) &terminal_standout_end},    /* Reverse Video */l4   {tc_char, "mr", (char *) &terminal_inverse_begin},5   {tc_char, "me", (char *) &terminal_end_attributes},D   /* Ding! */t  /   {tc_char, "bl", (char *) &terminal_ear_bell},     /* Terminal Initialization */W  0   {tc_char, "ti", (char *) &terminal_use_begin},.   {tc_char, "te", (char *) &terminal_use_end},   /* Padding Stuff */i   .   {tc_char, "pc", (char *) &terminal_padding},  5 /* Terminate this array with a var of type tc_last */e   {tc_last, NULL, NULL}y   };   int terminal_opened_p = 0;   open_terminal_io ()a {    int error;     if (terminal_opened_p)     return (NO_ERROR);  1   if ((error = get_terminal_info ()) != NO_ERROR)      return (error);n  =   if ((error = get_terminal_vars (capabilities)) != NO_ERROR)d     return (error);i  <   /* Now, make sure we have the capabilites that we need. */   if (terminal_is_generic)     return (BAD_TERMINAL);     terminal_opened_p++;   return (NO_ERROR); }    get_terminal_info () {-   char temp_string_buffer[256];e
   int result;e  (   char *terminal_name = getenv ("TERM");  2   if (terminal_name == NULL || *terminal_name == 01       || (strcmp (terminal_name, "dialup") == 0))      {u)       terminal_name = temp_string_buffer;="       printf ("\nTerminal Type:");       fflush (stdout);(       fgets (terminal_name, 256, stdin);       if (!(*terminal_name))! 	return (NO_TERMINAL_DESCRIPTOR);e     }f  $ /* #define VERBOSE_GET_TERMINAL 1 */ #ifdef VERBOSE_GET_TERMINALa   #define buffer_limit 256- #define opsys_termcap_filename "/etc/termcap"e  J   /* We hack question mark if that is what the user typed.  All this meansK      is we read /etc/termcap, and prettily print out the names of terminalse      that we find. */o  3   if (terminal_name[0] == '?' && !terminal_name[1])      {(       FILE *termcap_file;pG       if ((termcap_file = fopen (opsys_termcap_filename, "r")) != NULL)  	{ 	  int result;" 	  char line_buffer[buffer_limit]; 	  int terminal_count = 0;  @ 	  while ((readline_termcap (termcap_file, line_buffer)) != EOF) 	    {& 	      char first_char = *line_buffer;1 	      if (first_char == '#' || first_char == ' '(0 		  || first_char == '\t' || first_char == '\n') 		;k 	      else  		{n) 		  /* Print the names the pretty way. */i, 		  printf ("\n%s", line_buffer);	/* liar */ 		  terminal_count++;  		}  	    } 	  fclose (termcap_file);1   	  if (terminal_count)9 	    printf ("\n%d terminals listed.\n", terminal_count);  	  else(@ 	    printf ("\nNo terminals were listed.  Brian's mistake.\n"); 	}
       else 	{ 	  fprintf (stderr, 6 		   "\nNo such system file as %s!\nWe lose badly.\n", 		   opsys_termcap_filename);E# 	  return (NO_TERMINAL_DESCRIPTOR);g 	}$       return (get_terminal_info ());     }k! #endif /* VERBOSE_GET_TERMINAL */r  3   result = tgetent (termcap_buffer, terminal_name);(     if (!result)$     return (NO_TERMINAL_DESCRIPTOR);   else     return (NO_ERROR); }f   #ifdef VERBOSE_GET_TERMINAL=! readline_termcap (stream, buffer)a      FILE *stream;      char *buffer; {(   int c;   int buffer_index = 0;   1   while ((c = getc (stream)) != EOF && c != '\n')t     {i+       if (buffer_index != buffer_limit - 1)e 	buffer[buffer_index++] = c;     }      buffer[buffer_index] = 0;e     if (c == EOF)n&     return ((buffer_index) ? 0 : EOF);   else     return (0);  }n! #endif /* VERBOSE_GET_TERMINAL */t  F /* For each element of "from_array", read the corresponding variable's!    value into the right place. */* get_terminal_vars (from_array),      termcap_capability_struct from_array[]; {d   int i;+   register termcap_capability_struct *item;*   char *buffer;*   #if !defined (GNU_TERMCAP):   buffer = (char *) xmalloc (sizeof (termcap_buffer) + 1); # define buffer_space &buffera #else; # define buffer_space 0  #endif  F   for (i = 0; (item = &from_array[i]) && (item->type != tc_last); i++)     {        switch (item->type)l 	{
 	case tc_int:o3 	  *((int *) (item->value)) = tgetnum (item->name);d	 	  break;r   	case tc_flag:2 	  *((int *) item->value) = tgetflag (item->name);	 	  break;    	case tc_char:A 	  *((char **) item->value) = tgetstr (item->name, buffer_space); 	 	  break;   	 	default:_1 	  FERROR ("Bad entry scanned in tc_struct[].\n \h5 	       Ask bfox@ai.mit.edu to fix this someday.\n");s 	}     }u  2   PC = terminal_padding ? terminal_padding[0] : 0;   BC = terminal_cursor_left;   UP = terminal_cursor_up;   return (NO_ERROR); };  2 /* Return the number of rows this terminal has. */ intc get_terminal_rows () {l   int rows = 0;    #if defined (TIOCGWINSZ)   {u     int tty;     struct winsize size;       tty = fileno (stdin);e  -     if (ioctl (tty, TIOCGWINSZ, &size) != -1)s       rows = size.ws_row;r   }" #endif /* TIOCGWINSZ */      if (!rows)     rows = tgetnum ("li");     if (rows <= 0)     rows = 24;     return (rows); }   5 /* Return the number of columns this terminal has. */* get_terminal_columns ()	 {	   int columns = 0;   #if defined (TIOCGWINSZ)   {	     int tty;     struct winsize size;       tty = fileno (stdin);*  -     if (ioctl (tty, TIOCGWINSZ, &size) != -1)e       columns = size.ws_col;   }  #endif /* TIOCGWINSZ */      if (!columns)T     columns = tgetnum ("co");      if (columns <= 0)      columns = 80;g     return (columns);; }i  $ /* #define TERMINAL_INFO_PRINTING */ #ifdef TERMINAL_INFO_PRINTING   D /* Scan this (already "get_terminal_vars"ed) array, printing out theE    capability name, and value for each entry.  Pretty print the valuecC    so that the terminal doesn't actually do anything, shitbrain. */a show_terminal_info (from_array)/,      termcap_capability_struct from_array[]; {E   register int i; +   register termcap_capability_struct *item;   J   for (i = 0; ((item = &from_array[i]) && ((item->type) != tc_last)); i++)     {t         char *type_name;       switch (item->type)+ 	{
 	case tc_int:  	  type_name = "int ";	 	  break;  	case tc_flag: 	  type_name = "flag";	 	  break;* 	case tc_char: 	  type_name = "char";	 	  break;/	 	default:" 	  type_name = "Broken"; 	}  4       printf ("\t%s\t%s = ", type_name, item->name);         switch (item->type)o 	{
 	case tc_int:n 	case tc_flag:) 	  printf ("%d", *((int *) item->value));c	 	  break;* 	case tc_char:. 	  tc_pretty_print (*((char **) item->value));	 	  break;o 	}       printf ("\n");     }r }e  C /* Print the contents of string without sending anything that isn't{(    a normal printing ASCII character. */ tc_pretty_print (string)      register char *string;r {e   register char c;     while (c = *string++)m     {e       if (CTRLP (c)) 	{ 	  putchar ('^');/ 	  c += 64;n 	}       putchar (c);     }" }  #endif TERMINAL_INFO_PRINTING;    F /* **************************************************************** */ /*								    */% /*			Character IO, and driver		    */t /*								    */F /* **************************************************************** */   char *widest_line; int terminal_inited_p = 0;  & /* Start up the character io stuff. */ init_terminal_io ()e {/   if (!terminal_inited_p)      {e       opsys_init_terminal ();c+       terminal_rows = get_terminal_rows ();y1       terminal_columns = get_terminal_columns ();r  8       widest_line = (char *) xmalloc (terminal_columns);         terminal_inited_p = 1;     }l     terminal_window.left = 0;(   terminal_window.top = 0;+   terminal_window.right = terminal_columns; )   terminal_window.bottom = terminal_rows;e      set_window (&terminal_window);     terminal_window.bottom -= 2;      set_window (&terminal_window);  9   init_echo_area (the_window.left, the_window.bottom + 1,r% 		  the_window.right, terminal_rows);&  H   /* Here is a list of things that the terminal has to be able to do. Do)      you think that this is too harsh? */_8   if (!terminal_goto ||		/* We can't move the cursor. */<       !terminal_rows)		/* We don't how many lines it has. */     {e       fprintf (stderr,D 	       "Your terminal is not clever enough to run info. Sorry.\n");        exit (1);     }s }d   /* Ring the terminal bell. */c ding ()e {n!   extern char *terminal_ear_bell;d     if (terminal_ear_bell)      do_term (terminal_ear_bell);   else     putchar (CTRL ('G'));l     fflush (stdout); }D   int untyi_char = 0;  int inhibit_output = 0;e  > /* Return a character from stdin, or the last unread character     if there is one available. */ blink_cursor ()  {a   int character;     fflush (stdout);   if (untyi_char)_     {p       character = untyi_char;,       untyi_char = 0;r     }h   elseO     do { character = getc (stdin); } while (character == -1 && errno == EINTR);      return (character);  }   ; /* Display single character on the terminal screen.  If the =    character would run off the right hand edge of the screen,n*    advance the cursor to the next line. */ charout (character)       int character;n {r   if (inhibit_output)e     return;   7   /* This character may need special treatment if it is)      a control character. */   if (CTRL_P (character))      {(       switch (character) 	{ 	case NEWLINE:
 	case RETURN:g 	  print_cr (); 	 	  break;e  
 	case TAB: 	  print_tab ();	 	  break;;  	 	default:m 	  charout ('^');|  	  charout (UNCTRL (character)); 	}     }n   else     {p       putchar (character);       advance (1);     }u }r  1 /* Move the cursor AMOUNT character positions. */( advance (amount)      int amount; {5$   int old_window_cv = the_window.cv;     while (amount-- > 0)     {O       the_window.ch++;,       if (the_window.ch >= the_window.right) 	{H 	  the_window.ch = (the_window.ch - the_window.right) + the_window.left; 	  the_window.cv++;   * 	  if (the_window.cv >= the_window.bottom)$ 	    the_window.cv = the_window.top; 	}     }p  %   if (the_window.cv != old_window_cv)m+     goto_xy (the_window.ch, the_window.cv);n }n  ) /* Print STRING and args using charout */ ) print_string (string, a1, a2, a3, a4, a5)c      char *string; {t   int character;   char buffer[2048];   int idx = 0;  /   sprintf (buffer, string, a1, a2, a3, a4, a5);o  #   while (character = buffer[idx++])      charout (character);     fflush (stdout); }    /* Display a carriage return. *    Clears to the end of the line first. */ print_cr ()| {r   extern int typing_out;   clear_eol ();k     if (typing_out) #     {				/* Do the "MORE" stuff. */.       int response;%  1       if (the_window.cv + 2 == the_window.bottom)  	{0 	  goto_xy (the_window.left, the_window.cv + 1); 	  clear_eol (); 	  print_string ("[More]");e 	  response = blink_cursor (); 	  if (response != SPACE)i 	    { 	      untyi_char = response;; 	      inhibit_output = 1; 	      return; 	    } 	  elsey 	    {0 	      goto_xy (the_window.left, the_window.cv); 	      clear_eol ();1 	      goto_xy (the_window.left, the_window.top);e 	      return; 	    } 	}     } -   advance (the_window.right - the_window.ch);( }m  A /* Move the cursor to the next tab stop, blanking the interveningA    spaces along the way. */e print_tab () {    int hpos, width, destination;=  )   hpos = the_window.ch - the_window.left;L%   width = ((hpos + 8) & 0xf8) - hpos;n  /   destination = hpos + width + the_window.left;c  &   if (destination >= the_window.right)$     destination -= the_window.right;  &   while (the_window.ch != destination)     charout (SPACE); }e   display_width (character, hpos)e      int character, hpos;E {;   int width = 1;     if (CTRL_P (character))S     {E       switch (character) 	{
 	case RETURN:r 	case NEWLINE:# 	  width = the_window.right - hpos; 	 	  break;l
 	case TAB:& 	  width = ((hpos + 8) & 0xf8) - hpos;	 	  break;t	 	default:o
 	  width = 2;  	}     }    return (width);p }l  ) /* Like GOTO_XY, but do it right away. */d I_goto_xy (xpos, ypos)      int xpos, ypos; {    goto_xy (xpos, ypos);+   fflush (stdout); }p  < /* Move the cursor, (and cursor variables) to xpos, ypos. */ goto_xy (xpos, ypos)      int xpos, ypos; {!   the_window.ch = xpos;    the_window.cv = ypos;l   opsys_goto_pos (xpos, ypos); }(  C /* Clear the screen, leaving ch and cv at the top of the window. */  clear_screen ()v {e,   goto_xy (the_window.left, the_window.top);   clear_eop_slowly (); }i   clear_eop_slowly ()i {-   int temp_ch = the_window.ch;   int temp_cv = the_window.cv;     clear_eol ();t  -   while (++the_window.cv < the_window.bottom)f     { /       goto_xy (the_window.left, the_window.cv);d       clear_eol ();g     };   goto_xy (temp_ch, temp_cv);  }P  8 /* Clear from current cursor position to end of page. */ clear_eop () {o   if (terminal_clearEOP)      do_term (terminal_clearEOP);   else     clear_eop_slowly (); }I  > /* Clear from current cursor position to end of screen line */ clear_eol () {    int temp_ch = the_window.ch;     if (terminal_clearEOL)      do_term (terminal_clearEOL);   else     {        char *line = widest_line;(       int i;  <       for (i = 0; i < the_window.right - the_window.ch; i++) 	line[i] = ' ';o       line[i] = '\0';.         printf ("%s", line);     } #   goto_xy (temp_ch, the_window.cv);G }S  E /* Call FUNCTION with WINDOW active.  You can pass upto 5 args to thei8    function.  This returns whatever FUNCTION returns. */ intoF with_output_to_window (window, function, arg1, arg2, arg3, arg4, arg5)      WINDOW *window;      Function *function; {=
   int result;n     push_window ();(   set_window (window);6   result = (*function) (arg1, arg2, arg3, arg4, arg5);   pop_window ();   return (result); }i  8 /* Given a pointer to a window data structure, make that    the current window. */e set_window (window)       WINDOW *window; {o/   bcopy (window, &the_window, sizeof (WINDOW));t }i  2 /* Save the current window on the window stack. */ push_window () { K   WINDOW_LIST *new_window = (WINDOW_LIST *) xmalloc (sizeof (WINDOW_LIST));=  )   new_window->next_window = window_stack;    window_stack = new_window;!   new_window->ch = the_window.ch;h!   new_window->cv = the_window.cv; #   new_window->top = the_window.top;c)   new_window->bottom = the_window.bottom;e%   new_window->left = the_window.left;h'   new_window->right = the_window.right;e }"  6 /* Pop the top of the window_stack into the_window. */
 pop_window ()  { &   set_window ((WINDOW *)window_stack);      if (window_stack->next_window)     {)0       WINDOW_LIST *thing_to_free = window_stack;/       window_stack = window_stack->next_window;e       free (thing_to_free);;     }r  )   goto_xy (the_window.ch, the_window.cv);u }e  F /* **************************************************************** */ /*								    */  /*			"Opsys" functions.			    */ /*								    */F /* **************************************************************** */  B /* The lowlevel terminal/file interface.  Nothing ever really gets.    low level when you're writing in C, though.  B    This file contains all of the "opsys" labels.  You have to makeE    a different one if you want GNU Info to run on machines that don't*    have Unix.  */*  C extern char *terminal_use_begin, *terminal_use_end, *terminal_goto;m   #if defined (TIOCGETC) struct tchars original_tchars; #endif   #if defined (TIOCGLTC)  struct ltchars original_ltchars; #endif   #if defined (USG) ' struct termio original_termio, ttybuff;) #else  int original_tty_flags = 0;i int original_lmode;  struct sgttyb ttybuff; #endif /* !USG */l  = /* Yes, that's right, do things that the machine needs to getw&    the terminal into a usable mode. */ opsys_init_terminal () {h   int tty = fileno (stdin);m   #if defined (USG)t(   ioctl (tty, TCGETA, &original_termio);    ioctl (tty, TCGETA, &ttybuff);A   ttybuff.c_iflag &= (~ISTRIP & ~INLCR & ~IGNCR & ~ICRNL &~IXON);h'   ttybuff.c_oflag &= (~ONLCR & ~OCRNL);	'   ttybuff.c_lflag &= (~ICANON & ~ECHO);      ttybuff.c_cc[VMIN] = 1;h   ttybuff.c_cc[VTIME] = 0;  #   if (ttybuff.c_cc[VINTR] = DELETE)i     ttybuff.c_cc[VINTR] = -1;a  #   if (ttybuff.c_cc[VQUIT] = DELETE)      ttybuff.c_cc[VQUIT] = -1;e      ioctl (tty, TCSETA, &ttybuff); #else /* !USG */  "   ioctl (tty, TIOCGETP, &ttybuff);     if (!original_tty_flags)*     original_tty_flags = ttybuff.sg_flags;  D   /* Make this terminal pass 8 bits around while we are using it. */ #ifdef PASS8   ttybuff.sg_flags |= PASS8; #endif  * #if defined (TIOCLGET) && defined (LPASS8)   {'     int flags;"     ioctl (tty, TIOCLGET, &flags);     original_lmode = flags;      flags |= LPASS8;"     ioctl (tty, TIOCLSET, &flags);   }r #endif   #ifdef TIOCGETCb   {/     struct tchars temp;   ,     ioctl (tty, TIOCGETC, &original_tchars);<     bcopy (&original_tchars, &temp, sizeof (struct tchars));  &     temp.t_startc = temp.t_stopc = -1;  E     /* If the quit character conflicts with one of our commands, thene        make it go away. */     if (temp.t_intrc == DELETE)t       temp.t_intrc == -1;        if (temp.t_quitc == DELETE)h       temp.t_quitc == -1;   !     ioctl (tty, TIOCSETC, &temp);    }h #endif /* TIOCGETC */    #ifdef TIOCGLTCr   {f     struct ltchars temp;  -     ioctl (tty, TIOCGLTC, &original_ltchars);e>     bcopy (&original_ltchars, &temp, sizeof (struct ltchars));  M     /* Make the interrupt keys go away.  Just enough to make people happy. */ "     temp.t_lnextc = -1;		/* C-v */  !     ioctl (tty, TIOCSLTC, &temp);    }f #endif /* TIOCGLTC */)     ttybuff.sg_flags &= ~ECHO;   ttybuff.sg_flags |= CBREAK;p"   ioctl (tty, TIOCSETN, &ttybuff); #endif /* !USG */u     open_terminal_io ();   do_term (terminal_use_begin);  }a  $ /* Fix the terminal that I broke. */
 restore_io ()  {h   int tty = fileno (stdin);n   #if defined (USG) (   ioctl (tty, TCSETA, &original_termio); #elsee"   ioctl (tty, TIOCGETP, &ttybuff);(   ttybuff.sg_flags = original_tty_flags;"   ioctl (tty, TIOCSETN, &ttybuff);   #ifdef TIOCGETCo*   ioctl (tty, TIOCSETC, &original_tchars); #endif /* TIOCGETC */}   #ifdef TIOCGLTCh+   ioctl (tty, TIOCSLTC, &original_ltchars);t #endif /* TIOCGLTC */w  * #if defined (TIOCLGET) && defined (LPASS8))   ioctl (tty, TIOCLSET, &original_lmode);3 #endif   #endif /* !USG */;   do_term (terminal_use_end);b }e   opsys_goto_pos (xpos, ypos)p      int xpos, ypos; {,.   do_term (tgoto (terminal_goto, xpos, ypos)); }d  % character_output_function (character)u      char character; {s   putchar (character); }   ! /* Generic interface to tputs. */  do_term (command)r      char *command;_ {;?   /* Send command to the terminal, with appropriate padding. */E   if (command)2     tputs (command, 1, character_output_function); }e  * /* Filename manipulators, and the like. */' char local_temp_filename[FILENAME_LEN];;   char *info_suffixes[] = {e   "",s
   ".info",
   "-info",   (char *)NULL };  H /* A structure which associates the argument passed into a function with$    the result from that function. */ typedef struct {   char *called;f   char *result;; } CALLED_RESULTS;(  3 /* An array of remembered arguments and results. */ L static CALLED_RESULTS **opsys_callers_and_results = (CALLED_RESULTS **)NULL;& static int next_caller_and_result = 0;( static int callers_and_results_size = 0;  N /* Find the result for having already called opsys_filename () with CALLER. */ char *# find_opsys_filename_result (caller)       char *caller; {x*   if (caller && opsys_callers_and_results)     {w       register int i;e4       for (i = 0; opsys_callers_and_results[i]; i++) 	{B 	  if (strcmp (opsys_callers_and_results[i]->called, caller) == 0)3 	    return (opsys_callers_and_results[i]->result);i 	}     }r   return (char *)NULL;;  };   - /* Add an argument and result to our list. */h void& add_caller_and_result (caller, result)      char *caller, *result;h {    CALLED_RESULTS *new;  <   if (next_caller_and_result + 2 > callers_and_results_size)     {        int alloc_size; %       callers_and_results_size += 10;O  H       alloc_size = callers_and_results_size * sizeof (CALLED_RESULTS *);  5       opsys_callers_and_results = (CALLED_RESULTS **) 2 	xrealloc (opsys_callers_and_results, alloc_size);     }   <   new = (CALLED_RESULTS *)xmalloc (sizeof (CALLED_RESULTS));$   new->called = savestring (caller);<   new->result = result ? savestring (result) : (char *)NULL;  <   opsys_callers_and_results[next_caller_and_result++] = new;M   opsys_callers_and_results[next_caller_and_result] = (CALLED_RESULTS *)NULL;  }l  9 /* Expand the filename in partial to make a real name for ?    this operating system.  This looks in INFO_PATHS in order ton=    find the correct file.  If it can't find the file, it just.&    returns the path as you gave it. */ char * opsys_filename (partial)      char *partial;C {r   int initial_character;   char *my_infopath;  0   if (partial && (initial_character = *partial))     {t       char *possible_result;  #       if (initial_character == '/')f 	return (partial);  =       possible_result = find_opsys_filename_result (partial);        if (possible_result) 	return (possible_result);  #       if (initial_character == '~')  	{ 	  if (partial[1] == '/')( 	    {7 	      /* Return the concatenation of HOME and the restn 		 of the string. */5 	      strcpy (local_temp_filename, getenv ("HOME")); 1 	      strcat (local_temp_filename, &partial[2]);G$ 	      return (local_temp_filename); 	    } 	  elsea 	    {! 	      struct passwd *user_entry;r 	      int i, c; 	      char username[257];  ' 	      for (i = 1; c = partial[i]; i++), 		{, 		  if (c == '/')  		    break; 		  else 		    username[i - 1] = c; 		}  	      username[i - 1] = '\0';  / 	      if (!(user_entry = getpwnam (username)))1 		{2- 		  display_error ("Not a registered user!");n 		  return (partial);v 		}p8 	      strcpy (local_temp_filename, user_entry->pw_dir);1 	      strcat (local_temp_filename, &partial[i]);w$ 	      return (local_temp_filename); 	    } 	}  %       if (initial_character == '.' &&dC 	  (partial[1] == '/' || (partial[1] == '.' && partial[2] == '/')))n 	{ #if defined (USG)m3 	  if (!getcwd (local_temp_filename, FILENAME_LEN))w #else $ 	  if (!getwd (local_temp_filename)) #endif 	    {+ 	      display_error (local_temp_filename);= 	      return (partial); 	    }  % 	  strcat (local_temp_filename, "/");m) 	  strcat (local_temp_filename, partial);=  	  return (local_temp_filename); 	}  M       /* If the current info file has a directory, then search that directory  	 first. */w       {  	register char *ptr, *file;w  7 	file = find_opsys_filename_result (current_info_file);   @ 	if (file && (ptr = (char *)rindex (file, '/')) != (char *)NULL) 	  {% 	    register int len = (ptr - file);o   	    my_infopath = (char *)t7 	      xmalloc (2 + strlen (file) + strlen (infopath));*  & 	    strncpy (my_infopath, file, len);2 	    sprintf (my_infopath + len, ":%s", infopath); 	  } 	else	' 	  my_infopath = savestring (infopath);*       }*  N       if (opsys_info_file_in_path (partial, my_infopath, local_temp_filename)) 	{ 	  free (my_infopath);8 	  add_caller_and_result (partial, local_temp_filename);  	  return (local_temp_filename); 	}         free (my_infopath);t     }    return (partial);r }o  + #if !defined (S_ISREG) && defined (S_IFREG)x0 #  define S_ISREG(m) (((m) & S_IFMT) == S_IFREG)  #endif /* !S_ISREG && S_IFREG */  + #if !defined (S_ISDIR) && defined (S_IFDIR)f0 #  define S_ISDIR(m) (((m) & S_IFMT) == S_IFDIR)  #endif /* !S_ISDIR && S_IFDIR */  = /* Scan the list of directories in PATH looking for FILENAME.g?    If we find one that is a regular file, stuff the answer into;J    RETURN_STRING.  Return non-zero if a file was found, zero otherwise. */ int 7 opsys_info_file_in_path (filename, path, return_string)t      char *filename, *path;i      char *return_string;e {U   struct stat finfo;-   char *temp_dirname, *extract_colon_unit (); "   char *test_file = return_string;"   int statable, dirname_index = 0;  B   while (temp_dirname = extract_colon_unit (path, &dirname_index))     {O(       register int i, pre_suffix_length;  '       strcpy (test_file, temp_dirname);f;       if (temp_dirname[(strlen (temp_dirname)) - 1] != '/')  	strcat (test_file, "/");E#       strcat (test_file, filename);e  -       pre_suffix_length = strlen (test_file);S         free (temp_dirname);  (       for (i = 0; info_suffixes[i]; i++) 	{< 	  strcpy (test_file + pre_suffix_length, info_suffixes[i]);  . 	  statable = (stat (test_file, &finfo) == 0);  B 	  /* If we have found a regular file, then use that.  Else, if weF 	     have found a directory, look in that directory for this file. */ 	  if (statable) 	    {# 	      if (S_ISREG (finfo.st_mode));
 		return (1);y( 	      else if (S_ISDIR (finfo.st_mode)) 		{O+ 		  char *newpath = savestring (test_file); 9 		  char *filename_only = (char *)rindex (filename, '/');n   		  if (opsys_info_file_in_pathh2 		      (filename_only ? filename_only : filename,! 		       newpath, return_string))c 		    {n 		      free (newpath);  		      return (1);y 		    }  		}e 	    } 	}     }E
   return (0);t }t  F /* Given a string containing units of information separated by colons,G    return the next one pointed to by IDX, or NULL if there are no more.i3    Advance IDX to the character after the colon. */  char *  extract_colon_unit (string, idx)      char *string;      int *idx; {s   register int i, start;     i = start = *idx;r(   if ((i >= strlen (string)) || !string)     return ((char *) NULL);e  '   while (string[i] && string[i] != ':')C     i++;   if (i == start)/     {L       return ((char *) NULL);      }    else     {a7       char *value = (char *) xmalloc (1 + (i - start));f3       strncpy (value, &string[start], (i - start));r       value[i - start] = '\0';       if (string[i]) 	++i;/       *idx = i;        return (value);(     }n }   F /* **************************************************************** */ /*								    */ /*			The echo area.				    */s /*								    */F /* **************************************************************** */  & WINDOW echo_area = {0, 0, 0, 0, 0, 0}; int echo_area_open_p = 0;O char modeline[256]; , WINDOW modeline_window = {0, 0, 0, 0, 0, 0};  7 /* Define the location of the echo area. Also inits theo    modeline as well. */i) init_echo_area (left, top, right, bottom) "      int left, top, right, bottom; {p/   echo_area.left = modeline_window.left = left;    echo_area.top = top;    modeline_window.top = top - 1;2   echo_area.right = modeline_window.right = right;   echo_area.bottom = bottom;/   modeline_window.bottom = modeline_window.top;  }t  B /* Make the echo_area_window be the current window, and only allow2    output in there.  Clear the window to start. */ new_echo_area () {    if (!echo_area_open_p)     {e       push_window ();a       set_window (&echo_area);       echo_area_open_p = 1;]     }h,   goto_xy (the_window.left, the_window.top);   clear_eop ();a })  + /* Return output to the previous window. */  close_echo_area () {f   if (!echo_area_open_p)     return;u     pop_window ();   echo_area_open_p = 0;f }   * /* Clear the contents of the echo area. */ clear_echo_area () {e   new_echo_area ();    close_echo_area ();* }y  & /* Create and display the modeline. */ make_modeline () {x;   int width = modeline_window.right - modeline_window.left;    char textual_position[6];r     if (pagetop == nodetop)f     {        if (pagebot == nodebot)d# 	sprintf (textual_position, "All"); 
       else# 	sprintf (textual_position, "Top");_     }u   else     {        if (pagebot == nodebot) # 	sprintf (textual_position, "Bot"); 
       else$ 	sprintf (textual_position, "%2d%%",4 		 100 * (pagetop - nodetop) / (nodebot - nodetop));     }s     4   sprintf (modeline, "Info: (%s)%s, %d lines ---%s",G 	   current_info_file, current_info_node, nodelines, textual_position);d     if (strnicmpA       (opsys_filename (current_info_file), last_loaded_info_file, ,        strlen (last_loaded_info_file)) != 0)     {s=       sprintf (&modeline[strlen (modeline)], ", Subfile: %s",t 	       last_loaded_info_file);e     }e      if (strlen (modeline) < width)     {S"       int idx = strlen (modeline);       while (idx != width) 	modeline[idx++] = '-';a       modeline[idx] = '\0';      }       if (strlen (modeline) > width)     modeline[width] = '\0';-   push_window ();g    set_window (&modeline_window);,   goto_xy (the_window.left, the_window.top);     if (terminal_inverse_begin)e%     do_term (terminal_inverse_begin);_    print_string ("%s", modeline);   if (terminal_inverse_begin)l&     do_term (terminal_end_attributes);     pop_window (); }    int typing_out = 0;m  6 /* Prepare to do output to the typeout window.  If the8    typeout window is already open, ignore this clown. */ open_typeout ()g {    if (typing_out)y     return;a     push_window ();r    set_window (&terminal_window);)   goto_xy (the_window.ch, the_window.cv);&!   typing_out = window_bashed = 1;  }t  . /* Close the currently open typeout window. */ close_typeout () {    if (inhibit_output)      inhibit_output = 0;d   else     {_'       do { untyi_char = getc (stdin); }s3         while (untyi_char == -1 && errno == EINTR);_         if (untyi_char == SPACE) 	untyi_char = 0;     }    pop_window ();   typing_out = 0;  }E   void * xrealloc (pointer, bytes)       char *pointer;t      int bytes;e {(
   void *temp;      if (pointer == (char *)NULL)$     temp = (void *) xmalloc (bytes);   else-     temp = (void *) realloc (pointer, bytes);a     if (temp == (void *)NULL)i     { 5       fprintf (stderr, "Virtual memory exhausted\n");i       restore_io ();       exit (2);      }r   return (temp); }    void * xmalloc (bytes)       int bytes;  {]'   void *temp = (void *) malloc (bytes);p     if (temp == (void *) NULL)     {r5       fprintf (stderr, "Virtual memory exhausted\n");v       restore_io ();       exit (2);a     }r   return (temp); } 