@ ;; Info package for Emacs  -- could use a "create node" feature.: ;; Copyright (C) 1985, 1986 Free Software Foundation, Inc.  " ;; This file is part of GNU Emacs.  D ;; GNU Emacs is free software; you can redistribute it and/or modifyG ;; it under the terms of the GNU General Public License as published by F ;; the Free Software Foundation; either version 1, or (at your option) ;; any later version.   ? ;; GNU Emacs is distributed in the hope that it will be useful, A ;; but WITHOUT ANY WARRANTY; without even the implied warranty of @ ;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/ ;; GNU General Public License for more details.   D ;; You should have received a copy of the GNU General Public License@ ;; along with GNU Emacs; see the file COPYING.  If not, write toH ;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.   (provide 'info)    (defvar Info-history nil'   "List of info nodes user has visited. ? Each element of list is a list (FILENAME NODENAME BUFFERPOS).")    (defvar Info-enable-edit nilO   "Non-nil means the \\[Info-edit] command in Info can edit the current node.")   " (defvar Info-enable-active-nodes tB   "Non-nil allows Info to execute Lisp code associated with nodes.6 The Lisp code is executed when the node is selected.")   (defvar Info-directory nil4   "Default directory for Info documentation files.")   (defvar Info-current-file nil 3   "Info file that Info is now looking at, or nil.")     (defvar Info-current-subfile nil:   "Info subfile that is actually in the *info* buffer now,9 or nil if current info file is not split into subfiles.")    (defvar Info-current-node nil 6   "Name of node that Info is now looking at, or nil.")  + (defvar Info-tag-table-marker (make-marker) A   "Marker pointing at beginning of current Info file's tag table. 1 Marker points nowhere if file has no tag table.")    (defun info ()*   "Enter Info, the documentation browser."   (interactive)    (if (get-buffer "*info*") !       (switch-to-buffer "*info*")      (Info-directory)))  B ;; Go to an info node specified as separate filename and nodename.I ;; no-going-back is non-nil if recovering from an error in this function; = ;; it says do not attempt further (recursive) error recovery. A (defun Info-find-node (filename nodename &optional no-going-back) >   ;; Convert filename to lower case if not found as specified.   ;; Expand it.    (if filename       (let (temp) 3 	(setq filename (substitute-in-file-name filename)) & 	(setq temp (expand-file-name filename" 				     ;; Use Info's default dir1 				     ;; unless the filename starts with `./'. 2 				     (if (not (string-match "^\\./" filename)) 					 Info-directory)))  	(if (file-exists-p temp)  	    (setq filename temp) , 	  (if (file-exists-p (concat temp ".info")), 	      (setq filename (concat temp ".info"))F 	    (setq temp (expand-file-name (downcase filename) Info-directory)) 	    (if (file-exists-p temp)  		(setq filename temp)0 	      (if (file-exists-p (concat temp ".info"))) 		  (setq filename (concat temp ".info")) & 		(error "Info file %s does not exist": 		       (expand-file-name filename Info-directory))))))))$   ;; Record the node we are leaving.1   (if (and Info-current-file (not no-going-back))        (setq Info-history= 	    (cons (list Info-current-file Info-current-node (point))  		  Info-history)))    ;; Go into info buffer.    (switch-to-buffer "*info*")     (or (eq major-mode 'Info-mode)       (Info-mode))	   (widen)    (setq Info-current-node nil)   (unwind-protect        (progn 	;; Switch files if necessary  	(or (null filename)' 	    (equal Info-current-file filename) " 	    (let ((buffer-read-only nil))" 	      (setq Info-current-file nil 		    Info-current-subfile nil)  	      (erase-buffer) ( 	      (insert-file-contents filename t)" 	      (set-buffer-modified-p nil)> 	      (setq default-directory (file-name-directory filename))H 	      ;; See whether file has a tag table.  Record the location if yes.- 	      (set-marker Info-tag-table-marker nil)  	      (goto-char (point-max)) 	      (forward-line -8) 	      (or (equal nodename "*") 7 		  (not (search-forward "\^_\nEnd tag table\n" nil t))  		  (let (pos)2 		    ;; We have a tag table.  Find its beginning." 		    ;; Is this an indirect file?( 		    (search-backward "\nTag table:\n") 		    (setq pos (point)) 		    (if (save-excursion  			  (forward-line 2) ! 			  (looking-at "(Indirect)\n")) 0 			;; It is indirect.  Copy it to another buffer6 			;; and record that the tag table is in that buffer. 			(save-excursion" 			  (let ((buf (current-buffer))); 			    (set-buffer (get-buffer-create " *info tag table*"))   			    (setq case-fold-search t) 			    (erase-buffer) $ 			    (insert-buffer-substring buf)( 			    (set-marker Info-tag-table-marker 					(match-end 0)))) 0 		     (set-marker Info-tag-table-marker pos)))) 	      (setq Info-current-file3 		    (file-name-sans-versions buffer-file-name))))  	(if (equal nodename "*") - 	    (progn (setq Info-current-node nodename)  		   (Info-set-mode-line))& 	  ;; Search file for a suitable node.6 	  ;; First get advice from tag table if file has one.- 	  ;; Also, if this is an indirect info file, / 	  ;; read the proper subfile into this buffer.  	  (let ((guesspos (point-min)) F 		(regexp (concat "Node: *" (regexp-quote nodename) " *[,\t\n\177]")))0 	    (if (marker-position Info-tag-table-marker) 		(save-excursion 6 		  (set-buffer (marker-buffer Info-tag-table-marker))% 		  (goto-char Info-tag-table-marker) ( 		  (if (re-search-forward regexp nil t) 		      (progn* 			(setq guesspos (read (current-buffer)))" 			;; If this is an indirect file,1 			;; determine which file really holds this node  			;; and read it in. 8 			(if (not (eq (current-buffer) (get-buffer "*info*"))) 			    (setq guesspos % 				  (Info-read-subfile guesspos)))) 0 		    (error "No such node: \"%s\"" nodename))))4 	    (goto-char (max (point-min) (- guesspos 1000)))D 	    ;; Now search from our advised position (or from beg of buffer)  	    ;; to find the actual node. 	    (catch 'foo, 	      (while (search-forward "\n\^_" nil t) 		(forward-line 1) 		(let ((beg (point))) 		  (forward-line 1)) 		  (if (re-search-backward regexp beg t)  		      (throw 'foo t)))) , 	      (error "No such node: %s" nodename))) 	  (Info-select-node))) 7     ;; If we did not finish finding the specified node, #     ;; go back to the previous one. '     (or Info-current-node no-going-back ! 	(let ((hist (car Info-history))) ) 	  (setq Info-history (cdr Info-history)) / 	  (Info-find-node (nth 0 hist) (nth 1 hist) t)  	  (goto-char (nth 2 hist)))))   (goto-char (point-min)))  " (defun Info-read-subfile (nodepos)4   (set-buffer (marker-buffer Info-tag-table-marker))   (goto-char (point-min))    (search-forward "\n\^_")   (let (lastfilepos  	lastfilename)     (forward-line 2)     (catch 'foo %       (while (not (looking-at "\^_"))  	(if (not (eolp))  	    (let ((beg (point)) 		  thisfilepos thisfilename)  	      (search-forward ": ")@ 	      (setq thisfilename  (buffer-substring beg (- (point) 2)))1 	      (setq thisfilepos (read (current-buffer))) " 	      (if (> thisfilepos nodepos) 		  (throw 'foo t)) ' 	      (setq lastfilename thisfilename) & 	      (setq lastfilepos thisfilepos)) 	  (forward-line 1))))&     (set-buffer (get-buffer "*info*"))1     (or (equal Info-current-subfile lastfilename)  	(let ((buffer-read-only nil)) 	  (setq buffer-file-name nil)
 	  (widen) 	  (erase-buffer) & 	  (insert-file-contents lastfilename) 	  (set-buffer-modified-p nil)- 	  (setq Info-current-subfile lastfilename)))      (goto-char (point-min))      (search-forward "\n\^_"))     (+ (- nodepos lastfilepos) (point))))   ) ;; Select the info node that point is in.  (defun Info-select-node ()   (save-excursion     ;; Find beginning of node.     (search-backward "\n\^_")    (forward-line 2) 0    ;; Get nodename spelled as it is in the node.$    (re-search-forward "Node:[ \t]*")    (setq Info-current-node 	 (buffer-substring (point)  			   (progn$ 			    (skip-chars-forward "^,\t\n") 			    (point))))     (Info-set-mode-line)k%    ;; Find the end of it, and narrow.o    (beginning-of-line)    (let (active-expression)r      (narrow-to-region (point)2 		       (if (re-search-forward "\n[\^_\f]" nil t) 			   (prog1 			    (1- (point))o- 			    (if (looking-at "[\n\^_\f]*execute: ")r
 				(progn 				  (goto-char (match-end 0))e 				  (setq active-expressione  					(read (current-buffer)))))) 			 (point-max))) >      (if Info-enable-active-nodes (eval active-expression)))))   (defun Info-set-mode-line ()'   (setq mode-line-buffer-identification; 	(concat 	 "Info:  (" 	 (if Info-current-fileO0 	     (file-name-nondirectory Info-current-file) 	   "")s 	 ")"; 	 (or Info-current-node ""))))  C ;; Go to an info node specified with a filename-and-nodename string 2 ;; of the sort that is found in pointers in nodes.    (defun Info-goto-node (nodename)J   "Go to info node named NAME.  Give just NODENAME or (FILENAME)NODENAME."   (interactive "sGoto node: ")   (let (filename) H     (string-match "\\s *\\((\\s *\\([^\t)]*\\)\\s *)\\s *\\|\\)\\(.*\\)"
 		  nodename)s<     (setq filename (if (= (match-beginning 1) (match-end 1)) 		       "" > 		     (substring nodename (match-beginning 2) (match-end 2)))C 	  nodename (substring nodename (match-beginning 3) (match-end 3)))d4     (let ((trim (string-match "\\s *\\'" filename)))<       (if trim (setq filename (substring filename 0 trim))))4     (let ((trim (string-match "\\s *\\'" nodename)))<       (if trim (setq nodename (substring nodename 0 trim))))9     (Info-find-node (if (equal filename "") nil filename)l0 		    (if (equal nodename "") "Top" nodename))))   (defvar Info-last-search nil5   "Default regexp for Info S command to search for.").   (defun Info-search (regexp)rJ   "Search for REGEXP, starting from point, and select node it's found in."$   (interactive "sSearch (regexp): ")   (if (equal regexp "") $       (setq regexp Info-last-search)#     (setq Info-last-search regexp))e   (let ((found ()) current 	(onode Info-current-node) 	(ofile Info-current-file) 	(opoint (point))o! 	(osubfile Info-current-subfile))      (save-excursion.       (save-restriction- 	(widen)  	(if (null Info-current-subfile)< 	    (progn (re-search-forward regexp) (setq found (point))) 	  (condition-case err> 	      (progn (re-search-forward regexp) (setq found (point))) 	    (search-failed nil)))))M     (if (not found) ;can only happen in subfile case -- else would have erred( 	(unwind-protect 	    (let ((list ()))l9 	      (set-buffer (marker-buffer Info-tag-table-marker)); 	      (goto-char (point-min))* 	      (search-forward "\n\^_\nIndirect:") 	      (save-restriction 		(narrow-to-region (point)	% 				  (progn (search-forward "\n\^_")t 					 (1- (point)))) 		(goto-char (point-min))i. 		(search-forward (concat "\n" osubfile ": ")) 		(beginning-of-line)" 		(while (not (eobp))m, 		  (re-search-forward "\\(^.*\\): [0-9]+$")# 		  (goto-char (+ (match-end 1) 2))e2 		  (setq list (cons (cons (read (current-buffer))+ 					 (buffer-substring (match-beginning 1)e 							   (match-end 1)))	
 				   list))l# 		  (goto-char (1+ (match-end 0))))d 		(setq list (nreverse list)  		      current (car (car list)) 		      list (cdr list)))d 	      (while list6 		(message "Searching subfile %s..." (cdr (car list)))& 		(Info-read-subfile (car (car list))) 		(setq list (cdr list)) 		(goto-char (point-min))f& 		(if (re-search-forward regexp nil t)$ 		    (setq found (point) list ()))) 	      (if found 		  (message "")) 		(signal 'search-failed (list regexp))))c 	  (if (not found)( 	      (progn (Info-read-subfile opoint) 		     (goto-char opoint)c 		     (Info-select-node)))))e     (widen)a     (goto-char found)e     (Info-select-node),     (or (and (equal onode Info-current-node)& 	     (equal ofile Info-current-file))3 	(setq Info-history (cons (list ofile onode opoint)  				 Info-history))))) y6 (defun Info-extract-pointer (name &optional errorname)   (save-excursione    (goto-char (point-min))    (forward-line 1)r3    (if (re-search-backward (concat name ":") nil t)t
        nilF      (error (concat "Node has no " (capitalize (or errorname name)))))    (goto-char (match-end 0))    (Info-following-node-name)))   8 (defun Info-following-node-name (&optional allowedchars)   (skip-chars-forward " \t")   (buffer-substring 
    (point)	    (progn D      (while (looking-at (concat "[" (or allowedchars "^,\t\n") "]"))C        (skip-chars-forward (concat (or allowedchars "^,\t\n") "("))t        (if (looking-at "(")t 	   (skip-chars-forward "^)")))e      (skip-chars-backward " ")      (point))))b   (defun Info-next ()u%   "Go to the next node of this node."l   (interactive)e1   (Info-goto-node (Info-extract-pointer "next")))    (defun Info-prev ()r)   "Go to the previous node of this node."-   (interactive)cC   (Info-goto-node (Info-extract-pointer "prev[ious]*" "previous")))    (defun Info-up ()i)   "Go to the superior node of this node."i   (interactive)f/   (Info-goto-node (Info-extract-pointer "up")))r   (defun Info-last ()	%   "Go back to the last node visited."f   (interactive)e   (or Info-history:       (error "This is the first Info node you looked at"))!   (let (filename nodename opoint);,     (setq filename (car (car Info-history)))2     (setq nodename (car (cdr (car Info-history))))6     (setq opoint (car (cdr (cdr (car Info-history)))))*     (setq Info-history (cdr Info-history))&     (Info-find-node filename nodename)*     (setq Info-history (cdr Info-history))     (goto-char opoint)))   (defun Info-directory ()"   "Go to the Info directory node."   (interactive)s   (Info-find-node "dir" "top")); f+ (defun Info-follow-reference (footnotename)h>   "Follow cross reference named NAME to the node it refers to.3 NAME may be an abbreviation of the reference name."	   (interactive#    (let ((completion-ignore-case t)o 	 completions str i)      (save-excursion        (goto-char (point-min))E        (while (re-search-forward "\\*note[ \n\t]*\\([^:]*\\):" nil t)  	 (setq str (buffer-substring) 		    (match-beginning 1)l 		    (1- (point)))) 	 (setq i 0)1 	 (while (setq i (string-match "[ \n\t]+" str i)) - 	   (setq str (concat (substring str 0 i) " ")' 			     (substring str (match-end 0))))t 	   (setq i (1+ i))) 	 (setq completionso 	       (cons (cons str nil) 		     completions))))      (if completionsG 	 (list (completing-read "Follow reference named: " completions nil t))o4        (error "No cross-references in this node"))))<   (let (target beg i (str (concat "\\*note " footnotename))),     (while (setq i (string-match " " str i))O       (setq str (concat (substring str 0 i) "[ \t\n]+" (substring str (1+ i))))f       (setq i (+ i 6)))e     (save-excursionm       (goto-char (point-min))k'       (or (re-search-forward str nil t)c6 	  (error "No cross-reference named %s" footnotename))+       (goto-char (+ (match-beginning 0) 5))        (setq targetC 	    (Info-extract-menu-node-name "Bad format cross reference" t)))s6     (while (setq i (string-match "[ \t\n]+" target i))5       (setq target (concat (substring target 0 i) " "t( 			   (substring target (match-end 0))))       (setq i (+ i 1)))(     (Info-goto-node target)))   D (defun Info-extract-menu-node-name (&optional errmessage multi-line)   (skip-chars-forward " \t\n")   (let ((beg (point))  	str i)e     (skip-chars-forward "^:")o     (forward-char 1)
     (setq stre 	  (if (looking-at ":")a* 	      (buffer-substring beg (1- (point)))! 	    (skip-chars-forward " \t\n") D 	    (Info-following-node-name (if multi-line "^.,\t"  "^.,\t\n"))))-     (while (setq i (string-match "\n" str i))        (aset str i ?\ )))	     str))a  % (defun Info-menu-item-sequence (list)a
   (while listn     (Info-menu-item (car list))      (setq list (cdr list))))   (defun Info-menu (menu-item)9   "Go to node for menu item named (or abbreviated) NAME."\   (interactive    (let ((completions '())A 	 ;; If point is within a menu item, use that item as the defaultt 	 (default nil)f
 	 (p (point)) 
 	 (last nil))r      (save-excursion        (goto-char (point-min))3        (if (not (search-forward "\n* menu:" nil t))e# 	   (error "No menu in this node"))r         (while (re-search-forward! 		"\n\\* \\([^:\t\n]*\\):" nil t)r 	 (if (and (null default) # 		  (prog1 (if last (< last p) nil) & 		    (setq last (match-beginning 0))) 		  (<= p last))- 	     (setq default (car (car completions))))	1 	 (setq completions (cons (cons (buffer-substringe 					 (match-beginning 1)r 					 (match-end 1)) 				       (match-beginning 1))b 				 completions))) #        (if (and (null default) last- 		(< last p)' 		(<= p (progn (end-of-line) (point))))o, 	   (setq default (car (car completions)))))      (let ((item nil))        (while (null item)f. 	 (setq item (let ((completion-ignore-case t))$ 		      (completing-read (if default* 					   (format "Menu item (default %s): " 						   default)  					   "Menu item: ") 				       completions nil t)))nD 	 ;; we rely on the bug (which RMS won't change for his own reasons)A 	 ;; that ;; completing-read accepts an input of "" even when the E 	 ;; require-match argument is true and "" is not a valid possibility" 	 (if (string= item "")t 	     (if defaultm 		 (setq item default) 	         ;; ask again 	         (setq item nil))))        (list item))))-6   (Info-goto-node (Info-extract-menu-item menu-item)))   ) (defun Info-extract-menu-item (menu-item)-   (save-excursionl     (goto-char (point-min))q*     (or (search-forward "\n* menu:" nil t)  	(error "No menu in this node"))<     (or (search-forward (concat "\n* " menu-item ":") nil t)1 	(search-forward (concat "\n* " menu-item) nil t)l  	(error "No such item in menu"))     (beginning-of-line)p     (forward-char 2)#     (Info-extract-menu-node-name)))t  ) (defun Info-extract-menu-counting (count)    (save-excursionh     (goto-char (point-min))E*     (or (search-forward "\n* menu:" nil t)  	(error "No menu in this node"))+     (or (search-forward "\n* " nil t count) ! 	(error "Too few items in menu")) #     (Info-extract-menu-node-name)))    (defun Info-first-menu-item ()*   "Go to the node of the first menu item."   (interactive)o2   (Info-goto-node (Info-extract-menu-counting 1)))   (defun Info-second-menu-item ()o+   "Go to the node of the second menu item.")   (interactive)-2   (Info-goto-node (Info-extract-menu-counting 2)))   (defun Info-third-menu-item ()*   "Go to the node of the third menu item."   (interactive)f2   (Info-goto-node (Info-extract-menu-counting 3)))   (defun Info-fourth-menu-item () +   "Go to the node of the fourth menu item.")   (interactive)u2   (Info-goto-node (Info-extract-menu-counting 4)))   (defun Info-fifth-menu-item ()*   "Go to the node of the fifth menu item."   (interactive) 2   (Info-goto-node (Info-extract-menu-counting 5)))   (defun Info-exit () -   "Exit Info by selecting some other buffer."s   (interactive)n:   (switch-to-buffer (prog1 (other-buffer (current-buffer))' 			   (bury-buffer (current-buffer)))))^   (defun Info-undefined ()&   "Make command be undefined in Info."   (interactive)e	   (ding))-   (defun Info-help ()-   "Enter the Info tutorial."   (interactive)h   (Info-find-node "info" 		  (if (< (window-height) 23) 		      "Help-Small-Screen"e 		    "Help")))u   (defun Info-summary ()1   "Display a brief summary of all Info commands."s   (interactive)u   (save-window-excursion     (switch-to-buffer "*Help*")c     (erase-buffer)'     (insert (documentation 'Info-mode)))     (goto-char (point-min))r     (let (ch flag)K       (while (progn (setq flag (not (pos-visible-in-window-p (point-max)))) 0 		    (message (if flag "Type Space to see more"* 			       "Type Space to return to Info"))( 		    (if (/= ?\  (setq ch (read-char))), 			(progn (setq unread-command-char ch) nil) 		      flag)) 	(scroll-up)))))   (defvar Info-mode-map nilo%   "Keymap containing Info commands.")- (if Info-mode-mape     nili$   (setq Info-mode-map (make-keymap))!   (suppress-keymap Info-mode-map)n5   (define-key Info-mode-map "." 'beginning-of-buffer)v+   (define-key Info-mode-map " " 'scroll-up)(6   (define-key Info-mode-map "1" 'Info-first-menu-item)7   (define-key Info-mode-map "2" 'Info-second-menu-item) 6   (define-key Info-mode-map "3" 'Info-third-menu-item)7   (define-key Info-mode-map "4" 'Info-fourth-menu-item)n6   (define-key Info-mode-map "5" 'Info-fifth-menu-item)+   (define-key Info-mode-map "6" 'undefined) +   (define-key Info-mode-map "7" 'undefined)g+   (define-key Info-mode-map "8" 'undefined)"+   (define-key Info-mode-map "9" 'undefined)l+   (define-key Info-mode-map "0" 'undefined)n.   (define-key Info-mode-map "?" 'Info-summary)5   (define-key Info-mode-map "b" 'beginning-of-buffer)n0   (define-key Info-mode-map "d" 'Info-directory)+   (define-key Info-mode-map "e" 'Info-edit)f7   (define-key Info-mode-map "f" 'Info-follow-reference)G0   (define-key Info-mode-map "g" 'Info-goto-node)+   (define-key Info-mode-map "h" 'Info-help)e+   (define-key Info-mode-map "l" 'Info-last)-+   (define-key Info-mode-map "m" 'Info-menu)d+   (define-key Info-mode-map "n" 'Info-next)f+   (define-key Info-mode-map "p" 'Info-prev)t+   (define-key Info-mode-map "q" 'Info-exit) -   (define-key Info-mode-map "s" 'Info-search)r)   (define-key Info-mode-map "u" 'Info-up)a1   (define-key Info-mode-map "\177" 'scroll-down))   % (put 'Info-mode 'mode-class 'special)s (defun Info-mode ()rP   "Info mode provides commands for browsing through the Info documentation tree.> Documentation in Info is divided into \"nodes\", each of which: discusses one topic and contains references to other nodes: which discuss related topics.  Info has commands to follow( the references and show you other nodes.   h	Invoke the Info tutorial.    Selecting other nodes:) n	Move to the \"next\" node of this node. - p	Move to the \"previous\" node of this node.s u	Move \"up\" from this node.o5 m	Pick menu item specified by name (or abbreviation).o8 	Picking a menu item causes another node to be selected.5 f	Follow a cross reference.  Reads name of reference.l$ l	Move to the last node you were at.   Moving within a node:s6 Space	scroll forward a page.     DEL  scroll backward. b	Go to beginning of node.   Advanced commands:1 q	Quit Info: reselect previously selected buffer. ! e	Edit contents of selected node.	! 1	Pick first item in node's menu.)7 2, 3, 4, 5   Pick second ... fifth item in node's menu.c! g	Move to node specified by name.o; 	You may include a filename as well, as (FILENAME)NODENAME.w5 s	Search through this Info file for specified regexp, < 	and select the node in which the next occurrence is found."   (kill-all-local-variables)   (setq major-mode 'Info-mode)   (setq mode-name "Info")    (use-local-map Info-mode-map)r+   (set-syntax-table text-mode-syntax-table) 2   (setq local-abbrev-table text-mode-abbrev-table)   (setq case-fold-search t)    (setq buffer-read-only t)n*   (make-local-variable 'Info-current-file)-   (make-local-variable 'Info-current-subfile)b*   (make-local-variable 'Info-current-node).   (make-local-variable 'Info-tag-table-marker)%   (make-local-variable 'Info-history)i   (Info-set-mode-line))t   (defvar Info-edit-map nilc2   "Local keymap used within `e' command of Info.") (if Info-edit-map)     nils2   (setq Info-edit-map (copy-keymap text-mode-map))9   (define-key Info-edit-map "\C-c\C-c" 'Info-cease-edit))l   (defun Info-edit-mode ()7   "Major mode for editing the contents of an Info node.-3 Like text mode with the addition of Info-cease-edit ( which returns to Info mode for browsing. \\{Info-edit-map}"   )o   (defun Info-edit ()s'   "Edit the contents of this Info node.n6 Allowed only if variable Info-enable-edit is non-nil."   (interactive)g   (or Info-enable-edit2       (error "Editing info nodes is not enabled"))   (use-local-map Info-edit-map)e#   (setq major-mode 'Info-edit-mode))   (setq mode-name "Info Edit")8   (kill-local-variable 'mode-line-buffer-identification)   (setq buffer-read-only nil).   ;; Make mode line update.(-   (set-buffer-modified-p (buffer-modified-p))u#   (message (substitute-command-keys > 	     "Editing: Type \\[Info-cease-edit] to return to info")))   (defun Info-cease-edit ()i9   "Finish editing Info node; switch back to Info proper.")   (interactive)oB   ;; Do this first, so nothing has changed if user C-g's at query.   (and (buffer-modified-p)#        (y-or-n-p "Save the file? ")(        (save-buffer))    (use-local-map Info-mode-map)n   (setq major-mode 'Info-mode)   (setq mode-name "Info")p   (Info-set-mode-line)   (setq buffer-read-only t)-   ;; Make mode line update.n-   (set-buffer-modified-p (buffer-modified-p))c.   (and (marker-position Info-tag-table-marker)        (buffer-modified-p)I        (message "Tags may have changed.  Use Info-tagify if necessary"))) 