+ ;; Info support functions package for Emacs 4 ;; Copyright (C) 1986 Free Software Foundation, Inc.  " ;; This file is part of GNU Emacs.  D ;; GNU Emacs is free software; you can redistribute it and/or modifyG ;; it under the terms of the GNU General Public License as published by F ;; the Free Software Foundation; either version 1, or (at your option) ;; any later version.   ? ;; GNU Emacs is distributed in the hope that it will be useful, A ;; but WITHOUT ANY WARRANTY; without even the implied warranty of @ ;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/ ;; GNU General Public License for more details.   D ;; You should have received a copy of the GNU General Public License@ ;; along with GNU Emacs; see the file COPYING.  If not, write toH ;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.   (require 'info)    (defun Info-tagify () ;   "Create or update Info-file tag table in current buffer."    (interactive) -   ;; Save and restore point and restrictions. %   ;; save-restrictions would not work 8   ;; because it records the old max relative to the end.,   ;; We record it relative to the beginning.   (let ((omin (point-min)) 	(omax (point-max)) + 	(nomax (= (point-max) (1+ (buffer-size))))  	(opoint (point)))     (unwind-protect  	(progn 
 	  (widen) 	  (goto-char (point-min))0 	  (if (search-forward "\^_\nIndirect:\n" nil t)0 	      (message "Cannot tagify split info file")7 	    (let ((regexp "Node:[ \t]*\\([^,\n\t]\\)*[,\t\n]")  		  (case-fold-search t)	 		  list) , 	      (while (search-forward "\n\^_" nil t) 		(forward-line 1) 		(let ((beg (point))) 		  (forward-line 1)) 		  (if (re-search-backward regexp beg t)  		      (setq list$ 			    (cons (list (buffer-substring 					  (match-beginning 1) 					  (match-end 1)) 	 					beg)  				  list)))))  	      (goto-char (point-max)) 	      (forward-line -8)$ 	      (let ((buffer-read-only nil))3 		(if (search-forward "\^_\nEnd tag table\n" nil t)  		    (let ((end (point)))* 		      (search-backward "\nTag table:\n") 		      (beginning-of-line) % 		      (delete-region (point) end)))  		(goto-char (point-max))   		(insert "\^_\f\nTag table:\n")- 		(move-marker Info-tag-table-marker (point))  		(setq list (nreverse list)) 
 		(while list , 		  (insert "Node: " (car (car list)) ?\177)3 		  (princ (car (cdr (car list))) (current-buffer))  		  (insert ?\n) 		  (setq list (cdr list))) % 		(insert "\^_\nEnd tag table\n")))))        (goto-char opoint)9       (narrow-to-region omin (if nomax (1+ (buffer-size)) % 			       (min omax (point-max)))))))    (defun Info-split ()G   "Split an info file into an indirect file plus bounded-size subfiles. : Each subfile will be up to 50000 characters plus one node.  H To use this command, first visit a large Info file that has a tag table.8 The buffer is modified into a (small) indirect info file< which should be saved in place of the original visited file.  G The subfiles are written in the same directory the original file is in, M with names generated by appending `-' and a number to the original file name.   B The indirect file still functions as an Info file, but it contains0 just the tag table and a directory of subfiles."   (interactive)    (if (< (buffer-size) 70000) 8       (error "This is too small to be worth splitting"))   (goto-char (point-min))    (search-forward "\^_")   (forward-char -1)    (let ((start (point))  	(chars-deleted 0)	 	subfiles  	(subfile-number 1)  	(case-fold-search t) 7 	(filename (file-name-sans-versions buffer-file-name)))      (goto-char (point-max))      (forward-line -8)      (setq buffer-read-only nil) 5     (or (search-forward "\^_\nEnd tag table\n" nil t) 3 	(error "Tag table required; use M-x Info-tagify")) &     (search-backward "\nTag table:\n")(     (if (looking-at "\nTag table:\n\^_")= 	(error "Tag table is just a skeleton; use M-x Info-tagify"))      (beginning-of-line)      (forward-char 1)     (save-restriction ,       (narrow-to-region (point-min) (point))       (goto-char (point-min)) )       (while (< (1+ (point)) (point-max)) 0 	(goto-char (min (+ (point) 50000) (point-max)))! 	(search-forward "\^_" nil 'move)  	(setq subfiles * 	      (cons (list (+ start chars-deleted). 			  (concat (file-name-nondirectory filename)% 				  (format "-%d" subfile-number)))  		    subfiles))= 	;; Put a newline at end of split file, to make Unix happier.  	(insert "\n")" 	(write-region (point-min) (point)8 		      (concat filename (format "-%d" subfile-number)))% 	(delete-region (1- (point)) (point))  	;; Back up over the final ^_. 	(forward-char -1)9 	(setq chars-deleted (+ chars-deleted (- (point) start)))  	(delete-region start (point)), 	(setq subfile-number (1+ subfile-number))))     (while subfiles        (goto-char start) $       (insert (nth 1 (car subfiles))+ 	      (format ": %d" (car (car subfiles)))  	      "\n")%       (setq subfiles (cdr subfiles)))      (goto-char start)      (insert "\^_\nIndirect:\n") %     (search-forward "\nTag Table:\n")      (insert "(Indirect)\n")))    (defun Info-validate () 5   "Check current buffer for validity as an Info file. : Check that every node pointer points to an existing node."   (interactive)    (save-excursion      (save-restriction 
       (widen)        (goto-char (point-min)) =       (if (search-forward "\nTag table:\n(Indirect)\n" nil t) F 	  (error "Don't yet know how to validate indirect info files: \"%s\""# 		 (buffer-name (current-buffer))))        (goto-char (point-min))        (let ((allnodes '(("*"))) 1 	    (regexp "Node:[ \t]*\\([^,\n\t]*\\)[,\t\n]")  	    (case-fold-search t)  	    (tags-losing nil) 	    (lossages ())) & 	(while (search-forward "\n\^_" nil t) 	  (forward-line 1)  	  (let ((beg (point)))  	    (forward-line 1) * 	    (if (re-search-backward regexp beg t) 		(let ((name (downcase  			      (buffer-substring 			        (match-beginning 1)
 				(progn 				  (goto-char (match-end 1)) ! 				  (skip-chars-backward " \t")  				  (point)))))) 		  (if (assoc name allnodes)  		      (setq lossages2 			    (cons (list name "Duplicate node-name" nil) 				  lossages)) 		      (setq allnodes 			    (cons (list name  					(progn  					  (end-of-line) 					  (and (re-search-backward  						"prev[ious]*:" beg t)  					       (progn  						 (goto-char (match-end 0)) 						 (downcase' 						   (Info-following-node-name))))) 	 					beg)  				  allnodes)))))))  	(goto-char (point-min))& 	(while (search-forward "\n\^_" nil t) 	  (forward-line 1)  	  (let ((beg (point)) 		thisnode next) 	    (forward-line 1) * 	    (if (re-search-backward regexp beg t) 		(save-restriction & 		  (search-forward "\n\^_" nil 'move)" 		  (narrow-to-region beg (point)) 		  (setq thisnode (downcase 				   (buffer-substring 				     (match-beginning 1) 				     (progn $ 				       (goto-char (match-end 1))& 				       (skip-chars-backward " \t") 				       (point))))) 		  (end-of-line) ( 		  (and (search-backward "next:" nil t)= 		       (setq next (Info-validate-node-name "invalid Next"))  		       (assoc next allnodes)5 		       (if (equal (car (cdr (assoc next allnodes)))  				  thisnode) 3 			   ;; allow multiple `next' pointers to one node  			   (let ((tem lossages))  			     (while tem/ 			       (if (and (equal (car (cdr (car tem))) # 					       "should have Previous")  					(equal (car (car tem))  					       next))1 				   (setq lossages (delq (car tem) lossages)))   			       (setq tem (cdr tem)))) 			 (setq lossages 			       (cons (list next 					   "should have Previous" 					   thisnode)  				     lossages))))  		  (end-of-line) 1 		  (if (re-search-backward "prev[ious]*:" nil t) 5 		      (Info-validate-node-name "invalid Previous"))  		  (end-of-line) % 		  (if (search-backward "up:" nil t) / 		      (Info-validate-node-name "invalid Up")) - 		  (if (re-search-forward "\n* Menu:" nil t) 1 		      (while (re-search-forward "\n\\* " nil t)  			(Info-validate-node-name ! 			  (concat "invalid menu item "  				  (buffer-substring (point)  						    (save-excursion % 						      (skip-chars-forward "^:")  						      (point))))% 			  (Info-extract-menu-node-name))))C 		  (goto-char (point-min))r< 		  (while (re-search-forward "\\*note[ \n]*[^:\t]*:" nil t)+ 		    (goto-char (+ (match-beginning 0) 5))b  		    (skip-chars-forward " \n") 		    (Info-validate-node-name# 		     (concat "invalid reference "F! 			     (buffer-substring (point)s 					       (save-excursion;  						 (skip-chars-forward "^:") 						 (point))))nG 		     (Info-extract-menu-node-name "Bad format cross-reference")))))))e4 	(setq tags-losing (not (Info-validate-tags-table))) 	(if (or lossages tags-losing); 	    (with-output-to-temp-buffer " *problems in info file*"  	      (while lossages 		(princ "In node \"") 		(princ (car (car lossages))) 		(princ "\", ")% 		(let ((tem (nth 1 (car lossages))));" 		  (cond ((string-match "\n" tem)1 			 (princ (substring tem 0 (match-beginning 0)))o 			 (princ "...")) 			(t  			 (princ tem)))) 		(if (nth 2 (car lossages)) 		    (progn 		      (princ ": ")+ 		      (let ((tem (nth 2 (car lossages)))) ! 			(cond ((string-match "\n" tem) 7 			       (princ (substring tem 0 (match-beginning 0))). 			       (princ "...")) 			      (ti 			       (princ tem))))))
 		(terpri)! 		(setq lossages (cdr lossages)))-D 	      (if tags-losing (princ "\nTags table must be recomputed\n")))! 	  ;; Here if info file is valid. : 	  ;; If we already made a list of problems, clear it out. 	  (save-excursion0 	    (if (get-buffer " *problems in info file*") 		(progn+ 		  (set-buffer " *problems in info file*")d% 		  (kill-buffer (current-buffer)))))s& 	  (message "File appears valid"))))))  4 (defun Info-validate-node-name (kind &optional name)
   (if name	       nilw     (goto-char (match-end 0))t     (skip-chars-forward " \t")      (if (= (following-char) ?\() 	nil       (setq name 	    (buffer-substring
 	     (point)  	     (progn$ 	      (skip-chars-forward "^,\t\n")  	      (skip-chars-backward " ") 	      (point))))))-   (if (null name)a	       niln     (setq name (downcase name)))7     (or (and (> (length name) 0) (= (aref name 0) ?\())g 	(assoc name allnodes) 	(setq lossages(3 	      (cons (list thisnode kind name) lossages))))    name)a  " (defun Info-validate-tags-table ()   (goto-char (point-min))s9   (if (not (search-forward "\^_\nEnd tag table\n" nil t))d       t      (not (catch 'losingp$ 	   (let* ((end (match-beginning 0))4 		  (start (progn (search-backward "\nTag table:\n") 				(1- (match-end 0)))) 		  tem) 	     (setq tem allnodes)o 	     (while tem 	       (goto-char start)(' 	       (or (equal (car (car tem)) "*")p% 		   (search-forward (concat "Node: "  					   (car (car tem))  					   "\177")f
 				   end t)d 		   (throw 'losing 'x)) 	       (setq tem (cdr tem)))t 	     (goto-char (1+ start))= 	     (while (looking-at ".*Node: \\(.*\\)\177\\([0-9]+\\)$").- 	       (setq tem (downcase (buffer-substringt 				     (match-beginning 1) 				     (match-end 1))))l' 	       (setq tem (assoc tem allnodes))n 	       (if (or (not tem)o 		       (< 1000 (prognh$ 				 (goto-char (match-beginning 2))' 				 (setq tem (- (car (cdr (cdr tem)))h$ 					      (read (current-buffer))))" 				 (if (> tem 0) tem (- tem))))) 		   (throw 'losing 'y)))o 	     (forward-line 1))i& 	   (or (looking-at "End tag table\n") 	       (throw 'losing 'z))  	   nil))))p t (defun batch-info-validate ())C   "Runs  Info-validate  on the files remaining on the command line.o= Must be used only with -batch, and kills emacs on completion.(A Each file will be processed even if an error occurred previously.lL For example, invoke \"emacs -batch -f batch-info-validate $info/ ~/*.info\""   (if (not noninteractive)=       (error "batch-info-validate may only be used -batch."))t   (let ((version-control t)a 	(auto-save-default nil) 	(find-file-run-dired nil) 	(kept-old-versions 259259)\ 	(kept-new-versions 259259))     (let ((error 0)M 	  filea 	  (files ()))#       (while command-line-args-left < 	(setq file (expand-file-name (car command-line-args-left)))" 	(cond ((not (file-exists-p file)). 	       (message ">> %s does not exist!" file) 	       (setq error 1 = 		     command-line-args-left (cdr command-line-args-left)))   	      ((file-directory-p file)(B 	       (setq command-line-args-left (nconc (directory-files file)* 					      (cdr command-line-args-left))))	 	      (t % 	       (setq files (cons file files) > 		     command-line-args-left (cdr command-line-args-left)))))       (while files 	(setq file (car files)a 	      files (cdr files))m 	(let ((lose nil)) 	  (condition-case err
 	      (progn 6 		(if buffer-file-name (kill-buffer (current-buffer))) 		(find-file file)& 		(buffer-flush-undo (current-buffer)) 		(set-buffer-modified-p nil)n 		(fundamental-mode) 		(let ((case-fold-search nil))  		  (goto-char (point-max))i; 		  (cond ((search-backward "\n\^_\^L\nTag table:\n" nil t) ) 			 (message "%s already tagified" file))f 			((< (point-max) 30000) 6 			 (message "%s too small to bother tagifying" file)) 			(tc$ 			 (message "Tagifying %s..." file) 			 (Info-tagify))+ 			 (message "Tagifying %s...done" file))))r/ 		(let ((loss-name " *problems in info file*")) 9 		  (message "Checking validity of info file %s..." file)t 		  (if (get-buffer loss-name)  		      (kill-buffer loss-name)) 		  (Info-validate)r$ 		  (if (not (get-buffer loss-name))E 		      nil ;(message "Checking validity of info file %s... OK" file) X 		    (message "----------------------------------------------------------------------")2 		    (message ">> PROBLEMS IN INFO FILE %s" file) 		    (save-excursion[ 		      (set-buffer loss-name); 		      (princ (buffer-substring (point-min) (point-max))))sX 		    (message "----------------------------------------------------------------------") 		    (setq error 1 lose t)))  		(if (and (buffer-modified-p) 			 (not lose))l0 		    (progn (message "Saving modified %s" file) 			   (save-buffer))))> 	    (error (message ">> Error: %s" (prin1-to-string err))))))       (kill-emacs error))))	