 ;;;; texinfmt.el  @ ;;; Emacs lisp functions to convert Texinfo files to Info files.  5 (defvar texinfmt-version "2.26 of 15 September 1992")     ;;; Robert J. Chassell          3 ;;; Please send bug reports to:  bob@gnu.ai.mit.edu   # ;;; Copyright (C) 1985, 1986, 1988, B ;;;               1990, 1991, 1992  Free Software Foundation, Inc.    # ;;; This file is part of GNU Emacs.   D ;; GNU Emacs is free software; you can redistribute it and/or modifyG ;; it under the terms of the GNU General Public License as published by F ;; the Free Software Foundation; either version 2, or (at your option) ;; any later version.   ? ;; GNU Emacs is distributed in the hope that it will be useful, A ;; but WITHOUT ANY WARRANTY; without even the implied warranty of @ ;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/ ;; GNU General Public License for more details.   D ;; You should have received a copy of the GNU General Public License@ ;; along with GNU Emacs; see the file COPYING.  If not, write toH ;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.     ;;; Variable definitions  I (require 'texinfo)              ; So `texinfo-footnote-style' is defined.   ( (defvar texinfo-format-syntax-table nil)   (defvar texinfo-vindex)  (defvar texinfo-findex)  (defvar texinfo-cindex)  (defvar texinfo-pindex)  (defvar texinfo-tindex)  (defvar texinfo-kindex)  (defvar texinfo-last-node) (defvar texinfo-node-names)  (defvar texinfo-enclosure-list)      ;;; Syntax table   (if texinfo-format-syntax-table      nil 8   (setq texinfo-format-syntax-table (make-syntax-table));   (modify-syntax-entry ?\" " " texinfo-format-syntax-table) ;   (modify-syntax-entry ?\\ " " texinfo-format-syntax-table) ;   (modify-syntax-entry ?@ "\\" texinfo-format-syntax-table) =   (modify-syntax-entry ?\^q "\\" texinfo-format-syntax-table) ;   (modify-syntax-entry ?\[ "." texinfo-format-syntax-table) ;   (modify-syntax-entry ?\] "." texinfo-format-syntax-table) ;   (modify-syntax-entry ?\( "." texinfo-format-syntax-table) ;   (modify-syntax-entry ?\) "." texinfo-format-syntax-table) ;   (modify-syntax-entry ?{ "(}" texinfo-format-syntax-table) ;   (modify-syntax-entry ?} "){" texinfo-format-syntax-table) <   (modify-syntax-entry ?\' "." texinfo-format-syntax-table))    4 ;;; Top level buffer and region formatting functions  1 (defun texinfo-format-buffer (&optional notagify) A   "Process the current buffer as texinfo code, into an Info file. D The Info file output is generated in a buffer visiting the Info file, names specified in the @setfilename command.  D Non-nil argument (prefix, if interactive) means don't make tag table? and don't split the file if large.  You can use Info-tagify and ! Info-split to do these manually."    (interactive "P") 0   (let ((lastmessage "Formatting Info file..."))     (message lastmessage)      (texinfo-format-buffer-1)      (if notagify         nil !       (if (> (buffer-size) 30000)            (prognM             (message (setq lastmessage "Making tags table for Info file..."))              (Info-tagify))) "       (if (> (buffer-size) 100000)           (prognA             (message (setq lastmessage "Splitting Info file..."))              (Info-split))))       (message (concat lastmessageK                      (if (interactive-p) "done.  Now save it." "done.")))))   2 (defvar texinfo-region-buffer-name "*Info Region*"E   "*Name of the temporary buffer used by \\[texinfo-format-region].")   = (defun texinfo-format-region (region-beginning region-ending) A   "Convert the current region of the Texinfo file to Info format. D This lets you see what that part of the file will look like in Info.D The command is bound to \\[texinfo-format-region].  The text that is3 converted to Info is stored in a temporary buffer."    (interactive "r") 1   (message "Converting region to Info format...")    (let (texinfo-command-start          texinfo-command-end          texinfo-command-name         texinfo-vindex         texinfo-findex         texinfo-cindex         texinfo-pindex         texinfo-tindex         texinfo-kindex         texinfo-stack          texinfo-format-filename          texinfo-example-start          texinfo-last-node-pos          texinfo-last-node          texinfo-node-names 	(texinfo-footnote-number 0)         last-input-buffer *         (fill-column-for-info fill-column)'         (input-buffer (current-buffer)) +         (input-directory default-directory)          filename-or-header$         filename-or-header-beginning         filename-or-header-end)       ;;; Find a buffer to use.      E     (switch-to-buffer (get-buffer-create texinfo-region-buffer-name))      (erase-buffer)  )     ;; Insert the region into the buffer.      4     ;; First, find file name or tell of its absence.G     ;; Second, insert lines between beginning and end of header lines,  .     ;;    if any, or else insert the filename.     ;; Third, insert region.          (save-excursion        (set-buffer input-buffer)        (save-excursion          (save-restriction            (widen) !           (goto-char (point-min)) I           (let ((search-end (save-excursion (forward-line 100) (point))))              K             ;; Find the filename or else explain that a filename is needed. <             (or (search-forward "@setfilename" search-end t)                 (errorN                  "The texinfo file needs a line saying: @setfilename <name>"))             E             ;; Find header and copy it into buffer; or copy just the  )             ;;     filename if no header. #             (goto-char (point-min))              (if (and                    (prog1 J                      (search-forward texinfo-start-of-header search-end t)&                    (beginning-of-line)/                    ;; Mark beginning of header. ?                    (setq filename-or-header-beginning (point)))                   (prog1 A                      (search-forward texinfo-end-of-header nil t) &                    (beginning-of-line)(                    ;; Mark end of header;                    (setq filename-or-header-end (point))))                                     ;; Copy header  )                 (setq filename-or-header  '                       (buffer-substring J                        (min filename-or-header-beginning region-beginning).                       filename-or-header-end))@               ;; Else no header; insert @filename line in buffer%               (goto-char (point-min)) :               (search-forward "@setfilename" search-end t)!               (beginning-of-line) 9               (setq filename-or-header-beginning (point))                (forward-line 1)3               (setq filename-or-header-end (point)) '               (setq filename-or-header  &                     (buffer-substring J                      (min filename-or-header-beginning region-beginning)  2                      filename-or-header-end)))))))     5     ;; Insert the filename or header into the buffer.      (insert filename-or-header) )     ;; Insert the region into the buffer.      (insert-buffer-substring      input-buffer 2      (max region-beginning filename-or-header-end)      region-ending) *     ;; Make sure region ends in a newline.      (or (= (preceding-char) ?\n)         (insert "\n"))          (texinfo-mode)+     (setq fill-column fill-column-for-info)   C     ;; Install a syntax table useful for scanning command operands. 2     (set-syntax-table texinfo-format-syntax-table)/     ;; Append @refill to appropriate paragraphs      (goto-char (point-min)) 3     (message "Converting region to Info format...")      (texinfo-append-refill) <     ;; If the region includes the effective end of the data,%     ;; discard everything after that.      (goto-char (point-max)) *     (if (re-search-backward "^@bye" nil t),         (delete-region (point) (point-max)))*     ;; Make sure buffer ends in a newline.      (or (= (preceding-char) ?\n)         (insert "\n"))<     ;; Don't use a previous value of texinfo-enclosure-list.%     (setq texinfo-enclosure-list nil)        ;; Now convert for real.     (goto-char (point-min))m     (texinfo-format-scan)r     (goto-char (point-min)).          (message "Done."))).    > ;;; Primary internal formatting function for the whole buffer.  ! (defun texinfo-format-buffer-1 ().   (let (texinfo-format-filename5         texinfo-example-start          texinfo-command-startr         texinfo-command-end          texinfo-command-name         texinfo-last-nodes         texinfo-last-node-post         texinfo-vindex         texinfo-findex         texinfo-cindex         texinfo-pindex         texinfo-tindex         texinfo-kindex         texinfo-stacky         texinfo-node-names 	(texinfo-footnote-number 0)         last-input-buffer          outfileY*         (fill-column-for-info fill-column)'         (input-buffer (current-buffer)) ,         (input-directory default-directory))%     (setq texinfo-enclosure-list nil)Y     (save-excursione       (goto-char (point-min))l%       (search-forward "@setfilename")e(       (setq texinfo-command-end (point)).       (setq outfile (texinfo-parse-line-arg)))     (find-file outfile)      (texinfo-mode)+     (setq fill-column fill-column-for-info)o2     (set-syntax-table texinfo-format-syntax-table)     (erase-buffer)*     (insert-buffer-substring input-buffer)/     ;; Append @refill to appropriate paragraphsd     (goto-char (point-min))aJ     (message "Converting %s to Info format..." (buffer-name input-buffer))     (texinfo-append-refill)d     (goto-char (point-min)) #     (search-forward "@setfilename")f     (beginning-of-line) '     (delete-region (point-min) (point))l2     ;; Remove @bye at end of file, if it is there.     (goto-char (point-max))e&     (if (search-backward "@bye" nil t),         (delete-region (point) (point-max)))*     ;; Make sure buffer ends in a newline.      (or (= (preceding-char) ?\n)         (insert "\n"))8     ;; Scan the whole buffer, converting to Info format.     (texinfo-format-scan)t     ;; Return data for indices.t     (goto-char (point-min))y     (list outfiler6           texinfo-vindex texinfo-findex texinfo-cindex9           texinfo-pindex texinfo-tindex texinfo-kindex)))x   f* ;;; Perform non-@-command file conversions  ' (defun texinfo-format-convert (min max)m=   ;; Convert left and right quotes to typewriter font quotes.    (goto-char min)r$   (while (search-forward "``" max t)     (replace-match "\""))(   (goto-char min) $   (while (search-forward "''" max t)     (replace-match "\""))e+   ;; Convert three hyphens in a row to two.f   (goto-char min)fH   (while (re-search-forward "\\( \\|\\w\\)\\(---\\)\\( \\|\\w\\)" max t)A     (delete-region (1+ (match-beginning 2)) (+ 2 (match-beginning 
     2)))))    (defvar texinfo-no-refill-regexp   "^@\\(example\\|smallexample\\|lisp\\|smalllisp\\|display\\|format\\|flushleft\\|flushright\\|menu\\|titlepage\\|iftex\\|tex\\)"G   "Regexp specifying environments in which paragraphs are not filled.")   # (defvar texinfo-part-of-para-regexp    "^@\\(b{\\|bullet{\\|cite{\\|code{\\|emph{\\|equiv{\\|error{\\|expansion{\\|file{\\|i{\\|inforef{\\|kbd{\\|key{\\|lisp{\\|minus{\\|point{\\|print{\\|pxref{\\|r{\\|ref{\\|result{\\|samp{\\|sc{\\|t{\\|TeX{\\|today{\\|var{\\|w{\\|xref{\\)":   "Regexp specifying @-commands found within paragraphs.")   (defun texinfo-append-refill ()eA   "Append @refill at end of each paragraph that should be filled.eO Do not append @refill to paragraphs within @example and similar environments.  i? Do not append @refill to paragraphs containing @w{TEXT} or @*."g  F   ;; It is necessary to append @refill before other processing because@   ;; the other processing removes information that tells Texinfo5   ;; whether the text should or should not be filled.o       (while (< (point) (point-max))+     (let ((refill-blank-lines "^[ \t\n]*$")eI           (case-fold-search nil))       ; Don't confuse @TeX and @tex...."       (beginning-of-line)-"       ;; 1. Skip over blank lines;7       ;;    skip over lines beginning with @-commands,  &       ;;    but do not skip over linesA       ;;      that are no-refill environments such as @example orfH       ;;      that begin with within-paragraph @-commands such as @code.J       (while (and (looking-at (concat "^@\\|^\\\\\\|" refill-blank-lines))#                   (not (looking-at                           (concat                           "\\(" f1                          texinfo-no-refill-regexpf                          "\\|" i4                          texinfo-part-of-para-regexp!                          "\\)")))r*                   (< (point) (point-max)))         (forward-line 1))oB       ;; 2. Skip over @example and similar no-refill environments./       (if (looking-at texinfo-no-refill-regexp)s           (let ((environmentG                  (buffer-substring (match-beginning 1) (match-end 1))))cJ             (progn (re-search-forward (concat "^@end " environment) nil t)%                    (forward-line 1))) ;         ;; 3. Do not refill a paragraph containing @w or @*s         (if  (or&               (>= (point) (point-max))                (re-search-forwardL                "@w{\\|@\\*" (save-excursion (forward-paragraph) (point)) t))5             ;; Go to end of paragraph and do nothing.               (forward-paragraph) >           ;; 4. Else go to end of paragraph and insert @refill           (forward-paragraph)-           (forward-line -1)r           (end-of-line)e           (delete-region            (point)@            (save-excursion (skip-chars-backward " \t") (point)))<           ;; `looking-at-backward' not available in v. 18.57@           ;; (if (not (looking-at-backward "@refill\\|@bye")) ;)&           (if (not (re-search-backward$                     "@refill\\|@bye"@                     (save-excursion (beginning-of-line) (point))                     t));!               (insert "@refill"))            (forward-line 1))))))a   eK ;;; Perform those texinfo-to-info conversions that apply to the whole inputr ;;; uniformly.   (defun texinfo-format-scan () 2   (texinfo-format-convert (point-min) (point-max))   ;; Scan for @-commands.    (goto-char (point-min))a#   (while (search-forward "@" nil t)       (if (looking-at "[@{}'` *]")@         ;; Handle a few special @-followed-by-one-char commands.#         (if (= (following-char) ?*)              (progn               ;; remove commandn7               (delete-region (1- (point)) (1+ (point))) 5               ;; insert return if not at end of line;u-               ;; else line is already broken. 0               (if (not (= (following-char) ?\n))&                   (insert ?\n)))      C           ;; The other characters are simply quoted.  Delete the @.            (delete-char -1)           (forward-char 1))-C       ;; @ is followed by a command-word; find the end of the word. /       (setq texinfo-command-start (1- (point))) /       (if (= (char-syntax (following-char)) ?w)i           (forward-word 1)         (forward-char 1)))(       (setq texinfo-command-end (point))+       ;; Call the handler for this command.e        (setq texinfo-command-name%             (intern (buffer-substringf>              (1+ texinfo-command-start) texinfo-command-end)))       (let ((enclosure-typeg              (assocM0               (symbol-name texinfo-command-name)'               texinfo-enclosure-list))))         (if enclosure-type             (progn               (insert 0                (car (car (cdr enclosure-type))) *                (texinfo-parse-arg-discard)6                (car (cdr (car (cdr enclosure-type)))))0               (goto-char texinfo-command-start))A           (let ((cmd (get texinfo-command-name 'texinfo-format)))x=             (if cmd (funcall cmd) (texinfo-unsupported)))))))v      (cond (texinfo-stack0          (goto-char (nth 2 (car texinfo-stack)))@          (error "Unterminated @%s" (car (car texinfo-stack))))))  2 (put 'begin 'texinfo-format 'texinfo-format-begin) (defun texinfo-format-begin ()-   (texinfo-format-begin-end 'texinfo-format))"  . (put 'end 'texinfo-format 'texinfo-format-end) (defun texinfo-format-end ()*   (texinfo-format-begin-end 'texinfo-end))  & (defun texinfo-format-begin-end (prop)?   (setq texinfo-command-name (intern (texinfo-parse-line-arg))) ,   (setq cmd (get texinfo-command-name prop))   (if cmd (funcall cmd)n     (texinfo-unsupported)))f t ;;; Parsing functions(    (defun texinfo-parse-line-arg ()!   (goto-char texinfo-command-end)    (let ((start (point)))     (cond ((looking-at " ")n 	   (skip-chars-forward " ") 	   (setq start (point)) 	   (end-of-line)f$            (skip-chars-backward " ")@            (delete-region (point) (progn (end-of-line) (point))), 	   (setq texinfo-command-end (1+ (point)))) 	  ((looking-at "{") 	   (setq start (1+ (point)))o 	   (forward-list 1)& 	   (setq texinfo-command-end (point)) 	   (forward-char -1)) 	  (t 2 	   (error "Invalid texinfo command arg format")))+     (prog1 (buffer-substring start (point))c# 	   (if (eolp) (forward-char 1)))))e  $ (defun texinfo-parse-expanded-arg ()!   (goto-char texinfo-command-end)i   (let ((start (point))r 	marker)     (cond ((looking-at " ")- 	   (skip-chars-forward " ") 	   (setq start (point)) 	   (end-of-line)f, 	   (setq texinfo-command-end (1+ (point)))) 	  ((looking-at "{") 	   (setq start (1+ (point)))a 	   (forward-list 1)& 	   (setq texinfo-command-end (point)) 	   (forward-char -1)) 	  (tb2 	   (error "Invalid texinfo command arg format")))A     (setq marker (move-marker (make-marker) texinfo-command-end))I0     (texinfo-format-expand-region start (point))7     (setq texinfo-command-end (marker-position marker))      (move-marker marker nil)+     (prog1 (buffer-substring start (point))i# 	   (if (eolp) (forward-char 1)))))v  / (defun texinfo-format-expand-region (start end)h   (save-restriction       (narrow-to-region start end)     (let (texinfo-command-start( 	  texinfo-command-end 	  texinfo-command-namee 	  texinfo-stack)(       (texinfo-format-scan))     (goto-char (point-max))))   # (defun texinfo-parse-arg-discard ().!   (prog1 (texinfo-parse-line-arg); 	 (texinfo-discard-command)))   ! (defun texinfo-discard-command ()u<   (delete-region texinfo-command-start texinfo-command-end))  ) (defun texinfo-optional-braces-discard ()i-   "Discard braces following command, if any." !   (goto-char texinfo-command-end)f   (let ((start (point)))4     (cond ((looking-at "[ \t]*\n"))     ; do nothing?           ((looking-at "{")             ; remove braces, if any) 	   (forward-list 1)' 	   (setq texinfo-command-end (point)))r 	  (ta            (error R             "Invalid `texinfo-optional-braces-discard' format \(need braces?\)")))?     (delete-region texinfo-command-start texinfo-command-end)))\  ( (defun texinfo-format-parse-line-args ()   (let ((start (1- (point)))
 	next beg end) 	args)     (skip-chars-forward " ")     (while (not (eolp))e       (setq beg (point))!       (re-search-forward "[\n,]")u       (setq next (point))\'       (if (bolp) (setq next (1- next)))v       (forward-char -1)a       (skip-chars-backward " ")        (setq end (point))B       (setq args (cons (if (> end beg) (buffer-substring beg end)) 		       args))e       (goto-char next)       (skip-chars-forward " "))\      (if (eolp) (forward-char 1))&     (setq texinfo-command-end (point))     (nreverse args)))"  # (defun texinfo-format-parse-args ()    (let ((start (1- (point)))
 	next beg end- 	args)     (search-forward "{")     (save-excursiont$       (texinfo-format-expand-region         (point)2        (save-excursion (up-list 1) (1- (point)))))B     ;; The following does not handle cross references of the form::     ;; `@xref{bullet, , @code{@@bullet}@{@}}.' because theE     ;; re-search-forward finds the first right brace after the secondx     ;; comma. $     (while (/= (preceding-char) ?\})"       (skip-chars-forward " \t\n")       (setq beg (point))        (re-search-forward "[},]")       (setq next (point)))       (forward-char -1)T#       (skip-chars-backward " \t\n")-       (setq end (point))       (cond ((< beg end) 	     (goto-char beg)i( 	     (while (search-forward "\n" end t) 	       (replace-match " "))))B       (setq args (cons (if (> end beg) (buffer-substring beg end)) 		       args))w       (goto-char next))m      (if (eolp) (forward-char 1))&     (setq texinfo-command-end (point))     (nreverse args)))   ) (defun texinfo-format-parse-defun-args () !   (goto-char texinfo-command-end)    (let ((start (point)))     (end-of-line) +     (setq texinfo-command-end (1+ (point))) C     (let ((marker (move-marker (make-marker) texinfo-command-end)))p2       (texinfo-format-expand-region start (point))9       (setq texinfo-command-end (marker-position marker))        (move-marker marker nil))s     (goto-char start)n     (let ((args '()) 	  beg end)f       (skip-chars-forward " ")       (while (not (eolp))  	(cond ((looking-at "{") 	       (setq beg (1+ (point)))) 	       (forward-list 1)  	       (setq end (1- (point))))	 	      (tt 	       (setq beg (point))# 	       (re-search-forward "[\n ]")o 	       (forward-char -1)t 	       (setq end (point))))3 	(setq args (cons (buffer-substring beg end) args))  	(skip-chars-forward " "))       (forward-char 1)       (nreverse args))))   (defun texinfo-discard-line ()!   (goto-char texinfo-command-end)o   (skip-chars-forward " \t")   (or (eolp)8       (error "Extraneous text at end of command line."))#   (goto-char texinfo-command-start)-   (or (bolp)>       (error "Extraneous text at beginning of command line."));   (delete-region (point) (progn (forward-line 1) (point))))a  ( (defun texinfo-discard-line-with-args ()#   (goto-char texinfo-command-start) ;   (delete-region (point) (progn (forward-line 1) (point))))\   e ;;; @setfilename   ; 19 October 1990a? ; @setfilename modifed to work with include files; see @include & ; (defun texinfo-format-setfilename (), ;   (let ((arg (texinfo-parse-arg-discard)))# ;     (setq texinfo-format-filenamea5 ; 	  (file-name-nondirectory (expand-file-name arg)))f ;     (insert "Info file: "h2 ; 	    texinfo-format-filename ",    -*-Text-*-\n"1 ; 	    "produced by texinfo-format-buffer\nfrom " * ; 	    (if (buffer-file-name input-buffer) ; 		(concat "file: " ; 			(file-name-sans-versions" ; 			 (file-name-nondirectory[) ; 			  (buffer-file-name input-buffer)))) 7 ; 	      (concat "buffer " (buffer-name input-buffer)))n ; 	    "\n\n")))  > (put 'setfilename 'texinfo-format 'texinfo-format-setfilename)$ (defun texinfo-format-setfilename ()*   (let ((arg (texinfo-parse-arg-discard)))+     (if (eq input-buffer last-input-buffer) . 	nil				; only use first setfilename in buffer.       (message "Formatting Info file: %s" arg)#       (setq texinfo-format-filenamea5 	    (file-name-nondirectory (expand-file-name arg)))d       (insert "Info file: "r2 	      texinfo-format-filename ",    -*-Text-*-\n"   	      "produced on " 8               (substring (current-time-string) 8 10) " "7               (substring (current-time-string) 4 7) " " 3               (substring (current-time-string) -4)  )               " by texinfo-format-buffer";               "\nfrom "s* 	      (if (buffer-file-name input-buffer) 		  (concat "file `" 			  (file-name-sans-versions  			   (file-name-nondirectoryi( 			    (buffer-file-name input-buffer)))                           "'")5 		(concat "buffer `" (buffer-name input-buffer) "'")) .               "\nusing `texinfmt.el' version "               texinfmt-version 	      ".\n\n"))))   ;;; @node, @menu  0 (put 'node 'texinfo-format 'texinfo-format-node) (defun texinfo-format-node () 0   (let* ((args (texinfo-format-parse-line-args)) 	 (name (nth 0 args))r 	 (next (nth 1 args))) 	 (prev (nth 2 args))( 	 (up (nth 3 args)))     (texinfo-discard-command) !     (setq texinfo-last-node name)u      (let ((tem (downcase name)))(       (if (assoc tem texinfo-node-names)) 	  (error "Duplicate node name: %s" name)rA 	(setq texinfo-node-names (cons (list tem) texinfo-node-names))))f$     (setq texinfo-footnote-number 0)     (or (bolp) 	(insert ?\n))1     (insert "\^_\nFile: " texinfo-format-filename  	    ", Node: " name)o     (if next 	(insert ", Next: " next))     (if prev 	(insert ", Prev: " prev))
     (if up 	(insert ", Up: " up))     (insert ?\n)*     (setq texinfo-last-node-pos (point))))  0 (put 'menu 'texinfo-format 'texinfo-format-menu) (defun texinfo-format-menu ()n   (texinfo-discard-line)   (insert "* Menu:\n\n"))i  1 (put 'menu 'texinfo-end 'texinfo-discard-command)r   n ;;; Cross references  + ; @xref {NODE, FNAME, NAME, FILE, DOCUMENT}" ; -> *Note FNAME: (FILE)NODE ;   If FILE is missing,t ;    *Note FNAME: NODE) ;   If FNAME is empty and NAME is present  ;    *Note NAME: Nodei& ;   If both NAME and FNAME are missing ;    *Note NODE::n* ;   texinfo ignores the DOCUMENT argument.F ; -> See section <xref to NODE> [NAME, else NODE], page <xref to NODE>7 ;   If FILE is specified, (FILE)NODE is used for xrefs. 5 ;   If fifth argument DOCUMENT is specified, producesoF ;    See section <xref to NODE> [NAME, else NODE], page <xref to NODE> ;    of DOCUMENT  B ; @ref             a reference that does not put `See' or `see' in@ ;                  the hardcopy and is the same as @xref in Info/ (put 'ref 'texinfo-format 'texinfo-format-xref)   0 (put 'xref 'texinfo-format 'texinfo-format-xref) (defun texinfo-format-xref ())+   (let ((args (texinfo-format-parse-args)))d     (texinfo-discard-command)m     (insert "*Note ")f1     (let ((fname (or (nth 1 args) (nth 2 args))))f(       (if (null (or fname (nth 3 args))) 	  (insert (car args) "::")e$ 	(insert (or fname (car args)) ": ") 	(if (nth 3 args)t# 	    (insert "(" (nth 3 args) ")"))n 	(insert (car args))))))  2 (put 'pxref 'texinfo-format 'texinfo-format-pxref) (defun texinfo-format-pxref ()   (texinfo-format-xref)r   (or (save-excursionn 	(forward-char -2) 	(looking-at "::"))s       (insert ".")))   ;@inforef{NODE, FNAME, FILE}* ;Like @xref{NODE, FNAME,,FILE} in texinfo.2 ;In Tex, generates "See Info file FILE, node NODE"6 (put 'inforef 'texinfo-format 'texinfo-format-inforef)  (defun texinfo-format-inforef ()+   (let ((args (texinfo-format-parse-args)))e     (texinfo-discard-command)a     (if (nth 1 args)H         (insert "*Note " (nth 1 args) ": (" (nth 2 args) ")" (car args))?       (insert "*Note " "(" (nth 2 args) ")" (car args) "::"))))a   a ;;; Section headings  ; (put 'majorheading 'texinfo-format 'texinfo-format-chapter)(: (put 'chapheading 'texinfo-format 'texinfo-format-chapter)7 (put 'ichapter 'texinfo-format 'texinfo-format-chapter)e6 (put 'chapter 'texinfo-format 'texinfo-format-chapter)8 (put 'iappendix 'texinfo-format 'texinfo-format-chapter)7 (put 'appendix 'texinfo-format 'texinfo-format-chapter)d: (put 'iunnumbered 'texinfo-format 'texinfo-format-chapter)2 (put 'top 'texinfo-format 'texinfo-format-chapter)9 (put 'unnumbered 'texinfo-format 'texinfo-format-chapter)   (defun texinfo-format-chapter ()    (texinfo-format-chapter-1 ?*))  6 (put 'heading 'texinfo-format 'texinfo-format-section)7 (put 'isection 'texinfo-format 'texinfo-format-section)16 (put 'section 'texinfo-format 'texinfo-format-section)? (put 'iappendixsection 'texinfo-format 'texinfo-format-section)(> (put 'appendixsection 'texinfo-format 'texinfo-format-section); (put 'iappendixsec 'texinfo-format 'texinfo-format-section)i: (put 'appendixsec 'texinfo-format 'texinfo-format-section)= (put 'iunnumberedsec 'texinfo-format 'texinfo-format-section)r< (put 'unnumberedsec 'texinfo-format 'texinfo-format-section)  (defun texinfo-format-section ()    (texinfo-format-chapter-1 ?=))  < (put 'subheading 'texinfo-format 'texinfo-format-subsection)= (put 'isubsection 'texinfo-format 'texinfo-format-subsection)s< (put 'subsection 'texinfo-format 'texinfo-format-subsection)A (put 'iappendixsubsec 'texinfo-format 'texinfo-format-subsection)g@ (put 'appendixsubsec 'texinfo-format 'texinfo-format-subsection)C (put 'iunnumberedsubsec 'texinfo-format 'texinfo-format-subsection)pB (put 'unnumberedsubsec 'texinfo-format 'texinfo-format-subsection)# (defun texinfo-format-subsection ()i    (texinfo-format-chapter-1 ?-))  B (put 'subsubheading 'texinfo-format 'texinfo-format-subsubsection)C (put 'isubsubsection 'texinfo-format 'texinfo-format-subsubsection))B (put 'subsubsection 'texinfo-format 'texinfo-format-subsubsection)G (put 'iappendixsubsubsec 'texinfo-format 'texinfo-format-subsubsection)hF (put 'appendixsubsubsec 'texinfo-format 'texinfo-format-subsubsection)I (put 'iunnumberedsubsubsec 'texinfo-format 'texinfo-format-subsubsection)eH (put 'unnumberedsubsubsec 'texinfo-format 'texinfo-format-subsubsection)& (defun texinfo-format-subsubsection ()    (texinfo-format-chapter-1 ?.))  + (defun texinfo-format-chapter-1 (belowchar)d*   (let ((arg (texinfo-parse-arg-discard)))G     (message "Formatting: %s ... " arg)   ; So we can see where we are. 5     (insert ?\n arg ?\n "@SectionPAD " belowchar ?\n)d     (forward-line -2)))w  < (put 'SectionPAD 'texinfo-format 'texinfo-format-sectionpad)# (defun texinfo-format-sectionpad () *   (let ((str (texinfo-parse-arg-discard)))     (forward-char -1) $     (let ((column (current-column)))       (forward-char 1)       (while (> column 0)1
 	(insert str)t 	(setq column (1- column))))     (insert ?\n)))   e, ;;; Space controling commands:  @. and @:   , (put '\. 'texinfo-format 'texinfo-format-\.) (defun texinfo-format-\. ()n   (texinfo-discard-command)m   (insert "."))i  , (put '\: 'texinfo-format 'texinfo-format-\:) (defun texinfo-format-\: ()    (texinfo-discard-command))   n ;;; @center, @sp, and @brb  4 (put 'center 'texinfo-format 'texinfo-format-center) (defun texinfo-format-center ()o+   (let ((arg (texinfo-parse-expanded-arg)))d     (texinfo-discard-command)a     (insert arg)     (insert ?\n)     (save-restrictioni       (goto-char (1- (point)))#       (let ((indent-tabs-mode nil))e 	(center-line)))))  , (put 'sp 'texinfo-format 'texinfo-format-sp) (defun texinfo-format-sp ()n*   (let* ((arg (texinfo-parse-arg-discard)) 	 (num (read arg)))-     (insert-char ?\n num)))f  9 (put 'br 'texinfo-format 'texinfo-format-paragraph-break)-( (defun texinfo-format-paragraph-break ()   "Force a paragraph break.a1 If used within a line, follow `@br' with braces."-#   (texinfo-optional-braces-discard)u)   ;; insert one return if at end of line;f7   ;; else insert two returns, to generate a blank line.n   (if (= (following-char) ?\n)       (insert ?\n)     (insert-char ?\n 2)))f   (" ;;; @footnote  and  @footnotestyle  A ; In Texinfo, footnotes are created with the `@footnote' command.lK ; This command is followed immediately by a left brace, then by the text of-; ; the footnote, and then by a terminating right brace.  Thel ; template for a footnote is:e ;  ;      @footnote{TEXT} ;m ; Info has two footnote styles:  ; D ;    * In the End of node style, all the footnotes for a single node= ;      are placed at the end of that node.  The footnotes areaC ;      separated from the rest of the node by a line of dashes with & ;      the word `Footnotes' within it. ; F ;    * In the Separate node style, all the footnotes for a single nodeD ;      are placed in an automatically constructed node of their own.  C ; Footnote style is specified by the @footnotestyle command, eitheri ;    @footnotestyle separate ; or ;    @footnotestyle endi ;  ; The default is  separate  * (defvar texinfo-footnote-style "separate" ,   "Footnote style, either separate or end.")  ; (put 'footnotestyle 'texinfo-format 'texinfo-footnotestyle)i (defun texinfo-footnotestyle () E   "Specify whether footnotes are at end of node or in separate nodes.p$ Argument is either end or separate."<   (setq texinfo-footnote-style (texinfo-parse-arg-discard)))    (defvar texinfo-footnote-number)  8 (put 'footnote 'texinfo-format 'texinfo-format-footnote)! (defun texinfo-format-footnote ()xB   "Format a footnote in either end of node or separate node style.E The   texinfo-footnote-style  variable controls which style is used."(=   (setq texinfo-footnote-number (1+ texinfo-footnote-number))e/   (cond ((string= texinfo-footnote-style "end")s#          (texinfo-format-end-node))o4         ((string= texinfo-footnote-style "separate")*          (texinfo-format-separate-node))))  & (defun texinfo-format-separate-node ()B   "Format footnote in Separate node style, with notes in own node.' The node is constructed automatically."    (let* (start'          (arg (texinfo-parse-line-arg))o          (node-name-beginningf           (save-excursion              (re-search-backwardrA              "^File: \\w+\\(\\w\\|\\s_\\|\\.\\|,\\)*[ \t]+Node:")a             (match-end 0)))c          (node-nameF           (save-excursion"             (buffer-substring L              (progn (goto-char node-name-beginning) ; skip over node commandA                     (skip-chars-forward " \t")  ; and over spacesa                     (point))               (if (search-forward                   ","cJ                   (save-excursion (end-of-line) (point)) t) ; bound search                  (1- (point))r)                (end-of-line) (point)))))) G     (texinfo-discard-command)  ; remove or insert whitespace, as neededpI     (delete-region (save-excursion (skip-chars-backward " \t\n") (point))                     (point))n2     (insert (format " (%d) (*Note %s-Footnotes::)") 		    texinfo-footnote-number node-name))t     (fill-paragraph nil)     (save-excursionm.     (if (re-search-forward "^@node" nil 'move)         (forward-line -1))  G     ;; two cases: for the first footnote, we must insert a node header;oD     ;; for the second and subsequent footnotes, we need only insert !     ;; the text of the  footnote.(       (if (save-excursion(          (re-search-backward/           (concat node-name "-Footnotes, Up: ")            node-name-beginnings
           t))'0         (progn   ; already at least one footnote           (setq start (point))F           (insert (format "\n(%d)  %s\n" texinfo-footnote-number arg))&           (fill-region start (point)))        ;; else not yet a footnote6       (insert "\n\^_\nFile: "  texinfo-format-filenameE               "  Node: " node-name "-Footnotes, Up: " node-name "\n")n       (setq start (point))B       (insert (format "\n(%d)  %s\n" texinfo-footnote-number arg))%       (fill-region start (point))))))   ! (defun texinfo-format-end-node ()oH   "Format footnote in the End of node style, with notes at end of node."
   (let (startr'         (arg (texinfo-parse-line-arg)))eG     (texinfo-discard-command)  ; remove or insert whitespace, as neededtI     (delete-region (save-excursion (skip-chars-backward " \t\n") (point))a                    (point))-6     (insert (format " (%d) " texinfo-footnote-number))     (fill-paragraph nil)     (save-excursionaD       (if (search-forward "\n--------- Footnotes ---------\n" nil t)H           (progn ; already have footnote, put new one before end of node6             (if (re-search-forward "^@node" nil 'move)"                 (forward-line -1))              (setq start (point))H             (insert (format "\n(%d)  %s\n" texinfo-footnote-number arg))(             (fill-region start (point)))!         ;; else no prior footnotef2         (if (re-search-forward "^@node" nil 'move)             (forward-line -1))4         (insert "\n--------- Footnotes ---------\n")         (setq start (point))H         (insert (format "\n(%d)  %s\n" texinfo-footnote-number arg))))))   f. ;;; @itemize, @enumerate, and similar commands  B ;; @itemize pushes (itemize "COMMANDS" STARTPOS) on texinfo-stack., ;; @enumerate pushes (enumerate 0 STARTPOS).J ;; @item dispatches to the texinfo-item prop of the first elt of the list.6 ;; For itemize, this puts in and rescans the COMMANDS.< ;; For enumerate, this increments the number and puts it in.? ;; In either case, it puts a Backspace at the front of the linei+ ;; which marks it not to be indented later.'> ;; All other lines get indented by 5 when the @end is reached.   (defvar texinfo-stack-depth 0t8   "Count of number of unpopped texinfo-push-stack calls.I Used by @refill indenting command to avoid indenting within lists, etc.")o  % (defun texinfo-push-stack (check arg)t5   (setq texinfo-stack-depth (1+ texinfo-stack-depth))-   (setq texinfo-stacke- 	(cons (list check arg texinfo-command-start)t 	      texinfo-stack)))n    (defun texinfo-pop-stack (check)5   (setq texinfo-stack-depth (1- texinfo-stack-depth))n   (if (null texinfo-stack)(       (error "Unmatched @end %s" check))0   (if (not (eq (car (car texinfo-stack)) check))"       (error "@end %s matches @%s"' 	     check (car (car texinfo-stack))))c"   (prog1 (cdr (car texinfo-stack)), 	 (setq texinfo-stack (cdr texinfo-stack))))  / (put 'itemize 'texinfo-format 'texinfo-itemize)x (defun texinfo-itemize ())   (texinfo-push-stackp    'itemize $    (progn (skip-chars-forward " \t")           (if (eolp)               "@bullet")'             (texinfo-parse-line-arg))))g"   (texinfo-discard-line-with-args)'   (setq fill-column (- fill-column 5)))l  0 (put 'itemize 'texinfo-end 'texinfo-end-itemize) (defun texinfo-end-itemize ()-&   (setq fill-column (+ fill-column 5))   (texinfo-discard-command)r   (let ((stacktop-  	 (texinfo-pop-stack 'itemize)))+     (texinfo-do-itemize (nth 1 stacktop))))   3 (put 'enumerate 'texinfo-format 'texinfo-enumerate)s (defun texinfo-enumerate ()n   (texinfo-push-stack)    'enumerate $    (progn (skip-chars-forward " \t")           (if (eolp)               1t&             (read (current-buffer)))))4   (if (and (symbolp (car (cdr (car texinfo-stack))))H            (> 1 (length (symbol-name (car (cdr (car texinfo-stack)))))))       (errorH        "@enumerate: Use a number or letter, eg: 1, A, a, 3, B, or d." ))"   (texinfo-discard-line-with-args)'   (setq fill-column (- fill-column 5)))i  4 (put 'enumerate 'texinfo-end 'texinfo-end-enumerate) (defun texinfo-end-enumerate () &   (setq fill-column (+ fill-column 5))   (texinfo-discard-command)l   (let ((stacktopd" 	 (texinfo-pop-stack 'enumerate)))+     (texinfo-do-itemize (nth 1 stacktop))))f  : ;; @alphaenumerate never became a standard part of Texinfo= (put 'alphaenumerate 'texinfo-format 'texinfo-alphaenumerate)p  (defun texinfo-alphaenumerate ().   (texinfo-push-stack 'alphaenumerate (1- ?a))&   (setq fill-column (- fill-column 5))   (texinfo-discard-line))n  > (put 'alphaenumerate 'texinfo-end 'texinfo-end-alphaenumerate)$ (defun texinfo-end-alphaenumerate ()&   (setq fill-column (+ fill-column 5))   (texinfo-discard-command)    (let ((stacktoph' 	 (texinfo-pop-stack 'alphaenumerate)))-+     (texinfo-do-itemize (nth 1 stacktop))))o  9 ;; @capsenumerate never became a standard part of Texinfof; (put 'capsenumerate 'texinfo-format 'texinfo-capsenumerate)  (defun texinfo-capsenumerate ()--   (texinfo-push-stack 'capsenumerate (1- ?A))h&   (setq fill-column (- fill-column 5))   (texinfo-discard-line))e  < (put 'capsenumerate 'texinfo-end 'texinfo-end-capsenumerate)# (defun texinfo-end-capsenumerate ()f&   (setq fill-column (+ fill-column 5))   (texinfo-discard-command)t   (let ((stacktops& 	 (texinfo-pop-stack 'capsenumerate)))+     (texinfo-do-itemize (nth 1 stacktop))))t  9 ;; At the @end, indent all the lines within the constructe7 ;; except those marked with backspace.  FROM says whereo ;; construct started.o  (defun texinfo-do-itemize (from)   (save-excursiont"    (while (progn (forward-line -1) 		 (>= (point) from))a!      (if (= (following-char) ?\b)i 	 (save-excursion  	   (delete-char 1)a 	   (end-of-line)s 	   (delete-char 6))'        (if (not (looking-at "[ \t]*$")) * 	   (save-excursion (insert "     ")))))))  ) (put 'item 'texinfo-format 'texinfo-item)y* (put 'itemx 'texinfo-format 'texinfo-item) (defun texinfo-item ():   (funcall (get (car (car texinfo-stack)) 'texinfo-item)))  2 (put 'itemize 'texinfo-item 'texinfo-itemize-item) (defun texinfo-itemize-item ()J   ;; (texinfo-discard-line)   ; Did not handle text on same line as @item.K   (delete-region (1+ (point)) (save-excursion (beginning-of-line) (point)))n$   (if (looking-at "[ \t]*[^ \t\n]+"),       ;; Text on same line as @item command.8       (insert "\b   " (nth 1 (car texinfo-stack)) " \n")     ;; Else text on next line.5     (insert "\b   " (nth 1 (car texinfo-stack)) " "))d   (forward-line -1))  6 (put 'enumerate 'texinfo-item 'texinfo-enumerate-item)  (defun texinfo-enumerate-item ()   (texinfo-discard-line)   (let (enumerating-symbol)e5     (cond ((integerp (car (cdr (car texinfo-stack)))) D            (setq enumerating-symbol (car (cdr (car texinfo-stack))))?            (insert ?\b (format "%3d. " enumerating-symbol) ?\n)-F            (setcar (cdr (car texinfo-stack)) (1+ enumerating-symbol)))4           ((symbolp (car (cdr (car texinfo-stack))))#            (setq enumerating-symbolF?                  (symbol-name (car (cdr (car texinfo-stack))))) B            (if (or (equal ?\[ (string-to-char enumerating-symbol))C                    (equal ?\{ (string-to-char enumerating-symbol)))e                (error J                 "Too many items in enumerated list; alphabet ends at Z."))?            (insert ?\b (format "%3s. " enumerating-symbol) ?\n)h,            (setcar (cdr (car texinfo-stack))                    (make-symbol #                     (char-to-string                       (1+ e>                       (string-to-char enumerating-symbol))))))           (t           (errorL            "@enumerate: Use a number or letter, eg: 1, A, a, 3, B or d." )))     (forward-line -1)))n  @ (put 'alphaenumerate 'texinfo-item 'texinfo-alphaenumerate-item)% (defun texinfo-alphaenumerate-item ()    (texinfo-discard-line)4   (let ((next (1+ (car (cdr (car texinfo-stack))))))     (if (> next ?z) I 	(error "More than 26 items in @alphaenumerate; get a bigger alphabet."))t+     (setcar (cdr (car texinfo-stack)) next)x      (insert "\b  " next ". \n"))   (forward-line -1))  > (put 'capsenumerate 'texinfo-item 'texinfo-capsenumerate-item)$ (defun texinfo-capsenumerate-item ()   (texinfo-discard-line)4   (let ((next (1+ (car (cdr (car texinfo-stack))))))     (if (> next ?Z)tH 	(error "More than 26 items in @capsenumerate; get a bigger alphabet."))+     (setcar (cdr (car texinfo-stack)) next)\      (insert "\b  " next ". \n"))   (forward-line -1))   :
 ;;; @table  2 ; The `@table' command produces two-column tables.  + (put 'table 'texinfo-format 'texinfo-table)" (defun texinfo-table ()a   (texinfo-push-stack 
    'table $    (progn (skip-chars-forward " \t")           (if (eolp)               "@asis"d'             (texinfo-parse-line-arg))))l"   (texinfo-discard-line-with-args)'   (setq fill-column (- fill-column 5)))m  . (put 'table 'texinfo-item 'texinfo-table-item) (defun texinfo-table-item ())   (let ((arg (texinfo-parse-arg-discard))a, 	(itemfont (car (cdr (car texinfo-stack)))))/     (insert ?\b itemfont ?\{ arg "}\n     \n"))l   (forward-line -2))  , (put 'table 'texinfo-end 'texinfo-end-table) (defun texinfo-end-table ()n&   (setq fill-column (+ fill-column 5))   (texinfo-discard-command)e   (let ((stacktop  	 (texinfo-pop-stack 'table)))+     (texinfo-do-itemize (nth 1 stacktop))))n  D ;; @description appears to be an undocumented variant on @table thatD ;; does not require an arg.  It fails in texinfo.tex 2.58 and is notF ;; part of makeinfo.c   The command appears to be a relic of the past.2 (put 'description 'texinfo-end 'texinfo-end-table)7 (put 'description 'texinfo-format 'texinfo-description)- (defun texinfo-description ()i%   (texinfo-push-stack 'table "@asis")%&   (setq fill-column (- fill-column 5))   (texinfo-discard-line))a   n ;;; @ftable, @vtable  D ; The `@ftable' and `@vtable' commands are like the `@table' commandB ; but they also insert each entry in the first column of the table& ; into the function or variable index.  + ;; Handle the @ftable and @vtable commands:a  - (put 'ftable 'texinfo-format 'texinfo-ftable)t- (put 'vtable 'texinfo-format 'texinfo-vtable),  6 (defun texinfo-ftable () (texinfo-indextable 'ftable))6 (defun texinfo-vtable () (texinfo-indextable 'vtable))  & (defun texinfo-indextable (table-type)=   (texinfo-push-stack table-type (texinfo-parse-arg-discard))p'   (setq fill-column (- fill-column 5)))f  6 ;; Handle the @item commands within ftable and vtable:  0 (put 'ftable 'texinfo-item 'texinfo-ftable-item)0 (put 'vtable 'texinfo-item 'texinfo-vtable-item)  H (defun texinfo-ftable-item () (texinfo-indextable-item 'texinfo-findex))H (defun texinfo-vtable-item () (texinfo-indextable-item 'texinfo-vindex))  + (defun texinfo-indextable-item (index-type) *   (let ((item (texinfo-parse-arg-discard))2         (itemfont (car (cdr (car texinfo-stack))))         (indexvar index-type))/     (insert ?\b itemfont ?\{ item "}\n     \n")f     (set indexvaro          (cons'           (list item texinfo-last-node)t#           (symbol-value indexvar)))x     (forward-line -2)))i  " ;; Handle @end ftable, @end vtable  . (put 'ftable 'texinfo-end 'texinfo-end-ftable). (put 'vtable 'texinfo-end 'texinfo-end-vtable)  > (defun texinfo-end-ftable () (texinfo-end-indextable 'ftable))> (defun texinfo-end-vtable () (texinfo-end-indextable 'vtable))  * (defun texinfo-end-indextable (table-type)&   (setq fill-column (+ fill-column 5))   (texinfo-discard-command)    (let ((stacktop )          (texinfo-pop-stack table-type)))k+     (texinfo-do-itemize (nth 1 stacktop))))t   o ;;; @ifinfo,  @iftex, @tex  3 (put 'ifinfo 'texinfo-format 'texinfo-discard-line)a3 (put 'ifinfo 'texinfo-end 'texinfo-discard-command)t  2 (put 'iftex 'texinfo-format 'texinfo-format-iftex) (defun texinfo-format-iftex ()&   (delete-region texinfo-command-start2 		 (progn (re-search-forward "@end iftex[ \t]*\n")
 			(point))))   . (put 'tex 'texinfo-format 'texinfo-format-tex) (defun texinfo-format-tex ()&   (delete-region texinfo-command-start0 		 (progn (re-search-forward "@end tex[ \t]*\n")
 			(point))))-   a ;;; @titlepage  : (put 'titlepage 'texinfo-format 'texinfo-format-titlepage)" (defun texinfo-format-titlepage ()&   (delete-region texinfo-command-start6 		 (progn (re-search-forward "@end titlepage[ \t]*\n")
 			(point))))d  9 (put 'endtitlepage 'texinfo-format 'texinfo-discard-line)   D ; @titlespec         an alternative titling command; ignored by Info  : (put 'titlespec 'texinfo-format 'texinfo-format-titlespec)" (defun texinfo-format-titlespec ()&   (delete-region texinfo-command-startD                  (progn (re-search-forward "@end titlespec[ \t]*\n")"                         (point))))  9 (put 'endtitlespec 'texinfo-format 'texinfo-discard-line)o   a
 ;;; @today  2 (put 'today 'texinfo-format 'texinfo-format-today)  ; ; Produces Day Month Year style of output.  eg `1 Jan 1900''C ; The `@today{}' command requires a pair of braces, like `@dots{}'.; (defun texinfo-format-today ()   (texinfo-parse-arg-discard)'   (insert (format "%s %s %s"0           (substring (current-time-string) 8 10)/           (substring (current-time-string) 4 7)-1           (substring (current-time-string) -4))))t   o ;;; @ignore)  4 (put 'ignore 'texinfo-format 'texinfo-format-ignore) (defun texinfo-format-ignore ()p&   (delete-region texinfo-command-start3 		 (progn (re-search-forward "@end ignore[ \t]*\n")(
 			(point))))t  6 (put 'endignore 'texinfo-format 'texinfo-discard-line)   h6 ;;; Define the Info enclosure command: @definfoenclose  B ; A `@definfoenclose' command may be used to define a highlighting= ; command for Info, but not for TeX.  A command defined usingfF ; `@definfoenclose' marks text by enclosing it in strings that precede ; and follow the text. ; F ; Presumably, if you define a command with `@definfoenclose` for Info,D ; you will also define the same command in the TeX definitions file,8 ; `texinfo.tex' in a manner appropriate for typesetting. ; F ; Write a `@definfoenclose' command on a line and follow it with threeD ; arguments separated by commas (commas are used as separators in an7 ; `@node' line in the same way).  The first argument tooB ; `@definfoenclose' is the @-command name \(without the `@'\); theC ; second argument is the Info start delimiter string; and the thirdiF ; argument is the Info end delimiter string.  The latter two argumentsD ; enclose the highlighted text in the Info file.  A delimiter string= ; may contain spaces.  Neither the start nor end delimiter is B ; required.  However, if you do not provide a start delimiter, youC ; must follow the command name with two commas in a row; otherwise,iB ; the Info formatting commands will misinterpret the end delimiter% ; string as a start delimiter string.n ; E ; An enclosure command defined this way takes one argument in braces.  ;( ; For example, you can write:d ;c
 ;     @ifinfok" ;     @definfoenclose phoo, //, \\ ;     @end ifinfog ;mD ; near the beginning of a Texinfo file at the beginning of the linesC ; to define `@phoo' as an Info formatting command that inserts `//' D ; before and `\\' after the argument to `@phoo'.  You can then write? ; `@phoo{bar}' wherever you want `//bar\\' highlighted in Info.r ;-, ; Also, for TeX formatting, you could write  ;( ;     @iftex ;     @global@let@phoo=@ib ;     @end iftex ; ; ; to define `@phoo' as a command that causes TeX to typeset % ; the argument to `@phoo' in italics.e ;?F ; Note that each definition applies to its own formatter: one for TeX,? ; the other for texinfo-format-buffer or texinfo-format-region.  ;   ; Here is another example: write ; # ;     @definfoenclose headword, , :r ;-B ; near the beginning of the file, to define `@headword' as an InfoF ; formatting command that inserts nothing before and a colon after the ; argument to `@headword'.  D (put 'definfoenclose 'texinfo-format 'texinfo-define-info-enclosure)' (defun texinfo-define-info-enclosure ()t0   (let* ((args (texinfo-format-parse-line-args)) 	 (command-name (nth 0 args))i, 	 (beginning-delimiter (or (nth 1 args) ""))' 	 (end-delimiter (or (nth 2 args) ""))))     (texinfo-discard-command)f      (setq texinfo-enclosure-list 	(cons 	 (list command-name
 	       (listt 		beginning-delimitero 		end-delimiter))e 	 texinfo-enclosure-list))))   e ;;; @var, @code and the like  . (put 'var 'texinfo-format 'texinfo-format-var)= ;  @sc  a small caps font for TeX; formatted as `var' in Infot- (put 'sc 'texinfo-format 'texinfo-format-var)) (defun texinfo-format-var ()/   (insert (upcase (texinfo-parse-arg-discard))))$   (goto-char texinfo-command-start))   ; various noops'  - (put 'b 'texinfo-format 'texinfo-format-noop)l- (put 'i 'texinfo-format 'texinfo-format-noop)n- (put 'r 'texinfo-format 'texinfo-format-noop) - (put 't 'texinfo-format 'texinfo-format-noop) - (put 'w 'texinfo-format 'texinfo-format-noop) 0 (put 'asis 'texinfo-format 'texinfo-format-noop)/ (put 'dmn 'texinfo-format 'texinfo-format-noop)u/ (put 'key 'texinfo-format 'texinfo-format-noop)b0 (put 'math 'texinfo-format 'texinfo-format-noop)5 (put 'titlefont 'texinfo-format 'texinfo-format-noop)( (defun texinfo-format-noop ()s&   (insert (texinfo-parse-arg-discard))$   (goto-char texinfo-command-start))  0 (put 'cite 'texinfo-format 'texinfo-format-code)0 (put 'code 'texinfo-format 'texinfo-format-code)0 (put 'file 'texinfo-format 'texinfo-format-code)/ (put 'kbd 'texinfo-format 'texinfo-format-code)-0 (put 'samp 'texinfo-format 'texinfo-format-code) (defun texinfo-format-code ()i.   (insert "`" (texinfo-parse-arg-discard) "'")$   (goto-char texinfo-command-start))  0 (put 'emph 'texinfo-format 'texinfo-format-emph)2 (put 'strong 'texinfo-format 'texinfo-format-emph) (defun texinfo-format-emph ()e.   (insert "*" (texinfo-parse-arg-discard) "*")$   (goto-char texinfo-command-start))  / (put 'dfn 'texinfo-format 'texinfo-format-defn)l0 (put 'defn 'texinfo-format 'texinfo-format-defn) (defun texinfo-format-defn () 0   (insert "\"" (texinfo-parse-arg-discard) "\"")$   (goto-char texinfo-command-start))  4 (put 'bullet 'texinfo-format 'texinfo-format-bullet) (defun texinfo-format-bullet ()    "Insert an asterisk.5 If used within a line, follow `@bullet' with braces."'#   (texinfo-optional-braces-discard)f   (insert "*"))-   eD ;;; @example, @lisp, @quotation, @display, @smalllisp, @smallexample  6 (put 'display 'texinfo-format 'texinfo-format-example)6 (put 'example 'texinfo-format 'texinfo-format-example)3 (put 'lisp 'texinfo-format 'texinfo-format-example)c8 (put 'quotation 'texinfo-format 'texinfo-format-example); (put 'smallexample 'texinfo-format 'texinfo-format-example)i8 (put 'smalllisp 'texinfo-format 'texinfo-format-example)  (defun texinfo-format-example ()#   (texinfo-push-stack 'example nil)i&   (setq fill-column (- fill-column 5))   (texinfo-discard-line))m  0 (put 'example 'texinfo-end 'texinfo-end-example)0 (put 'display 'texinfo-end 'texinfo-end-example)- (put 'lisp 'texinfo-end 'texinfo-end-example)n2 (put 'quotation 'texinfo-end 'texinfo-end-example)5 (put 'smallexample 'texinfo-end 'texinfo-end-example)d2 (put 'smalllisp 'texinfo-end 'texinfo-end-example) (defun texinfo-end-example ()-&   (setq fill-column (+ fill-column 5))   (texinfo-discard-command),   (let ((stacktopt  	 (texinfo-pop-stack 'example)))+     (texinfo-do-itemize (nth 1 stacktop))))e  4 (put 'exdent 'texinfo-format 'texinfo-format-exdent) (defun texinfo-format-exdent ()n   (texinfo-discard-command)-   (delete-region (point)	 		 (progno 		  (skip-chars-forward " ")
 		  (point)))l   (insert ?\b)4   ;; Cancel out the deletion that texinfo-do-itemize,   ;; is going to do at the end of this line.   (save-excursiont     (end-of-line)o     (insert "\n     ")))   t ;;; @cartouche '  @ ; The @cartouche command is a noop in Info; in a printed manual,& ; it makes a box with rounded corners.  6 (put 'cartouche 'texinfo-format 'texinfo-discard-line)6 (put 'cartouche 'texinfo-end 'texinfo-discard-command)     ;;; @flushleft and @format  A ; The @flushleft command left justifies every line but leaves thetA ; right end ragged.  As far as Info is concerned, @flushleft is at ; `do-nothing' command  D ; The @format command is similar to @example except that it does notD ; indent; this means that in Info, @format is similar to @flushleft.  7 (put 'format 'texinfo-format 'texinfo-format-flushleft)t: (put 'flushleft 'texinfo-format 'texinfo-format-flushleft)" (defun texinfo-format-flushleft ()   (texinfo-discard-line))-  1 (put 'format 'texinfo-end 'texinfo-end-flushleft) 4 (put 'flushleft 'texinfo-end 'texinfo-end-flushleft) (defun texinfo-end-flushleft ()x   (texinfo-discard-command))   n ;;; @flushrighte  C ; The @flushright command right justifies every line but leaves therB ; left end ragged.  Spaces and tabs at the right ends of lines are: ; removed so that visible text lines up on the right side.  < (put 'flushright 'texinfo-format 'texinfo-format-flushright)# (defun texinfo-format-flushright ()y&   (texinfo-push-stack 'flushright nil)   (texinfo-discard-line))m  6 (put 'flushright 'texinfo-end 'texinfo-end-flushright)  (defun texinfo-end-flushright ()   (texinfo-discard-command)r     (let ((stacktop *          (texinfo-pop-stack 'flushright)))  .     (texinfo-do-flushright (nth 1 stacktop))))  # (defun texinfo-do-flushright (from)e   (save-excursion "    (while (progn (forward-line -1)#                  (>= (point) from))         (beginning-of-line)      (insert       (make-string        (- fill-columnr           (save-excursionr             (end-of-line) '             (skip-chars-backward " \t")nA             (delete-region (point) (progn (end-of-line) (point)))i              (current-column)))          ? )))))    * ;;; @ctrl, @TeX, @copyright, @minus, @dots  0 (put 'ctrl 'texinfo-format 'texinfo-format-ctrl) (defun texinfo-format-ctrl ()l*   (let ((str (texinfo-parse-arg-discard)))'     (insert (logand 31 (aref str 0)))))f  . (put 'TeX 'texinfo-format 'texinfo-format-TeX) (defun texinfo-format-TeX ()   (texinfo-parse-arg-discard)f   (insert "TeX"))x  : (put 'copyright 'texinfo-format 'texinfo-format-copyright)" (defun texinfo-format-copyright ()   (texinfo-parse-arg-discard)t   (insert "(C)"))a  2 (put 'minus 'texinfo-format 'texinfo-format-minus) (defun texinfo-format-minus ()   "Insert a minus sign.c4 If used within a line, follow `@minus' with braces."#   (texinfo-optional-braces-discard)e   (insert "-"))n  0 (put 'dots 'texinfo-format 'texinfo-format-dots) (defun texinfo-format-dots ()s   (texinfo-parse-arg-discard)t   (insert "..."))    iB ;;; Refilling and indenting:  @refill, @paragraphindent, @noindent  D ;;; Indent only those paragraphs that are refilled as a result of an ;;; @refill command.    H ;    * If the value is `asis', do not change the existing indentation at  ;      the starts of paragraphs.  : ;    * If the value zero, delete any existing indentation.  G ;    * If the value is greater than zero, indent each paragraph by thatx ;      number of spaces.  A ;;; But do not refill paragraphs with an @refill command that arefA ;;; preceded by @noindent or are part of a table, list, or deffn.t  ' (defvar texinfo-paragraph-indent "asis"rM   "Number of spaces for @refill to indent a paragraph; else to leave as is.")h  ? (put 'paragraphindent 'texinfo-format 'texinfo-paragraphindent)'  ! (defun texinfo-paragraphindent ()oB   "Specify the number of spaces for @refill to indent a paragraph.0 Default is to leave the number of spaces as is."+   (let ((arg  (texinfo-parse-arg-discard)))      (if (string= "asis" arg).         (setq texinfo-paragraph-indent "asis")<       (setq texinfo-paragraph-indent (string-to-int arg)))))  4 (put 'refill 'texinfo-format 'texinfo-format-refill) (defun texinfo-format-refill () H   "Refill paragraph. Also, indent first line as set by @paragraphindent.1 Default is to leave paragraph indentation as is."d   (texinfo-discard-command)a   (forward-paragraph -1)     t0   (if (looking-at "[ \t\n]*$") (forward-line 1)):   ;; Do not indent if an entry in a list, table, or deffn,.   ;; or if paragraph is preceded by @noindent.   ;; Otherwise, indent   (cond 9    ;; delete a @noindent line and do not indent paragraphs%    ((save-excursion (forward-line -1)s/                     (looking-at "^@noindent")) t     (forward-line -1)t=     (delete-region (point) (progn (forward-line 1) (point))))i    ;; do nothing if "asis",    ((equal texinfo-paragraph-indent "asis"))#    ;; do no indenting in list, etc.n!    ((> texinfo-stack-depth 0))   @5    ;; otherwise delete existing whitespace and indentf    (t F     (delete-region (point) (progn (skip-chars-forward " \t") (point)))8     (insert (make-string texinfo-paragraph-indent ? ))))   (forward-paragraph 1)    (forward-line -1)p   (end-of-line)x   (fill-paragraph nil))a  1 (put 'noindent 'texinfo-format 'texinfo-noindent)p (defun texinfo-noindent ()     (save-excursion      (forward-paragraph 1)t"     (if (search-backward "@refill"I                             (save-excursion (forward-line -1) (point)) t)tK         () ; leave @noindent command so @refill command knows not to indentf
       ;; elsef       (texinfo-discard-line))))-   t ;;; Index generation  4 (put 'vindex 'texinfo-format 'texinfo-format-vindex) (defun texinfo-format-vindex () "   (texinfo-index 'texinfo-vindex))  4 (put 'cindex 'texinfo-format 'texinfo-format-cindex) (defun texinfo-format-cindex ()d"   (texinfo-index 'texinfo-cindex))  4 (put 'findex 'texinfo-format 'texinfo-format-findex) (defun texinfo-format-findex ()r"   (texinfo-index 'texinfo-findex))  4 (put 'pindex 'texinfo-format 'texinfo-format-pindex) (defun texinfo-format-pindex ()t"   (texinfo-index 'texinfo-pindex))  4 (put 'tindex 'texinfo-format 'texinfo-format-tindex) (defun texinfo-format-tindex ()t"   (texinfo-index 'texinfo-tindex))  4 (put 'kindex 'texinfo-format 'texinfo-format-kindex) (defun texinfo-format-kindex ())"   (texinfo-index 'texinfo-kindex))   (defun texinfo-index (indexvar)x+   (let ((arg (texinfo-parse-expanded-arg)))t     (texinfo-discard-command)t     (set indexvar( 	 (cons (list arg(&                      texinfo-last-nodeM                      ;; Region formatting may not provide last node position.b  		     (if texinfo-last-node-posI                          (1+ (count-lines texinfo-last-node-pos (point)))h                        1))# 	       (symbol-value indexvar)))))-    (defconst texinfo-indexvar-alist   '(("cp" . texinfo-cindex)m     ("fn" . texinfo-findex)t     ("vr" . texinfo-vindex)-     ("tp" . texinfo-tindex)n     ("pg" . texinfo-pindex)m     ("ky" . texinfo-kindex)))t   i ;;; @defindex   @defcodeindext8 (put 'defindex 'texinfo-format 'texinfo-format-defindex)< (put 'defcodeindex 'texinfo-format 'texinfo-format-defindex)  ! (defun texinfo-format-defindex ()-<   (let* ((index-name (texinfo-parse-arg-discard)) ; eg: `aa'@          (indexing-command (intern (concat index-name "index")))F          (index-formatting-command      ; eg: `texinfo-format-aaindex'A           (intern (concat "texinfo-format-" index-name "index")))i?          (index-alist-name              ; eg: `texinfo-aaindex'i;           (intern (concat "texinfo-" index-name "index"))))d       (set index-alist-name nil)  5     (put indexing-command               ; eg, aaindex(          'texinfo-formatD          index-formatting-command)      ; eg, texinfo-format-aaindex  !     ;; eg: "aa" . texinfo-aaindext1     (or (assoc index-name texinfo-indexvar-alist)e$         (setq texinfo-indexvar-alist               (consf                (cons index-namea&                      index-alist-name)(                texinfo-indexvar-alist)))  "     (fset index-formatting-command           (list 'lambda 'nil%                 (list 'texinfo-index t9                       (list 'quote index-alist-name))))))e     ;;; @synindex   @syncodeindex;  8 (put 'synindex 'texinfo-format 'texinfo-format-synindex)< (put 'syncodeindex 'texinfo-format 'texinfo-format-synindex)  ! (defun texinfo-format-synindex ()t+   (let* ((args (texinfo-parse-arg-discard))o/          (second (cdr (read-from-string args)))e=          (joiner (symbol-name (car (read-from-string args)))) E          (joined (symbol-name (car (read-from-string args second)))))   5     (if (assoc joiner texinfo-short-index-cmds-alist)          (put=           (cdr (assoc joiner texinfo-short-index-cmds-alist))t          'texinfo-formatG          (or (cdr (assoc joined texinfo-short-index-format-cmds-alist))hA              (intern (concat "texinfo-format-" joined "index")))) 
       (put'        (intern (concat joiner "index"))d        'texinfo-formatD        (or (cdr(assoc joined texinfo-short-index-format-cmds-alist))B            (intern (concat "texinfo-format-" joined "index")))))))  ( (defconst texinfo-short-index-cmds-alist   '(("cp" . cindex)o     ("fn" . findex)      ("vr" . vindex)      ("tp" . tindex)e     ("pg" . pindex)t     ("ky" . kindex)))s  / (defconst texinfo-short-index-format-cmds-aliste"   '(("cp" . texinfo-format-cindex)"     ("fn" . texinfo-format-findex)"     ("vr" . texinfo-format-vindex)"     ("tp" . texinfo-format-tindex)"     ("pg" . texinfo-format-pindex)$     ("ky" . texinfo-format-kindex)))   o ;;; Sort and index (for VMS)  F ;; Sort an index which is in the current buffer between START and END.: ;; Used on VMS, where the `sort' utility is not available.& (defun texinfo-sort-region (start end)   (require 'sort)r   (save-restriction-      (narrow-to-region start end)J     (sort-subr nil 'forward-line 'end-of-line 'texinfo-sort-startkeyfun)))  # ;; Subroutine for sorting an index. > ;; At start of a line, return a string to sort the line under." (defun texinfo-sort-startkeyfun ()
   (let ((line"E 	 (buffer-substring (point) (save-excursion (end-of-line) (point))))) 9     ;; Canonicalize whitespace and eliminate funny chars. :     (while (string-match "[ \t][ \t]+\\|[^a-z0-9 ]+" line)?       (setq line (concat (substring line 0 (match-beginning 0))  			 " "r3 			 (substring line (match-end 0) (length line)))))1
     line))   f ;;; @printindexx  < (put 'printindex 'texinfo-format 'texinfo-format-printindex)  # (defun texinfo-format-printindex ()r    (let ((indexelts (symbol-value- 		    (cdr (assoc (texinfo-parse-arg-discard)t 				texinfo-indexvar-alist)))) 	opoint)     (insert "\n* Menu:\n\n")     (setq opoint (point))n'     (texinfo-print-index nil indexelts)t  !     (if (eq system-type 'vax-vms)i,         (texinfo-sort-region opoint (point))>       (shell-command-on-region opoint (point) "sort -fd" 1))))  + (defun texinfo-print-index (file indexelts)f   (while indexelts'     (if (stringp (car (car indexelts)))r         (progn3           (insert "* " (car (car indexelts)) ": " )n           (indent-to 32)           (insert;-            (if file (concat "(" file ")") "")d'            (nth 1 (car indexelts)) ".")            (indent-to 54)           (insertn&            (if (nth 2 (car indexelts))7                (format "  %d." (nth 2 (car indexelts)))e              "")            "\n"))*+       ;; index entries from @include'd filec2       (texinfo-print-index (nth 1 (car indexelts)) 			   (nth 2 (car indexelts))))t&     (setq indexelts (cdr indexelts))))   b ;;; Glyphs: @equiv, @error, etce  ? ;; @equiv           to show that two expressions are equivalentN, ;; @error           to show an error message3 ;; @expansion       to show what a macro expands to ? ;; @point           to show the location of point in an exampleg? ;; @print           to show what an evaluated expression printsdC ;; @result          to indicate the value returned by an expression   2 (put 'equiv 'texinfo-format 'texinfo-format-equiv) (defun texinfo-format-equiv ()   (texinfo-parse-arg-discard)s   (insert "=="))  2 (put 'error 'texinfo-format 'texinfo-format-error) (defun texinfo-format-error ()   (texinfo-parse-arg-discard)o   (insert "error-->"))  : (put 'expansion 'texinfo-format 'texinfo-format-expansion)" (defun texinfo-format-expansion ()   (texinfo-parse-arg-discard)n   (insert "==>"))a  2 (put 'point 'texinfo-format 'texinfo-format-point) (defun texinfo-format-point ()   (texinfo-parse-arg-discard)    (insert "-!-"))e  2 (put 'print 'texinfo-format 'texinfo-format-print) (defun texinfo-format-print ()   (texinfo-parse-arg-discard)    (insert "-|"))  4 (put 'result 'texinfo-format 'texinfo-format-result) (defun texinfo-format-result ()i   (texinfo-parse-arg-discard)1   (insert "=>"))   (. ;;; Definition formatting: @deffn, @defun, etc  ' ;; What definition formatting produces:p ;; ;; @deffn category name args... % ;;     In Info, `Category: name ARGS'o$ ;;     In index: name:  node. line#. ;; ;; @defvr category name   ;;     In Info, `Category: name'$ ;;     In index: name:  node. line#. ;;% ;; @deftp category name attributes...tG ;; `category name attributes...'       Note: @deftp args in lower case. $ ;;     In index: name:  node. line#. ;;5 ;; Specialized function-like or variable-like entity:e ;;. ;; @defun, @defmac, @defspec, @defvar, @defopt ;;< ;; @defun name args           In Info, `Function: name ARGS'9 ;; @defmac name args          In Info, `Macro: name ARGS' 7 ;; @defvar name               In Info, `Variable: name'  ;; etc.o$ ;;     In index: name:  node. line#. ;;A ;; Generalized typed-function-like or typed-variable-like entity:p- ;; @deftypefn category data-type name args...e3 ;;     In Info, `Category:  data-type name args...'x& ;; @deftypevr category data-type name + ;;     In Info, `Category:  data-type name'x$ ;;     In index: name:  node. line#. ;;A ;; Specialized typed-function-like or typed-variable-like entity:n% ;; @deftypefun data-type name args... 0 ;;     In Info, `Function:  data-type name ARGS'' ;;     In index: name:  node. line#.     ;; ;; @deftypevar data-type name + ;;     In Info, `Variable:  data-type name'dD ;;     In index: name:  node. line#.   but include args after name!? ;;' ;; Generalized object oriented entity:  % ;; @defop category class name args...o- ;;     In Info, `Category on class: name ARG' , ;;     In index: name on class: node. line#. ;;& ;; @defcv category class name         ) ;;     In Info, `Category of class: name's, ;;     In index: name of class: node. line#. ;;& ;; Specialized object oriented entity:! ;; @defmethod class name args... n, ;;     In Info, `Method on class: name ARGS', ;;     In index: name on class: node. line#. ;; ;; @defivar class name2 ;;     In Info, `Instance variable of class: name', ;;     In index: name of class: node. line#.   -' ;;; The definition formatting functions(   (defun texinfo-format-defun ()!   (texinfo-push-stack 'defun nil)e&   (setq fill-column (- fill-column 5))   (texinfo-format-defun-1 t))x   (defun texinfo-end-defun ())&   (setq fill-column (+ fill-column 5))   (texinfo-discard-command)m3   (let ((start (nth 1 (texinfo-pop-stack 'defun))))i     (texinfo-do-itemize start)2     ;; Delete extra newline inserted after header.     (save-excursion-       (goto-char start)        (delete-char -1))))m   (defun texinfo-format-defunx ()d   (texinfo-format-defun-1 nil))g  ' (defun texinfo-format-defun-1 (first-p)'6   (let ((parse-args (texinfo-format-parse-defun-args))? 	(command-type (get texinfo-command-name 'texinfo-defun-type)))n     (texinfo-discard-command) @     ;; Delete extra newline inserted after previous header line.     (if (not first-p)i 	(delete-char -1))     (funcallN      (get texinfo-command-name 'texinfo-deffn-formatting-property) parse-args)C     ;; Insert extra newline so that paragraph filling does not mess      ;; with header line.     (insert "\n\n") 4     (rplaca (cdr (cdr (car texinfo-stack))) (point))     (funcallN      (get texinfo-command-name 'texinfo-defun-indexing-property) parse-args)))  - ;;; Formatting the first line of a definitionm   ;; @deffn, @defvr, @deftpsE (put 'deffn 'texinfo-deffn-formatting-property 'texinfo-format-deffn) F (put 'deffnx 'texinfo-deffn-formatting-property 'texinfo-format-deffn)E (put 'defvr 'texinfo-deffn-formatting-property 'texinfo-format-deffn)pF (put 'defvrx 'texinfo-deffn-formatting-property 'texinfo-format-deffn)E (put 'deftp 'texinfo-deffn-formatting-property 'texinfo-format-deffn) F (put 'deftpx 'texinfo-deffn-formatting-property 'texinfo-format-deffn)) (defun texinfo-format-deffn (parsed-args) K   ;; Generalized function-like, variable-like, or generic data-type entity:i!   ;; @deffn category name args...-'   ;;     In Info, `Category: name ARGS'r'   ;; @deftp category name attributes...lI   ;; `category name attributes...'       Note: @deftp args in lower case.h$   (let ((category (car parsed-args))&         (name (car (cdr parsed-args)))'         (args (cdr (cdr parsed-args))))(&     (insert " -- " category ": " name)     (while args        (insert " "o0               (if (or (= ?& (aref (car args) 0))A                       (eq (eval (car command-type)) 'deftp-type))                    (car args)%                 (upcase (car args))))        (setq args (cdr args)))))d  C ;; @defun, @defmac, @defspec, @defvar, @defopt: Specialized, simples. (put 'defun 'texinfo-deffn-formatting-property'      'texinfo-format-specialized-defun) / (put 'defunx 'texinfo-deffn-formatting-propertye'      'texinfo-format-specialized-defun)-/ (put 'defmac 'texinfo-deffn-formatting-property)'      'texinfo-format-specialized-defun) 0 (put 'defmacx 'texinfo-deffn-formatting-property'      'texinfo-format-specialized-defun) 0 (put 'defspec 'texinfo-deffn-formatting-property'      'texinfo-format-specialized-defun)s1 (put 'defspecx 'texinfo-deffn-formatting-property-'      'texinfo-format-specialized-defun) / (put 'defvar 'texinfo-deffn-formatting-propertyn'      'texinfo-format-specialized-defun)o0 (put 'defvarx 'texinfo-deffn-formatting-property'      'texinfo-format-specialized-defun)./ (put 'defopt 'texinfo-deffn-formatting-propertyn'      'texinfo-format-specialized-defun)u0 (put 'defoptx 'texinfo-deffn-formatting-property'      'texinfo-format-specialized-defun) 5 (defun texinfo-format-specialized-defun (parsed-args)l7   ;; Specialized function-like or variable-like entity:e>   ;; @defun name args           In Info, `Function: Name ARGS';   ;; @defmac name args          In Info, `Macro: Name ARGS'n9   ;; @defvar name               In Info, `Variable: Name'n3   ;; Use cdr of command-type to determine category:y+   (let ((category (car (cdr command-type)))a          (name (car parsed-args))!         (args (cdr parsed-args)))\&     (insert " -- " category ": " name)     (while argsp       (insert " "x,               (if (= ?& (aref (car args) 0))                   (car args)%                 (upcase (car args))))-       (setq args (cdr args)))))1  , ;; @deftypefn, @deftypevr: Generalized typedM (put 'deftypefn 'texinfo-deffn-formatting-property 'texinfo-format-deftypefn)oN (put 'deftypefnx 'texinfo-deffn-formatting-property 'texinfo-format-deftypefn)M (put 'deftypevr 'texinfo-deffn-formatting-property 'texinfo-format-deftypefn) N (put 'deftypevrx 'texinfo-deffn-formatting-property 'texinfo-format-deftypefn)- (defun texinfo-format-deftypefn (parsed-args) C   ;; Generalized typed-function-like or typed-variable-like entity: /   ;; @deftypefn category data-type name args...c5   ;;     In Info, `Category:  data-type name args...'d(   ;; @deftypevr category data-type name -   ;;     In Info, `Category:  data-type name' ?   ;; Note: args in lower case, unless modified in command line.h$   (let ((category (car parsed-args))+         (data-type (car (cdr parsed-args)));,         (name (car (cdr (cdr parsed-args))))-         (args (cdr (cdr (cdr parsed-args)))))o4     (insert " -- " category ": " data-type " " name)     (while argsx       (insert " " (car args))        (setq args (cdr args)))))n  . ;; @deftypefun, @deftypevar: Specialized typedO (put 'deftypefun 'texinfo-deffn-formatting-property 'texinfo-format-deftypefun)s4 (put 'deftypefunx 'texinfo-deffn-formatting-property       'texinfo-format-deftypefun)O (put 'deftypevar 'texinfo-deffn-formatting-property 'texinfo-format-deftypefun) 4 (put 'deftypevarx 'texinfo-deffn-formatting-property       'texinfo-format-deftypefun). (defun texinfo-format-deftypefun (parsed-args)C   ;; Specialized typed-function-like or typed-variable-like entity:f'   ;; @deftypefun data-type name args...r2   ;;     In Info, `Function:  data-type name ARGS'    ;; @deftypevar data-type name -   ;;     In Info, `Variable:  data-type name'o?   ;; Note: args in lower case, unless modified in command line.o3   ;; Use cdr of command-type to determine category:e+   (let ((category (car (cdr command-type)))i%         (data-type (car parsed-args))a'         (name (car (cdr  parsed-args)))i'         (args (cdr (cdr parsed-args))))f4     (insert " -- " category ": " data-type " " name)     (while args        (insert " " (car args))        (setq args (cdr args)))))   & ;; @defop: Generalized object-orientedE (put 'defop 'texinfo-deffn-formatting-property 'texinfo-format-defop);F (put 'defopx 'texinfo-deffn-formatting-property 'texinfo-format-defop)) (defun texinfo-format-defop (parsed-args);)   ;; Generalized object oriented entity:  '   ;; @defop category class name args...c/   ;;     In Info, `Category on class: name ARG' *   ;; Note: args in upper case; use of `on'$   (let ((category (car parsed-args))'         (class (car (cdr parsed-args))) ,         (name (car (cdr (cdr parsed-args))))-         (args (cdr (cdr (cdr parsed-args)))))z3     (insert " -- " category " on " class ": " name)p     (while argsa&       (insert " " (upcase (car args)))       (setq args (cdr args)))))e  & ;; @defcv: Generalized object-orientedE (put 'defcv 'texinfo-deffn-formatting-property 'texinfo-format-defcv):F (put 'defcvx 'texinfo-deffn-formatting-property 'texinfo-format-defcv)) (defun texinfo-format-defcv (parsed-args)y)   ;; Generalized object oriented entity: :(   ;; @defcv category class name         +   ;;     In Info, `Category of class: name't*   ;; Note: args in upper case; use of `of'$   (let ((category (car parsed-args))'         (class (car (cdr parsed-args)))a,         (name (car (cdr (cdr parsed-args))))-         (args (cdr (cdr (cdr parsed-args)))));3     (insert " -- " category " of " class ": " name)I     (while argsc&       (insert " " (upcase (car args)))       (setq args (cdr args)))))   * ;; @defmethod: Specialized object-orientedM (put 'defmethod 'texinfo-deffn-formatting-property 'texinfo-format-defmethod);N (put 'defmethodx 'texinfo-deffn-formatting-property 'texinfo-format-defmethod)- (defun texinfo-format-defmethod (parsed-args);(   ;; Specialized object oriented entity:#   ;; @defmethod class name args... ;.   ;;     In Info, `Method on class: name ARGS'*   ;; Note: args in upper case; use of `on'3   ;; Use cdr of command-type to determine category:c+   (let ((category (car (cdr command-type)))o!         (class (car parsed-args)) '         (name (car (cdr  parsed-args)))s(         (args (cdr  (cdr parsed-args))))3     (insert " -- " category " on " class ": " name)o     (while args)&       (insert " " (upcase (car args)))       (setq args (cdr args)))))d  ( ;; @defivar: Specialized object-orientedI (put 'defivar 'texinfo-deffn-formatting-property 'texinfo-format-defivar)uJ (put 'defivarx 'texinfo-deffn-formatting-property 'texinfo-format-defivar)+ (defun texinfo-format-defivar (parsed-args)-(   ;; Specialized object oriented entity:   ;; @defivar class name4   ;;     In Info, `Instance variable of class: name'*   ;; Note: args in upper case; use of `of'3   ;; Use cdr of command-type to determine category:a+   (let ((category (car (cdr command-type)))n!         (class (car parsed-args))o'         (name (car (cdr  parsed-args)))e(         (args (cdr  (cdr parsed-args))))3     (insert " -- " category " of " class ": " name)      (while args(&       (insert " " (upcase (car args)))       (setq args (cdr args)))))n   e ;;; Indexing for definitions  M ;; An index entry has three parts: the `entry proper', the node name, and the,E ;; line number.  Depending on the which command is used, the entry isf ;; formatted differently:f ;; ;; @defun, - ;; @defmac, 
 ;; @defspec, f ;; @defvar, C ;; @defopt          all use their 1st argument as the entry-proper p ;; ;; @deffn, e ;; @defvr, o
 ;; @deftp  ;; @deftypefunB ;; @deftypevar      all use their 2nd argument as the entry-proper ;; ;; @deftypefn, tE ;; @deftypevr       both use their 3rd argument as the entry-proper  f ;;F ;; @defmethod       uses its 2nd and 1st arguments as an entry-proper . ;;                    formatted: NAME on CLASS  F ;; @defop           uses its 3rd and 2nd arguments as an entry-proper . ;;                    formatted: NAME on CLASS
 ;;        E ;; @defivar         uses its 2nd and 1st arguments as an entry-properr. ;;                    formatted: NAME of CLASS ;;D ;; @defcv           uses its 3rd and 2nd argument as an entry-proper. ;;                    formatted: NAME of CLASS  B (put 'defun 'texinfo-defun-indexing-property 'texinfo-index-defun)C (put 'defunx 'texinfo-defun-indexing-property 'texinfo-index-defun) C (put 'defmac 'texinfo-defun-indexing-property 'texinfo-index-defun)tD (put 'defmacx 'texinfo-defun-indexing-property 'texinfo-index-defun)D (put 'defspec 'texinfo-defun-indexing-property 'texinfo-index-defun)E (put 'defspecx 'texinfo-defun-indexing-property 'texinfo-index-defun)fC (put 'defvar 'texinfo-defun-indexing-property 'texinfo-index-defun)tD (put 'defvarx 'texinfo-defun-indexing-property 'texinfo-index-defun)D (put 'defopt  'texinfo-defun-indexing-property 'texinfo-index-defun)E (put 'defoptx  'texinfo-defun-indexing-property 'texinfo-index-defun)r( (defun texinfo-index-defun (parsed-args)(   ;; use 1st parsed-arg  as entry-proper4   ;; `index-list' will be texinfo-findex or the likeE   (let ((index-list (get texinfo-command-name 'texinfo-defun-index)))'     (set index-listl          (cons tA           ;; Three elements: entry-proper, node-name, line-numbers           (list.            (car parsed-args)            texinfo-last-nodeC            ;; Region formatting may not provide last node position.t$            (if texinfo-last-node-pos?                (1+ (count-lines texinfo-last-node-pos (point)))-              1))'           (symbol-value index-list)))))i  B (put 'deffn 'texinfo-defun-indexing-property 'texinfo-index-deffn)C (put 'deffnx 'texinfo-defun-indexing-property 'texinfo-index-deffn)eB (put 'defvr 'texinfo-defun-indexing-property 'texinfo-index-deffn)C (put 'defvrx 'texinfo-defun-indexing-property 'texinfo-index-deffn)mB (put 'deftp 'texinfo-defun-indexing-property 'texinfo-index-deffn)C (put 'deftpx 'texinfo-defun-indexing-property 'texinfo-index-deffn)gG (put 'deftypefun 'texinfo-defun-indexing-property 'texinfo-index-deffn) H (put 'deftypefunx 'texinfo-defun-indexing-property 'texinfo-index-deffn)G (put 'deftypevar 'texinfo-defun-indexing-property 'texinfo-index-deffn) H (put 'deftypevarx 'texinfo-defun-indexing-property 'texinfo-index-deffn)) (defun texinfo-index-deffn (parsed-args) t'  ;; use 2nd parsed-arg  as entry-proper 4   ;; `index-list' will be texinfo-findex or the likeE   (let ((index-list (get texinfo-command-name 'texinfo-defun-index)))o     (set index-list-          (cons nA           ;; Three elements: entry-proper, node-name, line-numbern           (liste"            (car (cdr parsed-args))            texinfo-last-nodeC            ;; Region formatting may not provide last node position.;$            (if texinfo-last-node-pos?                (1+ (count-lines texinfo-last-node-pos (point)))n              1))'           (symbol-value index-list)))))t  J (put 'deftypefn 'texinfo-defun-indexing-property 'texinfo-index-deftypefn)K (put 'deftypefnx 'texinfo-defun-indexing-property 'texinfo-index-deftypefn)rJ (put 'deftypevr 'texinfo-defun-indexing-property 'texinfo-index-deftypefn)K (put 'deftypevrx 'texinfo-defun-indexing-property 'texinfo-index-deftypefn)@, (defun texinfo-index-deftypefn (parsed-args)(   ;; use 3rd parsed-arg  as entry-proper4   ;; `index-list' will be texinfo-findex or the likeE   (let ((index-list (get texinfo-command-name 'texinfo-defun-index)))      (set index-listi          (cons iA           ;; Three elements: entry-proper, node-name, line-numbero           (list-(            (car (cdr (cdr parsed-args)))            texinfo-last-nodeC            ;; Region formatting may not provide last node position.i$            (if texinfo-last-node-pos?                (1+ (count-lines texinfo-last-node-pos (point)))a              1))'           (symbol-value index-list)))))o  J (put 'defmethod 'texinfo-defun-indexing-property 'texinfo-index-defmethod)K (put 'defmethodx 'texinfo-defun-indexing-property 'texinfo-index-defmethod)l, (defun texinfo-index-defmethod (parsed-args)/   ;; use 2nd on 1st parsed-arg  as entry-proper 4   ;; `index-list' will be texinfo-findex or the likeE   (let ((index-list (get texinfo-command-name 'texinfo-defun-index)))      (set index-list           (cons aA           ;; Three elements: entry-proper, node-name, line-numbero           (listp)            (format "%s on %s"            y*                    (car (cdr parsed-args))%                    (car parsed-args))f            texinfo-last-nodeC            ;; Region formatting may not provide last node position. $            (if texinfo-last-node-pos?                (1+ (count-lines texinfo-last-node-pos (point))):              1))'           (symbol-value index-list)))))r  B (put 'defop 'texinfo-defun-indexing-property 'texinfo-index-defop)C (put 'defopx 'texinfo-defun-indexing-property 'texinfo-index-defop)s( (defun texinfo-index-defop (parsed-args)/   ;; use 3rd on 2nd parsed-arg  as entry-properr4   ;; `index-list' will be texinfo-findex or the likeE   (let ((index-list (get texinfo-command-name 'texinfo-defun-index)))d     (set index-listr          (cons tA           ;; Three elements: entry-proper, node-name, line-numberf           (listf)            (format "%s on %s"            ;0                    (car (cdr (cdr parsed-args)))+                    (car (cdr parsed-args)))n            texinfo-last-nodeC            ;; Region formatting may not provide last node position.p$            (if texinfo-last-node-pos?                (1+ (count-lines texinfo-last-node-pos (point)))               1))'           (symbol-value index-list)))))   F (put 'defivar 'texinfo-defun-indexing-property 'texinfo-index-defivar)G (put 'defivarx 'texinfo-defun-indexing-property 'texinfo-index-defivar):* (defun texinfo-index-defivar (parsed-args)/   ;; use 2nd of 1st parsed-arg  as entry-properm4   ;; `index-list' will be texinfo-findex or the likeE   (let ((index-list (get texinfo-command-name 'texinfo-defun-index)))o     (set index-list;          (cons cA           ;; Three elements: entry-proper, node-name, line-numberI           (listn)            (format "%s of %s"            r*                    (car (cdr parsed-args))%                    (car parsed-args))c            texinfo-last-nodeC            ;; Region formatting may not provide last node position.r$            (if texinfo-last-node-pos?                (1+ (count-lines texinfo-last-node-pos (point)))a              1))'           (symbol-value index-list))))))  B (put 'defcv 'texinfo-defun-indexing-property 'texinfo-index-defcv)C (put 'defcvx 'texinfo-defun-indexing-property 'texinfo-index-defcv)-( (defun texinfo-index-defcv (parsed-args)/   ;; use 3rd of 2nd parsed-arg  as entry-proper)4   ;; `index-list' will be texinfo-findex or the likeE   (let ((index-list (get texinfo-command-name 'texinfo-defun-index)))I     (set index-listi          (cons mA           ;; Three elements: entry-proper, node-name, line-numberm           (listm)            (format "%s of %s"             0                    (car (cdr (cdr parsed-args)))+                    (car (cdr parsed-args)))             texinfo-last-nodeC            ;; Region formatting may not provide last node position. $            (if texinfo-last-node-pos?                (1+ (count-lines texinfo-last-node-pos (point)))i              1))'           (symbol-value index-list)))))e   r ;;; Properties for definitions  . ;; Each definition command has six properties: ;;F ;; 1. texinfo-deffn-formatting-property      to format definition lineB ;; 2. texinfo-defun-indexing-property        to create index entry? ;; 3. texinfo-format                         formatting commandeC ;; 4. texinfo-end                            end formatting command D ;; 5. texinfo-defun-type                     type of deffn to formatA ;; 6. texinfo-defun-index                    type of index to usee ;;C ;; The `x' forms of each definition command are used for the second  ;; and subsequent header lines.C  L ;; The texinfo-deffn-formatting-property and texinfo-defun-indexing-propertyK ;; are listed just before the appropriate formatting and indexing commands.   2 (put 'deffn 'texinfo-format 'texinfo-format-defun)4 (put 'deffnx 'texinfo-format 'texinfo-format-defunx), (put 'deffn 'texinfo-end 'texinfo-end-defun)3 (put 'deffn 'texinfo-defun-type '('deffn-type nil)):4 (put 'deffnx 'texinfo-defun-type '('deffn-type nil))1 (put 'deffn 'texinfo-defun-index 'texinfo-findex)f2 (put 'deffnx 'texinfo-defun-index 'texinfo-findex)  2 (put 'defun 'texinfo-format 'texinfo-format-defun)4 (put 'defunx 'texinfo-format 'texinfo-format-defunx), (put 'defun 'texinfo-end 'texinfo-end-defun): (put 'defun 'texinfo-defun-type '('defun-type "Function")); (put 'defunx 'texinfo-defun-type '('defun-type "Function"))n1 (put 'defun 'texinfo-defun-index 'texinfo-findex)t2 (put 'defunx 'texinfo-defun-index 'texinfo-findex)  3 (put 'defmac 'texinfo-format 'texinfo-format-defun)t5 (put 'defmacx 'texinfo-format 'texinfo-format-defunx)p- (put 'defmac 'texinfo-end 'texinfo-end-defun)t8 (put 'defmac 'texinfo-defun-type '('defun-type "Macro"))9 (put 'defmacx 'texinfo-defun-type '('defun-type "Macro"))-2 (put 'defmac 'texinfo-defun-index 'texinfo-findex)3 (put 'defmacx 'texinfo-defun-index 'texinfo-findex)d  4 (put 'defspec 'texinfo-format 'texinfo-format-defun)6 (put 'defspecx 'texinfo-format 'texinfo-format-defunx). (put 'defspec 'texinfo-end 'texinfo-end-defun)@ (put 'defspec 'texinfo-defun-type '('defun-type "Special form"))A (put 'defspecx 'texinfo-defun-type '('defun-type "Special form"))o3 (put 'defspec 'texinfo-defun-index 'texinfo-findex)n4 (put 'defspecx 'texinfo-defun-index 'texinfo-findex)  2 (put 'defvr 'texinfo-format 'texinfo-format-defun)4 (put 'defvrx 'texinfo-format 'texinfo-format-defunx), (put 'defvr 'texinfo-end 'texinfo-end-defun)3 (put 'defvr 'texinfo-defun-type '('deffn-type nil))r4 (put 'defvrx 'texinfo-defun-type '('deffn-type nil))1 (put 'defvr 'texinfo-defun-index 'texinfo-vindex)t2 (put 'defvrx 'texinfo-defun-index 'texinfo-vindex)  3 (put 'defvar 'texinfo-format 'texinfo-format-defun)x5 (put 'defvarx 'texinfo-format 'texinfo-format-defunx)e- (put 'defvar 'texinfo-end 'texinfo-end-defun)t; (put 'defvar 'texinfo-defun-type '('defun-type "Variable")))< (put 'defvarx 'texinfo-defun-type '('defun-type "Variable"))2 (put 'defvar 'texinfo-defun-index 'texinfo-vindex)3 (put 'defvarx 'texinfo-defun-index 'texinfo-vindex)d  5 (put 'defconst 'texinfo-format 'texinfo-format-defun)y7 (put 'defconstx 'texinfo-format 'texinfo-format-defunx) / (put 'defconst 'texinfo-end 'texinfo-end-defun)m= (put 'defconst 'texinfo-defun-type '('defun-type "Constant"))s> (put 'defconstx 'texinfo-defun-type '('defun-type "Constant"))4 (put 'defconst 'texinfo-defun-index 'texinfo-vindex)5 (put 'defconstx 'texinfo-defun-index 'texinfo-vindex)i  3 (put 'defcmd 'texinfo-format 'texinfo-format-defun) 5 (put 'defcmdx 'texinfo-format 'texinfo-format-defunx)o- (put 'defcmd 'texinfo-end 'texinfo-end-defun) : (put 'defcmd 'texinfo-defun-type '('defun-type "Command")); (put 'defcmdx 'texinfo-defun-type '('defun-type "Command"))-2 (put 'defcmd 'texinfo-defun-index 'texinfo-findex)3 (put 'defcmdx 'texinfo-defun-index 'texinfo-findex)   3 (put 'defopt 'texinfo-format 'texinfo-format-defun)f5 (put 'defoptx 'texinfo-format 'texinfo-format-defunx)t- (put 'defopt 'texinfo-end 'texinfo-end-defun)d> (put 'defopt 'texinfo-defun-type '('defun-type "User Option"))? (put 'defoptx 'texinfo-defun-type '('defun-type "User Option"))i2 (put 'defopt 'texinfo-defun-index 'texinfo-vindex)3 (put 'defoptx 'texinfo-defun-index 'texinfo-vindex)   2 (put 'deftp 'texinfo-format 'texinfo-format-defun)4 (put 'deftpx 'texinfo-format 'texinfo-format-defunx), (put 'deftp 'texinfo-end 'texinfo-end-defun)3 (put 'deftp 'texinfo-defun-type '('deftp-type nil))n4 (put 'deftpx 'texinfo-defun-type '('deftp-type nil))1 (put 'deftp 'texinfo-defun-index 'texinfo-tindex)o2 (put 'deftpx 'texinfo-defun-index 'texinfo-tindex)  . ;;; Object-oriented stuff is a little hairier.  2 (put 'defop 'texinfo-format 'texinfo-format-defun)4 (put 'defopx 'texinfo-format 'texinfo-format-defunx), (put 'defop 'texinfo-end 'texinfo-end-defun)3 (put 'defop 'texinfo-defun-type '('defop-type nil))s4 (put 'defopx 'texinfo-defun-type '('defop-type nil))1 (put 'defop 'texinfo-defun-index 'texinfo-findex)m2 (put 'defopx 'texinfo-defun-index 'texinfo-findex)  6 (put 'defmethod 'texinfo-format 'texinfo-format-defun)8 (put 'defmethodx 'texinfo-format 'texinfo-format-defunx)0 (put 'defmethod 'texinfo-end 'texinfo-end-defun)@ (put 'defmethod 'texinfo-defun-type '('defmethod-type "Method"))A (put 'defmethodx 'texinfo-defun-type '('defmethod-type "Method")) 5 (put 'defmethod 'texinfo-defun-index 'texinfo-findex)x6 (put 'defmethodx 'texinfo-defun-index 'texinfo-findex)  2 (put 'defcv 'texinfo-format 'texinfo-format-defun)4 (put 'defcvx 'texinfo-format 'texinfo-format-defunx), (put 'defcv 'texinfo-end 'texinfo-end-defun)3 (put 'defcv 'texinfo-defun-type '('defop-type nil))t4 (put 'defcvx 'texinfo-defun-type '('defop-type nil))1 (put 'defcv 'texinfo-defun-index 'texinfo-vindex)p2 (put 'defcvx 'texinfo-defun-index 'texinfo-vindex)  4 (put 'defivar 'texinfo-format 'texinfo-format-defun)6 (put 'defivarx 'texinfo-format 'texinfo-format-defunx). (put 'defivar 'texinfo-end 'texinfo-end-defun)I (put 'defivar 'texinfo-defun-type '('defmethod-type "Instance variable"))sJ (put 'defivarx 'texinfo-defun-type '('defmethod-type "Instance variable"))3 (put 'defivar 'texinfo-defun-index 'texinfo-vindex)o4 (put 'defivarx 'texinfo-defun-index 'texinfo-vindex)  ! ;;; Typed functions and variables   6 (put 'deftypefn 'texinfo-format 'texinfo-format-defun)8 (put 'deftypefnx 'texinfo-format 'texinfo-format-defunx)0 (put 'deftypefn 'texinfo-end 'texinfo-end-defun); (put 'deftypefn 'texinfo-defun-type '('deftypefn-type nil)) < (put 'deftypefnx 'texinfo-defun-type '('deftypefn-type nil))5 (put 'deftypefn 'texinfo-defun-index 'texinfo-findex) 6 (put 'deftypefnx 'texinfo-defun-index 'texinfo-findex)  7 (put 'deftypefun 'texinfo-format 'texinfo-format-defun)d9 (put 'deftypefunx 'texinfo-format 'texinfo-format-defunx) 1 (put 'deftypefun 'texinfo-end 'texinfo-end-defun);D (put 'deftypefun 'texinfo-defun-type '('deftypefun-type "Function"))E (put 'deftypefunx 'texinfo-defun-type '('deftypefun-type "Function")) 6 (put 'deftypefun 'texinfo-defun-index 'texinfo-findex)7 (put 'deftypefunx 'texinfo-defun-index 'texinfo-findex)r  6 (put 'deftypevr 'texinfo-format 'texinfo-format-defun)8 (put 'deftypevrx 'texinfo-format 'texinfo-format-defunx)0 (put 'deftypevr 'texinfo-end 'texinfo-end-defun); (put 'deftypevr 'texinfo-defun-type '('deftypefn-type nil))x< (put 'deftypevrx 'texinfo-defun-type '('deftypefn-type nil))5 (put 'deftypevr 'texinfo-defun-index 'texinfo-vindex)v6 (put 'deftypevrx 'texinfo-defun-index 'texinfo-vindex)  7 (put 'deftypevar 'texinfo-format 'texinfo-format-defun)i9 (put 'deftypevarx 'texinfo-format 'texinfo-format-defunx)t1 (put 'deftypevar 'texinfo-end 'texinfo-end-defun)sD (put 'deftypevar 'texinfo-defun-type '('deftypevar-type "Variable"))E (put 'deftypevarx 'texinfo-defun-type '('deftypevar-type "Variable"))s6 (put 'deftypevar 'texinfo-defun-index 'texinfo-vindex)7 (put 'deftypevarx 'texinfo-defun-index 'texinfo-vindex))    " ;;; @set, @clear, @ifset, @ifclear  E ;; If a flag is set with @set FLAG, then text between @ifset and @end(B ;; ifset is formatted normally, but if the flag is is cleared with> ;; @clear FLAG, then the text is not formatted; it is ignored.  D ;; If a flag is cleared with @clear FLAG, then text between @ifclearI ;; and @end ifclear is formatted normally, but if the flag is is set witheF ;; @set FLAG, then the text is not formatted; it is ignored.  @ifclear ;; is the opposite of @ifset.   0 ;; If a flag is set to a string with @set FLAG, ) ;; replace  @value{FLAG} with the string. & ;; If a flag with a value is cleared,  ;; @value{FLAG} is invalid, 7 ;; as if there had never been any @set FLAG previously.u  + (put 'clear 'texinfo-format 'texinfo-clear)e (defun texinfo-clear ()     "Clear the value of the flag."*   (let* ((arg (texinfo-parse-arg-discard)),          (flag (car (read-from-string arg)))>          (value (substring arg (cdr (read-from-string arg)))))2     (put flag 'texinfo-whether-setp 'flag-cleared)&     (put flag 'texinfo-set-value "")))  ' (put 'set 'texinfo-format 'texinfo-set)t (defun texinfo-set ())5   "Set the value of the flag, optionally to a string.e) The command  `@set foo This is a string.':/ sets flag foo to the value: `This is a string.'n2 The command  `@value{foo}'  expands to the value."*   (let* ((arg (texinfo-parse-arg-discard)),          (flag (car (read-from-string arg)))>          (value (substring arg (cdr (read-from-string arg))))).     (put flag 'texinfo-whether-setp 'flag-set))     (put flag 'texinfo-set-value value)))(  + (put 'value 'texinfo-format 'texinfo-value)- (defun texinfo-value ()".   "Insert the string to which the flag is set.) The command  `@set foo This is a string.'u/ sets flag foo to the value: `This is a string.'-2 The command  `@value{foo}'  expands to the value."*   (let ((arg (texinfo-parse-arg-discard)))     (cond ((and H             (eq (get (car (read-from-string arg)) 'texinfo-whether-setp)                 'flag-set)B             (get (car (read-from-string arg)) 'texinfo-set-value))J            (insert (get (car (read-from-string arg)) 'texinfo-set-value)))H           ((eq (get (car (read-from-string arg)) 'texinfo-whether-setp)                 'flag-cleared)f:            (insert (format "{No value for \"%s\"}"  arg)))L           ((eq (get (car (read-from-string arg)) 'texinfo-whether-setp) nil)=            (insert (format "{No value for \"%s\"}"  arg))))))   2 (put 'ifset 'texinfo-end 'texinfo-discard-command), (put 'ifset 'texinfo-format 'texinfo-if-set) (defun texinfo-if-set ()K   "If set, continue formatting; else do not format region up to @end ifset"p*   (let ((arg (texinfo-parse-arg-discard)))	     (cond B      ((eq (get (car (read-from-string arg)) 'texinfo-whether-setp)           'flag-set)C       ;; Format the text (i.e., do not remove it); do nothing here.x	       ())eB      ((eq (get (car (read-from-string arg)) 'texinfo-whether-setp)           'flag-cleared);       ;; Clear region (i.e., cause the text to be ignored).e*       (delete-region texinfo-command-startF                        (progn (re-search-forward "@end ifset[ \t]*\n")(                               (point))))B      ((eq (get (car (read-from-string arg)) 'texinfo-whether-setp)           nil)K       (error  "@ifset flag `%s' is not defined by @set or @clear." arg)))))   4 (put 'ifclear 'texinfo-end 'texinfo-discard-command)0 (put 'ifclear 'texinfo-format 'texinfo-if-clear) (defun texinfo-if-clear ()I   "If clear, continue formatting; if set, do not format up to @end ifset"(*   (let ((arg (texinfo-parse-arg-discard)))	     (cond-B      ((eq (get (car (read-from-string arg)) 'texinfo-whether-setp)           'flag-set);       ;; Clear region (i.e., cause the text to be ignored).t*       (delete-region texinfo-command-startH                        (progn (re-search-forward "@end ifclear[ \t]*\n")(                               (point))))B      ((eq (get (car (read-from-string arg)) 'texinfo-whether-setp)           'flag-cleared)C       ;; Format the text (i.e., do not remove it); do nothing here.'	       ())iB      ((eq (get (car (read-from-string arg)) 'texinfo-whether-setp)           nil)M       (error  "@ifclear flag `%s' is not defined by @clear or @set." arg)))))e   y/ ;;; Process included files:  `@include' commandt   ;; Updated 19 October 1990B ;; In the original version, include files were ignored by Info butD ;; incorporated in to the printed manual.  To make references to theF ;; included file, the Texinfo source file has to refer to the includedD ;; files using the `(filename)nodename' format for refering to otherE ;; Info files.  Also, the included files had to be formatted on theiri1 ;; own.  It was just like they were another file.x  @ ;; Currently, include files are inserted into the buffer that isF ;; formatted for Info.  If large, the resulting info file is split andE ;; tagified.  For current include files to work, the master menu mustfE ;; refer to all the nodes, and the highest level nodes in the include-; ;; files must have the correct next, prev, and up pointers.   D ;; The included file may have an @setfilename and even an @settitle, ;; but not an /input texinfo   ; Original definition:" ; (defun texinfo-format-include ()0 ;   (let ((filename (texinfo-parse-arg-discard))& ; 	(default-directory input-directory) ; 	subindex) ;     (setq subindex ; 	  (save-excursion ; 	    (progn (find-file= ; 		    (cond ((file-readable-p (concat filename ".texinfo"))t% ; 			   (concat filename ".texinfo"))y3 ; 			  ((file-readable-p (concat filename ".texi"))'" ; 			   (concat filename ".texi"))2 ; 			  ((file-readable-p (concat filename ".tex"))! ; 			   (concat filename ".tex"))u" ; 			  ((file-readable-p filename) ; 			   filename))/ ; 			  (t (error "@include'd file %s not found"p ; 				    filename))))# ; 		   (texinfo-format-buffer-1))))cH ;     (texinfo-subindex 'texinfo-vindex (car subindex) (nth 1 subindex))H ;     (texinfo-subindex 'texinfo-findex (car subindex) (nth 2 subindex))H ;     (texinfo-subindex 'texinfo-cindex (car subindex) (nth 3 subindex))H ;     (texinfo-subindex 'texinfo-pindex (car subindex) (nth 4 subindex))H ;     (texinfo-subindex 'texinfo-tindex (car subindex) (nth 5 subindex))J ;     (texinfo-subindex 'texinfo-kindex (car subindex) (nth 6 subindex))))  / (defun texinfo-subindex (indexvar file content)e2   (set indexvar (cons (list 'recurse file content)" 		      (symbol-value indexvar))))  6 (put 'include 'texinfo-format 'texinfo-format-include)  (defun texinfo-format-include ())   (let ((filename (concat input-directory " 			  (texinfo-parse-arg-discard)))% 	(default-directory input-directory))d$     (message "Reading: %s" filename)     (save-excursionf       (save-restriction-         (narrow-to-region           (point)A          (+ (point) (car (cdr (insert-file-contents filename)))))o         (goto-char (point-min))i         (texinfo-append-refill)d:         (texinfo-format-convert (point-min) (point-max))))B     (setq last-input-buffer input-buffer)  ; to bypass setfilename     ))   e+ ;;; Numerous commands do nothing in Texinfot  @ ;; These commands are defined in texinfo.tex for printed output.  0 (put 'bye 'texinfo-format 'texinfo-discard-line)8 (put 'c 'texinfo-format 'texinfo-discard-line-with-args)> (put 'comment 'texinfo-format 'texinfo-discard-line-with-args)? (put 'contents 'texinfo-format 'texinfo-discard-line-with-args)t5 (put 'finalout 'texinfo-format 'texinfo-discard-line) 9 (put 'group 'texinfo-end 'texinfo-discard-line-with-args)v< (put 'group 'texinfo-format 'texinfo-discard-line-with-args)? (put 'headings 'texinfo-format 'texinfo-discard-line-with-args)f< (put 'hsize 'texinfo-format 'texinfo-discard-line-with-args)A (put 'itemindent 'texinfo-format 'texinfo-discard-line-with-args)xD (put 'lispnarrowing 'texinfo-format 'texinfo-discard-line-with-args); (put 'need 'texinfo-format 'texinfo-discard-line-with-args)V= (put 'nopara 'texinfo-format 'texinfo-discard-line-with-args)-; (put 'page 'texinfo-format 'texinfo-discard-line-with-args)x@ (put 'parindent 'texinfo-format 'texinfo-discard-line-with-args)H (put 'setchapternewpage 'texinfo-format 'texinfo-discard-line-with-args); (put 'setq 'texinfo-format 'texinfo-discard-line-with-args)o? (put 'settitle 'texinfo-format 'texinfo-discard-line-with-args)L; (put 'setx 'texinfo-format 'texinfo-discard-line-with-args) D (put 'shortcontents 'texinfo-format 'texinfo-discard-line-with-args)6 (put 'smallbook 'texinfo-format 'texinfo-discard-line)F (put 'summarycontents 'texinfo-format 'texinfo-discard-line-with-args)   c# ;;; Some commands cannot be handled    (defun texinfo-unsupported () '   (error "%s is not handled by texinfo"}@ 	 (buffer-substring texinfo-command-start texinfo-command-end))) { ;;; Batch formatting   (defun batch-texinfo-format ()K   "Runs  texinfo-format-buffer  on the files remaining on the command line.t= Must be used only with -batch, and kills emacs on completion.rA Each file will be processed even if an error occurred previously.n For example, invokeaE   \"emacs -batch -funcall batch-texinfo-format $docs/ ~/*.texinfo\"."n   (if (not noninteractive)>       (error "batch-texinfo-format may only be used -batch."))   (let ((version-control t)n 	(auto-save-default nil) 	(find-file-run-dired nil) 	(kept-old-versions 259259)n 	(kept-new-versions 259259))     (let ((error 0)t 	  file  	  (files ()))#       (while command-line-args-lefta< 	(setq file (expand-file-name (car command-line-args-left)))" 	(cond ((not (file-exists-p file)). 	       (message ">> %s does not exist!" file) 	       (setq error 1)< 		     command-line-args-left (cdr command-line-args-left))) 	      ((file-directory-p file) $ 	       (setq command-line-args-left$ 		     (nconc (directory-files file)& 			    (cdr command-line-args-left))))	 	      (to% 	       (setq files (cons file files)e> 		     command-line-args-left (cdr command-line-args-left)))))       (while files 	(setq file (car files)a 	      files (cdr files))r 	(condition-case err 	    (progn ; 	      (if buffer-file-name (kill-buffer (current-buffer)))  	      (find-file file))+ 	      (buffer-flush-undo (current-buffer)))" 	      (set-buffer-modified-p nil) 	      (texinfo-mode)f0 	      (message "texinfo formatting %s..." file)" 	      (texinfo-format-buffer nil) 	      (if (buffer-modified-p)< 		  (progn (message "Saving modified %s" (buffer-file-name)) 			 (save-buffer))))	 	  (error 2 	   (message ">> Error: %s" (prin1-to-string err)) 	   (message ">>  point at")& 	   (let ((s (buffer-substring (point) 				      (min (+ (point) 100) 					   (point-max)))) 		 (tem 0))t2 	     (while (setq tem (string-match "\n+" s tem)); 	       (setq s (concat (substring s 0 (match-beginning 0))o 			       "\n>>  "& 			       (substring s (match-end 0))) 		     tem (1+ tem)))n 	     (message ">>  %s" s))- 	   (setq error 1))))n       (kill-emacs error))))f   e# ;;; Place `provide' at end of file.o (provide 'texinfmt)o1 ;;;;;;;;;;;;;;;; end texinfmt.el ;;;;;;;;;;;;;;;;-