 ;;;; texnfo-upd.el  I ;;; Texinfo mode utilities for updating nodes and menus in Texinfo files.   $ ;;; Version 2.15    2 September 1992 ;;; Robert J. Chassell      3 ;;; Please send bug reports to:  bob@gnu.ai.mit.edu   = ;;; Copyright 1989, 1990, 1991, 1992 Free Software Foundation   6 ;;; Known bug: update commands fail to ignore @ignore.    # ;;; This file is part of GNU Emacs.   D ;; GNU Emacs is free software; you can redistribute it and/or modifyG ;; it under the terms of the GNU General Public License as published by F ;; the Free Software Foundation; either version 1, or (at your option) ;; any later version.   ? ;; GNU Emacs is distributed in the hope that it will be useful, A ;; but WITHOUT ANY WARRANTY; without even the implied warranty of @ ;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/ ;; GNU General Public License for more details.   D ;; You should have received a copy of the GNU General Public License@ ;; along with GNU Emacs; see the file COPYING.  If not, write toH ;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.    - ;;; Summary: how to use the updating commands   4 ; The node and menu updating functions automatically  # ;   * insert missing `@node' lines, @ ;   * insert the `Next', `Previous' and `Up' pointers of a node,/ ;   * insert or update the menu for a section,  5 ;   * create a master menu for a Texinfo source file.  ; 3 ; Passed an argument, the `texinfo-update-node' and < ; `texinfo-make-menu' functions do their jobs in the region. ; H ; In brief, the functions for creating or updating nodes and menus, are: ; : ;     texinfo-update-node (&optional region-p)            : ;     texinfo-every-node-update ()                        9 ;     texinfo-sequential-node-update (&optional region-p)  ; : ;     texinfo-make-menu (&optional region-p)              : ;     texinfo-all-menus-update ()                          ;     texinfo-master-menu () ; 4 ;     texinfo-insert-node-lines  (&optional title-p) ; A ;     texinfo-indent-menu-description (column &optional region-p)   G ; The `texinfo-column-for-description' variable specifies the column to ( ; which menu descriptions are indented.    ; Texinfo file structure ; ----------------------  D ; To use the updating commands, you must structure your Texinfo fileC ; hierarchically.  Each `@node' line, with the exception of the top D ; node, must be accompanied by some kind of section line, such as an= ; `@chapter' or `@section' line.  Each node-line/section-line " ; combination must look like this:  D ;      @node    Lists and Tables, Cross References, Structuring, TopC ;      @comment node-name,        next,             previous,    up ' ;      @chapter Making Lists and Tables   - ; or like this (without the `@comment' line):   D ;      @node    Lists and Tables, Cross References, Structuring, Top' ;      @chapter Making Lists and Tables   D ; If the file has a `top' node, it must be called `top' or `Top' and  ; be the first node in the file.    1 ;;; The update node functions described in detail   @ ; The `texinfo-update-node' function without an argument insertsB ; the correct next, previous and up pointers for the node in which8 ; point is located (i.e., for the node preceding point).  B ; With an argument, the `texinfo-update-node' function inserts theA ; correct next, previous and up pointers for the nodes inside the 	 ; region.   ? ; It does not matter whether the  `@node' line has pre-existing @ ; `Next', `Previous', or `Up' pointers in it.  They are removed.  E ; The `texinfo-every-node-update' function runs `texinfo-update-node'  ; on the whole buffer.  ; ; The `texinfo-sequential-node-update' function inserts the = ; immediately following and preceding node into the `Next' or F ; `Previous' pointers regardless of their hierarchical level.  This isC ; only useful for certain kinds of text, like a novel, which you go  ; through sequentially.     1 ;;; The menu making functions described in detail   A ; The `texinfo-make-menu' function without an argument creates or C ; updates a menu for the section encompassing the node that follows C ; point.  With an argument, it makes or updates menus for the nodes & ; within or part of the marked region.  = ; Whenever an existing menu is updated, the descriptions from H ; that menu are incorporated into the new menu.  This is done by copyingD ; descriptions from the existing menu to the entries in the new menuF ; that have the same node names.  If the node names are different, the. ; descriptions are not copied to the new menu.  D ; Menu entries that refer to other Info files are removed since they> ; are not a node within current buffer.  This is a deficiency.  B ; The `texinfo-all-menus-update' function runs `texinfo-make-menu' ; on the whole buffer.  E ; The `texinfo-master-menu' function creates an extended menu located E ; after the top node.  (The file must have a top node.)  The function F ; first updates all the regular menus in the buffer (incorporating theE ; descriptions from pre-existing menus), and then constructs a master F ; menu that includes every entry from every other menu.  (However, the@ ; function cannot update an already existing master menu; if one: ; exists, it must be removed before calling the function.)  > ; The `texinfo-indent-menu-description' function indents everyC ; description in the menu following point, to the specified column. > ; Non-nil argument (prefix, if interactive) means indent everyB ; description in every menu in the region.  This function does notA ; indent second and subsequent lines of a multi-line description.   E ; The `texinfo-insert-node-lines' function inserts `@node' before the F ; `@chapter', `@section', and such like lines of a region in a Texinfo+ ; file where the `@node' lines are missing.  ; D ; With a non-nil argument (prefix, if interactive), the function notD ; only inserts `@node' lines but also inserts the chapter or sectionD ; titles as the names of the corresponding nodes; and inserts titles> ; as node names in pre-existing `@node' lines that lack names. ; A ; Since node names should be more concise than section or chapter A ; titles, node names so inserted will need to be edited manually.      ;;; The menu making functions   - (defun texinfo-make-menu (&optional region-p) 6   "Without any prefix argument, make or update a menu.G Make the menu for the section enclosing the node found following point.   D Non-nil argument (prefix, if interactive) means make or update menus. for nodes within or part of the marked region.  C Whenever a menu exists, and is being updated, the descriptions that ; are associated with node names in the pre-existing menu are E incorporated into the new menu.  Otherwise, the nodes' section titles  are inserted as descriptions."      (interactive "P")    (if (not region-p)/       (let ((level (texinfo-hierarchic-level))) %         (texinfo-make-one-menu level) G         (message "Done...updated the menu.  You may save the buffer."))      ;; else @     (message "Making or updating menus in %s... " (buffer-name))(     (let ((beginning (region-beginning)) 	  (region-end (region-end))C           (level (progn         ; find section type following point 1                    (goto-char (region-beginning)) 0                    (texinfo-hierarchic-level))))"       (if (= region-end beginning)*           (error "Please mark a region!"))       (save-excursion          (save-restriction            (widen) 
           B           (while  (texinfo-find-lower-level-node level region-end)F             (setq level (texinfo-hierarchic-level)) ; new, lower level*             (texinfo-make-one-menu level))
           ,           (while (and (< (point) region-end)H                       (texinfo-find-higher-level-node level region-end))3             (setq level (texinfo-hierarchic-level)) C             (while (texinfo-find-lower-level-node level region-end) H               (setq level (texinfo-hierarchic-level)) ; new, lower level0               (texinfo-make-one-menu level))))))A     (message "Done...updated menus.  You may save the buffer.")))   $ (defun texinfo-make-one-menu (level)<   "Make a menu of all the appropriate nodes in this section.@ `Appropriate nodes' are those associated with sections that are D at the level specified by LEVEL.  Point is left at the end of menu."   (let*.       ((case-fold-search t)9        (beginning  	(save-excursion; 	  (goto-char (texinfo-update-menu-region-beginning level))  	  (end-of-line) 	  (point)))3        (end (texinfo-update-menu-region-end level))r6        (first (texinfo-menu-first-node beginning end))        (node-name (progn)                     (goto-char beginning)F'                     (beginning-of-line)o.                     (texinfo-copy-node-name)))D        (new-menu-list (texinfo-make-menu-list beginning end level))),     (if (texinfo-old-menu-p beginning first)         (progn:           (texinfo-incorporate-descriptions new-menu-list)>           (texinfo-incorporate-menu-entry-names new-menu-list)5           (texinfo-delete-old-menu beginning first)))a3     (texinfo-insert-menu new-menu-list node-name)))r  > (defun texinfo-all-menus-update (&optional update-all-nodes-p)/   "Update every regular menu in a Texinfo file. 1 Update pre-existing master menu, if there is one.f  F If called with a non-nil argument, this function first updates all the/ nodes in the buffer before updating the menus."n   (interactive "P")    (let ((case-fold-search t)         master-menu-p)     (save-excursions       (push-mark (point-max) t)u       (goto-char (point-min)) D       (message "Checking for a master menu in %s ... "(buffer-name))       (save-excursioni@         (if (re-search-forward texinfo-master-menu-header nil t)2             ;; Remove detailed master menu listing             (progn$               (setq master-menu-p t)-               (goto-char (match-beginning 0)) 6               (let ((end-of-detailed-menu-descriptionsE                      (save-excursion     ; beginning of end menu line 5                        (goto-char (texinfo-menu-end))-<                        (beginning-of-line) (forward-char -1)!                        (point))))aM                 (delete-region (point) end-of-detailed-menu-descriptions)))))o              (if update-all-nodes-p           (prognC             (message "Updating all nodes in %s ... " (buffer-name))t             (sleep-for 2)c%             (push-mark (point-max) t)y#             (goto-char (point-min))i%             (texinfo-update-node t)))n       E       (message "Updating all menus in %s ... " (buffer-name))                (sleep-for 2)n       (push-mark (point-max) t)i       (goto-char (point-min))t       (texinfo-make-menu t)s              (if master-menu-pn           (prognH             (message "Updating the master menu in %s... " (buffer-name))             (sleep-for 2)h(             (texinfo-master-menu nil))))     I     (message "Done...updated all the menus.  You may save the buffer.")))L  7 (defun texinfo-find-lower-level-node (level region-end) D   "Search forward from point for node at any level lower than LEVEL.? Search is limited to the end of the marked region, REGION-END, n0 and to the end of the menu region for the level.  F Return t if the node is found, else nil.  Leave point at the beginning5 of the node if one is found; else do not move point."    (let ((case-fold-search t))n#     (if (and (< (point) region-end)               (re-search-forwardo               (concats;                "\\(^@node\\).*\n"         ; match node lineoF                "\\(\\(\\(^@c\\).*\n\\)"   ; match comment line, if any.                "\\|"                      ; or?                "\\(^@ifinfo[ ]*\n\\)\\)?" ; ifinfo line, if anyfL                (eval (cdr (assoc level texinfo-update-menu-lower-regexps))))A               ;; the next higher level node marks the end of this'F               ;; section, and no lower level node will be found beyond@               ;; this position even if region-end is farther off5               (texinfo-update-menu-region-end level) e               t)) *         (goto-char (match-beginning 1)))))  8 (defun texinfo-find-higher-level-node (level region-end)N   "Search forward from point for node at any higher level than argument LEVEL.> Search is limited to the end of the marked region, REGION-END.  F Return t if the node is found, else nil.  Leave point at the beginning5 of the node if one is found; else do not move point."    (let ((case-fold-search t)) 	     (condgD      ((or (string-equal "top" level) (string-equal "chapter" level))N       (if (re-search-forward "^@node [ \t]*top[ \t]*\\(,\\|$\\)" region-end t))           (progn (beginning-of-line) t)))r      (te       (if (re-search-forward            (concat=             "\\(^@node\\).*\n"              ; match node linenH             "\\(\\(\\(^@c\\).*\n\\)"        ; match comment line, if any0             "\\|"                           ; orA             "\\(^@ifinfo[ ]*\n\\)\\)?"      ; ifinfo line, if anypJ             (eval (cdr (assoc level texinfo-update-menu-higher-regexps))))            region-end t),           (progn (beginning-of-line) t))))))   c' ;;; Making the list of new menu entriese  3 (defun texinfo-make-menu-list (beginning end level)c4   "Make a list of node names and their descriptions.J Point is left at the end of the menu region, but the menu is not inserted.  A First argument is position from which to start making menu list; eC second argument is end of region in which to try to locate entries;(> third argument is the level of the nodes that are the entries.  F Node names and descriptions are dotted pairs of strings.  Each pair is? an element of the list.  If the description does not exist, the-( element consists only of the node name."   (goto-char beginning)e   (let (new-menu-list)2     (while (texinfo-menu-locate-entry-p level end)       (setq new-menu-list              (cons (cons +                    (texinfo-copy-node-name) /                    (prog1 "" (forward-line 1)))hK                    ;; Use following to insert section titles automatically.t3                    ;; (texinfo-copy-section-title))e"                   new-menu-list)))     (reverse new-menu-list)))h  5 (defun texinfo-menu-locate-entry-p (level search-end)w:   "Find a node that will be part of menu for this section.E First argument is a string such as \"section\" specifying the generalt= hierarchical level of the menu; second argument is a position ! specifying the end of the search.d  C The function returns t if the node is found, else nil.  It searchesaB forward from point, and leaves point at the beginning of the node.  D The function finds entries of the same type.  Thus `subsections' and2 `unnumberedsubsecs' will appear in the same menu."   (let ((case-fold-search t))      (if (re-search-forward          (concat;           "\\(^@node\\).*\n"              ; match node line F           "\\(\\(\\(^@c\\).*\n\\)"        ; match comment line, if any.           "\\|"                           ; or?           "\\(^@ifinfo[ ]*\n\\)\\)?"      ; ifinfo line, if any            (eval G            (cdr (assoc level texinfo-update-menu-same-level-regexps))))b          search-endn          t)e*         (goto-char (match-beginning 1)))))    (defun texinfo-copy-node-name ()$   "Return the node name as a string.  A Start with point at the beginning of the node line; copy the textvE after the node command up to the first comma on the line, if any, andrB return the text as a string.  Leaves point at the beginning of the: line.  If there is no node name, returns an empty string."      (save-excursionv     (buffer-substring B      (progn (forward-word 1)              ; skip over node command;             (skip-chars-forward " \t")    ; and over spaces              (point))      (if (search-forward
           ","nB           (save-excursion (end-of-line) (point)) t) ; bound search          (1- (point))e         (end-of-line) (point)))))  $ (defun texinfo-copy-section-title ()/   "Return the title of the section as a string.-E The title is used as a description line in the menu when one does not) already exist.  D Move point to the beginning of the appropriate section line by goingC to the start of the text matched by last regexp searched for, which 6 must have been done by `texinfo-menu-locate-entry-p'."  E   ;; could use the same re-search as in `texinfo-menu-locate-entry-p'fB   ;; instead of using `match-beginning'; such a variation would be@   ;; more general, but would waste information already collected  =   (goto-char (match-beginning 7))       ; match section name       (buffer-substring-@    (progn (forward-word 1)              ; skip over section type9           (skip-chars-forward " \t")    ; and over spaces            (point))"    (progn (end-of-line) (point))))   i ;;; Handling the old menut  + (defun texinfo-old-menu-p (beginning first) D   "Move point to the beginning of the menu for this section, if any.B Otherwise move point to the end of the first node of this section.+ Return t if a menu is found, nil otherwise.x  G First argument is the position of the beginning of the section in which-F the menu will be located; second argument is the position of the first node within the section.  F If no menu is found, the function inserts two newlines just before theE end of the section, and leaves point there where a menu ought to be."s   (goto-char beginning)a8   (if (not (re-search-forward "^@menu" first 'goto-end))3       (progn (insert "\n\n") (forward-line -2) nil)t     t))"  7 (defun texinfo-incorporate-descriptions (new-menu-list) B   "Copy the old menu line descriptions that exist to the new menu.  ' Point must be at beginning of old menu.g  E If the node-name of the new menu is found in the old menu, insert the # old description into the new entry.s  D For this function, the new menu is a list made up of lists of dottedE pairs in which the first element of the pair is the node name and the G second element the description.  The new menu is changed destructively.d< The old menu is the menu as it appears in the texinfo file."   -   (let ((new-menu-list-pointer new-menu-list) )         (end-of-menu (texinfo-menu-end)))      (while new-menu-listJ       (save-excursion                   ; keep point at beginning of menu          (if (re-search-forward0              ;; Existing nodes can have the form-              ;;     * NODE NAME:: DESCRIPTION               ;; or<              ;;     * MENU ITEM: NODE NAME.     DESCRIPTION.              ;; @              ;; Recognize both when looking for the description.L              (concat "\\* \\("              ; so only menu entries are found3                      (car (car new-menu-list)) "::"e                      "\\|"@                      ".*: " (car (car new-menu-list)) "[.,\t\n]"                      "\\)"I                      )               ; so only complete entries are founds              end-of-menu              t) (             (setcdr (car new-menu-list) F                     (texinfo-menu-copy-old-description end-of-menu))))0       (setq new-menu-list (cdr new-menu-list))) 0     (setq new-menu-list new-menu-list-pointer)))  ; (defun texinfo-incorporate-menu-entry-names (new-menu-list)r1   "Copy any old menu entry names to the new menu.O  ' Point must be at beginning of old menu.   A If the node-name of the new menu entry cannot be found in the oldn menu, do nothing.   D For this function, the new menu is a list made up of lists of dottedE pairs in which the first element of the pair is the node name and thes+ second element is the description (or nil).   F If we find an existing menu entry name, we change the first element ofE the pair to be another dotted pair in which the car is the menu entry\" name and the cdr is the node name.  G NEW-MENU-LIST is changed destructively.  The old menu is the menu as it( appears in the texinfo file."u   -   (let ((new-menu-list-pointer new-menu-list)n)         (end-of-menu (texinfo-menu-end)))'     (while new-menu-listJ       (save-excursion                   ; keep point at beginning of menu          (if (re-search-forward0              ;; Existing nodes can have the form-              ;;     * NODE NAME:: DESCRIPTIONh              ;; or<              ;;     * MENU ITEM: NODE NAME.     DESCRIPTION.              ;; 4              ;; We're interested in the second case.I              (concat "\\* "              ; so only menu entries are found.H                      "\\(.*\\): " (car (car new-menu-list))  "[.,\t\n]")              end-of-menu              t)m             (setcar(:               (car new-menu-list)  ; replace the node nameH               (cons (buffer-substring (match-beginning 1) (match-end 1))0                     (car (car new-menu-list)))))0       (setq new-menu-list (cdr new-menu-list))))0     (setq new-menu-list new-menu-list-pointer)))  6 (defun texinfo-menu-copy-old-description (end-of-menu)7   "Return description field of old menu line as string. O Point must be located just after the node name.  Point left before description. ; Single argument, END-OF-MENU, is position limiting search."p$   (skip-chars-forward "[:.,\t\n ]+")B   ;; don't copy a carriage return at line beginning with asterisk!3   ;; do copy a description that begins with an `@'! G   ;; !! Known bug: does not copy descriptions starting with ^|\{?* etc.g,   (if (and (looking-at "\\(\\w+\\|@\\)")    ;            (not (looking-at "\\(^\\* \\|^@end menu\\)")))  e       (buffer-substrings        (point)        (save-excursionE          (re-search-forward "\\(^\\* \\|^@end menu\\)" end-of-menu t)           (forward-line -1)L          (end-of-line)                  ; go to end of last description line          (point)))     ""))   (defun texinfo-menu-end ()E   "Return position of end of menu. Does not change location of point.i$ Signal an error if not end of menu."   (save-excursiont.     (if (re-search-forward "^@end menu" nil t)         (point)e-       (error "Menu does not have an end."))))e  0 (defun texinfo-delete-old-menu (beginning first)8   "Delete the old menu.  Point must be in or after menu.C First argument is position of the beginning of the section in whicheF the menu will be located; second argument is the position of the first node within the section." 6   ;; No third arg to search, so error if search fails.)   (re-search-backward "^@menu" beginning)r   (delete-region (point)                   (save-excursion9                    (re-search-forward "^@end menu" first)e                    (point))))c   v ;;; Inserting new menu  # ;; try 32, but perhaps 24 is bettere) (defvar texinfo-column-for-description 32t;   "*Column at which descriptions start in a Texinfo menu.")p  0 (defun texinfo-insert-menu (menu-list node-name)"   "Insert formatted menu at point.B Indents the first line of the description, if any, to the value of texinfo-column-for-description.s   MENU-LIST has form:   +     \(\(\"node-name1\" . \"description\"\)  /     \(\"node-name2\" . \"description\"\) ... \)l  , However, the description field might be nil.  F Also, the node-name field might itself be a dotted pair (call it P) of= strings instead of just a string.  In that case, the car of P ; is the menu entry name, and the cdr of P is the node name."u      (insert "@menu\n")   (while menu-list7     ;; Every menu entry starts with a star and a space.n     (insert "* ")n     >     ;; Insert the node name (and menu entry name, if present).,     (let ((node-part (car (car menu-list))))       (if (stringp node-part)oN           ;; "Double colon" entry line; menu entry and node name are the same,.           (insert (format "%s::" node-part))  M         ;; "Single colon" entry line; menu entry and node name are different.oE         (insert (format "%s: %s." (car node-part) (cdr node-part)))))      *     ;; Insert the description, if present.     (if (cdr (car menu-list))e         (progn!           ;; Move to right place. 7           (indent-to texinfo-column-for-description 2) p            ;; Insert description.:           (insert (format "%s" (cdr (car menu-list))))))    '     (insert "\n") ; end this menu entry %     (setq menu-list (cdr menu-list)))    (insert "@end menu")   (message nH    "Updated \"%s\" level menu following node: %s ... " level node-name))   t2 ;;; Starting menu descriptions by inserting titles  ( (defun texinfo-start-menu-description ()I   "In this menu entry, insert the node's section title as a description. c= Position point at beginning of description ready for editing.fC Do not insert a title if the line contains an existing description.   B You will need to edit the inserted text since a useful descriptionB complements the node name rather than repeats it as a title does."      (interactive)(&   (let (beginning end node-name title)     (save-excursion      (beginning-of-line)  rH       (if (search-forward "* " (save-excursion (end-of-line) (point)) t)+           (progn (skip-chars-forward " \t")t*                  (setq beginning (point)))0         (error "This is not a line in a menu!"))              (condnL         ;; "Double colon" entry line; menu entry and node name are the same,F        ((search-forward "::" (save-excursion (end-of-line) (point)) t)*         (if (looking-at "[ \t]*[^ \t\n]+")7             (error "Descriptive text already exists.")) $         (skip-chars-backward ": \t")>         (setq node-name (buffer-substring beginning (point))))        eL        ;; "Single colon" entry line; menu entry and node name are different.E        ((search-forward ":" (save-excursion (end-of-line) (point)) t)o"         (skip-chars-forward " \t")          (setq beginning (point))<         ;; Menu entry line ends in a period, comma, or tab. '         (if (re-search-forward "[.,\t]"aK                                (save-excursion (forward-line 1) (point)) t)e             (progn0               (if (looking-at "[ \t]*[^ \t\n]+")=                   (error "Descriptive text already exists."))m+               (skip-chars-backward "., \t")rD               (setq node-name (buffer-substring beginning (point)))).           ;; Menu entry line ends in a return.#           (re-search-forward ".*\n"iG                            (save-excursion (forward-line 1) (point)) t)t'           (skip-chars-backward " \t\n")-?           (setq node-name (buffer-substring beginning (point)))-&           (if (= 0 (length node-name))2               (error "No node name on this line.")             (insert "."))))n0        (t (error "No node name on this line.")))L       ;; Search for node that matches node name, and copy the section title.       (if (re-search-forward            (concat               "^@node[ \t]+"             node-namet@             ".*\n"                             ; match node line             "\\(" K             "\\(\\(^@c \\|^@comment\\).*\n\\)" ; match comment line, if any"3             "\\|"                              ; or)D             "\\(^@ifinfo[ ]*\n\\)"             ; ifinfo line, if any             "\\)?")m            nil t)o           (progn             (setq title #                   (buffer-substringn,                    ;; skip over section type+                    (progn (forward-word 1) t,                           ;; and over spaces5                           (skip-chars-forward " \t") x"                           (point))'                    (progn (end-of-line)y5                           (skip-chars-backward " \t")o%                           (point))))) F         (error "Cannot find node to match node name in menu entry.")))5     ;; Return point to the menu and insert the title.      (end-of-line)i     (delete-region      (point):      (save-excursion (skip-chars-backward " \t") (point)))0     (indent-to texinfo-column-for-description 2)%     (save-excursion (insert title))))    t$ ;;; Handling description indentation  D ; Since the make-menu functions indent descriptions, these functions= ; are useful primarily for indenting a single menu specially.   B (defun texinfo-indent-menu-description (column &optional region-p)@   "Indent every description in menu following point to COLUMN.  < Non-nil argument (prefix, if interactive) means indent everyD description in every menu in the region.  Does not indent second and. subsequent lines of a multi-line description."      (interactive7    "nIndent menu descriptions to (column number): \nP");   (save-excursionN     (save-restrictionO
       (widen)        (if (not region-p)           (progn(             (re-search-forward "^@menu")4             (texinfo-menu-indent-description column)             (messageI              "Indented descriptions in menu.  You may save the buffer."))          ;;elseB         (message "Indenting every menu description in region... ")&         (goto-char (region-beginning)),         (while (and (< (point) (region-end)),                     (texinfo-locate-menu-p))           (forward-line 1)3           (texinfo-menu-indent-description column))eA         (message "Indenting done.  You may save the buffer.")))))(  9 (defun texinfo-menu-indent-description (to-column-number) @   "Indent the Texinfo file menu description to TO-COLUMN-NUMBER.C Start with point just after the word `menu' in the `@menu' line andiE leave point on the line before the `@end menu' line.  Does not indent 9 second and subsequent lines of a multi-line description." *   (let* ((beginning-of-next-line (point)))$     (while (< beginning-of-next-line>               (save-excursion     ; beginning of end menu line.                 (goto-char (texinfo-menu-end))#                 (beginning-of-line)                  (point)))   F       (if (re-search-forward  "\\* \\(.*::\\|.*: [^.,\t\n]+[.,\t]\\)"             (texinfo-menu-end) 
            t)r           (progn2             (let ((beginning-white-space (point)))<               (skip-chars-forward " \t")  ; skip over spacesB               (if (looking-at "\\(@\\|\\w\\)+") ; if there is text                   (progn6                     ;; remove pre-existing indentationA                     (delete-region beginning-white-space (point)) <                     (indent-to-column to-column-number))))))1       ;; position point at beginning of next line (       (forward-line 1)                  .       (setq beginning-of-next-line (point)))))   i ;;; Making the master menu  5 (defun texinfo-master-menu (update-all-nodes-menus-p) /   "Make a master menu for a whole Texinfo file.s@ Non-nil argument (prefix, if interactive) means first update allL existing nodes and menus.  Remove pre-existing master menu, if there is one.  C This function creates a master menu that follows the top node.  The > master menu includes every entry from all the other menus.  It> replaces any existing ordinary menu that follows the top node.  F If called with a non-nil argument, this function first updates all theA menus in the buffer (incorporating descriptions from pre-existing , menus) before it constructs the master menu.  D The function removes the detailed part of an already existing masterD menu.  This action depends on the pre-exisitng master menu using the& standard `texinfo-master-menu-header'.  C The master menu has the following format, which is adapted from them% recommendation in the Texinfo Manual:c  E    * The first part contains the major nodes in the Texinfo file: the A      nodes for the chapters, chapter-like sections, and the major C      appendices.  This includes the indices, so long as they are int8      chapter-like sections, such as unnumbered sections.  D    * The second and subsequent parts contain a listing of the other,?      lower level menus, in order.  This way, an inquirer can got@      directly to a particular node if he or she is searching for      specific information.  C Each of the menus in the detailed node listing is introduced by thei* title of the section containing the menu."      (interactive "P")    (let ((case-fold-search t))n     (widen)      (goto-char (point-min))c     *     ;; Move point to location after `top'.K     (if (not (re-search-forward "^@node [ \t]*top[ \t]*\\(,\\|$\\)" nil t))t0         (error "This buffer needs a Top node!"))     *     (let ((first-chapter                              (save-excursion3              (or (re-search-forward "^@node" nil t)t<                  (error "Too few nodes for a master menu!"))              (point))))"H       (if (re-search-forward texinfo-master-menu-header first-chapter t)0           ;; Remove detailed master menu listing           (progn+             (goto-char (match-beginning 0)) 4             (let ((end-of-detailed-menu-descriptionsC                    (save-excursion     ; beginning of end menu line 3                      (goto-char (texinfo-menu-end)) :                      (beginning-of-line) (forward-char -1)                      (point))))nK               (delete-region (point) end-of-detailed-menu-descriptions)))))e           (if update-all-nodes-menus-p         (prognO           (message "Making a master menu in %s ...first updating all nodes... "n!                    (buffer-name))k           (sleep-for 2) #           (push-mark (point-max) t)n!           (goto-char (point-min)) !           (texinfo-update-node t)c
           I           (message "Updating all menus in %s ... " (buffer-name))                    (sleep-for 2)(#           (push-mark (point-max) t) !           (goto-char (point-min))[!           (texinfo-make-menu t)))c     B     (message "Now making the master menu in %s... " (buffer-name))     (sleep-for 2)m     (goto-char (point-min)) $     (texinfo-insert-master-menu-list       (texinfo-master-menu-list))     A     ;; Remove extra newlines that texinfo-insert-master-menu-liste     ;; may have inserted.           (save-excursion        (goto-char (point-min))p       >       (if (re-search-forward texinfo-master-menu-header nil t)           (progn+             (goto-char (match-beginning 0))              (insert "\n")w              (delete-blank-lines)%             (goto-char (point-min))))a  "       (re-search-forward "^@menu")       (forward-line -1)t       (delete-blank-lines)       &       (re-search-forward "^@end menu")       (forward-line 1)       (delete-blank-lines))i          (messageH      "Done...completed making master menu.  You may save the buffer.")))  " (defun texinfo-master-menu-list ()F   "Return a list of menu entries and header lines for the master menu.  ? Start with the menu for chapters and indices and then find each)= following menu and the title of the node preceding that menu.r  # The master menu list has this form:   8     \(\(\(... \"entry-1-2\"  \"entry-1\"\) \"title-1\"\):       \(\(... \"entry-2-2\"  \"entry-2-1\"\) \"title-2\"\)       ...\)   2 However, there does not need to be a title field."     (let (master-menu-list)n"     (while (texinfo-locate-menu-p)       (setq master-menu-list               (cons (listd&                    (texinfo-copy-menu)-                    (texinfo-copy-menu-title))e%                   master-menu-list)))       (reverse master-menu-list)))  9 (defun texinfo-insert-master-menu-list (master-menu-list)f<   "Format and insert the master menu in the current buffer."   (goto-char (point-min)) D   ;; Insert a master menu only after `Top' node and before next node2   ;; \(or include file if there is no next node\).I   (if (not (re-search-forward "^@node [ \t]*top[ \t]*\\(,\\|$\\)" nil t)) .       (error "This buffer needs a Top node!"))   (let ((first-chapterL          (save-excursion (re-search-forward "^@node\\|^@include") (point)))):     (if (not (re-search-forward "^@menu" first-chapter t))         (errorI          "Buffer lacks ordinary `Top' menu in which to insert master.")))    (beginning-of-line)t:   (delete-region      ; buffer must have ordinary top menu
    (point)   e=    (save-excursion (re-search-forward "^@end menu") (point)))o   J   (save-excursion                       ; leave point at beginning of menu     ;; Handle top of menui     (insert "\n@menu\n")"     ;; Insert chapter menu entriesE     (setq this-very-menu-list (reverse (car (car master-menu-list))))u"     ;; Tell user what is going on.I     (message "Inserting chapter menu entry: %s ... " this-very-menu-list)      (while this-very-menu-list2       (insert "* " (car this-very-menu-list) "\n");       (setq this-very-menu-list (cdr this-very-menu-list)))s     2     (setq master-menu-list (cdr master-menu-list))     ;     ;; Only insert detailed master menu if there is one....($     (if (car (car master-menu-list)),         (insert texinfo-master-menu-header))     &     ;; Now, insert all the other menus     6     ;; The menu master-menu-list has a form like this:%     ;; ((("beta"  "alpha") "title-A") &     ;;  (("delta" "gamma") "title-B"))          (while master-menu-liste              (messageH        "Inserting menu for %s .... " (car (cdr (car master-menu-list))))%       ;; insert title of menu section =       (insert "\n" (car (cdr (car master-menu-list))) "\n\n")               ;; insert each menu entryrG       (setq this-very-menu-list (reverse (car (car master-menu-list))))         (while this-very-menu-list4         (insert "* " (car this-very-menu-list) "\n")=         (setq this-very-menu-list (cdr this-very-menu-list)))m       5       (setq master-menu-list (cdr master-menu-list)))e          ;; Finish menu     (insert "@end menu\n\n")))  " (defvar texinfo-master-menu-header*   "\n --- The Detailed Node Listing ---\n"E   "String inserted before lower level entries in Texinfo master menu.o0 It comes after the chapter-level menu entries.")   (defun texinfo-locate-menu-p ()i*   "Find the next menu in the texinfo file.J If found, leave point after word `menu' on the `@menu' line, and return t.: If a menu is not found, do not move point and return nil."+   (re-search-forward "\\(^@menu\\)" nil t))e  " (defun texinfo-copy-menu-title  ()B   "Return the title of the section preceding the menu as a string.E If such a title cannot be found, return an empty string.  Do not move  point."o   (let ((case-fold-search t))t     (save-excursion        (if (re-search-backward             (concat             "\\(^@top".             "\\|"                         ; orC             texinfo-section-types-regexp  ; all other section typesb             "\\)")            nil
            t)e           (progn             (beginning-of-line) B             (forward-word 1)              ; skip over section type;             (skip-chars-forward " \t")    ; and over spacesm             (buffer-substring               (point),              (progn (end-of-line) (point))))         ""))))   (defun texinfo-copy-menu ()n4   "Return the entries of an existing menu as a list.? Start with point just after the word `menu' in the `@menu' line.9 and leave point on the line before the `@end menu' line."    (let* (this-menu-listeJ          (end-of-menu (texinfo-menu-end)) ; position of end of `@end menu'D          (last-entry (save-excursion      ; position of beginning of;                                           ; last `* ' entryt-                       (goto-char end-of-menu)m6                       ;; handle multi-line descriptionA                       (if (not (re-search-backward "^\* " nil t)) 8                           (error "No entries in menu."))                        (point))))!     (while (< (point) last-entry)i3       (if (re-search-forward  "^\* " end-of-menu t)s           (progn              (setq this-menu-list                   (const%                    (buffer-substring a                     (point) 3                     ;; copy multi-line descriptionse#                     (save-excursion B                       (re-search-forward "\\(^\* \\|^@e\\)" nil t)%                       (- (point) 3)))T&                    this-menu-list)))))     this-menu-list))    : ;;; Determining the hierarchical level in the texinfo file  ( (defun texinfo-specific-section-type () 9   "Return the specific type of next section, as a string. @ For example, \"unnumberedsubsec\".  Return \"top\" for top node.  @ Searches forward for a section.  Hence, point must be before theB section whose type will be found.  Does not move point.  Signal anB error if the node is not the top node and a section is not found."   (let ((case-fold-search t))t     (save-excursion        (cond >        ((re-search-forward "^@node [ \t]*top[ \t]*\\(,\\|$\\)"2 ;;; Following search limit by cph but causes a bug ;;;			 (save-excursion ;;;			   (end-of-line) ;;;			   (point))-                            nil                            t)          "top")>        ((re-search-forward texinfo-section-types-regexp nil t)D         (buffer-substring (progn (beginning-of-line) ; copy its name.                                  (1+ (point)))1                           (progn (forward-word 1) +                                  (point)))) 	        (t          (errorM          "texinfo-specific-section-type: Chapter or section not found."))))))-  " (defun texinfo-hierarchic-level ()J   "Return the general hierarchal level of the next node in a texinfo file.< Thus, a subheading or appendixsubsec is of type subsection."   (let ((case-fold-search t))      (cdr (assoc))           (texinfo-specific-section-type)s.           texinfo-section-to-generic-alist))))   i  ;;; Locating the major positions  5 (defun texinfo-update-menu-region-beginning (level)  sC   "Locate beginning of higher level section this section is within. E Return position of the beginning of the node line; do not move point. G Thus, if this level is subsection, searches backwards for section node. : Only argument is a string of the general type of section."   (let ((case-fold-search t))nB     ;; !! Known bug: if section immediately follows top node, thisB     ;; returns the beginning of the buffer as the beginning of the     ;; higher level section.	     (condv$      ((or (string-equal "top" level))           (string-equal "chapter" level))d       (save-excursiona         (goto-char (point-min)) E         (re-search-forward "^@node [ \t]*top[ \t]*\\(,\\|$\\)" nil t)          (beginning-of-line))         (point)))-      (tn       (save-excursion-         (re-search-backward           (concat;           "\\(^@node\\).*\n"              ; match node lineaF           "\\(\\(\\(^@c\\).*\n\\)"        ; match comment line, if any.           "\\|"                           ; or?           "\\(^@ifinfo[ ]*\n\\)\\)?"      ; ifinfo line, if anys           (eval C            (cdr (assoc level texinfo-update-menu-higher-regexps)))).          nil          'goto-beginning)i         (point))))))  / (defun texinfo-update-menu-region-end (level)  e=   "Locate end of higher level section this section is within. = Return position; do not move point.  Thus, if this level is a(D subsection, find the node for the section this subsection is within.D If level is top or chapter, returns end of file.  Only argument is a' string of the general type of section.")   (let ((case-fold-search t))      (save-excursionl       (if (re-search-forward            (concat;             "\\(^@node\\).*\n"            ; match node line F             "\\(\\(\\(^@c\\).*\n\\)"      ; match comment line, if any.             "\\|"                         ; or?             "\\(^@ifinfo[ ]*\n\\)\\)?"    ; ifinfo line, if anyt             (eval F              ;; Never finds end of level above chapter so goes to end.E              (cdr (assoc level texinfo-update-menu-higher-regexps))))c            nil            'goto-end)|           (match-beginning 1)h         (point-max)))))e  . (defun texinfo-menu-first-node (beginning end)A   "Locate first node of the section the menu will be placed in.  n# Return position; do not move point.c5 The menu will be located just before this position.  n  A First argument is the position of the beginning of the section intF which the menu will be located; second argument is the position of the* end of that region; it limits the search."      (save-excursiono     (goto-char beginning)      (forward-line 1)&     (re-search-forward "^@node" end t)     (beginning-of-line)i
     (point)))n    C ;;; Alists and regular expressions for defining hierarchical levelsr  ( (defvar texinfo-section-to-generic-alist   '(("top" . "top")g       ("chapter" . "chapter")h     ("unnumbered" . "chapter")      ("majorheading" . "chapter")     ("chapheading" . "chapter")"     ("appendix" . "chapter")          ("section" . "section") !     ("unnumberedsec" . "section")      ("heading" . "section")d     ("appendixsec" . "section");     !     ("subsection" . "subsection")e'     ("unnumberedsubsec" . "subsection")n!     ("subheading" . "subsection")a%     ("appendixsubsec" . "subsection")n     '     ("subsubsection" . "subsubsection") -     ("unnumberedsubsubsec" . "subsubsection")('     ("subsubheading" . "subsubsection")(,     ("appendixsubsubsec" . "subsubsection"))I   "*An alist of specific and corresponding generic Texinfo section types..E The keys are strings specifying specific types of section; the values 3 are strings of their corresponding general types.")n  $ (defvar texinfo-section-types-regexp^   "^@\\(chapter \\|sect\\|subs\\|subh\\|unnum\\|major\\|chapheading \\|heading \\|appendix\\)"M   "Regexp matching chapter, section, other headings (but not the top node)."))  % (defvar texinfo-chapter-level-regexp  B   "chapter\\|unnumbered \\|appendix \\|majorheading\\|chapheading"I   "Regular expression matching just the Texinfo chapter level headings.")n  % (defvar texinfo-section-level-regexp d4   "section\\|unnumberedsec\\|heading \\|appendixsec"I   "Regular expression matching just the Texinfo section level headings.")a  ( (defvar texinfo-subsection-level-regexp ?   "subsection\\|unnumberedsubsec\\|subheading\\|appendixsubsec"nL   "Regular expression matching just the Texinfo subsection level headings.")  * (defvar texinfo-subsubsection-level-regexpK   "subsubsection\\|unnumberedsubsubsec\\|subsubheading\\|appendixsubsubsec"tO   "Regular expression matching just the Texinfo subsubsection level headings.")   . (defvar texinfo-update-menu-same-level-regexps   '(("top" . "top[ \t]+")t     ("chapter" .  E      (concat "\\(^@\\)\\(" texinfo-chapter-level-regexp "\\)[ \t]*"))h     ("section" .  E      (concat "\\(^@\\)\\(" texinfo-section-level-regexp "\\)[ \t]*"))      ("subsection" .   H      (concat "\\(^@\\)\\(" texinfo-subsection-level-regexp "\\)[ \t]+"))     ("subsubsection" .  L      (concat "\\(^@\\)\\(" texinfo-subsubsection-level-regexp "\\)[ \t]+")))D   "*Regexps for searching for same level sections in a Texinfo file.E The keys are strings specifying the general hierarchical level in then/ document; the values are regular expressions.")d  * (defvar texinfo-update-menu-higher-regexps!   '(("top" . "^@node [ \t]*DIR") h5     ("chapter" . "^@node [ \t]*top[ \t]*\\(,\\|$\\)")i     ("section" .
      (concat t       "\\(^@\\(""       texinfo-chapter-level-regexp       "\\)[ \t]*\\)"))     ("subsection" .s
      (concat n       "\\(^@\\(""       texinfo-section-level-regexp       "\\|" "       texinfo-chapter-level-regexp       "\\)[ \t]*\\)"))     ("subsubsection" .
      (concat         "\\(^@\\("%       texinfo-subsection-level-regexph       "\\|"u"       texinfo-section-level-regexp       "\\|"s"       texinfo-chapter-level-regexp       "\\)[ \t]*\\)")))"F   "*Regexps for searching for higher level sections in a Texinfo file.E The keys are strings specifying the general hierarchical level in the / document; the values are regular expressions.")t  ) (defvar texinfo-update-menu-lower-regexpsm
   '(("top" .  
      (concat n       "\\(^@\\(""       texinfo-chapter-level-regexp       "\\|"i"       texinfo-section-level-regexp       "\\|"r%       texinfo-subsection-level-regexpu       "\\|" (       texinfo-subsubsection-level-regexp       "\\)[ \t]*\\)"))     ("chapter" . -
      (concat         "\\(^@\\(""       texinfo-section-level-regexp       "\\|" %       texinfo-subsection-level-regexpi       "\\|" (       texinfo-subsubsection-level-regexp       "\\)[ \t]*\\)"))     ("section" .
      (concat         "\\(^@\\("%       texinfo-subsection-level-regexpp       "\\|"d(       texinfo-subsubsection-level-regexp       "\\)[ \t]+\\)"))     ("subsection" .y
      (concat d       "\\(^@\\("(       texinfo-subsubsection-level-regexp       "\\)[ \t]+\\)"))(     ("subsubsection" . "nothing lower"))E   "*Regexps for searching for lower level sections in a Texinfo file.dE The keys are strings specifying the general hierarchical level in the / document; the values are regular expressions.")    - ;;; Updating a nodeo  / (defun texinfo-update-node (&optional region-p) J   "Without any prefix argument, update the node in which point is located.G Non-nil argument (prefix, if interactive) means update the nodes in then marked region.  A The functions for creating or updating nodes and menus, and their  keybindings, are:w  G     texinfo-update-node (&optional region-p)    \\[texinfo-update-node] M     texinfo-every-node-update ()                \\[texinfo-every-node-update]n7     texinfo-sequential-node-update (&optional region-p)r  E     texinfo-make-menu (&optional region-p)      \\[texinfo-make-menu] L     texinfo-all-menus-update ()                 \\[texinfo-all-menus-update]     texinfo-master-menu ()  ?     texinfo-indent-menu-description (column &optional region-p)o  E The `texinfo-column-for-description' variable specifies the column tot? which menu descriptions are indented. Its default value is 32."n      (interactive "P")    (if (not region-p)8       (let ((auto-fill-hook nil)) ; update a single node=         (if (not (re-search-backward "^@node" (point-min) t))a@             (error "Node line not found before this position."))!         (texinfo-update-the-node)-G         (message "Done...updated the node.  You may save the buffer."))      ;; else      (let ((auto-fill-hook nil)(           (beginning (region-beginning)) 	  (end (region-end)))       (if (= end beginning)q*           (error "Please mark a region!"))       (save-restrictions! 	(narrow-to-region beginning end)( 	(goto-char beginning)         (push-mark (point) t)t2 	(while (re-search-forward "^@node" (point-max) t))           (beginning-of-line)             $           (texinfo-update-the-node))Q         (message "Done...updated nodes in region.  You may save the buffer.")))))l  # (defun texinfo-every-node-update ()"(   "Update every node in a Texinfo file."   (interactive)    (save-excursion      (push-mark (point-max) t)*     (goto-char (point-min)),     (texinfo-update-node t) K     (message "Done...updated every node.       You may save the buffer.")))n  ! (defun texinfo-update-the-node () C   "Update one node.  Point must be at the beginning of node line.   ) Leave point at the end of the node line."c   (texinfo-check-for-node-name);$   (texinfo-delete-existing-pointers)=   (message "Updating node: %s ... " (texinfo-copy-node-name))t   (save-restrictionv     (widen)c	     (let*u         ((case-fold-search t) +          (level (texinfo-hierarchic-level)))A          (beginning (texinfo-update-menu-region-beginning level))r6          (end (texinfo-update-menu-region-end level)))$       (if (string-equal level "top")$           (texinfo-top-pointer-case)         ;; else :         (texinfo-insert-pointer beginning end level 'next)>         (texinfo-insert-pointer beginning end level 'previous)8         (texinfo-insert-pointer beginning end level 'up)(         (texinfo-clean-up-node-line)))))  " (defun texinfo-top-pointer-case ()<   "Insert pointers in the Top node.  This is a special case.  B The `Next' pointer is a pointer to a chapter or section at a lowerE hierarchical level in the file.  The `Previous' and `Up' pointers areoD to `(dir)'.  Point must be at the beginning of the node line, and is" left at the end of the node line."     (texinfo-clean-up-node-line)   (insert ", " e           (save-excursioneE             ;; There may be an @chapter or other such command betweenmC             ;; the top node line and the next node line, as a title"B             ;; for an `ifinfo' section. This @chapter command mustB             ;; must be skipped.  So the procedure is to search for=             ;; the next `@node' line, and then copy its name.f2             (if (re-search-forward "^@node" nil t)                 (progn%                   (beginning-of-line)"+                   (texinfo-copy-node-name)))               " "))            ", (dir), (dir)"))  % (defun texinfo-check-for-node-name ()tF   "Determine whether the node has a node name.  Prompt for one if not.? Point must be at beginning of node line.  Does not move point.""   (save-excursions6     (let ((initial (texinfo-copy-next-section-title)))B       (forward-word 1)                    ; skip over node command;       (skip-chars-forward " \t")          ; and over spacesoO       (if (not (looking-at "[^,\t\n ]+")) ; regexp based on what Info looks forsJ                                           ; alternatively, use "[a-zA-Z]+"         (let ((node-name$                (read-from-minibufferH                 "Node name (use no @, commas, colons, or apostrophes): "                 initial)))%           (insert " " node-name))))))e  * (defun texinfo-delete-existing-pointers ()2   "Delete `Next', `Previous', and `Up' pointers.  D Starts from the current position of the cursor, and searches forwardD on the line for a comma and if one is found, deletes the rest of the? line, including the comma.  Leaves point at beginning of line.""C   (if (search-forward "," (save-excursion (end-of-line) (point)) t)n       (progn          (goto-char (1- (point)))         (kill-line nil)))c   (beginning-of-line))  ; (defun texinfo-find-pointer (beginning end level direction)eG   "Move point to section associated with next, previous, or up pointer.\7 Return type of pointer (either 'normal or 'no-pointer).g  D The first and second arguments bound the search for a pointer to the> beginning and end, respectively, of the enclosing higher levelD section.  The third argument is a string specifying the general kindC of section such as \"chapter\ or \"section\".  When looking for the B `Next' pointer, the section found will be at the same hierarchicalC level in the Texinfo file; when looking for the `Previous' pointer,aE the section found will be at the same or higher hierarchical level in^F the Texinfo file; when looking for the `Up' pointer, the section foundF will be at some level higher in the Texinfo file.  The fourth argumentA \(one of 'next, 'previous, or 'up\) specifies whether to find theo% `Next', `Previous', or `Up' pointer.")   (let ((case-fold-search t))o     (cond ((eq direction 'next)o@            (forward-line 3)             ; skip over current nodeD            ;; Search for section commands accompanied by node lines;=            ;; ignore section commands in the middle of nodes.\!            (if (re-search-forwardeJ                 ;; A `Top' node is never a next pointer, so won't find it.                 (concatp$                  ;; Match node line.,                  "\\(^@node\\).*\n"         8                  ;; Match comment or ifinfo line, if anyE                  "\\(\\(\\(^@c\\).*\n\\)\\|\\(^@ifinfo[ ]*\n\\)\\)?" "                  (evalN                   (cdr (assoc level texinfo-update-menu-same-level-regexps))))                 endo                 t)                'normal              'no-pointer))#           ((eq direction 'previous)e"            (if (re-search-backward                 (concats                  "\\("$                  ;; Match node line.,                  "\\(^@node\\).*\n"         8                  ;; Match comment or ifinfo line, if anyE                  "\\(\\(\\(^@c\\).*\n\\)\\|\\(^@ifinfo[ ]*\n\\)\\)?" -                  (evalM                   (cdr (assoc level texinfo-update-menu-same-level-regexps)))r                  "\\|"$                  ;; Match node line.,                  "\\(^@node\\).*\n"         8                  ;; Match comment or ifinfo line, if anyE                  "\\(\\(\\(^@c\\).*\n\\)\\|\\(^@ifinfo[ ]*\n\\)\\)?"                    (evalI                   (cdr (assoc level texinfo-update-menu-higher-regexps)))o                  "\\|"0                  ;; Handle `Top' node specially.4                  "^@node [ \t]*top[ \t]*\\(,\\|$\\)"                  "\\)")u                 beginningd                 t)                'normal              'no-pointer))           ((eq direction 'up)o"            (if (re-search-backward                 (concate                  "\\("$                  ;; Match node line.,                  "\\(^@node\\).*\n"         8                  ;; Match comment or ifinfo line, if anyE                  "\\(\\(\\(^@c\\).*\n\\)\\|\\(^@ifinfo[ ]*\n\\)\\)?"  N                  (eval (cdr (assoc level texinfo-update-menu-higher-regexps)))                  "\\|"0                  ;; Handle `Top' node specially.4                  "^@node [ \t]*top[ \t]*\\(,\\|$\\)"                  "\\)")                  (save-excursion-'                   (goto-char beginning)x%                   (beginning-of-line)o                   (point))                 t)                'normal              'no-pointer))           (tD            (error "texinfo-find-pointer: lack proper arguments")))))  " (defun texinfo-pointer-name (kind)6   "Return the node name preceding the section command.B The argument is the kind of section, either normal or no-pointer."
   (let (name)p     (cond ((eq kind 'normal)I            (end-of-line)                ; this handles prev node top case @            (re-search-backward          ; when point is already H             "^@node"                    ; at the beginning of @node line.             (save-excursion (forward-line -3))             t)0            (setq name (texinfo-copy-node-name))) 	  ((eq kind 'no-pointer) 7 	   (setq name " ")))	; put a blank in the pointer slott
     name))  = (defun texinfo-insert-pointer (beginning end level direction)l<   "Insert the `Next', `Previous' or `Up' node name at point. Move point forward.  i  D The first and second arguments bound the search for a pointer to the> beginning and end, respectively, of the enclosing higher levelE section.  The third argument is the hierarchical level of the TexinfoaE file, a string such as \"section\".  The fourth argument is direction B towards which the pointer is directed, one of `next, `previous, or 'up."s     (end-of-line)y	   (insertu    ", ")    (save-excursion      (texinfo-pointer-name>       (texinfo-find-pointer beginning end level direction)))))  $ (defun texinfo-clean-up-node-line ()5   "Remove extra commas, if any, at end of node line."o   (end-of-line)a   (skip-chars-backward ", ")A   (delete-region (point) (save-excursion (end-of-line) (point))))o     ;;; Updating nodes sequentially ? ; These sequential update functions insert `Next' or `Previous'hF ; pointers that point to the following or preceding nodes even if theyC ; are at higher or lower hierarchical levels.  This means that if ae@ ; section contains one or more subsections, the section's `Next'E ; pointer will point to the subsection and not the following section. F ; (The subsection to which `Next' points will most likely be the first ; item on the section's menu.)  : (defun texinfo-sequential-node-update (&optional region-p)H   "Update one node (or many) in a Texinfo file with sequential pointers.  E This function causes the `Next' or `Previous' pointer to point to thenE immediately preceding or following node, even if it is at a higher or F lower hierarchical level in the document.  Continually pressing `n' or( `p' takes you straight through the file.  G Without any prefix argument, update the node in which point is located.oG Non-nil argument (prefix, if interactive) means update the nodes in ther marked region.  < This command makes it awkward to navigate among sections andF subsections; it should be used only for those documents that are meantB to be read like a novel rather than a reference, and for which the! Info `g*' command is inadequate."e      (interactive "P")e   (if (not region-p):       (let ((auto-fill-hook nil))   ; update a single node=         (if (not (re-search-backward "^@node" (point-min) t)) @             (error "Node line not found before this position.")).         (texinfo-sequentially-update-the-node)         (message  M          "Done...sequentially updated the node .  You may save the buffer."))      ;; elseb     (let ((auto-fill-hook nil)(           (beginning (region-beginning))           (end (region-end))))       (if (= end beginning)c*           (error "Please mark a region!"))       (save-restriction.(         (narrow-to-region beginning end)         (goto-char beginning)n         (push-mark (point) t)s9         (while (re-search-forward "^@node" (point-max) t)))           (beginning-of-line)             1           (texinfo-sequentially-update-the-node))          (message nO          "Done...updated the nodes in sequence.  You may save the buffer.")))))I  . (defun texinfo-sequentially-update-the-node ():   "Update one node such that the pointers are sequential. I A `Next' or `Previous' pointer points to any preceding or following node,s& regardless of its hierarchical level."  %         (texinfo-check-for-node-name) *         (texinfo-delete-existing-pointers)         (message pH          "Sequentially updating node: %s ... " (texinfo-copy-node-name))         (save-restrictionh           (widen)h           (let*e#               ((case-fold-search t),2                (level (texinfo-hierarchic-level)))*             (if (string-equal level "top")*                 (texinfo-top-pointer-case)               ;; else ?               (texinfo-sequentially-insert-pointer level 'next)nC               (texinfo-sequentially-insert-pointer level 'previous)i=               (texinfo-sequentially-insert-pointer level 'up)i.               (texinfo-clean-up-node-line)))))  : (defun texinfo-sequentially-find-pointer (level direction)M   "Find next or previous pointer sequentially in Texinfo file, or up pointer.eF Move point to section associated with the pointer.  Find point even if it is in a different section.   7 Return type of pointer (either 'normal or 'no-pointer).o  E The first argument is a string specifying the general kind of sectionrD such as \"chapter\ or \"section\".  The section found will be at theF same hierarchical level in the Texinfo file, or, in the case of the up? pointer, some level higher.  The second argument (one of 'next,eD 'previous, or 'up) specifies whether to find the `Next', `Previous', or `Up' pointer."(   (let ((case-fold-search t))        (cond ((eq direction 'next)N@            (forward-line 3)             ; skip over current node"            (if (re-search-forward ,                 texinfo-section-types-regexp                 (point-max)                  t)                'normal              'no-pointer))#           ((eq direction 'previous)d#            (if (re-search-backward a,                 texinfo-section-types-regexp                 (point-min)o                 t)                'normal              'no-pointer))           ((eq direction 'up)d"            (if (re-search-backwardM                 (eval (cdr (assoc level texinfo-update-menu-higher-regexps)))\                 beginning)                 t)                'normal              'no-pointer))           (tO            (error "texinfo-sequential-find-pointer: lack proper arguments")))))'  < (defun texinfo-sequentially-insert-pointer (level direction)<   "Insert the `Next', `Previous' or `Up' node name at point. Move point forward.     C The first argument is the hierarchical level of the Texinfo file, anE string such as \"section\".  The second argument is direction, one of  `next, `previous, or 'up."     (end-of-line))	   (insertn    ", "\    (save-excursion      (texinfo-pointer-name=       (texinfo-sequentially-find-pointer level direction)))))r     ;;; Inserting `@node' lines J ; The `texinfo-insert-node-lines' function inserts `@node' lines as neededD ; before the `@chapter', `@section', and such like lines of a region ; in a Texinfo file.  B (defun texinfo-insert-node-lines (beginning end &optional title-p):   "Insert missing `@node' lines in region of Texinfo file.B Non-nil argument (prefix, if interactive) means also to insert theF section titles as node names; and also to insert the section titles as8 node names in pre-existing @node lines that lack names."   (interactive "r\nP")  B   ;; Use marker; after inserting node lines, leave point at end of"   ;; region and mark at beginning.  @   (let (beginning-marker end-marker title last-section-position)  >     ;; Save current position on mark ring and set mark to end.(     (push-mark end t)                   +     (setq end-marker (mark-marker))        c       (goto-char beginning)n     (while (re-search-forwardv)             texinfo-section-types-regexp g             end-marker             'end)        ;; Copy title if desired.        (if title-p            (progn \             (beginning-of-line)              (forward-word 1)&             (skip-chars-forward " \t"))             (setq title (buffer-substringb                           (point)C                          (save-excursion (end-of-line) (point)))))) '       ;; Insert node line if necessary.(       (if (re-search-backwardc            "^@node" G            ;; Avoid finding previous node line if node lines are close.n(            (or last-section-position    =                (save-excursion (forward-line -2) (point))) t)pC           ;;  @node is present, and point at beginning of that line C           (forward-word 1)          ; Leave point just after @node. *         ;; Else @node missing; insert one.C         (beginning-of-line)         ; Beginning of `@section' line.          (insert "@node\n")E         (backward-char 1))          ; Leave point just after `@node'.n!       ;; Insert title if desired.        (if title-p)           (progn&             (skip-chars-forward " \t")6             ;; Use regexp based on what info looks for0             ;; (alternatively, use "[a-zA-Z]+");@             ;; this means we only insert a title if none exists.0             (if (not (looking-at "[^,\t\n ]+"))                  (progn&                   (beginning-of-line) "                   (forward-word 1)$                   (insert " " title)>                   (message "Inserted title %s ... " title)))))1       ;; Go forward beyond current section title.,6       (re-search-forward texinfo-section-types-regexp E                          (save-excursion (forward-line 3) (point)) t)o*       (setq last-section-position (point))       (forward-line 1))e  7     ;; Leave point at end of region, mark at beginning.o     (set-mark beginning)       (if title-pr       (messageI        "Done inserting node lines and titles.  You may save the buffer.") G     (message "Done inserting node lines.  You may save the buffer."))))e   e: ;;; Update and create menus for multi-file Texinfo sources  ) ;;  1. M-x texinfo-multiple-files-update e ;;> ;;     Read the include file list of an outer Texinfo file andF ;;     update all highest level nodes in the files listed and insert a6 ;;     main menu in the outer file after its top node.  - ;;  2. C-u M-x texinfo-multiple-files-update l ;;D ;;     Same as 1, but insert a master menu.  (Saves reupdating lowerE ;;     level menus and nodes.)  This command simply reads every menu, @ ;;     so if the menus are wrong, the master menu will be wrong.B ;;     Similarly, if the lower level node pointers are wrong, they ;;     will stay wrong.e  / ;;  3. C-u 2 M-x texinfo-multiple-files-update l ;;> ;;     Read the include file list of an outer Texinfo file andB ;;     update all nodes and menus in the files listed and insert a8 ;;     master menu in the outer file after its top node.   ;;; Note: these functions: ;;;sH ;;;   * Do not save or delete any buffers.  You may fill up your memory.= ;;;   * Do not handle any pre-existing nodes in outer file.  o/ ;;;     Hence, you may need a file for indices.a   t2 ;;; Auxiliary functions for multiple file updating  4 (defun texinfo-multi-file-included-list (outer-file)6   "Return a list of the included files in OUTER-FILE.".   (let ((included-file-list (list outer-file))         start)     (save-excursion 8       (switch-to-buffer (find-file-noselect outer-file))
       (widen)n       (goto-char (point-min)))2       (while (re-search-forward "^@include" nil t)"         (skip-chars-forward " \t")         (setq start (point))         (end-of-line) &         (skip-chars-backward " \t")             (setq included-file-list4               (cons (buffer-substring start (point)))                     included-file-list)))i&       (nreverse included-file-list))))  ) (defun texinfo-copy-next-section-title () D   "Return the name of the immediately following section as a string.  G Start with point at the beginning of the node line.  Leave point at thex< same place.  If there is no title, returns an empty string."     (save-excursiont     (end-of-line)e     (let ((node-end (or '                         (save-excursionpF                           (if (re-search-forward "\\(^@node\\)" nil t)3                               (match-beginning 0)))e&                         (point-max))))E       (if (re-search-forward texinfo-section-types-regexp node-end t)            (progn             (beginning-of-line)m             ;; copy titlei             (let ((title$                    (buffer-substringN                     (progn (forward-word 1)           ; skip over section typeG                            (skip-chars-forward " \t") ; and over spaces #                            (point)) 4                     (progn (end-of-line) (point)))))               title))          ""))))  D (defun texinfo-multi-file-update (files &optional update-everything)4   "Update first node pointers in each file in FILES.  Return a list of the node names.  > The first file in the list is an outer file; the remaining are: files included in the outer file with `@include' commands.  @ If optional arg UPDATE-EVERYTHING non-nil, update every menu and& pointer in each of the included files.  < Also update the `Top' level node pointers of the outer file.  
 Requirements:n  <   * the first file in the FILES list must be the outer file,?   * each of the included files must contain exactly one highesth     hierarchical level node,  :   * this node must be the first node in the included file,B   * each highest hierarchical level node must be of the same type.  > Thus, normally, each included file contains one, and only one,	 chapter."h   ; The menu-list has the form:, ; ( ;     \(\(\"node-name1\" . \"title1\"\) . ;       \(\"node-name2\" . \"title2\"\) ... \) ; D ; However, there does not need to be a title field and this function= ; does not fill it; however a comment tells you how to do so.eE ; You would use the title field if you wanted to insert titles in the'. ; description slot of a menu as a description.      (let ((case-fold-search t)         menu-list)     B     ;; Find the name of the first node of the first included file.=     (switch-to-buffer (find-file-noselect (car (cdr files))))      (widen)t     (goto-char (point-min))n0     (if (not (re-search-forward "^@node" nil t))>         (error "No `@node' line found in %s !" (buffer-name)))     (beginning-of-line) !     (texinfo-check-for-node-name) 2     (setq next-node-name (texinfo-copy-node-name))          (setq menu-list            (cons (cons                   next-node-name)-                  (prog1 "" (forward-line 1)))tH                 ;; Use following to insert section titles automatically.4                 ;; (texinfo-copy-next-section-title)                 menu-list))        ;; Go to outer fileg7     (switch-to-buffer (find-file-noselect (car files)))o     (goto-char (point-min))'K     (if (not (re-search-forward "^@node [ \t]*top[ \t]*\\(,\\|$\\)" nil t))i0         (error "This buffer needs a Top node!"))     (beginning-of-line))&     (texinfo-delete-existing-pointers)     (end-of-line)s1     (insert ", " next-node-name ", (dir), (dir)")e     (beginning-of-line)t#     (setq previous-node-name "Top")o     (setq files (cdr files))          (while files              (if (not (cdr files))a           ;; No next filen"           (setq next-node-name "")         ;; Else,<         ;; find the name of the first node in the next file.A         (switch-to-buffer (find-file-noselect (car (cdr files))))          (widen)-         (goto-char (point-min))m4         (if (not (re-search-forward "^@node" nil t))B             (error "No `@node' line found in %s !" (buffer-name)))         (beginning-of-line)n%         (texinfo-check-for-node-name)n6         (setq next-node-name (texinfo-copy-node-name))         (setq menu-list                (cons (cons #                      next-node-namem1                      (prog1 "" (forward-line 1))) L                     ;; Use following to insert section titles automatically.8                     ;; (texinfo-copy-next-section-title)                      menu-list)))  "       ;; Go to node to be updated.9       (switch-to-buffer (find-file-noselect (car files)))s       (goto-char (point-min)) 2       (if (not (re-search-forward "^@node" nil t))@           (error "No `@node' line found in %s !" (buffer-name)))       (beginning-of-line)        3       ;; Update other menus and nodes if requested.c9       (if update-everything (texinfo-all-menus-update t))r         (beginning-of-line)s(       (texinfo-delete-existing-pointers)       (end-of-line) L       (insert ", " next-node-name ", " previous-node-name ", " up-node-name)              (beginning-of-line) 8       (setq previous-node-name (texinfo-copy-node-name))              (setq files (cdr files)))n     (nreverse menu-list)))  7 (defun texinfo-multi-files-insert-main-menu (menu-list) '   "Insert formatted main menu at point. B Indents the first line of the description, if any, to the value of  texinfo-column-for-description."     (insert "@menu\n")   (while menu-list7     ;; Every menu entry starts with a star and a space.x     (insert "* ")o     >     ;; Insert the node name (and menu entry name, if present).,     (let ((node-part (car (car menu-list))))       (if (stringp node-part)tN           ;; "Double colon" entry line; menu entry and node name are the same,.           (insert (format "%s::" node-part))  M         ;; "Single colon" entry line; menu entry and node name are different.tE         (insert (format "%s: %s." (car node-part) (cdr node-part)))))e     *     ;; Insert the description, if present.     (if (cdr (car menu-list))          (progn!           ;; Move to right place. 7           (indent-to texinfo-column-for-description 2) l            ;; Insert description.:           (insert (format "%s" (cdr (car menu-list))))))    '     (insert "\n") ; end this menu entry %     (setq menu-list (cdr menu-list)))    (insert "@end menu"))"  7 (defun texinfo-multi-file-master-menu-list (files-list)t4   "Return master menu list from files in FILES-LIST.E Menu entries in each file collected using `texinfo-master-menu-list'.e  D The first file in FILES-LIST must be the outer file; the others mustB be the files included within it.  A main menu must already exist."   (save-excursionu     (let (master-menu-list)t       (while files-listx@         (switch-to-buffer (find-file-noselect (car files-list)))4         (message "Working on: %s " (current-buffer))         (goto-char (point-min))s         (setq master-menu-listC               (append master-menu-list (texinfo-master-menu-list)))m+         (setq files-list (cdr files-list)))w       master-menu-list)))y   g% ;;; The multiple-file update function-  $ (defun texinfo-multiple-files-update;   (outer-file &optional update-everything make-master-menu) B   "Update first node pointers in each file included in OUTER-FILE;C create or update the `Top' level node pointers and the main menu in B the outer file that refers to such nodes.  This does not create or3 update menus or pointers within the included files.d  E With optional MAKE-MASTER-MENU argument (prefix arg, if interactive), F insert a master menu in OUTER-FILE in addition to creating or updatingF pointers in the first @node line in each included file and creating orD updating the `Top' level node pointers of the outer file.  This doesA not create or update other menus and pointers within the includedn files.  @ With optional UPDATE-EVERYTHING argument (numeric prefix arg, ifF interactive), update all the menus and all the `Next', `Previous', andF `Up' pointers of all the files included in OUTER-FILE before inserting? a master menu in OUTER-FILE.  Also, update the `Top' level nodel pointers of OUTER-FILE.n   Notes: u  ;   * this command does NOT save any files--you must save the)0     outer file and any modified, included files.  ?   * except for the `Top' node, this command does NOT handle anym@     pre-existing nodes in the outer file; hence, indices must be!     enclosed in an included file.e  
 Requirements:a  ?   * each of the included files must contain exactly one highestv     hierarchical level node, eB   * this highest node must be the first node in the included file,B   * each highest hierarchical level node must be of the same type.  > Thus, normally, each included file contains one, and only one,	 chapter."       (interactive (cons                 (read-string1                  "Name of outer `include' file: "o$                  (buffer-file-name))/                 (cond ((not current-prefix-arg)t"                        '(nil nil))1                       ((listp current-prefix-arg) 6                        '(t nil))   ; make-master-menu 3                       ((numberp current-prefix-arg) 6                        '(t t))     ; update-everything                       ))))  K   (let* ((included-file-list (texinfo-multi-file-included-list outer-file))e#          (files included-file-list)           main-menu-listt          next-node-name.          previous-node-namea          (up-node-name "Top"))   ;;; Update the pointers 1 ;;; and collect the names of the nodes and titles@M     (setq main-menu-list (texinfo-multi-file-update files update-everything))e   ;;; Insert main menu     ;; Go to outer file B   (switch-to-buffer (find-file-noselect (car included-file-list)))   (if (texinfo-old-menu-p         (point-min)        (save-excursion(          (re-search-forward "^@include")          (beginning-of-line)          (point)))  E       ;; If found, leave point after word `menu' on the `@menu' line.        (progn9         (texinfo-incorporate-descriptions main-menu-list)o          ;; Delete existing menu.         (beginning-of-line).         (delete-region          (point)C          (save-excursion (re-search-forward "^@end menu") (point)))\         ;; Insert main menue>         (texinfo-multi-files-insert-main-menu main-menu-list))  8     ;; Else no current menu; insert it before `@include':     (texinfo-multi-files-insert-main-menu main-menu-list))   ;;; Insert master menu     (if make-master-menu       (prognH         ;; First, removing detailed part of any pre-existing master menu         (goto-char (point-min))s@         (if (re-search-forward texinfo-master-menu-header nil t)2             ;; Remove detailed master menu listing             (progn-               (goto-char (match-beginning 0))e6               (let ((end-of-detailed-menu-descriptionsE                      (save-excursion     ; beginning of end menu linee5                        (goto-char (texinfo-menu-end)) <                        (beginning-of-line) (forward-char -1)!                        (point))))(L                 (delete-region (point) end-of-detailed-menu-descriptions))))  -         ;; Create a master menu and insert itn)         (texinfo-insert-master-menu-list s-          (texinfo-multi-file-master-menu-listo!           included-file-list)))))l  !   ;; Remove unwanted extra lines.    (save-excursiona     (goto-char (point-min))[             (re-search-forward "^@menu")     (forward-line -1)o4     (insert  "\n") ; Ensure at least one blank line.     (delete-blank-lines)       $     (re-search-forward "^@end menu")     (forward-line 1)4     (insert  "\n") ; Ensure at least one blank line.     (delete-blank-lines))   &   (message "Multiple files updated."))    # ;;; Place `provide' at end of file.  (provide 'texnfo-upd) 3 ;;;;;;;;;;;;;;;; end texnfo-upd.el ;;;;;;;;;;;;;;;; 