 ;;;; makeinfo.el  5 ;;;  Texinfo mode interface to the `makeinfo' command B ;;;  for converting part or all of a Texinfo file to an Info file.  # ;;; Version 2.04   12 February 1992  ;;; Robert J. Chassell        5 ;;; Copyright (C) 1991 Free Software Foundation, Inc.     # ;;; This file is part of GNU Emacs.   D ;; GNU Emacs is free software; you can redistribute it and/or modifyG ;; it under the terms of the GNU General Public License as published by F ;; the Free Software Foundation; either version 1, or (at your option) ;; any later version.   ? ;; GNU Emacs is distributed in the hope that it will be useful, A ;; but WITHOUT ANY WARRANTY; without even the implied warranty of @ ;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/ ;; GNU General Public License for more details.   D ;; You should have received a copy of the GNU General Public License@ ;; along with GNU Emacs; see the file COPYING.  If not, write toH ;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.    5 ;;; The Texinfo mode `makeinfo' related commands are:   > ;; makeinfo-region      to run makeinfo on the current region.A ;; makeinfo-buffer      to run makeinfo on the current buffer, or E ;;                        with optional prefix arg, on current region > ;; kill-compilation     to kill currently running makeinfo jobG ;; makeinfo-recenter-makeinfo-buffer  to redisplay *compilation* buffer     ) ;;; Keybindings (defined in `texinfo.el')    ;; makeinfo bindings? ; (define-key texinfo-mode-map "\C-c\C-m\C-r" 'makeinfo-region) ? ; (define-key texinfo-mode-map "\C-c\C-m\C-b" 'makeinfo-buffer) @ ; (define-key texinfo-mode-map "\C-c\C-m\C-k" 'kill-compilation)- ; (define-key texinfo-mode-map "\C-c\C-m\C-l" * ;   'makeinfo-recenter-compilation-buffer)      ;;; Variables used by `makeinfo'   (require 'compile)  ' (defvar makeinfo-run-command "makeinfo" (   "*Command used to run makeinfo subjob.M The name of the file will be appended to this string, separated by a space.")   * (defvar makeinfo-options "+fill-column=70",   "*String containing flags for  makeinfo.  F Do not include footnote-style or paragraph-indent, which are specified) by @footnotestyle and @paragraphindent.")    (require 'texinfo) (require 'texinfmt)   ( (defvar makeinfo-compilation-process nil6   "Process that runs makeinfo. Should start out nil.")   (defvar makeinfo-temp-file nilG   "Temporary file name used for text being sent as input to makeinfo.")   % (defvar makeinfo-output-file-name nil 5   "Info file name used for text output by makeinfo.")     ' ;;; The `makeinfo' function definitions    (autoload 'compile1 "compile")  4 (defun makeinfo-region (region-beginning region-end)H   "Make Info file from region of current Texinfo file, and switch to it.  C This command does not offer the `next-error' feature since it would F apply to a temporary file, not the original; use the `makeinfo-buffer'% command to gain use of `next-error'."       (interactive "r")    (let (filename-or-header$         filename-or-header-beginning         filename-or-header-end) 1     ;; Cannot use `let' for makeinfo-temp-file or F     ;; makeinfo-output-file-name since `makeinfo-compilation-sentinel'     ;; needs them.       (setq makeinfo-temp-file           (concat             (make-temp-name)             (substring (buffer-file-name)                         0  F                        (or (string-match "\\.tex" (buffer-file-name)) 9                            (length (buffer-file-name)))))             ".texinfo"))           (save-excursion        (save-restriction          (widen)          (goto-char (point-min)) G         (let ((search-end (save-excursion (forward-line 100) (point)))) /           ;; Find and record the Info filename, 7           ;; or else explain that a filename is needed. !           (if (re-search-forward  9                "^@setfilename[ \t]+\\([^ \t\n]+\\)[ \t]*"                 search-end t).               (setq makeinfo-output-file-name I                     (buffer-substring (match-beginning 1) (match-end 1)))              (errorJ              "The texinfo file needs a line saying: @setfilename <name>"))  ;           ;; Find header and specify its beginning and end. !           (goto-char (point-min))            (if (and                  (prog1 H                    (search-forward texinfo-start-of-header search-end t)$                  (beginning-of-line)-                  ;; Mark beginning of header. =                  (setq filename-or-header-beginning (point)))                 (prog1 ?                    (search-forward texinfo-end-of-header nil t) $                  (beginning-of-line)&                  ;; Mark end of header8                  (setq filename-or-header-end (point))))               ;               ;; Insert the header into the temporary file.                (write-region B                (min filename-or-header-beginning region-beginning)%                filename-or-header-end *                makeinfo-temp-file nil nil)             I             ;; Else no header; insert @filename line into temporary file. #             (goto-char (point-min)) 8             (search-forward "@setfilename" search-end t)             (beginning-of-line) 7             (setq filename-or-header-beginning (point))              (forward-line 1)1             (setq filename-or-header-end (point))              (write-region @              (min filename-or-header-beginning region-beginning)#              filename-or-header-end )              makeinfo-temp-file nil nil)) 
           -           ;; Insert the region into the file.            (write-region 8            (max region-beginning filename-or-header-end)            region-end $            makeinfo-temp-file t nil)  K           ;; Run the `makeinfo-compile' command in the *compilation* buffer            (save-excursion              (makeinfo-compile )              (concat makeinfo-run-command                       " "%                      makeinfo-options                       " "  (                      makeinfo-temp-file)T              "Use `makeinfo-buffer' to gain use of the `next-error' command.")))))))  D ;; Based on `compile1' in compile.el; changed so to make it possible ;; to delete temporary file.F (defun makeinfo-compile (command error-message &optional name-of-mode)L   ;(save-some-buffers)                   ; Don't need to save other buffers."   (if makeinfo-compilation-processK       (if (or (not (eq (process-status makeinfo-compilation-process) 'run))  	      (yes-or-no-p I                "A `makeinfo' compilation process is running; kill it? "))  	  (condition-case () 6 	      (let ((comp-proc makeinfo-compilation-process)) 		(interrupt-process comp-proc) 
 		(sit-for 1)  		(delete-process comp-proc))  	    (error nil)) / 	(error "Cannot have two makeinfo processes"))) )   (setq makeinfo-compilation-process nil)    (compilation-forget-errors) !   (setq compilation-error-list t) 0   (setq compilation-error-message error-message)$   (setq makeinfo-compilation-process3 	(start-process "makeinfo" "*compilation*"           		       shell-file-name( 		       "-c" (concat "exec " command))):   (with-output-to-temp-buffer "*compilation*"                  (princ "cd ")      (princ default-directory)      (terpri)     (princ command) 
     (terpri)) *   (let ((regexp compilation-error-regexp))     (save-excursion :       (set-buffer "*compilation*")                        5       (make-local-variable 'compilation-error-regexp) .       (setq compilation-error-regexp regexp)))   (set-process-sentinel ?    makeinfo-compilation-process 'makeinfo-compilation-sentinel) $   (let* ((thisdir default-directory)8 	 (outbuf (process-buffer makeinfo-compilation-process))& 	 (outwin (get-buffer-window outbuf)))$     (if (eq outbuf (current-buffer)) 	(goto-char (point-max)))      (save-excursion        (set-buffer outbuf)         (buffer-flush-undo outbuf)E       (let ((start (save-excursion (set-buffer outbuf) (point-min))))   	(set-window-start outwin start)" 	(or (eq outwin (selected-window))& 	    (set-window-point outwin start)))&       (setq default-directory thisdir)       (fundamental-mode):       (setq mode-name (or name-of-mode "compilation"))    7       ;; Make log buffer's mode line show process states+       (setq mode-line-process '(": %s")))))h  ; ;; Delete makeinfo-temp-file after proccessing is finished,, ;; and visit Info file.lF ;; This function is called when the compilation process changes state.0 ;; Based on `compilation-sentinel' in compile.el/ (defun makeinfo-compilation-sentinel (proc msg) 3   (cond ((null (buffer-name (process-buffer proc)))  	 ;; buffer killed  	 (set-process-buffer proc nil))- 	((memq (process-status proc) '(signal exit))s  	 (let* ((obuf (current-buffer)) 		omax opoint). 	   ;; save-excursion isn't the right thing if( 	   ;;  process-buffer is current-buffer 	   (unwind-protecti 	       (progn/ 		 ;; Write something in *compilation* and hacky 		 ;; its mode line,% 		 (set-buffer (process-buffer proc))s) 		 (setq omax (point-max) opoint (point))t 		 (goto-char (point-max))! 		 (insert ?\n mode-name " " msg)  		 (forward-char -1) 		 (insert " at "o+ 			 (substring (current-time-string) 0 -5))n 		 (forward-char 1)  		 (setq mode-line-process 		       (concat ": "r/ 			       (symbol-name (process-status proc)))) 8 		 ;; If buffer and mode line will show that the process2 		 ;; is dead, we can delete it now.  Otherwise it0 		 ;; will stay around until M-x list-processes. 		 (delete-process proc))o- 	     (setq makeinfo-compilation-process nil)t' 	     ;; Force mode line redisplay soond2 	     (set-buffer-modified-p (buffer-modified-p)))$ 	   (if (and opoint (< opoint omax)) 	       (goto-char opoint))u 	   (set-buffer obuf))H          (if (and makeinfo-temp-file (file-exists-p makeinfo-temp-file)).              (delete-file makeinfo-temp-file))+          ;; Always use the version on disk.b8          (if (get-file-buffer makeinfo-output-file-name):              (progn (set-buffer makeinfo-output-file-name))                     (revert-buffer t t)))o.          (find-file makeinfo-output-file-name)#          (goto-char (point-min)))))    (defun makeinfo-buffer (buffer)k&   "Make Info file from current buffer.  A The \\[next-error] command can be used to move to the next error g \(if any are found\)."   &   (interactive "bRun `makeinfo' on: ")    (cond ((null buffer-file-name)1          (error "Buffer not visiting any file!"))i         ((buffer-modified-p)C          (if (y-or-n-p "Buffer modified; do you want to save it? ")               (save-buffer))))o   '   ;; Find and record the Info filename,d/   ;; or else explain that a filename is needed.m   (save-excursione     (goto-char (point-min))iC     (let ((search-end (save-excursion (forward-line 100) (point)))))       (if (re-search-forward  5            "^@setfilename[ \t]+\\([^ \t\n]+\\)[ \t]*"a            search-end t)*           (setq makeinfo-output-file-name E                 (buffer-substring (match-beginning 1) (match-end 1)))o         (errorH          "The texinfo file needs a line saying: @setfilename <name>"))))      (save-excursiong     (makeinfo-compilee!      (concat makeinfo-run-command               " " t              makeinfo-optionsu              " " e              "+footnote-style=" #              texinfo-footnote-stylen              " "              (buffer-file-name#               (get-buffer buffer)))u      "No more errors.")))   5 (defun makeinfo-recenter-compilation-buffer (linenum)hI   "Redisplay *compilation* buffer so that most recent output can be seen.f+ The last line of the buffer is displayed on 5 line LINE of the window, or centered if LINE is nil."    (interactive "P")g6   (let ((makeinfo-buffer (get-buffer "*compilation*")) 	(old-buffer (current-buffer)))n     (if (null makeinfo-buffer)$ 	(message "No *compilation* buffer")%       (pop-to-buffer makeinfo-buffer)d#       (bury-buffer makeinfo-buffer)d       (goto-char (point-max))m       (recenter (if linenum $ 		    (prefix-numeric-value linenum) 		  (/ (window-height) 2)))-        (pop-to-buffer old-buffer)	       )))r   m# ;;; Place `provide' at end of file.  (provide 'makeinfo) 1 ;;;;;;;;;;;;;;;; end makeinfo.el ;;;;;;;;;;;;;;;;t