 ;;;; texinfmt.el  @ ;;; Emacs lisp functions to convert Texinfo files to Info files.  / (defvar texinfmt-version "2.30 of 18 May 1993")     ;;; Robert J. Chassell          < ;;; Please send bug reports to:  bug-texinfo@prep.ai.mit.edu  # ;;; Copyright (C) 1985, 1986, 1988, H ;;;               1990, 1991, 1992, 1993  Free Software Foundation, Inc.    # ;;; This file is part of GNU Emacs.   D ;; GNU Emacs is free software; you can redistribute it and/or modifyG ;; it under the terms of the GNU General Public License as published by F ;; the Free Software Foundation; either version 2, or (at your option) ;; any later version.   ? ;; GNU Emacs is distributed in the hope that it will be useful, A ;; but WITHOUT ANY WARRANTY; without even the implied warranty of @ ;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/ ;; GNU General Public License for more details.   D ;; You should have received a copy of the GNU General Public License@ ;; along with GNU Emacs; see the file COPYING.  If not, write toH ;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.     ;;; Variable definitions  E (require 'texinfo)          ; So `texinfo-footnote-style' is defined. K (require 'texnfo-upd)       ; So `texinfo-section-types-regexp' is defined.   ( (defvar texinfo-format-syntax-table nil)   (defvar texinfo-vindex)  (defvar texinfo-findex)  (defvar texinfo-cindex)  (defvar texinfo-pindex)  (defvar texinfo-tindex)  (defvar texinfo-kindex)  (defvar texinfo-last-node) (defvar texinfo-node-names)  (defvar texinfo-enclosure-list)      ;;; Syntax table   (if texinfo-format-syntax-table      nil 8   (setq texinfo-format-syntax-table (make-syntax-table));   (modify-syntax-entry ?\" " " texinfo-format-syntax-table) ;   (modify-syntax-entry ?\\ " " texinfo-format-syntax-table) ;   (modify-syntax-entry ?@ "\\" texinfo-format-syntax-table) =   (modify-syntax-entry ?\^q "\\" texinfo-format-syntax-table) ;   (modify-syntax-entry ?\[ "." texinfo-format-syntax-table) ;   (modify-syntax-entry ?\] "." texinfo-format-syntax-table) ;   (modify-syntax-entry ?\( "." texinfo-format-syntax-table) ;   (modify-syntax-entry ?\) "." texinfo-format-syntax-table) ;   (modify-syntax-entry ?{ "(}" texinfo-format-syntax-table) ;   (modify-syntax-entry ?} "){" texinfo-format-syntax-table) <   (modify-syntax-entry ?\' "." texinfo-format-syntax-table))    4 ;;; Top level buffer and region formatting functions  1 (defun texinfo-format-buffer (&optional notagify) A   "Process the current buffer as texinfo code, into an Info file. D The Info file output is generated in a buffer visiting the Info file, names specified in the @setfilename command.  D Non-nil argument (prefix, if interactive) means don't make tag table? and don't split the file if large.  You can use Info-tagify and ! Info-split to do these manually."    (interactive "P") 0   (let ((lastmessage "Formatting Info file..."))     (message lastmessage)      (texinfo-format-buffer-1)      (if notagify         nil !       (if (> (buffer-size) 30000)            (prognM             (message (setq lastmessage "Making tags table for Info file..."))              (Info-tagify))) "       (if (> (buffer-size) 100000)           (prognA             (message (setq lastmessage "Splitting Info file..."))              (Info-split))))       (message (concat lastmessageK                      (if (interactive-p) "done.  Now save it." "done.")))))   2 (defvar texinfo-region-buffer-name "*Info Region*"E   "*Name of the temporary buffer used by \\[texinfo-format-region].")   : (defun texinfo-format-region (region-beginning region-end)A   "Convert the current region of the Texinfo file to Info format. D This lets you see what that part of the file will look like in Info.D The command is bound to \\[texinfo-format-region].  The text that is3 converted to Info is stored in a temporary buffer."    (interactive "r") 1   (message "Converting region to Info format...")    (let (texinfo-command-start          texinfo-command-end          texinfo-command-name         texinfo-vindex         texinfo-findex         texinfo-cindex         texinfo-pindex         texinfo-tindex         texinfo-kindex         texinfo-stack $         (texinfo-format-filename "")         texinfo-example-start          texinfo-last-node-pos          texinfo-last-node          texinfo-node-names#         (texinfo-footnote-number 0)          last-input-buffer *         (fill-column-for-info fill-column)'         (input-buffer (current-buffer)) +         (input-directory default-directory)          (header-text "")         (header-beginning 1)         (header-end 1))      : ;;; Copy lines between beginning and end of header lines, < ;;;    if any, or else copy the `@setfilename' line, if any.     (save-excursion          (save-restriction            (widen) !           (goto-char (point-min)) I           (let ((search-end (save-excursion (forward-line 100) (point))))              (if (or ,                  ;; Either copy header text.                  (and                    (prog1  K                       (search-forward texinfo-start-of-header search-end t) $                     (forward-line 1)0                     ;; Mark beginning of header.4                     (setq header-beginning (point)))                   (prog1  B                       (search-forward texinfo-end-of-header nil t)'                     (beginning-of-line) )                     ;; Mark end of header /                     (setq header-end (point)))) +                  ;; Or copy @filename line.                   (prog2 )                   (goto-char (point-min)) >                   (search-forward "@setfilename" search-end t)%                   (beginning-of-line) 1                   (setq header-beginning (point)) "                   (forward-line 1)-                   (setq header-end (point))))                                    ;; Copy header  !                 (setq header-text '                       (buffer-substring >                        (min header-beginning region-beginning)'                        header-end))))))    ;;; Find a buffer to use. E     (switch-to-buffer (get-buffer-create texinfo-region-buffer-name))      (erase-buffer))     ;; Insert the header into the buffer.      (insert header-text))     ;; Insert the region into the buffer.      (insert-buffer-substring      input-buffer &      (max region-beginning header-end)      region-end)*     ;; Make sure region ends in a newline.      (or (= (preceding-char) ?\n)         (insert "\n"))          (goto-char (point-min))      (texinfo-mode)3     (message "Converting region to Info format...") +     (setq fill-column fill-column-for-info) C     ;; Install a syntax table useful for scanning command operands. 2     (set-syntax-table texinfo-format-syntax-table)  B     ;; Insert @include files so `texinfo-raise-lower-sections' can4     ;; work on them without losing track of multiple'     ;; @raise/@lowersections commands.  0     (while (re-search-forward "^@include" nil t)(       (setq texinfo-command-end (point))-       (let ((filename (concat input-directory 9                               (texinfo-parse-line-arg))))          (beginning-of-line) I         (delete-region (point) (save-excursion (forward-line 1) (point))) 6         (message "Reading included file: %s" filename)         (save-excursion            (save-restriction              (narrow-to-region               (point)E              (+ (point) (car (cdr (insert-file-contents filename))))) #             (goto-char (point-min)) E             ;; Remove `@setfilename' line from included file, if any, 6             ;; so @setfilename command not duplicated.#             (if (re-search-forward  O                  "^@setfilename" (save-excursion (forward-line 100) (point)) t)                  (progn%                   (beginning-of-line)                     (delete-regionK                    (point) (save-excursion (forward-line 1) (point)))))))))   :     ;; Raise or lower level of each section, if necessary.     (goto-char (point-min)) "     (texinfo-raise-lower-sections)<     ;; Append @refill to appropriate paragraphs for filling.     (goto-char (point-min))o     (texinfo-append-refill)f<     ;; If the region includes the effective end of the data,%     ;; discard everything after that.o     (goto-char (point-max))u*     (if (re-search-backward "^@bye" nil t),         (delete-region (point) (point-max)))*     ;; Make sure buffer ends in a newline.      (or (= (preceding-char) ?\n)         (insert "\n"))<     ;; Don't use a previous value of texinfo-enclosure-list.%     (setq texinfo-enclosure-list nil)b       (goto-char (point-min))e-     (if (looking-at "\\\\input[ \t]+texinfo")oJ         (delete-region (point) (save-excursion (forward-line 1) (point))))  %     ;; Insert Info region title text.R     (goto-char (point-min))e     (if (search-forward F          "@setfilename" (save-excursion (forward-line 100) (point)) t)         (progn,           (setq texinfo-command-end (point))           (beginning-of-line)l.           (setq texinfo-command-start (point))2           (let ((arg (texinfo-parse-arg-discard)))             (insert " "C(               texinfo-region-buffer-name!               " buffer for:  `") )D             (insert (file-name-nondirectory (expand-file-name arg)))/             (insert "',        -*-Text-*-\n")))s$       ;; Else no `@setfilename' line       (insert " " (               texinfo-region-buffer-name<               " buffer                       -*-Text-*-\n"))3     (insert "produced by `texinfo-format-region'\n"d              "from a region in: "/             (if (buffer-file-name input-buffer)i                   (concat "`" 2                           (file-name-sans-versions2                            (file-name-nondirectory=                             (buffer-file-name input-buffer)))m                           "'")C                 (concat "buffer `" (buffer-name input-buffer) "'"))a.               "\nusing `texinfmt.el' version "               texinfmt-version               ".\n\n")       ;; Now convert for real.     (goto-char (point-min))y     (texinfo-format-scan)t     (goto-char (point-min))e          (message "Done.")))t   b> ;;; Primary internal formatting function for the whole buffer.  ! (defun texinfo-format-buffer-1 ()x   (let (texinfo-format-filenamed         texinfo-example-starto         texinfo-command-startf         texinfo-command-endo         texinfo-command-name         texinfo-last-nodeg         texinfo-last-node-posf         texinfo-vindex         texinfo-findex         texinfo-cindex         texinfo-pindex         texinfo-tindex         texinfo-kindex         texinfo-stacki         texinfo-node-names#         (texinfo-footnote-number 0)          last-input-bufferf         outfilen*         (fill-column-for-info fill-column)'         (input-buffer (current-buffer))n,         (input-directory default-directory))%     (setq texinfo-enclosure-list nil)o     (save-excursion"       (goto-char (point-min)) /       (or (search-forward "@setfilename" nil t) H           (error "Texinfo file needs an `@setfilename FILENAME' line."))(       (setq texinfo-command-end (point)).       (setq outfile (texinfo-parse-line-arg)))     (find-file outfile)>     (texinfo-mode)+     (setq fill-column fill-column-for-info)e2     (set-syntax-table texinfo-format-syntax-table)     (erase-buffer)*     (insert-buffer-substring input-buffer)J     (message "Converting %s to Info format..." (buffer-name input-buffer))     B     ;; Insert @include files so `texinfo-raise-lower-sections' can4     ;; work on them without losing track of multiple'     ;; @raise/@lowersections commands. r     (goto-char (point-min))r0     (while (re-search-forward "^@include" nil t)(       (setq texinfo-command-end (point))-       (let ((filename (concat input-directoryd9                               (texinfo-parse-line-arg))))          (beginning-of-line)aI         (delete-region (point) (save-excursion (forward-line 1) (point)))o6         (message "Reading included file: %s" filename)         (save-excursion            (save-restriction              (narrow-to-region-              (point)E              (+ (point) (car (cdr (insert-file-contents filename)))))f#             (goto-char (point-min)) E             ;; Remove `@setfilename' line from included file, if any, 6             ;; so @setfilename command not duplicated.#             (if (re-search-forward x                   "^@setfilename"?                  (save-excursion (forward-line 100) (point)) t)                  (progn%                   (beginning-of-line)y                    (delete-regionK                    (point) (save-excursion (forward-line 1) (point)))))))));:     ;; Raise or lower level of each section, if necessary.     (goto-char (point-min)) "     (texinfo-raise-lower-sections)/     ;; Append @refill to appropriate paragraphs      (goto-char (point-min))-     (texinfo-append-refill)      (goto-char (point-min))s#     (search-forward "@setfilename")      (beginning-of-line) '     (delete-region (point-min) (point)) 2     ;; Remove @bye at end of file, if it is there.     (goto-char (point-max))o&     (if (search-backward "@bye" nil t),         (delete-region (point) (point-max)))*     ;; Make sure buffer ends in a newline.      (or (= (preceding-char) ?\n)         (insert "\n"))8     ;; Scan the whole buffer, converting to Info format.     (texinfo-format-scan)e     ;; Return data for indices.g     (goto-char (point-min))      (list outfile 6           texinfo-vindex texinfo-findex texinfo-cindex9           texinfo-pindex texinfo-tindex texinfo-kindex)))     > ;;; Perform non-@-command file conversions: quotes and hyphens  ' (defun texinfo-format-convert (min max)a=   ;; Convert left and right quotes to typewriter font quotes.    (goto-char min)b$   (while (search-forward "``" max t)     (replace-match "\""))    (goto-char min)r$   (while (search-forward "''" max t)     (replace-match "\""))r+   ;; Convert three hyphens in a row to two.    (goto-char min)fH   (while (re-search-forward "\\( \\|\\w\\)\\(---\\)\\( \\|\\w\\)" max t)A     (delete-region (1+ (match-beginning 2)) (+ 2 (match-beginning 
     2)))))   i ;;; Handle paragraph filling    (defvar texinfo-no-refill-regexp   "^@\\(example\\|smallexample\\|lisp\\|smalllisp\\|display\\|format\\|flushleft\\|flushright\\|menu\\|titlepage\\|iftex\\|tex\\)"G   "Regexp specifying environments in which paragraphs are not filled.")i  # (defvar texinfo-part-of-para-regexp;   "^@\\(b{\\|bullet{\\|cite{\\|code{\\|emph{\\|equiv{\\|error{\\|expansion{\\|file{\\|i{\\|inforef{\\|kbd{\\|key{\\|lisp{\\|minus{\\|point{\\|print{\\|pxref{\\|r{\\|ref{\\|result{\\|samp{\\|sc{\\|t{\\|TeX{\\|today{\\|var{\\|w{\\|xref{\\)":   "Regexp specifying @-commands found within paragraphs.")   (defun texinfo-append-refill ()aA   "Append @refill at end of each paragraph that should be filled.sO Do not append @refill to paragraphs within @example and similar environments.  o? Do not append @refill to paragraphs containing @w{TEXT} or @*."(  F   ;; It is necessary to append @refill before other processing because@   ;; the other processing removes information that tells Texinfo5   ;; whether the text should or should not be filled.        (while (< (point) (point-max))+     (let ((refill-blank-lines "^[ \t\n]*$")1I           (case-fold-search nil))       ; Don't confuse @TeX and @tex....        (beginning-of-line) "       ;; 1. Skip over blank lines;7       ;;    skip over lines beginning with @-commands, p&       ;;    but do not skip over linesA       ;;      that are no-refill environments such as @example orRH       ;;      that begin with within-paragraph @-commands such as @code.J       (while (and (looking-at (concat "^@\\|^\\\\\\|" refill-blank-lines))#                   (not (looking-at e                         (concati                          "\\("  1                          texinfo-no-refill-regexp                           "\\|"  4                          texinfo-part-of-para-regexp!                          "\\)"))) *                   (< (point) (point-max)))         (forward-line 1)) B       ;; 2. Skip over @example and similar no-refill environments./       (if (looking-at texinfo-no-refill-regexp)i           (let ((environmentG                  (buffer-substring (match-beginning 1) (match-end 1))));J             (progn (re-search-forward (concat "^@end " environment) nil t)%                    (forward-line 1))) ;         ;; 3. Do not refill a paragraph containing @w or @*          (if  (or&               (>= (point) (point-max))                (re-search-forwardL                "@w{\\|@\\*" (save-excursion (forward-paragraph) (point)) t))5             ;; Go to end of paragraph and do nothing.i              (forward-paragraph) >           ;; 4. Else go to end of paragraph and insert @refill           (forward-paragraph)o           (forward-line -1)t           (end-of-line)            (delete-region            (point)@            (save-excursion (skip-chars-backward " \t") (point)))<           ;; `looking-at-backward' not available in v. 18.57@           ;; (if (not (looking-at-backward "@refill\\|@bye")) ;)&           (if (not (re-search-backward$                     "@refill\\|@bye"@                     (save-excursion (beginning-of-line) (point))                     t))r!               (insert "@refill"))i           (forward-line 1))))))r    9 ;;; Handle `@raisesections' and `@lowersections' commandsi  F ;; These commands change the hierarchical level of chapter structuring
 ;; commands.   ;;    2 ;; @raisesections changes @subsection to @section,2 ;;                        @section    to @chapter, ;;                        etc. ;;1 ;; @lowersections changes @chapter    to @sectiona8 ;;                        @subsection to @subsubsection, ;;                        etc. ;;> ;; An @raisesections/@lowersections command changes only thoseE ;; structuring commands that follow the @raisesections/@lowersectionsa ;; command.( ;;D ;; Repeated @raisesections/@lowersections continue to raise or lower ;; the heading level.e ;; tC ;; An @lowersections command cancels an @raisesections command, and  ;; vice versa. ;;E ;; You cannot raise or lower "beyond" chapters or subsubsections, but ? ;; trying to do so does not elicit an error---you just get morecD ;; headings that mean the same thing as you keep raising or loweringA ;; (for example, after a single @raisesections, both @chapter and & ;; @section produce chapter headings).  & (defun texinfo-raise-lower-sections ()E   "Raise or lower the hierarchical level of chapters, sections, etc.    E This function acts according to `@raisesections' and `@lowersections'e commands in the Texinfo file.i  A For example, an `@lowersections' command is useful if you wish to-A include what is written as an outer or standalone Texinfo file intF another Texinfo file as an inner, included file.  The `@lowersections'D command changes chapters to sections, sections to subsections and so on.d  / @raisesections changes @subsection to @section, /                        @section    to @chapter,)3                        @heading    to @chapheading,                         etc.e  / @lowersections changes @chapter    to @section,s5                        @subsection to @subsubsection,t2                        @heading    to @subheading,                        etc.   B An `@raisesections' or `@lowersections' command changes only those8 structuring commands that follow the `@raisesections' or `@lowersections' command.   D An `@lowersections' command cancels an `@raisesections' command, and vice versa.I  H Repeated use of the commands continue to raise or lower the hierarchical level a step at a time.o  D An attempt to raise above `chapters' reproduces chapter commands; an> attempt to lower below subsubsections reproduces subsubsection
 commands."   B   ;; `texinfo-section-types-regexp' is defined in `texnfo-upd.el';=   ;; it is a regexp matching chapter, section, other headings    ;; (but not the top node).     (let (type (level 0))n     (while r         (re-search-forward          (concat8           "\\(\\(^@\\(raise\\|lower\\)sections\\)\\|\\("&           texinfo-section-types-regexp           "\\)\\)")-          nil t)        (beginning-of-line) :       (save-excursion (setq type (read (current-buffer))))       (cond         (        ;; 1. Increment level!        ((eq type '@raisesections)u         (setq level (1+ level));         (delete-region<          (point) (save-excursion (forward-line 1) (point))))                 ;; 2. Decrement level!        ((eq type '@lowersections)1         (setq level (1- level))          (delete-region<          (point) (save-excursion (forward-line 1) (point))))         )        ;; Now handle structuring commands1
        ((cond)	          R(          ;; 3. Raise level when positive          ((> level 0)r           (let ((count level)i!                 (new-level type))r             (while (> count 0)               (setq new-level G                     (cdr (assq new-level texinfo-raisesections-alist)))o&               (setq count (1- count)))             (kill-word 1)n.             (insert (symbol-name new-level))))	          i>          ;; 4. Do nothing except move point when level is zero'          ((= level 0) (forward-line 1))i	          ((          ;; 5. Lower level when positive          ((< level 0)            (let ((count level) !                 (new-level type))h             (while (< count 0)               (setq new-levelnG                     (cdr (assq new-level texinfo-lowersections-alist)))l&               (setq count (1+ count)))             (kill-word 1)x4             (insert (symbol-name new-level))))))))))  # (defvar texinfo-raisesections-alist 8   '((@chapter . @chapter)             ; Cannot go higher     (@unnumbered . @unnumbered)e  #     (@majorheading . @majorheading)f!     (@chapheading . @chapheading)      (@appendix . @appendix)a          (@section . @chapter) "     (@unnumberedsec . @unnumbered)     (@heading . @chapheading)a     (@appendixsec . @appendix)          (@subsection . @section)(     (@unnumberedsubsec . @unnumberedsec)     (@subheading . @heading)$     (@appendixsubsec . @appendixsec)     "     (@subsubsection . @subsection).     (@unnumberedsubsubsec . @unnumberedsubsec)"     (@subsubheading . @subheading)+     (@appendixsubsubsec . @appendixsubsec))|?   "*An alist of next higher levels for chapters, sections. etc.t7 For example, section to chapter, subsection to section.t' Used by `texinfo-raise-lower-sections'. D The keys specify types of section; the values correspond to the next higher types.")e  # (defvar texinfo-lowersections-alist{   '((@chapter . @section)  i"     (@unnumbered . @unnumberedsec)     (@majorheading . @heading)     (@chapheading . @heading)v     (@appendix . @appendixsec)          (@section . @subsection)(     (@unnumberedsec . @unnumberedsubsec)     (@heading . @subheading)$     (@appendixsec . @appendixsubsec)     "     (@subsection . @subsubsection).     (@unnumberedsubsec . @unnumberedsubsubsec)"     (@subheading . @subsubheading)*     (@appendixsubsec . @appendixsubsubsec)     8     (@subsubsection . @subsubsection) ; Cannot go lower.1     (@unnumberedsubsubsec . @unnumberedsubsubsec)s%     (@subsubheading . @subsubheading)o.     (@appendixsubsubsec . @appendixsubsubsec))>   "*An alist of next lower levels for chapters, sections. etc.7 For example, chapter to section, section to subsection.X' Used by `texinfo-raise-lower-sections'. D The keys specify types of section; the values correspond to the next lower types.")   ,K ;;; Perform those texinfo-to-info conversions that apply to the whole inpute ;;; uniformly.   (defun texinfo-format-scan ()h2   (texinfo-format-convert (point-min) (point-max))   ;; Scan for @-commands.o   (goto-char (point-min))\#   (while (search-forward "@" nil t)       (if (looking-at "[@{}'` *]")@         ;; Handle a few special @-followed-by-one-char commands.#         (if (= (following-char) ?*)r             (progn               ;; remove command 7               (delete-region (1- (point)) (1+ (point))) 5               ;; insert return if not at end of line;--               ;; else line is already broken. 0               (if (not (= (following-char) ?\n))&                   (insert ?\n)))      C           ;; The other characters are simply quoted.  Delete the @.r           (delete-char -1)           (forward-char 1)) C       ;; @ is followed by a command-word; find the end of the word. /       (setq texinfo-command-start (1- (point)))3/       (if (= (char-syntax (following-char)) ?w)            (forward-word 1)         (forward-char 1)))(       (setq texinfo-command-end (point))+       ;; Call the handler for this command.d        (setq texinfo-command-name%             (intern (buffer-substringt>              (1+ texinfo-command-start) texinfo-command-end)))       (let ((enclosure-typee              (assoc 0               (symbol-name texinfo-command-name)'               texinfo-enclosure-list)))l         (if enclosure-type             (progn               (insertb0                (car (car (cdr enclosure-type))) *                (texinfo-parse-arg-discard)6                (car (cdr (car (cdr enclosure-type)))))0               (goto-char texinfo-command-start))A           (let ((cmd (get texinfo-command-name 'texinfo-format))) =             (if cmd (funcall cmd) (texinfo-unsupported)))))))       (cond (texinfo-stack0          (goto-char (nth 2 (car texinfo-stack)))@          (error "Unterminated @%s" (car (car texinfo-stack))))))  2 (put 'begin 'texinfo-format 'texinfo-format-begin) (defun texinfo-format-begin ()-   (texinfo-format-begin-end 'texinfo-format))   . (put 'end 'texinfo-format 'texinfo-format-end) (defun texinfo-format-end ()*   (texinfo-format-begin-end 'texinfo-end))  & (defun texinfo-format-begin-end (prop)?   (setq texinfo-command-name (intern (texinfo-parse-line-arg)));,   (setq cmd (get texinfo-command-name prop))   (if cmd (funcall cmd)r     (texinfo-unsupported)))    ;;; Parsing functionsc    (defun texinfo-parse-line-arg ()!   (goto-char texinfo-command-end)t   (let ((start (point)))     (cond ((looking-at " ");#            (skip-chars-forward " ")             (setq start (point))v            (end-of-line)$            (skip-chars-backward " ")@            (delete-region (point) (progn (end-of-line) (point)))3            (setq texinfo-command-end (1+ (point))))e           ((looking-at "{") $            (setq start (1+ (point)))            (forward-list 1)p-            (setq texinfo-command-end (point)).            (forward-char -1))s           (t9            (error "Invalid texinfo command arg format")))s+     (prog1 (buffer-substring start (point))@*            (if (eolp) (forward-char 1)))))  $ (defun texinfo-parse-expanded-arg ()!   (goto-char texinfo-command-end)f   (let ((start (point))d         marker)      (cond ((looking-at " ")i#            (skip-chars-forward " ")             (setq start (point))o            (end-of-line)3            (setq texinfo-command-end (1+ (point))))            ((looking-at "{")a$            (setq start (1+ (point)))            (forward-list 1)t-            (setq texinfo-command-end (point))             (forward-char -1))            (t9            (error "Invalid texinfo command arg format"))) A     (setq marker (move-marker (make-marker) texinfo-command-end)) 0     (texinfo-format-expand-region start (point))7     (setq texinfo-command-end (marker-position marker))      (move-marker marker nil)+     (prog1 (buffer-substring start (point))t*            (if (eolp) (forward-char 1)))))  / (defun texinfo-format-expand-region (start end)    (save-restrictionr      (narrow-to-region start end)     (let (texinfo-command-start            texinfo-command-end            texinfo-command-name           texinfo-stack)       (texinfo-format-scan))     (goto-char (point-max))))e  # (defun texinfo-parse-arg-discard () !   (prog1 (texinfo-parse-line-arg) $          (texinfo-discard-command)))  ! (defun texinfo-discard-command ()o<   (delete-region texinfo-command-start texinfo-command-end))  ) (defun texinfo-optional-braces-discard ()r-   "Discard braces following command, if any."^!   (goto-char texinfo-command-end)\   (let ((start (point)))4     (cond ((looking-at "[ \t]*\n"))     ; do nothing?           ((looking-at "{")             ; remove braces, if any(            (forward-list 1) .            (setq texinfo-command-end (point)))           (t            (errorsR             "Invalid `texinfo-optional-braces-discard' format \(need braces?\)")))?     (delete-region texinfo-command-start texinfo-command-end)))c  ( (defun texinfo-format-parse-line-args ()   (let ((start (1- (point)))         next beg end
         args)      (skip-chars-forward " ")     (while (not (eolp)))       (setq beg (point))!       (re-search-forward "[\n,]")        (setq next (point)) '       (if (bolp) (setq next (1- next)))        (forward-char -1)        (skip-chars-backward " ")        (setq end (point))B       (setq args (cons (if (> end beg) (buffer-substring beg end))                        args))l       (goto-char next)       (skip-chars-forward " "))       (if (eolp) (forward-char 1))&     (setq texinfo-command-end (point))     (nreverse args)))   # (defun texinfo-format-parse-args ()e   (let ((start (1- (point)))         next beg end
         args)n     (search-forward "{")     (save-excursionw$       (texinfo-format-expand-region         (point)2        (save-excursion (up-list 1) (1- (point)))))B     ;; The following does not handle cross references of the form::     ;; `@xref{bullet, , @code{@@bullet}@{@}}.' because theE     ;; re-search-forward finds the first right brace after the secondd     ;; comma. $     (while (/= (preceding-char) ?\})"       (skip-chars-forward " \t\n")       (setq beg (point))        (re-search-forward "[},]")       (setq next (point))@       (forward-char -1)o#       (skip-chars-backward " \t\n")p       (setq end (point))       (cond ((< beg end)              (goto-char beg)/              (while (search-forward "\n" end t)@%                (replace-match " "))))xB       (setq args (cons (if (> end beg) (buffer-substring beg end))                        args))        (goto-char next))       (if (eolp) (forward-char 1))&     (setq texinfo-command-end (point))     (nreverse args)))u  ) (defun texinfo-format-parse-defun-args ()d!   (goto-char texinfo-command-end)u   (let ((start (point)))     (end-of-line) +     (setq texinfo-command-end (1+ (point)))cC     (let ((marker (move-marker (make-marker) texinfo-command-end))) 2       (texinfo-format-expand-region start (point))9       (setq texinfo-command-end (marker-position marker))t       (move-marker marker nil))s     (goto-char start)h     (let ((args '())           beg end)       (skip-chars-forward " ")       (while (not (eolp))e         (cond ((looking-at "{")x&                (setq beg (1+ (point)))                (forward-list 1) '                (setq end (1- (point))))b               (t!                (setq beg (point)) *                (re-search-forward "[\n ]")                 (forward-char -1)#                (setq end (point))))n:         (setq args (cons (buffer-substring beg end) args))!         (skip-chars-forward " "))a       (forward-char 1)       (nreverse args))))   (defun texinfo-discard-line ()!   (goto-char texinfo-command-end)d   (skip-chars-forward " \t")   (or (eolp)8       (error "Extraneous text at end of command line."))#   (goto-char texinfo-command-start)n   (or (bolp)>       (error "Extraneous text at beginning of command line."));   (delete-region (point) (progn (forward-line 1) (point))))e  ( (defun texinfo-discard-line-with-args ()#   (goto-char texinfo-command-start) ;   (delete-region (point) (progn (forward-line 1) (point))))t   o ;;; @setfilename  > ;; Only `texinfo-format-buffer' handles @setfilename with thisD ;; definition; `texinfo-format-region' handles @setfilename, if any, ;; specially. > (put 'setfilename 'texinfo-format 'texinfo-format-setfilename)$ (defun texinfo-format-setfilename ()*   (let ((arg (texinfo-parse-arg-discard))),     (message "Formatting Info file: %s" arg)!     (setq texinfo-format-filename :           (file-name-nondirectory (expand-file-name arg)))     (insert "Info file: "n7             texinfo-format-filename ",    -*-Text-*-\n" H             ;; Date string removed so that regression testing is easier.             ;; "produced on " 9             ;; (substring (current-time-string) 8 10) " " 8             ;; (substring (current-time-string) 4 7) " "8             ;; (substring (current-time-string) -4)  " "3             "produced by `texinfo-format-buffer'\n"              "from file" /             (if (buffer-file-name input-buffer)o                 (concat " `"0                         (file-name-sans-versions0                          (file-name-nondirectory;                           (buffer-file-name input-buffer)))m                         "'")A               (concat "buffer `" (buffer-name input-buffer) "'"))o,             "\nusing `texinfmt.el' version "             texinfmt-version             ".\n\n"))) n ;;; @node, @menu  0 (put 'node 'texinfo-format 'texinfo-format-node)2 (put 'nwnode 'texinfo-format 'texinfo-format-node) (defun texinfo-format-node ()r0   (let* ((args (texinfo-format-parse-line-args))          (name (nth 0 args))          (next (nth 1 args))          (prev (nth 2 args))          (up (nth 3 args)))c     (texinfo-discard-command) !     (setq texinfo-last-node name)       (let ((tem (downcase name)))(       (if (assoc tem texinfo-node-names)0           (error "Duplicate node name: %s" name)H         (setq texinfo-node-names (cons (list tem) texinfo-node-names))))$     (setq texinfo-footnote-number 0)     (or (bolp)         (insert ?\n))n1     (insert "\^_\nFile: " texinfo-format-filenamex             ", Node: " name)     (if next!         (insert ", Next: " next))      (if prev!         (insert ", Prev: " prev))s
     (if up         (insert ", Up: " up))m     (insert ?\n)*     (setq texinfo-last-node-pos (point))))  0 (put 'menu 'texinfo-format 'texinfo-format-menu) (defun texinfo-format-menu ()-   (texinfo-discard-line)   (insert "* Menu:\n\n"))   1 (put 'menu 'texinfo-end 'texinfo-discard-command)f   d ;;; Cross references  + ; @xref {NODE, FNAME, NAME, FILE, DOCUMENT}  ; -> *Note FNAME: (FILE)NODE ;   If FILE is missing,r ;    *Note FNAME: NODE) ;   If FNAME is empty and NAME is presentn ;    *Note NAME: Noden& ;   If both NAME and FNAME are missing ;    *Note NODE::t* ;   texinfo ignores the DOCUMENT argument.F ; -> See section <xref to NODE> [NAME, else NODE], page <xref to NODE>7 ;   If FILE is specified, (FILE)NODE is used for xrefs.o5 ;   If fifth argument DOCUMENT is specified, producessF ;    See section <xref to NODE> [NAME, else NODE], page <xref to NODE> ;    of DOCUMENT  B ; @ref             a reference that does not put `See' or `see' in@ ;                  the hardcopy and is the same as @xref in Info/ (put 'ref 'texinfo-format 'texinfo-format-xref)n  0 (put 'xref 'texinfo-format 'texinfo-format-xref) (defun texinfo-format-xref () +   (let ((args (texinfo-format-parse-args)))e     (texinfo-discard-command)      (insert "*Note ") 1     (let ((fname (or (nth 1 args) (nth 2 args)))) (       (if (null (or fname (nth 3 args)))"           (insert (car args) "::")+         (insert (or fname (car args)) ": ")m         (if (nth 3 args)*             (insert "(" (nth 3 args) ")"))         (insert (car args))))))   2 (put 'pxref 'texinfo-format 'texinfo-format-pxref) (defun texinfo-format-pxref ()   (texinfo-format-xref)t   (or (save-excursion(         (forward-char -2))         (looking-at "::"))       (insert ".")))   ;@inforef{NODE, FNAME, FILE}* ;Like @xref{NODE, FNAME,,FILE} in texinfo.2 ;In Tex, generates "See Info file FILE, node NODE"6 (put 'inforef 'texinfo-format 'texinfo-format-inforef)  (defun texinfo-format-inforef ()+   (let ((args (texinfo-format-parse-args)))o     (texinfo-discard-command)1     (if (nth 1 args)H         (insert "*Note " (nth 1 args) ": (" (nth 2 args) ")" (car args))?       (insert "*Note " "(" (nth 2 args) ")" (car args) "::"))))d     ;;; Section headings  ; (put 'majorheading 'texinfo-format 'texinfo-format-chapter)n: (put 'chapheading 'texinfo-format 'texinfo-format-chapter)7 (put 'ichapter 'texinfo-format 'texinfo-format-chapter)i6 (put 'chapter 'texinfo-format 'texinfo-format-chapter)8 (put 'iappendix 'texinfo-format 'texinfo-format-chapter)7 (put 'appendix 'texinfo-format 'texinfo-format-chapter) : (put 'iunnumbered 'texinfo-format 'texinfo-format-chapter)2 (put 'top 'texinfo-format 'texinfo-format-chapter)9 (put 'unnumbered 'texinfo-format 'texinfo-format-chapter)x  (defun texinfo-format-chapter ()    (texinfo-format-chapter-1 ?*))  6 (put 'heading 'texinfo-format 'texinfo-format-section)7 (put 'isection 'texinfo-format 'texinfo-format-section) 6 (put 'section 'texinfo-format 'texinfo-format-section)? (put 'iappendixsection 'texinfo-format 'texinfo-format-section)a> (put 'appendixsection 'texinfo-format 'texinfo-format-section); (put 'iappendixsec 'texinfo-format 'texinfo-format-section)b: (put 'appendixsec 'texinfo-format 'texinfo-format-section)= (put 'iunnumberedsec 'texinfo-format 'texinfo-format-section)-< (put 'unnumberedsec 'texinfo-format 'texinfo-format-section)  (defun texinfo-format-section ()    (texinfo-format-chapter-1 ?=))  < (put 'subheading 'texinfo-format 'texinfo-format-subsection)= (put 'isubsection 'texinfo-format 'texinfo-format-subsection)d< (put 'subsection 'texinfo-format 'texinfo-format-subsection)A (put 'iappendixsubsec 'texinfo-format 'texinfo-format-subsection)e@ (put 'appendixsubsec 'texinfo-format 'texinfo-format-subsection)C (put 'iunnumberedsubsec 'texinfo-format 'texinfo-format-subsection)tB (put 'unnumberedsubsec 'texinfo-format 'texinfo-format-subsection)# (defun texinfo-format-subsection ()     (texinfo-format-chapter-1 ?-))  B (put 'subsubheading 'texinfo-format 'texinfo-format-subsubsection)C (put 'isubsubsection 'texinfo-format 'texinfo-format-subsubsection) B (put 'subsubsection 'texinfo-format 'texinfo-format-subsubsection)G (put 'iappendixsubsubsec 'texinfo-format 'texinfo-format-subsubsection))F (put 'appendixsubsubsec 'texinfo-format 'texinfo-format-subsubsection)I (put 'iunnumberedsubsubsec 'texinfo-format 'texinfo-format-subsubsection)oH (put 'unnumberedsubsubsec 'texinfo-format 'texinfo-format-subsubsection)& (defun texinfo-format-subsubsection ()    (texinfo-format-chapter-1 ?.))  + (defun texinfo-format-chapter-1 (belowchar)d*   (let ((arg (texinfo-parse-arg-discard)))G     (message "Formatting: %s ... " arg)   ; So we can see where we are.d5     (insert ?\n arg ?\n "@SectionPAD " belowchar ?\n)i     (forward-line -2)))-  < (put 'SectionPAD 'texinfo-format 'texinfo-format-sectionpad)# (defun texinfo-format-sectionpad () *   (let ((str (texinfo-parse-arg-discard)))     (forward-char -1))$     (let ((column (current-column)))       (forward-char 1)       (while (> column 0)(         (insert str)#         (setq column (1- column))))      (insert ?\n)))   ), ;;; Space controling commands:  @. and @:   , (put '\. 'texinfo-format 'texinfo-format-\.) (defun texinfo-format-\. ()w   (texinfo-discard-command)(   (insert ".")))  , (put '\: 'texinfo-format 'texinfo-format-\:) (defun texinfo-format-\: ()-   (texinfo-discard-command))   d ;;; @center, @sp, and @brr  4 (put 'center 'texinfo-format 'texinfo-format-center) (defun texinfo-format-center ()r+   (let ((arg (texinfo-parse-expanded-arg)))"     (texinfo-discard-command)n     (insert arg)     (insert ?\n)     (save-restrictionl       (goto-char (1- (point)))#       (let ((indent-tabs-mode nil))          (center-line)))))g  , (put 'sp 'texinfo-format 'texinfo-format-sp) (defun texinfo-format-sp () *   (let* ((arg (texinfo-parse-arg-discard))          (num (read arg)))     (insert-char ?\n num)))o  9 (put 'br 'texinfo-format 'texinfo-format-paragraph-break) ( (defun texinfo-format-paragraph-break ()   "Force a paragraph break.@1 If used within a line, follow `@br' with braces."n#   (texinfo-optional-braces-discard)e)   ;; insert one return if at end of line;m7   ;; else insert two returns, to generate a blank line.s   (if (= (following-char) ?\n)       (insert ?\n)     (insert-char ?\n 2)))    f" ;;; @footnote  and  @footnotestyle  A ; In Texinfo, footnotes are created with the `@footnote' command.lK ; This command is followed immediately by a left brace, then by the text ofs; ; the footnote, and then by a terminating right brace.  The  ; template for a footnote is:m ;  ;      @footnote{TEXT} ;  ; Info has two footnote styles:i ; D ;    * In the End of node style, all the footnotes for a single node= ;      are placed at the end of that node.  The footnotes are C ;      separated from the rest of the node by a line of dashes with & ;      the word `Footnotes' within it. ; F ;    * In the Separate node style, all the footnotes for a single nodeD ;      are placed in an automatically constructed node of their own.  C ; Footnote style is specified by the @footnotestyle command, eithern ;    @footnotestyle separate ; or ;    @footnotestyle endv ;  ; The default is  separate  * (defvar texinfo-footnote-style "separate" ,   "Footnote style, either separate or end.")  ; (put 'footnotestyle 'texinfo-format 'texinfo-footnotestyle)) (defun texinfo-footnotestyle () E   "Specify whether footnotes are at end of node or in separate nodes. $ Argument is either end or separate."<   (setq texinfo-footnote-style (texinfo-parse-arg-discard)))    (defvar texinfo-footnote-number)  8 (put 'footnote 'texinfo-format 'texinfo-format-footnote)! (defun texinfo-format-footnote ()dB   "Format a footnote in either end of node or separate node style.E The   texinfo-footnote-style  variable controls which style is used."s=   (setq texinfo-footnote-number (1+ texinfo-footnote-number)) /   (cond ((string= texinfo-footnote-style "end")f#          (texinfo-format-end-node)))4         ((string= texinfo-footnote-style "separate")*          (texinfo-format-separate-node))))  & (defun texinfo-format-separate-node ()B   "Format footnote in Separate node style, with notes in own node.' The node is constructed automatically."m   (let* (start'          (arg (texinfo-parse-line-arg))a          (node-name-beginningn           (save-excursion-             (re-search-backward A              "^File: \\w+\\(\\w\\|\\s_\\|\\.\\|,\\)*[ \t]+Node:")E             (match-end 0))))          (node-namem           (save-excursion              (buffer-substring L              (progn (goto-char node-name-beginning) ; skip over node commandA                     (skip-chars-forward " \t")  ; and over spaces                      (point))               (if (search-forward                   ","sJ                   (save-excursion (end-of-line) (point)) t) ; bound search                  (1- (point))s)                (end-of-line) (point))))))gG     (texinfo-discard-command)  ; remove or insert whitespace, as needed I     (delete-region (save-excursion (skip-chars-backward " \t\n") (point))s                    (point))e2     (insert (format " (%d) (*Note %s-Footnotes::)"7                     texinfo-footnote-number node-name))f     (fill-paragraph nil)     (save-excursiona.     (if (re-search-forward "^@node" nil 'move)         (forward-line -1))  G     ;; two cases: for the first footnote, we must insert a node header;hD     ;; for the second and subsequent footnotes, we need only insert !     ;; the text of the  footnote.        (if (save-excursioni          (re-search-backward/           (concat node-name "-Footnotes, Up: ")t           node-name-beginningx
           t))x0         (progn   ; already at least one footnote           (setq start (point))F           (insert (format "\n(%d)  %s\n" texinfo-footnote-number arg))&           (fill-region start (point)))        ;; else not yet a footnote6       (insert "\n\^_\nFile: "  texinfo-format-filenameE               "  Node: " node-name "-Footnotes, Up: " node-name "\n")-       (setq start (point))B       (insert (format "\n(%d)  %s\n" texinfo-footnote-number arg))%       (fill-region start (point))))))"  ! (defun texinfo-format-end-node ()(H   "Format footnote in the End of node style, with notes at end of node."
   (let (starte'         (arg (texinfo-parse-line-arg)))iG     (texinfo-discard-command)  ; remove or insert whitespace, as neededtI     (delete-region (save-excursion (skip-chars-backward " \t\n") (point))t                    (point))f6     (insert (format " (%d) " texinfo-footnote-number))     (fill-paragraph nil)     (save-excursionxD       (if (search-forward "\n--------- Footnotes ---------\n" nil t)H           (progn ; already have footnote, put new one before end of node6             (if (re-search-forward "^@node" nil 'move)"                 (forward-line -1))              (setq start (point))H             (insert (format "\n(%d)  %s\n" texinfo-footnote-number arg))(             (fill-region start (point)))!         ;; else no prior footnoteo2         (if (re-search-forward "^@node" nil 'move)             (forward-line -1))4         (insert "\n--------- Footnotes ---------\n")         (setq start (point))H         (insert (format "\n(%d)  %s\n" texinfo-footnote-number arg))))))   x. ;;; @itemize, @enumerate, and similar commands  B ;; @itemize pushes (itemize "COMMANDS" STARTPOS) on texinfo-stack., ;; @enumerate pushes (enumerate 0 STARTPOS).J ;; @item dispatches to the texinfo-item prop of the first elt of the list.6 ;; For itemize, this puts in and rescans the COMMANDS.< ;; For enumerate, this increments the number and puts it in.? ;; In either case, it puts a Backspace at the front of the linep+ ;; which marks it not to be indented later.f> ;; All other lines get indented by 5 when the @end is reached.   (defvar texinfo-stack-depth 0m8   "Count of number of unpopped texinfo-push-stack calls.I Used by @refill indenting command to avoid indenting within lists, etc.")t  % (defun texinfo-push-stack (check arg)f5   (setq texinfo-stack-depth (1+ texinfo-stack-depth))r   (setq texinfo-stacks4         (cons (list check arg texinfo-command-start)               texinfo-stack)))    (defun texinfo-pop-stack (check)5   (setq texinfo-stack-depth (1- texinfo-stack-depth))e   (if (null texinfo-stack)(       (error "Unmatched @end %s" check))0   (if (not (eq (car (car texinfo-stack)) check))"       (error "@end %s matches @%s".              check (car (car texinfo-stack))))"   (prog1 (cdr (car texinfo-stack))3          (setq texinfo-stack (cdr texinfo-stack))))s  / (put 'itemize 'texinfo-format 'texinfo-itemize)d (defun texinfo-itemize ()-   (texinfo-push-stack(    'itemize-$    (progn (skip-chars-forward " \t")           (if (eolp)               "@bullet" '             (texinfo-parse-line-arg))))o"   (texinfo-discard-line-with-args)'   (setq fill-column (- fill-column 5)))-  0 (put 'itemize 'texinfo-end 'texinfo-end-itemize) (defun texinfo-end-itemize ()s&   (setq fill-column (+ fill-column 5))   (texinfo-discard-command)c   (let ((stacktopm'          (texinfo-pop-stack 'itemize)))e+     (texinfo-do-itemize (nth 1 stacktop))))   3 (put 'enumerate 'texinfo-format 'texinfo-enumerate)  (defun texinfo-enumerate ():   (texinfo-push-stack.    'enumerate $    (progn (skip-chars-forward " \t")           (if (eolp)               1d&             (read (current-buffer)))))4   (if (and (symbolp (car (cdr (car texinfo-stack))))H            (> 1 (length (symbol-name (car (cdr (car texinfo-stack)))))))       (errorH        "@enumerate: Use a number or letter, eg: 1, A, a, 3, B, or d." ))"   (texinfo-discard-line-with-args)'   (setq fill-column (- fill-column 5)))   4 (put 'enumerate 'texinfo-end 'texinfo-end-enumerate) (defun texinfo-end-enumerate () &   (setq fill-column (+ fill-column 5))   (texinfo-discard-command)p   (let ((stacktopm)          (texinfo-pop-stack 'enumerate)))a+     (texinfo-do-itemize (nth 1 stacktop))))s  : ;; @alphaenumerate never became a standard part of Texinfo= (put 'alphaenumerate 'texinfo-format 'texinfo-alphaenumerate)   (defun texinfo-alphaenumerate ().   (texinfo-push-stack 'alphaenumerate (1- ?a))&   (setq fill-column (- fill-column 5))   (texinfo-discard-line))c  > (put 'alphaenumerate 'texinfo-end 'texinfo-end-alphaenumerate)$ (defun texinfo-end-alphaenumerate ()&   (setq fill-column (+ fill-column 5))   (texinfo-discard-command)i   (let ((stacktop .          (texinfo-pop-stack 'alphaenumerate)))+     (texinfo-do-itemize (nth 1 stacktop))))f  9 ;; @capsenumerate never became a standard part of Texinfo ; (put 'capsenumerate 'texinfo-format 'texinfo-capsenumerate)b (defun texinfo-capsenumerate () -   (texinfo-push-stack 'capsenumerate (1- ?A))o&   (setq fill-column (- fill-column 5))   (texinfo-discard-line))h  < (put 'capsenumerate 'texinfo-end 'texinfo-end-capsenumerate)# (defun texinfo-end-capsenumerate () &   (setq fill-column (+ fill-column 5))   (texinfo-discard-command)i   (let ((stacktop -          (texinfo-pop-stack 'capsenumerate))) +     (texinfo-do-itemize (nth 1 stacktop))))t  9 ;; At the @end, indent all the lines within the constructo7 ;; except those marked with backspace.  FROM says wheref ;; construct started.l  (defun texinfo-do-itemize (from)   (save-excursionr"    (while (progn (forward-line -1)#                  (>= (point) from))i!      (if (= (following-char) ?\b)F          (save-excursion            (delete-char 1)            (end-of-line)            (delete-char 6))f'        (if (not (looking-at "[ \t]*$"))w1            (save-excursion (insert "     ")))))))n  ) (put 'item 'texinfo-format 'texinfo-item) * (put 'itemx 'texinfo-format 'texinfo-item) (defun texinfo-item ():   (funcall (get (car (car texinfo-stack)) 'texinfo-item)))  2 (put 'itemize 'texinfo-item 'texinfo-itemize-item) (defun texinfo-itemize-item ()J   ;; (texinfo-discard-line)   ; Did not handle text on same line as @item.K   (delete-region (1+ (point)) (save-excursion (beginning-of-line) (point)))1$   (if (looking-at "[ \t]*[^ \t\n]+"),       ;; Text on same line as @item command.8       (insert "\b   " (nth 1 (car texinfo-stack)) " \n")     ;; Else text on next line.5     (insert "\b   " (nth 1 (car texinfo-stack)) " "))n   (forward-line -1))  6 (put 'enumerate 'texinfo-item 'texinfo-enumerate-item)  (defun texinfo-enumerate-item ()   (texinfo-discard-line)   (let (enumerating-symbol)t5     (cond ((integerp (car (cdr (car texinfo-stack))))nD            (setq enumerating-symbol (car (cdr (car texinfo-stack))))?            (insert ?\b (format "%3d. " enumerating-symbol) ?\n) F            (setcar (cdr (car texinfo-stack)) (1+ enumerating-symbol)))4           ((symbolp (car (cdr (car texinfo-stack))))#            (setq enumerating-symbolk?                  (symbol-name (car (cdr (car texinfo-stack)))))tB            (if (or (equal ?\[ (string-to-char enumerating-symbol))C                    (equal ?\{ (string-to-char enumerating-symbol)))x                (errorpJ                 "Too many items in enumerated list; alphabet ends at Z."))?            (insert ?\b (format "%3s. " enumerating-symbol) ?\n) ,            (setcar (cdr (car texinfo-stack))                    (make-symbols#                     (char-to-string                       (1+ i>                       (string-to-char enumerating-symbol))))))           (t           (errorL            "@enumerate: Use a number or letter, eg: 1, A, a, 3, B or d." )))     (forward-line -1)))   @ (put 'alphaenumerate 'texinfo-item 'texinfo-alphaenumerate-item)% (defun texinfo-alphaenumerate-item ()    (texinfo-discard-line)4   (let ((next (1+ (car (cdr (car texinfo-stack))))))     (if (> next ?z) P         (error "More than 26 items in @alphaenumerate; get a bigger alphabet."))+     (setcar (cdr (car texinfo-stack)) next)-      (insert "\b  " next ". \n"))   (forward-line -1))  > (put 'capsenumerate 'texinfo-item 'texinfo-capsenumerate-item)$ (defun texinfo-capsenumerate-item ()   (texinfo-discard-line)4   (let ((next (1+ (car (cdr (car texinfo-stack))))))     (if (> next ?Z) O         (error "More than 26 items in @capsenumerate; get a bigger alphabet."))a+     (setcar (cdr (car texinfo-stack)) next)       (insert "\b  " next ". \n"))   (forward-line -1))   x
 ;;; @table  2 ; The `@table' command produces two-column tables.  + (put 'table 'texinfo-format 'texinfo-table)a (defun texinfo-table ()n   (texinfo-push-stack 
    'table $    (progn (skip-chars-forward " \t")           (if (eolp)               "@asis"c'             (texinfo-parse-line-arg))))s"   (texinfo-discard-line-with-args)'   (setq fill-column (- fill-column 5)))o  . (put 'table 'texinfo-item 'texinfo-table-item) (defun texinfo-table-item ())   (let ((arg (texinfo-parse-arg-discard)) 3         (itemfont (car (cdr (car texinfo-stack)))))-/     (insert ?\b itemfont ?\{ arg "}\n     \n"))n   (forward-line -2))  , (put 'table 'texinfo-end 'texinfo-end-table) (defun texinfo-end-table ()e&   (setq fill-column (+ fill-column 5))   (texinfo-discard-command)t   (let ((stacktop %          (texinfo-pop-stack 'table)))x+     (texinfo-do-itemize (nth 1 stacktop))))-  D ;; @description appears to be an undocumented variant on @table thatD ;; does not require an arg.  It fails in texinfo.tex 2.58 and is notF ;; part of makeinfo.c   The command appears to be a relic of the past.2 (put 'description 'texinfo-end 'texinfo-end-table)7 (put 'description 'texinfo-format 'texinfo-description)e (defun texinfo-description () %   (texinfo-push-stack 'table "@asis")"&   (setq fill-column (- fill-column 5))   (texinfo-discard-line))R   . ;;; @ftable, @vtable  D ; The `@ftable' and `@vtable' commands are like the `@table' commandB ; but they also insert each entry in the first column of the table& ; into the function or variable index.  + ;; Handle the @ftable and @vtable commands:f  - (put 'ftable 'texinfo-format 'texinfo-ftable)l- (put 'vtable 'texinfo-format 'texinfo-vtable)e  6 (defun texinfo-ftable () (texinfo-indextable 'ftable))6 (defun texinfo-vtable () (texinfo-indextable 'vtable))  & (defun texinfo-indextable (table-type)=   (texinfo-push-stack table-type (texinfo-parse-arg-discard)) '   (setq fill-column (- fill-column 5)))   6 ;; Handle the @item commands within ftable and vtable:  0 (put 'ftable 'texinfo-item 'texinfo-ftable-item)0 (put 'vtable 'texinfo-item 'texinfo-vtable-item)  H (defun texinfo-ftable-item () (texinfo-indextable-item 'texinfo-findex))H (defun texinfo-vtable-item () (texinfo-indextable-item 'texinfo-vindex))  + (defun texinfo-indextable-item (index-type)e*   (let ((item (texinfo-parse-arg-discard))2         (itemfont (car (cdr (car texinfo-stack))))         (indexvar index-type))/     (insert ?\b itemfont ?\{ item "}\n     \n")m     (set indexvar           (cons'           (list item texinfo-last-node)o#           (symbol-value indexvar)))      (forward-line -2))))  " ;; Handle @end ftable, @end vtable  . (put 'ftable 'texinfo-end 'texinfo-end-ftable). (put 'vtable 'texinfo-end 'texinfo-end-vtable)  > (defun texinfo-end-ftable () (texinfo-end-indextable 'ftable))> (defun texinfo-end-vtable () (texinfo-end-indextable 'vtable))  * (defun texinfo-end-indextable (table-type)&   (setq fill-column (+ fill-column 5))   (texinfo-discard-command))   (let ((stacktop-)          (texinfo-pop-stack table-type)))r+     (texinfo-do-itemize (nth 1 stacktop))))f   x ;;; @ifinfo,  @iftex, @tex  3 (put 'ifinfo 'texinfo-format 'texinfo-discard-line)o3 (put 'ifinfo 'texinfo-end 'texinfo-discard-command)   2 (put 'iftex 'texinfo-format 'texinfo-format-iftex) (defun texinfo-format-iftex ()&   (delete-region texinfo-command-start@                  (progn (re-search-forward "@end iftex[ \t]*\n")"                         (point))))  . (put 'tex 'texinfo-format 'texinfo-format-tex) (defun texinfo-format-tex ()&   (delete-region texinfo-command-start>                  (progn (re-search-forward "@end tex[ \t]*\n")"                         (point))))   o ;;; @titlepage  : (put 'titlepage 'texinfo-format 'texinfo-format-titlepage)" (defun texinfo-format-titlepage ()&   (delete-region texinfo-command-startD                  (progn (re-search-forward "@end titlepage[ \t]*\n")"                         (point))))  9 (put 'endtitlepage 'texinfo-format 'texinfo-discard-line)p  D ; @titlespec         an alternative titling command; ignored by Info  : (put 'titlespec 'texinfo-format 'texinfo-format-titlespec)" (defun texinfo-format-titlespec ()&   (delete-region texinfo-command-startD                  (progn (re-search-forward "@end titlespec[ \t]*\n")"                         (point))))  9 (put 'endtitlespec 'texinfo-format 'texinfo-discard-line)s   o
 ;;; @today  2 (put 'today 'texinfo-format 'texinfo-format-today)  ; ; Produces Day Month Year style of output.  eg `1 Jan 1900'bC ; The `@today{}' command requires a pair of braces, like `@dots{}'.a (defun texinfo-format-today ()   (texinfo-parse-arg-discard)o   (insert (format "%s %s %s"0           (substring (current-time-string) 8 10)/           (substring (current-time-string) 4 7)i1           (substring (current-time-string) -4))))m   i ;;; @ignorea  4 (put 'ignore 'texinfo-format 'texinfo-format-ignore) (defun texinfo-format-ignore ()a&   (delete-region texinfo-command-startA                  (progn (re-search-forward "@end ignore[ \t]*\n")p"                         (point))))  6 (put 'endignore 'texinfo-format 'texinfo-discard-line)   r6 ;;; Define the Info enclosure command: @definfoenclose  B ; A `@definfoenclose' command may be used to define a highlighting= ; command for Info, but not for TeX.  A command defined using)F ; `@definfoenclose' marks text by enclosing it in strings that precede ; and follow the text. ; F ; Presumably, if you define a command with `@definfoenclose` for Info,D ; you will also define the same command in the TeX definitions file,8 ; `texinfo.tex' in a manner appropriate for typesetting. ; F ; Write a `@definfoenclose' command on a line and follow it with threeD ; arguments separated by commas (commas are used as separators in an7 ; `@node' line in the same way).  The first argument tosB ; `@definfoenclose' is the @-command name \(without the `@'\); theC ; second argument is the Info start delimiter string; and the third F ; argument is the Info end delimiter string.  The latter two argumentsD ; enclose the highlighted text in the Info file.  A delimiter string= ; may contain spaces.  Neither the start nor end delimiter is)B ; required.  However, if you do not provide a start delimiter, youC ; must follow the command name with two commas in a row; otherwise,tB ; the Info formatting commands will misinterpret the end delimiter% ; string as a start delimiter string.m ; E ; An enclosure command defined this way takes one argument in braces.s ;k ; For example, you can write:  ; 
 ;     @ifinfoc" ;     @definfoenclose phoo, //, \\ ;     @end ifinfoa ;gD ; near the beginning of a Texinfo file at the beginning of the linesC ; to define `@phoo' as an Info formatting command that inserts `//'lD ; before and `\\' after the argument to `@phoo'.  You can then write? ; `@phoo{bar}' wherever you want `//bar\\' highlighted in Info.u ;a, ; Also, for TeX formatting, you could write  ;e ;     @iftex ;     @global@let@phoo=@i) ;     @end iftex ;e; ; to define `@phoo' as a command that causes TeX to typeseto% ; the argument to `@phoo' in italics.  ; F ; Note that each definition applies to its own formatter: one for TeX,? ; the other for texinfo-format-buffer or texinfo-format-region.u ;a  ; Here is another example: write ; # ;     @definfoenclose headword, , :  ;)B ; near the beginning of the file, to define `@headword' as an InfoF ; formatting command that inserts nothing before and a colon after the ; argument to `@headword'.  D (put 'definfoenclose 'texinfo-format 'texinfo-define-info-enclosure)' (defun texinfo-define-info-enclosure () 0   (let* ((args (texinfo-format-parse-line-args))$          (command-name (nth 0 args))3          (beginning-delimiter (or (nth 1 args) ""))x.          (end-delimiter (or (nth 2 args) "")))     (texinfo-discard-command)       (setq texinfo-enclosure-list
         (consd          (list command-name                 (list#                 beginning-delimiterc                 end-delimiter))e#          texinfo-enclosure-list))))-   ) ;;; @var, @code and the like  . (put 'var 'texinfo-format 'texinfo-format-var)= ;  @sc  a small caps font for TeX; formatted as `var' in Infot- (put 'sc 'texinfo-format 'texinfo-format-var)n (defun texinfo-format-var ()/   (insert (upcase (texinfo-parse-arg-discard)))o$   (goto-char texinfo-command-start))   ; various noopsc  - (put 'b 'texinfo-format 'texinfo-format-noop)x- (put 'i 'texinfo-format 'texinfo-format-noop)m- (put 'r 'texinfo-format 'texinfo-format-noop)i- (put 't 'texinfo-format 'texinfo-format-noop)i- (put 'w 'texinfo-format 'texinfo-format-noop))0 (put 'asis 'texinfo-format 'texinfo-format-noop)/ (put 'dmn 'texinfo-format 'texinfo-format-noop) / (put 'key 'texinfo-format 'texinfo-format-noop)n0 (put 'math 'texinfo-format 'texinfo-format-noop)5 (put 'titlefont 'texinfo-format 'texinfo-format-noop)n (defun texinfo-format-noop ()s&   (insert (texinfo-parse-arg-discard))$   (goto-char texinfo-command-start))  0 (put 'cite 'texinfo-format 'texinfo-format-code)0 (put 'code 'texinfo-format 'texinfo-format-code)0 (put 'file 'texinfo-format 'texinfo-format-code)/ (put 'kbd 'texinfo-format 'texinfo-format-code)r0 (put 'samp 'texinfo-format 'texinfo-format-code) (defun texinfo-format-code () .   (insert "`" (texinfo-parse-arg-discard) "'")$   (goto-char texinfo-command-start))  0 (put 'emph 'texinfo-format 'texinfo-format-emph)2 (put 'strong 'texinfo-format 'texinfo-format-emph) (defun texinfo-format-emph ()b.   (insert "*" (texinfo-parse-arg-discard) "*")$   (goto-char texinfo-command-start))  / (put 'dfn 'texinfo-format 'texinfo-format-defn)t0 (put 'defn 'texinfo-format 'texinfo-format-defn) (defun texinfo-format-defn () 0   (insert "\"" (texinfo-parse-arg-discard) "\"")$   (goto-char texinfo-command-start))  4 (put 'bullet 'texinfo-format 'texinfo-format-bullet) (defun texinfo-format-bullet ()x   "Insert an asterisk.5 If used within a line, follow `@bullet' with braces."e#   (texinfo-optional-braces-discard)y   (insert "*"))-   iD ;;; @example, @lisp, @quotation, @display, @smalllisp, @smallexample  6 (put 'display 'texinfo-format 'texinfo-format-example)6 (put 'example 'texinfo-format 'texinfo-format-example)3 (put 'lisp 'texinfo-format 'texinfo-format-example)t8 (put 'quotation 'texinfo-format 'texinfo-format-example); (put 'smallexample 'texinfo-format 'texinfo-format-example)x8 (put 'smalllisp 'texinfo-format 'texinfo-format-example)  (defun texinfo-format-example ()#   (texinfo-push-stack 'example nil)t&   (setq fill-column (- fill-column 5))   (texinfo-discard-line))t  0 (put 'example 'texinfo-end 'texinfo-end-example)0 (put 'display 'texinfo-end 'texinfo-end-example)- (put 'lisp 'texinfo-end 'texinfo-end-example) 2 (put 'quotation 'texinfo-end 'texinfo-end-example)5 (put 'smallexample 'texinfo-end 'texinfo-end-example)l2 (put 'smalllisp 'texinfo-end 'texinfo-end-example) (defun texinfo-end-example ()(&   (setq fill-column (+ fill-column 5))   (texinfo-discard-command)f   (let ((stacktopt'          (texinfo-pop-stack 'example)))t+     (texinfo-do-itemize (nth 1 stacktop))))n  4 (put 'exdent 'texinfo-format 'texinfo-format-exdent) (defun texinfo-format-exdent ()-   (texinfo-discard-command)m   (delete-region (point)                  (prognx*                   (skip-chars-forward " ")                   (point)))n   (insert ?\b)4   ;; Cancel out the deletion that texinfo-do-itemize,   ;; is going to do at the end of this line.   (save-excursionl     (end-of-line)c     (insert "\n     ")))   ( ;;; @cartouche f  @ ; The @cartouche command is a noop in Info; in a printed manual,& ; it makes a box with rounded corners.  6 (put 'cartouche 'texinfo-format 'texinfo-discard-line)6 (put 'cartouche 'texinfo-end 'texinfo-discard-command)   d ;;; @flushleft and @format  A ; The @flushleft command left justifies every line but leaves the A ; right end ragged.  As far as Info is concerned, @flushleft is ai ; `do-nothing' command  D ; The @format command is similar to @example except that it does notD ; indent; this means that in Info, @format is similar to @flushleft.  7 (put 'format 'texinfo-format 'texinfo-format-flushleft)t: (put 'flushleft 'texinfo-format 'texinfo-format-flushleft)" (defun texinfo-format-flushleft ()   (texinfo-discard-line))e  1 (put 'format 'texinfo-end 'texinfo-end-flushleft)i4 (put 'flushleft 'texinfo-end 'texinfo-end-flushleft) (defun texinfo-end-flushleft ()t   (texinfo-discard-command))   i ;;; @flushrightn  C ; The @flushright command right justifies every line but leaves the B ; left end ragged.  Spaces and tabs at the right ends of lines are: ; removed so that visible text lines up on the right side.  < (put 'flushright 'texinfo-format 'texinfo-format-flushright)# (defun texinfo-format-flushright ()p&   (texinfo-push-stack 'flushright nil)   (texinfo-discard-line))i  6 (put 'flushright 'texinfo-end 'texinfo-end-flushright)  (defun texinfo-end-flushright ()   (texinfo-discard-command)n     (let ((stacktop *          (texinfo-pop-stack 'flushright)))  .     (texinfo-do-flushright (nth 1 stacktop))))  # (defun texinfo-do-flushright (from)s   (save-excursion "    (while (progn (forward-line -1)#                  (>= (point) from))         (beginning-of-line)      (insert       (make-string        (- fill-columne           (save-excursionm             (end-of-line) '             (skip-chars-backward " \t")dA             (delete-region (point) (progn (end-of-line) (point)))n              (current-column)))          ? )))))   l* ;;; @ctrl, @TeX, @copyright, @minus, @dots  0 (put 'ctrl 'texinfo-format 'texinfo-format-ctrl) (defun texinfo-format-ctrl ()I*   (let ((str (texinfo-parse-arg-discard)))'     (insert (logand 31 (aref str 0)))))o  . (put 'TeX 'texinfo-format 'texinfo-format-TeX) (defun texinfo-format-TeX ()   (texinfo-parse-arg-discard)    (insert "TeX"))e  : (put 'copyright 'texinfo-format 'texinfo-format-copyright)" (defun texinfo-format-copyright ()   (texinfo-parse-arg-discard)f   (insert "(C)"))c  2 (put 'minus 'texinfo-format 'texinfo-format-minus) (defun texinfo-format-minus ()   "Insert a minus sign.r4 If used within a line, follow `@minus' with braces."#   (texinfo-optional-braces-discard)e   (insert "-"))o  0 (put 'dots 'texinfo-format 'texinfo-format-dots) (defun texinfo-format-dots ()t   (texinfo-parse-arg-discard)f   (insert "..."))    rB ;;; Refilling and indenting:  @refill, @paragraphindent, @noindent  D ;;; Indent only those paragraphs that are refilled as a result of an ;;; @refill command.    H ;    * If the value is `asis', do not change the existing indentation at  ;      the starts of paragraphs.  : ;    * If the value zero, delete any existing indentation.  G ;    * If the value is greater than zero, indent each paragraph by that  ;      number of spaces.  A ;;; But do not refill paragraphs with an @refill command that are A ;;; preceded by @noindent or are part of a table, list, or deffn..  ' (defvar texinfo-paragraph-indent "asis"eM   "Number of spaces for @refill to indent a paragraph; else to leave as is.")   ? (put 'paragraphindent 'texinfo-format 'texinfo-paragraphindent)e  ! (defun texinfo-paragraphindent ()aB   "Specify the number of spaces for @refill to indent a paragraph.0 Default is to leave the number of spaces as is."+   (let ((arg  (texinfo-parse-arg-discard)))e     (if (string= "asis" arg).         (setq texinfo-paragraph-indent "asis")<       (setq texinfo-paragraph-indent (string-to-int arg)))))  4 (put 'refill 'texinfo-format 'texinfo-format-refill) (defun texinfo-format-refill ()tH   "Refill paragraph. Also, indent first line as set by @paragraphindent.1 Default is to leave paragraph indentation as is."-   (texinfo-discard-command)n   (forward-paragraph -1)     (0   (if (looking-at "[ \t\n]*$") (forward-line 1)):   ;; Do not indent if an entry in a list, table, or deffn,.   ;; or if paragraph is preceded by @noindent.   ;; Otherwise, indent   (cond 9    ;; delete a @noindent line and do not indent paragraphr%    ((save-excursion (forward-line -1)c/                     (looking-at "^@noindent"))       (forward-line -1) =     (delete-region (point) (progn (forward-line 1) (point))))s    ;; do nothing if "asis",    ((equal texinfo-paragraph-indent "asis"))#    ;; do no indenting in list, etc.a!    ((> texinfo-stack-depth 0))    5    ;; otherwise delete existing whitespace and indentn    (t F     (delete-region (point) (progn (skip-chars-forward " \t") (point)))8     (insert (make-string texinfo-paragraph-indent ? ))))   (forward-paragraph 1)    (forward-line -1)p   (end-of-line)nH   ;; Do not fill a section title line with asterisks, hyphens, etc. thatF   ;; are used to underline it.  This could occur if the line followingB   ;; the underlining is not an index entry and has text within it.9   (let* ((previous-paragraph-separate paragraph-separate)pI          (paragraph-separate (concat paragraph-separate "\\|^[=*---.]+"))o3          (previous-paragraph-start paragraph-start)fD          (paragraph-start (concat paragraph-start "\\|^[=*---.]+")))     (unwind-protectd         (fill-paragraph nil);       (setq paragraph-separate previous-paragraph-separate)t8       (setq paragraph-start previous-paragraph-start))))  1 (put 'noindent 'texinfo-format 'texinfo-noindent)t (defun texinfo-noindent ()     (save-excursion      (forward-paragraph 1)i"     (if (search-backward "@refill"I                             (save-excursion (forward-line -1) (point)) t)tK         () ; leave @noindent command so @refill command knows not to indentp
       ;; elsei       (texinfo-discard-line))))    n ;;; Index generation  4 (put 'vindex 'texinfo-format 'texinfo-format-vindex) (defun texinfo-format-vindex () "   (texinfo-index 'texinfo-vindex))  4 (put 'cindex 'texinfo-format 'texinfo-format-cindex) (defun texinfo-format-cindex ()e"   (texinfo-index 'texinfo-cindex))  4 (put 'findex 'texinfo-format 'texinfo-format-findex) (defun texinfo-format-findex ()t"   (texinfo-index 'texinfo-findex))  4 (put 'pindex 'texinfo-format 'texinfo-format-pindex) (defun texinfo-format-pindex ()i"   (texinfo-index 'texinfo-pindex))  4 (put 'tindex 'texinfo-format 'texinfo-format-tindex) (defun texinfo-format-tindex ()l"   (texinfo-index 'texinfo-tindex))  4 (put 'kindex 'texinfo-format 'texinfo-format-kindex) (defun texinfo-format-kindex ()x"   (texinfo-index 'texinfo-kindex))   (defun texinfo-index (indexvar)t+   (let ((arg (texinfo-parse-expanded-arg))))     (texinfo-discard-command)o     (set indexvart          (cons (list arg&                      texinfo-last-nodeM                      ;; Region formatting may not provide last node position.s.                      (if texinfo-last-node-posI                          (1+ (count-lines texinfo-last-node-pos (point)))i                        1))*                (symbol-value indexvar)))))    (defconst texinfo-indexvar-alist   '(("cp" . texinfo-cindex)l     ("fn" . texinfo-findex)f     ("vr" . texinfo-vindex)      ("tp" . texinfo-tindex)'     ("pg" . texinfo-pindex)t     ("ky" . texinfo-kindex)))    c ;;; @defindex   @defcodeindexx8 (put 'defindex 'texinfo-format 'texinfo-format-defindex)< (put 'defcodeindex 'texinfo-format 'texinfo-format-defindex)  ! (defun texinfo-format-defindex ()o<   (let* ((index-name (texinfo-parse-arg-discard)) ; eg: `aa'@          (indexing-command (intern (concat index-name "index")))F          (index-formatting-command      ; eg: `texinfo-format-aaindex'A           (intern (concat "texinfo-format-" index-name "index")))a?          (index-alist-name              ; eg: `texinfo-aaindex'.;           (intern (concat "texinfo-" index-name "index"))))        (set index-alist-name nil)  5     (put indexing-command               ; eg, aaindexn          'texinfo-formatD          index-formatting-command)      ; eg, texinfo-format-aaindex  !     ;; eg: "aa" . texinfo-aaindex'1     (or (assoc index-name texinfo-indexvar-alist)@$         (setq texinfo-indexvar-alist               (conse                (cons index-nameg&                      index-alist-name)(                texinfo-indexvar-alist)))  "     (fset index-formatting-command           (list 'lambda 'nil%                 (list 'texinfo-index t9                       (list 'quote index-alist-name))))))'   f ;;; @synindex   @syncodeindexs  8 (put 'synindex 'texinfo-format 'texinfo-format-synindex)< (put 'syncodeindex 'texinfo-format 'texinfo-format-synindex)  ! (defun texinfo-format-synindex ()h+   (let* ((args (texinfo-parse-arg-discard))-/          (second (cdr (read-from-string args))) =          (joiner (symbol-name (car (read-from-string args))))fE          (joined (symbol-name (car (read-from-string args second)))))d  5     (if (assoc joiner texinfo-short-index-cmds-alist)          (put=           (cdr (assoc joiner texinfo-short-index-cmds-alist))t          'texinfo-formatG          (or (cdr (assoc joined texinfo-short-index-format-cmds-alist))-A              (intern (concat "texinfo-format-" joined "index"))))g
       (put'        (intern (concat joiner "index"))n        'texinfo-formatD        (or (cdr(assoc joined texinfo-short-index-format-cmds-alist))B            (intern (concat "texinfo-format-" joined "index")))))))  ( (defconst texinfo-short-index-cmds-alist   '(("cp" . cindex)      ("fn" . findex)w     ("vr" . vindex)      ("tp" . tindex)f     ("pg" . pindex)n     ("ky" . kindex)))e  / (defconst texinfo-short-index-format-cmds-alist "   '(("cp" . texinfo-format-cindex)"     ("fn" . texinfo-format-findex)"     ("vr" . texinfo-format-vindex)"     ("tp" . texinfo-format-tindex)"     ("pg" . texinfo-format-pindex)$     ("ky" . texinfo-format-kindex)))   c ;;; Sort and index (for VMS)  F ;; Sort an index which is in the current buffer between START and END.: ;; Used on VMS, where the `sort' utility is not available.& (defun texinfo-sort-region (start end)   (require 'sort)x   (save-restrictionf      (narrow-to-region start end)J     (sort-subr nil 'forward-line 'end-of-line 'texinfo-sort-startkeyfun)))  # ;; Subroutine for sorting an index.i> ;; At start of a line, return a string to sort the line under." (defun texinfo-sort-startkeyfun ()
   (let ((lineoL          (buffer-substring (point) (save-excursion (end-of-line) (point)))))9     ;; Canonicalize whitespace and eliminate funny chars.c:     (while (string-match "[ \t][ \t]+\\|[^a-z0-9 ]+" line)?       (setq line (concat (substring line 0 (match-beginning 0))n                          " "H                          (substring line (match-end 0) (length line)))))
     line))   a ;;; @printindexn  < (put 'printindex 'texinfo-format 'texinfo-format-printindex)  # (defun texinfo-format-printindex ()     (let ((indexelts (symbol-value;                     (cdr (assoc (texinfo-parse-arg-discard)p:                                 texinfo-indexvar-alist))))         opoint)      (insert "\n* Menu:\n\n")     (setq opoint (point))r'     (texinfo-print-index nil indexelts)   !     (if (eq system-type 'vax-vms) ,         (texinfo-sort-region opoint (point))>       (shell-command-on-region opoint (point) "sort -fd" 1))))  + (defun texinfo-print-index (file indexelts)a   (while indexelts'     (if (stringp (car (car indexelts)))          (progn3           (insert "* " (car (car indexelts)) ": " )            (indent-to 32)           (inserti-            (if file (concat "(" file ")") "") '            (nth 1 (car indexelts)) ".")r           (indent-to 54)           (insertr&            (if (nth 2 (car indexelts))7                (format "  %d." (nth 2 (car indexelts)))               "")            "\n"))(+       ;; index entries from @include'd filef2       (texinfo-print-index (nth 1 (car indexelts))4                            (nth 2 (car indexelts))))&     (setq indexelts (cdr indexelts))))   s ;;; Glyphs: @equiv, @error, etcs  ? ;; @equiv           to show that two expressions are equivalent(, ;; @error           to show an error message3 ;; @expansion       to show what a macro expands to,? ;; @point           to show the location of point in an exampleO? ;; @print           to show what an evaluated expression printsnC ;; @result          to indicate the value returned by an expression   2 (put 'equiv 'texinfo-format 'texinfo-format-equiv) (defun texinfo-format-equiv ()   (texinfo-parse-arg-discard)(   (insert "=="))  2 (put 'error 'texinfo-format 'texinfo-format-error) (defun texinfo-format-error ()   (texinfo-parse-arg-discard)n   (insert "error-->"))  : (put 'expansion 'texinfo-format 'texinfo-format-expansion)" (defun texinfo-format-expansion ()   (texinfo-parse-arg-discard)n   (insert "==>"))m  2 (put 'point 'texinfo-format 'texinfo-format-point) (defun texinfo-format-point ()   (texinfo-parse-arg-discard)    (insert "-!-"))t  2 (put 'print 'texinfo-format 'texinfo-format-print) (defun texinfo-format-print ()   (texinfo-parse-arg-discard)    (insert "-|"))  4 (put 'result 'texinfo-format 'texinfo-format-result) (defun texinfo-format-result ()a   (texinfo-parse-arg-discard)a   (insert "=>"))   t. ;;; Definition formatting: @deffn, @defun, etc  ' ;; What definition formatting produces:f ;; ;; @deffn category name args...a% ;;     In Info, `Category: name ARGS'u$ ;;     In index: name:  node. line#. ;; ;; @defvr category name   ;;     In Info, `Category: name'$ ;;     In index: name:  node. line#. ;;% ;; @deftp category name attributes...'G ;; `category name attributes...'       Note: @deftp args in lower case.-$ ;;     In index: name:  node. line#. ;;5 ;; Specialized function-like or variable-like entity:  ;;. ;; @defun, @defmac, @defspec, @defvar, @defopt ;;< ;; @defun name args           In Info, `Function: name ARGS'9 ;; @defmac name args          In Info, `Macro: name ARGS')7 ;; @defvar name               In Info, `Variable: name'o ;; etc.i$ ;;     In index: name:  node. line#. ;;A ;; Generalized typed-function-like or typed-variable-like entity:i- ;; @deftypefn category data-type name args...n3 ;;     In Info, `Category:  data-type name args...'x& ;; @deftypevr category data-type name + ;;     In Info, `Category:  data-type name'd$ ;;     In index: name:  node. line#. ;;A ;; Specialized typed-function-like or typed-variable-like entity:x% ;; @deftypefun data-type name args...x0 ;;     In Info, `Function:  data-type name ARGS'' ;;     In index: name:  node. line#.   f ;; ;; @deftypevar data-type name + ;;     In Info, `Variable:  data-type name'mD ;;     In index: name:  node. line#.   but include args after name!? ;;' ;; Generalized object oriented entity: i% ;; @defop category class name args...-- ;;     In Info, `Category on class: name ARG'm, ;;     In index: name on class: node. line#. ;;& ;; @defcv category class name         ) ;;     In Info, `Category of class: name'n, ;;     In index: name of class: node. line#. ;;& ;; Specialized object oriented entity:! ;; @defmethod class name args... i, ;;     In Info, `Method on class: name ARGS', ;;     In index: name on class: node. line#. ;; ;; @defivar class name2 ;;     In Info, `Instance variable of class: name', ;;     In index: name of class: node. line#.   f' ;;; The definition formatting functions    (defun texinfo-format-defun ()!   (texinfo-push-stack 'defun nil);&   (setq fill-column (- fill-column 5))   (texinfo-format-defun-1 t))o   (defun texinfo-end-defun ()d&   (setq fill-column (+ fill-column 5))   (texinfo-discard-command)-3   (let ((start (nth 1 (texinfo-pop-stack 'defun))))-     (texinfo-do-itemize start)2     ;; Delete extra newline inserted after header.     (save-excursiono       (goto-char start)g       (delete-char -1))))    (defun texinfo-format-defunx ()f   (texinfo-format-defun-1 nil))   ' (defun texinfo-format-defun-1 (first-p) 6   (let ((parse-args (texinfo-format-parse-defun-args))F         (command-type (get texinfo-command-name 'texinfo-defun-type)))     (texinfo-discard-command) @     ;; Delete extra newline inserted after previous header line.     (if (not first-p)i         (delete-char -1));     (funcallN      (get texinfo-command-name 'texinfo-deffn-formatting-property) parse-args)C     ;; Insert extra newline so that paragraph filling does not messi     ;; with header line.     (insert "\n\n")m4     (rplaca (cdr (cdr (car texinfo-stack))) (point))     (funcallN      (get texinfo-command-name 'texinfo-defun-indexing-property) parse-args)))  - ;;; Formatting the first line of a definitioni   ;; @deffn, @defvr, @deftpnE (put 'deffn 'texinfo-deffn-formatting-property 'texinfo-format-deffn)tF (put 'deffnx 'texinfo-deffn-formatting-property 'texinfo-format-deffn)E (put 'defvr 'texinfo-deffn-formatting-property 'texinfo-format-deffn)rF (put 'defvrx 'texinfo-deffn-formatting-property 'texinfo-format-deffn)E (put 'deftp 'texinfo-deffn-formatting-property 'texinfo-format-deffn)dF (put 'deftpx 'texinfo-deffn-formatting-property 'texinfo-format-deffn)) (defun texinfo-format-deffn (parsed-args) K   ;; Generalized function-like, variable-like, or generic data-type entity: !   ;; @deffn category name args...r'   ;;     In Info, `Category: name ARGS'o'   ;; @deftp category name attributes...(I   ;; `category name attributes...'       Note: @deftp args in lower case.o$   (let ((category (car parsed-args))&         (name (car (cdr parsed-args)))'         (args (cdr (cdr parsed-args)))) &     (insert " -- " category ": " name)     (while args)       (insert " " 0               (if (or (= ?& (aref (car args) 0))A                       (eq (eval (car command-type)) 'deftp-type))f                   (car args)%                 (upcase (car args))))h       (setq args (cdr args)))))(  C ;; @defun, @defmac, @defspec, @defvar, @defopt: Specialized, simple . (put 'defun 'texinfo-deffn-formatting-property'      'texinfo-format-specialized-defun)o/ (put 'defunx 'texinfo-deffn-formatting-property)'      'texinfo-format-specialized-defun);/ (put 'defmac 'texinfo-deffn-formatting-propertyw'      'texinfo-format-specialized-defun) 0 (put 'defmacx 'texinfo-deffn-formatting-property'      'texinfo-format-specialized-defun)o0 (put 'defspec 'texinfo-deffn-formatting-property'      'texinfo-format-specialized-defun)i1 (put 'defspecx 'texinfo-deffn-formatting-propertyS'      'texinfo-format-specialized-defun)t/ (put 'defvar 'texinfo-deffn-formatting-propertyn'      'texinfo-format-specialized-defun) 0 (put 'defvarx 'texinfo-deffn-formatting-property'      'texinfo-format-specialized-defun))/ (put 'defopt 'texinfo-deffn-formatting-propertyn'      'texinfo-format-specialized-defun)t0 (put 'defoptx 'texinfo-deffn-formatting-property'      'texinfo-format-specialized-defun))5 (defun texinfo-format-specialized-defun (parsed-args) 7   ;; Specialized function-like or variable-like entity:i>   ;; @defun name args           In Info, `Function: Name ARGS';   ;; @defmac name args          In Info, `Macro: Name ARGS'd9   ;; @defvar name               In Info, `Variable: Name' 3   ;; Use cdr of command-type to determine category: +   (let ((category (car (cdr command-type))))          (name (car parsed-args))!         (args (cdr parsed-args)))(&     (insert " -- " category ": " name)     (while args        (insert " " ,               (if (= ?& (aref (car args) 0))                   (car args)%                 (upcase (car args))))1       (setq args (cdr args)))))x  , ;; @deftypefn, @deftypevr: Generalized typedM (put 'deftypefn 'texinfo-deffn-formatting-property 'texinfo-format-deftypefn)cN (put 'deftypefnx 'texinfo-deffn-formatting-property 'texinfo-format-deftypefn)M (put 'deftypevr 'texinfo-deffn-formatting-property 'texinfo-format-deftypefn) N (put 'deftypevrx 'texinfo-deffn-formatting-property 'texinfo-format-deftypefn)- (defun texinfo-format-deftypefn (parsed-args)rC   ;; Generalized typed-function-like or typed-variable-like entity:e/   ;; @deftypefn category data-type name args...t5   ;;     In Info, `Category:  data-type name args...' (   ;; @deftypevr category data-type name -   ;;     In Info, `Category:  data-type name'e?   ;; Note: args in lower case, unless modified in command line.s$   (let ((category (car parsed-args))+         (data-type (car (cdr parsed-args))) ,         (name (car (cdr (cdr parsed-args))))-         (args (cdr (cdr (cdr parsed-args))))) 4     (insert " -- " category ": " data-type " " name)     (while argst       (insert " " (car args))c       (setq args (cdr args)))))e  . ;; @deftypefun, @deftypevar: Specialized typedO (put 'deftypefun 'texinfo-deffn-formatting-property 'texinfo-format-deftypefun)s4 (put 'deftypefunx 'texinfo-deffn-formatting-property       'texinfo-format-deftypefun)O (put 'deftypevar 'texinfo-deffn-formatting-property 'texinfo-format-deftypefun)o4 (put 'deftypevarx 'texinfo-deffn-formatting-property       'texinfo-format-deftypefun). (defun texinfo-format-deftypefun (parsed-args)C   ;; Specialized typed-function-like or typed-variable-like entity:r'   ;; @deftypefun data-type name args...d2   ;;     In Info, `Function:  data-type name ARGS'    ;; @deftypevar data-type name -   ;;     In Info, `Variable:  data-type name's?   ;; Note: args in lower case, unless modified in command line.-3   ;; Use cdr of command-type to determine category:t+   (let ((category (car (cdr command-type))) %         (data-type (car parsed-args)),'         (name (car (cdr  parsed-args)))t'         (args (cdr (cdr parsed-args))))m4     (insert " -- " category ": " data-type " " name)     (while argsm       (insert " " (car args))        (setq args (cdr args)))))C  & ;; @defop: Generalized object-orientedE (put 'defop 'texinfo-deffn-formatting-property 'texinfo-format-defop)mF (put 'defopx 'texinfo-deffn-formatting-property 'texinfo-format-defop)) (defun texinfo-format-defop (parsed-args)f)   ;; Generalized object oriented entity:  '   ;; @defop category class name args...e/   ;;     In Info, `Category on class: name ARG'`*   ;; Note: args in upper case; use of `on'$   (let ((category (car parsed-args))'         (class (car (cdr parsed-args)))a,         (name (car (cdr (cdr parsed-args))))-         (args (cdr (cdr (cdr parsed-args)))))t3     (insert " -- " category " on " class ": " name)f     (while argsy&       (insert " " (upcase (car args)))       (setq args (cdr args)))));  & ;; @defcv: Generalized object-orientedE (put 'defcv 'texinfo-deffn-formatting-property 'texinfo-format-defcv) F (put 'defcvx 'texinfo-deffn-formatting-property 'texinfo-format-defcv)) (defun texinfo-format-defcv (parsed-args).)   ;; Generalized object oriented entity: a(   ;; @defcv category class name         +   ;;     In Info, `Category of class: name' *   ;; Note: args in upper case; use of `of'$   (let ((category (car parsed-args))'         (class (car (cdr parsed-args)))G,         (name (car (cdr (cdr parsed-args))))-         (args (cdr (cdr (cdr parsed-args))))) 3     (insert " -- " category " of " class ": " name)      (while argsi&       (insert " " (upcase (car args)))       (setq args (cdr args)))))r  * ;; @defmethod: Specialized object-orientedM (put 'defmethod 'texinfo-deffn-formatting-property 'texinfo-format-defmethod)lN (put 'defmethodx 'texinfo-deffn-formatting-property 'texinfo-format-defmethod)- (defun texinfo-format-defmethod (parsed-args) (   ;; Specialized object oriented entity:#   ;; @defmethod class name args... :.   ;;     In Info, `Method on class: name ARGS'*   ;; Note: args in upper case; use of `on'3   ;; Use cdr of command-type to determine category:;+   (let ((category (car (cdr command-type)))t!         (class (car parsed-args))n'         (name (car (cdr  parsed-args)))m(         (args (cdr  (cdr parsed-args))))3     (insert " -- " category " on " class ": " name)e     (while argsx&       (insert " " (upcase (car args)))       (setq args (cdr args))))).  ( ;; @defivar: Specialized object-orientedI (put 'defivar 'texinfo-deffn-formatting-property 'texinfo-format-defivar)xJ (put 'defivarx 'texinfo-deffn-formatting-property 'texinfo-format-defivar)+ (defun texinfo-format-defivar (parsed-args)r(   ;; Specialized object oriented entity:   ;; @defivar class name4   ;;     In Info, `Instance variable of class: name'*   ;; Note: args in upper case; use of `of'3   ;; Use cdr of command-type to determine category:r+   (let ((category (car (cdr command-type)))n!         (class (car parsed-args))o'         (name (car (cdr  parsed-args)))e(         (args (cdr  (cdr parsed-args))))3     (insert " -- " category " of " class ": " name)      (while args(&       (insert " " (upcase (car args)))       (setq args (cdr args)))))n   e ;;; Indexing for definitions  M ;; An index entry has three parts: the `entry proper', the node name, and the,E ;; line number.  Depending on the which command is used, the entry isf ;; formatted differently:f ;; ;; @defun, - ;; @defmac, 
 ;; @defspec, f ;; @defvar, C ;; @defopt          all use their 1st argument as the entry-proper r ;; ;; @deffn, e ;; @defvr, o
 ;; @deftp  ;; @deftypefunB ;; @deftypevar      all use their 2nd argument as the entry-proper ;; ;; @deftypefn, tE ;; @deftypevr       both use their 3rd argument as the entry-proper  f ;;F ;; @defmethod       uses its 2nd and 1st arguments as an entry-proper . ;;                    formatted: NAME on CLASS  F ;; @defop           uses its 3rd and 2nd arguments as an entry-proper . ;;                    formatted: NAME on CLASS
 ;;        E ;; @defivar         uses its 2nd and 1st arguments as an entry-properr. ;;                    formatted: NAME of CLASS ;;D ;; @defcv           uses its 3rd and 2nd argument as an entry-proper. ;;                    formatted: NAME of CLASS  B (put 'defun 'texinfo-defun-indexing-property 'texinfo-index-defun)C (put 'defunx 'texinfo-defun-indexing-property 'texinfo-index-defun) C (put 'defmac 'texinfo-defun-indexing-property 'texinfo-index-defun)tD (put 'defmacx 'texinfo-defun-indexing-property 'texinfo-index-defun)D (put 'defspec 'texinfo-defun-indexing-property 'texinfo-index-defun)E (put 'defspecx 'texinfo-defun-indexing-property 'texinfo-index-defun)fC (put 'defvar 'texinfo-defun-indexing-property 'texinfo-index-defun)tD (put 'defvarx 'texinfo-defun-indexing-property 'texinfo-index-defun)D (put 'defopt  'texinfo-defun-indexing-property 'texinfo-index-defun)E (put 'defoptx  'texinfo-defun-indexing-property 'texinfo-index-defun)r( (defun texinfo-index-defun (parsed-args)(   ;; use 1st parsed-arg  as entry-proper4   ;; `index-list' will be texinfo-findex or the likeE   (let ((index-list (get texinfo-command-name 'texinfo-defun-index)))'     (set index-listl          (cons tA           ;; Three elements: entry-proper, node-name, line-numbers           (list)            (car parsed-args)            texinfo-last-nodeC            ;; Region formatting may not provide last node position.t$            (if texinfo-last-node-pos?                (1+ (count-lines texinfo-last-node-pos (point)))-              1))'           (symbol-value index-list)))))i  B (put 'deffn 'texinfo-defun-indexing-property 'texinfo-index-deffn)C (put 'deffnx 'texinfo-defun-indexing-property 'texinfo-index-deffn)eB (put 'defvr 'texinfo-defun-indexing-property 'texinfo-index-deffn)C (put 'defvrx 'texinfo-defun-indexing-property 'texinfo-index-deffn)mB (put 'deftp 'texinfo-defun-indexing-property 'texinfo-index-deffn)C (put 'deftpx 'texinfo-defun-indexing-property 'texinfo-index-deffn)gG (put 'deftypefun 'texinfo-defun-indexing-property 'texinfo-index-deffn) H (put 'deftypefunx 'texinfo-defun-indexing-property 'texinfo-index-deffn)G (put 'deftypevar 'texinfo-defun-indexing-property 'texinfo-index-deffn) H (put 'deftypevarx 'texinfo-defun-indexing-property 'texinfo-index-deffn)) (defun texinfo-index-deffn (parsed-args) t'  ;; use 2nd parsed-arg  as entry-proper 4   ;; `index-list' will be texinfo-findex or the likeE   (let ((index-list (get texinfo-command-name 'texinfo-defun-index)))o     (set index-list-          (cons nA           ;; Three elements: entry-proper, node-name, line-numbern           (liste"            (car (cdr parsed-args))            texinfo-last-nodeC            ;; Region formatting may not provide last node position.;$            (if texinfo-last-node-pos?                (1+ (count-lines texinfo-last-node-pos (point)))n              1))'           (symbol-value index-list)))))t  J (put 'deftypefn 'texinfo-defun-indexing-property 'texinfo-index-deftypefn)K (put 'deftypefnx 'texinfo-defun-indexing-property 'texinfo-index-deftypefn)rJ (put 'deftypevr 'texinfo-defun-indexing-property 'texinfo-index-deftypefn)K (put 'deftypevrx 'texinfo-defun-indexing-property 'texinfo-index-deftypefn)@, (defun texinfo-index-deftypefn (parsed-args)(   ;; use 3rd parsed-arg  as entry-proper4   ;; `index-list' will be texinfo-findex or the likeE   (let ((index-list (get texinfo-command-name 'texinfo-defun-index)))      (set index-listi          (cons iA           ;; Three elements: entry-proper, node-name, line-numbero           (list-(            (car (cdr (cdr parsed-args)))            texinfo-last-nodeC            ;; Region formatting may not provide last node position.i$            (if texinfo-last-node-pos?                (1+ (count-lines texinfo-last-node-pos (point)))a              1))'           (symbol-value index-list)))))o  J (put 'defmethod 'texinfo-defun-indexing-property 'texinfo-index-defmethod)K (put 'defmethodx 'texinfo-defun-indexing-property 'texinfo-index-defmethod)l, (defun texinfo-index-defmethod (parsed-args)/   ;; use 2nd on 1st parsed-arg  as entry-proper 4   ;; `index-list' will be texinfo-findex or the likeE   (let ((index-list (get texinfo-command-name 'texinfo-defun-index)))      (set index-list           (cons aA           ;; Three elements: entry-proper, node-name, line-numbero           (listp)            (format "%s on %s"            y*                    (car (cdr parsed-args))%                    (car parsed-args))f            texinfo-last-nodeC            ;; Region formatting may not provide last node position. $            (if texinfo-last-node-pos?                (1+ (count-lines texinfo-last-node-pos (point))):              1))'           (symbol-value index-list)))))r  B (put 'defop 'texinfo-defun-indexing-property 'texinfo-index-defop)C (put 'defopx 'texinfo-defun-indexing-property 'texinfo-index-defop)s( (defun texinfo-index-defop (parsed-args)/   ;; use 3rd on 2nd parsed-arg  as entry-properr4   ;; `index-list' will be texinfo-findex or the likeE   (let ((index-list (get texinfo-command-name 'texinfo-defun-index)))d     (set index-listr          (cons tA           ;; Three elements: entry-proper, node-name, line-numberf           (listf)            (format "%s on %s"            ;0                    (car (cdr (cdr parsed-args)))+                    (car (cdr parsed-args)))n            texinfo-last-nodeC            ;; Region formatting may not provide last node position.p$            (if texinfo-last-node-pos?                (1+ (count-lines texinfo-last-node-pos (point)))               1))'           (symbol-value index-list)))))   F (put 'defivar 'texinfo-defun-indexing-property 'texinfo-index-defivar)G (put 'defivarx 'texinfo-defun-indexing-property 'texinfo-index-defivar):* (defun texinfo-index-defivar (parsed-args)/   ;; use 2nd of 1st parsed-arg  as entry-properm4   ;; `index-list' will be texinfo-findex or the likeE   (let ((index-list (get texinfo-command-name 'texinfo-defun-index)))o     (set index-list;          (cons cA           ;; Three elements: entry-proper, node-name, line-numberI           (listn)            (format "%s of %s"            r*                    (car (cdr parsed-args))%                    (car parsed-args))c            texinfo-last-nodeC            ;; Region formatting may not provide last node position.r$            (if texinfo-last-node-pos?                (1+ (count-lines texinfo-last-node-pos (point)))a              1))'           (symbol-value index-list))))))  B (put 'defcv 'texinfo-defun-indexing-property 'texinfo-index-defcv)C (put 'defcvx 'texinfo-defun-indexing-property 'texinfo-index-defcv)-( (defun texinfo-index-defcv (parsed-args)/   ;; use 3rd of 2nd parsed-arg  as entry-proper)4   ;; `index-list' will be texinfo-findex or the likeE   (let ((index-list (get texinfo-command-name 'texinfo-defun-index)))I     (set index-listi          (cons mA           ;; Three elements: entry-proper, node-name, line-numberm           (listm)            (format "%s of %s"             0                    (car (cdr (cdr parsed-args)))+                    (car (cdr parsed-args)))             texinfo-last-nodeC            ;; Region formatting may not provide last node position. $            (if texinfo-last-node-pos?                (1+ (count-lines texinfo-last-node-pos (point)))i              1))'           (symbol-value index-list)))))e   r ;;; Properties for definitions  . ;; Each definition command has six properties: ;;F ;; 1. texinfo-deffn-formatting-property      to format definition lineB ;; 2. texinfo-defun-indexing-property        to create index entry? ;; 3. texinfo-format                         formatting commandeC ;; 4. texinfo-end                            end formatting command D ;; 5. texinfo-defun-type                     type of deffn to formatA ;; 6. texinfo-defun-index                    type of index to usee ;;C ;; The `x' forms of each definition command are used for the second  ;; and subsequent header lines.C  L ;; The texinfo-deffn-formatting-property and texinfo-defun-indexing-propertyK ;; are listed just before the appropriate formatting and indexing commands.   2 (put 'deffn 'texinfo-format 'texinfo-format-defun)4 (put 'deffnx 'texinfo-format 'texinfo-format-defunx), (put 'deffn 'texinfo-end 'texinfo-end-defun)3 (put 'deffn 'texinfo-defun-type '('deffn-type nil)):4 (put 'deffnx 'texinfo-defun-type '('deffn-type nil))1 (put 'deffn 'texinfo-defun-index 'texinfo-findex)f2 (put 'deffnx 'texinfo-defun-index 'texinfo-findex)  2 (put 'defun 'texinfo-format 'texinfo-format-defun)4 (put 'defunx 'texinfo-format 'texinfo-format-defunx), (put 'defun 'texinfo-end 'texinfo-end-defun): (put 'defun 'texinfo-defun-type '('defun-type "Function")); (put 'defunx 'texinfo-defun-type '('defun-type "Function"))n1 (put 'defun 'texinfo-defun-index 'texinfo-findex)t2 (put 'defunx 'texinfo-defun-index 'texinfo-findex)  3 (put 'defmac 'texinfo-format 'texinfo-format-defun)t5 (put 'defmacx 'texinfo-format 'texinfo-format-defunx)p- (put 'defmac 'texinfo-end 'texinfo-end-defun)t8 (put 'defmac 'texinfo-defun-type '('defun-type "Macro"))9 (put 'defmacx 'texinfo-defun-type '('defun-type "Macro"))-2 (put 'defmac 'texinfo-defun-index 'texinfo-findex)3 (put 'defmacx 'texinfo-defun-index 'texinfo-findex)d  4 (put 'defspec 'texinfo-format 'texinfo-format-defun)6 (put 'defspecx 'texinfo-format 'texinfo-format-defunx). (put 'defspec 'texinfo-end 'texinfo-end-defun)@ (put 'defspec 'texinfo-defun-type '('defun-type "Special form"))A (put 'defspecx 'texinfo-defun-type '('defun-type "Special form"))o3 (put 'defspec 'texinfo-defun-index 'texinfo-findex)n4 (put 'defspecx 'texinfo-defun-index 'texinfo-findex)  2 (put 'defvr 'texinfo-format 'texinfo-format-defun)4 (put 'defvrx 'texinfo-format 'texinfo-format-defunx), (put 'defvr 'texinfo-end 'texinfo-end-defun)3 (put 'defvr 'texinfo-defun-type '('deffn-type nil))r4 (put 'defvrx 'texinfo-defun-type '('deffn-type nil))1 (put 'defvr 'texinfo-defun-index 'texinfo-vindex)t2 (put 'defvrx 'texinfo-defun-index 'texinfo-vindex)  3 (put 'defvar 'texinfo-format 'texinfo-format-defun)x5 (put 'defvarx 'texinfo-format 'texinfo-format-defunx)e- (put 'defvar 'texinfo-end 'texinfo-end-defun)t; (put 'defvar 'texinfo-defun-type '('defun-type "Variable")))< (put 'defvarx 'texinfo-defun-type '('defun-type "Variable"))2 (put 'defvar 'texinfo-defun-index 'texinfo-vindex)3 (put 'defvarx 'texinfo-defun-index 'texinfo-vindex)d  5 (put 'defconst 'texinfo-format 'texinfo-format-defun)y7 (put 'defconstx 'texinfo-format 'texinfo-format-defunx) / (put 'defconst 'texinfo-end 'texinfo-end-defun)m= (put 'defconst 'texinfo-defun-type '('defun-type "Constant"))s> (put 'defconstx 'texinfo-defun-type '('defun-type "Constant"))4 (put 'defconst 'texinfo-defun-index 'texinfo-vindex)5 (put 'defconstx 'texinfo-defun-index 'texinfo-vindex)i  3 (put 'defcmd 'texinfo-format 'texinfo-format-defun) 5 (put 'defcmdx 'texinfo-format 'texinfo-format-defunx)o- (put 'defcmd 'texinfo-end 'texinfo-end-defun) : (put 'defcmd 'texinfo-defun-type '('defun-type "Command")); (put 'defcmdx 'texinfo-defun-type '('defun-type "Command"))-2 (put 'defcmd 'texinfo-defun-index 'texinfo-findex)3 (put 'defcmdx 'texinfo-defun-index 'texinfo-findex)   3 (put 'defopt 'texinfo-format 'texinfo-format-defun)f5 (put 'defoptx 'texinfo-format 'texinfo-format-defunx)t- (put 'defopt 'texinfo-end 'texinfo-end-defun)d> (put 'defopt 'texinfo-defun-type '('defun-type "User Option"))? (put 'defoptx 'texinfo-defun-type '('defun-type "User Option"))i2 (put 'defopt 'texinfo-defun-index 'texinfo-vindex)3 (put 'defoptx 'texinfo-defun-index 'texinfo-vindex)   2 (put 'deftp 'texinfo-format 'texinfo-format-defun)4 (put 'deftpx 'texinfo-format 'texinfo-format-defunx), (put 'deftp 'texinfo-end 'texinfo-end-defun)3 (put 'deftp 'texinfo-defun-type '('deftp-type nil))n4 (put 'deftpx 'texinfo-defun-type '('deftp-type nil))1 (put 'deftp 'texinfo-defun-index 'texinfo-tindex)o2 (put 'deftpx 'texinfo-defun-index 'texinfo-tindex)  . ;;; Object-oriented stuff is a little hairier.  2 (put 'defop 'texinfo-format 'texinfo-format-defun)4 (put 'defopx 'texinfo-format 'texinfo-format-defunx), (put 'defop 'texinfo-end 'texinfo-end-defun)3 (put 'defop 'texinfo-defun-type '('defop-type nil))s4 (put 'defopx 'texinfo-defun-type '('defop-type nil))1 (put 'defop 'texinfo-defun-index 'texinfo-findex)m2 (put 'defopx 'texinfo-defun-index 'texinfo-findex)  6 (put 'defmethod 'texinfo-format 'texinfo-format-defun)8 (put 'defmethodx 'texinfo-format 'texinfo-format-defunx)0 (put 'defmethod 'texinfo-end 'texinfo-end-defun)@ (put 'defmethod 'texinfo-defun-type '('defmethod-type "Method"))A (put 'defmethodx 'texinfo-defun-type '('defmethod-type "Method")) 5 (put 'defmethod 'texinfo-defun-index 'texinfo-findex)x6 (put 'defmethodx 'texinfo-defun-index 'texinfo-findex)  2 (put 'defcv 'texinfo-format 'texinfo-format-defun)4 (put 'defcvx 'texinfo-format 'texinfo-format-defunx), (put 'defcv 'texinfo-end 'texinfo-end-defun)3 (put 'defcv 'texinfo-defun-type '('defop-type nil))t4 (put 'defcvx 'texinfo-defun-type '('defop-type nil))1 (put 'defcv 'texinfo-defun-index 'texinfo-vindex)p2 (put 'defcvx 'texinfo-defun-index 'texinfo-vindex)  4 (put 'defivar 'texinfo-format 'texinfo-format-defun)6 (put 'defivarx 'texinfo-format 'texinfo-format-defunx). (put 'defivar 'texinfo-end 'texinfo-end-defun)I (put 'defivar 'texinfo-defun-type '('defmethod-type "Instance variable"))sJ (put 'defivarx 'texinfo-defun-type '('defmethod-type "Instance variable"))3 (put 'defivar 'texinfo-defun-index 'texinfo-vindex)o4 (put 'defivarx 'texinfo-defun-index 'texinfo-vindex)  ! ;;; Typed functions and variables   6 (put 'deftypefn 'texinfo-format 'texinfo-format-defun)8 (put 'deftypefnx 'texinfo-format 'texinfo-format-defunx)0 (put 'deftypefn 'texinfo-end 'texinfo-end-defun); (put 'deftypefn 'texinfo-defun-type '('deftypefn-type nil)) < (put 'deftypefnx 'texinfo-defun-type '('deftypefn-type nil))5 (put 'deftypefn 'texinfo-defun-index 'texinfo-findex) 6 (put 'deftypefnx 'texinfo-defun-index 'texinfo-findex)  7 (put 'deftypefun 'texinfo-format 'texinfo-format-defun)d9 (put 'deftypefunx 'texinfo-format 'texinfo-format-defunx) 1 (put 'deftypefun 'texinfo-end 'texinfo-end-defun);D (put 'deftypefun 'texinfo-defun-type '('deftypefun-type "Function"))E (put 'deftypefunx 'texinfo-defun-type '('deftypefun-type "Function")) 6 (put 'deftypefun 'texinfo-defun-index 'texinfo-findex)7 (put 'deftypefunx 'texinfo-defun-index 'texinfo-findex)r  6 (put 'deftypevr 'texinfo-format 'texinfo-format-defun)8 (put 'deftypevrx 'texinfo-format 'texinfo-format-defunx)0 (put 'deftypevr 'texinfo-end 'texinfo-end-defun); (put 'deftypevr 'texinfo-defun-type '('deftypefn-type nil))x< (put 'deftypevrx 'texinfo-defun-type '('deftypefn-type nil))5 (put 'deftypevr 'texinfo-defun-index 'texinfo-vindex)v6 (put 'deftypevrx 'texinfo-defun-index 'texinfo-vindex)  7 (put 'deftypevar 'texinfo-format 'texinfo-format-defun)i9 (put 'deftypevarx 'texinfo-format 'texinfo-format-defunx)t1 (put 'deftypevar 'texinfo-end 'texinfo-end-defun)sD (put 'deftypevar 'texinfo-defun-type '('deftypevar-type "Variable"))E (put 'deftypevarx 'texinfo-defun-type '('deftypevar-type "Variable"))s6 (put 'deftypevar 'texinfo-defun-index 'texinfo-vindex)7 (put 'deftypevarx 'texinfo-defun-index 'texinfo-vindex))    " ;;; @set, @clear, @ifset, @ifclear  E ;; If a flag is set with @set FLAG, then text between @ifset and @end(B ;; ifset is formatted normally, but if the flag is is cleared with> ;; @clear FLAG, then the text is not formatted; it is ignored.  D ;; If a flag is cleared with @clear FLAG, then text between @ifclearI ;; and @end ifclear is formatted normally, but if the flag is is set witheF ;; @set FLAG, then the text is not formatted; it is ignored.  @ifclear ;; is the opposite of @ifset.   0 ;; If a flag is set to a string with @set FLAG, ) ;; replace  @value{FLAG} with the string. & ;; If a flag with a value is cleared,  ;; @value{FLAG} is invalid, 7 ;; as if there had never been any @set FLAG previously.u  + (put 'clear 'texinfo-format 'texinfo-clear)e (defun texinfo-clear ()     "Clear the value of the flag."*   (let* ((arg (texinfo-parse-arg-discard)),          (flag (car (read-from-string arg)))>          (value (substring arg (cdr (read-from-string arg)))))2     (put flag 'texinfo-whether-setp 'flag-cleared)&     (put flag 'texinfo-set-value "")))  ' (put 'set 'texinfo-format 'texinfo-set)t (defun texinfo-set ())5   "Set the value of the flag, optionally to a string.e) The command  `@set foo This is a string.':/ sets flag foo to the value: `This is a string.'n2 The command  `@value{foo}'  expands to the value."*   (let* ((arg (texinfo-parse-arg-discard)),          (flag (car (read-from-string arg)))>          (value (substring arg (cdr (read-from-string arg))))).     (put flag 'texinfo-whether-setp 'flag-set))     (put flag 'texinfo-set-value value)))(  + (put 'value 'texinfo-format 'texinfo-value)- (defun texinfo-value ()".   "Insert the string to which the flag is set.) The command  `@set foo This is a string.'u/ sets flag foo to the value: `This is a string.'-2 The command  `@value{foo}'  expands to the value."*   (let ((arg (texinfo-parse-arg-discard)))     (cond ((and H             (eq (get (car (read-from-string arg)) 'texinfo-whether-setp)                 'flag-set)B             (get (car (read-from-string arg)) 'texinfo-set-value))J            (insert (get (car (read-from-string arg)) 'texinfo-set-value)))H           ((eq (get (car (read-from-string arg)) 'texinfo-whether-setp)                 'flag-cleared)f:            (insert (format "{No value for \"%s\"}"  arg)))L           ((eq (get (car (read-from-string arg)) 'texinfo-whether-setp) nil)=            (insert (format "{No value for \"%s\"}"  arg))))))   2 (put 'ifset 'texinfo-end 'texinfo-discard-command), (put 'ifset 'texinfo-format 'texinfo-if-set) (defun texinfo-if-set ()K   "If set, continue formatting; else do not format region up to @end ifset"p*   (let ((arg (texinfo-parse-arg-discard)))	     (cond B      ((eq (get (car (read-from-string arg)) 'texinfo-whether-setp)           'flag-set)C       ;; Format the text (i.e., do not remove it); do nothing here.x	       ())eB      ((eq (get (car (read-from-string arg)) 'texinfo-whether-setp)           'flag-cleared);       ;; Clear region (i.e., cause the text to be ignored).e*       (delete-region texinfo-command-startF                        (progn (re-search-forward "@end ifset[ \t]*\n")(                               (point))))B      ((eq (get (car (read-from-string arg)) 'texinfo-whether-setp)           nil)K       (error  "@ifset flag `%s' is not defined by @set or @clear." arg)))))   4 (put 'ifclear 'texinfo-end 'texinfo-discard-command)0 (put 'ifclear 'texinfo-format 'texinfo-if-clear) (defun texinfo-if-clear ()I   "If clear, continue formatting; if set, do not format up to @end ifset"(*   (let ((arg (texinfo-parse-arg-discard)))	     (cond-B      ((eq (get (car (read-from-string arg)) 'texinfo-whether-setp)           'flag-set);       ;; Clear region (i.e., cause the text to be ignored).t*       (delete-region texinfo-command-startH                        (progn (re-search-forward "@end ifclear[ \t]*\n")(                               (point))))B      ((eq (get (car (read-from-string arg)) 'texinfo-whether-setp)           'flag-cleared)C       ;; Format the text (i.e., do not remove it); do nothing here.'	       ())iB      ((eq (get (car (read-from-string arg)) 'texinfo-whether-setp)           nil)M       (error  "@ifclear flag `%s' is not defined by @clear or @set." arg)))))e   y/ ;;; Process included files:  `@include' commandt   ;; Updated 19 October 1990B ;; In the original version, include files were ignored by Info butD ;; incorporated in to the printed manual.  To make references to theF ;; included file, the Texinfo source file has to refer to the includedD ;; files using the `(filename)nodename' format for refering to otherE ;; Info files.  Also, the included files had to be formatted on theiri1 ;; own.  It was just like they were another file.x  @ ;; Currently, include files are inserted into the buffer that isF ;; formatted for Info.  If large, the resulting info file is split andE ;; tagified.  For current include files to work, the master menu mustfE ;; refer to all the nodes, and the highest level nodes in the include-; ;; files must have the correct next, prev, and up pointers.   D ;; The included file may have an @setfilename and even an @settitle,$ ;; but not an `\input texinfo' line.   ;; Updated 24 March 1993C ;; In order for @raisesections and @lowersections to work, included-@ ;; files must be inserted into the buffer holding the outer fileF ;; before other Info formatting takes place.  So @include is no longer$ ;; is treated like other @-commands.4 (put 'include 'texinfo-format  'texinfo-format-noop)   ; Original definition:" ; (defun texinfo-format-include ()0 ;   (let ((filename (texinfo-parse-arg-discard))+ ;       (default-directory input-directory)r ;       subindex)- ;     (setq subindex ;         (save-excursionm ;           (progn (find-fileoI ;                   (cond ((file-readable-p (concat filename ".texinfo")))8 ;                          (concat filename ".texinfo"))F ;                         ((file-readable-p (concat filename ".texi"))5 ;                          (concat filename ".texi"))oE ;                         ((file-readable-p (concat filename ".tex"))-4 ;                          (concat filename ".tex"))5 ;                         ((file-readable-p filename)d$ ;                          filename)B ;                         (t (error "@include'd file %s not found"0 ;                                   filename))))/ ;                  (texinfo-format-buffer-1))))vH ;     (texinfo-subindex 'texinfo-vindex (car subindex) (nth 1 subindex))H ;     (texinfo-subindex 'texinfo-findex (car subindex) (nth 2 subindex))H ;     (texinfo-subindex 'texinfo-cindex (car subindex) (nth 3 subindex))H ;     (texinfo-subindex 'texinfo-pindex (car subindex) (nth 4 subindex))H ;     (texinfo-subindex 'texinfo-tindex (car subindex) (nth 5 subindex))J ;     (texinfo-subindex 'texinfo-kindex (car subindex) (nth 6 subindex)))) ; 0 ;(defun texinfo-subindex (indexvar file content)3 ;  (set indexvar (cons (list 'recurse file content)r1 ;                      (symbol-value indexvar))))o   ; Second definition:8 ; (put 'include 'texinfo-format 'texinfo-format-include)" ; (defun texinfo-format-include ()+ ;   (let ((filename (concat input-directorye9 ;                           (texinfo-parse-arg-discard)))p. ;         (default-directory input-directory))& ;     (message "Reading: %s" filename) ;     (save-excursione ;       (save-restrictione ;         (narrow-to-regione ;          (point)C ;          (+ (point) (car (cdr (insert-file-contents filename)))))n! ;         (goto-char (point-min))i! ;         (texinfo-append-refill)l< ;         (texinfo-format-convert (point-min) (point-max))))D ;     (setq last-input-buffer input-buffer)  ; to bypass setfilename ;     ))   m+ ;;; Numerous commands do nothing in Texinfo   @ ;; These commands are defined in texinfo.tex for printed output.  0 (put 'bye 'texinfo-format 'texinfo-discard-line)8 (put 'c 'texinfo-format 'texinfo-discard-line-with-args)> (put 'comment 'texinfo-format 'texinfo-discard-line-with-args)? (put 'contents 'texinfo-format 'texinfo-discard-line-with-args)r5 (put 'finalout 'texinfo-format 'texinfo-discard-line)t9 (put 'group 'texinfo-end 'texinfo-discard-line-with-args) < (put 'group 'texinfo-format 'texinfo-discard-line-with-args)? (put 'headings 'texinfo-format 'texinfo-discard-line-with-args)h< (put 'hsize 'texinfo-format 'texinfo-discard-line-with-args)A (put 'itemindent 'texinfo-format 'texinfo-discard-line-with-args) D (put 'lispnarrowing 'texinfo-format 'texinfo-discard-line-with-args); (put 'need 'texinfo-format 'texinfo-discard-line-with-args)e= (put 'nopara 'texinfo-format 'texinfo-discard-line-with-args)s; (put 'page 'texinfo-format 'texinfo-discard-line-with-args)i@ (put 'parindent 'texinfo-format 'texinfo-discard-line-with-args)H (put 'setchapternewpage 'texinfo-format 'texinfo-discard-line-with-args); (put 'setq 'texinfo-format 'texinfo-discard-line-with-args)r? (put 'settitle 'texinfo-format 'texinfo-discard-line-with-args)r; (put 'setx 'texinfo-format 'texinfo-discard-line-with-args))D (put 'shortcontents 'texinfo-format 'texinfo-discard-line-with-args)6 (put 'smallbook 'texinfo-format 'texinfo-discard-line)F (put 'summarycontents 'texinfo-format 'texinfo-discard-line-with-args)   d# ;;; Some commands cannot be handlede   (defun texinfo-unsupported ()i'   (error "%s is not handled by texinfo"rG          (buffer-substring texinfo-command-start texinfo-command-end)))v e ;;; Batch formatting   (defun batch-texinfo-format ()K   "Runs  texinfo-format-buffer  on the files remaining on the command line.a= Must be used only with -batch, and kills emacs on completion.aA Each file will be processed even if an error occurred previously.e For example, invokeaE   \"emacs -batch -funcall batch-texinfo-format $docs/ ~/*.texinfo\"."r   (if (not noninteractive)>       (error "batch-texinfo-format may only be used -batch."))   (let ((version-control t)a         (auto-save-default nil)f!         (find-file-run-dired nil)t"         (kept-old-versions 259259)#         (kept-new-versions 259259))g     (let ((error 0)r           file           (files ())) #       (while command-line-args-lefttC         (setq file (expand-file-name (car command-line-args-left)))t)         (cond ((not (file-exists-p file))-5                (message ">> %s does not exist!" file)g                (setq error 1J                      command-line-args-left (cdr command-line-args-left)))&               ((file-directory-p file)+                (setq command-line-args-lefte2                      (nconc (directory-files file);                             (cdr command-line-args-left))))c               (t,                (setq files (cons file files)L                      command-line-args-left (cdr command-line-args-left)))))       (while files         (setq file (car files)                files (cdr files))         (condition-case err              (prognB               (if buffer-file-name (kill-buffer (current-buffer)))               (find-file file)2               (buffer-flush-undo (current-buffer)))               (set-buffer-modified-p nil)a               (texinfo-mode)7               (message "texinfo formatting %s..." file)-)               (texinfo-format-buffer nil) %               (if (buffer-modified-p)dJ                   (progn (message "Saving modified %s" (buffer-file-name)))                          (save-buffer))))r           (error9            (message ">> Error: %s" (prin1-to-string err))t#            (message ">>  point at")a-            (let ((s (buffer-substring (point)':                                       (min (+ (point) 100)9                                            (point-max))))t                  (tem 0)) 9              (while (setq tem (string-match "\n+" s tem)) B                (setq s (concat (substring s 0 (match-beginning 0))'                                "\n>>  "i;                                (substring s (match-end 0)))x#                      tem (1+ tem))) "              (message ">>  %s" s))            (setq error 1))))       (kill-emacs error)))))    # ;;; Place `provide' at end of file.) (provide 'texinfmt)t1 ;;;;;;;;;;;;;;;; end texinfmt.el ;;;;;;;;;;;;;;;;e