 ;;;; texinfo.el   ) ;;; Major mode for editing Texinfo files.     ;;; Version 2.13   18 March 1993  ;;; Robert J. Chassell            ! ;; Copyright (C) 1985, '88, '89,  C ;;                '90, '91, '92, '93 Free Software Foundation, Inc.     # ;;; This file is part of GNU Emacs.   D ;; GNU Emacs is free software; you can redistribute it and/or modifyG ;; it under the terms of the GNU General Public License as published by F ;; the Free Software Foundation; either version 1, or (at your option) ;; any later version.   ? ;; GNU Emacs is distributed in the hope that it will be useful, A ;; but WITHOUT ANY WARRANTY; without even the implied warranty of @ ;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/ ;; GNU General Public License for more details.   D ;; You should have received a copy of the GNU General Public License@ ;; along with GNU Emacs; see the file COPYING.  If not, write toH ;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.    
 ;;; Autoloads     (autoload 'texinfo-format-region           "texinfmt"A   "Convert the current region of the Texinfo file to Info format. D This lets you see what that part of the file will look like in Info.D The command is bound to \\[texinfo-format-region].  The text that is3 converted to Info is stored in a temporary buffer."            t nil)    (autoload 'texinfo-format-buffer           "texinfmt"A   "Process the current buffer as texinfo code, into an Info file. D The Info file output is generated in a buffer visiting the Info file, names specified in the @setfilename command.  D Non-nil argument (prefix, if interactive) means don't make tag table? and don't split the file if large.  You can use Info-tagify and ! Info-split to do these manually."            t nil)   (autoload 'makeinfo-region           "makeinfo"=   "Make Info file from region of current Texinfo source file.   E The \\[next-error] command can be used to move to the next error \(if  any are found\)."            t nil)   (autoload 'makeinfo-buffer           "makeinfo"&   "Make Info file from current buffer.  A The \\[next-error] command can be used to move to the next error   \(if any are found\)."           t nil)   (autoload 'kill-compilation            "compile" 5   "Kill the process made by the \\[compile] command."            t nil)  / (autoload 'makeinfo-recenter-compilation-buffer            "makeinfo"I   "Redisplay *compilation* buffer so that most recent output can be seen. + The last line of the buffer is displayed on 5 line LINE of the window, or centered if LINE is nil."            t nil)   (autoload 'texinfo-tex-region            "texnfo-tex""   "Run tex on the current region.   D A temporary file is written in the default directory, and tex is run? in that directory.  The first line of the file is copied to the D temporary file; and if the buffer has a header, it is written to theD temporary file before the region itself.  The buffer's header is all@ lines between the strings defined by texinfo-start-of-header andH texinfo-end-of-header inclusive.  The header must start in the first 100J lines.  The value of texinfo-tex-trailer is appended to the temporary file after the region."           t nil)   (autoload 'texinfo-tex-buffer            "texnfo-tex"   "Run TeX on current buffer. J After running TeX the first time, you may have to run \\[texinfo-texindex]' and then \\[texinfo-tex-buffer] again."            t nil)   (autoload 'texinfo-kill-tex-job            "texnfo-tex"'   "Kill the currently running TeX job."            t nil)  - (autoload 'texinfo-recenter-tex-output-buffer            "texnfo-tex"M   "Redisplay buffer of TeX job output so that most recent output can be seen. + The last line of the buffer is displayed on 5 line LINE of the window, or centered if LINE is nil."            t nil)  . (autoload 'texinfo-delete-from-tex-print-queue           "texnfo-tex"3   "Delete job from the line printer spooling queue. 8 You are prompted for the job number (shown by a previous* \\[texinfo-show-tex-print-queue] command."           t nil)  ' (autoload 'texinfo-show-tex-print-queue            "texnfo-tex"C   "Show the print queue that \\[texinfo-tex-print] put your job on. B Runs the shell command defined by texinfo-show-tex-queue-command."           t nil)   (autoload 'texinfo-tex-print           "texnfo-tex"L   "Print .dvi file made by \\[texinfo-tex-region] or \\[texinfo-tex-buffer].A Runs the shell command defined by texinfo-tex-dvi-print-command."            t nil)   (autoload 'texinfo-texindex            "texnfo-tex"(   "Run texindex on unsorted index files.M The index files are made by \\[texinfo-tex-region] or \\[texinfo-tex-buffer]. < Runs the shell command defined by texinfo-texindex-command."           t nil)   (autoload 'texinfo-make-menu           "texnfo-upd"6   "Without any prefix argument, make or update a menu.G Make the menu for the section enclosing the node found following point.   D Non-nil argument (prefix, if interactive) means make or update menus. for nodes within or part of the marked region.  C Whenever a menu exists, and is being updated, the descriptions that ; are associated with node names in the pre-existing menu are E incorporated into the new menu.  Otherwise, the nodes' section titles  are inserted as descriptions."           t nil)   (autoload 'texinfo-update-node           "texnfo-upd"J   "Without any prefix argument, update the node in which point is located.G Non-nil argument (prefix, if interactive) means update the nodes in the  marked region.  A The functions for creating or updating nodes and menus, and their  keybindings, are:   G     texinfo-update-node (&optional region-p)    \\[texinfo-update-node] M     texinfo-every-node-update ()                \\[texinfo-every-node-update] 7     texinfo-sequential-node-update (&optional region-p)   E     texinfo-make-menu (&optional region-p)      \\[texinfo-make-menu] L     texinfo-all-menus-update ()                 \\[texinfo-all-menus-update]     texinfo-master-menu ()  ?     texinfo-indent-menu-description (column &optional region-p)   E The `texinfo-column-for-description' variable specifies the column to ? which menu descriptions are indented. Its default value is 24."            t nil)  $ (autoload 'texinfo-every-node-update           "texnfo-upd"(   "Update every node in a Texinfo file."           t nil)  # (autoload 'texinfo-all-menus-update            "texnfo-upd"/   "Update every regular menu in a Texinfo file. 1 Remove pre-existing master menu, if there is one.   F If called with a non-nil argument, this function first updates all the/ nodes in the buffer before updating the menus."            t nil)   (autoload 'texinfo-master-menu           "texnfo-upd"/   "Make a master menu for a whole Texinfo file. @ Non-nil argument (prefix, if interactive) means first update allL existing nodes and menus.  Remove pre-existing master menu, if there is one.  C This function creates a master menu that follows the top node.  The > master menu includes every entry from all the other menus.  It> replaces any existing ordinary menu that follows the top node.  F If called with a non-nil argument, this function first updates all theA menus in the buffer (incorporating descriptions from pre-existing , menus) before it constructs the master menu.  D The function removes the detailed part of an already existing masterD menu.  This action depends on the pre-exisitng master menu using the& standard `texinfo-master-menu-header'.  C The master menu has the following format, which is adapted from the % recommendation in the Texinfo Manual:   E    * The first part contains the major nodes in the Texinfo file: the A      nodes for the chapters, chapter-like sections, and the major C      appendices.  This includes the indices, so long as they are in 8      chapter-like sections, such as unnumbered sections.  D    * The second and subsequent parts contain a listing of the other,?      lower level menus, in order.  This way, an inquirer can go @      directly to a particular node if he or she is searching for      specific information.  C Each of the menus in the detailed node listing is introduced by theo* title of the section containing the menu."           t nil)  * (autoload 'texinfo-indent-menu-description           "texnfo-upd"@   "Indent every description in menu following point to COLUMN.  < Non-nil argument (prefix, if interactive) means indent everyD description in every menu in the region.  Does not indent second and. subsequent lines of a multi-line description."           t nil)  ) (autoload 'texinfo-sequential-node-updateo           "texnfo-upd"H   "Update one node (or many) in a Texinfo file with sequential pointers.  E This function causes the `Next' or `Previous' pointer to point to theME immediately preceding or following node, even if it is at a higher ornF lower hierarchical level in the document.  Continually pressing `n' or( `p' takes you straight through the file.  G Without any prefix argument, update the node in which point is located. G Non-nil argument (prefix, if interactive) means update the nodes in theu marked region.  < This command makes it awkward to navigate among sections andF subsections; it should be used only for those documents that are meantB to be read like a novel rather than a reference, and for which the! Info `g*' command is inadequate.".           t nil)  $ (autoload 'texinfo-insert-node-lines           "texnfo-upd":   "Insert missing `@node' lines in region of Texinfo file.B Non-nil argument (prefix, if interactive) means also to insert theF section titles as node names; and also to insert the section titles as8 node names in pre-existing @node lines that lack names."           t nil)  ) (autoload 'texinfo-start-menu-descriptione           "texnfo-upd"I   "In this menu entry, insert the node's section title as a description. .= Position point at beginning of description ready for editing.mC Do not insert a title if the line contains an existing description.e  B You will need to edit the inserted text since a useful descriptionB complements the node name rather than repeats it as a title does."           t nil)  ( (autoload 'texinfo-multiple-files-update           "texnfo-upd"B   "Update first node pointers in each file included in OUTER-FILE;H create or update main menu in the outer file that refers to such nodes. K This does not create or update menus or pointers within the included files.i  E With optional MAKE-MASTER-MENU argument (prefix arg, if interactive),fC insert a master menu in OUTER-FILE.  This does not create or updateb, menus or pointers within the included files.  @ With optional UPDATE-EVERYTHING argument (numeric prefix arg, ifF interactive), update all the menus and all the `Next', `Previous', andF `Up' pointers of all the files included in OUTER-FILE before inserting a master menu in OUTER-FILE.  E The command also updates the `Top' level node pointers of OUTER-FILE.    Notes: i  ;   * this command does NOT save any files--you must save ther0     outer file and any modified, included files.  ?   * except for the `Top' node, this command does NOT handle any-@     pre-existing nodes in the outer file; hence, indices must be!     enclosed in an included file.u  
 Requirements:t  ?   * each of the included files must contain exactly one highest      hierarchical level node, oB   * this highest node must be the first node in the included file,B   * each highest hierarchical level node must be of the same type.  > Thus, normally, each included file contains one, and only one,	 chapter."l           t nil)   o ;;; Syntax table  & (defvar texinfo-mode-syntax-table nil)   (if texinfo-mode-syntax-tablet     nilx6   (setq texinfo-mode-syntax-table (make-syntax-table))9   (modify-syntax-entry ?\" " " texinfo-mode-syntax-table) 9   (modify-syntax-entry ?\\ " " texinfo-mode-syntax-table)y9   (modify-syntax-entry ?@ "\\" texinfo-mode-syntax-table).;   (modify-syntax-entry ?\^q "\\" texinfo-mode-syntax-table)i:   (modify-syntax-entry ?\[ "(]" texinfo-mode-syntax-table):   (modify-syntax-entry ?\] ")[" texinfo-mode-syntax-table)9   (modify-syntax-entry ?{ "(}" texinfo-mode-syntax-table)c9   (modify-syntax-entry ?} "){" texinfo-mode-syntax-table)r:   (modify-syntax-entry ?\' "w" texinfo-mode-syntax-table))   \ ;;; Keybindingsn (defvar texinfo-mode-map nil)s  6 ;;; Keys common both to Texinfo mode and to TeX shell.  * (defun texinfo-define-common-keys (keymap)F   "Define the keys both in Texinfo mode and in the texinfo-tex-shell."=   (define-key keymap "\C-c\C-t\C-k"    'texinfo-kill-tex-job)d=   (define-key keymap "\C-c\C-t\C-x"    'texinfo-quit-tex-job)lK   (define-key keymap "\C-c\C-t\C-l"    'texinfo-recenter-tex-output-buffer)nL   (define-key keymap "\C-c\C-t\C-d"    'texinfo-delete-from-tex-print-queue)E   (define-key keymap "\C-c\C-t\C-q"    'texinfo-show-tex-print-queue)d:   (define-key keymap "\C-c\C-t\C-p"    'texinfo-tex-print)9   (define-key keymap "\C-c\C-t\C-i"    'texinfo-texindex)p  ;   (define-key keymap "\C-c\C-t\C-r"    'texinfo-tex-region)f<   (define-key keymap "\C-c\C-t\C-b"    'texinfo-tex-buffer))  9 ;; Mode documentation displays commands in reverse order  4 ;; from how they are listed in the texinfo-mode-map.   (if texinfo-mode-map     nila.   (setq texinfo-mode-map (make-sparse-keymap))  !   ;; bindings for `texnfo-tex.el'h/   (texinfo-define-common-keys texinfo-mode-map)      ;; bindings for `texinfmt.el' H   (define-key texinfo-mode-map "\C-c\C-e\C-r"    'texinfo-format-region)H   (define-key texinfo-mode-map "\C-c\C-e\C-b"    'texinfo-format-buffer)     ;; bindings for `makeinfo.el'r@   (define-key texinfo-mode-map "\C-c\C-m\C-k" 'kill-compilation).   (define-key texinfo-mode-map "\C-c\C-m\C-l" *     'makeinfo-recenter-compilation-buffer)?   (define-key texinfo-mode-map "\C-c\C-m\C-r" 'makeinfo-region) ?   (define-key texinfo-mode-map "\C-c\C-m\C-b" 'makeinfo-buffer)d  *   ;; bindings for updating nodes and menus  B   (define-key texinfo-mode-map "\C-c\C-um"   'texinfo-master-menu)  C   (define-key texinfo-mode-map "\C-c\C-u\C-m"   'texinfo-make-menu) E   (define-key texinfo-mode-map "\C-c\C-u\C-n"   'texinfo-update-node)iK   (define-key texinfo-mode-map "\C-c\C-u\C-e"   'texinfo-every-node-update)mJ   (define-key texinfo-mode-map "\C-c\C-u\C-a"   'texinfo-all-menus-update)  F   (define-key texinfo-mode-map "\C-c\C-s"     'texinfo-show-structure)  7   (define-key texinfo-mode-map "\C-c\C-c}"    'up-list)tH   (define-key texinfo-mode-map "\C-c\C-c]"    'up-list) ; easier to typeE   (define-key texinfo-mode-map "\C-c\C-c{"    'texinfo-insert-braces)i  #   ;; bindings for inserting strings   N   (define-key texinfo-mode-map "\C-c\C-c\C-d" 'texinfo-start-menu-description)  C   (define-key texinfo-mode-map "\C-c\C-cv"    'texinfo-insert-@var) E   (define-key texinfo-mode-map "\C-c\C-ct"    'texinfo-insert-@table)-D   (define-key texinfo-mode-map "\C-c\C-cs"    'texinfo-insert-@samp)H   (define-key texinfo-mode-map "\C-c\C-co"    'texinfo-insert-@noindent)D   (define-key texinfo-mode-map "\C-c\C-cn"    'texinfo-insert-@node)C   (define-key texinfo-mode-map "\C-c\C-ck"    'texinfo-insert-@kbd) D   (define-key texinfo-mode-map "\C-c\C-ci"    'texinfo-insert-@item)D   (define-key texinfo-mode-map "\C-c\C-cf"    'texinfo-insert-@file)G   (define-key texinfo-mode-map "\C-c\C-cx"    'texinfo-insert-@example)cC   (define-key texinfo-mode-map "\C-c\C-ce"    'texinfo-insert-@end)tC   (define-key texinfo-mode-map "\C-c\C-cd"    'texinfo-insert-@dfn)rE   (define-key texinfo-mode-map "\C-c\C-cc"    'texinfo-insert-@code))s   e ;;; Texinfo mode  % (defvar texinfo-chapter-level-regexp  B   "chapter\\|unnumbered \\|appendix \\|majorheading\\|chapheading"D   "*Regexp matching chapter-level headings (but not the top node).")   (defun texinfo-mode ()(   "Major mode for editing Texinfo files.     It has these extra commands: \\{texinfo-mode-map}  H   These are files that are used as input for TeX to make printed manualsE and also to be turned into Info files by \\[texinfo-format-buffer] orpA `makeinfo'.  These files must be written in a very restricted andd% modified version of TeX input format.   E   Editing commands are like text-mode except that the syntax table isiB set up so expression commands skip Texinfo bracket groups.  To seeE what the Info version of a region of the Texinfo file will look like, L use \\[texinfo-format-region].  This command runs Info on the current region, of the Texinfo file and formats it properly.  O   You can show the structure of a Texinfo file with \\[texinfo-show-structure]. A This command shows the structure of a Texinfo file by listing thedD lines with the @-sign commands for @chapter, @section, and the like.F These lines are displayed in another window called the *Occur* window.E In that window, you can position the cursor over one of the lines and E use \\[occur-mode-goto-occurrence], to jump to the corresponding spot  in the Texinfo file.  A   In addition, Texinfo mode provides commands that insert variouslC frequently used @-sign commands into the buffer.  You can use theseaE commands to save keystrokes.  And you can insert balanced braces withiB \\[texinfo-insert-braces] and later use the command \\[up-list] to$ move forward past the closing brace.  C Also, Texinfo mode provides functions for automatically creating ora2 updating menus and node pointers.  These functions  >   * insert the `Next', `Previous' and `Up' pointers of a node,0   * insert or update the menu for a section, and3   * create a master menu for a Texinfo source file.s   Here are the functions:t  >     texinfo-update-node                \\[texinfo-update-node]D     texinfo-every-node-update          \\[texinfo-every-node-update]#     texinfo-sequential-node-update    <     texinfo-make-menu                  \\[texinfo-make-menu]C     texinfo-all-menus-update           \\[texinfo-all-menus-update]o     texinfo-master-menu   ?     texinfo-indent-menu-description (column &optional region-p)c  E The `texinfo-column-for-description' variable specifies the column ton& which menu descriptions are indented.   ; Passed an argument (a prefix argument, if interactive), thenE `texinfo-update-node' and `texinfo-make-menu' functions do their jobsh in the region.  B To use the updating commands, you must structure your Texinfo fileF hierarchically, such that each `@node' line, with the exception of theA Top node, is accompanied by some kind of section line, such as anm `@chapter' or `@section' line.  B If the file has a `top' node, it must be called `top' or `Top' and be the first node in the file.  E Entering Texinfo mode calls the value of text-mode-hook, and then the  value of texinfo-mode-hook."   (interactive)n
   (text-mode)d   (setq mode-name "Texinfo")!   (setq major-mode 'texinfo-mode)a"   (use-local-map texinfo-mode-map).   (set-syntax-table texinfo-mode-syntax-table)'   (make-local-variable 'page-delimiter)    (setq page-delimiter f         (concat '          "^@node [ \t]*[Tt]op\\|^@\\("  &          texinfo-chapter-level-regexp           "\\)")).   (make-local-variable 'require-final-newline)    (setq require-final-newline t))   (make-local-variable 'indent-tabs-mode)d   (setq indent-tabs-mode nil) +   (make-local-variable 'paragraph-separate) S   (setq paragraph-separate (concat "^\b\\|^@[a-zA-Z]*[ \n]\\|" paragraph-separate))e(   (make-local-variable 'paragraph-start)M   (setq paragraph-start (concat "^\b\\|^@[a-zA-Z]*[ \n]\\|" paragraph-start)) $   (make-local-variable 'fill-column)   (setq fill-column 72) &   (make-local-variable 'comment-start)   (setq comment-start "@c ")+   (make-local-variable 'comment-start-skip)o"   (setq comment-start-skip "@c +").   (make-local-variable 'words-include-escapes)    (setq words-include-escapes t)0   (make-local-variable 'texinfo-start-of-header)+   (setq texinfo-start-of-header "%**start")o.   (make-local-variable 'texinfo-end-of-header)'   (setq texinfo-end-of-header "%**end")t1   (run-hooks 'text-mode-hook 'texinfo-mode-hook))-   x/ ;;; Define start and end of header expressions m  E ;; The start-of-header and end-of-header expressions are defined heretC ;; since they used by both by `texinfmt.el' and by `texnfo-tex.el', 8 ;; only one of which is likely to be loaded at one time.  * (defvar texinfo-start-of-header "%**start";   "String to mark start of header for texinfo-tex-region.")t  & (defvar texinfo-end-of-header "%**end"9   "String to mark end of header for texinfo-tex-region.")a   i ;;; Insert string commands  $ (defconst texinfo-environment-regexp   "^@\\(f?table\\|enumerate\\|itemize\\|ifinfo\\|iftex\\|example\\|quotation\\|lisp\\|smallexample\\|smalllisp\\|display\\|format\\|flushleft\\|flushright\\|ignore\\|group\\|tex\\)"x5   "Regexp for environment-like TexInfo list commands.-G Subexpression 1 is what goes into the corresponding `@end' statement.")t  C ;; The following texinfo-insert-@end command not only inserts a SPCeC ;; after the @end, but tries to find out what belongs there.  It isi7 ;; not very smart: it does not understand nested lists.t   (defun texinfo-insert-@end ()dD   "Insert the matching `@end' for a @table etc. in a texinfo buffer.' BUG: Does not understand nested lists."e   (interactive)-   (let ((string (save-excursioni'                 (if (re-search-backward 7                      texinfo-environment-regexp nil t) e9                     (buffer-substring (match-beginning 1) 8                                       (match-end 1))))))     (insert "@end ")!     (if string (insert string))))m  ( ; Earlier version of texinfo-insert-@end ; (defun texinfo-insert-@end () N ;   "Insert the string `@end ' (end followed by a space) in a texinfo buffer." ;   (interactive)e ;   (insert "@end "))t  D ;; The following insert commands accept a prefix arg N, which is theB ;; number of words (actually s-exprs) that should be surrounded byD ;; braces.  Thus you can first paste a variable name into a .texinfo@ ;; buffer, then say C-u 1 C-c C-c v at the beginning of the justD ;; pasted variable name to put @var{...} *around* the variable name.7 ;; Operate on previous word or words with negative arg.f  / ;; These commands use texinfo-insert-@-with-arg 7 (defun texinfo-insert-@-with-arg (string &optional arg)k
   (if arg        (progn-         (setq arg (prefix-numeric-value arg))-         (if (< arg 0)e             (progn/               (skip-chars-backward " \t\n\r\f")n               (save-excursionu"                 (forward-sexp arg)(                 (insert "@" string "{"))               (insert "}")))*           (skip-chars-forward " \t\n\r\f")!           (insert "@" string "{")i           (forward-sexp arg)           (insert "}")))     (insert "@" string "{}")     (backward-char)))o   (defun texinfo-insert-braces ()o>   "Make a pair of braces and be poised to type inside of them.3 Use \\[up-list] to move forward out of the braces."e   (interactive)p   (insert "{}")t   (backward-char))    ; (defun texinfo-insert-@code ()2 ;   "Insert the string @code in a texinfo buffer." ;   (interactive)C ;   (insert "@code{}") ;   (backward-char))  + (defun texinfo-insert-@code (&optional arg)s0   "Insert the string @code in a texinfo buffer."   (interactive "P")i)   (texinfo-insert-@-with-arg "code" arg))p   ; (defun texinfo-insert-@dfn ()d1 ;   "Insert the string @dfn in a texinfo buffer."t ;   (interactive)) ;   (insert "@dfn{}")- ;   (backward-char))  * (defun texinfo-insert-@dfn (&optional arg)/   "Insert the string @dfn in a texinfo buffer."e   (interactive "P")i(   (texinfo-insert-@-with-arg "dfn" arg))  ! (defun texinfo-insert-@example ()m3   "Insert the string @example in a texinfo buffer."e   (interactive)p   (insert "@example\n"))  + (defun texinfo-insert-@file (&optional arg)a0   "Insert the string @file in a texinfo buffer."   (interactive "P")\)   (texinfo-insert-@-with-arg "file" arg))t    ; (defun texinfo-insert-@item ()2 ;   "Insert the string @item in a texinfo buffer." ;   (interactive)  ;   (insert "@item") ;   (newline))   (defun texinfo-insert-@item ()0   "Insert the string @item in a texinfo buffer."   (interactive)m   (insert "@item")   (newline))   ; (defun texinfo-insert-@kbd ()f1 ;   "Insert the string @kbd in a texinfo buffer."i ;   (interactive)  ;   (insert "@kbd{}")o ;   (backward-char))  * (defun texinfo-insert-@kbd (&optional arg)/   "Insert the string @kbd in a texinfo buffer."c   (interactive "P")b(   (texinfo-insert-@-with-arg "kbd" arg))    ; (defun texinfo-insert-@node ()2 ;   "Insert the string @node in a texinfo buffer, : ; along with a comment indicating the arguments to @node." ;   (interactive)pA ;   (insert "@node \n@comment  node-name,  next,  previous,  up")t ;   (forward-line -1)  ;   (forward-char 6))e   (defun texinfo-insert-@node ()0   "Insert the string @node in a texinfo buffer, 8 along with a comment indicating the arguments to @node."   (interactive) ?   (insert "@node \n@comment  node-name,  next,  previous,  up")c   (forward-line -1)    (forward-char 6))c  $ ; (defun texinfo-insert-@noindent ()6 ;   "Insert the string @noindent in a texinfo buffer." ;   (interactive)r ;   (insert "@noindent\n"))a  " (defun texinfo-insert-@noindent ()4   "Insert the string @noindent in a texinfo buffer."   (interactive)n   (insert "@noindent\n"))r    ; (defun texinfo-insert-@samp ()2 ;   "Insert the string @samp in a texinfo buffer." ;   (interactive)n ;   (insert "@samp{}") ;   (backward-char))  + (defun texinfo-insert-@samp (&optional arg)n0   "Insert the string @samp in a texinfo buffer."   (interactive "P")o)   (texinfo-insert-@-with-arg "samp" arg))t  , (defun texinfo-insert-@table (&optional arg)1   "Insert the string @table in a texinfo buffer."e   (interactive "P")    (insert "@table "))d   ; (defun texinfo-insert-@var ()n1 ;   "Insert the string @var in a texinfo buffer."i ;   (interactive)t ;   (insert "@var{}")i ;   (backward-char))  * (defun texinfo-insert-@var (&optional arg)/   "Insert the string @var in a texinfo buffer."    (interactive "P")u(   (texinfo-insert-@-with-arg "var" arg))   i ;;; Texinfo file structure  - ; The following is defined in `texnfo-upd.el'm& ; (defvar texinfo-section-types-regexp` ;   "^@\\(chapter \\|sect\\|subs\\|subh\\|unnum\\|major\\|chapheading \\|heading \\|appendix\\)"O ;   "Regexp matching chapter, section, other headings (but not the top node).")e  8 ; The other regexps are defined in `texnfo-upd.el' also.4 (defun texinfo-show-structure (&optional nodes-too) (   "Show the structure of a Texinfo file.B List the lines in the file that begin with the @-sign commands for! @chapter, @section, and the like.'  C With optional argument (prefix if interactive), list both the lines'C with @-sign commands for @chapter, @section, and the like, and listh @node lines.  B Lines with structuring commands beginning in them are displayed inB another window called the *Occur* window.  In that window, you can1 position the cursor over one of the lines and usea  \\[occur-mode-goto-occurrence], 7 to jump to the corresponding spot in the Texinfo file."      (interactive "P")r   (require 'texnfo-upd)    (save-excursion      (goto-char (point-min))x     (if nodes-toorG         (occur (concat "\\(^@node\\)\\|" texinfo-section-types-regexp)) ,       (occur texinfo-section-types-regexp)))   (pop-to-buffer "*Occur*")d   (goto-char (point-min))n   (flush-lines "-----")b;   ;; Now format the "*Occur*" buffer to show the structure."/   ;; Thanks to ceder@signum.se (Per Cederqvist)    (goto-char (point-max))a   (let ((margin 5)) 2     (while (re-search-backward "^ *[0-9]*:" nil 0)       (re-search-forward ":")a       (setq margin             (condcG              ((looking-at (concat "@" texinfo-chapter-level-regexp)) 5) ,              ;; ((looking-at "@chapter ") 5)/              ;; ((looking-at "@unnumbered ") 5)k-              ;; ((looking-at "@appendix ") 5)t1              ;; ((looking-at "@majorheading ") 5)'0              ;; ((looking-at "@chapheading ") 5)  G              ((looking-at (concat "@" texinfo-section-level-regexp)) 9)t,              ;; ((looking-at "@section ") 9)2              ;; ((looking-at "@unnumberedsec ") 9)0              ;; ((looking-at "@appendixsec ") 9),              ;; ((looking-at "@heading ") 9)  K              ((looking-at (concat "@" texinfo-subsection-level-regexp)) 13)n0              ;; ((looking-at "@subsection ") 13)6              ;; ((looking-at "@unnumberedsubsec ") 13)4              ;; ((looking-at "@appendixsubsec ") 13)0              ;; ((looking-at "@subheading ") 13)  N              ((looking-at (concat "@" texinfo-subsubsection-level-regexp)) 17)3              ;; ((looking-at "@subsubsection ") 17)n9              ;; ((looking-at "@unnumberedsubsubsec ") 17)i7              ;; ((looking-at "@appendixsubsubsec ") 17)i3              ;; ((looking-at "@subsubheading ") 17)r              (t margin)))g       (indent-to-column margin)l       (beginning-of-line))))   w! ;;; Place provide at end of file.n (provide 'texinfo)0 ;;;;;;;;;;;;;;;; end texinfo.el ;;;;;;;;;;;;;;;;