 ;;;; texnfo-tex.el  4 ;;; Texinfo mode TeX and hardcopy printing commands.  F ;; These commands are for running TeX on a region of a Texinfo file inD ;; GNU Emacs, or on the whole buffer, and for printing the resulting ;; DVI file.  # ;;; Version 2.07    22 October 1991  ;;; Robert J. Chassell      < ;;; Please send bug reports to:  bug-texinfo@prep.ai.mit.edu  A ;;; Copyright (C) 1989, 1990, 1991 Free Software Foundation, Inc.     # ;;; This file is part of GNU Emacs.   D ;; GNU Emacs is free software; you can redistribute it and/or modifyG ;; it under the terms of the GNU General Public License as published by F ;; the Free Software Foundation; either version 1, or (at your option) ;; any later version.   ? ;; GNU Emacs is distributed in the hope that it will be useful, A ;; but WITHOUT ANY WARRANTY; without even the implied warranty of @ ;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/ ;; GNU General Public License for more details.   D ;; You should have received a copy of the GNU General Public License@ ;; along with GNU Emacs; see the file COPYING.  If not, write toH ;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.    . ;;; The Texinfo mode TeX related commands are:  = ; texinfo-tex-region        to run tex on the current region. = ; texinfo-tex-buffer        to run tex on the current buffer. 9 ; texinfo-texindex          to sort unsorted index files. ? ; texinfo-tex-print         to print the .dvi file made by tex. B ; texinfo-kill-tex-job      to kill the currently running tex job.G ; texinfo-recenter-tex-output-buffer    to redisplay tex output buffer. @ ; texinfo-show-tex-print-queue          to show the print queue.    6 ;;; Keys common both to Texinfo mode and to TeX shell.   ;; Defined in `texinfo.el', ; (defun texinfo-define-common-keys (keymap)H ;   "Define the keys both in Texinfo mode and in the texinfo-tex-shell."? ;   (define-key keymap "\C-c\C-t\C-k"    'texinfo-kill-tex-job) ? ;   (define-key keymap "\C-c\C-t\C-x"    'texinfo-quit-tex-job) M ;   (define-key keymap "\C-c\C-t\C-l"    'texinfo-recenter-tex-output-buffer) N ;   (define-key keymap "\C-c\C-t\C-d"    'texinfo-delete-from-tex-print-queue)G ;   (define-key keymap "\C-c\C-t\C-q"    'texinfo-show-tex-print-queue) < ;   (define-key keymap "\C-c\C-t\C-p"    'texinfo-tex-print); ;   (define-key keymap "\C-c\C-t\C-i"    'texinfo-texindex) = ;   (define-key keymap "\C-c\C-t\C-r"    'texinfo-tex-region) > ;   (define-key keymap "\C-c\C-t\C-b"    'texinfo-tex-buffer))  % ;; See also texinfo-tex-start-shell.  5 ;; The following is executed in the `texinfo.el' file . ;(texinfo-define-common-keys texinfo-mode-map)     ;;; Variable definitions:    (require 'shell)  ) (defvar texinfo-tex-shell-cd-command "cd" >   "Command to give to shell running TeX to change directory.")  ! (defvar texinfo-tex-command "tex" B   "*Command used by  texinfo-tex-region  to run tex on a region.")  + (defvar texinfo-texindex-command "texindex" F   "*Command used by  texinfo-texindex  to sort unsorted index files.")  . (defvar texinfo-tex-dvi-print-command "lpr -d"@   "*Command string used by \\[tex-print] to print a .dvi file.")  , (defvar texinfo-show-tex-queue-command "lpq"<   "*Command string used to show the Texinfo TeX print queue.: Command is used by \\[texinfo-show-tex-print-queue] and it@ should show the queue that \\[texinfo-tex-print] puts jobs on.")  6 (defvar texinfo-delete-from-print-queue-command "lprm"D   "*Command string used to delete a job from the line printer queue.C Command is used by \\[texinfo-delete-from-tex-print-queue] based on > number provided by a previous \\[texinfo-show-tex-print-queue]
 command.")  " (defvar texinfo-tex-trailer "@bye"F   "String appended after a region sent to TeX by texinfo-tex-region.")  $ (defvar texinfo-tex-original-file ""/   "Original name of file on which to run TeX.")   ! (defvar texinfo-tex-temp-file nil B   "Temporary file name used for text being sent as input to TeX.")  & (defvar texinfo-tex-root-temp-file nilB   "Temporary file name used for text being sent as input to TeX.")     ;;; Texinfo TeX main functions  ) (defun texinfo-tex-region (beginning end) "   "Run tex on the current region.   D A temporary file is written in the default directory, and tex is run? in that directory.  The first line of the file is copied to the D temporary file; and if the buffer has a header, it is written to theD temporary file before the region itself.  The buffer's header is all@ lines between the strings defined by texinfo-start-of-header andH texinfo-end-of-header inclusive.  The header must start in the first 100J lines.  The value of texinfo-tex-trailer is appended to the temporary file after the region."      (interactive "r") (   (if (get-buffer "*texinfo-tex-shell*")8       (quit-process (get-process "texinfo-tex-shell") t)     (texinfo-tex-start-shell))   "   (setq texinfo-tex-root-temp-file         (expand-file-name           (make-temp-name3           (prin1-to-string (read (buffer-name))))))    K   (let ((texinfo-tex-temp-file (concat texinfo-tex-root-temp-file ".tex")))      (save-excursion        (save-restriction          (widen)          (goto-char (point-min))          (forward-line 100)"         (let ((search-end (point))F               (header-beginning (point-min)) (header-end (point-min)))!           (goto-char (point-min)) E           ;; Copy first line, the `\input texinfo' line, to temp file             (write-region (point) A                         (save-excursion (forward-line 1) (point)) 6                         texinfo-tex-temp-file nil nil)?           ;; Don't copy first line twice if region includes it.            (forward-line 1)?           (if (< beginning  (point)) (setq beginning  (point))) G           ;; Initialize the temp file with either the header or nothing C           (if (search-forward texinfo-start-of-header search-end t)                (progn#                 (beginning-of-line) K                 (setq header-beginning (point)) ; Mark beginning of header. @                 (if (search-forward texinfo-end-of-header nil t).                     (progn (beginning-of-line)M                            (setq header-end (point)))   ; Mark end of header. J                   (setq header-beginning (point-min))))) ; Else no header.(           ;; Copy  header  to temp file.           (write-region ,            (min header-beginning beginning )            header-end '            texinfo-tex-temp-file t nil) (           ;; Copy  region  to temp file.           (write-region &            (max beginning  header-end)            end'            texinfo-tex-temp-file t nil) H           ;; This is a kludge to insert the texinfo-tex-trailer into theG           ;; texinfo-tex-temp-file.  We have to create a special buffer N           ;; in which to insert the texinfo-tex-trailer first because there isG           ;; no function with which to append a literal string directly            ;; to a file. 7           (let ((local-tex-trailer texinfo-tex-trailer) L                 (temp-buffer (get-buffer-create " texinfo-trailer-buffer")))$             (set-buffer temp-buffer)             (erase-buffer):             ;; make sure trailer isn't hidden by a comment              (insert-string "\n")=             (if local-tex-trailer (insert local-tex-trailer)) 2             (write-region (point-min) (point-max) 8                           texinfo-tex-temp-file t nil)))@         (set-process-sentinel (get-process "texinfo-tex-shell") :                               'texinfo-tex-shell-sentinel)(         (send-string "texinfo-tex-shell"=                      (concat texinfo-tex-shell-cd-command " " 5                              default-directory "\n")) (         (send-string "texinfo-tex-shell"4                      (concat texinfo-tex-command " ";                              texinfo-tex-temp-file "\n  ")) 2         (texinfo-recenter-tex-output-buffer 0)))))  " (defun texinfo-tex-buffer (buffer)   "Run TeX on current buffer. J After running TeX the first time, you may have to run \\[texinfo-texindex]' and then \\[texinfo-tex-buffer] again."    (interactive ;    (listE     ;; Sometimes you put point into *texinfo-tex-shell*; this promptse+     ;; you for the correct file regardless.f
     (if (and  G          (string= (buffer-name (current-buffer)) "*texinfo-tex-shell*") $          texinfo-tex-root-temp-file),         (read-string (format "Run TeX on: ")/                      texinfo-tex-original-file).M       (read-string (format "Run TeX on: ") (buffer-name (current-buffer))))))    A   ;; Set to original buffer if in *texinfo-tex-shell*; otherwise,f#   ;; record name of current buffer. D   (if (string= (buffer-name (current-buffer)) "*texinfo-tex-shell*")       (set-buffer buffer)t#     (setq texinfo-tex-original-file +            (buffer-name (current-buffer))));  (   (if (get-buffer "*texinfo-tex-shell*")8       (quit-process (get-process "texinfo-tex-shell") t)     (texinfo-tex-start-shell))    (cond ((null buffer-file-name)1          (error "Buffer not visiting any file!"))          ((buffer-modified-p)>          (error "Buffer has been modified since last saved!"))C         (t (set-process-sentinel (get-process "texinfo-tex-shell") o=                                  'texinfo-tex-shell-sentinel)0+            (send-string "texinfo-tex-shell"l=                         (concat texinfo-tex-shell-cd-command  #                                 " "u4                                 (file-name-directory2                                  (buffer-file-name7                                   (get-buffer buffer))) &                                 "\n"))+            (send-string "texinfo-tex-shell"fG                         (concat texinfo-tex-command " " buffer "\n  "))f            i4            ;; so the texinfo-tex-print command works+            (setq texinfo-tex-root-temp-fileh$                  (substring buffer 0>                             (or (string-match "\\.tex" buffer)2                                 (length buffer))))            -4            (texinfo-recenter-tex-output-buffer 0))))   (defun texinfo-texindex ()(   "Run texindex on unsorted index files.M The index files are made by \\[texinfo-tex-region] or \\[texinfo-tex-buffer].d< Runs the shell command defined by texinfo-texindex-command."   (interactive)d"   (send-string "texinfo-tex-shell"/                (concat texinfo-texindex-commandeB                        " " texinfo-tex-root-temp-file ".??" "\n"))+   (texinfo-recenter-tex-output-buffer nil))f   (defun texinfo-tex-print () L   "Print .dvi file made by \\[texinfo-tex-region] or \\[texinfo-tex-buffer].A Runs the shell command defined by texinfo-tex-dvi-print-command."g   (interactive)h"   (send-string "texinfo-tex-shell"4                (concat texinfo-tex-dvi-print-commandC                        " " texinfo-tex-root-temp-file ".dvi" "\n"))a+   (texinfo-recenter-tex-output-buffer nil))    o! ;;; Texinfo TeX utility functionsi  ! (defun texinfo-tex-start-shell ()s   (save-excursionr     (require 'texinfo)D     (set-buffer (make-shell "texinfo-tex-shell" "/bin/sh" nil "-v"))=     (setq texinfo-tex-shell-map (copy-keymap shell-mode-map))d6     (texinfo-define-common-keys texinfo-tex-shell-map))     (use-local-map texinfo-tex-shell-map)d'     (run-hooks 'texinfo-tex-shell-hook)e     (if (zerop (buffer-size))t         (sleep-for 1))))   (defun texinfo-quit-tex-job ()<   "Quit currently running TeX job, by sending an `x' to it."   (interactive)e-   (if (not (get-process "texinfo-tex-shell"))i&       (error "No TeX shell running."))   (save-excursioni3     (set-buffer (get-buffer "*texinfo-tex-shell*"))      (goto-char (point-max))-     (insert "x")     (shell-send-input)))   (defun texinfo-kill-tex-job ()'   "Kill the currently running TeX job."d   (interactive)-'   (if (get-process "texinfo-tex-shell")a6         ;; Use `texinfo-tex-shell-sentinel' to restart0         ;; texinfo-tex-shell after it is killed.:         (kill-process (get-process "texinfo-tex-shell"))))  1 (defun texinfo-tex-shell-sentinel (process event)n1   "Restart texinfo-tex-shell after it is killed."m   (if (equal event "killed\n")       (save-excursions+         (set-buffer  "*texinfo-tex-shell*")          (insert "\n")n$         (texinfo-tex-start-shell))))  3 (defun texinfo-recenter-tex-output-buffer (linenum)iM   "Redisplay buffer of TeX job output so that most recent output can be seen.s+ The last line of the buffer is displayed onr5 line LINE of the window, or centered if LINE is nil."o   (interactive "P")b>   (let ((texinfo-tex-shell (get-buffer "*texinfo-tex-shell*"))&         (old-buffer (current-buffer)))      (if (null texinfo-tex-shell)(         (message "No TeX output buffer")'       (pop-to-buffer texinfo-tex-shell)o%       (bury-buffer texinfo-tex-shell)r       (goto-char (point-max))        (recenter (if linenumg2                     (prefix-numeric-value linenum))                   (/ (window-height) 2)))         (pop-to-buffer old-buffer)	       )))f  & (defun texinfo-show-tex-print-queue ()C   "Show the print queue that \\[texinfo-tex-print] put your job on.uB Runs the shell command defined by texinfo-show-tex-queue-command."   (interactive)l)   (if (not (texinfo-tex-shell-running-p))s        (texinfo-tex-start-shell))"   (send-string "texinfo-tex-shell"<                (concat texinfo-show-tex-queue-command "\n"))+   (texinfo-recenter-tex-output-buffer nil)))  7 (defun texinfo-delete-from-tex-print-queue (job-number))3   "Delete job from the line printer spooling queue.'8 You are prompted for the job number (shown by a previous* \\[texinfo-show-tex-print-queue] command."4   (interactive "nPrinter job number for deletion: ")#   (if (texinfo-tex-shell-running-p)D       (texinfo-kill-tex-job)     (texinfo-tex-start-shell))"   (send-string "texinfo-tex-shell"                (concat b7                 texinfo-delete-from-print-queue-commandl                 " "d                  job-number"\n"))+   (texinfo-recenter-tex-output-buffer nil))d  % (defun texinfo-tex-shell-running-p () (   (and (get-process "texinfo-tex-shell")E        (eq (process-status (get-process "texinfo-tex-shell")) 'run)))    i# ;;; Place `provide' at end of file.e (provide 'texnfo-tex) 3 ;;;;;;;;;;;;;;;; end texnfo-tex.el ;;;;;;;;;;;;;;;; 