/ /* display.c -- How to display Info windows. */   L /* This file is part of GNU Info, a program for reading online documentation    stored in Info format.   4    Copyright (C) 1993 Free Software Foundation, Inc.  G    This program is free software; you can redistribute it and/or modify G    it under the terms of the GNU General Public License as published by F    the Free Software Foundation; either version 2, or (at your option)    any later version.   B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software<    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  -    Written by Brian Fox (bfox@ai.mit.edu). */    #include <stdio.h> #include <ctype.h> #include <sys/types.h> #include <sys/stat.h>  #include "display.h"  B extern int info_any_buffered_input_p (); /* Found in session.c. */   static void free_display ();& static DISPLAY_LINE **make_display ();  G /* An array of display lines which tell us what is currently visible on     the display.  */ 3 DISPLAY_LINE **the_display = (DISPLAY_LINE **)NULL;   " /* Non-zero means do no output. */ int display_inhibited = 0;  E /* Initialize THE_DISPLAY to WIDTH and HEIGHT, with nothing in it. */  void* display_initialize_display (width, height)      int width, height;  {    free_display (the_display); -   the_display = make_display (width, height); &   display_clear_display (the_display); }   @ /* Clear all of the lines in DISPLAY making the screen blank. */ void display_clear_display (display)       DISPLAY_LINE **display; {    register int i; &   register DISPLAY_LINE *display_line;  -   for (i = 0; display_line = display[i]; i++)      { !       display[i]->text[0] = '\0';        display[i]->textlen = 0;       display[i]->inverse = 0;     }  }   : /* Non-zero if we didn't completely redisplay a window. */" int display_was_interrupted_p = 0;  I /* Update the windows pointed to by WINDOW in the_display.  This actually $    writes the text on the screen. */ void display_update_display (window)       WINDOW *window; {    register WINDOW *win;       display_was_interrupted_p = 0;  I   /* For every window in the list, check contents against the display. */ *   for (win = window; win; win = win->next)     { @       /* Only re-display visible windows which need updating. */2       if (((win->flags & W_WindowVisible) == 0) ||* 	  ((win->flags & W_UpdateWindow) == 0) || 	  (win->height == 0))
 	continue;  &       display_update_one_window (win);$       if (display_was_interrupted_p) 	break;      }   $   /* Always update the echo area. */,   display_update_one_window (the_echo_area); }   F /* Display WIN on the_display.  Unlike display_update_display (), this$    function only does one window. */ void display_update_one_window (win)       WINDOW *win;  { >   register char *nodetext;	/* Current character to display. */N   register char *last_node_char; /* Position of the last character in node. */+   register int i;		/* General use index. */ 7   char *printed_line;		/* Buffer for a printed line. */ 3   int pl_index = 0;		/* Index into PRINTED_LINE. */ 9   int line_index = 0;		/* Number of lines done so far. */ '   DISPLAY_LINE **display = the_display;   G   /* If display is inhibited, that counts as an interrupted display. */    if (display_inhibited)"     display_was_interrupted_p = 1;  G   /* If the window has no height, or display is inhibited, quit now. */ (   if (!win->height || display_inhibited)     return;   D   /* If the window's first row doesn't appear in the_screen, then itD      cannot be displayed.  This can happen when the_echo_area is theG      window to be displayed, and the screen has shrunk to less than one 
      line. */ D   if ((win->first_row < 0) || (win->first_row > the_screen->height))     return;   B   /* Print each line in the window into our local buffer, and thenD      check the contents of that buffer against the display.  If they#      differ, update the display. */ 2   printed_line = (char *)xmalloc (1 + win->width);  &   if (!win->node || !win->line_starts)      goto done_with_node_display;  ,   nodetext = win->line_starts[win->pagetop];<   last_node_char = win->node->contents + win->node->nodelen;  /   for (; nodetext < last_node_char; nodetext++)      { 0       char *rep, *rep_carried_over, rep_temp[2];       int replen;          if (isprint (*nodetext)) 	{ 	  rep_temp[0] = *nodetext;  	  replen = 1; 	  rep_temp[1] = '\0'; 	  rep = rep_temp; 	}
       else 	{. 	  if (*nodetext == '\r' || *nodetext == '\n') 	    {& 	      replen = win->width - pl_index; 	    } 	  else  	    {: 	      rep = printed_representation (*nodetext, pl_index); 	      replen = strlen (rep);  	    } 	}  F       /* If this character can be printed without passing the width of+ 	 the line, then stuff it into the line. */ )       if (replen + pl_index < win->width)  	{ 	  /* Optimize if possible. */ 	  if (replen == 1)  	    {' 	      printed_line[pl_index++] = *rep;  	    } 	  else  	    {# 	      for (i = 0; i < replen; i++) $ 		printed_line[pl_index++] = rep[i]; 	    } 	}
       else 	{ 	  DISPLAY_LINE *entry;   ? 	  /* If this character cannot be printed in this line, we have B 	     found the end of this line as it would appear on the screen.? 	     Carefully print the end of the line, and then compare. */ C 	  if (*nodetext == '\n' || *nodetext == '\r' || *nodetext == '\t')  	    {% 	      printed_line[pl_index] = '\0'; ' 	      rep_carried_over = (char *)NULL;  	    } 	  else  	    {C 	      /* The printed representation of this character extends into < 		 the next line.  Remember the offset of the last character= 		 printed out of REP so that we can carry the character over  		 to the next line. */ 0 	      for (i = 0; pl_index < (win->width - 1);)& 		printed_line[pl_index++] = rep[i++]; 	       " 	      rep_carried_over = rep + i;  @ 	      /* If printing the last character in this window couldn't9 		 possibly cause the screen to scroll, place a backslash  		 in the rightmost column. */@ 	      if (1 + line_index + win->first_row < the_screen->height) 		{  		  if (win->flags & W_NoWrap)% 		    printed_line[pl_index++] = '$';  		  else& 		    printed_line[pl_index++] = '\\'; 		} % 	      printed_line[pl_index] = '\0';  	    }  ? 	  /* We have the exact line as it should appear on the screen. A 	     Check to see if this line matches the one already appearing  	     on the screen. */ 0 	  entry = display[line_index + win->first_row];  ; 	  /* If the screen line is inversed, then we have to clear < 	     the line from the screen first.  Why, I don't know. */ 	  if (entry->inverse) 	    {9 	      terminal_goto_xy (0, line_index + win->first_row);   	      terminal_clear_to_eol (); 	      entry->inverse = 0; 	      entry->text[0] = '\0';  	      entry->textlen = 0; 	    }  2 	  /* Find the offset where these lines differ. */! 	  for (i = 0; i < pl_index; i++) + 	    if (printed_line[i] != entry->text[i]) 
 	      break;   ? 	  /* If the lines are not the same length, or if they differed + 	     at all, we must do some redrawing. */ 7 	  if ((i != pl_index) || (pl_index != entry->textlen))  	    {6 	      /* Move to the proper point on the terminal. */9 	      terminal_goto_xy (i, line_index + win->first_row);   5 	      /* If there is any text to print, print it. */  	      if (i != pl_index) ' 		terminal_put_text (printed_line + i);   C 	      /* If the printed text didn't extend all the way to the edge = 		 of the window, and text was appearing between here and the A 		 edge of the window, clear from here to the end of the line. */ B 	      if ((pl_index < win->width && pl_index < entry->textlen) || 		  (entry->inverse))  		terminal_clear_to_eol ();    	      fflush (stdout);   , 	      /* Update the display text buffer. */2 	      strcpy (entry->text + i, printed_line + i);! 	      entry->textlen = pl_index;w  E 	      /* Lines showing node text are not in inverse.  Only modelinesd 		 have that distinction. */ 	      entry->inverse = 0; 	    }  @ 	  /* We have done at least one line.  Increment our screen line; 	     index, and check against the bottom of the window. */ # 	  if (++line_index == win->height)p 	    break;   D 	  /* A line has been displayed, and the screen reflects that state.D 	     If there is typeahead pending, then let that typeahead be read5 	     now, instead of continuing with the display. */t$ 	  if (info_any_buffered_input_p ()) 	    { 	      free (printed_line);T% 	      display_was_interrupted_p = 1;l 	      return; 	    }  1 	  /* Reset PL_INDEX to the start of the line. */h 	  pl_index = 0;  @ 	  /* If there are characters from REP left to print, stuff them 	     into the buffer now. */5 	  if (rep_carried_over)& 	    for (; rep[pl_index]; pl_index++). 	      printed_line[pl_index] = rep[pl_index];  B 	  /* If this window has chosen not to wrap lines, skip to the endG 	     of the physical line in the buffer, and start a new line here. */s+ 	  if (pl_index && (win->flags & W_NoWrap))t 	    { 	      char *begin;l   	      pl_index = 0; 	      printed_line[0] = '\0';   	      begin = nodetext; 	      sA 	      while ((nodetext < last_node_char) && (*nodetext != '\n')) 
 		nodetext++;n 	    } 	}     }     done_with_node_display:I   /* We have reached the end of the node or the end of the window.  If itoI      is the end of the node, then clear the lines of the window from here !      to the end of the window. */ 0   for (; line_index < win->height; line_index++)     {lA       DISPLAY_LINE *entry = display[line_index + win->first_row];L  =       /* If this line has text on it then make it go away. */l"       if (entry && entry->textlen) 	{ 	  entry->textlen = 0; 	  entry->text[0] = '\0';y  5 	  terminal_goto_xy (0, line_index + win->first_row);  	  terminal_clear_to_eol (); 	}     }   L   /* Finally, if this window has a modeline it might need to be redisplayed.K      Check the window's modeline against the one in the display, and updaten      if necessary. */U(   if ((win->flags & W_InhibitMode) == 0)     {p!       window_make_modeline (win); 0       line_index = win->first_row + win->height;  E       /* This display line must both be in inverse, and have the samep 	 contents. */,       if ((!display[line_index]->inverse) ||< 	  (strcmp (display[line_index]->text, win->modeline) != 0)) 	{$ 	  terminal_goto_xy (0, line_index); 	  terminal_begin_inverse ();s% 	  terminal_put_text (win->modeline);i 	  terminal_end_inverse ();=5 	  strcpy (display[line_index]->text, win->modeline);($ 	  display[line_index]->inverse = 1;9 	  display[line_index]->textlen = strlen (win->modeline);n 	  fflush (stdout);  	}     }   8   /* Okay, this window doesn't need updating anymore. */    win->flags &= ~W_UpdateWindow;   free (printed_line);   fflush (stdout); }t  I /* Scroll the region of the_display starting at START, ending at END, andeI    moving the lines AMOUNT lines.  If AMOUNT is less than zero, the linesuH    are moved up in the screen, otherwise down.  Actually, it is possibleG    for no scrolling to take place in the case that the terminal doesn'tn-    support it.  This doesn't matter to us. */a void+ display_scroll_display (start, end, amount)n      int start, end, amount; {i   register int i, last;i   DISPLAY_LINE *temp;   :   /* If this terminal cannot do scrolling, give up now. */   if (!terminal_can_scroll)n     return;p  F   /* If there isn't anything displayed on the screen because it is too      small, quit now. */   if (!the_display[0])     return;   L   /* If there is typeahead pending, then don't actually do any scrolling. */#   if (info_any_buffered_input_p ())t     return;e     /* Do it on the screen. */0   terminal_scroll_terminal (start, end, amount);  I   /* Now do it in the display buffer so our contents match the screen. */.   if (amount > 0)i     {        last = end + amount;  7       /* Shift the lines to scroll right into place. */ )       for (i = 0; i < (end - start); i++)  	{  	  temp = the_display[last - i];0 	  the_display[last - i] = the_display[end - i]; 	  the_display[end - i] = temp;e 	}  J       /* The lines have been shifted down in the buffer.  Clear all of the 	 lines that were vacated. */ 1       for (i = start; i != (start + amount); i++)a 	{" 	  the_display[i]->text[0] = '\0'; 	  the_display[i]->textlen = 0;t 	  the_display[i]->inverse = 0;  	}     }      if (amount < 0)a     {v       last = start + amount;)       for (i = 0; i < (end - start); i++){ 	{  	  temp = the_display[last + i];2 	  the_display[last + i] = the_display[start + i];! 	  the_display[start + i] = temp;e 	}  H       /* The lines have been shifted up in the buffer.  Clear all of the 	 lines that are left over. */+       for (i = end + amount; i != end; i++)l 	{" 	  the_display[i]->text[0] = '\0'; 	  the_display[i]->textlen = 0;c 	  the_display[i]->inverse = 0;a 	}     }i }   N /* Try to scroll lines in WINDOW.  OLD_PAGETOP is the pagetop of WINDOW beforeK    having had its line starts recalculated.  OLD_STARTS is the list of line O    starts that used to appear in this window.  OLD_COUNT is the number of lines *    that appear in the OLD_STARTS array. */ voidG display_scroll_line_starts (window, old_pagetop, old_starts, old_count)       WINDOW *window;       int old_pagetop, old_count;      char **old_starts;f {iF   register int i, old, new;	/* Indices into the line starts arrays. */?   int last_new, last_old;	/* Index of the last visible line. */nB   int old_first, new_first;	/* Index of the first changed line. */   int unchanged_at_top = 0;p   int already_scrolled = 0;   D   /* Locate the first line which was displayed on the old window. */   old_first = old_pagetop;   new_first = window->pagetop;  <   /* Find the last line currently visible in this window. */4   last_new = window->pagetop + (window->height - 1);$   if (last_new > window->line_count)&     last_new = window->line_count - 1;  M   /* Find the last line which used to be currently visible in this window. */ 0   last_old = old_pagetop + (window->height - 1);   if (last_old > old_count)o     last_old = old_count - 1;h  (   for (old = old_first, new = new_first;(        old < last_old && new < last_new;        old++, new++)4     if (old_starts[old] != window->line_starts[new])       break;     else       unchanged_at_top++;\  H   /* Loop through the old lines looking for a match in the new lines. */A   for (old = old_first + unchanged_at_top; old < last_old; old++)e     {s2       for (new = new_first; new < last_new; new++)1 	if (old_starts[old] == window->line_starts[new])- 	  {1 	    /* Find the extent of the matching lines. */n+ 	    for (i = 0; (old + i) < last_old; i++)c? 	      if (old_starts[old + i] != window->line_starts[new + i]){ 		break;  : 	    /* Scroll these lines if there are enough of them. */ 	    { 	      int start, end, amount;  ! 	      start = (window->first_row\5 		       + ((old + already_scrolled) - old_pagetop));t/ 	      amount = new - (old + already_scrolled); 0 	      end = window->first_row + window->height;  C 	      /* If we are shifting the block of lines down, then the lasts: 		 AMOUNT lines will become invisible.  Thus, don't bother 		 scrolling them. */i 	      if (amount > 0) 		end -= amount;   	      if ((end - start) > 0)e 		{h0 		  display_scroll_display (start, end, amount);  = 		  /* Some lines have been scrolled.  Simulate the scrollinge3 		     by offsetting the value of the old index. */ 
 		  old += i;e 		  already_scrolled += amount;) 		}  	    } 	  }     }t }t  N /* Move the screen cursor to directly over the current character in WINDOW. */ void  display_cursor_at_point (window)      WINDOW *window; {t   int vpos, hpos;n  M   vpos = window_line_of_point (window) - window->pagetop + window->first_row;e+   hpos = window_get_cursor_column (window);     terminal_goto_xy (hpos, vpos); }   F /* **************************************************************** */ /*								    */. /*		     Functions Static to this File		    */ /*								    */F /* **************************************************************** */  3 /* Make a DISPLAY_LINE ** with width and height. */e static DISPLAY_LINE ** make_display (width, height)      int width, height;t {b   register int i;.   DISPLAY_LINE **display;=  N   display = (DISPLAY_LINE **)xmalloc ((1 + height) * sizeof (DISPLAY_LINE *));     for (i = 0; i < height; i++)     {eC       display[i] = (DISPLAY_LINE *)xmalloc (sizeof (DISPLAY_LINE)); 5       display[i]->text = (char *)xmalloc (1 + width);r       display[i]->textlen = 0;       display[i]->inverse = 0;     }s$   display[i] = (DISPLAY_LINE *)NULL;   return (display);  }I  , /* Free the storage allocated to DISPLAY. */ static void  free_display (display)      DISPLAY_LINE **display; {m   register int i;f&   register DISPLAY_LINE *display_line;     if (!display)i     return;e  -   for (i = 0; display_line = display[i]; i++)x     {         free (display_line->text);       free (display_line);     }    free (display);i }i