9 /* echo_area.c -- How to read a line in the echo area. */   L /* This file is part of GNU Info, a program for reading online documentation    stored in Info format.   4    Copyright (C) 1993 Free Software Foundation, Inc.  G    This program is free software; you can redistribute it and/or modify G    it under the terms of the GNU General Public License as published by F    the Free Software Foundation; either version 2, or (at your option)    any later version.   B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software<    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  -    Written by Brian Fox (bfox@ai.mit.edu). */    #include "info.h"   = /* Non-zero means that C-g was used to quit reading input. */  int info_aborted_echo_area = 0;   D /* Non-zero means that the echo area is being used to read input. */ int echo_area_is_active = 0;  @ /* The address of the last command executed in the echo area. */8 VFunction *ea_last_executed_command = (VFunction *)NULL;  D /* Non-zero means that the last command executed while reading input    killed some text. */ ( int echo_area_last_command_was_kill = 0;  E /* Variables which hold on to the current state of the input line. */ ) static char input_line[1 + EA_MAX_INPUT];  static char *input_line_prompt;  static int input_line_point; static int input_line_beg; static int input_line_end; static NODE input_line_node = { G   (char *)NULL, (char *)NULL, (char *)NULL, input_line, EA_MAX_INPUT, 0  };  ) static void echo_area_initialize_node (); 0 static void push_echo_area (), pop_echo_area ();O static int echo_area_stack_depth (), echo_area_stack_contains_completions_p ();    static void ea_kill_text ();  3 /* Non-zero means we force the user to complete. */ ) static int echo_area_must_complete_p = 0; # static int completions_window_p ();   J /* If non-null, this is a window which was specifically created to displayH    possible completions output.  We remember it so we can delete it when    appropriate. */= static WINDOW *echo_area_completions_window = (WINDOW *)NULL;   E /* Variables which keep track of the window which was active prior to     entering the echo area. */ / static WINDOW *calling_window = (WINDOW *)NULL; 0 static NODE *calling_window_node = (NODE *)NULL;% static long calling_window_point = 0; ' static long calling_window_pagetop = 0;   F /* Remember the node and pertinent variables of the calling window. */ static void   remember_calling_window (window)      WINDOW *window; { J   /* Only do this if the calling window is not the completions window, or,E      if it is the completions window and there is no other window. */ '   if (!completions_window_p (window) || /       ((window == windows) && !(window->next)))      {        calling_window = window;)       calling_window_node = window->node; +       calling_window_point = window->point; /       calling_window_pagetop = window->pagetop;      }  }   L /* Restore the caller's window so that it shows the node that it was showing-    on entry to info_read_xxx_echo_area (). */  static void  restore_calling_window ()  { 2   register WINDOW *win, *compwin = (WINDOW *)NULL;  F   /* If the calling window is still visible, and it is the window thatH      we used for completions output, then restore the calling window. */+   for (win = windows; win; win = win->next)      { %       if (completions_window_p (win))  	compwin = win;   2       if (win == calling_window && win == compwin) 	{C 	  window_set_node_of_window (calling_window, calling_window_node); 0 	  calling_window->point = calling_window_point;4 	  calling_window->pagetop = calling_window_pagetop; 	  compwin = (WINDOW *)NULL;	 	  break;  	}     }   G   /* Delete the completions window if it is still present, it isn't the J      last window on the screen, and there aren't any prior echo area reads3      pending which created a completions window. */    if (compwin)     { 2       if ((compwin != windows || windows->next) &&. 	  !echo_area_stack_contains_completions_p ()) 	{ 	  WINDOW *next;# 	  int pagetop, start, end, amount;    	  next = compwin->next; 	  if (next) 	    { 	      start = next->first_row; " 	      end = start + next->height;( 	      amount = - (compwin->height + 1); 	      pagetop = next->pagetop;  	    }  ) 	  info_delete_window_internal (compwin);   B 	  /* This is not necessary because info_delete_window_internal ()A 	     calls echo_area_inform_of_deleted_window (), which does the  	     right thing. */  #if defined (UNNECESSARY) 1 	  echo_area_completions_window = (WINDOW *)NULL;  #endif /* UNNECESSARY */   	  if (next) 	    {3 	      display_scroll_display (start, end, amount);  	      next->pagetop = pagetop; ( 	      display_update_display (windows); 	    } 	}     }  }   * /* Set up a new input line with PROMPT. */ static void  initialize_input_line (prompt)      char *prompt; {    input_line_prompt = prompt; 
   if (prompt)       strcpy (input_line, prompt);   else     input_line[0] = '\0';   G   input_line_beg = input_line_end = input_line_point = strlen (prompt);  }   
 static char *  echo_area_after_read ()  {    char *return_value;      if (info_aborted_echo_area)      { !       info_aborted_echo_area = 0; "       return_value = (char *)NULL;     }    else     { +       if (input_line_beg == input_line_end)   	return_value = savestring ("");
       else 	{2 	  int line_len = input_line_end - input_line_beg;2 	  return_value = (char *) xmalloc (1 + line_len);A 	  strncpy (return_value, &input_line[input_line_beg], line_len); ! 	  return_value[line_len] = '\0';  	}     }    return (return_value); }   G /* Read a line of text in the echo area.  Return a malloc ()'ed string, I    or NULL if the user aborted out of this read.  WINDOW is the currently H    active window, so that we can restore it when we need to.  PROMPT, if=    non-null, is a prompt to print before reading the line. */  char *' info_read_in_echo_area (window, prompt)       WINDOW *window;      char *prompt; { 
   char *line;   G   /* If the echo area is already active, remember the current state. */    if (echo_area_is_active)     push_echo_area ();  '   /* Initialize our local variables. */ !   initialize_input_line (prompt);   M   /* Initialize the echo area for the first (but maybe not the last) time. */    echo_area_initialize_node ();   G   /* Save away the original node of this window, and the window itself, >      so echo area commands can temporarily use this window. */#   remember_calling_window (window);   ?   /* Let the rest of Info know that the echo area is active. */    echo_area_is_active++;    active_window = the_echo_area;  )   /* Read characters in the echo area. */    info_read_and_dispatch ();     echo_area_is_active--;  @   /* Restore the original active window and show point in it. */!   active_window = calling_window;    restore_calling_window ();*   display_cursor_at_point (active_window);   fflush (stdout);  "   /* Get the value of the line. */!   line = echo_area_after_read ();   C   /* If there is a previous loop waiting for us, restore it now. */    if (echo_area_is_active)     pop_echo_area ();   )   /* Return the results to the caller. */    return (line); }   ) /* (re) Initialize the echo area node. */  static void  echo_area_initialize_node () {    register int i;   8   for (i = input_line_end; i < sizeof (input_line); i++)     input_line[i] = ' ';     input_line[i - 1] = '\n'; >   window_set_node_of_window (the_echo_area, &input_line_node);$   input_line[input_line_end] = '\n'; }   H /* Prepare to read characters in the echo area.  This can initialize theF    echo area node, but its primary purpose is to side effect the input    line buffer contents. */  void echo_area_prep_read () { .   if (the_echo_area->node != &input_line_node)!     echo_area_initialize_node ();   *   the_echo_area->point = input_line_point;$   input_line[input_line_end] = '\n';,   display_update_one_window (the_echo_area);*   display_cursor_at_point (active_window); }n   nF /* **************************************************************** */ /*								    */, /*		     Echo Area Movement Commands		    */ /*								    */F /* **************************************************************** */  = DECLARE_INFO_COMMAND (ea_forward, "Move forward a character")h {o   if (count < 0)&     ea_backward (window, -count, key);   else     {         input_line_point += count;,       if (input_line_point > input_line_end)# 	input_line_point = input_line_end;      }e }t  ? DECLARE_INFO_COMMAND (ea_backward, "Move backward a character")l {L   if (count < 0)%     ea_forward (window, -count, key);F   else     {         input_line_point -= count;,       if (input_line_point < input_line_beg)# 	input_line_point = input_line_beg;u     }o }   G DECLARE_INFO_COMMAND (ea_beg_of_line, "Move to the start of this line")o {o$   input_line_point = input_line_beg; }   E DECLARE_INFO_COMMAND (ea_end_of_line, "Move to the end of this line")v { $   input_line_point = input_line_end; }e  A #define alphabetic(c) (islower (c) || isupper (c) || isdigit (c))V  , /* Move forward a word in the input line. */= DECLARE_INFO_COMMAND (ea_forward_word, "Move forward a word")* {    int c;     if (count < 0)+     ea_backward_word (window, -count, key);h   else     {        while (count--)  	{* 	  if (input_line_point == input_line_end) 	    return;  @ 	  /* If we are not in a word, move forward until we are in one.D 	     Then, move forward until we hit a non-alphabetic character. */$ 	  c = input_line[input_line_point];   	  if (!alphabetic (c))T 	    {2 	      while (++input_line_point < input_line_end) 		{i% 		  c = input_line[input_line_point];  		  if (alphabetic (c))k 		    break; 		}a 	    }  * 	  if (input_line_point == input_line_end) 	    return;  . 	  while (++input_line_point < input_line_end) 	    {( 	      c = input_line[input_line_point]; 	      if (!alphabetic (c))_ 		break; 	    } 	}     }s }   ? DECLARE_INFO_COMMAND (ea_backward_word, "Move backward a word")p {i   int c;     if (count < 0)*     ea_forward_word (window, -count, key);   else     {e       while (count--)n 	{* 	  if (input_line_point == input_line_beg) 	    return;  9 	  /* Like ea_forward_word (), except that we look at the.& 	     characters just before point. */  ( 	  c = input_line[input_line_point - 1];   	  if (!alphabetic (c))c 	    {! 	      while (--input_line_point)n 		{l) 		  c = input_line[input_line_point - 1];  		  if (alphabetic (c))l 		    break; 		}i 	    }  - 	  while (input_line_point != input_line_beg)  	    {, 	      c = input_line[input_line_point - 1]; 	      if (!alphabetic (c))t 		break; 	      elsei 		--input_line_point;  	    } 	}     }  }o  I DECLARE_INFO_COMMAND (ea_delete, "Delete the character under the cursor")  {d   register int i;e     if (count < 0)$     ea_rubout (window, -count, key);   else     { -       if (input_line_point == input_line_end)w 	return;  )       if (info_explicit_arg || count > 1)p 	{ 	  int orig_point;  ! 	  orig_point = input_line_point;t# 	  ea_forward (window, count, key);g/ 	  ea_kill_text (orig_point, input_line_point); ! 	  input_line_point = orig_point;w 	}
       else 	{6 	  for (i = input_line_point; i < input_line_end; i++)' 	    input_line[i] = input_line[i + 1];s   	  input_line_end--; 	}     }c }l  J DECLARE_INFO_COMMAND (ea_rubout, "Delete the character behind the cursor") {n   if (count < 0)$     ea_delete (window, -count, key);   else     {n       int start;  -       if (input_line_point == input_line_beg)  	return;         start = input_line_point; '       ea_backward (window, count, key);-  )       if (info_explicit_arg || count > 1)n( 	ea_kill_text (start, input_line_point);
       else  	ea_delete (window, count, key);     }  }*  ; DECLARE_INFO_COMMAND (ea_abort, "Cancel or quit operation")  { I   /* If any text, just discard it, and restore the calling window's node.s      If no text, quit. */d'   if (input_line_end != input_line_beg))     {        terminal_ring_bell ();9       input_line_end = input_line_point = input_line_beg;t6       if (calling_window->node != calling_window_node) 	restore_calling_window ();o     }n   else     info_aborted_echo_area = 1;= }x  N DECLARE_INFO_COMMAND (ea_newline, "Accept (or force completion of) this line") {tG   /* Stub does nothing.  Simply here to see if it has been executed. */_ }e  I DECLARE_INFO_COMMAND (ea_quoted_insert, "Insert next character verbatim")t {a   unsigned char character;  -   character = info_get_another_input_char (); '   ea_insert (window, count, character);A }   9 DECLARE_INFO_COMMAND (ea_insert, "Insert this character")/ {N   register int i;i  +   if ((input_line_end + 1) == EA_MAX_INPUT)      {        terminal_ring_bell ();
       return;p     }   :   for (i = input_line_end + 1; i != input_line_point; i--)&     input_line[i] = input_line[i - 1];  %   input_line[input_line_point] = key;    input_line_point++;o   input_line_end++;e }o  > DECLARE_INFO_COMMAND (ea_tab_insert, "Insert a TAB character") {l"   ea_insert (window, count, '\t'); }u  J /* Transpose the characters at point.  If point is at the end of the line,1    then transpose the characters before point. */eJ DECLARE_INFO_COMMAND (ea_transpose_chars, "Transpose characters at point") {_A   /* Handle conditions that would make it impossible to transpose       characters. */iK   if (!count || !input_line_point || (input_line_end - input_line_beg) < 2)      return;e     while (count)-     {l       int t;-       if (input_line_point == input_line_end)  	{( 	  t = input_line[input_line_point - 1];  G 	  input_line[input_line_point - 1] = input_line[input_line_point - 2];u( 	  input_line[input_line_point - 2] = t; 	}
       else 	{$ 	  t = input_line[input_line_point];  C 	  input_line[input_line_point] = input_line[input_line_point - 1];l( 	  input_line[input_line_point - 1] = t;  7 	  if (count < 0 && input_line_point != input_line_beg)t 	    input_line_point--; 	  else* 	    input_line_point++; 	}         if (count < 0)	 	count++; 
       else	 	count--;o     }  }  rF /* **************************************************************** */ /*								    */. /*		     Echo Area Killing and Yanking		    */ /*								    */F /* **************************************************************** */  ( static char **kill_ring = (char **)NULL;M static int kill_ring_index = 0;	/* Number of kills appearing in KILL_RING. */tM static int kill_ring_slots = 0;	/* Number of slots allocated to KILL_RING. */mE static int kill_ring_loc = 0;	/* Location of current yank pointer. */n  ? /* The largest number of kills that we remember at one time. */v# static int max_retained_kills = 15;c  I DECLARE_INFO_COMMAND (ea_yank, "Yank back the contents of the last kill")  {o   register int i;(   register char *text;     if (!kill_ring_index)o     { 1       inform_in_echo_area ("Kill ring is empty");n
       return;i     }   "   text = kill_ring[kill_ring_loc];     for (i = 0; text[i]; i++)w#     ea_insert (window, 1, text[i]);e }l  F /* If the last command was yank, or yank_pop, and the text just beforeE    point is identical to the current kill item, then delete that textsJ    from the line, rotate the index down, and yank back some other text. */? DECLARE_INFO_COMMAND (ea_yank_pop, "Yank back a previous kill"). {    register int len;a  /   if (((ea_last_executed_command != ea_yank) && 4        (ea_last_executed_command != ea_yank_pop)) ||       (kill_ring_index == 0))      return;-  *   len = strlen (kill_ring[kill_ring_loc]);  2   /* Delete the last yanked item from the line. */   {]     register int i, counter;  0     counter = input_line_end - input_line_point;     =     for (i = input_line_point - len; counter; i++, counter--)t*       input_line[i] = input_line[i + len];       input_line_end -= len;     input_line_point -= len;   }_  +   /* Get a previous kill, and yank that. */    kill_ring_loc--;   if (kill_ring_loc < 0)(     kill_ring_loc = kill_ring_index - 1;     ea_yank (window, count, key);r };  0 /* Delete the text from point to end of line. */B DECLARE_INFO_COMMAND (ea_kill_line, "Kill to the end of the line") {    if (count < 0)     {	6       ea_kill_text (input_line_point, input_line_beg);(       input_line_point = input_line_beg;     }*   else4     ea_kill_text (input_line_point, input_line_end); }v  0 /* Delete the text from point to beg of line. */, DECLARE_INFO_COMMAND (ea_backward_kill_line,, 		      "Kill to the beginning of the line") {(   if (count < 0)4     ea_kill_text (input_line_point, input_line_end);   else     { 6       ea_kill_text (input_line_point, input_line_beg);(       input_line_point = input_line_beg;     }i }w  7 /* Delete from point to the end of the current word. */ I DECLARE_INFO_COMMAND (ea_kill_word, "Kill the word following the cursor")n {_$   int orig_point = input_line_point;     if (count < 0)0     ea_backward_kill_word (window, -count, key);   else     {=+       ea_forward_word (window, count, key);(  )       if (input_line_point != orig_point)"- 	ea_kill_text (orig_point, input_line_point);e  $       input_line_point = orig_point;     }e }c  9 /* Delete from point to the start of the current word. */e, DECLARE_INFO_COMMAND (ea_backward_kill_word,- 		      "Kill the word preceding the cursor")o { $   int orig_point = input_line_point;     if (count < 0)'     ea_kill_word (window, -count, key);i   else     {o,       ea_backward_word (window, count, key);  )       if (input_line_point != orig_point)e- 	ea_kill_text (orig_point, input_line_point);      }o }l  C /* The way to kill something.  This appends or prepends to the last!A    kill, if the last command was a kill command.  If FROM is lesslE    than TO, then the killed text is appended to the most recent kill,tJ    otherwise it is prepended.  If the last command was not a kill command,,    then a new slot is made for this kill. */ static voidt ea_kill_text (from, to)       int from, to; {i$   register int i, counter, distance;   int killing_backwards, slot;   char *killed_text;  "   killing_backwards = (from > to);  @   /* If killing backwards, reverse the values of FROM and TO. */   if (killing_backwards)     {        int temp = from;       from = to;       to = temp;     }l  6   /* Remember the text that we are about to delete. */   distance = to - from;./   killed_text = (char *)xmalloc (1 + distance);=5   strncpy (killed_text, &input_line[from], distance);c   killed_text[distance] = '\0';n  /   /* Actually delete the text from the line. */n    counter = input_line_end - to;  )   for (i = from; counter; i++, counter--)e-     input_line[i] = input_line[i + distance];      input_line_end -= distance;p  I   /* If the last command was a kill, append or prepend the killed text toi'      the last command's killed text. */L&   if (echo_area_last_command_was_kill)     {t       char *old, *new;         slot = kill_ring_loc;(       old = kill_ring[slot];F       new = (char *)xmalloc (1 + strlen (old) + strlen (killed_text));         if (killing_backwards) 	{& 	  /* Prepend TEXT to current kill. */ 	  strcpy (new, killed_text);  	  strcat (new, old);  	}
       else 	{% 	  /* Append TEXT to current kill. */o 	  strcpy (new, old);  	  strcat (new, killed_text);i 	}         free (old);        free (killed_text);t       kill_ring[slot] = new;     }t   else     {tK       /* Try to store the kill in a new slot, unless that would cause thereD% 	 to be too many remembered kills. */n       slot = kill_ring_index;   %       if (slot == max_retained_kills);
 	slot = 0;  %       if (slot + 1 > kill_ring_slots)_ 	kill_ring = (char **) xreallocr 	  (kill_ring,? 	   (kill_ring_slots += max_retained_kills) * sizeof (char *));)  "       if (slot != kill_ring_index) 	free (kill_ring[slot]);
       else 	kill_ring_index++;   $       kill_ring[slot] = killed_text;         kill_ring_loc = slot;A     }a  0   /* Notice that the last command was a kill. */$   echo_area_last_command_was_kill++; }l gF /* **************************************************************** */ /*								    */" /*			Echo Area Completion			    */ /*								    */F /* **************************************************************** */  8 /* Pointer to an array of REFERENCE to complete over. */C static REFERENCE **echo_area_completion_items = (REFERENCE **)NULL;A  I /* Sorted array of REFERENCE * which is the possible completions found inoJ    the variable echo_area_completion_items.  If there is only one element,)    it is the only possible completion. */t: static REFERENCE **completions_found = (REFERENCE **)NULL;' static int completions_found_index = 0;)' static int completions_found_slots = 0;)  ; /* The lowest common denominator found while completing. */e! static REFERENCE *LCD_completion;f  0 /* Internal functions used by the user calls. */A static void build_completions (), completions_must_be_rebuilt ();p  5 /* Variable which holds the output of completions. */i= static NODE *possible_completions_output_node = (NODE *)NULL;k  , static char *compwin_name = "*Completions*";  H /* Return non-zero if WINDOW is a window used for completions output. */
 static int completions_window_p (window)       WINDOW *window; {r   int result = 0;n  ,   if (internal_info_node_p (window->node) &&;       (strcmp (window->node->nodename, compwin_name) == 0))a     result = 1;a     return (result); }t  K /* Workhorse for completion readers.  If FORCE is non-zero, the user cannot 7    exit unless the line read completes, or is empty. */n char *B info_read_completing_internal (window, prompt, completions, force)      WINDOW *window;      char *prompt;      REFERENCE **completions;t      int force;u {i
   char *line;   G   /* If the echo area is already active, remember the current state. */    if (echo_area_is_active)     push_echo_area ();  $   echo_area_must_complete_p = force;  '   /* Initialize our local variables. */ !   initialize_input_line (prompt);   M   /* Initialize the echo area for the first (but maybe not the last) time. */!   echo_area_initialize_node ();n  G   /* Save away the original node of this window, and the window itself, >      so echo area commands can temporarily use this window. */#   remember_calling_window (window);*  5   /* Save away the list of items to complete over. */a+   echo_area_completion_items = completions;/!   completions_must_be_rebuilt ();*      active_window = the_echo_area;   echo_area_is_active++;  )   /* Read characters in the echo area. */x   while (1)e     {l        info_read_and_dispatch ();  %       line = echo_area_after_read ();f  G       /* Force the completion to take place if the user hasn't acceptedo2 	 a default or aborted, and if FORCE is active. */0       if (force && line && *line && completions) 	{ 	  register int i;   	  build_completions ();  A 	  /* If there is only one completion, then make the line be thate 	     completion. */$ 	  if (completions_found_index == 1) 	    { 	      free (line);i7 	      line = savestring (completions_found[0]->label); 
 	      break;k 	    }  F 	  /* If one of the completions matches exactly, then that is okay, so! 	     return the current line. */c0 	  for (i = 0; i < completions_found_index; i++): 	    if (stricmp (completions_found[i]->label, line) == 0) 	      { 		free (line);2 		line = savestring (completions_found[i]->label); 		break; 	      }  , 	  /* If no match, go back and try again. */$ 	  if (i == completions_found_index) 	    {, 	      inform_in_echo_area ("Not complete"); 	      continue; 	    } 	}       break;     }|   echo_area_is_active--;  @   /* Restore the original active window and show point in it. */!   active_window = calling_window;f   restore_calling_window ();*   display_cursor_at_point (active_window);   fflush (stdout);  2   echo_area_completion_items = (REFERENCE **)NULL;!   completions_must_be_rebuilt ();n  C   /* If there is a previous loop waiting for us, restore it now. */n   if (echo_area_is_active)     pop_echo_area ();      return (line); }    D /* Read a line in the echo area with completion over COMPLETIONS. */ char *? info_read_completing_in_echo_area (window, prompt, completions)e      WINDOW *window;      char *prompt;      REFERENCE **completions;l {oJ   return (info_read_completing_internal (window, prompt, completions, 1)); }_  I /* Read a line in the echo area allowing completion over COMPLETIONS, but*    not requiring it. */t char *8 info_read_maybe_completing (window, prompt, completions)      WINDOW *window;      char *prompt;      REFERENCE **completions;  { J   return (info_read_completing_internal (window, prompt, completions, 0)); }t  K DECLARE_INFO_COMMAND (ea_possible_completions, "List possible completions")_ {e"   if (!echo_area_completion_items)     {p%       ea_insert (window, count, key);*
       return;i     }h     build_completions ();*     if (!completions_found_index)o     {l       terminal_ring_bell ();-       inform_in_echo_area ("No completions");      }(:   else if ((completions_found_index == 1) && (key != '?'))     {e.       inform_in_echo_area ("Sole completion");     }    else     {u       register int i, l;&       int limit, count, max_label = 0;  #       initialize_message_buffer ();o       printf_to_message_buffer> 	("There %s %d ", completions_found_index == 1 ? "is" : "are", 	 completions_found_index);w       printf_to_message_buffer> 	("completion%s:\n", completions_found_index == 1 ? "" : "s");  /       /* Find the maximum length of a label. */t3       for (i = 0; i < completions_found_index; i++)d 	{2 	  int len = strlen (completions_found[i]->label); 	  if (len > max_label)i 	    max_label = len;n 	}         max_label += 4;y  9       /* Find out how many columns we should print in. */ 0       limit = calling_window->width / max_label;E       if (limit != 1 && (limit * max_label == calling_window->width))t	 	limit--;l  H       /* Avoid a possible floating exception.  If max_label > width then@ 	 the limit will be 0 and a divide-by-zero fault will result. */       if (limit == 0)  	limit = 1;,  5       /* How many iterations of the printing loop? */l>       count = (completions_found_index + (limit - 1)) / limit;  J       /* Watch out for special case.  If the number of completions is less6 	 than LIMIT, then just do the inner printing loop. */*       if (completions_found_index < limit) 	count = 1;   ?       /* Print the sorted items, up-and-down alphabetically. */t!       for (i = 0; i < count; i++)) 	{ 	  register int j;  % 	  for (j = 0, l = i; j < limit; j++)m 	    {( 	      if (l >= completions_found_index) 		break; 	      elset 		{x 		  char *label; 		  int printed_length, k;  ( 		  label = completions_found[l]->label;$ 		  printed_length = strlen (label);+ 		  printf_to_message_buffer ("%s", label);i   		  if (j + 1 < limit) 		    {d8 		      for (k = 0; k < max_label - printed_length; k++)" 			printf_to_message_buffer (" "); 		    }o 		}_ 	      l += count; 	    }# 	  printf_to_message_buffer ("\n");l 	}  J       /* Make a new node to hold onto possible completions.  Don't destroy 	 dangling pointers. */(       {x 	NODE *temp;  " 	temp = message_buffer_to_node ();% 	add_gcable_pointer (temp->contents); ) 	name_internal_node (temp, compwin_name); ) 	possible_completions_output_node = temp;c       }l  F       /* Find a suitable window for displaying the completions output.@ 	 First choice is an existing window showing completions output.< 	 If there is only one window, and it is large, make anotherB 	 (smaller) window, and use that one.  Otherwise, use the caller's 	 window. */       {  	WINDOW *compwin;i  3 	compwin = get_internal_info_window (compwin_name);    	if (!compwin) 	  {D 	    /* If we can split the window to display most of the completion 	       items, then do so. */_. 	    if (calling_window->height > (count * 2)) 	      { 		int start, end, pagetop;  ! 		active_window = calling_window;g  7 		/* Perhaps we can scroll this window on redisplay. */ $ 		start = calling_window->first_row;$ 		pagetop = calling_window->pagetop;   		compwin =a: 		  window_make_window (possible_completions_output_node);  		active_window = the_echo_area; 		window_change_window_height/0 		  (compwin, -(compwin->height - (count + 2)));  ) 		window_adjust_pagetop (calling_window);*+ 		remember_calling_window (calling_window);t  ! #if defined (SPLIT_BEFORE_ACTIVE)v9 		/* If the pagetop hasn't changed, scrolling the callingF+ 		   window is a reasonable thing to do. */N) 		if (pagetop == calling_window->pagetop)d 		  { + 		    end = start + calling_window->height;  		    display_scroll_display7 		      (start, end, calling_window->prev->height + 1);E 		  }l  #else /* !SPLIT_BEFORE_ACTIVE */= 		/* If the pagetop has changed, set the new pagetop here. */o) 		if (pagetop != calling_window->pagetop)n 		  {n+ 		    int newtop = calling_window->pagetop;R( 		    calling_window->pagetop = pagetop;2 		    set_window_pagetop (calling_window, newtop); 		  }i! #endif /* !SPLIT_BEFORE_ACTIVE */   ) 		echo_area_completions_window = compwin; 4 		remember_window_and_node (compwin, compwin->node); 	      }	 	    elseU  	      compwin = calling_window; 	  }  7 	if (compwin->node != possible_completions_output_node)e 	  { 	    window_set_node_of_window3 	      (compwin, possible_completions_output_node);o7 	    remember_window_and_node (compwin, compwin->node);( 	  }  " 	display_update_display (windows);       }m     }w }n  7 DECLARE_INFO_COMMAND (ea_complete, "Insert completion")  {W"   if (!echo_area_completion_items)     {i%       ea_insert (window, count, key);n
       return;e     }l  K   /* If KEY is SPC, and we are not forcing completion to take place, simplyc      insert the key. */W/   if (!echo_area_must_complete_p && key == SPC)E     {l%       ea_insert (window, count, key);*
       return;I     }c  .   if (ea_last_executed_command == ea_complete)     { F       /* If the keypress is a SPC character, and we have already tried@ 	 completing once, and there are several completions, then check? 	 the batch of completions to see if any continue with a space.e@ 	 If there are some, insert the space character and continue. */4       if (key == SPC && completions_found_index > 1) 	{ 	  register int i, offset;  , 	  offset = input_line_end - input_line_beg;  0 	  for (i = 0; i < completions_found_index; i++)4 	    if (completions_found[i]->label[offset] == ' ')
 	      break;    	  if (completions_found[i])  	    ea_insert (window, 1, ' '); 	  else  	    {4 	      ea_possible_completions (window, count, key); 	      return; 	    } 	}
       else 	{0 	  ea_possible_completions (window, count, key);
 	  return; 	}     }i  $   input_line_point = input_line_end;   build_completions ();o     if (!completions_found_index)p     terminal_ring_bell ();,   else if (LCD_completion->label[0] == '\0')1     ea_possible_completions (window, count, key);n   else     {d       register int i;/9       input_line_point = input_line_end = input_line_beg;a0       for (i = 0; LCD_completion->label[i]; i++)1 	ea_insert (window, 1, LCD_completion->label[i]);l     }a }t  3 /* Utility REFERENCE used to store possible LCD. */ N static REFERENCE LCD_reference = { (char *)NULL, (char *)NULL, (char *)NULL };  , static void remove_completion_duplicates ();  = /* Variables which remember the state of the most recent calln    to build_completions (). */4 static char *last_completion_request = (char *)NULL;> static REFERENCE **last_completion_items = (REFERENCE **)NULL;  A /* How to tell the completion builder to reset internal state. */  static voidf completions_must_be_rebuilt () { '   maybe_free (last_completion_request);;)   last_completion_request = (char *)NULL;R-   last_completion_items = (REFERENCE **)NULL;t }   H /* Build a list of possible completions from echo_area_completion_items,%    and the contents of input_line. */; static voidt build_completions () {p   register int i, len;   register REFERENCE *entry;   char *request;"   int informed_of_lengthy_job = 0;  A   /* If there are no items to complete over, exit immediately. */o"   if (!echo_area_completion_items)     { "       completions_found_index = 0;)       LCD_completion = (REFERENCE *)NULL; 
       return;e     }_  K   /* Check to see if this call to build completions is the same as the lastp"      call to build completions. */(   len = input_line_end - input_line_beg;&   request = (char *)xmalloc (1 + len);6   strncpy (request, &input_line[input_line_beg], len);   request[len] = '\0';  9   if (last_completion_request && last_completion_items &&(<       last_completion_items == echo_area_completion_items &&7       (strcmp (last_completion_request, request) == 0))n     {_       free (request);n
       return;m     }s  '   maybe_free (last_completion_request);i$   last_completion_request = request;5   last_completion_items = echo_area_completion_items;p  2   /* Always start at the beginning of the list. */   completions_found_index = 0;%   LCD_completion = (REFERENCE *)NULL;x  9   for (i = 0; entry = echo_area_completion_items[i]; i++)o     {"5       if (strnicmp (request, entry->label, len) == 0)n6 	add_pointer_to_array (entry, completions_found_index,4 			      completions_found, completions_found_slots, 			      20, REFERENCE *);  D       if (!informed_of_lengthy_job && completions_found_index > 100) 	{ 	  informed_of_lengthy_job = 1;r; 	  window_message_in_echo_area ("Building completions...");e 	}     }e     if (!completions_found_index)t     return;f  D   /* Sort and prune duplicate entries from the completions array. */"   remove_completion_duplicates ();  :   /* If there is only one completion, just return that. */#   if (completions_found_index == 1)o     {d,       LCD_completion = completions_found[0];
       return;n     }   *   /* Find the least common denominator. */   {y     long shortest = 100000;*  1     for (i = 1; i < completions_found_index; i++)        {( 	register int j; 	int c1, c2;   	for (j = 0;A 	     (c1 = info_tolower (completions_found[i - 1]->label[j])) &&p; 	     (c2 = info_tolower (completions_found[i]->label[j])); 
 	     j++) 	  if (c1 != c2) 	    break;    	if (shortest > j) 	  shortest = j;       }n  %     maybe_free (LCD_reference.label); 9     LCD_reference.label = (char *)xmalloc (1 + shortest);;I     strncpy (LCD_reference.label, completions_found[0]->label, shortest);e)     LCD_reference.label[shortest] = '\0';i$     LCD_completion = &LCD_reference;   }_     if (informed_of_lengthy_job)!     echo_area_initialize_node ();n }o   /* Function called by qsort. */i
 static int# compare_references (entry1, entry2) "      REFERENCE **entry1, **entry2; { 8   return (stricmp ((*entry1)->label, (*entry2)->label)); }   5 /* Prune duplicate entries from COMPLETIONS_FOUND. */h static voida remove_completion_duplicates (); {	   register int i, j;   REFERENCE **temp;n
   int newlen;u     if (!completions_found_index)      return;	     /* Sort the items. */ J   qsort (completions_found, completions_found_index, sizeof (REFERENCE *), 	 compare_references);  ?   for (i = 0, newlen = 1; i < completions_found_index - 1; i++)      { .       if (strcmp (completions_found[i]->label,* 		  completions_found[i + 1]->label) == 0)* 	completions_found[i] = (REFERENCE *)NULL;
       else
 	newlen++;     }e  L   /* We have marked all the dead slots.  It is faster to copy the live slots6      twice than to prune the dead slots one by one. */E   temp = (REFERENCE **)xmalloc ((1 + newlen) * sizeof (REFERENCE *));e6   for (i = 0, j = 0; i < completions_found_index; i++)     if (completions_found[i])i'       temp[j++] = completions_found[i];d     for (i = 0; i < newlen; i++)#     completions_found[i] = temp[i];   +   completions_found[i] = (REFERENCE *)NULL;a#   completions_found_index = newlen;    free (temp); }   O /* Scroll the "other" window.  If there is a window showing completions, scrolltN    that one, otherwise scroll the window which was active on entering the read    function. */oT DECLARE_INFO_COMMAND (ea_scroll_completions_window, "Scroll the completions window") {i   WINDOW *compwin;   int old_pagetop;  4   compwin = get_internal_info_window (compwin_name);     if (!compwin)m     compwin = calling_window;s  !   old_pagetop = compwin->pagetop;_  H   /* Let info_scroll_forward () do the work, and print any messages that      need to be displayed. */j,   info_scroll_forward (compwin, count, key); }g  F /* Function which gets called when an Info window is deleted while theM    echo area is active.  WINDOW is the window which has just been deleted. */  void+ echo_area_inform_of_deleted_window (window)p      WINDOW *window; {nJ   /* If this is the calling_window, forget what we remembered about it. */   if (window == calling_window)-     { )       if (active_window != the_echo_area)V) 	remember_calling_window (active_window);t
       else# 	remember_calling_window (windows);g     }-  J   /* If this window was the echo_area_completions_window, then notice that$      the window has been deleted. */-   if (window == echo_area_completions_window) 2     echo_area_completions_window = (WINDOW *)NULL; }o eF /* **************************************************************** */ /*								    */0 /*		   Pushing and Popping the Echo Area		    */ /*								    */F /* **************************************************************** */  ! /* Push and Pop the echo area. */o typedef struct {
   char *line;m   char *prompt;n   REFERENCE **comp_items;)   int point, beg, end;   int must_complete;   NODE node;   WINDOW *compwin; } PUSHED_EA;  : static PUSHED_EA **pushed_echo_areas = (PUSHED_EA **)NULL;' static int pushed_echo_areas_index = 0;n' static int pushed_echo_areas_slots = 0;l  N /* Pushing the echo_area has a side effect of zeroing the completion_items. */ static voidh push_echo_area ()e {_   PUSHED_EA *pushed;  5   pushed = (PUSHED_EA *)xmalloc (sizeof (PUSHED_EA));e)   pushed->line = savestring (input_line);s%   pushed->prompt = input_line_prompt; #   pushed->point = input_line_point;    pushed->beg = input_line_beg;i   pushed->end = input_line_end;a!   pushed->node = input_line_node; 2   pushed->comp_items = echo_area_completion_items;4   pushed->must_complete = echo_area_must_complete_p;1   pushed->compwin = echo_area_completions_window;o  K   add_pointer_to_array (pushed, pushed_echo_areas_index, pushed_echo_areas,_, 			pushed_echo_areas_slots, 4, PUSHED_EA *);  2   echo_area_completion_items = (REFERENCE **)NULL; }u   static voidf pop_echo_area () {b   PUSHED_EA *popped;  8   popped = pushed_echo_areas[--pushed_echo_areas_index];  $   strcpy (input_line, popped->line);   free (popped->line);%   input_line_prompt = popped->prompt; #   input_line_point = popped->point;w   input_line_beg = popped->beg;    input_line_end = popped->end;t!   input_line_node = popped->node;o2   echo_area_completion_items = popped->comp_items;4   echo_area_must_complete_p = popped->must_complete;1   echo_area_completions_window = popped->compwin;e!   completions_must_be_rebuilt ();r  C   /* If the completion window no longer exists, forget about it. */ #   if (echo_area_completions_window)[     {)       register WINDOW *win;c  /       for (win = windows; win; win = win->next)F) 	if (echo_area_completions_window == win)t	 	  break;E  I       /* If the window wasn't found, then it has already been deleted. */        if (!win)_/ 	echo_area_completions_window = (WINDOW *)NULL;      }f     free (popped); }   
 static int echo_area_stack_depth () { #   return (pushed_echo_areas_index);L }   I /* Returns non-zero if any of the prior stacked calls to read in the echoe)    area produced a completions window. */ 
 static int) echo_area_stack_contains_completions_p ()) {    register int i;t  /   for (i = 0; i < pushed_echo_areas_index; i++) &     if (pushed_echo_areas[i]->compwin)       return (1);L  
   return (0);d }l  F /* **************************************************************** */ /*								    */: /*	       Error Messages While Reading in Echo Area	    */ /*								    */F /* **************************************************************** */   #if defined (HAVE_SYS_TIME_H)s #  include <sys/time.h>m #  define HAVE_STRUCT_TIMEVALa #endif /* HAVE_SYS_TIME_H */   static void_ pause_or_input ()  {  #if defined (FD_SET)   struct timeval timer;u   fd_set readfds;*   int ready;     FD_ZERO (&readfds);p$   FD_SET (fileno (stdin), &readfds);   timer.tv_sec = 2;t   timer.tv_usec = 750;G   ready = select (1, &readfds, (fd_set *)NULL, (fd_set *)NULL, &timer);n #endif /* FD_SET */l }[  B /* Print MESSAGE right after the end of the current line, and waitD    for input or 2.75 seconds, whichever comes first.  Then flush the-    informational message that was printed. */l void inform_in_echo_area (message))      char *message;e {e   register int i;u
   char *text;      text = savestring (message);/   for (i = 0; text[i] && text[i] != '\n'; i++);a   text[i] = '\0';      echo_area_initialize_node (); 3   sprintf (&input_line[input_line_end], "%s[%s]\n",o) 	   echo_area_is_active ? " ": "", text);n   free (text);*   the_echo_area->point = input_line_point;,   display_update_one_window (the_echo_area);*   display_cursor_at_point (active_window);   fflush (stdout);   pause_or_input ();   echo_area_initialize_node ();s }u